;+----------------------------------------------------------------------------+
;|  Title:    NWTest        Function: Example of interfacing the Netware API
;|  Source:   MASM32        License:  None - Free source
;|  Platform: Win32         Version:  <n/a>
;|  Author:   R.Daneel      Build:    16
;+----------------------------------------------------------------------------+

;+----------------------------------------------------------------------------+
;|  Assembler Directives:
.486
.model  flat,stdcall
option  casemap:none
;|
;+----------------------------------------------------------------------------+

;+----------------------------------------------------------------------------+
;|  Function Prototypes:
;|
;+----------------------------------------------------------------------------+

;+----------------------------------------------------------------------------+
;|  Includes:
;|      Headers:
include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\masm32.inc
include \masm32\include\comdlg32.inc
include \masm32\include\netwin32.inc
include \masm32\include\calwin32.inc
include \masm32\include\clxwin32.inc
;|
;|      Libraries:
includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\masm32.lib
includelib \masm32\lib\comdlg32.lib
includelib \masm32\lib\netwin32.lib
includelib \masm32\lib\calwin32.lib
includelib \masm32\lib\clxwin32.lib
;|
;+----------------------------------------------------------------------------+

.const
;+----------------------------------------------------------------------------+
;|  Constants:
NWCC_INFO_VERSION       equ         0002h
NW_MAX_TREE_NAME_LEN    equ         36
NW_MAX_SERVER_NAME_LEN  equ         52
;|
;|
;+----------------------------------------------------------------------------+

.data   ;|Data section begins
;+----------------------------------------------------------------------------+
;|  Globals:
;|      Initialized:
MBTitle                 BYTE        "NWTest -- Netware Masm32 Style",0
ConnectionInformation   BYTE        "Primary Netware Connection Info:",0dh,0ah
                        BYTE        "--------------------------------",0dh,0ah
                        BYTE        "    Authentication State:    %lu (0-Attached,1-Bindery,2-NDS)",0dh,0ah
                        BYTE        "    Broadcast State:         %lu (0-All,1-System,2-None,3-Poll)",0dh,0ah
                        BYTE        "    Connection Reference:    %lu",0dh,0ah
                        BYTE        "    Tree Name:               %s",0dh,0ah
                        BYTE        "    Connection Number:       %lu",0dh,0ah
                        BYTE        "    User Object ID:          %lu",0dh,0ah
                        BYTE        "    Server Name:             %s",0dh,0ah
                        BYTE        "    NDS State:               %lu (0-ServerNotNDSCapable,1-ServerNDSCapable)",0dh,0ah
                        BYTE        "    Maximum Packet Size:     %lu",0dh,0ah
                        BYTE        "    License State:           %lu (0-NotLicensed,1-Licensed)",0dh,0ah
                        BYTE        "    Distance:                %lu (Number of hops to server)",0dh,0ah
                        BYTE        "    Server Version:          %lu",0dh,0ah,0
;|
;+----------------------------------------------+

.data?
;+----------------------------------------------+
;|      Uninitialized:
hInstance                   HINSTANCE       ?
CommandLine                 LPSTR           ?
connRef                     DWORD           ?
MBPrimaryConnectionInfo     BYTE   512  dup(?)
;|
;|      Structures:
NWCCVersion     STRUCT
    major                   DWORD           ?
    minor                   DWORD           ?
    revision                DWORD           ?
NWCCVersion     ENDS

NWCCConnInfo    STRUCT
    authenticationState     DWORD           ?       
    broadcastState          DWORD           ?
    connRef                 DWORD           ?
    treeName                BYTE    NW_MAX_TREE_NAME_LEN    dup(?)
    connNum                 DWORD           ?
    userID                  DWORD           ?
    serverName              BYTE    NW_MAX_SERVER_NAME_LEN  dup(?)
    NDSState                DWORD           ?
    maxPacketSize           DWORD           ?
    licenseState            DWORD           ?
    distance                DWORD           ?
    serverVersion           NWCCVersion     <>
NWCCConnInfo   ENDS
;|
returnInfo                  NWCCConnInfo    <>
;+----------------------------------------------------------------------------+

.code   ;|Code section begins
;+----------------------------------------------------------------------------+
;|  Startup:
start:
    invoke  GetModuleHandle, NULL
    mov     hInstance, eax

    invoke  GetCommandLine
    mov     CommandLine, eax

    invoke  NWCallsInit, NULL, NULL
    invoke  NWCCGetPrimConnRef, ADDR connRef
    invoke  NWCCGetAllConnRefInfo, connRef, NWCC_INFO_VERSION, ADDR returnInfo
    .IF eax==0
        invoke  wsprintf, ADDR MBPrimaryConnectionInfo, ADDR ConnectionInformation,\
                returnInfo.authenticationState, returnInfo.broadcastState,\
                returnInfo.connRef, ADDR returnInfo.treeName,\
                returnInfo.connNum, returnInfo.userID,\
                ADDR returnInfo.serverName, returnInfo.NDSState,\
                returnInfo.maxPacketSize, returnInfo.licenseState,\
                returnInfo.distance, returnInfo.serverVersion.major
        invoke  MessageBeep, MB_OK                
        invoke  MessageBox, NULL, ADDR MBPrimaryConnectionInfo, ADDR MBTitle, MB_OK       
    .ENDIF


    invoke  ExitProcess, eax
;|
;+----------------------------------------------------------------------------+
end start       ;| End of code section

;+----------------------------------------------------------------------------+
;|  End
;+----------------------------------------------------------------------------+

