; Outlook style menu example by bAZiK - bazik@x-mail.net
; nothing special -> just some static control plugged together.
; but looks quite nice :-)
; if you use this code, please place my name in you about-box <g>

    .486
    .model flat, stdcall
    option casemap :none

    include \masm32\include\windows.inc
    include \masm32\include\user32.inc
    include \masm32\include\kernel32.inc
    include \masm32\include\gdi32.inc

    includelib \masm32\lib\user32.lib
    includelib \masm32\lib\kernel32.lib
    includelib \masm32\lib\gdi32.lib


    WinMain PROTO :DWORD, :DWORD, :DWORD, :DWORD
    WndProc PROTO :DWORD, :DWORD, :DWORD, :DWORD
    StaticProc PROTO :DWORD, :DWORD, :DWORD, :DWORD
    MouseOver PROTO :DWORD
    MouseOut PROTO :DWORD

    OB_INBOX            equ 2000
    OB_OUTBOX           equ 2001
    OB_SENT             equ 2002
    OB_TRASH            equ 2003
    OB_DRAFTS           equ 2004

    .data
        szAppName       db "Outlook Style Demo by bAZiK - bazik@x-mail.net", 0
        szClassName     db "Test_Class", 0
        szButtonClass   db "BUTTON", 0
        szStaticClass   db "STATIC", 0
        szMailAddy      db "bazik@x-mail.net", 0
        szInbox         db "Eingang", 0
        szOutbox        db "Ausgang", 0
        szSent          db "Gesendet", 0
        szTrash         db "Gelscht", 0
        szDrafts        db "Entwrfe", 0

        wc              WNDCLASSEX <sizeof wc, CS_HREDRAW or \
                                    CS_VREDRAW or CS_BYTEALIGNWINDOW, \
                                    offset WndProc, 0, 0, 400000h, \
                                    0, 0, COLOR_BTNFACE + 1, 0, \
                                    offset szClassName, 0>

    .data?
        msg             MSG <?>
        pt              POINT <?>

        rOutbox         RECT <?>
        rInbox          RECT <?>
        rSent           RECT <?>
        rTrash          RECT <?>
        rDrafts         RECT <?>

        hWnd            dd ?
        hStatic         dd ?
        lpStaticProc    dd ?
        hInbox          dd ?
        hOutbox         dd ?
        hSent           dd ?
        hDrafts         dd ?
        hTrash          dd ?
        hFont           dd ?
        hMailButton     dd ?



    .code

zMail:
    invoke WinMain, 400000h, 0, 0, SW_SHOWDEFAULT
    invoke ExitProcess, eax

WinMain proc hInst :DWORD, hPrevInst :DWORD, CmdLine :DWORD, CmdShow :DWORD

    invoke LoadIcon, hInst, 100
    mov wc.hIcon, eax

    invoke LoadCursor, 0, IDC_ARROW
    mov wc.hCursor, eax

    invoke RegisterClassEx, addr wc

    invoke GetSystemMetrics, SM_CXSCREEN
    mov esi,eax

    invoke GetSystemMetrics, SM_CYSCREEN
    shr esi, 1
    shr eax, 1
    sub eax, 504/2 ; for centering window
    sub esi, 400/2 ; dito

    invoke CreateWindowEx, WS_EX_CONTROLPARENT,
                           addr szClassName,
                           addr szAppName,
                           WS_CAPTION or WS_MINIMIZEBOX or WS_SYSMENU or WS_VISIBLE,
                           esi, eax, 400, 504, 0, 0, hInst, 0
    mov hWnd, eax

    invoke ShowWindow, hWnd, SW_SHOWNORMAL
    invoke UpdateWindow, hWnd

    mov esi, offset msg

 @@:
    invoke GetMessage, esi, 0, 0, 0
    or eax, eax
    je @F
    invoke TranslateMessage, esi
    invoke DispatchMessage, esi
    jmp @B
 @@:

    mov eax, msg.wParam
    ret

WinMain endp

WndProc proc hWin :DWORD,uMsg :DWORD, wParam :DWORD, lParam :DWORD

    .if uMsg == WM_CREATE

        invoke SetTimer, hWin, 11, 10, 0 ; set timer

        invoke CreateWindowEx, WS_EX_CLIENTEDGE, addr szStaticClass, 0,
                               WS_CHILD or WS_VISIBLE, 0, 48, 100, 404, hWin, 0, 400000h, 0 ; create static window
        mov hStatic, eax
        invoke SetWindowLong, hStatic, GWL_WNDPROC, StaticProc ; subclass it
        mov lpStaticProc, eax

        invoke SendMessage, hStatic, WM_CREATE, 0, 0 ; send a create message to it (it doesn't prduce one by itself ?!)

    .elseif uMsg == WM_CTLCOLORSTATIC
        invoke GetStockObject, DKGRAY_BRUSH ; set background of static dark gray
        ret

    .elseif uMsg == WM_TIMER
        invoke GetWindowRect, hOutbox, addr rOutbox ; fill rects
        invoke GetWindowRect, hInbox, addr rInbox
        invoke GetWindowRect, hSent, addr rSent
        invoke GetWindowRect, hDrafts, addr rDrafts
        invoke GetWindowRect, hTrash, addr rTrash


        invoke GetCursorPos, addr pt ; get cursor position

        invoke PtInRect, addr rInbox, pt.x, pt.y ; check if mouse is over control (in rect of control)

        .if (eax) ; yuo, it is
            invoke MouseOver, hInbox ; show the hover style
        .else ; nope, its our
            invoke MouseOut, hInbox ; show the out style
        .endif

        invoke PtInRect, addr rOutbox, pt.x, pt.y

        .if (eax)
            invoke MouseOver, hOutbox
        .else
            invoke MouseOut, hOutbox
        .endif

        invoke PtInRect, addr rSent, pt.x, pt.y

        .if (eax)
            invoke MouseOver, hSent
        .else
            invoke MouseOut, hSent
        .endif

        invoke PtInRect, addr rDrafts, pt.x, pt.y

        .if (eax)
            invoke MouseOver, hDrafts
        .else
            invoke MouseOut, hDrafts
        .endif

        invoke PtInRect, addr rTrash, pt.x, pt.y

        .if (eax)
            invoke MouseOver, hTrash
        .else
            invoke MouseOut, hTrash
        .endif

    .elseif uMsg == WM_COMMAND

    .elseif uMsg == WM_CLOSE

    .elseif uMsg == WM_DESTROY

        invoke PostQuitMessage,NULL
        xor eax, eax
        ret

    .endif

    invoke DefWindowProc, hWin, uMsg, wParam, lParam
    ret

WndProc endp

MouseOver proc hCtl :DWORD
    invoke GetWindowLong, hCtl, GWL_EXSTYLE ; get extended style
    .if (!(eax & WS_EX_CLIENTEDGE)) ; if WS_EX_CLIENTEDGE is not set (this check prevents flickering) ----+
        mov edi, eax                ;                                                                     |
        mov eax, WS_EX_CLIENTEDGE   ;                                                                     |
        or eax, edi                 ;                                                                     |
        invoke SetWindowLong, hCtl, GWL_EXSTYLE, eax ; set it <-------------------------------------------|
        invoke SetWindowPos, hCtl, 0, 0, 0, 0, 0, ; redraw window
                             SWP_NOSIZE or SWP_NOMOVE or \
                             SWP_NOZORDER or SWP_NOACTIVATE or \
                             SWP_FRAMECHANGED
    .endif
    ret
MouseOver endp

MouseOut proc hCtl :DWORD
    invoke GetWindowLong, hCtl, GWL_EXSTYLE ; get extended style
    .if (eax & WS_EX_CLIENTEDGE) ; check if style is set (prevents flickering, too)
        and eax, not WS_EX_CLIENTEDGE ; if yes, then remove it
        invoke SetWindowLong, hCtl, GWL_EXSTYLE, eax ; store it
        invoke SetWindowPos, hCtl, 0, 0, 0, 0, 0, ; redraw window
                             SWP_NOSIZE or SWP_NOMOVE or \
                             SWP_NOZORDER or SWP_NOACTIVATE or \
                             SWP_FRAMECHANGED
    .endif
    ret
MouseOut endp

StaticProc proc hCtl :DWORD, uMsg :DWORD, wParam :DWORD, lParam :DWORD

    .if uMsg == WM_CREATE

        invoke CreateFont, 12, 0, 0, 0, FW_NORMAL, ; create small font for mail address :-)
                           0, 0, 0, DEFAULT_CHARSET,
                           OUT_DEFAULT_PRECIS,
                           CLIP_DEFAULT_PRECIS,
                           DEFAULT_QUALITY,
                           DEFAULT_PITCH, 0
        mov hFont, eax

        invoke CreateWindowEx, 0, addr szButtonClass, addr szMailAddy, ; create the button with the mail address
                               WS_CHILD or WS_VISIBLE or WS_DISABLED, 0, 0, 96, 25, hCtl, 10, 400000h, 0
        mov hMailButton, eax
        invoke SendMessage, eax, WM_SETFONT, hFont, 0 ; set the font

        invoke CreateWindowEx, 0, addr szStaticClass, addr szInbox, ; create static
                               WS_CHILD or WS_VISIBLE or SS_CENTERIMAGE or SS_NOTIFY or SS_BITMAP, 0, 25, 96, 75, hCtl, OB_INBOX, 400000h, 0
        mov hInbox, eax

        invoke LoadBitmap, 400000h, 102 ; load image from rc file
        invoke SendMessage, hInbox, STM_SETIMAGE, IMAGE_BITMAP, eax ; set the image

        invoke CreateWindowEx, 0, addr szStaticClass, addr szOutbox,
                               WS_CHILD or WS_VISIBLE or SS_CENTERIMAGE or SS_NOTIFY or SS_BITMAP, 0, 100, 96, 75, hCtl, OB_OUTBOX, 400000h, 0
        mov hOutbox, eax

        invoke LoadBitmap, 400000h, 103
        invoke SendMessage, hOutbox, STM_SETIMAGE, IMAGE_BITMAP, eax

        invoke CreateWindowEx, 0, addr szStaticClass, addr szSent,
                               WS_CHILD or WS_VISIBLE or SS_CENTERIMAGE or SS_NOTIFY or SS_BITMAP, 0, 175, 96, 75, hCtl, OB_SENT, 400000h, 0
        mov hSent, eax

        invoke LoadBitmap, 400000h, 104
        invoke SendMessage, hSent, STM_SETIMAGE, IMAGE_BITMAP, eax

        invoke CreateWindowEx, 0, addr szStaticClass, addr szDrafts,
                               WS_CHILD or WS_VISIBLE or SS_CENTERIMAGE or SS_NOTIFY or SS_BITMAP, 0, 250, 96, 75, hCtl, OB_DRAFTS, 400000h, 0
        mov hDrafts, eax

        invoke LoadBitmap, 400000h, 106
        invoke SendMessage, hDrafts, STM_SETIMAGE, IMAGE_BITMAP, eax

;######################### WITH IMAGE

;         invoke CreateWindowEx, 0, addr szStaticClass, addr szTrash,
;                                WS_CHILD or WS_VISIBLE or SS_CENTERIMAGE or SS_NOTIFY or SS_BITMAP, 0, 325, 96, 75, hCtl, OB_TRASH, 400000h, 0
;         mov hTrash, eax

;         invoke LoadBitmap, 400000h, 105
;         invoke SendMessage, hTrash, STM_SETIMAGE, IMAGE_BITMAP, eax
;######################### UNCOMMENT IF NEEDED

;######################### WITHOUT IMAGE

        invoke CreateWindowEx, 0, addr szStaticClass, addr szTrash,
                               WS_CHILD or WS_VISIBLE or SS_CENTER or SS_NOTIFY, 0, 325, 96, 75, hCtl, OB_TRASH, 400000h, 0
        mov hTrash, eax



    .elseif uMsg == WM_COMMAND
        mov eax, wParam
        shr eax, 16 ; get loword of wParam

        .if eax == STN_CLICKED ; if loword is STN_CLICKED

            .if wParam == OB_INBOX ; check highword or button ID
                invoke MessageBox, 0, addr szInbox, addr szAppName, 0

            .elseif wParam == OB_OUTBOX
                invoke MessageBox, 0, addr szOutbox, addr szAppName, 0

            .elseif wParam == OB_SENT
                invoke MessageBox, 0, addr szSent, addr szAppName, 0

            .elseif wParam == OB_DRAFTS
                invoke MessageBox, 0, addr szDrafts, addr szAppName, 0

            .elseif wParam == OB_TRASH
                invoke MessageBox, 0, addr szTrash, addr szAppName, 0

            .endif

        .endif

    .elseif uMsg == WM_CTLCOLORSTATIC
        invoke SetTextColor, wParam, 0FFFFFFh
        invoke SetBkColor, wParam, 404040h
        invoke GetStockObject, DKGRAY_BRUSH ; only needed if you have no images in at least on button
        ret

    .endif

    invoke CallWindowProc,lpStaticProc,hCtl,uMsg,wParam,lParam

    ret

StaticProc endp

end zMail
