.386
.model flat,stdcall

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc
include \masm32\include\comdlg32.inc
include \masm32\include\advapi32.inc
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\comdlg32.lib
includelib \masm32\lib\advapi32.lib

CreateColumns proto
ProcessCmndLine proto
SetInitValues proto
CrcFromFile proto
CreateCrcTable proto
ProcessError proto
ChangeButtons proto :DWORD
WriteFileSummary proto
ConvertTime proto
AssociateSFV proto
SetCurrentDir proto :DWORD

.const
IDD_MAINDLG                     equ 101
IDR_MAINMENU                    equ 103
IDI_ICON                        equ 104
IDC_FILELIST                    equ 1008
IDC_FILEPATH                    equ 1009
IDC_FILE                        equ 1010
IDC_PROGRESS                    equ 1011
IDC_SUMMARY                     equ 1012
IDC_CHECK                       equ 1013
IDC_MAKE                        equ 1014
IDC_STATUS                      equ 1015
IDM_CHECK                       equ 40002
IDM_MAKE                        equ 40003
IDM_EXIT                        equ 40004
IDM_ABOUT                       equ 40005
IDM_ADDFILES                    equ 40006
IDM_OPEN                        equ 40007
IDM_CLEAR                       equ 40008
IDM_ASSOCIATE                   equ 40009
SFV_ENABLEBUTTON		equ WM_USER+105
FILEREADSIZE			equ 10240
CRC32POLY			equ 0EDB88320h

.data
ClassName	db 'DLGCLASS',0
errorMsg	db 'ERROR!',0
errorBuffer	db 50 dup(0)
strIdle		db 'Idle',0
strListing	db 'Listing Files...',0
strBuildingCrc	db 'Building CRC Table...',0
widthParts	dd 280,315,-1
col1Header	db 'File',0
col2Header	db 'Listed CRC',0
col3Header	db 'Actual CRC',0
col4Header	db 'Status',0
lv_column	LV_COLUMN <NULL>
msgNA		db ' ',0
msgGood		db 'good',0
msgBad		db 'bad!',0
msgDone		db 'done',0
msgLost		db 'lost',0
checkCap	db 'Check',0
abortCap	db 'Abort',0
lv_item		LV_ITEM <NULL>
sfvFileName	db 256 dup(0)
fileNameBuffer	db 256 dup(0)
checkBuffer	db 300 dup(0)
lineBuffer	db 360 dup(0)
progBuffer	db 5 dup(0)
crcBuffer	db 9 dup(0)
crcCharBuffer	db 9 dup(0)
printTemplate	db '%08lX',0
lineTemplate	db '%s %08lX',13,10,0
checkTemplate	db 'Checking file %s...',0
makeTemplate	db 'Calculating file %s...',0
progTemplate	db '%3u%%',0
sizeTemplate	db ';%13lu  %10s %9s %s',13,10,0
ofn		OPENFILENAME <0>
Filter		db 'SFV Files (*.sfv)',0,'*.sfv',0,'All Files (*.*)',0,'*.*',0,0
defExt		db '*.sfv',0
capError	db 'Error',0
formatError	db 'Invalid SFV Format!',0
headerTemplate	db ';32-bit CRC calculated by radSFV v1.0 on %s at %s',13,10
		db ';Get radSFV at http://deucerad.cjb.net',13,10,';',13,10,0
sfvHeader	db 115 dup(0)
totFileSize	dd 0
curFileSize	dd 0
fileSize	dd 0
readSize	dd 0
allFileSize	dd 0
numFiles	dd 0
fileSel		dd 0
allFlag		dd TRUE
fileErrFlag	dd FALSE
checkFlag	dd FALSE
ptrDestData	dd 0
c100		dd 100
progRess	dd 0
barSize		dd 0
ftime		FILETIME <0>
stime		SYSTEMTIME <0>
sfvTime		db 20 dup(0)
sfvDate		db 20 dup(0)
timeFormat	db 'hh',39,':',39,'mm',39,':',39,'ss',0
errFileLost	db 'Could not find at least 1 of the files...',10,10
		db 'Make sure you saved the sfv in the same',10
		db 'directory that contains your files.',0
strAbout	db 'radSFV v1.0',10,'Calculates 32-bit checksums.',10,10
		db 'Jan 23, 2001',10,'Author: Deuce',10
		db 'smileykid71@hotmail.com',10,'http://deucerad.cjb.net'
		db 10,10,'Please email bugs/suggestions.',0
capAbout	db 'About',0
summaryTemplate	db '%3i file(s) Good',10,'%3i file(s) Bad',10,'%3i file(s) Lost',0
timeTemplate	db '%2li:%02i.%i',0
regTemplate	db '%s ',34,'%%1',34,0
iconTemplate	db '%s,0',0
capSummary	db 'Summary',0
filesGood	dd 0
filesBad	dd 0
filesLost	dd 0
tickStart	dd 0
tickCurrent	dd 0
timeTenths	dd 0
timeMinutes	dd 0
timeSeconds	dd 0
sKeyName	db 'radSFV',0
sKeyValue	db 'SFV File',0
sKeySub		db 'radSFV\shell\open\command',0
sKeyIconSub	db 'radSFV\DefaultIcon',0
sKeyExt		db '.sfv',0
hKey		dd 0
keyDisp		dd 0
keyClass	db 0

.data?
wc		WNDCLASSEX <?>
Msg		MSG <?>
IdListThread	dd ?
ptrCmndLine	dd ?
ptrFileData	dd ?
ptrFileBuffer	dd ?
ptrCrcTable	dd ?
ptrMultSel	dd ?
hInstance	HINSTANCE ?
hWindow		HWND ?
hStatus		dd ?
hFileList	dd ?
hFilePath	dd ?
hFile		dd ?
hCheck		dd ?
hMake		dd ?
hFileButton	dd ?
hCrcFile	dd ?
hProgress	dd ?
hMenu		dd ?
hNewFile	dd ?
hSummary	dd ?
hFileInfo	dd ?

.code
start:
	invoke	GetModuleHandle,NULL
	mov	hInstance,eax
	invoke	GetCommandLine
	mov	ptrCmndLine,eax

	mov	wc.cbSize,sizeof WNDCLASSEX
	mov	wc.style,CS_HREDRAW OR CS_VREDRAW
	mov	wc.cbWndExtra,DLGWINDOWEXTRA
	mov	wc.lpfnWndProc,offset WndProc
	push	hInstance
	pop	wc.hInstance
	invoke	LoadIcon,hInstance,IDI_ICON
	mov	wc.hIcon,eax
	mov	wc.hIconSm,0
	invoke	LoadCursor,NULL,IDC_ARROW
	mov	wc.hCursor,eax
	mov	wc.hbrBackground,COLOR_BTNFACE +1
	mov	wc.lpszMenuName,IDR_MAINMENU
	mov	wc.lpszClassName,offset ClassName
	mov	wc.cbClsExtra,0
	invoke	RegisterClassEx,offset wc

	invoke	InitCommonControls
	invoke	CreateDialogParam,hInstance,IDD_MAINDLG,NULL,NULL,NULL
	mov	hWindow,eax

	invoke	ShowWindow,hWindow,SW_SHOWNORMAL
	invoke	UpdateWindow,hWindow

	invoke	SetInitValues

  msgLoop:
	invoke	GetMessage,offset Msg,NULL,0,0
	cmp	eax,NULL
	je	nowExit

	invoke	IsDialogMessage,hWindow,offset Msg
	cmp	eax,NULL
	jne	nowReturn00

	invoke	TranslateMessage,offset Msg
	invoke	DispatchMessage,offset Msg

  nowReturn00:
	jmp	msgLoop

  nowExit:
	invoke	ExitProcess,NULL
ListThread proc uses eax
	invoke	SendMessage,hFileList,LVM_DELETEALLITEMS,NULL,NULL
	invoke	SendMessage,hFileList,LVM_SETTEXTCOLOR,0,0FF0000h

	invoke	SendMessage,hStatus,SB_SETTEXT,0,offset strListing

	invoke	GetFileSize,hFile,NULL
	mov	fileSize,eax
	invoke	GlobalAlloc,GMEM_FIXED OR GMEM_ZEROINIT,eax
	mov	ptrFileData,eax
	invoke	ReadFile,hFile,ptrFileData,fileSize,offset readSize,NULL
	invoke	CloseHandle,hFile

	mov	totFileSize,0
	mov	ecx,readSize
	mov	esi,ptrFileData
	xor	ebx,ebx
	mov	lv_item.imask,LVIF_TEXT
	jmp	inputLoop

  nowSkip02:
	mov	numFiles,ebx
	invoke	SendMessage,hWindow,SFV_ENABLEBUTTON,hCheck,TRUE
	invoke	SendMessage,hWindow,SFV_ENABLEBUTTON,hMake,TRUE
	invoke	EnableMenuItem,hMenu,IDM_CHECK,MF_BYCOMMAND OR MF_ENABLED
	invoke	EnableMenuItem,hMenu,IDM_MAKE,MF_BYCOMMAND OR MF_ENABLED
  nowReturn03:
	invoke	SendMessage,hStatus,SB_SETTEXT,0,offset strIdle
	invoke	GlobalFree,ptrFileData
  nowReturn02:
	ret

  inputLoop:
	jecxz	nowSkip02
	mov	ah,byte ptr [esi]
	cmp	ah,';'
	je	findLineEnd
	cmp	ah,9  ;tab
	je	nextByte
	cmp	ah,32 ;space
	je	nextByte
	cmp	ah,13 ;carriage return
	je	nextByte
	cmp	ah,10 ;lf
	je	nextByte
	mov	edx,256
	mov	edi,offset fileNameBuffer
  fileName:
	mov	byte ptr [edi],ah
	dec	ecx
	jz	sfvInvalid
	dec	edx
	jz	sfvInvalid
	inc	esi
	inc	edi
	mov	ah,byte ptr [esi]
	cmp	ah,' '
	jne	fileName

	mov	byte ptr [edi],0
  crc:
	dec	ecx
	jz	sfvInvalid
	mov	edi,offset crcBuffer
	inc	esi
	push	ecx
	mov	ecx,8
	rep movsb
	cmp	ecx,0
	pop	ecx
	jg	sfvInvalid
	sub	ecx,8
	mov	byte ptr [edi],0

	push	ecx
	push	esi
	push	ebx
	mov lv_item.imask,LVIF_TEXT
	mov	lv_item.iItem,ebx
	mov	lv_item.iSubItem,0
	mov	lv_item.pszText,offset fileNameBuffer
	invoke	SendMessage,hFileList,LVM_INSERTITEM,NULL,offset lv_item
	mov	lv_item.iSubItem,1
	mov	lv_item.pszText,offset crcBuffer
	invoke	SendMessage,hFileList,LVM_SETITEM,NULL,offset lv_item
	invoke	CreateFile,offset fileNameBuffer,GENERIC_READ,FILE_SHARE_READ,NULL,\
		OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
	cmp	eax,INVALID_HANDLE_VALUE
	je	fileMissing
	push	eax
	invoke	GetFileSize,eax,NULL
	add	totFileSize,eax
	pop	eax
	invoke	CloseHandle,eax
  fileMissing:
	pop	ebx
	pop	esi
	pop	ecx
	inc	ebx

  findLineEnd:
	mov	edi,esi
	mov	al,10 ;lf
	repne scasb
	mov	esi,edi
	jmp	inputLoop
  nextByte:
	dec	ecx
	inc	esi
	jmp	inputLoop
  sfvInvalid:
	invoke	SendMessage,hFileList,LVM_DELETEALLITEMS,NULL,NULL
	invoke	MessageBox,NULL,offset formatError,offset capError,MB_OK
	jmp	nowReturn03
ListThread endp
CheckThread proc
	mov	timeSeconds,0
	mov	timeMinutes,0
	mov	timeTenths,0
	invoke	SetTimer,hWindow,WM_USER+11,100,NULL
	invoke	ChangeButtons,FALSE
	invoke	SendMessage,hFileList,LVM_REDRAWITEMS,0,numFiles
	invoke	SendMessage,hProgress,PBM_SETPOS,0,NULL
	invoke	SendMessage,hStatus,SB_SETTEXT,0,offset strBuildingCrc
	invoke	CreateCrcTable
	invoke	SendMessage,hFileList,LVM_SETTEXTCOLOR,0,0FF0000h
	mov	filesGood,0
	mov	filesBad,0
	mov	filesLost,0

	invoke	SetCurrentDir,offset sfvFileName

	mov	allFileSize,0
	xor	edx,edx
	mov	ecx,fileSel
	mov	lv_item.stateMask,LVIS_SELECTED
  checkStart:
	mov	fileErrFlag,FALSE
	mov	lv_item.imask,LVIF_TEXT OR LVIF_STATE
	mov	lv_item.iSubItem,0
	mov	lv_item.pszText,offset fileNameBuffer
	mov	lv_item.cchTextMax,256
	mov	lv_item.iItem,edx
	push	edx
	push	ecx
	invoke	SendMessage,hFileList,LVM_GETITEM,NULL,offset lv_item

	pop	ecx
	pop	edx
	cmp	allFlag,TRUE
	je	getCRC
	cmp	lv_item.state,LVIS_SELECTED
	jne	skipCheck
  getCRC:
	mov	lv_item.iSubItem,1
	mov	lv_item.pszText,offset crcBuffer
	mov	lv_item.cchTextMax,9
	push	edx
	push	ecx
	invoke	wsprintf,offset checkBuffer,offset checkTemplate,offset fileNameBuffer
	invoke	SendMessage,hStatus,SB_SETTEXT,0,offset checkBuffer
	invoke	SendMessage,hFileList,LVM_GETITEM,NULL,offset lv_item
	pop	ecx
	pop	edx
	cmp	eax,NULL
	je	checkDone

	invoke	CrcFromFile
	cmp	checkFlag,FALSE
	je	checkDone

	push	ecx
	push	edx
	invoke	wsprintf,offset crcCharBuffer,offset printTemplate,eax

	mov	lv_item.pszText,offset crcCharBuffer
	mov	lv_item.imask,LVIF_TEXT
	mov	lv_item.iSubItem,2
	invoke	SendMessage,hFileList,LVM_SETITEM,NULL,offset lv_item

	cmp	fileErrFlag,TRUE
	jne	skipLost
	mov	lv_item.pszText,offset msgLost
	invoke	SendMessage,hFileList,LVM_SETTEXTCOLOR,0,00000FFh
	invoke	SendMessage,hFileList,LVM_REDRAWITEMS,0,numFiles
	inc	filesLost
	jmp	crcCont
  skipLost:
	mov	edx,offset crcCharBuffer
	mov	eax,dword ptr [edx]
	mov	edx,offset crcBuffer
	cmp	eax,dword ptr [edx]
	jne	skipGood
	mov	lv_item.pszText,offset msgGood
	inc	filesGood
	jmp	crcCont
  skipGood:
	mov	lv_item.pszText,offset msgBad
	invoke	SendMessage,hFileList,LVM_SETTEXTCOLOR,0,00000FFh
	invoke	SendMessage,hFileList,LVM_REDRAWITEMS,0,numFiles
	inc	filesBad
  crcCont:
	mov	lv_item.iSubItem,3
	invoke	SendMessage,hFileList,LVM_SETITEM,NULL,offset lv_item
	pop	edx
	push	edx
	invoke	SendMessage,hFileList,LVM_ENSUREVISIBLE,edx,FALSE

	pop	edx
	pop	ecx

	dec	ecx
	jz	checkDone
  skipCheck:
	inc	edx
	jmp	checkStart
	
  checkDone:
	mov	checkFlag,FALSE
	invoke	SendMessage,hSummary,BM_GETCHECK,NULL,NULL
	cmp	eax,BST_CHECKED
	jne	skipSummaryCheck
	invoke	wsprintf,offset lineBuffer,offset summaryTemplate,filesGood,filesBad,\
		filesLost
	invoke	MessageBox,hWindow,offset lineBuffer,offset capSummary, \
		MB_ICONINFORMATION OR MB_OK
  skipSummaryCheck:
	invoke	ChangeButtons,TRUE
	invoke	SendMessage,hStatus,SB_SETTEXT,0,offset strIdle
	invoke	GlobalFree,ptrCrcTable
	ret
CheckThread endp
MakeThread proc
	invoke	ChangeButtons,FALSE
	invoke	CreateFile,offset sfvFileName,GENERIC_WRITE,FILE_SHARE_READ,\
		NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL OR \
		FILE_FLAG_SEQUENTIAL_SCAN,NULL
	cmp	eax,INVALID_HANDLE_VALUE
	je	nowReturn04
	mov	hNewFile,eax
	invoke	SendMessage,hProgress,PBM_SETPOS,0,NULL
	invoke	SendMessage,hStatus,SB_SETTEXT,0,offset strBuildingCrc
	invoke	CreateCrcTable
	invoke	GetLocalTime,offset stime
	invoke	ConvertTime
	invoke	wsprintf,offset sfvHeader,offset headerTemplate,offset sfvDate,\
		offset sfvTime
	invoke	lstrlen,offset sfvHeader
	invoke	WriteFile,hNewFile,offset sfvHeader,eax,offset readSize,NULL

	invoke	SendMessage,hSummary,BM_GETCHECK,NULL,NULL
	cmp	eax,BST_CHECKED
	jne	skipSummaryMake
	invoke	WriteFileSummary
  skipSummaryMake:
	mov	timeSeconds,0
	mov	timeMinutes,0
	mov	timeTenths,0
	invoke	SetTimer,hWindow,WM_USER+11,100,NULL
	mov	lv_item.imask,LVIF_TEXT
	mov	ecx,numFiles
	xor	ebx,ebx
	mov	fileErrFlag,FALSE
	jmp	lineStart
  makeAborted:
	pop	ebx
	pop	ecx
  nowReturn04:
	invoke	CloseHandle,hNewFile
	invoke	GlobalFree,ptrCrcTable
	invoke	ChangeButtons,TRUE
	invoke	SendMessage,hStatus,SB_SETTEXT,0,offset strIdle
	mov	checkFlag,FALSE
	cmp	fileErrFlag,TRUE
	jne	skipErrorMsg
	invoke	MessageBox,NULL,offset errFileLost,offset capError,MB_OK OR \
		MB_ICONWARNING
  skipErrorMsg:
	ret

  lineStart:
	jecxz	nowReturn04
	mov	lv_item.iItem,ebx
	mov	lv_item.iSubItem,0
	mov	lv_item.pszText,offset fileNameBuffer
	mov	lv_item.cchTextMax,256
	push	ecx
	push	ebx
	invoke	SendMessage,hFileList,LVM_GETITEM,NULL,offset lv_item
	invoke	wsprintf,offset checkBuffer,offset makeTemplate,offset fileNameBuffer
	invoke	SendMessage,hStatus,SB_SETTEXT,0,offset checkBuffer
	invoke	CrcFromFile
	cmp	checkFlag,FALSE
	je	makeAborted
	push	eax
	invoke	wsprintf,offset crcCharBuffer,offset printTemplate,eax
	pop	eax
	invoke	wsprintf,offset lineBuffer,offset lineTemplate,\ 
		offset fileNameBuffer,eax
	invoke	WriteFile,hNewFile,offset lineBuffer,eax,offset readSize,NULL
	mov	lv_item.iSubItem,1
	mov	lv_item.pszText,offset msgNA
	invoke	SendMessage,hFileList,LVM_SETITEM,NULL,offset lv_item
	mov	lv_item.iSubItem,2
	mov	lv_item.pszText,offset crcCharBuffer
	invoke	SendMessage,hFileList,LVM_SETITEM,NULL,offset lv_item
	mov	lv_item.iSubItem,3
	mov	lv_item.pszText,offset msgDone
	invoke	SendMessage,hFileList,LVM_SETITEM,NULL,offset lv_item
	invoke	SendMessage,hFileList,LVM_ENSUREVISIBLE,lv_item.iItem,FALSE
	pop	ebx
	pop	ecx
	inc	ebx
	dec	ecx
	jmp	lineStart
MakeThread endp
ListSelectedFiles proc ptrNames:DWORD
	invoke	SendMessage,hFileList,LVM_DELETEALLITEMS,NULL,NULL
	invoke	SendMessage,hFileList,LVM_SETTEXTCOLOR,0,0FF0000h
	invoke	SetCurrentDirectory,ptrMultSel
	mov	esi,ptrNames
	xor	ebx,ebx
	mov	lv_item.imask,LVIF_TEXT
	mov	lv_item.iSubItem,0
	mov	allFileSize,0
	mov	totFileSize,0
  multStart:
	invoke	lstrlen,esi
	cmp	eax,0
	je	selectDone
	mov	lv_item.iItem,ebx
	mov	lv_item.pszText,esi
	push	eax
	push	esi
	push	ebx
	invoke	CreateFile,esi,GENERIC_READ,FILE_SHARE_READ,\
		NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
	push	eax
	invoke	GetFileSize,eax,NULL
	add	totFileSize,eax
	pop	eax
	invoke	CloseHandle,eax
	invoke	SendMessage,hFileList,LVM_INSERTITEM,NULL,offset lv_item
	pop	ebx
	pop	esi
	pop	eax
	add	esi,eax
	inc	esi
	inc	ebx
	jmp	multStart
  selectDone:
	dec	ebx
	mov	numFiles,ebx
	invoke	SendMessage,hWindow,SFV_ENABLEBUTTON,hMake,TRUE
	invoke	EnableMenuItem,hMenu,IDM_MAKE,MF_BYCOMMAND OR MF_ENABLED
	invoke	GlobalFree,ptrMultSel
	ret
ListSelectedFiles endp
WndProc proc hWnd:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
	cmp	uMsg,WM_CREATE
	je	firstTime

	cmp	uMsg,WM_DESTROY
	je	winDestroyed

	cmp	uMsg,WM_COMMAND
	je	winCommand

	cmp	uMsg,SFV_ENABLEBUTTON
	je	enableButton

	cmp	uMsg,WM_TIMER
	je	wm_timer

  defProcessing:
	invoke	DefWindowProc,hWnd,uMsg,wParam,lParam
	ret

  firstTime:
	invoke	CreateStatusWindow,WS_CHILD OR WS_VISIBLE,offset strIdle,\
		hWnd,IDC_STATUS
	mov	hStatus,eax
	invoke	SendMessage,eax,SB_SETPARTS,3,offset widthParts
	cmp	eax,NULL
	jne	nowSkip01
	invoke	ProcessError
  nowSkip01:
	jmp	nowReturn01

  winDestroyed:
	invoke	PostQuitMessage,NULL
	jmp	nowReturn01

  winCommand:
	mov	eax,wParam
	mov	edx,eax
	cmp	lParam,NULL
	je	cmndMenu

	shr	edx,16
	cmp	dx,EN_UPDATE
	je	pathChanged

	cmp	dx,BN_CLICKED
	jne	nowReturn00

	cmp	ax,IDC_FILE
	je	cmndFile

	cmp	ax,IDC_CHECK
	je	cmndCheck

	cmp	ax,IDC_MAKE
	je	cmndMake

	jmp	nowReturn01

  cmndFile:
	invoke	SendMessage,hWnd,WM_COMMAND,IDM_OPEN,NULL
	jmp	nowReturn01

  cmndCheck:
	invoke	SendMessage,hWnd,WM_COMMAND,IDM_CHECK,NULL
	jmp	nowReturn01

  cmndMake:
	invoke	SendMessage,hWnd,WM_COMMAND,IDM_MAKE,NULL

  cmndMenu:
	cmp	ax,IDM_EXIT
	je	menuExit

	cmp	ax,IDM_OPEN
	je	menuOpen

	cmp	ax,IDM_CHECK
	je	menuCheck

	cmp	ax,IDM_CLEAR
	je	menuClear

	cmp	ax,IDM_MAKE
	je	menuMake

	cmp	ax,IDM_ADDFILES
	je	menuAddFiles

	cmp	ax,IDM_ABOUT
	je	menuAbout

	cmp	ax,IDM_ASSOCIATE
	je	associateSfv

	jmp	nowReturn01

  menuExit:
	invoke	DestroyWindow,hWnd
	jmp	nowReturn01

  menuOpen:
	mov	ofn.lStructSize,sizeof ofn
	push	hWnd
	pop	ofn.hWndOwner
	push	hInstance
	pop	ofn.hInstance
	mov	ofn.lpstrFilter,offset Filter
	mov	ofn.lpstrFile,offset sfvFileName
	mov	ofn.nMaxFile,256
	mov	ofn.Flags,OFN_EXPLORER OR OFN_FILEMUSTEXIST\
		OR OFN_PATHMUSTEXIST OR OFN_HIDEREADONLY
	invoke	GetOpenFileName,offset ofn
	cmp	eax,NULL
	je	nowReturn01
	invoke	SetDlgItemText,hWnd,IDC_FILEPATH,offset sfvFileName
	jmp	nowReturn01

  menuCheck:
	cmp	checkFlag,TRUE
	je	abortCheck	
	mov	checkFlag,TRUE

	invoke	SendMessage,hFileList,LVM_GETSELECTEDCOUNT,NULL,NULL
	cmp	eax,0
	jne	getSelection
	push	numFiles
	pop	fileSel
	mov	allFlag,TRUE
  selCont:
	invoke	CreateThread,NULL,0,offset CheckThread,NULL,NULL,offset IdListThread
	jmp	nowReturn01
  getSelection:
	mov	fileSel,eax
	mov	allFlag,FALSE
	jmp	selCont
  abortCheck:
	mov	checkFlag,FALSE
	jmp	nowReturn01

  menuClear:
	invoke	SendMessage,hFileList,LVM_DELETEALLITEMS,NULL,NULL
	invoke	SendMessage,hWindow,SFV_ENABLEBUTTON,hCheck,FALSE
	invoke	SendMessage,hWindow,SFV_ENABLEBUTTON,hMake,FALSE
	invoke	EnableMenuItem,hMenu,IDM_CHECK,MF_BYCOMMAND OR MF_GRAYED
	invoke	EnableMenuItem,hMenu,IDM_MAKE,MF_BYCOMMAND OR MF_GRAYED
	invoke	SetDlgItemText,hWnd,IDC_FILEPATH,offset msgNA
	jmp	nowReturn01

  pathChanged:
	cmp	ax,IDC_FILEPATH
	jne	defProcessing

	invoke	GetDlgItemText,hWindow,IDC_FILEPATH,offset sfvFileName,255
	invoke	CreateFile,offset sfvFileName,GENERIC_READ,FILE_SHARE_READ,\
		NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL OR \
		FILE_FLAG_SEQUENTIAL_SCAN,NULL
	cmp	eax,INVALID_HANDLE_VALUE
	je	nowReturn01

	mov	hFile,eax
	invoke	CreateThread,NULL,0,offset ListThread,NULL,NULL,offset IdListThread
	jmp	nowReturn01

  enableButton:
	invoke	EnableWindow,wParam,lParam
	jmp	nowReturn01

  menuMake:
	cmp	checkFlag,TRUE
	je	abortMake	
	mov	checkFlag,TRUE

	invoke	SendMessage,hFileList,LVM_GETITEMCOUNT,NULL,NULL
	mov	numFiles,eax

	mov	ofn.lStructSize,sizeof ofn
	push	hWnd
	pop	ofn.hWndOwner
	push	hInstance
	pop	ofn.hInstance
	mov	ofn.lpstrFilter,offset Filter
	mov	ofn.lpstrFile,offset sfvFileName
	mov	ofn.nMaxFile,256
	mov	ofn.Flags,OFN_EXPLORER OR OFN_HIDEREADONLY OR OFN_OVERWRITEPROMPT
	mov	ofn.lpstrDefExt,offset defExt
	invoke	GetSaveFileName,offset ofn
	cmp	eax,NULL
	je	nowReturn01
	invoke	CreateThread,NULL,0,offset MakeThread,NULL,NULL,offset IdListThread
	jmp	nowReturn01
  abortMake:
	mov	checkFlag,FALSE
	jmp	nowReturn01

  menuAddFiles:
	mov	ofn.lStructSize,sizeof ofn
	push	hWnd
	pop	ofn.hWndOwner
	push	hInstance
	pop	ofn.hInstance
	mov	ofn.lpstrFilter,NULL
	invoke	GlobalAlloc,GPTR,100*256 ;?!?!?!?!
	mov	ptrMultSel,eax
	mov	ofn.lpstrFile,eax
	mov	ofn.nMaxFile,100*256
	mov	ofn.Flags,OFN_EXPLORER OR OFN_FILEMUSTEXIST \
		OR OFN_PATHMUSTEXIST OR OFN_HIDEREADONLY OR OFN_ALLOWMULTISELECT
	invoke	GetOpenFileName,offset ofn
	mov	eax,ptrMultSel
	add	ax,ofn.nFileOffset
	invoke	CreateThread,NULL,0,offset ListSelectedFiles,eax,NULL,\
		offset IdListThread
	jmp	nowReturn01

  menuAbout:
	invoke	MessageBox,hWnd,offset strAbout,offset capAbout,MB_OK OR \
		MB_ICONINFORMATION OR MB_APPLMODAL
	jmp	nowReturn01

  wm_timer:
	cmp	wParam,WM_USER+11
	jne	nowReturn01
	inc	timeTenths
	cmp	timeTenths,10
	jne	timeWrite
	mov	timeTenths,0
	inc	timeSeconds
	cmp	timeSeconds,60
	jne	timeWrite
	mov	timeSeconds,0
	inc	timeMinutes
  timeWrite:
	invoke	wsprintf,offset sfvTime,offset timeTemplate,timeMinutes,timeSeconds,\
		timeTenths
	invoke	SendMessage,hStatus,SB_SETTEXT,2,offset sfvTime
	invoke	wsprintf,offset progBuffer,offset progTemplate,progRess
	invoke	SendMessage,hStatus,SB_SETTEXT,1,offset progBuffer
	invoke	SendMessage,hProgress,PBM_SETPOS,barSize,NULL
  timeDone:
	cmp	checkFlag,FALSE
	jne	nowReturn01
	invoke	KillTimer,hWnd,WM_USER+11
	jmp	nowReturn01

  associateSfv:
	invoke	AssociateSFV

  nowReturn01:
	xor	eax,eax
	ret
WndProc endp
CreateColumns proc
	invoke	GetDlgItem,hWindow,IDC_FILELIST
	mov	hFileList,eax
	mov	lv_column.imask,LVCF_WIDTH OR LVCF_TEXT OR LVCF_FMT
	mov	lv_column.lx,109
	mov	lv_column.pszText,offset col1Header
	mov	lv_column.fmt,LVCFMT_LEFT
	invoke	SendMessage,hFileList,LVM_INSERTCOLUMN,0,offset lv_column

	mov	lv_column.lx,80
	mov	lv_column.pszText,offset col2Header
	mov	lv_column.fmt,LVCFMT_CENTER
	invoke	SendMessage,hFileList,LVM_INSERTCOLUMN,1,offset lv_column

	mov	lv_column.lx,80
	mov	lv_column.pszText,offset col3Header
	invoke	SendMessage,hFileList,LVM_INSERTCOLUMN,2,offset lv_column

	mov	lv_column.lx,50
	mov	lv_column.pszText,offset col4Header
	invoke	SendMessage,hFileList,LVM_INSERTCOLUMN,3,offset lv_column
CreateColumns endp
ProcessCmndLine proc
	mov	edi,ptrCmndLine
	invoke	lstrlen,edi
	add	edi,eax
	dec	edi
	mov	dl,' '
	xor	ecx,ecx
	cmp	byte ptr [edi],34
	jne	noSpaces
	mov	dl,34
	dec	ecx

  noSpaces:
	dec	edi
	inc	ecx
	cmp	byte ptr [edi],dl
	je	foundCmndLine
	cmp	edi,ptrCmndLine
	je	noVariables
	jmp	noSpaces

  foundCmndLine:
	inc	edi
	mov	esi,edi
	mov	edi,offset sfvFileName
	mov	eax,ecx
	rep movsb
	ret

  noVariables:
	xor	eax,eax
	ret
ProcessCmndLine endp
SetInitValues proc
	invoke	CreateColumns
	invoke	GetDlgItem,hWindow,IDC_FILEPATH
	mov	hFilePath,eax
	invoke	GetMenu,hWindow
	mov	hMenu,eax
	invoke	GetDlgItem,hWindow,IDC_CHECK
	mov	hCheck,eax
	invoke	SendMessage,hWindow,SFV_ENABLEBUTTON,hCheck,FALSE
	invoke	EnableMenuItem,hMenu,IDM_CHECK,MF_BYCOMMAND OR MF_GRAYED
	invoke	GetDlgItem,hWindow,IDC_MAKE
	mov	hMake,eax
	invoke	SendMessage,hWindow,SFV_ENABLEBUTTON,hMake,FALSE
	invoke	EnableMenuItem,hMenu,IDM_MAKE,MF_BYCOMMAND OR MF_GRAYED
	invoke	GetDlgItem,hWindow,IDC_FILE
	mov	hFileButton,eax
	invoke	GetDlgItem,hWindow,IDC_PROGRESS
	mov	hProgress,eax 
	invoke	GetDlgItem,hWindow,IDC_SUMMARY
	mov	hSummary,eax
	invoke	SendMessage,hSummary,BM_SETCHECK,BST_CHECKED,NULL
	invoke	ProcessCmndLine
	cmp	eax,NULL
	je	noCmndLine

	invoke	SetDlgItemText,hWindow,IDC_FILEPATH,offset sfvFileName
	invoke	SendMessage,hFilePath,EM_LIMITTEXT,256,NULL

  noCmndLine:
	ret
SetInitValues endp
CrcFromFile proc uses ecx edx edi esi
	invoke	GlobalAlloc,GPTR,FILEREADSIZE
	mov	ptrFileBuffer,eax
	invoke	CreateFile,offset fileNameBuffer,GENERIC_READ,FILE_SHARE_READ,\
		NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL OR \
		FILE_FLAG_SEQUENTIAL_SCAN,NULL
	cmp	eax,INVALID_HANDLE_VALUE
	je	createError
	push	eax
	invoke	GetFileSize,eax,NULL
	and	eax,0FFFFFFFFh
	mov	fileSize,eax
;	add	allFileSize,eax
	mov	curFileSize,0
	pop	eax
	mov	hCrcFile,eax
	or	eax,0FFFFFFFFh
	mov	progRess,0
  crcNextChunk:
	push	eax
	invoke	ReadFile,hCrcFile,ptrFileBuffer,FILEREADSIZE,offset readSize,NULL
	pop	eax
	mov	ecx,readSize
	add	curFileSize,ecx
	jecxz	crcDone
	mov	edi,ptrFileBuffer
  crcNextByte:
	mov	dl,al                    ;<-- start CRC32 algorithm
	and	edx,0000000FFh
	xor	dl,byte ptr [edi]
	shl	edx,2
	mov	esi,ptrCrcTable
	add	esi,edx
	shr	eax,8
	xor	eax,dword ptr [esi]
	inc	edi
	loop	crcNextByte              ;<--   end CRC32 algorithm

	fild	curFileSize
	fild	fileSize
	fdiv
	fild	c100
	fmul
	fistp	progRess
	mov	edx,readSize
	add	allFileSize,edx
	fild	allFileSize
	fild	totFileSize
	fdiv
	fild	c100
	fmul
	fistp	barSize

	cmp	checkFlag,FALSE
	je	crcDone
	jmp	crcNextChunk
  createError:
	mov	fileErrFlag,TRUE
  crcDone:
	push	eax
	invoke	CloseHandle,hCrcFile
	invoke	GlobalFree,ptrFileBuffer
	pop	eax
	xor	eax,0FFFFFFFFh
	ret
CrcFromFile endp
CreateCrcTable proc uses ecx edx eax edi
	invoke	GlobalAlloc,GPTR,4*256
	mov	ptrCrcTable,eax
	mov	edi,eax
	xor	edx,edx
	mov	ecx,256
  nextDWORD:
	mov	eax,edx
	push	ecx
	mov	ecx,8
  tableDWORD:
	bt	ax,0
	shr	eax,1
	jnc	skipXOR
	xor	eax,CRC32POLY
  skipXOR:
	loop	tableDWORD

	mov	dword ptr [edi],eax
	pop	ecx
	inc	edx
	add	edi,4
	loop	nextDWORD

	ret
CreateCrcTable endp
ChangeButtons proc changeV:DWORD
	cmp	changeV,FALSE
	jne	checkB
	invoke	SetWindowText,hCheck,offset abortCap
	invoke	EnableMenuItem,hMenu,IDM_CHECK,MF_BYCOMMAND OR MF_GRAYED
	invoke	EnableMenuItem,hMenu,IDM_OPEN,MF_BYCOMMAND OR MF_GRAYED
	invoke	EnableMenuItem,hMenu,IDM_ADDFILES,MF_BYCOMMAND OR MF_GRAYED
	invoke	EnableMenuItem,hMenu,IDM_MAKE,MF_BYCOMMAND OR MF_GRAYED
	invoke	EnableMenuItem,hMenu,IDM_CLEAR,MF_BYCOMMAND OR MF_GRAYED
	invoke	DrawMenuBar,hWindow
	jmp	contButtons
  checkB:
	invoke	SetWindowText,hCheck,offset checkCap
	invoke	EnableMenuItem,hMenu,IDM_CHECK,MF_BYCOMMAND OR MF_ENABLED
	invoke	EnableMenuItem,hMenu,IDM_OPEN,MF_BYCOMMAND OR MF_ENABLED
	invoke	EnableMenuItem,hMenu,IDM_ADDFILES,MF_BYCOMMAND OR MF_ENABLED
	invoke	EnableMenuItem,hMenu,IDM_MAKE,MF_BYCOMMAND OR MF_ENABLED
	invoke	EnableMenuItem,hMenu,IDM_CLEAR,MF_BYCOMMAND OR MF_ENABLED
  contButtons:
	invoke	EnableWindow,hMake,changeV
	invoke	EnableWindow,hFileButton,changeV
	invoke	EnableWindow,hFilePath,changeV

	ret
ChangeButtons endp
WriteFileSummary proc
	mov	lv_item.imask,LVIF_TEXT
	mov	lv_item.iSubItem,0
	mov	lv_item.pszText,offset fileNameBuffer
	mov	lv_item.cchTextMax,256
	mov	ecx,numFiles
	xor	ebx,ebx
	jmp	summaryStart
  summaryDone:
	ret
  summaryStart:
	jecxz	summaryDone
	mov	lv_item.iItem,ebx
	push	ebx
	push	ecx
	invoke	SendMessage,hFileList,LVM_GETITEM,NULL,offset lv_item
	invoke	CreateFile,offset fileNameBuffer,GENERIC_READ,FILE_SHARE_READ,\
		NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL OR \
		FILE_FLAG_SEQUENTIAL_SCAN,NULL
	mov	hFileInfo,eax
	invoke	GetFileTime,eax,offset ftime,NULL,NULL
	invoke	FileTimeToSystemTime,offset ftime,offset stime
	invoke	ConvertTime
	invoke	GetFileSize,hFileInfo,NULL
	invoke	wsprintf,offset lineBuffer,offset sizeTemplate,eax,offset sfvTime,\
		offset sfvDate,offset fileNameBuffer
	invoke	CloseHandle,hFileInfo
	invoke	lstrlen,offset lineBuffer
	invoke	WriteFile,hNewFile,offset lineBuffer,eax,offset readSize,NULL
	pop	ecx
	pop	ebx

	inc	ebx
	dec	ecx
	jmp	summaryStart
WriteFileSummary endp
ConvertTime proc
	invoke	GetTimeFormat,NULL,LOCALE_NOUSEROVERRIDE,\
		offset stime,NULL,offset sfvTime,20
	invoke	GetDateFormat,NULL,DATE_SHORTDATE,offset stime,NULL,\
		offset sfvDate,20
	ret
ConvertTime endp
AssociateSFV proc
	invoke	RegCreateKeyEx,HKEY_CLASSES_ROOT,offset sKeyName,0,offset keyClass,\
		REG_OPTION_NON_VOLATILE,KEY_WRITE,NULL,offset hKey,offset keyDisp
	invoke	RegSetValueEx,hKey,NULL,0,REG_SZ,offset sKeyValue,9
	cmp	eax,ERROR_SUCCESS
	jne	regError

	invoke	RegCreateKeyEx,HKEY_CLASSES_ROOT,offset sKeyExt,0,offset keyClass,\
		REG_OPTION_NON_VOLATILE,KEY_WRITE,NULL,offset hKey,offset keyDisp
	invoke	RegSetValueEx,hKey,NULL,0,REG_SZ,offset sKeyName,7
	cmp	eax,ERROR_SUCCESS
	jne	regError

	invoke	GetModuleFileName,hInstance,offset fileNameBuffer,256
	invoke	RegCreateKeyEx,HKEY_CLASSES_ROOT,offset sKeySub,0,offset keyClass,\
		REG_OPTION_NON_VOLATILE,KEY_WRITE,NULL,offset hKey,offset keyDisp
	invoke	wsprintf,offset lineBuffer,offset regTemplate,offset fileNameBuffer
	invoke	lstrlen,offset lineBuffer
	inc	eax
	invoke	RegSetValueEx,hKey,NULL,0,REG_SZ,offset lineBuffer,eax
	invoke	RegCreateKeyEx,HKEY_CLASSES_ROOT,offset sKeyIconSub,0,offset keyClass,\
		REG_OPTION_NON_VOLATILE,KEY_WRITE,NULL,offset hKey,offset keyDisp
	invoke	wsprintf,offset lineBuffer,offset iconTemplate,offset fileNameBuffer
	invoke	lstrlen,offset lineBuffer
	inc	eax
	invoke	RegSetValueEx,hKey,NULL,0,REG_SZ,offset lineBuffer,eax
	cmp	eax,ERROR_SUCCESS
	jne	regError

	invoke	MessageBox,hWindow,offset msgDone,offset capSummary,MB_OK OR \
		MB_ICONINFORMATION
	ret
  regError:
	invoke	MessageBox,hWindow,offset errorMsg,offset capError,MB_OK OR MB_ICONWARNING
	ret
AssociateSFV endp
SetCurrentDir proc pathAddr:DWORD

	invoke	lstrlen,pathAddr
	mov	edi,pathAddr
	add	edi,eax
  dirStart:
	dec	edi
	cmp	edi,pathAddr
	jle	dirSkip
	cmp	byte ptr [edi],'\'
	jne	dirStart	
  dirDone:
	sub	edi,pathAddr
	mov	ecx,edi
	mov	esi,pathAddr
	mov	edi,offset fileNameBuffer
	rep movsb
	mov	byte ptr [edi],0
	invoke	SetCurrentDirectory,offset fileNameBuffer
  dirSkip:
	ret
SetCurrentDir endp
ProcessError proc
	invoke	GetLastError
	invoke	FormatMessage,FORMAT_MESSAGE_FROM_SYSTEM,NULL,eax,NULL,\
		offset errorBuffer,100,NULL
	invoke	MessageBox,NULL,offset errorBuffer,offset errorMsg,MB_OK
	ret
ProcessError endp
end	start