;Makoto Matsumoto and Takuji Nishimura
;psuedorandom number generating algorithm
;copyright 1997, matumoto@math.keio.ac.jp
;http://www.math.keio.ac.jp/matumoto/emt.html

Rand proto :DWORD       ;Generates a number on [0,Max-1]
Randomize proto :DWORD  ;Changes the seed for Rand

.const
N         equ 624
M         equ 397
MATRIX_A  equ 9908b0dfh
TEMPERING_MASK_B equ 9d2c5680h
TEMPERING_MASK_C equ 0efc60000h
UM        equ 80000000h
LM        equ 7fffffffh

.data
mti       dd (N+1)
MC        dd 69069

.data?
mt dd 2496 dup(?)

.code
Randomize proc Seed:DWORD
lea edi,mt
mov eax,Seed
mov [edi],eax
mov mti,1
@R: add edi,4
    mul MC
    mov [edi],eax
    inc mti
    cmp mti,N
    jnz @R
ret
Randomize endp

Rand proc Max:DWORD
LOCAL Counter:DWORD
lea edi,mt
.IF mti>=N
    .IF mti==N+1
        INVOKE Randomize,4357
    .ENDIF
    mov Counter,0
    mov esi,edi
@S:     mov eax,[esi]
        and eax,UM
        mov ebx,[esi+4]
        and ebx,LM
        or eax,ebx
        mov ecx,eax
        shr eax,1
        mov edx,esi
        add edx,(M*4)
        mov ebx,[edx]
        xor eax,ebx
        and ecx,1
        .IF ecx
            xor eax,MATRIX_A
        .ENDIF
        mov [esi],eax
        add esi,4
        inc Counter
        cmp Counter,(N-M)
        jnz @S

@T:     mov eax,[esi]
        and eax,UM
        mov ebx,[esi+4]
        and ebx,LM
        or eax,ebx
        mov ecx,eax
        shr eax,1
        mov edx,esi
        add edx,((M-N)*4)
        mov ebx,[edx]
        xor eax,ebx
        and ecx,1
        .IF ecx
            xor eax,MATRIX_A
        .ENDIF
        mov [esi],eax
        add esi,4
        inc Counter
        cmp Counter,(N-1)
        jnz @T

        mov edx,edi
        add edx,(M-1)*4
        mov ebx,[edx]
        xor eax,ebx
        and ecx,1
        .IF ecx
            xor eax,MATRIX_A
        .ENDIF
        mov [esi],eax
    mov mti,0
.ENDIF
mov esi,edi
mov eax,mti
inc mti
shl eax,2
add esi,eax
mov eax,[esi]
mov ebx,eax
shr eax,11
xor ebx,eax
mov eax,ebx
shl eax,7
and eax,TEMPERING_MASK_B
xor ebx,eax
mov eax,ebx
shl eax,15
and eax,TEMPERING_MASK_C
xor ebx,eax
mov eax,ebx
shr eax,18
xor eax,ebx
xor edx,edx
div Max
mov eax,edx
ret
Rand endp
