.386
.model flat,stdcall
option casemap:none

include windows.inc
include kernel32.inc
include user32.inc

includelib kernel32.lib
includelib user32.lib

.const
WM_MOUSEHOOK equ WM_USER+6	;our hook message which is posted to revealer

.data
hInstance	dd 0

.data?
hHook		dd ?
hWnd		dd ?

.code
DllEntry proc hInst:HINSTANCE, reason:DWORD, reserved1:DWORD
	push hInst
	pop hInstance
	mov  eax,TRUE
	ret
DllEntry Endp

MouseProc proc nCode:DWORD,wParam:DWORD,lParam:DWORD
	invoke CallNextHookEx,hHook,nCode,wParam,lParam
	mov edx,lParam					;move mouse coordinates in edx
	assume edx:PTR MOUSEHOOKSTRUCT
	invoke WindowFromPoint,[edx].pt.x,[edx].pt.y	;get handle of window from mouse coordinates/point
	assume edx:nothing
	
	mov wParam, eax
	
	invoke	GetWindowLongA, wParam, GWL_STYLE			;get the window styles
	test eax, ES_PASSWORD						;check for password flag

	jz NotPassBox							;jump if non password box
		invoke	SendMessage, wParam, EM_SETPASSWORDCHAR, 0, 0	;remove the password flag from window
		invoke	InvalidateRect, wParam, 0, 0			;and update window
	NotPassBox:

	xor eax,eax
	ret
MouseProc endp

InstallHook proc hwnd:DWORD
	push hwnd
	pop hWnd
	invoke SetWindowsHookEx,WH_MOUSE,addr MouseProc,hInstance,NULL	;set a hook on mouse events
	mov hHook,eax
	ret 
InstallHook endp

UninstallHook proc
	invoke UnhookWindowsHookEx,hHook				;unhook our hook
	ret
UninstallHook endp

End DllEntry
