.386					;for 386 at least
.model flat, stdcall
option casemap :none			;case sensitive

include windows.inc
include user32.inc
include kernel32.inc
include shell32.inc
include gdi32.inc
include comctl32.inc
include msimg32.inc

includelib user32.lib
includelib kernel32.lib
includelib shell32.lib
includelib gdi32.lib
includelib comctl32.lib
includelib msimg32.lib

include		hookdll\mhook.inc		;mouse hook dll
includelib	hookdll\mhook.lib		;mouse hook dll

WinMain PROTO :DWORD,:DWORD,:DWORD,:DWORD
WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD

WM_SHELLNOTIFY	equ WM_USER+5	;tray message
WM_MOUSEHOOK	equ WM_USER+6	;hook message

IDC_ABOUTDLG	equ 200		;Aboutbox

IDI_TRAY	equ 0		;ID of our trayicon

ICON_KEYON	equ 1000
ICON_KEYOFF	equ 1001

IDM_TOGGLE	equ 2000	;menu TOGGLE
IDM_ABOUT	equ 2001	;menu ABOUT
IDM_EXIT	equ 2002	;menu EXIT

BMP_GHOUSE	equ 300		;greyed house
BMP_CHOUSE	equ 301		;colored house

BMP_GEMAIL	equ 302		;greyed email
BMP_CEMAIL	equ 303		;colored email

hposX		equ 10		;X position of housebitmap
hposY		equ 63		;Y position of housebitmap
	
eposX		equ 30		;X position of emailbitmap
eposY		equ 66		;Y position of emailbitmap

.data
	HookFlag	db	FALSE					;Start disabled

	szClassName	db	"SavvyClass",0				;Class name for window
	szToolClassName	db	"Tooltips_class32",0
	szCaption	db	"Password Revealer by SavaGe",0

	szToolTipText	db	"Password Revealer "			;Tooltip text
	TipStatus	db	11 dup (0)

	TipEnabled	db	"[Enabled]",0				;used for TipStatus
	TipDisabled	db	"[Disabled]",0				;

	szMenuEnable	db	"&Enable Revealer",0			;Menuitem text
	szMenuDisable	db	"&Disable Revealer",0			;
	szMenuAbout	db	"&About",0				;
	szMenuExit	db	"E&xit",0				;
	
	szCmdEnabled	db	"-enabled",0
		
	HouseFlag	db	FALSE
	EmailFlag	db	FALSE
	Painted		db	FALSE

	szEmailAddress	db	"mailto:savage@phrozencrew.com",0
	szHomePage	db	"http://www.phrozencrew.com",0

	rectemail	RECT  <eposX, eposY, eposX+11, eposY+11>	;for aboutbox
	recthouse	RECT  <hposX, hposY, hposX+14, hposY+14>	;
	
.data?
	hInstance	dd	?
	lpCmdLine	dd	?					;pointer to commandline

	hPopupMenu	dd	?					;handle popupmenu

	hIconON		dd	?					;handle icon on
	hIconOFF	dd	?					;handle icon off

	hBmpColHouse	dd	?					;bitmap handles
	hBmpColEmail	dd	?					;
	hBmpGreyHouse	dd	?					;
	hBmpGreyEmail	dd	?					;
	
	hDCWin		dd	?					;for about box
	hDCMem		dd	?					;
	
	hwndTool	dd	?					;for tooltip
		
	pt		POINT <>					;for TrackPopupMenu
	mousept		POINT <>					;point struct which will contain our cursor pos
	rect		RECT  <>					;for about box

	ps		PAINTSTRUCT    <>				;for aboutbox
	nid		NOTIFYICONDATA <>				;The structure for traybar icons
	mii		MENUITEMINFO   <>				;for popupmenu
	
.code

Main:
	invoke FindWindow,addr szClassName,addr szCaption		;check if revealer is already running
	.IF eax!=0							;if yes
	 invoke ExitProcess,0						;exit
	.ENDIF
	
	invoke	GetModuleHandle, NULL
	mov	hInstance, eax
	
	invoke 	GetCommandLine
	mov 	lpCmdLine, eax
	
	invoke	WinMain, hInstance, NULL, lpCmdLine, SW_SHOWDEFAULT
	invoke	ExitProcess, eax
	
WinMain proc hInst:DWORD, hPrevInst:DWORD, CmdLine:DWORD, CmdShow:DWORD
lOCAL wc   :WNDCLASSEX
LOCAL msg  :MSG
	
	invoke	lstrlen,CmdLine	
	mov edi, CmdLine
	inc edi			;we are looking for the second '"' char not the first
	mov cl, '"'
	xchg ecx, eax
	repne scasb		;search for "
	inc edi			;get rid of space char
	
	invoke	lstrcmpi, edi, addr szCmdEnabled	;check for commandline "-enabled"
	.IF eax==0
		mov HookFlag, TRUE
	.ENDIF	
	
	mov	nid.cbSize, sizeof nid
	mov	wc.cbSize, sizeof WNDCLASSEX
	mov	wc.style, CS_HREDRAW or CS_VREDRAW
	mov	wc.lpfnWndProc, offset WndProc
	mov	wc.cbClsExtra, NULL 
	mov	wc.cbWndExtra, NULL 
	push	hInstance
	pop	wc.hInstance
	mov	wc.hbrBackground, COLOR_WINDOW + 1
	mov	wc.lpszMenuName, NULL
	mov	wc.lpszClassName, offset szClassName
	
	invoke	LoadImage, hInstance, ICON_KEYON, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR
	mov	hIconON, eax
	
	invoke	LoadImage, hInstance, ICON_KEYOFF, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR
	mov	hIconOFF, eax
	
	mov	wc.hIcon, eax 
	mov	wc.hIconSm, eax
	
	.IF HookFlag==TRUE				;if started "-enabled"
		invoke InstallHook, hInst		;enable hook
		mov eax, hIconON			;enabled icon
	.ENDIF
	
	mov	nid.hIcon, eax
	
	invoke	LoadCursor, NULL, IDC_ARROW
	mov	wc.hCursor, eax 
		
	invoke	RegisterClassEx, addr wc
	
	invoke 	CreateWindowEx, NULL, addr szClassName, addr szCaption,\
	  WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,\
	  CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL,\
	  hInstance, NULL
	  
	mov	nid.hwnd, eax
	mov	nid.uCallbackMessage, WM_SHELLNOTIFY
	mov	nid.uID, IDI_TRAY
	mov	nid.uFlags, NIF_ICON + NIF_TIP + NIF_MESSAGE

	call	CheckToolTip							;Set tooltip enabled/disabled

	invoke	Shell_NotifyIcon, NIM_ADD, addr nid				;Add the traybar icon
	
	.WHILE TRUE								;Message Handler
		invoke GetMessage, addr msg, NULL, 0, 0				;
		.BREAK .IF (!eax)						;
		invoke TranslateMessage, addr msg				;
		invoke DispatchMessage, addr msg				;
	.ENDW									;
	
	invoke	Shell_NotifyIcon, NIM_DELETE, addr nid				;Delete the trayicon (exit)
	ret
WinMain endp 

WndProc proc hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	mov	eax, uMsg

	.IF eax ==WM_CREATE
	
		invoke	CreatePopupMenu					;create popupmenu
		mov	hPopupMenu,eax

		.IF HookFlag==FALSE
			mov ebx, offset szMenuEnable
			jmp addmenu
		.ELSE
			mov ebx, offset szMenuDisable
		addmenu:
			invoke	AppendMenu, hPopupMenu, MF_STRING, IDM_TOGGLE, ebx 		;Add Enabled/Disabled
		.ENDIF
	
		mov mii.dwTypeData, ebx

		invoke	SetMenuDefaultItem, hPopupMenu, IDM_TOGGLE, 0				;Make toggle menuitem default/bold

		invoke	AppendMenu, hPopupMenu, MF_SEPARATOR, 0, 0				;Add -----
		invoke	AppendMenu, hPopupMenu, MF_STRING, IDM_ABOUT, offset szMenuAbout	;Add About
		invoke	AppendMenu, hPopupMenu, MF_SEPARATOR, 0, 0				;Add -----
		invoke	AppendMenu, hPopupMenu, MF_STRING, IDM_EXIT, offset szMenuExit		;Add Exit
		
		mov mii.cbSize, sizeof mii
		mov mii.fMask, MIIM_TYPE	
		mov mii.fType, MFT_STRING

		push hWnd
		pop mii.wID

		push hPopupMenu
		pop mii.hSubMenu

		mov mii.dwItemData, IDM_TOGGLE
	
	.ELSEIF	eax==WM_SHELLNOTIFY						;if clicked on trayicon
		mov 	edx, lParam						;
										;
		.IF dx==WM_LBUTTONDOWN						;with left mouse button

			.IF HookFlag==TRUE					;Toggle MouseHook
				invoke	UninstallHook				; Disable
				mov	eax, hIconOFF				;
				mov	HookFlag,FALSE				;
			.ELSE							;
				invoke	InstallHook,hWnd			; Enable
				mov	eax, hIconON				;
				mov	HookFlag,TRUE				;
			.ENDIF							;

			mov	nid.hIcon, eax
			call	CheckToolTip					;Set tooltip enabled/disabled
			invoke	Shell_NotifyIcon,NIM_MODIFY,addr nid		;Update/modify the Icon
			
		.ELSEIF	dx==WM_RBUTTONDOWN					;if clicked with right mouse button
			
			mov eax, offset szMenuEnable
			mov ebx, offset szMenuDisable
			
			mov ecx, offset mii
			assume ecx:ptr MENUITEMINFO
			
			.IF HookFlag==FALSE && [ecx].dwTypeData!=eax
				mov [ecx].dwTypeData, eax
				jmp setmenu
			.ELSEIF HookFlag==TRUE && [ecx].dwTypeData!=ebx
				mov [ecx].dwTypeData, ebx
			setmenu:
				invoke	SetMenuItemInfo, hPopupMenu, IDM_TOGGLE, NULL, ecx
			.ENDIF
			
			assume ecx:nothing
			
			invoke	GetCursorPos, offset pt							;get cursorpos
			invoke	SetForegroundWindow,hWnd						;need this to get rid of popupmenu
			invoke	TrackPopupMenu, hPopupMenu, 0, pt.x, pt.y, 0, hWnd, NULL		;Display popupmenu and track the selection
			invoke	PostMessage, hWnd, WM_NULL, 0, 0					;used for compatibility reason

		.ENDIF

	.ELSEIF	eax==WM_COMMAND

		.IF	wParam==IDM_TOGGLE					;if toggle menuitem has been clicked

			.IF HookFlag==TRUE					;Toggle MouseHook
				invoke	UninstallHook				; Disable
				mov	eax, hIconOFF				;
				mov	HookFlag,FALSE				;
			.ELSE							;
				invoke	InstallHook,hWnd			; Enable
				mov	eax, hIconON				;
				mov	HookFlag,TRUE				;
			.ENDIF							;
					
			mov	nid.hIcon, eax
			call	CheckToolTip					;Set tooltip enabled/disabled
			invoke	Shell_NotifyIcon,NIM_MODIFY,addr nid		;Update/modify the Icon

		.ELSEIF	wParam==IDM_ABOUT					;if about menuitem has been clicked
		
			mov eax, offset AboutProc
			invoke DialogBoxParamA, hInstance, IDC_ABOUTDLG, hWnd, eax, 0
			push 1
			pop eax		;return true
			ret
				
		.ELSEIF	wParam==IDM_EXIT					;if exit menuitem has been clicked

			.IF HookFlag==TRUE					;if hook was enabled,
				invoke	UninstallHook				;uninstall the hook
			.ENDIF			

			invoke	DestroyMenu, hPopupMenu				;kill popupmenu
			invoke	PostQuitMessage, NULL
		.ENDIF	
	.ELSE
		invoke	DefWindowProc, hWnd, uMsg, wParam, lParam
	.ENDIF
WindowDone:
	ret
WndProc endp

CheckToolTip PROC					;sets the tooltip text as enabled/disabled
	.IF HookFlag==TRUE					;if enabled,
	  invoke lstrcpy, addr TipStatus, addr TipEnabled	;set [Enabled]
	.ELSE							;else
	  invoke lstrcpy, addr TipStatus, addr TipDisabled	;set [Disabled]
	.ENDIF
	invoke	lstrcpy, addr nid.szTip, offset szToolTipText	;Tool-tip text for traybar icon
	ret
CheckToolTip ENDP

CheckMouseOver PROC  uses esi Rect:DWORD	;checks if the mousecursor is in the specified Rect
	invoke PtInRect, Rect, mousept.x, mousept.y
	ret
CheckMouseOver ENDP

DrawColHouse PROC
	invoke	SelectObject, hDCMem, hBmpColHouse
	invoke	TransparentBlt, hDCWin, hposX, hposY, 14, 14, hDCMem, 0, 0, 14, 14, 0FF00FFh
	mov HouseFlag, 1
	ret
DrawColHouse ENDP

DrawGreyHouse PROC
	invoke	SelectObject, hDCMem, hBmpGreyHouse
	invoke	TransparentBlt, hDCWin, hposX, hposY, 14, 14, hDCMem, 0, 0, 14, 14, 0FF00FFh
	mov HouseFlag, 0
	ret
DrawGreyHouse ENDP

DrawColEmail PROC
	invoke	SelectObject, hDCMem, hBmpColEmail
	invoke	TransparentBlt, hDCWin, eposX, eposY, 11, 11, hDCMem, 0, 0, 11, 11, 0FF00FFh
	mov EmailFlag, 1
	ret
DrawColEmail ENDP

DrawGreyEmail PROC
	invoke	SelectObject, hDCMem, hBmpGreyEmail
	invoke	TransparentBlt, hDCWin, eposX, eposY, 11, 11, hDCMem, 0, 0, 11, 11, 0FF00FFh
	mov EmailFlag, 0
	ret
DrawGreyEmail ENDP

AboutProc proc hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
LOCAL ti:TOOLINFO
	
	mov	eax, uMsg
	
	.IF eax==WM_CLOSE
		jmp EndAbout
	.ELSEIF eax==WM_INITDIALOG
		
		mov esi, hInstance
		mov edi, offset LoadBitmap
		
		;invoke	LoadBitmap, hInstance, BMP_CHOUSE
		push BMP_CHOUSE
		push esi
		call edi
		mov hBmpColHouse, eax
		
		;invoke	LoadBitmap, hInstance, BMP_GHOUSE
		push BMP_GHOUSE
		push esi
		call edi
		mov hBmpGreyHouse, eax
		
		;invoke	LoadBitmap, hInstance, BMP_CEMAIL
		push BMP_CEMAIL
		push esi
		call edi
		mov hBmpColEmail, eax
		
		;invoke	LoadBitmap, hInstance, BMP_GEMAIL
		push BMP_GEMAIL
		push esi
		call edi
		mov hBmpGreyEmail, eax
				
		invoke InitCommonControls
		invoke CreateWindowEx,WS_EX_TOPMOST,ADDR szToolClassName,NULL,\
	           TTS_ALWAYSTIP,CW_USEDEFAULT,\
	           CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,NULL,\
	           hInstance,NULL
		
		mov hwndTool,eax
		mov ti.cbSize,sizeof TOOLINFO
		mov ti.uFlags,TTF_SUBCLASS
		push hWnd
		pop ti.hWnd
		
		;copy recthouse struct into ti.rect struct
		xor ecx, ecx
		mov cl, 4
		lea esi, recthouse
		lea edi, ti.rect
		rep movsd
		
		mov ti.lpszText, offset szHomePage
		invoke SendMessage,hwndTool,TTM_ADDTOOL,NULL,addr ti
		
		;copy rectemail struct into ti.rect struct
		xor ecx, ecx
		mov cl, 4
		lea esi, rectemail
		lea edi, ti.rect
		rep movsd
		
		mov ti.lpszText, offset szEmailAddress+7
		invoke SendMessage,hwndTool,TTM_ADDTOOL,NULL,addr ti
					
	.ELSEIF eax==WM_MOUSEMOVE
		
		mov eax,lParam
		and eax,0FFFFh
		mov mousept.x,eax
		mov eax,lParam
		shr eax,16
		mov mousept.y,eax
		
		invoke CheckMouseOver, addr recthouse
		.IF (EAX)
		
		.IF (!HouseFlag)
			invoke DrawColHouse
		 .ENDIF
		
		.ELSEIF (HouseFlag)
			invoke DrawGreyHouse
		.ENDIF
		
		invoke CheckMouseOver, addr rectemail
		.IF (EAX)
		
		  .IF (!EmailFlag)
			invoke DrawColEmail
		  .ENDIF
		
		.ELSEIF (EmailFlag)
			invoke DrawGreyEmail
		.ENDIF
		
	.ELSEIF eax==WM_LBUTTONUP
		
		invoke CheckMouseOver, addr recthouse
		.IF (EAX)
			invoke ShellExecuteA,hWnd,NULL,offset szHomePage,NULL,NULL,NULL
		.ENDIF
		
		invoke CheckMouseOver, addr rectemail
		.IF (EAX)
			invoke ShellExecuteA,hWnd,NULL,offset szEmailAddress,NULL,NULL,NULL
		.ENDIF
		
	.ELSEIF eax==WM_PAINT

		.IF (!Painted)
			invoke	BeginPaint, hWnd, addr ps
			mov	hDCWin, eax
			invoke	CreateCompatibleDC, eax
			mov	hDCMem, eax
			xor	Painted, 1
		.ENDIF
		
		invoke	DrawGreyHouse
		invoke	DrawGreyEmail
		
	.ELSEIF eax==WM_COMMAND
	
		mov eax, wParam
		cmp ax, IDOK		;user pressed OK
		je EndAbout
	.ENDIF
	
	xor eax, eax
	ret

EndAbout:
	invoke	EndDialog, hWnd, wParam
	
	invoke	DeleteDC, hDCMem		;cleanup
	invoke	DeleteDC, hDCWin		;
	invoke	EndPaint, hWnd, addr ps		;
						;
	mov	edi, offset DeleteObject	;
	push	hBmpColHouse			;
	call	edi				;
	push	hBmpColEmail			;
	call	edi				;
	push	hBmpGreyHouse			;
	call	edi				;
	push	hBmpGreyEmail			;
	call	edi				;
	
	xor	Painted, 1
	
	push 1
	pop eax
	ret
AboutProc endp

End Main
