; RUNNINGAPPS.ASM by [neo] / ByTeGeiZ, 10/May/2002
; ------------------------------------------------
; Demonstrate how to get all running applications and processid with
; Win32APIs CreateToolhelp32Snapshot, Process32First and Process32Next
; ------------------------------------------------
; contact: neo@grotten-eumel.de / neo@ByTeGeiZ.de
;          http://www.grotten-eumel.de
;          http://www.ByTeGeiZ.de

.386
.MODEL FLAT,STDCALL
OPTION CASEMAP:NONE

include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\windows.inc
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib

WWIDTH EQU 480
WHEIGHT EQU 300

.DATA?
hWin dd ?
lpfnWndProc dd ?
Msg MSG <>
CenterX dd ?
CenterY dd ?
uProcess PROCESSENTRY32 <>
hSnapshot dd ?
tBuffer db 255 dup(?)

.DATA
PrgName db "ProcessId -> Running Application | Demo by [neo]",0
cFormat db "0%xh -> %s",0
ClassName db "LISTBOX",0
wc WNDCLASSEX <SIZEOF WNDCLASSEX, CS_HREDRAW + CS_VREDRAW, offset WndProc, 0, 0, 0, 0, 0, 0, 0, offset PrgName, 0>

.CODE
start:
 push   0
 call   GetModuleHandle
 mov    [wc.hInstance],eax                ; get module handle

 push   SM_CXSCREEN
 call   GetSystemMetrics                  ; get screen width

 push   eax
 push   WWIDTH
 call   CenterCalc
 mov    [CenterX],eax                     ; calculate center x

 push   SM_CYSCREEN
 call   GetSystemMetrics                  ; get screen height

 push   eax
 push   WHEIGHT
 call   CenterCalc
 mov    [CenterY],eax                     ; calculate center y

 push   offset wc
 call   RegisterClassEx                   ; register window class

 push   0
 push   [wc.hInstance]
 push   0
 push   0
 push   WHEIGHT
 push   WWIDTH
 push   [CenterY]
 push   [CenterX]
 push   WS_CAPTION or WS_SYSMENU or WS_VSCROLL
 push   offset PrgName
 push   offset ClassName
 push   WS_EX_DLGMODALFRAME
 call   CreateWindowEx
 mov    [hWin],eax                        ; create listbox window

 push   offset WndProc
 push   GWL_WNDPROC
 push   eax
 call   SetWindowLong
 mov    lpfnWndProc,eax                   ; set listbox proc

 push   [hWin]
 call   GetRunningApps                    ; get running applications

 push   SW_SHOWNORMAL
 push   [hWin]
 call   ShowWindow                        ; show window 

 push   [hWin]
 call   UpdateWindow                      ; update window

Messageloop:                              ; messageloop: get and translate win msg
 push   PM_REMOVE
 push   0
 push   0
 push   0
 push   offset Msg
 call   PeekMessage
 test   eax,eax
 jz     ToDo
 cmp    [Msg.message],WM_QUIT
 jnz    Dispatcher
 push   [Msg.wParam]
 call   PostQuitMessage
 jmp    ProgramExit

Dispatcher:
 push   offset Msg
 call   TranslateMessage
 
 push   offset Msg
 call   DispatchMessage
 jmp    Messageloop

ToDo:
 jmp    Messageloop

ProgramExit:

 push   0
 call   ExitProcess                       ; end program

WndProc PROC hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

 mov    eax,[uMsg]                        ; check input
 cmp    eax,WM_CLOSE
 jz     WndProc_2
 cmp    eax,WM_DESTROY
 jz     WndProc_2

 push   [lParam]
 push   [wParam]
 push   eax
 push   [hWnd]
 push   [lpfnWndProc]
 call   CallWindowProc                    ; next...
 ret

WndProc_2:
 push   0
 call   PostQuitMessage                   ; prepare exit
 xor    eax,eax
 ret

WndProc ENDP

; *********************************************
; *** CenterCalc: calculate center position ***
; *********************************************
CenterCalc PROC wWidth:DWORD, sWidth:DWORD

 shr sWidth,1                             ; x=screenwidth/2
 shr wWidth,1                             ; x2=windowwidth/2
 mov eax,wWidth
 sub sWidth,eax                           ; result=x-x2
 mov eax,sWidth
 ret

CenterCalc endp

; *********************************************************************
; *** GetRunningApps: get running applications inclusive processids ***
; ***                 and write into a listbox                      ***
; *********************************************************************
GetRunningApps PROC hWnd:DWORD

 push   0
 push   TH32CS_SNAPPROCESS
 call   CreateToolhelp32Snapshot          ; snapshot of the current process list
 mov    [hSnapshot],eax

 mov    [uProcess.dwSize],sizeof PROCESSENTRY32

 push   offset uProcess
 push   eax
 call   Process32First                    ; get first process
 jmp    GetRunningApps_Chk

GetRunningApps_Loop:

 push   offset uProcess.szExeFile
 push   [uProcess.th32ProcessID]
 push   offset cFormat
 push   offset tBuffer
 call   wsprintf                          ; write current processid and exefile
                                          ; into a temp buffer
 push   offset tBuffer
 push   0
 push   LB_ADDSTRING
 push   [hWnd]
 call   SendMessage                       ; add temp buffer to listbox

 push   offset uProcess
 push   [hSnapshot]
 call   Process32Next                     ; get next process

GetRunningApps_Chk:
 test   eax,eax
 jnz    GetRunningApps_Loop               ; if eax!=0 loop

 push   [hSnapshot]
 call   CloseHandle                       ; close snapshot handle
 ret

GetRunningApps ENDP
end start