EnableControls PROC hDlg:DWORD
	;----------------------------------------
	; Enable relevant controls
	;----------------------------------------
	invoke GetDlgItem,hDlg,IDC_REDIRECTGROUP
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_RETURNGROUP
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_NOREDIRECT
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_EPRVA
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_REDIRECTCODE
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_REDIRECTCALL
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_RETURNGROUP
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_NORETURN
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_RETURN
	invoke EnableWindow,eax,TRUE
	invoke SendDlgItemMessage,hDlg,IDC_RETURN,BM_GETCHECK,0,0
	.if eax==BST_CHECKED
		invoke EnableReturnVA,hDlg
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_REDIRECTCODE,BM_GETCHECK,0,0
	push eax
	invoke SendDlgItemMessage,hDlg,IDC_REDIRECTCALL,BM_GETCHECK,0,0
	mov edx,eax
	pop eax
	.if eax==BST_CHECKED || edx==BST_CHECKED
		invoke EnablePatchVA,hDlg
	.endif
	ret
EnableControls ENDP



DisableControls PROC hDlg:DWORD
	invoke GetDlgItem,hDlg,IDC_REDIRECTGROUP
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_RETURNGROUP
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_NOREDIRECT
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_EPRVA
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_REDIRECTCODE
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_REDIRECTCALL
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_RETURNGROUP
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_NORETURN
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_RETURN
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_RESTOREGROUP
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_RESTORECODE
	invoke EnableWindow,eax,FALSE
	invoke DisablePatchVA,hDlg
	invoke DisableReturnVA,hDlg
	ret
DisableControls endp
EnablePatchVA proc hDlg:DWORD
	invoke GetDlgItem,hDlg,IDC_REDIRECTLABEL
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_PATCHVA
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_RESTOREGROUP
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_RESTORECODE
	invoke EnableWindow,eax,TRUE
	ret
EnablePatchVA endp

DisablePatchVA proc hDlg:DWORD
	invoke GetDlgItem,hDlg,IDC_REDIRECTLABEL
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_PATCHVA
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_RESTOREGROUP
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_RESTORECODE
	invoke EnableWindow,eax,FALSE
	ret
DisablePatchVA endp
EnableReturnVA proc hDlg:DWORd
	invoke GetDlgItem,hDlg,IDC_RETURNLABEL
	invoke EnableWindow,eax,TRUE
	invoke GetDlgItem,hDlg,IDC_RETURNVA
	invoke EnableWindow,eax,TRUE
	ret
EnableReturnVA endp
DisableReturnVA proc hDlg:DWORd
	invoke GetDlgItem,hDlg,IDC_RETURNLABEL
	invoke EnableWindow,eax,FALSE
	invoke GetDlgItem,hDlg,IDC_RETURNVA
	invoke EnableWindow,eax,FALSE
	ret
DisableReturnVA endp

HexString2Dword proc uses ebx ecx edi edx esi String:DWORD
	LOCAL Result:DWORD
	mov Result,0
	xor ecx,ecx
	mov edi,String
	invoke lstrlen,String
	mov ebx,16
	mov esi,eax
	.while esi!=0
		mov al,[edi]
		.if al>="0" && al<="9"
			sub al,"0"
		.elseif al>="a" && al<="f"
			sub al,"a"
			add al,10
		.else
			sub al,"A"
			add al,10
		.endif
		movzx eax,al
		mov ecx,esi
		dec ecx
		.while ecx>0
			mul ebx
			dec ecx
		.endw
		add Result,eax
		inc edi
		dec esi
	.endw
	mov eax,Result
	ret
HexString2Dword endp

FillPEInfo PROC uses esi pTempMapping:DWORD,lpPEHeader:DWORD; esi points to the pe header in the memory mapped file
	LOCAL ImportRVA:DWORD
	mov esi,lpPEHeader
	mov pPEHeader,esi
	assume esi:ptr IMAGE_NT_HEADERS
	;---------------------------------
	; Store number of sections
	;---------------------------------
	mov ax,[esi].FileHeader.NumberOfSections
	movzx eax,ax
	mov NumSection,eax
	;--------------------------------------------
	; Calculate the VA for the new section (if used)
	;--------------------------------------------
	mov eax,[esi].OptionalHeader.ImageBase
	add eax,[esi].OptionalHeader.SizeOfImage
	mov NewSectionVA,eax
	;------------------------------------------
	; Now store the pointer to the section table
	;------------------------------------------
	assume esi:nothing
	mov ecx,sizeof IMAGE_NT_HEADERS
	push esi
	add esi,ecx
	mov pSectionTable,esi
	pop esi
	assume esi:ptr IMAGE_NT_HEADERS
	mov eax,[esi].OptionalHeader.DataDirectory[8].VirtualAddress
	mov ImportRVA,eax
	invoke RVAToOffset,pTempMapping,ImportRVA
	add eax,pTempMapping
	mov pImportSection,eax
	assume esi:nothing
	ret
FillPEInfo endp

InfoProc PROC hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	.if uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
InfoProc endp
AboutProc PROC hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	.if uMsg==WM_INITDIALOG
		invoke LoadIcon,hInstance,IDI_MYICON
		invoke SendMessage,hDlg,WM_SETICON,ICON_SMALL,eax
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if ax==IDC_ABOUTOK
			.if dx==BN_CLICKED
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		.endif
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
AboutProc endp

ManageMenuState proc
	.if ax==0	; File menu
		.if FProjectInProgress!=NO_PROJECT
			.if FProjectInProgress!=TARGET_ONLY
				invoke EnableMenuItem,hMenu,IDM_CLOSE,MF_ENABLED
				invoke EnableMenuItem,hMenu,IDM_SAVE,MF_ENABLED
			.else
				invoke EnableMenuItem,hMenu,IDM_CLOSE,MF_GRAYED
				invoke EnableMenuItem,hMenu,IDM_SAVE,MF_GRAYED
			.endif
			.if FProjectInProgress==EXEFILE_AVAILABLE
				invoke EnableMenuItem,hMenu,IDM_EXPORT,MF_ENABLED
			.else
				invoke EnableMenuItem,hMenu,IDM_EXPORT,MF_GRAYED
			.endif
		.else
			invoke EnableMenuItem,hMenu,IDM_SAVE,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_EXPORT,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_CLOSE,MF_GRAYED
		.endif
	.elseif ax==1	; Edit menu
		.if FProjectInProgress!=NO_PROJECT && FProjectInProgress!=TARGET_ONLY
			;---------------------------------------------
			; Enable main menu items
			;----------------------------------------------
			invoke EnableMenuItem,hMenu,IDM_CUT,MF_ENABLED
			invoke EnableMenuItem,hMenu,IDM_COPY,MF_ENABLED
			invoke EnableMenuItem,hMenu,IDM_SELECTALL,MF_ENABLED
			invoke EnableMenuItem,hMenu,IDM_DELETE,MF_ENABLED
			invoke OpenClipboard,NULL
			invoke IsClipboardFormatAvailable,CF_TEXT
			.if eax!=0
				invoke EnableMenuItem,hMenu,IDM_PASTE,MF_ENABLED
				invoke EnableMenuItem,hMenuPopup,IDM_PASTE,MF_ENABLED
			.else
				invoke EnableMenuItem,hMenu,IDM_PASTE,MF_GRAYED
				invoke EnableMenuItem,hMenuPopup,IDM_PASTE,MF_GRAYED
			.endif	
			invoke CloseClipboard
			invoke EnableMenuItem,hMenu,IDM_UNDO,MF_ENABLED
		.else
			;-----------------------------------------------
			; Disable main menu
			;-----------------------------------------------
			invoke EnableMenuItem,hMenu,IDM_SELECTALL,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_CUT,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_COPY,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_PASTE,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_UNDO,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_DELETE,MF_GRAYED
		.endif
	.elseif ax==2	; PE info menu
		.if FPatch==TRUE || FProjectInProgress==TARGET_ONLY
			invoke EnableMenuItem,hMenu,IDM_PEHEADER,MF_ENABLED
			invoke EnableMenuItem,hMenu,IDM_SECTION,MF_ENABLED
			mov eax,pPEHeader
			assume eax:ptr IMAGE_NT_HEADERS
			.if [eax].OptionalHeader.DataDirectory[8].VirtualAddress!=0
				invoke EnableMenuItem,hMenu,IDM_IMPORT,MF_ENABLED
			.else
				invoke EnableMenuItem,hMenu,IDM_IMPORT,MF_GRAYED
			.endif
			invoke EnableMenuItem,hMenu,IDM_DATADIRECTORY,MF_ENABLED
		.else
			invoke EnableMenuItem,hMenu,IDM_PEHEADER,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_SECTION,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_IMPORT,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_DATADIRECTORY,MF_GRAYED
		.endif
	.elseif ax==3	; Action menu
		.if FProjectInProgress!=NO_PROJECT && FProjectInProgress!=TARGET_ONLY
			invoke EnableMenuItem,hMenu,IDM_ASSEMBLE,MF_ENABLED
			invoke EnableMenuItem,hMenu,IDM_PROJECTOPTION,MF_ENABLED
			.if FPatch==TRUE
				invoke EnableMenuItem,hMenu,IDM_NEWIMPORT,MF_ENABLED
			.else
				invoke EnableMenuItem,hMenu,IDM_NEWIMPORT,MF_GRAYED
			.endif
			.if FPatch==TRUE && FProjectInProgress==EXEFILE_AVAILABLE
				.if PatchOption>0
					invoke EnableMenuItem,hMenu,IDM_PATCH,MF_ENABLED
				.else
					invoke EnableMenuItem,hMenu,IDM_PATCH,MF_GRAYED
				.endif
			.else
				invoke EnableMenuItem,hMenu,IDM_PATCH,MF_GRAYED
			.endif
		.else
			invoke EnableMenuItem,hMenu,IDM_PROJECTOPTION,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_ASSEMBLE,MF_GRAYED
			invoke EnableMenuItem,hMenu,IDM_PATCH,MF_GRAYED
			.if FProjectInProgress==TARGET_ONLY
				invoke EnableMenuItem,hMenu,IDM_NEWIMPORT,MF_ENABLED
			.else
				invoke EnableMenuItem,hMenu,IDM_NEWIMPORT,MF_GRAYED
			.endif
		.endif
		invoke EnableMenuItem,hMenu,IDM_NEWTARGET,MF_ENABLED
	.elseif ax==4	; help
		.if FProjectInProgress!=NO_PROJECT && FProjectInProgress!=TARGET_ONLY
			invoke EnableMenuItem,hMenu,IDM_PROJECTINFO,MF_ENABLED
		.else
			invoke EnableMenuItem,hMenu,IDM_PROJECTINFO,MF_GRAYED
		.endif
	.endif
	ret
ManageMenuState endp

BrowseAndFillEditBox PROC hWnd:DWORD,EditID:DWORD
	LOCAL buffer[256]:byte
	mov ofn.lStructSize,SIZEOF ofn
	push hWnd
	pop  ofn.hWndOwner
	push hInstance
	pop  ofn.hInstance
	mov  ofn.lpstrFilter, OFFSET FilterString
	mov  ofn.lpstrFile, OFFSET FileName
	mov  ofn.nMaxFile,sizeof FileName
	mov ofn.Flags,OFN_LONGNAMES or OFN_NOCHANGEDIR or\
                		 OFN_EXPLORER or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
	invoke GetOpenFileName, ADDR ofn
	.if eax==TRUE
		invoke SetDlgItemText,hWnd,EditID,addr FileName
	.endif	
	ret
BrowseAndFillEditBox ENDP


CheckIfValidPE proc uses esi lpProgName:DWORD
	LOCAL hTemp:DWORD
	LOCAL hTempMapping:DWORD
	LOCAL pTempMapping:DWORD
	LOCAL filesize:DWORD
	invoke CreateFile,lpProgName,GENERIC_READ+GENERIC_WRITE,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
	.if eax!=INVALID_HANDLE_VALUE
		mov hTemp,eax
		invoke GetFileSize,hTemp,NULL
		mov filesize,eax
		mov edx,sizeof IMAGE_DOS_HEADER
		add edx,sizeof IMAGE_NT_HEADERS
		.if eax<edx		; if file size is less than combined size of dos and pe header
NoPE:
			invoke CloseHandle,hTemp
			mov eax,FALSE
			ret
		.endif
		;-----------------------------------------------------
		; here it's safe to read the dos header
		;-----------------------------------------------------
		invoke CreateFileMapping,hTemp,NULL,PAGE_READWRITE,NULL,NULL,NULL
		.if eax!=NULL
			mov hTempMapping,eax
			invoke MapViewOfFile,hTempMapping,FILE_MAP_READ+FILE_MAP_WRITE,NULL,NULL,NULL
			.if eax!=NULL
				mov pTempMapping,eax
				mov esi,eax
				.if word ptr [esi]==IMAGE_DOS_SIGNATURE
					assume esi:ptr IMAGE_DOS_HEADER
					mov eax,[esi].e_lfanew					
					assume esi:nothing
					add esi,eax	; esi now points to the pe header
					.if eax>=filesize
						invoke UnmapViewOfFile,pTempMapping
						invoke CloseHandle,hTempMapping
						jmp NoPE
					.endif
					.if word ptr [esi]=="EP"
						;-----------------------------
						; The file is a valid pe file
						;-----------------------------
						invoke FillPEInfo,pTempMapping,esi
					.else
UnmapCloseAndExit:
						invoke UnmapViewOfFile,pTempMapping
						invoke CloseHandle,hTempMapping
						invoke CloseHandle,hTemp
						mov eax,FALSE
						ret
					.endif
				.else
					jmp UnmapCloseAndExit
				.endif
			.else
				invoke GetLastError
				push eax
				invoke CloseHandle,hTempMapping
				invoke CloseHandle,hTemp
				pop eax
				invoke SetLastError,eax
				mov eax,INVALID_HANDLE_VALUE
				ret
			.endif
		.else
			invoke GetLastError
			push eax
			invoke CloseHandle,hTemp
			pop eax
			invoke SetLastError,eax
			mov eax,INVALID_HANDLE_VALUE
			ret
		.endif
		.if FPatch==TRUE || FProjectInProgress==TARGET_ONLY
			invoke UnmapViewOfFile,pMapping
			invoke CloseHandle,hMapping
			invoke CloseHandle,hFile
		.endif
		push pTempMapping
		pop pMapping
		push hTempMapping
		pop hMapping
		push hTemp
		pop hFile
		mov FPatch,TRUE
		mov eax,TRUE
	.endif
	ret
CheckIfValidPE endp

GetAppDir proc uses edi esi CmdLine:DWORD,AppDir:DWORD
	mov edi,CmdLine
	invoke lstrlen,edi
	.if eax!=0
		std
		mov ecx,eax
		add edi,eax
		mov al,"\"
		dec edi
		repne scasb
		cld
		inc ecx
		mov esi,CmdLine
		.if byte ptr [esi]=='"'
			dec ecx
			inc esi
		.endif
		mov edi,AppDir
		rep movsb
		mov byte ptr [edi],0
		mov eax,1
	.endif
	ret
GetAppDir endp

OpenMainINI proc
	LOCAL hFileTemp:DWORD
	LOCAL bytesWritten:DWORD
	LOCAL ResourceHandle:DWORD
	LOCAL pData:DWORD
	LOCAL ModuleName[256]:BYTE
	invoke GetModuleFileName,hInstance,addr ModuleName,256
	invoke GetAppDir,addr ModuleName,addr ProgramDir
	invoke lstrcpy,addr FullININame,addr ProgramDir
	invoke lstrcat,addr FullININame,addr MainININame
	invoke CreateFile,addr FullININame,0,FILE_SHARE_READ+FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
	.if eax==INVALID_HANDLE_VALUE
		invoke CreateFile,addr FullININame,GENERIC_READ+GENERIC_WRITE,FILE_SHARE_READ+FILE_SHARE_WRITE,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
		mov hFileTemp,eax
		invoke FindResource,hInstance,addr DefaultINI,addr DefaultINI
		mov ResourceHandle,eax
		invoke LoadResource,hInstance,ResourceHandle
		invoke LockResource,eax
		mov pData,eax
		invoke SizeofResource,hInstance,ResourceHandle
		mov edx,eax
		invoke WriteFile,hFileTemp,pData,edx,addr bytesWritten,NULL
		invoke CloseHandle,hFileTemp
		invoke WritePrivateProfileString,addr MainINISection,addr MainINIKeyDefProjDir,addr ProgramDir,addr FullININame
	.else
		invoke CloseHandle,eax
	.endif
	ret
OpenMainINI endp

NewProjectProc PROC hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[512]:BYTE
	LOCAL hFileTemp:DWORD
	LOCAL hResource:DWORD
	LOCAL bytestoWrite:DWORD
	.if uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,eax
		shr edx,16
		.if ax==IDC_CANCELPROJECT
			.if dx==BN_CLICKED
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		.elseif ax==IDC_BROWSEPROG
			.if dx==BN_CLICKED
				invoke BrowseAndFillEditBox,hDlg,IDC_PATCHEDPROG
			.endif
		.elseif ax==IDC_OKPROJECT
			.if dx==BN_CLICKED
				invoke GetDlgItemText,hDlg,IDC_PROJECTNAME,addr ProjectName,128
				invoke lstrlen,addr ProjectName
				.if eax==0
					invoke MessageBox,NULL,addr ErrorNoProjectName,addr AppName,MB_OK+MB_ICONERROR
				.else
					invoke GetPrivateProfileString,addr MainINISection,addr MainINIKeyDefProjDir,addr buffer,addr buffer,512,addr FullININame
					invoke lstrcpy,addr ProjectDir,addr buffer
					invoke lstrcat,addr ProjectDir,addr ProjectName
					invoke CreateDirectory,addr ProjectDir,NULL
					.if eax!=NULL						
						invoke GetDlgItemText,hDlg,IDC_PATCHEDPROG,addr buffer,256
						invoke lstrlen,addr buffer
						.if eax==0
							.if FProjectInProgress==TARGET_ONLY
								invoke UnmapViewOfFile,pMapping
								invoke CloseHandle,hMapping
								invoke CloseHandle,hFile
							.endif
							mov FProjectInProgress,PROJECT_OPENED
							call CreateFileNames
							invoke SetCurrentDirectory,addr ProjectDir
							invoke SendMessage,hDlg,WM_CLOSE,0,0
						.else
							invoke CheckIfValidPE,addr buffer
							.if eax==TRUE
								invoke SetCurrentDirectory,addr ProjectDir
								mov FProjectInProgress,PROJECT_OPENED
								call CreateFileNames
								invoke lstrcpy,addr TargetName,addr buffer
								invoke SendMessage,hDlg,WM_CLOSE,0,0
							.elseif eax==FALSE
								invoke RemoveDirectory,addr ProjectDir
								invoke MessageBox,hDlg,addr ErrorNotValidPEFile,addr AppName,MB_OK+MB_ICONERROR
								invoke GetDlgItem,hDlg,IDC_PATCHEDPROG
								invoke SetFocus,eax
								mov eax,TRUE
								ret
							.elseif eax==INVALID_HANDLE_VALUE
								invoke ShowErrorMessage,hDlg
								invoke RemoveDirectory,addr ProjectDir
								invoke GetDlgItem,hDlg,IDC_PATCHEDPROG
								invoke SetFocus,eax								
								mov eax,TRUE
								ret
							.endif
						.endif
						;-----------------------------------------
						; Write default project ini
						;-----------------------------------------
						invoke lstrcpy,addr FullProjININame,addr ProjectDir
						push edi
						invoke lstrlen,addr FullProjININame
						mov edi,offset FullProjININame
						add edi,eax
						mov byte ptr [edi],"\"
						mov byte ptr [edi+1],0
						invoke lstrcat,addr FullProjININame,addr ProjectName
						invoke lstrlen,addr FullProjININame
						lea edi,FullProjININame
						add edi,eax
						mov byte ptr [edi],"."
						mov byte ptr [edi+1],"i"
						mov byte ptr [edi+2],"n"
						mov byte ptr [edi+3],"i"
						mov byte ptr [edi+4],0
						pop edi
						invoke CreateFile,addr FullProjININame,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
						mov hFileTemp,eax
						invoke FindResource,hInstance,ID_PATCHINI,addr DefaultINI
						mov hResource,eax
						invoke LoadResource,hInstance,eax
						invoke LockResource,eax
						push eax
						invoke SizeofResource,hInstance,hResource
						pop edx
						mov ecx,eax
						invoke WriteFile,hFileTemp,edx,ecx,addr bytestoWrite,NULL
						invoke CloseHandle,hFileTemp
						invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyTarget,addr buffer,addr FullProjININame
						;------------------------------------------
						; Fill info into variables
						;------------------------------------------
						invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeySnippetVA,addr buffer,addr buffer,256,addr FullProjININame
						invoke HexString2Dword,addr buffer
						mov SnippetVA,eax
						invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyPatchOption,addr buffer,addr buffer,256,addr FullProjININame
						invoke HexString2Dword,addr buffer
						mov PatchOption,eax
						invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyRedirect,addr buffer,addr buffer,256,addr FullProjININame
						invoke HexString2Dword,addr buffer
						mov RedirectOption,eax
						invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyRedirectVA,addr buffer,addr buffer,256,addr FullProjININame
						invoke HexString2Dword,addr buffer
						mov PatchVA,eax
						invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyReturn,addr buffer,addr buffer,256,addr FullProjININame
						invoke HexString2Dword,addr buffer
						mov ReturnOption,eax
						invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyReturnVA,addr buffer,addr buffer,256,addr FullProjININame
						invoke HexString2Dword,addr buffer
						mov ReturnVA,eax
						invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyRestore,addr buffer,addr buffer,256,addr FullProjININame
						invoke HexString2Dword,addr buffer
						mov RestoreOption,eax
						;------------------------------------------
						; Enable the richedit control
						;------------------------------------------
						invoke GetParent,hDlg
						push eax
						invoke SetDlgItemText,eax,IDC_CODEBOX,addr ProjectName
						pop eax
						invoke GetDlgItem,eax,IDC_CODEEDIT
						push eax
						invoke EnableWindow,eax,TRUE
						pop eax
						invoke SetFocus,eax
						invoke GetParent,hDlg
						invoke GetDlgItem,eax,IDC_ASSEMBLE
						invoke EnableWindow,eax,TRUE
					.else
						invoke ShowErrorMessage,hDlg
						invoke GetDlgItem,hDlg,IDC_PROJECTNAME
						invoke SetFocus,eax
					.endif
				.endif
			.endif
		.endif
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
NewProjectProc ENDP

OptionProc PROC hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[256]:BYTE
	.if uMsg==WM_INITDIALOG
		invoke GetPrivateProfileString,addr MainINISection,addr MainINIKeyCurASM,addr buffer,addr buffer,256,addr FullININame
		invoke lstrcmp,addr buffer,addr MASM
		mov CurrentASM,eax
		.if eax==0
			invoke SendDlgItemMessage,hDlg,IDC_MASM,BM_SETCHECK,BST_CHECKED,0
			invoke GetPrivateProfileString,addr MASM,addr MainINIKeyASM,addr buffer,addr buffer,256,addr FullININame
			invoke SetDlgItemText,hDlg,IDC_ASSEMBLER,addr buffer
			invoke GetPrivateProfileString,addr MASM,addr MainINIKeyLink,addr buffer,addr buffer,256,addr FullININame
			invoke SetDlgItemText,hDlg,IDC_LINKER,addr buffer
		.else
			invoke SendDlgItemMessage,hDlg,IDC_TASM,BM_SETCHECK,BST_CHECKED,0
			invoke GetPrivateProfileString,addr TASM,addr MainINIKeyASM,addr buffer,addr buffer,256,addr FullININame
			invoke SetDlgItemText,hDlg,IDC_ASSEMBLER,addr buffer
			invoke GetPrivateProfileString,addr TASM,addr MainINIKeyLink,addr buffer,addr buffer,256,addr FullININame
			invoke SetDlgItemText,hDlg,IDC_LINKER,addr buffer
		.endif
		invoke GetPrivateProfileString,addr MainINISection,addr MainINIKeyDefProjDir,addr buffer,addr buffer,256,addr FullININame
		invoke SetDlgItemText,hDlg,IDC_PARENTDIR,addr buffer
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if ax==IDC_CANCELOPTION
			.if dx==BN_CLICKED
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		.elseif ax==IDC_MASM
			.if dx==BN_CLICKED
				invoke GetPrivateProfileString,addr MASM,addr MainINIKeyASM,addr buffer,addr buffer,256,addr FullININame
				invoke SetDlgItemText,hDlg,IDC_ASSEMBLER,addr buffer
				invoke GetPrivateProfileString,addr MASM,addr MainINIKeyLink,addr buffer,addr buffer,256,addr FullININame
				invoke SetDlgItemText,hDlg,IDC_LINKER,addr buffer
			.endif
		.elseif ax==IDC_TASM
			.if dx==BN_CLICKED
				invoke GetPrivateProfileString,addr TASM,addr MainINIKeyASM,addr buffer,addr buffer,256,addr FullININame
				invoke SetDlgItemText,hDlg,IDC_ASSEMBLER,addr buffer
				invoke GetPrivateProfileString,addr TASM,addr MainINIKeyLink,addr buffer,addr buffer,256,addr FullININame
				invoke SetDlgItemText,hDlg,IDC_LINKER,addr buffer
			.endif
		.elseif ax==IDC_OKOPTION
			.if dx==BN_CLICKED
				invoke SendDlgItemMessage,hDlg,IDC_MASM,BM_GETCHECK,0,0
				.if eax==BST_CHECKED
					mov CurrentASM,0
					invoke WritePrivateProfileString,addr MainINISection,addr MainINIKeyCurASM,addr MASM,addr FullININame
					invoke GetDlgItemText,hDlg,IDC_ASSEMBLER,addr buffer,256
					invoke WritePrivateProfileString,addr MASM,addr MainINIKeyASM,addr buffer,addr FullININame
					invoke GetDlgItemText,hDlg,IDC_LINKER,addr buffer,256
					invoke WritePrivateProfileString,addr MASM,addr MainINIKeyLink,addr buffer,addr FullININame
				.else
					mov CurrentASM,1
					invoke WritePrivateProfileString,addr MainINISection,addr MainINIKeyCurASM,addr TASM,addr FullININame
					invoke GetDlgItemText,hDlg,IDC_ASSEMBLER,addr buffer,256
					invoke WritePrivateProfileString,addr TASM,addr MainINIKeyASM,addr buffer,addr FullININame
					invoke GetDlgItemText,hDlg,IDC_LINKER,addr buffer,256
					invoke WritePrivateProfileString,addr TASM,addr MainINIKeyLink,addr buffer,addr FullININame
				.endif
				invoke GetDlgItemText,hDlg,IDC_PARENTDIR,addr buffer,256
				invoke WritePrivateProfileString,addr MainINISection,addr MainINIKeyDefProjDir,addr buffer,addr FullININame
				invoke MessageBox,hDlg,addr DataSaved,addr AppName,MB_OK+MB_ICONINFORMATION
;				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		.elseif ax==IDC_DEFAULTOPTION
			.if dx==BN_CLICKED
				invoke SendDlgItemMessage,hDlg,IDC_MASM,BM_GETCHECK,0,0
				.if eax==BST_CHECKED
					invoke SetDlgItemText,hDlg,IDC_ASSEMBLER ,addr ASM_MASM
					invoke SetDlgItemText,hDlg,IDC_LINKER,addr LINK_MASM
				.else
					invoke SetDlgItemText,hDlg,IDC_ASSEMBLER ,addr ASM_TASM
					invoke SetDlgItemText,hDlg,IDC_LINKER,addr LINK_TASM
				.endif
			.endif
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
OptionProc endp

EditProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	.if uMsg==WM_CHAR
		mov eax,wParam
		.if (al>="0" && al<="9") || (al>="a" && al<="f") || (al>="A" && al<="F") || al==08
			invoke CallWindowProc,OldWinProc,hDlg,uMsg,wParam,lParam
			ret
		.endif
	.else
		invoke CallWindowProc,OldWinProc,hDlg,uMsg,wParam,lParam
		ret
	.endif
	xor eax,eax
	ret
EditProc endp

PatchOptionProc PROC hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[256]:byte
	LOCAL Result:DWORD
	.if uMsg==WM_INITDIALOG
		;-------------------------------------
		; Limit input to 8 characters
		;-------------------------------------
		invoke SendDlgItemMessage,hDlg,IDC_SNIPPETVA,EM_LIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_PATCHVA,EM_LIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_RETURNVA,EM_LIMITTEXT,8,0
		;------------------------------------------------------------
		; Subclass them to force user to input only hex numbers
		;------------------------------------------------------------
		invoke GetDlgItem,hDlg,IDC_SNIPPETVA
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		mov OldWinProc,eax
		invoke GetDlgItem,hDlg,IDC_PATCHVA
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_RETURNVA
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		;---------------------------------------
		; Read the snippet VA
		;----------------------------------------
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeySnippetVA,addr buffer,addr buffer,256,addr FullProjININame
		invoke HexString2Dword,addr buffer
		mov SnippetVA,eax			; store the snippet VA
		invoke SetDlgItemText,hDlg,IDC_SNIPPETVA,addr buffer
		;----------------------------------------
		; Read the CPU model
		;----------------------------------------
		invoke RtlFillMemory,addr buffer,256,0
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyModel,addr buffer,addr buffer,256,addr FullProjININame
		invoke lstrlen,addr buffer
		.if eax==0
			invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyModel,addr DefaultCPU,addr FullProjININame
			invoke SetDlgItemText,hDlg,IDC_MODEL,addr DefaultCPU
		.else
			invoke SetDlgItemText,hDlg,IDC_MODEL,addr buffer
		.endif
		.if FPatch==TRUE		; if patched target is specified
			invoke GetDlgItem,hDlg,IDC_PATCHGROUP
			invoke EnableWindow,eax,TRUE
			invoke GetDlgItem,hDlg,IDC_NOPATCH
			invoke EnableWindow,eax,TRUE
			invoke GetDlgItem,hDlg,IDC_PATCHNEW
			invoke EnableWindow,eax,TRUE
			invoke GetDlgItem,hDlg,IDC_PATCHEXISTING
			invoke EnableWindow,eax,TRUE
			;----------------------------------------
			; Check patching option
			;----------------------------------------
			invoke GetPrivateProfileInt,addr MainINISection,addr ProjINIKeyPatchOption,0,addr FullProjININame
			mov PatchOption,eax		; store patch option
			push eax
			.if eax==0		; If no patching
				invoke SendDlgItemMessage,hDlg,IDC_NOPATCH,BM_SETCHECK,BST_CHECKED,0
			.elseif eax==1	; If creating a new section for the snippet
				invoke SendDlgItemMessage,hDlg,IDC_PATCHNEW,BM_SETCHECK,BST_CHECKED,0
			.elseif eax==2	; If patch into an existing section
				invoke SendDlgItemMessage,hDlg,IDC_PATCHEXISTING,BM_SETCHECK,BST_CHECKED,0
			.endif
			pop eax
			.if eax>0	; if patching is specified, enable other controls
				invoke EnableControls,hDlg
			.endif
			;-----------------------------------------------
			; Check the redirect group
			;-----------------------------------------------
			invoke GetPrivateProfileInt,addr MainINISection,addr ProjINIKeyRedirect,0,addr FullProjININame
			mov RedirectOption,eax		; store redirect option
			.if eax==0		; no redirection
				invoke SendDlgItemMessage,hDlg,IDC_NOREDIRECT,BM_SETCHECK,BST_CHECKED,0
			.elseif eax==1	; redirect from EPRVA
				invoke SendDlgItemMessage,hDlg,IDC_EPRVA,BM_SETCHECK,BST_CHECKED,0
			.elseif eax==2	; redirect from somewhere in the code
				invoke SendDlgItemMessage,hDlg,IDC_REDIRECTCODE,BM_SETCHECK,BST_CHECKED,0
				invoke EnablePatchVA,hDlg
				invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyRedirectVA ,addr buffer,addr buffer,256,addr FullProjININame
				invoke HexString2Dword,addr buffer
				mov PatchVA,eax		; store patch VA
				invoke SetDlgItemText,hDlg,IDC_PATCHVA,addr buffer
			.elseif eax==3	; redirect from a call/jump
				invoke SendDlgItemMessage,hDlg,IDC_REDIRECTCALL,BM_SETCHECK,BST_CHECKED,0
				invoke EnablePatchVA,hDlg
				invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyRedirectVA ,addr buffer,addr buffer,256,addr FullProjININame
				invoke HexString2Dword,addr buffer
				mov PatchVA,eax		; store patch VA
				invoke SetDlgItemText,hDlg,IDC_PATCHVA,addr buffer				
			.endif
			;----------------------------------------
			; Check return group
			;----------------------------------------
			invoke GetPrivateProfileInt,addr MainINISection,addr ProjINIKeyReturn,0,addr FullProjININame
			mov ReturnOption,eax		; store return option
			.if eax==0		; if no return
				invoke SendDlgItemMessage,hDlg,IDC_NORETURN,BM_SETCHECK,BST_CHECKED,0
			.else
				invoke SendDlgItemMessage,hDlg,IDC_RETURN,BM_SETCHECK,BST_CHECKED,0
				invoke EnableReturnVA,hDlg
				invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyReturnVA ,addr buffer,addr buffer,256,addr FullProjININame
				invoke HexString2Dword,addr buffer
				mov ReturnVA,eax		; store return VA
				invoke SetDlgItemText,hDlg,IDC_RETURNVA,addr buffer
			.endif
			invoke GetPrivateProfileInt,addr MainINISection,addr ProjINIKeyRestore,0,addr FullProjININame
			mov RestoreOption,eax		; store restore option
			.if eax==0
				invoke SendDlgItemMessage,hDlg,IDC_RESTORECODE,BM_SETCHECK,BST_UNCHECKED,0
			.else
				invoke SendDlgItemMessage,hDlg,IDC_RESTORECODE,BM_SETCHECK,BST_CHECKED,0
			.endif
		.endif
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if ax==IDC_CANCELPATCH
			.if dx==BN_CLICKED
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		;---------------------------------------------------------------------------
		; The user chooses to save the current patch options to the ini file
		;---------------------------------------------------------------------------
		.elseif ax==IDC_OKPATCH
			.if dx==BN_CLICKED
				;--------------------------------------
				; Check CPU model
				;--------------------------------------
				invoke GetDlgItemText,hDlg,IDC_MODEL,addr buffer,512
				invoke lstrlen,addr buffer
				.if eax==0
					invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyModel,addr DefaultCPU,addr FullProjININame
				.else
					invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyModel,addr buffer,addr FullProjININame
				.endif
				;--------------------------------------
				; Check snippet VA
				;--------------------------------------
				invoke GetDlgItemText,hDlg,IDC_SNIPPETVA,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov SnippetVA,eax		; store new snippet VA
				;---------------------------------------------------------------------
				; If a target is specified, we must check if the snippet va is valid 
				;---------------------------------------------------------------------
				.if FPatch==TRUE
					invoke SendDlgItemMessage,hDlg,IDC_NOPATCH,BM_GETCHECK,0,0
					.if eax!=BST_CHECKED
						invoke SendDlgItemMessage,hDlg,IDC_PATCHEXISTING,BM_GETCHECK,0,0
						.if eax==BST_CHECKED
							invoke HexString2Dword,addr buffer
							mov edx,pPEHeader
							assume edx:ptr IMAGE_NT_HEADERS
							mov ecx,[edx].OptionalHeader.ImageBase
							.if eax<ecx
								invoke MessageBox,hDlg,addr ErrorSnippetOutOfRange,addr AppName,MB_OK+MB_ICONERROR
								invoke GetDlgItem,hDlg,IDC_SNIPPETVA
								invoke SetFocus,eax
								mov eax,TRUE
								ret
							.else
								invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeySnippetVA,addr buffer,addr FullProjININame
							.endif
						.else
							invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeySnippetVA,addr buffer,addr FullProjININame
						.endif
					.else
						invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeySnippetVA,addr buffer,addr FullProjININame
					.endif
				.else
					invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeySnippetVA,addr buffer,addr FullProjININame
				.endif
				;--------------------------------------------------------------------------
				; We will process the redirect and return groups if and only if there is
				; a target.
				;--------------------------------------------------------------------------
				.if FPatch==TRUE
					;----------------------------------------------
					; Check if patching 
					;----------------------------------------------
					invoke SendDlgItemMessage,hDlg,IDC_NOPATCH,BM_GETCHECK,0,0
					lea edx,buffer
					push eax
					.if eax==BST_CHECKED
						mov PatchOption,0
						mov byte ptr [edx],"0"
						push edx
						mov byte ptr [edx+1],0
						invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyReturn,addr buffer,addr FullProjININame
						mov ReturnOption,0
						invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyReturnVA,addr buffer,addr FullProjININame
						mov ReturnVA,0
						invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyRestore,addr buffer,addr FullProjININame
						mov RestoreOption,0
						invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyRedirect,addr buffer,addr FullProjININame
						mov RedirectOption,0
						invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyRedirectVA,addr buffer,addr FullProjININame
						mov PatchVA,0
						pop edx
					.else
						invoke SendDlgItemMessage,hDlg,IDC_PATCHNEW,BM_GETCHECK,0,0
						lea edx,buffer
						.if eax==BST_CHECKED
							mov PatchOption,1
							mov byte ptr [edx],"1"
						.else
							mov PatchOption,2
							mov byte ptr [edx],"2"
						.endif
					.endif
					mov byte ptr [edx+1],0
					invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyPatchOption,addr buffer,addr FullProjININame
					pop eax
					;------------------------------------------------------------------------------------
					; If the user chooses some patch option, we must process redirect and return options
					;-------------------------------------------------------------------------------------
					.if eax!=BST_CHECKED
						;----------------------------------------------
						; Check patch va
						;----------------------------------------------
						invoke SendDlgItemMessage,hDlg,IDC_REDIRECTCODE,BM_GETCHECK,0,0
						push eax
						invoke SendDlgItemMessage,hDlg,IDC_REDIRECTCALL,BM_GETCHECK,0,0
						mov edx,eax
						pop eax
						.if eax==BST_CHECKED || edx==BST_CHECKED
							invoke GetDlgItemText,hDlg,IDC_PATCHVA,addr buffer,256
							invoke lstrlen,addr buffer
							.if eax==0
								invoke MessageBox,hDlg,addr ErrorNoPatchVA,addr AppName,MB_OK+MB_ICONERROR
								invoke GetDlgItem,hDlg,IDC_PATCHVA
								invoke SetFocus,eax
								mov eax,TRUE
								ret
							.else
								invoke HexString2Dword,addr buffer
								mov Result,eax
								mov edx,pPEHeader
								assume edx:ptr IMAGE_NT_HEADERS
								mov ecx,[edx].OptionalHeader.ImageBase
								.if eax<ecx
									invoke MessageBox,hDlg,addr ErrorPatchValueOutOfRange,addr AppName,MB_OK+MB_ICONERROR
									invoke GetDlgItem,hDlg,IDC_PATCHVA
									invoke SetFocus,eax
									mov eax,TRUE
									ret
								.else
									push Result
									pop PatchVA
									;-------------------------------------------------------------------------------------------
									; the patch VA is in the image. Now if the option is to redirect control from a call or jump
									; we must verify if the va points to actual call/jmp instruction
									;--------------------------------------------------------------------------------------------
									invoke SendDlgItemMessage,hDlg,IDC_REDIRECTCALL,BM_GETCHECK,0,0
									.if eax==BST_CHECKED
										invoke AddressToOffset,pMapping,PatchVA
										add eax,pMapping
										.if byte ptr [eax]==0E8h || (byte ptr [eax]==0FFh && (byte ptr [eax]==025h || byte ptr [eax]==15h))												
										.else
											invoke MessageBox,hDlg,addr NoCallOrJump,addr AppName,MB_OK+MB_ICONERROR
											invoke GetDlgItem,hDlg,IDC_PATCHVA
											invoke SetFocus,eax
											mov eax,TRUE
											ret
										.endif
									.endif
									;--------------------------------------
									; Store the patch VA in the ini file
									;---------------------------------------
									invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyRedirectVA,addr buffer,addr FullProjININame
									invoke SendDlgItemMessage,hDlg,IDC_REDIRECTCODE,BM_GETCHECK,0,0
									lea edx,buffer
									.if eax==BST_CHECKED
										mov byte ptr [edx],"2"
										mov RedirectOption,2
									.else
										mov byte ptr [edx],"3"
										mov RedirectOption,3
									.endif
									mov byte ptr [edx+1],0
									;--------------------------------------
									; Store the redirect option
									;--------------------------------------
									invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyRedirect,addr buffer,addr FullProjININame
									;------------------------------------------------------------
									; when the redirect from code/call is specified, we must
									; check if the user wants to restore the original instructions
									;-------------------------------------------------------------
									invoke SendDlgItemMessage,hDlg,IDC_RESTORECODE,BM_GETCHECK,0,0
									lea edx,buffer
									.if eax==BST_CHECKED
										mov byte ptr [edx],"1"
										mov RestoreOption,1
									.else
										mov byte ptr [edx],"0"
										mov RestoreOption,0
									.endif
									mov byte ptr [edx+1],0
									;-----------------------------------
									; Store the restore option in ini file
									;--------------------------------------
									invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyRestore,addr buffer,addr FullProjININame
								.endif
							.endif
						.else
							invoke SendDlgItemMessage,hDlg,IDC_NOREDIRECT,BM_GETCHECK,0,0
							lea edx,buffer
							.if eax==BST_CHECKED
								mov byte ptr [edx],"0"
								mov RedirectOption,0
							.else
								mov byte ptr [edx],"1"
								mov RedirectOption,1
							.endif
							mov byte ptr [edx+1],0
							invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyRedirect,addr buffer,addr FullProjININame
						.endif
						;------------------------------------
						; Check return VA
						;------------------------------------
						invoke SendDlgItemMessage,hDlg,IDC_RETURN,BM_GETCHECK,0,0
						.if eax==BST_CHECKED
							;------------------------------------------------------
							; To prevent error in the case, the user assembles the
							; snippet BEFORE selecting this option, we must check 
							; if this option is already chosen before this.
							; If it is not, we MUST delete the exe file. Because
							; the return code is added during AssembleCode proc,
							; if we don't delete it, this option will not be in
							; effect and the target program will crash.
							;------------------------------------------------------
							invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyReturn,addr buffer,addr buffer,256, addr FullProjININame
							.if byte ptr [buffer]=="0"	; if the previous selection is NOT to return, we must delete the exe file
								invoke GetCurrentDirectory,256,addr buffer
								invoke SetCurrentDirectory,addr ProjectDir
								invoke DeleteFile,addr EXEName
								invoke SetCurrentDirectory,addr buffer
								mov FProjectInProgress,PROJECT_OPENED
							.endif
							;-----------------------------------------------------
							; Now check the return VA
							;-----------------------------------------------------
							invoke GetDlgItemText,hDlg,IDC_RETURNVA,addr buffer,256
							invoke lstrlen,addr buffer
							.if eax==0
								invoke MessageBox,hDlg,addr ErrorNoReturnVA,addr AppName,MB_OK+MB_ICONERROR
								invoke GetDlgItem,hDlg,IDC_RETURN
								invoke SetFocus,eax
								mov eax,TRUE
								ret
							.else
								invoke HexString2Dword,addr buffer
								mov Result,eax
								mov edx,pPEHeader
								assume edx:ptr IMAGE_NT_HEADERS
								mov ecx,[edx].OptionalHeader.ImageBase
								.if eax<ecx
									invoke MessageBox,hDlg,addr ErrorReturnValueOutOfRange,addr AppName,MB_OK+MB_ICONERROR
									invoke GetDlgItem,hDlg,IDC_RETURNVA
									invoke SetFocus,eax
									mov eax,TRUE
									ret
								.else
									push Result
									pop ReturnVA
									invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyReturnVA,addr buffer,addr FullProjININame
									lea edx,buffer
									mov byte ptr [edx],"1"
									mov byte ptr [edx+1],0
									invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyReturn,addr buffer,addr FullProjININame
									mov ReturnOption,1
								.endif
							.endif
						.else
							lea edx,buffer
							mov byte ptr [edx],"0"
							mov byte ptr [edx+1],0
							invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyReturn,addr buffer,addr FullProjININame
							mov ReturnOption,0
						.endif
					.endif
				.endif
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		.elseif ax==IDC_NOPATCH
			invoke DisableControls,hDlg
		.elseif ax==IDC_PATCHNEW
			invoke EnableControls,hDlg
		.elseif ax==IDC_PATCHEXISTING
			invoke EnableControls,hDlg
		.elseif ax==IDC_NOREDIRECT
			invoke DisablePatchVA,hDlg
		.elseif ax==IDC_EPRVA
			invoke DisablePatchVA,hDlg
		.elseif ax==IDC_REDIRECTCODE
			invoke EnablePatchVA,hDlg
		.elseif ax==IDC_REDIRECTCALL
			invoke EnablePatchVA,hDlg
		.elseif ax==IDC_NORETURN
			invoke DisableReturnVA,hDlg
		.elseif ax==IDC_RETURN
			invoke EnableReturnVA,hDlg
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
PatchOptionProc endp

SetTitle proc uses edi esi ecx hDlg:DWORD
	LOCAL buffer[1024]:byte
	invoke GetWindowText,hDlg,addr buffer,1024
	invoke lstrcat,addr buffer,addr LeadBracket
	invoke ParseName,addr TargetName
	invoke lstrcat,addr buffer,eax
	invoke lstrcat,addr buffer,addr CloseBracket
	invoke SetWindowText,hDlg,addr buffer
	ret
SetTitle endp

PEHeaderProc proc uses edi hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[1024]:byte
	.if uMsg==WM_INITDIALOG
		mov edi,pPEHeader
		assume edi:ptr IMAGE_NT_HEADERS
		invoke SetTitle,hDlg
		;------------------------------------------------
		; Limit file characteristics edit box to 4 digits
		;-------------------------------------------------
		invoke SendDlgItemMessage,hDlg,IDC_FILECHARAC,EM_SETLIMITTEXT,4,0
		invoke SendDlgItemMessage,hDlg,IDC_MAJORSUBSYSTEM,EM_SETLIMITTEXT,4,0
		invoke SendDlgItemMessage,hDlg,IDC_MINORSUBSYSTEM,EM_SETLIMITTEXT,4,0
		;--------------------------------------
		; Limit text to 8 digits
		;--------------------------------------
		invoke SendDlgItemMessage,hDlg,IDC_CHECKSUM,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_IMAGEBASE,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_IMAGESIZE,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_EPRVABOX,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_CODEBASE,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_DATABASE,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_SECTIONALIGN,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_FILEALIGN,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_UNINITDATA,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_INITDATA,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_CODESIZE,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_NUMSEC,EM_SETLIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_HEADERSIZE,EM_SETLIMITTEXT,8,0
		;--------------------------------
		; Subclass all edit controls
		;--------------------------------
		invoke GetDlgItem,hDlg,IDC_IMAGEBASE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		mov OldWinProc,eax
		invoke GetDlgItem,hDlg,IDC_IMAGESIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_EPRVABOX
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_CODEBASE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_DATABASE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_SECTIONALIGN
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_FILEALIGN
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_UNINITDATA
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_INITDATA
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_CODESIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_NUMSEC
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_HEADERSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_FILECHARAC
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_MAJORSUBSYSTEM
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_MINORSUBSYSTEM
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_CHECKSUM
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		;---------------------------------------
		; Fill machine and subsystem comboboxes
		;---------------------------------------
		invoke FillCombo,hDlg
		;---------------------------------
		; Set file characteristics
		;---------------------------------
		mov dx,[edi].FileHeader.Characteristics
		movzx edx,dx
		invoke wsprintf,addr buffer,addr HalfSectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_FILECHARAC,addr buffer
		;---------------------------------
		; Major subsystem
		;--------------------------------
		mov dx,[edi].OptionalHeader.MajorSubsystemVersion
		movzx edx,dx
		invoke wsprintf,addr buffer,addr HalfSectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_MAJORSUBSYSTEM,addr buffer
		;---------------------------------
		; Minor subsystem
		;--------------------------------
		mov dx,[edi].OptionalHeader.MinorSubsystemVersion
		movzx edx,dx
		invoke wsprintf,addr buffer,addr HalfSectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_MINORSUBSYSTEM,addr buffer
		;---------------------------------
		; Set checksum
		;---------------------------------
		mov edx,[edi].OptionalHeader.CheckSum
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_CHECKSUM,addr buffer
		;---------------------------------
		; Set ImageBase
		;---------------------------------
		mov edx,[edi].OptionalHeader.ImageBase
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_IMAGEBASE,addr buffer
		;---------------------------------
		; Image size
		;---------------------------------
		mov edx,[edi].OptionalHeader.SizeOfImage
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_IMAGESIZE,addr buffer
		;---------------------------------
		; EPRVA
		;---------------------------------
		mov edx,[edi].OptionalHeader.AddressOfEntryPoint
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_EPRVABOX,addr buffer
		;------------------------------
		; Base of code
		;------------------------------
		mov edx,[edi].OptionalHeader.BaseOfCode
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_CODEBASE,addr buffer
		;----------------------------
		; Base of data
		;----------------------------
		mov edx,[edi].OptionalHeader.BaseOfData
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_DATABASE,addr buffer
		;-----------------------------
		; Section alignment
		;-----------------------------
		mov edx,[edi].OptionalHeader.SectionAlignment
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_SECTIONALIGN,addr buffer
		;---------------------------
		; File alignment
		;--------------------------
		mov edx,[edi].OptionalHeader.FileAlignment
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_FILEALIGN,addr buffer
		;---------------------------
		; Size of uninitialized data
		;---------------------------
		mov edx,[edi].OptionalHeader.SizeOfUninitializedData
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_UNINITDATA,addr buffer
		;------------------------------
		; Size of initialized data
		;-----------------------------
		mov edx,[edi].OptionalHeader.SizeOfInitializedData
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_INITDATA,addr buffer
		;--------------------------
		; Size of code
		;--------------------------
		mov edx,[edi].OptionalHeader.SizeOfCode
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_CODESIZE,addr buffer
		;--------------------------
		; Number of sections
		;--------------------------
		mov dx,[edi].FileHeader.NumberOfSections
		movzx edx,dx
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_NUMSEC,addr buffer
		;---------------------------
		; Size of headers
		;----------------------------
		mov edx,[edi].OptionalHeader.SizeOfHeaders
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_HEADERSIZE,addr buffer
		assume edi:nothing
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if dx==BN_CLICKED
			.if ax==IDC_SAVEHEADER
				;-----------------------------------
				; Save the values into the pe header
				;------------------------------------
				push edi
				mov edi,pPEHeader
				assume edi:ptr IMAGE_NT_HEADERS
				;------------------------------
				; Machine
				;------------------------------
				invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_GETCURSEL,0,0
				invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_GETITEMDATA,eax,0
				mov [edi].FileHeader.Machine,ax
				;----------------------------
				; File characteristics
				;----------------------------
				invoke GetDlgItemText,hDlg,IDC_FILECHARAC,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].FileHeader.Characteristics,ax
				;----------------------------
				; Subsystem
				;----------------------------
				invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_GETCURSEL,0,0
				invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_GETITEMDATA,eax,0
				mov [edi].OptionalHeader.Subsystem,ax
				;----------------------------
				; major subsystem version
				;----------------------------
				invoke GetDlgItemText,hDlg,IDC_MAJORSUBSYSTEM,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.MajorSubsystemVersion,ax
				;----------------------------
				; minor subsystem version
				;----------------------------
				invoke GetDlgItemText,hDlg,IDC_MINORSUBSYSTEM,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.MinorSubsystemVersion,ax
				;-------------------------------
				; Checksum
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_CHECKSUM,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.CheckSum,eax
				;-------------------------------
				; Image base
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_IMAGEBASE,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.ImageBase,eax
				;-------------------------------
				; Image size
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_IMAGESIZE,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.SizeOfImage,eax
				;-------------------------------
				; EPRVA
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_EPRVABOX,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.AddressOfEntryPoint,eax
				;-------------------------------
				; Base of code
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_CODEBASE,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.BaseOfCode,eax
				;-------------------------------
				; Base of data
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_DATABASE,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.BaseOfData,eax
				;-------------------------------
				; section alignment
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_SECTIONALIGN,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.SectionAlignment,eax
				;-------------------------------
				; file alignment
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_FILEALIGN,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.FileAlignment,eax
				;-------------------------------
				; size of uninitialized data
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_UNINITDATA,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.SizeOfUninitializedData,eax
				;-------------------------------
				; size of initialized data
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_INITDATA,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.SizeOfInitializedData,eax
				;-------------------------------
				; size of code
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_CODESIZE,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.SizeOfCode,eax
				;-------------------------------
				; Number of sections
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_NUMSEC,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].FileHeader.NumberOfSections,ax
				;-------------------------------
				; Size of headers
				;------------------------------
				invoke GetDlgItemText,hDlg,IDC_HEADERSIZE,addr buffer,256
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.SizeOfHeaders,eax
				assume edi:nothing
				pop edi
				invoke MessageBox,hDlg,addr DataSaved,addr AppName,MB_OK+MB_ICONINFORMATION
			.elseif ax==IDC_CANCELHEADER
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.elseif ax==IDC_FILECHARACBROWSE
				invoke GetDlgItemText,hDlg,IDC_FILECHARAC,addr buffer,1024
				invoke HexString2Dword,addr buffer
				mov Charac,eax
				invoke DialogBoxParam,hInstance,IDD_FILECHARAC,hDlg,addr FileCharacteristicsProc,0
			.endif
		.endif
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
PEHeaderProc endp

SectionMenuCreate proc
	LOCAL menuinfo:MENUITEMINFO
	invoke CreatePopupMenu
	mov hSectionPopup,eax
	mov menuinfo.cbSize,sizeof MENUITEMINFO
	mov menuinfo.fMask,MIIM_TYPE + MIIM_ID
	mov menuinfo.fType,MFT_STRING
	mov menuinfo.wID,IDM_EDITSECTION
	mov menuinfo.dwTypeData,offset EditSection
	invoke lstrlen,addr EditSection
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hSectionPopup,IDM_EDITSECTION,FALSE,addr menuinfo
	mov menuinfo.wID,IDM_SAVESECTION
	mov menuinfo.dwTypeData,offset SaveSection
	invoke lstrlen,addr SaveSection
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hSectionPopup,IDM_SAVESECTION,FALSE,addr menuinfo
	mov menuinfo.wID,IDM_KILLSECTION
	mov menuinfo.dwTypeData,offset KillSection
	invoke lstrlen,addr KillSection
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hSectionPopup,IDM_KILLSECTION,FALSE,addr menuinfo
	mov menuinfo.wID,IDM_APPENDSECTION
	mov menuinfo.dwTypeData,offset AppendSection
	invoke lstrlen,addr AppendSection
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hSectionPopup,IDM_APPENDSECTION,FALSE,addr menuinfo
	;-----------------------------
	; Menu separator
	;-----------------------------
	mov menuinfo.wID,NULL
	mov menuinfo.dwTypeData,NULL
	mov menuinfo.fType,MFT_SEPARATOR
	mov menuinfo.cch,NULL
	invoke InsertMenuItem,hSectionPopup,NULL,FALSE,addr menuinfo

	mov menuinfo.wID,IDM_DUMPDOSHEADER
	mov menuinfo.dwTypeData,offset DumpDOSHeader
	mov menuinfo.fType,MFT_STRING
	invoke lstrlen,addr DumpDOSHeader
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hSectionPopup,IDM_DUMPDOSHEADER,FALSE,addr menuinfo
	mov menuinfo.wID,IDM_DUMPPEHEADER
	mov menuinfo.dwTypeData,offset DumpPEHeader
	invoke lstrlen,addr DumpPEHeader
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hSectionPopup,IDM_DUMPPEHEADER,FALSE,addr menuinfo
	mov menuinfo.wID,IDM_DUMPSECTIONTABLE
	mov menuinfo.dwTypeData,offset DumpSectionTable
	invoke lstrlen,addr DumpSectionTable
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hSectionPopup,IDM_DUMPSECTIONTABLE,FALSE,addr menuinfo
	mov menuinfo.wID,IDM_DUMPALL
	mov menuinfo.dwTypeData,offset DumpAll
	invoke lstrlen,addr DumpAll
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hSectionPopup,IDM_DUMPALL,FALSE,addr menuinfo

	ret
SectionMenuCreate endp

SectionProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL lvc:LV_COLUMN
	LOCAL hwndListView:DWORD
	LOCAL pt:POINT
	LOCAL rect:RECT
	.if uMsg==WM_INITDIALOG
		invoke SetTitle,hDlg
		invoke GetDlgItem,hDlg,IDC_SECTIONLIST
		mov hwndListView,eax
		invoke GetWindowRect,hwndListView,addr rect
		mov eax,rect.right
		sub eax,rect.left
		xor edx,edx
		mov ecx,6
		div ecx
		dec eax
		dec eax
		mov lvc.lx,eax
		mov lvc.imask,LVCF_SUBITEM+LVCF_TEXT+LVCF_WIDTH+LVCF_FMT
		mov lvc.fmt,LVCFMT_LEFT
		mov lvc.pszText,offset SectionNameStr
		mov lvc.iSubItem,0
		invoke SendMessage,hwndListView,LVM_INSERTCOLUMN,lvc.iSubItem,addr lvc
		mov lvc.fmt,LVCFMT_RIGHT
		mov lvc.pszText,offset VirtualSizeStr
		inc lvc.iSubItem
		invoke SendMessage,hwndListView,LVM_INSERTCOLUMN,lvc.iSubItem,addr lvc
		mov lvc.pszText,offset VirtualOffsetStr
		inc lvc.iSubItem
		invoke SendMessage,hwndListView,LVM_INSERTCOLUMN,lvc.iSubItem,addr lvc
		mov lvc.pszText,offset RawSizeStr
		inc lvc.iSubItem
		invoke SendMessage,hwndListView,LVM_INSERTCOLUMN,lvc.iSubItem,addr lvc
		mov lvc.pszText,offset RawOffsetStr
		inc lvc.iSubItem
		invoke SendMessage,hwndListView,LVM_INSERTCOLUMN,lvc.iSubItem,addr lvc
		mov lvc.pszText,offset CharacteristicsStr
		inc lvc.iSubItem
		invoke SendMessage,hwndListView,LVM_INSERTCOLUMN,lvc.iSubItem,addr lvc
		invoke UpdateListView,hwndListView
	;-----------------------------------------------------------------------------------------
	; When the user right-clicks at the listview item, display a dialog box to accept the
	; change to section table 
	;------------------------------------------------------------------------------------------
	.elseif uMsg==WM_NOTIFY
		mov edx,lParam
		assume edx:ptr NMHDR
		.if [edx].code==NM_RCLICK
			invoke SendDlgItemMessage,hDlg,IDC_SECTIONLIST,LVM_GETNEXTITEM,-1,LVNI_SELECTED
			.if eax!=-1
				invoke GetCursorPos,addr pt
				invoke TrackPopupMenu,hSectionPopup,TPM_LEFTALIGN,pt.x,pt.y,NULL,hDlg,NULL
			.endif
		.endif
		assume edx:nothing
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		.if lParam==0
			.if ax==IDM_EDITSECTION
				invoke SendDlgItemMessage,hDlg,IDC_SECTIONLIST,LVM_GETNEXTITEM,-1,LVNI_SELECTED
				.if eax!=-1
					invoke DialogBoxParam,hInstance,IDD_SECTIONITEM,hDlg,addr ModifySectionProc,eax
				.endif
			.elseif ax==IDM_SAVESECTION			
				invoke SendDlgItemMessage,hDlg,IDC_SECTIONLIST,LVM_GETNEXTITEM,-1,LVNI_SELECTED
				.if eax!=-1
					invoke SaveSectionToDisk,hDlg,eax
				.endif
			.elseif ax==IDM_APPENDSECTION	
				invoke AppendSectionToFile,hDlg
			.elseif ax==IDM_DUMPDOSHEADER
				invoke DumpHeader,hDlg,DOSHEADER
			.elseif ax==IDM_DUMPPEHEADER
				invoke DumpHeader,hDlg,PEHEADER
			.elseif ax==IDM_DUMPSECTIONTABLE
				invoke DumpHeader,hDlg,SECTIONTABLE
			.elseif ax==IDM_DUMPALL
				invoke DumpHeader,hDlg,ALLHEADER
			.elseif ax==IDM_KILLSECTION
				invoke SendDlgItemMessage,hDlg,IDC_SECTIONLIST,LVM_GETNEXTITEM,-1,LVNI_SELECTED
				.if eax!=-1
					invoke KillTheSection,hDlg,eax
					.if eax==TRUE
						invoke GetDlgItem,hDlg,IDC_SECTIONLIST
						invoke UpdateListView,eax
					.endif
				.endif
			.endif
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
SectionProc endp

ModifySectionProc proc uses edi hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[64]:byte
	.if uMsg==WM_INITDIALOG
		mov edi,pSectionTable
		mov eax,lParam
		mov ecx,sizeof IMAGE_SECTION_HEADER
		mul ecx
		add edi,eax		; edi points to the IMAGE_SECTION_HEADER structure that we want to modify
		mov SectionPtr,edi
		assume edi:ptr IMAGE_SECTION_HEADER
		;-----------------------------------------
		; Section name
		;-----------------------------------------
		invoke SendDlgItemMessage,hDlg,IDC_SECNAME,EM_SETLIMITTEXT,8,0
		invoke RtlFillMemory,addr buffer,64,0
		invoke lstrcpyn,addr buffer,edi,9
		invoke SetDlgItemText,hDlg,IDC_SECNAME,addr buffer
		;--------------------------------------
		; Section VA
		;--------------------------------------
		invoke GetDlgItem,hDlg,IDC_SECRVA
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		mov OldWinProc,eax
		invoke SendDlgItemMessage,hDlg,IDC_SECRVA,EM_SETLIMITTEXT,8,0
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].VirtualAddress
		invoke SetDlgItemText,hDlg,IDC_SECRVA,addr buffer
		;---------------------------------
		; virtual size
		;---------------------------------
		invoke GetDlgItem,hDlg,IDC_SECVSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke SendDlgItemMessage,hDlg,IDC_SECVSIZE,EM_SETLIMITTEXT,8,0
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].Misc.VirtualSize
		invoke SetDlgItemText,hDlg,IDC_SECVSIZE,addr buffer
		;---------------------------------
		; Raw Offset
		;---------------------------------
		invoke GetDlgItem,hDlg,IDC_SECROFFSET
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke SendDlgItemMessage,hDlg,IDC_SECROFFSET,EM_SETLIMITTEXT,8,0
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].PointerToRawData
		invoke SetDlgItemText,hDlg,IDC_SECROFFSET,addr buffer
		;------------------------------
		; Raw size
		;------------------------------
		invoke GetDlgItem,hDlg,IDC_SECRSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke SendDlgItemMessage,hDlg,IDC_SECRSIZE,EM_SETLIMITTEXT,8,0
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].SizeOfRawData
		invoke SetDlgItemText,hDlg,IDC_SECRSIZE,addr buffer
		;------------------------------
		; Characteristics
		;------------------------------
		invoke GetDlgItem,hDlg,IDC_SECCHARAC
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].Characteristics
		invoke SetDlgItemText,hDlg,IDC_SECCHARAC,addr buffer
		assume edi:nothing
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if dx==BN_CLICKED
			.if ax==IDC_SECCANCEL
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			;-------------------------------------------
			; The user chooses to save the data
			;-------------------------------------------
			.elseif ax==IDC_SECOK
				mov edi,SectionPtr
				assume edi:ptr IMAGE_SECTION_HEADER
				;---------------------------------------
				; Section Name
				;---------------------------------------
				invoke RtlFillMemory,addr buffer,9,0
				invoke GetDlgItemText,hDlg,IDC_SECNAME,addr buffer,64
				push edi
				push esi
				lea esi,buffer
				mov ecx,8
				rep movsb
				pop esi
				pop edi
				;--------------------------------------
				; Virtual size
				;--------------------------------------
				invoke GetDlgItemText,hDlg,IDC_SECVSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].Misc.VirtualSize,eax
				;--------------------------------------
				; Virtual offset
				;--------------------------------------
				invoke GetDlgItemText,hDlg,IDC_SECRVA,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].VirtualAddress,eax
				;--------------------------------------
				; raw offset
				;--------------------------------------
				invoke GetDlgItemText,hDlg,IDC_SECROFFSET,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].PointerToRawData,eax
				;--------------------------------------
				; raw size
				;--------------------------------------
				invoke GetDlgItemText,hDlg,IDC_SECRSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].SizeOfRawData,eax
				;--------------------------------------
				; Characteristics
				;--------------------------------------
				invoke GetDlgItemText,hDlg,IDC_SECCHARAC,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].Characteristics,eax
				assume edi:nothing
				invoke GetParent,hDlg
				mov edx,eax
				invoke SendMessage,edx,WM_INITDIALOG,0,0
				invoke MessageBox,hDlg,addr DataSaved,addr AppName,MB_OK+MB_ICONINFORMATION
			.elseif ax==IDC_CHARACBROWSE
				invoke GetDlgItemText,hDlg,IDC_SECCHARAC,addr buffer,64
				invoke HexString2Dword,addr buffer
				invoke DialogBoxParam,hInstance,IDD_CHARAC,hDlg,addr CharacteristicsProc,eax
			.endif
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
ModifySectionProc endp

CharacteristicsProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[16]:byte
	.if uMsg==WM_INITDIALOG
		push lParam
		pop Charac
		test Charac,IMAGE_SCN_TYPE_NO_PAD
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_NOPAD,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_CNT_CODE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_CODE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_CNT_INITIALIZED_DATA
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_INITDATA,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_CNT_UNINITIALIZED_DATA
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_UNINITDATA,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_LNK_OTHER
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_LNKOTHER,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_LNK_INFO
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_LNKINFO,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_LNK_REMOVE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_LNKREMOVE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_LNK_COMDAT
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_LNKCOMDAT,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_NO_DEFER_SPEC_EXC
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_DEFERSPEC,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_GPREL
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_GPREL,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_FARDATA
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_FARDATA,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_PURGEABLE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_PURGEABLE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_16BIT
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_MEM16BIT,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_LOCKED
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_LOCKED,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_PRELOAD
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_PRELOAD,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_1BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN1BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_2BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN2BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_4BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN4BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_8BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN8BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_16BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN16BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_32BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN32BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_64BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN64BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_128BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN128BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_256BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN256BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_1024BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN1024BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_2048BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN2048BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_4096BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN4096BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_ALIGN_8192BYTES
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_ALIGN8192BYTES,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_LNK_NRELOC_OVFL
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_OVFL,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_DISCARDABLE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_DISCARDABLE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_NOT_CACHED
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_NOTCACHED,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_NOT_PAGED
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_NOTPAGED,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_SHARED
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_MEMSHARED,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_EXECUTE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_MEMEXECUTE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_READ
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_MEMREAD,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_MEM_WRITE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_MEMWRITE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_SCN_SCALE_INDEX
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_SCALEINDEX,BM_SETCHECK,BST_CHECKED,0
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if dx==BN_CLICKED
			.if ax==IDC_CHARACOK
				invoke wsprintf,addr buffer,addr SectionTemplate,Charac
				invoke GetParent,hDlg
				mov ecx,eax
				invoke SetDlgItemText,ecx,IDC_SECCHARAC,addr buffer
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.elseif ax==IDC_CHARACCANCEL
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.elseif ax==IDC_NOPAD
				test Charac,IMAGE_SCN_TYPE_NO_PAD
				.if ZERO?
					or Charac,IMAGE_SCN_TYPE_NO_PAD
				.else
					mov eax,IMAGE_SCN_TYPE_NO_PAD
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_MEMWRITE
				test Charac,IMAGE_SCN_MEM_WRITE
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_WRITE
				.else
					mov eax,IMAGE_SCN_MEM_WRITE
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_CODE
				test Charac,IMAGE_SCN_CNT_CODE
				.if ZERO?
					or Charac,IMAGE_SCN_CNT_CODE
				.else
					mov eax,IMAGE_SCN_CNT_CODE
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_INITDATA
				test Charac,IMAGE_SCN_CNT_INITIALIZED_DATA
				.if ZERO?
					or Charac,IMAGE_SCN_CNT_INITIALIZED_DATA
				.else
					mov eax,IMAGE_SCN_CNT_INITIALIZED_DATA
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_UNINITDATA
				test Charac,IMAGE_SCN_CNT_UNINITIALIZED_DATA
				.if ZERO?
					or Charac,IMAGE_SCN_CNT_UNINITIALIZED_DATA
				.else
					mov eax,IMAGE_SCN_CNT_UNINITIALIZED_DATA
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_LNKOTHER
				test Charac,IMAGE_SCN_LNK_OTHER
				.if ZERO?
					or Charac,IMAGE_SCN_LNK_OTHER
				.else
					mov eax,IMAGE_SCN_LNK_OTHER
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_LNKINFO
				test Charac,IMAGE_SCN_LNK_INFO 
				.if ZERO?
					or Charac,IMAGE_SCN_LNK_INFO 
				.else
					mov eax,IMAGE_SCN_LNK_INFO 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_LNKREMOVE
				test Charac,IMAGE_SCN_LNK_REMOVE 
				.if ZERO?
					or Charac,IMAGE_SCN_LNK_REMOVE 
				.else
					mov eax,IMAGE_SCN_LNK_REMOVE 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_LNKCOMDAT
				test Charac,IMAGE_SCN_LNK_COMDAT 
				.if ZERO?
					or Charac,IMAGE_SCN_LNK_COMDAT 
				.else
					mov eax,IMAGE_SCN_LNK_COMDAT 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_DEFERSPEC
				test Charac,IMAGE_SCN_NO_DEFER_SPEC_EXC 
				.if ZERO?
					or Charac,IMAGE_SCN_NO_DEFER_SPEC_EXC 
				.else
					mov eax,IMAGE_SCN_NO_DEFER_SPEC_EXC 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_GPREL
				test Charac,IMAGE_SCN_GPREL 
				.if ZERO?
					or Charac,IMAGE_SCN_GPREL 
				.else
					mov eax,IMAGE_SCN_GPREL 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_FARDATA
				test Charac,IMAGE_SCN_MEM_FARDATA 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_FARDATA 
				.else
					mov eax,IMAGE_SCN_MEM_FARDATA 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_PURGEABLE
				test Charac,IMAGE_SCN_MEM_PURGEABLE 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_PURGEABLE 
				.else
					mov eax,IMAGE_SCN_MEM_PURGEABLE 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_MEM16BIT
				test Charac,IMAGE_SCN_MEM_16BIT 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_16BIT 
				.else
					mov eax,IMAGE_SCN_MEM_16BIT 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_LOCKED
				test Charac,IMAGE_SCN_MEM_LOCKED 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_LOCKED 
				.else
					mov eax,IMAGE_SCN_MEM_LOCKED 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_PRELOAD
				test Charac,IMAGE_SCN_MEM_PRELOAD 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_PRELOAD 
				.else
					mov eax,IMAGE_SCN_MEM_PRELOAD 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN1BYTES
				test Charac,IMAGE_SCN_ALIGN_1BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_1BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_1BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN2BYTES
				test Charac,IMAGE_SCN_ALIGN_2BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_2BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_2BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN4BYTES
				test Charac,IMAGE_SCN_ALIGN_4BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_4BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_4BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN8BYTES
				test Charac,IMAGE_SCN_ALIGN_8BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_8BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_8BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN16BYTES
				test Charac,IMAGE_SCN_ALIGN_16BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_16BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_16BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN32BYTES
				test Charac,IMAGE_SCN_ALIGN_32BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_32BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_32BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN64BYTES
				test Charac,IMAGE_SCN_ALIGN_64BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_64BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_64BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN128BYTES
				test Charac,IMAGE_SCN_ALIGN_128BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_128BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_128BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN256BYTES
				test Charac,IMAGE_SCN_ALIGN_256BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_256BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_256BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN512BYTES
				test Charac,IMAGE_SCN_ALIGN_512BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_512BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_512BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN1024BYTES
				test Charac,IMAGE_SCN_ALIGN_1024BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_1024BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_1024BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN2048BYTES
				test Charac,IMAGE_SCN_ALIGN_2048BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_2048BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_2048BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN4096BYTES
				test Charac,IMAGE_SCN_ALIGN_4096BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_4096BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_4096BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_ALIGN8192BYTES
				test Charac,IMAGE_SCN_ALIGN_8192BYTES 
				.if ZERO?
					or Charac,IMAGE_SCN_ALIGN_8192BYTES 
				.else
					mov eax,IMAGE_SCN_ALIGN_8192BYTES 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_OVFL
				test Charac,IMAGE_SCN_LNK_NRELOC_OVFL 
				.if ZERO?
					or Charac,IMAGE_SCN_LNK_NRELOC_OVFL 
				.else
					mov eax,IMAGE_SCN_LNK_NRELOC_OVFL 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_DISCARDABLE
				test Charac,IMAGE_SCN_MEM_DISCARDABLE 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_DISCARDABLE 
				.else
					mov eax,IMAGE_SCN_MEM_DISCARDABLE 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_NOTCACHED
				test Charac,IMAGE_SCN_MEM_NOT_CACHED 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_NOT_CACHED 
				.else
					mov eax,IMAGE_SCN_MEM_NOT_CACHED 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_NOTPAGED
				test Charac,IMAGE_SCN_MEM_NOT_PAGED 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_NOT_PAGED 
				.else
					mov eax,IMAGE_SCN_MEM_NOT_PAGED 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_MEMSHARED
				test Charac,IMAGE_SCN_MEM_SHARED 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_SHARED 
				.else
					mov eax,IMAGE_SCN_MEM_SHARED 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_MEMEXECUTE
				test Charac,IMAGE_SCN_MEM_EXECUTE 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_EXECUTE 
				.else
					mov eax,IMAGE_SCN_MEM_EXECUTE 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_MEMREAD
				test Charac,IMAGE_SCN_MEM_READ 
				.if ZERO?
					or Charac,IMAGE_SCN_MEM_READ 
				.else
					mov eax,IMAGE_SCN_MEM_READ 
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_SCALEINDEX
				test Charac,IMAGE_SCN_SCALE_INDEX 
				.if ZERO?
					or Charac,IMAGE_SCN_SCALE_INDEX 
				.else
					mov eax,IMAGE_SCN_SCALE_INDEX 
					not eax
					and Charac,eax
				.endif
			.endif
		.endif
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
CharacteristicsProc endp

UpdateListView proc uses esi edi hwndListView:DWORD
	LOCAL tvi:TV_ITEM
	LOCAL lvi:LV_ITEM
	LOCAL buffer[50]:BYTE
	LOCAL SectionName[9]:BYTE
	invoke GetParent,hwndListView
	invoke SendDlgItemMessage,eax,IDC_SECTIONLIST,LVM_DELETEALLITEMS,0,0
	mov lvi.imask,LVIF_TEXT
	mov lvi.iItem,0
	mov esi,pPEHeader
	assume esi:ptr IMAGE_NT_HEADERS
	mov ax,[esi].FileHeader.NumberOfSections
	movzx eax,ax
	mov esi,eax
	assume esi:nothing
	mov edi,pSectionTable
	.while esi>0
		mov lvi.iSubItem,0
		assume edi: ptr IMAGE_SECTION_HEADER
		;----------------------------------
		; Insert section name
		;----------------------------------
		push esi
		push edi
		lea esi,[edi].Name1
		lea edi,SectionName
		mov ecx,8
		rep movsb
		mov byte ptr [edi],0
		pop edi
		pop esi
		lea eax,SectionName
		mov lvi.pszText,eax
		invoke SendMessage,hwndListView,LVM_INSERTITEM,NULL,addr lvi
		;----------------------------------
		; Insert Virtual Size
		;----------------------------------
		inc lvi.iSubItem
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].Misc.VirtualSize
		invoke CharUpper,addr buffer
		lea eax,buffer
		mov lvi.pszText,eax
		invoke SendMessage,hwndListView,LVM_SETITEM,NULL,addr lvi
		;---------------------------------
		; insert virtual offset
		;---------------------------------
		inc lvi.iSubItem
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].VirtualAddress
		invoke CharUpper,addr buffer
		lea eax,buffer
		mov lvi.pszText,eax
		invoke SendMessage,hwndListView,LVM_SETITEM,NULL,addr lvi
		;--------------------------------
		; Insert raw Size
		;--------------------------------
		inc lvi.iSubItem
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].SizeOfRawData
		invoke CharUpper,addr buffer
		lea eax,buffer
		mov lvi.pszText,eax
		invoke SendMessage,hwndListView,LVM_SETITEM,NULL,addr lvi
		;--------------------------------
		; Insert raw offset
		;--------------------------------
		inc lvi.iSubItem
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].PointerToRawData
		invoke CharUpper,addr buffer
		lea eax,buffer
		mov lvi.pszText,eax
		invoke SendMessage,hwndListView,LVM_SETITEM,NULL,addr lvi
		;--------------------------------
		; Insert characteristics
		;--------------------------------
		inc lvi.iSubItem
		invoke wsprintf,addr buffer,addr SectionTemplate,[edi].Characteristics
		invoke CharUpper,addr buffer
		lea eax,buffer
		mov lvi.pszText,eax
		invoke SendMessage,hwndListView,LVM_SETITEM,NULL,addr lvi
		inc lvi.iItem
		assume edi: nothing
		add edi,sizeof IMAGE_SECTION_HEADER
		dec esi
	.endw
	ret
UpdateListView endp

ImportProc proc uses esi edi hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL tvi:TV_INSERTSTRUCT
	LOCAL hwndTreeView:DWORD
	LOCAL buffer[50]:byte
	.if uMsg==WM_INITDIALOG		
		invoke SetTitle,hDlg
		invoke GetDlgItem,hDlg,IDC_IMPORTTREE
		mov hwndTreeView,eax
		mov edi,pImportSection
		assume edi:ptr IMAGE_IMPORT_DESCRIPTOR
		.while [edi].FirstThunk!=0 || [edi].TimeDateStamp!=0 || [edi].ForwarderChain!=0 || [edi].Name1!=0 || [edi].OriginalFirstThunk!=0
			mov tvi.hParent,NULL
			mov tvi.hInsertAfter,TVI_SORT
			mov tvi.item.imask,TVIF_TEXT
			invoke RVAToOffset,pMapping,[edi].Name1
			add eax,pMapping
			mov tvi.item.pszText,eax
			invoke SendDlgItemMessage,hDlg,IDC_IMPORTTREE,TVM_INSERTITEM,0,addr tvi
			;------------------------------------
			; Now enumerate the functions
			;------------------------------------
			mov tvi.hParent,eax
			invoke RVAToOffset,pMapping,[edi].FirstThunk
			add eax,pMapping
			mov esi,eax
			cmp [edi].TimeDateStamp,0
			jz NotBoundImport
			invoke RVAToOffset,pMapping,[edi].OriginalFirstThunk	; if it is, use the original first thunk instead
			add eax,pMapping
			mov esi,eax
NotBoundImport:
			mov tvi.hInsertAfter,TVI_SORT
			.while dword ptr [esi]!=0
				test dword ptr [esi],80000000h
				.if ZERO?
					invoke RVAToOffset,pMapping,dword ptr [esi]
					add eax,pMapping
					add eax,2
					mov tvi.item.pszText,eax
				.else		; if import by ordinals
					mov edx,dword ptr [esi]
					and edx,7fffffffh
					invoke wsprintf,addr buffer,addr DecTemplate,edx
					lea eax,buffer
					mov tvi.item.pszText,eax
				.endif
				invoke SendDlgItemMessage,hDlg,IDC_IMPORTTREE,TVM_INSERTITEM,0,addr tvi
				add esi,4
			.endw
			add edi,sizeof IMAGE_IMPORT_DESCRIPTOR
		.endw
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif	
	mov eax,TRUE
	ret
ImportProc endp

RVAToOffset PROC uses edi esi edx ecx pFileMap:DWORD,RVA:DWORD
	mov esi,pFileMap
	mov ax,[esi+3Ch]
	movzx eax,ax
	add esi,eax
	assume esi:ptr IMAGE_NT_HEADERS
	mov edi,RVA	; edi == RVA
	mov edx,esi
	add edx,sizeof IMAGE_NT_HEADERS
	mov cx,[esi].FileHeader.NumberOfSections
	movzx ecx,cx
	assume edx:ptr IMAGE_SECTION_HEADER
	.while ecx>0	; check all sections
		.if edi>=[edx].VirtualAddress
			mov eax,[edx].VirtualAddress
			add eax,[edx].SizeOfRawData
			.if edi<eax	; The address is in this section
				mov eax,[edx].VirtualAddress
				sub edi,eax	; edi == difference between the specified RVA and the section's RVA
				mov eax,[edx].PointerToRawData
				add eax,edi	; eax == file offset
				ret
			.endif
		.endif
		add edx,sizeof IMAGE_SECTION_HEADER
		dec ecx
	.endw
	assume edx:nothing
	assume esi:nothing
	mov eax,edi
	ret
RVAToOffset endp

OutputProc PROC uses edi hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL Startupinfo:STARTUPINFO
	LOCAL hRead:DWORD
	LOCAL hWrite:DWORD
	LOCAL hReadDup:DWORD
	LOCAL hReadInput:DWORD
	LOCAL hWriteInput:DWORD
	LOCAL hWriteDup:DWORD
	LOCAL StdErrorHandle:DWORD
	LOCAL StdOutputHandle:DWORD
	LOCAL StdInputHandle:DWORD
	LOCAL pi:PROCESS_INFORMATION
	LOCAL buffer[20000]:byte
	LOCAL bytesread:DWORD
	LOCAL ExitCode:DWORD
	LOCAL sat:SECURITY_ATTRIBUTES
	.if uMsg==WM_INITDIALOG
		invoke RtlFillMemory,addr buffer,20000,0
		mov sat.nLength,sizeof sat
		mov sat.lpSecurityDescriptor,NULL
		mov sat.bInheritHandle,TRUE
		;---------------------------------------------------------------------------------
		; Create the output pipe to redirect output from the console applications
		;---------------------------------------------------------------------------------
		invoke CreatePipe,addr hRead,addr hWrite,addr sat,0
		mov Startupinfo.cb,sizeof STARTUPINFO
		invoke GetStartupInfo,addr Startupinfo
		mov Startupinfo.dwFlags,STARTF_USESHOWWINDOW+STARTF_USESTDHANDLES
		mov Startupinfo.wShowWindow,SW_HIDE		
		push hWrite
		pop Startupinfo.hStdOutput
		push hWrite
		pop Startupinfo.hStdError
		invoke CreateProcess,NULL,addr Assembler,NULL,NULL,TRUE,NULL,NULL,NULL,addr Startupinfo,addr pi
		.if eax!=0
			invoke CloseHandle,hWrite
			invoke CloseHandle,pi.hProcess
			invoke CloseHandle,pi.hThread
			lea edi,buffer
			.while TRUE
				invoke ReadFile,hRead,edi,20000,addr bytesread,NULL
				invoke GetLastError
				add edi,bytesread
				.if bytesread==0
					.break
				.endif
			.endw
			invoke CloseHandle,hRead
			invoke CreatePipe,addr hRead,addr hWrite,addr sat,0
			push hWrite
			pop Startupinfo.hStdOutput
			push hWrite
			pop Startupinfo.hStdError
			invoke CreateProcess,NULL,addr Linker,NULL,NULL,TRUE,NULL,NULL,NULL,addr Startupinfo,addr pi
			.if eax!=0
				invoke CloseHandle,hWrite
				invoke CloseHandle,pi.hProcess
				invoke CloseHandle,pi.hThread
				.while TRUE
					invoke ReadFile,hRead,edi,20000,addr bytesread,NULL
					add edi,bytesread
					.if bytesread==0
						.break
					.endif
				.endw
				invoke CloseHandle,hRead
				invoke SetDlgItemText,hDlg,IDC_OUTPUT,addr buffer
			.else
				invoke SetDlgItemText,hDlg,IDC_OUTPUT,addr ErrorLoadingLink
			.endif
		.else
			invoke SetDlgItemText,hDlg,IDC_OUTPUT,addr ErrorLoadingASM
		.endif		
	.elseif uMsg==WM_ACTIVATE
		invoke SendDlgItemMessage,hDlg,IDC_OUTPUT,EM_SETSEL,-1,0
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
OutputProc endp

;--------------------------------------------------------------------------------
;					SourceCodeProc
;--------------------------------------------------------------------------------
; This is the stream function used to receive the content of the richedit control
;--------------------------------------------------------------------------------
SourceCodeProc PROC dwCookie:DWORD,lpBuffer:DWORD,Count:DWORD,lpBytesWritten:DWORD
	.if Count==0
		mov eax,1
	.else
		invoke WriteFile,hAsm,lpBuffer,Count,lpBytesWritten,NULL
		.if eax!=NULL
			invoke WriteFile,hSource,lpBuffer,Count,lpBytesWritten,NULL
			.if eax!=NULL
				xor eax,eax
			.else
				mov eax,1
			.endif
		.else
			mov eax,1
		.endif
	.endif
	ret
SourceCodeProc endp

;--------------------------------------------
; accept the byte in al and return the string
; in ax
;--------------------------------------------
Hex2String proc uses edx
	mov dl,al
	shr dl,4
	.if dl>9
		add dl,"A"
		sub dl,10
	.else
		add dl,"0"
	.endif
	mov ah,dl
	mov dl,al
	and dl,0Fh
	.if dl>9
		add dl,"A"
		sub dl,10
	.else
		add dl,"0"
	.endif
	mov al,dl
	xchg ah,al
	ret
Hex2String endp

AssembleCode proc uses edi esi ecx hDlg:DWORD
	LOCAL StreamOut:EDITSTREAM
	LOCAL bytesWritten:DWORD
	LOCAL buffer[2048]:byte
	LOCAL buffer1[1024]:byte
	LOCAL curdir[1024]:byte
	LOCAL FullAsmName[512]:BYTE
	LOCAL FullSourceName[512]:BYTE
	LOCAL sd:SECURITY_DESCRIPTOR
	LOCAL sat:SECURITY_ATTRIBUTES
	LOCAL acl[1000]:byte
	LOCAL sid[1000]:byte
	LOCAL ExitCode:DWORD
	LOCAL d1:DWORD
	LOCAL d2:DWORD
	LOCAL d3:DWORD
	LOCAL CurDir[1024]:byte

	invoke GetCurrentDirectory,1024, addr CurDir
	invoke SetCurrentDirectory,addr ProjectDir
	;-------------------------------------
	; Create both asm and source files
	;-------------------------------------
	invoke CreateFile,addr SRCName,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,NULL
	mov hSource,eax
	invoke CreateFile,addr ASMName,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,NULL
	mov hAsm,eax
	;----------------------------------
	; Append cpu model
	;----------------------------------
	invoke RtlFillMemory,addr buffer,1024, 0
	invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyModel,addr buffer,addr buffer,2048,addr FullProjININame
	invoke lstrlen,addr buffer
	.if eax==0
		invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyModel,addr DefaultCPU,addr FullProjININame
		invoke lstrcpy,addr buffer,addr DefaultCPU
		invoke lstrlen,addr buffer
	.endif
	mov edx,eax
	invoke WriteFile,hAsm,addr buffer,edx,addr bytesWritten,NULL
	;------------------------------------
	; Append code prologue
	;------------------------------------
	invoke lstrlen,addr CodePrologue
	mov edx,eax
	invoke WriteFile,hAsm,addr CodePrologue,edx,addr bytesWritten,NULL
	;---------------------------------------------------
	; replace all xxxxPrefix with ";"
	;---------------------------------------------------
	mov OldInstructionPrefix,";"
	mov PatchVAPrefix,";"
	mov OriginalCallPrefix,";"
	mov CallAddressPrefix,";"
	mov CallOldVAPrefix,";"
	;----------------------------------------------------
	; Now check if code restoration is specified
	;----------------------------------------------------
	.if FPatch==TRUE
		.if RedirectOption==2 && RestoreOption==1
			mov OldInstructionPrefix," "
			invoke AddressToOffset,pMapping,PatchVA
			mov esi,eax
			add esi,pMapping	; edi now points to the address to patch
			mov al, byte ptr [esi]
			call Hex2String
			mov word ptr [FirstByte+1],ax
			inc esi
			mov al, byte ptr [esi]
			call Hex2String
			mov word ptr [SecondByte+1],ax
			inc esi
			mov al, byte ptr [esi]
			call Hex2String
			mov word ptr [ThirdByte+1],ax
			inc esi
			mov al, byte ptr [esi]
			call Hex2String
			mov word ptr [FourthByte+1],ax
			inc esi
			mov al, byte ptr [esi]
			call Hex2String
			mov word ptr [FifthByte+1],ax
			inc esi
			mov al, byte ptr [esi]
			call Hex2String
			mov word ptr [SixthByte+1],ax
			mov PatchVAPrefix," "
			invoke wsprintf,addr buffer,addr SectionTemplate,PatchVA
			lea esi,buffer
			mov edi,offset PatchLocation
			mov ecx,8
			rep movsb
			;-----------------------------------
			; Write the data part
			;-----------------------------------
			invoke lstrlen,addr MainData
			mov ecx,eax
			invoke WriteFile,hAsm,addr MainData,ecx,addr bytesWritten,NULL
			;-------------------------------------
			; Now write the restore snippet 
			;-------------------------------------
			invoke lstrlen,addr RestoreSnippet
			mov ecx,eax
			invoke WriteFile,hAsm,addr RestoreSnippet,ecx,addr bytesWritten,NULL
		.elseif RedirectOption==3
			invoke AddressToOffset,pMapping,PatchVA
			add eax,pMapping
			.if byte ptr [eax]==0E8h
				inc eax
				mov edx,dword ptr [eax]
				add edx,PatchVA
				add edx,5
			.else
				inc eax
				inc eax
				mov edx,dword ptr [eax]
			.endif	
			mov OriginalCallPrefix," "
			invoke wsprintf,addr buffer,addr SectionTemplate,edx
			mov edi,offset OriginalCall
			lea esi, buffer
			mov ecx,8
			rep movsb
			.if RestoreOption==1
				;-------------------------------------------------
				; Redirect control from call/jmp
				;-------------------------------------------------
				invoke AddressToOffset,pMapping,PatchVA
				add eax,pMapping
				push eax
				.if byte ptr [eax]==0E8h
					inc eax
				.else
					inc eax
					inc eax
				.endif
				mov esi,eax		; esi points to the dword to be replaced
				mov CallAddressPrefix," "
				invoke wsprintf,addr buffer,addr SectionTemplate,dword ptr [esi]
				mov edi,offset CallAddress
				lea esi,buffer
				mov ecx,8
				rep movsb
				pop eax
				mov edx,PatchVA
				.if byte ptr [eax]==0E8h
					inc edx
				.else
					inc edx
					inc edx
				.endif
				mov PatchVAPrefix," "
				invoke wsprintf,addr buffer,addr SectionTemplate,edx
				mov edi,offset PatchLocation
				lea esi,buffer
				mov ecx,8
				rep movsb
			.endif
			;----------------------------------
			; Write Maindata
			;----------------------------------
			invoke lstrlen,addr MainData
			mov ecx,eax
			invoke WriteFile,hAsm,addr MainData,ecx,addr bytesWritten,NULL
			.if RestoreOption==1
				;-------------------------------------
				; Now write the restore snippet 
				;-------------------------------------
				invoke lstrlen,addr RestoreCallSnippet
				mov ecx,eax
				invoke WriteFile,hAsm,addr RestoreCallSnippet,ecx,addr bytesWritten,NULL			
			.endif
		.endif
	.endif
	;-----------------------------------------------------
	; Write data from the richedit control to the asm file
	;-----------------------------------------------------
	mov StreamOut.dwCookie,0
	mov StreamOut.dwError,0
	mov StreamOut.pfnCallback,offset SourceCodeProc
	invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,EM_STREAMOUT,SF_TEXT,addr StreamOut
	;-----------------------------------------------------
	; Check if return option is specified
	;-----------------------------------------------------
	.if ReturnOption==1
		invoke wsprintf,addr buffer,addr HexTemplate,ReturnVA
		invoke lstrlen,addr buffer
		mov ecx,9
		sub ecx,eax
		lea esi,buffer
		mov edi,offset ReturnLocation
		add edi,ecx
		mov ecx,eax
		rep movsb
		invoke lstrlen,addr ReturnSnippet
		mov ecx,eax
		invoke WriteFile,hAsm,addr ReturnSnippet,ecx,addr bytesWritten,NULL
	.endif
	;------------------------------------------------------
	; Append code epilogue
	;------------------------------------------------------
	invoke lstrlen,addr CodeEpilogue
	mov edx,eax
	invoke WriteFile,hAsm,addr CodeEpilogue,edx,addr bytesWritten,NULL
	invoke CloseHandle,hAsm
	invoke CloseHandle,hSource
	;--------------------------------------------------
	; Now we create the assembler and linker commandlines
	;--------------------------------------------------
	.if CurrentASM==0
		invoke GetPrivateProfileString,addr MASM,addr MainINIKeyASM,addr buffer,addr buffer,256,addr FullININame
	.else
		invoke GetPrivateProfileString,addr TASM,addr MainINIKeyASM,addr buffer,addr buffer,256,addr FullININame
	.endif
	lea esi,buffer
	lea edi,Assembler
	mov ecx,1022
	.while ecx>0
		.if byte ptr [esi]!="%"
			mov al,byte ptr [esi]
			mov byte ptr [edi],al
			.if al==0
				.break
			.endif
			inc esi
			inc edi
		.else
			push esi
			push ecx
			mov byte ptr [edi],'"'
			inc edi
			invoke lstrlen,addr ASMName
			mov ecx,eax
			mov esi,offset ASMName
			rep movsb
			pop ecx
			pop esi
			inc esi
			inc esi
			dec ecx
		.endif
		dec ecx
	.endw
	;--------------------------------------------------
	; Create linker commandline
	;--------------------------------------------------
	.if CurrentASM==0	; if MASM
		invoke GetPrivateProfileString,addr MASM,addr MainINIKeyLink,addr buffer,addr buffer,256,addr FullININame
	.else
		invoke GetPrivateProfileString,addr TASM,addr MainINIKeyLink,addr buffer,addr buffer,256,addr FullININame
	.endif
	lea esi,buffer
	lea edi,Linker
	mov ecx,1022
	.while ecx>0
		.if byte ptr [esi]!="%"
			mov al,byte ptr [esi]
			mov byte ptr [edi],al
			.if al==0
				.break
			.endif
			inc esi
			inc edi
		.else
			push esi
			push ecx
			invoke lstrlen,addr OBJName
			mov ecx,eax
			mov esi,offset OBJName
			rep movsb
			pop ecx
			pop esi
			add esi,2
			dec ecx
		.endif
		dec ecx
	.endw
	;------------------------------------------------------
	; Delete the obj and exe files first so we can be sure
	; of the result of the assembling process
	;------------------------------------------------------
	invoke DeleteFile,addr EXEName
	invoke DeleteFile,addr OBJName
	;-------------------------------------------------------
	; Show the output dialog box
	;-------------------------------------------------------
	invoke DialogBoxParam,hInstance,IDD_OUTPUT,hDlg,addr OutputProc,NULL
	;-------------------------------------------------------------
	; Check if the .exe file is available after assembling process
	;-------------------------------------------------------------
	invoke CreateFile,addr EXEName,0,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
	.if eax!=INVALID_HANDLE_VALUE
		mov FProjectInProgress,EXEFILE_AVAILABLE
		invoke CloseHandle,eax
	.endif
	invoke SetCurrentDirectory,addr CurDir
	ret
AssembleCode endp

NewTargetProc PROC hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[256]:byte
	LOCAL CurrentFlag:DWORD
	.if uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if dx==BN_CLICKED
			.if ax==IDC_BROWSETARGET
				invoke BrowseAndFillEditBox,hDlg,IDC_NEWFILEBOX
			.elseif ax==IDC_CANCELNEWTARGET
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.elseif ax==IDC_OKNEWTARGET
				invoke GetDlgItemText,hDlg,IDC_NEWFILEBOX,addr buffer,256
				invoke lstrlen,addr buffer
				.if eax==0
					invoke MessageBox,hDlg,addr ErrorNoPatchFile,addr AppName,MB_OK+MB_ICONERROR
					invoke GetDlgItem,hDlg,IDC_NEWFILEBOX
					invoke SetFocus,eax
				.else
					invoke CheckIfValidPE,addr buffer
					.if eax==TRUE
						.if FProjectInProgress!=NO_PROJECT && FProjectInProgress!=TARGET_ONLY
							invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyTarget,addr buffer,addr FullProjININame
						.else
							mov FProjectInProgress,TARGET_ONLY
						.endif
						invoke lstrcpy,addr TargetName,addr buffer
						invoke SendMessage,hDlg,WM_CLOSE,0,0
					.elseif eax==FALSE
						invoke MessageBox,hDlg,addr ErrorNotValidPEFile,addr AppName,MB_OK+MB_ICONERROR
						invoke GetDlgItem,hDlg,IDC_NEWFILEBOX
						invoke SetFocus,eax
					.elseif eax==INVALID_HANDLE_VALUE
						invoke ShowErrorMessage,hDlg
						invoke GetDlgItem,hDlg,IDC_NEWFILEBOX
						invoke SetFocus,eax								
					.endif
				.endif
			.endif
		.endif
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
NewTargetProc endp

ShowErrorMessage proc hDlg:DWORD
	LOCAL buffer[1024]:byte
	invoke GetLastError
	mov edx,eax
	invoke FormatMessage,FORMAT_MESSAGE_FROM_SYSTEM,0,edx,0,addr buffer,1024,NULL
	invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
	ret
ShowErrorMessage endp
ExportSnippet proc uses esi edi ebx edx ecx hDlg:DWORD
	LOCAL hEXEFile:DWORD
	LOCAL hOutput:DWORD
	LOCAL hOutMapping:DWORD
	LOCAL pOutMapping:DWORD
	LOCAL hEXEMapping:DWORD
	LOCAL pEXEMapping:DWORD
	LOCAL Result:DWORD
	LOCAL NumSec:DWORD
	LOCAL BinSize:DWORD
	LOCAL pSection:DWORD
	LOCAL CodeVA:DWORD
	LOCAL CodeLimit:DWORD
	LOCAL bytesWritten:DWORD
	LOCAL lpPEHeader:DWORD
	LOCAL ChunkVA:DWORD
	LOCAL ImageBase:DWORD
	LOCAL buffer[256]:byte
	LOCAL RelocDifference:DWORD
	LOCAL JumpTableAddr:DWORD
	LOCAL JmpTableDifference:DWORD
	LOCAL JumpTablePresent:DWORD
	LOCAL FunctionName[256]:byte
	LOCAL DLLName[256]:byte
	LOCAL ImportPtr:DWORD
	LOCAL BinJumpTableAddr:DWORD
	LOCAL CurDir[1024]:byte

	invoke GetCurrentDirectory,1024, addr CurDir
	invoke SetCurrentDirectory,addr ProjectDir
	;----------------------------------------------------
	; Open the output exe file
	;----------------------------------------------------
	invoke CreateFile,addr EXEName,GENERIC_READ+GENERIC_WRITE,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,NULL
	.if eax!=INVALID_HANDLE_VALUE
		mov hEXEFile,eax
		;-----------------------------------------
		; Map the exe file into memory
		;-----------------------------------------
		invoke CreateFileMapping,hEXEFile,NULL,PAGE_READWRITE,NULL,NULL,NULL
		.if eax!=NULL
			mov hEXEMapping,eax
			invoke MapViewOfFile,hEXEMapping,FILE_MAP_ALL_ACCESS,NULL,NULL,NULL
			.if eax!=NULL
				mov pEXEMapping,eax
				;-----------------------------------
				; Now we create the output binary file
				;-----------------------------------
				invoke CreateFile,addr FileName,GENERIC_READ+GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,NULL
				.if eax!=INVALID_HANDLE_VALUE
					mov hOutput,eax
					;-------------------------------------
					; Find the code section
					;-------------------------------------
					mov edi,pEXEMapping
					mov ax,word ptr [edi+3Ch]
					movzx eax,ax
					add edi,eax	; now edi points to the pe header
					mov lpPEHeader,edi
					assume edi:ptr IMAGE_NT_HEADERS
					;---------------------------------
					; Save Imagebase
					;---------------------------------
					push [edi].OptionalHeader.ImageBase
					pop ImageBase
					;----------------------------------------------
					; Retrieve the EPRVA and number of sections
					; in the output exe file
					;----------------------------------------------
					mov eax,[edi].OptionalHeader.AddressOfEntryPoint
					mov cx,[edi].FileHeader.NumberOfSections
					movzx ecx,cx
					mov NumSec,ecx
					;-------------------------------------
					; Now we walk the section headers to
					; search for the section that is the
					; code section
					;--------------------------------------
					add edi,sizeof IMAGE_NT_HEADERS	; edi points to the section table
					mov pSection,edi
					assume edi:ptr IMAGE_SECTION_HEADER
					.while ecx>0
						.if eax>=[edi].VirtualAddress
							mov edx,[edi].VirtualAddress
							add edx,[edi].Misc.VirtualSize
							;-----------------------------------------------
							; If EPRVA falls somewhere in this section,
							; it is assumed that this is the code section
							;-----------------------------------------------
							.if eax<edx
								;--------------------------------------------------
								; Store the RVA of the code section and its limit
								;--------------------------------------------------
								push [edi].VirtualAddress
								pop CodeVA
								mov CodeLimit,edx
								;-----------------------------------------------------------------------
								; Find the marker so that we can calculate the size of the code section
								;------------------------------------------------------------------------
								mov esi,[edi].PointerToRawData
								add esi,pEXEMapping
								push edi
								push esi
								mov edi,esi
								mov al,"I"
								mov ecx,-1
continuescanning:
								repne scasb
								push edi
								push ecx
								push eax
								dec edi
								mov esi,offset IczMarker
								invoke lstrlen,esi
								mov ecx,eax
								repe cmpsb
								je  TheEndFound
								pop eax
								pop ecx
								pop edi
								jmp continuescanning
TheEndFound:
								pop eax
								mov JumpTableAddr,edi	; edi points to the first byte of the jump table (if exists)
								pop ecx
								pop edi
								dec edi
								mov ecx,edi
								pop esi
								pop edi
								sub ecx,esi
								mov BinSize,ecx
								invoke WriteFile,hOutput,esi,ecx,addr bytesWritten,NULL
								;---------------------------------------------------------
								; Now checks if jump table follows the delimiting string
								;---------------------------------------------------------
								invoke lstrlen,addr IczMarker
								mov JmpTableDifference,eax
								mov ecx,JumpTableAddr
								.if CurrentASM==0		; MASM pads the end of code section to dword alignment before it adds the jump table
									.while byte ptr [ecx]==0CCh
										inc ecx
										inc JmpTableDifference
									.endw
									mov JumpTableAddr,ecx
								.endif
								.while word ptr [ecx]==25FFh
									add ecx,6
								.endw
								.if ecx!=JumpTableAddr
									push BinSize
									pop BinJumpTableAddr
									mov eax,JmpTableDifference
									add BinJumpTableAddr,eax
									sub ecx,JumpTableAddr	; ecx == size of jump table
									add BinSize,ecx
									push ecx
									invoke WriteFile,hOutput,addr buffer,JmpTableDifference,addr bytesWritten,NULL
									pop ecx
									invoke WriteFile,hOutput,JumpTableAddr,ecx,addr bytesWritten,NULL  ; write jump table
									mov JumpTablePresent,TRUE
								.else
									mov JumpTablePresent,FALSE
								.endif
								;----------------------------------------------------------
								; Map the output binary file
								;----------------------------------------------------------
								invoke CreateFileMapping,hOutput,NULL,PAGE_READWRITE,NULL,NULL,NULL
								.if eax==NULL
MapError:
									invoke CloseHandle,hOutput
									invoke UnmapViewOfFile,pEXEMapping
									invoke CloseHandle,hEXEMapping
									invoke CloseHandle,hEXEFile
									invoke wsprintf,addr buffer,addr ErrorMapping,addr FileName
									invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
									invoke SetCurrentDirectory,addr CurDir
									mov eax,FALSE
									ret
								.endif
								mov hOutMapping,eax
								invoke MapViewOfFile,hOutMapping,FILE_MAP_ALL_ACCESS,NULL,NULL,NULL
								.if eax==NULL
									invoke CloseHandle,hOutMapping
									jmp MapError
								.endif
								mov pOutMapping,eax
								add BinJumpTableAddr,eax
								;-----------------------------------------------------------
								; Now perform relocation. Check first if the relocation
								; section exists. It should always exist.
								;-----------------------------------------------------------
								mov eax,SnippetVA
								sub eax,CodeVA
								sub eax,ImageBase
								mov RelocDifference,eax
								mov edi,lpPEHeader
								assume edi:ptr IMAGE_NT_HEADERS
								mov eax,[edi].OptionalHeader.DataDirectory[40].VirtualAddress
								.if eax!=0
									invoke RVAToOffset,pEXEMapping,eax
									mov esi,eax
									add esi,pEXEMapping
									assume esi:ptr IMAGE_BASE_RELOCATION
									.while [esi].VirtualAddress!=0 || [esi].SizeOfBlock!=0
										mov eax,[esi].VirtualAddress
										mov ChunkVA,eax
										.if eax>=CodeVA && eax<CodeLimit
											mov ecx,[esi].SizeOfBlock
											sub ecx,sizeof IMAGE_BASE_RELOCATION
											shr ecx,1
											add esi,sizeof IMAGE_BASE_RELOCATION
											assume esi:nothing
											.while ecx>0
												mov ax,[esi]
												and ax,0fffh
												movzx eax,ax
												mov edx,ChunkVA
												sub edx,CodeVA
												add edx,eax	; edx is the relative offset to the dword in question
												mov ax,[esi]
												shr ax,12
												.if ax==1		; apply to the high word of the dword in question
													push esi
													mov esi,pOutMapping
													add esi,edx		; esi points to the dword in question
													mov edx,RelocDifference
													add word ptr [esi],dx
													pop esi
												.elseif ax==2	; apply to the low word of the dword in question
													push esi
													mov esi,pOutMapping
													add esi,edx		; esi points to the dword in question
													mov edx,RelocDifference
													add word ptr [esi+2],dx
													pop esi
												.elseif ax==3	; apply to the whole dword
													push esi
													mov esi,pOutMapping
													add esi,edx
													mov edx,RelocDifference
													add [esi],edx
													pop esi
												.endif
												add esi,2
												dec ecx
											.endw
											assume esi:ptr IMAGE_BASE_RELOCATION
										.else
											add esi,[esi].SizeOfBlock
										.endif
									.endw
									assume esi:nothing
								.endif
								assume edi:nothing
								.if JumpTablePresent==TRUE
									;--------------------------------------------------
									; Get the address of the import table
									;--------------------------------------------------
									assume edi:ptr IMAGE_NT_HEADERS
									mov eax,[edi].OptionalHeader.DataDirectory[8].VirtualAddress
									add eax,ImageBase
									mov edx,eax
									invoke AddressToOffset,pEXEMapping,edx
									add eax,pEXEMapping
									mov ImportPtr,eax
									;--------------------------------------------------------
									; Now we fix jump table
									;--------------------------------------------------------
									mov edi,JumpTableAddr
									.while word ptr [edi]==25ffh
										mov edx,dword ptr [edi+2]	; edx == virtual address of the import address table
										invoke AddressToOffset,pEXEMapping,edx										
										add eax,pEXEMapping	; eax points to the import address
										mov edx,dword ptr [eax]
										mov ImportAddress,edx
										test edx,80000000h
										.if ZERO?
											add edx,ImageBase	; edx == virtual address of the import address
											invoke AddressToOffset,pEXEMapping,edx
											inc eax
											inc eax		; eax points to the name of the function
											mov esi,eax
											add esi,pEXEMapping
											invoke lstrcpy,addr FunctionName,esi
										.endif
										;------------------------------------------------
										; Now find out the name of the dll
										;-------------------------------------------------
										mov esi,ImportPtr
										assume esi:ptr IMAGE_IMPORT_DESCRIPTOR
										.while [esi].FirstThunk!=0
											mov edx,[esi].FirstThunk
											add edx,ImageBase
											invoke AddressToOffset,pEXEMapping,edx
											add eax,pEXEMapping
											.while dword ptr [eax]!=0
												mov edx,dword ptr [eax]
												.if edx==ImportAddress
													mov edx,[esi].Name1
													add edx,ImageBase
													invoke AddressToOffset,pEXEMapping,edx
													add eax,pEXEMapping
													mov edx,eax
													invoke lstrcpy,addr DLLName,edx
													jmp SearchTargetImportSection
												.endif
												add eax,4
											.endw										
											add esi,sizeof IMAGE_IMPORT_DESCRIPTOR
										.endw
										assume esi:nothing
SearchTargetImportSection:
										;--------------------------------------------------------
										; Now we got both the names of the dll and the function
										; Begin looking for the import entry in the target file
										;--------------------------------------------------------
										test ImportAddress,80000000h
										.if ZERO?
											invoke SearchTargetImport,addr DLLName,addr FunctionName
										.else
											invoke SearchTargetImport,addr DLLName,NULL
										.endif
										.if eax!=0
											mov edx,BinJumpTableAddr
											mov dword ptr [edx+2],eax
										.else
											invoke MessageBox,hDlg,addr ErrorImport,addr AppName,MB_OK+MB_ICONERROR
											invoke UnmapViewOfFile,pOutMapping
											invoke CloseHandle,hOutMapping
											invoke CloseHandle,hOutput
											invoke UnmapViewOfFile,pEXEMapping
											invoke CloseHandle,hEXEMapping
											invoke CloseHandle,hEXEFile
											invoke DeleteFile,addr FileName
											mov Result,FALSE
											jmp WeReturn
										.endif
										add BinJumpTableAddr,6
										add edi,6
									.endw
								.endif
								invoke UnmapViewOfFile,pOutMapping
								invoke CloseHandle,hOutMapping
								invoke CloseHandle,hOutput
								invoke UnmapViewOfFile,pEXEMapping
								invoke CloseHandle,hEXEMapping
								invoke CloseHandle,hEXEFile
								mov Result,TRUE
								.break
							.endif
						.endif
						add edi,sizeof IMAGE_SECTION_HEADER
						dec ecx
					.endw
					assume edi:nothing
				.else
					invoke UnmapViewOfFile,pEXEMapping
					invoke CloseHandle,hEXEMapping
					invoke CloseHandle,hEXEFile
					invoke wsprintf,addr buffer,addr ErrorCreateExport,addr FileName
					invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
					mov Result,FALSE
				.endif
			.else
				invoke CloseHandle,hEXEMapping
				invoke CloseHandle,hEXEFile
				jmp FileNotFound
			.endif
		.else
			invoke CloseHandle,hEXEFile
			jmp FileNotFound
		.endif
	.else
FileNotFound:
		invoke wsprintf,addr buffer,addr ErrorEXENotFound,addr EXEName
		mov FProjectInProgress,PROJECT_OPENED
		invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
		mov Result,FALSE
	.endif
WeReturn:
	invoke SetCurrentDirectory,addr CurDir
	mov eax,Result
	ret
ExportSnippet endp

;------------------------------------------------------------------------
; Search the import table of the target until every DLL entry is checked.
; There can be a DLL which is imported several times in the same file.
;------------------------------------------------------------------------
SearchTargetImport proc uses edi esi lpDLLName:DWORD,lpFunctionName:DWORD
	LOCAL Result:DWORD

	mov edi,pPEHeader
	assume edi:ptr IMAGE_NT_HEADERS
	;--------------------------------------------
	; Get the offset of the import section first
	;--------------------------------------------
	mov edx,[edi].OptionalHeader.DataDirectory[8].VirtualAddress
	add edx,[edi].OptionalHeader.ImageBase
	invoke AddressToOffset,pMapping,edx
	add eax,pMapping
	mov esi,eax		; esi points to IMAGE_IMPORT_DESCRIPTOR structure
	assume esi:ptr IMAGE_IMPORT_DESCRIPTOR
	;-------------------------------------------------------
	; Search all structures for the dll name that matches
	;-------------------------------------------------------
	.while [esi].FirstThunk!=0
		mov edx,[esi].Name1
		add edx,[edi].OptionalHeader.ImageBase
		invoke AddressToOffset,pMapping,edx
		add eax,pMapping
		mov edx,eax
		invoke lstrcmpi,lpDLLName,edx
		.if eax==0		; now the dll name matches, we search for the function name
			mov edx,[esi].FirstThunk
			mov Result,edx
			add edx,[edi].OptionalHeader.ImageBase
			invoke AddressToOffset,pMapping,edx
			add eax,pMapping
			mov eax,dword ptr [eax]	; RVA 
			cmp [esi].TimeDateStamp,0
			jz  UseFirstThunk
			mov edx,[esi].OriginalFirstThunk
			mov Result,edx
			add edx,[edi].OptionalHeader.ImageBase
UseFirstThunk:
			invoke AddressToOffset,pMapping,edx
			mov edx,eax
			add edx,pMapping		; edx points to the thunk dword
			.while dword ptr [edx]!=0
				push edx
				mov ecx,dword ptr [edx]
				.if lpFunctionName!=NULL
					add ecx,[edi].OptionalHeader.ImageBase
					invoke AddressToOffset,pMapping,ecx
					add eax,pMapping
					add eax,2
					invoke lstrcmpi,eax,lpFunctionName
					.if eax==0
SuccessImport:
						mov eax,Result
						.if [esi].TimeDateStamp!=0		; if the import is bound, we must walk the firstthink dword array
							sub eax,[esi].OriginalFirstThunk
							add eax,[esi].FirstThunk
						.endif
						add eax,[edi].OptionalHeader.ImageBase
						pop edx
						jmp ReturnToCaller
					.endif
				.else
					.if ecx==ImportAddress
						jmp SuccessImport
					.endif
				.endif
				pop edx
				add edx,4
				add Result,4
			.endw
		.endif
		add esi,sizeof IMAGE_IMPORT_DESCRIPTOR
	.endw
Failure:
	mov eax,0
	jmp ReturnToCaller
ReturnToCaller:
	assume esi:nothing
	assume edi:nothing
	ret
SearchTargetImport endp

;====================================================================================
;								AddressToOffset
;------------------------------------------------------------------------------------
; Convert a virtual address into a file offset
; On return: eax == file offset
;====================================================================================
AddressToOffset PROC uses edi esi edx ecx pMap:DWORD,Address:DWORD	
	mov esi,pMap
	mov ax,word ptr [esi+3ch]
	movzx eax,ax
	add esi,eax		; esi points to PE header
	assume esi:ptr IMAGE_NT_HEADERS
	mov eax,[esi].OptionalHeader.ImageBase
	sub Address,eax		; Address is now an RVA
	mov edi,Address	; edi == RVA
	mov edx,esi
	add edx,sizeof IMAGE_NT_HEADERS
	mov cx,[esi].FileHeader.NumberOfSections	; ecx == number of sections in the file
	movzx ecx,cx
	assume esi:nothing
	assume edx:ptr IMAGE_SECTION_HEADER
	.while ecx>0	; check all sections
		.if edi>=[edx].VirtualAddress
			mov eax,[edx].VirtualAddress
			add eax,[edx].SizeOfRawData
			.if edi<eax	; The address is in this section
				mov eax,[edx].VirtualAddress
				sub edi,eax	; edi == difference between the specified RVA and the section's RVA
				mov eax,[edx].PointerToRawData	
				add eax,edi	; eax == file offset
				ret
			.endif
		.endif
		add edx,sizeof IMAGE_SECTION_HEADER
		dec ecx
	.endw
	assume edx:nothing
	mov eax,edi
	ret
AddressToOffset endp

NewSectionProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	.if uMsg==WM_INITDIALOG
		invoke SetDlgItemText,hDlg,IDC_SECTIONNAME,addr DefaultSectionName
		invoke SendDlgItemMessage,hDlg,IDC_SECTIONNAME,EM_LIMITTEXT,8,0
		invoke SendDlgItemMessage,hDlg,IDC_CHRCODE,BM_SETCHECK,BST_CHECKED,0
		invoke SendDlgItemMessage,hDlg,IDC_CHREXECUTE,BM_SETCHECK,BST_CHECKED,0
		invoke SendDlgItemMessage,hDlg,IDC_CHRREAD,BM_SETCHECK,BST_CHECKED,0
		invoke SendDlgItemMessage,hDlg,IDC_CHRWRITE,BM_SETCHECK,BST_CHECKED,0
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if ax==IDC_CANCELSECTION
			.if dx==BN_CLICKED
				invoke EndDialog,hDlg,0	;0==unsuccessful
			.endif
		.elseif ax==IDC_OKSECTION
			.if dx==BN_CLICKED
				invoke GetDlgItemText,hDlg,IDC_SECTIONNAME,addr NewSectionName,9
				invoke lstrlen,addr NewSectionName
				.if eax==0
					invoke MessageBox,hDlg,addr ErrorSectionName,addr AppName,MB_OK+MB_ICONERROR
					invoke GetDlgItem,hDlg,IDC_SECTIONNAME
					invoke SetFocus,eax
				.else		; the section name is present. Create characteristic flags
					mov Characteristics,0
					invoke SendDlgItemMessage,hDlg,IDC_CHRCODE,BM_GETCHECK,0,0
					.if eax!=0
						or Characteristics,IMAGE_SCN_CNT_CODE
					.endif
					invoke SendDlgItemMessage,hDlg,IDC_CHRINIT,BM_GETCHECK,0,0
					.if eax!=0
						or Characteristics,IMAGE_SCN_CNT_INITIALIZED_DATA
					.endif
					invoke SendDlgItemMessage,hDlg,IDC_CHRUNINIT,BM_GETCHECK,0,0
					.if eax!=0
						or Characteristics,IMAGE_SCN_CNT_UNINITIALIZED_DATA
					.endif
					invoke SendDlgItemMessage,hDlg,IDC_CHRSHARE,BM_GETCHECK,0,0
					.if eax!=0
						or Characteristics,IMAGE_SCN_MEM_SHARED
					.endif
					invoke SendDlgItemMessage,hDlg,IDC_CHREXECUTE,BM_GETCHECK,0,0
					.if eax!=0
						or Characteristics,IMAGE_SCN_MEM_EXECUTE
					.endif
					invoke SendDlgItemMessage,hDlg,IDC_CHRREAD,BM_GETCHECK,0,0
					.if eax!=0
						or Characteristics,IMAGE_SCN_MEM_READ
					.endif
					invoke SendDlgItemMessage,hDlg,IDC_CHRWRITE,BM_GETCHECK,0,0
					.if eax!=0
						or Characteristics,IMAGE_SCN_MEM_WRITE
					.endif
					invoke EndDialog,hDlg,1	; 1== successful
				.endif
			.endif
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
NewSectionProc endp

PatchTheTarget proc  uses edi esi ebx hDlg:DWORd
	LOCAL FileAlignment:DWORD
	LOCAL SectionAlignment:DWORD
	LOCAL hBinFile:DWORD
	LOCAL PrevSectionRVA:DWORD
	LOCAL ImageBase:DWORD
	LOCAL SnippetSize:DWORD
	LOCAL hBinMapping:DWORD
	LOCAL pBinMapping:DWORD
	LOCAL buffer[512]:byte
	LOCAL buffer1[1024]:byte
	LOCAL hTempExe:DWORD
	LOCAL HeaderSize:DWORD
	LOCAL bytesWritten:DWORD
	LOCAL section:IMAGE_SECTION_HEADER
	LOCAL CurDir[1024]:byte
	LOCAL TrueHeaderSize:DWORD
	LOCAL CurrentObjectSize:DWORD
	LOCAL SizeToPad:DWORD
	LOCAL SectionRVA:DWORD
	LOCAL SectionPointer:DWORD
	LOCAL BeginVA:DWORD
	LOCAL EndVA:DWORD

	invoke GetCurrentDirectory,1024, addr CurDir
	invoke SetCurrentDirectory,addr ProjectDir
	mov esi,pPEHeader
	assume esi:ptr IMAGE_NT_HEADERS
	push [esi].OptionalHeader.ImageBase
	pop ImageBase
	push [esi].OptionalHeader.FileAlignment
	pop FileAlignment
	;-----------------------------------------
	; Create the bin file
	;-----------------------------------------
	invoke lstrcpy,addr FileName,addr BINName
	.if PatchOption==1
		push SnippetVA
		push NewSectionVA
		pop SnippetVA
		invoke ExportSnippet,hDlg
		pop SnippetVA
	.else
		invoke ExportSnippet,hDlg
	.endif
	.if eax==FALSE
		invoke SetCurrentDirectory,addr CurDir
		ret
	.endif
	;-------------------------------------------------------
	; Paste the snippet into the target
	;-------------------------------------------------------
	.if PatchOption==1		; if patch as a new section
		push [esi].OptionalHeader.SectionAlignment
		pop SectionAlignment
		invoke PrepareSpaceInSectionTable,hDlg
		;-----------------------------------------------------------------------------------
		; Now begins adding the new section to the target. We must search the section table
		; for the correct file offset to add the section. We can't use file size since
		; some files don't pad the last section :(
		;-----------------------------------------------------------------------------------
		mov edi,pSectionTable
		assume edi:ptr IMAGE_SECTION_HEADER
		mov ecx,NumSection
		xor edx,edx
		.while ecx>0
			.if edx< [edi].PointerToRawData || edx==0
				mov edx,[edi].PointerToRawData
			.endif
			add edi,sizeof IMAGE_SECTION_HEADER
			dec ecx
		.endw
		sub edi,sizeof IMAGE_SECTION_HEADER
		add edx,[edi].SizeOfRawData
		mov section.PointerToRawData,edx
		assume edi:nothing
		invoke DialogBoxParam,hInstance,IDD_NEWSECTION,hDlg,NewSectionProc,NULL		
		.if eax==1
			;------------------------------------------------------------
			; Now that we got the relocated snippet, we must pad it to
			; the file alignment unit
			;------------------------------------------------------------
			invoke SetCurrentDirectory,addr ProjectDir
			invoke CreateFile,addr FileName,GENERIC_READ+GENERIC_WRITE,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
			.if eax!=INVALID_HANDLE_VALUE
				mov hBinFile,eax
				invoke GetFileSize,hBinFile,NULL
				mov section.Misc.VirtualSize,eax
				xor edx,edx
				mov ecx,FileAlignment
				div ecx
				.if edx!=0
					inc eax
				.endif
				mov ecx,FileAlignment
				mul ecx
				mov section.SizeOfRawData,eax
				invoke SetFilePointer,hBinFile,section.SizeOfRawData,0,FILE_BEGIN
				invoke SetEndOfFile,hBinFile
				invoke CreateFileMapping,hBinFile,NULL,PAGE_READONLY,NULL,NULL,NULL
				.if eax!=NULL
					mov hBinMapping,eax
					invoke MapViewOfFile,hBinMapping,FILE_MAP_READ,NULL,NULL,NULL
					.if eax!=NULL
						mov pBinMapping,eax
					.else
						invoke CloseHandle,hBinMapping
						jmp CloseAndExit
					.endif
				.else
CloseAndExit:
					invoke CloseHandle,hBinFile
					invoke wsprintf,addr buffer,addr ErrorMapping,addr FileName
					invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
					jmp EndOfFunc
				.endif
				;------------------------------------------------
				; We now append the new section to the target
				;------------------------------------------------
				invoke SetFilePointer,hFile,section.PointerToRawData,0,FILE_BEGIN
				invoke WriteFile,hFile,pBinMapping,section.SizeOfRawData,addr buffer,NULL
				;----------------------------------------------
				; Modify pe header to recognize the new section
				;----------------------------------------------
				mov esi,pPEHeader
				assume esi:ptr IMAGE_NT_HEADERS
				inc [esi].FileHeader.NumberOfSections
				mov eax,section.Misc.VirtualSize
				xor edx,edx
				mov ecx,SectionAlignment
				div ecx
				.if edx!=0
					inc eax
				.endif
				mul ecx
				add [esi].OptionalHeader.SizeOfImage,eax
				assume esi:nothing
				add esi,sizeof IMAGE_NT_HEADERS
				mov eax,sizeof IMAGE_SECTION_HEADER
				mov ecx,NumSection
				mul ecx
				add esi,eax	; esi points to the place we can add new section info
				push esi
				push edi
				mov esi,offset NewSectionName
				lea edi,section.Name1
				mov ecx,8
				rep movsb
				pop edi
				pop esi
				mov eax,NewSectionVA
				sub eax,ImageBase
				mov section.VirtualAddress,eax
				push Characteristics
				pop section.Characteristics
				mov edx,esi
				mov edi,edx
				lea esi,section
				mov ecx,sizeof IMAGE_SECTION_HEADER
				rep movsb
				mov esi,edx
				invoke UnmapViewOfFile,pBinMapping
				invoke CloseHandle,hBinMapping
				invoke CloseHandle,hBinFile
				invoke DeleteFile,addr FileName
				;-------------------------------------------------------------------------
				; Now that we increase the size of the target exe, we must remap it
				;--------------------------------------------------------------------------
				invoke UnmapViewOfFile,pMapping
				invoke CloseHandle,hMapping
				invoke CloseHandle,hFile
				mov FPatch,FALSE
				push NewSectionVA		; save the newsectionVA!!!!!!
				push FProjectInProgress
				mov FProjectInProgress,NO_PROJECT
				invoke CheckIfValidPE,addr TargetName
				pop FProjectInProgress
				pop NewSectionVA
			.else
OpenBinError:
				invoke wsprintf,addr buffer,addr ErrorEXENotFound,addr FileName
				invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
				jmp EndOfFunc
			.endif
		.else
			jmp EndOfFunc
		.endif
	;===============================================================================================
	; Patch the snippet into an existing section or the pe header. If the user specifies some VA
	; that is larger than the size of raw data, we will pad the section upto the nearest file
	; alignment. If not, we just write the snippet into the file
	;-----------------------------------------------------------------------------------------------
	.else			; patch into existing section
		invoke CreateFile,addr FileName,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hBinFile,eax
			;--------------------------------------
			; Get the size of the snippet
			;--------------------------------------
			invoke GetFileSize,hBinFile,NULL
			mov SnippetSize,eax
			;-----------------------------------------------------
			; Check if snippet will spill over to other section
			;-----------------------------------------------------
			mov ecx,NumSection
			mov edi,pSectionTable
			assume edi:ptr IMAGE_SECTION_HEADER
			mov eax,SnippetVA
			sub eax,ImageBase		; eax ==RVA of the snippet
			mov edx,eax
			add edx,SnippetSize	; edx == RVA of the byte following the snippet
			mov BeginVA,0
			mov EndVA,0
			.while ecx>0
				.if eax>=[edi].VirtualAddress
					.if BeginVA==0
						push [edi].VirtualAddress
						pop BeginVA
					.else
						mov ebx,BeginVA
						.if ebx<[edi].VirtualAddress
							push [edi].VirtualAddress
							pop BeginVA
						.endif
					.endif
				.else
					.if EndVA==0
						push [edi].VirtualAddress
						pop EndVA
					.else
						mov ebx,EndVA
						.if ebx>[edi].VirtualAddress
							push [edi].VirtualAddress
							pop EndVA
						.endif
					.endif
				.endif
				add edi,sizeof IMAGE_SECTION_HEADER
				dec ecx
			.endw
			.if edx>=EndVA && EndVA!=0
				invoke CloseHandle,hBinFile
				invoke wsprintf,addr buffer,addr ErrorRVAOverflow,SnippetSize
				invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
				jmp EndOfFunc
			.endif
			assume edi:nothing
			invoke CreateFileMapping,hBinFile,NULL,PAGE_READONLY,NULL,NULL,NULL
			.if eax!=NULL
				mov hBinMapping,eax
				invoke MapViewOfFile,hBinMapping,FILE_MAP_READ,NULL,NULL,NULL
				.if eax!=NULL
					mov pBinMapping,eax
					mov eax,SnippetVA
					sub eax,ImageBase			; eax == RVA of the snippet
					mov PrevSectionRVA,0		; start from the pe header
					;---------------------------------------------------
					; Now check in which section the snippet should be
					; added
					;---------------------------------------------------
					mov edi,pSectionTable
					assume edi:ptr IMAGE_SECTION_HEADER
					mov ecx,NumSection
					.while ecx>0
						.if eax>=PrevSectionRVA && eax<[edi].VirtualAddress
							.break
						.else
							push [edi].VirtualAddress
							pop PrevSectionRVA
						.endif
						add edi,sizeof IMAGE_SECTION_HEADER
						dec ecx
					.endw
					;----------------------------------------------------------------------
					; Now we must check the raw offset of the snippet against the
					; limit of the raw data of the section. If it stays within
					; the raw data limit, we check further if there is enough space
					; to store the snippet. If there is not enough space or the raw offset
					; of the snippet is beyond the raw data limit, we add more space to the
					; section.
					;-----------------------------------------------------------------------
					.if PrevSectionRVA==0	; if the snippet will be stored in the pe header
						;----------------------------------------
						; Search for the smallest raw offset
						;----------------------------------------
						mov edi,pSectionTable
						mov ecx,NumSection
						xor edx,edx
						.while ecx>0
							.if edx>[edi].PointerToRawData || edx==0
								mov edx,[edi].PointerToRawData
							.endif
							add edi,sizeof IMAGE_SECTION_HEADER
							dec ecx
						.endw
						mov CurrentObjectSize,edx
						;----------------------------------------------------
						; edx contains the raw size of the pe header
						; We must check the offset of the snippet against
						; this value
						;----------------------------------------------------
						mov eax,SnippetVA
						sub eax,ImageBase		; eax is the relative offset from the image base
						.if eax>=edx		; if the snippet offset is beyond the limit of the pe header
							add eax,SnippetSize
							sub eax,edx		; eax == size to add
						.else
							add eax,SnippetSize
							.if eax<=edx		; if the snippet can be stored in the pe header, we won't have to do anything further
								mov eax,0	
							.else
								sub eax,edx		; eax == size to add
							.endif
						.endif
						.if eax!=0	; if some space must be added, we must pad it to the nearest file alignment 
							xor edx,edx
							mov ecx,FileAlignment
							div ecx
							.if edx!=0
								inc eax
							.endif
							mov ecx,FileAlignment
							mul ecx		; eax now contains the size to be added to the pe header
							mov SizeToPad,eax
							assume edi:nothing
							;--------------------------------------------------------------------------
							; Create the temporary file in the same dir as the target but it has .icz
							; extension.
							;--------------------------------------------------------------------------
							invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyTarget,addr buffer,addr buffer,512,addr FullProjININame
							invoke lstrlen,addr buffer
							mov ecx,eax
							lea edi,buffer
							mov al,"."
							repne scasb
							.if ZERO?
								dec edi
								push esi
								mov esi,offset ICZ
								mov ecx,4
								rep movsb
								pop esi
								mov byte ptr [edi],0
							.else
								invoke lstrcat,addr buffer,addr ICZ
							.endif
							invoke CreateFile,addr buffer,GENERIC_READ+GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
							.if eax!=INVALID_HANDLE_VALUE
								mov hTempExe,eax
								;---------------------------------------------------
								; increase the size of headers member 
								;---------------------------------------------------
								mov eax,SizeToPad
								mov esi,pPEHeader
								assume esi:ptr IMAGE_NT_HEADERS
								add [esi].OptionalHeader.SizeOfHeaders,eax
								;--------------------------------------------------------------------------------
								; Modify the PointerToRawData members
								;--------------------------------------------------------------------------------
								mov edi,pSectionTable
								assume edi:ptr IMAGE_SECTION_HEADER
								mov ecx,NumSection
								mov eax,SizeToPad
								.while ecx>0
									add [edi].PointerToRawData,eax
									add edi,sizeof IMAGE_SECTION_HEADER
									dec ecx
								.endw
								assume edi:nothing
								invoke WriteFile,hTempExe,pMapping,CurrentObjectSize,addr bytesWritten,NULL
								;-----------------------------------------------------------------
								; Now we must pad the pe header by setting a new end of file
								;-----------------------------------------------------------------
								mov ecx,CurrentObjectSize
								add ecx,SizeToPad
								invoke SetFilePointer,hTempExe,ecx,0,FILE_BEGIN
								invoke SetEndOfFile,hTempExe
								;----------------------------------------------------------------
								; now write the rest of the file
								;----------------------------------------------------------------
								invoke GetFileSize,hFile,NULL
								sub eax,CurrentObjectSize
								mov ecx,eax
								mov edx,pMapping
								add edx,CurrentObjectSize
								invoke WriteFile,hTempExe,edx,ecx,addr bytesWritten,NULL
								invoke CloseHandle,hTempExe
								;----------------------------------------------------------------
								; Delete the original target file and rename the temp file to
								; the original target filename
								;----------------------------------------------------------------
								invoke UnmapViewOfFile,pMapping
								invoke CloseHandle,hMapping
								invoke CloseHandle,hFile
								invoke DeleteFile,addr TargetName
								.if eax!=0
									invoke MoveFile,addr buffer,addr TargetName
									mov FPatch,FALSE
									push FProjectInProgress
									mov FProjectInProgress,NO_PROJECT
									invoke CheckIfValidPE,addr TargetName
									pop FProjectInProgress
								.else
									invoke UnmapViewOfFile,pBinMapping
									invoke CloseHandle,hBinMapping
									invoke CloseHandle,hBinFile
									mov FPatch,FALSE
									push FProjectInProgress
									mov FProjectInProgress,NO_PROJECT
									invoke CheckIfValidPE,addr TargetName
									invoke wsprintf,addr buffer,addr ErrorDeletingEXE,addr TargetName
									invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
									jmp EndOfFunc
								.endif
							.else
								invoke UnmapViewOfFile,pBinMapping
								invoke CloseHandle,hBinMapping
								invoke CloseHandle,hBinFile
								invoke wsprintf,addr buffer1,addr ErrorCreatingTempExe,addr buffer
								invoke MessageBox,hDlg,addr buffer1,addr AppName,MB_OK+MB_ICONERROR
								jmp EndOfFunc
							.endif
						.endif
					.else
						sub edi, sizeof IMAGE_SECTION_HEADER	; edi now points to the section info of the section that the snippet will be in
						;---------------------------------------------------
						; calculate the size that we must pad into this section
						;-----------------------------------------------------
						assume edi:ptr IMAGE_SECTION_HEADER
						mov eax,[edi].VirtualAddress
						add eax,[edi].SizeOfRawData	; eax is the RVA that points to the first uncommitted byte after the data
						mov edx,SnippetVA
						sub edx,ImageBase
						add edx,SnippetSize
						sub edx,eax			; edx is the number of bytes we must pad
						mov eax,edx
						xor edx,edx
						mov ecx,FileAlignment
						div ecx
						.if edx!=0
							inc eax
						.endif
						mov ecx,FileAlignment
						mul ecx
						mov SizeToPad,eax		; Now we got the size to pad
						push [edi].SizeOfRawData
						pop CurrentObjectSize
						push [edi].VirtualAddress
						pop SectionRVA
						push [edi].PointerToRawData
						pop SectionPointer
						invoke AddSpaceToSection,pMapping,edi,SizeToPad
						.if eax==FALSE
							invoke UnmapViewOfFile,pBinMapping
							invoke CloseHandle,hBinMapping
							invoke CloseHandle,hBinFile
							ret
						.endif
					.endif
					assume edi:nothing
					mov eax,SnippetVA
					;------------------------------------------------
					; RVA of the target section is in PrevSectionRVA
					; now write the snippet into the file
					;------------------------------------------------
					invoke AddressToOffset,pMapping,eax
					mov esi,pBinMapping
					mov edi,pMapping
					add edi,eax
					mov ecx,SnippetSize
					rep movsb
					;------------------------------------------------
					; Now check the section characteristics
					;------------------------------------------------
					.if PrevSectionRVA!=0		; if the patch location is not in the pe header
						mov edi,pSectionTable
						mov eax,PrevSectionRVA
						assume edi:ptr IMAGE_SECTION_HEADER
						mov ecx,NumSection
						.while ecx>0
							.if eax==[edi].VirtualAddress		
								;---------------------------------------------
								; Change the characteristics
								;---------------------------------------------
								or [edi].Characteristics,IMAGE_SCN_CNT_CODE
								or [edi].Characteristics,IMAGE_SCN_MEM_EXECUTE
								or [edi].Characteristics,IMAGE_SCN_MEM_READ
								or [edi].Characteristics,IMAGE_SCN_MEM_WRITE
								;---------------------------------------------
								; Change the virtual size
								;---------------------------------------------
								mov eax,SnippetVA
								sub eax,ImageBase			; eax == RVA of the snippet
								add eax,SnippetSize
								sub eax,[edi].VirtualAddress
								.if eax>[edi].Misc.VirtualSize
									mov [edi].Misc.VirtualSize,eax
								.endif
							.endif
							add edi,sizeof IMAGE_SECTION_HEADER
							dec ecx
						.endw
						assume edi:nothing
					.endif
					invoke UnmapViewOfFile,pBinMapping
					invoke CloseHandle,hBinMapping
					invoke CloseHandle,hBinFile
				.else
					invoke CloseHandle,hBinMapping
					jmp CloseAndExit
				.endif
			.else
				jmp CloseAndExit
			.endif
		.else	
			jmp OpenBinError
		.endif
	.endif
	invoke AddRelocInfoToTarget,hDlg
	;---------------------------------------------------
	; Redirect the flow to the snippet
	;---------------------------------------------------
	mov esi,pPEHeader
	assume esi:ptr IMAGE_NT_HEADERS
	.if RedirectOption==1		; if redirect eprva
		.if PatchOption==1	; if new section is created
			mov eax,NewSectionVA
		.else
			mov eax,SnippetVA
		.endif
		sub eax,ImageBase
		mov [esi].OptionalHeader.AddressOfEntryPoint,eax
	.elseif RedirectOption==2	; if redirect from existing code
		invoke AddressToOffset,pMapping,PatchVA
		mov edi,eax		; edi points to the redirect point
		add edi,pMapping
		mov byte ptr [edi],68h
		inc edi
		.if PatchOption==1	; if we patch the snippet as a new section, we must redirect it to the new section
			push NewSectionVA
		.else
			push SnippetVA
		.endif
		pop dword ptr [edi]
		add edi,4
		mov byte ptr [edi],0C3h
		;--------------------------------------------------------------------------------
		; Check if restoration of overwritten instruction is specified. If so, we must
		; change the characteristics of the overwritten section to be writable.
		;--------------------------------------------------------------------------------
		mov esi,pSectionTable
		assume esi:ptr IMAGE_SECTION_HEADER
		mov ecx,NumSection
		mov eax,PatchVA
		sub eax,ImageBase
		.while ecx>0
			.if eax>=[esi].VirtualAddress
				mov edx,[esi].VirtualAddress
				add edx,[esi].SizeOfRawData
				.if eax<edx
					or [esi].Characteristics,IMAGE_SCN_MEM_WRITE
				.endif
			.endif
			add esi,sizeof IMAGE_SECTION_HEADER
			dec ecx
		.endw
	.elseif RedirectOption==3
		.if PatchOption==1
			invoke AddressToOffset,pMapping,NewSectionVA
		.elseif PatchOption==2
			invoke AddressToOffset,pMapping,PatchVA
		.endif
		add eax,pMapping
		mov esi,eax
		.if byte ptr [esi]==0E8h
			inc esi
			mov eax,PatchVA
			add eax,5
			mov edx,SnippetVA
			sub edx,eax
			mov dword ptr [esi],edx
		.else
		.endif
	.endif
	.if PatchOption==1
		mov esi,pPEHeader
		assume esi:ptr IMAGE_NT_HEADERS
		mov eax,[esi].OptionalHeader.SizeOfImage
		add eax,[esi].OptionalHeader.ImageBase
		mov NewSectionVA,eax		
		assume esi:nothing
	.endif
	invoke MessageBox,NULL,addr PatchSuccessful,addr AppName,MB_OK+MB_ICONINFORMATION
EndOfFunc:
	invoke SetCurrentDirectory,addr CurDir
	assume esi:nothing
	ret
PatchTheTarget endp

ManagePopupMenuItem proc
	;-------------------------------------------------
	; Check the flags to see which menuitems should be
	; enabled/grayed.
	;--------------------------------------------------
	.if FProjectInProgress!=NO_PROJECT
		;---------------------------------------------
		; Enable popup menu items
		;---------------------------------------------
		invoke EnableMenuItem,hMenuPopup,IDM_CUT,MF_ENABLED
		invoke EnableMenuItem,hMenuPopup,IDM_COPY,MF_ENABLED
		invoke EnableMenuItem,hMenuPopup,IDM_SELECTALL,MF_ENABLED
		invoke EnableMenuItem,hMenuPopup,IDM_UNDO,MF_ENABLED
		invoke IsClipboardFormatAvailable,CF_TEXT
		.if eax!=0
			invoke EnableMenuItem,hMenuPopup,IDM_PASTE,MF_ENABLED
		.else
			invoke EnableMenuItem,hMenuPopup,IDM_PASTE,MF_GRAYED
		.endif
		invoke CloseClipboard
	.else
		;--------------------------------------------
		; Disable popup menu
		;--------------------------------------------
		invoke EnableMenuItem,hMenuPopup,IDM_SELECTALL,MF_GRAYED
		invoke EnableMenuItem,hMenuPopup,IDM_CUT,MF_GRAYED
		invoke EnableMenuItem,hMenuPopup,IDM_COPY,MF_GRAYED
		invoke EnableMenuItem,hMenuPopup,IDM_PASTE,MF_GRAYED
		invoke EnableMenuItem,hMenuPopup,IDM_UNDO,MF_GRAYED
	.endif
	ret
ManagePopupMenuItem endp

PopupMenuCreate proc
	LOCAL menuinfo:MENUITEMINFO
	invoke CreatePopupMenu
	mov hMenuPopup,eax
	mov menuinfo.cbSize,sizeof MENUITEMINFO

	mov menuinfo.fMask,MIIM_TYPE + MIIM_ID
	mov menuinfo.wID,IDM_UNDO
	mov menuinfo.fType,MFT_STRING
	mov menuinfo.dwTypeData,offset UNDOString
	invoke lstrlen,addr UNDOString
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hMenuPopup,IDM_UNDO,FALSE,addr menuinfo

	;-----------------------------
	; Menu separator
	;-----------------------------
	mov menuinfo.fMask,MIIM_TYPE
	mov menuinfo.wID,NULL
	mov menuinfo.dwTypeData,NULL
	mov menuinfo.fType,MFT_SEPARATOR
	mov menuinfo.cch,NULL
	invoke InsertMenuItem,hMenuPopup,1,TRUE,addr menuinfo

	mov menuinfo.fMask,MIIM_TYPE + MIIM_ID
	mov menuinfo.fType,MFT_STRING
	mov menuinfo.wID,IDM_COPY
	mov menuinfo.dwTypeData,offset COPYString
	invoke lstrlen,addr COPYString
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hMenuPopup,IDM_COPY,FALSE,addr menuinfo
	mov menuinfo.wID,IDM_CUT
	mov menuinfo.dwTypeData,offset CUTString
	invoke lstrlen,addr CUTString
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hMenuPopup,IDM_CUT,FALSE,addr menuinfo
	mov menuinfo.wID,IDM_PASTE
	mov menuinfo.dwTypeData,offset PASTEString
	invoke lstrlen,addr PASTEString
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hMenuPopup,IDM_PASTE,FALSE,addr menuinfo

	mov menuinfo.wID,IDM_DELETE
	mov menuinfo.dwTypeData,offset DeleteString
	invoke lstrlen,addr DeleteString
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hMenuPopup,IDM_DELETE,FALSE,addr menuinfo

	;-----------------------------
	; Menu separator
	;-----------------------------
	mov menuinfo.fMask,MIIM_TYPE
	mov menuinfo.wID,NULL
	mov menuinfo.dwTypeData,NULL
	mov menuinfo.fType,MFT_SEPARATOR
	mov menuinfo.cch,NULL
	invoke InsertMenuItem,hMenuPopup,6,TRUE,addr menuinfo

	mov menuinfo.fMask,MIIM_TYPE + MIIM_ID
	mov menuinfo.wID,IDM_SELECTALL
	mov menuinfo.fType,MFT_STRING
	mov menuinfo.dwTypeData,offset SelectAllString
	invoke lstrlen,addr SelectAllString
	mov menuinfo.cch,eax
	invoke InsertMenuItem,hMenuPopup,IDM_SELECTALL,FALSE,addr menuinfo
	ret
PopupMenuCreate endp

OpenProject proc hDlg:DWORD
	LOCAL buffer[1024]:byte
	LOCAL edits:EDITSTREAM
	LOCAL bytesread:DWORD
	LOCAL CurDir[1024]:byte

	invoke lstrcpy,addr buffer,addr DefaultINI
	invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeySnippetVA,addr buffer,addr buffer,1024,addr FileName
	invoke lstrcmp,addr buffer,addr DefaultINI
	.if eax==0
		invoke MessageBox,hDlg,addr ErrorInvalidProjectINI,addr AppName,MB_OK+MB_ICONERROR		
	.else
		invoke HexString2Dword,addr buffer
		mov SnippetVA,eax
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyPatchOption,addr buffer,addr buffer,1024,addr FileName
		invoke HexString2Dword,addr buffer
		mov PatchOption,eax
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyRedirect,addr buffer,addr buffer,1024,addr FileName
		invoke HexString2Dword,addr buffer
		mov RedirectOption,eax
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyRedirectVA,addr buffer,addr buffer,1024,addr FileName
		invoke HexString2Dword,addr buffer
		mov PatchVA,eax
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyReturn,addr buffer,addr buffer,1024,addr FileName
		invoke HexString2Dword,addr buffer
		mov ReturnOption,eax
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyReturnVA,addr buffer,addr buffer,1024,addr FileName
		invoke HexString2Dword,addr buffer
		mov ReturnVA,eax
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyRestore,addr buffer,addr buffer,1024,addr FileName
		invoke HexString2Dword,addr buffer
		mov RestoreOption,eax
		;--------------------------------------------------
		; Retrieve the target filename
		;--------------------------------------------------
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyTarget,addr buffer,addr buffer,1024,addr FileName
		invoke lstrlen,addr buffer
		.if eax!=0
			invoke CheckIfValidPE,addr buffer
			.if eax==TRUE
				invoke lstrcpy,addr TargetName,addr buffer
				mov FPatch,TRUE
			.else
				mov byte ptr [buffer],0
				mov FPatch,FALSE
				invoke WritePrivateProfileString,addr MainINISection,addr ProjINIKeyTarget,addr buffer,addr FileName
			.endif
		.endif
		;------------------------------------------
		; fill project directory
		;------------------------------------------
		invoke lstrcpy,addr FullProjININame,addr FileName
		mov ax,ofn.nFileOffset
		movzx eax,ax
		push eax
		invoke lstrcpyn,addr ProjectDir,addr FileName,eax
		invoke GetDlgItem,hDlg,IDC_CODEEDIT
		push eax
		invoke EnableWindow,eax,TRUE
		pop eax
		invoke SetFocus,eax
		invoke GetDlgItem,hDlg,IDC_ASSEMBLE
		invoke EnableWindow,eax,TRUE
		pop eax
		;-----------------------------------------
		; fill project name
		;-----------------------------------------
		lea edx,FileName
		add edx,eax
		mov cx,ofn.nFileExtension
		movzx ecx,cx
		sub ecx,eax
		invoke lstrcpyn,addr ProjectName,edx,ecx
		invoke SetDlgItemText,hDlg,IDC_CODEBOX,addr ProjectName
		;-------------------------------------------------------
		; Find the assembler used
		;-------------------------------------------------------
		invoke GetPrivateProfileString,addr MainINISection,addr MainINIKeyCurASM,addr buffer,addr buffer,1024,addr FullININame
		invoke lstrcmp,addr buffer,addr MASM
		.if eax==0
			mov CurrentASM,0
		.else
			mov CurrentASM,1
		.endif
		;--------------------------------------------------------
		; Create the filenames
		;--------------------------------------------------------
		call CreateFileNames
		;----------------------------------------------------------
		; Read the content of .src file into the richedit control
		;----------------------------------------------------------
		invoke GetCurrentDirectory,1024, addr CurDir
		invoke SetCurrentDirectory,addr ProjectDir
		invoke CreateFile,addr SRCName,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hAsm,eax
			mov edits.dwCookie,0
			mov edits.dwError,0
			mov edits.pfnCallback,offset FillProc
			invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,EM_STREAMIN,SF_TEXT,addr edits
			invoke CloseHandle,hAsm
		.endif
		invoke SetCurrentDirectory,addr CurDir
		mov FProjectInProgress,PROJECT_OPENED
	.endif
	ret
OpenProject endp

FillProc proc Cookie:DWORD,lpBuffer:DWORD,Count:DWORD,lpBytesRead:DWORD
	invoke ReadFile,hAsm,lpBuffer,Count,lpBytesRead,NULL
	mov eax,lpBytesRead
	.if eax!=Count
		xor eax,eax
	.else
		mov eax,1
	.endif
	ret
FillProc endp

CreateFileNames proc
	invoke lstrcpy,addr EXEName,addr ProjectName
	invoke lstrcat,addr EXEName,addr EXE
	invoke lstrcpy,addr OBJName,addr ProjectName
	invoke lstrcat,addr OBJName,addr OBJ
	invoke lstrcpy,addr BINName,addr ProjectName
	invoke lstrcat,addr BINName,addr BIN
	invoke lstrcpy,addr SRCName,addr ProjectName
	invoke lstrcat,addr SRCName,addr SRC
	invoke lstrcpy,addr ASMName,addr ProjectName
	invoke lstrcat,addr ASMName,addr ASM
	invoke lstrcpy,addr ININame,addr ProjectName
	invoke lstrcat,addr ININame,addr INI
	ret
CreateFileNames endp

SaveRichEditContent proc hDlg:DWORD
	LOCAL edits:EDITSTREAM
	LOCAL CurDir[1024]:byte

	invoke GetCurrentDirectory,1024, addr CurDir
	invoke SetCurrentDirectory,addr ProjectDir
	invoke CreateFile,addr SRCName,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,NULL
	.if eax!=INVALID_HANDLE_VALUE
		mov hAsm,eax
		mov edits.dwCookie,0
		mov edits.dwError,0
		mov edits.pfnCallback,offset SaveFunc
		invoke SendDlgItemMessage,hDlg,IDC_CODEEDIT,EM_STREAMOUT,SF_TEXT,addr edits
		invoke MessageBox,hDlg,addr SaveComplete,addr AppName,MB_OK+MB_ICONINFORMATION
	.else
		invoke MessageBox,hDlg,addr ErrorSaving,addr AppName,MB_OK+MB_ICONERROR
	.endif
	invoke CloseHandle,hAsm
	invoke SetCurrentDirectory,addr CurDir
	ret
SaveRichEditContent endp

SaveFunc proc dwCookie:DWORD,lpBuffer:DWORD,Count:DWORD,lpBytesRead:DWORD
	.if Count==0
		mov eax,1
	.else
		invoke WriteFile,hAsm,lpBuffer,Count,lpBytesRead,NULL
		xor eax,eax
	.endif
	ret
SaveFunc endp

ProjectInfoProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[512]:byte
	.if uMsg==WM_INITDIALOG
		invoke SetDlgItemText,hDlg,IDC_PROJECTNAME,addr ProjectName
		invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyTarget,addr buffer,addr buffer,512,addr FullProjININame
		invoke SetDlgItemText,hDlg,IDC_TARGETINFO,addr buffer
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if ax==IDC_OKINFO
			.if dx==BN_CLICKED
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
ProjectInfoProc endp

DataDirectoryProc proc  hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[64]:BYTE
	.if uMsg==WM_INITDIALOG
		invoke SetTitle,hDlg
		;----------------------------
		; subclass the edit controls
		;----------------------------
		invoke GetDlgItem,hDlg,IDC_EXPORTADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		mov OldWinProc,eax
		invoke GetDlgItem,hDlg,IDC_EXPORTSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_IMPORTADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_IMPORTSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_RESOURCEADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_RESOURCESIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_EXCEPTIONADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_EXCEPTIONSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_SECURITYADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_SECURITYSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_RELOCATIONADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_RELOCATIONSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_DEBUGADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_DEBUGSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_COPYRIGHTADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_COPYRIGHTSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_GLOBALPTRADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_GLOBALPTRSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_TLSADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_TLSSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_LOADCONFIGADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_LOADCONFIGSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_BOUNDIMPORTADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_BOUNDIMPORTSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_IATADDR
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		invoke GetDlgItem,hDlg,IDC_IATSIZE
		invoke SetWindowLong,eax,GWL_WNDPROC,addr EditProc
		;-------------------
		; Initialize the controls
		;--------------------------
		push edi
		mov edi,pPEHeader
		assume edi:ptr IMAGE_NT_HEADERS
		;-------------
		; Export
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*0].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_EXPORTADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*0].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_EXPORTSIZE,addr buffer
		;-------------
		; Import
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*1].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_IMPORTADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*1].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_IMPORTSIZE,addr buffer
		;-------------
		; resource
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*2].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_RESOURCEADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*2].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_RESOURCESIZE,addr buffer
		;-------------
		; Exception
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*3].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_EXCEPTIONADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*3].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_EXCEPTIONSIZE,addr buffer
		;-------------
		; security
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*4].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_SECURITYADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*4].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_SECURITYSIZE,addr buffer
		;-------------
		; Basereloc
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*5].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_RELOCATIONADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*5].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_RELOCATIONSIZE,addr buffer
		;-------------
		; debug
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*6].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_DEBUGADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*6].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_DEBUGSIZE,addr buffer
		;-------------
		; copyright
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*7].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_COPYRIGHTADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*7].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_COPYRIGHTSIZE,addr buffer
		;-------------
		; globalptr
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*8].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_GLOBALPTRADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*8].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_GLOBALPTRSIZE,addr buffer
		;-------------
		; tls
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*9].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_TLSADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*9].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_TLSSIZE,addr buffer
		;-------------
		; load config
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*10].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_LOADCONFIGADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*10].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_LOADCONFIGSIZE,addr buffer
		;-------------
		; bound import
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*11].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_BOUNDIMPORTADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*11].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_BOUNDIMPORTSIZE,addr buffer
		;-------------
		; IAT
		;------------
		mov edx,[edi].OptionalHeader.DataDirectory[8*12].VirtualAddress
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_IATADDR,addr buffer
		mov edx,[edi].OptionalHeader.DataDirectory[8*12].isize
		invoke wsprintf,addr buffer,addr SectionTemplate,edx
		invoke SetDlgItemText,hDlg,IDC_IATSIZE,addr buffer
		assume edi:nothing
		pop edi
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if dx==BN_CLICKED
			.if ax==IDC_SAVEDATA
				push edi
				mov edi,pPEHeader
				assume edi:ptr IMAGE_NT_HEADERS
				;----------------
				; EXPORT
				;----------------
				invoke GetDlgItemText,hDlg,IDC_EXPORTADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*0].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_EXPORTSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*0].isize,eax
				;----------------
				; import
				;----------------
				invoke GetDlgItemText,hDlg,IDC_IMPORTADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*1].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_IMPORTSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*1].isize,eax
				;----------------
				; RESOURCE
				;----------------
				invoke GetDlgItemText,hDlg,IDC_RESOURCEADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*2].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_RESOURCESIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*2].isize,eax
				;----------------
				; EXCEPTION
				;----------------
				invoke GetDlgItemText,hDlg,IDC_EXCEPTIONADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*3].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_EXCEPTIONSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*3].isize,eax
				;----------------
				; SECURITY
				;----------------
				invoke GetDlgItemText,hDlg,IDC_SECURITYADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*4].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_SECURITYSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*4].isize,eax
				;----------------
				; BASERELOC
				;----------------
				invoke GetDlgItemText,hDlg,IDC_RELOCATIONADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*5].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_RELOCATIONSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*5].isize,eax
				;----------------
				; DEBUG
				;----------------
				invoke GetDlgItemText,hDlg,IDC_DEBUGADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*6].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_DEBUGSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*6].isize,eax
				;----------------
				; COPYRIGHT
				;----------------
				invoke GetDlgItemText,hDlg,IDC_COPYRIGHTADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*7].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_COPYRIGHTSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*7].isize,eax
				;----------------
				; GLOBALPTR
				;----------------
				invoke GetDlgItemText,hDlg,IDC_GLOBALPTRADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*8].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_GLOBALPTRSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*8].isize,eax
				;----------------
				; TLS
				;----------------
				invoke GetDlgItemText,hDlg,IDC_TLSADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*9].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_TLSSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*9].isize,eax
				;----------------
				; LOAD CONFIG
				;----------------
				invoke GetDlgItemText,hDlg,IDC_LOADCONFIGADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*10].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_LOADCONFIGSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*10].isize,eax
				;----------------
				; BOUND IMPORT
				;----------------
				invoke GetDlgItemText,hDlg,IDC_BOUNDIMPORTADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*11].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_BOUNDIMPORTSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*11].isize,eax
				;----------------
				; IAT
				;----------------
				invoke GetDlgItemText,hDlg,IDC_IATADDR,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*12].VirtualAddress,eax
				invoke GetDlgItemText,hDlg,IDC_IATSIZE,addr buffer,64
				invoke HexString2Dword,addr buffer
				mov [edi].OptionalHeader.DataDirectory[8*12].isize,eax
				pop edi
				assume edi:nothing
				invoke MessageBox,hDlg,addr DataSaved,addr AppName,MB_OK+MB_ICONINFORMATION
			.elseif ax==IDC_CANCELDATA
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
DataDirectoryProc endp

CloseProject proc hDlg:DWORD
	.if FProjectInProgress!=NO_PROJECT
		.if FProjectInProgress!=TARGET_ONLY
			invoke MessageBox,hDlg,addr CloseConfirmation1,addr AppName,MB_YESNO+MB_ICONQUESTION
			.if eax==IDYES
				mov FProjectInProgress,NO_PROJECT
				.if FPatch==TRUE
					invoke UnmapViewOfFile,pMapping
					invoke CloseHandle,hMapping
					invoke CloseHandle,hFile
					mov FPatch,FALSE
				.endif
				invoke SetDlgItemText,hDlg,IDC_CODEBOX,addr NoProject
				invoke SetDlgItemText,hDlg,IDC_CODEEDIT,NULL
				invoke GetDlgItem,hDlg,IDC_CODEEDIT
				invoke EnableWindow,eax,FALSE
				invoke GetDlgItem,hDlg,IDC_ASSEMBLE
				invoke EnableWindow,eax,FALSE
				invoke SetFocus,hDlg
				mov eax,TRUE
			.else
				mov eax,FALSE
			.endif
		.else
			invoke UnmapViewOfFile,pMapping
			invoke CloseHandle,hMapping
			invoke CloseHandle,hFile
			mov eax,TRUE
		.endif
	.else
		mov eax,TRUE
	.endif
	ret
CloseProject endp

ParseName proc uses edi esi ecx lpFullPath:DWORD
	mov edi,lpFullPath
	invoke lstrlen,lpFullPath
	mov ecx,eax
	dec eax
	add edi,eax		; edi points to the last char of the full path
	std
	mov al,"\"
	repne scasb
	.if ZERO?
		mov eax,edi
		inc eax
		inc eax
	.else
		mov eax,lpFullPath
	.endif
	cld
	ret
ParseName endp

SaveSectionToDisk proc uses edi hDlg:DWORD, nIndex:DWORD
	LOCAL hTemp:DWORD
	LOCAL bytesWritten:DWORD
	mov edi,pSectionTable
	mov eax,nIndex
	mov ecx,sizeof IMAGE_SECTION_HEADER
	mul ecx
	add edi,eax
	assume edi:ptr IMAGE_SECTION_HEADER	; edi points to the section info to be saved
	mov ofn.lStructSize,SIZEOF ofn
	push hDlg
	pop  ofn.hWndOwner
	push hInstance
	pop  ofn.hInstance
	mov  ofn.lpstrFilter, OFFSET SectionFilterString
	invoke lstrcpyn,addr FileName,edi,9
	mov  ofn.lpstrFile, OFFSET FileName
	mov  ofn.nMaxFile,sizeof FileName
	mov ofn.Flags,OFN_LONGNAMES or OFN_NOCHANGEDIR or\
		 OFN_EXPLORER or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
	invoke GetSaveFileName,addr ofn
	.if eax!=0
		invoke CreateFile,addr FileName,GENERIC_READ+GENERIC_WRITE,FILE_SHARE_WRITE+FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hTemp,eax
			mov edx,[edi].PointerToRawData
			add edx,pMapping
			;------------------------------------------------
			; Now calculate the size to copy
			; We compare virtual size and raw size.
			; We will choose the smallest value , if not zero
			;-------------------------------------------------
			.if [edi].Misc.VirtualSize!=0 || [edi].SizeOfRawData!=0
				mov ecx,[edi].SizeOfRawData
				.if ecx>[edi].Misc.VirtualSize
					mov ecx,[edi].Misc.VirtualSize
				.endif
				invoke WriteFile,hTemp,edx,ecx,addr bytesWritten,NULL
			.endif
			invoke MessageBox,hDlg,addr DataSaved,addr AppName,MB_OK+MB_ICONINFORMATION
			invoke CloseHandle,hTemp
		.else
			invoke ShowErrorMessage,hDlg
		.endif
	.endif
	assume edi:nothing
	ret
SaveSectionToDisk endp

FillCombo proc uses edi esi hDlg:DWORD
	LOCAL Index:DWORD
	mov edi,pPEHeader
	assume edi:ptr IMAGE_NT_HEADERS
	mov si,[edi].FileHeader.Machine
	mov Index,0
	;------------------------------------------------
	; Clear and fill the machine combo box
	;------------------------------------------------
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_RESETCONTENT,0,0
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr Unknown
	.if si==0
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,0
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr I386
	.if si==IMAGE_FILE_MACHINE_I386
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_I386
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr R3000
	.if si==IMAGE_FILE_MACHINE_R3000
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_R3000
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr R4000
	.if si==IMAGE_FILE_MACHINE_R4000
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_R4000
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr R10000
	.if si==IMAGE_FILE_MACHINE_R10000
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_R10000
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr WCEMIPSV2
	.if si==IMAGE_FILE_MACHINE_WCEMIPSV2
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_WCEMIPSV2
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr Alpha
	.if si==IMAGE_FILE_MACHINE_ALPHA
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_ALPHA
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr PowerPC
	.if si==IMAGE_FILE_MACHINE_POWERPC
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_POWERPC
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr SH3
	.if si==IMAGE_FILE_MACHINE_SH3
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_SH3
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr SH3E
	.if si==IMAGE_FILE_MACHINE_SH3E
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_SH3E
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr SH4
	.if si==IMAGE_FILE_MACHINE_SH4
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_SH4
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr ARM
	.if si==IMAGE_FILE_MACHINE_ARM
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_ARM
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr Thumb
	.if si==IMAGE_FILE_MACHINE_THUMB
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_THUMB
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr IA64
	.if si==IMAGE_FILE_MACHINE_IA64
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_IA64
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr Mips16
	.if si==IMAGE_FILE_MACHINE_MIPS16
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_MIPS16
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr MipsFpu
	.if si==IMAGE_FILE_MACHINE_MIPSFPU
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_MIPSFPU
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr MipsFpu16
	.if si==IMAGE_FILE_MACHINE_MIPSFPU16
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_MIPSFPU16
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr Alpha64
	.if si==IMAGE_FILE_MACHINE_ALPHA64
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_ALPHA64
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_ADDSTRING,0,addr AXP64
	.if si==IMAGE_FILE_MACHINE_AXP64
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETITEMDATA,eax,IMAGE_FILE_MACHINE_AXP64
	invoke SendDlgItemMessage,hDlg,IDC_MACHINECOMBO,CB_SETCURSEL,Index,0
	;-----------------------------------------------
	; Now we fill the subsystem combo box
	;-----------------------------------------------
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_RESETCONTENT,0,0
	mov Index,0
	mov si,[edi].OptionalHeader.Subsystem
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_ADDSTRING,0,addr UnknownSubsystem
	.if si==IMAGE_SUBSYSTEM_UNKNOWN
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETITEMDATA,eax,IMAGE_SUBSYSTEM_UNKNOWN
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_ADDSTRING,0,addr Native
	.if si==IMAGE_SUBSYSTEM_NATIVE
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETITEMDATA,eax,IMAGE_SUBSYSTEM_NATIVE
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_ADDSTRING,0,addr WinGUI
	.if si==IMAGE_SUBSYSTEM_WINDOWS_GUI
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETITEMDATA,eax,IMAGE_SUBSYSTEM_WINDOWS_GUI
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_ADDSTRING,0,addr WinConsole
	.if si==IMAGE_SUBSYSTEM_WINDOWS_CUI
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETITEMDATA,eax,IMAGE_SUBSYSTEM_WINDOWS_CUI
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_ADDSTRING,0,addr OS2Console
	.if si==IMAGE_SUBSYSTEM_OS2_CUI
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETITEMDATA,eax,IMAGE_SUBSYSTEM_OS2_CUI
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_ADDSTRING,0,addr POSIXConsole
	.if si==IMAGE_SUBSYSTEM_POSIX_CUI
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETITEMDATA,eax,IMAGE_SUBSYSTEM_POSIX_CUI
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_ADDSTRING,0,addr NativeWin
	.if si==IMAGE_SUBSYSTEM_NATIVE_WINDOWS
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETITEMDATA,eax,IMAGE_SUBSYSTEM_NATIVE_WINDOWS
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_ADDSTRING,0,addr WinCEGUI
	.if si==IMAGE_SUBSYSTEM_WINDOWS_CE_GUI
		mov Index,eax
	.endif
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETITEMDATA,eax,IMAGE_SUBSYSTEM_WINDOWS_CE_GUI
	invoke SendDlgItemMessage,hDlg,IDC_SUBSYSTEMCOMBO,CB_SETCURSEL,Index,0
	assume edi:nothing
	ret
FillCombo endp

FileCharacteristicsProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	LOCAL buffer[64]:byte
	.if uMsg==WM_INITDIALOG
		test Charac,IMAGE_FILE_RELOCS_STRIPPED
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_RELOCSTRIPPED,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_EXECUTABLE_IMAGE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_EXECUTABLE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_LINE_NUMS_STRIPPED
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_LINENUMSTRIPPED,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_LOCAL_SYMS_STRIPPED
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_LOCALSYMSTRIPPED,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_AGGRESIVE_WS_TRIM
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_WSTRIM,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_LARGE_ADDRESS_AWARE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_LARGEADDRAWARE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_BYTES_REVERSED_LO
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_REVERSEDLO,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_32BIT_MACHINE
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_32BITMACHINE,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_DEBUG_STRIPPED
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_DEBUGSTRIPPED,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_RUNFROMSWAP,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_NET_RUN_FROM_SWAP
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_NETRUNFROMSWAP,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_SYSTEM
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_FILESYSTEM,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_DLL
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_FILEDLL,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_UP_SYSTEM_ONLY
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_SYSTEMONLY,BM_SETCHECK,BST_CHECKED,0
		.endif
		test Charac,IMAGE_FILE_BYTES_REVERSED_HI
		.if !ZERO?
			invoke SendDlgItemMessage,hDlg,IDC_REVERSEDHI,BM_SETCHECK,BST_CHECKED,0
		.endif
	.elseif uMsg==WM_CLOSE
		invoke EndDialog,hDlg,NULL
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if dx==BN_CLICKED
			.if ax==IDC_CANCELFILECHARAC
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.elseif ax==IDC_OKFILECHARAC
				invoke wsprintf,addr buffer,addr HalfSectionTemplate,Charac
				invoke GetParent,hDlg
				mov edx,eax
				invoke SetDlgItemText,edx,IDC_FILECHARAC,addr buffer
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.elseif ax==IDC_RELOCSTRIPPED
				test Charac,IMAGE_FILE_RELOCS_STRIPPED
				.if ZERO?
					or Charac,IMAGE_FILE_RELOCS_STRIPPED
				.else
					mov eax,IMAGE_FILE_RELOCS_STRIPPED
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_EXECUTABLE
				test Charac,IMAGE_FILE_EXECUTABLE_IMAGE
				.if ZERO?
					or Charac,IMAGE_FILE_EXECUTABLE_IMAGE
				.else
					mov eax,IMAGE_FILE_EXECUTABLE_IMAGE
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_LINENUMSTRIPPED
				test Charac,IMAGE_FILE_LINE_NUMS_STRIPPED
				.if ZERO?
					or Charac,IMAGE_FILE_LINE_NUMS_STRIPPED
				.else
					mov eax,IMAGE_FILE_LINE_NUMS_STRIPPED
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_LOCALSYMSTRIPPED
				test Charac,IMAGE_FILE_LOCAL_SYMS_STRIPPED
				.if ZERO?
					or Charac,IMAGE_FILE_LOCAL_SYMS_STRIPPED
				.else
					mov eax,IMAGE_FILE_LOCAL_SYMS_STRIPPED
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_WSTRIM
				test Charac,IMAGE_FILE_AGGRESIVE_WS_TRIM
				.if ZERO?
					or Charac,IMAGE_FILE_AGGRESIVE_WS_TRIM
				.else
					mov eax,IMAGE_FILE_AGGRESIVE_WS_TRIM
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_LARGEADDRAWARE
				test Charac,IMAGE_FILE_LARGE_ADDRESS_AWARE
				.if ZERO?
					or Charac,IMAGE_FILE_LARGE_ADDRESS_AWARE
				.else
					mov eax,IMAGE_FILE_LARGE_ADDRESS_AWARE
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_REVERSEDLO
				test Charac,IMAGE_FILE_BYTES_REVERSED_LO
				.if ZERO?
					or Charac,IMAGE_FILE_BYTES_REVERSED_LO
				.else
					mov eax,IMAGE_FILE_BYTES_REVERSED_LO
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_32BITMACHINE
				test Charac,IMAGE_FILE_32BIT_MACHINE
				.if ZERO?
					or Charac,IMAGE_FILE_32BIT_MACHINE
				.else
					mov eax,IMAGE_FILE_32BIT_MACHINE
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_DEBUGSTRIPPED
				test Charac,IMAGE_FILE_DEBUG_STRIPPED
				.if ZERO?
					or Charac,IMAGE_FILE_DEBUG_STRIPPED
				.else
					mov eax,IMAGE_FILE_DEBUG_STRIPPED
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_RUNFROMSWAP
				test Charac,IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP
				.if ZERO?
					or Charac,IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP
				.else
					mov eax,IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_NETRUNFROMSWAP
				test Charac,IMAGE_FILE_NET_RUN_FROM_SWAP
				.if ZERO?
					or Charac,IMAGE_FILE_NET_RUN_FROM_SWAP
				.else
					mov eax,IMAGE_FILE_NET_RUN_FROM_SWAP
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_FILESYSTEM
				test Charac,IMAGE_FILE_SYSTEM
				.if ZERO?
					or Charac,IMAGE_FILE_SYSTEM
				.else
					mov eax,IMAGE_FILE_SYSTEM
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_FILEDLL
				test Charac,IMAGE_FILE_DLL
				.if ZERO?
					or Charac,IMAGE_FILE_DLL
				.else
					mov eax,IMAGE_FILE_DLL
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_SYSTEMONLY
				test Charac,IMAGE_FILE_UP_SYSTEM_ONLY
				.if ZERO?
					or Charac,IMAGE_FILE_UP_SYSTEM_ONLY
				.else
					mov eax,IMAGE_FILE_UP_SYSTEM_ONLY
					not eax
					and Charac,eax
				.endif
			.elseif ax==IDC_REVERSEDHI
				test Charac,IMAGE_FILE_BYTES_REVERSED_HI
				.if ZERO?
					or Charac,IMAGE_FILE_BYTES_REVERSED_HI
				.else
					mov eax,IMAGE_FILE_BYTES_REVERSED_HI
					not eax
					and Charac,eax
				.endif
			.endif
		.endif
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
FileCharacteristicsProc endp

DumpHeader proc uses edi hDlg:DWORD,DumpFlag:DWORD
	LOCAL hTemp:DWORD
	LOCAL bytesWritten:DWORD
	mov ofn.lStructSize,SIZEOF ofn
	push hDlg
	pop  ofn.hWndOwner
	push hInstance
	pop  ofn.hInstance
	mov  ofn.lpstrFilter, OFFSET SectionFilterString
	mov  ofn.lpstrFile, OFFSET FileName
	mov  ofn.nMaxFile,sizeof FileName
	mov  byte ptr [FileName],0
	mov ofn.Flags,OFN_LONGNAMES or OFN_NOCHANGEDIR or\
		 OFN_EXPLORER or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
	invoke GetSaveFileName,addr ofn
	.if eax!=0
		invoke CreateFile,addr FileName,GENERIC_READ+GENERIC_WRITE,FILE_SHARE_WRITE+FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hTemp,eax
			.if DumpFlag==DOSHEADER
				mov edi,pMapping
				mov cx,[edi+3ch]
				movzx ecx,cx
			.elseif DumpFlag==PEHEADER
				mov edi,pPEHeader
				mov ecx,sizeof IMAGE_NT_HEADERS
			.elseif DumpFlag==SECTIONTABLE
				mov edi,pMapping
				mov ax,[edi+3ch]
				movzx eax,ax
				add eax,sizeof IMAGE_NT_HEADERS
				mov edi,pPEHeader
				assume edi:ptr IMAGE_NT_HEADERS
				mov ecx,[edi].OptionalHeader.SizeOfHeaders
				sub ecx,eax
				mov edi,pSectionTable
				assume edi:nothing
			.elseif DumpFlag==ALLHEADER
				mov edi,pPEHeader
				assume edi:ptr IMAGE_NT_HEADERS
				mov ecx,[edi].OptionalHeader.SizeOfHeaders
				assume edi:nothing
				mov edi,pMapping
			.endif
			invoke WriteFile,hTemp,edi,ecx,addr bytesWritten,NULL
			invoke CloseHandle,hTemp
			invoke MessageBox,hDlg,addr DataSaved,addr AppName,MB_OK+MB_ICONINFORMATION
		.else
			invoke ShowErrorMessage,hDlg
		.endif
	.endif
	ret
DumpHeader endp


GetNewDLL proc uses edi hDlg:DWORD
	LOCAL buffer[256]:byte
	mov ofn.lStructSize,SIZEOF ofn
	push hDlg
	pop  ofn.hWndOwner
	push hInstance
	pop  ofn.hInstance
	mov  ofn.lpstrFilter, OFFSET DLLFilterString
	mov  ofn.lpstrFile, OFFSET FileName
	mov  ofn.nMaxFile,sizeof FileName
	mov byte ptr [FileName],0
	mov ofn.Flags,OFN_LONGNAMES or OFN_NOCHANGEDIR or\
		 OFN_EXPLORER or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
	invoke GetOpenFileName,addr ofn
	.if eax!=0
		;---------------------------------------------------
		; Check if this file is a valid PE file and a DLL
		;---------------------------------------------------
		invoke CreateFile,addr FileName,GENERIC_READ,FILE_SHARE_READ+FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hDLL,eax
			invoke GetFileSize,hDLL,NULL
			.if eax>=sizeof IMAGE_DOS_HEADER+sizeof IMAGE_NT_HEADERS
				invoke CreateFileMapping,hDLL,NULL,PAGE_READONLY,0,0,0
				.if eax!=NULL
					mov hDLLMapping,eax
					invoke MapViewOfFile,hDLLMapping,FILE_MAP_READ,0,0,0
					.if eax!=NULL
						mov pDLLMapping,eax
						mov edi,pDLLMapping
						.if word ptr [edi]=="ZM"
							mov ax,[edi+3ch]
							movzx eax,ax
							add edi,eax
							.if word ptr [edi]=="EP"
								assume edi:ptr IMAGE_NT_HEADERS
								test [edi].FileHeader.Characteristics,IMAGE_FILE_DLL
								.if ZERO?
									invoke wsprintf,addr buffer,addr ErrorNotDLL,addr FileName
									invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
									invoke UnmapViewOfFile,pDLLMapping
									invoke CloseHandle,hDLLMapping
									invoke CloseHandle,hDLL
									mov hDLL,0
									jmp EndOfFunc
								.endif
								invoke GetExportFunctions,hDlg,edi
								;-------------------------------------------
								; Put the name of the dll into the edit box
								;-------------------------------------------
								mov ax,ofn.nFileOffset
								movzx eax,ax
								mov edx,offset FileName
								add edx,eax
								invoke SetDlgItemText,hDlg,IDC_NEWDLL,edx
								invoke GetDlgItem,hDlg,IDC_OKNEWIMPORT
								invoke EnableWindow,eax,TRUE
							.else
								jmp BadPE
							.endif
						.else
BadPE:
							invoke UnmapViewOfFile,pDLLMapping
							invoke CloseHandle,hDLLMapping
							jmp NotPE
						.endif
					.else
						invoke ShowErrorMessage,hDlg
						invoke CloseHandle,hDLLMapping
						invoke CloseHandle,hDLL
						mov hDLL,0
					.endif
				.else
					invoke ShowErrorMessage,hDlg
					invoke CloseHandle,hDLL
					mov hDLL,0
				.endif
			.else
NotPE:
				invoke MessageBox,hDlg,addr ErrorNotValidPEFile,addr AppName,MB_OK+MB_ICONERROR
				invoke CloseHandle,hDLL
				mov hDLL,0
			.endif
		.else
			invoke ShowErrorMessage,hDlg
		.endif
	.endif
EndOfFunc:
	ret
GetNewDLL endp

GetExportFunctions proc uses edi esi hDlg:DWORD,pDLLHeader:DWORD
	LOCAL buffer[64]:byte
	LOCAL Counter:DWORD
	LOCAL Base:DWORD
	LOCAL NameOrdinalPtr:DWORD
	LOCAL NumberOfNames:DWORD
	mov edi,pDLLHeader	
	assume edi:ptr IMAGE_NT_HEADERS
	.if [edi].OptionalHeader.DataDirectory[8*0].VirtualAddress!=0
		invoke RVAToOffset,pDLLMapping,[edi].OptionalHeader.DataDirectory[8*0].VirtualAddress
		add eax,pDLLMapping
		mov esi,eax		; esi points to the export directory
		assume esi:ptr IMAGE_EXPORT_DIRECTORY
		;------------------------------------------------------------------------------------
		; First, we fill the listbox with the names of exported functions that are exported
		; by names.
		;------------------------------------------------------------------------------------
		mov ecx,[esi].NumberOfNames
		mov NumberOfNames,ecx
		invoke RVAToOffset,pDLLMapping,[esi].AddressOfNames
		add eax,pDLLMapping
		mov edi,eax
		.while ecx>0
			push ecx
			invoke RVAToOffset,pDLLMapping,dword ptr [edi]
			add eax,pDLLMapping
			invoke SendDlgItemMessage,hDlg,IDC_FUNCTIONLIST,LB_ADDSTRING,0,eax
			pop ecx
			add edi,sizeof DWORD
			dec ecx
		.endw
		;-----------------------------------------------------------------------------------
		; Now we fill the listbox with the functions that are exported by ordinals only.
		; The total number of exported function are in NumberOfFunctions member. And we must
		; check the AddressOfFunctions array. If an element is not present, it'll be zero.
		; We also have to check if that ordinal is already exported by name. Lastly, we must
		; bias the array index with the nBase member.
		;------------------------------------------------------------------------------------
		invoke RVAToOffset,pDLLMapping,[esi].AddressOfNameOrdinals
		add eax,pDLLMapping
		mov NameOrdinalPtr,eax
		push [esi].NumberOfFunctions
		pop Counter
		invoke RVAToOffset,pDLLMapping,[esi].AddressOfFunctions
		add eax,pDLLMapping
		mov edi,eax		; edi points to the array of function RVAs
		push [esi].nBase
		pop Base
		xor ecx,ecx
		.while ecx<Counter
			.if dword ptr [edi]!=0
				push ecx
				push edi
				mov edx,ecx
				mov ecx,NumberOfNames
				mov edi,NameOrdinalPtr
				mov eax,TRUE		; if eax==TRUE, the function is exported by ordinal only
				.while ecx>0
					.if dx==word ptr [edi]
						mov eax,FALSE
						.break
					.endif
					add edi,sizeof WORD
					dec ecx
				.endw
				pop edi
				pop ecx
				.if eax==TRUE
					mov edx,ecx
					add edx,Base
					push ecx
					invoke wsprintf,addr buffer,addr DecTemplate,edx
					invoke SendDlgItemMessage,hDlg,IDC_FUNCTIONLIST,LB_ADDSTRING,0,addr buffer
					pop ecx
				.endif
			.endif
			add edi,sizeof DWORD
			inc ecx
		.endw
		assume esi:nothing
	.endif
	assume edi:nothing
	ret
GetExportFunctions endp

PrepareSpaceInSectionTable proc uses edi esi ecx edx hDlg:DWORD
	LOCAL HeaderSize:DWORD
	LOCAL TrueHeaderSize:DWORD
	LOCAL hTempExe:DWORD
	LOCAL FileAlignment:DWORD
	LOCAL bytesWritten:DWORD
	LOCAL buffer[1024]:byte
	LOCAL buffer1[1024]:byte
	
	mov esi,pPEHeader
	assume esi:ptr IMAGE_NT_HEADERS
	push [esi].OptionalHeader.FileAlignment
	pop FileAlignment
	;------------------------------------------------------------------------------------
	; First, check if there is enough space to store another IMAGE_SECTION_HEADER structure.
	; If there is not enough space, just add more space the size of file alignment unit.
	; and adjust the pointer to raw data in all sections accordingly
	;--------------------------------------------------------------------------------------
	mov edi,pSectionTable
	assume edi:ptr IMAGE_SECTION_HEADER
	mov ecx,NumSection
	;---------------------------------------------------------------------------------------
	; Walk all IMAGE_SECTION_HEADER structures to retrieve the smallest PointerToRawData
	; member since the sections MAY be rearranged and we cannot be absolutely sure that
	; the first section is the first section stored in the file
	;----------------------------------------------------------------------------------------
	xor eax,eax
	.while ecx>0
		.if eax>[edi].PointerToRawData || eax==0
			mov eax,[edi].PointerToRawData
		.endif
		add edi,sizeof IMAGE_SECTION_HEADER
		dec ecx
	.endw
	assume edi:nothing
	mov edi,eax	
	mov HeaderSize,edi
	;-----------------------------------------------------------------------
	; HeaderSize and edi now contain the size of DOS header+PE header+section table+padding
	; We will find out how much the padding is
	;------------------------------------------------------------------------
	mov eax,NumSection
	mov ecx,sizeof IMAGE_SECTION_HEADER
	mul ecx
	add eax,sizeof IMAGE_NT_HEADERS
	mov ecx,pMapping
	mov cx,word ptr [ecx+3Ch]
	movzx ecx,cx
	add eax,ecx			; eax is the size of space actually taken up by DOS header+PE header+section table
	mov TrueHeaderSize,eax
	sub edi,eax		; edi contains the free space left
	;----------------------------------------------------------------------------------
	; If there is not enough space left to insert another IMAGE_SECTION_HEADER structure,
	; we just add more space. Before doing this, we must create a new target file
	;-----------------------------------------------------------------------------------
	.if edi<sizeof IMAGE_SECTION_HEADER || [esi].OptionalHeader.DataDirectory[8*11].VirtualAddress!=0
		;--------------------------------------------------------------------------
		; Create the temporary file in the same dir as the target but it has .icz
		; extension.
		;--------------------------------------------------------------------------
		.if FProjectInProgress!=TARGET_ONLY
			invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyTarget,addr buffer,addr buffer,512,addr FullProjININame
		.else
			invoke lstrcpy,addr buffer,addr TargetName
		.endif
		invoke lstrlen,addr buffer
		mov ecx,eax
		lea edi,buffer
		mov al,"."
		repne scasb
		.if ZERO?
			dec edi
			push esi
			mov esi,offset ICZ
			mov ecx,4
			rep movsb
			pop esi
			mov byte ptr [edi],0
		.else
			invoke lstrcat,addr buffer,addr ICZ
		.endif
		invoke CreateFile,addr buffer,GENERIC_READ+GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
		.if eax!=INVALID_HANDLE_VALUE
			mov hTempExe,eax
			;--------------------------------------------------------------------------------
			; Modify the PointerToRawData members
			;--------------------------------------------------------------------------------
			mov edi,pSectionTable
			assume edi:ptr IMAGE_SECTION_HEADER
			mov ecx,NumSection
			mov eax,FileAlignment
			.while ecx>0
				add [edi].PointerToRawData,eax
				add edi,sizeof IMAGE_SECTION_HEADER
				dec ecx
			.endw
			assume edi:nothing
			invoke WriteFile,hTempExe,pMapping,TrueHeaderSize,addr bytesWritten,NULL
			;-------------------------------------------------------------------------
			; Now we must make room for the additional IAMGE_SECTION_HEADER structure
			;--------------------------------------------------------------------------
			invoke RtlFillMemory,addr buffer1,sizeof IMAGE_SECTION_HEADER,0
			invoke WriteFile,hTempExe,addr buffer1,sizeof IMAGE_SECTION_HEADER,addr bytesWritten,NULL
			;--------------------------------------------------------------------------
			; Next we write the bound import (if exists) 
			;--------------------------------------------------------------------------
			mov ecx,HeaderSize
			sub ecx,TrueHeaderSize
			mov edi,pMapping
			add edi,TrueHeaderSize
			invoke WriteFile,hTempExe,edi,ecx,addr bytesWritten,NULL
			;---------------------------------------------------------------
			; Write additional space the size of file alignment unit
			;---------------------------------------------------------------
			invoke RtlFillMemory,addr buffer1,FileAlignment,0
			mov ecx,FileAlignment
			sub ecx,sizeof IMAGE_SECTION_HEADER
			invoke WriteFile,hTempExe,addr buffer1,ecx,addr bytesWritten,NULL
			;---------------------------------------------------------------
			; Write the remaining data in the file to the temp file
			;---------------------------------------------------------------
			mov edi,pMapping
			add edi,HeaderSize
			invoke GetFileSize,hFile,NULL
			sub eax,HeaderSize
			mov ecx,eax
			invoke WriteFile,hTempExe,edi,ecx,addr bytesWritten,NULL
			invoke CloseHandle,hTempExe
			;----------------------------------------------------------------
			; Delete the original target file and rename the temp file to
			; the original target filename
			;----------------------------------------------------------------
			invoke UnmapViewOfFile,pMapping
			invoke CloseHandle,hMapping
			invoke CloseHandle,hFile
			.if FProjectInProgress!=TARGET_ONLY
				invoke GetPrivateProfileString,addr MainINISection,addr ProjINIKeyTarget,addr buffer1,addr buffer1,512,addr FullProjININame
			.else
				invoke lstrcpy,addr buffer1,addr TargetName
			.endif
			invoke DeleteFile,addr buffer1
			.if eax!=0
				invoke MoveFile,addr buffer,addr buffer1					
				mov FPatch,FALSE
				push FProjectInProgress
				mov FProjectInProgress,NO_PROJECT
				invoke CheckIfValidPE,addr buffer1
				pop FProjectInProgress
				mov esi,pPEHeader
				assume esi:ptr IMAGE_NT_HEADERS
				mov eax,[esi].OptionalHeader.FileAlignment
				add [esi].OptionalHeader.SizeOfHeaders,eax
			.else
				mov FPatch,FALSE
				push FProjectInProgress
				mov FProjectInProgress,NO_PROJECT
				invoke CheckIfValidPE,addr buffer1
				pop FProjectInProgress
				invoke wsprintf,addr buffer,addr ErrorDeletingEXE,addr buffer1
				invoke MessageBox,hDlg,addr buffer,addr AppName,MB_OK+MB_ICONERROR
				jmp EndOfFunc
			.endif
		.else
CreateTempEXEFail:
			invoke wsprintf,addr buffer1,addr ErrorCreatingTempExe,addr buffer
			invoke MessageBox,hDlg,addr buffer1,addr AppName,MB_OK+MB_ICONERROR
			jmp EndOfFunc
		.endif
	.endif
EndOfFunc:
	assume esi:nothing
	assume edi:nothing
	ret
PrepareSpaceInSectionTable endp

String2Dword proc uses ecx edi edx esi String:DWORD
        xor ecx,ecx
        mov edi,String
        invoke lstrlen,String
        .while eax!=0
                xor edx,edx
                mov dl,byte ptr [edi]
                sub dl,"0"      ; subtrack each digit with "0" to convert it to hex value
                mov esi,eax
                dec esi
                push eax
                mov eax,edx
                push ebx
                mov ebx,10
                .while esi > 0
                        mul ebx
                        dec esi
                .endw
                pop ebx
                add ecx,eax
                pop eax
                inc edi
                dec eax
        .endw
        mov eax,ecx
        ret
String2Dword endp

AddSpaceToSection proc uses edi esi edx ecx pTempMapping:DWORD,pISH:DWORD,SizeToPad:DWORD
	LOCAL buffer[1024]:byte
	LOCAL hTempExe:DWORD
	LOCAL bytesWritten:DWORD
	LOCAL OffsetToPadBytes:DWORD
	;--------------------------------------------------------------------------
	; Create the temporary file in the same dir as the target but it has .icz
	; extension.
	;--------------------------------------------------------------------------
	invoke lstrcpy,addr buffer,addr TargetName
	invoke lstrlen,addr buffer
	mov ecx,eax
	lea edi,buffer
	mov al,"."
	repne scasb
	.if ZERO?
		dec edi
		push esi
		mov esi,offset ICZ
		mov ecx,4
		rep movsb
		pop esi
		mov byte ptr [edi],0
	.else
		invoke lstrcat,addr buffer,addr ICZ
	.endif
	invoke CreateFile,addr buffer,GENERIC_READ+GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
	.if eax!=INVALID_HANDLE_VALUE
		mov hTempExe,eax
		;--------------------------------------------------------------------------------
		; Modify the PointerToRawData members of the ISHs that follow
		;--------------------------------------------------------------------------------
		mov eax,pISH
		sub eax,pSectionTable	; eax contains the combined size of the ISH before the ISH we want to expand
		xor edx,edx
		mov ecx,sizeof IMAGE_SECTION_HEADER
		div ecx
		mov edi,pISH
		add edi,sizeof IMAGE_SECTION_HEADER
		inc eax
		assume edi:ptr IMAGE_SECTION_HEADER
		mov ecx,NumSection
		sub ecx,eax
		mov eax,SizeToPad
		.while ecx>0
			add [edi].PointerToRawData,eax
			add edi,sizeof IMAGE_SECTION_HEADER
			dec ecx
		.endw
		;--------------------------------------------------
		; Modify the current ISH
		;--------------------------------------------------
		mov esi,pTempMapping
		mov ax,[esi+3ch]
		movzx eax,ax
		add esi,eax
		assume esi:ptr IMAGE_NT_HEADERS
		mov ecx,[esi].OptionalHeader.FileAlignment
		assume esi:nothing
		mov edi,pISH
		assume edi:ptr IMAGE_SECTION_HEADER
		mov eax,[edi].SizeOfRawData
		add eax,SizeToPad
		xor edx,edx
		div ecx
		.if edx!=0
			inc edx
		.endif
		mul ecx
		mov [edi].SizeOfRawData,eax
		;--------------------------------------------------
		; Write the first half of the file to the temp file
		;--------------------------------------------------
		mov edi,pISH
		mov ecx,[edi].PointerToRawData
		add ecx,[edi].SizeOfRawData
		sub ecx,SizeToPad
		mov edi,ecx
		mov OffsetToPadBytes,edi
		invoke WriteFile,hTempExe,pTempMapping,edi,addr bytesWritten,NULL
		assume edi:nothing
		;-----------------------------------------------------------------
		; Now we must pad the section by setting a new end of file
		;-----------------------------------------------------------------
		mov ecx,edi
		add ecx,SizeToPad
		invoke SetFilePointer,hTempExe,ecx,0,FILE_BEGIN
		invoke SetEndOfFile,hTempExe
		;----------------------------------------------------------------
		; now write the rest of the file
		;----------------------------------------------------------------
		invoke GetFileSize,hFile,NULL
		sub eax,edi
		mov ecx,eax
		mov edx,pTempMapping
		add edx,edi
		invoke WriteFile,hTempExe,edx,ecx,addr bytesWritten,NULL
		invoke CloseHandle,hTempExe
		;----------------------------------------------------------------
		; Delete the original target file and rename the temp file to
		; the original target filename
		;----------------------------------------------------------------
		invoke UnmapViewOfFile,pMapping
		invoke CloseHandle,hMapping
		invoke CloseHandle,hFile
		invoke DeleteFile,addr TargetName
		.if eax!=0
			invoke MoveFile,addr buffer,addr TargetName
			mov FPatch,FALSE
			push FProjectInProgress
			mov FProjectInProgress,NO_PROJECT
			invoke CheckIfValidPE,addr TargetName
			pop FProjectInProgress
			;----------------------------------------------------------
			; we must calculate the new image size
			;----------------------------------------------------------
			mov ecx,NumSection
			mov edi,pSectionTable
			assume edi:ptr IMAGE_SECTION_HEADER
			xor eax,eax
			.while ecx>0
				.if eax<[edi].VirtualAddress || eax==0
					mov eax,[edi].VirtualAddress
					mov edx,[edi].SizeOfRawData
				.endif
				add edi,sizeof IMAGE_SECTION_HEADER
				dec ecx
			.endw
			push eax
			mov eax,edx
			xor edx,edx
			mov esi,pPEHeader
			assume esi:ptr IMAGE_NT_HEADERS
			mov ecx,[esi].OptionalHeader.SectionAlignment
			div ecx
			.if edx!=0
				inc eax
			.endif
			mul ecx
			mov edx,eax
			pop eax
			add eax,edx
			mov [esi].OptionalHeader.SizeOfImage,eax
			;------------------------------------------------
			; Clear the padding bytes
			;------------------------------------------------
			mov edi,pMapping
			add edi,OffsetToPadBytes
			invoke RtlFillMemory,edi,SizeToPad,0
			mov eax,TRUE
		.else
			mov FPatch,FALSE
			push FProjectInProgress
			mov FProjectInProgress,NO_PROJECT
			invoke CheckIfValidPE,addr TargetName
			pop FProjectInProgress
			invoke wsprintf,addr buffer,addr ErrorDeletingEXE,addr TargetName
			invoke MessageBox,NULL,addr buffer,addr AppName,MB_OK+MB_ICONERROR
			mov eax,FALSE
		.endif
	.else
		invoke wsprintf,addr buffer,addr ErrorCreatingTempExe,addr buffer
		invoke MessageBox,NULL,addr buffer,addr AppName,MB_OK+MB_ICONERROR
		mov eax,FALSE
	.endif
EndOfFunc:
	ret
AddSpaceToSection endp

GetSpaceNeeded proc uses edi ecx edx hDlg:DWORD,FunctionCount:DWORD,pGlobal:DWORD
	LOCAL buffer[1024]:byte
	LOCAL SizeRequired:DWORD
	invoke GetDlgItemText,hDlg,IDC_NEWDLL,addr buffer,1024
	invoke lstrlen,addr buffer
	inc eax
	mov SizeRequired,eax	; the size of the dll name
	;----------------------------------------------------
	; size of thunk dword arrays
	;----------------------------------------------------
	mov eax,FunctionCount
	shl eax,3		; each element is 4 bytes, and there are two arrays
	add eax,8		; add the two terminating null dwords
	add SizeRequired,eax
	;-----------------------------------------------------------------
	; The size required to store the names of the functions and hints
	;-----------------------------------------------------------------
	invoke SendDlgItemMessage,hDlg,IDC_FUNCTIONLIST,LB_GETSELITEMS,FunctionCount,pGlobal
	mov edi,pGlobal
	mov ecx,eax
	.while ecx>0
		push ecx
		invoke SendDlgItemMessage,hDlg,IDC_FUNCTIONLIST,LB_GETTEXT,dword ptr [edi],addr buffer
		.if byte ptr [buffer]<"0" || byte ptr [buffer]>"9"
			invoke lstrlen,addr buffer
			add eax,3		; the hint name (2 bytes) and the terminating null
		.endif
		add SizeRequired,eax
		pop ecx
		add edi,sizeof DWORD
		dec ecx
	.endw
	mov eax,SizeRequired
	ret
GetSpaceNeeded endp

AddRelocInfoToTarget proc uses ebx ecx edx edi esi hDlg:DWORD
	LOCAL ImageBase:DWORD
	LOCAL pBinReloc:DWORD
	LOCAL BinRelocSize:DWORD
	LOCAL pTargetReloc:DWORD
	LOCAL TargetRelocSize:DWORD
	LOCAL pAvailSpace:DWORD
	LOCAL SpaceRequired:DWORD
	LOCAL pTargetISH:DWORD
	LOCAL SizeOfRawData:DWORD
	LOCAL RelocSection:IMAGE_SECTION_HEADER
	LOCAL pExeMapping:DWORD
	LOCAL CurDir[1024]:byte
	LOCAL hExe:DWORD
	LOCAL hExeMapping:DWORD

	mov edi,pPEHeader
	assume edi:ptr IMAGE_NT_HEADERS
	;-----------------------------------------------------
	; Check if .reloc is present
	;-----------------------------------------------------
	.if [edi].OptionalHeader.DataDirectory[8*5].VirtualAddress!=0
		;-----------------------------------------------------
		; Open the project exe file
		;-----------------------------------------------------
		invoke GetCurrentDirectory,1024,addr CurDir
		invoke SetCurrentDirectory,addr ProjectDir
		invoke CreateFile,addr EXEName,GENERIC_READ+GENERIC_WRITE,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hExe,eax
			invoke CreateFileMapping,hExe,NULL,PAGE_READWRITE,0,0,0
			.if eax!=NULL
				mov hExeMapping,eax
				invoke MapViewOfFile,hExeMapping,FILE_MAP_READ+FILE_MAP_WRITE,0,0,0
				.if eax!=NULL
					mov pExeMapping,eax
				.else
					invoke ShowErrorMessage,hDlg
					jmp CloseHandleAndExit
				.endif
			.else
				invoke ShowErrorMessage,hDlg
				jmp CloseFileAndExit
			.endif
		.else
			invoke ShowErrorMessage,hDlg
			jmp RestoreCurDir
		.endif
		mov esi,pExeMapping
		mov ax,word ptr [esi+3ch]
		movzx eax,ax
		add esi,eax		
		assume esi:ptr IMAGE_NT_HEADERS
		push [esi].OptionalHeader.ImageBase
		pop ImageBase
		invoke RVAToOffset,pExeMapping,[esi].OptionalHeader.DataDirectory[8*5].VirtualAddress
		add eax,pExeMapping
		mov esi,eax
		mov pBinReloc,esi		; store the address to the beginning of the reloc data of the bin file
		assume esi:ptr IMAGE_BASE_RELOCATION
		.if [esi].VirtualAddress!=0
			.if PatchOption==1	; if patch as a new section
				mov eax,NewSectionVA
			.else
				mov eax,SnippetVA
			.endif
			sub eax,ImageBase
			sub eax,[esi].VirtualAddress
		.endif
		mov BinRelocSize,0
		.while [esi].VirtualAddress!=0
			add [esi].VirtualAddress,eax
			mov edx,[esi].SizeOfBlock
			add BinRelocSize,edx
			add esi,[esi].SizeOfBlock
		.endw
		add BinRelocSize,8	; add an empty IMAGE_BASE_RELOCATION
		;-------------------------------------------------------------------
		; Now that we adjusted the relocation data, we must write them to
		; the end of the target's reloc section
		;-------------------------------------------------------------------
		invoke RVAToOffset,pMapping,[edi].OptionalHeader.DataDirectory[8*5].VirtualAddress
		add eax,pMapping		; eax points to the reloc data in the target
		mov esi,eax
		mov pTargetReloc,esi
		mov TargetRelocSize,0
		.while [esi].VirtualAddress!=0
			mov edx,[esi].SizeOfBlock
			add TargetRelocSize,edx
			add esi,[esi].SizeOfBlock
		.endw
		;------------------------------------------------------------------
		; esi points to the place where we can add the reloc data from
		; the bin exe
		;------------------------------------------------------------------
		mov pAvailSpace,esi
		;-----------------------------------------------------------------
		; We must find the size of the section that contains the target's
		; reloc data
		;-----------------------------------------------------------------
		mov eax,[edi].OptionalHeader.DataDirectory[8*5].VirtualAddress
		mov ecx,NumSection
		mov esi,pSectionTable
		assume esi:ptr IMAGE_SECTION_HEADER
		.while ecx>0
			.if eax>=[esi].VirtualAddress
				mov edx,[esi].VirtualAddress
				add edx,[esi].SizeOfRawData
				.if eax<edx
					.break
				.endif
			.endif
			add esi,sizeof IMAGE_SECTION_HEADER
			dec ecx
		.endw
		;----------------------------------------------------------------
		; esi points to the ISH of the section that contains the reloc
		; data
		;------------------------------------------------------------------
		mov pTargetISH,esi
		mov eax,pAvailSpace
		sub eax,pMapping
		sub eax,[esi].PointerToRawData	; eax is the size of data in the .reloc section
		mov SpaceRequired,eax
		mov edx,BinRelocSize
		add SpaceRequired,edx
		mov ecx,[esi].SizeOfRawData
		sub ecx,eax
		.if BinRelocSize>ecx	; if space is not enough
			;--------------------------------------------------------------
			; Check if we can add space to the end of the section safely
			;--------------------------------------------------------------
			mov eax,SpaceRequired
			xor edx,edx
			mov ecx,[edi].OptionalHeader.FileAlignment
			div ecx
			.if edx!=0
				inc eax
			.endif
			mul ecx		; eax now contains the size of the section
			mov SizeOfRawData,eax
			mov eax,[esi].VirtualAddress	; eax now contains the virtual address of the section that contains reloc data
			mov ecx,NumSection
			mov esi,pSectionTable			
			xor edx,edx
			.while ecx>0
				.if eax<[esi].VirtualAddress
					.if edx==0
						mov edx,[esi].VirtualAddress
					.else
						.if edx>[esi].VirtualAddress
							mov edx,[esi].VirtualAddress
						.endif
					.endif
				.endif
				add esi,sizeof IMAGE_SECTION_HEADER
				dec ecx
			.endw
			;--------------------------------------------------
			; edx contains the limiting virtual address or 0
			; if the section is the last one
			;--------------------------------------------------
			mov esi,pTargetISH
			mov eax,[esi].VirtualAddress
			add eax,SizeOfRawData
			.if eax>edx && edx!=0		; if we are up against section limit here, we have to move the reloc data to a new section
				invoke PrepareSpaceInSectionTable,hDlg
				;----------------------------------------------------------
				; Fill the new reloc section's ISH
				;----------------------------------------------------------
				invoke RtlFillMemory,addr RelocSection,sizeof IMAGE_SECTION_HEADER,0
				;----------------------------------
				; section name
				;----------------------------------
				mov esi,offset RelocName
				lea edi,RelocSection
				invoke lstrlen,esi
				mov ecx,eax
				rep movsb
				mov edi,pPEHeader
				;-----------------------------------
				; Virtual address
				;-----------------------------------
				push [edi].OptionalHeader.SizeOfImage
				pop RelocSection.VirtualAddress
				;-----------------------------------
				; Virtual size
				;-----------------------------------
				mov eax,TargetRelocSize
				add eax,BinRelocSize
				mov RelocSection.Misc.VirtualSize,eax
				;------------------------------------
				; Size of raw data
				;------------------------------------
				mov eax,RelocSection.Misc.VirtualSize
				xor edx,edx
				mov ecx,[edi].OptionalHeader.FileAlignment
				div ecx
				.if edx!=0
					inc eax
				.endif
				mul ecx
				mov RelocSection.SizeOfRawData,eax
				;------------------------------------
				; Pointer to raw data
				;------------------------------------
				mov ecx,NumSection
				mov esi,pSectionTable
				assume esi:ptr IMAGE_SECTION_HEADER
				xor edx,edx
				.while ecx>0
					.if edx<[esi].PointerToRawData || edx==0
						mov edx,[esi].PointerToRawData
						mov ebx,[esi].SizeOfRawData
					.endif
					add esi,sizeof IMAGE_SECTION_HEADER
					dec ecx
				.endw
				add edx,ebx
				mov RelocSection.PointerToRawData,edx
				;------------------------------------------
				; Characteristics
				;------------------------------------------
				mov RelocSection.Characteristics,IMAGE_SCN_MEM_READ+IMAGE_SCN_CNT_INITIALIZED_DATA
				;------------------------------------------
				; Add the new section 
				;------------------------------------------
				mov ecx,RelocSection.PointerToRawData
				add ecx,RelocSection.SizeOfRawData
				invoke SetFilePointer,hFile,ecx,0,FILE_BEGIN
				invoke SetEndOfFile,hFile
				invoke UnmapViewOfFile,pMapping
				invoke CloseHandle,hMapping
				invoke CloseHandle,hFile
				mov FPatch,FALSE
				push FProjectInProgress
				mov FProjectInProgress,NO_PROJECT
				invoke CheckIfValidPE,addr TargetName
				pop FProjectInProgress
				;----------------------------------------
				; Clear the section
				;----------------------------------------
				mov edx,RelocSection.PointerToRawData
				add edx,pMapping
				invoke RtlFillMemory,edx,RelocSection.SizeOfRawData,0
				;-----------------------------------------------
				; Copy the old reloc data to the new section
				;-----------------------------------------------
				mov edi,pPEHeader
				invoke RVAToOffset,pMapping,[edi].OptionalHeader.DataDirectory[8*5].VirtualAddress
				add eax,pMapping
				mov esi,eax
				mov edi,pMapping
				add edi,RelocSection.PointerToRawData
				mov ecx,TargetRelocSize
				rep movsb
				;------------------------------------------------
				; Copy the bin reloc data
				;------------------------------------------------
				mov esi,pBinReloc
				mov ecx,BinRelocSize
				rep movsb
				;------------------------------------------------
				; append the reloc ISH to the section table
				;------------------------------------------------
				mov edi,pSectionTable
				assume edi:ptr IMAGE_SECTION_HEADER
				mov ecx,NumSection
				mov eax,sizeof IMAGE_SECTION_HEADER
				mul ecx
				add edi,eax		; edi points to the space we can copy the ISH to
				lea esi,RelocSection
				mov ecx,sizeof IMAGE_SECTION_HEADER
				rep movsb
				;----------------------------------------------
				; Increase number of section and the image size
				;----------------------------------------------
				mov edi,pPEHeader
				assume edi:ptr IMAGE_NT_HEADERS
				inc [edi].FileHeader.NumberOfSections
				mov eax,RelocSection.Misc.VirtualSize
				xor edx,edx
				mov ecx,[edi].OptionalHeader.SectionAlignment
				div ecx
				.if edx!=0
					inc eax
				.endif
				mul ecx
				add eax,RelocSection.VirtualAddress
				mov [edi].OptionalHeader.SizeOfImage,eax
				;------------------------------------------------
				; Update the base reloc entry in data directory
				;------------------------------------------------
				mov eax,RelocSection.VirtualAddress
				mov [edi].OptionalHeader.DataDirectory[8*5].VirtualAddress,eax
				mov eax,RelocSection.Misc.VirtualSize
				mov [edi].OptionalHeader.DataDirectory[8*5].isize,eax
			.else				
				mov edx,SizeOfRawData
				sub edx,[esi].SizeOfRawData
				invoke AddSpaceToSection,pMapping,pTargetISH,edx
				;-------------------------------------------------------
				; We must find the pointer to the available space anew
				; since the target is remapped
				;-------------------------------------------------------
				mov edi,pPEHeader
				invoke RVAToOffset,pMapping,[edi].OptionalHeader.DataDirectory[8*5].VirtualAddress
				add eax,pMapping
				mov esi,eax
				assume esi:ptr IMAGE_BASE_RELOCATION
				.while [esi].VirtualAddress!=0
					add esi,[esi].SizeOfBlock
				.endw
				mov edi,esi
				mov esi,pBinReloc
				mov ecx,BinRelocSize
				rep movsb
				jmp UpdateEntry
			.endif
		.else		; if there is enough space in the section, we just copy the reloc data into it
			mov esi,pBinReloc
			mov edi,pAvailSpace
			mov ecx,BinRelocSize
			rep movsb
UpdateEntry:
			;------------------------------------------------
			; Correct base reloc entry
			;------------------------------------------------
			mov edi,pPEHeader
			mov eax,TargetRelocSize
			add eax,BinRelocSize
			mov [edi].OptionalHeader.DataDirectory[8*5].isize,eax
			;-----------------------------------------------
			; update the ISH
			;-----------------------------------------------
			mov eax,[edi].OptionalHeader.DataDirectory[8*5].VirtualAddress
			mov ecx,NumSection
			mov esi,pSectionTable
			assume esi:ptr IMAGE_SECTION_HEADER
			.while ecx>0
				.if eax>=[esi].VirtualAddress
					mov edx,[esi].VirtualAddress
					add edx,[esi].SizeOfRawData
					.if eax<edx
						.break
					.endif
				.endif
				add esi,sizeof IMAGE_SECTION_HEADER
				dec ecx
			.endw
			push SpaceRequired
			pop [esi].Misc.VirtualSize
		.endif
		assume esi:nothing
EndOfFunc:
		;----------------------------------------
		; Close exe file and restore current dir
		;----------------------------------------
		invoke UnmapViewOfFile,pExeMapping
CloseHandleAndExit:
		invoke CloseHandle,hExeMapping
CloseFileAndExit:
		invoke CloseHandle,hExe
RestoreCurDir:
		invoke SetCurrentDirectory,addr CurDir
	.endif
	assume edi:nothing
	ret
AddRelocInfoToTarget endp

NewImportProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	.if uMsg==WM_INITDIALOG
		mov hDLL,0
		invoke SendDlgItemMessage,hDlg,IDC_FUNCTIONLIST,LB_RESETCONTENT,0,0
	.elseif uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,wParam
		shr edx,16
		.if dx==BN_CLICKED
			.if ax==IDC_BROWSEDLL
				invoke GetNewDLL,hDlg
			.elseif ax==IDC_OKNEWIMPORT
				invoke SendDlgItemMessage,hDlg,IDC_FUNCTIONLIST,LB_GETSELCOUNT,0,0
				.if eax!=0
					invoke AddNewImport,hDlg
					.if eax!=FALSE
						invoke SendMessage,hDlg,WM_CLOSE,0,0
					.endif
				.else
					invoke MessageBox,hDlg,addr ErrorNoFunction,addr AppName,MB_OK+MB_ICONERROR
				.endif
			.elseif ax==IDC_CANCELNEWIMPORT
				invoke SendMessage,hDlg,WM_CLOSE,0,0
			.endif
		.endif
	.elseif uMsg==WM_CLOSE
		.if hDLL!=0
			invoke UnmapViewOfFile,pDLLMapping
			invoke CloseHandle,hDLLMapping
			invoke CloseHandle,hDLL
		.endif
		invoke EndDialog,hDlg,NULL
	.else
		mov eax,FALSE
		ret
	.endif
	mov eax,TRUE
	ret
NewImportProc endp

AddNewImport proc uses esi edi ebx hDlg:DWORD
	LOCAL SectionAlignment:DWORD
	LOCAL FileAlignment:DWORD
	LOCAL ImportDescSection:IMAGE_SECTION_HEADER
	LOCAL ImportDataSection:IMAGE_SECTION_HEADER
	LOCAL buffer[1024]:byte
	LOCAL hGlobal:DWORD
	LOCAL pGlobal:DWORD
	LOCAL FunctionCount:DWORD
	LOCAL pIID:DWORD		; pointer to image_import_descriptor structure
	LOCAL pImportData:DWORD	; pointer to the import data section
	LOCAL pFuncName:DWORD	; pointer to the first availabe space to store the name of an import function
	LOCAL Index:DWORD
	LOCAL EndVA:DWORD
	LOCAL ImportDataVA:DWORD
	LOCAL ImportDataSize:DWORD
	LOCAL pAvailSpace:DWORD		; pointer to the first byte of available space to store dll name, thunk dwords etc
	LOCAL CurrentDataSize:DWORD	; the size of the data in import data section
	LOCAL pImportDataISH:DWORD
	LOCAL pImportDescISH:DWORD
	LOCAL DLLNameRVA:DWORD


	;----------------------------------------------------------------------------------
	; Check if we can allocate memory for the array of indexes
	;----------------------------------------------------------------------------------
	invoke SendDlgItemMessage,hDlg,IDC_FUNCTIONLIST,LB_GETSELCOUNT,0,0
	mov FunctionCount,eax
	shl eax,2		; multiply by 4 to get the size of buffer we need
	invoke GlobalAlloc,GHND,eax
	.if eax==NULL
MemError:
		invoke ShowErrorMessage,hDlg
		mov eax,FALSE
	.endif
	mov hGlobal,eax
	invoke GlobalLock,hGlobal
	.if eax==NULL
		jmp MemError
	.endif
	mov pGlobal,eax
	;-------------------------------------------------
	; Now that we can allocate enough memory, we can
	; process to modify the target
	;-------------------------------------------------
	mov esi,pMapping
	mov ax,[esi+3ch]
	movzx eax,ax
	add esi,eax		; esi points to the pe header
	assume esi:ptr IMAGE_NT_HEADERS
	push [esi].OptionalHeader.FileAlignment
	pop FileAlignment
	push [esi].OptionalHeader.SectionAlignment
	pop SectionAlignment
	invoke RtlFillMemory,addr ImportDescSection,sizeof IMAGE_SECTION_HEADER,0
	invoke RtlFillMemory,addr ImportDataSection,sizeof IMAGE_SECTION_HEADER,0
	;--------------------------------------------------------------------------
	; Check the import section first. If it is already modified by this util,
	; it will contain the string "ICZE" before the IMAGE_EXPORT_DESCRIPTOR
	; structure
	;---------------------------------------------------------------------------
	.if [esi].OptionalHeader.DataDirectory[8*1].VirtualAddress!=0
		invoke RVAToOffset,pMapping,[esi].OptionalHeader.DataDirectory[8*1].VirtualAddress
		add eax,pMapping
		mov edi,eax
		sub eax,4
		.if dword ptr [eax]!="EZCI"		; if this file's import section is not modified by this util before
MakeNewSection:
			;-------------------------------------------------------------------------------------
			; Find the virtual size
			;-------------------------------------------------------------------------------------
			assume edi:ptr IMAGE_IMPORT_DESCRIPTOR
			xor ecx,ecx
			.while [edi].OriginalFirstThunk!=0 || [edi].TimeDateStamp!=0 || [edi].ForwarderChain!=0 || [edi].Name1!=0 || [edi].FirstThunk!=0
				add ecx,sizeof IMAGE_IMPORT_DESCRIPTOR
				add edi,sizeof IMAGE_IMPORT_DESCRIPTOR
			.endw
MakeNewSections:
			add ecx,sizeof IMAGE_IMPORT_DESCRIPTOR	; one more for the structure we will add
			add ecx,sizeof IMAGE_IMPORT_DESCRIPTOR	; one more for the all null structure
			add ecx,4		; for "ICZE" string
			mov ImportDescSection.Misc.VirtualSize,ecx
			;----------------------------------------
			; Calculate size of raw data
			;----------------------------------------
			mov eax,ecx
			xor edx,edx
			mov ecx,FileAlignment
			div ecx
			.if edx!=0
				inc eax
			.endif
			mul ecx
			mov ImportDescSection.SizeOfRawData,eax
			;---------------------------------------
			; Store section VA
			;---------------------------------------
			push [esi].OptionalHeader.SizeOfImage
			pop ImportDescSection.VirtualAddress
			;----------------------------------------------------------
			; Prepare space for the new IMAGE_SECTION_HEADER structure
			; We must call this function before calculating the raw
			; offset because if expansion of the pe header is done,
			; the raw offset of all sections will be increased!
			;----------------------------------------------------------
			invoke PrepareSpaceInSectionTable,hDlg
			;---------------------------------------
			; Find pointer to raw data
			;---------------------------------------
			mov ecx,NumSection
			.if ecx!=0
				mov edi,pSectionTable
				assume edi:ptr IMAGE_SECTION_HEADER
				xor eax,eax
				.while ecx>0
					.if eax<[edi].PointerToRawData || eax==0
						mov eax,[edi].PointerToRawData
					.endif
					add edi,sizeof IMAGE_SECTION_HEADER
					dec ecx
				.endw
				sub edi,sizeof IMAGE_SECTION_HEADER
				add eax,[edi].SizeOfRawData
			.else
				mov eax,[esi].OptionalHeader.SizeOfHeaders
			.endif
			mov ImportDescSection.PointerToRawData,eax
			;-------------------------------------------------
			; Section name
			;-------------------------------------------------
			mov esi,offset ImportName
			lea edi,ImportDescSection
			invoke lstrlen,esi
			mov ecx,eax
			rep movsb
			;---------------------------------------------------
			; Section Characteristics
			;---------------------------------------------------
			mov ImportDescSection.Characteristics,IMAGE_SCN_MEM_READ+IMAGE_SCN_CNT_INITIALIZED_DATA
			;----------------------------------------------------------
			; Now insert the IMAGE_SECTION_HEADER
			;----------------------------------------------------------
			mov ecx,NumSection
			mov edi,pSectionTable
			mov eax,sizeof IMAGE_SECTION_HEADER
			xor edx,edx
			mul ecx
			add edi,eax		; edi now points to the space we should put the new ISH structure
			;---------------------------------------
			; copy the structure to the section table
			;---------------------------------------
			lea esi,ImportDescSection
			mov ecx,sizeof IMAGE_SECTION_HEADER
			rep movsb
			;-------------------------------------------------
			; Increase the number of section in the pe header
			;-------------------------------------------------
			mov esi,pPEHeader
			inc [esi].FileHeader.NumberOfSections
			;-------------------------------------------------
			; Calculate the new image size
			;-------------------------------------------------
			mov eax,ImportDescSection.Misc.VirtualSize
			xor edx,edx
			mov ecx,SectionAlignment
			div ecx
			.if edx!=0
				inc eax
			.endif
			mul ecx
			add eax,ImportDescSection.VirtualAddress
			mov [esi].OptionalHeader.SizeOfImage,eax
			;-------------------------------------------------
			; Now add the new section
			;-------------------------------------------------
			mov edx,ImportDescSection.PointerToRawData
			add edx,ImportDescSection.SizeOfRawData
			invoke SetFilePointer,hFile,edx,0,FILE_BEGIN
			invoke SetEndOfFile,hFile
			invoke UnmapViewOfFile,pMapping
			invoke CloseHandle,hMapping
			invoke CloseHandle,hFile
			mov FPatch,FALSE
			push FProjectInProgress
			mov FProjectInProgress,NO_PROJECT
			invoke CheckIfValidPE,addr TargetName
			pop FProjectInProgress
			;-----------------------------------------------
			; Clear the new section
			;-----------------------------------------------
			assume edi:nothing
			mov edi,pMapping
			add edi,ImportDescSection.PointerToRawData
			invoke RtlFillMemory,edi,ImportDescSection.SizeOfRawData,0
			;-----------------------------------------------
			; Fill the new import section with data
			;-----------------------------------------------
			mov dword ptr [edi],"EZCI"	; header
			add edi,4
			mov esi,pPEHeader
			assume esi:ptr IMAGE_NT_HEADERS
			.if [esi].OptionalHeader.DataDirectory[8*1].VirtualAddress!=0
				invoke RVAToOffset,pMapping,[esi].OptionalHeader.DataDirectory[8*1].VirtualAddress
				add eax,pMapping
				mov esi,eax
				assume esi:ptr IMAGE_IMPORT_DESCRIPTOR
				push esi
				xor ecx,ecx
				.while [esi].OriginalFirstThunk!=0 || [esi].TimeDateStamp!=0 || [esi].ForwarderChain!=0 || [esi].Name1 !=0 || [esi].FirstThunk !=0
					add ecx,sizeof IMAGE_IMPORT_DESCRIPTOR
					add esi,sizeof IMAGE_IMPORT_DESCRIPTOR
				.endw
				pop esi
				rep movsb
				mov esi,pPEHeader
				assume esi:ptr IMAGE_NT_HEADERS
			.endif
			;------------------------------------------------
			; modify the export member of data directory 
			; to point to the new section
			;------------------------------------------------
			mov esi,pPEHeader
			mov eax,ImportDescSection.VirtualAddress
			add eax,4		; we will put "ICZE" string at the beginning
			mov [esi].OptionalHeader.DataDirectory[8*1].VirtualAddress,eax
			mov eax,ImportDescSection.Misc.VirtualSize
			mov [esi].OptionalHeader.DataDirectory[8*1].isize,eax
			;------------------------------------------------------------
			; Now we add another section for the dll name, FirstThunk
			; and the OriginalFirstThunk arrays.
			; We must find how many functions we will import.
			;------------------------------------------------------------
AddNewImportDataSection:
			mov ImportDataSection.Characteristics,IMAGE_SCN_CNT_INITIALIZED_DATA+IMAGE_SCN_MEM_READ+IMAGE_SCN_MEM_WRITE
			push [esi].OptionalHeader.SizeOfImage
			pop ImportDataSection.VirtualAddress
			;------------------------------------------------------------
			; Now calculate the space required
			;------------------------------------------------------------
			invoke GetSpaceNeeded,hDlg,FunctionCount,pGlobal
			mov ImportDataSection.Misc.VirtualSize,eax
			;-------------------------------------------
			; now calculate the size of raw data
			;-------------------------------------------
			xor edx,edx
			mov ecx,FileAlignment
			div ecx
			.if edx!=0
				inc eax
			.endif
			mul ecx
			mov ImportDataSection.SizeOfRawData,eax
			;--------------------------------------
			; Store the name of the new section
			;--------------------------------------
			mov esi,offset ImportData
			lea edi,ImportDataSection
			invoke lstrlen,esi
			mov ecx,eax
			rep movsb
			;-------------------------------------
			; Prepare the space in the section table
			;--------------------------------------
			invoke PrepareSpaceInSectionTable,hDlg
			;------------------------------------------
			; Find the appropriate raw offset
			;------------------------------------------
			mov ecx,NumSection
			mov edi,pSectionTable
			assume edi:ptr IMAGE_SECTION_HEADER
			xor eax,eax
			.while ecx>0
				.if eax<[edi].PointerToRawData || eax==0
					mov eax,[edi].PointerToRawData
				.endif
				add edi,sizeof IMAGE_SECTION_HEADER
				dec ecx
			.endw
			sub edi,sizeof IMAGE_SECTION_HEADER
			add eax,[edi].SizeOfRawData
			mov ImportDataSection.PointerToRawData,eax
			;------------------------------------------
			; copy the new ISH into the section table
			;------------------------------------------
			mov edi,pSectionTable
			mov ecx,NumSection
			mov eax,sizeof IMAGE_SECTION_HEADER
			mul ecx
			add edi,eax		; edi now points to the space we can add new ISH
			lea esi,ImportDataSection
			mov ecx,sizeof IMAGE_SECTION_HEADER
			rep movsb
			;----------------------------------------------------
			; Increase the number of section and size of image
			;----------------------------------------------------
			mov esi,pPEHeader
			assume esi:ptr IMAGE_NT_HEADERS
			inc [esi].FileHeader.NumberOfSections
			mov eax,ImportDataSection.Misc.VirtualSize
			xor edx,edx
			mov ecx,SectionAlignment
			div ecx
			.if edx!=0
				inc eax
			.endif
			mul ecx
			add eax,ImportDataSection.VirtualAddress
			mov [esi].OptionalHeader.SizeOfImage,eax
			;----------------------------------------
			; Add the section to the file 
			;----------------------------------------
			mov edx,ImportDataSection.PointerToRawData
			add edx,ImportDataSection.SizeOfRawData
			invoke SetFilePointer,hFile,edx,0,FILE_BEGIN
			invoke SetEndOfFile,hFile
			invoke UnmapViewOfFile,pMapping
			invoke CloseHandle,hMapping
			invoke CloseHandle,hFile
			mov FPatch,FALSE
			push FProjectInProgress
			mov FProjectInProgress,NO_PROJECT
			invoke CheckIfValidPE,addr TargetName
			pop FProjectInProgress
			;---------------------------------------
			; Clear the section
			;---------------------------------------
			mov esi,ImportDataSection.PointerToRawData
			add esi,pMapping
			invoke RtlFillMemory,esi,ImportDataSection.SizeOfRawData,0
			;------------------------------------------
			; Now write the actual data. Starting with
			; the name of the dll
			;------------------------------------------
			mov edi,pMapping
			add edi,ImportDataSection.PointerToRawData
			push ImportDataSection.VirtualAddress
			pop DLLNameRVA
BeginFillingData:
			invoke GetDlgItemText,hDlg,IDC_NEWDLL,addr buffer,1024
			lea esi,buffer
			invoke lstrlen,esi
			mov ecx,eax
			rep movsb
			;------------------------------------------
			; Fix the DLL name VA in IMAGE_IMPORT_DESCRIPTOR structure
			;------------------------------------------
			mov esi,pPEHeader
			assume esi:ptr IMAGE_NT_HEADERS
			invoke RVAToOffset,pMapping,[esi].OptionalHeader.DataDirectory[8*1].VirtualAddress
			add eax,pMapping
			;--------------------------------------------------
			; search for the first empty IID
			;--------------------------------------------------
			assume eax:ptr IMAGE_IMPORT_DESCRIPTOR
			.while [eax].OriginalFirstThunk!=0 || [eax].TimeDateStamp!=0 || [eax].ForwarderChain!=0 || [eax].Name1!=0 || [eax].FirstThunk!=0
				add eax,sizeof IMAGE_IMPORT_DESCRIPTOR
			.endw
			assume eax:nothing
			mov pIID,eax
			assume eax:ptr IMAGE_IMPORT_DESCRIPTOR
			push DLLNameRVA
			pop [eax].Name1
			assume eax:nothing
			mov eax,ImportDataSection.PointerToRawData
			add eax,pMapping
			mov pImportData,eax
			;--------------------------------------------------------
			; Store the thunk dword array VAs to the IMAGE_IMPORT_DESCRIPTOR
			;--------------------------------------------------------
			inc edi   ; put a null between the DLL name and the thunk dword arrays
			mov eax,FunctionCount
			shl eax,2		; eax == size of each thunk dword array
			add eax,4		; the terminating null
			mov esi,edi
			add esi,eax		; esi points to the head of another thunk dword array
			mov edx,esi
			add edx,eax		; edx points to the first available space to store the name of an import function
			mov pFuncName,edx
			mov edx,pIID
			assume edx:ptr IMAGE_IMPORT_DESCRIPTOR
			mov eax,edi
			sub eax,pImportData
			add eax,ImportDataSection.VirtualAddress
			mov [edx].OriginalFirstThunk,eax
			mov eax,esi
			sub eax,pImportData
			add eax,ImportDataSection.VirtualAddress
			mov [edx].FirstThunk,eax
			assume edx:nothing
			;------------------------------------------------------------
			; esi points to the head of the FirstThunk array
			; edi points to the head of the OriginalFirstThunk array
			; pFuncName points to the first available space to store the
			;   name of an import function
			; Now we fill the members of the thunk arrays
			;-------------------------------------------------------------
			mov ecx,FunctionCount
			mov ebx,pGlobal
			.while ecx>0
				push ecx
				invoke SendDlgItemMessage,hDlg,IDC_FUNCTIONLIST,LB_GETTEXT,dword ptr [ebx],addr buffer
				.if byte ptr [buffer]>="0" && byte ptr [buffer]<="9"	; if this function is imported by ordinals
					invoke String2Dword,addr buffer
					or eax,80000000h
					mov dword ptr [edi],eax
					mov dword ptr [esi],eax
				.else
					mov eax,pFuncName
					sub eax,ImportDataSection.PointerToRawData
					sub eax,pMapping
					add eax,ImportDataSection.VirtualAddress	; eax == RVA of the function name
					mov dword ptr [edi],eax		; store the RVA of the function name
					mov dword ptr [esi],eax
					invoke lstrlen,addr buffer	; get the length of the function name
					mov ecx,eax
					mov edx,pFuncName
					inc edx
					inc edx	; edx points to the space we can store the function name
					push esi
					push edi
					lea esi,buffer
					mov edi,edx
					rep movsb
					inc edi
					mov pFuncName,edi
					pop edi
					pop esi
				.endif
				add edi,4
				add esi,4
				pop ecx
				add ebx,4
				dec ecx
			.endw
			assume edi:nothing
		.else		; if the target is already modified by this util
			;-------------------------------------------------------------------
			; We must ascertain about the available space left in the 
			; section. If space is not sufficient, we must grow it, up to
			; the virtual address of the next section. If the size
			; is still insufficient, we must move the section to a new section
			;-------------------------------------------------------------------
			push eax	; eax points to the first byte of the import section
			add eax,4	; eax points to the first IMAGE_IMPORT_DESCRIPTOR structure
			assume eax:ptr IMAGE_IMPORT_DESCRIPTOR
			xor edx,edx
			.while [eax].OriginalFirstThunk!=0 || [eax].TimeDateStamp!=0 || [eax].ForwarderChain!=0 || [eax].Name1!=0 || [eax].FirstThunk!=0
				add edx,sizeof IMAGE_IMPORT_DESCRIPTOR
				add eax,sizeof IMAGE_IMPORT_DESCRIPTOR
			.endw
			add edx,sizeof IMAGE_IMPORT_DESCRIPTOR	;the terminating null structure
			add edx,4		; icze string
			assume eax:nothing
			mov edi,pSectionTable
			assume edi:ptr IMAGE_SECTION_HEADER
			pop eax		
			sub eax,pMapping	; eax == pointer to raw data of the import section
			mov ecx,NumSection
			.while ecx>0
				.if eax==[edi].PointerToRawData
					.break
				.endif
				add edi,sizeof IMAGE_SECTION_HEADER
				dec ecx	
			.endw
			;--------------------------------------------------
			; edi points to the ISH of the import desc section
			;---------------------------------------------------
			mov pImportDescISH,edi
			;-----------------------------------------------------
			; Check if more space needs to be added to the section
			;------------------------------------------------------
			mov eax,[edi].SizeOfRawData
			sub eax,edx		; eax==available space in the section
			mov ImportDescSection.Misc.VirtualSize,edx
			.if eax<IMAGE_IMPORT_DESCRIPTOR
				mov ecx,NumSection
				mov eax,[edi].VirtualAddress
				push edi
				mov edi,pSectionTable
				.while ecx>0
					.if eax<[edi].VirtualAddress
						.if EndVA==0
							push [edi].VirtualAddress
							pop EndVA
						.else
							mov edx,EndVA
							.if edx>[edi].VirtualAddress
								push [edi].VirtualAddress
								pop EndVA
							.endif
						.endif
					.endif
					add edi,sizeof IMAGE_SECTION_HEADER
					dec ecx
				.endw
				pop edi
				mov eax,[edi].SizeOfRawData
				add eax,FileAlignment		; eax == raw size needed
				add eax,[edi].VirtualAddress	; eax == the VA of the last byte of the block
				.if eax>EndVA && EndVA!=0	; if there is no virtual space left in this section, move to a new section
					invoke RVAToOffset,pMapping,[esi].OptionalHeader.DataDirectory[8].VirtualAddress
					add eax,pMapping
					mov edi,eax
					jmp MakeNewSection
				.endif
				invoke AddSpaceToSection,pMapping,edi,FileAlignment
				.if eax!=TRUE
ErrorReturn:
					invoke GlobalUnlock,pGlobal
					invoke GlobalFree,hGlobal
					mov eax,FALSE
					ret
				.endif
			.endif
			;-----------------------------------------------------
			; Now we check the other section that contains the thunk
			; dword arrays and dll names. We can obtain the rva of
			; the section by checking the firstThunk member of the
			; last IID
			;-----------------------------------------------------
			invoke RVAToOffset,pMapping,[esi].OptionalHeader.DataDirectory[8].VirtualAddress
			add eax,pMapping
			assume eax:ptr IMAGE_IMPORT_DESCRIPTOR
			.while [eax].OriginalFirstThunk!=0 || [eax].TimeDateStamp!=0 || [eax].ForwarderChain!=0 || [eax].Name1!=0 || [eax].FirstThunk!=0
				add eax,sizeof IMAGE_IMPORT_DESCRIPTOR
			.endw
			sub eax,sizeof IMAGE_IMPORT_DESCRIPTOR	; eax points to the last IID
			.if [eax].FirstThunk!=0
				mov eax,[eax].FirstThunk
			.else
				invoke MessageBox,hDlg,addr ErrorInvalidIID,addr AppName,MB_OK+MB_ICONERROR
				jmp ErrorReturn
			.endif
			assume eax:nothing
			;---------------------------------------------------------------
			; eax now contains the rva that falls within the section
			; that contains the thunk dword arrays. Now we must get the starting
			; VA of that section
			;---------------------------------------------------------------
			mov ecx,NumSection
			mov edi,pSectionTable
			.while ecx>0
				.if eax>=[edi].VirtualAddress
					mov edx,[edi].VirtualAddress
					add edx,[edi].SizeOfRawData
					.if eax<edx
						push [edi].VirtualAddress
						pop ImportDataVA
						push [edi].SizeOfRawData
						pop ImportDataSize
						mov pImportDataISH,edi
						.break
					.endif
				.endif
				add edi,sizeof IMAGE_SECTION_HEADER
				dec ecx
			.endw
			;----------------------------------------------------------
			; Now go to the last entry of the thunk dword array. And
			; calculate the ending address of the function name pointed
			; to by that last thunk dword. So we can calculate the size
			; of the data in the section.
			;-----------------------------------------------------------
			invoke RVAToOffset,pMapping,eax
			add eax,pMapping	; eax now points to the first dword of the thunk dword array
			xor edx,edx
			.while dword ptr [eax]!=0
				test dword ptr [eax],80000000h	; if this function is not imported by ordinal
				.if ZERO?
					.if edx<dword ptr [eax] || edx==0
						mov edx,dword ptr [eax]
					.endif
				.endif
				add eax,4
			.endw
			.if edx!=0
				invoke RVAToOffset,pMapping,edx
				add eax,pMapping
			.else
				add eax,4
			.endif
			mov edi,eax
			add edi,2		; skip the hint name
			invoke lstrlen,edi
			inc eax	; terminating null
			add edi,eax	; edi points to the first available space in the section
			mov pAvailSpace,edi
			invoke RVAToOffset,pMapping,ImportDataVA
			add eax,pMapping
			mov ecx,edi
			sub ecx,eax		; ecx == size of data in the section
			mov CurrentDataSize,ecx
			;-----------------------------------------------------------------
			; Now we must check how much space we need for the new function(s)
			;-----------------------------------------------------------------
			invoke GetSpaceNeeded,hDlg,FunctionCount,pGlobal
			add ecx,eax		; ecx == actual space needed
			mov ImportDataSection.Misc.VirtualSize,ecx
			.if ecx>ImportDataSize		; if the space required is larger than currently available, we must pad the section
				mov eax,ecx
				xor edx,edx
				mov ecx,FileAlignment
				div ecx
				.if edx!=0
					inc eax
				.endif
				mul ecx	; eax is the size of raw data
				push eax
				add eax,ImportDataVA	; eax now contains the VA of the last byte in the section
				mov ecx,NumSection
				mov edi,pSectionTable
				assume edi:ptr IMAGE_SECTION_HEADER
				mov EndVA,0
				mov edx,ImportDataVA
				.while ecx>0
					.if edx<[edi].VirtualAddress
						.if EndVA==0
							push [edi].VirtualAddress
							pop EndVA
						.else
							mov ebx,EndVA
							.if ebx>[edi].VirtualAddress
								push [edi].VirtualAddress
								pop EndVA
							.endif
						.endif
					.endif
					add edi,sizeof IMAGE_SECTION_HEADER
					dec ecx
				.endw
				;-------------------------------------------------------
				; EndVA now contains the limiting VA of the import data
				; section. if EndVA is zero, the import data section is
				; the last section.
				;-------------------------------------------------------
				.if eax>EndVA && EndVA!=0	; if there is not enough space, just move to a new section
					jmp AddNewImportDataSection
				.endif
				pop edx	; edx == size of the section 
				sub edx,ImportDataSize
				invoke AddSpaceToSection,pMapping,pImportDataISH,edx
			.endif
			;-------------------------------------------------------------
			; Now everything is clear, we can add more functions to the
			; section
			;-------------------------------------------------------------
			mov edi,pImportDataISH
			assume edi:ptr IMAGE_SECTION_HEADER
			push [edi].PointerToRawData
			pop ImportDataSection.PointerToRawData
			mov eax,pAvailSpace
			sub eax,pMapping
			sub eax,[edi].PointerToRawData
			add eax,[edi].VirtualAddress
			mov DLLNameRVA,eax
			push [edi].VirtualAddress
			pop ImportDataSection.VirtualAddress
			;-------------------------------------------
			; Modify the virtual size of both import
			; sections
			;-------------------------------------------
			mov eax,ImportDescSection.Misc.VirtualSize
			mov [esi].OptionalHeader.DataDirectory[8].isize,eax
			mov edi,pImportDescISH
			assume edi:ptr IMAGE_SECTION_HEADER
			mov [edi].Misc.VirtualSize,eax
			mov edi,pImportDataISH
			push ImportDataSection.Misc.VirtualSize
			pop [edi].Misc.VirtualSize
			mov edi,pAvailSpace
			assume edi:nothing
			jmp BeginFillingData
	      .endif
	.else		; if the target doesn't import any function, we must create a new section for import
		xor ecx,ecx		
		jmp MakeNewSections
	.endif
	assume esi:nothing
	invoke GlobalUnlock,pGlobal
	invoke GlobalFree,hGlobal
	mov eax,TRUE
	ret
AddNewImport endp

AppendSectionToFile proc uses edi esi hDlg:DWORD
	LOCAL hTemp:dword
	LOCAL hTempMapping:DWORD
	LOCAL pTempMapping:DWORD
	LOCAL SectionHeader:IMAGE_SECTION_HEADER
	LOCAL bytesWritten:DWORD

	mov ofn.lStructSize,SIZEOF ofn
	push hDlg
	pop  ofn.hWndOwner
	push hInstance
	pop  ofn.hInstance
	mov  ofn.lpstrFilter, OFFSET SectionFilterString
	mov  ofn.lpstrFile, OFFSET FileName
	mov  ofn.nMaxFile,sizeof FileName
	mov byte ptr [FileName],0
	mov ofn.Flags,OFN_LONGNAMES or OFN_NOCHANGEDIR or\
		 OFN_EXPLORER or OFN_HIDEREADONLY or OFN_PATHMUSTEXIST
	invoke GetOpenFileName,addr ofn
	.if eax!=0
		invoke CreateFile,addr FileName,GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
		.if eax!=INVALID_HANDLE_VALUE
			mov hTemp,eax
			invoke CreateFileMapping,hTemp,NULL,PAGE_READONLY,NULL,NULL,NULL
			.if eax!=NULL
				mov hTempMapping,eax
				invoke MapViewOfFile,hTempMapping,FILE_MAP_READ, NULL,NULL,NULL
				.if eax!=NULL
					mov pTempMapping,eax
					;-----------------------------------------------------------------
					; Show dialog box prompting for the new section's characteristics
					; and name.
					;------------------------------------------------------------------
					invoke DialogBoxParam,hInstance,IDD_NEWSECTION,hDlg,addr NewSectionProc,NULL
					.if eax==1
						invoke RtlZeroMemory,addr SectionHeader,sizeof IMAGE_SECTION_HEADER
						invoke PrepareSpaceInSectionTable,hDlg
						mov edi,pSectionTable
						assume edi:ptr IMAGE_SECTION_HEADER
						mov esi,pPEHeader
						assume esi:ptr IMAGE_NT_HEADERS
						mov ecx,NumSection
						xor edx,edx
						.while ecx>0
							.if edx<[edi].PointerToRawData || edx==0
								mov edx,[edi].PointerToRawData
								mov eax,[edi].SizeOfRawData
							.endif
							add edi,sizeof IMAGE_SECTION_HEADER
							dec ecx
						.endw
						.if edx==0		; if there is no section
							mov edx,[esi].OptionalHeader.SizeOfHeaders
						.else
							add edx,eax		; edx == pointer to raw data of the new section	
						.endif
						;--------------------------------------------------
						; Fill ISH of the new section
						;--------------------------------------------------
						mov SectionHeader.PointerToRawData,edx
						push [esi].OptionalHeader.SizeOfImage
						pop SectionHeader.VirtualAddress
						invoke GetFileSize,hTemp,NULL
						mov SectionHeader.Misc.VirtualSize,eax
						xor edx,edx
						mov ecx,[esi].OptionalHeader.FileAlignment
						div ecx
						.if edx!=0
							inc eax
						.endif
						mul ecx
						mov SectionHeader.SizeOfRawData,eax
						push Characteristics
						pop SectionHeader.Characteristics
						invoke RtlMoveMemory,addr SectionHeader,addr NewSectionName,8
						;----------------------------------------
						; Append the new section
						;----------------------------------------
						invoke SetFilePointer,hFile,SectionHeader.PointerToRawData,0,FILE_BEGIN
						invoke WriteFile,hFile,pTempMapping,SectionHeader.Misc.VirtualSize,addr bytesWritten,NULL
						mov ecx,SectionHeader.PointerToRawData
						add ecx,SectionHeader.SizeOfRawData
						invoke SetFilePointer,hFile,ecx,0,FILE_BEGIN
						invoke SetEndOfFile,hFile
						invoke UnmapViewOfFile,pMapping
						invoke CloseHandle,hMapping
						invoke CloseHandle,hFile
						mov FPatch,FALSE
						push FProjectInProgress
						mov FProjectInProgress,NO_PROJECT
						invoke CheckIfValidPE,addr TargetName
						pop FProjectInProgress
						;----------------------------------------------
						; Fill the padding with zeroes
						;----------------------------------------------
						mov edx,pMapping
						add edx,SectionHeader.PointerToRawData
						add edx,SectionHeader.Misc.VirtualSize
						mov ecx,SectionHeader.SizeOfRawData
						sub ecx,SectionHeader.Misc.VirtualSize
						invoke RtlZeroMemory,edx,ecx
						;-----------------------------------------------
						; Modify the pe header
						;------------------------------------------------
						mov eax,NumSection
						xor edx,edx
						mov ecx,sizeof IMAGE_SECTION_HEADER
						mul ecx
						add eax,pSectionTable
						lea esi,SectionHeader
						mov edi,eax
						mov ecx,sizeof IMAGE_SECTION_HEADER
						rep movsb
						;-----------------------------------------------
						; New image size
						;-----------------------------------------------
						mov esi,pPEHeader
						mov eax,SectionHeader.Misc.VirtualSize
						xor edx,edx
						mov ecx,[esi].OptionalHeader.SectionAlignment
						div ecx
						.if edx!=0
							inc eax
						.endif
						mul ecx
						add eax,SectionHeader.VirtualAddress
						mov [esi].OptionalHeader.SizeOfImage,eax
						;-----------------------------------------------
						; Number of section
						;-----------------------------------------------
						inc [esi].FileHeader.NumberOfSections
						inc NumSection
						;------------------------------------------------
						; Update the listview
						;------------------------------------------------
						invoke GetDlgItem,hDlg,IDC_SECTIONLIST
						invoke UpdateListView,eax
						assume edi:nothing
					.endif
					invoke UnmapViewOfFile,pTempMapping
					jmp CloseHandles
				.else
					invoke ShowErrorMessage,hDlg
CloseHandles:
					invoke CloseHandle,hTempMapping
					invoke CloseHandle,hTemp
				.endif
			.else
				invoke ShowErrorMessage,hDlg
				invoke CloseHandle,hTemp
			.endif
		.else
			invoke ShowErrorMessage,hDlg
		.endif
	.endif	
	ret
AppendSectionToFile endp
