.386
.model flat,stdcall
option casemap:none

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc

includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib

CAT_Decode  PROTO   :DWORD,:DWORD,:DWORD
SCAT_Clumps PROTO   :DWORD,:DWORD,:DWORD,:DWORD
UPA_Check   PROTO   :DWORD
CC_Convert  PROTO   :DWORD,:DWORD,:DWORD
IBX_Convert PROTO   :DWORD,:DWORD

.data

table   db  "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/",0
len     dd  0
count   dd  0
count2  dd  0
equal   dd  0

.const
b0      equ     eax
b1      equ     ebx
b2      equ     ecx
b3      equ     edx
n       equ     eax



.code
DLLEntry PROC DLLinst:DWORD, Reason:DWORD, Reserved1:DWORD
        mov  eax,1
        ret
DLLEntry ENDP

CAT_Decode  PROC    scat:DWORD, lengt:DWORD, output:DWORD
    mov     count, 0
    mov     count2, 0
    mov     eax, lengt
    mov     ecx, 4
    xor     edx, edx
    div     ecx
    mov     eax, 4
    sub     al, dl
    mov     len, eax

@loop:
    xor     eax, eax
    xor     ecx, ecx
    xor     edx, edx
    
    mov     ebx, scat
    add     ebx, count
    mov     edi, OFFSET table
    mov     esi, output
    add     esi, count2
    mov     equal, 0
    
    @b_loop:

        push    ecx

        shl     edx, 8    

        movzx   eax, byte ptr [ebx]
        .if     al == '='
            inc     equal
        .endif
        mov     cx, 0FFh
        repne   scasb
        sub     edi, OFFSET table
        dec     edi
        mov     eax, edi
        mov     dl, al


        mov     edi, OFFSET table

        pop     ecx
        inc     ecx
        inc     ebx
        cmp     ecx, 4
        jnz     @b_loop


        rol     edx, 16
        movzx   b0, dh
        movzx   b1, dl
        rol     edx, 16
        movzx   b2, dh
        movzx   b3, dl

        shl     n, 6
        or      n, b1
        shl     n, 6
        or      n, b2
        shl     n, 6
        or      n, b3

        mov     ebx, n
        mov     ecx, n
        mov     edx, n
        xchg    edi, esi

        cmp     equal, 3
        jz      @next
        shr     ebx, 16
        xor     ebx, 67
        mov     al, bl
        stosb

        cmp     equal, 2
        jz      @next
        shr     ecx, 8
        and     ecx, 0FFh
        xor     ecx, 67
        mov     al, cl
        stosb

        cmp     equal, 1
        jz      @next
        and     edx, 0FFh
        xor     edx, 67
        mov     al, dl
        stosb

@next:

    add     count, 4
    add     count2, 3
    mov     eax, count
    cmp     eax, lengt
    
    jl      @loop
    
    .if     len != 4
        mov     eax, len
        mov     ebx, lengt
        mov     ecx, output
        sub     ebx, eax
        add     ecx, ebx
        dec     ecx
        mov     byte ptr [ecx], 0
    .endif   
    

    ret

CAT_Decode  ENDP

SCAT_Clumps PROC    scat:DWORD, scat_sn:DWORD, scat_type:DWORD, scat_upc:DWORD

    invoke  lstrlen, scat
    dec     eax
    mov     ebx, eax
    mov     eax, scat
    cmp     byte ptr [eax], '.'
    jnz     @badend
    cmp     byte ptr [eax + ebx], '.'
    jnz     @badend

    mov     eax, scat
    inc     eax
@loop:
    mov     bl, byte ptr [eax]
    cmp     bl, '.'
    jnz     @next
    mov     byte ptr [eax], 0
@next:
    inc     eax
    cmp     byte ptr [eax], 0
    jnz     @loop

    mov     ebx, scat
    inc     ebx

    invoke  lstrcpy, scat_sn, ebx
    invoke  lstrlen, ebx
    add     ebx, eax
    inc     ebx

    invoke  lstrcpy, scat_type, ebx
    invoke  lstrlen, ebx
    add     ebx, eax
    inc     ebx
    
    invoke  lstrcpy, scat_upc, ebx
    invoke  lstrlen, ebx
    
    xor     eax,eax
    
    jmp     @end
    
@badend:
    mov     eax, -1

@end:
    ret

SCAT_Clumps ENDP

UPA_Check   PROC    upa:DWORD

    invoke  lstrlen, upa
    cmp     eax, 12
    jnz     @badend

    xor     eax, eax
    xor     ebx, ebx
    xor     ecx, ecx
    xor     edx, edx
    mov     count, 1
    mov     esi, upa

@loop:
    push    edx
    xor     edx, edx
    mov     eax, count
    mov     ecx, 2
    div     ecx
    cmp     dl, 0
    pop     edx
    jnz     @odd
    
    lodsb
    sub     al, 30h
    add     ebx, eax
    jmp     @next
@odd:
    lodsb
    sub     al, 30h
    add     edx, eax
@next:
    inc     count
    cmp     count, 12
    jl      @loop

    imul    edx, 3
    add     edx, ebx
    mov     eax, edx
    xor     edx, edx
    mov     ecx, 10
    div     ecx
    xor     eax, eax
    lodsb
    cmp     dl, 0
    jnz     @notzero
    mov     dl, 10
@notzero:
    sub     al, 30h
    mov     dh, 10
    sub     dh, dl
    cmp     al, dh
    jz      @goodend

@badend:
    mov     eax, -1
    jmp     @end

@goodend:
    mov     eax, 0
    
@end:
    ret

UPA_Check   ENDP

CC_Convert  PROC    upc:DWORD, cc:DWORD, utype:DWORD

    cld
    mov     edi, cc
    mov     esi, utype
    mov     al, 'C'
    stosb
    movzx   eax, byte ptr [esi + 2]
    sub     al, 32
    xor     edx, edx
    mov     ecx, 10
    div     ecx
    add     al, 30h
    stosb
    movzx   eax, byte ptr [esi + 2]
    sub     al, 32
    xor     edx, edx
    mov     ecx, 10
    div     ecx
    mov     al, dl
    add     al, 30h
    stosb
    invoke  lstrlen, upc
    mov     count, eax
    mov     count2, 0
    mov     esi, upc
@loop:
    xor     eax, eax
    lodsb
    dec     esi
    sub     al, 32
    mov     ecx, 10
    xor     edx, edx
    div     ecx
    add     al, 30h
    stosb
    xor     eax, eax
    lodsb
    sub     al, 32
    mov     ecx, 10
    xor     edx, edx
    div     ecx
    movzx   eax, dl
    add     al, 30h
    stosb
    inc     count2
    mov     eax, count2
    cmp     count, eax
    jnz     @loop

ret

CC_Convert  ENDP

IBX_Convert PROC    upc:DWORD, ibx:DWORD

    cld
    mov     esi, upc
    mov     edi, ibx
    add     esi, 3
    mov     count, 0
@loop:
    movsb
    inc     count
    .if     (count == 1) || (count == 4) || (count == 9)
        mov     al, '-'
        stosb
    .endif
    cmp     count, 9
    jnz     @loop

    mov     esi, upc
    add     esi, 3
    mov     ecx, 10
    xor     eax, eax
    xor     ebx, ebx

@checkdigit:

    lodsb
    sub     al, 30h
    imul    eax, ecx
    add     ebx, eax
    loop    @checkdigit

    xor     edx, edx
    mov     eax, ebx
    mov     ebx, 11
    div     ebx
    movzx   edx, dl
    sub     ebx, edx
    .if     ebx == 10
        mov     al, 'X'
        stosb
    .else
        mov     al, bl
        add     al, 30h
        stosb
    .endif

ret

IBX_Convert ENDP 

END DLLEntry