;͸
; SIB.ASM                   Small Is Beautiful           created: 10/29/96 
;                   Generic Win32 Application Template			    
;;
		 	TITLE SIB - Small Is Beautiful

include windows.inc

;͸
;                              E Q U A T E S				    
;;
NAMEDbit	equ	1h	; fFileStatus 0=NoChanges 1=Changed
CHANGEDbit	equ	2h	; fFileStatus 0=NeedsName 1=Named

ID_STATUSBAR	equ	0F0h	; ID's for our two local controls
ID_TOOLBAR	equ	0F1h

; Equates also defined in the resource file 

IDI_ICON	equ	01h	; resource IDs
IDM_MENU	equ	02h
IDA_ACCEL	equ	03h
IDD_ABOUT	equ	04h

IDS_SYSMENU	equ	10h	; system Menu ID
IDM_FILEMENU	equ	11h	; menu IDs
IDM_HELPMENU	equ	12h

IDM_NEW		equ	20h	; file Menu Command IDs
IDM_OPEN	equ	21h
IDM_SAVE	equ	22h
IDM_SAVEAS	equ	23h
IDM_EXIT	equ	24h
IDM_HELPTOPICS	equ	25h	; help Menu Command IDs
IDM_ABOUT	equ	26h


;͸
;                    Function and Procedure Prototypes			    
;;
MiscCenterWnd	PROTO	STDCALL :HWND, :HWND
AboutProc	PROTO	STDCALL :HWND, :UINT, :WPARAM, :LPARAM
OnlyOneInstance	PROTO	STDCALL
Initialization	PROTO	STDCALL


				.const
;͸
;                            C O N S T A N T S				    
;;
szClassName	SBYTE	"SIB",0
szFilter	SBYTE	"Text Files (*.TXT)",0,"*.TXT",0
		SBYTE	"All Files (*.*)",0,"*.*",0,0
szDefExt	SBYTE	"txt",0

tbButtons	TBBUTTON <STD_FILENEW,  IDM_NEW,  TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0>
		TBBUTTON <STD_FILEOPEN, IDM_OPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0>
		TBBUTTON <STD_FILESAVE, IDM_SAVE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0>


				.data?
;͸
;                  U N I N I T I A L I Z E D    D A T A		    
;;
hInst		HINSTANCE	?
lpCmdLine	LPSTR		?
nCmdShow	SDWORD		?
hMainWnd	HWND		?
hAccel		HACCEL		?
hFile		HANDLE		?
fFileStatus	DWORD		?		; see COMMON.INC for EQUs
szFileTitle	SBYTE		MAX_PATH DUP (?)
hdc		HDC		?		; for WM_PAINT
ps		PAINTSTRUCT 	<>
hStatusBar	HWND		?
szStatusBar	SBYTE		40h DUP (?)
bSimpleMode	DWORD		?		; simple Status Bar TRUE/FALSE
hToolBar	HWND		?
szToolTip	SBYTE		10h DUP (?)


				.data
;͸
;                                 D A T A				    
;;
ofn		OPENFILENAME <SIZEOF(OPENFILENAME), NULL, NULL,\
		OFFSET szFilter, NULL, NULL, 1h, OFFSET szFile, MAX_PATH,\
		OFFSET szFileTitle, MAX_PATH, NULL, NULL, 0, 0, 0,\
		OFFSET szDefExt, 0, 0, 0>
szSaveChanges	SBYTE	"Save changes to the following file?",0Ah,0Ah
szFile		SBYTE	MAX_PATH DUP (0)
szWindowName	SBYTE	(MAX_PATH + 10h) DUP (0)


				.code
;͸
;                        EXECUTION BEGINS HERE ...			    
;;
Start:		invoke	GetModuleHandle, NULL	; get our module's handle
		mov	hInst, eax
		invoke	GetCommandLine		; and the command line
		mov	lpCmdLine, eax
		mov	nCmdShow, SW_SHOWDEFAULT

;	Call our WinMain where we'll stay until GetMessage drops us out...

		invoke	WinMain, hInst, 0, lpCmdLine, nCmdShow
		invoke	ExitProcess, eax	; eax == Exit Code
;͸
;                      EXECUTION TERMIATES HERE ...			    
;;

;//////////////////////////////////////////////////////////////////////////

;͸
;                                WIN MAIN				    
;
WinMain	PROC	STDCALL, hInstance:HINSTANCE, hPrevInstance:HINSTANCE, pCmdLine:LPSTR, CmdShow:SDWORD
	LOCAL	msg:MSG
;
call	OnlyOneInstance	; insure that we have ONLY one instance
.IF (eax)
	call	Initialization	; and that initialization succeeds
	.IF (eax)
		invoke	LoadAccelerators, hInst, IDA_ACCEL
		mov	hAccel,eax
		.IF (eax)
			.WHILE TRUE
				invoke	GetMessage, ADDR msg, NULL, 0, 0
				.BREAK .IF (!eax)
				invoke	TranslateAccelerator, msg.hwnd, hAccel, ADDR msg
				.CONTINUE .IF (eax)	; skip if we handled
				invoke	TranslateMessage, ADDR msg
				invoke	DispatchMessage, ADDR msg
			.ENDW
			mov	eax, msg.wParam		; wParam == Exit Code
		.ENDIF
	.ENDIF
.ENDIF
ret
;
WinMain	ENDP


;͸
;                                WND PROC				    
;ĳ
;                 Our application's main window procedure		    
;
WndProc	PROC	STDCALL, hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
;
mov	eax, uMsg			; pickup our message
.IF (eax <= WM_MENUSELECT)		; if it COULD be important to us ...
;Ŀ
; WM_MENUSELECT							    
;
	.IF (zero?)
		reset	DWORD PTR szStatusBar	; Clear Status Text
		mov	eax, wParam		; fuFlags = HIWORD wParam
		shr	eax, 10h
		.IF (eax == 0FFFFh) && (!lParam)
			mov	bSimpleMode, FALSE
			invoke	SendMessage, hStatusBar, SB_SIMPLE, FALSE, 0
			jmp	ReturnZero
		.ENDIF
		;
		.IF !(eax & MFT_SEPARATOR)
			.IF !(eax & MF_POPUP)	; CommandID = LOWORD wParam
				mov	eax, wParam
				and	eax, 0FFFFh
			.ELSE
				.IF (eax & MF_SYSMENU)	; System Menu
					mov	eax, IDS_SYSMENU
				.ELSE	; Menu Index = LOWORD wParam
					mov	eax, wParam
					add	eax, IDM_FILEMENU
				.ENDIF
			.ENDIF	; eax = StatusBar StringID
			invoke	LoadString, hInst, eax, ADDR szStatusBar, 40h
		.ENDIF
		;
		mov	eax, TRUE
		.IF (eax != bSimpleMode)
			mov	bSimpleMode, eax	; eax=TRUE
			invoke	SendMessage, hStatusBar, SB_SIMPLE, eax, 0h
		.ENDIF
		invoke	SendMessage, hStatusBar, SB_SETTEXT, 0FFh + SBT_NOBORDERS, ADDR szStatusBar

;Ŀ
; WM_PAINT								    
;
	.ELSEIF (eax == WM_PAINT)
		invoke	BeginPaint, hWnd, ADDR ps
		mov	hdc, eax

		; <<< PAINT OUR CLIENT AREA HERE >>>

		invoke	EndPaint, hWnd, ADDR ps

;Ŀ
; WM_SIZE								    
;
	.ELSEIF (eax == WM_SIZE)
		invoke	SendMessage, hStatusBar, uMsg, wParam, lParam
		invoke	SendMessage, hToolBar, uMsg, wParam, lParam

;Ŀ
; WM_CREATE								    
;
	.ELSEIF (eax == WM_CREATE)
		invoke	GetDesktopWindow
		invoke	MiscCenterWnd, hWnd, eax	;Center Main Window
		invoke	InitCommonControls


;		Create the Status Window
		invoke	CreateStatusWindow, WS_CHILD + WS_BORDER + WS_VISIBLE,
			ADDR szStatusBar, hWnd, ID_STATUSBAR
		mov	hStatusBar,eax
		.IF (eax)
;			Create the Toolbar
			invoke	CreateToolbarEx, hWnd,
				WS_CHILD + WS_BORDER + WS_VISIBLE + TBSTYLE_TOOLTIPS,
				ID_TOOLBAR, 0Bh, HINST_COMMCTRL, IDB_STD_SMALL_COLOR,
				ADDR tbButtons, 3h, 10h, 10h, 10h, 10h, SIZEOF(TBBUTTON)
			mov	hToolBar,eax
			check	eax
			iffalse	@F
			;--------------------------------------------------------------------------
			call	CmdIDM_NEW
		.ELSE
@@:			zero	eax
			dec	eax
			jmp	Return		; return -1 to exit
		.ENDIF

;Ŀ
; WM_CLOSE								    
;
	.ELSEIF (eax == WM_CLOSE)
caseWM_CLOSE:	call	SaveChanges
		.IF (eax)
			invoke	DestroyWindow, hMainWnd
		.ENDIF

;Ŀ
; WM_DESTROY								    
;
	.ELSEIF (eax == WM_DESTROY)
		invoke	PostQuitMessage, 0

;Ŀ
; WM_NOTIFY								    
;
	.ELSEIF (eax == WM_NOTIFY)
		mov	eax, lParam	; **** Process Notifications ****
		mov	eax, (NMHDR PTR [eax]).code
		cmp	eax, TTN_NEEDTEXT
		jne	DefProc
		;--------------------------------------------------------------------------
		mov	eax, lParam
		mov	eax, (TOOLTIPTEXT PTR [eax]).hdr.idFrom
		add	eax, 80h	; eax=Tooltip StringID
		invoke	LoadString, hInst, eax, ADDR szToolTip, 10h
		mov	eax, lParam
		mov	(TOOLTIPTEXT PTR [eax]).lpszText,OFFSET szToolTip

;Ŀ
; WM_COMMAND								    
;
	.ELSEIF (eax == WM_COMMAND)
		mov	eax,wParam	;**** Process Menu Commands ****
		and	eax,0FFFFh
; <<< IDM_NEW >>>
		.IF (eax == IDM_NEW)
			call	CmdIDM_NEW
; <<< IDM_OPEN >>>
		.ELSEIF (eax == IDM_OPEN)
			call	SaveChanges
			.IF (eax)
				movmov	ofn.hwndOwner, eax, hMainWnd
				mov	ofn.Flags, OFN_PATHMUSTEXIST + OFN_FILEMUSTEXIST
				invoke	GetOpenFileName, ADDR ofn
				.IF (eax)
					; <<< FILE OPEN CODE HERE >>>
					or	fFileStatus, NAMEDbit
					and	fFileStatus, NOT CHANGEDbit
					call	NewWindowName
					mov	eax, TRUE	; return TRUE
					jmp	Return
					;
OpenError:				invoke	GetLastError
					; <<< FILE OPEN ERROR CODE HERE >>>
				.ENDIF
				zero	eax	; return FALSE
			.ENDIF
; <<< IDM_SAVERS >>>
		.ELSEIF (eax == IDM_SAVEAS)
			and	fFileStatus,NOT NAMEDbit
			jmp	@F
; <<< IDM_SAVE >>>
		.ELSEIF (eax == IDM_SAVE)
@@:			call	CmdIDM_SAVE
; <<< IDM_EXIT >>>
		.ELSEIF (eax == IDM_EXIT)
			je	caseWM_CLOSE
; <<< IDM_ABOUT >>>
		.ELSEIF (eax == IDM_ABOUT)
			invoke	DialogBoxParam, hInst, IDD_ABOUT, hMainWnd, ADDR AboutProc, NULL

		.ELSE ; it was some other WM_COMMAND ... give default handling
			jmp	DefProc
		.ENDIF
	.ELSE ; it was come other WM_MESSAGE ... so give it default handling
		jmp	DefProc
	.ENDIF
.ELSE
;Ŀ
; WM_??? - It wasn't something we care about, so give it default handling  
;
DefProc:	invoke	DefWindowProc, hWnd, uMsg, wParam, lParam
		jmp	Return
.ENDIF
ReturnZero:	zero	eax	; return 0 if message is processed
		jmp	Return


CmdIDM_NEW:
;͸
;                               Cmd IDM_NEW				    
;
	call	SaveChanges
	.IF (eax)
		; <<< OTHER CODE HERE ?? >>>
		mov	DWORD PTR szFile,    "itnU"	; "Untitled"
		mov	DWORD PTR szFile[4], "delt"
		zero	eax
		mov	DWORD PTR szFile[8], eax
		mov	ofn.nFileOffset, ax
		mov	ofn.nFileExtension, 9
		and	fFileStatus, NOT NAMEDbit
		and	fFileStatus, NOT CHANGEDbit
		call	NewWindowName
	.ENDIF
;
	LocalReturn


SaveChanges:
;͸
;                              Save Changes				    
;
	mov	eax, IDNO
	.IF (fFileStatus & CHANGEDbit)
		invoke	MessageBox, hMainWnd, ADDR szSaveChanges,
			ADDR szClassName, MB_YESNOCANCEL + MB_ICONWARNING
		.IF (eax == IDYES)
			call	CmdIDM_SAVE ; returns FALSE to CANCEL
			LocalReturn	    ; or TRUE to continue
		.ELSEIF (eax == IDCANCEL)
			zero	eax	; return FALSE to CANCEL
			LocalReturn
		.ENDIF
	.ENDIF
	mov	eax, TRUE
;
	LocalReturn


CmdIDM_SAVE:
;͸
;                               CmdIDM_SAVE				    
;
	.IF !(fFileStatus & NAMEDbit)	; does the file need a name?
		movmov	ofn.hwndOwner, eax, hMainWnd ; get file name
		mov	ofn.Flags, OFN_HIDEREADONLY + OFN_OVERWRITEPROMPT
		invoke	GetSaveFileName, ADDR ofn
		.IF (eax == 0)	; if it was zero, cancel and save
			LocalReturn
		.ENDIF
	.ENDIF
	; <<< YOUR FILE SAVE CODE HERE >>>

	or	fFileStatus, NAMEDbit
	and	fFileStatus, NOT CHANGEDbit
	call	NewWindowName
	mov	eax, TRUE	; return TRUE to continue
	LocalReturn

SaveError: invoke GetLastError

	; <<< SAVE ERROR HANDLING HERE >>>

;
	LocalReturn


NewWindowName:
;͸
;                    Set the Main Parent's Window Name			    
;
	pushem	<esi, edi>
;--------------------------------------------------------------------------
	mov	esi, OFFSET szFile
	zero	eax
	mov	ax, ofn.nFileOffset
	add	esi, eax		; copy filename only
	zero	ecx
	mov	cx, ofn.nFileExtension
	sub	ecx, eax		; do not show extension
	mov	edi, OFFSET szWindowName
	rep movsb

	dec	edi			; add changed status
	.IF (fFileStatus & CHANGEDbit)
		mov	BYTE PTR [edi],"*"
		inc	edi
	.ENDIF
	mov	DWORD PTR [edi], "  - "	; add application name
	add	edi, 3
	mov	esi, OFFSET szClassName
	mov	ecx, 9
	rep movsb

	invoke	SetWindowText, hWnd, ADDR szWindowName
	popem	<edi, esi>
;
	LocalReturn

;
;-////////////////////////////////////////////////////////////////////////-
Return:		ret
;
WndProc		ENDP


;͸
;                    Handle the ABOUT Dialog Messages			    
;
AboutProc	PROC	STDCALL, hDlg:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
;
	mov	eax, uMsg
	.IF (eax == WM_INITDIALOG)
		invoke	MiscCenterWnd, hDlg, hMainWnd

	.ELSEIF (eax == WM_COMMAND) && ((wParam == IDOK) || (wParam == IDCANCEL))
		invoke	EndDialog, hDlg, TRUE
	.ELSE
		mov	eax, FALSE	; show message not processed
		jmp	Return
	.ENDIF
	mov	eax, TRUE		; show message was processed
Return:	ret
;
AboutProc	ENDP


;͸
;                           Misc Center Window				    
;
MiscCenterWnd	PROC	STDCALL, hChild:HWND, hParent:HWND
		LOCAL	rcP:RECT, rcC:RECT, xNew:DWORD, yNew:DWORD
;
invoke	GetWindowRect, hParent, ADDR rcP
.IF (eax)
	invoke	GetWindowRect, hChild, ADDR rcC
	.IF (eax)
		mov	eax, rcP.right	;center horizontally
		sub	eax, rcP.left	;x=Px+(Pdx-Cdx)/2
		sub	eax, rcC.right
		add	eax, rcC.left
		sar	eax, 1
		add	eax, rcP.left
		.IF (sign?)		; check if off screen at left
			zero	eax
		.ENDIF
		mov	xNew, eax

		invoke	GetSystemMetrics, SM_CXFULLSCREEN
		sub	eax, rcC.right
		add	eax, rcC.left
		.IF (eax < xNew)	; check if off screen at right
			mov	xNew, eax
		.ENDIF

		mov	eax, rcP.bottom	; center vertically
		sub	eax, rcP.top	; y=Py+(Pdy-Cdy)/2
		sub	eax, rcC.bottom
		add	eax, rcC.top
		sar	eax, 1
		add	eax, rcP.top
		.IF (sign?)		; check if off screen at top
			zero	eax
		.ENDIF
		mov	yNew,eax

		invoke	GetSystemMetrics, SM_CYFULLSCREEN
		sub	eax, rcC.bottom
		add	eax, rcC.top
		.IF (eax < yNew)
			mov	yNew, eax
		.ENDIF

		invoke	SetWindowPos, hChild, NULL, xNew, yNew, 0, 0, SWP_NOSIZE + SWP_NOZORDER
	.ENDIF
.ENDIF
Return:	ret
;
MiscCenterWnd	ENDP


;͸
;                            Only One Instance				    
;
OnlyOneInstance	PROC	STDCALL
		LOCAL	hSemaphore:HANDLE
;
	invoke	CreateSemaphore, NULL, 0, 1, ADDR szClassName
	mov	hSemaphore,eax

	invoke	GetLastError
	.IF (eax == ERROR_ALREADY_EXISTS)
		invoke	CloseHandle, hSemaphore
	.ELSE
		.IF (eax == ERROR_SUCCESS) ; created Semaphore will
			mov	eax, TRUE  ; prevent other instances
			jmp	Return	   ; return TRUE to continue
		.ENDIF
	.ENDIF

	invoke	FindWindow, ADDR szClassName, NULL
	check	eax
	iffalse	Return		; return FALSE (eax=0) to exit

	invoke	GetLastActivePopup, eax
	mov	hMainWnd, eax		; eax == hMainWnd or hPopupWnd

	invoke	IsIconic, hMainWnd
	.IF (eax)
		invoke	ShowWindow, hMainWnd, SW_RESTORE
		jmp	ReturnZero	; return FALSE (eax=0) to exit
	.ENDIF
	invoke	SetForegroundWindow, hMainWnd

ReturnZero:	zero	eax		; return FALSE (eax=0) to exit
Return:		ret
;
OnlyOneInstance	ENDP


;͸
;                             Initialization				    
;
Initialization	PROC	STDCALL
		LOCAL	wcex:WNDCLASSEX
;
	mov	wcex.cbSize, SIZEOF WNDCLASSEX
	mov	wcex.style, CS_HREDRAW or CS_VREDRAW
	mov	wcex.lpfnWndProc, OFFSET WndProc

	zero	eax
	mov	wcex.cbClsExtra, eax
	mov	wcex.cbWndExtra, eax

	movmov	wcex.hInstance, eax, hInst

	invoke	LoadIcon, hInst, IDI_ICON
	mov	wcex.hIcon, eax

	invoke	LoadCursor, NULL, IDC_ARROW
	mov	wcex.hCursor, eax

	mov	wcex.hbrBackground, COLOR_WINDOW + 1
	mov	wcex.lpszMenuName,  IDM_MENU
	mov	wcex.lpszClassName, OFFSET szClassName

	invoke	LoadImage, hInst, IDI_ICON, IMAGE_ICON, 16, 16, NULL
	mov	wcex.hIconSm, eax

	invoke	RegisterClassEx, ADDR wcex
	.IF (eax)
		invoke	CreateWindowEx, NULL, ADDR szClassName,
			ADDR szClassName, WS_OVERLAPPEDWINDOW,
			0, 0, 1A0h, 180h, NULL, NULL, hInst, NULL
		.IF (eax)
			mov	hMainWnd,eax
			invoke	ShowWindow, hMainWnd, nCmdShow
			invoke	UpdateWindow, hMainWnd
		.ENDIF
	.ENDIF
	ret
;
Initialization	ENDP


;
;-///////////////////////////////////////////////////////////////////////////-
;			      END OF THE ROAD
;-///////////////////////////////////////////////////////////////////////////-
END	Start
