;
;         Anti Spammer
;         written by JimmyClif
;         in Masm32
;
;         Socket Procs File (note the forward references tho)



;========================================================================
;                           ReadSocket
;========================================================================
;  Here we get the lenght of the content available on the socket for
;  reading, then we allocate enough space in a buffer and read it.
;  After that our Buffer will be processed thru ProcessLine depending on 
;  the Flags we're at.
;========================================================================
ReadSocket proc
     invoke ioctlsocket,sock,FIONREAD,ADDR SizeToRead
     .IF NotDoneReading==0
          invoke GlobalAlloc,GHND,MEMSIZE ;as elo 65535d
          mov hMemory,eax
          invoke GlobalLock,eax
          mov pMemory,eax
          mov StartOfMemory,eax
     .ELSE
          invoke ioctlsocket,sock,FIONREAD,ADDR SizeToRead
          mov edx,ActualDataRead
          mov eax,pMemory
          add eax,edx
     .ENDIF
     invoke recv, sock, eax, SizeToRead, 0
     add ActualDataRead,eax
     
     .IF eax==SOCKET_ERROR
          invoke ShowErrorAndClose
     .ELSE
          invoke ProcessLine
          .IF NotDoneReading==1
               ret
          .ENDIF
     .ENDIF          
     invoke GlobalUnlock,pMemory
     invoke GlobalFree,hMemory
     mov ActualDataRead,0
     ret
ReadSocket endp

;========================================================================
;                           ConnectSocket
;========================================================================
;  Here we create our socket, we initialize it to non-blocking mode
;  convert the Provider URL with htons, and get in contact with the 
;  remote Host - then we wait for the FD_READ.
;========================================================================
ConnectSocket proc
     invoke socket, PF_INET, SOCK_STREAM,0
     .IF eax!=INVALID_SOCKET
          mov sock,eax
          ;Fill our SocketAdress Structure with data
          mov SocketAdress.sin_family, PF_INET         ;there is only one PF_INET
          invoke htons,HTTPPort                        ;convert port into network byte order
          mov SocketAdress.sin_port, ax                ;note this is a 16bit word size param
          invoke inet_addr, ADDR szHostName              ;let's assume the user typed "214.121.55.214" as Host
          .IF eax==INADDR_NONE                         ;If INADDR_NONE occurs it is a "www.it.fr" sort of adress
               invoke gethostbyname,ADDR szHostName
               .IF eax==NULL
                    invoke ShowErrorAndClose           ; no host? why did we fail? anyway... show & close
                    ret
               .ENDIF
               mov eax,[eax+12]                        ; move the value of h_list member into eax 
               mov eax,[eax]                           ; copy the pointer to the actual IP address into eax 
               mov eax,[eax]                           ; copy IP address into eax 
          .ENDIF
          mov SocketAdress.sin_addr, eax
          
          invoke WSAAsyncSelect,sock,hWnd,WM_SOCKET,\  ;Setting up what messages we're interested in
                                FD_CONNECT or FD_READ or FD_CLOSE
          .IF eax==NULL  ;successfull
               invoke connect, sock, ADDR SocketAdress, SIZEOF SocketAdress
               .IF eax==SOCKET_ERROR
                    invoke WSAGetLastError
                    .IF eax!=WSAEWOULDBLOCK
                         invoke ShowErrorAndClose
                    .ENDIF
               .ENDIF
          .ELSE
               invoke ShowErrorAndClose          
          .ENDIF
          
     .ELSE
          invoke ShowError                             ; why did the socket creation fail?
          ret
     .ENDIF
     ret
ConnectSocket endp

;========================================================================
;                           CloseMySocket
;========================================================================
;  Here we close our socket, set the sock handle back to 0 and get rid
;  of the leftover waiting data on our socket if there is some. 
;========================================================================
CloseMySocket proc
     .IF sock!=0
          invoke ClearWaitingData          
          invoke closesocket,sock
          mov sock,0
     .ENDIF  
     ret
CloseMySocket endp

;========================================================================
;                           ClearWaitingData
;========================================================================
;  Get rid of the leftover waiting data on our socket if there is some. 
;========================================================================
ClearWaitingData proc
LOCAL MyMSG:MSG

     mov eax,TRUE
     .WHILE eax==TRUE    ; Since there may be WM_SOCKET messages left in the message queues,
                         ; we must get rid of them before we create new socket.
          invoke PeekMessage,addr MyMSG,hWnd,WM_SOCKET,WM_SOCKET,PM_REMOVE
     .ENDW
     ret
ClearWaitingData endp

;========================================================================
;                           ReconnectIfPossible
;========================================================================
;  Tries to reconnect, or shows the error if all else fails.
;========================================================================
ReconnectIfPossible proc

     .IF eax==WSAECONNREFUSED || eax==WSAENETUNREACH || eax==WSAETIMEDOUT
          invoke CloseMySocket
          invoke ConnectSocket
     .ELSE
          invoke ShowErrorAndClose
     .ENDIF
     ret
ReconnectIfPossible endp

;========================================================================
;                           DisableControls
;========================================================================
;  Disabling the CheckMail Button and the CheckMail MenuItem.
;========================================================================
DisableControls proc

     invoke EnableWindow,hConnectButton,FALSE
     invoke EnableMenuItem,hMenu,IDM_CONNECT,MF_GRAYED
     ret
DisableControls endp

;========================================================================
;                           EnableControls
;========================================================================
;  Re-Enabling the CheckMail Button and the CheckMail MenuItem.
;========================================================================
EnableControls proc

     invoke EnableWindow,hConnectButton,TRUE
     invoke EnableMenuItem,hMenu,IDM_CONNECT,MF_ENABLED
     ret
EnableControls endp


;========================================================================
;                      Other Socket related Includes
;========================================================================
include ProcessLine.asm