;--------------------
; TIMPAD v.033
; Simple Text Editor
; Supports up to 65536 bytes
; written by: timon   POLAND 2001
; contact/questions/suggestions/ (99% reply):	ti_mo_n@poczta.onet.pl
;						ti_mo_n@wp.pl
; you can use, change, or put this onto your website
; but you have to credit me!
;--------------------------------
; command line should separated with '|' mark
;
; c:\windows\timpad\timpad.exe |c:\mytexts\text1.txt
;--------------------
ideal	; declare ideal mode

p386n	; use 80386


model flat, stdcall ; windows flat memory model, stdcall convention


include "windows.inc"	; include files (should be within the archive)

MAXSIZE equ 260		; declare constants
MEMSIZE equ 65535

;-16------------ Uninitialized data segment follows ------------------
udataseg

MessageStruct	MSG ?		; used for window messages
ofn		OPENFILENAME ?	; used to get the filename
rct		RECT ?		; used for resizing
hwndMain	dd ?		; handle of main window
hwndEdit	dd ?		; handle of edit
hInst		dd ?		; applicatio instance
SizeRead	dd ?		; bytes read fro file
hFont		dd ?		; handle to font created with CreateFont
hMenu		dd ?		; handle to menu resource

;-30------------ Initialized data segment follows -------------------
dataseg

WindowClass	WNDCLASS <0, offset MainWindowCallback, 0, 0, 0, 0, 0,COLOR_WINDOW+1, 2, szAppName>
szAppName	db 'timpad v 0.33 (beta release)', 0
title		db "Select a file",0

edinam		db "edit",0

FilterString	db "All usable types"	,0,"*.txt;*.asm;*.cfg;*.nfo;*.inc;*.reg;*.inf;*.ini",0
		db "Text Files (*.txt)"		,0,"*."
defex		db "txt",0
		db "Assembly Files (*.asm)"	,0,"*.asm",0
		db "Configuration Files (*.cfg)",0,"*.cfg",0
		db "Info Files (*.nfo)"		,0,"*.nfo",0
		db "Include Files (*.inc)"	,0,"*.inc",0
		db "Registry Files (*.reg)"	,0,"*.reg",0
		db "Installation Files (*.inf)"	,0,"*.inf",0
		db "Settings Files (*.ini)"	,0,"*.ini",0
		db "All Files (*.*)"		,0,"*.*"  ,0,0

buffer		db MAXSIZE dup(0)
zerostr		db 0			; used for clearing the fields

lptext		db 'Error while opening file.',0
lpcapt		db 'timpad ERROR',0
lpcpt2		db 'About timpad...',0
lptxt2		db 'timpad v0.33 (beta). Written by timon. POLAND 2001',0
fontstring	db 'Fixedsys',0
lState		db 0			; used when retrieving command line
allowsave	db 0			; when set to 1: save option is enabled, this option disables when 'new' is clicked or app starts
ww		db 0			; 0: wordwrap disabled (default)   1: wordwrap enabled
;-56-------------------- Code segment follows -------------------------
codeseg

; Define main window callback type as WNDPROC
procdesc MainWindowCallback WNDPROC

proc	MainWindowCallback uses ebx esi edi, hwnd, uMsg, wParam, lParam

		; Dispatch window message
			mov	ebx, [hwnd]
			mov	eax, [uMsg]
			mov	ecx, [wParam]
			mov	edx, [lParam]
			cmp	eax, WM_COMMAND
			je	@@command
			cmp	eax, WM_SETFOCUS
			je	cancel1
			cmp	eax, WM_INITMENUPOPUP
			je	@@menupop
		 	cmp	eax, WM_SIZE
			je	@@size
			cmp	eax, WM_CREATE
			je	@@create
			cmp	eax, WM_DESTROY
			je	@@destroy

		; Default message processing
			call	DefWindowProc, ebx, eax, [wParam], [lParam]
			ret

		; WM_INITMENUPOPUP message   -  here we disable certain menu functions, because there is no sense for them to be executed
@@menupop:
			cmp	edx,1
			jnz	@@create
			mov	edi, ecx

			call	SendMessage, [hwndEdit], EM_CANUNDO, 0, 0
			or	al,al
			jnz	enabl
			push	MF_GRAYED
			jmp	disabl
enabl:			push	MF_ENABLED
disabl:			push	5013
			push	edi
			call	EnableMenuItem	; change the state of UNDO command

			call	IsClipboardFormatAvailable, CF_TEXT
			or	al,al
			jnz	enabl2
			push	MF_GRAYED
			jmp	disabl2
enabl2:			push	MF_ENABLED
disabl2:		push	5008
			push	edi
			call	EnableMenuItem ; change the state of PASTE command

			push	0
			mov	ecx,esp
			push	0
			mov	ebx,esp
			push	ecx   ; end of selection
			push	ebx   ; start of selection
			push	large EM_GETSEL
			push	[hwndEdit]
			call	SendMessage
			pop	ecx
			pop	ebx
			cmp	ecx,ebx
			jnz	enabl3
			mov	eax, MF_GRAYED
			jmp	disabl3
enabl3:			mov	eax, MF_ENABLED
disabl3:		push	eax
			push	eax
			push	eax
			push	5006
			push	edi
			call	EnableMenuItem
			push	5007
			push	edi
			call	EnableMenuItem
			push	5009
			push	edi
			call	EnableMenuItem

			cmp	[ww],0
			jnz	enabl4
			push	MF_UNCHECKED
			jmp	disabl4
enabl4:			push	MF_CHECKED
disabl4:		push	5014
			push	edi
			call	CheckMenuItem

			call	SetFocus, [hwndEdit]

		; WM_CREATE message, return zero
@@create:		xor	eax, eax
			ret

		; WM_DESTROY message, finish the message loop.
@@destroy:		call	PostQuitMessage, 0
			xor	eax, eax
			ret

@@paint:
			xor	eax, eax
			ret

@@size:
			mov	eax,edx
			shr	eax,16
			and	edx,0ffffh
size2:			call	MoveWindow,[hwndEdit],0,0,edx,eax,1
			call	SetFocus, [hwndEdit]
			xor eax,eax
			ret

stopp:			call	MessageBox, [hwndMain], offset lptext, offset lpcapt, MB_OK or MB_APPLMODAL or MB_ICONSTOP
			ret

@@command:
			cmp	ecx, 5001
			jne	nxt
			call	SetWindowText, [hwndEdit], offset zerostr
			and	[allowsave],0
			jmp	cancel1
nxt:			cmp	ecx, 5002
			jne	nxt2
	; open file
			mov	[ofn.Flags], OFN_FILEMUSTEXIST or OFN_PATHMUSTEXIST or OFN_LONGNAMES or OFN_EXPLORER or OFN_HIDEREADONLY or OFN_NOREADONLYRETURN
			call	GetOpenFileName, offset ofn
			or	eax,eax
			jz	cancel1
loadf:			call	CreateFile,offset buffer, GENERIC_READ or GENERIC_WRITE ,\
					FILE_SHARE_READ, 0,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE, 0
			cmp	eax, INVALID_HANDLE_VALUE
			jz	stopp
			mov	ebx,eax
			call	GetFileSize, eax, 0
			cmp	eax, 65535
			jb	size_ok
			call	CloseHandle, ebx
			call	MessageBox, [hwndMain], offset lptext, offset lpcapt, MB_OK or MB_APPLMODAL or MB_ICONSTOP
			jmp	cancel1
size_ok:		call	GlobalAlloc,GMEM_MOVEABLE or GMEM_ZEROINIT,MEMSIZE
			push	eax	; we store it for global free
			call	GlobalLock, eax
			push	eax	; \
			push	eax	; /we store it for sendmessage and global unlock
			call	ReadFile, ebx, eax, MEMSIZE-1,offset SizeRead, 0
			push	0
			push	WM_SETTEXT
			push	[hwndEdit]
			call	SendMessage
			call	CloseHandle, ebx
			call	GlobalUnlock	; handle stored earlied
			call	GlobalFree	; handle stored earlier
			mov	[allowsave],1

cancel1:		call	SetFocus, [hwndEdit]
			xor eax,eax
			ret
;--------
nxt2:			cmp	ecx, 5003
			je	@save
			cmp	ecx, 5004
			jne	nxt4

	; save file
;157
@sava:			mov	[ofn.Flags],OFN_LONGNAMES or OFN_EXPLORER or OFN_HIDEREADONLY or OFN_OVERWRITEPROMPT or OFN_NOREADONLYRETURN
			call	GetSaveFileName, offset ofn
			or	eax,eax
			jz	cancel1
@write:			call	CreateFile,offset buffer, GENERIC_READ or GENERIC_WRITE ,\
				FILE_SHARE_READ , 0,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE, 0
			mov	ebx,eax
			call	GlobalAlloc,GMEM_MOVEABLE or GMEM_ZEROINIT,MEMSIZE
			push	eax
			call	GlobalLock, eax
			mov	esi,eax
			push	eax
			call	SendMessage, [hwndEdit],WM_GETTEXT,MEMSIZE-1, eax
			call	WriteFile, ebx, esi, eax, offset SizeRead, 0
			call	CloseHandle, ebx
			call	GlobalUnlock
			call	GlobalFree
			mov	[allowsave],1
			jmp	cancel1

nxt4:			cmp	ecx, 5005
			jne	nxt5
			jmp	@@destroy

nxt5:			cmp	ecx, 5010
			jne	nxt6
			call	MessageBox, [hwndMain], offset lptxt2, offset lpcpt2, MB_OK or MB_APPLMODAL or MB_ICONINFORMATION
			jmp	fin

nxt6:
			cmp	ecx, 5009
			jnz	nxt7
			mov	eax,WM_CLEAR
			jmp	editproc
nxt7:			cmp	ecx, 5008
			jnz	nxt8
			mov	eax,WM_PASTE
			jmp	editproc
nxt8:			cmp	ecx, 5007
			jnz	nxt9s
			mov	eax,WM_COPY
			jmp	editproc
nxt9s:			cmp	ecx,5013
			jnz	nxt9
			mov	eax,WM_UNDO
			jmp	editproc
nxt9:			cmp	ecx,5006
			jnz	nxt10
			mov	eax,WM_CUT
nxt10:			cmp	ecx,5011
			jnz	nxt11
			push	-1
			push	0
			push	EM_SETSEL
			jmp	sel

editproc:		push	0
			push	0
			push	eax
sel:			push	[hwndEdit]
			call	SendMessage
			jmp	cancel1

@save:			or	[allowsave],0
			jz	@sava
			jmp	@write

fin:			call	SetFocus, [hwndEdit]
			xor eax,eax
			ret

nxt11:			cmp	ecx,5012
			jnz	nxt12
			jmp	loadf

nxt12:			cmp	ecx, 5014
			jnz	fin

			call	GlobalAlloc, GMEM_MOVEABLE or GMEM_ZEROINIT, 65565
			or	eax,eax
			jz	fin
			mov	edi, eax
			call	GlobalLock, eax
			or	eax,eax
			jz	fin2
			mov	ebx, eax
			call	SendMessage, [hwndEdit], WM_GETTEXT, 65534, eax
			call	DestroyWindow, [hwndEdit]
			cmp	[ww],0
			jz	setww
			mov	[ww],0
			mov	eax, WS_CHILD or WS_VISIBLE or ES_MULTILINE or WS_VSCROLL or ES_AUTOVSCROLL or ES_AUTOHSCROLL or WS_HSCROLL
			jmp	skip3
setww:			mov	[ww],1
			mov	eax, WS_CHILD or WS_VISIBLE or ES_MULTILINE or WS_VSCROLL or ES_AUTOVSCROLL
skip3:

			call	CreateWindowEx,WS_EX_CLIENTEDGE, offset edinam, ebx, eax,0,0,0,0, [hwndMain],3, [hInst],0
			mov	[hwndEdit],eax

			call	CreateFont, 16, 0, 0, 0, 400, 0, 0, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH or SYSTEM_FONT, offset fontstring

			call	SendMessage, [hwndEdit], WM_SETFONT, eax, 0

			call	GlobalUnlock, ebx
			call	GlobalFree, edi

			call	GetClientRect, [hwndMain], offset rct
			mov	eax,[rct.bottom]
			mov	edx,[rct.right]

			jmp	size2

fin2:			call	GlobalFree,edi
			call	SetFocus, [hwndEdit]
			xor eax,eax
			ret
endp
;--------------------- Program entry point --------------------------
;---------------------			   --------------------------

proc	main
		; Get the instance handle
			xor	edi, edi
			call	GetModuleHandle, edi
			mov	ebx, eax
			mov	[hInst],eax

		; Get the command line

			call	GetCommandLine	; get handle to our command line

again:			inc	eax
			mov	dl, [eax]
			or	dl,dl
			jz	skip
			cmp	dl,"|"
			jnz	again
			inc	eax

			call	wsprintf, offset buffer, eax, ebx
			mov	[lState],1
skip:
		; Prepare window class
			mov	[WindowClass.hInstance], ebx

			call	LoadIcon, ebx, 1
			mov	[WindowClass.hIcon], eax

			call	LoadCursor, edi, IDC_ARROW
			mov	[WindowClass.hCursor], eax

			call	LoadMenu, ebx, 2
			mov	[hMenu],eax

		; Register the class
			call	RegisterClass, offset WindowClass

		; Create main window
			call	CreateWindowEx, edi, offset szAppName, offset szAppName,\
				 WS_OVERLAPPEDWINDOW,\
				 CW_USEDEFAULT, CW_USEDEFAULT, 598, 430, edi, edi, ebx, edi
			mov	[hwndMain], eax
			push 	eax

		; create edit

			call CreateWindowEx,WS_EX_CLIENTEDGE, offset edinam,edi,\ 
				WS_CHILD or WS_VISIBLE or ES_LEFT or ES_MULTILINE or ES_AUTOHSCROLL or ES_AUTOVSCROLL or WS_VSCROLL or WS_HSCROLL,\ 
				0,0,580,415,eax,3,ebx,edi
			mov [hwndEdit],eax
			call	SetFocus,[hwndEdit]

			call	SendMessage, [hwndEdit], EM_SETLIMITTEXT, 65534, 0

			call	CreateFont, 16, 0, 0, 0, 400, 0, 0, 0, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH or SYSTEM_FONT, offset fontstring

			call	SendMessage, [hwndEdit], WM_SETFONT, eax, 0

		; Show the window
			call	ShowWindow, [hwndMain], SW_SHOWNORMAL
			call	UpdateWindow, [hwndMain]

		; initialize members of openfilename

			mov	[ofn.lStructSize],size ofn
			pop	eax
			mov	[ofn.hwndOwner],eax
			mov	[ofn.hInstance],ebx
			mov	[ofn.lpstrFilter], offset FilterString
			mov	[ofn.nMaxFile],MAXSIZE
			mov	[ofn.lpstrTitle], offset title
			mov	[ofn.lpstrFile], offset buffer
			mov	[ofn.lpstrInitialDir], 0
			mov	[ofn.lpstrDefExt], offset defex


			mov	al,[lState]
			or	al,al
			jz	skip2
			call	SendMessage, [hwndMain], WM_COMMAND, 5012, 0
skip2:			call	SetFocus,[hwndEdit]

		; Message loop
			mov	esi, offset MessageStruct
			jmp	@@get_msg
@@msg_loop:		call	TranslateMessage, esi
			call	DispatchMessage, esi
@@get_msg:		call	GetMessage, esi, edi, edi, edi
			or	eax, eax
			jnz	@@msg_loop
endd:
		; Finish the program
			call	ExitProcess, [MessageStruct.wParam]
endp

; Mark Program Entry Point
end main
