;****************************************************************************\
;*									       *
;* commctrl.h - - Interface for the Windows Common Controls		       *
;*									       *
;* Version 1.2								       *
;*									       *
;* Copyright (c) 1991-1998, Microsoft Corp.	 All rights reserved.	       *
;*									       *
;\****************************************************************************

procdesc InitCommonControls

struc	INITCOMMONCONTROLSEX
	dwSize			dd ?		; size of this structure
	dwICC			dd ?		; flags indicating which classes to be initialized
ends

ICC_LISTVIEW_CLASSES		= 000000001h ; listview, header
ICC_TREEVIEW_CLASSES		= 000000002h ; treeview, tooltips
ICC_BAR_CLASSES 		= 000000004h ; toolbar, statusbar, trackbar, tooltips
ICC_TAB_CLASSES 		= 000000008h ; tab, tooltips
ICC_UPDOWN_CLASS		= 000000010h ; updown
ICC_PROGRESS_CLASS		= 000000020h ; progress
ICC_HOTKEY_CLASS		= 000000040h ; hotkey
ICC_ANIMATE_CLASS		= 000000080h ; animate
ICC_WIN95_CLASSES		= 0000000FFh
ICC_DATE_CLASSES		= 000000100h ; month picker, date picker, time picker, updown
ICC_USEREX_CLASSES		= 000000200h ; comboex
ICC_COOL_CLASSES		= 000000400h ; rebar (coolbar) control
ICC_INTERNET_CLASSES		= 000000800h
ICC_PAGESCROLLER_CLASS		= 000001000h   ; page scroller
ICC_NATIVEFNTCTL_CLASS		= 000002000h   ; native font control

procdesc InitCommonControls: dword

ODT_HEADER			= 100
ODT_TAB 			= 101
ODT_LISTVIEW			= 102

;====== Ranges for control message IDs =======================================

LVM_FIRST			= 01000h      ; ListView messages
TV_FIRST			= 01100h      ; TreeView messages
HDM_FIRST			= 01200h      ; Header messages
TCM_FIRST			= 01300h      ; Tab control messages

PGM_FIRST			= 01400h      ; Pager control messages
CCM_FIRST			= 02000h      ; Common control shared messages
CCM_LAST			= (CCM_FIRST + 0200h)

CCM_SETBKCOLOR			= (CCM_FIRST + 1) ; lParam is bkColor

struc	COLORSCHEME
	dwSize			dd ?
	clrBtnHighlight 	dd ?	; highlight color
	clrBtnShadow		dd ?	; shadow color
ends

CCM_SETCOLORSCHEME		= (CCM_FIRST + 2) ; lParam is color scheme
CCM_GETCOLORSCHEME		= (CCM_FIRST + 3) ; fills in COLORSCHEME pointed to by lParam
CCM_GETDROPTARGET		= (CCM_FIRST + 4)
CCM_SETUNICODEFORMAT		= (CCM_FIRST + 5)
CCM_GETUNICODEFORMAT		= (CCM_FIRST + 6)
COMCTL32_VERSION		= 5
CCM_SETVERSION			= (CCM_FIRST + 7)
CCM_GETVERSION			= (CCM_FIRST + 8)
CCM_SETNOTIFYWINDOW		= (CCM_FIRST + 9) ; wParam == hwndParent.

INFOTIPSIZE			= 1024

;====== Generic WM_NOTIFY notification codes =================================

NM_OUTOFMEMORY			= (NM_FIRST-1)
NM_CLICK			= (NM_FIRST-2)	  ; uses NMCLICK struct
NM_DBLCLK			= (NM_FIRST-3)
NM_RETURN			= (NM_FIRST-4)
NM_RCLICK			= (NM_FIRST-5)	  ; uses NMCLICK struct
NM_RDBLCLK			= (NM_FIRST-6)
NM_SETFOCUS			= (NM_FIRST-7)
NM_KILLFOCUS			= (NM_FIRST-8)
NM_CUSTOMDRAW			= (NM_FIRST-12)
NM_HOVER			= (NM_FIRST-13)
NM_NCHITTEST			= (NM_FIRST-14)   ; uses NMMOUSE struct
NM_KEYDOWN			= (NM_FIRST-15)   ; uses NMKEY struct
NM_RELEASEDCAPTURE		= (NM_FIRST-16)
NM_SETCURSOR			= (NM_FIRST-17)   ; uses NMMOUSE struct
NM_CHAR 			= (NM_FIRST-18)   ; uses NMCHAR struct
NM_TOOLTIPSCREATED		= (NM_FIRST-19)   ; notify of when the tooltips window is create
NM_LDOWN			= (NM_FIRST-20)
NM_RDOWN			= (NM_FIRST-21)

;====== Generic WM_NOTIFY notification structures ============================

struc	NMTOOLTIPSCREATED
	hdr			NMHDR ?
	hwndToolTips		dd ?
ends

struc	NMMOUSE
	hdr			NMHDR ?
	dwItemSpec		dd ?
	dwItemData		dd ?
	pt			POINT ?
	dwHitInfo		dd ?		; any specifics about where on the item or control the mouse is
ends

typedef NMCLICK NMMOUSE

; Generic structure to request an object of a specific type.

struc	NMOBJECTNOTIFY
	hdr			NMHDR ?
	iItem			dd ?
	piid			dd ?
	pObject 		dd ?
	hResult 		dd ?
	dwFlags 		dd ?		; control specific flags (hints as to where in iItem it hit)
ends

; Generic structure for a key

struc	NMKEY
	hdr			NMHDR ?
	nVKey			dd ?
	uFlags			dd ?
ends

; Generic structure for a character

struc	NMCHAR
	hdr			NMHDR ?
	ch			dd ?
	dwItemPrev		dd ?		; Item previously selected
	dwItemNext		dd ?		; Item to be selected
ends

;====== WM_NOTIFY codes (NMHDR.code values) ==================================

NM_FIRST			= (0-  0)	; generic to all controls
NM_LAST 			= (0- 99)

LVN_FIRST			= (0-100)	; listview
LVN_LAST			= (0-199)

HDN_FIRST			= (0-300)	; header
HDN_LAST			= (0-399)

TVN_FIRST			= (0-400)	; treeview
TVN_LAST			= (0-499)

TTN_FIRST			= (0-520)	; tooltips
TTN_LAST			= (0-549)

TCN_FIRST			= (0-550)	; tab control
TCN_LAST			= (0-580)

; Shell reserved	       (0U-580U) -  (0U-589U)

CDN_FIRST			= (0-601)	; common dialog (new)
CDN_LAST			= (0-699)

TBN_FIRST			= (0-700)	; toolbar
TBN_LAST			= (0-720)

UDN_FIRST			= (0-721)	 ; updown
UDN_LAST			= (0-740)

MCN_FIRST			= (0-750)	; monthcal
MCN_LAST			= (0-759)

DTN_FIRST			= (0-760)	; datetimepick
DTN_LAST			= (0-799)

CBEN_FIRST			= (0-800)	; combo box ex
CBEN_LAST			= (0-830)

RBN_FIRST			= (0-831)	; rebar
RBN_LAST			= (0-859)

IPN_FIRST			= (0-860)	; internet address
IPN_LAST			= (0-879)	; internet address

SBN_FIRST			= (0-880)	; status bar
SBN_LAST			= (0-899)

PGN_FIRST			= (0-900)	; Pager Control
PGN_LAST			= (0-950)

WMN_FIRST			= (0-1000)
WMN_LAST			= (0-1200)

MSGF_COMMCTRL_BEGINDRAG 	= 04200h
MSGF_COMMCTRL_SIZEHEADER	= 04201h
MSGF_COMMCTRL_DRAGSELECT	= 04202h
MSGF_COMMCTRL_TOOLBARCUST	= 04203h

;==================== CUSTOM DRAW ==========================================

; custom draw return flags
; values under 0x00010000 are reserved for global custom draw values.
; above that are for specific controls
CDRF_DODEFAULT			= 000000000h
CDRF_NEWFONT			= 000000002h
CDRF_SKIPDEFAULT		= 000000004h

CDRF_NOTIFYPOSTPAINT		= 000000010h
CDRF_NOTIFYITEMDRAW		= 000000020h
CDRF_NOTIFYSUBITEMDRAW		= 000000020h  ; flags are the same, we can distinguish by context
CDRF_NOTIFYPOSTERASE		= 000000040h

; drawstage flags
; values under 0x00010000 are reserved for global custom draw values.
; above that are for specific controls
CDDS_PREPAINT			= 000000001h
CDDS_POSTPAINT			= 000000002h
CDDS_PREERASE			= 000000003h
CDDS_POSTERASE			= 000000004h
; the 0x000010000 bit means it's individual item specific
CDDS_ITEM			= 000010000h
CDDS_ITEMPREPAINT		= (CDDS_ITEM + CDDS_PREPAINT)
CDDS_ITEMPOSTPAINT		= (CDDS_ITEM + CDDS_POSTPAINT)
CDDS_ITEMPREERASE		= (CDDS_ITEM + CDDS_PREERASE)
CDDS_ITEMPOSTERASE		= (CDDS_ITEM + CDDS_POSTERASE)
CDDS_SUBITEM			= 000020000h

; itemState flags
CDIS_SELECTED			= 00001h
CDIS_GRAYED			= 00002h
CDIS_DISABLED			= 00004h
CDIS_CHECKED			= 00008h
CDIS_FOCUS			= 00010h
CDIS_DEFAULT			= 00020h
CDIS_HOT			= 00040h
CDIS_MARKED			= 00080h
CDIS_INDETERMINATE		= 00100h

struc	NMCUSTOMDRAW
	hdr			NMHDR ?
	dwDrawStage		dd ?
	hdc			dd ?
	rc			RECT ?
	dwItemSpec		dd ?	; this is control specific, but it's how to specify an item.  valid only with CDDS_ITEM bit set
	uItemState		dd ?
	lItemlParam		dd ?
ends

struc	NMTTCUSTOMDRAW
	nmcd			NMCUSTOMDRAW ?
	uDrawFlags		dd ?
ends

;====== IMAGE APIS ===========================================================

CLR_NONE			= 0FFFFFFFFh
CLR_DEFAULT			= 0FF000000h

struc	IMAGELISTDRAWPARAMS
	cbSize			dd ?
	himl			dd ?
	i			dd ?
	hdcDst			dd ?
	x			dd ?
	y			dd ?
	cx			dd ?
	cy			dd ?
	xBitmap 		dd ?		; x offest from the upperleft of bitmap
	yBitmap 		dd ?		; y offset from the upperleft of bitmap
	rgbBk			dd ?
	rgbFg			dd ?
	fStyle			dd ?
	dwRop			dd ?
ends

ILC_MASK			= 00001h
ILC_COLOR			= 00000h
ILC_COLORDDB			= 000FEh
ILC_COLOR4			= 00004h
ILC_COLOR8			= 00008h
ILC_COLOR16			= 00010h
ILC_COLOR24			= 00018h
ILC_COLOR32			= 00020h
ILC_PALETTE			= 00800h      ; (not implemented)

procdesc ImageList_Create :dword, :dword, :dword, :dword, :dword
procdesc ImageList_Destroy :dword
procdesc ImageList_GetImageCount :dword
procdesc ImageList_SetImageCount :dword, :dword, :dword
procdesc ImageList_Add :dword, :dword, :dword
procdesc ImageList_ReplaceIcon :dword, :dword, :dword
procdesc ImageList_SetBkColor :dword, :dword
procdesc ImageList_GetBkColor :dword
procdesc ImageList_SetOverlayImage :dword, :dword, :dword

ILD_NORMAL			= 00000h
ILD_TRANSPARENT 		= 00001h
ILD_MASK			= 00010h
ILD_IMAGE			= 00020h
ILD_ROP 			= 00040h
ILD_BLEND25			= 00002h
ILD_BLEND50			= 00004h
ILD_OVERLAYMASK 		= 00F00h

ILD_SELECTED			= ILD_BLEND50
ILD_FOCUS			= ILD_BLEND25
ILD_BLEND			= ILD_BLEND50
CLR_HILIGHT			= CLR_DEFAULT

procdesc ImageList_Draw :dword, :dword, :dword, :dword, :dword, :dword
procdesc ImageList_Replace :dword, :dword, :dword, :dword
procdesc ImageList_AddMasked :dword, :dword, :dword
procdesc ImageList_DrawEx :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc ImageList_DrawIndirect :dword
procdesc ImageList_Remove :dword, :dword
procdesc ImageList_GetIcon :dword, :dword, :dword
procdesc ImageList_LoadImageA :dword, :dword, :dword, :dword, :dword, :dword, :dword

ImageList_LoadImage		equ <ImageList_LoadImageA>

ILCF_MOVE			= (000000000h)
ILCF_SWAP			= (000000001h)

procdesc ImageList_Copy :dword, :dword, :dword, :dword, :dword
procdesc ImageList_BeginDrag :dword, :dword, :dword, :dword
procdesc ImageList_EndDrag
procdesc ImageList_DragEnter :dword, :dword, :dword
procdesc ImageList_DragLeave :dword
procdesc ImageList_DragMove :dword, :dword
procdesc ImageList_SetDragCursorImage :dword, :dword, :dword, :dword
procdesc ImageList_DragShowNolock :dword
procdesc ImageList_GetDragImage :dword, :dword
procdesc ImageList_Read :dword
procdesc ImageList_Write :dword, :dword

struc	IMAGEINFO
	hbmImage		dd ?
	hbmMask 		dd ?
	Unused1 		dd ?
	Unused2 		dd ?
	rcImage 		RECT ?
ends

procdesc ImageList_GetIconSize :dword, :dword, :dword
procdesc ImageList_SetIconSize :dword, :dword, :dword
procdesc ImageList_GetImageInfo :dword, :dword, :dword
procdesc ImageList_Merge :dword, :dword, :dword, :dword, :dword, :dword
procdesc ImageList_Duplicate :dword
procdesc ImageList_SetFlags :dword, :dword

;====== HEADER CONTROL =======================================================

WC_HEADER			equ <'SysHeader32', 0>

HDS_HORZ			= 00000h
HDS_BUTTONS			= 00002h
HDS_HOTTRACK			= 00004h
HDS_HIDDEN			= 00008h

HDS_DRAGDROP			= 00040h
HDS_FULLDRAG			= 00080h
HDS_FILTERBAR			= 00100h

HDFT_ISSTRING			= 00000h	; HD_ITEM.pvFilter points to a HD_TEXTFILTER
HDFT_ISNUMBER			= 00001h	; HD_ITEM.pvFilter points to a INT

HDFT_HASNOVALUE 		= 08000h	; clear the filter, by setting this bit

struc	HD_TEXTFILTER
	pszText 		dd ?		; [in] pointer to the buffer containing the filter (ANSI)
	cchTextMax		dd ?		; [in] max size of buffer/edit control buffer
ends

typedef HDTEXTFILTER		HD_TEXTFILTER

struc	HDITEM
	mask			dd ?
	cxy			dd ?
	pszText 		dd ?
	hbm			dd ?
	cchTextMax		dd ?
	fmt			dd ?
	lParam			dd ?
if _WIN32_IE ge 0300h
	iImage			dd ?		; index of bitmap in ImageList
	iOrder			dd ?		; where to draw this item
endif
if _WIN32_IE ge 0500h
	type			dd ?		; [in] filter type (defined what pvFilter is a pointer to)
	pvFilter		dd ?		; [in] fillter data see above
endif
ends

typedef HD_ITEM 		HDITEM

HDI_WIDTH			= 00001h
HDI_HEIGHT			= HDI_WIDTH
HDI_TEXT			= 00002h
HDI_FORMAT			= 00004h
HDI_LPARAM			= 00008h
HDI_BITMAP			= 00010h
HDI_IMAGE			= 00020h
HDI_DI_SETITEM			= 00040h
HDI_ORDER			= 00080h
HDI_FILTER			= 00100h

HDF_LEFT			= 0
HDF_RIGHT			= 1
HDF_CENTER			= 2
HDF_JUSTIFYMASK 		= 00003h
HDF_RTLREADING			= 4

HDF_OWNERDRAW			= 08000h
HDF_STRING			= 04000h
HDF_BITMAP			= 02000h
HDF_BITMAP_ON_RIGHT		= 01000h
HDF_IMAGE			= 00800h

HDM_GETITEMCOUNT		= (HDM_FIRST + 0)
HDM_INSERTITEM			= (HDM_FIRST + 1)
HDM_DELETEITEM			= (HDM_FIRST + 2)
HDM_GETITEM			= (HDM_FIRST + 3)
HDM_SETITEM			= (HDM_FIRST + 4)

struc	HDLAYOUT
	prc			dd ?
	pwpos			dd ?
ends

typedef HD_LAYOUT		HDLAYOUT

HDM_LAYOUT			= (HDM_FIRST + 5)

HHT_NOWHERE			= 00001h
HHT_ONHEADER			= 00002h
HHT_ONDIVIDER			= 00004h
HHT_ONDIVOPEN			= 00008h
HHT_ONFILTER			= 00010h
HHT_ONFILTERBUTTON		= 00020h
HHT_ABOVE			= 00100h
HHT_BELOW			= 00200h
HHT_TORIGHT			= 00400h
HHT_TOLEFT			= 00800h

struc	HDHITTESTINFO
	pt			POINT ?
	flags			dd ?
	iItem			dd ?
ends

typedef HD_HITTESTINFO		HDHITTESTINFO

HDM_HITTEST			= (HDM_FIRST + 6)
HDM_GETITEMRECT 		= (HDM_FIRST + 7)
HDM_SETIMAGELIST		= (HDM_FIRST + 8)
HDM_GETIMAGELIST		= (HDM_FIRST + 9)
HDM_ORDERTOINDEX		= (HDM_FIRST + 15)
HDM_CREATEDRAGIMAGE		= (HDM_FIRST + 16)  ; wparam = which item (by index)
HDM_GETORDERARRAY		= (HDM_FIRST + 17)
HDM_SETORDERARRAY		= (HDM_FIRST + 18)
HDM_SETHOTDIVIDER		= (HDM_FIRST + 19)
HDM_SETBITMAPMARGIN		= (HDM_FIRST + 20)
HDM_GETBITMAPMARGIN		= (HDM_FIRST + 21)
HDM_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
HDM_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT
HDM_SETFILTERCHANGETIMEOUT	= (HDM_FIRST+22)
HDM_EDITFILTER			= (HDM_FIRST+23)
HDM_CLEARFILTER 		= (HDM_FIRST+24)

HDN_ITEMCHANGING		= (HDN_FIRST-0)
HDN_ITEMCHANGED 		= (HDN_FIRST-1)
HDN_ITEMCLICK			= (HDN_FIRST-2)
HDN_ITEMDBLCLICK		= (HDN_FIRST-3)
HDN_DIVIDERDBLCLICK		= (HDN_FIRST-5)
HDN_BEGINTRACK			= (HDN_FIRST-6)
HDN_ENDTRACK			= (HDN_FIRST-7)
HDN_TRACK			= (HDN_FIRST-8)
HDN_GETDISPINFO 		= (HDN_FIRST-9)
HDN_BEGINDRAG			= (HDN_FIRST-10)
HDN_ENDDRAG			= (HDN_FIRST-11)
HDN_FILTERCHANGE		= (HDN_FIRST-12)
HDN_FILTERBTNCLICK		= (HDN_FIRST-13)

struc	NMHEADER
	hdr			NMHDR ?
	iItem			dd ?
	iButton 		dd ?
	pitem			dd ?
ends

typedef HD_NOTIFY		NMHEADER

struc	NMHDDISPINFO
	hdr			NMHDR ?
	iItem			dd ?
	mask			dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iImage			dd ?
	lParam			dd ?
ends

struc	NMHDFILTERBTNCLICK
	hdr			NMHDR ?
	iItem			dd ?
	rc			RECT ?
ends

;====== TOOLBAR CONTROL ======================================================

TOOLBARCLASSNAME		equ <'ToolbarWindow32', 0>

struc	TBBUTTON
	iBitmap 		dd ?
	idCommand		dd ?
	fsState 		db ?
	fsStyle 		db ?
	bReserved		db 2 dup (?)	; padding for alignment
	dwData			dd ?
	iString 		dd ?
ends

struc	COLORMAP
	from			dd ?
	to			dd ?
ends

procdesc CreateToolbarEx :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateMappedBitmap :dword, :dword, :dword, :dword, :dword

CMB_MASKED			= 002h

TBSTATE_CHECKED 		= 001h
TBSTATE_PRESSED 		= 002h
TBSTATE_ENABLED 		= 004h
TBSTATE_HIDDEN			= 008h
TBSTATE_INDETERMINATE		= 010h
TBSTATE_WRAP			= 020h
TBSTATE_ELLIPSES		= 040h
TBSTATE_MARKED			= 080h

TBSTYLE_BUTTON			= 00000h  ; obsolete; use BTNS_BUTTON instead
TBSTYLE_SEP			= 00001h  ; obsolete; use BTNS_SEP instead
TBSTYLE_CHECK			= 00002h  ; obsolete; use BTNS_CHECK instead
TBSTYLE_GROUP			= 00004h  ; obsolete; use BTNS_GROUP instead
TBSTYLE_CHECKGROUP		= (TBSTYLE_GROUP + TBSTYLE_CHECK)     ; obsolete; use BTNS_CHECKGROUP instead
TBSTYLE_DROPDOWN		= 00008h  ; obsolete; use BTNS_DROPDOWN instead
TBSTYLE_AUTOSIZE		= 00010h  ; obsolete; use BTNS_AUTOSIZE instead
TBSTYLE_NOPREFIX		= 00020h  ; obsolete; use BTNS_NOPREFIX instead

TBSTYLE_TOOLTIPS		= 00100h
TBSTYLE_WRAPABLE		= 00200h
TBSTYLE_ALTDRAG 		= 00400h
TBSTYLE_FLAT			= 00800h
TBSTYLE_LIST			= 01000h
TBSTYLE_CUSTOMERASE		= 02000h
TBSTYLE_REGISTERDROP		= 04000h
TBSTYLE_TRANSPARENT		= 08000h
TBSTYLE_EX_DRAWDDARROWS 	= 000000001h

BTNS_BUTTON			= TBSTYLE_BUTTON      ; 0x0000
BTNS_SEP			= TBSTYLE_SEP	      ; 0x0001
BTNS_CHECK			= TBSTYLE_CHECK       ; 0x0002
BTNS_GROUP			= TBSTYLE_GROUP       ; 0x0004
BTNS_CHECKGROUP 		= TBSTYLE_CHECKGROUP  ; (TBSTYLE_GROUP | TBSTYLE_CHECK)
BTNS_DROPDOWN			= TBSTYLE_DROPDOWN    ; 0x0008
BTNS_AUTOSIZE			= TBSTYLE_AUTOSIZE    ; 0x0010; automatically calculate the cx of the button
BTNS_NOPREFIX			= TBSTYLE_NOPREFIX    ; 0x0020; this button should not have accel prefix

; Custom Draw Structure

struc	NMTBCUSTOMDRAW
	nmcd			NMCUSTOMDRAW ?
	hbrMonoDither		dd ?
	hbrLines		dd ?	; For drawing lines on buttons
	hpenLines		dd ?	; For drawing lines on buttons
	clrText 		dd ?	; Color of text
	clrMark 		dd ?	; Color of text bk when marked. (only if TBSTATE_MARKED)
	clrTextHighlight	dd ?	; Color of text when highlighted
	clrBtnFace		dd ?	; Background of the button
	clrBtnHighlight 	dd ?	; 3D highlight
	clrHighlightHotTrack	dd ?	; In conjunction with fHighlightHotTrack ; will cause button to highlight like a menu
	rcText			RECT ?	; Rect for text
	nStringBkMode		dd ?
	nHLStringBkMode 	dd ?
ends

; Toolbar custom draw return flags
TBCDRF_NOEDGES			= 000010000h  ; Don't draw button edges
TBCDRF_HILITEHOTTRACK		= 000020000h  ; Use color of the button bk when hottracked
TBCDRF_NOOFFSET 		= 000040000h  ; Don't offset button if pressed
TBCDRF_NOMARK			= 000080000h  ; Don't draw default highlight of image/text for TBSTATE_MARKED
TBCDRF_NOETCHEDEFFECT		= 000100000h  ; Don't draw etched effect for disabled items

TBCDRF_BLENDICON		= 000200000h  ; Use ILD_BLEND50 on the icon image

TB_ENABLEBUTTON 		= (WM_USER + 1)
TB_CHECKBUTTON			= (WM_USER + 2)
TB_PRESSBUTTON			= (WM_USER + 3)
TB_HIDEBUTTON			= (WM_USER + 4)
TB_INDETERMINATE		= (WM_USER + 5)
TB_MARKBUTTON			= (WM_USER + 6)
TB_ISBUTTONENABLED		= (WM_USER + 9)
TB_ISBUTTONCHECKED		= (WM_USER + 10)
TB_ISBUTTONPRESSED		= (WM_USER + 11)
TB_ISBUTTONHIDDEN		= (WM_USER + 12)
TB_ISBUTTONINDETERMINATE	= (WM_USER + 13)
TB_ISBUTTONHIGHLIGHTED		= (WM_USER + 14)
TB_SETSTATE			= (WM_USER + 17)
TB_GETSTATE			= (WM_USER + 18)
TB_ADDBITMAP			= (WM_USER + 19)

struc	TBADDBITMAP
	hInst			dd ?
	nID			dd ?
ends

HINST_COMMCTRL			= (-1)
IDB_STD_SMALL_COLOR		= 0
IDB_STD_LARGE_COLOR		= 1
IDB_VIEW_SMALL_COLOR		= 4
IDB_VIEW_LARGE_COLOR		= 5
IDB_HIST_SMALL_COLOR		= 8
IDB_HIST_LARGE_COLOR		= 9

; icon indexes for standard bitmap

STD_CUT 			= 0
STD_COPY			= 1
STD_PASTE			= 2
STD_UNDO			= 3
STD_REDOW			= 4
STD_DELETE			= 5
STD_FILENEW			= 6
STD_FILEOPEN			= 7
STD_FILESAVE			= 8
STD_PRINTPRE			= 9
STD_PROPERTIES			= 10
STD_HELP			= 11
STD_FIND			= 12
STD_REPLACE			= 13
STD_PRINT			= 14

; icon indexes for standard view bitmap

VIEW_LARGEICONS 		= 0
VIEW_SMALLICONS 		= 1
VIEW_LIST			= 2
VIEW_DETAILS			= 3
VIEW_SORTNAME			= 4
VIEW_SORTSIZE			= 5
VIEW_SORTDATE			= 6
VIEW_SORTTYPE			= 7
VIEW_PARENTFOLDER		= 8
VIEW_NETCONNECT 		= 9
VIEW_NETDISCONNECT		= 10
VIEW_NEWFOLDER			= 11
VIEW_VIEWMENU			= 12

HIST_BACK			= 0
HIST_FORWARD			= 1
HIST_FAVORITES			= 2
HIST_ADDTOFAVORITES		= 3
HIST_VIEWTREE			= 4

TB_ADDBUTTONS			= (WM_USER + 20)
TB_INSERTBUTTON 		= (WM_USER + 21)

TB_DELETEBUTTON 		= (WM_USER + 22)
TB_GETBUTTON			= (WM_USER + 23)
TB_BUTTONCOUNT			= (WM_USER + 24)
TB_COMMANDTOINDEX		= (WM_USER + 25)

struc	TBSAVEPARAMS
	hkr			dd ?
	pszSubKey		dd ?
	pszValueName		dd ?
ends

TB_SAVERESTORE			= (WM_USER + 26)
TB_CUSTOMIZE			= (WM_USER + 27)
TB_ADDSTRING			= (WM_USER + 28)
TB_GETITEMRECT			= (WM_USER + 29)
TB_BUTTONSTRUCTSIZE		= (WM_USER + 30)
TB_SETBUTTONSIZE		= (WM_USER + 31)
TB_SETBITMAPSIZE		= (WM_USER + 32)
TB_AUTOSIZE			= (WM_USER + 33)
TB_GETTOOLTIPS			= (WM_USER + 35)
TB_SETTOOLTIPS			= (WM_USER + 36)
TB_SETPARENT			= (WM_USER + 37)
TB_SETROWS			= (WM_USER + 39)
TB_GETROWS			= (WM_USER + 40)
TB_SETCMDID			= (WM_USER + 42)
TB_CHANGEBITMAP 		= (WM_USER + 43)
TB_GETBITMAP			= (WM_USER + 44)
TB_GETBUTTONTEXT		= (WM_USER + 45)
TB_REPLACEBITMAP		= (WM_USER + 46)
TB_SETINDENT			= (WM_USER + 47)
TB_SETIMAGELIST 		= (WM_USER + 48)
TB_GETIMAGELIST 		= (WM_USER + 49)
TB_LOADIMAGES			= (WM_USER + 50)
TB_GETRECT			= (WM_USER + 51) ; wParam is the Cmd instead of index
TB_SETHOTIMAGELIST		= (WM_USER + 52)
TB_GETHOTIMAGELIST		= (WM_USER + 53)
TB_SETDISABLEDIMAGELIST 	= (WM_USER + 54)
TB_GETDISABLEDIMAGELIST 	= (WM_USER + 55)
TB_SETSTYLE			= (WM_USER + 56)
TB_GETSTYLE			= (WM_USER + 57)
TB_GETBUTTONSIZE		= (WM_USER + 58)
TB_SETBUTTONWIDTH		= (WM_USER + 59)
TB_SETMAXTEXTROWS		= (WM_USER + 60)
TB_GETTEXTROWS			= (WM_USER + 61)
TB_GETOBJECT			= (WM_USER + 62)  ; wParam == IID, lParam void **ppv
TB_GETHOTITEM			= (WM_USER + 71)
TB_SETHOTITEM			= (WM_USER + 72)  ; wParam == iHotItem
TB_SETANCHORHIGHLIGHT		= (WM_USER + 73)  ; wParam == TRUE/FALSE
TB_GETANCHORHIGHLIGHT		= (WM_USER + 74)
TB_MAPACCELERATOR		= (WM_USER + 78)  ; wParam == ch, lParam int * pidBtn

struc	TBINSERTMARK
	iButton 		dd ?
	dwFlags 		dd ?
ends

TBIMHT_AFTER			= 000000001h ; TRUE = insert After iButton, otherwise before
TBIMHT_BACKGROUND		= 000000002h ; TRUE iff missed buttons completely

TB_GETINSERTMARK		= (WM_USER + 79)  ; lParam == LPTBINSERTMARK
TB_SETINSERTMARK		= (WM_USER + 80)  ; lParam == LPTBINSERTMARK
TB_INSERTMARKHITTEST		= (WM_USER + 81)  ; wParam == LPPOINT lParam == LPTBINSERTMARK
TB_MOVEBUTTON			= (WM_USER + 82)
TB_GETMAXSIZE			= (WM_USER + 83)  ; lParam == LPSIZE
TB_SETEXTENDEDSTYLE		= (WM_USER + 84)  ; For TBSTYLE_EX_*
TB_GETEXTENDEDSTYLE		= (WM_USER + 85)  ; For TBSTYLE_EX_*
TB_GETPADDING			= (WM_USER + 86)
TB_SETPADDING			= (WM_USER + 87)
TB_SETINSERTMARKCOLOR		= (WM_USER + 88)
TB_GETINSERTMARKCOLOR		= (WM_USER + 89)

TB_SETCOLORSCHEME		= CCM_SETCOLORSCHEME  ; lParam is color scheme
TB_GETCOLORSCHEME		= CCM_GETCOLORSCHEME	  ; fills in COLORSCHEME pointed to by lParam

TB_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
TB_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT

struc	TBREPLACEBITMAP
	hInstOld		dd ?
	nIDOld			dd ?
	hInstNew		dd ?
	nIDNew			dd ?
	nButtons		dd ?
ends

TBBF_LARGE			= 00001h

TB_GETBITMAPFLAGS		= (WM_USER + 41)

TBIF_IMAGE			= 000000001h
TBIF_TEXT			= 000000002h
TBIF_STATE			= 000000004h
TBIF_STYLE			= 000000008h
TBIF_LPARAM			= 000000010h
TBIF_COMMAND			= 000000020h
TBIF_SIZE			= 000000040h
TBIF_BYINDEX			= 080000000h ; this specifies that the wparam in Get/SetButtonInfo is an index, not id

struc	TBBUTTONINFO
	cbSize			dd ?
	dwMask			dd ?
	idCommand		dd ?
	iImage			dd ?
	fsState 		db ?
	fsStyle 		db ?
	cx			dw ?
	lParam			dd ?
	pszText 		dd ?
	cchText 		dd ?
ends

; BUTTONINFO APIs do NOT support the string pool.
TB_GETBUTTONINFO		= (WM_USER + 65)
TB_SETBUTTONINFO		= (WM_USER + 66)
TB_HITTEST			= (WM_USER + 69)
TB_SETDRAWTEXTFLAGS		= (WM_USER + 70)  ; wParam == mask lParam == bit values
TB_GETSTRING			= (WM_USER + 92)

TBN_GETBUTTONINFO		= (TBN_FIRST-0)
TBN_BEGINDRAG			= (TBN_FIRST-1)
TBN_ENDDRAG			= (TBN_FIRST-2)
TBN_BEGINADJUST 		= (TBN_FIRST-3)
TBN_ENDADJUST			= (TBN_FIRST-4)
TBN_RESET			= (TBN_FIRST-5)
TBN_QUERYINSERT 		= (TBN_FIRST-6)
TBN_QUERYDELETE 		= (TBN_FIRST-7)
TBN_TOOLBARCHANGE		= (TBN_FIRST-8)
TBN_CUSTHELP			= (TBN_FIRST-9)
TBN_DROPDOWN			= (TBN_FIRST - 10)
TBN_GETOBJECT			= (TBN_FIRST - 12)

; Structure for TBN_HOTITEMCHANGE notification
;

struc	NMTBHOTITEM
	hdr			NMHDR ?
	idOld			dd ?
	idNew			dd ?
	dwFlags 		dd ?		; HICF_*
ends

; Hot item change flags
HICF_OTHER			= 000000000h
HICF_MOUSE			= 000000001h	      ; Triggered by mouse
HICF_ARROWKEYS			= 000000002h	      ; Triggered by arrow keys
HICF_ACCELERATOR		= 000000004h	      ; Triggered by accelerator
HICF_DUPACCEL			= 000000008h	      ; This accelerator is not unique
HICF_ENTERING			= 000000010h	      ; idOld is invalid
HICF_LEAVING			= 000000020h	      ; idNew is invalid
HICF_RESELECT			= 000000040h	      ; hot item reselected
HICF_LMOUSE			= 000000080h	      ; left mouse button selected
HICF_TOGGLEDROPDOWN		= 000000100h	      ; Toggle button's dropdown state

TBN_HOTITEMCHANGE		= (TBN_FIRST - 13)
TBN_DRAGOUT			= (TBN_FIRST - 14) ; this is sent when the user clicks down on a button then drags off the button
TBN_DELETINGBUTTON		= (TBN_FIRST - 15) ; uses TBNOTIFY
TBN_GETDISPINFO 		= (TBN_FIRST - 16) ; This is sent when the  toolbar needs  some display information
TBN_GETINFOTIP			= (TBN_FIRST - 18)
TBN_RESTORE			= (TBN_FIRST - 21)
TBN_SAVE			= (TBN_FIRST - 22)
TBN_INITCUSTOMIZE		= (TBN_FIRST - 23)
TBNRF_HIDEHELP			= 000000001h
TBNRF_ENDCUSTOMIZE		= 000000002h

struc	NMTBSAVE
	hdr			NMHDR ?
	pData			dd ?
	pCurrent		dd ?
	cbData			dd ?
	iItem			dd ?
	cButtons		dd ?
	tbButton		TBBUTTON ?
ends

struc	NMTBRESTORE
	hdr			NMHDR ?
	pData			dd ?
	pCurrent		dd ?
	cbData			dd ?
	iItem			dd ?
	cButtons		dd ?
	cbBytesPerRecord	dd ?
	tbButton		TBBUTTON ?
ends

struc	NMTBGETINFOTIP
	hdr			NMHDR ?
	pszText 		dd ?
	cchTextMax		dd ?
	iItem			dd ?
	lParam			dd ?
ends

TBNF_IMAGE			= 000000001h
TBNF_TEXT			= 000000002h
TBNF_DI_SETITEM 		= 010000000h

struc	NMTBDISPINFO
	hdr			NMHDR ?
	dwMask			dd ?		; [in] Specifies the values requested .[out] Client ask the data to be set for future use
	idCommand		dd ?		; [in] id of button we're requesting info for
	lParam			dd ?		; [in] lParam of button
	iImage			dd ?		; [out] image index
	pszText 		dd ?		; [out] new text for item
	cchText 		dd ?		; [in] size of buffer pointed to by pszText
ends

; Return codes for TBN_DROPDOWN
TBDDRET_DEFAULT 		= 0
TBDDRET_NODEFAULT		= 1
TBDDRET_TREATPRESSED		= 2	  ; Treat as a standard press button

struc	NMTOOLBAR
	hdr			NMHDR ?
	iItem			dd ?
	tbButton		TBBUTTON ?
	cchText 		dd ?
	pszText 		dd ?
if _WIN32_IE ge 0500h
	rcButton		RECT ?
endif
ends

typedef TBNOTIFY		NMTOOLBAR

;====== REBAR CONTROL ========================================================

REBARCLASSNAME			equ <'ReBarWindow32', 0>

RBIM_IMAGELIST			= 000000001h

RBS_TOOLTIPS			= 00100h
RBS_VARHEIGHT			= 00200h
RBS_BANDBORDERS 		= 00400h
RBS_FIXEDORDER			= 00800h
RBS_REGISTERDROP		= 01000h
RBS_AUTOSIZE			= 02000h
RBS_VERTICALGRIPPER		= 04000h  ; this always has the vertical gripper (default for horizontal mode)
RBS_DBLCLKTOGGLE		= 08000h
RBS_EX_OFFICE9			= 000000001h  ; new gripper, chevron, focus handling

struc	REBARINFO
	cbSize			dd ?
	fMask			dd ?
	himl			dd ?
ends

RBBS_BREAK			= 000000001h  ; break to new line
RBBS_FIXEDSIZE			= 000000002h  ; band can't be sized
RBBS_CHILDEDGE			= 000000004h  ; edge around top & bottom of child window
RBBS_HIDDEN			= 000000008h  ; don't show
RBBS_NOVERT			= 000000010h  ; don't show when vertical
RBBS_FIXEDBMP			= 000000020h  ; bitmap doesn't move during band resize
RBBS_VARIABLEHEIGHT		= 000000040h  ; allow autosizing of this child vertically
RBBS_GRIPPERALWAYS		= 000000080h  ; always show the gripper
RBBS_NOGRIPPER			= 000000100h  ; never show the gripper
RBBS_NOCHEVRON			= 000000200h

RBBIM_STYLE			= 000000001h
RBBIM_COLORS			= 000000002h
RBBIM_TEXT			= 000000004h
RBBIM_IMAGE			= 000000008h
RBBIM_CHILD			= 000000010h
RBBIM_CHILDSIZE 		= 000000020h
RBBIM_SIZE			= 000000040h
RBBIM_BACKGROUND		= 000000080h
RBBIM_ID			= 000000100h
RBBIM_IDEALSIZE 		= 000000200h
RBBIM_LPARAM			= 000000400h
RBBIM_HEADERSIZE		= 000000800h  ; control the size of the header

struc	REBARBANDINFO
	cbSize			dd ?
	fMask			dd ?
	fStyle			dd ?
	clrFore 		dd ?
	clrBack 		dd ?
	lpText			dd ?
	cch			dd ?
	iImage			dd ?
	hwndChild		dd ?
	cxMinChild		dd ?
	cyMinChild		dd ?
	cx			dd ?
	hbmBack 		dd ?
	wID			dd ?
if _WIN32_IE ge 0400h
	cyChild 		dd ?
	cyMaxChild		dd ?
	cyIntegral		dd ?
	cxIdeal 		dd ?
	lParam			dd ?
	cxHeader		dd ?
endif
ends

RB_INSERTBAND			= (WM_USER +  1)
RB_DELETEBAND			= (WM_USER +  2)
RB_GETBARINFO			= (WM_USER +  3)
RB_SETBARINFO			= (WM_USER +  4)
RB_GETBANDINFO			= (WM_USER +  5)
RB_SETBANDINFO			= (WM_USER +  6)
RB_SETPARENT			= (WM_USER +  7)
RB_HITTEST			= (WM_USER +  8)
RB_GETRECT			= (WM_USER +  9)
RB_GETBANDCOUNT 		= (WM_USER +  12)
RB_GETROWCOUNT			= (WM_USER +  13)
RB_GETROWHEIGHT 		= (WM_USER +  14)
RB_IDTOINDEX			= (WM_USER +  16) ; wParam == id
RB_GETTOOLTIPS			= (WM_USER +  17)
RB_SETTOOLTIPS			= (WM_USER +  18)
RB_SETBKCOLOR			= (WM_USER +  19) ; sets the default BK color
RB_GETBKCOLOR			= (WM_USER +  20) ; defaults to CLR_NONE
RB_SETTEXTCOLOR 		= (WM_USER +  21)
RB_GETTEXTCOLOR 		= (WM_USER +  22) ; defaults to 0x00000000
RB_SIZETORECT			= (WM_USER +  23) ; resize the rebar/break bands and such to this rect (lparam)

RB_SETCOLORSCHEME		= CCM_SETCOLORSCHEME  ; lParam is color scheme
RB_GETCOLORSCHEME		= CCM_GETCOLORSCHEME  ; fills in COLORSCHEME pointed to by lParam

; for manual drag control
; lparam == cursor pos
	; -1 means do it yourself.
	; -2 means use what you had saved before
RB_BEGINDRAG			= (WM_USER + 24)
RB_ENDDRAG			= (WM_USER + 25)
RB_DRAGMOVE			= (WM_USER + 26)
RB_GETBARHEIGHT 		= (WM_USER + 27)
RB_GETBANDINFO			= (WM_USER + 29)

RB_MINIMIZEBAND 		= (WM_USER + 30)
RB_MAXIMIZEBAND 		= (WM_USER + 31)

RB_GETDROPTARGET		= (CCM_GETDROPTARGET)

RB_GETBANDBORDERS		= (WM_USER + 34)  ; returns in lparam = lprc the amount of edges added to band wparam

RB_SHOWBAND			= (WM_USER + 35)      ; show/hide band
RB_SETPALETTE			= (WM_USER + 37)
RB_GETPALETTE			= (WM_USER + 38)
RB_MOVEBAND			= (WM_USER + 39)

RB_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
RB_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT

RB_SETBANDFOCUS 		= (WM_USER + 40)  ; (UINT) wParam == band index      lParam == TRUE/FALSE
						  ; returns TRUE if gave band focus, else FALSE
RB_GETBANDFOCUS 		= (WM_USER + 41)  ; returns index of band with focus (-1 if none)
RB_CYCLEFOCUS			= (WM_USER + 42)  ; (UINT) wParam == band index      (BOOL) lParam == back/forward
						  ; returns index of band that got focus (-1 if none)
RB_SETEXTENDEDSTYLE		= (WM_USER + 43)

RBN_HEIGHTCHANGE		= (RBN_FIRST - 0)

RBN_GETOBJECT			= (RBN_FIRST - 1)
RBN_LAYOUTCHANGED		= (RBN_FIRST - 2)
RBN_AUTOSIZE			= (RBN_FIRST - 3)
RBN_BEGINDRAG			= (RBN_FIRST - 4)
RBN_ENDDRAG			= (RBN_FIRST - 5)
RBN_DELETINGBAND		= (RBN_FIRST - 6)     ; Uses NMREBAR
RBN_DELETEDBAND 		= (RBN_FIRST - 7)     ; Uses NMREBAR
RBN_CHILDSIZE			= (RBN_FIRST - 8)

RBN_SETFOCUS			= (RBN_FIRST - 9)     ; Uses NMREBAR
RBN_CHEVRONPUSHED		= (RBN_FIRST - 10)

RBN_MINMAX			= (RBN_FIRST - 21)

struc	NMREBARCHILDSIZE
	hdr			NMHDR ?
	uBand			dd ?
	wID			dd ?
	rcChild 		RECT ?
	rcBand			RECT ?
ends

struc	NMREBAR
	hdr			NMHDR ?
	dwMask			dd ?		; RBNM_*
	uBand			dd ?
	fStyle			dd ?
	wID			dd ?
	lParam			dd ?
ends

; Mask flags for NMREBAR
RBNM_ID 			= 000000001h
RBNM_STYLE			= 000000002h
RBNM_LPARAM			= 000000004h

struc	NMRBAUTOSIZE
	hdr			NMHDR ?
	fChanged		dd ?
	rcTarget		RECT ?
	rcActual		RECT ?
ends

struc	NMREBARCHEVRON
	hdr			NMHDR ?
	uBand			dd ?
	wID			dd ?
	lParam			dd ?
	rc			RECT ?
ends

RBHT_NOWHERE			= 00001h
RBHT_CAPTION			= 00002h
RBHT_CLIENT			= 00003h
RBHT_GRABBER			= 00004h
RBHT_CHEVRON			= 00008h

struc	RBHITTESTINFO
	pt			POINT ?
	flags			dd ?
	iBand			dd ?
ends

;====== TOOLTIPS CONTROL =====================================================

TOOLTIPS_CLASS			equ <'tooltips_class32', 0>

struc	TTTOOLINFO
	cbSize			dd ?
	uFlags			dd ?
	hwnd			dd ?
	uId			dd ?
	rect			RECT ?
	hinst			dd ?
	lpszText		dd ?
if _WIN32_IE ge 0300h
	lParam			dd ?
endif
ends

typedef TOOLINFO		TTTOOLINFO

TTS_ALWAYSTIP			= 001h
TTS_NOPREFIX			= 002h

TTF_IDISHWND			= 00001h

; Use this to center around trackpoint in trackmode
; -OR- to center around tool in normal mode.
; Use TTF_ABSOLUTE to place the tip exactly at the track coords when
; in tracking mode.  TTF_ABSOLUTE can be used in conjunction with TTF_CENTERTIP
; to center the tip absolutely about the track point.

TTF_CENTERTIP			= 00002h
TTF_RTLREADING			= 00004h
TTF_SUBCLASS			= 00010h
TTF_TRACK			= 00020h
TTF_ABSOLUTE			= 00080h
TTF_TRANSPARENT 		= 00100h
TTF_DI_SETITEM			= 08000h       ; valid only on the TTN_NEEDTEXT callback

TTDT_AUTOMATIC			= 0
TTDT_RESHOW			= 1
TTDT_AUTOPOP			= 2
TTDT_INITIAL			= 3

TTM_ACTIVATE			= (WM_USER + 1)
TTM_SETDELAYTIME		= (WM_USER + 3)
TTM_ADDTOOL			= (WM_USER + 4)
TTM_DELTOOL			= (WM_USER + 5)
TTM_NEWTOOLRECT 		= (WM_USER + 6)
TTM_RELAYEVENT			= (WM_USER + 7)

TTM_GETTOOLINFO 		= (WM_USER + 8)
TTM_SETTOOLINFO 		= (WM_USER + 9)

TTM_HITTEST			= (WM_USER +10)
TTM_GETTEXT			= (WM_USER +11)
TTM_UPDATETIPTEXT		= (WM_USER +12)
TTM_GETTOOLCOUNT		= (WM_USER +13)
TTM_ENUMTOOLS			= (WM_USER +14)
TTM_GETCURRENTTOOL		= (WM_USER + 15)
TTM_WINDOWFROMPOINT		= (WM_USER + 16)
TTM_TRACKACTIVATE		= (WM_USER + 17)  ; wParam = TRUE/FALSE start end  lparam = LPTOOLINFO
TTM_TRACKPOSITION		= (WM_USER + 18)  ; lParam = dwPos
TTM_SETTIPBKCOLOR		= (WM_USER + 19)
TTM_SETTIPTEXTCOLOR		= (WM_USER + 20)
TTM_GETDELAYTIME		= (WM_USER + 21)
TTM_GETTIPBKCOLOR		= (WM_USER + 22)
TTM_GETTIPTEXTCOLOR		= (WM_USER + 23)
TTM_SETMAXTIPWIDTH		= (WM_USER + 24)
TTM_GETMAXTIPWIDTH		= (WM_USER + 25)
TTM_SETMARGIN			= (WM_USER + 26)  ; lParam = lprc
TTM_GETMARGIN			= (WM_USER + 27)  ; lParam = lprc
TTM_POP 			= (WM_USER + 28)
TTM_UPDATE			= (WM_USER + 29)

struc	TTHITTESTINFO
	hwnd			dd ?
	pt			POINT ?
	ti			TTTOOLINFO ?
ends

typedef HITTESTINFO		TTHITTESTINFO

TTN_GETDISPINFO 		= (TTN_FIRST - 0)
TTN_SHOW			= (TTN_FIRST - 1)
TTN_POP 			= (TTN_FIRST - 2)
TTN_NEEDTEXT			= TTN_GETDISPINFO

struc	NMTTDISPINFO
	hdr			NMHDR ?
	lpszText		dd ?
	szText			db 80 dup (?)
	hinst			dd ?
	uFlags			dd ?
if _WIN32_IE ge 0300h
	lParam			dd ?
endif
ends

typedef TOOLTIPTEXT		 NMTTDISPINFO

;====== STATUS BAR CONTROL ===================================================

SBARS_SIZEGRIP			= 00100h
SBARS_TOOLTIPS			= 00800h

; this is a status bar flag, preference to SBARS_TOOLTIPS
SBT_TOOLTIPS			= 00800h

procdesc CreateStatusWindowA :dword, :dword, :dword, :dword
procdesc DrawStatusTextA :dword, :dword, :dword, :dword

CreateStatusWindow		equ <CreateStatusWindowA>
DrawStatusText			equ <DrawStatusTextA>

STATUSCLASSNAME 		equ <'msctls_statusbar32', 0>

SB_SETTEXT			= (WM_USER+1)
SB_GETTEXT			= (WM_USER+2)
SB_GETTEXTLENGTH		= (WM_USER+3)

SB_SETPARTS			= (WM_USER+4)
SB_GETPARTS			= (WM_USER+6)
SB_GETBORDERS			= (WM_USER+7)
SB_SETMINHEIGHT 		= (WM_USER+8)
SB_SIMPLE			= (WM_USER+9)
SB_GETRECT			= (WM_USER+10)
SB_ISSIMPLE			= (WM_USER+14)
SB_SETICON			= (WM_USER+15)
SB_SETTIPTEXT			= (WM_USER+16)
SB_GETTIPTEXT			= (WM_USER+18)
SB_GETICON			= (WM_USER+20)
SB_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
SB_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT

SBT_OWNERDRAW			= 01000h
SBT_NOBORDERS			= 00100h
SBT_POPOUT			= 00200h
SBT_RTLREADING			= 00400h
SBT_NOTABPARSING		= 00800h

SB_SETBKCOLOR			= CCM_SETBKCOLOR      ; lParam = bkColor

; status bar notifications
SBN_SIMPLEMODECHANGE		= (SBN_FIRST - 0)

; refers to the data saved for simple mode
SB_SIMPLEID			= 000fh

;====== MENU HELP ============================================================

procdesc MenuHelp :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc ShowHideMenuCtl :dword, :dword, :dword
procdesc GetEffectiveClientRect :dword, :dword, :dword

MINSYSCOMMAND			= SC_SIZE

;====== TRACKBAR CONTROL =====================================================

TRACKBAR_CLASS			equ <'msctls_trackbar32', 0>

TBS_AUTOTICKS			= 00001h
TBS_VERT			= 00002h
TBS_HORZ			= 00000h
TBS_TOP 			= 00004h
TBS_BOTTOM			= 00000h
TBS_LEFT			= 00004h
TBS_RIGHT			= 00000h
TBS_BOTH			= 00008h
TBS_NOTICKS			= 00010h
TBS_ENABLESELRANGE		= 00020h
TBS_FIXEDLENGTH 		= 00040h
TBS_NOTHUMB			= 00080h
TBS_TOOLTIPS			= 00100h

TBM_GETPOS			= (WM_USER)
TBM_GETRANGEMIN 		= (WM_USER+1)
TBM_GETRANGEMAX 		= (WM_USER+2)
TBM_GETTIC			= (WM_USER+3)
TBM_SETTIC			= (WM_USER+4)
TBM_SETPOS			= (WM_USER+5)
TBM_SETRANGE			= (WM_USER+6)
TBM_SETRANGEMIN 		= (WM_USER+7)
TBM_SETRANGEMAX 		= (WM_USER+8)
TBM_CLEARTICS			= (WM_USER+9)
TBM_SETSEL			= (WM_USER+10)
TBM_SETSELSTART 		= (WM_USER+11)
TBM_SETSELEND			= (WM_USER+12)
TBM_GETPTICS			= (WM_USER+14)
TBM_GETTICPOS			= (WM_USER+15)
TBM_GETNUMTICS			= (WM_USER+16)
TBM_GETSELSTART 		= (WM_USER+17)
TBM_GETSELEND			= (WM_USER+18)
TBM_CLEARSEL			= (WM_USER+19)
TBM_SETTICFREQ			= (WM_USER+20)
TBM_SETPAGESIZE 		= (WM_USER+21)
TBM_GETPAGESIZE 		= (WM_USER+22)
TBM_SETLINESIZE 		= (WM_USER+23)
TBM_GETLINESIZE 		= (WM_USER+24)
TBM_GETTHUMBRECT		= (WM_USER+25)
TBM_GETCHANNELRECT		= (WM_USER+26)
TBM_SETTHUMBLENGTH		= (WM_USER+27)
TBM_GETTHUMBLENGTH		= (WM_USER+28)
TBM_SETTOOLTIPS 		= (WM_USER+29)
TBM_GETTOOLTIPS 		= (WM_USER+30)
TBM_SETTIPSIDE			= (WM_USER+31)
; TrackBar Tip Side flags
TBTS_TOP			= 0
TBTS_LEFT			= 1
TBTS_BOTTOM			= 2
TBTS_RIGHT			= 3

TBM_SETBUDDY			= (WM_USER+32) ; wparam = BOOL fLeft; (or right)
TBM_GETBUDDY			= (WM_USER+33) ; wparam = BOOL fLeft; (or right)
TBM_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
TBM_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT

TB_LINEUP			= 0
TB_LINEDOWN			= 1
TB_PAGEUP			= 2
TB_PAGEDOWN			= 3
TB_THUMBPOSITION		= 4
TB_THUMBTRACK			= 5
TB_TOP				= 6
TB_BOTTOM			= 7
TB_ENDTRACK			= 8

; custom draw item specs
TBCD_TICS			= 00001h
TBCD_THUMB			= 00002h
TBCD_CHANNEL			= 00003h

;====== DRAG LIST CONTROL ====================================================

struc	DRAGLISTINFO
	uNotification		dd ?
	hWnd			dd ?
	ptCursor		POINT ?
ends

DL_BEGINDRAG			= (WM_USER+133)
DL_DRAGGING			= (WM_USER+134)
DL_DROPPED			= (WM_USER+135)
DL_CANCELDRAG			= (WM_USER+136)

DL_CURSORSET			= 0
DL_STOPCURSOR			= 1
DL_COPYCURSOR			= 2
DL_MOVECURSOR			= 3

procdesc MakeDragList :dword
procdesc DrawInsert :dword, :dword, :dword
procdesc LBItemFromPt :dword, :dword, :dword

DRAGLISTMSGSTRING		equ <'commctrl_DragListMsg', 0>

;====== UPDOWN CONTROL =======================================================

UPDOWN_CLASS			equ <'msctls_updown32', 0>

struc	UDACCEL
	nSec			dd ?
	nInc			dd ?
ends

UD_MAXVAL			= 07ffh
UD_MINVAL			= (-UD_MAXVAL)

UDS_WRAP			= 00001h
UDS_SETBUDDYINT 		= 00002h
UDS_ALIGNRIGHT			= 00004h
UDS_ALIGNLEFT			= 00008h
UDS_AUTOBUDDY			= 00010h
UDS_ARROWKEYS			= 00020h
UDS_HORZ			= 00040h
UDS_NOTHOUSANDS 		= 00080h
UDS_HOTTRACK			= 00100h

UDM_SETRANGE			= (WM_USER+101)
UDM_GETRANGE			= (WM_USER+102)
UDM_SETPOS			= (WM_USER+103)
UDM_GETPOS			= (WM_USER+104)
UDM_SETBUDDY			= (WM_USER+105)
UDM_GETBUDDY			= (WM_USER+106)
UDM_SETACCEL			= (WM_USER+107)
UDM_GETACCEL			= (WM_USER+108)
UDM_SETBASE			= (WM_USER+109)
UDM_GETBASE			= (WM_USER+110)
UDM_SETRANGE32			= (WM_USER+111)
UDM_GETRANGE32			= (WM_USER+112) ; wParam & lParam are LPINT
UDM_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
UDM_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT

procdesc CreateUpDownControl :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

struc	NMUPDOWN
	hdr			NMHDR ?
	iPos			dd ?
	iDelta			dd ?
ends

typedef NM_UPDOWN		NMUPDOWN

UDN_DELTAPOS			= (UDN_FIRST - 1)

;====== PROGRESS CONTROL =====================================================

PROGRESS_CLASS			equ <'msctls_progress32', 0>

PBS_SMOOTH			= 001h
PBS_VERTICAL			= 004h

PBM_SETRANGE			= (WM_USER+1)
PBM_SETPOS			= (WM_USER+2)
PBM_DELTAPOS			= (WM_USER+3)
PBM_SETSTEP			= (WM_USER+4)
PBM_STEPIT			= (WM_USER+5)
PBM_SETRANGE32			= (WM_USER+6)  ; lParam = high, wParam = low

struc	PBRANGE
	iLow			dd ?
	iHigh			dd ?
ends

PBM_GETRANGE			= (WM_USER+7)  ; wParam = return (TRUE ? low : high). lParam = PPBRANGE or NULL
PBM_GETPOS			= (WM_USER+8)
PBM_SETBARCOLOR 		= (WM_USER+9)		  ; lParam = bar color
PBM_SETBKCOLOR			= CCM_SETBKCOLOR  ; lParam = bkColor

;====== HOTKEY CONTROL =======================================================

HOTKEYF_SHIFT			= 001h
HOTKEYF_CONTROL 		= 002h
HOTKEYF_ALT			= 004h
HOTKEYF_EXT			= 008h

HKCOMB_NONE			= 00001h
HKCOMB_S			= 00002h
HKCOMB_C			= 00004h
HKCOMB_A			= 00008h
HKCOMB_SC			= 00010h
HKCOMB_SA			= 00020h
HKCOMB_CA			= 00040h
HKCOMB_SCA			= 00080h

HKM_SETHOTKEY			= (WM_USER+1)
HKM_GETHOTKEY			= (WM_USER+2)
HKM_SETRULES			= (WM_USER+3)

HOTKEY_CLASS			equ <'msctls_hotkey32', 0>

;====== COMMON CONTROL STYLES ================================================

CCS_TOP 			= 000000001h
CCS_NOMOVEY			= 000000002h
CCS_BOTTOM			= 000000003h
CCS_NORESIZE			= 000000004h
CCS_NOPARENTALIGN		= 000000008h
CCS_ADJUSTABLE			= 000000020h
CCS_NODIVIDER			= 000000040h
CCS_VERT			= 000000080h
CCS_LEFT			= (CCS_VERT + CCS_TOP)
CCS_RIGHT			= (CCS_VERT + CCS_BOTTOM)
CCS_NOMOVEX			= (CCS_VERT + CCS_NOMOVEY)

;====== LISTVIEW CONTROL =====================================================

WC_LISTVIEW			equ <'SysListView32', 0>

LVS_ICON			= 00000h
LVS_REPORT			= 00001h
LVS_SMALLICON			= 00002h
LVS_LIST			= 00003h
LVS_TYPEMASK			= 00003h
LVS_SINGLESEL			= 00004h
LVS_SHOWSELALWAYS		= 00008h
LVS_SORTASCENDING		= 00010h
LVS_SORTDESCENDING		= 00020h
LVS_SHAREIMAGELISTS		= 00040h
LVS_NOLABELWRAP 		= 00080h
LVS_AUTOARRANGE 		= 00100h
LVS_EDITLABELS			= 00200h
LVS_OWNERDATA			= 01000h
LVS_NOSCROLL			= 02000h

LVS_TYPESTYLEMASK		= 0fc00h

LVS_ALIGNTOP			= 00000h
LVS_ALIGNLEFT			= 00800h
LVS_ALIGNMASK			= 00c00h

LVS_OWNERDRAWFIXED		= 00400h
LVS_NOCOLUMNHEADER		= 04000h
LVS_NOSORTHEADER		= 08000h

LVM_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
LVM_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT
LVM_GETBKCOLOR			= (LVM_FIRST + 0)
LVM_SETBKCOLOR			= (LVM_FIRST + 1)
LVM_GETIMAGELIST		= (LVM_FIRST + 2)

LVSIL_NORMAL			= 0
LVSIL_SMALL			= 1
LVSIL_STATE			= 2

LVM_SETIMAGELIST		= (LVM_FIRST + 3)
LVM_GETITEMCOUNT		= (LVM_FIRST + 4)

LVIF_TEXT			= 00001h
LVIF_IMAGE			= 00002h
LVIF_PARAM			= 00004h
LVIF_STATE			= 00008h
LVIF_INDENT			= 00010h
LVIF_NORECOMPUTE		= 00800h

LVIS_FOCUSED			= 00001h
LVIS_SELECTED			= 00002h
LVIS_CUT			= 00004h
LVIS_DROPHILITED		= 00008h
LVIS_ACTIVATING 		= 00020h

LVIS_OVERLAYMASK		= 00F00h
LVIS_STATEIMAGEMASK		= 0F000h

I_INDENTCALLBACK		= (-1)

struc	LVITEM
	mask			dd ?
	iItem			dd ?
	iSubItem		dd ?
	state			dd ?
	stateMask		dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iImage			dd ?
	lParam			dd ?
if _WIN32_IE ge 0300h
	iIndent 		dd ?
endif
ends

typedef LV_ITEM 		LVITEM

LPSTR_TEXTCALLBACK		= (-1)

I_IMAGECALLBACK 		= (-1)

LVM_GETITEM			= (LVM_FIRST + 5)
LVM_SETITEM			= (LVM_FIRST + 6)
LVM_INSERTITEM			= (LVM_FIRST + 7)
LVM_DELETEITEM			= (LVM_FIRST + 8)
LVM_DELETEALLITEMS		= (LVM_FIRST + 9)
LVM_GETCALLBACKMASK		= (LVM_FIRST + 10)
LVM_SETCALLBACKMASK		= (LVM_FIRST + 11)

LVNI_ALL			= 00000h
LVNI_FOCUSED			= 00001h
LVNI_SELECTED			= 00002h
LVNI_CUT			= 00004h
LVNI_DROPHILITED		= 00008h

LVNI_ABOVE			= 00100h
LVNI_BELOW			= 00200h
LVNI_TOLEFT			= 00400h
LVNI_TORIGHT			= 00800h

LVM_GETNEXTITEM 		= (LVM_FIRST + 12)

LVFI_PARAM			= 00001h
LVFI_STRING			= 00002h
LVFI_PARTIAL			= 00008h
LVFI_WRAP			= 00020h
LVFI_NEARESTXY			= 00040h

struc	LVFINDINFO
	flags			dd ?
	psz			dd ?
	lParam			dd ?
	pt			POINT ?
	vkDirection		dd ?
ends

typedef LV_FINDINFO		 LVFINDINFO

LVM_FINDITEM			= (LVM_FIRST + 13)

LVIR_BOUNDS			= 0
LVIR_ICON			= 1
LVIR_LABEL			= 2
LVIR_SELECTBOUNDS		= 3

LVM_GETITEMRECT 		= (LVM_FIRST + 14)
LVM_SETITEMPOSITION		= (LVM_FIRST + 15)
LVM_GETITEMPOSITION		= (LVM_FIRST + 16)
LVM_GETSTRINGWIDTH		= (LVM_FIRST + 17)

LVHT_NOWHERE			= 00001h
LVHT_ONITEMICON 		= 00002h
LVHT_ONITEMLABEL		= 00004h
LVHT_ONITEMSTATEICON		= 00008h
LVHT_ONITEM			= (LVHT_ONITEMICON + LVHT_ONITEMLABEL + LVHT_ONITEMSTATEICON)

LVHT_ABOVE			= 00008h
LVHT_BELOW			= 00010h
LVHT_TORIGHT			= 00020h
LVHT_TOLEFT			= 00040h

struc	LVHITTESTINFO
	pt			POINT ?
	flags			dd ?
	iItem			dd ?
if _WIN32_IE ge 0300h
	iSubItem		dd ?		; this is was NOT in win95.  valid only for LVM_SUBITEMHITTEST
endif
ends

typedef LV_HITTESTINFO		LVHITTESTINFO

LVM_HITTEST			= (LVM_FIRST + 18)
LVM_ENSUREVISIBLE		= (LVM_FIRST + 19)
LVM_SCROLL			= (LVM_FIRST + 20)
LVM_REDRAWITEMS 		= (LVM_FIRST + 21)

LVA_DEFAULT			= 00000h
LVA_ALIGNLEFT			= 00001h
LVA_ALIGNTOP			= 00002h
LVA_SNAPTOGRID			= 00005h

LVM_ARRANGE			= (LVM_FIRST + 22)

LVM_EDITLABEL			= (LVM_FIRST + 23)
LVM_GETEDITCONTROL		= (LVM_FIRST + 24)

struc	LVCOLUMN
	mask			dd ?
	fmt			dd ?
	cx			dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iSubItem		dd ?
if _WIN32_IE ge 0300h
	iImage			dd ?
	iOrder			dd ?
endif
ends

typedef LV_COLUMN		LVCOLUMN

LVCF_FMT			= 00001h
LVCF_WIDTH			= 00002h
LVCF_TEXT			= 00004h
LVCF_SUBITEM			= 00008h
LVCF_IMAGE			= 00010h
LVCF_ORDER			= 00020h

LVCFMT_LEFT			= 00000h
LVCFMT_RIGHT			= 00001h
LVCFMT_CENTER			= 00002h
LVCFMT_JUSTIFYMASK		= 00003h
LVCFMT_IMAGE			= 00800h
LVCFMT_BITMAP_ON_RIGHT		= 01000h
LVCFMT_COL_HAS_IMAGES		= 08000h

LVM_GETCOLUMN			= (LVM_FIRST + 25)
LVM_SETCOLUMN			= (LVM_FIRST + 26)
LVM_INSERTCOLUMN		= (LVM_FIRST + 27)
LVM_DELETECOLUMN		= (LVM_FIRST + 28)
LVM_GETCOLUMNWIDTH		= (LVM_FIRST + 29)

LVSCW_AUTOSIZE			= -1
LVSCW_AUTOSIZE_USEHEADER	= -2

LVM_SETCOLUMNWIDTH		= (LVM_FIRST + 30)
LVM_GETHEADER			= (LVM_FIRST + 31)
LVM_CREATEDRAGIMAGE		= (LVM_FIRST + 33)
LVM_GETVIEWRECT 		= (LVM_FIRST + 34)
LVM_GETTEXTCOLOR		= (LVM_FIRST + 35)
LVM_SETTEXTCOLOR		= (LVM_FIRST + 36)
LVM_GETTEXTBKCOLOR		= (LVM_FIRST + 37)
LVM_SETTEXTBKCOLOR		= (LVM_FIRST + 38)
LVM_GETTOPINDEX 		= (LVM_FIRST + 39)
LVM_GETCOUNTPERPAGE		= (LVM_FIRST + 40)
LVM_GETORIGIN			= (LVM_FIRST + 41)
LVM_UPDATE			= (LVM_FIRST + 42)
LVM_SETITEMSTATE		= (LVM_FIRST + 43)
LVM_GETITEMSTATE		= (LVM_FIRST + 44)
LVM_GETITEMTEXT 		= (LVM_FIRST + 45)
LVM_SETITEMTEXT 		= (LVM_FIRST + 46)

; these flags only apply to LVS_OWNERDATA listviews in report or list mode
LVSICF_NOINVALIDATEALL		= 000000001h
LVSICF_NOSCROLL 		= 000000002h

LVM_SETITEMCOUNT		= (LVM_FIRST + 47)
LVM_SORTITEMS			= (LVM_FIRST + 48)

proctype FNLVCOMPARE :dword, :dword, :dword

LVM_SETITEMPOSITION32		= (LVM_FIRST + 49)
LVM_GETSELECTEDCOUNT		= (LVM_FIRST + 50)
LVM_GETITEMSPACING		= (LVM_FIRST + 51)
LVM_GETISEARCHSTRING		= (LVM_FIRST + 52)
LVM_SETICONSPACING		= (LVM_FIRST + 53)
LVM_SETEXTENDEDLISTVIEWSTYLE	= (LVM_FIRST + 54)   ; optional wParam == mask
LVM_GETEXTENDEDLISTVIEWSTYLE	= (LVM_FIRST + 55)

LVS_EX_GRIDLINES		= 000000001h
LVS_EX_SUBITEMIMAGES		= 000000002h
LVS_EX_CHECKBOXES		= 000000004h
LVS_EX_TRACKSELECT		= 000000008h
LVS_EX_HEADERDRAGDROP		= 000000010h
LVS_EX_FULLROWSELECT		= 000000020h ; applies to report mode only
LVS_EX_ONECLICKACTIVATE 	= 000000040h
LVS_EX_TWOCLICKACTIVATE 	= 000000080h
LVS_EX_FLATSB			= 000000100h
LVS_EX_REGIONAL 		= 000000200h
LVS_EX_INFOTIP			= 000000400h ; listview does InfoTips for you
LVS_EX_UNDERLINEHOT		= 000000800h
LVS_EX_UNDERLINECOLD		= 000001000h
LVS_EX_MULTIWORKAREAS		= 000002000h
LVS_EX_LABELTIP 		= 000004000h ; listview unfolds partly hidden labels if it does not have infotip text

LVM_GETSUBITEMRECT		= (LVM_FIRST + 56)
LVM_SUBITEMHITTEST		= (LVM_FIRST + 57)
LVM_SETCOLUMNORDERARRAY 	= (LVM_FIRST + 58)
LVM_GETCOLUMNORDERARRAY 	= (LVM_FIRST + 59)
LVM_SETHOTITEM			= (LVM_FIRST + 60)
LVM_GETHOTITEM			= (LVM_FIRST + 61)
LVM_SETHOTCURSOR		= (LVM_FIRST + 62)
LVM_GETHOTCURSOR		= (LVM_FIRST + 63)
LVM_APPROXIMATEVIEWRECT 	= (LVM_FIRST + 64)

LV_MAX_WORKAREAS		= 16
LVM_SETWORKAREAS		= (LVM_FIRST + 65)
LVM_GETWORKAREAS		= (LVM_FIRST + 70)
LVM_GETNUMBEROFWORKAREAS	= (LVM_FIRST + 73)
LVM_GETSELECTIONMARK		= (LVM_FIRST + 66)
LVM_SETSELECTIONMARK		= (LVM_FIRST + 67)
LVM_SETHOVERTIME		= (LVM_FIRST + 71)
LVM_GETHOVERTIME		= (LVM_FIRST + 72)
LVM_SETTOOLTIPS 		= (LVM_FIRST + 74)
LVM_GETTOOLTIPS 		= (LVM_FIRST + 78)
LVM_SORTITEMSEX 		= (LVM_FIRST + 81)

struc	LVBKIMAGE
	ulFlags 		dd ?		; LVBKIF_*
	hbm			dd ?
	pszImage		dd ?
	cchImageMax		dd ?
	xOffsetPercent		dd ?
	yOffsetPercent		dd ?
ends

LVBKIF_SOURCE_NONE		= 000000000h
LVBKIF_SOURCE_HBITMAP		= 000000001h
LVBKIF_SOURCE_URL		= 000000002h
LVBKIF_SOURCE_MASK		= 000000003h
LVBKIF_STYLE_NORMAL		= 000000000h
LVBKIF_STYLE_TILE		= 000000010h
LVBKIF_STYLE_MASK		= 000000010h

LVM_SETBKIMAGE			= (LVM_FIRST + 68)
LVM_GETBKIMAGE			= (LVM_FIRST + 69)

struc	NMLISTVIEW
	hdr			NMHDR ?
	iItem			dd ?
	iSubItem		dd ?
	uNewState		dd ?
	uOldState		dd ?
	uChanged		dd ?
	ptAction		POINT ?
	lParam			dd ?
ends

typedef NM_LISTVIEW		NMLISTVIEW

; NMITEMACTIVATE is used instead of NMLISTVIEW in IE >= 0x400
; therefore all the fields are the same except for extra uKeyFlags
; they are used to store key flags at the time of the single click with
; delayed activation - because by the time the timer goes off a user may
; not hold the keys (shift, ctrl) any more

struc	NMITEMACTIVATE
	hdr			NMHDR ?
	iItem			dd ?
	iSubItem		dd ?
	uNewState		dd ?
	uOldState		dd ?
	uChanged		dd ?
	ptAction		POINT ?
	lParam			dd ?
	uKeyFlags		dd ?
ends

; key flags stored in uKeyFlags
LVKF_ALT			= 00001h
LVKF_CONTROL			= 00002h
LVKF_SHIFT			= 00004h

struc	NMLVCUSTOMDRAW
	nmcd			NMCUSTOMDRAW ?
	clrText 		dd ?
	clrTextBk		dd ?
if _WIN32_IE ge 0400h
	iSubItem		dd ?
endif
ends

struc	NMLVCACHEHINT
	hdr			NMHDR ?
	iFrom			dd ?
	iTo			dd ?
ends

typedef NM_CACHEHINT		NMLVCACHEHINT

struc	NMLVFINDITEM
	hdr			NMHDR ?
	iStart			dd ?
	lvfi			LVFINDINFO ?
ends

typedef NM_FINDITEM		NMLVFINDITEM

struc	NMLVODSTATECHANGE
	hdr			NMHDR ?
	iFrom			dd ?
	iTo			dd ?
	uNewState		dd ?
	uOldState		dd ?
ends

typedef NM_ODSTATECHANGE	NMLVODSTATECHANGE

LVN_ITEMCHANGING		= (LVN_FIRST-0)
LVN_ITEMCHANGED 		= (LVN_FIRST-1)
LVN_INSERTITEM			= (LVN_FIRST-2)
LVN_DELETEITEM			= (LVN_FIRST-3)
LVN_DELETEALLITEMS		= (LVN_FIRST-4)
LVN_BEGINLABELEDIT		= (LVN_FIRST-5)
LVN_ENDLABELEDIT		= (LVN_FIRST-6)
LVN_COLUMNCLICK 		= (LVN_FIRST-8)
LVN_BEGINDRAG			= (LVN_FIRST-9)
LVN_BEGINRDRAG			= (LVN_FIRST-11)

LVN_ODCACHEHINT 		= (LVN_FIRST-13)
LVN_ODFINDITEM			= (LVN_FIRST-52)

LVN_ITEMACTIVATE		= (LVN_FIRST-14)
LVN_ODSTATECHANGED		= (LVN_FIRST-15)

LVN_HOTTRACK			= (LVN_FIRST-21)

LVN_GETDISPINFO 		= (LVN_FIRST-50)
LVN_SETDISPINFO 		= (LVN_FIRST-51)

LVIF_DI_SETITEM 		= 01000h

struc	NMLVDISPINFO
	hdr			NMHDR ?
	item			LVITEM ?
ends

typedef LV_DISPINFO		NMLVDISPINFO

LVN_KEYDOWN			= (LVN_FIRST-55)

struc	NMLVKEYDOWN
	hdr			NMHDR ?
	wVKey			dw ?
	flags			dd ?
ends

typedef LV_KEYDOWN		NMLVKEYDOWN

LVN_MARQUEEBEGIN		= (LVN_FIRST-56)

struc	NMLVGETINFOTIP
	hdr			NMHDR ?
	dwFlags 		dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iItem			dd ?
	iSubItem		dd ?
	lParam			dd ?
ends

LVGIT_UNFOLDED			= 00001h

LVN_GETINFOTIP			= (LVN_FIRST-57)

;====== TREEVIEW CONTROL =====================================================

WC_TREEVIEW			equ <'SysTreeView32', 0>

TVS_HASBUTTONS			= 00001h
TVS_HASLINES			= 00002h
TVS_LINESATROOT 		= 00004h
TVS_EDITLABELS			= 00008h
TVS_DISABLEDRAGDROP		= 00010h
TVS_SHOWSELALWAYS		= 00020h
TVS_RTLREADING			= 00040h

TVS_NOTOOLTIPS			= 00080h
TVS_CHECKBOXES			= 00100h
TVS_TRACKSELECT 		= 00200h
TVS_SINGLEEXPAND		= 00400h
TVS_INFOTIP			= 00800h
TVS_FULLROWSELECT		= 01000h
TVS_NOSCROLL			= 02000h
TVS_NONEVENHEIGHT		= 04000h
TVS_NOHSCROLL			= 08000h  ; TVS_NOSCROLL overrides this

TVIF_TEXT			= 00001h
TVIF_IMAGE			= 00002h
TVIF_PARAM			= 00004h
TVIF_STATE			= 00008h
TVIF_HANDLE			= 00010h
TVIF_SELECTEDIMAGE		= 00020h
TVIF_CHILDREN			= 00040h
TVIF_INTEGRAL			= 00080h
TVIS_SELECTED			= 00002h
TVIS_CUT			= 00004h
TVIS_DROPHILITED		= 00008h
TVIS_BOLD			= 00010h
TVIS_EXPANDED			= 00020h
TVIS_EXPANDEDONCE		= 00040h
TVIS_EXPANDPARTIAL		= 00080h

TVIS_OVERLAYMASK		= 00F00h
TVIS_STATEIMAGEMASK		= 0F000h
TVIS_USERMASK			= 0F000h

I_CHILDRENCALLBACK		= (-1)

struc	TVITEM
	mask			dd ?
	hItem			dd ?
	state			dd ?
	stateMask		dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iImage			dd ?
	iSelectedImage		dd ?
	cChildren		dd ?
	lParam			dd ?
ends

typedef TV_ITEM 		TVITEM

; only used for Get and Set messages.  no notifies

struc	TVITEMEX
	mask			dd ?
	hItem			dd ?
	state			dd ?
	stateMask		dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iImage			dd ?
	iSelectedImage		dd ?
	cChildren		dd ?
	lParam			dd ?
	iIntegral		dd ?
ends

typedef TV_ITEMEX		TVITEMEX

TVI_ROOT			= (-010000h)
TVI_FIRST			= (-00FFFFh)
TVI_LAST			= (-00FFFEh)
TVI_SORT			= (-00FFFDh)

struc	TVINSERTSTRUCT
	hParent 		dd ?
	hInsertAfter		dd ?
	item			TV_ITEM ?
ends

typedef TV_INSERTSTRUCT 	TVINSERTSTRUCT

TVM_INSERTITEM			= (TV_FIRST + 0)
TVM_DELETEITEM			= (TV_FIRST + 1)
TVM_EXPAND			= (TV_FIRST + 2)

TVE_COLLAPSE			= 00001h
TVE_EXPAND			= 00002h
TVE_TOGGLE			= 00003h
TVE_EXPANDPARTIAL		= 04000h
TVE_COLLAPSERESET		= 08000h

TVM_GETITEMRECT 		= (TV_FIRST + 4)
TVM_GETCOUNT			= (TV_FIRST + 5)
TVM_GETINDENT			= (TV_FIRST + 6)
TVM_SETINDENT			= (TV_FIRST + 7)
TVM_GETIMAGELIST		= (TV_FIRST + 8)

TVSIL_NORMAL			= 0
TVSIL_STATE			= 2

TVM_SETIMAGELIST		= (TV_FIRST + 9)
TVM_GETNEXTITEM 		= (TV_FIRST + 10)

TVGN_ROOT			= 00000h
TVGN_NEXT			= 00001h
TVGN_PREVIOUS			= 00002h
TVGN_PARENT			= 00003h
TVGN_CHILD			= 00004h
TVGN_FIRSTVISIBLE		= 00005h
TVGN_NEXTVISIBLE		= 00006h
TVGN_PREVIOUSVISIBLE		= 00007h
TVGN_DROPHILITE 		= 00008h
TVGN_CARET			= 00009h
TVGN_LASTVISIBLE		= 0000Ah

TVM_SELECTITEM			= (TV_FIRST + 11)
TVM_GETITEM			= (TV_FIRST + 12)
TVM_SETITEM			= (TV_FIRST + 13)
TVM_EDITLABEL			= (TV_FIRST + 14)
TVM_GETEDITCONTROL		= (TV_FIRST + 15)
TVM_GETVISIBLECOUNT		= (TV_FIRST + 16)
TVM_HITTEST			= (TV_FIRST + 17)

struc	TVHITTESTINFO
	pt			POINT ?
	flags			dd ?
	hItem			dd ?
ends

typedef TV_HITTESTINFO		TVHITTESTINFO

TVHT_NOWHERE			= 00001h
TVHT_ONITEMICON 		= 00002h
TVHT_ONITEMLABEL		= 00004h
TVHT_ONITEM			= (TVHT_ONITEMICON + TVHT_ONITEMLABEL + TVHT_ONITEMSTATEICON)
TVHT_ONITEMINDENT		= 00008h
TVHT_ONITEMBUTTON		= 00010h
TVHT_ONITEMRIGHT		= 00020h
TVHT_ONITEMSTATEICON		= 00040h

TVHT_ABOVE			= 00100h
TVHT_BELOW			= 00200h
TVHT_TORIGHT			= 00400h
TVHT_TOLEFT			= 00800h

TVM_CREATEDRAGIMAGE		= (TV_FIRST + 18)
TVM_SORTCHILDREN		= (TV_FIRST + 19)
TVM_ENSUREVISIBLE		= (TV_FIRST + 20)
TVM_SORTCHILDRENCB		= (TV_FIRST + 21)
TVM_ENDEDITLABELNOW		= (TV_FIRST + 22)
TVM_GETISEARCHSTRING		= (TV_FIRST + 23)
TVM_SETTOOLTIPS 		= (TV_FIRST + 24)
TVM_GETTOOLTIPS 		= (TV_FIRST + 25)
TVM_SETINSERTMARK		= (TV_FIRST + 26)
TVM_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
TVM_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT
TVM_SETITEMHEIGHT		= (TV_FIRST + 27)
TVM_GETITEMHEIGHT		= (TV_FIRST + 28)
TVM_SETBKCOLOR			= (TV_FIRST + 29)
TVM_SETTEXTCOLOR		= (TV_FIRST + 30)
TVM_GETBKCOLOR			= (TV_FIRST + 31)
TVM_GETTEXTCOLOR		= (TV_FIRST + 32)
TVM_SETSCROLLTIME		= (TV_FIRST + 33)
TVM_GETSCROLLTIME		= (TV_FIRST + 34)
TVM_SETINSERTMARKCOLOR		= (TV_FIRST + 37)
TVM_GETINSERTMARKCOLOR		= (TV_FIRST + 38)

TVM_GETITEMSTATE		= (TV_FIRST + 39)

proctype FNTVCOMPARE :dword, :dword, :dword

struc	TVSORTCB
	hParent 		dd ?
	lpfnCompare		dd ?
	lParam			dd ?
ends

typedef TV_SORTCB		TVSORTCB

struc	NMTREEVIEW
	hdr			NMHDR ?
	action			dd ?
	itemOld 		TVITEM ?
	itemNew 		TVITEM ?
	ptDrag			POINT ?
ends

typedef NM_TREEVIEW		NMTREEVIEW

TVN_SELCHANGING 		= (TVN_FIRST-1)
TVN_SELCHANGED			= (TVN_FIRST-2)

TVC_UNKNOWN			= 00000h
TVC_BYMOUSE			= 00001h
TVC_BYKEYBOARD			= 00002h

TVN_GETDISPINFO 		= (TVN_FIRST-3)
TVN_SETDISPINFO 		= (TVN_FIRST-4)

TVIF_DI_SETITEM 		= 01000h

struc	NMTVDISPINFO
	hdr			NMHDR ?
	item			TVITEM ?
ends

typedef TV_DISPINFO		NMTVDISPINFO

TVN_ITEMEXPANDING		= (TVN_FIRST-5)
TVN_ITEMEXPANDED		= (TVN_FIRST-6)
TVN_BEGINDRAG			= (TVN_FIRST-7)
TVN_BEGINRDRAG			= (TVN_FIRST-8)
TVN_DELETEITEM			= (TVN_FIRST-9)
TVN_BEGINLABELEDIT		= (TVN_FIRST-10)
TVN_ENDLABELEDIT		= (TVN_FIRST-11)
TVN_KEYDOWN			= (TVN_FIRST-12)

TVN_GETINFOTIP			= (TVN_FIRST-13)
TVN_SINGLEEXPAND		= (TVN_FIRST-15)

struc	NMTVKEYDOWN
	hdr			NMHDR ?
	wVKey			dw ?
	flags			dd ?
ends

typedef TV_KEYDOWN		NMTVKEYDOWN

struc	NMTVCUSTOMDRAW
	nmcd			NMCUSTOMDRAW ?
	clrText 		dd ?
	clrTextBk		dd ?
if _WIN32_IE ge 0400h
	iLevel			dd ?
endif
ends

typedef TV_CUSTOMDRAW		NMTVCUSTOMDRAW

; for tooltips

struc	NMTVGETINFOTIP
	hdr			NMHDR ?
	pszText 		dd ?
	cchTextMax		dd ?
	hItem			dd ?
	lParam			dd ?
ends

typedef TV_GETINFOTIP		NMTVGETINFOTIP

; treeview's customdraw return meaning don't draw images.  valid on CDRF_NOTIFYITEMPREPAINT
TVCDRF_NOIMAGES 		= 000010000h

;//////////////////  ComboBoxEx ////////////////////////////////

WC_COMBOBOXEX			equ <'ComboBoxEx32', 0>

CBEIF_TEXT			= 000000001h
CBEIF_IMAGE			= 000000002h
CBEIF_SELECTEDIMAGE		= 000000004h
CBEIF_OVERLAY			= 000000008h
CBEIF_INDENT			= 000000010h
CBEIF_LPARAM			= 000000020h

CBEIF_DI_SETITEM		= 010000000h

struc	COMBOBOXEXITEM
	mask			dd ?
	iItem			dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iImage			dd ?
	iSelectedImage		dd ?
	iOverlay		dd ?
	iIndent 		dd ?
	lParam			dd ?
ends

CBEM_INSERTITEM 		= (WM_USER + 1)
CBEM_SETIMAGELIST		= (WM_USER + 2)
CBEM_GETIMAGELIST		= (WM_USER + 3)
CBEM_GETITEM			= (WM_USER + 4)
CBEM_SETITEM			= (WM_USER + 5)
CBEM_DELETEITEM 		= CB_DELETESTRING
CBEM_GETCOMBOCONTROL		= (WM_USER + 6)
CBEM_GETEDITCONTROL		= (WM_USER + 7)
CBEM_SETEXSTYLE 		= (WM_USER + 8)  ; use	SETEXTENDEDSTYLE instead
CBEM_SETEXTENDEDSTYLE		= (WM_USER + 14)   ; lparam == new style, wParam (optional) == mask
CBEM_GETEXSTYLE 		= (WM_USER + 9) ; use GETEXTENDEDSTYLE instead
CBEM_GETEXTENDEDSTYLE		= (WM_USER + 9)
CBEM_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
CBEM_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT
CBEM_SETEXSTYLE 		= (WM_USER + 8)
CBEM_GETEXSTYLE 		= (WM_USER + 9)
CBEM_HASEDITCHANGED		= (WM_USER + 10)

CBES_EX_NOEDITIMAGE		= 000000001h
CBES_EX_NOEDITIMAGEINDENT	= 000000002h
CBES_EX_PATHWORDBREAKPROC	= 000000004h
CBES_EX_NOSIZELIMIT		= 000000008h
CBES_EX_CASESENSITIVE		= 000000010h

struc	NMCOMBOBOXEX
	hdr			NMHDR ?
	ceItem			COMBOBOXEXITEM ?
ends

CBEN_GETDISPINFO		= (CBEN_FIRST - 0)
CBEN_INSERTITEM 		= (CBEN_FIRST - 1)
CBEN_DELETEITEM 		= (CBEN_FIRST - 2)
CBEN_BEGINEDIT			= (CBEN_FIRST - 4)
CBEN_ENDEDIT			= (CBEN_FIRST - 5)
CBEN_DRAGBEGIN			= (CBEN_FIRST - 8)

CBENF_KILLFOCUS 		= 1
CBENF_RETURN			= 2
CBENF_ESCAPE			= 3
CBENF_DROPDOWN			= 4

CBEMAXSTRLEN			= 260

; CBEN_DRAGBEGIN sends this information ...

struc	NMCBEDRAGBEGIN
	hdr			NMHDR ?
	iItemid 		dd ?
	szText			db CBEMAXSTRLEN dup (?)
ends

; CBEN_ENDEDIT sends this information...
; fChanged if the user actually did anything
; iNewSelection gives what would be the new selection unless the notify is failed
;		       iNewSelection may be CB_ERR if there's no match

struc	NMCBEENDEDIT
	hdr			NMHDR ?
	fChanged		dd ?
	iNewSelection		dd ?
	szText			db CBEMAXSTRLEN dup (?)
	iWhy			dd ?
ends

;====== TAB CONTROL ==========================================================

WC_TABCONTROL			equ <'SysTabControl32', 0>

TCS_SCROLLOPPOSITE		= 00001h   ; assumes multiline tab
TCS_BOTTOM			= 00002h
TCS_RIGHT			= 00002h
TCS_MULTISELECT 		= 00004h  ; allow multi-select in button mode
TCS_FLATBUTTONS 		= 00008h
TCS_FORCEICONLEFT		= 00010h
TCS_FORCELABELLEFT		= 00020h
TCS_HOTTRACK			= 00040h
TCS_VERTICAL			= 00080h
TCS_TABS			= 00000h
TCS_BUTTONS			= 00100h
TCS_SINGLELINE			= 00000h
TCS_MULTILINE			= 00200h
TCS_RIGHTJUSTIFY		= 00000h
TCS_FIXEDWIDTH			= 00400h
TCS_RAGGEDRIGHT 		= 00800h
TCS_FOCUSONBUTTONDOWN		= 01000h
TCS_OWNERDRAWFIXED		= 02000h
TCS_TOOLTIPS			= 04000h
TCS_FOCUSNEVER			= 08000h

; EX styles for use with TCM_SETEXTENDEDSTYLE
TCS_EX_FLATSEPARATORS		= 000000001h
TCS_EX_REGISTERDROP		= 000000002h

TCM_GETIMAGELIST		= (TCM_FIRST + 2)
TCM_SETIMAGELIST		= (TCM_FIRST + 3)
TCM_GETITEMCOUNT		= (TCM_FIRST + 4)

TCIF_TEXT			= 00001h
TCIF_IMAGE			= 00002h
TCIF_RTLREADING 		= 00004h
TCIF_PARAM			= 00008h
TCIF_STATE			= 00010h

TCIS_BUTTONPRESSED		= 00001h
TCIS_HIGHLIGHTED		= 00002h

struc	TCITEMHEADER
	mask			dd ?
	lpReserved1		dd ?
	lpReserved2		dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iImage			dd ?
ends

typedef TC_ITEMHEADER		TCITEMHEADER

struc	TCITEM
	mask			dd ?
	dwState 		dd ?
	dwStateMask		dd ?
	pszText 		dd ?
	cchTextMax		dd ?
	iImage			dd ?
	lParam			dd ?
ends

typedef TC_ITEM 		TCITEM

TCM_GETITEM			= (TCM_FIRST + 5)
TCM_SETITEM			= (TCM_FIRST + 6)
TCM_INSERTITEM			= (TCM_FIRST + 7)
TCM_DELETEITEM			= (TCM_FIRST + 8)
TCM_DELETEALLITEMS		= (TCM_FIRST + 9)
TCM_GETITEMRECT 		= (TCM_FIRST + 10)
TCM_GETCURSEL			= (TCM_FIRST + 11)
TCM_SETCURSEL			= (TCM_FIRST + 12)

TCHT_NOWHERE			= 00001h
TCHT_ONITEMICON 		= 00002h
TCHT_ONITEMLABEL		= 00004h
TCHT_ONITEM			= (TCHT_ONITEMICON + TCHT_ONITEMLABEL)

struc	TCHITTESTINFO
	pt			POINT ?
	flags			dd ?
ends

typedef TC_HITTESTINFO		TCHITTESTINFO

TCM_HITTEST			= (TCM_FIRST + 13)
TCM_SETITEMEXTRA		= (TCM_FIRST + 14)
TCM_ADJUSTRECT			= (TCM_FIRST + 40)
TCM_SETITEMSIZE 		= (TCM_FIRST + 41)
TCM_REMOVEIMAGE 		= (TCM_FIRST + 42)
TCM_SETPADDING			= (TCM_FIRST + 43)
TCM_GETROWCOUNT 		= (TCM_FIRST + 44)
TCM_GETTOOLTIPS 		= (TCM_FIRST + 45)
TCM_SETTOOLTIPS 		= (TCM_FIRST + 46)
TCM_GETCURFOCUS 		= (TCM_FIRST + 47)
TCM_SETCURFOCUS 		= (TCM_FIRST + 48)
TCM_SETMINTABWIDTH		= (TCM_FIRST + 49)
TCM_DESELECTALL 		= (TCM_FIRST + 50)
TCM_HIGHLIGHTITEM		= (TCM_FIRST + 51)
TCM_SETEXTENDEDSTYLE		= (TCM_FIRST + 52)  ; optional wParam == mask
TCM_GETEXTENDEDSTYLE		= (TCM_FIRST + 53)
TCM_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
TCM_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT

TCN_KEYDOWN			= (TCN_FIRST - 0)

struc	NMTCKEYDOWN
	hdr			NMHDR ?
	wVKey			dw ?
	flags			dd ?
ends

typedef TC_KEYDOWN		NMTCKEYDOWN

TCN_SELCHANGE			= (TCN_FIRST - 1)
TCN_SELCHANGING 		= (TCN_FIRST - 2)
TCN_GETOBJECT			= (TCN_FIRST - 3)
TCN_FOCUSCHANGE 		= (TCN_FIRST - 4)

;====== ANIMATE CONTROL ======================================================

ANIMATE_CLASS			equ <'SysAnimate32', 0>

ACS_CENTER			= 00001h
ACS_TRANSPARENT 		= 00002h
ACS_AUTOPLAY			= 00004h
ACS_TIMER			= 00008h  ; don't use threads... use timers

ACM_OPEN			= (WM_USER+100)
ACM_PLAY			= (WM_USER+101)
ACM_STOP			= (WM_USER+102)

ACN_START			= 1
ACN_STOP			= 2

;====== MONTHCAL CONTROL ======================================================

MONTHCAL_CLASS			equ <'SysMonthCal32', 0>

MCM_FIRST			= 01000h
MCM_GETCURSEL			= (MCM_FIRST + 1)
MCM_SETCURSEL			= (MCM_FIRST + 2)
MCM_GETMAXSELCOUNT		= (MCM_FIRST + 3)
MCM_SETMAXSELCOUNT		= (MCM_FIRST + 4)
MCM_GETSELRANGE 		= (MCM_FIRST + 5)
MCM_SETSELRANGE 		= (MCM_FIRST + 6)
MCM_GETMONTHRANGE		= (MCM_FIRST + 7)
MCM_SETDAYSTATE 		= (MCM_FIRST + 8)
MCM_GETMINREQRECT		= (MCM_FIRST + 9)
MCM_SETCOLOR			= (MCM_FIRST + 10)
MCM_GETCOLOR			= (MCM_FIRST + 11)

MCSC_BACKGROUND 		= 0   ; the background color (between months)
MCSC_TEXT			= 1   ; the dates
MCSC_TITLEBK			= 2   ; background of the title
MCSC_TITLETEXT			= 3
MCSC_MONTHBK			= 4   ; background within the month cal
MCSC_TRAILINGTEXT		= 5   ; the text color of header & trailing days

MCM_SETTODAY			= (MCM_FIRST + 12)
MCM_GETTODAY			= (MCM_FIRST + 13)
MCM_HITTEST			= (MCM_FIRST + 14)

struc	MCHITTESTINFO
	cbSize			dd ?
	pt			POINT ?
	uHit			dd ?		; out param
	st			SYSTEMTIME ?
ends

MCHT_TITLE			= 000010000h
MCHT_CALENDAR			= 000020000h
MCHT_TODAYLINK			= 000030000h

MCHT_NEXT			= 001000000h   ; these indicate that hitting
MCHT_PREV			= 002000000h  ; here will go to the next/prev month

MCHT_NOWHERE			= 000000000h

MCHT_TITLEBK			= (MCHT_TITLE)
MCHT_TITLEMONTH 		= (MCHT_TITLE + 00001h)
MCHT_TITLEYEAR			= (MCHT_TITLE + 00002h)
MCHT_TITLEBTNNEXT		= (MCHT_TITLE + MCHT_NEXT + 00003h)
MCHT_TITLEBTNPREV		= (MCHT_TITLE + MCHT_PREV + 00003h)

MCHT_CALENDARBK 		= (MCHT_CALENDAR)
MCHT_CALENDARDATE		= (MCHT_CALENDAR + 00001h)
MCHT_CALENDARDATENEXT		= (MCHT_CALENDARDATE + MCHT_NEXT)
MCHT_CALENDARDATEPREV		= (MCHT_CALENDARDATE + MCHT_PREV)
MCHT_CALENDARDAY		= (MCHT_CALENDAR + 00002h)
MCHT_CALENDARWEEKNUM		= (MCHT_CALENDAR + 00003h)

MCM_SETFIRSTDAYOFWEEK		= (MCM_FIRST + 15)
MCM_GETFIRSTDAYOFWEEK		= (MCM_FIRST + 16)
MCM_GETRANGE			= (MCM_FIRST + 17)
MCM_SETRANGE			= (MCM_FIRST + 18)
MCM_GETMONTHDELTA		= (MCM_FIRST + 19)
MCM_SETMONTHDELTA		= (MCM_FIRST + 20)
MCM_GETMAXTODAYWIDTH		= (MCM_FIRST + 21)
MCM_SETUNICODEFORMAT		= CCM_SETUNICODEFORMAT
MCM_GETUNICODEFORMAT		= CCM_GETUNICODEFORMAT

; MCN_SELCHANGE is sent whenever the currently displayed date changes
; via month change, year change, keyboard navigation, prev/next button

struc	NMSELCHANGE
	nmhdr			NMHDR ? 	; this must be first, so we don't break WM_NOTIFY
	stSelStart		SYSTEMTIME ?
	stSelEnd		SYSTEMTIME ?
ends

MCN_SELCHANGE			= (MCN_FIRST + 1)

; MCN_GETDAYSTATE is sent for MCS_DAYSTATE controls whenever new daystate
; information is needed (month or year scroll) to draw bolding information.
; The app must fill in cDayState months worth of information starting from
; stStart date. The app may fill in the array at prgDayState or change
; prgDayState to point to a different array out of which the information
; will be copied. (similar to tooltips)

struc	NMDAYSTATE
	nmhdr			NMHDR ? 	; this must be first, so we don't break WM_NOTIFY
	stStart 		SYSTEMTIME ?
	cDayState		dd ?
	prgDayState		dd ?		; points to cDayState MONTHDAYSTATEs
ends

MCN_GETDAYSTATE 		= (MCN_FIRST + 3)

; MCN_SELECT is sent whenever a selection has occured (via mouse or keyboard)

MCN_SELECT			= (MCN_FIRST + 4)

MCS_DAYSTATE			= 00001h
MCS_MULTISELECT 		= 00002h
MCS_WEEKNUMBERS 		= 00004h
MCS_NOTODAYCIRCLE		= 00008h
MCS_NOTODAY			= 00010h

GMR_VISIBLE			= 0	  ; visible portion of display
GMR_DAYSTATE			= 1	  ; above plus the grayed out parts of
					  ; partially displayed months

;====== DATETIMEPICK CONTROL ==================================================

DATETIMEPICK_CLASS		equ <'SysDateTimePick32', 0>

DTM_FIRST			= 01000h
DTM_GETSYSTEMTIME		= (DTM_FIRST + 1)
DTM_SETSYSTEMTIME		= (DTM_FIRST + 2)
DTM_GETRANGE			= (DTM_FIRST + 3)
DTM_SETRANGE			= (DTM_FIRST + 4)
DTM_SETFORMAT			= (DTM_FIRST + 5)
DTM_SETMCCOLOR			= (DTM_FIRST + 6)
DTM_GETMCCOLOR			= (DTM_FIRST + 7)
DTM_GETMONTHCAL 		= (DTM_FIRST + 8)
DTM_SETMCFONT			= (DTM_FIRST + 9)
DTM_GETMCFONT			= (DTM_FIRST + 10)

DTS_UPDOWN			= 00001h ; use UPDOWN instead of MONTHCAL
DTS_SHOWNONE			= 00002h ; allow a NONE selection
DTS_SHORTDATEFORMAT		= 00000h ; use the short date format (app must forward WM_WININICHANGE messages)
DTS_LONGDATEFORMAT		= 00004h ; use the long date format (app must forward WM_WININICHANGE messages)
DTS_SHORTDATECENTURYFORMAT	= 0000Ch; short date format with century (app must forward WM_WININICHANGE messages)
DTS_TIMEFORMAT			= 00009h ; use the time format (app must forward WM_WININICHANGE messages)
DTS_APPCANPARSE 		= 00010h ; allow user entered strings (app MUST respond to DTN_USERSTRING)
DTS_RIGHTALIGN			= 00020h ; right-align popup instead of left-align it

DTN_DATETIMECHANGE		= (DTN_FIRST + 1) ; the systemtime has changed

struc	NMDATETIMECHANGE
	nmhdr			NMHDR ?
	dwFlags 		dd ?		; GDT_VALID or GDT_NONE
	st			SYSTEMTIME ?	; valid iff dwFlags==GDT_VALID
ends

DTN_USERSTRING			= (DTN_FIRST + 2) ; the user has entered a string

struc	NMDATETIMESTRING
	nmhdr			NMHDR ?
	pszUserString		dd ?		; string user entered
	st			SYSTEMTIME ?	; app fills this in
	dwFlags 		dd ?		; GDT_VALID or GDT_NONE
ends

DTN_WMKEYDOWN			= (DTN_FIRST + 3) ; modify keydown on app format field (X)

struc	NMDATETIMEWMKEYDOWN
	nmhdr			NMHDR ?
	nVirtKey		dd ?		; virtual key code of WM_KEYDOWN which MODIFIES an X field
	pszFormat		dd ?		; format substring
	st			SYSTEMTIME ?	; current systemtime, app should modify based on key
ends

DTN_FORMAT			= (DTN_FIRST + 4) ; query display for app format field (X)

struc	NMDATETIMEFORMAT
	nmhdr			NMHDR ?
	pszFormat		dd ?		; format substring
	st			SYSTEMTIME ?	; current systemtime
	pszDisplay		dd ?		; string to display
	szDisplay		db 64 dup (?)	; buffer pszDisplay originally points at
ends

DTN_FORMATQUERY 		= (DTN_FIRST + 5) ; query formatting info for app format field (X)

struc	NMDATETIMEFORMATQUERY
	nmhdr			NMHDR ?
	pszFormat		dd ?		; format substring
	szMax			_SIZE ? 	; max bounding rectangle app will use for this format string
ends

DTN_DROPDOWN			= (DTN_FIRST + 6) ; MonthCal has dropped down
DTN_CLOSEUP			= (DTN_FIRST + 7) ; MonthCal is popping up

GDTR_MIN			= 00001h
GDTR_MAX			= 00002h

GDT_ERROR			= -1
GDT_VALID			= 0
GDT_NONE			= 1

;/////////////////////////////////////////////
;/    IP Address edit control

; Messages sent to IPAddress controls

IPM_CLEARADDRESS		= (WM_USER+100) ; no parameters
IPM_SETADDRESS			= (WM_USER+101) ; lparam = TCP/IP address
IPM_GETADDRESS			= (WM_USER+102) ; lresult = # of non black fields.  lparam = LPDWORD for TCP/IP address
IPM_SETRANGE			= (WM_USER+103) ; wparam = field, lparam = range
IPM_SETFOCUS			= (WM_USER+104) ; wparam = field
IPM_ISBLANK			= (WM_USER+105) ; no parameters

WC_IPADDRESS			equ <'SysIPAddress32', 0>

IPN_FIELDCHANGED		= (IPN_FIRST - 0)

struc	NMIPADDRESS
	hdr			NMHDR ?
	iField			dd ?
	iValue			dd ?
ends

;---------------------------------------------------------------------------------------
;---------------------------------------------------------------------------------------
;/  ====================== Pager Control =============================
;---------------------------------------------------------------------------------------
;---------------------------------------------------------------------------------------

WC_PAGESCROLLER 		equ <'SysPager', 0>

;---------------------------------------------------------------------------------------
; Pager Control Styles
;---------------------------------------------------------------------------------------

PGS_VERT			= 000000000h
PGS_HORZ			= 000000001h
PGS_AUTOSCROLL			= 000000002h
PGS_DRAGNDROP			= 000000004h

;---------------------------------------------------------------------------------------
; Pager Button State
;---------------------------------------------------------------------------------------
;The scroll can be in one of the following control State
PGF_INVISIBLE			= 0	 ; Scroll button is not visible
PGF_NORMAL			= 1	 ; Scroll button is in normal state
PGF_GRAYED			= 2	 ; Scroll button is in grayed state
PGF_DEPRESSED			= 4	 ; Scroll button is in depressed state
PGF_HOT 			= 8	 ; Scroll button is in hot state

; The following identifiers specifies the button control
PGB_TOPORLEFT			= 0
PGB_BOTTOMORRIGHT		= 1

;---------------------------------------------------------------------------------------
; Pager Control  Messages
;---------------------------------------------------------------------------------------
PGM_SETCHILD			= (PGM_FIRST + 1)  ; lParam == hwnd
PGM_RECALCSIZE			= (PGM_FIRST + 2)
PGM_FORWARDMOUSE		= (PGM_FIRST + 3)
PGM_SETBKCOLOR			= (PGM_FIRST + 4)
PGM_GETBKCOLOR			= (PGM_FIRST + 5)
PGM_SETBORDER			= (PGM_FIRST + 6)
PGM_GETBORDER			= (PGM_FIRST + 7)
PGM_SETPOS			= (PGM_FIRST + 8)
PGM_GETPOS			= (PGM_FIRST + 9)
PGM_SETBUTTONSIZE		= (PGM_FIRST + 10)
PGM_GETBUTTONSIZE		= (PGM_FIRST + 11)
PGM_GETBUTTONSTATE		= (PGM_FIRST + 12)
PGM_GETDROPTARGET		= CCM_GETDROPTARGET
;---------------------------------------------------------------------------------------
;Pager Control Notification Messages
;---------------------------------------------------------------------------------------

; PGN_SCROLL Notification Message

PGN_SCROLL			= (PGN_FIRST-1)

PGF_SCROLLUP			= 1
PGF_SCROLLDOWN			= 2
PGF_SCROLLLEFT			= 4
PGF_SCROLLRIGHT 		= 8

;Keys down
PGK_SHIFT			= 1
PGK_CONTROL			= 2
PGK_MENU			= 4

; This structure is sent along with PGN_SCROLL notifications

struc	NMPGSCROLL
	hdr			NMHDR ?
	fwKeys			dw ?		; Specifies which keys are down when this notification is send
	rcParent		RECT ?		; Contains Parent Window Rect
	iDir			dd ?		; Scrolling Direction
	iXpos			dd ?		; Horizontal scroll position
	iYpos			dd ?		; Vertical scroll position
	iScroll 		dd ?		; [in/out] Amount to scroll
ends

; PGN_CALCSIZE Notification Message

PGN_CALCSIZE			= (PGN_FIRST-2)

PGF_CALCWIDTH			= 1
PGF_CALCHEIGHT			= 2

struc	NMPGCALCSIZE
	hdr			NMHDR ?
	dwFlag			dd ?
	iWidth			dd ?
	iHeight 		dd ?
ends

;//======================  End Pager Control ==========================================

;
; === Native Font Control ===
;
;NativeFont Class Name
WC_NATIVEFONTCTL		equ <'NativeFontCtl', 0>

; style definition
NFS_EDIT			= 00001h
NFS_STATIC			= 00002h
NFS_LISTCOMBO			= 00004h
NFS_BUTTON			= 00008h
NFS_ALL 			= 00010h

; === End Native Font Control ===

;====== TrackMouseEvent  =====================================================

; If the messages for TrackMouseEvent have not been defined then define them
; now.

WM_MOUSEHOVER			= 002A1h
WM_MOUSELEAVE			= 002A3h

; If the TRACKMOUSEEVENT structure and associated flags havent been declared
; then declare them now.

TME_HOVER			= 000000001h
TME_LEAVE			= 000000002h
TME_NONCLIENT			= 000000010h
TME_QUERY			= 040000000h
TME_CANCEL			= 080000000h

HOVER_DEFAULT			= 0FFFFFFFFh

struc	TRACKMOUSEEVENT
	cbSize			dd ?
	dwFlags 		dd ?
	hwndTrack		dd ?
	dwHoverTime		dd ?
ends

procdesc _TrackMouseEvent :dword

;====== Flat Scrollbar APIs=========================================

WSB_PROP_CYVSCROLL		= 000000001h
WSB_PROP_CXHSCROLL		= 000000002h
WSB_PROP_CYHSCROLL		= 000000004h
WSB_PROP_CXVSCROLL		= 000000008h
WSB_PROP_CXHTHUMB		= 000000010h
WSB_PROP_CYVTHUMB		= 000000020h
WSB_PROP_VBKGCOLOR		= 000000040h
WSB_PROP_HBKGCOLOR		= 000000080h
WSB_PROP_VSTYLE 		= 000000100h
WSB_PROP_HSTYLE 		= 000000200h
WSB_PROP_WINSTYLE		= 000000400h
WSB_PROP_PALETTE		= 000000800h
WSB_PROP_MASK			= 000000FFFh

FSB_FLAT_MODE			= 2
FSB_ENCARTA_MODE		= 1
FSB_REGULAR_MODE		= 0

FlatSB_GetScrollPropPtr 	equ <FlatSB_GetScrollProp>
FlatSB_SetScrollPropPtr 	equ <FlatSB_SetScrollProp>

procdesc FlatSB_EnableScrollBar :dword, :dword
procdesc FlatSB_ShowScrollBar :dword, :dword, :dword
procdesc FlatSB_GetScrollRange :dword, :dword, :dword, :dword
procdesc FlatSB_GetScrollInfo :dword, :dword, :dword
procdesc FlatSB_GetScrollPos :dword, :dword
procdesc FlatSB_GetScrollProp :dword, :dword, :dword
procdesc FlatSB_SetScrollPos :dword, :dword, :dword, :dword
procdesc FlatSB_SetScrollInfo :dword, :dword, :dword, :dword
procdesc FlatSB_SetScrollRange :dword, :dword, :dword, :dword, :dword
procdesc FlatSB_SetScrollProp :dword, :dword, :dword, :dword
procdesc InitializeFlatSB :dword
procdesc UninitializeFlatSB :dword
