;***********************************************************************
;*									 *
;*   commdlg.h -- This module defines the 32-Bit Common Dialog APIs	 *
;*									 *
;*   Copyright (c) 1992-1998, Microsoft Corp. All rights reserved.	 *
;*									 *
;***********************************************************************

;
;  IPrintDialogCallback interface id used by PrintDlgEx.
;
;  {5852A2C3-6530-11D1-B6A3-0000F8757BF9}
;

macro	Define_IID_IPrintDialogCallback
public	IID_IPrintDialogCallback
IID_IPrintDialogCallback	GUID <05852a2c3h, 06530h, 011d1h,\
			0b6h, 0a3h, 00h, 00h, 0f8h, 075h, 07h, 0f9h>
endm

;
;  IPrintDialogServices interface id used by PrintDlgEx.
;
;  {509AAEDA-5639-11D1-B6A1-0000F8757BF9}
;

macro	Define_IID_IPrintDialogServices
public	IID_IPrintDialogServices
IID_IPrintDialogServices	GUID <0509aaedh, 05639h, 011d1h,\
			0b6h, 0a1h, 00h, 00h, 0f8h, 075h, 07h, 0f9h>
endm

struc	EDITMENU
	hmenu			dd ?
	idEdit			dw ?
	idCut			dw ?
	idCopy			dw ?
	idPaste 		dw ?
	idClear 		dw ?
	idUndo			dw ?
ends

proctype OFNHOOKPROC :dword, :dword, :dword, :dword

struc	OPENFILENAME
	lStructSize		dd ?
	hwndOwner		dd ?
	hInstance		dd ?
	lpstrFilter		dd ?
	lpstrCustomFilter	dd ?
	nMaxCustFilter		dd ?
	nFilterIndex		dd ?
	lpstrFile		dd ?
	nMaxFile		dd ?
	lpstrFileTitle		dd ?
	nMaxFileTitle		dd ?
	lpstrInitialDir 	dd ?
	lpstrTitle		dd ?
	Flags			dd ?
	nFileOffset		dw ?
	nFileExtension		dw ?
	lpstrDefExt		dd ?
	lCustData		dd ?
	lpfnHook		dd ?
	lpTemplateName		dd ?
if _WIN32_WINNT ge 0500h
	rgpMonikers		dd ?
	cMonikers		dd ?
endif
ends

procdesc GetOpenFileNameA :dword
procdesc GetSaveFileNameA :dword
procdesc GetFileTitleA :dword, :dword, :dword

GetOpenFileName 		equ <GetOpenFileNameA>
GetSaveFileName 		equ <GetSaveFileNameA>
GetFileTitle			equ <GetFileTitleA>

OFN_READONLY			= 000000001h
OFN_OVERWRITEPROMPT		= 000000002h
OFN_HIDEREADONLY		= 000000004h
OFN_NOCHANGEDIR 		= 000000008h
OFN_SHOWHELP			= 000000010h
OFN_ENABLEHOOK			= 000000020h
OFN_ENABLETEMPLATE		= 000000040h
OFN_ENABLETEMPLATEHANDLE	= 000000080h
OFN_NOVALIDATE			= 000000100h
OFN_ALLOWMULTISELECT		= 000000200h
OFN_EXTENSIONDIFFERENT		= 000000400h
OFN_PATHMUSTEXIST		= 000000800h
OFN_FILEMUSTEXIST		= 000001000h
OFN_CREATEPROMPT		= 000002000h
OFN_SHAREAWARE			= 000004000h
OFN_NOREADONLYRETURN		= 000008000h
OFN_NOTESTFILECREATE		= 000010000h
OFN_NONETWORKBUTTON		= 000020000h
OFN_NOLONGNAMES 		= 000040000h	 ; force no long names for 4.x modules
OFN_EXPLORER			= 000080000h	 ; new look commdlg
OFN_NODEREFERENCELINKS		= 000100000h
OFN_LONGNAMES			= 000200000h	 ; force long names for 3.x modules
OFN_ENABLEINCLUDENOTIFY 	= 000400000h	 ; send include message to callback
OFN_ENABLESIZING		= 000800000h
OFN_USEMONIKERS 		= 001000000h
OFN_DONTADDTORECENT		= 002000000h
OFN_FORCESHOWHIDDEN		= 004000000h	; Show All files including System and hidden files

; Return values for the registered message sent to the hook function
; when a sharing violation occurs.  OFN_SHAREFALLTHROUGH allows the
; filename to be accepted, OFN_SHARENOWARN rejects the name but puts
; up no warning (returned when the app has already put up a warning
; message), and OFN_SHAREWARN puts up the default warning message
; for sharing violations.
;
; Note:  Undefined return values map to OFN_SHAREWARN, but are
;	 reserved for future use.

OFN_SHAREFALLTHROUGH		= 2
OFN_SHARENOWARN 		= 1
OFN_SHAREWARN			= 0

proctype CCHOOKPROC :dword, :dword, :dword, :dword

; Structure used for all file based OpenFileName notifications

struc	OFNOTIFY
	hdr			NMHDR ?
	lpOFN			dd ?
	pszFile 		dd ?		; May be NULL
ends

; Structure used for all object based OpenFileName notifications

struc	OFNOTIFYEX
	hdr			NMHDR ?
	lpOFN			dd ?
	psf			dd ?
	pidl			dd ?		; May be NULL
ends

CDN_FIRST			= (0-601)
CDN_LAST			= (0-699)

; Notifications when Open or Save dialog status changes
CDN_INITDONE			= (CDN_FIRST - 00000h)
CDN_SELCHANGE			= (CDN_FIRST - 00001h)
CDN_FOLDERCHANGE		= (CDN_FIRST - 00002h)
CDN_SHAREVIOLATION		= (CDN_FIRST - 00003h)
CDN_HELP			= (CDN_FIRST - 00004h)
CDN_FILEOK			= (CDN_FIRST - 00005h)
CDN_TYPECHANGE			= (CDN_FIRST - 00006h)
CDN_INCLUDEITEM 		= (CDN_FIRST - 00007h)

CDM_FIRST			= (WM_USER + 100)
CDM_LAST			= (WM_USER + 200)

CDM_GETSPEC			= (CDM_FIRST + 00000h)
CDM_GETFILEPATH 		= (CDM_FIRST + 00001h)
CDM_GETFOLDERPATH		= (CDM_FIRST + 00002h)
CDM_GETFOLDERIDLIST		= (CDM_FIRST + 00003h)
CDM_SETCONTROLTEXT		= (CDM_FIRST + 00004h)
CDM_HIDECONTROL 		= (CDM_FIRST + 00005h)
CDM_SETDEFEXT			= (CDM_FIRST + 00006h)

struc	CHOOSECOLOR
	lStructSize		dd ?
	hwndOwner		dd ?
	hInstance		dd ?
	rgbResult		dd ?
	lpCustColors		dd ?
	Flags			dd ?
	lCustData		dd ?
	lpfnHook		dd ?
	lpTemplateName		dd ?
ends

procdesc ChooseColorA :dword

ChooseColor			equ <ChooseColorA>

CC_RGBINIT			= 000000001h
CC_FULLOPEN			= 000000002h
CC_PREVENTFULLOPEN		= 000000004h
CC_SHOWHELP			= 000000008h
CC_ENABLEHOOK			= 000000010h
CC_ENABLETEMPLATE		= 000000020h
CC_ENABLETEMPLATEHANDLE 	= 000000040h
CC_SOLIDCOLOR			= 000000080h
CC_ANYCOLOR			= 000000100h

proctype FRHOOKPROC :dword, :dword, :dword, :dword

struc	FINDREPLACE
	lStructSize		dd ?		; size of this struct 0x20
	hwndOwner		dd ?		; handle to owner's window
	hInstance		dd ?		; instance handle of.EXE that ;   contains cust. dlg. template
	Flags			dd ?		; one or more of the FR_??
	lpstrFindWhat		dd ?		; ptr. to search string
	lpstrReplaceWith	dd ?		; ptr. to replace string
	wFindWhatLen		dw ?		; size of find buffer
	wReplaceWithLen 	dw ?		; size of replace buffer
	lCustData		dd ?		; data passed to hook fn.
	lpfnHook		dd ?		; ptr. to hook fn. or NULL
	lpTemplateName		dd ?		; custom template name
ends

FR_DOWN 			= 000000001h
FR_WHOLEWORD			= 000000002h
FR_MATCHCASE			= 000000004h
FR_FINDNEXT			= 000000008h
FR_REPLACE			= 000000010h
FR_REPLACEALL			= 000000020h
FR_DIALOGTERM			= 000000040h
FR_SHOWHELP			= 000000080h
FR_ENABLEHOOK			= 000000100h
FR_ENABLETEMPLATE		= 000000200h
FR_NOUPDOWN			= 000000400h
FR_NOMATCHCASE			= 000000800h
FR_NOWHOLEWORD			= 000001000h
FR_ENABLETEMPLATEHANDLE 	= 000002000h
FR_HIDEUPDOWN			= 000004000h
FR_HIDEMATCHCASE		= 000008000h
FR_HIDEWHOLEWORD		= 000010000h
FR_RAW				= 000020000h
FR_MATCHDIAC			= 020000000h
FR_MATCHKASHIDA 		= 040000000h
FR_MATCHALEFHAMZA		= 080000000h

procdesc FindTextA :dword
procdesc ReplaceTextA :dword
procdesc AfxReplaceTextA :dword

FindText			equ <FindTextA>
ReplaceText			equ <ReplaceTextA>
AfxReplaceText			equ <AfxReplaceTextA>

proctype CFHOOKPROC :dword, :dword, :dword, :dword

struc	CHOOSEFONT
	lStructSize		dd ?
	hwndOwner		dd ?		; caller's window handle
	hDC			dd ?		; printer DC/IC or NULL
	lpLogFont		dd ?		; ptr. to a LOGFONT struct
	iPointSize		dd ?		; 10 * size in points of selected font
	Flags			dd ?		; enum. type flags
	rgbColors		dd ?		; returned text color
	lCustData		dd ?		; data passed to hook fn.
	lpfnHook		dd ?		; ptr. to hook function
	lpTemplateName		dd ?		; custom template name
	hInstance		dd ?		; instance handle of.EXE that ;   contains cust. dlg. template
	lpszStyle		dd ?		; return the style field here ; must be LF_FACESIZE or bigger
	nFontType		dw ?		; same value reported to the EnumFonts ;   call back with the extra FONTTYPE_ ;   bits added
	___MISSING_ALIGNMENT__	dw ?
	nSizeMin		dd ?		; minimum pt size allowed &
	nSizeMax		dd ?		; max pt size allowed if ;   CF_LIMITSIZE is used
ends

procdesc ChooseFontA :dword

ChooseFont			equ <ChooseFontA>

CF_SCREENFONTS			= 000000001h
CF_PRINTERFONTS 		= 000000002h
CF_BOTH 			= (CF_SCREENFONTS + CF_PRINTERFONTS)
CF_SHOWHELP			= 000000004h
CF_ENABLEHOOK			= 000000008h
CF_ENABLETEMPLATE		= 000000010h
CF_ENABLETEMPLATEHANDLE 	= 000000020h
CF_INITTOLOGFONTSTRUCT		= 000000040h
CF_USESTYLE			= 000000080h
CF_EFFECTS			= 000000100h
CF_APPLY			= 000000200h
CF_ANSIONLY			= 000000400h
CF_SCRIPTSONLY			= CF_ANSIONLY
CF_NOVECTORFONTS		= 000000800h
CF_NOOEMFONTS			= CF_NOVECTORFONTS
CF_NOSIMULATIONS		= 000001000h
CF_LIMITSIZE			= 000002000h
CF_FIXEDPITCHONLY		= 000004000h
CF_WYSIWYG			= 000008000h ; must also have CF_SCREENFONTS & CF_PRINTERFONTS
CF_FORCEFONTEXIST		= 000010000h
CF_SCALABLEONLY 		= 000020000h
CF_TTONLY			= 000040000h
CF_NOFACESEL			= 000080000h
CF_NOSTYLESEL			= 000100000h
CF_NOSIZESEL			= 000200000h
CF_SELECTSCRIPT 		= 000400000h
CF_NOSCRIPTSEL			= 000800000h
CF_NOVERTFONTS			= 001000000h

; these are extra nFontType bits that are added to what is returned to the
; EnumFonts callback routine

SIMULATED_FONTTYPE		= 08000h
PRINTER_FONTTYPE		= 04000h
SCREEN_FONTTYPE 		= 02000h
BOLD_FONTTYPE			= 00100h
ITALIC_FONTTYPE 		= 00200h
REGULAR_FONTTYPE		= 00400h

; EnumFonts callback routine only uses these bits, so we can use the rest

; #define RASTER_FONTTYPE     0x001
; #define DEVICE_FONTTYPE     0x002
; #define TRUETYPE_FONTTYPE   0x004

PS_OPENTYPE_FONTTYPE		= 010000h
TT_OPENTYPE_FONTTYPE		= 020000h
TYPE1_FONTTYPE			= 040000h

WM_CHOOSEFONT_GETLOGFONT	= (WM_USER + 1)
WM_CHOOSEFONT_SETLOGFONT	= (WM_USER + 101)
WM_CHOOSEFONT_SETFLAGS		= (WM_USER + 102)

; strings used to obtain unique window message for communication
; between dialog and caller

LBSELCHSTRING			equ <'commdlg_LBSelChangedNotify', 0>
SHAREVISTRING			equ <'commdlg_ShareViolation', 0>
FILEOKSTRING			equ <'commdlg_FileNameOK', 0>
COLOROKSTRING			equ <'commdlg_ColorOK', 0>
SETRGBSTRING			equ <'commdlg_SetRGBColor', 0>
HELPMSGSTRING			equ <'commdlg_help', 0>
FINDMSGSTRING			equ <'commdlg_FindReplace', 0>

; HIWORD values for lParam of commdlg_LBSelChangeNotify message
CD_LBSELNOITEMS 		= -1
CD_LBSELCHANGE			= 0
CD_LBSELSUB			= 1
CD_LBSELADD			= 2

proctype PRINTHOOKPROC :dword, :dword, :dword, :dword
proctype SETUPHOOKPROC :dword, :dword, :dword, :dword

struc	PRINTDLG
	lStructSize		dd ?
	hwndOwner		dd ?
	hDevMode		dd ?
	hDevNames		dd ?
	hDC			dd ?
	Flags			dd ?
	nFromPage		dw ?
	nToPage 		dw ?
	nMinPage		dw ?
	nMaxPage		dw ?
	nCopies 		dw ?
	hInstance		dd ?
	lCustData		dd ?
	lpfnPrintHook		dd ?
	lpfnSetupHook		dd ?
	lpPrintTemplateName	dd ?
	lpSetupTemplateName	dd ?
	hPrintTemplate		dd ?
	hSetupTemplate		dd ?
ends

procdesc PrintDlgA :dword

PrintDlg			equ <PrintDlgA>

;-------------------------------------------------------------------------
;
;  IPrintDialogCallback Interface
;
;  IPrintDialogCallback::InitDone()
;    This function is called by PrintDlgEx when the system has finished
;    initializing the main page of the print dialog.  This function
;    should return S_OK if it has processed the action or S_FALSE to let
;    PrintDlgEx perform the default action.
;
;  IPrintDialogCallback::SelectionChange()
;    This function is called by PrintDlgEx when a selection change occurs
;    in the list view that displays the currently installed printers.
;    This function should return S_OK if it has processed the action or
;    S_FALSE to let PrintDlgEx perform the default action.
;
;  IPrintDialogCallback::HandleMessage(hDlg, uMsg, wParam, lParam, pResult)
;    This function is called by PrintDlgEx when a message is sent to the
;    child window of the main page of the print dialog.  This function
;    should return S_OK if it has processed the action or S_FALSE to let
;    PrintDlgEx perform the default action.
;
;  IObjectWithSite::SetSite(punkSite)
;    IPrintDialogCallback usually paired with IObjectWithSite.
;    Provides the IUnknown pointer of the site to QI for the
;    IPrintDialogServices interface.
;
;-------------------------------------------------------------------------

struc	IPrintDialogCallback
; *** IUnknown methods ***
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; *** IPrintDialogCallback methods ***
	InitDone		dd ?
	SelectionChange 	dd ?
	HandleMessage		dd ?
ends

;-------------------------------------------------------------------------
;
;  IPrintDialogServices Interface
;
;  IPrintDialogServices::GetCurrentDevMode(pDevMode, pcbSize)
;    Returns the DEVMODE structure for the currently selected printer.
;
;  IPrintDialogServices::GetCurrentPrinterName(pPrinterName, pcchSize)
;    Returns the printer name for the currently selected printer.
;
;  IPrintDialogServices::GetCurrentPortName(pPortName, pcchSize)
;    Returns the port name for the currently selected printer.
;
;-------------------------------------------------------------------------

struc	IPrintDialogServices
; *** IUnknown methods ***
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; *** IPrintDialogServices methods ***
	GetCurrentDevMode	dd ?
	GetCurrentPrinterName	dd ?
	GetCurrentPortName	dd ?
ends

;
;  Page Range structure for PrintDlgEx.
;

struc	PRINTPAGERANGE
	nFromPage		dd ?
	nToPage 		dd ?
ends

;
;  PrintDlgEx structure.
;

struc	PRINTDLGEX
	lStructSize		dd ?		; size of structure in bytes
	hwndOwner		dd ?		; caller's window handle
	hDevMode		dd ?		; handle to DevMode
	hDevNames		dd ?		; handle to DevNames
	hDC			dd ?		; printer DC/IC or NULL
	Flags			dd ?		; PD_ flags
	Flags2			dd ?		; reserved
	ExclusionFlags		dd ?		; items to exclude from driver pages
	nPageRanges		dd ?		; number of page ranges
	nMaxPageRanges		dd ?		; max number of page ranges
	lpPageRanges		dd ?		; array of page ranges
	nMinPage		dd ?		; min page number
	nMaxPage		dd ?		; max page number
	nCopies 		dd ?		; number of copies
	hInstance		dd ?		; instance handle
	lpPrintTemplateName	dd ?		; template name for app specific area
	lpCallback		dd ?		; app callback interface
	nPropertyPages		dd ?		; number of app property pages in lphPropertyPages
	lphPropertyPages	dd ?		; array of app property page handles
	nStartPage		dd ?		; start page id
	dwResultAction		dd ?		; result action if S_OK is returned
ends

procdesc PrintDlgExA :dword

PrintDlgEx			equ <PrintDlgExA>

;
;  Flags for PrintDlg and PrintDlgEx.
;
PD_ALLPAGES			= 000000000h
PD_SELECTION			= 000000001h
PD_PAGENUMS			= 000000002h
PD_NOSELECTION			= 000000004h
PD_NOPAGENUMS			= 000000008h
PD_COLLATE			= 000000010h
PD_PRINTTOFILE			= 000000020h
PD_PRINTSETUP			= 000000040h
PD_NOWARNING			= 000000080h
PD_RETURNDC			= 000000100h
PD_RETURNIC			= 000000200h
PD_RETURNDEFAULT		= 000000400h
PD_SHOWHELP			= 000000800h
PD_ENABLEPRINTHOOK		= 000001000h
PD_ENABLESETUPHOOK		= 000002000h
PD_ENABLEPRINTTEMPLATE		= 000004000h
PD_ENABLESETUPTEMPLATE		= 000008000h
PD_ENABLEPRINTTEMPLATEHANDLE	= 000010000h
PD_ENABLESETUPTEMPLATEHANDLE	= 000020000h
PD_USEDEVMODECOPIES		= 000040000h
PD_USEDEVMODECOPIESANDCOLLATE	= 000040000h
PD_DISABLEPRINTTOFILE		= 000080000h
PD_HIDEPRINTTOFILE		= 000100000h
PD_NONETWORKBUTTON		= 000200000h
PD_CURRENTPAGE			= 000400000h
PD_NOCURRENTPAGE		= 000800000h
PD_EXCLUSIONFLAGS		= 001000000h

;
;  Exclusion flags for PrintDlgEx.
;
PD_EXCL_COPIESANDCOLLATE	= (DM_COPIES + DM_COLLATE)

;
;  Define the start page for the print dialog when using PrintDlgEx.
;
START_PAGE_GENERAL		= 0fffffffh

;
;  Result action ids for PrintDlgEx.
;
PD_RESULT_CANCEL		= 0
PD_RESULT_PRINT 		= 1
PD_RESULT_APPLY 		= 2

;
;  Device Names structure for PrintDlg and PrintDlgEx.
;

struc	DEVNAMES
	wDriverOffset		dw ?
	wDeviceOffset		dw ?
	wOutputOffset		dw ?
	wDefault		dw ?
ends

DN_DEFAULTPRN			= 00001h

procdesc CommDlgExtendedError

WM_PSD_PAGESETUPDLG		= (WM_USER  )
WM_PSD_FULLPAGERECT		= (WM_USER+1)
WM_PSD_MINMARGINRECT		= (WM_USER+2)
WM_PSD_MARGINRECT		= (WM_USER+3)
WM_PSD_GREEKTEXTRECT		= (WM_USER+4)
WM_PSD_ENVSTAMPRECT		= (WM_USER+5)
WM_PSD_YAFULLPAGERECT		= (WM_USER+6)

struc	PAGESETUPDLG
	lStructSize		dd ?
	hwndOwner		dd ?
	hDevMode		dd ?
	hDevNames		dd ?
	Flags			dd ?
	ptPaperSize		POINT ?
	rtMinMargin		RECT ?
	rtMargin		RECT ?
	hInstance		dd ?
	lCustData		dd ?
	lpfnPageSetupHook	dd ?
	lpfnPagePaintHook	dd ?
	lpPageSetupTemplateName dd ?
	hPageSetupTemplate	dd ?
ends

procdesc PageSetupDlgA :dword

PageSetupDlg			equ <PageSetupDlgA>

PSD_DEFAULTMINMARGINS		= 000000000h ; default (printer's)
PSD_INWININIINTLMEASURE 	= 000000000h ; 1st of 4 possible

PSD_MINMARGINS			= 000000001h ; use caller's
PSD_MARGINS			= 000000002h ; use caller's
PSD_INTHOUSANDTHSOFINCHES	= 000000004h ; 2nd of 4 possible
PSD_INHUNDREDTHSOFMILLIMETERS	= 000000008h ; 3rd of 4 possible
PSD_DISABLEMARGINS		= 000000010h
PSD_DISABLEPRINTER		= 000000020h
PSD_NOWARNING			= 000000080h ; must be same as PD_*
PSD_DISABLEORIENTATION		= 000000100h
PSD_RETURNDEFAULT		= 000000400h ; must be same as PD_*
PSD_DISABLEPAPER		= 000000200h
PSD_SHOWHELP			= 000000800h ; must be same as PD_*
PSD_ENABLEPAGESETUPHOOK 	= 000002000h ; must be same as PD_*
PSD_ENABLEPAGESETUPTEMPLATE	= 000008000h ; must be same as PD_*
PSD_ENABLEPAGESETUPTEMPLATEHANDLE = 000020000h ; must be same as PD_*
PSD_ENABLEPAGEPAINTHOOK 	= 000040000h
PSD_DISABLEPAGEPAINTING 	= 000080000h
PSD_NONETWORKBUTTON		= 000200000h ; must be same as PD_*
