;****************************************************************************\
;*									       *
;* dde.h -	 Dynamic Data Exchange structures and definitions	       *
;*									       *
;* Copyright (c) 1993-1998, Microsoft Corp.	All rights reserved	      *
;*									       *
;\****************************************************************************

; DDE window messages

WM_DDE_FIRST			= 003E0h
WM_DDE_INITIATE 		= (WM_DDE_FIRST)
WM_DDE_TERMINATE		= (WM_DDE_FIRST+1)
WM_DDE_ADVISE			= (WM_DDE_FIRST+2)
WM_DDE_UNADVISE 		= (WM_DDE_FIRST+3)
WM_DDE_ACK			= (WM_DDE_FIRST+4)
WM_DDE_DATA			= (WM_DDE_FIRST+5)
WM_DDE_REQUEST			= (WM_DDE_FIRST+6)
WM_DDE_POKE			= (WM_DDE_FIRST+7)
WM_DDE_EXECUTE			= (WM_DDE_FIRST+8)
WM_DDE_LAST			= (WM_DDE_FIRST+8)

;----------------------------------------------------------------------------
;|	 DDEACK structure
;|
;|	Structure of wStatus (LOWORD(lParam)) in WM_DDE_ACK message
;|	 sent in response to a WM_DDE_DATA, WM_DDE_REQUEST, WM_DDE_POKE,
;|	 WM_DDE_ADVISE, or WM_DDE_UNADVISE message.
;|
;----------------------------------------------------------------------------

struc	DDEACK
	usFkags 		dw ?
ends

;----------------------------------------------------------------------------
;|	 DDEADVISE structure
;|
;|	WM_DDE_ADVISE parameter structure for hOptions (LOWORD(lParam))
;|
;----------------------------------------------------------------------------

struc	DDEADVISE
	usFlags 		dw ?
	cfFormat		dw ?
ends

;----------------------------------------------------------------------------
;|	 DDEDATA structure
;|
;|	 WM_DDE_DATA parameter structure for hData (LOWORD(lParam)).
;|	 The actual size of this structure depends on the size of
;|	 the Value array.
;|
;----------------------------------------------------------------------------

struc	DDEDATA
	usFlags 		dw ?
	cfFormat		dw ?
label	Value			byte
ends

;----------------------------------------------------------------------------
;|	DDEPOKE structure
;|
;|	WM_DDE_POKE parameter structure for hData (LOWORD(lParam)).
;|	 The actual size of this structure depends on the size of
;|	 the Value array.
;|
;----------------------------------------------------------------------------

struc	DDEPOKE
	usFlags 		dw ?
	cfFormat		dw ?
label	Value			byte		; This member was named rgb[1] in previous
						; versions of DDE.H
ends

;----------------------------------------------------------------------------
;The following typedef's were used in previous versions of the Windows SDK.
;They are still valid.	The above typedef's define exactly the same structures
;as those below.  The above typedef names are recommended, however, as they
;are more meaningful.
;
;Note that the DDEPOKE structure typedef'ed in earlier versions of DDE.H did
;not correctly define the bit positions.
;----------------------------------------------------------------------------

struc	DDELN
	usFlags 		dw ?
	cfFormat		dw ?
ends

struc	DDEUP
	usFlags 		dw ?
	cfFormat		dw ?
label	rgb			byte
ends

; Security

procdesc DdeSetQualityOfService :dword, :dword, :dword
procdesc ImpersonateDdeClientWindow :dword, :dword

; DDE message packing APIs

procdesc PackDDElParam :dword, :dword, :dword
procdesc UnpackDDElParam :dword, :dword, :dword, :dword
procdesc FreeDDElParam :dword, :dword
procdesc ReuseDDElParam :dword, :dword, :dword, :dword, :dword
