;***************************************************************************
;*
;*  Copyright (C) 1996-1997 Microsoft Corporation.  All Rights Reserved.
;*
;*  File:	dinput.h
;*  Content:	DirectInput include file
;*
;***************************************************************************

ifndef DIRECTINPUT_VERSION_DEFINED
DIRECTINPUT_VERSION		= 00500h
endif

;***************************************************************************
;*
;*	Class IDs
;*
;***************************************************************************

macro	Define_CLSID_DirectInput
public	CLSID_DirectInput
CLSID_DirectInput	GUID <025E609E0h,0B259h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_CLSID_DirectInputDevice
public	CLSID_DirectInputDevice
CLSID_DirectInputDevice GUID <025E609E1h,0B259h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

;***************************************************************************
;*
;*	Interfaces
;*
;***************************************************************************

macro	Define_IID_IDirectInputA
public	IID_IDirectInputA
IID_IDirectInputA	GUID <089521360h,0AA8Ah,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_IID_IDirectInputW
public	IID_IDirectInputW
IID_IDirectInputW	GUID <089521361h,0AA8Ah,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_IID_IDirectInput2A
public	IID_IDirectInput2A
IID_IDirectInput2A	 GUID <05944E662h,0AA8Ah,011CFh,\
			 0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_IID_IDirectInput2W
public	IID_IDirectInput2W
IID_IDirectInput2W	 GUID <05944E663h,0AA8Ah,011CFh,\
			 0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_IID_IDirectInputDeviceA
public	IID_IDirectInputDeviceA
IID_IDirectInputDeviceA  GUID <05944E680h,0C92Eh,011CFh,\
			 0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_IID_IDirectInputDeviceW
public	IID_IDirectInputDeviceW
IID_IDirectInputDeviceW  GUID <05944E681h,0C92Eh,011CFh,\
			 0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_IID_IDirectInputDevice2A
public	IID_IDirectInputDevice2A
IID_IDirectInputDevice2A GUID <05944E682h,0C92Eh,011CFh,\
			 0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_IID_IDirectInputDevice2W
public	IID_IDirectInputDevice2W
IID_IDirectInputDevice2W GUID <05944E683h,0C92Eh,011CFh,\
			 0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_IID_IDirectInputEffect
public	IID_IDirectInputEffect
IID_IDirectInputEffect	 GUID <0E7E1F7C0h,088D2h,011D0h,\
			 09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

;***************************************************************************
;*
;*	Predefined object types
;*
;***************************************************************************

macro	Define_GUID_XAxis
public	GUID_XAxis
GUID_XAxis		GUID <0A36D02E0h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_YAxis
public	GUID_YAxis
GUID_YAxis		GUID <0A36D02E1h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_ZAxis
public	GUID_ZAxis
GUID_ZAxis		GUID <0A36D02E2h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_RxAxis
public	GUID_RxAxis
GUID_RxAxis		GUID <0A36D02F4h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_RyAxis
public	GUID_RyAxis
GUID_RyAxis		GUID <0A36D02F5h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_RzAxis
public	GUID_RzAxis
GUID_RzAxis		GUID <0A36D02E3h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_Slider
public	GUID_Slider
GUID_Slider		GUID <0A36D02E4h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_Button
public	GUID_Button
GUID_Button		GUID <0A36D02F0h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_Key
public	GUID_Key
GUID_Key		GUID <055728220h,0D33Ch,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_POV
public	GUID_POV
GUID_POV		GUID <0A36D02F2h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h
endm

macro	Define_GUID_Unknown
public	GUID_Unknown
GUID_Unknown		GUID <0A36D02F3h,0C9F3h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

;***************************************************************************
;*
;*	Predefined product GUIDs
;*
;***************************************************************************

macro	Define_GUID_SysMouse
public	GUID_SysMouse
GUID_SysMouse		GUID <06F1D2B60h,0D5A0h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_SysKeyboard
public	GUID_SysKeyboard
GUID_SysKeyboard	GUID <06F1D2B61h,0D5A0h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

macro	Define_GUID_Joystick
public	GUID_Joystick
GUID_Joystick		GUID <06F1D2B70h,0D5A0h,011CFh,\
			0BFh,0C7h,044h,045h,053h,054h,000h,000h>
endm

;***************************************************************************
;*
;*	Predefined force feedback effects
;*
;***************************************************************************

macro	Define_GUID_ConstantForce
public	GUID_ConstantForce
GUID_ConstantForce	GUID <013541C20h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_RampForce
public	GUID_RampForce
GUID_RampForce		GUID <013541C21h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_Square
public	GUID_Square
GUID_Square		GUID <013541C22h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_Sine
public	GUID_Sine
GUID_Sine		GUID <013541C23h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_Triangle
public	GUID_Triangle
GUID_Triangle		GUID <013541C24h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_SawtoothUp
public	GUID_SawtoothUp
GUID_SawtoothUp 	GUID <013541C25h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_SawtoothDown
public	GUID_SawtoothDown
GUID_SawtoothDown	GUID <013541C26h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_Spring
public	GUID_Spring
GUID_Spring		GUID <013541C27h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_Damper
public	GUID_Damper
GUID_Damper		GUID <013541C28h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_Inertia
public	GUID_Inertia
GUID_Inertia		GUID <013541C29h,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_Friction
public	GUID_Friction
GUID_Friction		GUID <013541C2Ah,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

macro	Define_GUID_CustomForce
public	GUID_CustomForce
GUID_CustomForce	GUID <013541C2Bh,08E33h,011D0h,\
			09Ah,0D0h,000h,0A0h,0C9h,0A0h,06Eh,035h>
endm

;***************************************************************************
;*
;*	Interfaces and Structures...
;*
;***************************************************************************

;***************************************************************************
;*
;*	IDirectInputEffect
;*
;***************************************************************************

DIEFT_ALL			= 000000000h

DIEFT_CONSTANTFORCE		= 000000001h
DIEFT_RAMPFORCE 		= 000000002h
DIEFT_PERIODIC			= 000000003h
DIEFT_CONDITION 		= 000000004h
DIEFT_CUSTOMFORCE		= 000000005h
DIEFT_HARDWARE			= 0000000FFh

DIEFT_FFATTACK			= 000000200h
DIEFT_FFFADE			= 000000400h
DIEFT_SATURATION		= 000000800h
DIEFT_POSNEGCOEFFICIENTS	= 000001000h
DIEFT_POSNEGSATURATION		= 000002000h
DIEFT_DEADBAND			= 000004000h

DI_DEGREES			= 100
DI_FFNOMINALMAX 		= 10000
DI_SECONDS			= 1000000

struc	DICONSTANTFORCE
	lMagnitude		dd ?
ends

struc	DIRAMPFORCE
	lStart			dd ?
	lEnd			dd ?
ends

struc	DIPERIODIC
	dwMagnitude		dd ?
	lOffset 		dd ?
	dwPhase 		dd ?
	dwPeriod		dd ?
ends

struc	DICONDITION
	lOffset 		dd ?
	lPositiveCoefficient	dd ?
	lNegativeCoefficient	dd ?
	dwPositiveSaturation	dd ?
	dwNegativeSaturation	dd ?
	lDeadBand		dd ?
ends

struc	DICUSTOMFORCE
	cChannels		dd ?
	dwSamplePeriod		dd ?
	cSamples		dd ?
	rglForceData		dd ?
ends

struc	DIENVELOPE
	dwSize			dd ?		; sizeof(DIENVELOPE)
	dwAttackLevel		dd ?
	dwAttackTime		dd ?		; Microseconds
	dwFadeLevel		dd ?
	dwFadeTime		dd ?		; Microseconds
ends

struc	DIEFFECT
	dwSize			dd ?		; sizeof(DIEFFECT)
	dwFlags 		dd ?		; DIEFF_*
	dwDuration		dd ?		; Microseconds
	dwSamplePeriod		dd ?		; Microseconds
	dwGain			dd ?
	dwTriggerButton 	dd ?		; or DIEB_NOTRIGGER
	dwTriggerRepeatInterval dd ?		; Microseconds
	cAxes			dd ?		; Number of axes
	rgdwAxes		dd ?		; Array of axes
	rglDirection		dd ?		; Array of directions
	lpEnvelope		dd ?		; Optional
	cbTypeSpecificParams	dd ?		; Size of params
	lpvTypeSpecificParams	dd ?		; Pointer to params
ends

DIEFF_OBJECTIDS 		= 000000001h
DIEFF_OBJECTOFFSETS		= 000000002h
DIEFF_CARTESIAN 		= 000000010h
DIEFF_POLAR			= 000000020h
DIEFF_SPHERICAL 		= 000000040h

DIEP_DURATION			= 000000001h
DIEP_SAMPLEPERIOD		= 000000002h
DIEP_GAIN			= 000000004h
DIEP_TRIGGERBUTTON		= 000000008h
DIEP_TRIGGERREPEATINTERVAL	= 000000010h
DIEP_AXES			= 000000020h
DIEP_DIRECTION			= 000000040h
DIEP_ENVELOPE			= 000000080h
DIEP_TYPESPECIFICPARAMS 	= 000000100h
DIEP_ALLPARAMS			= 0000001FFh
DIEP_START			= 020000000h
DIEP_NORESTART			= 040000000h
DIEP_NODOWNLOAD 		= 080000000h
DIEB_NOTRIGGER			= 0FFFFFFFFh

DIES_SOLO			= 000000001h
DIES_NODOWNLOAD 		= 080000000h

DIEGES_PLAYING			= 000000001h
DIEGES_EMULATED 		= 000000002h

struc	DIEFFESCAPE
	dwSize			dd ?
	dwCommand		dd ?
	lpvInBuffer		dd ?
	cbInBuffer		dd ?
	lpvOutBuffer		dd ?
	cbOutBuffer		dd ?
ends

struc	IDirectInputEffect
;** IUnknown methods **
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
;** IDirectInputEffect methods **
	Initialize		dd ?
	GetEffectGuid		dd ?
	GetParameters		dd ?
	SetParameters		dd ?
	Start			dd ?
	Stop			dd ?
	GetEffectStatus 	dd ?
	Download		dd ?
	Unload			dd ?
	Escape			dd ?
ends

;***************************************************************************
;*
;*	IDirectInputDevice
;*
;***************************************************************************

DIDEVTYPE_DEVICE		= 1
DIDEVTYPE_MOUSE 		= 2
DIDEVTYPE_KEYBOARD		= 3
DIDEVTYPE_JOYSTICK		= 4
DIDEVTYPE_HID			= 000010000h

DIDEVTYPEMOUSE_UNKNOWN		= 1
DIDEVTYPEMOUSE_TRADITIONAL	= 2
DIDEVTYPEMOUSE_FINGERSTICK	= 3
DIDEVTYPEMOUSE_TOUCHPAD 	= 4
DIDEVTYPEMOUSE_TRACKBALL	= 5

DIDEVTYPEKEYBOARD_UNKNOWN	= 0
DIDEVTYPEKEYBOARD_PCXT		= 1
DIDEVTYPEKEYBOARD_OLIVETTI	= 2
DIDEVTYPEKEYBOARD_PCAT		= 3
DIDEVTYPEKEYBOARD_PCENH 	= 4
DIDEVTYPEKEYBOARD_NOKIA1050	= 5
DIDEVTYPEKEYBOARD_NOKIA9140	= 6
DIDEVTYPEKEYBOARD_NEC98 	= 7
DIDEVTYPEKEYBOARD_NEC98LAPTOP	= 8
DIDEVTYPEKEYBOARD_NEC98106	= 9
DIDEVTYPEKEYBOARD_JAPAN106	= 10
DIDEVTYPEKEYBOARD_JAPANAX	= 11
DIDEVTYPEKEYBOARD_J3100 	= 12

DIDEVTYPEJOYSTICK_UNKNOWN	= 1
DIDEVTYPEJOYSTICK_TRADITIONAL	= 2
DIDEVTYPEJOYSTICK_FLIGHTSTICK	= 3
DIDEVTYPEJOYSTICK_GAMEPAD	= 4
DIDEVTYPEJOYSTICK_RUDDER	= 5
DIDEVTYPEJOYSTICK_WHEEL 	= 6
DIDEVTYPEJOYSTICK_HEADTRACKER	= 7

if DIRECTINPUT_VERSION ge 0500h
; This structure is defined for DirectX 3.0 compatibility

struc	DIDEVCAPS_DX3
	dwSize			dd ?
	dwFlags 		dd ?
	dwDevType		dd ?
	dwAxes			dd ?
	dwButtons		dd ?
	dwPOVs			dd ?
ends

endif ; DIRECTINPUT_VERSION ge 0500h

struc	DIDEVCAPS
	dwSize			dd ?
	dwFlags 		dd ?
	dwDevType		dd ?
	dwAxes			dd ?
	dwButtons		dd ?
	dwPOVs			dd ?
if DIRECTINPUT_VERSION ge 0500h
	dwFFSamplePeriod	dd ?
	dwFFMinTimeResolution	dd ?
	dwFirmwareRevision	dd ?
	dwHardwareRevision	dd ?
	dwFFDriverVersion	dd ?
endif ; DIRECTINPUT_VERSION ge 0500h
ends

DIDC_ATTACHED			= 000000001h
DIDC_POLLEDDEVICE		= 000000002h
DIDC_EMULATED			= 000000004h
DIDC_POLLEDDATAFORMAT		= 000000008h
DIDC_FORCEFEEDBACK		= 000000100h
DIDC_FFATTACK			= 000000200h
DIDC_FFFADE			= 000000400h
DIDC_SATURATION 		= 000000800h
DIDC_POSNEGCOEFFICIENTS 	= 000001000h
DIDC_POSNEGSATURATION		= 000002000h
DIDC_DEADBAND			= 000004000h

DIDFT_ALL			= 000000000h

DIDFT_RELAXIS			= 000000001h
DIDFT_ABSAXIS			= 000000002h
DIDFT_AXIS			= 000000003h

DIDFT_PSHBUTTON 		= 000000004h
DIDFT_TGLBUTTON 		= 000000008h
DIDFT_BUTTON			= 00000000Ch

DIDFT_POV			= 000000010h

DIDFT_COLLECTION		= 000000040h
DIDFT_NODATA			= 000000080h

DIDFT_ANYINSTANCE		= 000FFFF00h
DIDFT_INSTANCEMASK		= DIDFT_ANYINSTANCE
DIDFT_FFACTUATOR		= 001000000h
DIDFT_FFEFFECTTRIGGER		= 002000000h

DIDFT_NOCOLLECTION		= 000FFFF00h

struc	DIOBJECTDATAFORMAT
	pguid			dd ?
	dwOfs			dd ?
	dwType			dd ?
	dwFlags 		dd ?
ends

struc	DIDATAFORMAT
	dwSize			dd ?
	dwObjSize		dd ?
	dwFlags 		dd ?
	dwDataSize		dd ?
	dwNumObjs		dd ?
	rgodf			dd ?
ends

DIDF_ABSAXIS			= 000000001h
DIDF_RELAXIS			= 000000002h

extrn c_dfDIMouse	:DIDATAFORMAT
extrn c_dfDIKeyboard	:DIDATAFORMAT
extrn c_dfDIJoystick	:DIDATAFORMAT
extrn c_dfDIJoystick2	:DIDATAFORMAT

if DIRECTINPUT_VERSION ge 0500h
; This structure is defined for DirectX 3.0 compatibility

struc	DIDEVICEOBJECTINSTANCE_DX3
	dwSize			dd ?
	guidType		GUID ?
	dwOfs			dd ?
	dwType			dd ?
	dwFlags 		dd ?
	tszName 		db MAX_PATH dup (?)
ends

endif ; DIRECTINPUT_VERSION ge 0500h

struc	DIDEVICEOBJECTINSTANCE
	dwSize			dd ?
	guidType		GUID ?
	dwOfs			dd ?
	dwType			dd ?
	dwFlags 		dd ?
	tszName 		db MAX_PATH dup (?)
if DIRECTINPUT_VERSION ge 0500h
	dwFFMaxForce		dd ?
	dwFFForceResolution	dd ?
	wCollectionNumber	dw ?
	wDesignatorIndex	dw ?
	wUsagePage		dw ?
	wUsage			dw ?
	dwDimension		dd ?
	wExponent		dw ?
	wReserved		dw ?
endif ; DIRECTINPUT_VERSION ge 0500h
ends

proctype DIENUMDEVICEOBJECTSCALLBACK :dword, :dword

DIDOI_FFACTUATOR		= 000000001h
DIDOI_FFEFFECTTRIGGER		= 000000002h
DIDOI_POLLED			= 000008000h
DIDOI_ASPECTPOSITION		= 000000100h
DIDOI_ASPECTVELOCITY		= 000000200h
DIDOI_ASPECTACCEL		= 000000300h
DIDOI_ASPECTFORCE		= 000000400h
DIDOI_ASPECTMASK		= 000000F00h

struc	DIPROPHEADER
	dwSize			dd ?
	dwHeaderSize		dd ?
	dwObj			dd ?
	dwHow			dd ?
ends

DIPH_DEVICE			= 0
DIPH_BYOFFSET			= 1
DIPH_BYID			= 2

struc	DIPROPDWORD
	diph			DIPROPHEADER ?
	dwData			dd ?
ends

struc	DIPROPRANGE
	diph			DIPROPHEADER ?
	lMin			dd ?
	lMax			dd ?
ends

DIPROPRANGE_NOMIN		= (080000000h)
DIPROPRANGE_NOMAX		= (07FFFFFFFh)

DIPROP_BUFFERSIZE		= 1
DIPROP_AXISMODE 		= 2

DIPROPAXISMODE_ABS		= 0
DIPROPAXISMODE_REL		= 1

DIPROP_GRANULARITY		= 3
DIPROP_RANGE			= 4
DIPROP_DEADZONE 		= 5
DIPROP_SATURATION		= 6
DIPROP_FFGAIN			= 7
DIPROP_FFLOAD			= 8
DIPROP_AUTOCENTER		= 9

DIPROPAUTOCENTER_OFF		= 0
DIPROPAUTOCENTER_ON		= 1

DIPROP_CALIBRATIONMODE		= 10

DIPROPCALIBRATIONMODE_COOKED	= 0
DIPROPCALIBRATIONMODE_RAW	= 1

struc	DIDEVICEOBJECTDATA
	dwOfs			dd ?
	dwData			dd ?
	dwTimeStamp		dd ?
	dwSequence		dd ?
ends

DIGDD_PEEK			= 000000001h

DISCL_EXCLUSIVE 		= 000000001h
DISCL_NONEXCLUSIVE		= 000000002h
DISCL_FOREGROUND		= 000000004h
DISCL_BACKGROUND		= 000000008h

if DIRECTINPUT_VERSION ge 0500h
; This structure is defined for DirectX 3.0 compatibility

struc	DIDEVICEINSTANCE_DX3
	dwSize			dd ?
	guidInstance		GUID ?
	guidProduct		GUID ?
	dwDevType		dd ?
	tszInstanceName 	db MAX_PATH dup (?)
	tszProductName		db MAX_PATH dup (?)
ends

endif ; DIRECTINPUT_VERSION ge 0500h

struc	DIDEVICEINSTANCE
	dwSize			dd ?
	guidInstance		GUID ?
	guidProduct		GUID ?
	dwDevType		dd ?
	tszInstanceName 	db MAX_PATH dup (?)
	tszProductName		db MAX_PATH dup (?)
if DIRECTINPUT_VERSION ge 0500h
	guidFFDriver		GUID ?
	wUsagePage		dw ?
	wUsage			dw ?
endif ; DIRECTINPUT_VERSION ge 0500h
ends

struc	IDirectInputDeviceW
;** IUnknown methods **
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
;** IDirectInputDeviceW methods **
	GetCapabilities 	dd ?
	EnumObjects		dd ?
	GetProperty		dd ?
	SetProperty		dd ?
	Acquire 		dd ?
	Unacquire		dd ?
	GetDeviceState		dd ?
	GetDeviceData		dd ?
	SetDataFormat		dd ?
	SetEventNotification	dd ?
	SetCooperativeLevel	dd ?
	GetObjectInfo		dd ?
	GetDeviceInfo		dd ?
	RunControlPanel 	dd ?
	Initialize		dd ?
;** IDirectInputDevice2W methods **
	CreateEffect		dd ?
	EnumEffects		dd ?
	GetEffectInfo		dd ?
	GetForceFeedbackState	dd ?
	SendForceFeedbackCommand dd ?
	EnumCreatedEffectObjects dd ?
	Escape			dd ?
	Poll			dd ?
	SendDeviceData		dd ?
ends

typedef IDirectInputDevice2W	IDirectInputDeviceW
typedef IDirectInputDeviceA	IDirectInputDeviceW
typedef IDirectInputDevice2A	IDirectInputDeviceW

proctype DIENUMEFFECTSCALLBACK :dword, :dword
proctype DIENUMCREATEDEFFECTOBJECTSCALLBACK :dword, :dword

DISFFC_RESET			= 000000001h
DISFFC_STOPALL			= 000000002h
DISFFC_PAUSE			= 000000004h
DISFFC_CONTINUE 		= 000000008h
DISFFC_SETACTUATORSON		= 000000010h
DISFFC_SETACTUATORSOFF		= 000000020h

DIGFFS_EMPTY			= 000000001h
DIGFFS_STOPPED			= 000000002h
DIGFFS_PAUSED			= 000000004h
DIGFFS_ACTUATORSON		= 000000010h
DIGFFS_ACTUATORSOFF		= 000000020h
DIGFFS_POWERON			= 000000040h
DIGFFS_POWEROFF 		= 000000080h
DIGFFS_SAFETYSWITCHON		= 000000100h
DIGFFS_SAFETYSWITCHOFF		= 000000200h
DIGFFS_USERFFSWITCHON		= 000000400h
DIGFFS_USERFFSWITCHOFF		= 000000800h
DIGFFS_DEVICELOST		= 080000000h

struc	DIEFFECTINFO
	dwSize			dd ?
	guid			GUID ?
	dwEffType		dd ?
	dwStaticParams		dd ?
	dwDynamicParams 	dd ?
	tszName 		db MAX_PATH dup (?)
ends

;***************************************************************************
;*
;*	Mouse
;*
;***************************************************************************

struc	DIMOUSESTATE
	lX			dd ?
	lY			dd ?
	lZ			dd ?
	rgbButtons		db 4 dup (?)
ends

;***************************************************************************
;*
;*	Keyboard
;*
;***************************************************************************

;***************************************************************************
;*
;*	DirectInput keyboard scan codes
;*
;***************************************************************************

DIK_ESCAPE			= 001h
DIK_1				= 002h
DIK_2				= 003h
DIK_3				= 004h
DIK_4				= 005h
DIK_5				= 006h
DIK_6				= 007h
DIK_7				= 008h
DIK_8				= 009h
DIK_9				= 00Ah
DIK_0				= 00Bh
DIK_MINUS			= 00Ch	  ; - on main keyboard
DIK_EQUALS			= 00Dh
DIK_BACK			= 00Eh	  ; backspace
DIK_TAB 			= 00Fh
DIK_Q				= 010h
DIK_W				= 011h
DIK_E				= 012h
DIK_R				= 013h
DIK_T				= 014h
DIK_Y				= 015h
DIK_U				= 016h
DIK_I				= 017h
DIK_O				= 018h
DIK_P				= 019h
DIK_LBRACKET			= 01Ah
DIK_RBRACKET			= 01Bh
DIK_RETURN			= 01Ch	  ; Enter on main keyboard
DIK_LCONTROL			= 01Dh
DIK_A				= 01Eh
DIK_S				= 01Fh
DIK_D				= 020h
DIK_F				= 021h
DIK_G				= 022h
DIK_H				= 023h
DIK_J				= 024h
DIK_K				= 025h
DIK_L				= 026h
DIK_SEMICOLON			= 027h
DIK_APOSTROPHE			= 028h
DIK_GRAVE			= 029h	  ; accent grave
DIK_LSHIFT			= 02Ah
DIK_BACKSLASH			= 02Bh
DIK_Z				= 02Ch
DIK_X				= 02Dh
DIK_C				= 02Eh
DIK_V				= 02Fh
DIK_B				= 030h
DIK_N				= 031h
DIK_M				= 032h
DIK_COMMA			= 033h
DIK_PERIOD			= 034h	  ; . on main keyboard
DIK_SLASH			= 035h	  ; / on main keyboard
DIK_RSHIFT			= 036h
DIK_MULTIPLY			= 037h	  ; * on numeric keypad
DIK_LMENU			= 038h	  ; left Alt
DIK_SPACE			= 039h
DIK_CAPITAL			= 03Ah
DIK_F1				= 03Bh
DIK_F2				= 03Ch
DIK_F3				= 03Dh
DIK_F4				= 03Eh
DIK_F5				= 03Fh
DIK_F6				= 040h
DIK_F7				= 041h
DIK_F8				= 042h
DIK_F9				= 043h
DIK_F10 			= 044h
DIK_NUMLOCK			= 045h
DIK_SCROLL			= 046h	  ; Scroll Lock
DIK_NUMPAD7			= 047h
DIK_NUMPAD8			= 048h
DIK_NUMPAD9			= 049h
DIK_SUBTRACT			= 04Ah	  ; - on numeric keypad
DIK_NUMPAD4			= 04Bh
DIK_NUMPAD5			= 04Ch
DIK_NUMPAD6			= 04Dh
DIK_ADD 			= 04Eh	  ; + on numeric keypad
DIK_NUMPAD1			= 04Fh
DIK_NUMPAD2			= 050h
DIK_NUMPAD3			= 051h
DIK_NUMPAD0			= 052h
DIK_DECIMAL			= 053h	  ; . on numeric keypad
DIK_F11 			= 057h
DIK_F12 			= 058h

DIK_F13 			= 064h	  ;			(NEC PC98)
DIK_F14 			= 065h	  ;			(NEC PC98)
DIK_F15 			= 066h	  ;			(NEC PC98)

DIK_KANA			= 070h	  ; (Japanese keyboard)
DIK_CONVERT			= 079h	  ; (Japanese keyboard)
DIK_NOCONVERT			= 07Bh	  ; (Japanese keyboard)
DIK_YEN 			= 07Dh	  ; (Japanese keyboard)
DIK_NUMPADEQUALS		= 08Dh	  ; = on numeric keypad (NEC PC98)
DIK_CIRCUMFLEX			= 090h	  ; (Japanese keyboard)
DIK_AT				= 091h	  ;			(NEC PC98)
DIK_COLON			= 092h	  ;			(NEC PC98)
DIK_UNDERLINE			= 093h	  ;			(NEC PC98)
DIK_KANJI			= 094h	  ; (Japanese keyboard)
DIK_STOP			= 095h	  ;			(NEC PC98)
DIK_AX				= 096h	  ;			(Japan AX)
DIK_UNLABELED			= 097h	  ;			   (J3100)
DIK_NUMPADENTER 		= 09Ch	  ; Enter on numeric keypad
DIK_RCONTROL			= 09Dh
DIK_NUMPADCOMMA 		= 0B3h	  ; , on numeric keypad (NEC PC98)
DIK_DIVIDE			= 0B5h	  ; / on numeric keypad
DIK_SYSRQ			= 0B7h
DIK_RMENU			= 0B8h	  ; right Alt
DIK_HOME			= 0C7h	  ; Home on arrow keypad
DIK_UP				= 0C8h	  ; UpArrow on arrow keypad
DIK_PRIOR			= 0C9h	  ; PgUp on arrow keypad
DIK_LEFT			= 0CBh	  ; LeftArrow on arrow keypad
DIK_RIGHT			= 0CDh	  ; RightArrow on arrow keypad
DIK_END 			= 0CFh	  ; End on arrow keypad
DIK_DOWN			= 0D0h	  ; DownArrow on arrow keypad
DIK_NEXT			= 0D1h	  ; PgDn on arrow keypad
DIK_INSERT			= 0D2h	  ; Insert on arrow keypad
DIK_DELETE			= 0D3h	  ; Delete on arrow keypad
DIK_LWIN			= 0DBh	  ; Left Windows key
DIK_RWIN			= 0DCh	  ; Right Windows key
DIK_APPS			= 0DDh	  ; AppMenu key

;
;  Alternate names for keys, to facilitate transition from DOS.
;
DIK_BACKSPACE			= DIK_BACK	      ; backspace
DIK_NUMPADSTAR			= DIK_MULTIPLY	      ; * on numeric keypad
DIK_LALT			= DIK_LMENU	      ; left Alt
DIK_CAPSLOCK			= DIK_CAPITAL	      ; CapsLock
DIK_NUMPADMINUS 		= DIK_SUBTRACT	      ; - on numeric keypad
DIK_NUMPADPLUS			= DIK_ADD	      ; + on numeric keypad
DIK_NUMPADPERIOD		= DIK_DECIMAL	      ; . on numeric keypad
DIK_NUMPADSLASH 		= DIK_DIVIDE	      ; / on numeric keypad
DIK_RALT			= DIK_RMENU	      ; right Alt
DIK_UPARROW			= DIK_UP	      ; UpArrow on arrow keypad
DIK_PGUP			= DIK_PRIOR	      ; PgUp on arrow keypad
DIK_LEFTARROW			= DIK_LEFT	      ; LeftArrow on arrow keypad
DIK_RIGHTARROW			= DIK_RIGHT	      ; RightArrow on arrow keypad
DIK_DOWNARROW			= DIK_DOWN	      ; DownArrow on arrow keypad
DIK_PGDN			= DIK_NEXT	      ; PgDn on arrow keypad

;***************************************************************************
;*
;*	Joystick
;*
;***************************************************************************

struc	DIJOYSTATE
	lX			dd ?		; x-axis position
	lY			dd ?		; y-axis position
	lZ			dd ?		; z-axis position
	lRx			dd ?		; x-axis rotation
	lRy			dd ?		; y-axis rotation
	lRz			dd ?		; z-axis rotation
	rglSlider		dd 2 dup (?)	; extra axes positions
	rgdwPOV 		dd 4 dup (?)	; POV directions
	rgbButtons		db 32 dup (?)	; 32 buttons
ends

struc	DIJOYSTATE2
	lX			dd ?		; x-axis position
	lY			dd ?		; y-axis position
	lZ			dd ?		; z-axis position
	lRx			dd ?		; x-axis rotation
	lRy			dd ?		; y-axis rotation
	lRz			dd ?		; z-axis rotation
	rglSlider		dd 2 dup (?)	; extra axes positions
	rgdwPOV 		dd 4 dup (?)	; POV directions
	rgbButtons		db 128 dup (?)	; 128 buttons
	lVX			dd ?		; x-axis velocity
	lVY			dd ?		; y-axis velocity
	lVZ			dd ?		; z-axis velocity
	lVRx			dd ?		; x-axis angular velocity
	lVRy			dd ?		; y-axis angular velocity
	lVRz			dd ?		; z-axis angular velocity
	rglVSlider		dd 2 dup (?)	; extra axes velocities
	lAX			dd ?		; x-axis acceleration
	lAY			dd ?		; y-axis acceleration
	lAZ			dd ?		; z-axis acceleration
	lARx			dd ?		; x-axis angular acceleration
	lARy			dd ?		; y-axis angular acceleration
	lARz			dd ?		; z-axis angular acceleration
	rglASlider		dd 2 dup (?)	; extra axes accelerations
	lFX			dd ?		; x-axis force
	lFY			dd ?		; y-axis force
	lFZ			dd ?		; z-axis force
	lFRx			dd ?		; x-axis torque
	lFRy			dd ?		; y-axis torque
	lFRz			dd ?		; z-axis torque
	rglFSlider		dd 2 dup (?)	; extra axes forces
ends

;***************************************************************************
;*
;*  IDirectInput
;*
;***************************************************************************

DIENUM_STOP			= 0
DIENUM_CONTINUE 		= 1

proctype DIENUMDEVICESCALLBACK :dword, :dword

DIEDFL_ALLDEVICES		= 000000000h
DIEDFL_ATTACHEDONLY		= 000000001h
DIEDFL_FORCEFEEDBACK		= 000000100h

struc	IDirectInputW
;** IUnknown methods **
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
;** IDirectInputW methods **
	CreateDevice		dd ?
	EnumDevices		dd ?
	GetDeviceStatus 	dd ?
	RunControlPanel 	dd ?
	Initialize		dd ?
;** IDirectInput2W methods **
	FindDevice		dd ?
ends

typedef IDirectInput2W		IDirectInputW
typedef IDirectInputA		IDirectInputW
typedef IDirectInput2A		IDirectInputW

procdesc DirectInputCreateA :dword, :dword, :dword, :dword

DirectInputCreate		equ <DirectInputCreateA>

;***************************************************************************
;*
;*  Return Codes
;*
;***************************************************************************

DI_OK				= S_OK
DI_NOTATTACHED			= S_FALSE
DI_BUFFEROVERFLOW		= S_FALSE
DI_PROPNOEFFECT 		= S_FALSE
DI_NOEFFECT			= S_FALSE
DI_POLLEDDEVICE 		= (000000002h)
DI_DOWNLOADSKIPPED		= (000000003h)
DI_EFFECTRESTARTED		= (000000004h)
DI_TRUNCATED			= (000000008h)
DIERR_OLDDIRECTINPUTVERSION	= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_OLD_WIN_VERSION)
DIERR_BETADIRECTINPUTVERSION	= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_RMODE_APP)
DIERR_BADDRIVERVER		= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_BAD_DRIVER_LEVEL)
DIERR_DEVICENOTREG		= REGDB_E_CLASSNOTREG
DIERR_NOTFOUND			= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_FILE_NOT_FOUND)
DIERR_OBJECTNOTFOUND		= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_FILE_NOT_FOUND)
DIERR_INVALIDPARAM		= E_INVALIDARG
DIERR_NOINTERFACE		= E_NOINTERFACE
DIERR_GENERIC			= E_FAIL
DIERR_OUTOFMEMORY		= E_OUTOFMEMORY
DIERR_UNSUPPORTED		= E_NOTIMPL
DIERR_NOTINITIALIZED		= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_NOT_READY)
DIERR_ALREADYINITIALIZED	= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_ALREADY_INITIALIZED)
DIERR_NOAGGREGATION		= CLASS_E_NOAGGREGATION
DIERR_OTHERAPPHASPRIO		= E_ACCESSDENIED
DIERR_INPUTLOST 		= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_READ_FAULT)
DIERR_ACQUIRED			= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_BUSY)
DIERR_NOTACQUIRED		= \
    (80000000h + (FACILITY_WIN32 shl 16) + ERROR_INVALID_ACCESS)
DIERR_READONLY			= E_ACCESSDENIED
DIERR_HANDLEEXISTS		= E_ACCESSDENIED
E_PENDING			= 080070007h
DIERR_INSUFFICIENTPRIVS 	= 080040200h
DIERR_DEVICEFULL		= 080040201h
DIERR_MOREDATA			= 080040202h
DIERR_NOTDOWNLOADED		= 080040203h
DIERR_HASEFFECTS		= 080040204h
DIERR_NOTEXCLUSIVEACQUIRED	= 080040205h
DIERR_INCOMPLETEEFFECT		= 080040206h
DIERR_NOTBUFFERED		= 080040207h
DIERR_EFFECTPLAYING		= 080040208h

;***************************************************************************
;*
;*  Definitions for non-IDirectInput (VJoyD) features defined more recently
;*  than the current sdk files
;*
;***************************************************************************

procdesc joyConfigChanged :dword

JOY_PASSDRIVERDATA		= 010000000h
JOY_HWS_ISHEADTRACKER		= 002000000h
JOY_HWS_ISGAMEPORTDRIVER	= 004000000h
JOY_HWS_ISANALOGPORTDRIVER	= 008000000h
JOY_HWS_AUTOLOAD		= 010000000h
JOY_HWS_NODEVNODE		= 020000000h
JOY_HWS_ISGAMEPORTEMULATOR	= 040000000h
JOY_US_VOLATILE 		= 000000008h

;***************************************************************************
;*
;*  Definitions for non-IDirectInput (VJoyD) features defined more recently
;*  than the current ddk files
;*
;***************************************************************************

JOY_OEMPOLL_PASSDRIVERDATA	= 7
