;==========================================================================;
;*
;*  Copyright (C) 1995,1996 Microsoft Corporation.  All Rights Reserved.
;*
;*  File:	dsound.h
;*  Content:	DirectSound include file
;*
;*************************************************************************

ifndef NODSOUND3D
include "d3dtypes.inc"
endif

_FACDS				= 0878h

; Direct Sound Component GUID {47D4D946-62E8-11cf-93BC-444553540000}

macro	Define_CLSID_DirectSound
public	CLSID_DirectSound
CLSID_DirectSound	GUID <047d4d946h, 062e8h, 011cfh,\
			093h, 0bch, 044h, 045h, 053h, 054h, 00h, 00h>
endm

; DirectSound Capture Component GUID {B0210780-89CD-11d0-AF08-00A0C925CD16}

macro	Define_CLSID_DirectSoundCapture
public	CLSID_DirectSoundCapture
CLSID_DirectSoundCapture GUID <0b0210780h, 089cdh, 011d0h,\
			0afh, 08h, 00h, 0a0h, 0c9h, 025h, 0cdh, 016h>
endm

struc	DSCAPS
	dwSize			dd ?
	dwFlags 		dd ?
	dwMinSecondarySampleRate dd ?
	dwMaxSecondarySampleRate dd ?
	dwPrimaryBuffers	dd ?
	dwMaxHwMixingAllBuffers dd ?
	dwMaxHwMixingStaticBuffers dd ?
	dwMaxHwMixingStreamingBuffers dd ?
	dwFreeHwMixingAllBuffers dd ?
	dwFreeHwMixingStaticBuffers dd ?
	dwFreeHwMixingStreamingBuffers dd ?
	dwMaxHw3DAllBuffers	dd ?
	dwMaxHw3DStaticBuffers	dd ?
	dwMaxHw3DStreamingBuffers dd ?
	dwFreeHw3DAllBuffers	dd ?
	dwFreeHw3DStaticBuffers dd ?
	dwFreeHw3DStreamingBuffers dd ?
	dwTotalHwMemBytes	dd ?
	dwFreeHwMemBytes	dd ?
	dwMaxContigFreeHwMemBytes dd ?
	dwUnlockTransferRateHwBuffers dd ?
	dwPlayCpuOverheadSwBuffers dd ?
	dwReserved1		dd ?
	dwReserved2		dd ?
ends

struc	DSBCAPS
	dwSize			dd ?
	dwFlags 		dd ?
	dwBufferBytes		dd ?
	dwUnlockTransferRate	dd ?
	dwPlayCpuOverhead	dd ?
ends

struc	DSBUFFERDESC
	dwSize			dd ?
	dwFlags 		dd ?
	dwBufferBytes		dd ?
	dwReserved		dd ?
	lpwfxFormat		dd ?
ends

ifndef NODSOUND3D

struc	DS3DBUFFER
	dwSize			dd ?
	vPosition		D3DVECTOR ?
	vVelocity		D3DVECTOR ?
	dwInsideConeAngle	dd ?
	dwOutsideConeAngle	dd ?
	vConeOrientation	D3DVECTOR ?
	lConeOutsideVolume	dd ?
	flMinDistance		D3DVALUE ?
	flMaxDistance		D3DVALUE ?
	dwMode			dd ?
ends

struc	DS3DLISTENER
	dwSize			dd ?
	vPosition		D3DVECTOR ?
	vVelocity		D3DVECTOR ?
	vOrientFront		D3DVECTOR ?
	vOrientTop		D3DVECTOR ?
	flDistanceFactor	D3DVALUE ?
	flRolloffFactor 	D3DVALUE ?
	flDopplerFactor 	D3DVALUE ?
ends

endif

struc	DSCCAPS
	dwSize			dd ?
	dwFlags 		dd ?
	dwFormats		dd ?
	dwChannels		dd ?
ends

struc	DSCBUFFERDESC
	dwSize			dd ?
	dwFlags 		dd ?
	dwBufferBytes		dd ?
	dwReserved		dd ?
	lpwfxFormat		dd ?
ends

struc	DSCBCAPS
	dwSize			dd ?
	dwFlags 		dd ?
	dwBufferBytes		dd ?
	dwReserved		dd ?
ends

struc	DSBPOSITIONNOTIFY
	dwOffset		dd ?
	hEventNotify		dd ?
ends

;
; DirectSound API
;

proctype DSENUMCALLBACK :dword, :dword, :dword, :dword

procdesc DirectSoundCreate :dword, :dword, :dword
procdesc DirectSoundEnumerateA :dword, :dword
procdesc DirectSoundCaptureCreate :dword, :dword, :dword
procdesc DirectSoundCaptureEnumerateA :dword, :dword

DirectSoundEnumerate		equ <DirectSoundEnumerateA>
DirectSoundCaptureEnumerate	equ <DirectSoundCaptureEnumerateA>

;
; IDirectSound
;

macro	Define_IID_IDirectSound
public	IID_IDirectSound
IID_IDirectSound	GUID <0279AFA83h, 04981h, 011CEh,\
			0A5h, 021h, 000h, 020h, 0AFh, 00Bh, 0E5h, 060h>
endm

struc	IDirectSound
; IUnknown methods
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; IDirectSound methods
	CreateSoundBuffer	dd ?
	GetCaps 		dd ?
	DuplicateSoundBuffer	dd ?
	SetCooperativeLevel	dd ?
	Compact 		dd ?
	GetSpeakerConfig	dd ?
	SetSpeakerConfig	dd ?
	Initialize		dd ?
ends

;
; IDirectSoundBuffer
;

macro	Define_IID_IDirectSoundBuffer
public	IID_IDirectSoundBuffer
IID_IDirectSoundBuffer	GUID <0279AFA85h, 04981h, 011CEh,\
			0A5h, 021h, 000h, 020h, 0AFh, 00Bh, 0E5h, 060h>
endm

struc	IDirectSoundBuffer
; IUnknown methods
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; IDirectSoundBuffer methods
	GetCaps 		dd ?
	GetCurrentPosition	dd ?
	GetFormat		dd ?
	GetVolume		dd ?
	GetPan			dd ?
	GetFrequency		dd ?
	GetStatus		dd ?
	Initialize		dd ?
	_Lock			dd ?
	Play			dd ?
	SetCurrentPosition	dd ?
	SetFormat		dd ?
	SetVolume		dd ?
	SetPan			dd ?
	SetFrequency		dd ?
	Stop			dd ?
	Unlock			dd ?
	Restore 		dd ?
ends

ifndef NODSOUND3D

;
; IDirectSound3DListener
;

macro	Define_IID_IDirectSound3DListener
public	IID_IDirectSound3DListener
IID_IDirectSound3DListener GUID <0279AFA84h, 04981h, 011CEh,\
			0A5h, 021h, 000h, 020h, 0AFh, 00Bh, 0E5h, 060h>
endm

struc	IDirectSound3DListener
; IUnknown methods
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; IDirectSound3D methods
	GetAllParameters	dd ?
	GetDistanceFactor	dd ?
	GetDopplerFactor	dd ?
	GetOrientation		dd ?
	GetPosition		dd ?
	GetRolloffFactor	dd ?
	GetVelocity		dd ?
	SetAllParameters	dd ?
	SetDistanceFactor	dd ?
	SetDopplerFactor	dd ?
	SetOrientation		dd ?
	SetPosition		dd ?
	SetRolloffFactor	dd ?
	SetVelocity		dd ?
	CommitDeferredSettings	dd ?
ends

;
; IDirectSound3DBuffer
;

macro	Define_IID_IDirectSound3DBuffer
public	IID_IDirectSound3DBuffer
IID_IDirectSound3DBuffer GUID <0279AFA86h, 04981h, 011CEh,\
			0A5h, 021h, 000h, 020h, 0AFh, 00Bh, 0E5h, 060h>
endm

struc	IDirectSound3DBuffer
; IUnknown methods
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; IDirectSoundBuffer3D methods
	GetAllParameters	dd ?
	GetConeAngles		dd ?
	GetConeOrientation	dd ?
	GetConeOutsideVolume	dd ?
	GetMaxDistance		dd ?
	GetMinDistance		dd ?
	GetMode 		dd ?
	GetPosition		dd ?
	GetVelocity		dd ?
	SetAllParameters	dd ?
	SetConeAngles		dd ?
	SetConeOrientation	dd ?
	SetConeOutsideVolume	dd ?
	SetMaxDistance		dd ?
	SetMinDistance		dd ?
	SetMode 		dd ?
	SetPosition		dd ?
	SetVelocity		dd ?
ends

endif ; NODSOUND3D

;
; IDirectSoundCapture
;

macro	Define_IID_IDirectSoundCapture
public	IID_IDirectSoundCapture
IID_IDirectSoundCapture GUID <0b0210781h, 089cdh, 011d0h,\
			0afh, 08h, 00h, 0a0h, 0c9h, 025h, 0cdh, 016h>
endm

struc	IDirectSoundCapture
; IUnknown methods
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; IDirectSoundCapture methods
	CreateCaptureBuffer	dd ?
	GetCaps 		dd ?
	Initialize		dd ?
ends

;
; IDirectSoundCaptureBuffer
;

macro	Define_IID_IDirectSoundCaptureBuffer
public	IID_IDirectSoundCaptureBuffer
IID_IDirectSoundCaptureBuffer GUID <0b0210782h, 089cdh, 011d0h,\
			0afh, 08h, 00h, 0a0h, 0c9h, 025h, 0cdh, 016h>
endm

struc	IDirectSoundCaptureBuffer
; IUnknown methods
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; IDirectSoundCaptureBuffer methods
	GetCaps 		dd ?
	GetCurrentPosition	dd ?
	GetFormat		dd ?
	GetStatus		dd ?
	Initialize		dd ?
	_Lock			dd ?
	Start			dd ?
	Stop			dd ?
	Unlock			dd ?
ends

;
; IDirectSoundNotify
;

macro	Define_IID_IDirectSoundNotify
public	IID_IDirectSoundNotify
IID_IDirectSoundNotify	GUID <0b0210783h, 089cdh, 011d0h,\
			0afh, 08h, 00h, 0a0h, 0c9h, 025h, 0cdh, 016h>
endm

struc	IDirectSoundNotify
; IUnknown methods
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; IDirectSoundNotify methods
	SetNotificationPositions dd ?
ends

;
; IKsPropertySet
;

KSPROPERTY_SUPPORT_GET		= 000000001h
KSPROPERTY_SUPPORT_SET		= 000000002h

macro	Define_IID_IKsPropertySet
public	IID_IKsPropertySet
IID_IKsPropertySet	GUID <031efac30h, 0515ch, 011d0h,\
			0a9h, 0aah, 000h, 0aah, 000h, 061h, 0beh, 093h>
endm

struc	IKsPropertySet
; IUnknown methods
	QueryInterface		dd ?
	AddRef			dd ?
	Release 		dd ?
; IKsPropertySet methods
	Get			dd ?
	Set			dd ?
	QuerySupport		dd ?
ends

;
; Return Codes
;

DS_OK				= 0
DSERR_ALLOCATED 		= (80000000h + (_FACDS shl 16) + 10)
DSERR_CONTROLUNAVAIL		= (80000000h + (_FACDS shl 16) + 30)
DSERR_INVALIDPARAM		= E_INVALIDARG
DSERR_INVALIDCALL		= (80000000h + (_FACDS shl 16) + 50)
DSERR_GENERIC			= E_FAIL
DSERR_PRIOLEVELNEEDED		= (80000000h + (_FACDS shl 16) + 70)
DSERR_OUTOFMEMORY		= E_OUTOFMEMORY
DSERR_BADFORMAT 		= (80000000h + (_FACDS shl 16) + 100)
DSERR_UNSUPPORTED		= E_NOTIMPL
DSERR_NODRIVER			= (80000000h + (_FACDS shl 16) + 120)
DSERR_ALREADYINITIALIZED	= (80000000h + (_FACDS shl 16) + 130)
DSERR_NOAGGREGATION		= CLASS_E_NOAGGREGATION
DSERR_BUFFERLOST		= (80000000h + (_FACDS shl 16) + 150)
DSERR_OTHERAPPHASPRIO		= (80000000h + (_FACDS shl 16) + 160)
DSERR_UNINITIALIZED		= (80000000h + (_FACDS shl 16) + 170)
DSERR_NOINTERFACE		= E_NOINTERFACE

;
; Flags
;

DSCAPS_PRIMARYMONO		= 000000001h
DSCAPS_PRIMARYSTEREO		= 000000002h
DSCAPS_PRIMARY8BIT		= 000000004h
DSCAPS_PRIMARY16BIT		= 000000008h
DSCAPS_CONTINUOUSRATE		= 000000010h
DSCAPS_EMULDRIVER		= 000000020h
DSCAPS_CERTIFIED		= 000000040h
DSCAPS_SECONDARYMONO		= 000000100h
DSCAPS_SECONDARYSTEREO		= 000000200h
DSCAPS_SECONDARY8BIT		= 000000400h
DSCAPS_SECONDARY16BIT		= 000000800h

DSBPLAY_LOOPING 		= 000000001h

DSBSTATUS_PLAYING		= 000000001h
DSBSTATUS_BUFFERLOST		= 000000002h
DSBSTATUS_LOOPING		= 000000004h

DSBLOCK_FROMWRITECURSOR 	= 000000001h
DSBLOCK_ENTIREBUFFER		= 000000002h

DSSCL_NORMAL			= 000000001h
DSSCL_PRIORITY			= 000000002h
DSSCL_EXCLUSIVE 		= 000000003h
DSSCL_WRITEPRIMARY		= 000000004h

ifndef NODSOUND3D

DS3DMODE_NORMAL 		= 000000000h
DS3DMODE_HEADRELATIVE		= 000000001h
DS3DMODE_DISABLE		= 000000002h

DS3D_IMMEDIATE			= 000000000h
DS3D_DEFERRED			= 000000001h

DS3D_MINDISTANCEFACTOR		= 0.0
DS3D_MAXDISTANCEFACTOR		= 10.0
DS3D_DEFAULTDISTANCEFACTOR	= 1.0

DS3D_MINROLLOFFFACTOR		= 0.0
DS3D_MAXROLLOFFFACTOR		= 10.0
DS3D_DEFAULTROLLOFFFACTOR	= 1.0

DS3D_MINDOPPLERFACTOR		= 0.0
DS3D_MAXDOPPLERFACTOR		= 10.0
DS3D_DEFAULTDOPPLERFACTOR	= 1.0

DS3D_DEFAULTMINDISTANCE 	= 1.0
DS3D_DEFAULTMAXDISTANCE 	= 1000000000.0

DS3D_MINCONEANGLE		= 0
DS3D_MAXCONEANGLE		= 360
DS3D_DEFAULTCONEANGLE		= 360

DS3D_DEFAULTCONEOUTSIDEVOLUME	= 0

endif ; NODSOUND3D

DSBCAPS_PRIMARYBUFFER		= 000000001h
DSBCAPS_STATIC			= 000000002h
DSBCAPS_LOCHARDWARE		= 000000004h
DSBCAPS_LOCSOFTWARE		= 000000008h
DSBCAPS_CTRL3D			= 000000010h
DSBCAPS_CTRLFREQUENCY		= 000000020h
DSBCAPS_CTRLPAN 		= 000000040h
DSBCAPS_CTRLVOLUME		= 000000080h
DSBCAPS_CTRLPOSITIONNOTIFY	= 000000100h
DSBCAPS_CTRLDEFAULT		= 0000000E0h
DSBCAPS_CTRLALL 		= 0000001F0h
DSBCAPS_STICKYFOCUS		= 000004000h
DSBCAPS_GLOBALFOCUS		= 000008000h
DSBCAPS_GETCURRENTPOSITION2	= 000010000h
DSBCAPS_MUTE3DATMAXDISTANCE	= 000020000h

DSCBCAPS_WAVEMAPPED		= 080000000h

DSSPEAKER_HEADPHONE		= 000000001h
DSSPEAKER_MONO			= 000000002h
DSSPEAKER_QUAD			= 000000003h
DSSPEAKER_STEREO		= 000000004h
DSSPEAKER_SURROUND		= 000000005h

DSSPEAKER_GEOMETRY_MIN		= 000000005h  ;   5 degrees
DSSPEAKER_GEOMETRY_NARROW	= 00000000Ah  ;  10 degrees
DSSPEAKER_GEOMETRY_WIDE 	= 000000014h  ;  20 degrees
DSSPEAKER_GEOMETRY_MAX		= 0000000B4h  ; 180 degrees

DSCCAPS_EMULDRIVER		= 000000020h

DSCBLOCK_ENTIREBUFFER		= 000000001h

DSCBSTATUS_CAPTURING		= 000000001h
DSCBSTATUS_LOOPING		= 000000002h

DSCBSTART_LOOPING		= 000000001h

DSBFREQUENCY_MIN		= 100
DSBFREQUENCY_MAX		= 100000
DSBFREQUENCY_ORIGINAL		= 0

DSBPAN_LEFT			= -10000
DSBPAN_CENTER			= 0
DSBPAN_RIGHT			= 10000

DSBVOLUME_MIN			= -10000
DSBVOLUME_MAX			= 0

DSBSIZE_MIN			= 4
DSBSIZE_MAX			= 00FFFFFFFh

DSBPN_OFFSETSTOP		= 0FFFFFFFFh
