;==========================================================================
;
;  mmsystem.h -- Include file for Multimedia API's
;
;  Version 4.00
;
;  Copyright (C) 1992-1995 Microsoft Corporation.  All Rights Reserved.
;
;--------------------------------------------------------------------------

;***************************************************************************
;
;		    General constants and data types
;
;***************************************************************************

; general constants
MAXPNAMELEN			= 32	 ; max product name length (including NULL)
MAXERRORLENGTH			= 256	 ; max error text length (including NULL)
MAX_JOYSTICKOEMVXDNAME		= 260 ; max oem vxd name length (including NULL)

;
;  Microsoft Manufacturer and Product ID's (these have been moved to
;  MMREG.H for Windows 4.00 and above).
;
MM_MICROSOFT			= 1   ; Microsoft Corporation

MM_MIDI_MAPPER			= 1   ; MIDI Mapper
MM_WAVE_MAPPER			= 2   ; Wave Mapper
MM_SNDBLST_MIDIOUT		= 3   ; Sound Blaster MIDI output port
MM_SNDBLST_MIDIIN		= 4   ; Sound Blaster MIDI input port
MM_SNDBLST_SYNTH		= 5   ; Sound Blaster internal synthesizer
MM_SNDBLST_WAVEOUT		= 6   ; Sound Blaster waveform output
MM_SNDBLST_WAVEIN		= 7   ; Sound Blaster waveform input
MM_ADLIB			= 9   ; Ad Lib-compatible synthesizer
MM_MPU401_MIDIOUT		= 10   ; MPU401-compatible MIDI output port
MM_MPU401_MIDIIN		= 11   ; MPU401-compatible MIDI input port
MM_PC_JOYSTICK			= 12   ; Joystick adapter

; MMTIME data structure

struc	MMTIME
	wType			dd ?		; indicates the contents of the union
label	ms			dword		; milliseconds
label	sample			dword		; samples
label	cb			dword		; byte count
label	ticks			dword		; ticks in MIDI stream	; SMPTE
label	songptrpos		dword		; song pointer position
	hour			db ?		; hours
	min			db ?		; minutes
	sec			db ?		; seconds
	frame			db ?		; frames
	fps			db ?		; frames per second
	dummy			db ?		; pad
	pad			db 2 dup (?)
ends

; types for wType field in MMTIME struct
TIME_MS 			= 00001h  ; time in milliseconds
TIME_SAMPLES			= 00002h  ; number of wave samples
TIME_BYTES			= 00004h  ; current byte offset
TIME_SMPTE			= 00008h  ; SMPTE time
TIME_MIDI			= 00010h  ; MIDI time
TIME_TICKS			= 00020h  ; Ticks within MIDI stream

;***************************************************************************
;
;		    Multimedia Extensions Window Messages
;
;***************************************************************************

MM_JOY1MOVE			= 03A0h 	  ; joystick
MM_JOY2MOVE			= 03A1h
MM_JOY1ZMOVE			= 03A2h
MM_JOY2ZMOVE			= 03A3h
MM_JOY1BUTTONDOWN		= 03B5h
MM_JOY2BUTTONDOWN		= 03B6h
MM_JOY1BUTTONUP 		= 03B7h
MM_JOY2BUTTONUP 		= 03B8h

MM_MCINOTIFY			= 03B9h 	  ; MCI

MM_WOM_OPEN			= 03BBh 	  ; waveform output
MM_WOM_CLOSE			= 03BCh
MM_WOM_DONE			= 03BDh

MM_WIM_OPEN			= 03BEh 	  ; waveform input
MM_WIM_CLOSE			= 03BFh
MM_WIM_DATA			= 03C0h

MM_MIM_OPEN			= 03C1h 	  ; MIDI input
MM_MIM_CLOSE			= 03C2h
MM_MIM_DATA			= 03C3h
MM_MIM_LONGDATA 		= 03C4h
MM_MIM_ERROR			= 03C5h
MM_MIM_LONGERROR		= 03C6h

MM_MOM_OPEN			= 03C7h 	  ; MIDI output
MM_MOM_CLOSE			= 03C8h
MM_MOM_DONE			= 03C9h

; these are also in msvideo.h
MM_DRVM_OPEN			= 03D0h 	  ; installable drivers
MM_DRVM_CLOSE			= 03D1h
MM_DRVM_DATA			= 03D2h
MM_DRVM_ERROR			= 03D3h

; these are used by msacm.h
MM_STREAM_OPEN			= 03D4h
MM_STREAM_CLOSE 		= 03D5h
MM_STREAM_DONE			= 03D6h
MM_STREAM_ERROR 		= 03D7h

MM_MOM_POSITIONCB		= 03CAh 	  ; Callback for MEVT_POSITIONCB

MM_MCISIGNAL			= 03CBh

MM_MIM_MOREDATA 		= 03CCh 	 ; MIM_DONE w/ pending events

MM_MIXM_LINE_CHANGE		= 03D0h       ; mixer line change notify
MM_MIXM_CONTROL_CHANGE		= 03D1h       ; mixer control change notify

;***************************************************************************
;
;		String resource number bases (internal use)
;
;***************************************************************************

MMSYSERR_BASE			= 0
WAVERR_BASE			= 32
MIDIERR_BASE			= 64
TIMERR_BASE			= 96
JOYERR_BASE			= 160
MCIERR_BASE			= 256
MIXERR_BASE			= 1024

MCI_STRING_OFFSET		= 512
MCI_VD_OFFSET			= 1024
MCI_CD_OFFSET			= 1088
MCI_WAVE_OFFSET 		= 1152
MCI_SEQ_OFFSET			= 1216

;***************************************************************************
;
;			General error return values
;
;***************************************************************************

; general error return values
MMSYSERR_NOERROR		= 0		       ; no error
MMSYSERR_ERROR			= (MMSYSERR_BASE + 1)  ; unspecified error
MMSYSERR_BADDEVICEID		= (MMSYSERR_BASE + 2)  ; device ID out of range
MMSYSERR_NOTENABLED		= (MMSYSERR_BASE + 3)  ; driver failed enable
MMSYSERR_ALLOCATED		= (MMSYSERR_BASE + 4)  ; device already allocated
MMSYSERR_INVALHANDLE		= (MMSYSERR_BASE + 5)  ; device handle is invalid
MMSYSERR_NODRIVER		= (MMSYSERR_BASE + 6)  ; no device driver present
MMSYSERR_NOMEM			= (MMSYSERR_BASE + 7)  ; memory allocation error
MMSYSERR_NOTSUPPORTED		= (MMSYSERR_BASE + 8)  ; function isn't supported
MMSYSERR_BADERRNUM		= (MMSYSERR_BASE + 9)  ; error value out of range
MMSYSERR_INVALFLAG		= (MMSYSERR_BASE + 10) ; invalid flag passed
MMSYSERR_INVALPARAM		= (MMSYSERR_BASE + 11) ; invalid parameter passed
MMSYSERR_HANDLEBUSY		= (MMSYSERR_BASE + 12) ; handle being used
						   ; simultaneously on another
						   ; thread (eg callback)
MMSYSERR_INVALIDALIAS		= (MMSYSERR_BASE + 13) ; specified alias not found
MMSYSERR_BADDB			= (MMSYSERR_BASE + 14) ; bad registry database
MMSYSERR_KEYNOTFOUND		= (MMSYSERR_BASE + 15) ; registry key not found
MMSYSERR_READERROR		= (MMSYSERR_BASE + 16) ; registry read error
MMSYSERR_WRITEERROR		= (MMSYSERR_BASE + 17) ; registry write error
MMSYSERR_DELETEERROR		= (MMSYSERR_BASE + 18) ; registry delete error
MMSYSERR_VALNOTFOUND		= (MMSYSERR_BASE + 19) ; registry value not found
MMSYSERR_NODRIVERCB		= (MMSYSERR_BASE + 20) ; driver does not call DriverCallback
MMSYSERR_LASTERROR		= (MMSYSERR_BASE + 20) ; last error in range

;***************************************************************************
;
;			Installable driver support
;
;***************************************************************************

struc	DRVCONFIGINFOEX
	dwDCISize		dd ?
	lpszDCISectionName	dd ?
	lpszDCIAliasName	dd ?
	dnDevNode		dd ?
ends

; Driver messages
DRV_LOAD			= 00001h
DRV_ENABLE			= 00002h
DRV_OPEN			= 00003h
DRV_CLOSE			= 00004h
DRV_DISABLE			= 00005h
DRV_FREE			= 00006h
DRV_CONFIGURE			= 00007h
DRV_QUERYCONFIGURE		= 00008h
DRV_INSTALL			= 00009h
DRV_REMOVE			= 0000Ah
DRV_EXITSESSION 		= 0000Bh
DRV_POWER			= 0000Fh
DRV_RESERVED			= 00800h
DRV_USER			= 04000h

struc	DRVCONFIGINFO
	dwDCISize		dd ?
	lpszDCISectionName	dd ?
	lpszDCIAliasName	dd ?
ends

; Supported return values for DRV_CONFIGURE message
DRVCNF_CANCEL			= 00000h
DRVCNF_OK			= 00001h
DRVCNF_RESTART			= 00002h

; installable driver function prototypes

proctype DRIVERPROC :dword, :dword, :dword, :dword, :dword

procdesc CloseDriver :dword, :dword, :dword
procdesc OpenDriver :dword, :dword, :dword
procdesc SendDriverMessage :dword, :dword, :dword, :dword
procdesc DrvGetModuleHandle :dword
procdesc GetDriverModuleHandle :dword
procdesc DefDriverProc :dword, :dword, :dword, :dword, :dword

; return values from DriverProc() function
DRV_CANCEL			= DRVCNF_CANCEL
DRV_OK				= DRVCNF_OK
DRV_RESTART			= DRVCNF_RESTART

DRV_MCI_FIRST			= DRV_RESERVED
DRV_MCI_LAST			= (DRV_RESERVED + 0FFFh)

;***************************************************************************
;
;			  Driver callback support
;
;***************************************************************************

; flags used with waveOutOpen(), waveInOpen(), midiInOpen(), and
; midiOutOpen() to specify the type of the dwCallback parameter.

CALLBACK_TYPEMASK		= 000070000h	; callback type mask
CALLBACK_NULL			= 000000000h	; no callback
CALLBACK_WINDOW 		= 000010000h	; dwCallback is a HWND
CALLBACK_TASK			= 000020000h	; dwCallback is a HTASK
CALLBACK_FUNCTION		= 000030000h	; dwCallback is a FARPROC
CALLBACK_THREAD 		= (CALLBACK_TASK); thread ID replaces 16 bit task
CALLBACK_EVENT			= 000050000h	; dwCallback is an EVENT Handle

proctype DRVCALLBACK :dword, :dword, :dword, :dword, :dword

WAVECALLBACK			equ <DRVCALLBACK>
MIDICALLBACK			equ <DRVCALLBACK>

;***************************************************************************
;
;		    General MMSYSTEM support
;
;***************************************************************************

procdesc mmsystemGetVersion

OutputDebugStr			equ <OutputDebugString>

;***************************************************************************
;
;			    Sound support
;
;***************************************************************************

procdesc sndPlaySoundA :dword, :dword

sndPlaySound			equ <sndPlaySoundA>

;
;  flag values for fuSound and fdwSound arguments on [snd]PlaySound
;
SND_SYNC			= 00000h  ; play synchronously (default)
SND_ASYNC			= 00001h  ; play asynchronously
SND_NODEFAULT			= 00002h  ; silence (!default) if sound not found
SND_MEMORY			= 00004h  ; pszSound points to a memory file
SND_LOOP			= 00008h  ; loop the sound until next sndPlaySound
SND_NOSTOP			= 00010h  ; don't stop any currently playing sound

SND_NOWAIT			= 000002000h ; don't wait if the driver is busy
SND_ALIAS			= 000010000h ; name is a registry alias
SND_ALIAS_ID			= 000110000h ; alias is a predefined ID
SND_FILENAME			= 000020000h ; name is file name
SND_RESOURCE			= 000040004h ; name is resource name or atom
SND_PURGE			= 00040h  ; purge non-static events for task
SND_APPLICATION 		= 00080h  ; look for application specific association

SND_ALIAS_START 		= 0	      ; alias base

SND_ALIAS_SYSTEMASTERISK	equ <'S*'>
SND_ALIAS_SYSTEMQUESTION	equ <'S?'>
SND_ALIAS_SYSTEMHAND		equ <'SH'>
SND_ALIAS_SYSTEMEXIT		equ <'SE'>
SND_ALIAS_SYSTEMSTART		equ <'SS'>
SND_ALIAS_SYSTEMWELCOME 	equ <'SW'>
SND_ALIAS_SYSTEMEXCLAMATION	equ <'S!'>
SND_ALIAS_SYSTEMDEFAULT 	equ <'SD'>

procdesc PlaySoundA :dword, :dword, :dword

PlaySound			equ <PlaySoundA>

;***************************************************************************
;
;			Waveform audio support
;
;***************************************************************************

; waveform audio error return values
WAVERR_BADFORMAT		= (WAVERR_BASE + 0)    ; unsupported wave format
WAVERR_STILLPLAYING		= (WAVERR_BASE + 1)    ; still something playing
WAVERR_UNPREPARED		= (WAVERR_BASE + 2)    ; header not prepared
WAVERR_SYNC			= (WAVERR_BASE + 3)    ; device is synchronous
WAVERR_LASTERROR		= (WAVERR_BASE + 3)    ; last error in range

; wave callback messages
WOM_OPEN			= MM_WOM_OPEN
WOM_CLOSE			= MM_WOM_CLOSE
WOM_DONE			= MM_WOM_DONE
WIM_OPEN			= MM_WIM_OPEN
WIM_CLOSE			= MM_WIM_CLOSE
WIM_DATA			= MM_WIM_DATA

; device ID for wave device mapper
WAVE_MAPPER			= (-1)

; flags for dwFlags parameter in waveOutOpen() and waveInOpen()
WAVE_FORMAT_QUERY		= 00001h
WAVE_ALLOWSYNC			= 00002h
WAVE_MAPPED			= 00004h
WAVE_FORMAT_DIRECT		= 00008h
WAVE_FORMAT_DIRECT_QUERY	= (WAVE_FORMAT_QUERY + WAVE_FORMAT_DIRECT)

; wave data block header

struc	WAVEHDR
	lpData			dd ?		; pointer to locked data buffer
	dwBufferLength		dd ?		; length of data buffer
	dwBytesRecorded 	dd ?		; used for input only
	dwUser			dd ?		; for client's use
	dwFlags 		dd ?		; assorted flags (see defines)
	dwLoops 		dd ?		; loop control counter
	lpNext			dd ?		; reserved for driver
	reserved		dd ?		; reserved for driver
ends

; flags for dwFlags field of WAVEHDR
WHDR_DONE			= 000000001h  ; done bit
WHDR_PREPARED			= 000000002h  ; set if this header has been prepared
WHDR_BEGINLOOP			= 000000004h  ; loop start block
WHDR_ENDLOOP			= 000000008h  ; loop end block
WHDR_INQUEUE			= 000000010h  ; reserved for driver

; waveform output device capabilities structure

struc	WAVEOUTCAPS
	wMid			dw ?		; manufacturer ID
	wPid			dw ?		; product ID
	vDriverVersion		dd ?		; version of the driver
	szPname 		db MAXPNAMELEN dup (?) ; product name (NULL terminated string)
	dwFormats		dd ?		; formats supported
	wChannels		dw ?		; number of sources supported
	wReserved1		dw ?		; packing
	dwSupport		dd ?		; functionality supported by driver
ends

; flags for dwSupport field of WAVEOUTCAPS
WAVECAPS_PITCH			= 00001h   ; supports pitch control
WAVECAPS_PLAYBACKRATE		= 00002h   ; supports playback rate control
WAVECAPS_VOLUME 		= 00004h   ; supports volume control
WAVECAPS_LRVOLUME		= 00008h   ; separate left-right volume control
WAVECAPS_SYNC			= 00010h
WAVECAPS_SAMPLEACCURATE 	= 00020h
WAVECAPS_DIRECTSOUND		= 00040h

; waveform input device capabilities structure

struc	WAVEINCAPS
	wMid			dw ?		; manufacturer ID
	wPid			dw ?		; product ID
	vDriverVersion		dd ?		; version of the driver
	szPname 		db MAXPNAMELEN dup (?) ; product name (NULL terminated string)
	dwFormats		dd ?		; formats supported
	wChannels		dw ?		; number of channels supported
	wReserved1		dw ?		; structure packing
ends

; defines for dwFormat field of WAVEINCAPS and WAVEOUTCAPS
WAVE_INVALIDFORMAT		= 000000000h	   ; invalid format
WAVE_FORMAT_1M08		= 000000001h	   ; 11.025 kHz, Mono,	 8-bit
WAVE_FORMAT_1S08		= 000000002h	   ; 11.025 kHz, Stereo, 8-bit
WAVE_FORMAT_1M16		= 000000004h	   ; 11.025 kHz, Mono,	 16-bit
WAVE_FORMAT_1S16		= 000000008h	   ; 11.025 kHz, Stereo, 16-bit
WAVE_FORMAT_2M08		= 000000010h	   ; 22.05  kHz, Mono,	 8-bit
WAVE_FORMAT_2S08		= 000000020h	   ; 22.05  kHz, Stereo, 8-bit
WAVE_FORMAT_2M16		= 000000040h	   ; 22.05  kHz, Mono,	 16-bit
WAVE_FORMAT_2S16		= 000000080h	   ; 22.05  kHz, Stereo, 16-bit
WAVE_FORMAT_4M08		= 000000100h	   ; 44.1   kHz, Mono,	 8-bit
WAVE_FORMAT_4S08		= 000000200h	   ; 44.1   kHz, Stereo, 8-bit
WAVE_FORMAT_4M16		= 000000400h	   ; 44.1   kHz, Mono,	 16-bit
WAVE_FORMAT_4S16		= 000000800h	   ; 44.1   kHz, Stereo, 16-bit

; OLD general waveform format structure (information common to all formats)

struc	WAVEFORMAT
	wFormatTag		dw ?		; format type
	nChannels		dw ?		; number of channels (i.e. mono, stereo, etc.)
	nSamplesPerSec		dd ?		; sample rate
	nAvgBytesPerSec 	dd ?		; for buffer estimation
	nBlockAlign		dw ?		; block size of data
ends

; flags for wFormatTag field of WAVEFORMAT
WAVE_FORMAT_PCM 		= 1

; specific waveform format structure for PCM data

struc	PCMWAVEFORMAT
	wf			WAVEFORMAT ?
	wBitsPerSample		dw ?
ends

;
;  extended waveform format structure used for all non-PCM formats. this
;  structure is common to all non-PCM formats.
;

struc	WAVEFORMATEX
	wFormatTag		dw ?		; format type
	nChannels		dw ?		; number of channels (i.e. mono, stereo...)
	nSamplesPerSec		dd ?		; sample rate
	nAvgBytesPerSec 	dd ?		; for buffer estimation
	nBlockAlign		dw ?		; block size of data
	wBitsPerSample		dw ?		; number of bits per sample of mono data
	cbSize			dw ?		; the count in bytes of the size of  ; extra information (after cbSize)
ends

procdesc waveOutGetNumDevs
procdesc waveOutGetDevCapsA :dword, :dword, :dword
procdesc waveOutGetVolume :dword, :dword
procdesc waveOutSetVolume :dword, :dword
procdesc waveOutGetErrorTextA :dword, :dword, :dword

procdesc waveOutOpen :dword, :dword, :dword, :dword, :dword, :dword
procdesc waveOutClose :dword
procdesc waveOutPrepareHeader :dword, :dword, :dword
procdesc waveOutUnprepareHeader :dword, :dword, :dword
procdesc waveOutWrite :dword, :dword, :dword
procdesc waveOutPause :dword
procdesc waveOutRestart :dword
procdesc waveOutReset :dword
procdesc waveOutBreakLoop :dword
procdesc waveOutGetPosition :dword, :dword, :dword
procdesc waveOutGetPitch :dword, :dword
procdesc waveOutSetPitch :dword, :dword
procdesc waveOutGetPlaybackRate :dword, :dword
procdesc waveOutSetPlaybackRate :dword, :dword
procdesc waveOutGetID :dword, :dword
procdesc waveOutMessage :dword, :dword, :dword, :dword

procdesc waveInGetNumDevs
procdesc waveInGetDevCapsA :dword, :dword, :dword
procdesc waveInGetErrorTextA :dword, :dword, :dword
procdesc waveInOpen :dword, :dword, :dword, :dword, :dword, :dword

procdesc waveInClose :dword
procdesc waveInPrepareHeader :dword, :dword, :dword
procdesc waveInUnprepareHeader :dword, :dword, :dword
procdesc waveInAddBuffer :dword, :dword, :dword
procdesc waveInStart :dword
procdesc waveInStop :dword
procdesc waveInReset :dword
procdesc waveInGetPosition :dword, :dword, :dword
procdesc waveInGetID :dword, :dword
procdesc waveInMessage :dword, :dword, :dword, :dword

waveOutGetDevCaps		equ <waveOutGetDevCapsA>
waveOutGetErrorText		equ <waveOutGetErrorTextA>
waveInGetDevCaps		equ <waveInGetDevCapsA>
waveInGetErrorText		equ <waveInGetErrorTextA>

;***************************************************************************
;
;			    MIDI audio support
;
;***************************************************************************

; MIDI error return values
MIDIERR_UNPREPARED		= (MIDIERR_BASE + 0)   ; header not prepared
MIDIERR_STILLPLAYING		= (MIDIERR_BASE + 1)   ; still something playing
MIDIERR_NOMAP			= (MIDIERR_BASE + 2)   ; no configured instruments
MIDIERR_NOTREADY		= (MIDIERR_BASE + 3)   ; hardware is still busy
MIDIERR_NODEVICE		= (MIDIERR_BASE + 4)   ; port no longer connected
MIDIERR_INVALIDSETUP		= (MIDIERR_BASE + 5)   ; invalid MIF
MIDIERR_BADOPENMODE		= (MIDIERR_BASE + 6)   ; operation unsupported w/ open mode
MIDIERR_DONT_CONTINUE		= (MIDIERR_BASE + 7)   ; thru device 'eating' a message
MIDIERR_LASTERROR		= (MIDIERR_BASE + 7)   ; last error in range

MIDIPATCHSIZE			= 128

; MIDI callback messages
MIM_OPEN			= MM_MIM_OPEN
MIM_CLOSE			= MM_MIM_CLOSE
MIM_DATA			= MM_MIM_DATA
MIM_LONGDATA			= MM_MIM_LONGDATA
MIM_ERROR			= MM_MIM_ERROR
MIM_LONGERROR			= MM_MIM_LONGERROR
MOM_OPEN			= MM_MOM_OPEN
MOM_CLOSE			= MM_MOM_CLOSE
MOM_DONE			= MM_MOM_DONE

MIM_MOREDATA			= MM_MIM_MOREDATA
MOM_POSITIONCB			= MM_MOM_POSITIONCB

; device ID for MIDI mapper
MIDIMAPPER			= (-1)
MIDI_MAPPER			= (-1)

; flags for dwFlags parm of midiInOpen()
MIDI_IO_STATUS			= 000000020h

; flags for wFlags parm of midiOutCachePatches(), midiOutCacheDrumPatches()
MIDI_CACHE_ALL			= 1
MIDI_CACHE_BESTFIT		= 2
MIDI_CACHE_QUERY		= 3
MIDI_UNCACHE			= 4

; MIDI output device capabilities structure

struc	MIDIOUTCAPS
	wMid			dw ?		; manufacturer ID
	wPid			dw ?		; product ID
	vDriverVersion		dd ?		; version of the driver
	szPname 		db MAXPNAMELEN dup (?) ; product name (NULL terminated string)
	wTechnology		dw ?		; type of device
	wVoices 		dw ?		; # of voices (internal synth only)
	wNotes			dw ?		; max # of notes (internal synth only)
	wChannelMask		dw ?		; channels used (internal synth only)
	dwSupport		dd ?		; functionality supported by driver
ends

; flags for wTechnology field of MIDIOUTCAPS structure
MOD_MIDIPORT			= 1  ; output port
MOD_SYNTH			= 2  ; generic internal synth
MOD_SQSYNTH			= 3  ; square wave internal synth
MOD_FMSYNTH			= 4  ; FM internal synth
MOD_MAPPER			= 5  ; MIDI mapper

; flags for dwSupport field of MIDIOUTCAPS structure
MIDICAPS_VOLUME 		= 00001h  ; supports volume control
MIDICAPS_LRVOLUME		= 00002h  ; separate left-right volume control
MIDICAPS_CACHE			= 00004h
MIDICAPS_STREAM 		= 00008h  ; driver supports midiStreamOut directly

; MIDI input device capabilities structure

struc	MIDIINCAPS
	wMid			dw ?		; manufacturer ID
	wPid			dw ?		; product ID
	vDriverVersion		dd ?		; version of the driver
	szPname 		db MAXPNAMELEN dup (?) ; product name (NULL terminated string)
	dwSupport		dd ?		; functionality supported by driver
ends

; MIDI data block header

struc	MIDIHDR
	lpData			dd ?		; pointer to locked data block
	dwBufferLength		dd ?		; length of data in data block
	dwBytesRecorded 	dd ?		; used for input only
	dwUser			dd ?		; for client's use
	dwFlags 		dd ?		; assorted flags (see defines)
	lpNext			dd ?		; reserved for driver
	reserved		dd ?		; reserved for driver
	dwOffset		dd ?		; Callback offset into buffer
	dwReserved		dd 8 dup (?)	; Reserved for MMSYSTEM
ends

struc	MIDIEVENT
	dwDeltaTime		dd ?		; Ticks since last event
	dwStreamID		dd ?		; Reserved; must be zero
	dwEvent 		dd ?		; Event type and parameters
label	dwParms 		dword		; Parameters if this is a long event
ends

struc	MIDISTRMBUFFVER
	dwVersion		dd ?		; Stream buffer format version
	dwMid			dd ?		; Manufacturer ID as defined in MMREG.H
	dwOEMVersion		dd ?		; Manufacturer version for custom ext
ends

; flags for dwFlags field of MIDIHDR structure
MHDR_DONE			= 000000001h	   ; done bit
MHDR_PREPARED			= 000000002h	   ; set if header prepared
MHDR_INQUEUE			= 000000004h	   ; reserved for driver
MHDR_ISSTRM			= 000000008h	   ; Buffer is stream buffer

;
; Type codes which go in the high byte of the event DWORD of a stream buffer
;
; Type codes 00-7F contain parameters within the low 24 bits
; Type codes 80-FF contain a length of their parameter in the low 24
; bits, followed by their parameter data in the buffer. The event
; DWORD contains the exact byte length; the parm data itself must be
; padded to be an even multiple of 4 bytes long.
;

MEVT_F_SHORT			= 000000000h
MEVT_F_LONG			= 080000000h
MEVT_F_CALLBACK 		= 040000000h

MEVT_SHORTMSG			= (000h)    ; parm = shortmsg for midiOutShortMsg
MEVT_TEMPO			= (001h)    ; parm = new tempo in microsec/qn
MEVT_NOP			= (002h)    ; parm = unused; does nothing

; 0x04-0x7F reserved

MEVT_LONGMSG			= (080h)    ; parm = bytes to send verbatim
MEVT_COMMENT			= (082h)    ; parm = comment data
MEVT_VERSION			= (084h)    ; parm = MIDISTRMBUFFVER struct

; 0x81-0xFF reserved

MIDISTRM_ERROR			= (-2)

;
; Structures and defines for midiStreamProperty
;
MIDIPROP_SET			= 080000000h
MIDIPROP_GET			= 040000000h

; These are intentionally both non-zero so the app cannot accidentally
; leave the operation off and happen to appear to work due to default
; action.

MIDIPROP_TIMEDIV		= 000000001h
MIDIPROP_TEMPO			= 000000002h


struc	MIDIPROPTIMEDIV
	cbStruct		dd ?
	dwTimeDiv		dd ?
ends

struc	MIDIPROPTEMPO
	cbStruct		dd ?
	dwTempo 		dd ?
ends

; MIDI function prototypes

procdesc midiOutGetNumDevs
procdesc midiStreamOpen :dword, :dword, :dword, :dword, :dword, :dword
procdesc midiStreamClose :dword
procdesc midiStreamProperty :dword, :dword, :dword
procdesc midiStreamPosition :dword, :dword, :dword
procdesc midiStreamOut :dword, :dword, :dword
procdesc midiStreamPause :dword
procdesc midiStreamRestart :dword
procdesc midiStreamStop :dword
procdesc midiConnect :dword, :dword, :dword
procdesc midiDisconnect :dword, :dword, :dword

procdesc midiOutGetDevCapsA :dword, :dword, :dword
procdesc midiOutGetVolume :dword, :dword
procdesc midiOutSetVolume :dword, :dword
procdesc midiOutGetErrorTextA :dword, :dword, :dword

procdesc midiOutOpen :dword, :dword, :dword, :dword, :dword
procdesc midiOutClose :dword
procdesc midiOutPrepareHeader :dword, :dword, :dword
procdesc midiOutUnprepareHeader :dword, :dword, :dword
procdesc midiOutShortMsg :dword, :dword
procdesc midiOutLongMsg :dword, :dword, :dword
procdesc midiOutReset :dword
procdesc midiOutCachePatches :dword, :dword, :dword, :dword
procdesc midiOutCacheDrumPatches :dword, :dword, :dword, :dword
procdesc midiOutGetID :dword, :dword
procdesc midiOutMessage :dword, :dword, :dword, :dword

procdesc midiInGetNumDevs
procdesc midiInGetDevCapsA :dword, :dword, :dword
procdesc midiInGetErrorTextA :dword, :dword, :dword

procdesc midiInOpen :dword, :dword, :dword, :dword, :dword
procdesc midiInClose :dword
procdesc midiInPrepareHeader :dword, :dword, :dword
procdesc midiInUnprepareHeader :dword, :dword, :dword
procdesc midiInAddBuffer :dword, :dword, :dword
procdesc midiInStart :dword
procdesc midiInStop :dword
procdesc midiInReset :dword
procdesc midiInGetID :dword, :dword
procdesc midiInMessage :dword, :dword, :dword, :dword

midiOutGetDevCaps		equ <midiOutGetDevCapsA>
midiOutGetErrorText		equ <midiOutGetErrorTextA>
midiInGetDevCaps		equ <midiInGetDevCapsA>
midiInGetErrorText		equ <midiInGetErrorTextA>

;***************************************************************************
;
;			Auxiliary audio support
;
;***************************************************************************

; device ID for aux device mapper
AUX_MAPPER			= (-1)

; Auxiliary audio device capabilities structure

struc	AUXCAPS
	wMid			dw ?		; manufacturer ID
	wPid			dw ?		; product ID
	vDriverVersion		dd ?		; version of the driver
	szPname 		db MAXPNAMELEN dup (?) ; product name (NULL terminated string)
	wTechnology		dw ?		; type of device
	wReserved1		dw ?		; padding
	dwSupport		dd ?		; functionality supported by driver
ends

; flags for wTechnology field in AUXCAPS structure
AUXCAPS_CDAUDIO 		= 1	  ; audio from internal CD-ROM drive
AUXCAPS_AUXIN			= 2	  ; audio from auxiliary input jacks

; flags for dwSupport field in AUXCAPS structure
AUXCAPS_VOLUME			= 00001h  ; supports volume control
AUXCAPS_LRVOLUME		= 00002h  ; separate left-right volume control

procdesc auxGetNumDevs
procdesc auxGetDevCapsA :dword, :dword, :dword
procdesc auxSetVolume :dword, :dword
procdesc auxGetVolume :dword, :dword
procdesc auxOutMessage :dword, :dword, :dword, :dword

auxGetDevCaps			equ <auxGetDevCapsA>

;***************************************************************************
;
;			    Mixer Support
;
;***************************************************************************

MIXER_SHORT_NAME_CHARS		= 16
MIXER_LONG_NAME_CHARS		= 64

;
;  MMRESULT error return values specific to the mixer API
;
;
MIXERR_INVALLINE		= (MIXERR_BASE + 0)
MIXERR_INVALCONTROL		= (MIXERR_BASE + 1)
MIXERR_INVALVALUE		= (MIXERR_BASE + 2)
MIXERR_LASTERROR		= (MIXERR_BASE + 2)

MIXER_OBJECTF_HANDLE		= 080000000h
MIXER_OBJECTF_MIXER		= 000000000h
MIXER_OBJECTF_HMIXER		= (MIXER_OBJECTF_HANDLE+MIXER_OBJECTF_MIXER)
MIXER_OBJECTF_WAVEOUT		= 010000000h
MIXER_OBJECTF_HWAVEOUT		= (MIXER_OBJECTF_HANDLE+MIXER_OBJECTF_WAVEOUT)
MIXER_OBJECTF_WAVEIN		= 020000000h
MIXER_OBJECTF_HWAVEIN		= (MIXER_OBJECTF_HANDLE+MIXER_OBJECTF_WAVEIN)
MIXER_OBJECTF_MIDIOUT		= 030000000h
MIXER_OBJECTF_HMIDIOUT		= (MIXER_OBJECTF_HANDLE+MIXER_OBJECTF_MIDIOUT)
MIXER_OBJECTF_MIDIIN		= 040000000h
MIXER_OBJECTF_HMIDIIN		= (MIXER_OBJECTF_HANDLE+MIXER_OBJECTF_MIDIIN)
MIXER_OBJECTF_AUX		= 050000000h

procdesc mixerGetNumDevs

struc	MIXERCAPS
	wMid			dw ?		; manufacturer id
	wPid			dw ?		; product id
	vDriverVersion		dd ?		; version of the driver
	szPname 		db MAXPNAMELEN dup (?) ; product name
	fdwSupport		dd ?		; misc. support bits
	cDestinations		dd ?		; count of destinations
ends

procdesc mixerGetDevCapsA :dword, :dword, :dword
procdesc mixerOpen :dword, :dword, :dword, :dword, :dword
procdesc mixerClose :dword
procdesc mixerMessage :dword, :dword, :dword, :dword

mixerGetDevCaps 		equ <mixerGetDevCapsA>

struc	MIXERLINEA
	cbStruct		dd ?		; size of MIXERLINE structure
	dwDestination		dd ?		; zero based destination index
	dwSource		dd ?		; zero based source index (if source)
	dwLineID		dd ?		; unique line id for mixer device
	fdwLine 		dd ?		; state/information about line
	dwUser			dd ?		; driver specific information
	dwComponentType 	dd ?		; component type line connects to
	cChannels		dd ?		; number of channels line supports
	cConnections		dd ?		; number of connections [possible]
	cControls		dd ?		; number of controls at this line
	szShortName		db MIXER_SHORT_NAME_CHARS dup (?)
	szName			db MIXER_LONG_NAME_CHARS dup (?)
	dwType			dd ?		; MIXERLINE_TARGETTYPE_xxxx
	dwDeviceID		dd ?		; target device ID of device type
	wMid			dw ?		; of target device
	wPid			dw ?		;      "
	vDriverVersion		dd ?		;      "
	szPname 		db MAXPNAMELEN dup (?)
ends

;
;  MIXERLINE.fdwLine
;

MIXERLINE_LINEF_ACTIVE		= 000000001h
MIXERLINE_LINEF_DISCONNECTED	= 000008000h
MIXERLINE_LINEF_SOURCE		= 080000000h

;
;  MIXERLINE.dwComponentType
;
;  component types for destinations and sources
;

MIXERLINE_COMPONENTTYPE_DST_FIRST = 000000000h
MIXERLINE_COMPONENTTYPE_DST_UNDEFINED = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 0)
MIXERLINE_COMPONENTTYPE_DST_DIGITAL = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 1)
MIXERLINE_COMPONENTTYPE_DST_LINE = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 2)
MIXERLINE_COMPONENTTYPE_DST_MONITOR = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 3)
MIXERLINE_COMPONENTTYPE_DST_SPEAKERS = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 4)
MIXERLINE_COMPONENTTYPE_DST_HEADPHONES = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 5)
MIXERLINE_COMPONENTTYPE_DST_TELEPHONE = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 6)
MIXERLINE_COMPONENTTYPE_DST_WAVEIN = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 7)
MIXERLINE_COMPONENTTYPE_DST_VOICEIN = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 8)
MIXERLINE_COMPONENTTYPE_DST_LAST = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 8)

MIXERLINE_COMPONENTTYPE_SRC_FIRST = 000001000h
MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 0)
MIXERLINE_COMPONENTTYPE_SRC_DIGITAL = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 1)
MIXERLINE_COMPONENTTYPE_SRC_LINE = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 2)
MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 3)
MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 4)
MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 5)
MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 6)
MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 7)
MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 8)
MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 9)
MIXERLINE_COMPONENTTYPE_SRC_ANALOG = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10)
MIXERLINE_COMPONENTTYPE_SRC_LAST = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10)

;
;  MIXERLINE.Target.dwType
;
;
MIXERLINE_TARGETTYPE_UNDEFINED	= 0
MIXERLINE_TARGETTYPE_WAVEOUT	= 1
MIXERLINE_TARGETTYPE_WAVEIN	= 2
MIXERLINE_TARGETTYPE_MIDIOUT	= 3
MIXERLINE_TARGETTYPE_MIDIIN	= 4
MIXERLINE_TARGETTYPE_AUX	= 5

procdesc mixerGetLineInfoA :dword, :dword, :dword

mixerGetLineInfo		equ <mixerGetLineInfoA>

MIXER_GETLINEINFOF_DESTINATION	= 000000000h
MIXER_GETLINEINFOF_SOURCE	= 000000001h
MIXER_GETLINEINFOF_LINEID	= 000000002h
MIXER_GETLINEINFOF_COMPONENTTYPE = 000000003h
MIXER_GETLINEINFOF_TARGETTYPE	= 000000004h

MIXER_GETLINEINFOF_QUERYMASK	= 00000000Fh

procdesc MixerGetID :dword, :dword, :dword

;
;  MIXERCONTROL
;

struc	MIXERCONTROL
	cbStruct		dd ?		; size in bytes of MIXERCONTROL
	dwControlID		dd ?		; unique control id for mixer device
	dwControlType		dd ?		; MIXERCONTROL_CONTROLTYPE_xxx
	fdwControl		dd ?		; MIXERCONTROL_CONTROLF_xxx
	cMultipleItems		dd ?		; if MIXERCONTROL_CONTROLF_MULTIPLE set
	szShortName		db MIXER_SHORT_NAME_CHARS dup (?)
	szName			db MIXER_LONG_NAME_CHARS dup (?)
label	lMinimum		dword		; signed minimum for this control
	dwMinimum		dd ?		; unsigned minimum for this control
label	lMaximum		dword		; signed maximum for this control
	dwMaximum		dd ?		; unsigned maximum for this control
	dwReserved1		dd 4 dup (?)
label	cSteps			dword		; # of steps between min & max
	cbCustomData		dd ?		; size in bytes of custom data
	dwReserved2		dd 5 dup (?)	; !!! needed? we have cbStruct....
ends

;
;  MIXERCONTROL.fdwControl
;
;
MIXERCONTROL_CONTROLF_UNIFORM	= 000000001h
MIXERCONTROL_CONTROLF_MULTIPLE	= 000000002h
MIXERCONTROL_CONTROLF_DISABLED	= 080000000h

;
;  MIXERCONTROL_CONTROLTYPE_xxx building block defines
;
;
MIXERCONTROL_CT_CLASS_MASK	= 0F0000000h
MIXERCONTROL_CT_CLASS_CUSTOM	= 000000000h
MIXERCONTROL_CT_CLASS_METER	= 010000000h
MIXERCONTROL_CT_CLASS_SWITCH	= 020000000h
MIXERCONTROL_CT_CLASS_NUMBER	= 030000000h
MIXERCONTROL_CT_CLASS_SLIDER	= 040000000h
MIXERCONTROL_CT_CLASS_FADER	= 050000000h
MIXERCONTROL_CT_CLASS_TIME	= 060000000h
MIXERCONTROL_CT_CLASS_LIST	= 070000000h

MIXERCONTROL_CT_SUBCLASS_MASK	= 00F000000h

MIXERCONTROL_CT_SC_SWITCH_BOOLEAN = 000000000h
MIXERCONTROL_CT_SC_SWITCH_BUTTON = 001000000h

MIXERCONTROL_CT_SC_METER_POLLED = 000000000h

MIXERCONTROL_CT_SC_TIME_MICROSECS = 000000000h
MIXERCONTROL_CT_SC_TIME_MILLISECS = 001000000h

MIXERCONTROL_CT_SC_LIST_SINGLE	= 000000000h
MIXERCONTROL_CT_SC_LIST_MULTIPLE = 001000000h

MIXERCONTROL_CT_UNITS_MASK	= 000FF0000h
MIXERCONTROL_CT_UNITS_CUSTOM	= 000000000h
MIXERCONTROL_CT_UNITS_BOOLEAN	= 000010000h
MIXERCONTROL_CT_UNITS_SIGNED	= 000020000h
MIXERCONTROL_CT_UNITS_UNSIGNED	= 000030000h
MIXERCONTROL_CT_UNITS_DECIBELS	= 000040000h ; in 10ths
MIXERCONTROL_CT_UNITS_PERCENT	= 000050000h ; in 10ths

;
;  Commonly used control types for specifying MIXERCONTROL.dwControlType
;

MIXERCONTROL_CONTROLTYPE_CUSTOM = (MIXERCONTROL_CT_CLASS_CUSTOM + MIXERCONTROL_CT_UNITS_CUSTOM)
MIXERCONTROL_CONTROLTYPE_BOOLEANMETER = (MIXERCONTROL_CT_CLASS_METER + MIXERCONTROL_CT_SC_METER_POLLED + MIXERCONTROL_CT_UNITS_BOOLEAN)
MIXERCONTROL_CONTROLTYPE_SIGNEDMETER = (MIXERCONTROL_CT_CLASS_METER + MIXERCONTROL_CT_SC_METER_POLLED + MIXERCONTROL_CT_UNITS_SIGNED)
MIXERCONTROL_CONTROLTYPE_PEAKMETER = (MIXERCONTROL_CONTROLTYPE_SIGNEDMETER + 1)
MIXERCONTROL_CONTROLTYPE_UNSIGNEDMETER = (MIXERCONTROL_CT_CLASS_METER + MIXERCONTROL_CT_SC_METER_POLLED + MIXERCONTROL_CT_UNITS_UNSIGNED)
MIXERCONTROL_CONTROLTYPE_BOOLEAN = (MIXERCONTROL_CT_CLASS_SWITCH + MIXERCONTROL_CT_SC_SWITCH_BOOLEAN + MIXERCONTROL_CT_UNITS_BOOLEAN)
MIXERCONTROL_CONTROLTYPE_ONOFF	= (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 1)
MIXERCONTROL_CONTROLTYPE_MUTE	= (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 2)
MIXERCONTROL_CONTROLTYPE_MONO	= (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 3)
MIXERCONTROL_CONTROLTYPE_LOUDNESS = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 4)
MIXERCONTROL_CONTROLTYPE_STEREOENH = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 5)
MIXERCONTROL_CONTROLTYPE_BUTTON = (MIXERCONTROL_CT_CLASS_SWITCH + MIXERCONTROL_CT_SC_SWITCH_BUTTON + MIXERCONTROL_CT_UNITS_BOOLEAN)
MIXERCONTROL_CONTROLTYPE_DECIBELS = (MIXERCONTROL_CT_CLASS_NUMBER + MIXERCONTROL_CT_UNITS_DECIBELS)
MIXERCONTROL_CONTROLTYPE_SIGNED = (MIXERCONTROL_CT_CLASS_NUMBER + MIXERCONTROL_CT_UNITS_SIGNED)
MIXERCONTROL_CONTROLTYPE_UNSIGNED = (MIXERCONTROL_CT_CLASS_NUMBER + MIXERCONTROL_CT_UNITS_UNSIGNED)
MIXERCONTROL_CONTROLTYPE_PERCENT = (MIXERCONTROL_CT_CLASS_NUMBER + MIXERCONTROL_CT_UNITS_PERCENT)
MIXERCONTROL_CONTROLTYPE_SLIDER = (MIXERCONTROL_CT_CLASS_SLIDER + MIXERCONTROL_CT_UNITS_SIGNED)
MIXERCONTROL_CONTROLTYPE_PAN	= (MIXERCONTROL_CONTROLTYPE_SLIDER + 1)
MIXERCONTROL_CONTROLTYPE_QSOUNDPAN = (MIXERCONTROL_CONTROLTYPE_SLIDER + 2)
MIXERCONTROL_CONTROLTYPE_FADER	= (MIXERCONTROL_CT_CLASS_FADER + MIXERCONTROL_CT_UNITS_UNSIGNED)
MIXERCONTROL_CONTROLTYPE_VOLUME = (MIXERCONTROL_CONTROLTYPE_FADER + 1)
MIXERCONTROL_CONTROLTYPE_BASS	= (MIXERCONTROL_CONTROLTYPE_FADER + 2)
MIXERCONTROL_CONTROLTYPE_TREBLE = (MIXERCONTROL_CONTROLTYPE_FADER + 3)
MIXERCONTROL_CONTROLTYPE_EQUALIZER = (MIXERCONTROL_CONTROLTYPE_FADER + 4)
MIXERCONTROL_CONTROLTYPE_SINGLESELECT = (MIXERCONTROL_CT_CLASS_LIST + MIXERCONTROL_CT_SC_LIST_SINGLE + MIXERCONTROL_CT_UNITS_BOOLEAN)
MIXERCONTROL_CONTROLTYPE_MUX	= (MIXERCONTROL_CONTROLTYPE_SINGLESELECT + 1)
MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT = (MIXERCONTROL_CT_CLASS_LIST + MIXERCONTROL_CT_SC_LIST_MULTIPLE + MIXERCONTROL_CT_UNITS_BOOLEAN)
MIXERCONTROL_CONTROLTYPE_MIXER	= (MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT + 1)
MIXERCONTROL_CONTROLTYPE_MICROTIME = (MIXERCONTROL_CT_CLASS_TIME + MIXERCONTROL_CT_SC_TIME_MICROSECS + MIXERCONTROL_CT_UNITS_UNSIGNED)
MIXERCONTROL_CONTROLTYPE_MILLITIME = (MIXERCONTROL_CT_CLASS_TIME + MIXERCONTROL_CT_SC_TIME_MILLISECS + MIXERCONTROL_CT_UNITS_UNSIGNED)

;
;  MIXERLINECONTROLS
;

struc	MIXERLINECONTROLS
	cbStruct		dd ?		; size in bytes of MIXERLINECONTROLS
	dwLineID		dd ?		; line id (from MIXERLINE.dwLineID)
label	dwControlID		dword		; MIXER_GETLINECONTROLSF_ONEBYID
	dwControlType		dd ?		; MIXER_GETLINECONTROLSF_ONEBYTYPE
	cControls		dd ?		; count of controls pmxctrl points to
	cbmxctrl		dd ?		; size in bytes of _one_ MIXERCONTROL
	pamxctrl		dd ?		; pointer to first MIXERCONTROL array
ends

procdesc mixerGetLineControlsA :dword, :dword, :dword

mixerGetLineControls		equ <mixerGetLineControlsA>

MIXER_GETLINECONTROLSF_ALL	= 000000000h
MIXER_GETLINECONTROLSF_ONEBYID	= 000000001h
MIXER_GETLINECONTROLSF_ONEBYTYPE = 000000002h

MIXER_GETLINECONTROLSF_QUERYMASK = 00000000Fh

struc	MIXERCONTROLDETAILS
	cbStruct		dd ?		; size in bytes of MIXERCONTROLDETAILS
	dwControlID		dd ?		; control id to get/set details on
	cChannels		dd ?		; number of channels in paDetails array
label	hwndOwner		dword		; for MIXER_SETCONTROLDETAILSF_CUSTOM
	cMultipleItems		dd ?		; if _MULTIPLE, the number of items per channel
	cbDetails		dd ?		; size of _one_ details_XX struct
	paDetails		dd ?		; pointer to array of details_XX structs
ends

;
;  MIXER_GETCONTROLDETAILSF_LISTTEXT
;

struc	MIXERCONTROLDETAILS_LISTTEXT
	dwParam1		dd ?
	dwParam2		dd ?
	szName			db MIXER_LONG_NAME_CHARS dup (?)
ends

;
;  MIXER_GETCONTROLDETAILSF_VALUE
;

struc	MIXERCONTROLDETAILS_BOOLEAN
	fValue			dd ?
ends

struc	MIXERCONTROLDETAILS_SIGNED
	lValue			dd ?
ends

struc	MIXERCONTROLDETAILS_UNSIGNED
	dwValue 		dd ?
ends

procdesc mixerGetControlDetailsA :dword, :dword, :dword

mixerGetControlDetails		equ <mixerGetControlDetailsA>

MIXER_GETCONTROLDETAILSF_VALUE	= 000000000h
MIXER_GETCONTROLDETAILSF_LISTTEXT = 000000001h

MIXER_GETCONTROLDETAILSF_QUERYMASK = 00000000Fh

procdesc mixerSetControlDetailsA :dword, :dword, :dword

MIXER_SETCONTROLDETAILSF_VALUE	= 000000000h
MIXER_SETCONTROLDETAILSF_CUSTOM = 000000001h

MIXER_SETCONTROLDETAILSF_QUERYMASK = 00000000Fh

;***************************************************************************
;
;			    Timer support
;
;***************************************************************************

; timer error return values
TIMERR_NOERROR			= (0)		       ; no error
TIMERR_NOCANDO			= (TIMERR_BASE+1)      ; request not completed
TIMERR_STRUCT			= (TIMERR_BASE+33)     ; time struct size

proctype TIMECALLBACK :dword, :dword, :dword, :dword, :dword

; flags for fuEvent parameter of timeSetEvent() function
TIME_ONESHOT			= 00000h   ; program timer for single event
TIME_PERIODIC			= 00001h   ; program for continuous periodic event

TIME_CALLBACK_FUNCTION		= 00000h  ; callback is function
TIME_CALLBACK_EVENT_SET 	= 00010h  ; callback is event - use SetEvent
TIME_CALLBACK_EVENT_PULSE	= 00020h  ; callback is event - use PulseEvent

; timer device capabilities data structure

struc	TIMECAPS
	wPeriodMin		dd ?		; minimum period supported
	wPeriodMax		dd ?		; maximum period supported
ends

; timer function prototypes

procdesc timeGetSystemTime :dword, :dword
procdesc timeGetTime
procdesc timeSetEvent :dword, :dword, :dword, :dword, :dword
procdesc timeKillEvent :dword
procdesc timeGetDevCaps :dword, :dword
procdesc timeBeginPeriod :dword
procdesc timeEndPeriod :dword

;***************************************************************************
;
;			    Joystick support
;
;***************************************************************************

; joystick error return values
JOYERR_NOERROR			= (0)		       ; no error
JOYERR_PARMS			= (JOYERR_BASE+5)      ; bad parameters
JOYERR_NOCANDO			= (JOYERR_BASE+6)      ; request not completed
JOYERR_UNPLUGGED		= (JOYERR_BASE+7)      ; joystick is unplugged

; constants used with JOYINFO and JOYINFOEX structures and MM_JOY* messages
JOY_BUTTON1			= 00001h
JOY_BUTTON2			= 00002h
JOY_BUTTON3			= 00004h
JOY_BUTTON4			= 00008h
JOY_BUTTON1CHG			= 00100h
JOY_BUTTON2CHG			= 00200h
JOY_BUTTON3CHG			= 00400h
JOY_BUTTON4CHG			= 00800h

; constants used with JOYINFOEX
JOY_BUTTON5			= 000000010h
JOY_BUTTON6			= 000000020h
JOY_BUTTON7			= 000000040h
JOY_BUTTON8			= 000000080h
JOY_BUTTON9			= 000000100h
JOY_BUTTON10			= 000000200h
JOY_BUTTON11			= 000000400h
JOY_BUTTON12			= 000000800h
JOY_BUTTON13			= 000001000h
JOY_BUTTON14			= 000002000h
JOY_BUTTON15			= 000004000h
JOY_BUTTON16			= 000008000h
JOY_BUTTON17			= 000010000h
JOY_BUTTON18			= 000020000h
JOY_BUTTON19			= 000040000h
JOY_BUTTON20			= 000080000h
JOY_BUTTON21			= 000100000h
JOY_BUTTON22			= 000200000h
JOY_BUTTON23			= 000400000h
JOY_BUTTON24			= 000800000h
JOY_BUTTON25			= 001000000h
JOY_BUTTON26			= 002000000h
JOY_BUTTON27			= 004000000h
JOY_BUTTON28			= 008000000h
JOY_BUTTON29			= 010000000h
JOY_BUTTON30			= 020000000h
JOY_BUTTON31			= 040000000h
JOY_BUTTON32			= 080000000h

; constants used with JOYINFOEX structure
JOY_POVCENTERED 		= -1
JOY_POVFORWARD			= 0
JOY_POVRIGHT			= 9000
JOY_POVBACKWARD 		= 18000
JOY_POVLEFT			= 27000

JOY_RETURNX			= 000000001h
JOY_RETURNY			= 000000002h
JOY_RETURNZ			= 000000004h
JOY_RETURNR			= 000000008h
JOY_RETURNU			= 000000010h	; axis 5
JOY_RETURNV			= 000000020h	; axis 6
JOY_RETURNPOV			= 000000040h
JOY_RETURNBUTTONS		= 000000080h
JOY_RETURNRAWDATA		= 000000100h
JOY_RETURNPOVCTS		= 000000200h
JOY_RETURNCENTERED		= 000000400h
JOY_USEDEADZONE 		= 000000800h
JOY_RETURNALL			= (JOY_RETURNX + JOY_RETURNY + JOY_RETURNZ +\
				   JOY_RETURNR + JOY_RETURNU + JOY_RETURNV +\
				   JOY_RETURNPOV + JOY_RETURNBUTTONS)
JOY_CAL_READALWAYS		= 000010000h
JOY_CAL_READXYONLY		= 000020000h
JOY_CAL_READ3			= 000040000h
JOY_CAL_READ4			= 000080000h
JOY_CAL_READXONLY		= 000100000h
JOY_CAL_READYONLY		= 000200000h
JOY_CAL_READ5			= 000400000h
JOY_CAL_READ6			= 000800000h
JOY_CAL_READZONLY		= 001000000h
JOY_CAL_READRONLY		= 002000000h
JOY_CAL_READUONLY		= 004000000h
JOY_CAL_READVONLY		= 008000000h

; joystick ID constants
JOYSTICKID1			= 0
JOYSTICKID2			= 1

; joystick driver capabilites
JOYCAPS_HASZ			= 00001h
JOYCAPS_HASR			= 00002h
JOYCAPS_HASU			= 00004h
JOYCAPS_HASV			= 00008h
JOYCAPS_HASPOV			= 00010h
JOYCAPS_POV4DIR 		= 00020h
JOYCAPS_POVCTS			= 00040h

; joystick device capabilities data structure

struc	JOYCAPS
	wMid			dw ?		; manufacturer ID
	wPid			dw ?		; product ID
	szPname 		db MAXPNAMELEN dup (?) ; product name (NULL terminated string)
	wXmin			dd ?		; minimum x position value
	wXmax			dd ?		; maximum x position value
	wYmin			dd ?		; minimum y position value
	wYmax			dd ?		; maximum y position value
	wZmin			dd ?		; minimum z position value
	wZmax			dd ?		; maximum z position value
	wNumButtons		dd ?		; number of buttons
	wPeriodMin		dd ?		; minimum message period when captured
	wPeriodMax		dd ?		; maximum message period when captured
	wRmin			dd ?		; minimum r position value
	wRmax			dd ?		; maximum r position value
	wUmin			dd ?		; minimum u (5th axis) position value
	wUmax			dd ?		; maximum u (5th axis) position value
	wVmin			dd ?		; minimum v (6th axis) position value
	wVmax			dd ?		; maximum v (6th axis) position value
	wCaps			dd ?		; joystick capabilites
	wMaxAxes		dd ?		; maximum number of axes supported
	wNumAxes		dd ?		; number of axes in use
	wMaxButtons		dd ?		; maximum number of buttons supported
	szRegKey		db MAXPNAMELEN dup (?) ; registry key
	szOEMVxD		db MAX_JOYSTICKOEMVXDNAME dup (?) ; OEM VxD in use
ends

; joystick information data structure

struc	JOYINFO
	wXpos			dd ?		; x position
	wYpos			dd ?		; y position
	wZpos			dd ?		; z position
	wButtons		dd ?		; button states
ends

struc	JOYINFOEX
	dwSize			dd ?		; size of structure
	dwFlags 		dd ?		; flags to indicate what to return
	dwXpos			dd ?		; x position
	dwYpos			dd ?		; y position
	dwZpos			dd ?		; z position
	dwRpos			dd ?		; rudder/4th axis position
	dwUpos			dd ?		; 5th axis position
	dwVpos			dd ?		; 6th axis position
	dwButtons		dd ?		; button states
	dwButtonNumber		dd ?		; current button number pressed
	dwPOV			dd ?		; point of view state
	dwReserved1		dd ?		; reserved for communication between winmm & driver
	dwReserved2		dd ?		; reserved for future expansion
ends


; joystick function prototypes

procdesc joyGetNumDevs
procdesc joyGetDevCapsA :dword, :dword, :dword
procdesc joyGetPos :dword, :dword
procdesc joyGetPosEx :dword, :dword
procdesc joyGetThreshold :dword, :dword
procdesc joyReleaseCapture :dword
procdesc joySetCapture :dword, :dword, :dword, :dword
procdesc joySetThreshold :dword, :dword

joyGetDevCaps			equ <joyGetDevCapsA>

;***************************************************************************
;
;			Multimedia File I/O support
;
;***************************************************************************

; MMIO error return values
MMIOERR_BASE			= 256
MMIOERR_FILENOTFOUND		= (MMIOERR_BASE + 1)  ; file not found
MMIOERR_OUTOFMEMORY		= (MMIOERR_BASE + 2)  ; out of memory
MMIOERR_CANNOTOPEN		= (MMIOERR_BASE + 3)  ; cannot open
MMIOERR_CANNOTCLOSE		= (MMIOERR_BASE + 4)  ; cannot close
MMIOERR_CANNOTREAD		= (MMIOERR_BASE + 5)  ; cannot read
MMIOERR_CANNOTWRITE		= (MMIOERR_BASE + 6)  ; cannot write
MMIOERR_CANNOTSEEK		= (MMIOERR_BASE + 7)  ; cannot seek
MMIOERR_CANNOTEXPAND		= (MMIOERR_BASE + 8)  ; cannot expand file
MMIOERR_CHUNKNOTFOUND		= (MMIOERR_BASE + 9)  ; chunk not found
MMIOERR_UNBUFFERED		= (MMIOERR_BASE + 10) ;
MMIOERR_PATHNOTFOUND		= (MMIOERR_BASE + 11) ; path incorrect
MMIOERR_ACCESSDENIED		= (MMIOERR_BASE + 12) ; file was protected
MMIOERR_SHARINGVIOLATION	= (MMIOERR_BASE + 13) ; file in use
MMIOERR_NETWORKERROR		= (MMIOERR_BASE + 14) ; network not responding
MMIOERR_TOOMANYOPENFILES	= (MMIOERR_BASE + 15) ; no more file handles
MMIOERR_INVALIDFILE		= (MMIOERR_BASE + 16) ; default error file error

; MMIO constants
CFSEPCHAR			equ <'+'>	      ; compound file name separator char.

proctype MMIOPROC :dword, :dword, :dword, :dword

; general MMIO information data structure

struc	MMIOINFO				; general fields
	dwFlags 		dd ?		; general status flags
	fccIOProc		dd ?		; pointer to I/O procedure
	pIOProc 		dd ?		; pointer to I/O procedure
	wErrorRet		dd ?		; place for error to be returned
	htask			dd ?		; alternate local task	; fields maintained by MMIO functions during buffered I/O
	cchBuffer		dd ?		; size of I/O buffer (or 0L)
	pchBuffer		dd ?		; start of I/O buffer (or NULL)
	pchNext 		dd ?		; pointer to next byte to read/write
	pchEndRead		dd ?		; pointer to last valid byte to read
	pchEndWrite		dd ?		; pointer to last byte to write
	lBufOffset		dd ?		; disk offset of start of buffer  ; fields maintained by I/O procedure
	lDiskOffset		dd ?		; disk offset of next read or write
	adwInfo 		dd 3 dup (?)	; data specific to type of MMIOPROC  ; other fields maintained by MMIO
	dwReserved1		dd ?		; reserved for MMIO use
	dwReserved2		dd ?		; reserved for MMIO use
	hmmio			dd ?		; handle to open file
ends

; RIFF chunk information data structure

struc	MMCKINFO
	ckid			dd ?		; chunk ID
	cksize			dd ?		; chunk size
	fccType 		dd ?		; form type or list type
	dwDataOffset		dd ?		; offset of data portion of chunk
	dwFlags 		dd ?		; flags used by MMIO functions
ends

; bit field masks
MMIO_RWMODE			= 000000003h	  ; open file for reading/writing/both
MMIO_SHAREMODE			= 000000070h	  ; file sharing mode number

; constants for dwFlags field of MMIOINFO
MMIO_CREATE			= 000001000h	  ; create new file (or truncate file)
MMIO_PARSE			= 000000100h	  ; parse new file returning path
MMIO_DELETE			= 000000200h	  ; create new file (or truncate file)
MMIO_EXIST			= 000004000h	  ; checks for existence of file
MMIO_ALLOCBUF			= 000010000h	  ; mmioOpen() should allocate a buffer
MMIO_GETTEMP			= 000020000h	  ; mmioOpen() should retrieve temp name

MMIO_DIRTY			= 010000000h	  ; I/O buffer is dirty

; read/write mode numbers (bit field MMIO_RWMODE)
MMIO_READ			= 000000000h	  ; open file for reading only
MMIO_WRITE			= 000000001h	  ; open file for writing only
MMIO_READWRITE			= 000000002h	  ; open file for reading and writing

; share mode numbers (bit field MMIO_SHAREMODE)
MMIO_COMPAT			= 000000000h	  ; compatibility mode
MMIO_EXCLUSIVE			= 000000010h	  ; exclusive-access mode
MMIO_DENYWRITE			= 000000020h	  ; deny writing to other processes
MMIO_DENYREAD			= 000000030h	  ; deny reading to other processes
MMIO_DENYNONE			= 000000040h	  ; deny nothing to other processes

; various MMIO flags
MMIO_FHOPEN			= 00010h  ; mmioClose: keep file handle open
MMIO_EMPTYBUF			= 00010h  ; mmioFlush: empty the I/O buffer
MMIO_TOUPPER			= 00010h  ; mmioStringToFOURCC: to u-case
MMIO_INSTALLPROC		= 000010000h  ; mmioInstallIOProc: install MMIOProc
MMIO_GLOBALPROC 		= 010000000h  ; mmioInstallIOProc: install globally
MMIO_REMOVEPROC 		= 000020000h  ; mmioInstallIOProc: remove MMIOProc
MMIO_UNICODEPROC		= 001000000h  ; mmioInstallIOProc: Unicode MMIOProc
MMIO_FINDPROC			= 000040000h  ; mmioInstallIOProc: find an MMIOProc
MMIO_FINDCHUNK			= 00010h  ; mmioDescend: find a chunk by ID
MMIO_FINDRIFF			= 00020h  ; mmioDescend: find a LIST chunk
MMIO_FINDLIST			= 00040h  ; mmioDescend: find a RIFF chunk
MMIO_CREATERIFF 		= 00020h  ; mmioCreateChunk: make a LIST chunk
MMIO_CREATELIST 		= 00040h  ; mmioCreateChunk: make a RIFF chunk

; message numbers for MMIOPROC I/O procedure functions
MMIOM_READ			= MMIO_READ	  ; read
MMIOM_WRITE			= MMIO_WRITE	   ; write
MMIOM_SEEK			= 2	  ; seek to a new position in file
MMIOM_OPEN			= 3	  ; open file
MMIOM_CLOSE			= 4	  ; close file
MMIOM_WRITEFLUSH		= 5	  ; write and flush

MMIOM_RENAME			= 6	  ; rename specified file

MMIOM_USER			= 08000h       ; beginning of user-defined messages

; standard four character codes
FOURCC_RIFF			equ <'FFIR'>
FOURCC_LIST			equ <'TSIL'>

; four character codes used to identify standard built-in I/O procedures
FOURCC_DOS			equ <' SOD'>
FOURCC_MEM			equ <' MEM'>

; flags for mmioSeek()
SEEK_SET			= 0		  ; seek to an absolute position
SEEK_CUR			= 1		  ; seek relative to current position
SEEK_END			= 2		  ; seek relative to end of file

; other constants
MMIO_DEFAULTBUFFER		= 8192	  ; default buffer size

; MMIO function prototypes

procdesc mmioStringToFOURCCA :dword, :dword
procdesc mmioInstallIOProcA :dword, :dword, :dword
procdesc mmioOpenA :dword, :dword, :dword
procdesc mmioRenameA :dword, :dword, :dword, :dword
procdesc mmioClose :dword, :dword
procdesc mmioRead :dword, :dword, :dword
procdesc mmioWrite :dword, :dword, :dword
procdesc mmioSeek :dword, :dword, :dword
procdesc mmioGetInfo :dword, :dword, :dword
procdesc mmioSetInfo :dword, :dword, :dword
procdesc mmioSetBuffer :dword, :dword, :dword, :dword
procdesc mmioFlush :dword, :dword
procdesc mmioAdvance :dword, :dword, :dword
procdesc mmioSendMessage :dword, :dword, :dword, :dword
procdesc mmioDescend :dword, :dword, :dword, :dword
procdesc mmioAscend :dword, :dword, :dword
procdesc mmioCreateChunk :dword, :dword, :dword

mmioStringToFOURCC		equ <mmioStringToFOURCCA>
mmioInstallIOProc		equ <mmioInstallIOProcA>
mmioOpen			equ <mmioOpenA>
mmioRename			equ <mmioRenameA>

;***************************************************************************
;
;			    MCI support
;
;***************************************************************************

; MCI function prototypes

proctype YIELDPROC :dword, :dword

procdesc mciSendCommandA :dword, :dword, :dword, :dword
procdesc mciSendStringA :dword, :dword, :dword, :dword
procdesc mciGetDeviceIDA :dword
procdesc mciGetDeviceIDFromElementIDA :dword, :dword
procdesc mciGetErrorStringA :dword, :dword, :dword
procdesc mciSetYieldProc :dword, :dword, :dword
procdesc mciGetCreatorTask :dword
procdesc mciGetYieldProc :dword, :dword
procdesc mciExecute :dword

mciSendCommand			equ <mciSendCommandA>
mciSendString			equ <mciSendStringA>
mciGetDeviceID			equ <mciGetDeviceIDA>
mciGetDeviceIDFromElementID	equ <mciGetDeviceIDFromElementIDA>
mciGetErrorString		equ <mciGetErrorStringA>

; MCI error return values
MCIERR_INVALID_DEVICE_ID	= (MCIERR_BASE + 1)
MCIERR_UNRECOGNIZED_KEYWORD	= (MCIERR_BASE + 3)
MCIERR_UNRECOGNIZED_COMMAND	= (MCIERR_BASE + 5)
MCIERR_HARDWARE 		= (MCIERR_BASE + 6)
MCIERR_INVALID_DEVICE_NAME	= (MCIERR_BASE + 7)
MCIERR_OUT_OF_MEMORY		= (MCIERR_BASE + 8)
MCIERR_DEVICE_OPEN		= (MCIERR_BASE + 9)
MCIERR_CANNOT_LOAD_DRIVER	= (MCIERR_BASE + 10)
MCIERR_MISSING_COMMAND_STRING	= (MCIERR_BASE + 11)
MCIERR_PARAM_OVERFLOW		= (MCIERR_BASE + 12)
MCIERR_MISSING_STRING_ARGUMENT	= (MCIERR_BASE + 13)
MCIERR_BAD_INTEGER		= (MCIERR_BASE + 14)
MCIERR_PARSER_INTERNAL		= (MCIERR_BASE + 15)
MCIERR_DRIVER_INTERNAL		= (MCIERR_BASE + 16)
MCIERR_MISSING_PARAMETER	= (MCIERR_BASE + 17)
MCIERR_UNSUPPORTED_FUNCTION	= (MCIERR_BASE + 18)
MCIERR_FILE_NOT_FOUND		= (MCIERR_BASE + 19)
MCIERR_DEVICE_NOT_READY 	= (MCIERR_BASE + 20)
MCIERR_INTERNAL 		= (MCIERR_BASE + 21)
MCIERR_DRIVER			= (MCIERR_BASE + 22)
MCIERR_CANNOT_USE_ALL		= (MCIERR_BASE + 23)
MCIERR_MULTIPLE 		= (MCIERR_BASE + 24)
MCIERR_EXTENSION_NOT_FOUND	= (MCIERR_BASE + 25)
MCIERR_OUTOFRANGE		= (MCIERR_BASE + 26)
MCIERR_FLAGS_NOT_COMPATIBLE	= (MCIERR_BASE + 28)
MCIERR_FILE_NOT_SAVED		= (MCIERR_BASE + 30)
MCIERR_DEVICE_TYPE_REQUIRED	= (MCIERR_BASE + 31)
MCIERR_DEVICE_LOCKED		= (MCIERR_BASE + 32)
MCIERR_DUPLICATE_ALIAS		= (MCIERR_BASE + 33)
MCIERR_BAD_CONSTANT		= (MCIERR_BASE + 34)
MCIERR_MUST_USE_SHAREABLE	= (MCIERR_BASE + 35)
MCIERR_MISSING_DEVICE_NAME	= (MCIERR_BASE + 36)
MCIERR_BAD_TIME_FORMAT		= (MCIERR_BASE + 37)
MCIERR_NO_CLOSING_QUOTE 	= (MCIERR_BASE + 38)
MCIERR_DUPLICATE_FLAGS		= (MCIERR_BASE + 39)
MCIERR_INVALID_FILE		= (MCIERR_BASE + 40)
MCIERR_NULL_PARAMETER_BLOCK	= (MCIERR_BASE + 41)
MCIERR_UNNAMED_RESOURCE 	= (MCIERR_BASE + 42)
MCIERR_NEW_REQUIRES_ALIAS	= (MCIERR_BASE + 43)
MCIERR_NOTIFY_ON_AUTO_OPEN	= (MCIERR_BASE + 44)
MCIERR_NO_ELEMENT_ALLOWED	= (MCIERR_BASE + 45)
MCIERR_NONAPPLICABLE_FUNCTION	= (MCIERR_BASE + 46)
MCIERR_ILLEGAL_FOR_AUTO_OPEN	= (MCIERR_BASE + 47)
MCIERR_FILENAME_REQUIRED	= (MCIERR_BASE + 48)
MCIERR_EXTRA_CHARACTERS 	= (MCIERR_BASE + 49)
MCIERR_DEVICE_NOT_INSTALLED	= (MCIERR_BASE + 50)
MCIERR_GET_CD			= (MCIERR_BASE + 51)
MCIERR_SET_CD			= (MCIERR_BASE + 52)
MCIERR_SET_DRIVE		= (MCIERR_BASE + 53)
MCIERR_DEVICE_LENGTH		= (MCIERR_BASE + 54)
MCIERR_DEVICE_ORD_LENGTH	= (MCIERR_BASE + 55)
MCIERR_NO_INTEGER		= (MCIERR_BASE + 56)

MCIERR_WAVE_OUTPUTSINUSE	= (MCIERR_BASE + 64)
MCIERR_WAVE_SETOUTPUTINUSE	= (MCIERR_BASE + 65)
MCIERR_WAVE_INPUTSINUSE 	= (MCIERR_BASE + 66)
MCIERR_WAVE_SETINPUTINUSE	= (MCIERR_BASE + 67)
MCIERR_WAVE_OUTPUTUNSPECIFIED	= (MCIERR_BASE + 68)
MCIERR_WAVE_INPUTUNSPECIFIED	= (MCIERR_BASE + 69)
MCIERR_WAVE_OUTPUTSUNSUITABLE	= (MCIERR_BASE + 70)
MCIERR_WAVE_SETOUTPUTUNSUITABLE = (MCIERR_BASE + 71)
MCIERR_WAVE_INPUTSUNSUITABLE	= (MCIERR_BASE + 72)
MCIERR_WAVE_SETINPUTUNSUITABLE	= (MCIERR_BASE + 73)

MCIERR_SEQ_DIV_INCOMPATIBLE	= (MCIERR_BASE + 80)
MCIERR_SEQ_PORT_INUSE		= (MCIERR_BASE + 81)
MCIERR_SEQ_PORT_NONEXISTENT	= (MCIERR_BASE + 82)
MCIERR_SEQ_PORT_MAPNODEVICE	= (MCIERR_BASE + 83)
MCIERR_SEQ_PORT_MISCERROR	= (MCIERR_BASE + 84)
MCIERR_SEQ_TIMER		= (MCIERR_BASE + 85)
MCIERR_SEQ_PORTUNSPECIFIED	= (MCIERR_BASE + 86)
MCIERR_SEQ_NOMIDIPRESENT	= (MCIERR_BASE + 87)

MCIERR_NO_WINDOW		= (MCIERR_BASE + 90)
MCIERR_CREATEWINDOW		= (MCIERR_BASE + 91)
MCIERR_FILE_READ		= (MCIERR_BASE + 92)
MCIERR_FILE_WRITE		= (MCIERR_BASE + 93)

MCIERR_NO_IDENTITY		= (MCIERR_BASE + 94)

; all custom device driver errors must be >= than this value
MCIERR_CUSTOM_DRIVER_BASE	= (MCIERR_BASE + 256)

MCI_FIRST			= DRV_MCI_FIRST   ; 0x0800
; MCI command message identifiers
MCI_OPEN			= 00803h
MCI_CLOSE			= 00804h
MCI_ESCAPE			= 00805h
MCI_PLAY			= 00806h
MCI_SEEK			= 00807h
MCI_STOP			= 00808h
MCI_PAUSE			= 00809h
MCI_INFO			= 0080Ah
MCI_GETDEVCAPS			= 0080Bh
MCI_SPIN			= 0080Ch
MCI_SET 			= 0080Dh
MCI_STEP			= 0080Eh
MCI_RECORD			= 0080Fh
MCI_SYSINFO			= 00810h
MCI_BREAK			= 00811h
MCI_SAVE			= 00813h
MCI_STATUS			= 00814h
MCI_CUE 			= 00830h
MCI_REALIZE			= 00840h
MCI_WINDOW			= 00841h
MCI_PUT 			= 00842h
MCI_WHERE			= 00843h
MCI_FREEZE			= 00844h
MCI_UNFREEZE			= 00845h
MCI_LOAD			= 00850h
MCI_CUT 			= 00851h
MCI_COPY			= 00852h
MCI_PASTE			= 00853h
MCI_UPDATE			= 00854h
MCI_RESUME			= 00855h
MCI_DELETE			= 00856h

; all custom MCI command messages must be >= than this value
MCI_USER_MESSAGES		= (DRV_MCI_FIRST + 0400h)
MCI_LAST			= 00FFFh

; device ID for "all devices"
MCI_ALL_DEVICE_ID		= (-1)

; constants for predefined MCI device types
MCI_DEVTYPE_VCR 		= 513 ; (MCI_STRING_OFFSET + 1)
MCI_DEVTYPE_VIDEODISC		= 514 ; (MCI_STRING_OFFSET + 2)
MCI_DEVTYPE_OVERLAY		= 515 ; (MCI_STRING_OFFSET + 3)
MCI_DEVTYPE_CD_AUDIO		= 516 ; (MCI_STRING_OFFSET + 4)
MCI_DEVTYPE_DAT 		= 517 ; (MCI_STRING_OFFSET + 5)
MCI_DEVTYPE_SCANNER		= 518 ; (MCI_STRING_OFFSET + 6)
MCI_DEVTYPE_ANIMATION		= 519 ; (MCI_STRING_OFFSET + 7)
MCI_DEVTYPE_DIGITAL_VIDEO	= 520 ; (MCI_STRING_OFFSET + 8)
MCI_DEVTYPE_OTHER		= 521 ; (MCI_STRING_OFFSET + 9)
MCI_DEVTYPE_WAVEFORM_AUDIO	= 522 ; (MCI_STRING_OFFSET + 10)
MCI_DEVTYPE_SEQUENCER		= 523 ; (MCI_STRING_OFFSET + 11)

MCI_DEVTYPE_FIRST		= MCI_DEVTYPE_VCR
MCI_DEVTYPE_LAST		= MCI_DEVTYPE_SEQUENCER

MCI_DEVTYPE_FIRST_USER		= 01000h
; return values for 'status mode' command
MCI_MODE_NOT_READY		= (MCI_STRING_OFFSET + 12)
MCI_MODE_STOP			= (MCI_STRING_OFFSET + 13)
MCI_MODE_PLAY			= (MCI_STRING_OFFSET + 14)
MCI_MODE_RECORD 		= (MCI_STRING_OFFSET + 15)
MCI_MODE_SEEK			= (MCI_STRING_OFFSET + 16)
MCI_MODE_PAUSE			= (MCI_STRING_OFFSET + 17)
MCI_MODE_OPEN			= (MCI_STRING_OFFSET + 18)

; constants used in 'set time format' and 'status time format' commands
MCI_FORMAT_MILLISECONDS 	= 0
MCI_FORMAT_HMS			= 1
MCI_FORMAT_MSF			= 2
MCI_FORMAT_FRAMES		= 3
MCI_FORMAT_SMPTE_24		= 4
MCI_FORMAT_SMPTE_25		= 5
MCI_FORMAT_SMPTE_30		= 6
MCI_FORMAT_SMPTE_30DROP 	= 7
MCI_FORMAT_BYTES		= 8
MCI_FORMAT_SAMPLES		= 9
MCI_FORMAT_TMSF 		= 10

; flags for wParam of MM_MCINOTIFY message
MCI_NOTIFY_SUCCESSFUL		= 00001h
MCI_NOTIFY_SUPERSEDED		= 00002h
MCI_NOTIFY_ABORTED		= 00004h
MCI_NOTIFY_FAILURE		= 00008h

; common flags for dwFlags parameter of MCI command messages
MCI_NOTIFY			= 000000001h
MCI_WAIT			= 000000002h
MCI_FROM			= 000000004h
MCI_TO				= 000000008h
MCI_TRACK			= 000000010h

; flags for dwFlags parameter of MCI_OPEN command message
MCI_OPEN_SHAREABLE		= 000000100h
MCI_OPEN_ELEMENT		= 000000200h
MCI_OPEN_ALIAS			= 000000400h
MCI_OPEN_ELEMENT_ID		= 000000800h
MCI_OPEN_TYPE_ID		= 000001000h
MCI_OPEN_TYPE			= 000002000h

; flags for dwFlags parameter of MCI_SEEK command message
MCI_SEEK_TO_START		= 000000100h
MCI_SEEK_TO_END 		= 000000200h

; flags for dwFlags parameter of MCI_STATUS command message
MCI_STATUS_ITEM 		= 000000100h
MCI_STATUS_START		= 000000200h

; flags for dwItem field of the MCI_STATUS_PARMS parameter block
MCI_STATUS_LENGTH		= 000000001h
MCI_STATUS_POSITION		= 000000002h
MCI_STATUS_NUMBER_OF_TRACKS	= 000000003h
MCI_STATUS_MODE 		= 000000004h
MCI_STATUS_MEDIA_PRESENT	= 000000005h
MCI_STATUS_TIME_FORMAT		= 000000006h
MCI_STATUS_READY		= 000000007h
MCI_STATUS_CURRENT_TRACK	= 000000008h

; flags for dwFlags parameter of MCI_INFO command message
MCI_INFO_PRODUCT		= 000000100h
MCI_INFO_FILE			= 000000200h
MCI_INFO_MEDIA_UPC		= 000000400h
MCI_INFO_MEDIA_IDENTITY 	= 000000800h
MCI_INFO_NAME			= 000001000h
MCI_INFO_COPYRIGHT		= 000002000h

; flags for dwFlags parameter of MCI_GETDEVCAPS command message
MCI_GETDEVCAPS_ITEM		= 000000100h

; flags for dwItem field of the MCI_GETDEVCAPS_PARMS parameter block
MCI_GETDEVCAPS_CAN_RECORD	= 000000001h
MCI_GETDEVCAPS_HAS_AUDIO	= 000000002h
MCI_GETDEVCAPS_HAS_VIDEO	= 000000003h
MCI_GETDEVCAPS_DEVICE_TYPE	= 000000004h
MCI_GETDEVCAPS_USES_FILES	= 000000005h
MCI_GETDEVCAPS_COMPOUND_DEVICE	= 000000006h
MCI_GETDEVCAPS_CAN_EJECT	= 000000007h
MCI_GETDEVCAPS_CAN_PLAY 	= 000000008h
MCI_GETDEVCAPS_CAN_SAVE 	= 000000009h

; flags for dwFlags parameter of MCI_SYSINFO command message
MCI_SYSINFO_QUANTITY		= 000000100h
MCI_SYSINFO_OPEN		= 000000200h
MCI_SYSINFO_NAME		= 000000400h
MCI_SYSINFO_INSTALLNAME 	= 000000800h

; flags for dwFlags parameter of MCI_SET command message
MCI_SET_DOOR_OPEN		= 000000100h
MCI_SET_DOOR_CLOSED		= 000000200h
MCI_SET_TIME_FORMAT		= 000000400h
MCI_SET_AUDIO			= 000000800h
MCI_SET_VIDEO			= 000001000h
MCI_SET_ON			= 000002000h
MCI_SET_OFF			= 000004000h

; flags for dwAudio field of MCI_SET_PARMS or MCI_SEQ_SET_PARMS
MCI_SET_AUDIO_ALL		= 000000000h
MCI_SET_AUDIO_LEFT		= 000000001h
MCI_SET_AUDIO_RIGHT		= 000000002h

; flags for dwFlags parameter of MCI_BREAK command message
MCI_BREAK_KEY			= 000000100h
MCI_BREAK_HWND			= 000000200h
MCI_BREAK_OFF			= 000000400h

; flags for dwFlags parameter of MCI_RECORD command message
MCI_RECORD_INSERT		= 000000100h
MCI_RECORD_OVERWRITE		= 000000200h

; flags for dwFlags parameter of MCI_SAVE command message
MCI_SAVE_FILE			= 000000100h

; flags for dwFlags parameter of MCI_LOAD command message
MCI_LOAD_FILE			= 000000100h

; generic parameter block for MCI command messages with no special parameters

struc	MCI_GENERIC_PARMS
	dwCallback		dd ?
ends

; parameter block for MCI_OPEN command message

struc	MCI_OPEN_PARMS
	dwCallback		dd ?
	wDeviceID		dd ?
	lpstrDeviceType 	dd ?
	lpstrElementName	dd ?
	lpstrAlias		dd ?
ends

; parameter block for MCI_PLAY command message

struc	MCI_PLAY_PARMS
	dwCallback		dd ?
	dwFrom			dd ?
	dwTo			dd ?
ends

; parameter block for MCI_SEEK command message

struc	MCI_SEEK_PARMS
	dwCallback		dd ?
	dwTo			dd ?
ends

; parameter block for MCI_STATUS command message

struc	MCI_STATUS_PARMS
	dwCallback		dd ?
	dwReturn		dd ?
	dwItem			dd ?
	dwTrack 		dd ?
ends

; parameter block for MCI_INFO command message

struc	MCI_INFO_PARMS
	dwCallback		dd ?
	lpstrReturn		dd ?
	dwRetSize		dd ?
ends

; parameter block for MCI_GETDEVCAPS command message

struc	MCI_GETDEVCAPS_PARMS
	dwCallback		dd ?
	dwReturn		dd ?
	dwItem			dd ?
ends

; parameter block for MCI_SYSINFO command message

struc	MCI_SYSINFO_PARMS
	dwCallback		dd ?
	lpstrReturn		dd ?
	dwRetSize		dd ?
	dwNumber		dd ?
	wDeviceType		dd ?
ends

; parameter block for MCI_SET command message

struc	MCI_SET_PARMS
	dwCallback		dd ?
	dwTimeFormat		dd ?
	dwAudio 		dd ?
ends

; parameter block for MCI_BREAK command message

struc	MCI_BREAK_PARMS
	dwCallback		dd ?
	nVirtKey		dd ?
	hwndBreak		dd ?
ends

; parameter block for MCI_SAVE command message

struc	MCI_SAVE_PARMS
	dwCallback		dd ?
	lpfilename		dd ?
ends

; parameter block for MCI_LOAD command message

struc	MCI_LOAD_PARMS
	dwCallback		dd ?
	lpfilename		dd ?
ends

; parameter block for MCI_RECORD command message

struc	MCI_RECORD_PARMS
	dwCallback		dd ?
	dwFrom			dd ?
	dwTo			dd ?
ends

; MCI extensions for videodisc devices

; flag for dwReturn field of MCI_STATUS_PARMS
; MCI_STATUS command, (dwItem == MCI_STATUS_MODE)
MCI_VD_MODE_PARK		= (MCI_VD_OFFSET + 1)

; flag for dwReturn field of MCI_STATUS_PARMS
; MCI_STATUS command, (dwItem == MCI_VD_STATUS_MEDIA_TYPE)
MCI_VD_MEDIA_CLV		= (MCI_VD_OFFSET + 2)
MCI_VD_MEDIA_CAV		= (MCI_VD_OFFSET + 3)
MCI_VD_MEDIA_OTHER		= (MCI_VD_OFFSET + 4)

MCI_VD_FORMAT_TRACK		= 04001h

; flags for dwFlags parameter of MCI_PLAY command message
MCI_VD_PLAY_REVERSE		= 000010000h
MCI_VD_PLAY_FAST		= 000020000h
MCI_VD_PLAY_SPEED		= 000040000h
MCI_VD_PLAY_SCAN		= 000080000h
MCI_VD_PLAY_SLOW		= 000100000h

; flag for dwFlags parameter of MCI_SEEK command message
MCI_VD_SEEK_REVERSE		= 000010000h

; flags for dwItem field of MCI_STATUS_PARMS parameter block
MCI_VD_STATUS_SPEED		= 000004002h
MCI_VD_STATUS_FORWARD		= 000004003h
MCI_VD_STATUS_MEDIA_TYPE	= 000004004h
MCI_VD_STATUS_SIDE		= 000004005h
MCI_VD_STATUS_DISC_SIZE 	= 000004006h

; flags for dwFlags parameter of MCI_GETDEVCAPS command message
MCI_VD_GETDEVCAPS_CLV		= 000010000h
MCI_VD_GETDEVCAPS_CAV		= 000020000h

MCI_VD_SPIN_UP			= 000010000h
MCI_VD_SPIN_DOWN		= 000020000h

; flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
MCI_VD_GETDEVCAPS_CAN_REVERSE	= 000004002h
MCI_VD_GETDEVCAPS_FAST_RATE	= 000004003h
MCI_VD_GETDEVCAPS_SLOW_RATE	= 000004004h
MCI_VD_GETDEVCAPS_NORMAL_RATE	= 000004005h

; flags for the dwFlags parameter of MCI_STEP command message
MCI_VD_STEP_FRAMES		= 000010000h
MCI_VD_STEP_REVERSE		= 000020000h

; flag for the MCI_ESCAPE command message
MCI_VD_ESCAPE_STRING		= 000000100h

; parameter block for MCI_PLAY command message

struc	MCI_VD_PLAY_PARMS
	dwCallback		dd ?
	dwFrom			dd ?
	dwTo			dd ?
	dwSpeed 		dd ?
ends

; parameter block for MCI_STEP command message

struc	MCI_VD_STEP_PARMS
	dwCallback		dd ?
	dwFrames		dd ?
ends

; parameter block for MCI_ESCAPE command message

struc	MCI_VD_ESCAPE_PARMS
	dwCallback		dd ?
	lpstrCommand		dd ?
ends

; MCI extensions for CD audio devices

; flags for the dwItem field of the MCI_STATUS_PARMS parameter block
MCI_CDA_STATUS_TYPE_TRACK	= 000004001h

; flags for the dwReturn field of MCI_STATUS_PARMS parameter block
; MCI_STATUS command, (dwItem == MCI_CDA_STATUS_TYPE_TRACK)
MCI_CDA_TRACK_AUDIO		= (MCI_CD_OFFSET + 0)
MCI_CDA_TRACK_OTHER		= (MCI_CD_OFFSET + 1)

; MCI extensions for waveform audio devices

MCI_WAVE_PCM			= (MCI_WAVE_OFFSET + 0)
MCI_WAVE_MAPPER 		= (MCI_WAVE_OFFSET + 1)

; flags for the dwFlags parameter of MCI_OPEN command message
MCI_WAVE_OPEN_BUFFER		= 000010000h

; flags for the dwFlags parameter of MCI_SET command message
MCI_WAVE_SET_FORMATTAG		= 000010000h
MCI_WAVE_SET_CHANNELS		= 000020000h
MCI_WAVE_SET_SAMPLESPERSEC	= 000040000h
MCI_WAVE_SET_AVGBYTESPERSEC	= 000080000h
MCI_WAVE_SET_BLOCKALIGN 	= 000100000h
MCI_WAVE_SET_BITSPERSAMPLE	= 000200000h

; flags for the dwFlags parameter of MCI_STATUS, MCI_SET command messages
MCI_WAVE_INPUT			= 000400000h
MCI_WAVE_OUTPUT 		= 000800000h

; flags for the dwItem field of MCI_STATUS_PARMS parameter block
MCI_WAVE_STATUS_FORMATTAG	= 000004001h
MCI_WAVE_STATUS_CHANNELS	= 000004002h
MCI_WAVE_STATUS_SAMPLESPERSEC	= 000004003h
MCI_WAVE_STATUS_AVGBYTESPERSEC	= 000004004h
MCI_WAVE_STATUS_BLOCKALIGN	= 000004005h
MCI_WAVE_STATUS_BITSPERSAMPLE	= 000004006h
MCI_WAVE_STATUS_LEVEL		= 000004007h

; flags for the dwFlags parameter of MCI_SET command message
MCI_WAVE_SET_ANYINPUT		= 004000000h
MCI_WAVE_SET_ANYOUTPUT		= 008000000h

; flags for the dwFlags parameter of MCI_GETDEVCAPS command message
MCI_WAVE_GETDEVCAPS_INPUTS	= 000004001h
MCI_WAVE_GETDEVCAPS_OUTPUTS	= 000004002h

; parameter block for MCI_OPEN command message

struc	MCI_WAVE_OPEN_PARMS
	dwCallback		dd ?
	wDeviceID		dd ?
	lpstrDeviceType 	dd ?
	lpstrElementName	dd ?
	lpstrAlias		dd ?
	dwBufferSeconds 	dd ?
ends

; parameter block for MCI_DELETE command message

struc	MCI_WAVE_DELETE_PARMS
	dwCallback		dd ?
	dwFrom			dd ?
	dwTo			dd ?
ends

; parameter block for MCI_SET command message

struc	MCI_WAVE_SET_PARMS
	dwCallback		dd ?
	dwTimeFormat		dd ?
	dwAudio 		dd ?
	wInput			dd ?
	wOutput 		dd ?
	wFormatTag		dw ?
	wReserved2		dw ?
	nChannels		dw ?
	wReserved3		dw ?
	nSamplesPerSec		dd ?
	nAvgBytesPerSec 	dd ?
	nBlockAlign		dw ?
	wReserved4		dw ?
	wBitsPerSample		dw ?
	wReserved5		dw ?
ends

; MCI extensions for MIDI sequencer devices

; flags for the dwReturn field of MCI_STATUS_PARMS parameter block
; MCI_STATUS command, (dwItem == MCI_SEQ_STATUS_DIVTYPE)
MCI_SEQ_DIV_PPQN		= (0 + MCI_SEQ_OFFSET)
MCI_SEQ_DIV_SMPTE_24		= (1 + MCI_SEQ_OFFSET)
MCI_SEQ_DIV_SMPTE_25		= (2 + MCI_SEQ_OFFSET)
MCI_SEQ_DIV_SMPTE_30DROP	= (3 + MCI_SEQ_OFFSET)
MCI_SEQ_DIV_SMPTE_30		= (4 + MCI_SEQ_OFFSET)

; flags for the dwMaster field of MCI_SEQ_SET_PARMS parameter block
; MCI_SET command, (dwFlags == MCI_SEQ_SET_MASTER)
MCI_SEQ_FORMAT_SONGPTR		= 04001h
MCI_SEQ_FILE			= 04002h
MCI_SEQ_MIDI			= 04003h
MCI_SEQ_SMPTE			= 04004h
MCI_SEQ_NONE			= 65533
MCI_SEQ_MAPPER			= 65535

; flags for the dwItem field of MCI_STATUS_PARMS parameter block
MCI_SEQ_STATUS_TEMPO		= 000004002h
MCI_SEQ_STATUS_PORT		= 000004003h
MCI_SEQ_STATUS_SLAVE		= 000004007h
MCI_SEQ_STATUS_MASTER		= 000004008h
MCI_SEQ_STATUS_OFFSET		= 000004009h
MCI_SEQ_STATUS_DIVTYPE		= 00000400Ah
MCI_SEQ_STATUS_NAME		= 00000400Bh
MCI_SEQ_STATUS_COPYRIGHT	= 00000400Ch

; flags for the dwFlags parameter of MCI_SET command message
MCI_SEQ_SET_TEMPO		= 000010000h
MCI_SEQ_SET_PORT		= 000020000h
MCI_SEQ_SET_SLAVE		= 000040000h
MCI_SEQ_SET_MASTER		= 000080000h
MCI_SEQ_SET_OFFSET		= 001000000h

; parameter block for MCI_SET command message

struc	MCI_SEQ_SET_PARMS
	dwCallback		dd ?
	dwTimeFormat		dd ?
	dwAudio 		dd ?
	dwTempo 		dd ?
	dwPort			dd ?
	dwSlave 		dd ?
	dwMaster		dd ?
	dwOffset		dd ?
ends

; MCI extensions for animation devices

; flags for dwFlags parameter of MCI_OPEN command message
MCI_ANIM_OPEN_WS		= 000010000h
MCI_ANIM_OPEN_PARENT		= 000020000h
MCI_ANIM_OPEN_NOSTATIC		= 000040000h

; flags for dwFlags parameter of MCI_PLAY command message
MCI_ANIM_PLAY_SPEED		= 000010000h
MCI_ANIM_PLAY_REVERSE		= 000020000h
MCI_ANIM_PLAY_FAST		= 000040000h
MCI_ANIM_PLAY_SLOW		= 000080000h
MCI_ANIM_PLAY_SCAN		= 000100000h

; flags for dwFlags parameter of MCI_STEP command message
MCI_ANIM_STEP_REVERSE		= 000010000h
MCI_ANIM_STEP_FRAMES		= 000020000h

; flags for dwItem field of MCI_STATUS_PARMS parameter block
MCI_ANIM_STATUS_SPEED		= 000004001h
MCI_ANIM_STATUS_FORWARD 	= 000004002h
MCI_ANIM_STATUS_HWND		= 000004003h
MCI_ANIM_STATUS_HPAL		= 000004004h
MCI_ANIM_STATUS_STRETCH 	= 000004005h

; flags for the dwFlags parameter of MCI_INFO command message
MCI_ANIM_INFO_TEXT		= 000010000h

; flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
MCI_ANIM_GETDEVCAPS_CAN_REVERSE = 000004001h
MCI_ANIM_GETDEVCAPS_FAST_RATE	= 000004002h
MCI_ANIM_GETDEVCAPS_SLOW_RATE	= 000004003h
MCI_ANIM_GETDEVCAPS_NORMAL_RATE = 000004004h
MCI_ANIM_GETDEVCAPS_PALETTES	= 000004006h
MCI_ANIM_GETDEVCAPS_CAN_STRETCH = 000004007h
MCI_ANIM_GETDEVCAPS_MAX_WINDOWS = 000004008h

; flags for the MCI_REALIZE command message
MCI_ANIM_REALIZE_NORM		= 000010000h
MCI_ANIM_REALIZE_BKGD		= 000020000h

; flags for dwFlags parameter of MCI_WINDOW command message
MCI_ANIM_WINDOW_HWND		= 000010000h
MCI_ANIM_WINDOW_STATE		= 000040000h
MCI_ANIM_WINDOW_TEXT		= 000080000h
MCI_ANIM_WINDOW_ENABLE_STRETCH	= 000100000h
MCI_ANIM_WINDOW_DISABLE_STRETCH = 000200000h

; flags for hWnd field of MCI_ANIM_WINDOW_PARMS parameter block
; MCI_WINDOW command message, (dwFlags == MCI_ANIM_WINDOW_HWND)
MCI_ANIM_WINDOW_DEFAULT 	= 000000000h

; flags for dwFlags parameter of MCI_PUT command message
MCI_ANIM_RECT			= 000010000h
MCI_ANIM_PUT_SOURCE		= 000020000h
MCI_ANIM_PUT_DESTINATION	= 000040000h

; flags for dwFlags parameter of MCI_WHERE command message
MCI_ANIM_WHERE_SOURCE		= 000020000h
MCI_ANIM_WHERE_DESTINATION	= 000040000h

; flags for dwFlags parameter of MCI_UPDATE command message
MCI_ANIM_UPDATE_HDC		= 000020000h

; parameter block for MCI_OPEN command message

struc	MCI_ANIM_OPEN_PARMS
	dwCallback		dd ?
	wDeviceID		dd ?
	lpstrDeviceType 	dd ?
	lpstrElementName	dd ?
	lpstrAlias		dd ?
	dwStyle 		dd ?
	hWndParent		dd ?
ends

; parameter block for MCI_PLAY command message

struc	MCI_ANIM_PLAY_PARMS
	dwCallback		dd ?
	dwFrom			dd ?
	dwTo			dd ?
	dwSpeed 		dd ?
ends

; parameter block for MCI_STEP command message

struc	MCI_ANIM_STEP_PARMS
	dwCallback		dd ?
	dwFrames		dd ?
ends

; parameter block for MCI_WINDOW command message

struc	MCI_ANIM_WINDOW_PARMS
	dwCallback		dd ?
	hWnd			dd ?
	nCmdShow		dd ?
	lpstrText		dd ?
ends

; parameter block for MCI_PUT, MCI_UPDATE, MCI_WHERE command messages

struc	MCI_ANIM_RECT_PARMS
	dwCallback		dd ?
label	rc			RECT
	ptOffset		POINT ?
	ptExtent		POINT ?
ends

; parameter block for MCI_UPDATE PARMS

struc	MCI_ANIM_UPDATE_PARMS
	dwCallback		dd ?
	rc			RECT ?
	hDC			dd ?
ends

; MCI extensions for video overlay devices

; flags for dwFlags parameter of MCI_OPEN command message
MCI_OVLY_OPEN_WS		= 000010000h
MCI_OVLY_OPEN_PARENT		= 000020000h

; flags for dwFlags parameter of MCI_STATUS command message
MCI_OVLY_STATUS_HWND		= 000004001h
MCI_OVLY_STATUS_STRETCH 	= 000004002h

; flags for dwFlags parameter of MCI_INFO command message
MCI_OVLY_INFO_TEXT		= 000010000h

; flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
MCI_OVLY_GETDEVCAPS_CAN_STRETCH = 000004001h
MCI_OVLY_GETDEVCAPS_CAN_FREEZE	= 000004002h
MCI_OVLY_GETDEVCAPS_MAX_WINDOWS = 000004003h

; flags for dwFlags parameter of MCI_WINDOW command message
MCI_OVLY_WINDOW_HWND		= 000010000h
MCI_OVLY_WINDOW_STATE		= 000040000h
MCI_OVLY_WINDOW_TEXT		= 000080000h
MCI_OVLY_WINDOW_ENABLE_STRETCH	= 000100000h
MCI_OVLY_WINDOW_DISABLE_STRETCH = 000200000h

; flags for hWnd parameter of MCI_OVLY_WINDOW_PARMS parameter block
MCI_OVLY_WINDOW_DEFAULT 	= 000000000h

; flags for dwFlags parameter of MCI_PUT command message
MCI_OVLY_RECT			= 000010000h
MCI_OVLY_PUT_SOURCE		= 000020000h
MCI_OVLY_PUT_DESTINATION	= 000040000h
MCI_OVLY_PUT_FRAME		= 000080000h
MCI_OVLY_PUT_VIDEO		= 000100000h

; flags for dwFlags parameter of MCI_WHERE command message
MCI_OVLY_WHERE_SOURCE		= 000020000h
MCI_OVLY_WHERE_DESTINATION	= 000040000h
MCI_OVLY_WHERE_FRAME		= 000080000h
MCI_OVLY_WHERE_VIDEO		= 000100000h

; parameter block for MCI_OPEN command message

struc	MCI_OVLY_OPEN_PARMS
	dwCallback		dd ?
	wDeviceID		dd ?
	lpstrDeviceType 	dd ?
	lpstrElementName	dd ?
	lpstrAlias		dd ?
	dwStyle 		dd ?
	hWndParent		dd ?
ends

; parameter block for MCI_WINDOW command message

struc	MCI_OVLY_WINDOW_PARMS
	dwCallback		dd ?
	hWnd			dd ?
	nCmdShow		dd ?
	lpstrText		dd ?
ends

; parameter block for MCI_PUT, MCI_UPDATE, and MCI_WHERE command messages

struc	MCI_OVLY_RECT_PARMS
	dwCallback		dd ?
label	rc			RECT
	ptOffset		POINT ?
	ptExtent		POINT ?
ends

; parameter block for MCI_SAVE command message

struc	MCI_OVLY_SAVE_PARMS
	dwCallback		dd ?
	lpfilename		dd ?
	rc			RECT ?
ends

; parameter block for MCI_LOAD command message

struc	MCI_OVLY_LOAD_PARMS
	dwCallback		dd ?
	lpfilename		dd ?
	rc			RECT ?
ends

;***************************************************************************
;
;			DISPLAY Driver extensions
;
;***************************************************************************

NEWTRANSPARENT			= 3	      ; use with SetBkMode()

QUERYROPSUPPORT 		= 40	      ; use to determine ROP support

;***************************************************************************
;
;			DIB Driver extensions
;
;***************************************************************************

SELECTDIB			= 41			  ; DIB.DRV select dib escape

;***************************************************************************
;
;			ScreenSaver support
;
;    The current application will receive a syscommand of SC_SCREENSAVE just
;    before the screen saver is invoked.  If the app wishes to prevent a
;    screen save, return non-zero value, otherwise call DefWindowProc().
;
;***************************************************************************

SC_SCREENSAVE			= 0F140h
