;****************************************************************************\
;*									       *
;* shellapi.h -  SHELL.DLL functions, types, and definitions		       *
;*									       *
;* Copyright (c) 1992-1998, Microsoft Corp.  All rights reserved	       *
;*									       *
;\****************************************************************************

procdesc DragQueryFileA :dword, :dword, :dword, :dword
procdesc DragQueryPoint :dword, :dword
procdesc DragFinish :dword
procdesc DragAcceptFiles :dword, :dword
procdesc ShellExecuteA :dword, :dword, :dword, :dword, :dword, :dword
procdesc FindExecutableA :dword, :dword, :dword
procdesc CommandLineToArgvW :dword, :dword
procdesc ShellAboutA :dword, :dword, :dword, :dword
procdesc DuplicateIcon :dword, :dword
procdesc ExtractAssociatedIconA :dword, :dword, :dword
procdesc ExtractIconA :dword, :dword, :dword

DragQueryFile			equ <DragQueryFileA>
ShellExecute			equ <ShellExecuteA>
FindExecutable			equ <FindExecutableA>
ShellAbout			equ <ShellAboutA>
ExtractAssociatedIcon		equ <ExtractAssociatedIconA>
ExtractIcon			equ <ExtractIconA>

struc	DRAGINFO
	uSize			dd ?		; init with sizeof(DRAGINFO)
	pt			POINT ?
	fNC			dd ?
	lpFileList		dd ?
	grfKeyState		dd ?
ends

;//
;// AppBar stuff
;//
ABM_NEW 			= 000000000h
ABM_REMOVE			= 000000001h
ABM_QUERYPOS			= 000000002h
ABM_SETPOS			= 000000003h
ABM_GETSTATE			= 000000004h
ABM_GETTASKBARPOS		= 000000005h
ABM_ACTIVATE			= 000000006h  ; lParam == TRUE/FALSE means activate/deactivate
ABM_GETAUTOHIDEBAR		= 000000007h
ABM_SETAUTOHIDEBAR		= 000000008h  ; this can fail at any time.  MUST check the result
					      ; lParam = TRUE/FALSE  Set/Unset
					      ; uEdge = what edge
ABM_WINDOWPOSCHANGED		= 00000009h


; these are put in the wparam of callback messages
ABN_STATECHANGE 		= 00000000h
ABN_POSCHANGED			= 00000001h
ABN_FULLSCREENAPP		= 00000002h
ABN_WINDOWARRANGE		= 00000003h ; lParam == TRUE means hide

; flags for get state
ABS_AUTOHIDE			= 00000001h
ABS_ALWAYSONTOP 		= 00000002h

ABE_LEFT			= 0
ABE_TOP 			= 1
ABE_RIGHT			= 2
ABE_BOTTOM			= 3

struc	APPBARDATA
	cbSize			dd ?
	hWnd			dd ?
	uCallbackMessage	dd ?
	uEdge			dd ?
	rc			RECT ?
	lParam			dd ?		; message specific
ends

procdesc SHAppBarMessage :dword, :dword

;//
;//  EndAppBar
;//

procdesc DoEnvironmentSubstA :dword, :dword
procdesc FindEnvironmentStringA :dword
procdesc ExtractIconExA :dword, :dword, :dword, :dword, :dword

DoEnvironmentSubst		equ <DoEnvironmentSubstA>
FindEnvironmentString		equ <FindEnvironmentStringA>
ExtractIconEx			equ <ExtractIconExA>

;//
;// Shell File Operations
;//

FO_MOVE 			= 00001h
FO_COPY 			= 00002h
FO_DELETE			= 00003h
FO_RENAME			= 00004h

FOF_MULTIDESTFILES		= 00001h
FOF_CONFIRMMOUSE		= 00002h
FOF_SILENT			= 00004h  ; don't create progress/report
FOF_RENAMEONCOLLISION		= 00008h
FOF_NOCONFIRMATION		= 00010h  ; Don't prompt the user.
FOF_WANTMAPPINGHANDLE		= 00020h  ; Fill in SHFILEOPSTRUCT.hNameMappings
				      ; Must be freed using SHFreeNameMappings
FOF_ALLOWUNDO			= 00040h
FOF_FILESONLY			= 00080h  ; on *.*, do only files
FOF_SIMPLEPROGRESS		= 00100h  ; means don't show names of files
FOF_NOCONFIRMMKDIR		= 00200h  ; don't confirm making any needed dirs
FOF_NOERRORUI			= 00400h  ; don't put up error UI
FOF_NOCOPYSECURITYATTRIBS	= 00800h  ; dont copy NT file Security Attributes
FOF_NORECURSION 		= 01000h  ; don't recurse into directories.
FOF_NO_CONNECTED_ELEMENTS	= 02000h  ; don't operate on connected elements.
FOF_WANTNUKEWARNING		= 04000h  ; during delete operation, warn if nuking instead of recycling (partially overrides FOF_NOCONFIRMATION)

PO_DELETE			= 00013h  ; printer is being deleted
PO_RENAME			= 00014h  ; printer is being renamed
PO_PORTCHANGE			= 00020h  ; port this printer connected to is being changed
				; if this id is set, the strings received by
				; the copyhook are a doubly-null terminated
				; list of strings.  The first is the printer
				; name and the second is the printer port.
PO_REN_PORT			= 00034h  ; PO_RENAME and PO_PORTCHANGE at same time.

; implicit parameters are:
;      if pFrom or pTo are unqualified names the current directories are
;      taken from the global current drive/directory settings managed
;      by Get/SetCurrentDrive/Directory
;
;      the global confirmation settings

struc	SHFILEOPSTRUCT
	hwnd			dd ?
	wFunc			dd ?
	pFrom			dd ?
	pTo			dd ?
	fFlags			dd ?
	fAnyOperationsAborted	dd ?
	hNameMappings		dd ?
	lpszProgressTitle	dd ?		; only used if FOF_SIMPLEPROGRESS
ends

procdesc SHFileOperationA :dword
procdesc SHFreeNameMappings :dword

SHFileOperation 		equ <SHFileOperationA>

struc	SHNAMEMAPPING
	pszOldPath		dd ?
	pszNewPath		dd ?
	cchOldPath		dd ?
	cchNewPath		dd ?
ends

;//
;// End Shell File Operations
;//

;//
;//  Begin ShellExecuteEx and family
;//

; ShellExecute() and ShellExecuteEx() error codes

; regular WinExec() codes
SE_ERR_FNF			= 2	  ; file not found
SE_ERR_PNF			= 3	  ; path not found
SE_ERR_ACCESSDENIED		= 5	  ; access denied
SE_ERR_OOM			= 8	  ; out of memory
SE_ERR_DLLNOTFOUND		= 32

; error values for ShellExecute() beyond the regular WinExec() codes
SE_ERR_SHARE			= 26
SE_ERR_ASSOCINCOMPLETE		= 27
SE_ERR_DDETIMEOUT		= 28
SE_ERR_DDEFAIL			= 29
SE_ERR_DDEBUSY			= 30
SE_ERR_NOASSOC			= 31

; Note CLASSKEY overrides CLASSNAME
SEE_MASK_CLASSNAME		= 000000001h
SEE_MASK_CLASSKEY		= 000000003h
; Note INVOKEIDLIST overrides IDLIST
SEE_MASK_IDLIST 		= 000000004h
SEE_MASK_INVOKEIDLIST		= 00000000h
SEE_MASK_ICON			= 000000010h
SEE_MASK_HOTKEY 		= 000000020h
SEE_MASK_NOCLOSEPROCESS 	= 000000040h
SEE_MASK_CONNECTNETDRV		= 000000080h
SEE_MASK_FLAG_DDEWAIT		= 000000100h
SEE_MASK_DOENVSUBST		= 000000200h
SEE_MASK_FLAG_NO_UI		= 000000400h
SEE_MASK_UNICODE		= 000004000h
SEE_MASK_NO_CONSOLE		= 000008000h
SEE_MASK_ASYNCOK		= 000100000h
SEE_MASK_HMONITOR		= 000200000h
SEE_MASK_USERLOGON		= 000800000h
SEE_MASK_NOQUERYCLASSSTORE	= 001000000h

;
; For compilers that don't support nameless unions
;

struc	SHELLEXECUTEINFO
	cbSize			dd ?
	fMask			dd ?
	hwnd			dd ?
	lpVerb			dd ?
	lpFile			dd ?
	lpParameters		dd ?
	lpDirectory		dd ?
	nShow			dd ?
	hInstApp		dd ?	 ; Optional fields
	lpIDList		dd ?
	lpClass 		dd ?
	hkeyClass		dd ?
	dwHotKey		dd ?
label	hIcon			dword
	hMonitor		dd ?
	hProcess		dd ?
ends

procdesc ShellExecuteExA :dword
procdesc WinExecErrorA :dword, :dword, :dword, :dword

ShellExecuteEx			equ <ShellExecuteExA>
WinExecError			equ <WinExecErrorA>

;//
;//  End ShellExecuteEx and family
;//

;
; RecycleBin
;

; struct for query recycle bin info

struc	SHQUERYRBINFO
	cbSize			dd ?
	i64Size 		dq ?
	i64NumItems		dq ?
ends

; flags for SHEmptyRecycleBin

SHERB_NOCONFIRMATION		= 000000001h
SHERB_NOPROGRESSUI		= 000000002h
SHERB_NOSOUND			= 000000004h

procdesc SHQueryRecycleBinA :dword, :dword
procdesc SHEmptyRecycleBinA :dword, :dword, :dword

SHQueryRecycleBin		equ <SHQueryRecycleBinA>
SHEmptyRecycleBin		equ <SHEmptyRecycleBinA>

;//
;// end of RecycleBin


;//
;// Tray notification definitions
;//

struc	NOTIFYICONDATA
	cbSize			dd ?
	hWnd			dd ?
	uID			dd ?
	uFlags			dd ?
	uCallbackMessage	dd ?
	hIcon			dd ?
	szTip			db 64 dup (?)
if _WIN32_IE ge 0500h
	dwState 		dd ?
	dwStateMask		dd ?
endif
ends

; notifies sent FROM shell to the app.
NOTIFYICON_VERSION		= 3
NIN_GETVERSION			= (WM_USER + 0)
NIN_SELECT			= (WM_USER + 02h)
NINF_KEY			= 01h
NIN_KEYSELECT			= (NIN_SELECT + NINF_KEY)

NIM_ADD 			= 000000000h
NIM_MODIFY			= 000000001h
NIM_DELETE			= 000000002h
NIM_SETFOCUS			= 000000003h

NIF_MESSAGE			= 000000001h
NIF_ICON			= 000000002h
NIF_TIP 			= 000000004h
NIF_STATE			= 000000008h

NIS_HIDDEN			= 000000001h
NIS_SHAREDICON			= 000000002h

procdesc Shell_NotifyIconA :dword, :dword

Shell_NotifyIcon		equ <Shell_NotifyIconA>

;//
;// End Tray Notification Icons
;//

;//
;// Begin SHGetFileInfo
;//

; The SHGetFileInfo API provides an easy way to get attributes
; for a file given a pathname.
;
;   PARAMETERS
;
;     pszPath		   file name to get info about
;     dwFileAttributes	   file attribs, only used with SHGFI_USEFILEATTRIBUTES
;     psfi		   place to return file info
;     cbFileInfo	   size of structure
;     uFlags		   flags
;
;   RETURN
;     TRUE if things worked

struc	SHFILEINFO
	hIcon			dd ?		; out: icon
	iIcon			dd ?		; out: icon index
	dwAttributes		dd ?		; out: SFGAO_ flags
	szDisplayName		db MAX_PATH dup (?) ; out: display name (or path)
	szTypeName		db 80 dup (?)	    ; out: type name
ends

; NOTE: This is also in shlwapi.h.  Please keep in synch.

SHGFI_ICON			= 0000000100h	  ; get icon
SHGFI_DISPLAYNAME		= 0000000200h	  ; get display name
SHGFI_TYPENAME			= 0000000400h	  ; get type name
SHGFI_ATTRIBUTES		= 0000000800h	  ; get attributes
SHGFI_ICONLOCATION		= 0000001000h	  ; get icon location
SHGFI_EXETYPE			= 0000002000h	  ; return exe type
SHGFI_SYSICONINDEX		= 0000004000h	  ; get system icon index
SHGFI_LINKOVERLAY		= 0000008000h	  ; put a link overlay on icon
SHGFI_SELECTED			= 0000010000h	  ; show icon in selected state
SHGFI_ATTR_SPECIFIED		= 0000020000h	  ; get only specified attributes
SHGFI_LARGEICON 		= 0000000000h	  ; get large icon
SHGFI_SMALLICON 		= 0000000001h	  ; get small icon
SHGFI_OPENICON			= 0000000002h	  ; get open icon
SHGFI_SHELLICONSIZE		= 0000000004h	  ; get shell size icon
SHGFI_PIDL			= 0000000008h	  ; pszPath is a pidl
SHGFI_USEFILEATTRIBUTES 	= 0000000010h	  ; use passed dwFileAttribute

procdesc SHGetFileInfoA :dword, :dword, :dword, :dword, :dword
procdesc SHGetDiskFreeSpaceExA :dword, :dword, :dword, :dword
procdesc SHGetNewLinkInfoA :dword, :dword, :dword, :dword, :dword

SHGetFileInfo			equ <SHGetFileInfoA>
SHGetDiskFreeSpaceEx		equ <SHGetDiskFreeSpaceExA>
SHGetDiskFreeSpace		equ <SHGetDiskFreeSpaceEx>
SHGetNewLinkInfo		equ <SHGetNewLinkInfoA>

SHGNLI_PIDL			= 0000000001h	  ; pszLinkTo is a pidl
SHGNLI_PREFIXNAME		= 0000000002h	  ; Make name "Shortcut to xxx"
SHGNLI_NOUNIQUE 		= 0000000004h	  ; don't do the unique name generation

;//
;// End SHGetFileInfo
;//

; Printer stuff
PRINTACTION_OPEN		= 0
PRINTACTION_PROPERTIES		= 1
PRINTACTION_NETINSTALL		= 2
PRINTACTION_NETINSTALLLINK	= 3
PRINTACTION_TESTPAGE		= 4
PRINTACTION_OPENNETPRN		= 5
PRINTACTION_DOCUMENTDEFAULTS	= 6
PRINTACTION_SERVERPROPERTIES	= 7

procdesc SHInvokePrinterCommandA :dword, :dword, :dword, :dword, :dword

SHInvokePrinterCommand		equ <SHInvokePrinterCommandA>
