;***********************************************************************
;*									 *
;*   winbase.h -- This module defines the 32-Bit Windows Base APIs	 *
;*									 *
;*   Copyright (c) 1990-1998, Microsoft Corp. All rights reserved.	 *
;*									 *
;***********************************************************************

INVALID_HANDLE_VALUE		= -1
INVALID_FILE_SIZE		= 0FFFFFFFFh

FILE_BEGIN			= 0
FILE_CURRENT			= 1
FILE_END			= 2

TIME_ZONE_ID_INVALID		= 0FFFFFFFFh

WAIT_FAILED			= 0FFFFFFFFh
WAIT_OBJECT_0			= ((STATUS_WAIT_0 ) + 0 )

WAIT_ABANDONED			= ((STATUS_ABANDONED_WAIT_0 ) + 0 )
WAIT_ABANDONED_0		= ((STATUS_ABANDONED_WAIT_0 ) + 0 )

WAIT_IO_COMPLETION		= STATUS_USER_APC
STILL_ACTIVE			= STATUS_PENDING
EXCEPTION_ACCESS_VIOLATION	= STATUS_ACCESS_VIOLATION
EXCEPTION_DATATYPE_MISALIGNMENT = STATUS_DATATYPE_MISALIGNMENT
EXCEPTION_BREAKPOINT		= STATUS_BREAKPOINT
EXCEPTION_SINGLE_STEP		= STATUS_SINGLE_STEP
EXCEPTION_ARRAY_BOUNDS_EXCEEDED = STATUS_ARRAY_BOUNDS_EXCEEDED
EXCEPTION_FLT_DENORMAL_OPERAND	= STATUS_FLOAT_DENORMAL_OPERAND
EXCEPTION_FLT_DIVIDE_BY_ZERO	= STATUS_FLOAT_DIVIDE_BY_ZERO
EXCEPTION_FLT_INEXACT_RESULT	= STATUS_FLOAT_INEXACT_RESULT
EXCEPTION_FLT_INVALID_OPERATION = STATUS_FLOAT_INVALID_OPERATION
EXCEPTION_FLT_OVERFLOW		= STATUS_FLOAT_OVERFLOW
EXCEPTION_FLT_STACK_CHECK	= STATUS_FLOAT_STACK_CHECK
EXCEPTION_FLT_UNDERFLOW 	= STATUS_FLOAT_UNDERFLOW
EXCEPTION_INT_DIVIDE_BY_ZERO	= STATUS_INTEGER_DIVIDE_BY_ZERO
EXCEPTION_INT_OVERFLOW		= STATUS_INTEGER_OVERFLOW
EXCEPTION_PRIV_INSTRUCTION	= STATUS_PRIVILEGED_INSTRUCTION
EXCEPTION_IN_PAGE_ERROR 	= STATUS_IN_PAGE_ERROR
EXCEPTION_ILLEGAL_INSTRUCTION	= STATUS_ILLEGAL_INSTRUCTION
EXCEPTION_NONCONTINUABLE_EXCEPTION = STATUS_NONCONTINUABLE_EXCEPTION
EXCEPTION_STACK_OVERFLOW	= STATUS_STACK_OVERFLOW
EXCEPTION_INVALID_DISPOSITION	= STATUS_INVALID_DISPOSITION
EXCEPTION_GUARD_PAGE		= STATUS_GUARD_PAGE_VIOLATION
EXCEPTION_INVALID_HANDLE	= STATUS_INVALID_HANDLE
CONTROL_C_EXIT			= STATUS_CONTROL_C_EXIT

;
; File creation flags must start at the high end since they
; are combined with the attributes
;

FILE_FLAG_WRITE_THROUGH 	= 080000000h
FILE_FLAG_OVERLAPPED		= 040000000h
FILE_FLAG_NO_BUFFERING		= 020000000h
FILE_FLAG_RANDOM_ACCESS 	= 010000000h
FILE_FLAG_SEQUENTIAL_SCAN	= 008000000h
FILE_FLAG_DELETE_ON_CLOSE	= 004000000h
FILE_FLAG_BACKUP_SEMANTICS	= 002000000h
FILE_FLAG_POSIX_SEMANTICS	= 001000000h
FILE_FLAG_OPEN_REPARSE_POINT	= 000200000h
FILE_FLAG_OPEN_NO_RECALL	= 000100000h

CREATE_NEW			= 1
CREATE_ALWAYS			= 2
OPEN_EXISTING			= 3
OPEN_ALWAYS			= 4
TRUNCATE_EXISTING		= 5

;
; Define possible return codes from the CopyFileEx callback routine
;

PROGRESS_CONTINUE		= 0
PROGRESS_CANCEL 		= 1
PROGRESS_STOP			= 2
PROGRESS_QUIET			= 3

;
; Define CopyFileEx callback routine state change values
;

CALLBACK_CHUNK_FINISHED 	= 000000000h
CALLBACK_STREAM_SWITCH		= 000000001h

;
; Define CopyFileEx option flags
;

COPY_FILE_FAIL_IF_EXISTS	= 000000001h
COPY_FILE_RESTARTABLE		= 000000002h
COPY_FILE_OPEN_SOURCE_FOR_WRITE = 000000004h

;
; Define ReplaceFile option flags
;

REPLACEFILE_WRITE_THROUGH	= 000000001h
REPLACEFILE_IGNORE_MERGE_ERRORS = 000000002h

;
; Define the NamedPipe definitions
;

;
; Define the dwOpenMode values for CreateNamedPipe
;

PIPE_ACCESS_INBOUND		= 000000001h
PIPE_ACCESS_OUTBOUND		= 000000002h
PIPE_ACCESS_DUPLEX		= 000000003h

;
; Define the Named Pipe End flags for GetNamedPipeInfo
;

PIPE_CLIENT_END 		= 000000000h
PIPE_SERVER_END 		= 000000001h

;
; Define the dwPipeMode values for CreateNamedPipe
;

PIPE_WAIT			= 000000000h
PIPE_NOWAIT			= 000000001h
PIPE_READMODE_BYTE		= 000000000h
PIPE_READMODE_MESSAGE		= 000000002h
PIPE_TYPE_BYTE			= 000000000h
PIPE_TYPE_MESSAGE		= 000000004h

;
; Define the well known values for CreateNamedPipe nMaxInstances
;

PIPE_UNLIMITED_INSTANCES	= 255

;
; Define the Security Quality of Service bits to be passed
; into CreateFile
;

SECURITY_ANONYMOUS		= ( SecurityAnonymous	   shl 16 )
SECURITY_IDENTIFICATION 	= ( SecurityIdentification shl 16 )
SECURITY_IMPERSONATION		= ( SecurityImpersonation  shl 16 )
SECURITY_DELEGATION		= ( SecurityDelegation	   shl 16 )

SECURITY_CONTEXT_TRACKING	= 000040000h
SECURITY_EFFECTIVE_ONLY 	= 000080000h

SECURITY_SQOS_PRESENT		= 000100000h
SECURITY_VALID_SQOS_FLAGS	= 0001F0000h

;
;  File structures
;

struc	OVERLAPPED
	Internal		dd ?
	InternalHigh		dd ?
	_Offset 		dd ?
	OffsetHigh		dd ?
	hEvent			dd ?
ends

struc	SECURITY_ATTRIBUTES
	nLength 		dd ?
	lpSecurityDescriptor	dd ?
	bInheritHandle		dd ?
ends

struc	PROCESS_INFORMATION
	hProcess		dd ?
	hThread 		dd ?
	dwProcessId		dd ?
	dwThreadId		dd ?
ends

;
;  File System time stamps are represented with the following structure:
;

struc	FILETIME
	dwLowDateTime		dd ?
	dwHighDateTime		dd ?
ends

;
; System time is represented with the following structure:
;

struc	SYSTEMTIME
	wYear			dw ?
	wMonth			dw ?
	wDayOfWeek		dw ?
	wDay			dw ?
	wHour			dw ?
	wMinute 		dw ?
	wSecond 		dw ?
	wMilliseconds		dw ?
ends

typedef CRITICAL_SECTION	RTL_CRITICAL_SECTION
typedef CRITICAL_SECTION_DEBUG	RTL_CRITICAL_SECTION_DEBUG

MUTEX_MODIFY_STATE		= MUTANT_QUERY_STATE
MUTEX_ALL_ACCESS		= MUTANT_ALL_ACCESS

;
; Serial provider type.
;

SP_SERIALCOMM			= (000000001h)

;
; Provider SubTypes
;

PST_UNSPECIFIED 		= (000000000h)
PST_RS232			= (000000001h)
PST_PARALLELPORT		= (000000002h)
PST_RS422			= (000000003h)
PST_RS423			= (000000004h)
PST_RS449			= (000000005h)
PST_MODEM			= (000000006h)
PST_FAX 			= (000000021h)
PST_SCANNER			= (000000022h)
PST_NETWORK_BRIDGE		= (000000100h)
PST_LAT 			= (000000101h)
PST_TCPIP_TELNET		= (000000102h)
PST_X25 			= (000000103h)

;
; Provider capabilities flags.
;

PCF_DTRDSR			= (00001h)
PCF_RTSCTS			= (00002h)
PCF_RLSD			= (00004h)
PCF_PARITY_CHECK		= (00008h)
PCF_XONXOFF			= (00010h)
PCF_SETXCHAR			= (00020h)
PCF_TOTALTIMEOUTS		= (00040h)
PCF_INTTIMEOUTS 		= (00080h)
PCF_SPECIALCHARS		= (00100h)
PCF_16BITMODE			= (00200h)

;
; Comm provider settable parameters
;

SP_PARITY			= (00001h)
SP_BAUD 			= (00002h)
SP_DATABITS			= (00004h)
SP_STOPBITS			= (00008h)
SP_HANDSHAKING			= (00010h)
SP_PARITY_CHECK 		= (00020h)
SP_RLSD 			= (00040h)

;
; Settable baud rates in the provider.
;

BAUD_075			= (000000001h)
BAUD_110			= (000000002h)
BAUD_134_5			= (000000004h)
BAUD_150			= (000000008h)
BAUD_300			= (000000010h)
BAUD_600			= (000000020h)
BAUD_1200			= (000000040h)
BAUD_1800			= (000000080h)
BAUD_2400			= (000000100h)
BAUD_4800			= (000000200h)
BAUD_7200			= (000000400h)
BAUD_9600			= (000000800h)
BAUD_14400			= (000001000h)
BAUD_19200			= (000002000h)
BAUD_38400			= (000004000h)
BAUD_56K			= (000008000h)
BAUD_128K			= (000010000h)
BAUD_115200			= (000020000h)
BAUD_57600			= (000040000h)
BAUD_USER			= (010000000h)

;
; Settable Data Bits
;

DATABITS_5			= (00001h)
DATABITS_6			= (00002h)
DATABITS_7			= (00004h)
DATABITS_8			= (00008h)
DATABITS_16			= (00010h)
DATABITS_16X			= (00020h)

;
; Settable Stop and Parity bits.
;

STOPBITS_10			= (00001h)
STOPBITS_15			= (00002h)
STOPBITS_20			= (00004h)
PARITY_NONE			= (00100h)
PARITY_ODD			= (00200h)
PARITY_EVEN			= (00400h)
PARITY_MARK			= (00800h)
PARITY_SPACE			= (01000h)


struc	COMMPROP
	wPacketLength		dw ?
	wPacketVersion		dw ?
	dwServiceMask		dd ?
	dwReserved1		dd ?
	dwMaxTxQueue		dd ?
	dwMaxRxQueue		dd ?
	dwMaxBaud		dd ?
	dwProvSubType		dd ?
	dwProvCapabilities	dd ?
	dwSettableParams	dd ?
	dwSettableBaud		dd ?
	wSettableData		dw ?
	wSettableStopParity	dw ?
	dwCurrentTxQueue	dd ?
	dwCurrentRxQueue	dd ?
	dwProvSpec1		dd ?
	dwProvSpec2		dd ?
label	wcProvChar		byte
ends

;
; Set dwProvSpec1 to COMMPROP_INITIALIZED to indicate that wPacketLength
; is valid before a call to GetCommProperties().
;

COMMPROP_INITIALIZED		= (0E73CF52Eh)

struc	COMSTAT
	Flags			dd ?
;	fCtsHold		dd  : 1 ?
;	fDsrHold		dd  : 1 ?
;	fRlsdHold		dd  : 1 ?
;	fXoffHold		dd  : 1 ?
;	fXoffSent		dd  : 1 ?
;	fEof			dd  : 1 ?
;	fTxim			dd  : 1 ?
;	fReserved		dd  : 25 ?
	cbInQue 		dd ?
	cbOutQue		dd ?
ends

;
; DTR Control Flow Values.
;
DTR_CONTROL_DISABLE		= 000h
DTR_CONTROL_ENABLE		= 001h
DTR_CONTROL_HANDSHAKE		= 002h

;
; RTS Control Flow Values
;
RTS_CONTROL_DISABLE		= 000h
RTS_CONTROL_ENABLE		= 001h
RTS_CONTROL_HANDSHAKE		= 002h
RTS_CONTROL_TOGGLE		= 003h

struc	DCB
	DCBlength		dd ?		; sizeof(DCB)
	BaudRate		dd ?		; Baudrate at which running
	Flags			dd ?
;	fBinary 		dd : 1 ?	; Binary Mode (skip EOF check)
;	fParity 		dd : 1 ?	; Enable parity checking
;	fOutxCtsFlow		dd :1 ? 	; CTS handshaking on output
;	fOutxDsrFlow		dd :1 ? 	; DSR handshaking on output
;	fDtrControl		dd :2 ? 	; DTR Flow control
;	fDsrSensitivity 	dd :1 ? 	; DSR Sensitivity
;	fTXContinueOnXoff	dd : 1 ?	; Continue TX when Xoff sent
;	fOutX			dd : 1 ?	; Enable output X-ON/X-OFF
;	fInX			dd : 1 ?	; Enable input X-ON/X-OFF
;	fErrorChar		dd : 1 ?	; Enable Err Replacement
;	fNull			dd : 1 ?	; Enable Null stripping
;	fRtsControl		dd :2 ? 	; Rts Flow control
;	fAbortOnError		dd :1 ? 	; Abort all reads and writes on Error
;	fDummy2 		dd :17 ?	; Reserved
	wReserved		dw ?		; Not currently used
	XonLim			dw ?		; Transmit X-ON threshold
	XoffLim 		dw ?		; Transmit X-OFF threshold
	ByteSize		db ?		; Number of bits/byte, 4-8
	Parity			db ?		; 0-4=None,Odd,Even,Mark,Space
	StopBits		db ?		; 0,1,2 = 1, 1.5, 2
	XonChar 		db ?		; Tx and Rx X-ON character
	XoffChar		db ?		; Tx and Rx X-OFF character
	ErrorChar		db ?		; Error replacement char
	EofChar 		db ?		; End of Input character
	EvtChar 		db ?		; Received Event character
	wReserved1		dw ?		; Fill for now.
ends

struc	COMMTIMEOUTS
	ReadIntervalTimeout	dd ?		; Maximum time between read chars.
	ReadTotalTimeoutMultiplier dd ? 	; Multiplier of characters.
	ReadTotalTimeoutConstant dd ?		; Constant in milliseconds.
	WriteTotalTimeoutMultiplier dd ?	; Multiplier of characters.
	WriteTotalTimeoutConstant dd ?		; Constant in milliseconds.
ends

struc	COMMCONFIG
	dwSize			dd ?		; Size of the entire struct
	wVersion		dw ?		; version of the structure
	wReserved		dw ?		; alignment
	dcb			DCB ?		; device control block
	dwProviderSubType	dd ?		; ordinal value for identifying
						; provider-defined data structure format
	dwProviderOffset	dd ?		; Specifies the offset of provider specific
						; data field in bytes from the start
	dwProviderSize		dd ?		; size of the provider-specific data field
label	wcProviderData		byte		; provider-specific data
ends

struc	SYSTEM_INFO
label	dwOemId 		dword		; Obsolete field...do not use
	wProcessorArchitecture	dw ?
	wReserved		dw ?
	dwPageSize		dd ?
	lpMinimumApplicationAddress dd ?
	lpMaximumApplicationAddress dd ?
	dwActiveProcessorMask	dd ?
	dwNumberOfProcessors	dd ?
	dwProcessorType 	dd ?
	dwAllocationGranularity dd ?
	wProcessorLevel 	dw ?
	wProcessorRevision	dw ?
ends

; Global Memory Flags

GMEM_FIXED			= 00000h
GMEM_MOVEABLE			= 00002h
GMEM_NOCOMPACT			= 00010h
GMEM_NODISCARD			= 00020h
GMEM_ZEROINIT			= 00040h
GMEM_MODIFY			= 00080h
GMEM_DISCARDABLE		= 00100h
GMEM_NOT_BANKED 		= 01000h
GMEM_SHARE			= 02000h
GMEM_DDESHARE			= 02000h
GMEM_NOTIFY			= 04000h
GMEM_LOWER			= GMEM_NOT_BANKED
GMEM_VALID_FLAGS		= 07F72h
GMEM_INVALID_HANDLE		= 08000h

GHND				= (GMEM_MOVEABLE + GMEM_ZEROINIT)
GPTR				= (GMEM_FIXED + GMEM_ZEROINIT)

; Flags returned by GlobalFlags (in addition to GMEM_DISCARDABLE)

GMEM_DISCARDED			= 04000h
GMEM_LOCKCOUNT			= 000FFh

struc	MEMORYSTATUS
	dwLength		dd ?
	dwMemoryLoad		dd ?
	dwTotalPhys		dd ?
	dwAvailPhys		dd ?
	dwTotalPageFile 	dd ?
	dwAvailPageFile 	dd ?
	dwTotalVirtual		dd ?
	dwAvailVirtual		dd ?
ends

; Local Memory Flags

LMEM_FIXED			= 00000h
LMEM_MOVEABLE			= 00002h
LMEM_NOCOMPACT			= 00010h
LMEM_NODISCARD			= 00020h
LMEM_ZEROINIT			= 00040h
LMEM_MODIFY			= 00080h
LMEM_DISCARDABLE		= 00F00h
LMEM_VALID_FLAGS		= 00F72h
LMEM_INVALID_HANDLE		= 08000h

LHND				= (LMEM_MOVEABLE + LMEM_ZEROINIT)
LPTR				= (LMEM_FIXED + LMEM_ZEROINIT)

NONZEROLHND			= (LMEM_MOVEABLE)
NONZEROLPTR			= (LMEM_FIXED)

; Flags returned by LocalFlags (in addition to LMEM_DISCARDABLE)

LMEM_DISCARDED			= 04000h
LMEM_LOCKCOUNT			= 000FFh

;
; dwCreationFlag values
;

DEBUG_PROCESS			= 000000001h
DEBUG_ONLY_THIS_PROCESS 	= 000000002h

CREATE_SUSPENDED		= 000000004h

DETACHED_PROCESS		= 000000008h

CREATE_NEW_CONSOLE		= 000000010h

NORMAL_PRIORITY_CLASS		= 000000020h
IDLE_PRIORITY_CLASS		= 000000040h
HIGH_PRIORITY_CLASS		= 000000080h
REALTIME_PRIORITY_CLASS 	= 000000100h

CREATE_NEW_PROCESS_GROUP	= 000000200h
CREATE_UNICODE_ENVIRONMENT	= 000000400h

CREATE_SEPARATE_WOW_VDM 	= 000000800h
CREATE_SHARED_WOW_VDM		= 000001000h
CREATE_FORCEDOS 		= 000002000h

BELOW_NORMAL_PRIORITY_CLASS	= 000004000h
ABOVE_NORMAL_PRIORITY_CLASS	= 000008000h

CREATE_DEFAULT_ERROR_MODE	= 004000000h
CREATE_NO_WINDOW		= 008000000h

PROFILE_USER			= 010000000h
PROFILE_KERNEL			= 020000000h
PROFILE_SERVER			= 040000000h

THREAD_PRIORITY_LOWEST		= THREAD_BASE_PRIORITY_MIN
THREAD_PRIORITY_BELOW_NORMAL	= (THREAD_PRIORITY_LOWEST+1)
THREAD_PRIORITY_NORMAL		= 0
THREAD_PRIORITY_HIGHEST 	= THREAD_BASE_PRIORITY_MAX
THREAD_PRIORITY_ABOVE_NORMAL	= (THREAD_PRIORITY_HIGHEST-1)
THREAD_PRIORITY_ERROR_RETURN	= (MAXLONG)

THREAD_PRIORITY_TIME_CRITICAL	= THREAD_BASE_PRIORITY_LOWRT
THREAD_PRIORITY_IDLE		= THREAD_BASE_PRIORITY_IDLE

;
; Debug APIs
;
EXCEPTION_DEBUG_EVENT		= 1
CREATE_THREAD_DEBUG_EVENT	= 2
CREATE_PROCESS_DEBUG_EVENT	= 3
EXIT_THREAD_DEBUG_EVENT 	= 4
EXIT_PROCESS_DEBUG_EVENT	= 5
LOAD_DLL_DEBUG_EVENT		= 6
UNLOAD_DLL_DEBUG_EVENT		= 7
OUTPUT_DEBUG_STRING_EVENT	= 8
RIP_EVENT			= 9

struc	EXCEPTION_DEBUG_INFO
	ExceptionRecord 	EXCEPTION_RECORD ?
	dwFirstChance		dd ?
ends

struc	CREATE_THREAD_DEBUG_INFO
	hThread 		dd ?
	lpThreadLocalBase	dd ?
	lpStartAddress		dd ?
ends

struc	CREATE_PROCESS_DEBUG_INFO
	hFile			dd ?
	hProcess		dd ?
	hThread 		dd ?
	lpBaseOfImage		dd ?
	dwDebugInfoFileOffset	dd ?
	nDebugInfoSize		dd ?
	lpThreadLocalBase	dd ?
	lpStartAddress		dd ?
	lpImageName		dd ?
	fUnicode		dw ?
ends

struc	EXIT_THREAD_DEBUG_INFO
	dwExitCode		dd ?
ends

struc	EXIT_PROCESS_DEBUG_INFO
	dwExitCode		dd ?
ends

struc	LOAD_DLL_DEBUG_INFO
	hFile			dd ?
	lpBaseOfDll		dd ?
	dwDebugInfoFileOffset	dd ?
	nDebugInfoSize		dd ?
	lpImageName		dd ?
	fUnicode		dw ?
ends

struc	UNLOAD_DLL_DEBUG_INFO
	lpBaseOfDll		dd ?
ends

struc	OUTPUT_DEBUG_STRING_INFO
	lpDebugStringData	dd ?
	fUnicode		dw ?
	nDebugStringLength	dw ?
ends

struc	RIP_INFO
	dwError 		dd ?
	dwType			dd ?
ends

struc	DEBUG_EVENT
	dwDebugEventCode	dd ?
	dwProcessId		dd ?
	dwThreadId		dd ?
label	Exception		EXCEPTION_DEBUG_INFO
label	CreateThread		CREATE_THREAD_DEBUG_INFO
label	CreateProcessInfo	CREATE_PROCESS_DEBUG_INFO
label	ExitThread		EXIT_THREAD_DEBUG_INFO
label	ExitProcess		EXIT_PROCESS_DEBUG_INFO
label	LoadDll 		LOAD_DLL_DEBUG_INFO
label	UnloadDll		UNLOAD_DLL_DEBUG_INFO
label	DebugString		OUTPUT_DEBUG_STRING_INFO
	RipInfo 		RIP_INFO ?
ends

DRIVE_UNKNOWN			= 0
DRIVE_NO_ROOT_DIR		= 1
DRIVE_REMOVABLE 		= 2
DRIVE_FIXED			= 3
DRIVE_REMOTE			= 4
DRIVE_CDROM			= 5
DRIVE_RAMDISK			= 6

FILE_TYPE_UNKNOWN		= 00000h
FILE_TYPE_DISK			= 00001h
FILE_TYPE_CHAR			= 00002h
FILE_TYPE_PIPE			= 00003h
FILE_TYPE_REMOTE		= 08000h

STD_INPUT_HANDLE		= -10
STD_OUTPUT_HANDLE		= -11
STD_ERROR_HANDLE		= -12

NOPARITY			= 0
ODDPARITY			= 1
EVENPARITY			= 2
MARKPARITY			= 3
SPACEPARITY			= 4

ONESTOPBIT			= 0
ONE5STOPBITS			= 1
TWOSTOPBITS			= 2

IGNORE				= 0	  ; Ignore signal
INFINITE			= 0FFFFFFFFh  ; Infinite timeout

;
; Baud rates at which the communication device operates
;

CBR_110 			= 110
CBR_300 			= 300
CBR_600 			= 600
CBR_1200			= 1200
CBR_2400			= 2400
CBR_4800			= 4800
CBR_9600			= 9600
CBR_14400			= 14400
CBR_19200			= 19200
CBR_38400			= 38400
CBR_56000			= 56000
CBR_57600			= 57600
CBR_115200			= 115200
CBR_128000			= 128000
CBR_256000			= 256000

;
; Error Flags
;

CE_RXOVER			= 00001h  ; Receive Queue overflow
CE_OVERRUN			= 00002h  ; Receive Overrun Error
CE_RXPARITY			= 00004h  ; Receive Parity Error
CE_FRAME			= 00008h  ; Receive Framing error
CE_BREAK			= 00010h  ; Break Detected
CE_TXFULL			= 00100h  ; TX Queue is full
CE_PTO				= 00200h  ; LPTx Timeout
CE_IOE				= 00400h  ; LPTx I/O Error
CE_DNS				= 00800h  ; LPTx Device not selected
CE_OOP				= 01000h  ; LPTx Out-Of-Paper
CE_MODE 			= 08000h  ; Requested mode unsupported

IE_BADID			= (-1)	  ; Invalid or unsupported id
IE_OPEN 			= (-2)	  ; Device Already Open
IE_NOPEN			= (-3)	  ; Device Not Open
IE_MEMORY			= (-4)	  ; Unable to allocate queues
IE_DEFAULT			= (-5)	  ; Error in default parameters
IE_HARDWARE			= (-10)   ; Hardware Not Present
IE_BYTESIZE			= (-11)   ; Illegal Byte Size
IE_BAUDRATE			= (-12)   ; Unsupported BaudRate

;
; Events
;

EV_RXCHAR			= 00001h  ; Any Character received
EV_RXFLAG			= 00002h  ; Received certain character
EV_TXEMPTY			= 00004h  ; Transmitt Queue Empty
EV_CTS				= 00008h  ; CTS changed state
EV_DSR				= 00010h  ; DSR changed state
EV_RLSD 			= 00020h  ; RLSD changed state
EV_BREAK			= 00040h  ; BREAK received
EV_ERR				= 00080h  ; Line status error occurred
EV_RING 			= 00100h  ; Ring signal detected
EV_PERR 			= 00200h  ; Printer error occured
EV_RX80FULL			= 00400h  ; Receive buffer is 80 percent full
EV_EVENT1			= 00800h  ; Provider specific event 1
EV_EVENT2			= 01000h  ; Provider specific event 2

;
; Escape Functions
;

SETXOFF 			= 1	  ; Simulate XOFF received
SETXON				= 2	  ; Simulate XON received
SETRTS				= 3	  ; Set RTS high
CLRRTS				= 4	  ; Set RTS low
SETDTR				= 5	  ; Set DTR high
CLRDTR				= 6	  ; Set DTR low
RESETDEV			= 7	  ; Reset device if possible
SETBREAK			= 8	  ; Set the device break line.
CLRBREAK			= 9	  ; Clear the device break line.

;
; PURGE function flags.
;
PURGE_TXABORT			= 00001h  ; Kill the pending/current writes to the comm port.
PURGE_RXABORT			= 00002h  ; Kill the pending/current reads to the comm port.
PURGE_TXCLEAR			= 00004h  ; Kill the transmit queue if there.
PURGE_RXCLEAR			= 00008h  ; Kill the typeahead buffer if there.

LPTx				= 080h	  ; Set if ID is for LPT device

;
; Modem Status Flags
;
MS_CTS_ON			= (00010h)
MS_DSR_ON			= (00020h)
MS_RING_ON			= (00040h)
MS_RLSD_ON			= (00080h)

;
; WaitSoundState() Constants
;

S_QUEUEEMPTY			= 0
S_THRESHOLD			= 1
S_ALLTHRESHOLD			= 2

;
; Accent Modes
;

S_NORMAL			= 0
S_LEGATO			= 1
S_STACCATO			= 2

;
; SetSoundNoise() Sources
;

S_PERIOD512			= 0	; Freq = N/512 high pitch, less coarse hiss
S_PERIOD1024			= 1	; Freq = N/1024
S_PERIOD2048			= 2	; Freq = N/2048 low pitch, more coarse hiss
S_PERIODVOICE			= 3	; Source is frequency from voice channel (3)
S_WHITE512			= 4	; Freq = N/512 high pitch, less coarse hiss
S_WHITE1024			= 5	; Freq = N/1024
S_WHITE2048			= 6	; Freq = N/2048 low pitch, more coarse hiss
S_WHITEVOICE			= 7	; Source is frequency from voice channel (3)

S_SERDVNA			= (-1)	; Device not available
S_SEROFM			= (-2)	; Out of memory
S_SERMACT			= (-3)	; Music active
S_SERQFUL			= (-4)	; Queue full
S_SERBDNT			= (-5)	; Invalid note
S_SERDLN			= (-6)	; Invalid note length
S_SERDCC			= (-7)	; Invalid note count
S_SERDTP			= (-8)	; Invalid tempo
S_SERDVL			= (-9)	; Invalid volume
S_SERDMD			= (-10) ; Invalid mode
S_SERDSH			= (-11) ; Invalid shape
S_SERDPT			= (-12) ; Invalid pitch
S_SERDFQ			= (-13) ; Invalid frequency
S_SERDDR			= (-14) ; Invalid duration
S_SERDSR			= (-15) ; Invalid source
S_SERDST			= (-16) ; Invalid state

NMPWAIT_WAIT_FOREVER		= 0fffffffh
NMPWAIT_NOWAIT			= 000000001h
NMPWAIT_USE_DEFAULT_WAIT	= 000000000h

FS_CASE_IS_PRESERVED		= FILE_CASE_PRESERVED_NAMES
FS_CASE_SENSITIVE		= FILE_CASE_SENSITIVE_SEARCH
FS_UNICODE_STORED_ON_DISK	= FILE_UNICODE_ON_DISK
FS_PERSISTENT_ACLS		= FILE_PERSISTENT_ACLS
FS_VOL_IS_COMPRESSED		= FILE_VOLUME_IS_COMPRESSED
FS_FILE_COMPRESSION		= FILE_FILE_COMPRESSION
FS_FILE_ENCRYPTION		= FILE_SUPPORTS_ENCRYPTION

FILE_MAP_COPY			= SECTION_QUERY
FILE_MAP_WRITE			= SECTION_MAP_WRITE
FILE_MAP_READ			= SECTION_MAP_READ
FILE_MAP_ALL_ACCESS		= SECTION_ALL_ACCESS

OF_READ 			= 000000000h
OF_WRITE			= 000000001h
OF_READWRITE			= 000000002h
OF_SHARE_COMPAT 		= 000000000h
OF_SHARE_EXCLUSIVE		= 000000010h
OF_SHARE_DENY_WRITE		= 000000020h
OF_SHARE_DENY_READ		= 000000030h
OF_SHARE_DENY_NONE		= 000000040h
OF_PARSE			= 000000100h
OF_DELETE			= 000000200h
OF_VERIFY			= 000000400h
OF_CANCEL			= 000000800h
OF_CREATE			= 000001000h
OF_PROMPT			= 000002000h
OF_EXIST			= 000004000h
OF_REOPEN			= 000008000h

OFS_MAXPATHNAME 		= 128

struc	OFSTRUCT
	cBytes			db ?
	fFixedDisk		db ?
	nErrCode		dw ?
	Reserved1		dw ?
	Reserved2		dw ?
	szPathName		db OFS_MAXPATHNAME dup (?)
ends

procdesc InterlockedIncrement :dword
procdesc InterlockedDecrement :dword
procdesc InterlockedExchange :dword, :dword
procdesc InterlockedExchangeAdd :dword, :dword
procdesc InterlockedCompareExchange :dword, :dword, :dword

procdesc FreeResource :dword
procdesc LockResource :dword

MAXINTATOM			= 0C000h
INVALID_ATOM			= 0

procdesc WinMain :dword, :dword, :dword, :dword
procdesc FreeLibrary :dword
procdesc FreeLibraryAndExitThread :dword, :dword
procdesc DisableThreadLibraryCalls :dword
procdesc GetProcAddress :dword, :dword
procdesc GetVersion
procdesc GlobalAlloc :dword, :dword
procdesc GlobalReAlloc :dword, :dword, :dword
procdesc GlobalSize :dword
procdesc GlobalFlags :dword
procdesc GlobalLock :dword
procdesc GlobalHandle :dword
procdesc GlobalUnlock :dword
procdesc GlobalFree :dword
procdesc GlobalCompact :dword
procdesc GlobalFix :dword
procdesc GlobalUnfix :dword
procdesc GlobalWire :dword
procdesc GlobalUnWire :dword
procdesc GlobalMemoryStatus :dword

struc	MEMORYSTATUSEX
	dwLength		dd ?
	dwMemoryLoad		dd ?
	ullTotalPhys		dq ?
	ullAvailPhys		dq ?
	ullTotalPageFile	dq ?
	ullAvailPageFile	dq ?
	ullTotalVirtual 	dq ?
	ullAvailVirtual 	dq ?
	ullAvailExtendedVirtual dq ?
ends

procdesc GlobalMemoryStatusEx :dword
procdesc LocalAlloc :dword, :dword
procdesc LocalReAlloc :dword, :dword, :dword
procdesc LocalLock :dword
procdesc LocalHandle :dword
procdesc LocalUnlock :dword
procdesc LocalSize :dword
procdesc LocalFlags :dword
procdesc LocalFree :dword
procdesc LocalShrink :dword, :dword
procdesc LocalCompact :dword
procdesc FlushInstructionCache :dword, :dword, :dword
procdesc VirtualAlloc :dword, :dword, :dword, :dword
procdesc VirtualFree :dword, :dword, :dword
procdesc VirtualProtect :dword, :dword, :dword, :dword
procdesc VirtualQuery :dword, :dword, :dword
procdesc VirtualAllocEx :dword, :dword, :dword, :dword, :dword

WRITE_WATCH_FLAG_RESET		= 1

procdesc GetWriteWatch :dword, :dword, :dword, :dword, :dword, :dword
procdesc ResetWriteWatch :dword, :dword
procdesc VirtualFreeEx :dword, :dword, :dword, :dword
procdesc VirtualProtectEx :dword, :dword, :dword, :dword, :dword
procdesc VirtualQueryEx :dword, :dword, :dword, :dword
procdesc HeapCreate :dword, :dword, :dword
procdesc HeapDestroy :dword
procdesc HeapAlloc :dword, :dword, :dword
procdesc HeapReAlloc :dword, :dword, :dword, :dword
procdesc HeapFree :dword, :dword, :dword
procdesc HeapSize :dword, :dword, :dword
procdesc HeapValidate :dword, :dword, :dword
procdesc HeapCompact :dword, :dword
procdesc GetProcessHeap
procdesc GetProcessHeaps :dword, :dword

struc	PROCESS_HEAP_ENTRY
	lpData			dd ?
	cbData			dd ?
	cbOverhead		db ?
	iRegionIndex		db ?
	wFlags			dw ?
label	hMem			dword
	dwCommittedSize 	dd ?
	dwUnCommittedSize	dd ?
	lpFirstBlock		dd ?
	lpLastBlock		dd ?
ends

PROCESS_HEAP_REGION		= 00001h
PROCESS_HEAP_UNCOMMITTED_RANGE	= 00002h
PROCESS_HEAP_ENTRY_BUSY 	= 00004h
PROCESS_HEAP_ENTRY_MOVEABLE	= 00010h
PROCESS_HEAP_ENTRY_DDESHARE	= 00020h

procdesc HeapLock :dword
procdesc HeapUnlock :dword
procdesc HeapWalk :dword, :dword

; GetBinaryType return values.

SCS_32BIT_BINARY		= 0
SCS_DOS_BINARY			= 1
SCS_WOW_BINARY			= 2
SCS_PIF_BINARY			= 3
SCS_POSIX_BINARY		= 4
SCS_OS216_BINARY		= 5

procdesc GetBinaryTypeA :dword, :dword
procdesc GetShortPathNameA :dword, :dword, :dword
procdesc GetLongPathNameA :dword, :dword, :dword
procdesc GetProcessAffinityMask :dword, :dword, :dword
procdesc SetProcessAffinityMask :dword, :dword
procdesc GetProcessTimes :dword, :dword, :dword, :dword, :dword
procdesc GetProcessWorkingSetSize :dword, :dword, :dword
procdesc SetProcessWorkingSetSize :dword, :dword, :dword
procdesc OpenProcess :dword, :dword, :dword
procdesc GetCurrentProcess
procdesc GetCurrentProcessId
procdesc ExitProcess :dword
procdesc TerminateProcess :dword, :dword
procdesc GetExitCodeProcess :dword, :dword
procdesc FatalExit :dword
procdesc GetEnvironmentStringsA
procdesc FreeEnvironmentStringsA :dword
procdesc RaiseException :dword, :dword, :dword, :dword
procdesc UnhandledExceptionFilter :dword
procdesc SetUnhandledExceptionFilter :dword
procdesc CreateFiber :dword, :dword, :dword
procdesc DeleteFiber :dword
procdesc ConvertThreadToFiber :dword
procdesc SwitchToFiber :dword
procdesc SwitchToThread

GetBinaryType			equ <GetBinaryTypeA>
GetShortPathName		equ <GetShortPathNameA>
GetLongPathName 		equ <GetLongPathNameA>
GetEnvironmentStrings		equ <GetEnvironmentStringsA>
FreeEnvironmentStrings		equ <FreeEnvironmentStringsA>

procdesc RegisterWaitForSingleObject :dword, :dword, :dword, :dword
procdesc RegisterWaitForSingleObjectEx :dword, :dword, :dword, :dword, :dword
procdesc UnregisterWait :dword
procdesc QueueUserWorkItem :dword, :dword, :dword
procdesc CreateTimerQueue
procdesc SetTimerQueueTimer :dword, :dword, :dword, :dword, :dword, :dword
procdesc ChangeTimerQueueTimer :dword, :dword, :dword, :dword
procdesc CancelTimerQueueTimer :dword, :dword
procdesc DeleteTimerQueue :dword
procdesc CreateThread :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateRemoteThread :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetCurrentThread
procdesc GetCurrentThreadId
procdesc SetThreadAffinityMask :dword, :dword
procdesc SetThreadIdealProcessor :dword, :dword
procdesc SetProcessPriorityBoost :dword, :dword
procdesc GetProcessPriorityBoost :dword, :dword
procdesc RequestWakeupLatency :dword
procdesc IsSystemResumeAutomatic
procdesc OpenThread :dword, :dword, :dword
procdesc SetThreadPriority :dword, :dword
procdesc SetThreadPriorityBoost :dword, :dword
procdesc GetThreadPriorityBoost :dword, :dword
procdesc GetThreadPriority :dword
procdesc GetThreadTimes :dword, :dword, :dword, :dword, :dword
procdesc ExitThread :dword
procdesc TerminateThread :dword, :dword
procdesc GetExitCodeThread :dword, :dword
procdesc GetThreadSelectorEntry :dword, :dword, :dword
procdesc SetThreadExecutionState :dword
procdesc GetLastError
procdesc SetLastError :dword
procdesc GetOverlappedResult :dword, :dword, :dword, :dword
procdesc CreateIoCompletionPort :dword, :dword, :dword, :dword
procdesc GetQueuedCompletionStatus :dword, :dword, :dword, :dword, :dword
procdesc PostQueuedCompletionStatus :dword, :dword, :dword, :dword

SEM_FAILCRITICALERRORS		= 00001h
SEM_NOGPFAULTERRORBOX		= 00002h
SEM_NOALIGNMENTFAULTEXCEPT	= 00004h
SEM_NOOPENFILEERRORBOX		= 08000h

procdesc SetErrorMode :dword
procdesc ReadProcessMemory :dword, :dword, :dword, :dword, :dword
procdesc WriteProcessMemory :dword, :dword, :dword, :dword, :dword
procdesc GetThreadContext :dword, :dword
procdesc SetThreadContext :dword, :dword
procdesc SuspendThread :dword
procdesc ResumeThread :dword
procdesc QueueUserAPC :dword, :dword, :dword
procdesc IsDebuggerPresent
procdesc DebugBreak
procdesc WaitForDebugEvent :dword, :dword
procdesc ContinueDebugEvent :dword, :dword, :dword
procdesc DebugActiveProcess :dword
procdesc InitializeCriticalSection :dword
procdesc EnterCriticalSection :dword
procdesc LeaveCriticalSection :dword
procdesc InitializeCriticalSectionAndSpinCount :dword, :dword
procdesc SetCriticalSectionSpinCount :dword, :dword
procdesc TryEnterCriticalSection :dword
procdesc DeleteCriticalSection :dword
procdesc SetEvent :dword
procdesc ResetEvent :dword
procdesc PulseEvent :dword
procdesc ReleaseSemaphore :dword, :dword, :dword
procdesc ReleaseMutex :dword
procdesc WaitForSingleObject :dword, :dword
procdesc WaitForMultipleObjects :dword, :dword, :dword, :dword
procdesc Sleep :dword
procdesc LoadResource :dword, :dword
procdesc SizeofResource :dword, :dword
procdesc GlobalDeleteAtom :dword
procdesc InitAtomTable :dword
procdesc DeleteAtom :dword
procdesc SetHandleCount :dword
procdesc GetLogicalDrives
procdesc LockFile :dword, :dword, :dword, :dword, :dword
procdesc UnlockFile :dword, :dword, :dword, :dword, :dword
procdesc LockFileEx :dword, :dword, :dword, :dword, :dword, :dword

LOCKFILE_FAIL_IMMEDIATELY	= 000000001h
LOCKFILE_EXCLUSIVE_LOCK 	= 000000002h

procdesc UnlockFileEx :dword, :dword, :dword, :dword, :dword

struc	BY_HANDLE_FILE_INFORMATION
	dwFileAttributes	dd ?
	ftCreationTime		FILETIME ?
	ftLastAccessTime	FILETIME ?
	ftLastWriteTime 	FILETIME ?
	dwVolumeSerialNumber	dd ?
	nFileSizeHigh		dd ?
	nFileSizeLow		dd ?
	nNumberOfLinks		dd ?
	nFileIndexHigh		dd ?
	nFileIndexLow		dd ?
ends

procdesc GetFileInformationByHandle :dword, :dword
procdesc GetFileType :dword
procdesc GetFileSize :dword, :dword
procdesc GetFileSizeEx :dword, :dword
procdesc GetStdHandle :dword
procdesc SetStdHandle :dword, :dword
procdesc WriteFile :dword, :dword, :dword, :dword, :dword
procdesc ReadFile :dword, :dword, :dword, :dword, :dword
procdesc FlushFileBuffers :dword
procdesc DeviceIoControl :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc RequestDeviceWakeup :dword
procdesc CancelDeviceWakeupRequest :dword
procdesc GetDevicePowerState :dword, :dword
procdesc SetMessageWaitingIndicator :dword, :dword
procdesc SetEndOfFile :dword
procdesc SetFilePointer :dword, :dword, :dword, :dword
procdesc SetFilePointerEx :dword, :dword, :dword, :dword
procdesc FindClose :dword
procdesc GetFileTime :dword, :dword, :dword, :dword
procdesc SetFileTime :dword, :dword, :dword, :dword
procdesc CloseHandle :dword
procdesc DuplicateHandle :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetHandleInformation :dword, :dword
procdesc SetHandleInformation :dword, :dword, :dword

HANDLE_FLAG_INHERIT		= 000000001h
HANDLE_FLAG_PROTECT_FROM_CLOSE	= 000000002h

HINSTANCE_ERROR 		= 32

procdesc LoadModule :dword, :dword
procdesc WinExec :dword, :dword
procdesc ClearCommBreak :dword
procdesc ClearCommError :dword, :dword, :dword
procdesc SetupComm :dword, :dword, :dword
procdesc EscapeCommFunction :dword, :dword
procdesc GetCommConfig :dword, :dword, :dword
procdesc GetCommMask :dword, :dword
procdesc GetCommProperties :dword, :dword
procdesc GetCommModemStatus :dword, :dword
procdesc GetCommState :dword, :dword
procdesc GetCommTimeouts :dword, :dword
procdesc PurgeComm :dword, :dword
procdesc SetCommBreak :dword
procdesc SetCommConfig :dword, :dword, :dword
procdesc SetCommMask :dword, :dword
procdesc SetCommState :dword, :dword
procdesc SetCommTimeouts :dword, :dword
procdesc TransmitCommChar :dword, :dword
procdesc WaitCommEvent :dword, :dword, :dword
procdesc SetTapePosition :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetTapePosition :dword, :dword, :dword, :dword, :dword
procdesc PrepareTape :dword, :dword, :dword
procdesc EraseTape :dword, :dword, :dword
procdesc CreateTapePartition :dword, :dword, :dword, :dword
procdesc WriteTapemark :dword, :dword, :dword, :dword
procdesc GetTapeStatus :dword
procdesc GetTapeParameters :dword, :dword, :dword, :dword

GET_TAPE_MEDIA_INFORMATION	= 0
GET_TAPE_DRIVE_INFORMATION	= 1

procdesc SetTapeParameters :dword, :dword, :dword

SET_TAPE_MEDIA_INFORMATION	= 0
SET_TAPE_DRIVE_INFORMATION	= 1

procdesc Beep :dword, :dword
procdesc MulDiv :dword, :dword, :dword
procdesc GetSystemTime :dword
procdesc GetSystemTimeAsFileTime :dword
procdesc SetSystemTime :dword
procdesc GetLocalTime :dword
procdesc SetLocalTime :dword
procdesc GetSystemInfo :dword

enum SYSTEMINFOCLASS\
	SystemInfoRemoteBoot = 1,\
	SystemInfoRemoteBootServerPath

procdesc GetSystemInfoExA :dword, :dword, :dword
procdesc IsProcessorFeaturePresent :dword

GetSystemInfoEx 		equ <GetSystemInfoExA>

struc	TIME_ZONE_INFORMATION
	Bias			dd ?
	StandardName		db 32 dup (?)
	StandardDate		SYSTEMTIME ?
	StandardBias		dd ?
	DaylightName		db 32 dup (?)
	DaylightDate		SYSTEMTIME ?
	DaylightBias		dd ?
ends

procdesc SystemTimeToTzSpecificLocalTime :dword, :dword, :dword
procdesc GetTimeZoneInformation :dword
procdesc SetTimeZoneInformation :dword

;
; Routines to convert back and forth between system time and file time
;

procdesc SystemTimeToFileTime :dword, :dword
procdesc FileTimeToLocalFileTime :dword, :dword
procdesc LocalFileTimeToFileTime :dword, :dword
procdesc FileTimeToSystemTime :dword, :dword
procdesc CompareFileTime :dword, :dword
procdesc FileTimeToDosDateTime :dword, :dword, :dword
procdesc DosDateTimeToFileTime :dword, :dword, :dword
procdesc GetTickCount
procdesc SetSystemTimeAdjustment :dword, :dword
procdesc GetSystemTimeAdjustment :dword, :dword, :dword
procdesc FormatMessageA :dword, :dword, :dword, :dword, :dword, :dword, :dword

FormatMessage			equ <FormatMessageA>

FORMAT_MESSAGE_ALLOCATE_BUFFER	= 000000100h
FORMAT_MESSAGE_IGNORE_INSERTS	= 000000200h
FORMAT_MESSAGE_FROM_STRING	= 000000400h
FORMAT_MESSAGE_FROM_HMODULE	= 000000800h
FORMAT_MESSAGE_FROM_SYSTEM	= 000001000h
FORMAT_MESSAGE_ARGUMENT_ARRAY	= 000002000h
FORMAT_MESSAGE_MAX_WIDTH_MASK	= 0000000FFh

procdesc CreatePipe :dword, :dword, :dword, :dword
procdesc ConnectNamedPipe :dword, :dword
procdesc DisconnectNamedPipe :dword
procdesc SetNamedPipeHandleState :dword, :dword, :dword, :dword
procdesc GetNamedPipeInfo :dword, :dword, :dword, :dword, :dword
procdesc PeekNamedPipe :dword, :dword, :dword, :dword, :dword, :dword
procdesc TransactNamedPipe :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateMailslotA :dword, :dword, :dword, :dword
procdesc GetMailslotInfo :dword, :dword, :dword, :dword, :dword
procdesc SetMailslotInfo :dword, :dword
procdesc MapViewOfFile :dword, :dword, :dword, :dword, :dword
procdesc MapViewOfFileVlm :dword, :dword, :dword, :dword, :dword
procdesc FlushViewOfFile :dword, :dword
procdesc UnmapViewOfFile :dword
procdesc UnmapViewOfFileVlm :dword

CreateMailslot			equ <CreateMailslotA>

;
; File Encryption API
;

procdesc EncryptFileA :dword
procdesc DecryptFileA :dword, :dword

EncryptFile			equ <EncryptFileA>
DecryptFile			equ <DecryptFileA>

;
;  Encryption Status Value
;

FILE_ENCRYPTABLE		= 0
FILE_IS_ENCRYPTED		= 1
FILE_SYSTEM_ATTR		= 2
FILE_ROOT_DIR			= 3
FILE_SYSTEM_DIR 		= 4
FILE_UNKNOWN			= 5
FILE_SYSTEM_NOT_SUPPORT 	= 6
FILE_USER_DISALLOWED		= 7
FILE_READ_ONLY			= 8

procdesc FileEncryptionStatusA :dword, :dword

FileEncryptionStatus		equ <FileEncryptionStatusA>

;
; Currently defined recovery flags
;

EFS_USE_RECOVERY_KEYS		= (01h)

;
;  OpenRaw flag values
;

CREATE_FOR_IMPORT		= (1)
CREATE_FOR_DIR			= (2)

procdesc OpenEncryptedFileRawA :dword, :dword, :dword

OpenEncryptedFileRaw		equ <OpenEncryptedFileRawA>

procdesc ReadEncryptedFileRaw :dword, :dword, :dword
procdesc WriteEncryptedFileRaw :dword, :dword, :dword
procdesc CloseEncryptedFileRaw :dword

;
; _l Compat Functions
;

procdesc lstrcmpA :dword, :dword
procdesc lstrcmpiA :dword, :dword
procdesc lstrcpynA :dword, :dword, :dword
procdesc lstrcpyA :dword, :dword
procdesc lstrcatA :dword, :dword
procdesc lstrlenA :dword

lstrcmp 			equ <lstrcmpA>
lstrcmpi			equ <lstrcmpiA>
lstrcpyn			equ <lstrcpynA>
lstrcpy 			equ <lstrcpyA>
lstrcat 			equ <lstrcatA>
lstrlen 			equ <lstrlenA>

procdesc OpenFile :dword, :dword, :dword
procdesc _lopen :dword, :dword
procdesc _lcreat :dword, :dword
procdesc _lread :dword, :dword, :dword
procdesc _lwrite :dword, :dword, :dword
procdesc _hread :dword, :dword, :dword
procdesc _hwrite :dword, :dword, :dword
procdesc _lclose :dword
procdesc _llseek :dword, :dword, :dword
procdesc IsTextUnicode :dword, :dword, :dword
procdesc TlsAlloc

TLS_OUT_OF_INDEXES		= 0FFFFFFFFh

procdesc TlsGetValue :dword
procdesc TlsSetValue :dword, :dword
procdesc TlsFree :dword
procdesc SleepEx :dword, :dword
procdesc WaitForSingleObjectEx :dword, :dword, :dword
procdesc WaitForMultipleObjectsEx :dword, :dword, :dword, :dword, :dword
procdesc SignalObjectAndWait :dword, :dword, :dword, :dword
procdesc ReadFileEx :dword, :dword, :dword, :dword, :dword
procdesc WriteFileEx :dword, :dword, :dword, :dword, :dword
procdesc BackupRead :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc BackupSeek :dword, :dword, :dword, :dword, :dword, :dword
procdesc BackupWrite :dword, :dword, :dword, :dword, :dword, :dword, :dword

;
;  Stream id structure
;

struc	WIN32_STREAM_ID
	dwStreamId		dd ?
	dwStreamAttributes	dd ?
	Size			dq ?
	dwStreamNameSize	dd ?
	cStreamName		db ANYSIZE_ARRAY dup (?)
ends

;
;  Stream Ids
;

BACKUP_INVALID			= 000000000h
BACKUP_DATA			= 000000001h
BACKUP_EA_DATA			= 000000002h
BACKUP_SECURITY_DATA		= 000000003h
BACKUP_ALTERNATE_DATA		= 000000004h
BACKUP_LINK			= 000000005h
BACKUP_PROPERTY_DATA		= 000000006h
BACKUP_OBJECT_ID		= 000000007h
BACKUP_REPARSE_DATA		= 000000008h
BACKUP_SPARSE_BLOCK		= 000000009h

;
;  Stream Attributes
;

STREAM_NORMAL_ATTRIBUTE 	= 000000000h
STREAM_MODIFIED_WHEN_READ	= 000000001h
STREAM_CONTAINS_SECURITY	= 000000002h
STREAM_CONTAINS_PROPERTIES	= 000000004h
STREAM_SPARSE_ATTRIBUTE 	= 000000008h

procdesc ReadFileScatter :dword, :dword, :dword, :dword, :dword
procdesc WriteFileGather :dword, :dword, :dword, :dword, :dword

;
; Dual Mode API below this line. Dual Mode Structures also included.
;

STARTF_USESHOWWINDOW		= 000000001h
STARTF_USESIZE			= 000000002h
STARTF_USEPOSITION		= 000000004h
STARTF_USECOUNTCHARS		= 000000008h
STARTF_USEFILLATTRIBUTE 	= 000000010h
STARTF_RUNFULLSCREEN		= 000000020h  ; ignored for non-x86 platforms
STARTF_FORCEONFEEDBACK		= 000000040h
STARTF_FORCEOFFFEEDBACK 	= 000000080h
STARTF_USESTDHANDLES		= 000000100h
STARTF_USEHOTKEY		= 000000200h

struc	STARTUPINFO
	cb			dd ?
	lpReserved		dd ?
	lpDesktop		dd ?
	lpTitle 		dd ?
	dwX			dd ?
	dwY			dd ?
	dwXSize 		dd ?
	dwYSize 		dd ?
	dwXCountChars		dd ?
	dwYCountChars		dd ?
	dwFillAttribute 	dd ?
	dwFlags 		dd ?
	wShowWindow		dw ?
	cbReserved2		dw ?
	lpReserved2		dd ?
	hStdInput		dd ?
	hStdOutput		dd ?
	hStdError		dd ?
ends

SHUTDOWN_NORETRY		= 000000001h

struc	WIN32_FIND_DATA
	dwFileAttributes	dd ?
	ftCreationTime		FILETIME ?
	ftLastAccessTime	FILETIME ?
	ftLastWriteTime 	FILETIME ?
	nFileSizeHigh		dd ?
	nFileSizeLow		dd ?
	dwReserved0		dd ?
	dwReserved1		dd ?
	cFileName		db MAX_PATH dup (?)
	cAlternateFileName	db 14 dup (?)
ends

struc	WIN32_FILE_ATTRIBUTE_DATA
	dwFileAttributes	dd ?
	ftCreationTime		FILETIME ?
	ftLastAccessTime	FILETIME ?
	ftLastWriteTime 	FILETIME ?
	nFileSizeHigh		dd ?
	nFileSizeLow		dd ?
ends

procdesc CreateMutexA :dword, :dword, :dword
procdesc OpenMutexA :dword, :dword, :dword
procdesc CreateEventA :dword, :dword, :dword, :dword
procdesc OpenEventA :dword, :dword, :dword
procdesc CreateSemaphoreA :dword, :dword, :dword, :dword
procdesc OpenSemaphoreA :dword, :dword, :dword
procdesc CreateWaitableTimerA :dword, :dword, :dword
procdesc OpenWaitableTimerA :dword, :dword, :dword
procdesc SetWaitableTimer :dword, :dword, :dword, :dword, :dword, :dword
procdesc CancelWaitableTimer :dword
procdesc CreateFileMappingA :dword, :dword, :dword, :dword, :dword, :dword
procdesc OpenFileMappingA :dword, :dword, :dword
procdesc GetLogicalDriveStringsA :dword, :dword
procdesc LoadLibraryA :dword
procdesc LoadLibraryExA :dword, :dword, :dword

CreateMutex			equ <CreateMutexA>
OpenMutex			equ <OpenMutexA>
CreateEvent			equ <CreateEventA>
OpenEvent			equ <OpenEventA>
CreateSemaphore 		equ <CreateSemaphoreA>
OpenSemaphore			equ <OpenSemaphoreA>
CreateWaitableTimer		equ <CreateWaitableTimerA>
OpenWaitableTimer		equ <OpenWaitableTimerA>
CreateFileMapping		equ <CreateFileMappingA>
OpenFileMapping 		equ <OpenFileMappingA>
GetLogicalDriveStrings		equ <GetLogicalDriveStringsA>
LoadLibrary			equ <LoadLibraryA>
LoadLibraryEx			equ <LoadLibraryExA>

DONT_RESOLVE_DLL_REFERENCES	= 000000001h
LOAD_LIBRARY_AS_DATAFILE	= 000000002h
LOAD_WITH_ALTERED_SEARCH_PATH	= 000000008h

proctype ENUMRESTYPEPROC :dword, :dword, :dword
proctype ENUMRESNAMEPROC :dword, :dword, :dword, :dword
proctype ENUMRESLANGPROC :dword, :dword, :dword, :dword, :dword

procdesc GetModuleFileNameA :dword, :dword, :dword
procdesc GetModuleHandleA :dword
procdesc CreateProcessA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetProcessShutdownParameters :dword, :dword
procdesc GetProcessShutdownParameters :dword, :dword
procdesc GetProcessVersion :dword
procdesc FatalAppExitA :dword, :dword
procdesc GetStartupInfoA :dword
procdesc GetCommandLineA
procdesc GetEnvironmentVariableA :dword, :dword, :dword
procdesc SetEnvironmentVariableA :dword, :dword
procdesc ExpandEnvironmentStringsA :dword, :dword, :dword
procdesc OutputDebugStringA :dword
procdesc FindResourceA :dword, :dword, :dword
procdesc FindResourceExA :dword, :dword, :dword, :dword
procdesc EnumResourceTypesA :dword, :dword, :dword
procdesc EnumResourceNamesA :dword, :dword, :dword, :dword
procdesc EnumResourceLanguagesA :dword, :dword, :dword, :dword, :dword
procdesc BeginUpdateResourceA :dword, :dword
procdesc UpdateResourceA :dword, :dword, :dword, :dword, :dword, :dword
procdesc EndUpdateResourceA :dword, :dword
procdesc GlobalAddAtomA :dword
procdesc GlobalFindAtomA :dword
procdesc GlobalGetAtomNameA :dword, :dword, :dword
procdesc AddAtomA :dword
procdesc FindAtomA :dword
procdesc GetAtomNameA :dword, :dword, :dword
procdesc GetProfileIntA :dword, :dword, :dword
procdesc GetProfileStringA :dword, :dword, :dword, :dword, :dword
procdesc WriteProfileStringA :dword, :dword, :dword
procdesc GetProfileSectionA :dword, :dword, :dword
procdesc WriteProfileSectionA :dword, :dword
procdesc GetPrivateProfileIntA :dword, :dword, :dword, :dword
procdesc GetPrivateProfileStringA :dword, :dword, :dword, :dword, :dword, :dword
procdesc WritePrivateProfileStringA :dword, :dword, :dword, :dword
procdesc GetPrivateProfileSectionA :dword, :dword, :dword, :dword
procdesc WritePrivateProfileSectionA :dword, :dword, :dword
procdesc GetPrivateProfileSectionNamesA :dword, :dword, :dword
procdesc GetPrivateProfileStructA :dword, :dword, :dword, :dword, :dword
procdesc WritePrivateProfileStructA :dword, :dword, :dword, :dword, :dword
procdesc GetDriveTypeA :dword
procdesc GetSystemDirectoryA :dword, :dword
procdesc GetTempPathA :dword, :dword
procdesc GetTempFileNameA :dword, :dword, :dword, :dword
procdesc GetWindowsDirectoryA :dword, :dword
procdesc SetCurrentDirectoryA :dword
procdesc GetCurrentDirectoryA :dword, :dword
procdesc GetDiskFreeSpaceA :dword, :dword, :dword, :dword, :dword
procdesc GetDiskFreeSpaceExA :dword, :dword, :dword, :dword
procdesc CreateDirectoryA :dword, :dword
procdesc CreateDirectoryExA :dword, :dword, :dword
procdesc RemoveDirectoryA :dword
procdesc GetFullPathNameA :dword, :dword, :dword, :dword

GetModuleFileName		equ <GetModuleFileNameA>
GetModuleHandle 		equ <GetModuleHandleA>
CreateProcess			equ <CreateProcessA>
FatalAppExit			equ <FatalAppExitA>
GetStartupInfo			equ <GetStartupInfoA >
GetCommandLine			equ <GetCommandLineA>
GetEnvironmentVariable		equ <GetEnvironmentVariableA>
SetEnvironmentVariable		equ <SetEnvironmentVariableA>
ExpandEnvironmentStrings	equ <ExpandEnvironmentStringsA>
OutputDebugString		equ <OutputDebugStringA>
FindResource			equ <FindResourceA>
FindResourceEx			equ <FindResourceExA>
EnumResourceTypes		equ <EnumResourceTypesA>
EnumResourceNames		equ <EnumResourceNamesA>
EnumResourceLanguages		equ <EnumResourceLanguagesA>
BeginUpdateResource		equ <BeginUpdateResourceA>
UpdateResource			equ <UpdateResourceA>
EndUpdateResource		equ <EndUpdateResourceA>
GlobalAddAtom			equ <GlobalAddAtomA>
GlobalFindAtom			equ <GlobalFindAtomA>
GlobalGetAtomName		equ <GlobalGetAtomNameA>
AddAtom 			equ <AddAtomA>
FindAtom			equ <FindAtomA>
GetAtomName			equ <GetAtomNameA>
GetProfileInt			equ <GetProfileIntA>
GetProfileString		equ <GetProfileStringA>
WriteProfileString		equ <WriteProfileStringA>
GetProfileSection		equ <GetProfileSectionA>
WriteProfileSection		equ <WriteProfileSectionA>
GetPrivateProfileInt		equ <GetPrivateProfileIntA>
GetPrivateProfileString 	equ <GetPrivateProfileStringA>
WritePrivateProfileString	equ <WritePrivateProfileStringA>
GetPrivateProfileSection	equ <GetPrivateProfileSectionA>
WritePrivateProfileSection	equ <WritePrivateProfileSectionA>
GetPrivateProfileSectionNames	equ <GetPrivateProfileSectionNamesA>
GetPrivateProfileStruct 	equ <GetPrivateProfileStructA>
WritePrivateProfileStruct	equ <WritePrivateProfileStructA>
GetDriveType			equ <GetDriveTypeA>
GetSystemDirectory		equ <GetSystemDirectoryA>
GetTempPath			equ <GetTempPathA>
GetTempFileName 		equ <GetTempFileNameA>
GetWindowsDirectory		equ <GetWindowsDirectoryA>
SetCurrentDirectory		equ <SetCurrentDirectoryA>
GetCurrentDirectory		equ <GetCurrentDirectoryA>
GetDiskFreeSpace		equ <GetDiskFreeSpaceA>
GetDiskFreeSpaceEx		equ <GetDiskFreeSpaceExA>
CreateDirectory 		equ <CreateDirectoryA>
CreateDirectoryEx		equ <CreateDirectoryExA>
RemoveDirectory 		equ <RemoveDirectoryA>
GetFullPathName 		equ <GetFullPathNameA>

DDD_RAW_TARGET_PATH		= 000000001h
DDD_REMOVE_DEFINITION		= 000000002h
DDD_EXACT_MATCH_ON_REMOVE	= 000000004h
DDD_NO_BROADCAST_SYSTEM 	= 000000008h

procdesc DefineDosDeviceA :dword, :dword, :dword
procdesc QueryDosDeviceA :dword, :dword, :dword
procdesc CreateFileA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetFileAttributesA :dword, :dword
procdesc GetFileAttributesA :dword

DefineDosDevice 		equ <DefineDosDeviceA>
QueryDosDevice			equ <QueryDosDeviceA>
CreateFile			equ <CreateFileA>
SetFileAttributes		equ <SetFileAttributesA>
GetFileAttributes		equ <GetFileAttributesA>

procdesc GetFileAttributesExA :dword, :dword, :dword
procdesc GetCompressedFileSizeA :dword, :dword
procdesc DeleteFileA :dword

GetFileAttributesEx		equ <GetFileAttributesExA>
GetCompressedFileSize		equ <GetCompressedFileSizeA>
DeleteFile			equ <DeleteFileA>

enum GET_FILEEX_INFO_LEVELS\
	GetFileExInfoStandard,\
	GetFileExMaxInfoLevel

enum FINDEX_INFO_LEVELS\
	FindExInfoStandard,\
	FindExInfoMaxInfoLevel

enum FINDEX_SEARCH_OPS\
	FindExSearchNameMatch,\
	FindExSearchLimitToDirectories,\
	FindExSearchLimitToDevices,\
	FindExSearchMaxSearchOp

FIND_FIRST_EX_CASE_SENSITIVE	= 000000001h

procdesc FindFirstFileExA :dword, :dword, :dword, :dword, :dword, :dword
procdesc FindFirstFileA :dword, :dword
procdesc FindNextFileA :dword, :dword
procdesc SearchPathA :dword, :dword, :dword, :dword, :dword, :dword
procdesc CopyFileA :dword, :dword, :dword
procdesc CopyFileExA :dword, :dword, :dword, :dword, :dword, :dword
procdesc MoveFileA :dword, :dword
procdesc MoveFileExA :dword, :dword, :dword
procdesc MoveFileWithProgressA :dword, :dword, :dword, :dword, :dword

FindFirstFileEx 		equ <FindFirstFileExA>
FindFirstFile			equ <FindFirstFileA>
FindNextFile			equ <FindNextFileA>
SearchPath			equ <SearchPathA>
CopyFile			equ <CopyFileA>
CopyFileEx			equ <CopyFileExA>
MoveFile			equ <MoveFileA>
MoveFileEx			equ <MoveFileExA>
MoveFileWithProgress		equ <MoveFileWithProgressA>

MOVEFILE_REPLACE_EXISTING	= 000000001h
MOVEFILE_COPY_ALLOWED		= 000000002h
MOVEFILE_DELAY_UNTIL_REBOOT	= 000000004h
MOVEFILE_WRITE_THROUGH		= 000000008h
MOVEFILE_CREATE_HARDLINK	= 000000010h
MOVEFILE_FAIL_IF_NOT_TRACKABLE	= 000000020h

procdesc ReplaceFile :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateHardLinkA :dword, :dword, :dword
procdesc CreateNamedPipeA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetNamedPipeHandleStateA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc CallNamedPipeA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc WaitNamedPipeA :dword, :dword
procdesc SetVolumeLabelA :dword, :dword
procdesc SetFileApisToOEM
procdesc SetFileApisToANSI
procdesc AreFileApisANSI
procdesc GetVolumeInformationA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc CancelIo :dword

CreateHardLink			equ <CreateHardLinkA>
CreateNamedPipe 		equ <CreateNamedPipeA>
GetNamedPipeHandleState 	equ <GetNamedPipeHandleStateA>
CallNamedPipe			equ <CallNamedPipeA>
WaitNamedPipe			equ <WaitNamedPipeA>
SetVolumeLabel			equ <SetVolumeLabelA>
GetVolumeInformation		equ <GetVolumeInformationA>

;
; Event logging APIs
;

procdesc ClearEventLogA :dword, :dword
procdesc BackupEventLogA :dword, :dword
procdesc CloseEventLog :dword
procdesc DeregisterEventSource :dword
procdesc NotifyChangeEventLog :dword, :dword
procdesc GetNumberOfEventLogRecords :dword, :dword
procdesc GetOldestEventLogRecord :dword, :dword
procdesc OpenEventLogA :dword, :dword
procdesc RegisterEventSourceA :dword, :dword
procdesc OpenBackupEventLogA :dword, :dword
procdesc ReadEventLogA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc ReportEventA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

ClearEventLog			equ <ClearEventLogA>
BackupEventLog			equ <BackupEventLogA>
OpenEventLog			equ <OpenEventLogA>
RegisterEventSource		equ <RegisterEventSourceA>
OpenBackupEventLog		equ <OpenBackupEventLogA>
ReadEventLog			equ <ReadEventLogA>
ReportEvent			equ <ReportEventA>

;
; Security APIs
;

procdesc DuplicateToken :dword, :dword, :dword
procdesc GetKernelObjectSecurity :dword, :dword, :dword, :dword, :dword
procdesc ImpersonateNamedPipeClient :dword
procdesc ImpersonateSelf :dword
procdesc RevertToSelf
procdesc SetThreadToken :dword, :dword
procdesc AccessCheck :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc AccessCheckByType :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc AccessCheckByTypeResultList :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc OpenProcessToken :dword, :dword, :dword
procdesc OpenThreadToken :dword, :dword, :dword, :dword
procdesc GetTokenInformation :dword, :dword, :dword, :dword, :dword
procdesc SetTokenInformation :dword, :dword, :dword, :dword
procdesc AdjustTokenPrivileges :dword, :dword, :dword, :dword, :dword, :dword
procdesc AdjustTokenGroups :dword, :dword, :dword, :dword, :dword, :dword
procdesc PrivilegeCheck :dword, :dword, :dword
procdesc AccessCheckAndAuditAlarmA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc AccessCheckByTypeAndAuditAlarmA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc AccessCheckByTypeResultListAndAuditAlarmA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc ObjectOpenAuditAlarmA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc ObjectPrivilegeAuditAlarmA :dword, :dword, :dword, :dword, :dword, :dword
procdesc ObjectCloseAuditAlarmA :dword, :dword, :dword
procdesc ObjectDeleteAuditAlarmA :dword, :dword, :dword
procdesc PrivilegedServiceAuditAlarmA :dword, :dword, :dword, :dword, :dword
procdesc IsValidSid :dword
procdesc EqualSid :dword, :dword
procdesc EqualPrefixSid :dword, :dword
procdesc GetSidLengthRequired :dword
procdesc AllocateAndInitializeSid :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc FreeSid :dword
procdesc InitializeSid :dword, :dword, :dword
procdesc GetSidIdentifierAuthority :dword
procdesc GetSidSubAuthority :dword, :dword
procdesc GetSidSubAuthorityCount :dword
procdesc GetLengthSid :dword
procdesc CopySid :dword, :dword, :dword
procdesc AreAllAccessesGranted :dword, :dword
procdesc AreAnyAccessesGranted :dword, :dword
procdesc MapGenericMask :dword, :dword
procdesc IsValidAcl :dword
procdesc InitializeAcl :dword, :dword, :dword
procdesc GetAclInformation :dword, :dword, :dword, :dword
procdesc SetAclInformation :dword, :dword, :dword, :dword
procdesc AddAce :dword, :dword, :dword, :dword, :dword
procdesc DeleteAce :dword, :dword
procdesc GetAce :dword, :dword, :dword
procdesc AddAccessAllowedAce :dword, :dword, :dword, :dword
procdesc AddAccessAllowedAceEx :dword, :dword, :dword, :dword, :dword
procdesc AddAccessDeniedAce :dword, :dword, :dword, :dword
procdesc AddAccessDeniedAceEx :dword, :dword, :dword, :dword, :dword
procdesc AddAuditAccessAce :dword, :dword, :dword, :dword, :dword, :dword
procdesc AddAuditAccessAceEx :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc AddAccessAllowedObjectAce :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc AddAccessDeniedObjectAce :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc AddAuditAccessObjectAce :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc FindFirstFreeAce :dword, :dword
procdesc InitializeSecurityDescriptor :dword, :dword
procdesc IsValidSecurityDescriptor :dword
procdesc GetSecurityDescriptorLength :dword
procdesc GetSecurityDescriptorControl :dword, :dword, :dword
procdesc SetSecurityDescriptorControl :dword, :dword, :dword
procdesc SetSecurityDescriptorDacl :dword, :dword, :dword, :dword
procdesc GetSecurityDescriptorDacl :dword, :dword, :dword, :dword
procdesc SetSecurityDescriptorSacl :dword, :dword, :dword, :dword
procdesc GetSecurityDescriptorSacl :dword, :dword, :dword, :dword
procdesc SetSecurityDescriptorOwner :dword, :dword, :dword
procdesc GetSecurityDescriptorOwner :dword, :dword, :dword
procdesc SetSecurityDescriptorGroup :dword, :dword, :dword
procdesc GetSecurityDescriptorGroup :dword, :dword, :dword
procdesc CreatePrivateObjectSecurity :dword, :dword, :dword, :dword, :dword, :dword
procdesc ConvertToAutoInheritPrivateObjectSecurity :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreatePrivateObjectSecurityEx :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetPrivateObjectSecurity :dword, :dword, :dword, :dword, :dword
procdesc SetPrivateObjectSecurityEx :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetPrivateObjectSecurity :dword, :dword, :dword, :dword, :dword
procdesc DestroyPrivateObjectSecurity :dword
procdesc MakeSelfRelativeSD :dword, :dword, :dword
procdesc MakeAbsoluteSD :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetFileSecurityA :dword, :dword, :dword
procdesc GetFileSecurityA :dword, :dword, :dword, :dword, :dword
procdesc SetKernelObjectSecurity :dword, :dword, :dword
procdesc FindFirstChangeNotificationA :dword, :dword, :dword
procdesc FindNextChangeNotification :dword
procdesc FindCloseChangeNotification :dword
procdesc ReadDirectoryChangesW :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc VirtualLock :dword, :dword
procdesc VirtualUnlock :dword, :dword
procdesc MapViewOfFileEx :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetPriorityClass :dword, :dword
procdesc GetPriorityClass :dword
procdesc IsBadReadPtr :dword, :dword
procdesc IsBadWritePtr :dword, :dword
procdesc IsBadHugeReadPtr :dword, :dword
procdesc IsBadHugeWritePtr :dword, :dword
procdesc IsBadCodePtr :dword
procdesc IsBadStringPtrA :dword, :dword
procdesc LookupAccountSidA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc LookupAccountNameA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc LookupPrivilegeValueA :dword, :dword, :dword
procdesc LookupPrivilegeNameA :dword, :dword, :dword, :dword
procdesc LookupPrivilegeDisplayNameA :dword, :dword, :dword, :dword, :dword
procdesc AllocateLocallyUniqueId :dword
procdesc BuildCommDCBA :dword, :dword
procdesc BuildCommDCBAndTimeoutsA :dword, :dword, :dword
procdesc CommConfigDialogA :dword, :dword, :dword
procdesc GetDefaultCommConfigA :dword, :dword, :dword
procdesc SetDefaultCommConfigA :dword, :dword, :dword

AccessCheckAndAuditAlarm	equ <AccessCheckAndAuditAlarmA>
AccessCheckByTypeAndAuditAlarm	equ <AccessCheckByTypeAndAuditAlarmA>
AccessCheckByTypeResultListAndAuditAlarm equ <AccessCheckByTypeResultListAndAuditAlarmA>
ObjectOpenAuditAlarm		equ <ObjectOpenAuditAlarmA>
ObjectPrivilegeAuditAlarm	equ <ObjectPrivilegeAuditAlarmA>
ObjectCloseAuditAlarm		equ <ObjectCloseAuditAlarmA>
ObjectDeleteAuditAlarm		equ <ObjectDeleteAuditAlarmA>
PrivilegedServiceAuditAlarm	equ <PrivilegedServiceAuditAlarmA>
SetFileSecurity 		equ <SetFileSecurityA>
GetFileSecurity 		equ <GetFileSecurityA>
FindFirstChangeNotification	equ <FindFirstChangeNotificationA>
IsBadStringPtr			equ <IsBadStringPtrA>
LookupAccountSid		equ <LookupAccountSidA>
LookupAccountName		equ <LookupAccountNameA>
LookupPrivilegeValue		equ <LookupPrivilegeValueA>
LookupPrivilegeName		equ <LookupPrivilegeNameA>
LookupPrivilegeDisplayName	equ <LookupPrivilegeDisplayNameA>
BuildCommDCB			equ <BuildCommDCBA>
BuildCommDCBAndTimeouts 	equ <BuildCommDCBAndTimeoutsA>
CommConfigDialog		equ <CommConfigDialogA>
GetDefaultCommConfig		equ <GetDefaultCommConfigA>
SetDefaultCommConfig		equ <SetDefaultCommConfigA>

MAX_COMPUTERNAME_LENGTH 	= 31

procdesc GetComputerNameA :dword, :dword
procdesc SetComputerNameA :dword

GetComputerName 		equ <GetComputerNameA>
SetComputerName 		equ <SetComputerNameA>

enum COMPUTER_NAME_FORMAT\
	ComputerNameNetBIOS,\
	ComputerNameDnsHostname,\
	ComputerNameDnsDomain,\
	ComputerNameDnsFullyQualified,\
	ComputerNamePhysicalNetBIOS,\
	ComputerNamePhysicalDnsHostname,\
	ComputerNamePhysicalDnsDomain,\
	ComputerNamePhysicalDnsFullyQualified,\
	ComputerNameMax

GetComputerNameEx		equ <GetComputerNameExA>
SetComputerNameEx		equ <SetComputerNameExA>
DnsHostnameToComputerName	equ <DnsHostnameToComputerNameA>
GetUserName			equ <GetUserNameA>

procdesc GetComputerNameExA :dword, :dword, :dword
procdesc SetComputerNameExA :dword, :dword
procdesc DnsHostnameToComputerNameA :dword, :dword, :dword
procdesc GetUserNameA :dword, :dword

;
; Logon Support APIs
;

LOGON32_LOGON_INTERACTIVE	= 2
LOGON32_LOGON_NETWORK		= 3
LOGON32_LOGON_BATCH		= 4
LOGON32_LOGON_SERVICE		= 5

LOGON32_PROVIDER_DEFAULT	= 0
LOGON32_PROVIDER_WINNT35	= 1
LOGON32_PROVIDER_WINNT40	= 2
LOGON32_PROVIDER_WINNT50	= 3

procdesc LogonUserA :dword, :dword, :dword, :dword, :dword, :dword
procdesc ImpersonateLoggedOnUser :dword
procdesc CreateProcessAsUserA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateProcessWithLogonW :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc DuplicateTokenEx :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateRestrictedToken :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc IsProcessRestricted
procdesc IsTokenRestricted
procdesc GetSiteSidFromToken :dword
procdesc GetSiteSidFromUrl :dword
procdesc GetSiteNameFromSid :dword, :dword
procdesc GetMangledSiteSid :dword, :dword, :dword

LogonUser			equ <LogonUserA>
CreateProcessAsUser		equ <CreateProcessAsUserA>

MAX_MANGLED_SITE		= (27)

procdesc GetSiteDirectoryA :dword, :dword, :dword
procdesc CheckTokenMembership :dword, :dword, :dword

GetSiteDirectory		equ <GetSiteDirectoryA>

;
; Plug-and-Play API's
;

HW_PROFILE_GUIDLEN		= 39	  ; 36-characters plus NULL terminator
MAX_PROFILE_LEN 		= 80

DOCKINFO_UNDOCKED		= (01h)
DOCKINFO_DOCKED 		= (02h)
DOCKINFO_USER_SUPPLIED		= (04h)
DOCKINFO_USER_UNDOCKED		= (DOCKINFO_USER_SUPPLIED + DOCKINFO_UNDOCKED)
DOCKINFO_USER_DOCKED		= (DOCKINFO_USER_SUPPLIED + DOCKINFO_DOCKED)

struc	HW_PROFILE_INFO
	dwDockInfo		dd ?
	szHwProfileGuid 	db HW_PROFILE_GUIDLEN dup (?)
	szHwProfileName 	db MAX_PROFILE_LEN dup (?)
ends

procdesc GetCurrentHwProfileA :dword

GetCurrentHwProfile		equ <GetCurrentHwProfileA>

;
; Performance counter API's
;

procdesc QueryPerformanceCounter :dword
procdesc QueryPerformanceFrequency :dword

struc	OSVERSIONINFO
	dwOSVersionInfoSize	dd ?
	dwMajorVersion		dd ?
	dwMinorVersion		dd ?
	dwBuildNumber		dd ?
	dwPlatformId		dd ?
	szCSDVersion		db 128 dup (?)	; Maintenance string for PSS usage
ends

struc	OSVERSIONINFOEX
	dwOSVersionInfoSize	dd ?
	dwMajorVersion		dd ?
	dwMinorVersion		dd ?
	dwBuildNumber		dd ?
	dwPlatformId		dd ?
	szCSDVersion		db 128 dup (?)	; Maintenance string for PSS usage
	wServicePackMajor	dw ?
	wServicePackMinor	dw ?
	wSuiteMask		dw ?
	wReserved		dw ?
ends

;
; dwPlatformId defines:
;

VER_PLATFORM_WIN32s		= 0
VER_PLATFORM_WIN32_WINDOWS	= 1
VER_PLATFORM_WIN32_NT		= 2

procdesc GetVersionExA :dword

GetVersionEx			equ <GetVersionExA>

;
; VerifyVersionInfo() conditions
;

VER_EQUAL			= 1
VER_GREATER			= 2
VER_GREATER_EQUAL		= 3
VER_LESS			= 4
VER_LESS_EQUAL			= 5
VER_AND 			= 6
VER_OR				= 7

;
; VerifyVersionInfo() type mask bits
;

VER_MINORVERSION		= 00000001h
VER_MAJORVERSION		= 00000002h
VER_BUILDNUMBER 		= 00000004h
VER_PLATFORMID			= 00000008h
VER_SERVICEPACKMINOR		= 00000010h
VER_SERVICEPACKMAJOR		= 00000020h
VER_SUITENAME			= 00000040h

procdesc VerifyVersionInfoA :dword, :dword, :dword

VerifyVersionInfo		equ <VerifyVersionInfoA>

;
; DOS and OS/2 Compatible Error Code definitions returned by the Win32 Base
; API functions.
;

;include "winerror.inc"

; Abnormal termination codes

TC_NORMAL			= 0
TC_HARDERR			= 1
TC_GP_TRAP			= 2
TC_SIGNAL			= 3

;
; Power Management APIs
;

AC_LINE_OFFLINE 		= 000h
AC_LINE_ONLINE			= 001h
AC_LINE_BACKUP_POWER		= 002h
AC_LINE_UNKNOWN 		= 0FFh

BATTERY_FLAG_HIGH		= 001h
BATTERY_FLAG_LOW		= 002h
BATTERY_FLAG_CRITICAL		= 004h
BATTERY_FLAG_CHARGING		= 008h
BATTERY_FLAG_NO_BATTERY 	= 080h
BATTERY_FLAG_UNKNOWN		= 0FFh

BATTERY_PERCENTAGE_UNKNOWN	= 0FFh

BATTERY_LIFE_UNKNOWN		= 0FFFFFFFFh

struc	SYSTEM_POWER_STATUS
	ACLineStatus		db ?
	BatteryFlag		db ?
	BatteryLifePercent	db ?
	Reserved1		db ?
	BatteryLifeTime 	dd ?
	BatteryFullLifeTime	dd ?
ends

procdesc GetSystemPowerStatus :dword
procdesc SetSystemPowerState :dword, :dword

;
; Very Large Memory API Subset
;

procdesc VirtualAllocVlm :dword, :dword, :dword, :dword, :dword
procdesc VirtualFreeVlm :dword, :dword, :dword, :dword
procdesc VirtualProtectVlm :dword, :dword, :dword, :dword, :dword
procdesc VirtualQueryVlm :dword, :dword, :dword, :dword
procdesc ReadProcessMemoryVlm :dword, :dword, :dword, :dword, :dword
procdesc WriteProcessMemoryVlm :dword, :dword, :dword, :dword, :dword
procdesc ReadFileVlm :dword, :dword, :dword, :dword, :dword
procdesc WriteFileVlm :dword, :dword, :dword, :dword, :dword
procdesc CreateJobObjectA :dword, :dword
procdesc OpenJobObjectA :dword, :dword, :dword
procdesc AssignProcessToJobObject :dword, :dword
procdesc TerminateJobObject :dword, :dword
procdesc QueryInformationJobObject :dword, :dword, :dword, :dword, :dword
procdesc SetInformationJobObject :dword, :dword, :dword, :dword

CreateJobObject 		equ <CreateJobObjectA>
OpenJobObject			equ <OpenJobObjectA>

;
; New Volume Mount Point API.
;

procdesc FindFirstVolumeA :dword, :dword
procdesc FindNextVolumeA :dword, :dword, :dword
procdesc FindVolumeClose :dword
procdesc FindFirstVolumeMountPointA :dword, :dword, :dword
procdesc FindNextVolumeMountPointA :dword, :dword, :dword
procdesc FindVolumeMountPointClose :dword
procdesc SetVolumeMountPointA :dword, :dword
procdesc DeleteVolumeMountPointA :dword
procdesc GetVolumeNameForVolumeMountPointA :dword, :dword, :dword
procdesc GetVolumePathNameA :dword, :dword, :dword

FindFirstVolume 		equ <FindFirstVolumeA>
FindNextVolume			equ <FindNextVolumeA>
FindFirstVolumeMountPoint	equ <FindFirstVolumeMountPointA>
FindNextVolumeMountPoint	equ <FindNextVolumeMountPointA>
SetVolumeMountPoint		equ <SetVolumeMountPointA>
DeleteVolumeMountPoint		equ <DeleteVolumeMountPointA>
GetVolumeNameForVolumeMountPoint equ <GetVolumeNameForVolumeMountPointA>
GetVolumePathName		equ <GetVolumePathNameA>
