;++ BUILD Version: 0002    // Increment this if a change has global effects
;
;Copyright (c) 1989-1998  Microsoft Corporation
;
;Module Name:
;
;    wincon.h
;
;Abstract:
;
;    This module contains the public data structures, data types,
;    and procedures exported by the NT console subsystem.
;
;Created:
;
;    26-Oct-1990
;
;Revision History:
;
;--

struc	COORD
	X			dw ?
	Y			dw ?
ends

struc	SMALL_RECT
	Left			dw ?
	Top			dw ?
	Right			dw ?
	Bottom			dw ?
ends

struc	KEY_EVENT_RECORD
	bKeyDown		dd ?
	wRepeatCount		dw ?
	wVirtualKeyCode 	dw ?
	wVirtualScanCode	dw ?
label	UnicodeChar		byte
	AsciiChar		db ?
	dwControlKeyState	dd ?
ends

;
; ControlKeyState flags
;

RIGHT_ALT_PRESSED		= 00001h ; the right alt key is pressed.
LEFT_ALT_PRESSED		= 00002h ; the left alt key is pressed.
RIGHT_CTRL_PRESSED		= 00004h ; the right ctrl key is pressed.
LEFT_CTRL_PRESSED		= 00008h ; the left ctrl key is pressed.
SHIFT_PRESSED			= 00010h ; the shift key is pressed.
NUMLOCK_ON			= 00020h ; the numlock light is on.
SCROLLLOCK_ON			= 00040h ; the scrolllock light is on.
CAPSLOCK_ON			= 00080h ; the capslock light is on.
ENHANCED_KEY			= 00100h ; the key is enhanced.
NLS_DBCSCHAR			= 000010000h ; DBCS for JPN: SBCS/DBCS mode.
NLS_ALPHANUMERIC		= 000000000h ; DBCS for JPN: Alphanumeric mode.
NLS_KATAKANA			= 000020000h ; DBCS for JPN: Katakana mode.
NLS_HIRAGANA			= 000040000h ; DBCS for JPN: Hiragana mode.
NLS_ROMAN			= 000400000h ; DBCS for JPN: Roman/Noroman mode.
NLS_IME_CONVERSION		= 000800000h ; DBCS for JPN: IME conversion.
NLS_IME_DISABLE 		= 020000000h ; DBCS for JPN: IME enable/disable.

struc	MOUSE_EVENT_RECORD
	dwMousePosition 	COORD ?
	dwButtonState		dd ?
	dwControlKeyState	dd ?
	dwEventFlags		dd ?
ends

;
; ButtonState flags
;

FROM_LEFT_1ST_BUTTON_PRESSED	= 00001h
RIGHTMOST_BUTTON_PRESSED	= 00002h
FROM_LEFT_2ND_BUTTON_PRESSED	= 00004h
FROM_LEFT_3RD_BUTTON_PRESSED	= 00008h
FROM_LEFT_4TH_BUTTON_PRESSED	= 00010h

;
; EventFlags
;

MOUSE_MOVED			= 00001h
DOUBLE_CLICK			= 00002h
MOUSE_WHEELED			= 00004h


struc	WINDOW_BUFFER_SIZE_RECORD
	dwSize			COORD ?
ends

struc	MENU_EVENT_RECORD
	dwCommandId		dd ?
ends

struc	FOCUS_EVENT_RECORD
	bSetFocus		dd ?
ends

struc	INPUT_RECORD
	EventType		dw ?
label	KeyEvent		KEY_EVENT_RECORD
label	MouseEvent		MOUSE_EVENT_RECORD
label	WindowBufferSizeEvent	WINDOW_BUFFER_SIZE_RECORD
label	MenuEvent		MENU_EVENT_RECORD
	FocusEvent		FOCUS_EVENT_RECORD ?
ends

;
;  EventType flags:
;

KEY_EVENT			= 00001h ; Event contains key event record
MOUSE_EVENT			= 00002h ; Event contains mouse event record
WINDOW_BUFFER_SIZE_EVENT	= 00004h ; Event contains window change event record
MENU_EVENT			= 00008h ; Event contains menu event record
FOCUS_EVENT			= 00010h ; event contains focus change

struc	CHAR_INFO
label	UnicodeChar		byte
	AsciiChar		db ?
	Attributes		dw ?
ends

;
; Attributes flags:
;

FOREGROUND_BLUE 		= 00001h ; text color contains blue.
FOREGROUND_GREEN		= 00002h ; text color contains green.
FOREGROUND_RED			= 00004h ; text color contains red.
FOREGROUND_INTENSITY		= 00008h ; text color is intensified.
BACKGROUND_BLUE 		= 00010h ; background color contains blue.
BACKGROUND_GREEN		= 00020h ; background color contains green.
BACKGROUND_RED			= 00040h ; background color contains red.
BACKGROUND_INTENSITY		= 00080h ; background color is intensified.
COMMON_LVB_LEADING_BYTE 	= 00100h ; Leading Byte of DBCS
COMMON_LVB_TRAILING_BYTE	= 00200h ; Trailing Byte of DBCS
COMMON_LVB_GRID_HORIZONTAL	= 00400h ; DBCS: Grid attribute: top horizontal.
COMMON_LVB_GRID_LVERTICAL	= 00800h ; DBCS: Grid attribute: left vertical.
COMMON_LVB_GRID_RVERTICAL	= 01000h ; DBCS: Grid attribute: right vertical.
COMMON_LVB_REVERSE_VIDEO	= 04000h ; DBCS: Reverse fore/back ground attribute.
COMMON_LVB_UNDERSCORE		= 08000h ; DBCS: Underscore.

COMMON_LVB_SBCSDBCS		= 00300h ; SBCS or DBCS flag.

struc	CONSOLE_SCREEN_BUFFER_INFO
	dwSize			COORD ?
	dwCursorPosition	COORD ?
	wAttributes		dw ?
	srWindow		SMALL_RECT ?
	dwMaximumWindowSize	COORD ?
ends

struc	CONSOLE_CURSOR_INFO
	dwSize			dd ?
	bVisible		dd ?
ends

;
; typedef for ctrl-c handler routines
;

CTRL_C_EVENT			= 0
CTRL_BREAK_EVENT		= 1
CTRL_CLOSE_EVENT		= 2
; 3 is reserved!
; 4 is reserved!
CTRL_LOGOFF_EVENT		= 5
CTRL_SHUTDOWN_EVENT		= 6

;
;  Input Mode flags:
;

ENABLE_PROCESSED_INPUT		= 00001h
ENABLE_LINE_INPUT		= 00002h
ENABLE_ECHO_INPUT		= 00004h
ENABLE_WINDOW_INPUT		= 00008h
ENABLE_MOUSE_INPUT		= 00010h

;
; Output Mode flags:
;

ENABLE_PROCESSED_OUTPUT 	= 00001h
ENABLE_WRAP_AT_EOL_OUTPUT	= 00002h

;
; direct API definitions.
;

procdesc PeekConsoleInputA :dword, :dword, :dword, :dword
procdesc ReadConsoleInputA :dword, :dword, :dword, :dword
procdesc WriteConsoleInputA :dword, :dword, :dword, :dword
procdesc ReadConsoleOutputA :dword, :dword, :dword, :dword, :dword
procdesc WriteConsoleOutputA :dword, :dword, :dword, :dword, :dword
procdesc ReadConsoleOutputCharacterA :dword, :dword, :dword, :dword, :dword
procdesc ReadConsoleOutputAttribute :dword, :dword, :dword, :dword, :dword
procdesc WriteConsoleOutputCharacterA :dword, :dword, :dword, :dword, :dword
procdesc WriteConsoleOutputAttribute :dword, :dword, :dword, :dword, :dword
procdesc FillConsoleOutputCharacterA :dword, :dword, :dword, :dword, :dword
procdesc FillConsoleOutputAttribute :dword, :dword, :dword, :dword, :dword
procdesc GetConsoleMode :dword, :dword
procdesc GetNumberOfConsoleInputEvents :dword, :dword
procdesc GetConsoleScreenBufferInfo :dword, :dword
procdesc GetLargestConsoleWindowSize :dword
procdesc GetConsoleCursorInfo :dword, :dword
procdesc GetNumberOfConsoleMouseButtons :dword
procdesc SetConsoleMode :dword, :dword
procdesc SetConsoleActiveScreenBuffer :dword
procdesc FlushConsoleInputBuffer :dword
procdesc SetConsoleScreenBufferSize :dword, :dword
procdesc SetConsoleCursorPosition :dword, :dword
procdesc SetConsoleCursorInfo :dword, :dword
procdesc ScrollConsoleScreenBufferA :dword, :dword, :dword, :dword, :dword
procdesc SetConsoleWindowInfo :dword, :dword, :dword
procdesc SetConsoleTextAttribute :dword, :dword
procdesc SetConsoleCtrlHandler :dword, :dword
procdesc GenerateConsoleCtrlEvent :dword, :dword
procdesc AllocConsole
procdesc FreeConsole
procdesc GetConsoleTitleA :dword, :dword
procdesc SetConsoleTitleA :dword
procdesc ReadConsoleA :dword, :dword, :dword, :dword, :dword
procdesc WriteConsoleA :dword, :dword, :dword, :dword, :dword

PeekConsoleInput		equ <PeekConsoleInputA>
ReadConsoleInput		equ <ReadConsoleInputA>
WriteConsoleInput		equ <WriteConsoleInputA>
ReadConsoleOutput		equ <ReadConsoleOutputA>
WriteConsoleOutput		equ <WriteConsoleOutputA>
ReadConsoleOutputCharacter	equ <ReadConsoleOutputCharacterA>
WriteConsoleOutputCharacter	equ <WriteConsoleOutputCharacterA>
FillConsoleOutputCharacter	equ <FillConsoleOutputCharacterA>
ScrollConsoleScreenBuffer	equ <ScrollConsoleScreenBufferA>
GetConsoleTitle 		equ <GetConsoleTitleA>
SetConsoleTitle 		equ <SetConsoleTitleA>
ReadConsole			equ <ReadConsoleA>
WriteConsole			equ <WriteConsoleA>

CONSOLE_TEXTMODE_BUFFER 	= 1

procdesc CreateConsoleScreenBuffer :dword, :dword, :dword, :dword, :dword
procdesc GetConsoleCP
procdesc SetConsoleCP :dword
procdesc GetConsoleOutputCP
procdesc SetConsoleOutputCP :dword
