;***********************************************************************
;*									 *
;*   winerror.h --  error code definitions for the Win32 API functions	 *
;*									 *
;*   Copyright (c) 1991-1998, Microsoft Corp. All rights reserved.	 *
;*									 *
;***********************************************************************

;
;  Values are 32 bit values layed out as follows:
;
;   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;  +---+-+-+-----------------------+-------------------------------+
;  |Sev|C|R|	 Facility	   |		   Code 	   |
;  +---+-+-+-----------------------+-------------------------------+
;
;  where
;
;      Sev - is the severity code
;
;	   00 - Success
;	   01 - Informational
;	   10 - Warning
;	   11 - Error
;
;      C - is the Customer code flag
;
;      R - is a reserved bit
;
;      Facility - is the facility code
;
;      Code - is the facility's status code
;

FACILITY_WINDOWS		= 8
FACILITY_STORAGE		= 3
FACILITY_SSPI			= 9
FACILITY_SCARD			= 16
FACILITY_SETUPAPI		= 15
FACILITY_RPC			= 1
FACILITY_WIN32			= 7
FACILITY_CONTROL		= 10
FACILITY_NULL			= 0
FACILITY_MSMQ			= 14
FACILITY_MEDIASERVER		= 13
FACILITY_INTERNET		= 12
FACILITY_ITF			= 4
FACILITY_DISPATCH		= 2
FACILITY_CERT			= 11
ERROR_SUCCESS			= 0
NO_ERROR			= 0						    ; dderror
ERROR_INVALID_FUNCTION		= 1    ; dderror
ERROR_FILE_NOT_FOUND		= 2
ERROR_PATH_NOT_FOUND		= 3
ERROR_TOO_MANY_OPEN_FILES	= 4
ERROR_ACCESS_DENIED		= 5
ERROR_INVALID_HANDLE		= 6
ERROR_ARENA_TRASHED		= 7
ERROR_NOT_ENOUGH_MEMORY 	= 8    ; dderror
ERROR_INVALID_BLOCK		= 9
ERROR_BAD_ENVIRONMENT		= 10
ERROR_BAD_FORMAT		= 11
ERROR_INVALID_ACCESS		= 12
ERROR_INVALID_DATA		= 13
ERROR_OUTOFMEMORY		= 14
ERROR_INVALID_DRIVE		= 15
ERROR_CURRENT_DIRECTORY 	= 16
ERROR_NOT_SAME_DEVICE		= 17
ERROR_NO_MORE_FILES		= 18
ERROR_WRITE_PROTECT		= 19
ERROR_BAD_UNIT			= 20
ERROR_NOT_READY 		= 21
ERROR_BAD_COMMAND		= 22
ERROR_CRC			= 23
ERROR_BAD_LENGTH		= 24
ERROR_SEEK			= 25
ERROR_NOT_DOS_DISK		= 26
ERROR_SECTOR_NOT_FOUND		= 27
ERROR_OUT_OF_PAPER		= 28
ERROR_WRITE_FAULT		= 29
ERROR_READ_FAULT		= 30
ERROR_GEN_FAILURE		= 31
ERROR_SHARING_VIOLATION 	= 32
ERROR_LOCK_VIOLATION		= 33
ERROR_WRONG_DISK		= 34
ERROR_SHARING_BUFFER_EXCEEDED	= 36
ERROR_HANDLE_EOF		= 38
ERROR_HANDLE_DISK_FULL		= 39
ERROR_NOT_SUPPORTED		= 50
ERROR_REM_NOT_LIST		= 51
ERROR_DUP_NAME			= 52
ERROR_BAD_NETPATH		= 53
ERROR_NETWORK_BUSY		= 54
ERROR_DEV_NOT_EXIST		= 55	; dderror
ERROR_TOO_MANY_CMDS		= 56
ERROR_ADAP_HDW_ERR		= 57
ERROR_BAD_NET_RESP		= 58
ERROR_UNEXP_NET_ERR		= 59
ERROR_BAD_REM_ADAP		= 60
ERROR_PRINTQ_FULL		= 61
ERROR_NO_SPOOL_SPACE		= 62
ERROR_PRINT_CANCELLED		= 63
ERROR_NETNAME_DELETED		= 64
ERROR_NETWORK_ACCESS_DENIED	= 65
ERROR_BAD_DEV_TYPE		= 66
ERROR_BAD_NET_NAME		= 67
ERROR_TOO_MANY_NAMES		= 68
ERROR_TOO_MANY_SESS		= 69
ERROR_SHARING_PAUSED		= 70
ERROR_REQ_NOT_ACCEP		= 71
ERROR_REDIR_PAUSED		= 72
ERROR_FILE_EXISTS		= 80
ERROR_CANNOT_MAKE		= 82
ERROR_FAIL_I24			= 83
ERROR_OUT_OF_STRUCTURES 	= 84
ERROR_ALREADY_ASSIGNED		= 85
ERROR_INVALID_PASSWORD		= 86
ERROR_INVALID_PARAMETER 	= 87	; dderror
ERROR_NET_WRITE_FAULT		= 88
ERROR_NO_PROC_SLOTS		= 89
ERROR_TOO_MANY_SEMAPHORES	= 100
ERROR_EXCL_SEM_ALREADY_OWNED	= 101
ERROR_SEM_IS_SET		= 102
ERROR_TOO_MANY_SEM_REQUESTS	= 103
ERROR_INVALID_AT_INTERRUPT_TIME = 104
ERROR_SEM_OWNER_DIED		= 105
ERROR_SEM_USER_LIMIT		= 106
ERROR_DISK_CHANGE		= 107
ERROR_DRIVE_LOCKED		= 108
ERROR_BROKEN_PIPE		= 109
ERROR_OPEN_FAILED		= 110
ERROR_BUFFER_OVERFLOW		= 111
ERROR_DISK_FULL 		= 112
ERROR_NO_MORE_SEARCH_HANDLES	= 113
ERROR_INVALID_TARGET_HANDLE	= 114
ERROR_INVALID_CATEGORY		= 117
ERROR_INVALID_VERIFY_SWITCH	= 118
ERROR_BAD_DRIVER_LEVEL		= 119
ERROR_CALL_NOT_IMPLEMENTED	= 120
ERROR_SEM_TIMEOUT		= 121
ERROR_INSUFFICIENT_BUFFER	= 122	 ; dderror
ERROR_INVALID_NAME		= 123	 ; dderror
ERROR_INVALID_LEVEL		= 124
ERROR_NO_VOLUME_LABEL		= 125
ERROR_MOD_NOT_FOUND		= 126
ERROR_PROC_NOT_FOUND		= 127
ERROR_WAIT_NO_CHILDREN		= 128
ERROR_CHILD_NOT_COMPLETE	= 129
ERROR_DIRECT_ACCESS_HANDLE	= 130
ERROR_NEGATIVE_SEEK		= 131
ERROR_SEEK_ON_DEVICE		= 132
ERROR_IS_JOIN_TARGET		= 133
ERROR_IS_JOINED 		= 134
ERROR_IS_SUBSTED		= 135
ERROR_NOT_JOINED		= 136
ERROR_NOT_SUBSTED		= 137
ERROR_JOIN_TO_JOIN		= 138
ERROR_SUBST_TO_SUBST		= 139
ERROR_JOIN_TO_SUBST		= 140
ERROR_SUBST_TO_JOIN		= 141
ERROR_BUSY_DRIVE		= 142
ERROR_SAME_DRIVE		= 143
ERROR_DIR_NOT_ROOT		= 144
ERROR_DIR_NOT_EMPTY		= 145
ERROR_IS_SUBST_PATH		= 146
ERROR_IS_JOIN_PATH		= 147
ERROR_PATH_BUSY 		= 148
ERROR_IS_SUBST_TARGET		= 149
ERROR_SYSTEM_TRACE		= 150
ERROR_INVALID_EVENT_COUNT	= 151
ERROR_TOO_MANY_MUXWAITERS	= 152
ERROR_INVALID_LIST_FORMAT	= 153
ERROR_LABEL_TOO_LONG		= 154
ERROR_TOO_MANY_TCBS		= 155
ERROR_SIGNAL_REFUSED		= 156
ERROR_DISCARDED 		= 157
ERROR_NOT_LOCKED		= 158
ERROR_BAD_THREADID_ADDR 	= 159
ERROR_BAD_ARGUMENTS		= 160
ERROR_BAD_PATHNAME		= 161
ERROR_SIGNAL_PENDING		= 162
ERROR_MAX_THRDS_REACHED 	= 164
ERROR_LOCK_FAILED		= 167
ERROR_BUSY			= 170
ERROR_CANCEL_VIOLATION		= 173
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174
ERROR_INVALID_SEGMENT_NUMBER	= 180
ERROR_INVALID_ORDINAL		= 182
ERROR_ALREADY_EXISTS		= 183
ERROR_INVALID_FLAG_NUMBER	= 186
ERROR_SEM_NOT_FOUND		= 187
ERROR_INVALID_STARTING_CODESEG	= 188
ERROR_INVALID_STACKSEG		= 189
ERROR_INVALID_MODULETYPE	= 190
ERROR_INVALID_EXE_SIGNATURE	= 191
ERROR_EXE_MARKED_INVALID	= 192
ERROR_BAD_EXE_FORMAT		= 193
ERROR_ITERATED_DATA_EXCEEDS_64k = 194
ERROR_INVALID_MINALLOCSIZE	= 195
ERROR_DYNLINK_FROM_INVALID_RING = 196
ERROR_IOPL_NOT_ENABLED		= 197
ERROR_INVALID_SEGDPL		= 198
ERROR_AUTODATASEG_EXCEEDS_64k	= 199
ERROR_RING2SEG_MUST_BE_MOVABLE	= 200
ERROR_RELOC_CHAIN_XEEDS_SEGLIM	= 201
ERROR_INFLOOP_IN_RELOC_CHAIN	= 202
ERROR_ENVVAR_NOT_FOUND		= 203
ERROR_NO_SIGNAL_SENT		= 205
ERROR_FILENAME_EXCED_RANGE	= 206
ERROR_RING2_STACK_IN_USE	= 207
ERROR_META_EXPANSION_TOO_LONG	= 208
ERROR_INVALID_SIGNAL_NUMBER	= 209
ERROR_THREAD_1_INACTIVE 	= 210
ERROR_LOCKED			= 212
ERROR_TOO_MANY_MODULES		= 214
ERROR_NESTING_NOT_ALLOWED	= 215
ERROR_EXE_MACHINE_TYPE_MISMATCH = 216
ERROR_BAD_PIPE			= 230
ERROR_PIPE_BUSY 		= 231
ERROR_NO_DATA			= 232
ERROR_PIPE_NOT_CONNECTED	= 233
ERROR_MORE_DATA 		= 234	 ; dderror
ERROR_VC_DISCONNECTED		= 240
ERROR_INVALID_EA_NAME		= 254
ERROR_EA_LIST_INCONSISTENT	= 255
WAIT_TIMEOUT			= 258
ERROR_NO_MORE_ITEMS		= 259
ERROR_CANNOT_COPY		= 266
ERROR_DIRECTORY 		= 267
ERROR_EAS_DIDNT_FIT		= 275
ERROR_EA_FILE_CORRUPT		= 276
ERROR_EA_TABLE_FULL		= 277
ERROR_INVALID_EA_HANDLE 	= 278
ERROR_EAS_NOT_SUPPORTED 	= 282
ERROR_NOT_OWNER 		= 288
ERROR_TOO_MANY_POSTS		= 298
ERROR_PARTIAL_COPY		= 299
ERROR_OPLOCK_NOT_GRANTED	= 300
ERROR_INVALID_OPLOCK_PROTOCOL	= 301
ERROR_MR_MID_NOT_FOUND		= 317
ERROR_INVALID_ADDRESS		= 487
ERROR_ARITHMETIC_OVERFLOW	= 534
ERROR_PIPE_CONNECTED		= 535
ERROR_PIPE_LISTENING		= 536
ERROR_EA_ACCESS_DENIED		= 994
ERROR_OPERATION_ABORTED 	= 995
ERROR_IO_INCOMPLETE		= 996
ERROR_IO_PENDING		= 997	 ; dderror
ERROR_NOACCESS			= 998
ERROR_SWAPERROR 		= 999
ERROR_STACK_OVERFLOW		= 1001
ERROR_INVALID_MESSAGE		= 1002
ERROR_CAN_NOT_COMPLETE		= 1003
ERROR_INVALID_FLAGS		= 1004
ERROR_UNRECOGNIZED_VOLUME	= 1005
ERROR_FILE_INVALID		= 1006
ERROR_FULLSCREEN_MODE		= 1007
ERROR_NO_TOKEN			= 1008
ERROR_BADDB			= 1009
ERROR_BADKEY			= 1010
ERROR_CANTOPEN			= 1011
ERROR_CANTREAD			= 1012
ERROR_CANTWRITE 		= 1013
ERROR_REGISTRY_RECOVERED	= 1014
ERROR_REGISTRY_CORRUPT		= 1015
ERROR_REGISTRY_IO_FAILED	= 1016
ERROR_NOT_REGISTRY_FILE 	= 1017
ERROR_KEY_DELETED		= 1018
ERROR_NO_LOG_SPACE		= 1019
ERROR_KEY_HAS_CHILDREN		= 1020
ERROR_CHILD_MUST_BE_VOLATILE	= 1021
ERROR_NOTIFY_ENUM_DIR		= 1022
ERROR_DEPENDENT_SERVICES_RUNNING = 1051
ERROR_INVALID_SERVICE_CONTROL	= 1052
ERROR_SERVICE_REQUEST_TIMEOUT	= 1053
ERROR_SERVICE_NO_THREAD 	= 1054
ERROR_SERVICE_DATABASE_LOCKED	= 1055
ERROR_SERVICE_ALREADY_RUNNING	= 1056
ERROR_INVALID_SERVICE_ACCOUNT	= 1057
ERROR_SERVICE_DISABLED		= 1058
ERROR_CIRCULAR_DEPENDENCY	= 1059
ERROR_SERVICE_DOES_NOT_EXIST	= 1060
ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061
ERROR_SERVICE_NOT_ACTIVE	= 1062
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = 1063
ERROR_EXCEPTION_IN_SERVICE	= 1064
ERROR_DATABASE_DOES_NOT_EXIST	= 1065
ERROR_SERVICE_SPECIFIC_ERROR	= 1066
ERROR_PROCESS_ABORTED		= 1067
ERROR_SERVICE_DEPENDENCY_FAIL	= 1068
ERROR_SERVICE_LOGON_FAILED	= 1069
ERROR_SERVICE_START_HANG	= 1070
ERROR_INVALID_SERVICE_LOCK	= 1071
ERROR_SERVICE_MARKED_FOR_DELETE = 1072
ERROR_SERVICE_EXISTS		= 1073
ERROR_ALREADY_RUNNING_LKG	= 1074
ERROR_SERVICE_DEPENDENCY_DELETED = 1075
ERROR_BOOT_ALREADY_ACCEPTED	= 1076
ERROR_SERVICE_NEVER_STARTED	= 1077
ERROR_DUPLICATE_SERVICE_NAME	= 1078
ERROR_DIFFERENT_SERVICE_ACCOUNT = 1079
ERROR_CANNOT_DETECT_DRIVER_FAILURE = 1080
ERROR_CANNOT_DETECT_PROCESS_ABORT = 1081
ERROR_NO_RECOVERY_PROGRAM	= 1082
ERROR_SERVICE_NOT_IN_EXE	= 1083
ERROR_END_OF_MEDIA		= 1100
ERROR_FILEMARK_DETECTED 	= 1101
ERROR_BEGINNING_OF_MEDIA	= 1102
ERROR_SETMARK_DETECTED		= 1103
ERROR_NO_DATA_DETECTED		= 1104
ERROR_PARTITION_FAILURE 	= 1105
ERROR_INVALID_BLOCK_LENGTH	= 1106
ERROR_DEVICE_NOT_PARTITIONED	= 1107
ERROR_UNABLE_TO_LOCK_MEDIA	= 1108
ERROR_UNABLE_TO_UNLOAD_MEDIA	= 1109
ERROR_MEDIA_CHANGED		= 1110
ERROR_BUS_RESET 		= 1111
ERROR_NO_MEDIA_IN_DRIVE 	= 1112
ERROR_NO_UNICODE_TRANSLATION	= 1113
ERROR_DLL_INIT_FAILED		= 1114
ERROR_SHUTDOWN_IN_PROGRESS	= 1115
ERROR_NO_SHUTDOWN_IN_PROGRESS	= 1116
ERROR_IO_DEVICE 		= 1117
ERROR_SERIAL_NO_DEVICE		= 1118
ERROR_IRQ_BUSY			= 1119
ERROR_MORE_WRITES		= 1120
ERROR_COUNTER_TIMEOUT		= 1121
ERROR_FLOPPY_ID_MARK_NOT_FOUND	= 1122
ERROR_FLOPPY_WRONG_CYLINDER	= 1123
ERROR_FLOPPY_UNKNOWN_ERROR	= 1124
ERROR_FLOPPY_BAD_REGISTERS	= 1125
ERROR_DISK_RECALIBRATE_FAILED	= 1126
ERROR_DISK_OPERATION_FAILED	= 1127
ERROR_DISK_RESET_FAILED 	= 1128
ERROR_EOM_OVERFLOW		= 1129
ERROR_NOT_ENOUGH_SERVER_MEMORY	= 1130
ERROR_POSSIBLE_DEADLOCK 	= 1131
ERROR_MAPPED_ALIGNMENT		= 1132
ERROR_SET_POWER_STATE_VETOED	= 1140
ERROR_SET_POWER_STATE_FAILED	= 1141
ERROR_TOO_MANY_LINKS		= 1142
ERROR_OLD_WIN_VERSION		= 1150
ERROR_APP_WRONG_OS		= 1151
ERROR_SINGLE_INSTANCE_APP	= 1152
ERROR_RMODE_APP 		= 1153
ERROR_INVALID_DLL		= 1154
ERROR_NO_ASSOCIATION		= 1155
ERROR_DDE_FAIL			= 1156
ERROR_DLL_NOT_FOUND		= 1157
ERROR_NO_MORE_USER_HANDLES	= 1158
ERROR_MESSAGE_SYNC_ONLY 	= 1159
ERROR_SOURCE_ELEMENT_EMPTY	= 1160
ERROR_DESTINATION_ELEMENT_FULL	= 1161
ERROR_ILLEGAL_ELEMENT_ADDRESS	= 1162
ERROR_MAGAZINE_NOT_PRESENT	= 1163
ERROR_DEVICE_REINITIALIZATION_NEEDED = 1164    ; dderror
ERROR_DEVICE_REQUIRES_CLEANING	= 1165
ERROR_DEVICE_DOOR_OPEN		= 1166
ERROR_DEVICE_NOT_CONNECTED	= 1167
ERROR_NOT_FOUND 		= 1168
ERROR_NO_MATCH			= 1169
ERROR_SET_NOT_FOUND		= 1170
ERROR_POINT_NOT_FOUND		= 1171
ERROR_NO_TRACKING_SERVICE	= 1172
ERROR_NO_VOLUME_ID		= 1173
ERROR_INVALID_VLM_OPERATION	= 1174
ERROR_UNABLE_TO_REMOVE_REPLACED = 1175
ERROR_UNABLE_TO_MOVE_REPLACEMENT = 1176
ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 = 1177
ERROR_JOURNAL_DELETE_IN_PROGRESS = 1178
ERROR_JOURNAL_NOT_ACTIVE	= 1179
ERROR_POTENTIAL_FILE_FOUND	= 1180
ERROR_CONNECTED_OTHER_PASSWORD	= 2108
ERROR_BAD_USERNAME		= 2202
ERROR_NOT_CONNECTED		= 2250
ERROR_OPEN_FILES		= 2401
ERROR_ACTIVE_CONNECTIONS	= 2402
ERROR_DEVICE_IN_USE		= 2404
ERROR_BAD_DEVICE		= 1200
ERROR_CONNECTION_UNAVAIL	= 1201
ERROR_DEVICE_ALREADY_REMEMBERED = 1202
ERROR_NO_NET_OR_BAD_PATH	= 1203
ERROR_BAD_PROVIDER		= 1204
ERROR_CANNOT_OPEN_PROFILE	= 1205
ERROR_BAD_PROFILE		= 1206
ERROR_NOT_CONTAINER		= 1207
ERROR_EXTENDED_ERROR		= 1208
ERROR_INVALID_GROUPNAME 	= 1209
ERROR_INVALID_COMPUTERNAME	= 1210
ERROR_INVALID_EVENTNAME 	= 1211
ERROR_INVALID_DOMAINNAME	= 1212
ERROR_INVALID_SERVICENAME	= 1213
ERROR_INVALID_NETNAME		= 1214
ERROR_INVALID_SHARENAME 	= 1215
ERROR_INVALID_PASSWORDNAME	= 1216
ERROR_INVALID_MESSAGENAME	= 1217
ERROR_INVALID_MESSAGEDEST	= 1218
ERROR_SESSION_CREDENTIAL_CONFLICT = 1219
ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220
ERROR_DUP_DOMAINNAME		= 1221
ERROR_NO_NETWORK		= 1222
ERROR_CANCELLED 		= 1223
ERROR_USER_MAPPED_FILE		= 1224
ERROR_CONNECTION_REFUSED	= 1225
ERROR_GRACEFUL_DISCONNECT	= 1226
ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227
ERROR_ADDRESS_NOT_ASSOCIATED	= 1228
ERROR_CONNECTION_INVALID	= 1229
ERROR_CONNECTION_ACTIVE 	= 1230
ERROR_NETWORK_UNREACHABLE	= 1231
ERROR_HOST_UNREACHABLE		= 1232
ERROR_PROTOCOL_UNREACHABLE	= 1233
ERROR_PORT_UNREACHABLE		= 1234
ERROR_REQUEST_ABORTED		= 1235
ERROR_CONNECTION_ABORTED	= 1236
ERROR_RETRY			= 1237
ERROR_CONNECTION_COUNT_LIMIT	= 1238
ERROR_LOGIN_TIME_RESTRICTION	= 1239
ERROR_LOGIN_WKSTA_RESTRICTION	= 1240
ERROR_INCORRECT_ADDRESS 	= 1241
ERROR_ALREADY_REGISTERED	= 1242
ERROR_SERVICE_NOT_FOUND 	= 1243
ERROR_NOT_AUTHENTICATED 	= 1244
ERROR_NOT_LOGGED_ON		= 1245
ERROR_CONTINUE			= 1246
ERROR_ALREADY_INITIALIZED	= 1247
ERROR_NO_MORE_DEVICES		= 1248	  ; dderror
ERROR_NO_SUCH_SITE		= 1249
ERROR_DOMAIN_CONTROLLER_EXISTS	= 1250
ERROR_NOT_ALL_ASSIGNED		= 1300
ERROR_SOME_NOT_MAPPED		= 1301
ERROR_NO_QUOTAS_FOR_ACCOUNT	= 1302
ERROR_LOCAL_USER_SESSION_KEY	= 1303
ERROR_NULL_LM_PASSWORD		= 1304
ERROR_UNKNOWN_REVISION		= 1305
ERROR_REVISION_MISMATCH 	= 1306
ERROR_INVALID_OWNER		= 1307
ERROR_INVALID_PRIMARY_GROUP	= 1308
ERROR_NO_IMPERSONATION_TOKEN	= 1309
ERROR_CANT_DISABLE_MANDATORY	= 1310
ERROR_NO_LOGON_SERVERS		= 1311
ERROR_NO_SUCH_LOGON_SESSION	= 1312
ERROR_NO_SUCH_PRIVILEGE 	= 1313
ERROR_PRIVILEGE_NOT_HELD	= 1314
ERROR_INVALID_ACCOUNT_NAME	= 1315
ERROR_USER_EXISTS		= 1316
ERROR_NO_SUCH_USER		= 1317
ERROR_GROUP_EXISTS		= 1318
ERROR_NO_SUCH_GROUP		= 1319
ERROR_MEMBER_IN_GROUP		= 1320
ERROR_MEMBER_NOT_IN_GROUP	= 1321
ERROR_LAST_ADMIN		= 1322
ERROR_WRONG_PASSWORD		= 1323
ERROR_ILL_FORMED_PASSWORD	= 1324
ERROR_PASSWORD_RESTRICTION	= 1325
ERROR_LOGON_FAILURE		= 1326
ERROR_ACCOUNT_RESTRICTION	= 1327
ERROR_INVALID_LOGON_HOURS	= 1328
ERROR_INVALID_WORKSTATION	= 1329
ERROR_PASSWORD_EXPIRED		= 1330
ERROR_ACCOUNT_DISABLED		= 1331
ERROR_NONE_MAPPED		= 1332
ERROR_TOO_MANY_LUIDS_REQUESTED	= 1333
ERROR_LUIDS_EXHAUSTED		= 1334
ERROR_INVALID_SUB_AUTHORITY	= 1335
ERROR_INVALID_ACL		= 1336
ERROR_INVALID_SID		= 1337
ERROR_INVALID_SECURITY_DESCR	= 1338
ERROR_BAD_INHERITANCE_ACL	= 1340
ERROR_SERVER_DISABLED		= 1341
ERROR_SERVER_NOT_DISABLED	= 1342
ERROR_INVALID_ID_AUTHORITY	= 1343
ERROR_ALLOTTED_SPACE_EXCEEDED	= 1344
ERROR_INVALID_GROUP_ATTRIBUTES	= 1345
ERROR_BAD_IMPERSONATION_LEVEL	= 1346
ERROR_CANT_OPEN_ANONYMOUS	= 1347
ERROR_BAD_VALIDATION_CLASS	= 1348
ERROR_BAD_TOKEN_TYPE		= 1349
ERROR_NO_SECURITY_ON_OBJECT	= 1350
ERROR_CANT_ACCESS_DOMAIN_INFO	= 1351
ERROR_INVALID_SERVER_STATE	= 1352
ERROR_INVALID_DOMAIN_STATE	= 1353
ERROR_INVALID_DOMAIN_ROLE	= 1354
ERROR_NO_SUCH_DOMAIN		= 1355
ERROR_DOMAIN_EXISTS		= 1356
ERROR_DOMAIN_LIMIT_EXCEEDED	= 1357
ERROR_INTERNAL_DB_CORRUPTION	= 1358
ERROR_INTERNAL_ERROR		= 1359
ERROR_GENERIC_NOT_MAPPED	= 1360
ERROR_BAD_DESCRIPTOR_FORMAT	= 1361
ERROR_NOT_LOGON_PROCESS 	= 1362
ERROR_LOGON_SESSION_EXISTS	= 1363
ERROR_NO_SUCH_PACKAGE		= 1364
ERROR_BAD_LOGON_SESSION_STATE	= 1365
ERROR_LOGON_SESSION_COLLISION	= 1366
ERROR_INVALID_LOGON_TYPE	= 1367
ERROR_CANNOT_IMPERSONATE	= 1368
ERROR_RXACT_INVALID_STATE	= 1369
ERROR_RXACT_COMMIT_FAILURE	= 1370
ERROR_SPECIAL_ACCOUNT		= 1371
ERROR_SPECIAL_GROUP		= 1372
ERROR_SPECIAL_USER		= 1373
ERROR_MEMBERS_PRIMARY_GROUP	= 1374
ERROR_TOKEN_ALREADY_IN_USE	= 1375
ERROR_NO_SUCH_ALIAS		= 1376
ERROR_MEMBER_NOT_IN_ALIAS	= 1377
ERROR_MEMBER_IN_ALIAS		= 1378
ERROR_ALIAS_EXISTS		= 1379
ERROR_LOGON_NOT_GRANTED 	= 1380
ERROR_TOO_MANY_SECRETS		= 1381
ERROR_SECRET_TOO_LONG		= 1382
ERROR_INTERNAL_DB_ERROR 	= 1383
ERROR_TOO_MANY_CONTEXT_IDS	= 1384
ERROR_LOGON_TYPE_NOT_GRANTED	= 1385
ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386
ERROR_NO_SUCH_MEMBER		= 1387
ERROR_INVALID_MEMBER		= 1388
ERROR_TOO_MANY_SIDS		= 1389
ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390
ERROR_NO_INHERITANCE		= 1391
ERROR_FILE_CORRUPT		= 1392
ERROR_DISK_CORRUPT		= 1393
ERROR_NO_USER_SESSION_KEY	= 1394
ERROR_LICENSE_QUOTA_EXCEEDED	= 1395
ERROR_WRONG_TARGET_NAME 	= 1396
ERROR_MUTUAL_AUTH_FAILED	= 1397
ERROR_TIME_SKEW 		= 1398
ERROR_INVALID_WINDOW_HANDLE	= 1400
ERROR_INVALID_MENU_HANDLE	= 1401
ERROR_INVALID_CURSOR_HANDLE	= 1402
ERROR_INVALID_ACCEL_HANDLE	= 1403
ERROR_INVALID_HOOK_HANDLE	= 1404
ERROR_INVALID_DWP_HANDLE	= 1405
ERROR_TLW_WITH_WSCHILD		= 1406
ERROR_CANNOT_FIND_WND_CLASS	= 1407
ERROR_WINDOW_OF_OTHER_THREAD	= 1408
ERROR_HOTKEY_ALREADY_REGISTERED = 1409
ERROR_CLASS_ALREADY_EXISTS	= 1410
ERROR_CLASS_DOES_NOT_EXIST	= 1411
ERROR_CLASS_HAS_WINDOWS 	= 1412
ERROR_INVALID_INDEX		= 1413
ERROR_INVALID_ICON_HANDLE	= 1414
ERROR_PRIVATE_DIALOG_INDEX	= 1415
ERROR_LISTBOX_ID_NOT_FOUND	= 1416
ERROR_NO_WILDCARD_CHARACTERS	= 1417
ERROR_CLIPBOARD_NOT_OPEN	= 1418
ERROR_HOTKEY_NOT_REGISTERED	= 1419
ERROR_WINDOW_NOT_DIALOG 	= 1420
ERROR_CONTROL_ID_NOT_FOUND	= 1421
ERROR_INVALID_COMBOBOX_MESSAGE	= 1422
ERROR_WINDOW_NOT_COMBOBOX	= 1423
ERROR_INVALID_EDIT_HEIGHT	= 1424
ERROR_DC_NOT_FOUND		= 1425
ERROR_INVALID_HOOK_FILTER	= 1426
ERROR_INVALID_FILTER_PROC	= 1427
ERROR_HOOK_NEEDS_HMOD		= 1428
ERROR_GLOBAL_ONLY_HOOK		= 1429
ERROR_JOURNAL_HOOK_SET		= 1430
ERROR_HOOK_NOT_INSTALLED	= 1431
ERROR_INVALID_LB_MESSAGE	= 1432
ERROR_SETCOUNT_ON_BAD_LB	= 1433
ERROR_LB_WITHOUT_TABSTOPS	= 1434
ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435
ERROR_CHILD_WINDOW_MENU 	= 1436
ERROR_NO_SYSTEM_MENU		= 1437
ERROR_INVALID_MSGBOX_STYLE	= 1438
ERROR_INVALID_SPI_VALUE 	= 1439
ERROR_SCREEN_ALREADY_LOCKED	= 1440
ERROR_HWNDS_HAVE_DIFF_PARENT	= 1441
ERROR_NOT_CHILD_WINDOW		= 1442
ERROR_INVALID_GW_COMMAND	= 1443
ERROR_INVALID_THREAD_ID 	= 1444
ERROR_NON_MDICHILD_WINDOW	= 1445
ERROR_POPUP_ALREADY_ACTIVE	= 1446
ERROR_NO_SCROLLBARS		= 1447
ERROR_INVALID_SCROLLBAR_RANGE	= 1448
ERROR_INVALID_SHOWWIN_COMMAND	= 1449
ERROR_NO_SYSTEM_RESOURCES	= 1450
ERROR_NONPAGED_SYSTEM_RESOURCES = 1451
ERROR_PAGED_SYSTEM_RESOURCES	= 1452
ERROR_WORKING_SET_QUOTA 	= 1453
ERROR_PAGEFILE_QUOTA		= 1454
ERROR_COMMITMENT_LIMIT		= 1455
ERROR_MENU_ITEM_NOT_FOUND	= 1456
ERROR_INVALID_KEYBOARD_HANDLE	= 1457
ERROR_HOOK_TYPE_NOT_ALLOWED	= 1458
ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459
ERROR_TIMEOUT			= 1460
ERROR_INVALID_MONITOR_HANDLE	= 1461
ERROR_EVENTLOG_FILE_CORRUPT	= 1500
ERROR_EVENTLOG_CANT_START	= 1501
ERROR_LOG_FILE_FULL		= 1502
ERROR_EVENTLOG_FILE_CHANGED	= 1503
ERROR_INSTALL_SERVICE		= 1601
ERROR_INSTALL_USEREXIT		= 1602
ERROR_INSTALL_FAILURE		= 1603
ERROR_INSTALL_SUSPEND		= 1604
ERROR_UNKNOWN_PRODUCT		= 1605
ERROR_UNKNOWN_FEATURE		= 1606
ERROR_UNKNOWN_COMPONENT 	= 1607
ERROR_UNKNOWN_PROPERTY		= 1608
ERROR_INVALID_HANDLE_STATE	= 1609
ERROR_BAD_CONFIGURATION 	= 1610
ERROR_INDEX_ABSENT		= 1611
ERROR_INSTALL_SOURCE_ABSENT	= 1612
ERROR_BAD_DATABASE_VERSION	= 1613
ERROR_PRODUCT_UNINSTALLED	= 1614
ERROR_BAD_QUERY_SYNTAX		= 1615
ERROR_INVALID_FIELD		= 1616
ERROR_DEVICE_REMOVED		= 1617
RPC_S_INVALID_STRING_BINDING	= 1700
RPC_S_WRONG_KIND_OF_BINDING	= 1701
RPC_S_INVALID_BINDING		= 1702
RPC_S_PROTSEQ_NOT_SUPPORTED	= 1703
RPC_S_INVALID_RPC_PROTSEQ	= 1704
RPC_S_INVALID_STRING_UUID	= 1705
RPC_S_INVALID_ENDPOINT_FORMAT	= 1706
RPC_S_INVALID_NET_ADDR		= 1707
RPC_S_NO_ENDPOINT_FOUND 	= 1708
RPC_S_INVALID_TIMEOUT		= 1709
RPC_S_OBJECT_NOT_FOUND		= 1710
RPC_S_ALREADY_REGISTERED	= 1711
RPC_S_TYPE_ALREADY_REGISTERED	= 1712
RPC_S_ALREADY_LISTENING 	= 1713
RPC_S_NO_PROTSEQS_REGISTERED	= 1714
RPC_S_NOT_LISTENING		= 1715
RPC_S_UNKNOWN_MGR_TYPE		= 1716
RPC_S_UNKNOWN_IF		= 1717
RPC_S_NO_BINDINGS		= 1718
RPC_S_NO_PROTSEQS		= 1719
RPC_S_CANT_CREATE_ENDPOINT	= 1720
RPC_S_OUT_OF_RESOURCES		= 1721
RPC_S_SERVER_UNAVAILABLE	= 1722
RPC_S_SERVER_TOO_BUSY		= 1723
RPC_S_INVALID_NETWORK_OPTIONS	= 1724
RPC_S_NO_CALL_ACTIVE		= 1725
RPC_S_CALL_FAILED		= 1726
RPC_S_CALL_FAILED_DNE		= 1727
RPC_S_PROTOCOL_ERROR		= 1728
RPC_S_UNSUPPORTED_TRANS_SYN	= 1730
RPC_S_UNSUPPORTED_TYPE		= 1732
RPC_S_INVALID_TAG		= 1733
RPC_S_INVALID_BOUND		= 1734
RPC_S_NO_ENTRY_NAME		= 1735
RPC_S_INVALID_NAME_SYNTAX	= 1736
RPC_S_UNSUPPORTED_NAME_SYNTAX	= 1737
RPC_S_UUID_NO_ADDRESS		= 1739
RPC_S_DUPLICATE_ENDPOINT	= 1740
RPC_S_UNKNOWN_AUTHN_TYPE	= 1741
RPC_S_MAX_CALLS_TOO_SMALL	= 1742
RPC_S_STRING_TOO_LONG		= 1743
RPC_S_PROTSEQ_NOT_FOUND 	= 1744
RPC_S_PROCNUM_OUT_OF_RANGE	= 1745
RPC_S_BINDING_HAS_NO_AUTH	= 1746
RPC_S_UNKNOWN_AUTHN_SERVICE	= 1747
RPC_S_UNKNOWN_AUTHN_LEVEL	= 1748
RPC_S_INVALID_AUTH_IDENTITY	= 1749
RPC_S_UNKNOWN_AUTHZ_SERVICE	= 1750
EPT_S_INVALID_ENTRY		= 1751
EPT_S_CANT_PERFORM_OP		= 1752
EPT_S_NOT_REGISTERED		= 1753
RPC_S_NOTHING_TO_EXPORT 	= 1754
RPC_S_INCOMPLETE_NAME		= 1755
RPC_S_INVALID_VERS_OPTION	= 1756
RPC_S_NO_MORE_MEMBERS		= 1757
RPC_S_NOT_ALL_OBJS_UNEXPORTED	= 1758
RPC_S_INTERFACE_NOT_FOUND	= 1759
RPC_S_ENTRY_ALREADY_EXISTS	= 1760
RPC_S_ENTRY_NOT_FOUND		= 1761
RPC_S_NAME_SERVICE_UNAVAILABLE	= 1762
RPC_S_INVALID_NAF_ID		= 1763
RPC_S_CANNOT_SUPPORT		= 1764
RPC_S_NO_CONTEXT_AVAILABLE	= 1765
RPC_S_INTERNAL_ERROR		= 1766
RPC_S_ZERO_DIVIDE		= 1767
RPC_S_ADDRESS_ERROR		= 1768
RPC_S_FP_DIV_ZERO		= 1769
RPC_S_FP_UNDERFLOW		= 1770
RPC_S_FP_OVERFLOW		= 1771
RPC_X_NO_MORE_ENTRIES		= 1772
RPC_X_SS_CHAR_TRANS_OPEN_FAIL	= 1773
RPC_X_SS_CHAR_TRANS_SHORT_FILE	= 1774
RPC_X_SS_IN_NULL_CONTEXT	= 1775
RPC_X_SS_CONTEXT_DAMAGED	= 1777
RPC_X_SS_HANDLES_MISMATCH	= 1778
RPC_X_SS_CANNOT_GET_CALL_HANDLE = 1779
RPC_X_NULL_REF_POINTER		= 1780
RPC_X_ENUM_VALUE_OUT_OF_RANGE	= 1781
RPC_X_BYTE_COUNT_TOO_SMALL	= 1782
RPC_X_BAD_STUB_DATA		= 1783
ERROR_INVALID_USER_BUFFER	= 1784
ERROR_UNRECOGNIZED_MEDIA	= 1785
ERROR_NO_TRUST_LSA_SECRET	= 1786
ERROR_NO_TRUST_SAM_ACCOUNT	= 1787
ERROR_TRUSTED_DOMAIN_FAILURE	= 1788
ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789
ERROR_TRUST_FAILURE		= 1790
RPC_S_CALL_IN_PROGRESS		= 1791
ERROR_NETLOGON_NOT_STARTED	= 1792
ERROR_ACCOUNT_EXPIRED		= 1793
ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794
ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795
ERROR_UNKNOWN_PORT		= 1796
ERROR_UNKNOWN_PRINTER_DRIVER	= 1797
ERROR_UNKNOWN_PRINTPROCESSOR	= 1798
ERROR_INVALID_SEPARATOR_FILE	= 1799
ERROR_INVALID_PRIORITY		= 1800
ERROR_INVALID_PRINTER_NAME	= 1801
ERROR_PRINTER_ALREADY_EXISTS	= 1802
ERROR_INVALID_PRINTER_COMMAND	= 1803
ERROR_INVALID_DATATYPE		= 1804
ERROR_INVALID_ENVIRONMENT	= 1805
RPC_S_NO_MORE_BINDINGS		= 1806
ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807
ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808
ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809
ERROR_DOMAIN_TRUST_INCONSISTENT = 1810
ERROR_SERVER_HAS_OPEN_HANDLES	= 1811
ERROR_RESOURCE_DATA_NOT_FOUND	= 1812
ERROR_RESOURCE_TYPE_NOT_FOUND	= 1813
ERROR_RESOURCE_NAME_NOT_FOUND	= 1814
ERROR_RESOURCE_LANG_NOT_FOUND	= 1815
ERROR_NOT_ENOUGH_QUOTA		= 1816
RPC_S_NO_INTERFACES		= 1817
RPC_S_CALL_CANCELLED		= 1818
RPC_S_BINDING_INCOMPLETE	= 1819
RPC_S_COMM_FAILURE		= 1820
RPC_S_UNSUPPORTED_AUTHN_LEVEL	= 1821
RPC_S_NO_PRINC_NAME		= 1822
RPC_S_NOT_RPC_ERROR		= 1823
RPC_S_UUID_LOCAL_ONLY		= 1824
RPC_S_SEC_PKG_ERROR		= 1825
RPC_S_NOT_CANCELLED		= 1826
RPC_X_INVALID_ES_ACTION 	= 1827
RPC_X_WRONG_ES_VERSION		= 1828
RPC_X_WRONG_STUB_VERSION	= 1829
RPC_X_INVALID_PIPE_OBJECT	= 1830
RPC_X_WRONG_PIPE_ORDER		= 1831
RPC_X_WRONG_PIPE_VERSION	= 1832
RPC_S_GROUP_MEMBER_NOT_FOUND	= 1898
EPT_S_CANT_CREATE		= 1899
RPC_S_INVALID_OBJECT		= 1900
ERROR_INVALID_TIME		= 1901
ERROR_INVALID_FORM_NAME 	= 1902
ERROR_INVALID_FORM_SIZE 	= 1903
ERROR_ALREADY_WAITING		= 1904
ERROR_PRINTER_DELETED		= 1905
ERROR_INVALID_PRINTER_STATE	= 1906
ERROR_PASSWORD_MUST_CHANGE	= 1907
ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908
ERROR_ACCOUNT_LOCKED_OUT	= 1909
OR_INVALID_OXID 		= 1910
OR_INVALID_OID			= 1911
OR_INVALID_SET			= 1912
RPC_S_SEND_INCOMPLETE		= 1913
RPC_S_INVALID_ASYNC_HANDLE	= 1914
RPC_S_INVALID_ASYNC_CALL	= 1915
RPC_X_PIPE_CLOSED		= 1916
RPC_X_PIPE_DISCIPLINE_ERROR	= 1917
RPC_X_PIPE_EMPTY		= 1918
ERROR_NO_SITENAME		= 1919
ERROR_CANT_ACCESS_FILE		= 1920
ERROR_CANT_RESOLVE_FILENAME	= 1921
ERROR_NO_BROWSER_SERVERS_FOUND	= 6118
ERROR_INVALID_PIXEL_FORMAT	= 2000
ERROR_BAD_DRIVER		= 2001
ERROR_INVALID_WINDOW_STYLE	= 2002
ERROR_METAFILE_NOT_SUPPORTED	= 2003
ERROR_TRANSFORM_NOT_SUPPORTED	= 2004
ERROR_CLIPPING_NOT_SUPPORTED	= 2005
ERROR_INVALID_CMM		= 2010
ERROR_INVALID_PROFILE		= 2011
ERROR_TAG_NOT_FOUND		= 2012
ERROR_TAG_NOT_PRESENT		= 2013
ERROR_DUPLICATE_TAG		= 2014
ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE = 2015
ERROR_PROFILE_NOT_FOUND 	= 2016
ERROR_INVALID_COLORSPACE	= 2017
ERROR_ICM_NOT_ENABLED		= 2018
ERROR_DELETING_ICM_XFORM	= 2019
ERROR_INVALID_TRANSFORM 	= 2020
ERROR_COLORSPACE_MISMATCH	= 2021
ERROR_INVALID_COLORINDEX	= 2022
ERROR_UNKNOWN_PRINT_MONITOR	= 3000
ERROR_PRINTER_DRIVER_IN_USE	= 3001
ERROR_SPOOL_FILE_NOT_FOUND	= 3002
ERROR_SPL_NO_STARTDOC		= 3003
ERROR_SPL_NO_ADDJOB		= 3004
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005
ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006
ERROR_INVALID_PRINT_MONITOR	= 3007
ERROR_PRINT_MONITOR_IN_USE	= 3008
ERROR_PRINTER_HAS_JOBS_QUEUED	= 3009
ERROR_SUCCESS_REBOOT_REQUIRED	= 3010
ERROR_SUCCESS_RESTART_REQUIRED	= 3011
ERROR_PRINTER_NOT_FOUND 	= 3012
ERROR_WINS_INTERNAL		= 4000
ERROR_CAN_NOT_DEL_LOCAL_WINS	= 4001
ERROR_STATIC_INIT		= 4002
ERROR_INC_BACKUP		= 4003
ERROR_FULL_BACKUP		= 4004
ERROR_REC_NON_EXISTENT		= 4005
ERROR_RPL_NOT_ALLOWED		= 4006
ERROR_DHCP_ADDRESS_CONFLICT	= 4100
ERROR_WMI_GUID_NOT_FOUND	= 4200
ERROR_WMI_INSTANCE_NOT_FOUND	= 4201
ERROR_WMI_ITEMID_NOT_FOUND	= 4202
ERROR_WMI_TRY_AGAIN		= 4203
ERROR_WMI_DP_NOT_FOUND		= 4204
ERROR_WMI_UNRESOLVED_INSTANCE_REF = 4205
ERROR_WMI_ALREADY_ENABLED	= 4206
ERROR_WMI_GUID_DISCONNECTED	= 4207
ERROR_WMI_SERVER_UNAVAILABLE	= 4208
ERROR_WMI_DP_FAILED		= 4209
ERROR_WMI_INVALID_MOF		= 4210
ERROR_WMI_INVALID_REGINFO	= 4211
ERROR_WMI_ALREADY_DISABLED	= 4212
ERROR_WMI_READ_ONLY		= 4213
ERROR_WMI_SET_FAILURE		= 4214
ERROR_SAM_INIT_FAILURE		= 4215
ERROR_INVALID_MEDIA		= 4300
ERROR_INVALID_LIBRARY		= 4301
ERROR_INVALID_MEDIA_POOL	= 4302
ERROR_DRIVE_MEDIA_MISMATCH	= 4303
ERROR_MEDIA_OFFLINE		= 4304
ERROR_LIBRARY_OFFLINE		= 4305
ERROR_EMPTY			= 4306
ERROR_NOT_EMPTY 		= 4307
ERROR_MEDIA_UNAVAILABLE 	= 4308
ERROR_RESOURCE_DISABLED 	= 4309
ERROR_INVALID_CLEANER		= 4310
ERROR_UNABLE_TO_CLEAN		= 4311
ERROR_OBJECT_NOT_FOUND		= 4312
ERROR_DATABASE_FAILURE		= 4313
ERROR_DATABASE_FULL		= 4314
ERROR_MEDIA_INCOMPATIBLE	= 4315
ERROR_RESOURCE_NOT_PRESENT	= 4316
ERROR_INVALID_OPERATION 	= 4317
ERROR_MEDIA_NOT_AVAILABLE	= 4318
ERROR_DEVICE_NOT_AVAILABLE	= 4319
ERROR_REQUEST_REFUSED		= 4320
ERROR_INVALID_DRIVE_OBJECT	= 4321
ERROR_LIBRARY_FULL		= 4322
ERROR_MEDIUM_NOT_ACCESSIBLE	= 4323
ERROR_UNABLE_TO_LOAD_MEDIUM	= 4324
ERROR_UNABLE_TO_INVENTORY_DRIVE = 4325
ERROR_UNABLE_TO_INVENTORY_SLOT	= 4326
ERROR_UNABLE_TO_INVENTORY_TRANSPORT = 4327
ERROR_TRANSPORT_FULL		= 4328
ERROR_CONTROLLING_IEPORT	= 4329
ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA = 4330
ERROR_CLEANER_SLOT_SET		= 4331
ERROR_CLEANER_SLOT_NOT_SET	= 4332
ERROR_CLEANER_CARTRIDGE_SPENT	= 4333
ERROR_UNEXPECTED_OMID		= 4334
ERROR_CANT_DELETE_LAST_ITEM	= 4335
ERROR_MESSAGE_EXCEEDS_MAX_SIZE	= 4336
ERROR_FILE_OFFLINE		= 4350
ERROR_REMOTE_STORAGE_NOT_ACTIVE = 4351
ERROR_REMOTE_STORAGE_MEDIA_ERROR = 4352
ERROR_NOT_A_REPARSE_POINT	= 4390
ERROR_REPARSE_ATTRIBUTE_CONFLICT = 4391
ERROR_INVALID_REPARSE_DATA	= 4392
ERROR_DEPENDENT_RESOURCE_EXISTS = 5001
ERROR_DEPENDENCY_NOT_FOUND	= 5002
ERROR_DEPENDENCY_ALREADY_EXISTS = 5003
ERROR_RESOURCE_NOT_ONLINE	= 5004
ERROR_HOST_NODE_NOT_AVAILABLE	= 5005
ERROR_RESOURCE_NOT_AVAILABLE	= 5006
ERROR_RESOURCE_NOT_FOUND	= 5007
ERROR_SHUTDOWN_CLUSTER		= 5008
ERROR_CANT_EVICT_ACTIVE_NODE	= 5009
ERROR_OBJECT_ALREADY_EXISTS	= 5010
ERROR_OBJECT_IN_LIST		= 5011
ERROR_GROUP_NOT_AVAILABLE	= 5012
ERROR_GROUP_NOT_FOUND		= 5013
ERROR_GROUP_NOT_ONLINE		= 5014
ERROR_HOST_NODE_NOT_RESOURCE_OWNER = 5015
ERROR_HOST_NODE_NOT_GROUP_OWNER = 5016
ERROR_RESMON_CREATE_FAILED	= 5017
ERROR_RESMON_ONLINE_FAILED	= 5018
ERROR_RESOURCE_ONLINE		= 5019
ERROR_QUORUM_RESOURCE		= 5020
ERROR_NOT_QUORUM_CAPABLE	= 5021
ERROR_CLUSTER_SHUTTING_DOWN	= 5022
ERROR_INVALID_STATE		= 5023
ERROR_RESOURCE_PROPERTIES_STORED = 5024
ERROR_NOT_QUORUM_CLASS		= 5025
ERROR_CORE_RESOURCE		= 5026
ERROR_QUORUM_RESOURCE_ONLINE_FAILED = 5027
ERROR_QUORUMLOG_OPEN_FAILED	= 5028
ERROR_CLUSTERLOG_CORRUPT	= 5029
ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE = 5030
ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE = 5031
ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND = 5032
ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE = 5033
ERROR_NETWORK_NOT_AVAILABLE	= 5035
ERROR_NODE_NOT_AVAILABLE	= 5036
ERROR_ALL_NODES_NOT_AVAILABLE	= 5037
ERROR_RESOURCE_FAILED		= 5038
ERROR_CLUSTER_INVALID_NODE	= 5039
ERROR_CLUSTER_NODE_EXISTS	= 5040
ERROR_CLUSTER_JOIN_IN_PROGRESS	= 5041
ERROR_CLUSTER_NODE_NOT_FOUND	= 5042
ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND = 5043
ERROR_CLUSTER_NETWORK_EXISTS	= 5044
ERROR_CLUSTER_NETWORK_NOT_FOUND = 5045
ERROR_CLUSTER_NETINTERFACE_EXISTS = 5046
ERROR_CLUSTER_NETINTERFACE_NOT_FOUND = 5047
ERROR_CLUSTER_INVALID_REQUEST	= 5048
ERROR_CLUSTER_INVALID_NETWORK_PROVIDER = 5049
ERROR_CLUSTER_NODE_DOWN 	= 5050
ERROR_CLUSTER_NODE_UNREACHABLE	= 5051
ERROR_CLUSTER_NODE_NOT_MEMBER	= 5052
ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS = 5053
ERROR_CLUSTER_INVALID_NETWORK	= 5054
ERROR_CLUSTER_NODE_UP		= 5056
ERROR_CLUSTER_IPADDR_IN_USE	= 5057
ERROR_CLUSTER_NODE_NOT_PAUSED	= 5058
ERROR_CLUSTER_NO_SECURITY_CONTEXT = 5059
ERROR_CLUSTER_NETWORK_NOT_INTERNAL = 5060
ERROR_CLUSTER_NODE_ALREADY_UP	= 5061
ERROR_CLUSTER_NODE_ALREADY_DOWN = 5062
ERROR_CLUSTER_NETWORK_ALREADY_ONLINE = 5063
ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE = 5064
ERROR_CLUSTER_NODE_ALREADY_MEMBER = 5065
ERROR_CLUSTER_LAST_INTERNAL_NETWORK = 5066
ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS = 5067
ERROR_INVALID_OPERATION_ON_QUORUM = 5068
ERROR_DEPENDENCY_NOT_ALLOWED	= 5069
ERROR_CLUSTER_NODE_PAUSED	= 5070
ERROR_NODE_CANT_HOST_RESOURCE	= 5071
ERROR_CLUSTER_NODE_NOT_READY	= 5072
ERROR_CLUSTER_NODE_SHUTTING_DOWN = 5073
ERROR_CLUSTER_JOIN_ABORTED	= 5074
ERROR_CLUSTER_INCOMPATIBLE_VERSIONS = 5075
ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED = 5076
ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED = 5077
ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND = 5078
ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED = 5079
ERROR_CLUSTER_RESNAME_NOT_FOUND = 5080
ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED = 5081
ERROR_ENCRYPTION_FAILED 	= 6000
ERROR_DECRYPTION_FAILED 	= 6001
ERROR_FILE_ENCRYPTED		= 6002
ERROR_NO_RECOVERY_POLICY	= 6003
ERROR_NO_EFS			= 6004
ERROR_WRONG_EFS 		= 6005
ERROR_NO_USER_KEYS		= 6006
ERROR_FILE_NOT_ENCRYPTED	= 6007
ERROR_NOT_EXPORT_FORMAT 	= 6008
ERROR_CTX_WINSTATION_NAME_INVALID = 7001
ERROR_CTX_INVALID_PD		= 7002
ERROR_CTX_PD_NOT_FOUND		= 7003
ERROR_CTX_WD_NOT_FOUND		= 7004
ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY = 7005
ERROR_CTX_SERVICE_NAME_COLLISION = 7006
ERROR_CTX_CLOSE_PENDING 	= 7007
ERROR_CTX_NO_OUTBUF		= 7008
ERROR_CTX_MODEM_INF_NOT_FOUND	= 7009
ERROR_CTX_INVALID_MODEMNAME	= 7010
ERROR_CTX_MODEM_RESPONSE_ERROR	= 7011
ERROR_CTX_MODEM_RESPONSE_TIMEOUT = 7012
ERROR_CTX_MODEM_RESPONSE_NO_CARRIER = 7013
ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE = 7014
ERROR_CTX_MODEM_RESPONSE_BUSY	= 7015
ERROR_CTX_MODEM_RESPONSE_VOICE	= 7016
ERROR_CTX_TD_ERROR		= 7017
ERROR_CTX_WINSTATION_NOT_FOUND	= 7022
ERROR_CTX_WINSTATION_ALREADY_EXISTS = 7023
ERROR_CTX_WINSTATION_BUSY	= 7024
ERROR_CTX_BAD_VIDEO_MODE	= 7025
ERROR_CTX_GRAPHICS_INVALID	= 7035
ERROR_CTX_LOGON_DISABLED	= 7037
ERROR_CTX_NOT_CONSOLE		= 7038
ERROR_CTX_CLIENT_QUERY_TIMEOUT	= 7040
ERROR_CTX_CONSOLE_DISCONNECT	= 7041
ERROR_CTX_CONSOLE_CONNECT	= 7042
ERROR_CTX_SHADOW_DENIED 	= 7044
ERROR_CTX_WINSTATION_ACCESS_DENIED = 7045
ERROR_CTX_INVALID_WD		= 7049
ERROR_CTX_SHADOW_INVALID	= 7050
ERROR_CTX_SHADOW_DISABLED	= 7051
FRS_ERR_INVALID_API_SEQUENCE	= 8001
FRS_ERR_STARTING_SERVICE	= 8002
FRS_ERR_STOPPING_SERVICE	= 8003
FRS_ERR_INTERNAL_API		= 8004
FRS_ERR_INTERNAL		= 8005
FRS_ERR_SERVICE_COMM		= 8006
FRS_ERR_INSUFFICIENT_PRIV	= 8007
FRS_ERR_AUTHENTICATION		= 8008
FRS_ERR_PARENT_INSUFFICIENT_PRIV = 8009
FRS_ERR_PARENT_AUTHENTICATION	= 8010
FRS_ERR_CHILD_TO_PARENT_COMM	= 8011
FRS_ERR_PARENT_TO_CHILD_COMM	= 8012
FRS_ERR_SYSVOL_POPULATE 	= 8013
FRS_ERR_SYSVOL_POPULATE_TIMEOUT = 8014
FRS_ERR_SYSVOL_IS_BUSY		= 8015
FRS_ERR_SYSVOL_DEMOTE		= 8016
FRS_ERR_INVALID_SERVICE_PARAMETER = 8017
DS_S_SUCCESS			= NO_ERROR
ERROR_DS_NOT_INSTALLED		= 8200
ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY = 8201
ERROR_DS_NO_ATTRIBUTE_OR_VALUE	= 8202
ERROR_DS_INVALID_ATTRIBUTE_SYNTAX = 8203
ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED = 8204
ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS = 8205
ERROR_DS_BUSY			= 8206
ERROR_DS_UNAVAILABLE		= 8207
ERROR_DS_NO_RIDS_ALLOCATED	= 8208
ERROR_DS_NO_MORE_RIDS		= 8209
ERROR_DS_INCORRECT_ROLE_OWNER	= 8210
ERROR_DS_RIDMGR_INIT_ERROR	= 8211
ERROR_DS_OBJ_CLASS_VIOLATION	= 8212
ERROR_DS_CANT_ON_NON_LEAF	= 8213
ERROR_DS_CANT_ON_RDN		= 8214
ERROR_DS_CANT_MOD_OBJ_CLASS	= 8215
ERROR_DS_CROSS_DOM_MOVE_ERROR	= 8216
ERROR_DS_GC_NOT_AVAILABLE	= 8217
ERROR_SHARED_POLICY		= 8218
ERROR_POLICY_OBJECT_NOT_FOUND	= 8219
ERROR_POLICY_ONLY_IN_DS 	= 8220
ERROR_PROMOTION_ACTIVE		= 8221
ERROR_NO_PROMOTION_ACTIVE	= 8222
ERROR_DS_OPERATIONS_ERROR	= 8224
ERROR_DS_PROTOCOL_ERROR 	= 8225
ERROR_DS_TIMELIMIT_EXCEEDED	= 8226
ERROR_DS_SIZELIMIT_EXCEEDED	= 8227
ERROR_DS_ADMIN_LIMIT_EXCEEDED	= 8228
ERROR_DS_COMPARE_FALSE		= 8229
ERROR_DS_COMPARE_TRUE		= 8230
ERROR_DS_AUTH_METHOD_NOT_SUPPORTED = 8231
ERROR_DS_STRONG_AUTH_REQUIRED	= 8232
ERROR_DS_INAPPROPRIATE_AUTH	= 8233
ERROR_DS_AUTH_UNKNOWN		= 8234
ERROR_DS_REFERRAL		= 8235
ERROR_DS_UNAVAILABLE_CRIT_EXTENSION = 8236
ERROR_DS_CONFIDENTIALITY_REQUIRED = 8237
ERROR_DS_INAPPROPRIATE_MATCHING = 8238
ERROR_DS_CONSTRAINT_VIOLATION	= 8239
ERROR_DS_NO_SUCH_OBJECT 	= 8240
ERROR_DS_ALIAS_PROBLEM		= 8241
ERROR_DS_INVALID_DN_SYNTAX	= 8242
ERROR_DS_IS_LEAF		= 8243
ERROR_DS_ALIAS_DEREF_PROBLEM	= 8244
ERROR_DS_UNWILLING_TO_PERFORM	= 8245
ERROR_DS_LOOP_DETECT		= 8246
ERROR_DS_NAMING_VIOLATION	= 8247
ERROR_DS_OBJECT_RESULTS_TOO_LARGE = 8248
ERROR_DS_AFFECTS_MULTIPLE_DSAS	= 8249
ERROR_DS_SERVER_DOWN		= 8250
ERROR_DS_LOCAL_ERROR		= 8251
ERROR_DS_ENCODING_ERROR 	= 8252
ERROR_DS_DECODING_ERROR 	= 8253
ERROR_DS_FILTER_UNKNOWN 	= 8254
ERROR_DS_PARAM_ERROR		= 8255
ERROR_DS_NOT_SUPPORTED		= 8256
ERROR_DS_NO_RESULTS_RETURNED	= 8257
ERROR_DS_CONTROL_NOT_FOUND	= 8258
ERROR_DS_CLIENT_LOOP		= 8259
ERROR_DS_REFERRAL_LIMIT_EXCEEDED = 8260
ERROR_DS_ROOT_MUST_BE_NC	= 8301
ERROR_DS_ADD_REPLICA_INHIBITED	= 8302
ERROR_DS_ATT_NOT_DEF_IN_SCHEMA	= 8303
ERROR_DS_MAX_OBJ_SIZE_EXCEEDED	= 8304
ERROR_DS_OBJ_STRING_NAME_EXISTS = 8305
ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA = 8306
ERROR_DS_RDN_DOESNT_MATCH_SCHEMA = 8307
ERROR_DS_NO_REQUESTED_ATTS_FOUND = 8308
ERROR_DS_USER_BUFFER_TO_SMALL	= 8309
ERROR_DS_ATT_IS_NOT_ON_OBJ	= 8310
ERROR_DS_ILLEGAL_MOD_OPERATION	= 8311
ERROR_DS_OBJ_TOO_LARGE		= 8312
ERROR_DS_BAD_INSTANCE_TYPE	= 8313
ERROR_DS_MASTERDSA_REQUIRED	= 8314
ERROR_DS_OBJECT_CLASS_REQUIRED	= 8315
ERROR_DS_MISSING_REQUIRED_ATT	= 8316
ERROR_DS_ATT_NOT_DEF_FOR_CLASS	= 8317
ERROR_DS_ATT_ALREADY_EXISTS	= 8318
ERROR_DS_CANT_ADD_ATT_VALUES	= 8320
ERROR_DS_SINGLE_VALUE_CONSTRAINT = 8321
ERROR_DS_RANGE_CONSTRAINT	= 8322
ERROR_DS_ATT_VAL_ALREADY_EXISTS = 8323
ERROR_DS_CANT_REM_MISSING_ATT	= 8324
ERROR_DS_CANT_REM_MISSING_ATT_VAL = 8325
ERROR_DS_ROOT_CANT_BE_SUBREF	= 8326
ERROR_DS_NO_CHAINING		= 8327
ERROR_DS_NO_CHAINED_EVAL	= 8328
ERROR_DS_NO_PARENT_OBJECT	= 8329
ERROR_DS_PARENT_IS_AN_ALIAS	= 8330
ERROR_DS_CANT_MIX_MASTER_AND_REPS = 8331
ERROR_DS_CHILDREN_EXIST 	= 8332
ERROR_DS_OBJ_NOT_FOUND		= 8333
ERROR_DS_ALIASED_OBJ_MISSING	= 8334
ERROR_DS_BAD_NAME_SYNTAX	= 8335
ERROR_DS_ALIAS_POINTS_TO_ALIAS	= 8336
ERROR_DS_CANT_DEREF_ALIAS	= 8337
ERROR_DS_OUT_OF_SCOPE		= 8338
ERROR_DS_CANT_DELETE_DSA_OBJ	= 8340
ERROR_DS_GENERIC_ERROR		= 8341
ERROR_DS_DSA_MUST_BE_INT_MASTER = 8342
ERROR_DS_CLASS_NOT_DSA		= 8343
ERROR_DS_INSUFF_ACCESS_RIGHTS	= 8344
ERROR_DS_ILLEGAL_SUPERIOR	= 8345
ERROR_DS_ATTRIBUTE_OWNED_BY_SAM = 8346
ERROR_DS_NAME_TOO_MANY_PARTS	= 8347
ERROR_DS_NAME_TOO_LONG		= 8348
ERROR_DS_NAME_VALUE_TOO_LONG	= 8349
ERROR_DS_NAME_UNPARSEABLE	= 8350
ERROR_DS_NAME_TYPE_UNKNOWN	= 8351
ERROR_DS_NOT_AN_OBJECT		= 8352
ERROR_DS_SEC_DESC_TOO_SHORT	= 8353
ERROR_DS_SEC_DESC_INVALID	= 8354
ERROR_DS_NO_DELETED_NAME	= 8355
ERROR_DS_SUBREF_MUST_HAVE_PARENT = 8356
ERROR_DS_NCNAME_MUST_BE_NC	= 8357
ERROR_DS_CANT_ADD_SYSTEM_ONLY	= 8358
ERROR_DS_CLASS_MUST_BE_CONCRETE = 8359
ERROR_DS_INVALID_DMD		= 8360
ERROR_DS_OBJ_GUID_EXISTS	= 8361
ERROR_DS_NOT_ON_BACKLINK	= 8362
ERROR_DS_NO_CROSSREF_FOR_NC	= 8363
ERROR_DS_SHUTTING_DOWN		= 8364
ERROR_DS_UNKNOWN_OPERATION	= 8365
ERROR_DS_INVALID_ROLE_OWNER	= 8366
ERROR_DS_COULDNT_CONTACT_FSMO	= 8367
ERROR_DS_CROSS_NC_DN_RENAME	= 8368
ERROR_DS_CANT_MOD_SYSTEM_ONLY	= 8369
ERROR_DS_REPLICATOR_ONLY	= 8370
ERROR_DS_OBJ_CLASS_NOT_DEFINED	= 8371
ERROR_DS_OBJ_CLASS_NOT_SUBCLASS = 8372
ERROR_DS_NAME_REFERENCE_INVALID = 8373
ERROR_DS_CROSS_REF_EXISTS	= 8374
ERROR_DS_CANT_DEL_MASTER_CROSSREF = 8375
ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD = 8376
ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX = 8377
ERROR_DS_DUP_RDN		= 8378
ERROR_DS_DUP_OID		= 8379
ERROR_DS_DUP_MAPI_ID		= 8380
ERROR_DS_DUP_SCHEMA_ID_GUID	= 8381
ERROR_DS_DUP_LDAP_DISPLAY_NAME	= 8382
ERROR_DS_SEMANTIC_ATT_TEST	= 8383
ERROR_DS_SYNTAX_MISMATCH	= 8384
ERROR_DS_EXISTS_IN_MUST_HAVE	= 8385
ERROR_DS_EXISTS_IN_MAY_HAVE	= 8386
ERROR_DS_NONEXISTENT_MAY_HAVE	= 8387
ERROR_DS_NONEXISTENT_MUST_HAVE	= 8388
ERROR_DS_AUX_CLS_TEST_FAIL	= 8389
ERROR_DS_NONEXISTENT_POSS_SUP	= 8390
ERROR_DS_SUB_CLS_TEST_FAIL	= 8391
ERROR_DS_BAD_RDN_ATT_ID_SYNTAX	= 8392
ERROR_DS_EXISTS_IN_AUX_CLS	= 8393
ERROR_DS_EXISTS_IN_SUB_CLS	= 8394
ERROR_DS_EXISTS_IN_POSS_SUP	= 8395
ERROR_DS_RECALCSCHEMA_FAILED	= 8396
ERROR_DS_TREE_DELETE_NOT_FINISHED = 8397
ERROR_DS_CANT_DELETE		= 8398
ERROR_DS_ATT_SCHEMA_REQ_ID	= 8399
ERROR_DS_BAD_ATT_SCHEMA_SYNTAX	= 8400
ERROR_DS_CANT_CACHE_ATT 	= 8401
ERROR_DS_CANT_CACHE_CLASS	= 8402
ERROR_DS_CANT_REMOVE_ATT_CACHE	= 8403
ERROR_DS_CANT_REMOVE_CLASS_CACHE = 8404
ERROR_DS_CANT_RETRIEVE_DN	= 8405
ERROR_DS_MISSING_SUPREF 	= 8406
ERROR_DS_CANT_RETRIEVE_INSTANCE = 8407
ERROR_DS_CODE_INCONSISTENCY	= 8408
ERROR_DS_DATABASE_ERROR 	= 8409
ERROR_DS_GOVERNSID_MISSING	= 8410
ERROR_DS_MISSING_EXPECTED_ATT	= 8411
ERROR_DS_NCNAME_MISSING_CR_REF	= 8412
ERROR_DS_SECURITY_CHECKING_ERROR = 8413
ERROR_DS_SCHEMA_NOT_LOADED	= 8414
ERROR_DS_SCHEMA_ALLOC_FAILED	= 8415
ERROR_DS_ATT_SCHEMA_REQ_SYNTAX	= 8416
ERROR_DS_GCVERIFY_ERROR 	= 8417
ERROR_DS_DRA_SCHEMA_MISMATCH	= 8418
ERROR_DS_CANT_FIND_DSA_OBJ	= 8419
ERROR_DS_CANT_FIND_EXPECTED_NC	= 8420
ERROR_DS_CANT_FIND_NC_IN_CACHE	= 8421
ERROR_DS_CANT_RETRIEVE_CHILD	= 8422
ERROR_DS_SECURITY_ILLEGAL_MODIFY = 8423
ERROR_DS_CANT_REPLACE_HIDDEN_REC = 8424
ERROR_DS_BAD_HIERARCHY_FILE	= 8425
ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED = 8426
ERROR_DS_CONFIG_PARAM_MISSING	= 8427
ERROR_DS_COUNTING_AB_INDICES_FAILED = 8428
ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED = 8429
ERROR_DS_INTERNAL_FAILURE	= 8430
ERROR_DS_UNKNOWN_ERROR		= 8431
ERROR_DS_ROOT_REQUIRES_CLASS_TOP = 8432
ERROR_DS_REFUSING_FSMO_ROLES	= 8433
ERROR_DS_MISSING_FSMO_SETTINGS	= 8434
ERROR_DS_UNABLE_TO_SURRENDER_ROLES = 8435
ERROR_DS_DRA_GENERIC		= 8436
ERROR_DS_DRA_INVALID_PARAMETER	= 8437
ERROR_DS_DRA_BUSY		= 8438
ERROR_DS_DRA_BAD_DN		= 8439
ERROR_DS_DRA_BAD_NC		= 8440
ERROR_DS_DRA_DN_EXISTS		= 8441
ERROR_DS_DRA_INTERNAL_ERROR	= 8442
ERROR_DS_DRA_INCONSISTENT_DIT	= 8443
ERROR_DS_DRA_CONNECTION_FAILED	= 8444
ERROR_DS_DRA_BAD_INSTANCE_TYPE	= 8445
ERROR_DS_DRA_OUT_OF_MEM 	= 8446
ERROR_DS_DRA_MAIL_PROBLEM	= 8447
ERROR_DS_DRA_REF_ALREADY_EXISTS = 8448
ERROR_DS_DRA_REF_NOT_FOUND	= 8449
ERROR_DS_DRA_OBJ_IS_REP_SOURCE	= 8450
ERROR_DS_DRA_DB_ERROR		= 8451
ERROR_DS_DRA_NO_REPLICA 	= 8452
ERROR_DS_DRA_ACCESS_DENIED	= 8453
ERROR_DS_DRA_NOT_SUPPORTED	= 8454
ERROR_DS_DRA_RPC_CANCELLED	= 8455
ERROR_DS_DRA_SOURCE_DISABLED	= 8456
ERROR_DS_DRA_SINK_DISABLED	= 8457
ERROR_DS_DRA_NAME_COLLISION	= 8458
ERROR_DS_DRA_SOURCE_REINSTALLED = 8459
ERROR_DS_DRA_MISSING_PARENT	= 8460
ERROR_DS_DRA_PREEMPTED		= 8461
ERROR_DS_DRA_ABANDON_SYNC	= 8462
ERROR_DS_DRA_SHUTDOWN		= 8463
ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET = 8464
ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA = 8465
ERROR_DS_DRA_EXTN_CONNECTION_FAILED = 8466
ERROR_DS_INSTALL_SCHEMA_MISMATCH = 8467
ERROR_DS_DUP_LINK_ID		= 8468
ERROR_DS_NAME_ERROR_RESOLVING	= 8469
ERROR_DS_NAME_ERROR_NOT_FOUND	= 8470
ERROR_DS_NAME_ERROR_NOT_UNIQUE	= 8471
ERROR_DS_NAME_ERROR_NO_MAPPING	= 8472
ERROR_DS_NAME_ERROR_DOMAIN_ONLY = 8473
ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING = 8474
ERROR_DS_CONSTRUCTED_ATT_MOD	= 8475
ERROR_DS_WRONG_OM_OBJ_CLASS	= 8476
ERROR_DS_DRA_REPL_PENDING	= 8477
ERROR_DS_DS_REQUIRED		= 8478
DNS_ERROR_RESPONSE_CODES_BASE	= 9000
DNS_ERROR_RCODE_NO_ERROR	= NO_ERROR
DNS_ERROR_MASK			= 000002328h ; 9000 or DNS_ERROR_RESPONSE_CODES_BASE
DNS_ERROR_RCODE_FORMAT_ERROR	= 9001
DNS_ERROR_RCODE_SERVER_FAILURE	= 9002
DNS_ERROR_RCODE_NAME_ERROR	= 9003
DNS_ERROR_RCODE_NOT_IMPLEMENTED = 9004
DNS_ERROR_RCODE_REFUSED 	= 9005
DNS_ERROR_RCODE_YXDOMAIN	= 9006
DNS_ERROR_RCODE_YXRRSET 	= 9007
DNS_ERROR_RCODE_NXRRSET 	= 9008
DNS_ERROR_RCODE_NOTAUTH 	= 9009
DNS_ERROR_RCODE_NOTZONE 	= 9010
DNS_ERROR_RCODE_BADSIG		= 9016
DNS_ERROR_RCODE_BADKEY		= 9017
DNS_ERROR_RCODE_BADTIME 	= 9018
DNS_ERROR_RCODE_LAST		= DNS_ERROR_RCODE_BADTIME
DNS_ERROR_PACKET_FMT_BASE	= 9500
DNS_INFO_NO_RECORDS		= 9501
DNS_ERROR_BAD_PACKET		= 9502
DNS_ERROR_NO_PACKET		= 9503
DNS_ERROR_RCODE 		= 9504
DNS_ERROR_UNSECURE_PACKET	= 9505
DNS_STATUS_PACKET_UNSECURE	= DNS_ERROR_UNSECURE_PACKET
DNS_ERROR_NO_MEMORY		= ERROR_OUTOFMEMORY
DNS_ERROR_INVALID_NAME		= ERROR_INVALID_NAME
DNS_ERROR_INVALID_DATA		= ERROR_INVALID_DATA
DNS_ERROR_GENERAL_API_BASE	= 9550
DNS_ERROR_INVALID_TYPE		= 9551
DNS_ERROR_INVALID_IP_ADDRESS	= 9552
DNS_ERROR_INVALID_PROPERTY	= 9553
DNS_ERROR_TRY_AGAIN_LATER	= 9554
DNS_ERROR_NOT_UNIQUE		= 9555
DNS_ERROR_NON_RFC_NAME		= 9556
DNS_STATUS_FQDN 		= 9557
DNS_STATUS_DOTTED_NAME		= 9558
DNS_STATUS_SINGLE_PART_NAME	= 9559
DNS_ERROR_ZONE_BASE		= 9600
DNS_ERROR_ZONE_DOES_NOT_EXIST	= 9601
DNS_ERROR_NO_ZONE_INFO		= 9602
DNS_ERROR_INVALID_ZONE_OPERATION = 9603
DNS_ERROR_ZONE_CONFIGURATION_ERROR = 9604
DNS_ERROR_ZONE_HAS_NO_SOA_RECORD = 9605
DNS_ERROR_ZONE_HAS_NO_NS_RECORDS = 9606
DNS_ERROR_ZONE_LOCKED		= 9607
DNS_ERROR_ZONE_CREATION_FAILED	= 9608
DNS_ERROR_ZONE_ALREADY_EXISTS	= 9609
DNS_ERROR_AUTOZONE_ALREADY_EXISTS = 9610
DNS_ERROR_INVALID_ZONE_TYPE	= 9611
DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP = 9612
DNS_ERROR_ZONE_NOT_SECONDARY	= 9613
DNS_ERROR_NEED_SECONDARY_ADDRESSES = 9614
DNS_ERROR_WINS_INIT_FAILED	= 9615
DNS_ERROR_NEED_WINS_SERVERS	= 9616
DNS_ERROR_NBSTAT_INIT_FAILED	= 9617
DNS_ERROR_SOA_DELETE_INVALID	= 9618
DNS_ERROR_DATAFILE_BASE 	= 9650
DNS_ERROR_PRIMARY_REQUIRES_DATAFILE = 9651
DNS_ERROR_INVALID_DATAFILE_NAME = 9652
DNS_ERROR_DATAFILE_OPEN_FAILURE = 9653
DNS_ERROR_FILE_WRITEBACK_FAILED = 9654
DNS_ERROR_DATAFILE_PARSING	= 9655
DNS_ERROR_DATABASE_BASE 	= 9700
DNS_ERROR_RECORD_DOES_NOT_EXIST = 9701
DNS_ERROR_RECORD_FORMAT 	= 9702
DNS_ERROR_NODE_CREATION_FAILED	= 9703
DNS_ERROR_UNKNOWN_RECORD_TYPE	= 9704
DNS_ERROR_RECORD_TIMED_OUT	= 9705
DNS_ERROR_NAME_NOT_IN_ZONE	= 9706
DNS_ERROR_CNAME_LOOP		= 9707
DNS_ERROR_NODE_IS_CNAME 	= 9708
DNS_ERROR_CNAME_COLLISION	= 9709
DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT = 9710
DNS_ERROR_RECORD_ALREADY_EXISTS = 9711
DNS_ERROR_SECONDARY_DATA	= 9712
DNS_ERROR_NO_CREATE_CACHE_DATA	= 9713
DNS_ERROR_NAME_DOES_NOT_EXIST	= 9714
DNS_WARNING_PTR_CREATE_FAILED	= 9715
DNS_WARNING_DOMAIN_UNDELETED	= 9716
DNS_ERROR_DS_UNAVAILABLE	= 9717
DNS_ERROR_DS_ZONE_ALREADY_EXISTS = 9718
DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE = 9719
DNS_ERROR_OPERATION_BASE	= 9750
DNS_INFO_AXFR_COMPLETE		= 9751
DNS_ERROR_AXFR			= 9752
DNS_INFO_ADDED_LOCAL_WINS	= 9753
DNS_ERROR_SECURE_BASE		= 9800
DNS_STATUS_CONTINUE_NEEDED	= 9801
DNS_ERROR_SETUP_BASE		= 9850
DNS_ERROR_NO_TCPIP		= 9851
DNS_ERROR_NO_DNS_SERVERS	= 9852

WSABASEERR			= 10000
WSAEINTR			= 10004
WSAEBADF			= 10009
WSAEACCES			= 10013
WSAEFAULT			= 10014
WSAEINVAL			= 10022
WSAEMFILE			= 10024
WSAEWOULDBLOCK			= 10035
WSAEINPROGRESS			= 10036
WSAEALREADY			= 10037
WSAENOTSOCK			= 10038
WSAEDESTADDRREQ 		= 10039
WSAEMSGSIZE			= 10040
WSAEPROTOTYPE			= 10041
WSAENOPROTOOPT			= 10042
WSAEPROTONOSUPPORT		= 10043
WSAESOCKTNOSUPPORT		= 10044
WSAEOPNOTSUPP			= 10045
WSAEPFNOSUPPORT 		= 10046
WSAEAFNOSUPPORT 		= 10047
WSAEADDRINUSE			= 10048
WSAEADDRNOTAVAIL		= 10049
WSAENETDOWN			= 10050
WSAENETUNREACH			= 10051
WSAENETRESET			= 10052
WSAECONNABORTED 		= 10053
WSAECONNRESET			= 10054
WSAENOBUFS			= 10055
WSAEISCONN			= 10056
WSAENOTCONN			= 10057
WSAESHUTDOWN			= 10058
WSAETOOMANYREFS 		= 10059
WSAETIMEDOUT			= 10060
WSAECONNREFUSED 		= 10061
WSAELOOP			= 10062
WSAENAMETOOLONG 		= 10063
WSAEHOSTDOWN			= 10064
WSAEHOSTUNREACH 		= 10065
WSAENOTEMPTY			= 10066
WSAEPROCLIM			= 10067
WSAEUSERS			= 10068
WSAEDQUOT			= 10069
WSAESTALE			= 10070
WSAEREMOTE			= 10071
WSASYSNOTREADY			= 10091
WSAVERNOTSUPPORTED		= 10092
WSANOTINITIALISED		= 10093
WSAEDISCON			= 10101
WSAENOMORE			= 10102
WSAECANCELLED			= 10103
WSAEINVALIDPROCTABLE		= 10104
WSAEINVALIDPROVIDER		= 10105
WSAEPROVIDERFAILEDINIT		= 10106
WSASYSCALLFAILURE		= 10107
WSASERVICE_NOT_FOUND		= 10108
WSATYPE_NOT_FOUND		= 10109
WSA_E_NO_MORE			= 10110
WSA_E_CANCELLED 		= 10111
WSAEREFUSED			= 10112
WSAHOST_NOT_FOUND		= 11001
WSATRY_AGAIN			= 11002
WSANO_RECOVERY			= 11003
WSANO_DATA			= 11004
WSA_QOS_RECEIVERS		= 11005
WSA_QOS_SENDERS 		= 11006
WSA_QOS_NO_SENDERS		= 11007
WSA_QOS_NO_RECEIVERS		= 11008
WSA_QOS_REQUEST_CONFIRMED	= 11009
WSA_QOS_ADMISSION_FAILURE	= 11010
WSA_QOS_POLICY_FAILURE		= 11011
WSA_QOS_BAD_STYLE		= 11012
WSA_QOS_BAD_OBJECT		= 11013
WSA_QOS_TRAFFIC_CTRL_ERROR	= 11014
WSA_QOS_GENERIC_ERROR		= 11015

SEVERITY_SUCCESS		= 0
SEVERITY_ERROR			= 1
FACILITY_NT_BIT 		= 010000000h
NOERROR 			= 0
E_UNEXPECTED			= (08000FFFFh)
E_NOTIMPL			= (080004001h)
E_OUTOFMEMORY			= (08007000Eh)
E_INVALIDARG			= (080070057h)
E_NOINTERFACE			= (080004002h)
E_POINTER			= (080004003h)
E_HANDLE			= (080070006h)
E_ABORT 			= (080004004h)
E_FAIL				= (080004005h)
E_ACCESSDENIED			= (080070005h)
E_PENDING			= (08000000Ah)
CO_E_INIT_TLS			= (080004006h)
CO_E_INIT_SHARED_ALLOCATOR	= (080004007h)
CO_E_INIT_MEMORY_ALLOCATOR	= (080004008h)
CO_E_INIT_CLASS_CACHE		= (080004009h)
CO_E_INIT_RPC_CHANNEL		= (08000400Ah)
CO_E_INIT_TLS_SET_CHANNEL_CONTROL = (08000400Bh)
CO_E_INIT_TLS_CHANNEL_CONTROL	= (08000400Ch)
CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = (08000400Dh)
CO_E_INIT_SCM_MUTEX_EXISTS	= (08000400Eh)
CO_E_INIT_SCM_FILE_MAPPING_EXISTS = (08000400Fh)
CO_E_INIT_SCM_MAP_VIEW_OF_FILE	= (080004010h)
CO_E_INIT_SCM_EXEC_FAILURE	= (080004011h)
CO_E_INIT_ONLY_SINGLE_THREADED	= (080004012h)
CO_E_CANT_REMOTE		= (080004013h)
CO_E_BAD_SERVER_NAME		= (080004014h)
CO_E_WRONG_SERVER_IDENTITY	= (080004015h)
CO_E_OLE1DDE_DISABLED		= (080004016h)
CO_E_RUNAS_SYNTAX		= (080004017h)
CO_E_CREATEPROCESS_FAILURE	= (080004018h)
CO_E_RUNAS_CREATEPROCESS_FAILURE = (080004019h)
CO_E_RUNAS_LOGON_FAILURE	= (08000401Ah)
CO_E_LAUNCH_PERMSSION_DENIED	= (08000401Bh)
CO_E_START_SERVICE_FAILURE	= (08000401Ch)
CO_E_REMOTE_COMMUNICATION_FAILURE = (08000401Dh)
CO_E_SERVER_START_TIMEOUT	= (08000401Eh)
CO_E_CLSREG_INCONSISTENT	= (08000401Fh)
CO_E_IIDREG_INCONSISTENT	= (080004020h)
CO_E_NOT_SUPPORTED		= (080004021h)
CO_E_RELOAD_DLL 		= (080004022h)
CO_E_MSI_ERROR			= (080004023h)
S_OK				= (000000000h)
S_FALSE 			= (000000001h)
OLE_E_FIRST			= (080040000h)
OLE_E_LAST			= (0800400FFh)
OLE_S_FIRST			= (000040000h)
OLE_S_LAST			= (0000400FFh)
OLE_E_OLEVERB			= (080040000h)
OLE_E_ADVF			= (080040001h)
OLE_E_ENUM_NOMORE		= (080040002h)
OLE_E_ADVISENOTSUPPORTED	= (080040003h)
OLE_E_NOCONNECTION		= (080040004h)
OLE_E_NOTRUNNING		= (080040005h)
OLE_E_NOCACHE			= (080040006h)
OLE_E_BLANK			= (080040007h)
OLE_E_CLASSDIFF 		= (080040008h)
OLE_E_CANT_GETMONIKER		= (080040009h)
OLE_E_CANT_BINDTOSOURCE 	= (08004000Ah)
OLE_E_STATIC			= (08004000Bh)
OLE_E_PROMPTSAVECANCELLED	= (08004000Ch)
OLE_E_INVALIDRECT		= (08004000Dh)
OLE_E_WRONGCOMPOBJ		= (08004000Eh)
OLE_E_INVALIDHWND		= (08004000Fh)
OLE_E_NOT_INPLACEACTIVE 	= (080040010h)
OLE_E_CANTCONVERT		= (080040011h)
OLE_E_NOSTORAGE 		= (080040012h)
DV_E_FORMATETC			= (080040064h)
DV_E_DVTARGETDEVICE		= (080040065h)
DV_E_STGMEDIUM			= (080040066h)
DV_E_STATDATA			= (080040067h)
DV_E_LINDEX			= (080040068h)
DV_E_TYMED			= (080040069h)
DV_E_CLIPFORMAT 		= (08004006Ah)
DV_E_DVASPECT			= (08004006Bh)
DV_E_DVTARGETDEVICE_SIZE	= (08004006Ch)
DV_E_NOIVIEWOBJECT		= (08004006Dh)
DRAGDROP_E_FIRST		= 080040100h
DRAGDROP_E_LAST 		= 08004010Fh
DRAGDROP_S_FIRST		= 000040100h
DRAGDROP_S_LAST 		= 00004010Fh
DRAGDROP_E_NOTREGISTERED	= (080040100h)
DRAGDROP_E_ALREADYREGISTERED	= (080040101h)
DRAGDROP_E_INVALIDHWND		= (080040102h)
CLASSFACTORY_E_FIRST		= 080040110h
CLASSFACTORY_E_LAST		= 08004011Fh
CLASSFACTORY_S_FIRST		= 000040110h
CLASSFACTORY_S_LAST		= 00004011Fh
CLASS_E_NOAGGREGATION		= (080040110h)
CLASS_E_CLASSNOTAVAILABLE	= (080040111h)
CLASS_E_NOTLICENSED		= (080040112h)
MARSHAL_E_FIRST 		= 080040120h
MARSHAL_E_LAST			= 08004012Fh
MARSHAL_S_FIRST 		= 000040120h
MARSHAL_S_LAST			= 00004012Fh
DATA_E_FIRST			= 080040130h
DATA_E_LAST			= 08004013Fh
DATA_S_FIRST			= 000040130h
DATA_S_LAST			= 00004013Fh
VIEW_E_FIRST			= 080040140h
VIEW_E_LAST			= 08004014Fh
VIEW_S_FIRST			= 000040140h
VIEW_S_LAST			= 00004014Fh
VIEW_E_DRAW			= (080040140h)
REGDB_E_FIRST			= 080040150h
REGDB_E_LAST			= 08004015Fh
REGDB_S_FIRST			= 000040150h
REGDB_S_LAST			= 00004015Fh
REGDB_E_READREGDB		= (080040150h)
REGDB_E_WRITEREGDB		= (080040151h)
REGDB_E_KEYMISSING		= (080040152h)
REGDB_E_INVALIDVALUE		= (080040153h)
REGDB_E_CLASSNOTREG		= (080040154h)
REGDB_E_IIDNOTREG		= (080040155h)
CAT_E_FIRST			= 080040160h
CAT_E_LAST			= 080040161h
CAT_E_CATIDNOEXIST		= (080040160h)
CAT_E_NODESCRIPTION		= (080040161h)
CS_E_FIRST			= 080040164h
CS_E_LAST			= 08004016Fh
CS_E_PACKAGE_NOTFOUND		= (080040164h)
CS_E_NOT_DELETABLE		= (080040165h)
CS_E_CLASS_NOTFOUND		= (080040166h)
CS_E_INVALID_VERSION		= (080040167h)
CS_E_NO_CLASSSTORE		= (080040168h)
CS_E_OBJECT_NOTFOUND		= (080040169h)
CS_E_OBJECT_ALREADY_EXISTS	= (08004016Ah)
CS_E_INVALID_PATH		= (08004016Bh)
CS_E_NETWORK_ERROR		= (08004016Ch)
CS_E_ADMIN_LIMIT_EXCEEDED	= (08004016Dh)
CS_E_SCHEMA_MISMATCH		= (08004016Eh)
CS_E_INTERNAL_ERROR		= (08004016Fh)
CACHE_E_FIRST			= 080040170h
CACHE_E_LAST			= 08004017Fh
CACHE_S_FIRST			= 000040170h
CACHE_S_LAST			= 00004017Fh
CACHE_E_NOCACHE_UPDATED 	= (080040170h)
OLEOBJ_E_FIRST			= 080040180h
OLEOBJ_E_LAST			= 08004018Fh
OLEOBJ_S_FIRST			= 000040180h
OLEOBJ_S_LAST			= 00004018Fh
OLEOBJ_E_NOVERBS		= (080040180h)
OLEOBJ_E_INVALIDVERB		= (080040181h)
CLIENTSITE_E_FIRST		= 080040190h
CLIENTSITE_E_LAST		= 08004019Fh
CLIENTSITE_S_FIRST		= 000040190h
CLIENTSITE_S_LAST		= 00004019Fh
INPLACE_E_NOTUNDOABLE		= (0800401A0h)
INPLACE_E_NOTOOLSPACE		= (0800401A1h)
INPLACE_E_FIRST 		= 0800401A0h
INPLACE_E_LAST			= 0800401AFh
INPLACE_S_FIRST 		= 0000401A0h
INPLACE_S_LAST			= 0000401AFh
ENUM_E_FIRST			= 0800401B0h
ENUM_E_LAST			= 0800401BFh
ENUM_S_FIRST			= 0000401B0h
ENUM_S_LAST			= 0000401BFh
CONVERT10_E_FIRST		= 0800401C0h
CONVERT10_E_LAST		= 0800401CFh
CONVERT10_S_FIRST		= 0000401C0h
CONVERT10_S_LAST		= 0000401CFh
CONVERT10_E_OLESTREAM_GET	= (0800401C0h)
CONVERT10_E_OLESTREAM_PUT	= (0800401C1h)
CONVERT10_E_OLESTREAM_FMT	= (0800401C2h)
CONVERT10_E_OLESTREAM_BITMAP_TO_DIB = (0800401C3h)
CONVERT10_E_STG_FMT		= (0800401C4h)
CONVERT10_E_STG_NO_STD_STREAM	= (0800401C5h)
CONVERT10_E_STG_DIB_TO_BITMAP	= (0800401C6h)
CLIPBRD_E_FIRST 		= 0800401D0h
CLIPBRD_E_LAST			= 0800401DFh
CLIPBRD_S_FIRST 		= 0000401D0h
CLIPBRD_S_LAST			= 0000401DFh
CLIPBRD_E_CANT_OPEN		= (0800401D0h)
CLIPBRD_E_CANT_EMPTY		= (0800401D1h)
CLIPBRD_E_CANT_SET		= (0800401D2h)
CLIPBRD_E_BAD_DATA		= (0800401D3h)
CLIPBRD_E_CANT_CLOSE		= (0800401D4h)
MK_E_FIRST			= 0800401E0h
MK_E_LAST			= 0800401EFh
MK_S_FIRST			= 0000401E0h
MK_S_LAST			= 0000401EFh
MK_E_CONNECTMANUALLY		= (0800401E0h)
MK_E_EXCEEDEDDEADLINE		= (0800401E1h)
MK_E_NEEDGENERIC		= (0800401E2h)
MK_E_UNAVAILABLE		= (0800401E3h)
MK_E_SYNTAX			= (0800401E4h)
MK_E_NOOBJECT			= (0800401E5h)
MK_E_INVALIDEXTENSION		= (0800401E6h)
MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = (0800401E7h)
MK_E_NOTBINDABLE		= (0800401E8h)
MK_E_NOTBOUND			= (0800401E9h)
MK_E_CANTOPENFILE		= (0800401EAh)
MK_E_MUSTBOTHERUSER		= (0800401EBh)
MK_E_NOINVERSE			= (0800401ECh)
MK_E_NOSTORAGE			= (0800401EDh)
MK_E_NOPREFIX			= (0800401EEh)
MK_E_ENUMERATION_FAILED 	= (0800401EFh)
CO_E_FIRST			= 0800401F0h
CO_E_LAST			= 0800401FFh
CO_S_FIRST			= 0000401F0h
CO_S_LAST			= 0000401FFh
CO_E_NOTINITIALIZED		= (0800401F0h)
CO_E_ALREADYINITIALIZED 	= (0800401F1h)
CO_E_CANTDETERMINECLASS 	= (0800401F2h)
CO_E_CLASSSTRING		= (0800401F3h)
CO_E_IIDSTRING			= (0800401F4h)
CO_E_APPNOTFOUND		= (0800401F5h)
CO_E_APPSINGLEUSE		= (0800401F6h)
CO_E_ERRORINAPP 		= (0800401F7h)
CO_E_DLLNOTFOUND		= (0800401F8h)
CO_E_ERRORINDLL 		= (0800401F9h)
CO_E_WRONGOSFORAPP		= (0800401FAh)
CO_E_OBJNOTREG			= (0800401FBh)
CO_E_OBJISREG			= (0800401FCh)
CO_E_OBJNOTCONNECTED		= (0800401FDh)
CO_E_APPDIDNTREG		= (0800401FEh)
CO_E_RELEASED			= (0800401FFh)
OLE_S_USEREG			= (000040000h)
OLE_S_STATIC			= (000040001h)
OLE_S_MAC_CLIPFORMAT		= (000040002h)
DRAGDROP_S_DROP 		= (000040100h)
DRAGDROP_S_CANCEL		= (000040101h)
DRAGDROP_S_USEDEFAULTCURSORS	= (000040102h)
DATA_S_SAMEFORMATETC		= (000040130h)
VIEW_S_ALREADY_FROZEN		= (000040140h)
CACHE_S_FORMATETC_NOTSUPPORTED	= (000040170h)
CACHE_S_SAMECACHE		= (000040171h)
CACHE_S_SOMECACHES_NOTUPDATED	= (000040172h)
OLEOBJ_S_INVALIDVERB		= (000040180h)
OLEOBJ_S_CANNOT_DOVERB_NOW	= (000040181h)
OLEOBJ_S_INVALIDHWND		= (000040182h)
INPLACE_S_TRUNCATED		= (0000401A0h)
CONVERT10_S_NO_PRESENTATION	= (0000401C0h)
MK_S_REDUCED_TO_SELF		= (0000401E2h)
MK_S_ME 			= (0000401E4h)
MK_S_HIM			= (0000401E5h)
MK_S_US 			= (0000401E6h)
MK_S_MONIKERALREADYREGISTERED	= (0000401E7h)
CO_E_CLASS_CREATE_FAILED	= (080080001h)
CO_E_SCM_ERROR			= (080080002h)
CO_E_SCM_RPC_FAILURE		= (080080003h)
CO_E_BAD_PATH			= (080080004h)
CO_E_SERVER_EXEC_FAILURE	= (080080005h)
CO_E_OBJSRV_RPC_FAILURE 	= (080080006h)
MK_E_NO_NORMALIZED		= (080080007h)
CO_E_SERVER_STOPPING		= (080080008h)
MEM_E_INVALID_ROOT		= (080080009h)
MEM_E_INVALID_LINK		= (080080010h)
MEM_E_INVALID_SIZE		= (080080011h)
CO_S_NOTALLINTERFACES		= (000080012h)
DISP_E_UNKNOWNINTERFACE 	= (080020001h)
DISP_E_MEMBERNOTFOUND		= (080020003h)
DISP_E_PARAMNOTFOUND		= (080020004h)
DISP_E_TYPEMISMATCH		= (080020005h)
DISP_E_UNKNOWNNAME		= (080020006h)
DISP_E_NONAMEDARGS		= (080020007h)
DISP_E_BADVARTYPE		= (080020008h)
DISP_E_EXCEPTION		= (080020009h)
DISP_E_OVERFLOW 		= (08002000Ah)
DISP_E_BADINDEX 		= (08002000Bh)
DISP_E_UNKNOWNLCID		= (08002000Ch)
DISP_E_ARRAYISLOCKED		= (08002000Dh)
DISP_E_BADPARAMCOUNT		= (08002000Eh)
DISP_E_PARAMNOTOPTIONAL 	= (08002000Fh)
DISP_E_BADCALLEE		= (080020010h)
DISP_E_NOTACOLLECTION		= (080020011h)
DISP_E_DIVBYZERO		= (080020012h)
DISP_E_BUFFERTOOSMALL		= (080020013h)
TYPE_E_BUFFERTOOSMALL		= (080028016h)
TYPE_E_FIELDNOTFOUND		= (080028017h)
TYPE_E_INVDATAREAD		= (080028018h)
TYPE_E_UNSUPFORMAT		= (080028019h)
TYPE_E_REGISTRYACCESS		= (08002801Ch)
TYPE_E_LIBNOTREGISTERED 	= (08002801Dh)
TYPE_E_UNDEFINEDTYPE		= (080028027h)
TYPE_E_QUALIFIEDNAMEDISALLOWED	= (080028028h)
TYPE_E_INVALIDSTATE		= (080028029h)
TYPE_E_WRONGTYPEKIND		= (08002802Ah)
TYPE_E_ELEMENTNOTFOUND		= (08002802Bh)
TYPE_E_AMBIGUOUSNAME		= (08002802Ch)
TYPE_E_NAMECONFLICT		= (08002802Dh)
TYPE_E_UNKNOWNLCID		= (08002802Eh)
TYPE_E_DLLFUNCTIONNOTFOUND	= (08002802Fh)
TYPE_E_BADMODULEKIND		= (0800288BDh)
TYPE_E_SIZETOOBIG		= (0800288C5h)
TYPE_E_DUPLICATEID		= (0800288C6h)
TYPE_E_INVALIDID		= (0800288CFh)
TYPE_E_TYPEMISMATCH		= (080028CA0h)
TYPE_E_OUTOFBOUNDS		= (080028CA1h)
TYPE_E_IOERROR			= (080028CA2h)
TYPE_E_CANTCREATETMPFILE	= (080028CA3h)
TYPE_E_CANTLOADLIBRARY		= (080029C4Ah)
TYPE_E_INCONSISTENTPROPFUNCS	= (080029C83h)
TYPE_E_CIRCULARTYPE		= (080029C84h)
STG_E_INVALIDFUNCTION		= (080030001h)
STG_E_FILENOTFOUND		= (080030002h)
STG_E_PATHNOTFOUND		= (080030003h)
STG_E_TOOMANYOPENFILES		= (080030004h)
STG_E_ACCESSDENIED		= (080030005h)
STG_E_INVALIDHANDLE		= (080030006h)
STG_E_INSUFFICIENTMEMORY	= (080030008h)
STG_E_INVALIDPOINTER		= (080030009h)
STG_E_NOMOREFILES		= (080030012h)
STG_E_DISKISWRITEPROTECTED	= (080030013h)
STG_E_SEEKERROR 		= (080030019h)
STG_E_WRITEFAULT		= (08003001Dh)
STG_E_READFAULT 		= (08003001Eh)
STG_E_SHAREVIOLATION		= (080030020h)
STG_E_LOCKVIOLATION		= (080030021h)
STG_E_FILEALREADYEXISTS 	= (080030050h)
STG_E_INVALIDPARAMETER		= (080030057h)
STG_E_MEDIUMFULL		= (080030070h)
STG_E_PROPSETMISMATCHED 	= (0800300F0h)
STG_E_ABNORMALAPIEXIT		= (0800300FAh)
STG_E_INVALIDHEADER		= (0800300FBh)
STG_E_INVALIDNAME		= (0800300FCh)
STG_E_UNKNOWN			= (0800300FDh)
STG_E_UNIMPLEMENTEDFUNCTION	= (0800300FEh)
STG_E_INVALIDFLAG		= (0800300FFh)
STG_E_INUSE			= (080030100h)
STG_E_NOTCURRENT		= (080030101h)
STG_E_REVERTED			= (080030102h)
STG_E_CANTSAVE			= (080030103h)
STG_E_OLDFORMAT 		= (080030104h)
STG_E_OLDDLL			= (080030105h)
STG_E_SHAREREQUIRED		= (080030106h)
STG_E_NOTFILEBASEDSTORAGE	= (080030107h)
STG_E_EXTANTMARSHALLINGS	= (080030108h)
STG_E_DOCFILECORRUPT		= (080030109h)
STG_E_BADBASEADDRESS		= (080030110h)
STG_E_DOCFILETOOLARGE		= (080030111h)
STG_E_NOTSIMPLEFORMAT		= (080030112h)
STG_E_INCOMPLETE		= (080030201h)
STG_E_TERMINATED		= (080030202h)
STG_S_CONVERTED 		= (000030200h)
STG_S_BLOCK			= (000030201h)
STG_S_RETRYNOW			= (000030202h)
STG_S_MONITORING		= (000030203h)
STG_S_MULTIPLEOPENS		= (000030204h)
STG_S_CONSOLIDATIONFAILED	= (000030205h)
STG_S_CANNOTCONSOLIDATE 	= (000030206h)
RPC_E_CALL_REJECTED		= (080010001h)
RPC_E_CALL_CANCELED		= (080010002h)
RPC_E_CANTPOST_INSENDCALL	= (080010003h)
RPC_E_CANTCALLOUT_INASYNCCALL	= (080010004h)
RPC_E_CANTCALLOUT_INEXTERNALCALL = (080010005h)
RPC_E_CONNECTION_TERMINATED	= (080010006h)
RPC_E_SERVER_DIED		= (080010007h)
RPC_E_CLIENT_DIED		= (080010008h)
RPC_E_INVALID_DATAPACKET	= (080010009h)
RPC_E_CANTTRANSMIT_CALL 	= (08001000Ah)
RPC_E_CLIENT_CANTMARSHAL_DATA	= (08001000Bh)
RPC_E_CLIENT_CANTUNMARSHAL_DATA = (08001000Ch)
RPC_E_SERVER_CANTMARSHAL_DATA	= (08001000Dh)
RPC_E_SERVER_CANTUNMARSHAL_DATA = (08001000Eh)
RPC_E_INVALID_DATA		= (08001000Fh)
RPC_E_INVALID_PARAMETER 	= (080010010h)
RPC_E_CANTCALLOUT_AGAIN 	= (080010011h)
RPC_E_SERVER_DIED_DNE		= (080010012h)
RPC_E_SYS_CALL_FAILED		= (080010100h)
RPC_E_OUT_OF_RESOURCES		= (080010101h)
RPC_E_ATTEMPTED_MULTITHREAD	= (080010102h)
RPC_E_NOT_REGISTERED		= (080010103h)
RPC_E_FAULT			= (080010104h)
RPC_E_SERVERFAULT		= (080010105h)
RPC_E_CHANGED_MODE		= (080010106h)
RPC_E_INVALIDMETHOD		= (080010107h)
RPC_E_DISCONNECTED		= (080010108h)
RPC_E_RETRY			= (080010109h)
RPC_E_SERVERCALL_RETRYLATER	= (08001010Ah)
RPC_E_SERVERCALL_REJECTED	= (08001010Bh)
RPC_E_INVALID_CALLDATA		= (08001010Ch)
RPC_E_CANTCALLOUT_ININPUTSYNCCALL = (08001010Dh)
RPC_E_WRONG_THREAD		= (08001010Eh)
RPC_E_THREAD_NOT_INIT		= (08001010Fh)
RPC_E_VERSION_MISMATCH		= (080010110h)
RPC_E_INVALID_HEADER		= (080010111h)
RPC_E_INVALID_EXTENSION 	= (080010112h)
RPC_E_INVALID_IPID		= (080010113h)
RPC_E_INVALID_OBJECT		= (080010114h)
RPC_S_CALLPENDING		= (080010115h)
RPC_S_WAITONTIMER		= (080010116h)
RPC_E_CALL_COMPLETE		= (080010117h)
RPC_E_UNSECURE_CALL		= (080010118h)
RPC_E_TOO_LATE			= (080010119h)
RPC_E_NO_GOOD_SECURITY_PACKAGES = (08001011Ah)
RPC_E_ACCESS_DENIED		= (08001011Bh)
RPC_E_REMOTE_DISABLED		= (08001011Ch)
RPC_E_INVALID_OBJREF		= (08001011Dh)
RPC_E_NO_CONTEXT		= (08001011Eh)
RPC_E_TIMEOUT			= (08001011Fh)
RPC_E_NO_SYNC			= (080010120h)
RPC_E_FULLSIC_REQUIRED		= (080010121h)
RPC_E_INVALID_STD_NAME		= (080010122h)
CO_E_FAILEDTOIMPERSONATE	= (080010123h)
CO_E_FAILEDTOGETSECCTX		= (080010124h)
CO_E_FAILEDTOOPENTHREADTOKEN	= (080010125h)
CO_E_FAILEDTOGETTOKENINFO	= (080010126h)
CO_E_TRUSTEEDOESNTMATCHCLIENT	= (080010127h)
CO_E_FAILEDTOQUERYCLIENTBLANKET = (080010128h)
CO_E_FAILEDTOSETDACL		= (080010129h)
CO_E_ACCESSCHECKFAILED		= (08001012Ah)
CO_E_NETACCESSAPIFAILED 	= (08001012Bh)
CO_E_WRONGTRUSTEENAMESYNTAX	= (08001012Ch)
CO_E_INVALIDSID 		= (08001012Dh)
CO_E_CONVERSIONFAILED		= (08001012Eh)
CO_E_NOMATCHINGSIDFOUND 	= (08001012Fh)
CO_E_LOOKUPACCSIDFAILED 	= (080010130h)
CO_E_NOMATCHINGNAMEFOUND	= (080010131h)
CO_E_LOOKUPACCNAMEFAILED	= (080010132h)
CO_E_SETSERLHNDLFAILED		= (080010133h)
CO_E_FAILEDTOGETWINDIR		= (080010134h)
CO_E_PATHTOOLONG		= (080010135h)
CO_E_FAILEDTOGENUUID		= (080010136h)
CO_E_FAILEDTOCREATEFILE 	= (080010137h)
CO_E_FAILEDTOCLOSEHANDLE	= (080010138h)
CO_E_EXCEEDSYSACLLIMIT		= (080010139h)
CO_E_ACESINWRONGORDER		= (08001013Ah)
CO_E_INCOMPATIBLESTREAMVERSION	= (08001013Bh)
CO_E_FAILEDTOOPENPROCESSTOKEN	= (08001013Ch)
CO_E_DECODEFAILED		= (08001013Dh)
CO_E_ACNOTINITIALIZED		= (08001013Fh)
RPC_E_UNEXPECTED		= (08001FFFFh)
NTE_BAD_UID			= (080090001h)
NTE_BAD_HASH			= (080090002h)
NTE_BAD_KEY			= (080090003h)
NTE_BAD_LEN			= (080090004h)
NTE_BAD_DATA			= (080090005h)
NTE_BAD_SIGNATURE		= (080090006h)
NTE_BAD_VER			= (080090007h)
NTE_BAD_ALGID			= (080090008h)
NTE_BAD_FLAGS			= (080090009h)
NTE_BAD_TYPE			= (08009000Ah)
NTE_BAD_KEY_STATE		= (08009000Bh)
NTE_BAD_HASH_STATE		= (08009000Ch)
NTE_NO_KEY			= (08009000Dh)
NTE_NO_MEMORY			= (08009000Eh)
NTE_EXISTS			= (08009000Fh)
NTE_PERM			= (080090010h)
NTE_NOT_FOUND			= (080090011h)
NTE_DOUBLE_ENCRYPT		= (080090012h)
NTE_BAD_PROVIDER		= (080090013h)
NTE_BAD_PROV_TYPE		= (080090014h)
NTE_BAD_PUBLIC_KEY		= (080090015h)
NTE_BAD_KEYSET			= (080090016h)
NTE_PROV_TYPE_NOT_DEF		= (080090017h)
NTE_PROV_TYPE_ENTRY_BAD 	= (080090018h)
NTE_KEYSET_NOT_DEF		= (080090019h)
NTE_KEYSET_ENTRY_BAD		= (08009001Ah)
NTE_PROV_TYPE_NO_MATCH		= (08009001Bh)
NTE_SIGNATURE_FILE_BAD		= (08009001Ch)
NTE_PROVIDER_DLL_FAIL		= (08009001Dh)
NTE_PROV_DLL_NOT_FOUND		= (08009001Eh)
NTE_BAD_KEYSET_PARAM		= (08009001Fh)
NTE_FAIL			= (080090020h)
NTE_SYS_ERR			= (080090021h)
NTE_SILENT_CONTEXT		= (080090022h)
NTE_TOKEN_KEYSET_STORAGE_FULL	= (080090023h)
CRYPT_E_MSG_ERROR		= (080091001h)
CRYPT_E_UNKNOWN_ALGO		= (080091002h)
CRYPT_E_OID_FORMAT		= (080091003h)
CRYPT_E_INVALID_MSG_TYPE	= (080091004h)
CRYPT_E_UNEXPECTED_ENCODING	= (080091005h)
CRYPT_E_AUTH_ATTR_MISSING	= (080091006h)
CRYPT_E_HASH_VALUE		= (080091007h)
CRYPT_E_INVALID_INDEX		= (080091008h)
CRYPT_E_ALREADY_DECRYPTED	= (080091009h)
CRYPT_E_NOT_DECRYPTED		= (08009100Ah)
CRYPT_E_RECIPIENT_NOT_FOUND	= (08009100Bh)
CRYPT_E_CONTROL_TYPE		= (08009100Ch)
CRYPT_E_ISSUER_SERIALNUMBER	= (08009100Dh)
CRYPT_E_SIGNER_NOT_FOUND	= (08009100Eh)
CRYPT_E_ATTRIBUTES_MISSING	= (08009100Fh)
CRYPT_E_STREAM_MSG_NOT_READY	= (080091010h)
CRYPT_E_STREAM_INSUFFICIENT_DATA = (080091011h)
CRYPT_E_BAD_LEN 		= (080092001h)
CRYPT_E_BAD_ENCODE		= (080092002h)
CRYPT_E_FILE_ERROR		= (080092003h)
CRYPT_E_NOT_FOUND		= (080092004h)
CRYPT_E_EXISTS			= (080092005h)
CRYPT_E_NO_PROVIDER		= (080092006h)
CRYPT_E_SELF_SIGNED		= (080092007h)
CRYPT_E_DELETED_PREV		= (080092008h)
CRYPT_E_NO_MATCH		= (080092009h)
CRYPT_E_UNEXPECTED_MSG_TYPE	= (08009200Ah)
CRYPT_E_NO_KEY_PROPERTY 	= (08009200Bh)
CRYPT_E_NO_DECRYPT_CERT 	= (08009200Ch)
CRYPT_E_BAD_MSG 		= (08009200Dh)
CRYPT_E_NO_SIGNER		= (08009200Eh)
CRYPT_E_PENDING_CLOSE		= (08009200Fh)
CRYPT_E_REVOKED 		= (080092010h)
CRYPT_E_NO_REVOCATION_DLL	= (080092011h)
CRYPT_E_NO_REVOCATION_CHECK	= (080092012h)
CRYPT_E_REVOCATION_OFFLINE	= (080092013h)
CRYPT_E_NOT_IN_REVOCATION_DATABASE = (080092014h)
CRYPT_E_INVALID_NUMERIC_STRING	= (080092020h)
CRYPT_E_INVALID_PRINTABLE_STRING = (080092021h)
CRYPT_E_INVALID_IA5_STRING	= (080092022h)
CRYPT_E_INVALID_X500_STRING	= (080092023h)
CRYPT_E_NOT_CHAR_STRING 	= (080092024h)
CRYPT_E_FILERESIZED		= (080092025h)
CRYPT_E_SECURITY_SETTINGS	= (080092026h)
CRYPT_E_NO_VERIFY_USAGE_DLL	= (080092027h)
CRYPT_E_NO_VERIFY_USAGE_CHECK	= (080092028h)
CRYPT_E_VERIFY_USAGE_OFFLINE	= (080092029h)
CRYPT_E_NOT_IN_CTL		= (08009202Ah)
CRYPT_E_NO_TRUSTED_SIGNER	= (08009202Bh)
CRYPT_E_OSS_ERROR		= (080093000h)
OSS_MORE_BUF			= (080093001h)
OSS_NEGATIVE_UINTEGER		= (080093002h)
OSS_PDU_RANGE			= (080093003h)
OSS_MORE_INPUT			= (080093004h)
OSS_DATA_ERROR			= (080093005h)
OSS_BAD_ARG			= (080093006h)
OSS_BAD_VERSION 		= (080093007h)
OSS_OUT_MEMORY			= (080093008h)
OSS_PDU_MISMATCH		= (080093009h)
OSS_LIMITED			= (08009300Ah)
OSS_BAD_PTR			= (08009300Bh)
OSS_BAD_TIME			= (08009300Ch)
OSS_INDEFINITE_NOT_SUPPORTED	= (08009300Dh)
OSS_MEM_ERROR			= (08009300Eh)
OSS_BAD_TABLE			= (08009300Fh)
OSS_TOO_LONG			= (080093010h)
OSS_CONSTRAINT_VIOLATED 	= (080093011h)
OSS_FATAL_ERROR 		= (080093012h)
OSS_ACCESS_SERIALIZATION_ERROR	= (080093013h)
OSS_NULL_TBL			= (080093014h)
OSS_NULL_FCN			= (080093015h)
OSS_BAD_ENCRULES		= (080093016h)
OSS_UNAVAIL_ENCRULES		= (080093017h)
OSS_CANT_OPEN_TRACE_WINDOW	= (080093018h)
OSS_UNIMPLEMENTED		= (080093019h)
OSS_OID_DLL_NOT_LINKED		= (08009301Ah)
OSS_CANT_OPEN_TRACE_FILE	= (08009301Bh)
OSS_TRACE_FILE_ALREADY_OPEN	= (08009301Ch)
OSS_TABLE_MISMATCH		= (08009301Dh)
OSS_TYPE_NOT_SUPPORTED		= (08009301Eh)
OSS_REAL_DLL_NOT_LINKED 	= (08009301Fh)
OSS_REAL_CODE_NOT_LINKED	= (080093020h)
OSS_OUT_OF_RANGE		= (080093021h)
OSS_COPIER_DLL_NOT_LINKED	= (080093022h)
OSS_CONSTRAINT_DLL_NOT_LINKED	= (080093023h)
OSS_COMPARATOR_DLL_NOT_LINKED	= (080093024h)
OSS_COMPARATOR_CODE_NOT_LINKED	= (080093025h)
OSS_MEM_MGR_DLL_NOT_LINKED	= (080093026h)
OSS_PDV_DLL_NOT_LINKED		= (080093027h)
OSS_PDV_CODE_NOT_LINKED 	= (080093028h)
OSS_API_DLL_NOT_LINKED		= (080093029h)
OSS_BERDER_DLL_NOT_LINKED	= (08009302Ah)
OSS_PER_DLL_NOT_LINKED		= (08009302Bh)
OSS_OPEN_TYPE_ERROR		= (08009302Ch)
OSS_MUTEX_NOT_CREATED		= (08009302Dh)
OSS_CANT_CLOSE_TRACE_FILE	= (08009302Eh)
CERTSRV_E_BAD_REQUESTSUBJECT	= (080094001h)
CERTSRV_E_NO_REQUEST		= (080094002h)
CERTSRV_E_BAD_REQUESTSTATUS	= (080094003h)
CERTSRV_E_PROPERTY_EMPTY	= (080094004h)
CERTSRV_E_INVALID_CA_CERTIFICATE = (080094005h)
CERTSRV_E_UNSUPPORTED_CERT_TYPE = (080094800h)
CERTSRV_E_NO_CERT_TYPE		= (080094801h)
CERTDB_E_JET_ERROR		= (080095000h)
TRUST_E_SYSTEM_ERROR		= (080096001h)
TRUST_E_NO_SIGNER_CERT		= (080096002h)
TRUST_E_COUNTER_SIGNER		= (080096003h)
TRUST_E_CERT_SIGNATURE		= (080096004h)
TRUST_E_TIME_STAMP		= (080096005h)
TRUST_E_BAD_DIGEST		= (080096010h)
TRUST_E_BASIC_CONSTRAINTS	= (080096019h)
TRUST_E_FINANCIAL_CRITERIA	= (08009601Eh)
NTE_OP_OK			= 0
TRUST_E_PROVIDER_UNKNOWN	= (0800B0001h)
TRUST_E_ACTION_UNKNOWN		= (0800B0002h)
TRUST_E_SUBJECT_FORM_UNKNOWN	= (0800B0003h)
TRUST_E_SUBJECT_NOT_TRUSTED	= (0800B0004h)
DIGSIG_E_ENCODE 		= (0800B0005h)
DIGSIG_E_DECODE 		= (0800B0006h)
DIGSIG_E_EXTENSIBILITY		= (0800B0007h)
DIGSIG_E_CRYPTO 		= (0800B0008h)
PERSIST_E_SIZEDEFINITE		= (0800B0009h)
PERSIST_E_SIZEINDEFINITE	= (0800B000Ah)
PERSIST_E_NOTSELFSIZING 	= (0800B000Bh)
TRUST_E_NOSIGNATURE		= (0800B0100h)
CERT_E_EXPIRED			= (0800B0101h)
CERT_E_VALIDITYPERIODNESTING	= (0800B0102h)
CERT_E_ROLE			= (0800B0103h)
CERT_E_PATHLENCONST		= (0800B0104h)
CERT_E_CRITICAL 		= (0800B0105h)
CERT_E_PURPOSE			= (0800B0106h)
CERT_E_ISSUERCHAINING		= (0800B0107h)
CERT_E_MALFORMED		= (0800B0108h)
CERT_E_UNTRUSTEDROOT		= (0800B0109h)
CERT_E_CHAINING 		= (0800B010Ah)
TRUST_E_FAIL			= (0800B010Bh)
CERT_E_REVOKED			= (0800B010Ch)
CERT_E_UNTRUSTEDTESTROOT	= (0800B010Dh)
CERT_E_REVOCATION_FAILURE	= (0800B010Eh)
CERT_E_CN_NO_MATCH		= (0800B010Fh)
CERT_E_WRONG_USAGE		= (0800B0110h)
TRUST_E_EXPLICIT_DISTRUST	= (0800B0111h)
SPAPI_E_EXPECTED_SECTION_NAME	= (0800F0000h)
SPAPI_E_BAD_SECTION_NAME_LINE	= (0800F0001h)
SPAPI_E_SECTION_NAME_TOO_LONG	= (0800F0002h)
SPAPI_E_GENERAL_SYNTAX		= (0800F0003h)
SPAPI_E_WRONG_INF_STYLE 	= (0800F0100h)
SPAPI_E_SECTION_NOT_FOUND	= (0800F0101h)
SPAPI_E_LINE_NOT_FOUND		= (0800F0102h)
SPAPI_E_NO_BACKUP		= (0800F0103h)
SPAPI_E_NO_ASSOCIATED_CLASS	= (0800F0200h)
SPAPI_E_CLASS_MISMATCH		= (0800F0201h)
SPAPI_E_DUPLICATE_FOUND 	= (0800F0202h)
SPAPI_E_NO_DRIVER_SELECTED	= (0800F0203h)
SPAPI_E_KEY_DOES_NOT_EXIST	= (0800F0204h)
SPAPI_E_INVALID_DEVINST_NAME	= (0800F0205h)
SPAPI_E_INVALID_CLASS		= (0800F0206h)
SPAPI_E_DEVINST_ALREADY_EXISTS	= (0800F0207h)
SPAPI_E_DEVINFO_NOT_REGISTERED	= (0800F0208h)
SPAPI_E_INVALID_REG_PROPERTY	= (0800F0209h)
SPAPI_E_NO_INF			= (0800F020Ah)
SPAPI_E_NO_SUCH_DEVINST 	= (0800F020Bh)
SPAPI_E_CANT_LOAD_CLASS_ICON	= (0800F020Ch)
SPAPI_E_INVALID_CLASS_INSTALLER = (0800F020Dh)
SPAPI_E_DI_DO_DEFAULT		= (0800F020Eh)
SPAPI_E_DI_NOFILECOPY		= (0800F020Fh)
SPAPI_E_INVALID_HWPROFILE	= (0800F0210h)
SPAPI_E_NO_DEVICE_SELECTED	= (0800F0211h)
SPAPI_E_DEVINFO_LIST_LOCKED	= (0800F0212h)
SPAPI_E_DEVINFO_DATA_LOCKED	= (0800F0213h)
SPAPI_E_DI_BAD_PATH		= (0800F0214h)
SPAPI_E_NO_CLASSINSTALL_PARAMS	= (0800F0215h)
SPAPI_E_FILEQUEUE_LOCKED	= (0800F0216h)
SPAPI_E_BAD_SERVICE_INSTALLSECT = (0800F0217h)
SPAPI_E_NO_CLASS_DRIVER_LIST	= (0800F0218h)
SPAPI_E_NO_ASSOCIATED_SERVICE	= (0800F0219h)
SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE = (0800F021Ah)
SPAPI_E_DEVICE_INTERFACE_ACTIVE = (0800F021Bh)
SPAPI_E_DEVICE_INTERFACE_REMOVED = (0800F021Ch)
SPAPI_E_BAD_INTERFACE_INSTALLSECT = (0800F021Dh)
SPAPI_E_NO_SUCH_INTERFACE_CLASS = (0800F021Eh)
SPAPI_E_INVALID_REFERENCE_STRING = (0800F021Fh)
SPAPI_E_INVALID_MACHINENAME	= (0800F0220h)
SPAPI_E_REMOTE_COMM_FAILURE	= (0800F0221h)
SPAPI_E_MACHINE_UNAVAILABLE	= (0800F0222h)
SPAPI_E_NO_CONFIGMGR_SERVICES	= (0800F0223h)
SPAPI_E_INVALID_PROPPAGE_PROVIDER = (0800F0224h)
SPAPI_E_NO_SUCH_DEVICE_INTERFACE = (0800F0225h)
SPAPI_E_DI_POSTPROCESSING_REQUIRED = (0800F0226h)
SPAPI_E_INVALID_COINSTALLER	= (0800F0227h)
SPAPI_E_NO_COMPAT_DRIVERS	= (0800F0228h)
SPAPI_E_NO_DEVICE_ICON		= (0800F0229h)
SPAPI_E_INVALID_INF_LOGCONFIG	= (0800F022Ah)
SPAPI_E_DI_DONT_INSTALL 	= (0800F022Bh)
SPAPI_E_INVALID_FILTER_DRIVER	= (0800F022Ch)
SPAPI_E_NON_WINDOWS_NT_DRIVER	= (0800F022Dh)
SPAPI_E_NON_WINDOWS_DRIVER	= (0800F022Eh)
SPAPI_E_NO_CATALOG_FOR_OEM_INF	= (0800F022Fh)
SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE = (0800F0230h)
SPAPI_E_ERROR_NOT_INSTALLED	= (0800F1000h)
SCARD_S_SUCCESS 		= NO_ERROR
SCARD_F_INTERNAL_ERROR		= (080100001h)
SCARD_E_CANCELLED		= (080100002h)
SCARD_E_INVALID_HANDLE		= (080100003h)
SCARD_E_INVALID_PARAMETER	= (080100004h)
SCARD_E_INVALID_TARGET		= (080100005h)
SCARD_E_NO_MEMORY		= (080100006h)
SCARD_F_WAITED_TOO_LONG 	= (080100007h)
SCARD_E_INSUFFICIENT_BUFFER	= (080100008h)
SCARD_E_UNKNOWN_READER		= (080100009h)
SCARD_E_TIMEOUT 		= (08010000Ah)
SCARD_E_SHARING_VIOLATION	= (08010000Bh)
SCARD_E_NO_SMARTCARD		= (08010000Ch)
SCARD_E_UNKNOWN_CARD		= (08010000Dh)
SCARD_E_CANT_DISPOSE		= (08010000Eh)
SCARD_E_PROTO_MISMATCH		= (08010000Fh)
SCARD_E_NOT_READY		= (080100010h)
SCARD_E_INVALID_VALUE		= (080100011h)
SCARD_E_SYSTEM_CANCELLED	= (080100012h)
SCARD_F_COMM_ERROR		= (080100013h)
SCARD_F_UNKNOWN_ERROR		= (080100014h)
SCARD_E_INVALID_ATR		= (080100015h)
SCARD_E_NOT_TRANSACTED		= (080100016h)
SCARD_E_READER_UNAVAILABLE	= (080100017h)
SCARD_P_SHUTDOWN		= (080100018h)
SCARD_E_PCI_TOO_SMALL		= (080100019h)
SCARD_E_READER_UNSUPPORTED	= (08010001Ah)
SCARD_E_DUPLICATE_READER	= (08010001Bh)
SCARD_E_CARD_UNSUPPORTED	= (08010001Ch)
SCARD_E_NO_SERVICE		= (08010001Dh)
SCARD_E_SERVICE_STOPPED 	= (08010001Eh)
SCARD_E_UNEXPECTED		= (08010001Fh)
SCARD_E_ICC_INSTALLATION	= (080100020h)
SCARD_E_ICC_CREATEORDER 	= (080100021h)
SCARD_E_UNSUPPORTED_FEATURE	= (080100022h)
SCARD_E_DIR_NOT_FOUND		= (080100023h)
SCARD_E_FILE_NOT_FOUND		= (080100024h)
SCARD_E_NO_DIR			= (080100025h)
SCARD_E_NO_FILE 		= (080100026h)
SCARD_E_NO_ACCESS		= (080100027h)
SCARD_E_WRITE_TOO_MANY		= (080100028h)
SCARD_E_BAD_SEEK		= (080100029h)
SCARD_E_INVALID_CHV		= (08010002Ah)
SCARD_E_UNKNOWN_RES_MNG 	= (08010002Bh)
SCARD_E_NO_SUCH_CERTIFICATE	= (08010002Ch)
SCARD_E_CERTIFICATE_UNAVAILABLE = (08010002Dh)
SCARD_E_NO_READERS_AVAILABLE	= (08010002Eh)
SCARD_W_UNSUPPORTED_CARD	= (080100065h)
SCARD_W_UNRESPONSIVE_CARD	= (080100066h)
SCARD_W_UNPOWERED_CARD		= (080100067h)
SCARD_W_RESET_CARD		= (080100068h)
SCARD_W_REMOVED_CARD		= (080100069h)
SCARD_W_SECURITY_VIOLATION	= (08010006Ah)
SCARD_W_WRONG_CHV		= (08010006Bh)
SCARD_W_CHV_BLOCKED		= (08010006Ch)
SCARD_W_EOF			= (08010006Dh)
SCARD_W_CANCELLED_BY_USER	= (08010006Eh)
