;*************************************************************************
;*									   *
;* wingdi.h -- GDI procedure declarations, constant definitions and macros *
;*									   *
;* Copyright (c) 1985-1998, Microsoft Corp. All rights reserved.	   *
;*									   *
;*************************************************************************

; Binary raster ops
R2_BLACK			= 1   ;  0
R2_NOTMERGEPEN			= 2   ; DPon
R2_MASKNOTPEN			= 3   ; DPna
R2_NOTCOPYPEN			= 4   ; PN
R2_MASKPENNOT			= 5   ; PDna
R2_NOT				= 6   ; Dn
R2_XORPEN			= 7   ; DPx
R2_NOTMASKPEN			= 8   ; DPan
R2_MASKPEN			= 9   ; DPa
R2_NOTXORPEN			= 10  ; DPxn
R2_NOP				= 11  ; D
R2_MERGENOTPEN			= 12  ; DPno
R2_COPYPEN			= 13  ; P
R2_MERGEPENNOT			= 14  ; PDno
R2_MERGEPEN			= 15  ; DPo
R2_WHITE			= 16  ;  1
R2_LAST 			= 16

; Ternary raster operations
SRCCOPY 			= 000CC0020h ; dest = source
SRCPAINT			= 000EE0086h ; dest = source OR dest
SRCAND				= 0008800C6h ; dest = source AND dest
SRCINVERT			= 000660046h ; dest = source XOR dest
SRCERASE			= 000440328h ; dest = source AND (NOT dest )
NOTSRCCOPY			= 000330008h ; dest = (NOT source)
NOTSRCERASE			= 0001100A6h ; dest = (NOT src) AND (NOT dest)
MERGECOPY			= 000C000CAh ; dest = (source AND pattern)
MERGEPAINT			= 000BB0226h ; dest = (NOT source) OR dest
PATCOPY 			= 000F00021h ; dest = pattern
PATPAINT			= 000FB0A09h ; dest = DPSnoo
PATINVERT			= 0005A0049h ; dest = pattern XOR dest
DSTINVERT			= 000550009h ; dest = (NOT dest)
BLACKNESS			= 000000042h ; dest = BLACK
WHITENESS			= 000FF0062h ; dest = WHITE
NOMIRRORBITMAP			= 080000000h ; Do not Mirror the bitmap in this call

GDI_ERROR			= (0FFFFFFFFh)
HGDI_ERROR			= (0FFFFFFFFh)

; Region Flags
ERROR				= 0
NULLREGION			= 1
SIMPLEREGION			= 2
COMPLEXREGION			= 3
RGN_ERROR			= ERROR

; CombineRgn() Styles
RGN_AND 			= 1
RGN_OR				= 2
RGN_XOR 			= 3
RGN_DIFF			= 4
RGN_COPY			= 5
RGN_MIN 			= RGN_AND
RGN_MAX 			= RGN_COPY

; StretchBlt() Modes
BLACKONWHITE			= 1
WHITEONBLACK			= 2
COLORONCOLOR			= 3
HALFTONE			= 4
MAXSTRETCHBLTMODE		= 4

; New StretchBlt() Modes
STRETCH_ANDSCANS		= BLACKONWHITE
STRETCH_ORSCANS 		= WHITEONBLACK
STRETCH_DELETESCANS		= COLORONCOLOR
STRETCH_HALFTONE		= HALFTONE

; PolyFill() Modes
ALTERNATE			= 1
WINDING 			= 2
POLYFILL_LAST			= 2

; Layout Orientation Options
LAYOUT_RTL			= 000000001h ; Right to left
LAYOUT_BTT			= 000000002h ; Bottom to top
LAYOUT_VBH			= 000000004h ; Vertical before horizontal
LAYOUT_ORIENTATIONMASK		= (LAYOUT_RTL + LAYOUT_BTT + LAYOUT_VBH)
LAYOUT_BITMAPORIENTATIONPRESERVED = 000000008h

; Text Alignment Options
TA_NOUPDATECP			= 0
TA_UPDATECP			= 1

TA_LEFT 			= 0
TA_RIGHT			= 2
TA_CENTER			= 6

TA_TOP				= 0
TA_BOTTOM			= 8
TA_BASELINE			= 24
TA_RTLREADING			= 256
TA_MASK 			= (TA_BASELINE+TA_CENTER+TA_UPDATECP+TA_RTLREADING)

VTA_BASELINE			= TA_BASELINE
VTA_LEFT			= TA_BOTTOM
VTA_RIGHT			= TA_TOP
VTA_CENTER			= TA_CENTER
VTA_BOTTOM			= TA_RIGHT
VTA_TOP 			= TA_LEFT

ETO_OPAQUE			= 00002h
ETO_CLIPPED			= 00004h
ETO_GLYPH_INDEX 		= 00010h
ETO_RTLREADING			= 00080h
ETO_NUMERICSLOCAL		= 00400h
ETO_NUMERICSLATIN		= 00800h
ETO_IGNORELANGUAGE		= 01000h
ETO_PDY 			= 02000h

ASPECT_FILTERING		= 00001h

; Bounds Accumulation APIs

DCB_RESET			= 00001h
DCB_ACCUMULATE			= 00002h
DCB_DIRTY			= DCB_ACCUMULATE
DCB_SET 			= (DCB_RESET + DCB_ACCUMULATE)
DCB_ENABLE			= 00004h
DCB_DISABLE			= 00008h

; Metafile Functions
META_SETBKCOLOR 		= 00201h
META_SETBKMODE			= 00102h
META_SETMAPMODE 		= 00103h
META_SETROP2			= 00104h
META_SETRELABS			= 00105h
META_SETPOLYFILLMODE		= 00106h
META_SETSTRETCHBLTMODE		= 00107h
META_SETTEXTCHAREXTRA		= 00108h
META_SETTEXTCOLOR		= 00209h
META_SETTEXTJUSTIFICATION	= 0020Ah
META_SETWINDOWORG		= 0020Bh
META_SETWINDOWEXT		= 0020Ch
META_SETVIEWPORTORG		= 0020Dh
META_SETVIEWPORTEXT		= 0020Eh
META_OFFSETWINDOWORG		= 0020Fh
META_SCALEWINDOWEXT		= 00410h
META_OFFSETVIEWPORTORG		= 00211h
META_SCALEVIEWPORTEXT		= 00412h
META_LINETO			= 00213h
META_MOVETO			= 00214h
META_EXCLUDECLIPRECT		= 00415h
META_INTERSECTCLIPRECT		= 00416h
META_ARC			= 00817h
META_ELLIPSE			= 00418h
META_FLOODFILL			= 00419h
META_PIE			= 0081Ah
META_RECTANGLE			= 0041Bh
META_ROUNDRECT			= 0061Ch
META_PATBLT			= 0061Dh
META_SAVEDC			= 0001Eh
META_SETPIXEL			= 0041Fh
META_OFFSETCLIPRGN		= 00220h
META_TEXTOUT			= 00521h
META_BITBLT			= 00922h
META_STRETCHBLT 		= 00B23h
META_POLYGON			= 00324h
META_POLYLINE			= 00325h
META_ESCAPE			= 00626h
META_RESTOREDC			= 00127h
META_FILLREGION 		= 00228h
META_FRAMEREGION		= 00429h
META_INVERTREGION		= 0012Ah
META_PAINTREGION		= 0012Bh
META_SELECTCLIPREGION		= 0012Ch
META_SELECTOBJECT		= 0012Dh
META_SETTEXTALIGN		= 0012Eh
META_CHORD			= 00830h
META_SETMAPPERFLAGS		= 00231h
META_EXTTEXTOUT 		= 00a32h
META_SETDIBTODEV		= 00d33h
META_SELECTPALETTE		= 00234h
META_REALIZEPALETTE		= 00035h
META_ANIMATEPALETTE		= 00436h
META_SETPALENTRIES		= 00037h
META_POLYPOLYGON		= 00538h
META_RESIZEPALETTE		= 00139h
META_DIBBITBLT			= 00940h
META_DIBSTRETCHBLT		= 00b41h
META_DIBCREATEPATTERNBRUSH	= 00142h
META_STRETCHDIB 		= 00f43h
META_EXTFLOODFILL		= 00548h
META_SETLAYOUT			= 00149h
META_DELETEOBJECT		= 001f0h
META_CREATEPALETTE		= 000f7h
META_CREATEPATTERNBRUSH 	= 001F9h
META_CREATEPENINDIRECT		= 002FAh
META_CREATEFONTINDIRECT 	= 002FBh
META_CREATEBRUSHINDIRECT	= 002FCh
META_CREATEREGION		= 006FFh

struc	DRAWPATRECT
	ptPosition		POINT ?
	ptSize			POINT ?
	wStyle			dw ?
	wPattern		dw ?
ends

; GDI Escapes
NEWFRAME			= 1
ABORTDOC			= 2
NEXTBAND			= 3
SETCOLORTABLE			= 4
GETCOLORTABLE			= 5
FLUSHOUTPUT			= 6
DRAFTMODE			= 7
QUERYESCSUPPORT 		= 8
SETABORTPROC			= 9
STARTDOC			= 10
ENDDOC				= 11
GETPHYSPAGESIZE 		= 12
GETPRINTINGOFFSET		= 13
GETSCALINGFACTOR		= 14
MFCOMMENT			= 15
GETPENWIDTH			= 16
SETCOPYCOUNT			= 17
SELECTPAPERSOURCE		= 18
DEVICEDATA			= 19
PASSTHROUGH			= 19
GETTECHNOLGY			= 20
GETTECHNOLOGY			= 20
SETLINECAP			= 21
SETLINEJOIN			= 22
SETMITERLIMIT			= 23
BANDINFO			= 24
DRAWPATTERNRECT 		= 25
GETVECTORPENSIZE		= 26
GETVECTORBRUSHSIZE		= 27
ENABLEDUPLEX			= 28
GETSETPAPERBINS 		= 29
GETSETPRINTORIENT		= 30
ENUMPAPERBINS			= 31
SETDIBSCALING			= 32
EPSPRINTING			= 33
ENUMPAPERMETRICS		= 34
GETSETPAPERMETRICS		= 35
POSTSCRIPT_DATA 		= 37
POSTSCRIPT_IGNORE		= 38
MOUSETRAILS			= 39
GETDEVICEUNITS			= 42

GETEXTENDEDTEXTMETRICS		= 256
GETEXTENTTABLE			= 257
GETPAIRKERNTABLE		= 258
GETTRACKKERNTABLE		= 259
EXTTEXTOUT			= 512
GETFACENAME			= 513
DOWNLOADFACE			= 514
ENABLERELATIVEWIDTHS		= 768
ENABLEPAIRKERNING		= 769
SETKERNTRACK			= 770
SETALLJUSTVALUES		= 771
SETCHARSET			= 772

STRETCHBLT			= 2048
GETSETSCREENPARAMS		= 3072
QUERYDIBSUPPORT 		= 3073
BEGIN_PATH			= 4096
CLIP_TO_PATH			= 4097
END_PATH			= 4098
EXT_DEVICE_CAPS 		= 4099
RESTORE_CTM			= 4100
SAVE_CTM			= 4101
SET_ARC_DIRECTION		= 4102
SET_BACKGROUND_COLOR		= 4103
SET_POLY_MODE			= 4104
SET_SCREEN_ANGLE		= 4105
SET_SPREAD			= 4106
TRANSFORM_CTM			= 4107
SET_CLIP_BOX			= 4108
SET_BOUNDS			= 4109
SET_MIRROR_MODE 		= 4110
OPENCHANNEL			= 4110
DOWNLOADHEADER			= 4111
CLOSECHANNEL			= 4112
POSTSCRIPT_PASSTHROUGH		= 4115
ENCAPSULATED_POSTSCRIPT 	= 4116

POSTSCRIPT_IDENTIFY		= 4117	 ; new escape for NT5 pscript driver
POSTSCRIPT_INJECTION		= 4118	 ; new escape for NT5 pscript driver

CHECKJPEGFORMAT 		= 4119
CHECKPNGFORMAT			= 4120

GET_PS_FEATURESETTING		= 4121	 ; new escape for NT5 pscript driver

;
; Parameters for POSTSCRIPT_IDENTIFY escape
;

PSIDENT_GDICENTRIC		= 0
PSIDENT_PSCENTRIC		= 1

;
; Header structure for the input buffer to POSTSCRIPT_INJECTION escape
;

struc	PSINJECTDATA
	DataBytes		dd ?		; number of raw data bytes (NOT including this header)
	InjectionPoint		dw ?		; injection point
	PageNumber		dw ?		; page number to apply the injection  ; Followed by raw data to be injected
ends

;
; Constants for PSINJECTDATA.InjectionPoint field
;

PSINJECT_BEGINSTREAM		= 1
PSINJECT_PSADOBE		= 2
PSINJECT_PAGESATEND		= 3
PSINJECT_PAGES			= 4

PSINJECT_DOCNEEDEDRES		= 5
PSINJECT_DOCSUPPLIEDRES 	= 6
PSINJECT_PAGEORDER		= 7
PSINJECT_ORIENTATION		= 8
PSINJECT_BOUNDINGBOX		= 9
PSINJECT_DOCUMENTPROCESSCOLORS	= 10

PSINJECT_COMMENTS		= 11
PSINJECT_BEGINDEFAULTS		= 12
PSINJECT_ENDDEFAULTS		= 13
PSINJECT_BEGINPROLOG		= 14
PSINJECT_ENDPROLOG		= 15
PSINJECT_BEGINSETUP		= 16
PSINJECT_ENDSETUP		= 17
PSINJECT_TRAILER		= 18
PSINJECT_EOF			= 19
PSINJECT_ENDSTREAM		= 20
PSINJECT_DOCUMENTPROCESSCOLORSATEND = 21

PSINJECT_PAGENUMBER		= 100
PSINJECT_BEGINPAGESETUP 	= 101
PSINJECT_ENDPAGESETUP		= 102
PSINJECT_PAGETRAILER		= 103
PSINJECT_PLATECOLOR		= 104

PSINJECT_SHOWPAGE		= 105
PSINJECT_PAGEBBOX		= 106
PSINJECT_ENDPAGECOMMENTS	= 107

PSINJECT_VMSAVE 		= 200
PSINJECT_VMRESTORE		= 201

;
; Parameter for GET_PS_FEATURESETTING escape
;

FEATURESETTING_NUP		= 0
FEATURESETTING_OUTPUT		= 1
FEATURESETTING_PSLEVEL		= 2
FEATURESETTING_CUSTPAPER	= 3

;
; Information about output options
;

struc	PSFEATURE_OUTPUT
	bPageIndependent	dd ?
	bSetPageDevice		dd ?
ends

;
; Information about custom paper size
;

struc	PSFEATURE_CUSTPAPER
	lOrientation		dd ?
	lWidth			dd ?
	lHeight 		dd ?
	lWidthOffset		dd ?
	lHeightOffset		dd ?
ends

; Flag returned from QUERYDIBSUPPORT
QDI_SETDIBITS			= 1
QDI_GETDIBITS			= 2
QDI_DIBTOSCREEN 		= 4
QDI_STRETCHDIB			= 8

; Spooler Error Codes
SP_NOTREPORTED			= 04000h
SP_ERROR			= (-1)
SP_APPABORT			= (-2)
SP_USERABORT			= (-3)
SP_OUTOFDISK			= (-4)
SP_OUTOFMEMORY			= (-5)

PR_JOBSTATUS			= 00000h

; Object Definitions for EnumObjects()
OBJ_PEN 			= 1
OBJ_BRUSH			= 2
OBJ_DC				= 3
OBJ_METADC			= 4
OBJ_PAL 			= 5
OBJ_FONT			= 6
OBJ_BITMAP			= 7
OBJ_REGION			= 8
OBJ_METAFILE			= 9
OBJ_MEMDC			= 10
OBJ_EXTPEN			= 11
OBJ_ENHMETADC			= 12
OBJ_ENHMETAFILE 		= 13

; xform stuff
MWT_IDENTITY			= 1
MWT_LEFTMULTIPLY		= 2
MWT_RIGHTMULTIPLY		= 3

MWT_MIN 			= MWT_IDENTITY
MWT_MAX 			= MWT_RIGHTMULTIPLY

struc	XFORM
	eM11			dd ?
	eM12			dd ?
	eM21			dd ?
	eM22			dd ?
	eDx			dd ?
	eDy			dd ?
ends

; Bitmap Header Definition

struc	BITMAP
	bmType			dd ?
	bmWidth 		dd ?
	bmHeight		dd ?
	bmWidthBytes		dd ?
	bmPlanes		dw ?
	bmBitsPixel		dw ?
	bmBits			dd ?
ends

struc	RGBTRIPLE
	rgbtBlue		db ?
	rgbtGreen		db ?
	rgbtRed 		db ?
ends

struc	RGBQUAD
	rgbBlue 		db ?
	rgbGreen		db ?
	rgbRed			db ?
	rgbReserved		db ?
ends

; Image Color Matching color definitions

CS_ENABLE			= 000000001h
CS_DISABLE			= 000000002h
CS_DELETE_TRANSFORM		= 000000003h

; Logcolorspace signature

LCS_SIGNATURE			= 'PSOC'

; Logcolorspace lcsType values

LCS_sRGB			= 'sRGB'
LCS_WINDOWS_COLOR_SPACE 	= 'Win '  ; Windows default color space

LCS_CALIBRATED_RGB		= 000000000h

LCS_GM_BUSINESS 		= 000000001h
LCS_GM_GRAPHICS 		= 000000002h
LCS_GM_IMAGES			= 000000004h
LCS_GM_ABS_COLORIMETRIC 	= 000000008h

; ICM Defines for results from CheckColorInGamut()
CM_OUT_OF_GAMUT 		= 255
CM_IN_GAMUT			= 0

; UpdateICMRegKey Constants
ICM_ADDPROFILE			= 1
ICM_DELETEPROFILE		= 2
ICM_QUERYPROFILE		= 3
ICM_SETDEFAULTPROFILE		= 4
ICM_REGISTERICMATCHER		= 5
ICM_UNREGISTERICMATCHER 	= 6
ICM_QUERYMATCH			= 7

; ICM Color Definitions
; The following two structures are used for defining RGB's in terms of CIEXYZ.

struc	CIEXYZ
	ciexyzX 		dd ?
	ciexyzY 		dd ?
	ciexyzZ 		dd ?
ends

struc	CIEXYZTRIPLE
	ciexyzRed		CIEXYZ ?
	ciexyzGreen		CIEXYZ ?
	ciexyzBlue		CIEXYZ ?
ends

; The next structures the logical color space. Unlike pens and brushes,
; but like palettes, there is only one way to create a LogColorSpace.
; A pointer to it must be passed, its elements can't be pushed as
; arguments.

struc	LOGCOLORSPACE
	lcsSignature		dd ?
	lcsVersion		dd ?
	lcsSize 		dd ?
	lcsCSType		dd ?
	lcsIntent		dd ?
	lcsEndpoints		CIEXYZTRIPLE ?
	lcsGammaRed		dd ?
	lcsGammaGreen		dd ?
	lcsGammaBlue		dd ?
	lcsFilename		db MAX_PATH dup (?)
ends

; structures for defining DIBs

struc	BITMAPCOREHEADER
	bcSize			dd ?		; used to get to color table
	bcWidth 		dw ?
	bcHeight		dw ?
	bcPlanes		dw ?
	bcBitCount		dw ?
ends

struc	BITMAPINFOHEADER
	biSize			dd ?
	biWidth 		dd ?
	biHeight		dd ?
	biPlanes		dw ?
	biBitCount		dw ?
	biCompression		dd ?
	biSizeImage		dd ?
	biXPelsPerMeter 	dd ?
	biYPelsPerMeter 	dd ?
	biClrUsed		dd ?
	biClrImportant		dd ?
ends

struc	BITMAPV4HEADER
	bV4Size 		dd ?
	bV4Width		dd ?
	bV4Height		dd ?
	bV4Planes		dw ?
	bV4BitCount		dw ?
	bV4V4Compression	dd ?
	bV4SizeImage		dd ?
	bV4XPelsPerMeter	dd ?
	bV4YPelsPerMeter	dd ?
	bV4ClrUsed		dd ?
	bV4ClrImportant 	dd ?
	bV4RedMask		dd ?
	bV4GreenMask		dd ?
	bV4BlueMask		dd ?
	bV4AlphaMask		dd ?
	bV4CSType		dd ?
	bV4Endpoints		CIEXYZTRIPLE ?
	bV4GammaRed		dd ?
	bV4GammaGreen		dd ?
	bV4GammaBlue		dd ?
ends

struc	BITMAPV5HEADER
	bV5Size 		dd ?
	bV5Width		dd ?
	bV5Height		dd ?
	bV5Planes		dw ?
	bV5BitCount		dw ?
	bV5Compression		dd ?
	bV5SizeImage		dd ?
	bV5XPelsPerMeter	dd ?
	bV5YPelsPerMeter	dd ?
	bV5ClrUsed		dd ?
	bV5ClrImportant 	dd ?
	bV5RedMask		dd ?
	bV5GreenMask		dd ?
	bV5BlueMask		dd ?
	bV5AlphaMask		dd ?
	bV5CSType		dd ?
	bV5Endpoints		CIEXYZTRIPLE ?
	bV5GammaRed		dd ?
	bV5GammaGreen		dd ?
	bV5GammaBlue		dd ?
	bV5Intent		dd ?
	bV5ProfileData		dd ?
	bV5ProfileSize		dd ?
	bV5Reserved		dd ?
ends

; Values for bV5CSType
PROFILE_LINKED			= 'LINK'
PROFILE_EMBEDDED		= 'MBED'

; constants for the biCompression field
BI_RGB				= 0
BI_RLE8 			= 1
BI_RLE4 			= 2
BI_BITFIELDS			= 3
BI_JPEG 			= 4
BI_PNG				= 5

struc	BITMAPINFO
	bmiHeader		BITMAPINFOHEADER ?
label	bmiColors		RGBQUAD
ends

struc	BITMAPCOREINFO
	bmciHeader		BITMAPCOREHEADER ?
label	bmciColors		RGBTRIPLE
ends

struc	BITMAPFILEHEADER
	bfType			dw ?
	bfSize			dd ?
	bfReserved1		dw ?
	bfReserved2		dw ?
	bfOffBits		dd ?
ends

struc	FONTSIGNATURE
	fsUsb			dd 4 dup (?)
	fsCsb			dd 2 dup (?)
ends

struc	CHARSETINFO
	ciCharset		dd ?
	ciACP			dd ?
	fs			FONTSIGNATURE ?
ends

TCI_SRCCHARSET			= 1
TCI_SRCCODEPAGE 		= 2
TCI_SRCFONTSIG			= 3

struc	LOCALESIGNATURE
	lsUsb			dd 4 dup (?)
	lsCsbDefault		dd 2 dup (?)
	lsCsbSupported		dd 2 dup (?)
ends

; Clipboard Metafile Picture Structure

struc	HANDLETABLE
label	objectHandle		dword
ends

struc	METARECORD
	rdSize			dd ?
	rdFunction		dw ?
label	rdParm			word
ends

struc	METAFILEPICT
	mm			dd ?
	xExt			dd ?
	yExt			dd ?
	hMF			dd ?
ends

struc	METAHEADER
	mtType			dw ?
	mtHeaderSize		dw ?
	mtVersion		dw ?
	mtSize			dd ?
	mtNoObjects		dw ?
	mtMaxRecord		dd ?
	mtNoParameters		dw ?
ends

; Enhanced Metafile structures

struc	ENHMETARECORD
	iType			dd ?		; Record type EMR_XXX
	nSize			dd ?		; Record size in bytes
label	dParm			dword		; Parameters
ends

struc	ENHMETAHEADER
	iType			dd ?		; Record type EMR_HEADER
	nSize			dd ?		; Record size in bytes.  This may be greater ; than the sizeof(ENHMETAHEADER).
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	rclFrame		RECTL ? 	; Inclusive-inclusive Picture Frame of metafile in .01 mm units
	dSignature		dd ?		; Signature.  Must be ENHMETA_SIGNATURE.
	nVersion		dd ?		; Version number
	nBytes			dd ?		; Size of the metafile in bytes
	nRecords		dd ?		; Number of records in the metafile
	nHandles		dw ?		; Number of handles in the handle table ; Handle index zero is reserved.
	sReserved		dw ?		; Reserved.  Must be zero.
	nDescription		dd ?		; Number of chars in the unicode description string ; This is 0 if there is no description string
	offDescription		dd ?		; Offset to the metafile description record. ; This is 0 if there is no description string
	nPalEntries		dd ?		; Number of entries in the metafile palette.
	szlDevice		SIZEL ? 	; Size of the reference device in pels
	szlMillimeters		SIZEL ? 	; Size of the reference device in millimeters
	cbPixelFormat		dd ?		; Size of PIXELFORMATDESCRIPTOR information ; This is 0 if no pixel format is set
	offPixelFormat		dd ?		; Offset to PIXELFORMATDESCRIPTOR ; This is 0 if no pixel format is set
	bOpenGL 		dd ?		; TRUE if OpenGL commands are present in ; the metafile, otherwise FALSE
ends

; tmPitchAndFamily flags
TMPF_FIXED_PITCH		= 001h
TMPF_VECTOR			= 002h
TMPF_DEVICE			= 008h
TMPF_TRUETYPE			= 004h

struc	TEXTMETRIC
	tmHeight		dd ?
	tmAscent		dd ?
	tmDescent		dd ?
	tmInternalLeading	dd ?
	tmExternalLeading	dd ?
	tmAveCharWidth		dd ?
	tmMaxCharWidth		dd ?
	tmWeight		dd ?
	tmOverhang		dd ?
	tmDigitizedAspectX	dd ?
	tmDigitizedAspectY	dd ?
	tmFirstChar		db ?
	tmLastChar		db ?
	tmDefaultChar		db ?
	tmBreakChar		db ?
	tmItalic		db ?
	tmUnderlined		db ?
	tmStruckOut		db ?
	tmPitchAndFamily	db ?
	tmCharSet		db ?
ends

; ntmFlags field flags
NTM_REGULAR			= 000000040h
NTM_BOLD			= 000000020h
NTM_ITALIC			= 000000001h

; new in NT 5.0

NTM_NONNEGATIVE_AC		= 000010000h
NTM_PS_OPENTYPE 		= 000020000h
NTM_TT_OPENTYPE 		= 000040000h
NTM_MULTIPLEMASTER		= 000080000h
NTM_TYPE1			= 000100000h
NTM_DSIG			= 000200000h

struc	NEWTEXTMETRIC
	tmHeight		dd ?
	tmAscent		dd ?
	tmDescent		dd ?
	tmInternalLeading	dd ?
	tmExternalLeading	dd ?
	tmAveCharWidth		dd ?
	tmMaxCharWidth		dd ?
	tmWeight		dd ?
	tmOverhang		dd ?
	tmDigitizedAspectX	dd ?
	tmDigitizedAspectY	dd ?
	tmFirstChar		db ?
	tmLastChar		db ?
	tmDefaultChar		db ?
	tmBreakChar		db ?
	tmItalic		db ?
	tmUnderlined		db ?
	tmStruckOut		db ?
	tmPitchAndFamily	db ?
	tmCharSet		db ?
	ntmFlags		dd ?
	ntmSizeEM		dd ?
	ntmCellHeight		dd ?
	ntmAvgWidth		dd ?
ends

struc	NEWTEXTMETRICEX
	ntmTm			NEWTEXTMETRIC ?
	ntmFontSig		FONTSIGNATURE ?
ends

; GDI Logical Objects:

; Pel Array

struc	PELARRAY
	paXCount		dd ?
	paYCount		dd ?
	paXExt			dd ?
	paYExt			dd ?
	paRGBs			db ?
ends

; Logical Brush (or Pattern)

struc	LOGBRUSH
	lbStyle 		dd ?
	lbColor 		dd ?
	lbHatch 		dd ?	 ; Sundown: lbHatch could hold a HANDLE
ends

; Logical Pen

struc	LOGPEN
	lopnStyle		dd ?
	lopnWidth		POINT ?
	lopnColor		dd ?
ends

struc	EXTLOGPEN
	elpPenStyle		dd ?
	elpWidth		dd ?
	elpBrushStyle		dd ?
	elpColor		dd ?
	elpHatch		dd ?	 ;Sundown: elpHatch could take a HANDLE
	elpNumEntries		dd ?
label	elpStyleEntry		dword
ends

struc	PALETTEENTRY
	peRed			db ?
	peGreen 		db ?
	peBlue			db ?
	peFlags 		db ?
ends

; Logical Palette

struc	LOGPALETTE
	palVersion		dw ?
	palNumEntries		dw ?
label	palPalEntry		PALETTEENTRY
ends

; Logical Font
LF_FACESIZE			= 32

struc	LOGFONT
	lfHeight		dd ?
	lfWidth 		dd ?
	lfEscapement		dd ?
	lfOrientation		dd ?
	lfWeight		dd ?
	lfItalic		db ?
	lfUnderline		db ?
	lfStrikeOut		db ?
	lfCharSet		db ?
	lfOutPrecision		db ?
	lfClipPrecision 	db ?
	lfQuality		db ?
	lfPitchAndFamily	db ?
	lfFaceName		db LF_FACESIZE dup (?)
ends

LF_FULLFACESIZE 		= 64

; Structure passed to FONTENUMPROC

struc	ENUMLOGFONT
	elfLogFont		LOGFONT ?
	elfFullName		db LF_FULLFACESIZE dup (?)
	elfStyle		db LF_FACESIZE dup (?)
ends

struc	ENUMLOGFONTEX
	elfLogFont		LOGFONT ?
	elfFullName		db LF_FULLFACESIZE dup (?)
	elfStyle		db LF_FACESIZE dup (?)
	elfScript		db LF_FACESIZE dup (?)
ends

OUT_DEFAULT_PRECIS		= 0
OUT_STRING_PRECIS		= 1
OUT_CHARACTER_PRECIS		= 2
OUT_STROKE_PRECIS		= 3
OUT_TT_PRECIS			= 4
OUT_DEVICE_PRECIS		= 5
OUT_RASTER_PRECIS		= 6
OUT_TT_ONLY_PRECIS		= 7
OUT_OUTLINE_PRECIS		= 8
OUT_SCREEN_OUTLINE_PRECIS	= 9
OUT_PS_ONLY_PRECIS		= 10

CLIP_DEFAULT_PRECIS		= 0
CLIP_CHARACTER_PRECIS		= 1
CLIP_STROKE_PRECIS		= 2
CLIP_MASK			= 0h
CLIP_LH_ANGLES			= (1 shl 4)
CLIP_TT_ALWAYS			= (2 shl 4)
CLIP_EMBEDDED			= (8 shl 4)

DEFAULT_QUALITY 		= 0
DRAFT_QUALITY			= 1
PROOF_QUALITY			= 2
NONANTIALIASED_QUALITY		= 3
ANTIALIASED_QUALITY		= 4

DEFAULT_PITCH			= 0
FIXED_PITCH			= 1
VARIABLE_PITCH			= 2
MONO_FONT			= 8

ANSI_CHARSET			= 0
DEFAULT_CHARSET 		= 1
SYMBOL_CHARSET			= 2
SHIFTJIS_CHARSET		= 128
HANGEUL_CHARSET 		= 129
HANGUL_CHARSET			= 129
GB2312_CHARSET			= 134
CHINESEBIG5_CHARSET		= 136
OEM_CHARSET			= 255
JOHAB_CHARSET			= 130
HEBREW_CHARSET			= 177
ARABIC_CHARSET			= 178
GREEK_CHARSET			= 161
TURKISH_CHARSET 		= 162
VIETNAMESE_CHARSET		= 163
THAI_CHARSET			= 222
EASTEUROPE_CHARSET		= 238
RUSSIAN_CHARSET 		= 204

MAC_CHARSET			= 77
BALTIC_CHARSET			= 186

FS_LATIN1			= 000000001h
FS_LATIN2			= 000000002h
FS_CYRILLIC			= 000000004h
FS_GREEK			= 000000008h
FS_TURKISH			= 000000010h
FS_HEBREW			= 000000020h
FS_ARABIC			= 000000040h
FS_BALTIC			= 000000080h
FS_VIETNAMESE			= 000000100h
FS_THAI 			= 000010000h
FS_JISJAPAN			= 000020000h
FS_CHINESESIMP			= 000040000h
FS_WANSUNG			= 000080000h
FS_CHINESETRAD			= 000100000h
FS_JOHAB			= 000200000h
FS_SYMBOL			= 080000000h

; Font Families
FF_DONTCARE			= (0 shl 4)  ; Don't care or don't know.
FF_ROMAN			= (1 shl 4)  ; Variable stroke width, serifed.
					  ; Times Roman, Century Schoolbook, etc.
FF_SWISS			= (2 shl 4)  ; Variable stroke width, sans-serifed.
					  ; Helvetica, Swiss, etc.
FF_MODERN			= (3 shl 4)  ; Constant stroke width, serifed or sans-serifed.
					  ; Pica, Elite, Courier, etc.
FF_SCRIPT			= (4 shl 4)  ; Cursive, etc.
FF_DECORATIVE			= (5 shl 4)  ; Old English, etc.

; Font Weights
FW_DONTCARE			= 0
FW_THIN 			= 100
FW_EXTRALIGHT			= 200
FW_LIGHT			= 300
FW_NORMAL			= 400
FW_MEDIUM			= 500
FW_SEMIBOLD			= 600
FW_BOLD 			= 700
FW_EXTRABOLD			= 800
FW_HEAVY			= 900

FW_ULTRALIGHT			= FW_EXTRALIGHT
FW_REGULAR			= FW_NORMAL
FW_DEMIBOLD			= FW_SEMIBOLD
FW_ULTRABOLD			= FW_EXTRABOLD
FW_BLACK			= FW_HEAVY

PANOSE_COUNT			= 10
PAN_FAMILYTYPE_INDEX		= 0
PAN_SERIFSTYLE_INDEX		= 1
PAN_WEIGHT_INDEX		= 2
PAN_PROPORTION_INDEX		= 3
PAN_CONTRAST_INDEX		= 4
PAN_STROKEVARIATION_INDEX	= 5
PAN_ARMSTYLE_INDEX		= 6
PAN_LETTERFORM_INDEX		= 7
PAN_MIDLINE_INDEX		= 8
PAN_XHEIGHT_INDEX		= 9

PAN_CULTURE_LATIN		= 0

struc	PANOSE
	bFamilyType		db ?
	bSerifStyle		db ?
	bWeight 		db ?
	bProportion		db ?
	bContrast		db ?
	bStrokeVariation	db ?
	bArmStyle		db ?
	bLetterform		db ?
	bMidline		db ?
	bXHeight		db ?
ends

PAN_ANY 			= 0 ; Any
PAN_NO_FIT			= 1 ; No Fit

PAN_FAMILY_TEXT_DISPLAY 	= 2 ; Text and Display
PAN_FAMILY_SCRIPT		= 3 ; Script
PAN_FAMILY_DECORATIVE		= 4 ; Decorative
PAN_FAMILY_PICTORIAL		= 5 ; Pictorial

PAN_SERIF_COVE			= 2 ; Cove
PAN_SERIF_OBTUSE_COVE		= 3 ; Obtuse Cove
PAN_SERIF_SQUARE_COVE		= 4 ; Square Cove
PAN_SERIF_OBTUSE_SQUARE_COVE	= 5 ; Obtuse Square Cove
PAN_SERIF_SQUARE		= 6 ; Square
PAN_SERIF_THIN			= 7 ; Thin
PAN_SERIF_BONE			= 8 ; Bone
PAN_SERIF_EXAGGERATED		= 9 ; Exaggerated
PAN_SERIF_TRIANGLE		= 10 ; Triangle
PAN_SERIF_NORMAL_SANS		= 11 ; Normal Sans
PAN_SERIF_OBTUSE_SANS		= 12 ; Obtuse Sans
PAN_SERIF_PERP_SANS		= 13 ; Prep Sans
PAN_SERIF_FLARED		= 14 ; Flared
PAN_SERIF_ROUNDED		= 15 ; Rounded

PAN_WEIGHT_VERY_LIGHT		= 2 ; Very Light
PAN_WEIGHT_LIGHT		= 3 ; Light
PAN_WEIGHT_THIN 		= 4 ; Thin
PAN_WEIGHT_BOOK 		= 5 ; Book
PAN_WEIGHT_MEDIUM		= 6 ; Medium
PAN_WEIGHT_DEMI 		= 7 ; Demi
PAN_WEIGHT_BOLD 		= 8 ; Bold
PAN_WEIGHT_HEAVY		= 9 ; Heavy
PAN_WEIGHT_BLACK		= 10 ; Black
PAN_WEIGHT_NORD 		= 11 ; Nord

PAN_PROP_OLD_STYLE		= 2 ; Old Style
PAN_PROP_MODERN 		= 3 ; Modern
PAN_PROP_EVEN_WIDTH		= 4 ; Even Width
PAN_PROP_EXPANDED		= 5 ; Expanded
PAN_PROP_CONDENSED		= 6 ; Condensed
PAN_PROP_VERY_EXPANDED		= 7 ; Very Expanded
PAN_PROP_VERY_CONDENSED 	= 8 ; Very Condensed
PAN_PROP_MONOSPACED		= 9 ; Monospaced

PAN_CONTRAST_NONE		= 2 ; None
PAN_CONTRAST_VERY_LOW		= 3 ; Very Low
PAN_CONTRAST_LOW		= 4 ; Low
PAN_CONTRAST_MEDIUM_LOW 	= 5 ; Medium Low
PAN_CONTRAST_MEDIUM		= 6 ; Medium
PAN_CONTRAST_MEDIUM_HIGH	= 7 ; Mediim High
PAN_CONTRAST_HIGH		= 8 ; High
PAN_CONTRAST_VERY_HIGH		= 9 ; Very High

PAN_STROKE_GRADUAL_DIAG 	= 2 ; Gradual/Diagonal
PAN_STROKE_GRADUAL_TRAN 	= 3 ; Gradual/Transitional
PAN_STROKE_GRADUAL_VERT 	= 4 ; Gradual/Vertical
PAN_STROKE_GRADUAL_HORZ 	= 5 ; Gradual/Horizontal
PAN_STROKE_RAPID_VERT		= 6 ; Rapid/Vertical
PAN_STROKE_RAPID_HORZ		= 7 ; Rapid/Horizontal
PAN_STROKE_INSTANT_VERT 	= 8 ; Instant/Vertical

PAN_STRAIGHT_ARMS_HORZ		= 2 ; Straight Arms/Horizontal
PAN_STRAIGHT_ARMS_WEDGE 	= 3 ; Straight Arms/Wedge
PAN_STRAIGHT_ARMS_VERT		= 4 ; Straight Arms/Vertical
PAN_STRAIGHT_ARMS_SINGLE_SERIF	= 5 ; Straight Arms/Single-Serif
PAN_STRAIGHT_ARMS_DOUBLE_SERIF	= 6 ; Straight Arms/Double-Serif
PAN_BENT_ARMS_HORZ		= 7 ; Non-Straight Arms/Horizontal
PAN_BENT_ARMS_WEDGE		= 8 ; Non-Straight Arms/Wedge
PAN_BENT_ARMS_VERT		= 9 ; Non-Straight Arms/Vertical
PAN_BENT_ARMS_SINGLE_SERIF	= 10 ; Non-Straight Arms/Single-Serif
PAN_BENT_ARMS_DOUBLE_SERIF	= 11 ; Non-Straight Arms/Double-Serif

PAN_LETT_NORMAL_CONTACT 	= 2 ; Normal/Contact
PAN_LETT_NORMAL_WEIGHTED	= 3 ; Normal/Weighted
PAN_LETT_NORMAL_BOXED		= 4 ; Normal/Boxed
PAN_LETT_NORMAL_FLATTENED	= 5 ; Normal/Flattened
PAN_LETT_NORMAL_ROUNDED 	= 6 ; Normal/Rounded
PAN_LETT_NORMAL_OFF_CENTER	= 7 ; Normal/Off Center
PAN_LETT_NORMAL_SQUARE		= 8 ; Normal/Square
PAN_LETT_OBLIQUE_CONTACT	= 9 ; Oblique/Contact
PAN_LETT_OBLIQUE_WEIGHTED	= 10 ; Oblique/Weighted
PAN_LETT_OBLIQUE_BOXED		= 11 ; Oblique/Boxed
PAN_LETT_OBLIQUE_FLATTENED	= 12 ; Oblique/Flattened
PAN_LETT_OBLIQUE_ROUNDED	= 13 ; Oblique/Rounded
PAN_LETT_OBLIQUE_OFF_CENTER	= 14 ; Oblique/Off Center
PAN_LETT_OBLIQUE_SQUARE 	= 15 ; Oblique/Square

PAN_MIDLINE_STANDARD_TRIMMED	= 2 ; Standard/Trimmed
PAN_MIDLINE_STANDARD_POINTED	= 3 ; Standard/Pointed
PAN_MIDLINE_STANDARD_SERIFED	= 4 ; Standard/Serifed
PAN_MIDLINE_HIGH_TRIMMED	= 5 ; High/Trimmed
PAN_MIDLINE_HIGH_POINTED	= 6 ; High/Pointed
PAN_MIDLINE_HIGH_SERIFED	= 7 ; High/Serifed
PAN_MIDLINE_CONSTANT_TRIMMED	= 8 ; Constant/Trimmed
PAN_MIDLINE_CONSTANT_POINTED	= 9 ; Constant/Pointed
PAN_MIDLINE_CONSTANT_SERIFED	= 10 ; Constant/Serifed
PAN_MIDLINE_LOW_TRIMMED 	= 11 ; Low/Trimmed
PAN_MIDLINE_LOW_POINTED 	= 12 ; Low/Pointed
PAN_MIDLINE_LOW_SERIFED 	= 13 ; Low/Serifed

PAN_XHEIGHT_CONSTANT_SMALL	= 2 ; Constant/Small
PAN_XHEIGHT_CONSTANT_STD	= 3 ; Constant/Standard
PAN_XHEIGHT_CONSTANT_LARGE	= 4 ; Constant/Large
PAN_XHEIGHT_DUCKING_SMALL	= 5 ; Ducking/Small
PAN_XHEIGHT_DUCKING_STD 	= 6 ; Ducking/Standard
PAN_XHEIGHT_DUCKING_LARGE	= 7 ; Ducking/Large

ELF_VENDOR_SIZE 		= 4

; The extended logical font
; An extension of the ENUMLOGFONT

struc	EXTLOGFONT
	elfLogFont		LOGFONT ?
	elfFullName		db LF_FULLFACESIZE dup (?)
	elfStyle		db LF_FACESIZE dup (?)
	elfVersion		dd ?		; 0 for the first release of NT
	elfStyleSize		dd ?
	elfMatch		dd ?
	elfReserved		dd ?
	elfVendorId		db ELF_VENDOR_SIZE dup (?)
	elfCulture		dd ?		; 0 for Latin
	elfPanose		PANOSE ?
ends

ELF_VERSION			= 0
ELF_CULTURE_LATIN		= 0

; EnumFonts Masks
RASTER_FONTTYPE 		= 00001h
DEVICE_FONTTYPE 		= 0002h
TRUETYPE_FONTTYPE		= 0004h

; palette entry flags

PC_RESERVED			= 001h	  ; palette index used for animation
PC_EXPLICIT			= 002h	  ; palette index is explicit to device
PC_NOCOLLAPSE			= 004h	  ; do not match color to system palette

; Background Modes
TRANSPARENT			= 1
OPAQUE				= 2
BKMODE_LAST			= 2

; Graphics Modes

GM_COMPATIBLE			= 1
GM_ADVANCED			= 2
GM_LAST 			= 2

; PolyDraw and GetPath point types
PT_CLOSEFIGURE			= 001h
PT_LINETO			= 002h
PT_BEZIERTO			= 004h
PT_MOVETO			= 006h

; Mapping Modes
MM_TEXT 			= 1
MM_LOMETRIC			= 2
MM_HIMETRIC			= 3
MM_LOENGLISH			= 4
MM_HIENGLISH			= 5
MM_TWIPS			= 6
MM_ISOTROPIC			= 7
MM_ANISOTROPIC			= 8

; Min and Max Mapping Mode values
MM_MIN				= MM_TEXT
MM_MAX				= MM_ANISOTROPIC
MM_MAX_FIXEDSCALE		= MM_TWIPS

; Coordinate Modes
ABSOLUTE			= 1
RELATIVE			= 2

; Stock Logical Objects
WHITE_BRUSH			= 0
LTGRAY_BRUSH			= 1
GRAY_BRUSH			= 2
DKGRAY_BRUSH			= 3
BLACK_BRUSH			= 4
NULL_BRUSH			= 5
HOLLOW_BRUSH			= NULL_BRUSH
WHITE_PEN			= 6
BLACK_PEN			= 7
NULL_PEN			= 8
OEM_FIXED_FONT			= 10
ANSI_FIXED_FONT 		= 11
ANSI_VAR_FONT			= 12
SYSTEM_FONT			= 13
DEVICE_DEFAULT_FONT		= 14
DEFAULT_PALETTE 		= 15
SYSTEM_FIXED_FONT		= 16
DEFAULT_GUI_FONT		= 17
DC_BRUSH			= 18
DC_PEN				= 19

STOCK_LAST			= 19

CLR_INVALID			= 0FFFFFFFFh

; Brush Styles
BS_SOLID			= 0
BS_NULL 			= 1
BS_HOLLOW			= BS_NULL
BS_HATCHED			= 2
BS_PATTERN			= 3
BS_INDEXED			= 4
BS_DIBPATTERN			= 5
BS_DIBPATTERNPT 		= 6
BS_PATTERN8X8			= 7
BS_DIBPATTERN8X8		= 8
BS_MONOPATTERN			= 9

; Hatch Styles
HS_HORIZONTAL			= 0	  ; -----
HS_VERTICAL			= 1	  ; |||||
HS_FDIAGONAL			= 2	  ; \\\\\
HS_BDIAGONAL			= 3	  ; /////
HS_CROSS			= 4	  ; +++++
HS_DIAGCROSS			= 5	  ; xxxxx

; Pen Styles
PS_SOLID			= 0
PS_DASH 			= 1	  ; -------
PS_DOT				= 2	  ; .......
PS_DASHDOT			= 3	  ; _._._._
PS_DASHDOTDOT			= 4	  ; _.._.._
PS_NULL 			= 5
PS_INSIDEFRAME			= 6
PS_USERSTYLE			= 7
PS_ALTERNATE			= 8
PS_STYLE_MASK			= 00000000Fh

PS_ENDCAP_ROUND 		= 000000000h
PS_ENDCAP_SQUARE		= 000000100h
PS_ENDCAP_FLAT			= 000000200h
PS_ENDCAP_MASK			= 000000F00h

PS_JOIN_ROUND			= 000000000h
PS_JOIN_BEVEL			= 000001000h
PS_JOIN_MITER			= 000002000h
PS_JOIN_MASK			= 00000F000h

PS_COSMETIC			= 000000000h
PS_GEOMETRIC			= 000010000h
PS_TYPE_MASK			= 0000F0000h

AD_COUNTERCLOCKWISE		= 1
AD_CLOCKWISE			= 2

; Device Parameters for GetDeviceCaps()
DRIVERVERSION			= 0	; Device driver version
TECHNOLOGY			= 2	; Device classification
HORZSIZE			= 4	; Horizontal size in millimeters
VERTSIZE			= 6	; Vertical size in millimeters
HORZRES 			= 8	; Horizontal width in pixels
VERTRES 			= 10	; Vertical height in pixels
BITSPIXEL			= 12	; Number of bits per pixel
PLANES				= 14	; Number of planes
NUMBRUSHES			= 16	; Number of brushes the device has
NUMPENS 			= 18	; Number of pens the device has
NUMMARKERS			= 20	; Number of markers the device has
NUMFONTS			= 22	; Number of fonts the device has
NUMCOLORS			= 24	; Number of colors the device supports
PDEVICESIZE			= 26	; Size required for device descriptor
CURVECAPS			= 28	; Curve capabilities
LINECAPS			= 30	; Line capabilities
POLYGONALCAPS			= 32	; Polygonal capabilities
TEXTCAPS			= 34	; Text capabilities
CLIPCAPS			= 36	; Clipping capabilities
RASTERCAPS			= 38	; Bitblt capabilities
ASPECTX 			= 40	; Length of the X leg
ASPECTY 			= 42	; Length of the Y leg
ASPECTXY			= 44	; Length of the hypotenuse

LOGPIXELSX			= 88	; Logical pixels/inch in X
LOGPIXELSY			= 90	; Logical pixels/inch in Y

SIZEPALETTE			= 104	 ; Number of entries in physical palette
NUMRESERVED			= 106	 ; Number of reserved entries in palette
COLORRES			= 108	 ; Actual color resolution

; Printing related DeviceCaps. These replace the appropriate Escapes

PHYSICALWIDTH			= 110 ; Physical Width in device units
PHYSICALHEIGHT			= 111 ; Physical Height in device units
PHYSICALOFFSETX 		= 112 ; Physical Printable Area x margin
PHYSICALOFFSETY 		= 113 ; Physical Printable Area y margin
SCALINGFACTORX			= 114 ; Scaling factor x
SCALINGFACTORY			= 115 ; Scaling factor y

; Display driver specific

VREFRESH			= 116  ; Current vertical refresh rate of the
				       ; display device (for displays only) in Hz
DESKTOPVERTRES			= 117  ; Horizontal width of entire desktop in
				       ; pixels
DESKTOPHORZRES			= 118  ; Vertical height of entire desktop in
				       ; pixels
BLTALIGNMENT			= 119  ; Preferred blt alignment

SHADEBLENDCAPS			= 120  ; Shading and blending caps
COLORMGMTCAPS			= 121  ; Color Management caps

; Device Capability Masks:

; Device Technologies
DT_PLOTTER			= 0   ; Vector plotter
DT_RASDISPLAY			= 1   ; Raster display
DT_RASPRINTER			= 2   ; Raster printer
DT_RASCAMERA			= 3   ; Raster camera
DT_CHARSTREAM			= 4   ; Character-stream, PLP
DT_METAFILE			= 5   ; Metafile, VDM
DT_DISPFILE			= 6   ; Display-file

; Curve Capabilities
CC_NONE 			= 0   ; Curves not supported
CC_CIRCLES			= 1   ; Can do circles
CC_PIE				= 2   ; Can do pie wedges
CC_CHORD			= 4   ; Can do chord arcs
CC_ELLIPSES			= 8   ; Can do ellipese
CC_WIDE 			= 16  ; Can do wide lines
CC_STYLED			= 32  ; Can do styled lines
CC_WIDESTYLED			= 64  ; Can do wide styled lines
CC_INTERIORS			= 128 ; Can do interiors
CC_ROUNDRECT			= 256 ;

; Line Capabilities
LC_NONE 			= 0   ; Lines not supported
LC_POLYLINE			= 2   ; Can do polylines
LC_MARKER			= 4   ; Can do markers
LC_POLYMARKER			= 8   ; Can do polymarkers
LC_WIDE 			= 16  ; Can do wide lines
LC_STYLED			= 32  ; Can do styled lines
LC_WIDESTYLED			= 64  ; Can do wide styled lines
LC_INTERIORS			= 128 ; Can do interiors

; Polygonal Capabilities
PC_NONE 			= 0   ; Polygonals not supported
PC_POLYGON			= 1   ; Can do polygons
PC_RECTANGLE			= 2   ; Can do rectangles
PC_WINDPOLYGON			= 4   ; Can do winding polygons
PC_TRAPEZOID			= 4   ; Can do trapezoids
PC_SCANLINE			= 8   ; Can do scanlines
PC_WIDE 			= 16  ; Can do wide borders
PC_STYLED			= 32  ; Can do styled borders
PC_WIDESTYLED			= 64  ; Can do wide styled borders
PC_INTERIORS			= 128 ; Can do interiors
PC_POLYPOLYGON			= 256 ; Can do polypolygons
PC_PATHS			= 512 ; Can do paths

; Clipping Capabilities
CP_NONE 			= 0   ; No clipping of output
CP_RECTANGLE			= 1   ; Output clipped to rects
CP_REGION			= 2   ; obsolete

; Text Capabilities
TC_OP_CHARACTER 		= 000000001h  ; Can do OutputPrecision	 CHARACTER
TC_OP_STROKE			= 000000002h  ; Can do OutputPrecision	 STROKE
TC_CP_STROKE			= 000000004h  ; Can do ClipPrecision	 STROKE
TC_CR_90			= 000000008h  ; Can do CharRotAbility	 90
TC_CR_ANY			= 000000010h  ; Can do CharRotAbility	 ANY
TC_SF_X_YINDEP			= 000000020h  ; Can do ScaleFreedom	 X_YINDEPENDENT
TC_SA_DOUBLE			= 000000040h  ; Can do ScaleAbility	 DOUBLE
TC_SA_INTEGER			= 000000080h  ; Can do ScaleAbility	 INTEGER
TC_SA_CONTIN			= 000000100h  ; Can do ScaleAbility	 CONTINUOUS
TC_EA_DOUBLE			= 000000200h  ; Can do EmboldenAbility	 DOUBLE
TC_IA_ABLE			= 000000400h  ; Can do ItalisizeAbility  ABLE
TC_UA_ABLE			= 000000800h  ; Can do UnderlineAbility  ABLE
TC_SO_ABLE			= 000001000h  ; Can do StrikeOutAbility  ABLE
TC_RA_ABLE			= 000002000h  ; Can do RasterFontAble	 ABLE
TC_VA_ABLE			= 000004000h  ; Can do VectorFontAble	 ABLE
TC_RESERVED			= 000008000h
TC_SCROLLBLT			= 000010000h  ; Don't do text scroll with blt

; Raster Capabilities
RC_NONE 			= 0
RC_BITBLT			= 1	  ; Can do standard BLT.
RC_BANDING			= 2	  ; Device requires banding support
RC_SCALING			= 4	  ; Device requires scaling support
RC_BITMAP64			= 8	  ; Device can support >64K bitmap
RC_GDI20_OUTPUT 		= 00010h      ; has 2.0 output calls
RC_GDI20_STATE			= 00020h
RC_SAVEBITMAP			= 00040h
RC_DI_BITMAP			= 00080h      ; supports DIB to memory
RC_PALETTE			= 00100h      ; supports a palette
RC_DIBTODEV			= 00200h      ; supports DIBitsToDevice
RC_BIGFONT			= 00400h      ; supports >64K fonts
RC_STRETCHBLT			= 00800h      ; supports StretchBlt
RC_FLOODFILL			= 01000h      ; supports FloodFill
RC_STRETCHDIB			= 02000h      ; supports StretchDIBits
RC_OP_DX_OUTPUT 		= 04000h
RC_DEVBITS			= 08000h

; Shading and blending caps
SB_NONE 			= 000000000h
SB_CONST_ALPHA			= 000000001h
SB_PIXEL_ALPHA			= 000000002h
SB_PREMULT_ALPHA		= 000000004h

SB_GRAD_RECT			= 000000010h
SB_GRAD_TRI			= 000000020h

; Color Management caps
CM_NONE 			= 000000000h
CM_DEVICE_ICM			= 000000001h
CM_GAMMA_RAMP			= 000000002h
CM_CMYK_COLOR			= 000000004h

; DIB color table identifiers

DIB_RGB_COLORS			= 0 ; color table in RGBs
DIB_PAL_COLORS			= 1 ; color table in palette indices

; constants for Get/SetSystemPaletteUse()

SYSPAL_ERROR			= 0
SYSPAL_STATIC			= 1
SYSPAL_NOSTATIC 		= 2
SYSPAL_NOSTATIC256		= 3

; constants for CreateDIBitmap
CBM_INIT			= 004h	 ; initialize bitmap

; ExtFloodFill style flags
FLOODFILLBORDER 		= 0
FLOODFILLSURFACE		= 1

; size of a device name string
CCHDEVICENAME			= 32

; size of a form name string
CCHFORMNAME			= 32


struc	DEVMODE
	dmDeviceName		db CCHDEVICENAME dup (?)
	dmSpecVersion		dw ?
	dmDriverVersion 	dw ?
	dmSize			dw ?
	dmDriverExtra		dw ?
	dmFields		dd ?
label	dmPosition		POINTL
	dmOrientation		dw ?
	dmPaperSize		dw ?
	dmPaperLength		dw ?
	dmPaperWidth		dw ?
	dmScale 		dw ?
	dmCopies		dw ?
	dmDefaultSource 	dw ?
	dmPrintQuality		dw ?
	dmColor 		dw ?
	dmDuplex		dw ?
	dmYResolution		dw ?
	dmTTOption		dw ?
	dmCollate		dw ?
	dmFormName		db CCHFORMNAME dup (?)
	dmLogPixels		dw ?
	dmBitsPerPel		dd ?
	dmPelsWidth		dd ?
	dmPelsHeight		dd ?
label	dmDisplayFlags		dword
	dmNup			dd ?
	dmDisplayFrequency	dd ?
if WINVER ge 0400h
	dmICMMethod		dd ?
	dmICMIntent		dd ?
	dmMediaType		dd ?
	dmDitherType		dd ?
	dmReserved1		dd ?
	dmReserved2		dd ?
if (WINVER ge 0500h) or (_WIN32_WINNT ge 0400h)
	dmPanningWidth		dd ?
	dmPanningHeight 	dd ?
endif
endif
ends

; current version of specification
if (WINVER ge 0500h) or (_WIN32_WINNT ge 0400h)
DM_SPECVERSION			= 00401h
elseif WINVER ge 0400h
DM_SPECVERSION			= 00400h
else
DM_SPECVERSION			= 00320h
endif

; field selection bits
DM_ORIENTATION			= 000000001h
DM_PAPERSIZE			= 000000002h
DM_PAPERLENGTH			= 000000004h
DM_PAPERWIDTH			= 000000008h
DM_SCALE			= 000000010h
DM_POSITION			= 000000020h
DM_NUP				= 000000040h
DM_COPIES			= 000000100h
DM_DEFAULTSOURCE		= 000000200h
DM_PRINTQUALITY 		= 000000400h
DM_COLOR			= 000000800h
DM_DUPLEX			= 000001000h
DM_YRESOLUTION			= 000002000h
DM_TTOPTION			= 000004000h
DM_COLLATE			= 000008000h
DM_FORMNAME			= 000010000h
DM_LOGPIXELS			= 000020000h
DM_BITSPERPEL			= 000040000h
DM_PELSWIDTH			= 000080000h
DM_PELSHEIGHT			= 000100000h
DM_DISPLAYFLAGS 		= 000200000h
DM_DISPLAYFREQUENCY		= 000400000h
DM_ICMMETHOD			= 000800000h
DM_ICMINTENT			= 001000000h
DM_MEDIATYPE			= 002000000h
DM_DITHERTYPE			= 004000000h
DM_PANNINGWIDTH 		= 008000000h
DM_PANNINGHEIGHT		= 010000000h

; orientation selections
DMORIENT_PORTRAIT		= 1
DMORIENT_LANDSCAPE		= 2

; paper selections
DMPAPER_FIRST			= DMPAPER_LETTER
DMPAPER_LETTER			= 1  ; Letter 8 1/2 x 11 in
DMPAPER_LETTERSMALL		= 2  ; Letter Small 8 1/2 x 11 in
DMPAPER_TABLOID 		= 3  ; Tabloid 11 x 17 in
DMPAPER_LEDGER			= 4  ; Ledger 17 x 11 in
DMPAPER_LEGAL			= 5  ; Legal 8 1/2 x 14 in
DMPAPER_STATEMENT		= 6  ; Statement 5 1/2 x 8 1/2 in
DMPAPER_EXECUTIVE		= 7  ; Executive 7 1/4 x 10 1/2 in
DMPAPER_A3			= 8  ; A3 297 x 420 mm
DMPAPER_A4			= 9  ; A4 210 x 297 mm
DMPAPER_A4SMALL 		= 10  ; A4 Small 210 x 297 mm
DMPAPER_A5			= 11  ; A5 148 x 210 mm
DMPAPER_B4			= 12  ; B4 (JIS) 250 x 354
DMPAPER_B5			= 13  ; B5 (JIS) 182 x 257 mm
DMPAPER_FOLIO			= 14  ; Folio 8 1/2 x 13 in
DMPAPER_QUARTO			= 15  ; Quarto 215 x 275 mm
DMPAPER_10X14			= 16  ; 10x14 in
DMPAPER_11X17			= 17  ; 11x17 in
DMPAPER_NOTE			= 18  ; Note 8 1/2 x 11 in
DMPAPER_ENV_9			= 19  ; Envelope #9 3 7/8 x 8 7/8
DMPAPER_ENV_10			= 20  ; Envelope #10 4 1/8 x 9 1/2
DMPAPER_ENV_11			= 21  ; Envelope #11 4 1/2 x 10 3/8
DMPAPER_ENV_12			= 22  ; Envelope #12 4 \276 x 11
DMPAPER_ENV_14			= 23  ; Envelope #14 5 x 11 1/2
DMPAPER_CSHEET			= 24  ; C size sheet
DMPAPER_DSHEET			= 25  ; D size sheet
DMPAPER_ESHEET			= 26  ; E size sheet
DMPAPER_ENV_DL			= 27  ; Envelope DL 110 x 220mm
DMPAPER_ENV_C5			= 28  ; Envelope C5 162 x 229 mm
DMPAPER_ENV_C3			= 29  ; Envelope C3  324 x 458 mm
DMPAPER_ENV_C4			= 30  ; Envelope C4  229 x 324 mm
DMPAPER_ENV_C6			= 31  ; Envelope C6  114 x 162 mm
DMPAPER_ENV_C65 		= 32  ; Envelope C65 114 x 229 mm
DMPAPER_ENV_B4			= 33  ; Envelope B4  250 x 353 mm
DMPAPER_ENV_B5			= 34  ; Envelope B5  176 x 250 mm
DMPAPER_ENV_B6			= 35  ; Envelope B6  176 x 125 mm
DMPAPER_ENV_ITALY		= 36  ; Envelope 110 x 230 mm
DMPAPER_ENV_MONARCH		= 37  ; Envelope Monarch 3.875 x 7.5 in
DMPAPER_ENV_PERSONAL		= 38  ; 6 3/4 Envelope 3 5/8 x 6 1/2 in
DMPAPER_FANFOLD_US		= 39  ; US Std Fanfold 14 7/8 x 11 in
DMPAPER_FANFOLD_STD_GERMAN	= 40  ; German Std Fanfold 8 1/2 x 12 in
DMPAPER_FANFOLD_LGL_GERMAN	= 41  ; German Legal Fanfold 8 1/2 x 13 in
DMPAPER_ISO_B4			= 42  ; B4 (ISO) 250 x 353 mm
DMPAPER_JAPANESE_POSTCARD	= 43  ; Japanese Postcard 100 x 148 mm
DMPAPER_9X11			= 44  ; 9 x 11 in
DMPAPER_10X11			= 45  ; 10 x 11 in
DMPAPER_15X11			= 46  ; 15 x 11 in
DMPAPER_ENV_INVITE		= 47  ; Envelope Invite 220 x 220 mm
DMPAPER_RESERVED_48		= 48  ; RESERVED--DO NOT USE
DMPAPER_RESERVED_49		= 49  ; RESERVED--DO NOT USE
DMPAPER_LETTER_EXTRA		= 50  ; Letter Extra 9 \275 x 12 in
DMPAPER_LEGAL_EXTRA		= 51  ; Legal Extra 9 \275 x 15 in
DMPAPER_TABLOID_EXTRA		= 52  ; Tabloid Extra 11.69 x 18 in
DMPAPER_A4_EXTRA		= 53  ; A4 Extra 9.27 x 12.69 in
DMPAPER_LETTER_TRANSVERSE	= 54  ; Letter Transverse 8 \275 x 11 in
DMPAPER_A4_TRANSVERSE		= 55  ; A4 Transverse 210 x 297 mm
DMPAPER_LETTER_EXTRA_TRANSVERSE = 56 ; Letter Extra Transverse 9\275 x 12 in
DMPAPER_A_PLUS			= 57  ; SuperA/SuperA/A4 227 x 356 mm
DMPAPER_B_PLUS			= 58  ; SuperB/SuperB/A3 305 x 487 mm
DMPAPER_LETTER_PLUS		= 59  ; Letter Plus 8.5 x 12.69 in
DMPAPER_A4_PLUS 		= 60  ; A4 Plus 210 x 330 mm
DMPAPER_A5_TRANSVERSE		= 61  ; A5 Transverse 148 x 210 mm
DMPAPER_B5_TRANSVERSE		= 62  ; B5 (JIS) Transverse 182 x 257 mm
DMPAPER_A3_EXTRA		= 63  ; A3 Extra 322 x 445 mm
DMPAPER_A5_EXTRA		= 64  ; A5 Extra 174 x 235 mm
DMPAPER_B5_EXTRA		= 65  ; B5 (ISO) Extra 201 x 276 mm
DMPAPER_A2			= 66  ; A2 420 x 594 mm
DMPAPER_A3_TRANSVERSE		= 67  ; A3 Transverse 297 x 420 mm
DMPAPER_A3_EXTRA_TRANSVERSE	= 68  ; A3 Extra Transverse 322 x 445 mm

DMPAPER_DBL_JAPANESE_POSTCARD	= 69 ; Japanese Double Postcard 200 x 148 mm
DMPAPER_A6			= 70  ; A6 105 x 148 mm
DMPAPER_JENV_KAKU2		= 71  ; Japanese Envelope Kaku #2
DMPAPER_JENV_KAKU3		= 72  ; Japanese Envelope Kaku #3
DMPAPER_JENV_CHOU3		= 73  ; Japanese Envelope Chou #3
DMPAPER_JENV_CHOU4		= 74  ; Japanese Envelope Chou #4
DMPAPER_LETTER_ROTATED		= 75  ; Letter Rotated 11 x 8 1/2 11 in
DMPAPER_A3_ROTATED		= 76  ; A3 Rotated 420 x 297 mm
DMPAPER_A4_ROTATED		= 77  ; A4 Rotated 297 x 210 mm
DMPAPER_A5_ROTATED		= 78  ; A5 Rotated 210 x 148 mm
DMPAPER_B4_JIS_ROTATED		= 79  ; B4 (JIS) Rotated 364 x 257 mm
DMPAPER_B5_JIS_ROTATED		= 80  ; B5 (JIS) Rotated 257 x 182 mm
DMPAPER_JAPANESE_POSTCARD_ROTATED = 81 ; Japanese Postcard Rotated 148 x 100 mm
DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED = 82 ; Double Japanese Postcard Rotated 148 x 200 mm
DMPAPER_A6_ROTATED		= 83  ; A6 Rotated 148 x 105 mm
DMPAPER_JENV_KAKU2_ROTATED	= 84  ; Japanese Envelope Kaku #2 Rotated
DMPAPER_JENV_KAKU3_ROTATED	= 85  ; Japanese Envelope Kaku #3 Rotated
DMPAPER_JENV_CHOU3_ROTATED	= 86  ; Japanese Envelope Chou #3 Rotated
DMPAPER_JENV_CHOU4_ROTATED	= 87  ; Japanese Envelope Chou #4 Rotated
DMPAPER_B6_JIS			= 88  ; B6 (JIS) 128 x 182 mm
DMPAPER_B6_JIS_ROTATED		= 89  ; B6 (JIS) Rotated 182 x 128 mm
DMPAPER_12X11			= 90  ; 12 x 11 in
DMPAPER_JENV_YOU4		= 91  ; Japanese Envelope You #4
DMPAPER_JENV_YOU4_ROTATED	= 92  ; Japanese Envelope You #4 Rotated
DMPAPER_P16K			= 93  ; PRC 16K 146 x 215 mm
DMPAPER_P32K			= 94  ; PRC 32K 97 x 151 mm
DMPAPER_P32KBIG 		= 95  ; PRC 32K(Big) 97 x 151 mm
DMPAPER_PENV_1			= 96  ; PRC Envelope #1 102 x 165 mm
DMPAPER_PENV_2			= 97  ; PRC Envelope #2 102 x 176 mm
DMPAPER_PENV_3			= 98  ; PRC Envelope #3 125 x 176 mm
DMPAPER_PENV_4			= 99  ; PRC Envelope #4 110 x 208 mm
DMPAPER_PENV_5			= 100 ; PRC Envelope #5 110 x 220 mm
DMPAPER_PENV_6			= 101 ; PRC Envelope #6 120 x 230 mm
DMPAPER_PENV_7			= 102 ; PRC Envelope #7 160 x 230 mm
DMPAPER_PENV_8			= 103 ; PRC Envelope #8 120 x 309 mm
DMPAPER_PENV_9			= 104 ; PRC Envelope #9 229 x 324 mm
DMPAPER_PENV_10 		= 105 ; PRC Envelope #10 324 x 458 mm
DMPAPER_P16K_ROTATED		= 106 ; PRC 16K Rotated
DMPAPER_P32K_ROTATED		= 107 ; PRC 32K Rotated
DMPAPER_P32KBIG_ROTATED 	= 108 ; PRC 32K(Big) Rotated
DMPAPER_PENV_1_ROTATED		= 109 ; PRC Envelope #1 Rotated 165 x 102 mm
DMPAPER_PENV_2_ROTATED		= 110 ; PRC Envelope #2 Rotated 176 x 102 mm
DMPAPER_PENV_3_ROTATED		= 111 ; PRC Envelope #3 Rotated 176 x 125 mm
DMPAPER_PENV_4_ROTATED		= 112 ; PRC Envelope #4 Rotated 208 x 110 mm
DMPAPER_PENV_5_ROTATED		= 113 ; PRC Envelope #5 Rotated 220 x 110 mm
DMPAPER_PENV_6_ROTATED		= 114 ; PRC Envelope #6 Rotated 230 x 120 mm
DMPAPER_PENV_7_ROTATED		= 115 ; PRC Envelope #7 Rotated 230 x 160 mm
DMPAPER_PENV_8_ROTATED		= 116 ; PRC Envelope #8 Rotated 309 x 120 mm
DMPAPER_PENV_9_ROTATED		= 117 ; PRC Envelope #9 Rotated 324 x 229 mm
DMPAPER_PENV_10_ROTATED 	= 118 ; PRC Envelope #10 Rotated 458 x 324 mm

DMPAPER_LAST			= DMPAPER_PENV_10_ROTATED

DMPAPER_USER			= 256

; bin selections
DMBIN_FIRST			= DMBIN_UPPER
DMBIN_UPPER			= 1
DMBIN_ONLYONE			= 1
DMBIN_LOWER			= 2
DMBIN_MIDDLE			= 3
DMBIN_MANUAL			= 4
DMBIN_ENVELOPE			= 5
DMBIN_ENVMANUAL 		= 6
DMBIN_AUTO			= 7
DMBIN_TRACTOR			= 8
DMBIN_SMALLFMT			= 9
DMBIN_LARGEFMT			= 10
DMBIN_LARGECAPACITY		= 11
DMBIN_CASSETTE			= 14
DMBIN_FORMSOURCE		= 15
DMBIN_LAST			= DMBIN_FORMSOURCE

DMBIN_USER			= 256	  ; device specific bins start here

; print qualities
DMRES_DRAFT			= (-1)
DMRES_LOW			= (-2)
DMRES_MEDIUM			= (-3)
DMRES_HIGH			= (-4)

; color enable/disable for color printers
DMCOLOR_MONOCHROME		= 1
DMCOLOR_COLOR			= 2

; duplex enable
DMDUP_SIMPLEX			= 1
DMDUP_VERTICAL			= 2
DMDUP_HORIZONTAL		= 3

; TrueType options
DMTT_BITMAP			= 1	  ; print TT fonts as graphics
DMTT_DOWNLOAD			= 2	  ; download TT fonts as soft fonts
DMTT_SUBDEV			= 3	  ; substitute device fonts for TT fonts
DMTT_DOWNLOAD_OUTLINE		= 4 ; download TT fonts as outline soft fonts

; Collation selections
DMCOLLATE_FALSE 		= 0
DMCOLLATE_TRUE			= 1

; DEVMODE dmDisplayFlags flags

; #define DM_GRAYSCALE		  0x00000001 /* This flag is no longer valid */
; #define DM_INTERLACED 	  0x00000002 /* This flag is no longer valid */
DMDISPLAYFLAGS_TEXTMODE 	= 000000004h

; dmNup , multiple logical page per physical page options
DMNUP_SYSTEM			= 1
DMNUP_ONEUP			= 2

; ICM methods
DMICMMETHOD_NONE		= 1   ; ICM disabled
DMICMMETHOD_SYSTEM		= 2   ; ICM handled by system
DMICMMETHOD_DRIVER		= 3   ; ICM handled by driver
DMICMMETHOD_DEVICE		= 4   ; ICM handled by device

DMICMMETHOD_USER		= 256	; Device-specific methods start here

; ICM Intents
DMICM_SATURATE			= 1   ; Maximize color saturation
DMICM_CONTRAST			= 2   ; Maximize color contrast
DMICM_COLORIMETRIC		= 3   ; Use specific color metric
DMICM_ABS_COLORIMETRIC		= 4   ; Use specific color metric

DMICM_USER			= 256	; Device-specific intents start here

; Media types

DMMEDIA_STANDARD		= 1   ; Standard paper
DMMEDIA_TRANSPARENCY		= 2   ; Transparency
DMMEDIA_GLOSSY			= 3   ; Glossy paper

DMMEDIA_USER			= 256	; Device-specific media start here

; Dither types
DMDITHER_NONE			= 1	 ; No dithering
DMDITHER_COARSE 		= 2	 ; Dither with a coarse brush
DMDITHER_FINE			= 3	 ; Dither with a fine brush
DMDITHER_LINEART		= 4	 ; LineArt dithering
DMDITHER_ERRORDIFFUSION 	= 5  ; LineArt dithering
DMDITHER_RESERVED6		= 6	 ; LineArt dithering
DMDITHER_RESERVED7		= 7	 ; LineArt dithering
DMDITHER_RESERVED8		= 8	 ; LineArt dithering
DMDITHER_RESERVED9		= 9	 ; LineArt dithering
DMDITHER_GRAYSCALE		= 10	 ; Device does grayscaling

DMDITHER_USER			= 256	; Device-specific dithers start here

struc	DISPLAY_DEVICE
	cb			dd ?
	DeviceName		db 32 dup (?)
	DeviceString		db 128 dup (?)
	StateFlags		dd ?
	DeviceID		db 128 dup (?)
	DeviceKey		db 128 dup (?)
ends

DISPLAY_DEVICE_ATTACHED_TO_DESKTOP = 000000001h
DISPLAY_DEVICE_MULTI_DRIVER	= 000000002h
DISPLAY_DEVICE_PRIMARY_DEVICE	= 000000004h
DISPLAY_DEVICE_MIRRORING_DRIVER = 000000008h
DISPLAY_DEVICE_VGA_COMPATIBLE	= 000000010h

; GetRegionData/ExtCreateRegion

RDH_RECTANGLES			= 1

struc	RGNDATAHEADER
	dwSize			dd ?
	iType			dd ?
	nCount			dd ?
	nRgnSize		dd ?
	rcBound 		RECT ?
ends

struc	RGNDATA
	rdh			RGNDATAHEADER ?
label	Buffer			byte
ends

struc	ABC
	abcA			dd ?
	abcB			dd ?
	abcC			dd ?
ends

struc	ABCFLOAT
	abcfA			dd ?
	abcfB			dd ?
	abcfC			dd ?
ends

struc	OUTLINETEXTMETRIC
	otmSize 		dd ?
	otmTextMetrics		TEXTMETRIC ?
	otmFiller		db ?
	otmPanoseNumber 	PANOSE ?
	otmfsSelection		dd ?
	otmfsType		dd ?
	otmsCharSlopeRise	dd ?
	otmsCharSlopeRun	dd ?
	otmItalicAngle		dd ?
	otmEMSquare		dd ?
	otmAscent		dd ?
	otmDescent		dd ?
	otmLineGap		dd ?
	otmsCapEmHeight 	dd ?
	otmsXHeight		dd ?
	otmrcFontBox		RECT ?
	otmMacAscent		dd ?
	otmMacDescent		dd ?
	otmMacLineGap		dd ?
	otmusMinimumPPEM	dd ?
	otmptSubscriptSize	POINT ?
	otmptSubscriptOffset	POINT ?
	otmptSuperscriptSize	POINT ?
	otmptSuperscriptOffset	POINT ?
	otmsStrikeoutSize	dd ?
	otmsStrikeoutPosition	dd ?
	otmsUnderscoreSize	dd ?
	otmsUnderscorePosition	dd ?
	otmpFamilyName		dd ?
	otmpFaceName		dd ?
	otmpStyleName		dd ?
	otmpFullName		dd ?
ends

struc	POLYTEXT
	x			dd ?
	y			dd ?
	n			dd ?
	lpstr			dd ?
	uiFlags 		dd ?
	_rcl			RECT ?
	pdx			dd ?
ends

struc	FIXED
	fract			dw ?
	value			dw ?
ends

struc	MAT2
	eM11			FIXED ?
	eM12			FIXED ?
	eM21			FIXED ?
	eM22			FIXED ?
ends

struc	GLYPHMETRICS
	gmBlackBoxX		dd ?
	gmBlackBoxY		dd ?
	gmptGlyphOrigin 	POINT ?
	gmCellIncX		dw ?
	gmCellIncY		dw ?
ends

;  GetGlyphOutline constants

GGO_METRICS			= 0
GGO_BITMAP			= 1
GGO_NATIVE			= 2
GGO_BEZIER			= 3

GGO_GRAY2_BITMAP		= 4
GGO_GRAY4_BITMAP		= 5
GGO_GRAY8_BITMAP		= 6
GGO_GLYPH_INDEX 		= 00080h

GGO_UNHINTED			= 00100h

TT_POLYGON_TYPE 		= 24

TT_PRIM_LINE			= 1
TT_PRIM_QSPLINE 		= 2
TT_PRIM_CSPLINE 		= 3

struc	POINTFX
	x			FIXED ?
	y			FIXED ?
ends

struc	TTPOLYCURVE
	wType			dw ?
	cpfx			dw ?
label	apfx			POINTFX
ends

struc	TTPOLYGONHEADER
	cb			dd ?
	dwType			dd ?
	pfxStart		POINTFX ?
ends

GCP_DBCS			= 00001h
GCP_REORDER			= 00002h
GCP_USEKERNING			= 00008h
GCP_GLYPHSHAPE			= 00010h
GCP_LIGATE			= 00020h
GCP_DIACRITIC			= 00100h
GCP_KASHIDA			= 00400h
GCP_ERROR			= 08000h
FLI_MASK			= 0103Bh

GCP_JUSTIFY			= 000010000h
FLI_GLYPHS			= 000040000h
GCP_CLASSIN			= 000080000h
GCP_MAXEXTENT			= 000100000h
GCP_JUSTIFYIN			= 000200000h
GCP_DISPLAYZWG			= 000400000h
GCP_SYMSWAPOFF			= 000800000h
GCP_NUMERICOVERRIDE		= 001000000h
GCP_NEUTRALOVERRIDE		= 002000000h
GCP_NUMERICSLATIN		= 004000000h
GCP_NUMERICSLOCAL		= 008000000h

GCPCLASS_LATIN			= 1
GCPCLASS_HEBREW 		= 2
GCPCLASS_ARABIC 		= 2
GCPCLASS_NEUTRAL		= 3
GCPCLASS_LOCALNUMBER		= 4
GCPCLASS_LATINNUMBER		= 5
GCPCLASS_LATINNUMERICTERMINATOR = 6
GCPCLASS_LATINNUMERICSEPARATOR	= 7
GCPCLASS_NUMERICSEPARATOR	= 8
GCPCLASS_PREBOUNDLTR		= 080h
GCPCLASS_PREBOUNDRTL		= 040h
GCPCLASS_POSTBOUNDLTR		= 020h
GCPCLASS_POSTBOUNDRTL		= 010h

GCPGLYPH_LINKBEFORE		= 08000h
GCPGLYPH_LINKAFTER		= 04000h

struc	GCP_RESULTS
	lStructSize		dd ?
	lpOutString		dd ?
	lpOrder 		dd ?
	lpDx			dd ?
	lpCaretPos		dd ?
	lpClass 		dd ?
	lpGlyphs		dd ?
	nGlyphs 		dd ?
	nMaxFit 		dd ?
ends

struc	RASTERIZER_STATUS
	nSize			dw ?
	wFlags			dw ?
	nLanguageID		dw ?
ends

; bits defined in wFlags of RASTERIZER_STATUS
TT_AVAILABLE			= 00001h
TT_ENABLED			= 00002h

; Pixel format descriptor

struc	PIXELFORMATDESCRIPTOR
	nSize			dw ?
	nVersion		dw ?
	dwFlags 		dd ?
	iPixelType		db ?
	cColorBits		db ?
	cRedBits		db ?
	cRedShift		db ?
	cGreenBits		db ?
	cGreenShift		db ?
	cBlueBits		db ?
	cBlueShift		db ?
	cAlphaBits		db ?
	cAlphaShift		db ?
	cAccumBits		db ?
	cAccumRedBits		db ?
	cAccumGreenBits 	db ?
	cAccumBlueBits		db ?
	cAccumAlphaBits 	db ?
	cDepthBits		db ?
	cStencilBits		db ?
	cAuxBuffers		db ?
	iLayerType		db ?
	bReserved		db ?
	dwLayerMask		dd ?
	dwVisibleMask		dd ?
	dwDamageMask		dd ?
ends

; pixel types
PFD_TYPE_RGBA			= 0
PFD_TYPE_COLORINDEX		= 1

; layer types
PFD_MAIN_PLANE			= 0
PFD_OVERLAY_PLANE		= 1
PFD_UNDERLAY_PLANE		= (-1)

; PIXELFORMATDESCRIPTOR flags
PFD_DOUBLEBUFFER		= 000000001h
PFD_STEREO			= 000000002h
PFD_DRAW_TO_WINDOW		= 000000004h
PFD_DRAW_TO_BITMAP		= 000000008h
PFD_SUPPORT_GDI 		= 000000010h
PFD_SUPPORT_OPENGL		= 000000020h
PFD_GENERIC_FORMAT		= 000000040h
PFD_NEED_PALETTE		= 000000080h
PFD_NEED_SYSTEM_PALETTE 	= 000000100h
PFD_SWAP_EXCHANGE		= 000000200h
PFD_SWAP_COPY			= 000000400h
PFD_SWAP_LAYER_BUFFERS		= 000000800h
PFD_GENERIC_ACCELERATED 	= 000001000h
PFD_SUPPORT_DIRECTDRAW		= 000002000h

; PIXELFORMATDESCRIPTOR flags for use in ChoosePixelFormat only
PFD_DEPTH_DONTCARE		= 020000000h
PFD_DOUBLEBUFFER_DONTCARE	= 040000000h
PFD_STEREO_DONTCARE		= 080000000h

proctype OLDFONTENUMPROC :dword, :dword, :dword, :dword
proctype GOBJENUMPROC :dword, :dword
proctype LINEDDAPROC :dword, :dword, :dword

procdesc AddFontResourceA :dword
procdesc AnimatePalette :dword, :dword, :dword, :dword
procdesc Arc :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc BitBlt :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc CancelDC :dword
procdesc Chord :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc ChoosePixelFormat :dword, :dword
procdesc CloseMetaFile :dword
procdesc CombineRgn :dword, :dword, :dword, :dword
procdesc CopyMetaFileA :dword, :dword
procdesc CreateBitmap :dword, :dword, :dword, :dword, :dword
procdesc CreateBitmapIndirect :dword
procdesc CreateBrushIndirect :dword
procdesc CreateCompatibleBitmap :dword, :dword, :dword
procdesc CreateDiscardableBitmap :dword, :dword, :dword
procdesc CreateCompatibleDC :dword
procdesc CreateDCA :dword, :dword, :dword, :dword
procdesc CreateDIBitmap :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateDIBPatternBrush :dword, :dword
procdesc CreateDIBPatternBrushPt :dword, :dword
procdesc CreateEllipticRgn :dword, :dword, :dword, :dword
procdesc CreateEllipticRgnIndirect :dword
procdesc CreateFontIndirectA :dword
procdesc CreateFontA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateHatchBrush :dword, :dword
procdesc CreateICA :dword, :dword, :dword, :dword
procdesc CreateMetaFileA :dword
procdesc CreatePalette :dword
procdesc CreatePen :dword, :dword, :dword
procdesc CreatePenIndirect :dword
procdesc CreatePolyPolygonRgn :dword, :dword, :dword, :dword
procdesc CreatePatternBrush :dword
procdesc CreateRectRgn :dword, :dword, :dword, :dword
procdesc CreateRectRgnIndirect :dword
procdesc CreateRoundRectRgn :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateScalableFontResourceA :dword, :dword, :dword, :dword
procdesc CreateSolidBrush :dword
procdesc DeleteDC :dword
procdesc DeleteMetaFile :dword
procdesc DeleteObject :dword
procdesc DescribePixelFormat :dword, :dword, :dword, :dword

AddFontResource 		equ <AddFontResourceA>
CopyMetaFile			equ <CopyMetaFileA>
CreateDC			equ <CreateDCA>
CreateFontIndirect		equ <CreateFontIndirectA>
CreateFont			equ <CreateFontA>
CreateIC			equ <CreateICA>
CreateMetaFile			equ <CreateMetaFileA>
CreateScalableFontResource	equ <CreateScalableFontResourceA>

proctype FNDEVMODE :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
proctype FNDEVCAPS :dword, :dword, :dword, :dword, :dword

; mode selections for the device mode function
DM_UPDATE			= 1
DM_COPY 			= 2
DM_PROMPT			= 4
DM_MODIFY			= 8

DM_IN_BUFFER			= DM_MODIFY
DM_IN_PROMPT			= DM_PROMPT
DM_OUT_BUFFER			= DM_COPY
DM_OUT_DEFAULT			= DM_UPDATE

; device capabilities indices
DC_FIELDS			= 1
DC_PAPERS			= 2
DC_PAPERSIZE			= 3
DC_MINEXTENT			= 4
DC_MAXEXTENT			= 5
DC_BINS 			= 6
DC_DUPLEX			= 7
DC_SIZE 			= 8
DC_EXTRA			= 9
DC_VERSION			= 10
DC_DRIVER			= 11
DC_BINNAMES			= 12
DC_ENUMRESOLUTIONS		= 13
DC_FILEDEPENDENCIES		= 14
DC_TRUETYPE			= 15
DC_PAPERNAMES			= 16
DC_ORIENTATION			= 17
DC_COPIES			= 18
DC_BINADJUST			= 19
DC_EMF_COMPLIANT		= 20
DC_DATATYPE_PRODUCED		= 21
DC_COLLATE			= 22
DC_MANUFACTURER 		= 23
DC_MODEL			= 24
DC_PERSONALITY			= 25
DC_PRINTRATE			= 26
DC_PRINTRATEUNIT		= 27
PRINTRATEUNIT_PPM		= 1
PRINTRATEUNIT_CPS		= 2
PRINTRATEUNIT_LPM		= 3
PRINTRATEUNIT_IPM		= 4
DC_PRINTERMEM			= 28
DC_MEDIAREADY			= 29
DC_STAPLE			= 30
DC_PRINTRATEPPM 		= 31
DC_COLORDEVICE			= 32
DC_NUP				= 33

; bit fields of the return value (DWORD) for DC_TRUETYPE
DCTT_BITMAP			= 00000001h
DCTT_DOWNLOAD			= 00000002h
DCTT_SUBDEV			= 00000004h
DCTT_DOWNLOAD_OUTLINE		= 00000008h

; return values for DC_BINADJUST
DCBA_FACEUPNONE 		= 00000h
DCBA_FACEUPCENTER		= 00001h
DCBA_FACEUPLEFT 		= 00002h
DCBA_FACEUPRIGHT		= 00003h
DCBA_FACEDOWNNONE		= 00100h
DCBA_FACEDOWNCENTER		= 00101h
DCBA_FACEDOWNLEFT		= 00102h
DCBA_FACEDOWNRIGHT		= 00103h

procdesc DeviceCapabilitiesA :dword, :dword, :dword, :dword, :dword
procdesc DrawEscape :dword, :dword, :dword, :dword
procdesc Ellipse :dword, :dword, :dword, :dword, :dword
procdesc EnumFontFamiliesExA :dword, :dword, :dword, :dword, :dword
procdesc EnumFontFamiliesA :dword, :dword, :dword, :dword
procdesc EnumFontsA :dword, :dword, :dword, :dword
procdesc EnumObjects :dword, :dword, :dword, :dword
procdesc EqualRgn :dword, :dword
procdesc Escape :dword, :dword, :dword, :dword, :dword
procdesc ExtEscape :dword, :dword, :dword, :dword, :dword, :dword
procdesc ExcludeClipRect :dword, :dword, :dword, :dword, :dword
procdesc ExtCreateRegion :dword, :dword, :dword
procdesc ExtFloodFill :dword, :dword, :dword, :dword, :dword
procdesc FillRgn :dword, :dword, :dword
procdesc FloodFill :dword, :dword, :dword, :dword
procdesc FrameRgn :dword, :dword, :dword, :dword, :dword
procdesc GetROP2 :dword
procdesc GetAspectRatioFilterEx :dword, :dword
procdesc GetBkColor :dword
procdesc GetDCBrushColor :dword
procdesc GetDCPenColor :dword
procdesc GetBkMode :dword
procdesc GetBitmapBits :dword, :dword, :dword
procdesc GetBitmapDimensionEx :dword, :dword
procdesc GetBoundsRect :dword, :dword, :dword
procdesc GetBrushOrgEx :dword, :dword
procdesc GetCharWidthA :dword, :dword, :dword, :dword
procdesc GetCharWidth32A :dword, :dword, :dword, :dword
procdesc GetCharWidthFloatA :dword, :dword, :dword, :dword
procdesc GetCharABCWidthsA :dword, :dword, :dword, :dword
procdesc GetCharABCWidthsFloatA :dword, :dword, :dword, :dword
procdesc GetClipBox :dword, :dword
procdesc GetClipRgn :dword, :dword
procdesc GetMetaRgn :dword, :dword
procdesc GetCurrentObject :dword, :dword
procdesc GetCurrentPositionEx :dword, :dword
procdesc GetDeviceCaps :dword, :dword
procdesc GetDIBits :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetFontData :dword, :dword, :dword, :dword, :dword
procdesc GetGlyphOutlineA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetGraphicsMode :dword
procdesc GetMapMode :dword
procdesc GetMetaFileBitsEx :dword, :dword, :dword
procdesc GetMetaFileA :dword
procdesc GetNearestColor :dword, :dword
procdesc GetNearestPaletteIndex :dword, :dword
procdesc GetObjectType :dword
procdesc GetOutlineTextMetricsA :dword, :dword, :dword
procdesc GetPaletteEntries :dword, :dword, :dword, :dword
procdesc GetPixel :dword, :dword, :dword
procdesc GetPixelFormat :dword
procdesc GetPolyFillMode :dword
procdesc GetRasterizerCaps :dword, :dword
procdesc GetRegionData :dword, :dword, :dword
procdesc GetRgnBox :dword, :dword
procdesc GetStockObject :dword
procdesc GetStretchBltMode :dword
procdesc GetSystemPaletteEntries :dword, :dword, :dword, :dword
procdesc GetSystemPaletteUse :dword
procdesc GetTextCharacterExtra :dword
procdesc GetTextAlign :dword
procdesc GetTextColor :dword
procdesc GetTextExtentPointA :dword, :dword, :dword, :dword
procdesc GetTextExtentPoint32A :dword, :dword, :dword, :dword
procdesc GetTextExtentExPointA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetTextCharset :dword
procdesc GetTextCharsetInfo :dword, :dword, :dword
procdesc TranslateCharsetInfo :dword, :dword, :dword
procdesc GetFontLanguageInfo :dword
procdesc GetCharacterPlacementA :dword, :dword, :dword, :dword, :dword, :dword

DeviceCapabilities		equ <DeviceCapabilitiesA>
EnumFontFamiliesEx		equ <EnumFontFamiliesExA>
EnumFontFamilies		equ <EnumFontFamiliesA>
EnumFonts			equ <EnumFontsA>
GetCharWidth			equ <GetCharWidthA>
GetCharWidth32			equ <GetCharWidth32A>
GetCharWidthFloat		equ <GetCharWidthFloatA>
GetCharABCWidths		equ <GetCharABCWidthsA>
GetCharABCWidthsFloat		equ <GetCharABCWidthsFloatA>
GetGlyphOutline 		equ <GetGlyphOutlineA>
GetMetaFile			equ <GetMetaFileA>
GetOutlineTextMetrics		equ <GetOutlineTextMetricsA>
GetTextExtentPoint		equ <GetTextExtentPointA>
GetTextExtentPoint32		equ <GetTextExtentPoint32A>
GetTextExtentExPoint		equ <GetTextExtentExPointA>
GetCharacterPlacement		equ <GetCharacterPlacementA>

struc	WCRANGE
	wcLow			db ?
	cGlyphs 		dw ?
ends

struc	GLYPHSET
	cbThis			dd ?
	flAccel 		dd ?
	cGlyphsSupported	dd ?
	cRanges 		dd ?
label	ranges			WCRANGE
ends

; flAccel flags for the GLYPHSET structure above

GS_8BIT_INDICES 		= 000000001h

; flags for GetGlyphIndices

GGI_MARK_NONEXISTING_GLYPHS	= 00001h

procdesc GetFontUnicodeRanges :dword, :dword
procdesc GetGlyphIndicesA :dword, :dword, :dword, :dword, :dword
procdesc GetTextExtentPointI :dword, :dword, :dword, :dword
procdesc GetTextExtentExPointI :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetCharWidthI :dword, :dword, :dword, :dword, :dword
procdesc GetCharABCWidthsI :dword, :dword, :dword, :dword, :dword

GetGlyphIndices 		equ <GetGlyphIndicesA>

STAMP_DESIGNVECTOR		= (08000000h + 'd' + ('v' shl 8))
STAMP_AXESLIST			= (08000000h + 'a' + ('l' shl 8))
MM_MAX_NUMAXES			= 16

struc	DESIGNVECTOR
	dvReserved		dd ?
	dvNumAxes		dd ?
	dvValues		dd MM_MAX_NUMAXES dup (?)
ends

procdesc AddFontResourceExA :dword, :dword, :dword
procdesc RemoveFontResourceExA :dword, :dword, :dword
procdesc AddFontMemResourceEx :dword, :dword, :dword, :dword
procdesc RemoveFontMemResourceEx :dword

AddFontResourceEx		equ <AddFontResourceExA>
RemoveFontResourceEx		equ <RemoveFontResourceExA>

FR_PRIVATE			= 010h
FR_NOT_ENUM			= 020h

; The actual size of the DESIGNVECTOR and ENUMLOGFONTEXDV structures
; is determined by dvNumAxes,
; MM_MAX_NUMAXES only detemines the maximal size allowed

MM_MAX_AXES_NAMELEN		= 16

struc	AXISINFO
	axMinValue		dd ?
	axMaxValue		dd ?
	axAxisName		db MM_MAX_AXES_NAMELEN dup (?)
ends

struc	AXESLIST
	axlReserved		dd ?
	axlNumAxes		dd ?
	axlAxisInfo		AXISINFO MM_MAX_NUMAXES dup (?)
ends

; The actual size of the AXESLIST and ENUMTEXTMETRIC structure is
; determined by axlNumAxes,
; MM_MAX_NUMAXES only detemines the maximal size allowed

struc	ENUMLOGFONTEXDV
	elfEnumLogfontEx	ENUMLOGFONTEX ?
	elfDesignVector 	DESIGNVECTOR ?
ends

procdesc CreateFontIndirectExA :dword

CreateFontIndirectEx		equ <CreateFontIndirectExA>

struc	ENUMTEXTMETRIC
	etmNewTextMetricEx	NEWTEXTMETRICEX ?
	etmAxesList		AXESLIST ?
ends

procdesc GetViewportExtEx :dword, :dword
procdesc GetViewportOrgEx :dword, :dword
procdesc GetWindowExtEx :dword, :dword
procdesc GetWindowOrgEx :dword, :dword
procdesc IntersectClipRect :dword, :dword, :dword, :dword, :dword
procdesc InvertRgn :dword, :dword
procdesc LineDDA :dword, :dword, :dword, :dword, :dword, :dword
procdesc LineTo :dword, :dword, :dword
procdesc MaskBlt :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc PlgBlt :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc OffsetClipRgn :dword, :dword, :dword
procdesc OffsetRgn :dword, :dword, :dword
procdesc PatBlt :dword, :dword, :dword, :dword, :dword, :dword
procdesc Pie :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc PlayMetaFile :dword, :dword
procdesc PaintRgn :dword, :dword
procdesc PolyPolygon :dword, :dword, :dword, :dword
procdesc PtInRegion :dword, :dword, :dword
procdesc PtVisible :dword, :dword, :dword
procdesc RectInRegion :dword, :dword
procdesc RectVisible :dword, :dword
procdesc Rectangle :dword, :dword, :dword, :dword, :dword
procdesc RestoreDC :dword, :dword
procdesc ResetDCA :dword, :dword
procdesc RealizePalette :dword
procdesc RemoveFontResourceA :dword
procdesc RoundRect :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc ResizePalette :dword, :dword
procdesc SaveDC :dword
procdesc SelectClipRgn :dword, :dword
procdesc ExtSelectClipRgn :dword, :dword, :dword
procdesc SetMetaRgn :dword
procdesc SelectObject :dword, :dword
procdesc SelectPalette :dword, :dword, :dword
procdesc SetBkColor :dword, :dword
procdesc SetDCBrushColor :dword, :dword
procdesc SetDCPenColor :dword, :dword
procdesc SetBkMode :dword, :dword
procdesc SetBitmapBits :dword, :dword, :dword
procdesc SetBoundsRect :dword, :dword, :dword
procdesc SetDIBits :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetDIBitsToDevice :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetMapperFlags :dword, :dword
procdesc SetGraphicsMode :dword, :dword
procdesc SetMapMode :dword, :dword
procdesc SetLayout :dword, :dword
procdesc GetLayout :dword
procdesc SetMetaFileBitsEx :dword, :dword
procdesc SetPaletteEntries :dword, :dword, :dword, :dword
procdesc SetPixel :dword, :dword, :dword, :dword
procdesc SetPixelV :dword, :dword, :dword, :dword
procdesc SetPixelFormat :dword, :dword, :dword
procdesc SetPolyFillMode :dword, :dword
procdesc StretchBlt :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetRectRgn :dword, :dword, :dword, :dword, :dword
procdesc StretchDIBits :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetROP2 :dword, :dword
procdesc SetStretchBltMode :dword, :dword
procdesc SetSystemPaletteUse :dword, :dword
procdesc SetTextCharacterExtra :dword, :dword
procdesc SetTextColor :dword, :dword
procdesc SetTextAlign :dword, :dword
procdesc SetTextJustification :dword, :dword, :dword
procdesc UpdateColors :dword

ResetDC 			equ <ResetDCA>
RemoveFontResource		equ <RemoveFontResourceA>

;
; image blt
;

struc	TRIVERTEX
	x			dd ?
	y			dd ?
	Red			dw ?
	Green			dw ?
	Blue			dw ?
	Alpha			dw ?
ends

struc	GRADIENT_TRIANGLE
	Vertex1 		dd ?
	Vertex2 		dd ?
	Vertex3 		dd ?
ends

struc	GRADIENT_RECT
	UpperLeft		dd ?
	LowerRight		dd ?
ends

struc	BLENDFUNCTION
	BlendOp 		db ?
	BlendFlags		db ?
	SourceConstantAlpha	db ?
	AlphaFormat		db ?
ends

;
; currentlly defined blend function
;

AC_SRC_OVER			= 000h

;
; alpha format flags
;

AC_SRC_ALPHA			= 001h

procdesc AlphaBlend :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc TransparentBlt :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

;
; gradient drawing modes
;

GRADIENT_FILL_RECT_H		= 000000000h
GRADIENT_FILL_RECT_V		= 000000001h
GRADIENT_FILL_TRIANGLE		= 000000002h
GRADIENT_FILL_OP_FLAG		= 0000000fh

procdesc GradientFill :dword, :dword, :dword, :dword, :dword, :dword

procdesc PlayMetaFileRecord :dword, :dword, :dword, :dword
procdesc EnumMetaFile :dword, :dword, :dword, :dword

proctype MFENUMPROC :dword, :dword, :dword, :dword, :dword
proctype ENHMFENUMPROC :dword, :dword, :dword, :dword, :dword

; Enhanced Metafile Function Declarations

procdesc CloseEnhMetaFile :dword
procdesc CopyEnhMetaFileA :dword, :dword
procdesc CreateEnhMetaFileA :dword, :dword, :dword, :dword
procdesc DeleteEnhMetaFile :dword
procdesc EnumEnhMetaFile :dword, :dword, :dword, :dword, :dword
procdesc GetEnhMetaFileA :dword
procdesc GetEnhMetaFileBits :dword, :dword, :dword
procdesc GetEnhMetaFileDescriptionA :dword, :dword, :dword
procdesc GetEnhMetaFileHeader :dword, :dword, :dword
procdesc GetEnhMetaFilePaletteEntries :dword, :dword, :dword
procdesc GetEnhMetaFilePixelFormat :dword, :dword, :dword
procdesc GetWinMetaFileBits :dword, :dword, :dword, :dword, :dword
procdesc PlayEnhMetaFile :dword, :dword, :dword
procdesc PlayEnhMetaFileRecord :dword, :dword, :dword, :dword
procdesc SetEnhMetaFileBits :dword, :dword
procdesc SetWinMetaFileBits :dword, :dword, :dword, :dword
procdesc GdiComment :dword, :dword, :dword
procdesc GetTextMetricsA :dword, :dword

CopyEnhMetaFile 		equ <CopyEnhMetaFileA>
CreateEnhMetaFile		equ <CreateEnhMetaFileA>
GetEnhMetaFile			equ <GetEnhMetaFileA>
GetEnhMetaFileDescription	equ <GetEnhMetaFileDescriptionA>
GetTextMetrics			equ <GetTextMetricsA>

; new GDI

struc	DIBSECTION
	dsBm			BITMAP ?
	dsBmih			BITMAPINFOHEADER ?
	dsBitfields		dd 3 dup (?)
	dshSection		dd ?
	dsOffset		dd ?
ends

procdesc AngleArc :dword, :dword, :dword, :dword, :dword, :dword
procdesc PolyPolyline :dword, :dword, :dword, :dword
procdesc GetWorldTransform :dword, :dword
procdesc SetWorldTransform :dword, :dword
procdesc ModifyWorldTransform :dword, :dword, :dword
procdesc CombineTransform :dword, :dword, :dword
procdesc CreateDIBSection :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetDIBColorTable :dword, :dword, :dword, :dword
procdesc SetDIBColorTable :dword, :dword, :dword, :dword

; Flags value for COLORADJUSTMENT
CA_NEGATIVE			= 00001h
CA_LOG_FILTER			= 00002h

; IlluminantIndex values
ILLUMINANT_DEVICE_DEFAULT	= 0
ILLUMINANT_A			= 1
ILLUMINANT_B			= 2
ILLUMINANT_C			= 3
ILLUMINANT_D50			= 4
ILLUMINANT_D55			= 5
ILLUMINANT_D65			= 6
ILLUMINANT_D75			= 7
ILLUMINANT_F2			= 8
ILLUMINANT_MAX_INDEX		= ILLUMINANT_F2

ILLUMINANT_TUNGSTEN		= ILLUMINANT_A
ILLUMINANT_DAYLIGHT		= ILLUMINANT_C
ILLUMINANT_FLUORESCENT		= ILLUMINANT_F2
ILLUMINANT_NTSC 		= ILLUMINANT_C

; Min and max for RedGamma, GreenGamma, BlueGamma
RGB_GAMMA_MIN			= 2500
RGB_GAMMA_MAX			= 65000

; Min and max for ReferenceBlack and ReferenceWhite
REFERENCE_WHITE_MIN		= 6000
REFERENCE_WHITE_MAX		= 10000
REFERENCE_BLACK_MIN		= 0
REFERENCE_BLACK_MAX		= 4000

; Min and max for Contrast, Brightness, Colorfulness, RedGreenTint
COLOR_ADJ_MIN			= -100
COLOR_ADJ_MAX			= 100

struc	COLORADJUSTMENT
	caSize			dw ?
	caFlags 		dw ?
	caIlluminantIndex	dw ?
	caRedGamma		dw ?
	caGreenGamma		dw ?
	caBlueGamma		dw ?
	caReferenceBlack	dw ?
	caReferenceWhite	dw ?
	caContrast		dw ?
	caBrightness		dw ?
	caColorfulness		dw ?
	caRedGreenTint		dw ?
ends

procdesc SetColorAdjustment :dword, :dword
procdesc GetColorAdjustment :dword, :dword
procdesc CreateHalftonePalette :dword

proctype ABORTPROC :dword, :dword

struc	DOCINFO
	cbSize			dd ?
	lpszDocName		dd ?
	lpszOutput		dd ?
	lpszDatatype		dd ?
	fwType			dd ?
ends

DI_APPBANDING			= 000000001h
DI_ROPS_READ_DESTINATION	= 000000002h

procdesc StartDocA :dword, :dword
procdesc EndDoc :dword
procdesc StartPage :dword
procdesc EndPage :dword
procdesc StartFormPage :dword
procdesc EndFormPage :dword
procdesc AbortDoc :dword
procdesc SetAbortProc :dword, :dword
procdesc AbortPath :dword
procdesc ArcTo :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc BeginPath :dword
procdesc CloseFigure :dword
procdesc EndPath :dword
procdesc FillPath :dword
procdesc FlattenPath :dword
procdesc GetPath :dword, :dword, :dword, :dword
procdesc PathToRegion :dword
procdesc PolyDraw :dword, :dword, :dword, :dword
procdesc SelectClipPath :dword, :dword
procdesc SetArcDirection :dword, :dword
procdesc SetMiterLimit :dword, :dword, :dword
procdesc StrokeAndFillPath :dword
procdesc StrokePath :dword
procdesc WidenPath :dword
procdesc ExtCreatePen :dword, :dword, :dword, :dword, :dword
procdesc GetMiterLimit :dword, :dword
procdesc GetArcDirection :dword
procdesc GetObjectA :dword, :dword, :dword
procdesc MoveToEx :dword, :dword, :dword, :dword
procdesc TextOutA :dword, :dword, :dword, :dword, :dword
procdesc ExtTextOutA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc PolyTextOutA :dword, :dword, :dword
procdesc CreatePolygonRgn :dword, :dword, :dword
procdesc DPtoLP :dword, :dword, :dword
procdesc LPtoDP :dword, :dword, :dword
procdesc Polygon :dword, :dword, :dword
procdesc Polyline :dword, :dword, :dword
procdesc PolyBezier :dword, :dword, :dword
procdesc PolyBezierTo :dword, :dword, :dword
procdesc PolylineTo :dword, :dword, :dword
procdesc SetViewportExtEx :dword, :dword, :dword, :dword
procdesc SetViewportOrgEx :dword, :dword, :dword, :dword
procdesc SetWindowExtEx :dword, :dword, :dword, :dword
procdesc SetWindowOrgEx :dword, :dword, :dword, :dword
procdesc OffsetViewportOrgEx :dword, :dword, :dword, :dword
procdesc OffsetWindowOrgEx :dword, :dword, :dword, :dword
procdesc ScaleViewportExtEx :dword, :dword, :dword, :dword, :dword, :dword
procdesc ScaleWindowExtEx :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetBitmapDimensionEx :dword, :dword, :dword, :dword
procdesc SetBrushOrgEx :dword, :dword, :dword, :dword
procdesc GetTextFaceA :dword, :dword, :dword

StartDoc			equ <StartDocA>
GetObject			equ <GetObjectA>
TextOut 			equ <TextOutA>
ExtTextOut			equ <ExtTextOutA>
PolyTextOut			equ <PolyTextOutA>
GetTextFace			equ <GetTextFaceA>

FONTMAPPER_MAX			= 10

struc	KERNINGPAIR
	wFirst			dw ?
	wSecond 		dw ?
	iKernAmount		dd ?
ends

procdesc GetKerningPairsA :dword, :dword, :dword
procdesc GetDCOrgEx :dword, :dword
procdesc FixBrushOrgEx :dword, :dword, :dword, :dword
procdesc UnrealizeObject :dword
procdesc GdiFlush
procdesc GdiSetBatchLimit :dword
procdesc GdiGetBatchLimit

GetKerningPairs 		equ <GetKerningPairsA>

ICM_OFF 			= 1
ICM_ON				= 2
ICM_QUERY			= 3
ICM_DONE_OUTSIDEDC		= 4

proctype ICMENUMPROC :dword, :dword

procdesc SetICMMode :dword, :dword
procdesc CheckColorsInGamut :dword, :dword, :dword, :dword
procdesc GetColorSpace :dword
procdesc GetLogColorSpaceA :dword, :dword, :dword
procdesc CreateColorSpaceA :dword
procdesc SetColorSpace :dword, :dword
procdesc DeleteColorSpace :dword
procdesc GetICMProfileA :dword, :dword, :dword
procdesc SetICMProfileA :dword, :dword
procdesc GetDeviceGammaRamp :dword, :dword
procdesc SetDeviceGammaRamp :dword, :dword
procdesc ColorMatchToTarget :dword, :dword, :dword
procdesc EnumICMProfilesA :dword, :dword, :dword
procdesc UpdateICMRegKeyA :dword, :dword, :dword, :dword
procdesc ColorCorrectPalette :dword, :dword, :dword, :dword

GetLogColorSpace		equ <GetLogColorSpaceA>
CreateColorSpace		equ <CreateColorSpaceA>
GetICMProfile			equ <GetICMProfileA>
SetICMProfile			equ <SetICMProfileA>
EnumICMProfiles 		equ <EnumICMProfilesA>
UpdateICMRegKey 		equ <UpdateICMRegKeyA>

; Enhanced metafile constants.

ENHMETA_SIGNATURE		= 0464D4520h

; Stock object flag used in the object handle index in the enhanced
; metafile records.
; E.g. The object handle index (META_STOCK_OBJECT | BLACK_BRUSH)
; represents the stock object BLACK_BRUSH.

ENHMETA_STOCK_OBJECT		= 080000000h

; Enhanced metafile record types.

EMR_HEADER			= 1
EMR_POLYBEZIER			= 2
EMR_POLYGON			= 3
EMR_POLYLINE			= 4
EMR_POLYBEZIERTO		= 5
EMR_POLYLINETO			= 6
EMR_POLYPOLYLINE		= 7
EMR_POLYPOLYGON 		= 8
EMR_SETWINDOWEXTEX		= 9
EMR_SETWINDOWORGEX		= 10
EMR_SETVIEWPORTEXTEX		= 11
EMR_SETVIEWPORTORGEX		= 12
EMR_SETBRUSHORGEX		= 13
EMR_EOF 			= 14
EMR_SETPIXELV			= 15
EMR_SETMAPPERFLAGS		= 16
EMR_SETMAPMODE			= 17
EMR_SETBKMODE			= 18
EMR_SETPOLYFILLMODE		= 19
EMR_SETROP2			= 20
EMR_SETSTRETCHBLTMODE		= 21
EMR_SETTEXTALIGN		= 22
EMR_SETCOLORADJUSTMENT		= 23
EMR_SETTEXTCOLOR		= 24
EMR_SETBKCOLOR			= 25
EMR_OFFSETCLIPRGN		= 26
EMR_MOVETOEX			= 27
EMR_SETMETARGN			= 28
EMR_EXCLUDECLIPRECT		= 29
EMR_INTERSECTCLIPRECT		= 30
EMR_SCALEVIEWPORTEXTEX		= 31
EMR_SCALEWINDOWEXTEX		= 32
EMR_SAVEDC			= 33
EMR_RESTOREDC			= 34
EMR_SETWORLDTRANSFORM		= 35
EMR_MODIFYWORLDTRANSFORM	= 36
EMR_SELECTOBJECT		= 37
EMR_CREATEPEN			= 38
EMR_CREATEBRUSHINDIRECT 	= 39
EMR_DELETEOBJECT		= 40
EMR_ANGLEARC			= 41
EMR_ELLIPSE			= 42
EMR_RECTANGLE			= 43
EMR_ROUNDRECT			= 44
EMR_ARC 			= 45
EMR_CHORD			= 46
EMR_PIE 			= 47
EMR_SELECTPALETTE		= 48
EMR_CREATEPALETTE		= 49
EMR_SETPALETTEENTRIES		= 50
EMR_RESIZEPALETTE		= 51
EMR_REALIZEPALETTE		= 52
EMR_EXTFLOODFILL		= 53
EMR_LINETO			= 54
EMR_ARCTO			= 55
EMR_POLYDRAW			= 56
EMR_SETARCDIRECTION		= 57
EMR_SETMITERLIMIT		= 58
EMR_BEGINPATH			= 59
EMR_ENDPATH			= 60
EMR_CLOSEFIGURE 		= 61
EMR_FILLPATH			= 62
EMR_STROKEANDFILLPATH		= 63
EMR_STROKEPATH			= 64
EMR_FLATTENPATH 		= 65
EMR_WIDENPATH			= 66
EMR_SELECTCLIPPATH		= 67
EMR_ABORTPATH			= 68

EMR_GDICOMMENT			= 70
EMR_FILLRGN			= 71
EMR_FRAMERGN			= 72
EMR_INVERTRGN			= 73
EMR_PAINTRGN			= 74
EMR_EXTSELECTCLIPRGN		= 75
EMR_BITBLT			= 76
EMR_STRETCHBLT			= 77
EMR_MASKBLT			= 78
EMR_PLGBLT			= 79
EMR_SETDIBITSTODEVICE		= 80
EMR_STRETCHDIBITS		= 81
EMR_EXTCREATEFONTINDIRECTW	= 82
EMR_EXTTEXTOUTA 		= 83
EMR_EXTTEXTOUTW 		= 84
EMR_POLYBEZIER16		= 85
EMR_POLYGON16			= 86
EMR_POLYLINE16			= 87
EMR_POLYBEZIERTO16		= 88
EMR_POLYLINETO16		= 89
EMR_POLYPOLYLINE16		= 90
EMR_POLYPOLYGON16		= 91
EMR_POLYDRAW16			= 92
EMR_CREATEMONOBRUSH		= 93
EMR_CREATEDIBPATTERNBRUSHPT	= 94
EMR_EXTCREATEPEN		= 95
EMR_POLYTEXTOUTA		= 96
EMR_POLYTEXTOUTW		= 97

EMR_SETICMMODE			= 98
EMR_CREATECOLORSPACE		= 99
EMR_SETCOLORSPACE		= 100
EMR_DELETECOLORSPACE		= 101
EMR_GLSRECORD			= 102
EMR_GLSBOUNDEDRECORD		= 103
EMR_PIXELFORMAT 		= 104

EMR_DRAWESCAPE			= 105
EMR_EXTESCAPE			= 106
EMR_STARTDOC			= 107
EMR_SMALLTEXTOUT		= 108
EMR_FORCEUFIMAPPING		= 109
EMR_NAMEDESCAPE 		= 110
EMR_COLORCORRECTPALETTE 	= 111
EMR_SETICMPROFILEA		= 112
EMR_SETICMPROFILEW		= 113
EMR_ALPHABLEND			= 114
EMR_SETLAYOUT			= 115
EMR_TRANSPARENTBLT		= 116
EMR_GRADIENTFILL		= 118
EMR_SETLINKEDUFIS		= 119
EMR_SETTEXTJUSTIFICATION	= 120
EMR_COLORMATCHTOTARGETW 	= 121

EMR_MIN 			= 1

EMR_MAX 			= 121

; Base record type for the enhanced metafile.

struc	EMR
	iType			dd ?		; Enhanced metafile record type
	nSize			dd ?		; Length of the record in bytes. ; This must be a multiple of 4.
ends

; Base text record type for the enhanced metafile.

struc	EMRTEXT
	ptlReference		POINTL ?
	nChars			dd ?
	offString		dd ?		; Offset to the string
	fOptions		dd ?
	_rcl			RECTL ?
	offDx			dd ?		; Offset to the inter-character spacing array. ; This is always given.
ends

; Record structures for the enhanced metafile.

struc	EMRABORTPATH
	emr			EMR ?
ends

typedef EMRBEGINPATH		EMRABORTPATH
typedef EMRENDPATH		EMRABORTPATH
typedef EMRCLOSEFIGURE		EMRABORTPATH
typedef EMRFLATTENPATH		EMRABORTPATH
typedef EMRWIDENPATH		EMRABORTPATH
typedef EMRSETMETARGN		EMRABORTPATH
typedef EMRSAVEDC		EMRABORTPATH
typedef EMRREALIZEPALETTE	EMRABORTPATH

struc	EMRSELECTCLIPPATH
	emr			EMR ?
	iMode			dd ?
ends

typedef EMRSETBKMODE		EMRSELECTCLIPPATH
typedef EMRSETMAPMODE		EMRSELECTCLIPPATH
typedef EMRSETPOLYFILLMODE	EMRSELECTCLIPPATH
typedef EMRSETROP2		EMRSELECTCLIPPATH
typedef EMRSETSTRETCHBLTMODE	EMRSELECTCLIPPATH
typedef EMRSETICMMODE		EMRSELECTCLIPPATH
typedef EMRSETTEXTALIGN 	EMRSELECTCLIPPATH

struc	EMRSETMITERLIMIT
	emr			EMR ?
	eMiterLimit		dd ?
ends

struc	EMRRESTOREDC
	emr			EMR ?
	iRelative		dd ?		; Specifies a relative instance
ends

struc	EMRSETARCDIRECTION
	emr			EMR ?
	iArcDirection		dd ?		; Specifies the arc direction in the ; advanced graphics mode.
ends

struc	EMRSETMAPPERFLAGS
	emr			EMR ?
	dwFlags 		dd ?
ends

struc	EMRSETBKCOLOR
	emr			EMR ?
	crColor 		dd ?
ends

typedef EMRSETTEXTCOLOR 	EMRSETBKCOLOR

struc	EMRSELECTOBJECT
	emr			EMR ?
	ihObject		dd ?		; Object handle index
ends

typedef EMRDELETEOBJECT 	EMRSELECTOBJECT

struc	EMRSELECTCOLORSPACE
	emr			EMR ?
	ihCS			dd ?		; ColorSpace handle index
ends

typedef EMRDELETECOLORSPACE	EMRSELECTCOLORSPACE

struc	EMRSELECTPALETTE
	emr			EMR ?
	ihPal			dd ?		; Palette handle index, background mode only
ends

struc	EMRRESIZEPALETTE
	emr			EMR ?
	ihPal			dd ?		; Palette handle index
	cEntries		dd ?
ends

struc	EMRSETPALETTEENTRIES
	emr			EMR ?
	ihPal			dd ?		; Palette handle index
	iStart			dd ?
	cEntries		dd ?
label	aPalEntries		PALETTEENTRY	   ; The peFlags fields do not contain any flags
ends

struc	EMRSETCOLORADJUSTMENT
	emr			EMR ?
	ColorAdjustment 	COLORADJUSTMENT ?
ends

struc	EMRGDICOMMENT
	emr			EMR ?
	cbData			dd ?		; Size of data in bytes
label	Data			byte
ends

struc	EMREOF
	emr			EMR ?
	nPalEntries		dd ?		; Number of palette entries
	offPalEntries		dd ?		; Offset to the palette entries
	nSizeLast		dd ?		; Same as nSize and must be the last DWORD ; of the record.  The palette entries, ; if exist, precede this field.
ends

struc	EMRLINETO
	emr			EMR ?
	ptl			POINTL ?
ends

typedef EMRMOVETOEX		EMRLINETO

struc	EMROFFSETCLIPRGN
	emr			EMR ?
	ptlOffset		POINTL ?
ends

struc	EMRFILLPATH
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
ends

typedef EMRSTROKEANDFILLPATH	EMRFILLPATH
typedef EMRSTROKEPATH		EMRFILLPATH

struc	EMREXCLUDECLIPRECT
	emr			EMR ?
	rclClip 		RECTL ?
ends

typedef EMRINTERSECTCLIPRECT	EMREXCLUDECLIPRECT

struc	EMRSETVIEWPORTORGEX
	emr			EMR ?
	ptlOrigin		POINTL ?
ends

typedef EMRSETWINDOWORGEX	EMRSETVIEWPORTORGEX
typedef EMRSETBRUSHORGEX	EMRSETVIEWPORTORGEX

struc	EMRSETVIEWPORTEXTEX
	emr			EMR ?
	szlExtent		SIZEL ?
ends

typedef EMRSETWINDOWEXTEX	EMRSETVIEWPORTEXTEX

struc	EMRSCALEVIEWPORTEXTEX
	emr			EMR ?
	xNum			dd ?
	xDenom			dd ?
	yNum			dd ?
	yDenom			dd ?
ends

typedef EMRSCALEWINDOWEXTEX	EMRSCALEVIEWPORTEXTEX

struc	EMRSETWORLDTRANSFORM
	emr			EMR ?
	xform			XFORM ?
ends

struc	EMRMODIFYWORLDTRANSFORM
	emr			EMR ?
	xform			XFORM ?
	iMode			dd ?
ends

struc	EMRSETPIXELV
	emr			EMR ?
	ptlPixel		POINTL ?
	crColor 		dd ?
ends

struc	EMREXTFLOODFILL
	emr			EMR ?
	ptlStart		POINTL ?
	crColor 		dd ?
	iMode			dd ?
ends

struc	EMRELLIPSE
	emr			EMR ?
	rclBox			RECTL ? 	; Inclusive-inclusive bounding rectangle
ends

typedef EMRRECTANGLE		EMRELLIPSE

struc	EMRROUNDRECT
	emr			EMR ?
	rclBox			RECTL ? 	; Inclusive-inclusive bounding rectangle
	szlCorner		SIZEL ?
ends

struc	EMRARC
	emr			EMR ?
	rclBox			RECTL ? 	; Inclusive-inclusive bounding rectangle
	ptlStart		POINTL ?
	ptlEnd			POINTL ?
ends

typedef EMRARCTO		EMRARC
typedef EMRCHORD		EMRARC
typedef EMRPIE			EMRARC

struc	EMRANGLEARC
	emr			EMR ?
	ptlCenter		POINTL ?
	nRadius 		dd ?
	eStartAngle		dd ?
	eSweepAngle		dd ?
ends

struc	EMRPOLYLINE
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	cptl			dd ?
label	aptl			POINTL
ends

typedef EMRPOLYBEZIER		EMRPOLYLINE
typedef EMRPOLYGON		EMRPOLYLINE
typedef EMRPOLYBEZIERTO 	EMRPOLYLINE
typedef EMRPOLYLINETO		EMRPOLYLINE

struc	EMRPOLYLINE16
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	cpts			dd ?
label	apts			POINTS
ends

typedef EMRPOLYBEZIER16 	EMRPOLYLINE16
typedef EMRPOLYGON16		EMRPOLYLINE16
typedef EMRPOLYBEZIERTO16	EMRPOLYLINE16
typedef EMRPOLYLINETO16 	EMRPOLYLINE16

struc	EMRPOLYDRAW
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	cptl			dd ?		; Number of points
label	aptl			POINTL		; Array of points
label	abTypes 		byte		; Array of point types
ends

struc	EMRPOLYDRAW16
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	cpts			dd ?		; Number of points
label	apts			POINTS		; Array of points
label	abTypes 		byte		; Array of point types
ends

struc	EMRPOLYPOLYLINE
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	nPolys			dd ?		; Number of polys
	cptl			dd ?		; Total number of points in all polys
label	aPolyCounts		dword		; Array of point counts for each poly
label	aptl			POINTL		; Array of points
ends

typedef EMRPOLYPOLYGON		EMRPOLYPOLYLINE

struc	EMRPOLYPOLYLINE16
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	nPolys			dd ?		; Number of polys
	cpts			dd ?		; Total number of points in all polys
label	aPolyCounts		dword		; Array of point counts for each poly
label	apts			POINTS		; Array of points
ends

typedef EMRPOLYPOLYGON16	EMRPOLYPOLYLINE16

struc	EMRINVERTRGN
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	cbRgnData		dd ?		; Size of region data in bytes
label	RgnData 		byte
ends

typedef EMRPAINTRGN		EMRINVERTRGN

struc	EMRFILLRGN
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	cbRgnData		dd ?		; Size of region data in bytes
	ihBrush 		dd ?		; Brush handle index
label	RgnData 		byte
ends

struc	EMRFRAMERGN
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	cbRgnData		dd ?		; Size of region data in bytes
	ihBrush 		dd ?		; Brush handle index
	szlStroke		SIZEL ?
label	RgnData 		byte
ends

struc	EMRGRADIENTFILL
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	nVer			dd ?
	nTri			dd ?
	ulMode			dd ?
label	Ver			TRIVERTEX
ends

struc	EMREXTSELECTCLIPRGN
	emr			EMR ?
	cbRgnData		dd ?		; Size of region data in bytes
	iMode			dd ?
label	RgnData 		byte
ends

struc	EMREXTTEXTOUT
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	iGraphicsMode		dd ?		; Current graphics mode
	exScale 		dd ?		; X and Y scales from Page units to .01mm units
	eyScale 		dd ?		;   if graphics mode is GM_COMPATIBLE.
	emrtext 		EMRTEXT ?	; This is followed by the string and spacing ; array
ends

struc	EMRPOLYTEXTOUT
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	iGraphicsMode		dd ?		; Current graphics mode
	exScale 		dd ?		; X and Y scales from Page units to .01mm units
	eyScale 		dd ?		;   if graphics mode is GM_COMPATIBLE.
	cStrings		dd ?
label	aemrtext		EMRTEXT 	; Array of EMRTEXT structures.	This is ; followed by the strings and spacing arrays.
ends

struc	EMRBITBLT
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	xDest			dd ?
	yDest			dd ?
	cxDest			dd ?
	cyDest			dd ?
	dwRop			dd ?
	xSrc			dd ?
	ySrc			dd ?
	xformSrc		XFORM ? 	; Source DC transform
	crBkColorSrc		dd ?		; Source DC BkColor in RGB
	iUsageSrc		dd ?		; Source bitmap info color table usage ; (DIB_RGB_COLORS)
	offBmiSrc		dd ?		; Offset to the source BITMAPINFO structure
	cbBmiSrc		dd ?		; Size of the source BITMAPINFO structure
	offBitsSrc		dd ?		; Offset to the source bitmap bits
	cbBitsSrc		dd ?		; Size of the source bitmap bits
ends

struc	EMRSTRETCHBLT
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	xDest			dd ?
	yDest			dd ?
	cxDest			dd ?
	cyDest			dd ?
	dwRop			dd ?
	xSrc			dd ?
	ySrc			dd ?
	xformSrc		XFORM ? 	; Source DC transform
	crBkColorSrc		dd ?		; Source DC BkColor in RGB
	iUsageSrc		dd ?		; Source bitmap info color table usage ; (DIB_RGB_COLORS)
	offBmiSrc		dd ?		; Offset to the source BITMAPINFO structure
	cbBmiSrc		dd ?		; Size of the source BITMAPINFO structure
	offBitsSrc		dd ?		; Offset to the source bitmap bits
	cbBitsSrc		dd ?		; Size of the source bitmap bits
	cxSrc			dd ?
	cySrc			dd ?
ends

struc	EMRMASKBLT
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	xDest			dd ?
	yDest			dd ?
	cxDest			dd ?
	cyDest			dd ?
	dwRop			dd ?
	xSrc			dd ?
	ySrc			dd ?
	xformSrc		XFORM ? 	; Source DC transform
	crBkColorSrc		dd ?		; Source DC BkColor in RGB
	iUsageSrc		dd ?		; Source bitmap info color table usage ; (DIB_RGB_COLORS)
	offBmiSrc		dd ?		; Offset to the source BITMAPINFO structure
	cbBmiSrc		dd ?		; Size of the source BITMAPINFO structure
	offBitsSrc		dd ?		; Offset to the source bitmap bits
	cbBitsSrc		dd ?		; Size of the source bitmap bits
	xMask			dd ?
	yMask			dd ?
	iUsageMask		dd ?		; Mask bitmap info color table usage
	offBmiMask		dd ?		; Offset to the mask BITMAPINFO structure if any
	cbBmiMask		dd ?		; Size of the mask BITMAPINFO structure if any
	offBitsMask		dd ?		; Offset to the mask bitmap bits if any
	cbBitsMask		dd ?		; Size of the mask bitmap bits if any
ends

struc	EMRPLGBLT
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	aptlDest		POINTL 3 dup (?)
	xSrc			dd ?
	ySrc			dd ?
	cxSrc			dd ?
	cySrc			dd ?
	xformSrc		XFORM ? 	; Source DC transform
	crBkColorSrc		dd ?		; Source DC BkColor in RGB
	iUsageSrc		dd ?		; Source bitmap info color table usage ; (DIB_RGB_COLORS)
	offBmiSrc		dd ?		; Offset to the source BITMAPINFO structure
	cbBmiSrc		dd ?		; Size of the source BITMAPINFO structure
	offBitsSrc		dd ?		; Offset to the source bitmap bits
	cbBitsSrc		dd ?		; Size of the source bitmap bits
	xMask			dd ?
	yMask			dd ?
	iUsageMask		dd ?		; Mask bitmap info color table usage
	offBmiMask		dd ?		; Offset to the mask BITMAPINFO structure if any
	cbBmiMask		dd ?		; Size of the mask BITMAPINFO structure if any
	offBitsMask		dd ?		; Offset to the mask bitmap bits if any
	cbBitsMask		dd ?		; Size of the mask bitmap bits if any
ends

struc	EMRSETDIBITSTODEVICE
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	xDest			dd ?
	yDest			dd ?
	xSrc			dd ?
	ySrc			dd ?
	cxSrc			dd ?
	cySrc			dd ?
	offBmiSrc		dd ?		; Offset to the source BITMAPINFO structure
	cbBmiSrc		dd ?		; Size of the source BITMAPINFO structure
	offBitsSrc		dd ?		; Offset to the source bitmap bits
	cbBitsSrc		dd ?		; Size of the source bitmap bits
	iUsageSrc		dd ?		; Source bitmap info color table usage
	iStartScan		dd ?
	cScans			dd ?
ends

struc	EMRSTRETCHDIBITS
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	xDest			dd ?
	yDest			dd ?
	xSrc			dd ?
	ySrc			dd ?
	cxSrc			dd ?
	cySrc			dd ?
	offBmiSrc		dd ?		; Offset to the source BITMAPINFO structure
	cbBmiSrc		dd ?		; Size of the source BITMAPINFO structure
	offBitsSrc		dd ?		; Offset to the source bitmap bits
	cbBitsSrc		dd ?		; Size of the source bitmap bits
	iUsageSrc		dd ?		; Source bitmap info color table usage
	dwRop			dd ?
	cxDest			dd ?
	cyDest			dd ?
ends

struc	EMRALPHABLEND
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	xDest			dd ?
	yDest			dd ?
	cxDest			dd ?
	cyDest			dd ?
	dwRop			dd ?
	xSrc			dd ?
	ySrc			dd ?
	xformSrc		XFORM ? 	; Source DC transform
	crBkColorSrc		dd ?		; Source DC BkColor in RGB
	iUsageSrc		dd ?		; Source bitmap info color table usage ; (DIB_RGB_COLORS)
	offBmiSrc		dd ?		; Offset to the source BITMAPINFO structure
	cbBmiSrc		dd ?		; Size of the source BITMAPINFO structure
	offBitsSrc		dd ?		; Offset to the source bitmap bits
	cbBitsSrc		dd ?		; Size of the source bitmap bits
	cxSrc			dd ?
	cySrc			dd ?
ends

struc	EMRTRANSPARENTBLT
	emr			EMR ?
	rclBounds		RECTL ? 	; Inclusive-inclusive bounds in device units
	xDest			dd ?
	yDest			dd ?
	cxDest			dd ?
	cyDest			dd ?
	dwRop			dd ?
	xSrc			dd ?
	ySrc			dd ?
	xformSrc		XFORM ? 	; Source DC transform
	crBkColorSrc		dd ?		; Source DC BkColor in RGB
	iUsageSrc		dd ?		; Source bitmap info color table usage ; (DIB_RGB_COLORS)
	offBmiSrc		dd ?		; Offset to the source BITMAPINFO structure
	cbBmiSrc		dd ?		; Size of the source BITMAPINFO structure
	offBitsSrc		dd ?		; Offset to the source bitmap bits
	cbBitsSrc		dd ?		; Size of the source bitmap bits
	cxSrc			dd ?
	cySrc			dd ?
ends

struc	EMREXTCREATEFONTINDIRECT
	emr			EMR ?
	ihFont			dd ?		; Font handle index
	elfw			EXTLOGFONT ?
ends

struc	EMRCREATEPALETTE
	emr			EMR ?
	ihPal			dd ?		; Palette handle index
	lgpl			LOGPALETTE ?	; The peFlags fields in the palette entries ; do not contain any flags
ends

struc	EMRCREATECOLORSPACE
	emr			EMR ?
	ihCS			dd ?		; ColorSpace handle index
	lcs			LOGCOLORSPACE ?
ends

struc	EMRCREATEPEN
	emr			EMR ?
	ihPen			dd ?		; Pen handle index
	lopn			LOGPEN ?
ends

struc	EMREXTCREATEPEN
	emr			EMR ?
	ihPen			dd ?		; Pen handle index
	offBmi			dd ?		; Offset to the BITMAPINFO structure if any
	cbBmi			dd ?		; Size of the BITMAPINFO structure if any ; The bitmap info is followed by the bitmap ; bits to form a packed DIB.
	offBits 		dd ?		; Offset to the brush bitmap bits if any
	cbBits			dd ?		; Size of the brush bitmap bits if any
	elp			EXTLOGPEN ?	; The extended pen with the style array.
ends

struc	EMRCREATEBRUSHINDIRECT
	emr			EMR ?
	ihBrush 		dd ?		; Brush handle index
	lb			LOGBRUSH ?	; The style must be BS_SOLID, BS_HOLLOW, ; BS_NULL or BS_HATCHED.
ends

struc	EMRCREATEMONOBRUSH
	emr			EMR ?
	ihBrush 		dd ?		; Brush handle index
	iUsage			dd ?		; Bitmap info color table usage
	offBmi			dd ?		; Offset to the BITMAPINFO structure
	cbBmi			dd ?		; Size of the BITMAPINFO structure
	offBits 		dd ?		; Offset to the bitmap bits
	cbBits			dd ?		; Size of the bitmap bits
ends

struc	EMRCREATEDIBPATTERNBRUSHPT
	emr			EMR ?
	ihBrush 		dd ?		; Brush handle index
	iUsage			dd ?		; Bitmap info color table usage
	offBmi			dd ?		; Offset to the BITMAPINFO structure
	cbBmi			dd ?		; Size of the BITMAPINFO structure ; The bitmap info is followed by the bitmap ; bits to form a packed DIB.
	offBits 		dd ?		; Offset to the bitmap bits
	cbBits			dd ?		; Size of the bitmap bits
ends

struc	EMRFORMAT
	dSignature		dd ?		; Format signature, e.g. ENHMETA_SIGNATURE.
	nVersion		dd ?		; Format version number.
	cbData			dd ?		; Size of data in bytes.
	offData 		dd ?		; Offset to data from GDICOMMENT_IDENTIFIER. ; It must begin at a DWORD offset.
ends

struc	EMRGLSRECORD
	emr			EMR ?
	cbData			dd ?		; Size of data in bytes
label	Data			byte
ends

struc	EMRGLSBOUNDEDRECORD
	emr			EMR ?
	rclBounds		RECTL ? 	; Bounds in recording coordinates
	cbData			dd ?		; Size of data in bytes
label	Data			byte
ends

struc	EMRPIXELFORMAT
	emr			EMR ?
	pfd			PIXELFORMATDESCRIPTOR ?
ends

SETICMPROFILE_EMBEDED		= 000000001h

struc	EMRSETICMPROFILE
	emr			EMR ?
	dwFlags 		dd ?		; flags
	cbName			dd ?		; Size of desired profile name
	cbData			dd ?		; Size of raw profile data if attached
label	Data			byte		; Array size is cbName + cbData
ends

COLORMATCHTOTARGET_EMBEDED	= 000000001h

struc	EMRCOLORMATCHTOTARGET
	emr			EMR ?
	dwAction		dd ?		; CS_ENABLE, CS_DISABLE or CS_DELETE_TRANSFORM
	dwFlags 		dd ?		; flags
	cbName			dd ?		; Size of desired target profile name
	cbData			dd ?		; Size of raw target profile data if attached
label	Data			byte		; Array size is cbName + cbData
ends

GDICOMMENT_IDENTIFIER		= 043494447h
GDICOMMENT_WINDOWS_METAFILE	= 080000001h
GDICOMMENT_BEGINGROUP		= 000000002h
GDICOMMENT_ENDGROUP		= 000000003h
GDICOMMENT_MULTIFORMATS 	= 040000004h
EPS_SIGNATURE			= 046535045h

procdesc wglCopyContext :dword, :dword, :dword
procdesc wglCreateContext :dword
procdesc wglCreateLayerContext :dword, :dword
procdesc wglDeleteContext :dword
procdesc wglGetCurrentContext
procdesc wglGetCurrentDC
procdesc wglGetProcAddress :dword
procdesc wglMakeCurrent :dword, :dword
procdesc wglShareLists :dword, :dword
procdesc wglUseFontBitmapsA :dword, :dword, :dword, :dword
procdesc SwapBuffers :dword

wglUseFontBitmaps		equ <wglUseFontBitmapsA>

struc	POINTFLOAT
	x			dd ?
	y			dd ?
ends

struc	GLYPHMETRICSFLOAT
	gmfBlackBoxX		dd ?
	gmfBlackBoxY		dd ?
	gmfptGlyphOrigin	POINTFLOAT ?
	gmfCellIncX		dd ?
	gmfCellIncY		dd ?
ends

WGL_FONT_LINES			= 0
WGL_FONT_POLYGONS		= 1

procdesc wglUseFontOutlinesA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

wglUseFontOutlines		equ <wglUseFontOutlinesA>

; Layer plane descriptor

struc	LAYERPLANEDESCRIPTOR			; lpd
	nSize			dw ?
	nVersion		dw ?
	dwFlags 		dd ?
	iPixelType		db ?
	cColorBits		db ?
	cRedBits		db ?
	cRedShift		db ?
	cGreenBits		db ?
	cGreenShift		db ?
	cBlueBits		db ?
	cBlueShift		db ?
	cAlphaBits		db ?
	cAlphaShift		db ?
	cAccumBits		db ?
	cAccumRedBits		db ?
	cAccumGreenBits 	db ?
	cAccumBlueBits		db ?
	cAccumAlphaBits 	db ?
	cDepthBits		db ?
	cStencilBits		db ?
	cAuxBuffers		db ?
	iLayerPlane		db ?
	bReserved		db ?
	crTransparent		dd ?
ends

; LAYERPLANEDESCRIPTOR flags
LPD_DOUBLEBUFFER		= 000000001h
LPD_STEREO			= 000000002h
LPD_SUPPORT_GDI 		= 000000010h
LPD_SUPPORT_OPENGL		= 000000020h
LPD_SHARE_DEPTH 		= 000000040h
LPD_SHARE_STENCIL		= 000000080h
LPD_SHARE_ACCUM 		= 000000100h
LPD_SWAP_EXCHANGE		= 000000200h
LPD_SWAP_COPY			= 000000400h
LPD_TRANSPARENT 		= 000001000h

LPD_TYPE_RGBA			= 0
LPD_TYPE_COLORINDEX		= 1

; wglSwapLayerBuffers flags
WGL_SWAP_MAIN_PLANE		= 000000001h
WGL_SWAP_OVERLAY1		= 000000002h
WGL_SWAP_OVERLAY2		= 000000004h
WGL_SWAP_OVERLAY3		= 000000008h
WGL_SWAP_OVERLAY4		= 000000010h
WGL_SWAP_OVERLAY5		= 000000020h
WGL_SWAP_OVERLAY6		= 000000040h
WGL_SWAP_OVERLAY7		= 000000080h
WGL_SWAP_OVERLAY8		= 000000100h
WGL_SWAP_OVERLAY9		= 000000200h
WGL_SWAP_OVERLAY10		= 000000400h
WGL_SWAP_OVERLAY11		= 000000800h
WGL_SWAP_OVERLAY12		= 000001000h
WGL_SWAP_OVERLAY13		= 000002000h
WGL_SWAP_OVERLAY14		= 000004000h
WGL_SWAP_OVERLAY15		= 000008000h
WGL_SWAP_UNDERLAY1		= 000010000h
WGL_SWAP_UNDERLAY2		= 000020000h
WGL_SWAP_UNDERLAY3		= 000040000h
WGL_SWAP_UNDERLAY4		= 000080000h
WGL_SWAP_UNDERLAY5		= 000100000h
WGL_SWAP_UNDERLAY6		= 000200000h
WGL_SWAP_UNDERLAY7		= 000400000h
WGL_SWAP_UNDERLAY8		= 000800000h
WGL_SWAP_UNDERLAY9		= 001000000h
WGL_SWAP_UNDERLAY10		= 002000000h
WGL_SWAP_UNDERLAY11		= 004000000h
WGL_SWAP_UNDERLAY12		= 008000000h
WGL_SWAP_UNDERLAY13		= 010000000h
WGL_SWAP_UNDERLAY14		= 020000000h
WGL_SWAP_UNDERLAY15		= 040000000h

procdesc wglDescribeLayerPlane :dword, :dword, :dword, :dword, :dword
procdesc wglSetLayerPaletteEntries :dword, :dword, :dword, :dword, :dword
procdesc wglGetLayerPaletteEntries :dword, :dword, :dword, :dword, :dword
procdesc wglRealizeLayerPalette :dword, :dword, :dword
procdesc wglSwapLayerBuffers :dword, :dword

struc	WGLSWAP
	hdc			dd ?
	uiFlags 		dd ?
ends

WGL_SWAPMULTIPLE_MAX		= 16

procdesc wglSwapMultipleBuffers :dword, :dword
