;++ BUILD Version: 0095     Increment this if a change has global effects
;
;Copyright (c) 1990-1998  Microsoft Corporation
;
;Module Name:
;
;    winnt.h
;
;Abstract:
;
;    This module defines the 32-Bit Windows types and constants that are
;    defined by NT, but exposed through the Win32 API.
;
;Revision History:
;
;--

ANYSIZE_ARRAY			= 1

APPLICATION_ERROR_MASK		= 020000000h
ERROR_SEVERITY_SUCCESS		= 000000000h
ERROR_SEVERITY_INFORMATIONAL	= 040000000h
ERROR_SEVERITY_WARNING		= 080000000h
ERROR_SEVERITY_ERROR		= 0C0000000h

struc	FLOAT128
	LowPart 		dq ?
	HighPart		dq ?
ends

MAXLONGLONG			equ 07ffffffffffffffh

struc	LARGE_INTEGER
	LowPart 		dd ?
	HighPart		dd ?
ends

;
; Locally Unique Identifier
;

struc	LUID
	LowPart 		dd ?
	HighPart		dd ?
ends

ANSI_NULL			= (0)
UNICODE_NULL			= (0)

;
;  Doubly linked list structure.  Can be used as either a list head, or
;  as link words.
;

struc	LIST_ENTRY
	Flink			dd ?
	Blink			dd ?
ends

;
;  Singly linked list structure. Can be used as either a list head, or
;  as link words.
;

struc	SINGLE_LIST_ENTRY
	Next			dd ?
ends


struc	GUID					; size is 16
	Data1			dd ?
	Data2			dw ?
	Data3			dw ?
	Data4			db ?
	Data5			db ?
	Data6			db ?
	Data7			db ?
	Data8			db ?
	Data9			db ?
	DataA			db ?
	DataB			db ?
ends

struc	OBJECTID				; size is 20
	Lineage 		GUID ?
	Uniquifier		dd ?
ends

MINCHAR 			= 080h
MAXCHAR 			= 07h
MINSHORT			= 08000h
MAXSHORT			= 07ffh
MINLONG 			= 080000000h
MAXLONG 			= 07ffffffh
MAXBYTE 			= 0fh
MAXWORD 			= 0fffh
MAXDWORD			= 0fffffffh

VER_SERVER_NT			= 080000000h
VER_WORKSTATION_NT		= 040000000h
VER_SUITE_SMALLBUSINESS 	= 000000001h
VER_SUITE_ENTERPRISE		= 000000002h
VER_SUITE_BACKOFFICE		= 000000004h
VER_SUITE_COMMUNICATIONS	= 000000008h
VER_SUITE_TERMINAL		= 000000010h
VER_SUITE_SMALLBUSINESS_RESTRICTED = 000000020h
VER_SUITE_EMBEDDEDNT		= 000000040h

;
;  Language IDs.
;
;  The following two combinations of primary language ID and
;  sublanguage ID have special semantics:
;
;    Primary Language ID   Sublanguage ID      Result
;    -------------------   ---------------     ------------------------
;    LANG_NEUTRAL	   SUBLANG_NEUTRAL     Language neutral
;    LANG_NEUTRAL	   SUBLANG_DEFAULT     User default language
;    LANG_NEUTRAL	   SUBLANG_SYS_DEFAULT System default language
;

;
;  Primary language IDs.
;

LANG_NEUTRAL			= 000h

LANG_AFRIKAANS			= 036h
LANG_ALBANIAN			= 01h
LANG_ARABIC			= 001h
LANG_ARMENIAN			= 02h
LANG_ASSAMESE			= 04h
LANG_AZERI			= 02h
LANG_BASQUE			= 02h
LANG_BELARUSIAN 		= 023h
LANG_BENGALI			= 045h
LANG_BULGARIAN			= 002h
LANG_CATALAN			= 003h
LANG_CHINESE			= 004h
LANG_CROATIAN			= 01h
LANG_CZECH			= 005h
LANG_DANISH			= 006h
LANG_DUTCH			= 013h
LANG_ENGLISH			= 009h
LANG_ESTONIAN			= 025h
LANG_FAEROESE			= 038h
LANG_FARSI			= 029h
LANG_FINNISH			= 00h
LANG_FRENCH			= 00h
LANG_GEORGIAN			= 037h
LANG_GERMAN			= 007h
LANG_GREEK			= 008h
LANG_GUJARATI			= 047h
LANG_HEBREW			= 00h
LANG_HINDI			= 039h
LANG_HUNGARIAN			= 00h
LANG_ICELANDIC			= 00h
LANG_INDONESIAN 		= 021h
LANG_ITALIAN			= 010h
LANG_JAPANESE			= 011h
LANG_KANNADA			= 04h
LANG_KASHMIRI			= 060h
LANG_KAZAK			= 03h
LANG_KONKANI			= 057h
LANG_KOREAN			= 012h
LANG_LATVIAN			= 026h
LANG_LITHUANIAN 		= 027h
LANG_MACEDONIAN 		= 02h
LANG_MALAY			= 03h
LANG_MALAYALAM			= 04h
LANG_MANIPURI			= 058h
LANG_MARATHI			= 04h
LANG_NEPALI			= 061h
LANG_NORWEGIAN			= 014h
LANG_ORIYA			= 048h
LANG_POLISH			= 015h
LANG_PORTUGUESE 		= 016h
LANG_PUNJABI			= 046h
LANG_ROMANIAN			= 018h
LANG_RUSSIAN			= 019h
LANG_SANSKRIT			= 04h
LANG_SERBIAN			= 01h
LANG_SINDHI			= 059h
LANG_SLOVAK			= 01h
LANG_SLOVENIAN			= 024h
LANG_SPANISH			= 00h
LANG_SWAHILI			= 041h
LANG_SWEDISH			= 01h
LANG_TAMIL			= 049h
LANG_TATAR			= 044h
LANG_TELUGU			= 04h
LANG_THAI			= 01h
LANG_TURKISH			= 01h
LANG_UKRAINIAN			= 022h
LANG_URDU			= 020h
LANG_UZBEK			= 043h
LANG_VIETNAMESE 		= 02h

;
;  Sublanguage IDs.
;
;  The name immediately following SUBLANG_ dictates which primary
;  language ID that sublanguage ID can be combined with to form a
;  valid language ID.
;

SUBLANG_NEUTRAL 		= 000h	  ; language neutral
SUBLANG_DEFAULT 		= 001h	  ; user default
SUBLANG_SYS_DEFAULT		= 002h	  ; system default

SUBLANG_ARABIC_SAUDI_ARABIA	= 001h	  ; Arabic (Saudi Arabia)
SUBLANG_ARABIC_IRAQ		= 002h	  ; Arabic (Iraq)
SUBLANG_ARABIC_EGYPT		= 003h	  ; Arabic (Egypt)
SUBLANG_ARABIC_LIBYA		= 004h	  ; Arabic (Libya)
SUBLANG_ARABIC_ALGERIA		= 005h	  ; Arabic (Algeria)
SUBLANG_ARABIC_MOROCCO		= 006h	  ; Arabic (Morocco)
SUBLANG_ARABIC_TUNISIA		= 007h	  ; Arabic (Tunisia)
SUBLANG_ARABIC_OMAN		= 008h	  ; Arabic (Oman)
SUBLANG_ARABIC_YEMEN		= 009h	  ; Arabic (Yemen)
SUBLANG_ARABIC_SYRIA		= 00h	 ; Arabic (Syria)
SUBLANG_ARABIC_JORDAN		= 00h	 ; Arabic (Jordan)
SUBLANG_ARABIC_LEBANON		= 00h	 ; Arabic (Lebanon)
SUBLANG_ARABIC_KUWAIT		= 00h	 ; Arabic (Kuwait)
SUBLANG_ARABIC_UAE		= 00h	 ; Arabic (U.A.E)
SUBLANG_ARABIC_BAHRAIN		= 00h	 ; Arabic (Bahrain)
SUBLANG_ARABIC_QATAR		= 010h	  ; Arabic (Qatar)
SUBLANG_AZERI_LATIN		= 001h	  ; Azeri (Latin)
SUBLANG_AZERI_CYRILLIC		= 002h	  ; Azeri (Cyrillic)
SUBLANG_CHINESE_TRADITIONAL	= 001h	  ; Chinese (Taiwan Region)
SUBLANG_CHINESE_SIMPLIFIED	= 002h	  ; Chinese (PR China)
SUBLANG_CHINESE_HONGKONG	= 003h	  ; Chinese (Hong Kong)
SUBLANG_CHINESE_SINGAPORE	= 004h	  ; Chinese (Singapore)
SUBLANG_CHINESE_MACAU		= 005h	  ; Chinese (Macau)
SUBLANG_DUTCH			= 001h	  ; Dutch
SUBLANG_DUTCH_BELGIAN		= 002h	  ; Dutch (Belgian)
SUBLANG_ENGLISH_US		= 001h	  ; English (USA)
SUBLANG_ENGLISH_UK		= 002h	  ; English (UK)
SUBLANG_ENGLISH_AUS		= 003h	  ; English (Australian)
SUBLANG_ENGLISH_CAN		= 004h	  ; English (Canadian)
SUBLANG_ENGLISH_NZ		= 005h	  ; English (New Zealand)
SUBLANG_ENGLISH_EIRE		= 006h	  ; English (Irish)
SUBLANG_ENGLISH_SOUTH_AFRICA	= 007h	  ; English (South Africa)
SUBLANG_ENGLISH_JAMAICA 	= 008h	  ; English (Jamaica)
SUBLANG_ENGLISH_CARIBBEAN	= 009h	  ; English (Caribbean)
SUBLANG_ENGLISH_BELIZE		= 00h	 ; English (Belize)
SUBLANG_ENGLISH_TRINIDAD	= 00h	 ; English (Trinidad)
SUBLANG_ENGLISH_ZIMBABWE	= 00h	 ; English (Zimbabwe)
SUBLANG_ENGLISH_PHILIPPINES	= 00h	 ; English (Philippines)
SUBLANG_FRENCH			= 001h	  ; French
SUBLANG_FRENCH_BELGIAN		= 002h	  ; French (Belgian)
SUBLANG_FRENCH_CANADIAN 	= 003h	  ; French (Canadian)
SUBLANG_FRENCH_SWISS		= 004h	  ; French (Swiss)
SUBLANG_FRENCH_LUXEMBOURG	= 005h	  ; French (Luxembourg)
SUBLANG_FRENCH_MONACO		= 006h	  ; French (Monaco)
SUBLANG_GERMAN			= 001h	  ; German
SUBLANG_GERMAN_SWISS		= 002h	  ; German (Swiss)
SUBLANG_GERMAN_AUSTRIAN 	= 003h	  ; German (Austrian)
SUBLANG_GERMAN_LUXEMBOURG	= 004h	  ; German (Luxembourg)
SUBLANG_GERMAN_LIECHTENSTEIN	= 005h	  ; German (Liechtenstein)
SUBLANG_ITALIAN 		= 001h	  ; Italian
SUBLANG_ITALIAN_SWISS		= 002h	  ; Italian (Swiss)
SUBLANG_KASHMIRI_INDIA		= 002h	  ; Kashmiri (India)
SUBLANG_KOREAN			= 001h	  ; Korean (Extended Wansung)
SUBLANG_LITHUANIAN		= 001h	  ; Lithuanian
SUBLANG_LITHUANIAN_CLASSIC	= 002h	  ; Lithuanian (Classic)
SUBLANG_MALAY_MALAYSIA		= 001h	  ; Malay (Malaysia)
SUBLANG_MALAY_BRUNEI_DARUSSALAM = 002h	  ; Malay (Brunei Darussalam)
SUBLANG_NEPALI_INDIA		= 002h	  ; Nepali (India)
SUBLANG_NORWEGIAN_BOKMAL	= 001h	  ; Norwegian (Bokmal)
SUBLANG_NORWEGIAN_NYNORSK	= 002h	  ; Norwegian (Nynorsk)
SUBLANG_PORTUGUESE		= 002h	  ; Portuguese
SUBLANG_PORTUGUESE_BRAZILIAN	= 001h	  ; Portuguese (Brazilian)
SUBLANG_SERBIAN_LATIN		= 002h	  ; Serbian (Latin)
SUBLANG_SERBIAN_CYRILLIC	= 003h	  ; Serbian (Cyrillic)
SUBLANG_SPANISH 		= 001h	  ; Spanish (Castilian)
SUBLANG_SPANISH_MEXICAN 	= 002h	  ; Spanish (Mexican)
SUBLANG_SPANISH_MODERN		= 003h	  ; Spanish (Modern)
SUBLANG_SPANISH_GUATEMALA	= 004h	  ; Spanish (Guatemala)
SUBLANG_SPANISH_COSTA_RICA	= 005h	  ; Spanish (Costa Rica)
SUBLANG_SPANISH_PANAMA		= 006h	  ; Spanish (Panama)
SUBLANG_SPANISH_DOMINICAN_REPUBLIC = 007h  ; Spanish (Dominican Republic)
SUBLANG_SPANISH_VENEZUELA	= 008h	  ; Spanish (Venezuela)
SUBLANG_SPANISH_COLOMBIA	= 009h	  ; Spanish (Colombia)
SUBLANG_SPANISH_PERU		= 00h	 ; Spanish (Peru)
SUBLANG_SPANISH_ARGENTINA	= 00h	 ; Spanish (Argentina)
SUBLANG_SPANISH_ECUADOR 	= 00h	 ; Spanish (Ecuador)
SUBLANG_SPANISH_CHILE		= 00h	 ; Spanish (Chile)
SUBLANG_SPANISH_URUGUAY 	= 00h	 ; Spanish (Uruguay)
SUBLANG_SPANISH_PARAGUAY	= 00h	 ; Spanish (Paraguay)
SUBLANG_SPANISH_BOLIVIA 	= 010h	  ; Spanish (Bolivia)
SUBLANG_SPANISH_EL_SALVADOR	= 011h	  ; Spanish (El Salvador)
SUBLANG_SPANISH_HONDURAS	= 012h	  ; Spanish (Honduras)
SUBLANG_SPANISH_NICARAGUA	= 013h	  ; Spanish (Nicaragua)
SUBLANG_SPANISH_PUERTO_RICO	= 014h	  ; Spanish (Puerto Rico)
SUBLANG_SWEDISH 		= 001h	  ; Swedish
SUBLANG_SWEDISH_FINLAND 	= 002h	  ; Swedish (Finland)
SUBLANG_URDU_PAKISTAN		= 001h	  ; Urdu (Pakistan)
SUBLANG_URDU_INDIA		= 002h	  ; Urdu (India)
SUBLANG_UZBEK_LATIN		= 001h	  ; Uzbek (Latin)
SUBLANG_UZBEK_CYRILLIC		= 002h	  ; Uzbek (Cyrillic)

;
;  Sorting IDs.
;

SORT_DEFAULT			= 00h	  ; sorting default

SORT_JAPANESE_XJIS		= 00h	  ; Japanese XJIS order
SORT_JAPANESE_UNICODE		= 01h	  ; Japanese Unicode order

SORT_CHINESE_BIG5		= 00h	  ; Chinese BIG5 order
SORT_CHINESE_PRCP		= 00h	  ; PRC Chinese Phonetic order
SORT_CHINESE_UNICODE		= 01h	  ; Chinese Unicode order
SORT_CHINESE_PRC		= 02h	  ; PRC Chinese Stroke Count order
SORT_CHINESE_BOPOMOFO		= 03h	  ; Traditional Chinese Bopomofo order

SORT_KOREAN_KSC 		= 00h	  ; Korean KSC order
SORT_KOREAN_UNICODE		= 01h	  ; Korean Unicode order

SORT_GERMAN_PHONE_BOOK		= 01h	  ; German Phone Book order

SORT_HUNGARIAN_DEFAULT		= 00h	  ; Hungarian Default order
SORT_HUNGARIAN_TECHNICAL	= 01h	  ; Hungarian Technical order

SORT_GEORGIAN_TRADITIONAL	= 00h	  ; Georgian Traditional order
SORT_GEORGIAN_MODERN		= 01h	  ; Georgian Modern order

;
;  A language ID is a 16 bit value which is the combination of a
;  primary language ID and a secondary language ID.  The bits are
;  allocated as follows:
;
;	+-----------------------+-------------------------+
;	|     Sublanguage ID	|   Primary Language ID   |
;	+-----------------------+-------------------------+
;	 15		      10 9			 0   bit
;
;
;  Language ID creation/extraction macros:
;
;    MAKELANGID    - construct language id from a primary language id and
;		     a sublanguage id.
;    PRIMARYLANGID - extract primary language id from a language id.
;    SUBLANGID	   - extract sublanguage id from a language id.
;

;
;  A locale ID is a 32 bit value which is the combination of a
;  language ID, a sort ID, and a reserved area.  The bits are
;  allocated as follows:
;
;	+-------------+---------+-------------------------+
;	|   Reserved  | Sort ID |      Language ID	  |
;	+-------------+---------+-------------------------+
;	 31	    20 19     16 15			 0   bit
;
;
;  Locale ID creation/extraction macros:
;
;    MAKELCID		 - construct the locale id from a language id and a sort id.
;    MAKESORTLCID	 - construct the locale id from a language id, sort id, and sort version.
;    LANGIDFROMLCID	 - extract the language id from a locale id.
;    SORTIDFROMLCID	 - extract the sort id from a locale id.
;    SORTVERSIONFROMLCID - extract the sort version from a locale id.
;

NLS_VALID_LOCALE_MASK		= 0000ffffh

;
;  Default System and User IDs for language and locale.
;

LANG_SYSTEM_DEFAULT		= LANG_NEUTRAL + (SUBLANG_SYS_DEFAULT shl 8)
LANG_USER_DEFAULT		= LANG_NEUTRAL + (SUBLANG_DEFAULT shl 8)

LOCALE_SYSTEM_DEFAULT		= LANG_SYSTEM_DEFAULT + (SORT_DEFAULT shl 16)
LOCALE_USER_DEFAULT		= LANG_USER_DEFAULT + (SORT_DEFAULT shl 16)

LOCALE_NEUTRAL			= LANG_NEUTRAL + (SUBLANG_NEUTRAL shl 8) +\
				  (SORT_DEFAULT shl 16)

STATUS_WAIT_0			= (000000000h)
STATUS_ABANDONED_WAIT_0 	= (000000080h)
STATUS_USER_APC 		= (0000000C0h)
STATUS_TIMEOUT			= (000000102h)
STATUS_PENDING			= (000000103h)
STATUS_SEGMENT_NOTIFICATION	= (040000005h)
STATUS_GUARD_PAGE_VIOLATION	= (080000001h)
STATUS_DATATYPE_MISALIGNMENT	= (080000002h)
STATUS_BREAKPOINT		= (080000003h)
STATUS_SINGLE_STEP		= (080000004h)
STATUS_ACCESS_VIOLATION 	= (0C0000005h)
STATUS_IN_PAGE_ERROR		= (0C0000006h)
STATUS_INVALID_HANDLE		= (0C0000008h)
STATUS_NO_MEMORY		= (0C0000017h)
STATUS_ILLEGAL_INSTRUCTION	= (0C000001Dh)
STATUS_NONCONTINUABLE_EXCEPTION = (0C0000025h)
STATUS_INVALID_DISPOSITION	= (0C0000026h)
STATUS_ARRAY_BOUNDS_EXCEEDED	= (0C000008Ch)
STATUS_FLOAT_DENORMAL_OPERAND	= (0C000008Dh)
STATUS_FLOAT_DIVIDE_BY_ZERO	= (0C000008Eh)
STATUS_FLOAT_INEXACT_RESULT	= (0C000008Fh)
STATUS_FLOAT_INVALID_OPERATION	= (0C0000090h)
STATUS_FLOAT_OVERFLOW		= (0C0000091h)
STATUS_FLOAT_STACK_CHECK	= (0C0000092h)
STATUS_FLOAT_UNDERFLOW		= (0C0000093h)
STATUS_INTEGER_DIVIDE_BY_ZERO	= (0C0000094h)
STATUS_INTEGER_OVERFLOW 	= (0C0000095h)
STATUS_PRIVILEGED_INSTRUCTION	= (0C0000096h)
STATUS_STACK_OVERFLOW		= (0C00000FDh)
STATUS_CONTROL_C_EXIT		= (0C000013Ah)
STATUS_FLOAT_MULTIPLE_FAULTS	= (0C00002B4h)
STATUS_FLOAT_MULTIPLE_TRAPS	= (0C00002B5h)
STATUS_ILLEGAL_VLM_REFERENCE	= (0C00002C0h)
STATUS_REG_NAT_CONSUMPTION	= (0C00002C9h)

MAXIMUM_WAIT_OBJECTS		= 64	 ; Maximum number of wait objects

MAXIMUM_SUSPEND_COUNT		= MAXCHAR ; Maximum times thread can be suspended

; x86 context

SIZE_OF_80387_REGISTERS 	= 80

;
; The following flags control the contents of the CONTEXT structure.
;

CONTEXT_i386			= 000010000h	; this assumes that i386 and
CONTEXT_i486			= 000010000h	; i486 have identical context records

CONTEXT_CONTROL 		= (CONTEXT_i386 + 000000001h) ; SS:SP, CS:IP, FLAGS, BP
CONTEXT_INTEGER 		= (CONTEXT_i386 + 000000002h) ; AX, BX, CX, DX, SI, DI
CONTEXT_SEGMENTS		= (CONTEXT_i386 + 000000004h) ; DS, ES, FS, GS
CONTEXT_FLOATING_POINT		= (CONTEXT_i386 + 000000008h) ; 387 state
CONTEXT_DEBUG_REGISTERS 	= (CONTEXT_i386 + 000000010h) ; DB 0-3,6,7
CONTEXT_EXTENDED_REGISTERS	= (CONTEXT_i386 + 000000020h) ; cpu specific extensions

CONTEXT_FULL			= (CONTEXT_CONTROL + CONTEXT_INTEGER +\
				   CONTEXT_SEGMENTS)

MAXIMUM_SUPPORTED_EXTENSION	= 512

struc	FLOATING_SAVE_AREA
	ControlWord		dd ?
	StatusWord		dd ?
	TagWord 		dd ?
	ErrorOffset		dd ?
	ErrorSelector		dd ?
	DataOffset		dd ?
	DataSelector		dd ?
	RegisterArea		db SIZE_OF_80387_REGISTERS dup (?)
	Cr0NpxState		dd ?
ends

;
; Context Frame
;
;  This frame has a several purposes: 1) it is used as an argument to
;  NtContinue, 2) is is used to constuct a call frame for APC delivery,
;  and 3) it is used in the user level thread creation routines.
;
;  The layout of the record conforms to a standard call frame.
;

struc	CONTEXT
;
; The flags values within this flag control the contents of
; a CONTEXT record.
;
; If the context record is used as an input parameter, then
; for each portion of the context record controlled by a flag
; whose value is set, it is assumed that that portion of the
; context record contains valid context. If the context record
; is being used to modify a threads context, then only that
; portion of the threads context will be modified.
;
; If the context record is used as an IN OUT parameter to capture
; the context of a thread, then only those portions of the thread's
; context corresponding to set flags will be returned.
;
; The context record is never used as an OUT only parameter.
;
	ContextFlags		dd ?
;
; This section is specified/returned if CONTEXT_DEBUG_REGISTERS is
; set in ContextFlags.	Note that CONTEXT_DEBUG_REGISTERS is NOT
; included in CONTEXT_FULL.
;
	_Dr0			dd ?
	_Dr1			dd ?
	_Dr2			dd ?
	_Dr3			dd ?
	_Dr6			dd ?
	_Dr7			dd ?
;
; This section is specified/returned if the
; ContextFlags word contians the flag CONTEXT_FLOATING_POINT.
;
	FloatSave		FLOATING_SAVE_AREA ?
;
; This section is specified/returned if the
; ContextFlags word contians the flag CONTEXT_SEGMENTS.
;
	_SegGs			dd ?
	_SegFs			dd ?
	_SegEs			dd ?
	_SegDs			dd ?
;
; This section is specified/returned if the
; ContextFlags word contians the flag CONTEXT_INTEGER.
;
	_Edi			dd ?
	_Esi			dd ?
	_Ebx			dd ?
	_Edx			dd ?
	_Ecx			dd ?
	_Eax			dd ?
;
; This section is specified/returned if the
; ContextFlags word contians the flag CONTEXT_CONTROL.
;
	_Ebp			dd ?
	_Eip			dd ?
	_SegCs			dd ?		; MUST BE SANITIZED
	_EFlags 		dd ?		; MUST BE SANITIZED
	_Esp			dd ?
	_SegSs			dd ?
;
; This section is specified/returned if the ContextFlags word
; contains the flag CONTEXT_EXTENDED_REGISTERS.
; The format and contexts are processor specific
;
	ExtendedRegisters	db MAXIMUM_SUPPORTED_EXTENSION dup (?)
ends


struc	LDT_ENTRY
	LimitLow		dw ?
	BaseLow 		dw ?
	BaseMid 		db ?
	Flags1			db ?
;	Type			dd  : 5 ?
;	Dpl			dd  : 2 ?
;	Pres			dd  : 1 ?
	Flags2			db ?
;	LimitHi 		dd  : 4 ?
;	Sys			dd  : 1 ?
;	Reserved_0		dd  : 1 ?
;	Default_Big		dd  : 1 ?
;	Granularity		dd  : 1 ?
	BaseHi			db ?
ends

EXCEPTION_NONCONTINUABLE	= 01h	 ; Noncontinuable exception
EXCEPTION_MAXIMUM_PARAMETERS	= 15 ; maximum number of exception parameters

;
; Exception record definition.
;

struc	EXCEPTION_RECORD
	ExceptionCode		dd ?
	ExceptionFlags		dd ?
	ExceptionRecord 	dd ?
	ExceptionAddress	dd ?
	NumberParameters	dd ?
	ExceptionInformation	dd EXCEPTION_MAXIMUM_PARAMETERS dup (?)
ends

;
; Typedef for pointer returned by exception_info()
;

struc	EXCEPTION_POINTERS
	ExceptionRecord 	dd ?
	ContextRecord		dd ?
ends

;//////////////////////////////////////////////////////////////////////
;								     //
;			      ACCESS MASK			     //
;								     //
;//////////////////////////////////////////////////////////////////////

;
;  Define the access mask as a longword sized structure divided up as
;  follows:
;
;	3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;	1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;      +---------------+---------------+-------------------------------+
;      |G|G|G|G|Res'd|A| StandardRights|	 SpecificRights        |
;      |R|W|E|A|     |S|	       |			       |
;      +-+-------------+---------------+-------------------------------+
;
;      typedef struct _ACCESS_MASK {
;	   WORD   SpecificRights;
;	   BYTE  StandardRights;
;	   BYTE  AccessSystemAcl : 1;
;	   BYTE  Reserved : 3;
;	   BYTE  GenericAll : 1;
;	   BYTE  GenericExecute : 1;
;	   BYTE  GenericWrite : 1;
;	   BYTE  GenericRead : 1;
;      } ACCESS_MASK;
;      typedef ACCESS_MASK *PACCESS_MASK;
;
;  but to make life simple for programmer's we'll allow them to specify
;  a desired access mask by simply OR'ing together mulitple single rights
;  and treat an access mask as a DWORD.  For example
;
;      DesiredAccess = DELETE | READ_CONTROL
;
;  So we'll declare ACCESS_MASK as DWORD
;

;//////////////////////////////////////////////////////////////////////
;								     //
;			      ACCESS TYPES			     //
;								     //
;//////////////////////////////////////////////////////////////////////

;
;  The following are masks for the predefined standard access types
;

DELETE				= (000010000h)
READ_CONTROL			= (000020000h)
WRITE_DAC			= (000040000h)
WRITE_OWNER			= (000080000h)
SYNCHRONIZE			= (000100000h)

STANDARD_RIGHTS_REQUIRED	= (0000F0000h)

STANDARD_RIGHTS_READ		= (READ_CONTROL)
STANDARD_RIGHTS_WRITE		= (READ_CONTROL)
STANDARD_RIGHTS_EXECUTE 	= (READ_CONTROL)

STANDARD_RIGHTS_ALL		= (0001F0000h)

SPECIFIC_RIGHTS_ALL		= (00000FFFFh)

;
; AccessSystemAcl access type
;

ACCESS_SYSTEM_SECURITY		= (001000000h)

;
; MaximumAllowed access type
;

MAXIMUM_ALLOWED 		= (002000000h)

;
;  These are the generic rights.
;

GENERIC_READ			= (080000000h)
GENERIC_WRITE			= (040000000h)
GENERIC_EXECUTE 		= (020000000h)
GENERIC_ALL			= (010000000h)


;
;  Define the generic mapping array.  This is used to denote the
;  mapping of each generic access right to a specific access mask.
;

struc	GENERIC_MAPPING
	GenericRead		dd ?
	GenericWrite		dd ?
	GenericExecute		dd ?
	GenericAll		dd ?
ends

;//////////////////////////////////////////////////////////////////////
;								     //
;			 LUID_AND_ATTRIBUTES			     //
;								     //
;//////////////////////////////////////////////////////////////////////

struc	LUID_AND_ATTRIBUTES
	Luid			LUID ?
	Attributes		dd ?
ends

;//////////////////////////////////////////////////////////////////////
;								     //
;	       Security Id     (SID)				     //
;								     //
;//////////////////////////////////////////////////////////////////////
;
;
; Pictorially the structure of an SID is as follows:
;
;	  1   1   1   1   1   1
;	  5   4   3   2   1   0   9   8   7   6   5   4   3   2   1   0
;      +---------------------------------------------------------------+
;      |      SubAuthorityCount        |Reserved1 (SBZ)|   Revision    |
;      +---------------------------------------------------------------+
;      |		   IdentifierAuthority[0]		       |
;      +---------------------------------------------------------------+
;      |		   IdentifierAuthority[1]		       |
;      +---------------------------------------------------------------+
;      |		   IdentifierAuthority[2]		       |
;      +---------------------------------------------------------------+
;      |							       |
;      +- -  -	-  -  -  -  -  SubAuthority[]  -  -  -	-  -  -  -  - -+
;      |							       |
;      +---------------------------------------------------------------+
;
;

struc	SID_IDENTIFIER_AUTHORITY
	Value			db 6 dup (?)
ends

struc	SID
	Revision		db ?
	SubAuthorityCount	db ?
	IdentifierAuthority	SID_IDENTIFIER_AUTHORITY ?
	SubAuthority		dd ANYSIZE_ARRAY dup (?)
ends

SID_REVISION			= (1)	 ; Current revision level
SID_MAX_SUB_AUTHORITIES 	= (15)
SID_RECOMMENDED_SUB_AUTHORITIES = (1)	 ; Will change to around 6
						; in a future release.
enum	SID_NAME_USE\
	SidTypeUser=1,\
	SidTypeGroup,\
	SidTypeDomain,\
	SidTypeAlias,\
	SidTypeWellKnownGroup,\
	SidTypeDeletedAccount,\
	SidTypeInvalid,\
	SidTypeUnknown,\
	SidTypeComputer

struc	SID_AND_ATTRIBUTES
	Sid			dd ?
	Attributes		dd ?
ends

;///////////////////////////////////////////////////////////////////////////
;									  //
; Universal well-known SIDs						  //
;									  //
;     Null SID			   S-1-0-0				  //
;     World			   S-1-1-0				  //
;     Local			   S-1-2-0				  //
;     Creator Owner ID		   S-1-3-0				  //
;     Creator Group ID		   S-1-3-1				  //
;     Creator Owner Server ID	   S-1-3-2				  //
;     Creator Group Server ID	   S-1-3-3				  //
;									  //
;     (Non-unique IDs)		   S-1-4				  //
;									  //
;///////////////////////////////////////////////////////////////////////////

SECURITY_NULL_SID_AUTHORITY	equ <<0,0,0,0,0,0>>
SECURITY_WORLD_SID_AUTHORITY	equ <<0,0,0,0,0,1>>
SECURITY_LOCAL_SID_AUTHORITY	equ <<0,0,0,0,0,2>>
SECURITY_CREATOR_SID_AUTHORITY	equ <<0,0,0,0,0,3>>
SECURITY_NON_UNIQUE_AUTHORITY	equ <<0,0,0,0,0,4>>

SECURITY_NULL_RID		= (000000000h)
SECURITY_WORLD_RID		= (000000000h)
SECURITY_LOCAL_RID		= (000000000h)

SECURITY_CREATOR_OWNER_RID	= (000000000h)
SECURITY_CREATOR_GROUP_RID	= (000000001h)

SECURITY_CREATOR_OWNER_SERVER_RID = (000000002h)
SECURITY_CREATOR_GROUP_SERVER_RID = (000000003h)

;///////////////////////////////////////////////////////////////////////////
;									  //
; NT well-known SIDs							  //
;									  //
;     NT Authority	    S-1-5					  //
;     Dialup		    S-1-5-1					  //
;									  //
;     Network		    S-1-5-2					  //
;     Batch		    S-1-5-3					  //
;     Interactive	    S-1-5-4					  //
;     Service		    S-1-5-6					  //
;     AnonymousLogon	    S-1-5-7	  (aka null logon session)	  //
;     Proxy		    S-1-5-8					  //
;     ServerLogon	    S-1-5-9	  (aka domain controller account) //
;     Self		    S-1-5-10	  (self RID)			  //
;     Authenticated User    S-1-5-11	  (Authenticated user somewhere)  //
;     Restricted Code	    S-1-5-12	  (Running restricted code)	  //
;									  //
;     (Logon IDs)	    S-1-5-5-X-Y 				  //
;									  //
;     (NT non-unique IDs)   S-1-5-0x15-...				  //
;									  //
;     (Built-in domain)     s-1-5-0x20					  //
;									  //
;///////////////////////////////////////////////////////////////////////////


SECURITY_NT_AUTHORITY		equ <<0,0,0,0,0,5>>   ; ntifs

SECURITY_DIALUP_RID		= (000000001h)
SECURITY_NETWORK_RID		= (000000002h)
SECURITY_BATCH_RID		= (000000003h)
SECURITY_INTERACTIVE_RID	= (000000004h)
SECURITY_SERVICE_RID		= (000000006h)
SECURITY_ANONYMOUS_LOGON_RID	= (000000007h)
SECURITY_PROXY_RID		= (000000008h)
SECURITY_ENTERPRISE_CONTROLLERS_RID = (000000009h)
SECURITY_SERVER_LOGON_RID	= SECURITY_ENTERPRISE_CONTROLLERS_RID
SECURITY_PRINCIPAL_SELF_RID	= (00000000Ah)
SECURITY_AUTHENTICATED_USER_RID = (00000000Bh)
SECURITY_RESTRICTED_CODE_RID	= (00000000Ch)

SECURITY_LOGON_IDS_RID		= (000000005h)
SECURITY_LOGON_IDS_RID_COUNT	= (3)

SECURITY_LOCAL_SYSTEM_RID	= (000000012h)

SECURITY_NT_NON_UNIQUE		= (000000015h)

SECURITY_BUILTIN_DOMAIN_RID	= (000000020h)

;///////////////////////////////////////////////////////////////////////////
;									  //
; well-known domain relative sub-authority values (RIDs)...		  //
;									  //
;///////////////////////////////////////////////////////////////////////////

; Well-known users ...

DOMAIN_USER_RID_ADMIN		= (0000001F4h)
DOMAIN_USER_RID_GUEST		= (0000001F5h)
DOMAIN_USER_RID_KRBTGT		= (0000001F6h)

; well-known groups ...

DOMAIN_GROUP_RID_ADMINS 	= (000000200h)
DOMAIN_GROUP_RID_USERS		= (000000201h)
DOMAIN_GROUP_RID_GUESTS 	= (000000202h)
DOMAIN_GROUP_RID_COMPUTERS	= (000000203h)
DOMAIN_GROUP_RID_CONTROLLERS	= (000000204h)
DOMAIN_GROUP_RID_CERT_ADMINS	= (000000205h)
DOMAIN_GROUP_RID_SCHEMA_ADMINS	= (000000206h)
DOMAIN_GROUP_RID_ENTERPRISE_ADMINS = (000000207h)

; well-known aliases ...

DOMAIN_ALIAS_RID_ADMINS 	= (000000220h)
DOMAIN_ALIAS_RID_USERS		= (000000221h)
DOMAIN_ALIAS_RID_GUESTS 	= (000000222h)
DOMAIN_ALIAS_RID_POWER_USERS	= (000000223h)

DOMAIN_ALIAS_RID_ACCOUNT_OPS	= (000000224h)
DOMAIN_ALIAS_RID_SYSTEM_OPS	= (000000225h)
DOMAIN_ALIAS_RID_PRINT_OPS	= (000000226h)
DOMAIN_ALIAS_RID_BACKUP_OPS	= (000000227h)

DOMAIN_ALIAS_RID_REPLICATOR	= (000000228h)
DOMAIN_ALIAS_RID_RAS_SERVERS	= (000000229h)

;
; Allocate the System Luid.  The first 1000 LUIDs are reserved.
; Use #999 here (0x3E7 = 999)
;

SYSTEM_LUID			equ << 03E7h, 00h >>
ANONYMOUS_LOGON_LUID		equ << 03e6h, 00h >>

;//////////////////////////////////////////////////////////////////////
;								     //
;			   User and Group related SID attributes     //
;								     //
;//////////////////////////////////////////////////////////////////////

;
; Group attributes
;

SE_GROUP_MANDATORY		= (000000001h)
SE_GROUP_ENABLED_BY_DEFAULT	= (000000002h)
SE_GROUP_ENABLED		= (000000004h)
SE_GROUP_OWNER			= (000000008h)
SE_GROUP_USE_FOR_DENY_ONLY	= (000000010h)
SE_GROUP_LOGON_ID		= (0C0000000h)

;//////////////////////////////////////////////////////////////////////
;								     //
;			  ACL  and  ACE 			     //
;								     //
;//////////////////////////////////////////////////////////////////////

;
;  Define an ACL and the ACE format.  The structure of an ACL header
;  followed by one or more ACEs.  Pictorally the structure of an ACL header
;  is as follows:
;
;	3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;	1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;      +-------------------------------+---------------+---------------+
;      |	    AclSize	       |      Sbz1     |  AclRevision  |
;      +-------------------------------+---------------+---------------+
;      |	      Sbz2	       |	   AceCount	       |
;      +-------------------------------+-------------------------------+
;
;  The current AclRevision is defined to be ACL_REVISION.
;
;  AclSize is the size, in bytes, allocated for the ACL.  This includes
;  the ACL header, ACES, and remaining free space in the buffer.
;
;  AceCount is the number of ACES in the ACL.
;

; This is the *current* ACL revision

ACL_REVISION			= (2)
ACL_REVISION_DS 		= (4)

; This is the history of ACL revisions.  Add a new one whenever
; ACL_REVISION is updated

ACL_REVISION1			= (1)
MIN_ACL_REVISION		= ACL_REVISION2
ACL_REVISION2			= (2)
ACL_REVISION3			= (3)
ACL_REVISION4			= (4)
MAX_ACL_REVISION		= ACL_REVISION4

struc	ACL
	AclRevision		db ?
	Sbz1			db ?
	AclSize 		dw ?
	AceCount		dw ?
	Sbz2			dw ?
ends

;
;  The structure of an ACE is a common ace header followed by ace type
;  specific data.  Pictorally the structure of the common ace header is
;  as follows:
;
;	3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;	1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;      +---------------+-------+-------+---------------+---------------+
;      |	    AceSize	       |    AceFlags   |     AceType   |
;      +---------------+-------+-------+---------------+---------------+
;
;  AceType denotes the type of the ace, there are some predefined ace
;  types
;
;  AceSize is the size, in bytes, of ace.
;
;  AceFlags are the Ace flags for audit and inheritance, defined shortly.

struc	ACE_HEADER
	AceType 		db ?
	AceFlags		db ?
	AceSize 		dw ?
ends

;
;  The following are the predefined ace types that go into the AceType
;  field of an Ace header.
;

ACCESS_MIN_MS_ACE_TYPE		= (00h)
ACCESS_ALLOWED_ACE_TYPE 	= (00h)
ACCESS_DENIED_ACE_TYPE		= (01h)
SYSTEM_AUDIT_ACE_TYPE		= (02h)
SYSTEM_ALARM_ACE_TYPE		= (03h)
ACCESS_MAX_MS_V2_ACE_TYPE	= (03h)

ACCESS_ALLOWED_COMPOUND_ACE_TYPE = (04h)
ACCESS_MAX_MS_V3_ACE_TYPE	= (04h)

ACCESS_MIN_MS_OBJECT_ACE_TYPE	= (05h)
ACCESS_ALLOWED_OBJECT_ACE_TYPE	= (05h)
ACCESS_DENIED_OBJECT_ACE_TYPE	= (06h)
SYSTEM_AUDIT_OBJECT_ACE_TYPE	= (07h)
SYSTEM_ALARM_OBJECT_ACE_TYPE	= (08h)
ACCESS_MAX_MS_OBJECT_ACE_TYPE	= (08h)

ACCESS_MAX_MS_V4_ACE_TYPE	= (08h)
ACCESS_MAX_MS_ACE_TYPE		= (08h)

;
;  The following are the inherit flags that go into the AceFlags field
;  of an Ace header.
;

OBJECT_INHERIT_ACE		= (01h)
CONTAINER_INHERIT_ACE		= (02h)
NO_PROPAGATE_INHERIT_ACE	= (04h)
INHERIT_ONLY_ACE		= (08h)
INHERITED_ACE			= (010h)
VALID_INHERIT_FLAGS		= (01Fh)

;  The following are the currently defined ACE flags that go into the
;  AceFlags field of an ACE header.  Each ACE type has its own set of
;  AceFlags.
;
;  SUCCESSFUL_ACCESS_ACE_FLAG - used only with system audit and alarm ACE
;  types to indicate that a message is generated for successful accesses.
;
;  FAILED_ACCESS_ACE_FLAG - used only with system audit and alarm ACE types
;  to indicate that a message is generated for failed accesses.
;

;
;  SYSTEM_AUDIT and SYSTEM_ALARM AceFlags
;
;  These control the signaling of audit and alarms for success or failure.
;

SUCCESSFUL_ACCESS_ACE_FLAG	= (040h)
FAILED_ACCESS_ACE_FLAG		= (080h)

;
;  We'll define the structure of the predefined ACE types.  Pictorally
;  the structure of the predefined ACE's is as follows:
;
;	3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;	1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;      +---------------+-------+-------+---------------+---------------+
;      |    AceFlags   | Resd  |Inherit|    AceSize    |     AceType   |
;      +---------------+-------+-------+---------------+---------------+
;      |			      Mask			       |
;      +---------------------------------------------------------------+
;      |							       |
;      +							       +
;      |							       |
;      +			      Sid			       +
;      |							       |
;      +							       +
;      |							       |
;      +---------------------------------------------------------------+
;
;  Mask is the access mask associated with the ACE.  This is either the
;  access allowed, access denied, audit, or alarm mask.
;
;  Sid is the Sid associated with the ACE.
;

;  The following are the four predefined ACE types.

;  Examine the AceType field in the Header to determine
;  which structure is appropriate to use for casting.



struc	ACCESS_ALLOWED_ACE
	Header			ACE_HEADER ?
	Mask			dd ?
	SidStart		dd ?
ends

struc	ACCESS_DENIED_ACE
	Header			ACE_HEADER ?
	Mask			dd ?
	SidStart		dd ?
ends

struc	SYSTEM_AUDIT_ACE
	Header			ACE_HEADER ?
	Mask			dd ?
	SidStart		dd ?
ends

struc	SYSTEM_ALARM_ACE
	Header			ACE_HEADER ?
	Mask			dd ?
	SidStart		dd ?
ends

struc	ACCESS_ALLOWED_OBJECT_ACE
	Header			ACE_HEADER ?
	Mask			dd ?
	Flags			dd ?
	ObjectType		GUID ?
	InheritedObjectType	GUID ?
	SidStart		dd ?
ends

struc	ACCESS_DENIED_OBJECT_ACE
	Header			ACE_HEADER ?
	Mask			dd ?
	Flags			dd ?
	ObjectType		GUID ?
	InheritedObjectType	GUID ?
	SidStart		dd ?
ends

struc	SYSTEM_AUDIT_OBJECT_ACE
	Header			ACE_HEADER ?
	Mask			dd ?
	Flags			dd ?
	ObjectType		GUID ?
	InheritedObjectType	GUID ?
	SidStart		dd ?
ends

struc	SYSTEM_ALARM_OBJECT_ACE
	Header			ACE_HEADER ?
	Mask			dd ?
	Flags			dd ?
	ObjectType		GUID ?
	InheritedObjectType	GUID ?
	SidStart		dd ?
ends

;
; Currently define Flags for "OBJECT" ACE types.
;

ACE_OBJECT_TYPE_PRESENT 	= 01h
ACE_INHERITED_OBJECT_TYPE_PRESENT = 02h

;
;  The following declarations are used for setting and querying information
;  about and ACL.  First are the various information classes available to
;  the user.
;

enum	ACL_INFORMATION_CLASS\
	AclRevisionInformation=1,\
	AclSizeInformation

;
;  This record is returned/sent if the user is requesting/setting the
;  AclRevisionInformation
;

struc	ACL_REVISION_INFORMATION
	AclRevision		dd ?
ends

;
;  This record is returned if the user is requesting AclSizeInformation
;

struc	ACL_SIZE_INFORMATION
	AceCount		dd ?
	AclBytesInUse		dd ?
	AclBytesFree		dd ?
ends

;//////////////////////////////////////////////////////////////////////
;								     //
;			      SECURITY_DESCRIPTOR		     //
;								     //
;//////////////////////////////////////////////////////////////////////
;
;  Define the Security Descriptor and related data types.
;  This is an opaque data structure.
;

;
; Current security descriptor revision value
;

SECURITY_DESCRIPTOR_REVISION	= (1)
SECURITY_DESCRIPTOR_REVISION1	= (1)

SECURITY_DESCRIPTOR_MIN_LENGTH	= (size SECURITY_DESCRIPTOR)

SE_OWNER_DEFAULTED		= (00001h)
SE_GROUP_DEFAULTED		= (00002h)
SE_DACL_PRESENT 		= (00004h)
SE_DACL_DEFAULTED		= (00008h)
SE_SACL_PRESENT 		= (00010h)
SE_SACL_DEFAULTED		= (00020h)
SE_DACL_AUTO_INHERIT_REQ	= (00100h)
SE_SACL_AUTO_INHERIT_REQ	= (00200h)
SE_DACL_AUTO_INHERITED		= (00400h)
SE_SACL_AUTO_INHERITED		= (00800h)
SE_DACL_PROTECTED		= (01000h)
SE_SACL_PROTECTED		= (02000h)
SE_SELF_RELATIVE		= (08000h)

;
;  Where:
;
;      SE_OWNER_DEFAULTED - This boolean flag, when set, indicates that the
;	   SID pointed to by the Owner field was provided by a
;	   defaulting mechanism rather than explicitly provided by the
;	   original provider of the security descriptor.  This may
;	   affect the treatment of the SID with respect to inheritence
;	   of an owner.
;
;      SE_GROUP_DEFAULTED - This boolean flag, when set, indicates that the
;	   SID in the Group field was provided by a defaulting mechanism
;	   rather than explicitly provided by the original provider of
;	   the security descriptor.  This may affect the treatment of
;	   the SID with respect to inheritence of a primary group.
;
;      SE_DACL_PRESENT - This boolean flag, when set, indicates that the
;	   security descriptor contains a discretionary ACL.  If this
;	   flag is set and the Dacl field of the SECURITY_DESCRIPTOR is
;	   null, then a null ACL is explicitly being specified.
;
;      SE_DACL_DEFAULTED - This boolean flag, when set, indicates that the
;	   ACL pointed to by the Dacl field was provided by a defaulting
;	   mechanism rather than explicitly provided by the original
;	   provider of the security descriptor.  This may affect the
;	   treatment of the ACL with respect to inheritence of an ACL.
;	   This flag is ignored if the DaclPresent flag is not set.
;
;      SE_SACL_PRESENT - This boolean flag, when set,  indicates that the
;	   security descriptor contains a system ACL pointed to by the
;	   Sacl field.	If this flag is set and the Sacl field of the
;	   SECURITY_DESCRIPTOR is null, then an empty (but present)
;	   ACL is being specified.
;
;      SE_SACL_DEFAULTED - This boolean flag, when set, indicates that the
;	   ACL pointed to by the Sacl field was provided by a defaulting
;	   mechanism rather than explicitly provided by the original
;	   provider of the security descriptor.  This may affect the
;	   treatment of the ACL with respect to inheritence of an ACL.
;	   This flag is ignored if the SaclPresent flag is not set.
;
;      SE_SELF_RELATIVE - This boolean flag, when set, indicates that the
;	   security descriptor is in self-relative form.  In this form,
;	   all fields of the security descriptor are contiguous in memory
;	   and all pointer fields are expressed as offsets from the
;	   beginning of the security descriptor.  This form is useful
;	   for treating security descriptors as opaque data structures
;	   for transmission in communication protocol or for storage on
;	   secondary media.
;
;
;
; Pictorially the structure of a security descriptor is as follows:
;
;	3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;	1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;      +---------------------------------------------------------------+
;      |	    Control	       |Reserved1 (SBZ)|   Revision    |
;      +---------------------------------------------------------------+
;      |			    Owner			       |
;      +---------------------------------------------------------------+
;      |			    Group			       |
;      +---------------------------------------------------------------+
;      |			    Sacl			       |
;      +---------------------------------------------------------------+
;      |			    Dacl			       |
;      +---------------------------------------------------------------+
;
; In general, this data structure should be treated opaquely to ensure future
; compatibility.
;
;

struc	SECURITY_DESCRIPTOR_RELATIVE
	Revision		db ?
	Sbz1			db ?
	Control 		dw ?
	Owner			dd ?
	_Group			dd ?
	Sacl			dd ?
	Dacl			dd ?
ends

struc	SECURITY_DESCRIPTOR
	Revision		db ?
	Sbz1			db ?
	Control 		dw ?
	Owner			dd ?
	_Group			dd ?
	Sacl			dd ?
	Dacl			dd ?
ends

; Where:
;
;     Revision - Contains the revision level of the security
;	  descriptor.  This allows this structure to be passed between
;	  systems or stored on disk even though it is expected to
;	  change in the future.
;
;     Control - A set of flags which qualify the meaning of the
;	  security descriptor or individual fields of the security
;	  descriptor.
;
;     Owner - is a pointer to an SID representing an object's owner.
;	  If this field is null, then no owner SID is present in the
;	  security descriptor.	If the security descriptor is in
;	  self-relative form, then this field contains an offset to
;	  the SID, rather than a pointer.
;
;     Group - is a pointer to an SID representing an object's primary
;	  group.  If this field is null, then no primary group SID is
;	  present in the security descriptor.  If the security descriptor
;	  is in self-relative form, then this field contains an offset to
;	  the SID, rather than a pointer.
;
;     Sacl - is a pointer to a system ACL.  This field value is only
;	  valid if the DaclPresent control flag is set.  If the
;	  SaclPresent flag is set and this field is null, then a null
;	  ACL  is specified.  If the security descriptor is in
;	  self-relative form, then this field contains an offset to
;	  the ACL, rather than a pointer.
;
;     Dacl - is a pointer to a discretionary ACL.  This field value is
;	  only valid if the DaclPresent control flag is set.  If the
;	  DaclPresent flag is set and this field is null, then a null
;	  ACL (unconditionally granting access) is specified.  If the
;	  security descriptor is in self-relative form, then this field
;	  contains an offset to the ACL, rather than a pointer.
;

;//////////////////////////////////////////////////////////////////////
;								     //
;		Object Type list for AccessCheckByType		     //
;								     //
;//////////////////////////////////////////////////////////////////////


struc	OBJECT_TYPE_LIST
	Level			dw ?
	Sbz			dw ?
	ObjectType		dd ?
ends

;
; DS values for Level
;

ACCESS_OBJECT_GUID		= 0
ACCESS_PROPERTY_SET_GUID	= 1
ACCESS_PROPERTY_GUID		= 2

ACCESS_MAX_LEVEL		= 4

;
; Parameters to NtAccessCheckByTypeAndAditAlarm
;

enum	AUDIT_EVENT_TYPE\
	AuditEventObjectAccess,\
	AuditEventDirectoryServiceAccess

AUDIT_ALLOW_NO_PRIVILEGE	= 01h

;
; DS values for Source and ObjectTypeName
;

ACCESS_DS_SOURCE_A		equ <'DS', 0>
ACCESS_DS_OBJECT_TYPE_NAME_A	equ <'Directory Service Object', 0>

;//////////////////////////////////////////////////////////////////////
;								     //
;		Privilege Related Data Structures		     //
;								     //
;//////////////////////////////////////////////////////////////////////

;
; Privilege attributes
;

SE_PRIVILEGE_ENABLED_BY_DEFAULT = (000000001h)
SE_PRIVILEGE_ENABLED		= (000000002h)
SE_PRIVILEGE_USED_FOR_ACCESS	= (080000000h)

;
; Privilege Set Control flags
;

PRIVILEGE_SET_ALL_NECESSARY	= (1)

;
;  Privilege Set - This is defined for a privilege set of one.
;		   If more than one privilege is needed, then this structure
;		   will need to be allocated with more space.
;
;  Note: don't change this structure without fixing the INITIAL_PRIVILEGE_SET
;  structure (defined in se.h)
;


struc	PRIVILEGE_SET
	PrivilegeCount		dd ?
	Control 		dd ?
	Privilege		LUID_AND_ATTRIBUTES ANYSIZE_ARRAY dup (?)
ends

;//////////////////////////////////////////////////////////////////////
;								     //
;		NT Defined Privileges				     //
;								     //
;//////////////////////////////////////////////////////////////////////

SE_CREATE_TOKEN_NAME		equ <'SeCreateTokenPrivilege', 0>
SE_ASSIGNPRIMARYTOKEN_NAME	equ <'SeAssignPrimaryTokenPrivilege', 0>
SE_LOCK_MEMORY_NAME		equ <'SeLockMemoryPrivilege', 0>
SE_INCREASE_QUOTA_NAME		equ <'SeIncreaseQuotaPrivilege', 0>
SE_UNSOLICITED_INPUT_NAME	equ <'SeUnsolicitedInputPrivilege', 0>
SE_MACHINE_ACCOUNT_NAME 	equ <'SeMachineAccountPrivilege', 0>
SE_TCB_NAME			equ <'SeTcbPrivilege', 0>
SE_SECURITY_NAME		equ <'SeSecurityPrivilege', 0>
SE_TAKE_OWNERSHIP_NAME		equ <'SeTakeOwnershipPrivilege', 0>
SE_LOAD_DRIVER_NAME		equ <'SeLoadDriverPrivilege', 0>
SE_SYSTEM_PROFILE_NAME		equ <'SeSystemProfilePrivilege', 0>
SE_SYSTEMTIME_NAME		equ <'SeSystemtimePrivilege', 0>
SE_PROF_SINGLE_PROCESS_NAME	equ <'SeProfileSingleProcessPrivilege', 0>
SE_INC_BASE_PRIORITY_NAME	equ <'SeIncreaseBasePriorityPrivilege', 0>
SE_CREATE_PAGEFILE_NAME 	equ <'SeCreatePagefilePrivilege', 0>
SE_CREATE_PERMANENT_NAME	equ <'SeCreatePermanentPrivilege', 0>
SE_BACKUP_NAME			equ <'SeBackupPrivilege', 0>
SE_RESTORE_NAME 		equ <'SeRestorePrivilege', 0>
SE_SHUTDOWN_NAME		equ <'SeShutdownPrivilege', 0>
SE_DEBUG_NAME			equ <'SeDebugPrivilege', 0>
SE_AUDIT_NAME			equ <'SeAuditPrivilege', 0>
SE_SYSTEM_ENVIRONMENT_NAME	equ <'SeSystemEnvironmentPrivilege', 0>
SE_CHANGE_NOTIFY_NAME		equ <'SeChangeNotifyPrivilege', 0>
SE_REMOTE_SHUTDOWN_NAME 	equ <'SeRemoteShutdownPrivilege', 0>

;//////////////////////////////////////////////////////////////////
;								 //
;	    Security Quality Of Service 			 //
;								 //
;								 //
;//////////////////////////////////////////////////////////////////

;
; Impersonation Level
;
; Impersonation level is represented by a pair of bits in Windows.
; If a new impersonation level is added or lowest value is changed from
; 0 to something else, fix the Windows CreateFile call.
;

enum	SECURITY_IMPERSONATION_LEVEL\
	SecurityAnonymous,\
	SecurityIdentification,\
	SecurityImpersonation,\
	SecurityDelegation

SECURITY_MAX_IMPERSONATION_LEVEL = SecurityDelegation

DEFAULT_IMPERSONATION_LEVEL	= SecurityImpersonation

;//////////////////////////////////////////////////////////////////
;								 //
;	    Token Object Definitions				 //
;								 //
;								 //
;//////////////////////////////////////////////////////////////////

;
; Token Specific Access Rights.
;

TOKEN_ASSIGN_PRIMARY		= (00001h)
TOKEN_DUPLICATE 		= (00002h)
TOKEN_IMPERSONATE		= (00004h)
TOKEN_QUERY			= (00008h)
TOKEN_QUERY_SOURCE		= (00010h)
TOKEN_ADJUST_PRIVILEGES 	= (00020h)
TOKEN_ADJUST_GROUPS		= (00040h)
TOKEN_ADJUST_DEFAULT		= (00080h)
TOKEN_ADJUST_SESSIONID		= (00100h)

TOKEN_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED  +\
				   TOKEN_ASSIGN_PRIMARY      +\
				   TOKEN_DUPLICATE	     +\
				   TOKEN_IMPERSONATE	     +\
				   TOKEN_QUERY		     +\
				   TOKEN_QUERY_SOURCE	     +\
				   TOKEN_ADJUST_PRIVILEGES   +\
				   TOKEN_ADJUST_GROUPS	     +\
				   TOKEN_ADJUST_SESSIONID    +\
				   TOKEN_ADJUST_DEFAULT)

TOKEN_READ			= (STANDARD_RIGHTS_READ      +\
				   TOKEN_QUERY)


TOKEN_WRITE			= (STANDARD_RIGHTS_WRITE     +\
				   TOKEN_ADJUST_PRIVILEGES   +\
				   TOKEN_ADJUST_GROUPS	     +\
				   TOKEN_ADJUST_DEFAULT)

TOKEN_EXECUTE			= (STANDARD_RIGHTS_EXECUTE)

;
;
; Token Types
;

enum	TOKEN_TYPE\
	TokenPrimary=1,\
	TokenImpersonation


;
; Token Information Classes.
;

enum	TOKEN_INFORMATION_CLASS\
	TokenUser=1,\
	TokenGroups,\
	TokenPrivileges,\
	TokenOwner,\
	TokenPrimaryGroup,\
	TokenDefaultDacl,\
	TokenSource,\
	TokenType,\
	TokenImpersonationLevel,\
	TokenStatistics,\
	TokenRestrictedSids,\
	TokenSessionId

;
; Token information class structures
;

struc	TOKEN_USER
	User			SID_AND_ATTRIBUTES ?
ends

struc	TOKEN_GROUPS
	GroupCount		dd ?
	Groups			SID_AND_ATTRIBUTES ANYSIZE_ARRAY dup (?)
ends

struc	TOKEN_PRIVILEGES
	PrivilegeCount		dd ?
	Privileges		LUID_AND_ATTRIBUTES ANYSIZE_ARRAY dup (?)
ends

struc	TOKEN_OWNER
	Owner			dd ?
ends

struc	TOKEN_PRIMARY_GROUP
	PrimaryGroup		dd ?
ends

struc	TOKEN_DEFAULT_DACL
	DefaultDacl		dd ?
ends

TOKEN_SOURCE_LENGTH		= 8

struc	TOKEN_SOURCE
	SourceName		db TOKEN_SOURCE_LENGTH dup (?)
	SourceIdentifier	LUID ?
ends

struc	TOKEN_STATISTICS
	TokenId 		LUID ?
	AuthenticationId	LUID ?
	ExpirationTime		dq ?
	TokenType		dd ?
	ImpersonationLevel	dd ?
	DynamicCharged		dd ?
	DynamicAvailable	dd ?
	GroupCount		dd ?
	PrivilegeCount		dd ?
	ModifiedId		LUID ?
ends

struc	TOKEN_CONTROL
	TokenId 		LUID ?
	AuthenticationId	LUID ?
	ModifiedId		LUID ?
	TokenSource		TOKEN_SOURCE ?
ends

;
; Security Tracking Mode
;

SECURITY_DYNAMIC_TRACKING	= (TRUE)
SECURITY_STATIC_TRACKING	= (FALSE)

;
; Quality Of Service
;

struc	SECURITY_QUALITY_OF_SERVICE
	Length			dd ?
	ImpersonationLevel	dd ?
	ContextTrackingMode	dd ?
	EffectiveOnly		dd ?
ends

;
; Used to represent information related to a thread impersonation
;

struc	SE_IMPERSONATION_STATE
	Token			dd ?
	CopyOnOpen		dd ?
	EffectiveOnly		dd ?
	Level			dd ?
ends

OWNER_SECURITY_INFORMATION	= (000000001h)
GROUP_SECURITY_INFORMATION	= (000000002h)
DACL_SECURITY_INFORMATION	= (000000004h)
SACL_SECURITY_INFORMATION	= (000000008h)
PROCESS_TERMINATE		= (00001h)
PROCESS_CREATE_THREAD		= (00002h)
PROCESS_SET_SESSIONID		= (00004h)
PROCESS_VM_OPERATION		= (00008h)
PROCESS_VM_READ 		= (00010h)
PROCESS_VM_WRITE		= (00020h)
PROCESS_DUP_HANDLE		= (00040h)
PROCESS_CREATE_PROCESS		= (00080h)
PROCESS_SET_QUOTA		= (00100h)
PROCESS_SET_INFORMATION 	= (00200h)
PROCESS_QUERY_INFORMATION	= (00400h)
PROCESS_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE +\
				   0FFFh)

MAXIMUM_PROCESSORS		= 32

THREAD_TERMINATE		= (00001h)
THREAD_SUSPEND_RESUME		= (00002h)
THREAD_GET_CONTEXT		= (00008h)
THREAD_SET_CONTEXT		= (00010h)
THREAD_SET_INFORMATION		= (00020h)
THREAD_QUERY_INFORMATION	= (00040h)
THREAD_SET_THREAD_TOKEN 	= (00080h)
THREAD_IMPERSONATE		= (00100h)
THREAD_DIRECT_IMPERSONATION	= (00200h)

THREAD_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE +\
				   03FFh)

JOB_OBJECT_ASSIGN_PROCESS	= (00001h)
JOB_OBJECT_SET_ATTRIBUTES	= (00002h)
JOB_OBJECT_QUERY		= (00004h)
JOB_OBJECT_TERMINATE		= (00008h)
JOB_OBJECT_SET_SECURITY_ATTRIBUTES = (00010h)
JOB_OBJECT_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE +\
				   01Fh )
TLS_MINIMUM_AVAILABLE		= 64


struc	NT_TIB
	ExceptionList		dd ?
	StackBase		dd ?
	StackLimit		dd ?
	SubSystemTib		dd ?
label	FiberData		dword
	_Version		dd ?
	ArbitraryUserPointer	dd ?
	Self			dd ?
ends

THREAD_BASE_PRIORITY_LOWRT	= 15  ; value that gets a thread to LowRealtime-1
THREAD_BASE_PRIORITY_MAX	= 2   ; maximum thread base priority boost
THREAD_BASE_PRIORITY_MIN	= -2  ; minimum thread base priority boost
THREAD_BASE_PRIORITY_IDLE	= -15 ; value that gets a thread to idle

struc	QUOTA_LIMITS
	PagedPoolLimit		dd ?
	NonPagedPoolLimit	dd ?
	MinimumWorkingSetSize	dd ?
	MaximumWorkingSetSize	dd ?
	PagefileLimit		dd ?
	TimeLimit		dq ?
ends

struc	JOBOBJECT_BASIC_ACCOUNTING_INFORMATION
	TotalUserTime		dq ?
	TotalKernelTime 	dq ?
	ThisPeriodTotalUserTime dq ?
	ThisPeriodTotalKernelTime dq ?
	TotalPageFaultCount	dd ?
	TotalProcesses		dd ?
	ActiveProcesses 	dd ?
	TotalTerminatedProcesses dd ?
ends

struc	JOBOBJECT_BASIC_LIMIT_INFORMATION
	PerProcessUserTimeLimit dq ?
	PerJobUserTimeLimit	dq ?
	LimitFlags		dd ?
	MinimumWorkingSetSize	dq ?
	MaximumWorkingSetSize	dq ?
	ActiveProcessLimit	dd ?
	Affinity		dd ?
	PriorityClass		dd ?
	SchedulingClass 	dd ?
ends

struc	JOBOBJECT_BASIC_PROCESS_ID_LIST
	NumberOfAssignedProcesses dd ?
	NumberOfProcessIdsInList dd ?
label	ProcessIdList		dword
ends

struc	JOBOBJECT_BASIC_UI_RESTRICTIONS
	UIRestrictionsClass	dd ?
ends

struc	JOBOBJECT_SECURITY_LIMIT_INFORMATION
	SecurityLimitFlags	dd ?
	JobToken		dd ?
	SidsToDisable		dd ?
	PrivilegesToDelete	dd ?
	RestrictedSids		dd ?
ends

struc	JOBOBJECT_END_OF_JOB_TIME_INFORMATION
	EndOfJobTimeAction	dd ?
ends

struc	JOBOBJECT_ASSOCIATE_COMPLETION_PORT
	CompletionKey		dd ?
	CompletionPort		dd ?
ends

JOB_OBJECT_TERMINATE_AT_END_OF_JOB = 0
JOB_OBJECT_POST_AT_END_OF_JOB	= 1

;
; Completion Port Messages for job objects
;
; These values are returned via the lpNumberOfBytesTransferred parameter
;

JOB_OBJECT_MSG_END_OF_JOB_TIME	= 1
JOB_OBJECT_MSG_END_OF_PROCESS_TIME = 2
JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT = 3
JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO = 4
JOB_OBJECT_MSG_NEW_PROCESS	= 6
JOB_OBJECT_MSG_EXIT_PROCESS	= 7


JOB_OBJECT_LIMIT_WORKINGSET	= 000000001h
JOB_OBJECT_LIMIT_PROCESS_TIME	= 000000002h
JOB_OBJECT_LIMIT_JOB_TIME	= 000000004h
JOB_OBJECT_LIMIT_ACTIVE_PROCESS = 000000008h
JOB_OBJECT_LIMIT_AFFINITY	= 000000010h
JOB_OBJECT_LIMIT_PRIORITY_CLASS = 000000020h
JOB_OBJECT_LIMIT_PRESERVE_JOB_TIME = 000000040h
JOB_OBJECT_LIMIT_SCHEDULING_CLASS = 000000080h

JOB_OBJECT_LIMIT_VALID_FLAGS	= 0000000fh

;
; UI restrictions for jobs
;

JOB_OBJECT_UILIMIT_NONE 	= 000000000h

JOB_OBJECT_UILIMIT_HANDLES	= 000000001h
JOB_OBJECT_UILIMIT_READCLIPBOARD = 000000002h
JOB_OBJECT_UILIMIT_WRITECLIPBOARD = 000000004h
JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS = 000000008h
JOB_OBJECT_UILIMIT_DISPLAYSETTINGS = 000000010h
JOB_OBJECT_UILIMIT_GLOBALATOMS	= 000000020h
JOB_OBJECT_UILIMIT_DESKTOP	= 000000040h
JOB_OBJECT_UILIMIT_EXITWINDOWS	= 000000080h

JOB_OBJECT_UILIMIT_ALL		= 0000000FFh

JOB_OBJECT_UI_VALID_FLAGS	= 0000000FFh

JOB_OBJECT_SECURITY_NO_ADMIN	= 000000001h
JOB_OBJECT_SECURITY_RESTRICTED_TOKEN = 000000002h
JOB_OBJECT_SECURITY_ONLY_TOKEN	= 000000004h
JOB_OBJECT_SECURITY_FILTER_TOKENS = 000000008h

JOB_OBJECT_SECURITY_VALID_FLAGS = 00000000h

enum	JOBOBJECTINFOCLASS\
	JobObjectBasicAccountingInformation=1,\
	JobObjectBasicLimitInformation,\
	JobObjectBasicProcessIdList,\
	JobObjectBasicUIRestrictions,\
	JobObjectSecurityLimitInformation,\
	JobObjectEndOfJobTimeInformation,\
	JobObjectAssociateCompletionPortInformation,\
	MaxJobObjectInfoClass


EVENT_MODIFY_STATE		= 00002h
EVENT_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED+SYNCHRONIZE+03h)
MUTANT_QUERY_STATE		= 00001h

MUTANT_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED+SYNCHRONIZE+\
				   MUTANT_QUERY_STATE)
SEMAPHORE_MODIFY_STATE		= 00002h
SEMAPHORE_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED+SYNCHRONIZE+03h)
;
; Timer Specific Access Rights.
;

TIMER_QUERY_STATE		= 00001h
TIMER_MODIFY_STATE		= 00002h

TIMER_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED+SYNCHRONIZE+\
				   TIMER_QUERY_STATE+TIMER_MODIFY_STATE)

TIME_ZONE_ID_UNKNOWN		= 0
TIME_ZONE_ID_STANDARD		= 1
TIME_ZONE_ID_DAYLIGHT		= 2

PROCESSOR_INTEL_386		= 386
PROCESSOR_INTEL_486		= 486
PROCESSOR_INTEL_PENTIUM 	= 586
PROCESSOR_INTEL_IA64		= 2200
PROCESSOR_MIPS_R4000		= 4000	  ; incl R4101 & R3910 for Windows CE
PROCESSOR_ALPHA_21064		= 21064
PROCESSOR_PPC_601		= 601
PROCESSOR_PPC_603		= 603
PROCESSOR_PPC_604		= 604
PROCESSOR_PPC_620		= 620
PROCESSOR_HITACHI_SH3		= 10003   ; Windows CE
PROCESSOR_HITACHI_SH3E		= 10004   ; Windows CE
PROCESSOR_HITACHI_SH4		= 10005   ; Windows CE
PROCESSOR_MOTOROLA_821		= 821	  ; Windows CE
PROCESSOR_SHx_SH3		= 103	  ; Windows CE
PROCESSOR_SHx_SH4		= 104	  ; Windows CE
PROCESSOR_STRONGARM		= 2577	  ; Windows CE - 0xA11
PROCESSOR_ARM720		= 1824	  ; Windows CE - 0x720
PROCESSOR_ARM820		= 2080	  ; Windows CE - 0x820
PROCESSOR_ARM920		= 2336	  ; Windows CE - 0x920
PROCESSOR_ARM_7TDMI		= 70001   ; Windows CE

PROCESSOR_ARCHITECTURE_INTEL	= 0
PROCESSOR_ARCHITECTURE_MIPS	= 1
PROCESSOR_ARCHITECTURE_ALPHA	= 2
PROCESSOR_ARCHITECTURE_PPC	= 3
PROCESSOR_ARCHITECTURE_SHX	= 4
PROCESSOR_ARCHITECTURE_ARM	= 5
PROCESSOR_ARCHITECTURE_IA64	= 6
PROCESSOR_ARCHITECTURE_ALPHA64	= 7
PROCESSOR_ARCHITECTURE_UNKNOWN	= 0FFFFh

PF_FLOATING_POINT_PRECISION_ERRATA = 0
PF_FLOATING_POINT_EMULATED	= 1
PF_COMPARE_EXCHANGE_DOUBLE	= 2
PF_MMX_INSTRUCTIONS_AVAILABLE	= 3
PF_PPC_MOVEMEM_64BIT_OK 	= 4
PF_ALPHA_BYTE_INSTRUCTIONS	= 5
PF_XMMI_INSTRUCTIONS_AVAILABLE	= 6
PF_AMD3D_INSTRUCTIONS_AVAILABLE = 7
PF_RDTSC_INSTRUCTION_AVAILABLE	= 8
SYSTEM_FLAG_REMOTE_BOOT_CLIENT	= 000000001h
SYSTEM_FLAG_DISKLESS_CLIENT	= 000000002h

struc	MEMORY_BASIC_INFORMATION
	BaseAddress		dd ?
	AllocationBase		dd ?
	AllocationProtect	dd ?
	RegionSize		dd ?
	State			dd ?
	Protect 		dd ?
	Type			dd ?
ends

struc	MEMORY_BASIC_INFORMATION_VLM
label	BaseAddress		qword
	BaseAddressAsUlongLong	dq ?
label	AllocationBase		qword
	AllocationBaseAsUlongLong dq ?
	RegionSize		dq ?
	AllocationProtect	dd ?
	State			dd ?
	Protect 		dd ?
	Type			dd ?
ends

SECTION_QUERY			= 00001h
SECTION_MAP_WRITE		= 00002h
SECTION_MAP_READ		= 00004h
SECTION_MAP_EXECUTE		= 00008h
SECTION_EXTEND_SIZE		= 00010h

SECTION_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED+SECTION_QUERY+\
				   SECTION_MAP_WRITE   +\
				   SECTION_MAP_READ    +\
				   SECTION_MAP_EXECUTE +\
				   SECTION_EXTEND_SIZE)

PAGE_NOACCESS			= 001h
PAGE_READONLY			= 002h
PAGE_READWRITE			= 004h
PAGE_WRITECOPY			= 008h
PAGE_EXECUTE			= 010h
PAGE_EXECUTE_READ		= 020h
PAGE_EXECUTE_READWRITE		= 040h
PAGE_EXECUTE_WRITECOPY		= 080h
PAGE_GUARD			= 0100h
PAGE_NOCACHE			= 0200h
PAGE_WRITECOMBINE		= 0400h
MEM_COMMIT			= 01000h
MEM_RESERVE			= 02000h
MEM_DECOMMIT			= 04000h
MEM_RELEASE			= 08000h
MEM_FREE			= 010000h
MEM_PRIVATE			= 020000h
MEM_MAPPED			= 040000h
MEM_RESET			= 080000h
MEM_TOP_DOWN			= 0100000h
MEM_WRITE_WATCH 		= 0200000h
MEM_4MB_PAGES			= 080000000h
SEC_FILE			= 0800000h
SEC_IMAGE			= 01000000h
SEC_VLM 			= 02000000h
SEC_RESERVE			= 04000000h
SEC_COMMIT			= 08000000h
SEC_NOCACHE			= 010000000h
MEM_IMAGE			= SEC_IMAGE

;
; Define access rights to files and directories
;

;
; The FILE_READ_DATA and FILE_WRITE_DATA constants are also defined in
; devioctl.h as FILE_READ_ACCESS and FILE_WRITE_ACCESS. The values for these
; constants *MUST* always be in sync.
; The values are redefined in devioctl.h because they must be available to
; both DOS and NT.
;

FILE_READ_DATA			= ( 00001h )	; file & pipe
FILE_LIST_DIRECTORY		= ( 00001h )	; directory

FILE_WRITE_DATA 		= ( 00002h )	; file & pipe
FILE_ADD_FILE			= ( 00002h )	; directory

FILE_APPEND_DATA		= ( 00004h )	; file
FILE_ADD_SUBDIRECTORY		= ( 00004h )	; directory
FILE_CREATE_PIPE_INSTANCE	= ( 00004h )	; named pipe


FILE_READ_EA			= ( 00008h )	; file & directory

FILE_WRITE_EA			= ( 00010h )	; file & directory

FILE_EXECUTE			= ( 00020h )	; file
FILE_TRAVERSE			= ( 00020h )	; directory

FILE_DELETE_CHILD		= ( 00040h )	; directory

FILE_READ_ATTRIBUTES		= ( 00080h )	; all

FILE_WRITE_ATTRIBUTES		= ( 00100h )	; all

FILE_ALL_ACCESS 		= (STANDARD_RIGHTS_REQUIRED + SYNCHRONIZE + 01FFh)

FILE_GENERIC_READ		= (STANDARD_RIGHTS_READ     +\
				   FILE_READ_DATA	    +\
				   FILE_READ_ATTRIBUTES     +\
				   FILE_READ_EA 	    +\
				   SYNCHRONIZE)


FILE_GENERIC_WRITE		= (STANDARD_RIGHTS_WRITE    +\
				   FILE_WRITE_DATA	    +\
				   FILE_WRITE_ATTRIBUTES    +\
				   FILE_WRITE_EA	    +\
				   FILE_APPEND_DATA	    +\
				   SYNCHRONIZE)


FILE_GENERIC_EXECUTE		= (STANDARD_RIGHTS_EXECUTE  +\
				   FILE_READ_ATTRIBUTES     +\
				   FILE_EXECUTE 	    +\
				   SYNCHRONIZE)

FILE_SHARE_READ 		= 000000001h
FILE_SHARE_WRITE		= 000000002h
FILE_SHARE_DELETE		= 000000004h
FILE_ATTRIBUTE_READONLY 	= 000000001h
FILE_ATTRIBUTE_HIDDEN		= 000000002h
FILE_ATTRIBUTE_SYSTEM		= 000000004h
FILE_ATTRIBUTE_DIRECTORY	= 000000010h
FILE_ATTRIBUTE_ARCHIVE		= 000000020h
FILE_ATTRIBUTE_DEVICE		= 000000040h
FILE_ATTRIBUTE_NORMAL		= 000000080h
FILE_ATTRIBUTE_TEMPORARY	= 000000100h
FILE_ATTRIBUTE_SPARSE_FILE	= 000000200h
FILE_ATTRIBUTE_REPARSE_POINT	= 000000400h
FILE_ATTRIBUTE_COMPRESSED	= 000000800h
FILE_ATTRIBUTE_OFFLINE		= 000001000h
FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 000002000h
FILE_ATTRIBUTE_ENCRYPTED	= 000004000h
FILE_NOTIFY_CHANGE_FILE_NAME	= 000000001h
FILE_NOTIFY_CHANGE_DIR_NAME	= 000000002h
FILE_NOTIFY_CHANGE_ATTRIBUTES	= 000000004h
FILE_NOTIFY_CHANGE_SIZE 	= 000000008h
FILE_NOTIFY_CHANGE_LAST_WRITE	= 000000010h
FILE_NOTIFY_CHANGE_LAST_ACCESS	= 000000020h
FILE_NOTIFY_CHANGE_CREATION	= 000000040h
FILE_NOTIFY_CHANGE_SECURITY	= 000000100h
FILE_ACTION_ADDED		= 000000001h
FILE_ACTION_REMOVED		= 000000002h
FILE_ACTION_MODIFIED		= 000000003h
FILE_ACTION_RENAMED_OLD_NAME	= 000000004h
FILE_ACTION_RENAMED_NEW_NAME	= 000000005h
MAILSLOT_NO_MESSAGE		= (-1)
MAILSLOT_WAIT_FOREVER		= (-1)
FILE_CASE_SENSITIVE_SEARCH	= 000000001h
FILE_CASE_PRESERVED_NAMES	= 000000002h
FILE_UNICODE_ON_DISK		= 000000004h
FILE_PERSISTENT_ACLS		= 000000008h
FILE_FILE_COMPRESSION		= 000000010h
FILE_VOLUME_QUOTAS		= 000000020h
FILE_SUPPORTS_SPARSE_FILES	= 000000040h
FILE_SUPPORTS_REPARSE_POINTS	= 000000080h
FILE_SUPPORTS_REMOTE_STORAGE	= 000000100h
FILE_VOLUME_IS_COMPRESSED	= 000008000h
FILE_SUPPORTS_OBJECT_IDS	= 000010000h
FILE_SUPPORTS_ENCRYPTION	= 000020000h

;
; Define the file notification information structure
;

struc	FILE_NOTIFY_INFORMATION
	NextEntryOffset 	dd ?
	Action			dd ?
	FileNameLength		dd ?
label	FileName		byte
ends

;
; Define segement buffer structure for scatter/gather read/write.
;

union	FILE_SEGMENT_ELEMENT
	Buffer			dq ?
	Alignment		dq ?
ends

;
; Structures for FSCTL_SET_REPARSE_POINT, FSCTL_GET_REPARSE_POINT, and FSCTL_DELETE_REPARSE_POINT
;

;
; The reparse structure is used by layered drivers to store data in a
; reparse point. The constraints on reparse tags are defined below.
; This version of the reparse data buffer is only for Microsoft tags.
;

struc	REPARSE_DATA_BUFFER
	ReparseTag		dd ?
	ReparseDataLength	dw ?
	Reserved		dw ?
label	DataBuffer		byte
	SubstituteNameOffset	dw ?
	SubstituteNameLength	dw ?
	PrintNameOffset 	dw ?
	PrintNameLength 	dw ?
label	PathBuffer		byte
ends

REPARSE_DATA_BUFFER_HEADER_SIZE = 8

;
; The reparse GUID structure is used by all 3rd party layered drivers to
; store data in a reparse point. For non-Microsoft tags, The GUID field
; cannot be GUID_NULL.
; The constraints on reparse tags are defined below.
; Microsoft tags can also be uses with this format of the reparse point buffer.
;

struc	REPARSE_GUID_DATA_BUFFER
	ReparseTag		dd ?
	ReparseDataLength	dw ?
	Reserved		dw ?
	ReparseGuid		GUID ?
label	DataBuffer		byte
ends

REPARSE_GUID_DATA_BUFFER_HEADER_SIZE = (size GUID) + 8

;
; The reparse information structure is used to return information about
; a reparse point to the caller.
;

struc	REPARSE_POINT_INFORMATION
	ReparseDataLength	dw ?
	UnparsedNameLength	dw ?
ends

;
; Maximum allowed size of the reparse data.
;

MAXIMUM_REPARSE_DATA_BUFFER_SIZE = ( 16 * 1024 )

;
; Predefined reparse tags.
; These tags need to avoid conflicting with IO_REMOUNT defined in ntos\inc\io.h
;

IO_REPARSE_TAG_RESERVED_ZERO	= (0)
IO_REPARSE_TAG_RESERVED_ONE	= (1)

;
; The value of the following constant needs to satisfy the following conditions:
;  (1) Be at least as large as the largest of the reserved tags.
;  (2) Be strictly smaller than all the tags in use.
;

IO_REPARSE_TAG_RESERVED_RANGE	= IO_REPARSE_TAG_RESERVED_ONE

;
; The reparse tags are a DWORD. The 32 bits are laid out as follows:
;
;   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;  +-+-+-+-------------------------+-------------------------------+
;  |M|L|N|   Reserved bits	   |	   Reparse Tag Value	   |
;  +-+-+-+-------------------------+-------------------------------+
;
; M is the Microsoft bit. When set to 1, it denotes a tag owned by Microsoft.
;   All ISVs must use a tag with a 0 in this position.
;   Note: If a Microsoft tag is used by non-Microsoft software, the
;   behavior is not defined.
;
; L is the high-latency bit. When set to 1, a file with this tag is
;   expected to have a long latency to retrieve the first byte of data.
;
; N is name surrogate. When set to 1, the file represents another named
;   entity in the system.
;
; The M, L, and N bits are OR-able.
; The following macros check for the M, L and N bit values:
;

;
; The following constant represents the bits that are valid to use in
; reparse tags.
;

IO_REPARSE_TAG_VALID_VALUES	= (0E000FFFFh)

;
; Microsoft tags for reparse points.
;

IO_REPARSE_TAG_SYMBOLIC_LINK	= IO_REPARSE_TAG_RESERVED_ZERO
IO_REPARSE_TAG_MOUNT_POINT	= (0A0000003h)
IO_REPARSE_TAG_HSM		= (0C0000004h)
IO_REPARSE_TAG_NSS		= (080000005h)
IO_REPARSE_TAG_NSSRECOVER	= (080000006h)
IO_REPARSE_TAG_SIS		= (080000007h)
IO_REPARSE_TAG_DFS		= (080000008h)

IO_COMPLETION_MODIFY_STATE	= 00002h
IO_COMPLETION_ALL_ACCESS	= (STANDARD_RIGHTS_REQUIRED+SYNCHRONIZE+03h)
DUPLICATE_CLOSE_SOURCE		= 000000001h
DUPLICATE_SAME_ACCESS		= 000000002h

ES_SYSTEM_REQUIRED		= (000000001h)
ES_DISPLAY_REQUIRED		= (000000002h)
ES_USER_PRESENT 		= (000000004h)
ES_CONTINUOUS			= (080000000h)

enum	LATENCY_TIME\
	LT_DONT_CARE,\
	LT_LOWEST_LATENCY

struc	POWER_DEVICE_TIMEOUTS
	ConservationIdleTime	dd ?
	PerformanceIdleTime	dd ?
ends

;
; Image Format
;

IMAGE_DOS_SIGNATURE		= 05A4Dh      ; MZ
IMAGE_OS2_SIGNATURE		= 0454Eh      ; NE
IMAGE_OS2_SIGNATURE_LE		= 0454Ch      ; LE
IMAGE_VXD_SIGNATURE		= 0454Ch      ; LE
IMAGE_NT_SIGNATURE		= 000004550h  ; PE00

struc	IMAGE_DOS_HEADER			; DOS .EXE header
	e_magic 		dw ?		; Magic number
	e_cblp			dw ?		; Bytes on last page of file
	e_cp			dw ?		; Pages in file
	e_crlc			dw ?		; Relocations
	e_cparhdr		dw ?		; Size of header in paragraphs
	e_minalloc		dw ?		; Minimum extra paragraphs needed
	e_maxalloc		dw ?		; Maximum extra paragraphs needed
	e_ss			dw ?		; Initial (relative) SS value
	e_sp			dw ?		; Initial SP value
	e_csum			dw ?		; Checksum
	e_ip			dw ?		; Initial IP value
	e_cs			dw ?		; Initial (relative) CS value
	e_lfarlc		dw ?		; File address of relocation table
	e_ovno			dw ?		; Overlay number
	e_res			dw 4 dup (?)	; Reserved words
	e_oemid 		dw ?		; OEM identifier (for e_oeminfo)
	e_oeminfo		dw ?		; OEM information; e_oemid specific
	e_res2			dw 10 dup (?)	; Reserved words
	e_lfanew		dd ?		; File address of new exe header
ends

struc	IMAGE_OS2_HEADER			; OS/2 .EXE header
	ne_magic		dw ?		; Magic number
	ne_ver			db ?		; Version number
	ne_rev			db ?		; Revision number
	ne_enttab		dw ?		; Offset of Entry Table
	ne_cbenttab		dw ?		; Number of bytes in Entry Table
	ne_crc			dd ?		; Checksum of whole file
	ne_flags		dw ?		; Flag word
	ne_autodata		dw ?		; Automatic data segment number
	ne_heap 		dw ?		; Initial heap allocation
	ne_stack		dw ?		; Initial stack allocation
	ne_csip 		dd ?		; Initial CS:IP setting
	ne_sssp 		dd ?		; Initial SS:SP setting
	ne_cseg 		dw ?		; Count of file segments
	ne_cmod 		dw ?		; Entries in Module Reference Table
	ne_cbnrestab		dw ?		; Size of non-resident name table
	ne_segtab		dw ?		; Offset of Segment Table
	ne_rsrctab		dw ?		; Offset of Resource Table
	ne_restab		dw ?		; Offset of resident name table
	ne_modtab		dw ?		; Offset of Module Reference Table
	ne_imptab		dw ?		; Offset of Imported Names Table
	ne_nrestab		dd ?		; Offset of Non-resident Names Table
	ne_cmovent		dw ?		; Count of movable entries
	ne_align		dw ?		; Segment alignment shift count
	ne_cres 		dw ?		; Count of resource segments
	ne_exetyp		db ?		; Target Operating system
	ne_flagsothers		db ?		; Other .EXE flags
	ne_pretthunks		dw ?		; offset to return thunks
	ne_psegrefbytes 	dw ?		; offset to segment ref. bytes
	ne_swaparea		dw ?		; Minimum code swap area size
	ne_expver		dw ?		; Expected Windows version number
ends

struc	IMAGE_VXD_HEADER			; Windows VXD header
	e32_magic		dw ?		; Magic number
	e32_border		db ?		; The byte ordering for the VXD
	e32_worder		db ?		; The word ordering for the VXD
	e32_level		dd ?		; The EXE format level for now = 0
	e32_cpu 		dw ?		; The CPU type
	e32_os			dw ?		; The OS type
	e32_ver 		dd ?		; Module version
	e32_mflags		dd ?		; Module flags
	e32_mpages		dd ?		; Module # pages
	e32_startobj		dd ?		; Object # for instruction pointer
	e32_eip 		dd ?		; Extended instruction pointer
	e32_stackobj		dd ?		; Object # for stack pointer
	e32_esp 		dd ?		; Extended stack pointer
	e32_pagesize		dd ?		; VXD page size
	e32_lastpagesize	dd ?		; Last page size in VXD
	e32_fixupsize		dd ?		; Fixup section size
	e32_fixupsum		dd ?		; Fixup section checksum
	e32_ldrsize		dd ?		; Loader section size
	e32_ldrsum		dd ?		; Loader section checksum
	e32_objtab		dd ?		; Object table offset
	e32_objcnt		dd ?		; Number of objects in module
	e32_objmap		dd ?		; Object page map offset
	e32_itermap		dd ?		; Object iterated data map offset
	e32_rsrctab		dd ?		; Offset of Resource Table
	e32_rsrccnt		dd ?		; Number of resource entries
	e32_restab		dd ?		; Offset of resident name table
	e32_enttab		dd ?		; Offset of Entry Table
	e32_dirtab		dd ?		; Offset of Module Directive Table
	e32_dircnt		dd ?		; Number of module directives
	e32_fpagetab		dd ?		; Offset of Fixup Page Table
	e32_frectab		dd ?		; Offset of Fixup Record Table
	e32_impmod		dd ?		; Offset of Import Module Name Table
	e32_impmodcnt		dd ?		; Number of entries in Import Module Name Table
	e32_impproc		dd ?		; Offset of Import Procedure Name Table
	e32_pagesum		dd ?		; Offset of Per-Page Checksum Table
	e32_datapage		dd ?		; Offset of Enumerated Data Pages
	e32_preload		dd ?		; Number of preload pages
	e32_nrestab		dd ?		; Offset of Non-resident Names Table
	e32_cbnrestab		dd ?		; Size of Non-resident Name Table
	e32_nressum		dd ?		; Non-resident Name Table Checksum
	e32_autodata		dd ?		; Object # for automatic data object
	e32_debuginfo		dd ?		; Offset of the debugging information
	e32_debuglen		dd ?		; The length of the debugging info. in bytes
	e32_instpreload 	dd ?		; Number of instance pages in preload section of VXD file
	e32_instdemand		dd ?		; Number of instance pages in demand load section of VXD file
	e32_heapsize		dd ?		; Size of heap - for 16-bit apps
	e32_res3		db 12 dup (?)	; Reserved words
	e32_winresoff		dd ?
	e32_winreslen		dd ?
	e32_devid		dw ?		; Device ID for VxD
	e32_ddkver		dw ?		; DDK version for VxD
ends

;
; File header format.
;

struc	IMAGE_FILE_HEADER
	Machine 		dw ?
	NumberOfSections	dw ?
	TimeDateStamp		dd ?
	PointerToSymbolTable	dd ?
	NumberOfSymbols 	dd ?
	SizeOfOptionalHeader	dw ?
	Characteristics 	dw ?
ends

IMAGE_SIZEOF_FILE_HEADER	= 20

IMAGE_FILE_RELOCS_STRIPPED	= 00001h  ; Relocation info stripped from file.
IMAGE_FILE_EXECUTABLE_IMAGE	= 00002h  ; File is executable	(i.e. no unresolved externel references).
IMAGE_FILE_LINE_NUMS_STRIPPED	= 00004h  ; Line nunbers stripped from file.
IMAGE_FILE_LOCAL_SYMS_STRIPPED	= 00008h  ; Local symbols stripped from file.
IMAGE_FILE_AGGRESIVE_WS_TRIM	= 00010h  ; Agressively trim working set
IMAGE_FILE_LARGE_ADDRESS_AWARE	= 00020h  ; App can handle >2gb addresses
IMAGE_FILE_BYTES_REVERSED_LO	= 00080h  ; Bytes of machine word are reversed.
IMAGE_FILE_32BIT_MACHINE	= 00100h  ; 32 bit word machine.
IMAGE_FILE_DEBUG_STRIPPED	= 00200h  ; Debugging info stripped from file in .DBG file
IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP = 00400h  ; If Image is on removable media, copy and run from the swap file.
IMAGE_FILE_NET_RUN_FROM_SWAP	= 00800h  ; If Image is on Net, copy and run from the swap file.
IMAGE_FILE_SYSTEM		= 01000h  ; System File.
IMAGE_FILE_DLL			= 02000h  ; File is a DLL.
IMAGE_FILE_UP_SYSTEM_ONLY	= 04000h  ; File should only be run on a UP machine
IMAGE_FILE_BYTES_REVERSED_HI	= 08000h  ; Bytes of machine word are reversed.

IMAGE_FILE_MACHINE_UNKNOWN	= 0
IMAGE_FILE_MACHINE_I386 	= 0014h  ; Intel 386.
IMAGE_FILE_MACHINE_R3000	= 00162h  ; MIPS little-endian, 0x160 big-endian
IMAGE_FILE_MACHINE_R4000	= 00166h  ; MIPS little-endian
IMAGE_FILE_MACHINE_R10000	= 00168h  ; MIPS little-endian
IMAGE_FILE_MACHINE_WCEMIPSV2	= 00169h  ; MIPS little-endian WCE v2
IMAGE_FILE_MACHINE_ALPHA	= 00184h  ; Alpha_AXP
IMAGE_FILE_MACHINE_POWERPC	= 001F0h  ; IBM PowerPC Little-Endian
IMAGE_FILE_MACHINE_SH3		= 001a2h  ; SH3 little-endian
IMAGE_FILE_MACHINE_SH3E 	= 001a4h  ; SH3E little-endian
IMAGE_FILE_MACHINE_SH4		= 001a6h  ; SH4 little-endian
IMAGE_FILE_MACHINE_ARM		= 001c0h  ; ARM Little-Endian
IMAGE_FILE_MACHINE_THUMB	= 001c2h
IMAGE_FILE_MACHINE_IA64 	= 00200h  ; Intel 64
IMAGE_FILE_MACHINE_MIPS16	= 00266h  ; MIPS
IMAGE_FILE_MACHINE_MIPSFPU	= 00366h  ; MIPS
IMAGE_FILE_MACHINE_MIPSFPU16	= 00466h  ; MIPS
IMAGE_FILE_MACHINE_ALPHA64	= 00284h  ; ALPHA64
IMAGE_FILE_MACHINE_AXP64	= IMAGE_FILE_MACHINE_ALPHA64

;
; Directory format.
;

struc	IMAGE_DATA_DIRECTORY
	VirtualAddress		dd ?
	Size			dd ?
ends

IMAGE_NUMBEROF_DIRECTORY_ENTRIES = 16

;
; Optional header format.
;

struc	IMAGE_OPTIONAL_HEADER32 		; ; Standard fields. ;
	Magic			dw ?
	MajorLinkerVersion	db ?
	MinorLinkerVersion	db ?
	SizeOfCode		dd ?
	SizeOfInitializedData	dd ?
	SizeOfUninitializedData dd ?
	AddressOfEntryPoint	dd ?
	BaseOfCode		dd ?
	BaseOfData		dd ?		; ; NT additional fields. ;
	ImageBase		dd ?
	SectionAlignment	dd ?
	FileAlignment		dd ?
	MajorOperatingSystemVersion dw ?
	MinorOperatingSystemVersion dw ?
	MajorImageVersion	dw ?
	MinorImageVersion	dw ?
	MajorSubsystemVersion	dw ?
	MinorSubsystemVersion	dw ?
	Win32VersionValue	dd ?
	SizeOfImage		dd ?
	SizeOfHeaders		dd ?
	CheckSum		dd ?
	Subsystem		dw ?
	DllCharacteristics	dw ?
	SizeOfStackReserve	dd ?
	SizeOfStackCommit	dd ?
	SizeOfHeapReserve	dd ?
	SizeOfHeapCommit	dd ?
	LoaderFlags		dd ?
	NumberOfRvaAndSizes	dd ?
	DataDirectory		IMAGE_DATA_DIRECTORY IMAGE_NUMBEROF_DIRECTORY_ENTRIES dup (?)
ends

struc	IMAGE_ROM_OPTIONAL_HEADER
	Magic			dw ?
	MajorLinkerVersion	db ?
	MinorLinkerVersion	db ?
	SizeOfCode		dd ?
	SizeOfInitializedData	dd ?
	SizeOfUninitializedData dd ?
	AddressOfEntryPoint	dd ?
	BaseOfCode		dd ?
	BaseOfData		dd ?
	BaseOfBss		dd ?
	GprMask 		dd ?
	CprMask 		dd 4 dup (?)
	GpValue 		dd ?
ends

struc	IMAGE_OPTIONAL_HEADER64
	Magic			dw ?
	MajorLinkerVersion	db ?
	MinorLinkerVersion	db ?
	SizeOfCode		dd ?
	SizeOfInitializedData	dd ?
	SizeOfUninitializedData dd ?
	AddressOfEntryPoint	dd ?
	BaseOfCode		dd ?
	ImageBase		dq ?
	SectionAlignment	dd ?
	FileAlignment		dd ?
	MajorOperatingSystemVersion dw ?
	MinorOperatingSystemVersion dw ?
	MajorImageVersion	dw ?
	MinorImageVersion	dw ?
	MajorSubsystemVersion	dw ?
	MinorSubsystemVersion	dw ?
	Win32VersionValue	dd ?
	SizeOfImage		dd ?
	SizeOfHeaders		dd ?
	CheckSum		dd ?
	Subsystem		dw ?
	DllCharacteristics	dw ?
	SizeOfStackReserve	dq ?
	SizeOfStackCommit	dq ?
	SizeOfHeapReserve	dq ?
	SizeOfHeapCommit	dq ?
	LoaderFlags		dd ?
	NumberOfRvaAndSizes	dd ?
	DataDirectory		IMAGE_DATA_DIRECTORY IMAGE_NUMBEROF_DIRECTORY_ENTRIES dup (?)
ends

IMAGE_SIZEOF_ROM_OPTIONAL_HEADER = 56
IMAGE_SIZEOF_STD_OPTIONAL_HEADER = 28
IMAGE_SIZEOF_NT_OPTIONAL32_HEADER = 224
IMAGE_SIZEOF_NT_OPTIONAL64_HEADER = 240

IMAGE_NT_OPTIONAL_HDR32_MAGIC	= 010h
IMAGE_NT_OPTIONAL_HDR64_MAGIC	= 020h
IMAGE_ROM_OPTIONAL_HDR_MAGIC	= 0107h

IMAGE_SIZEOF_NT_OPTIONAL_HEADER = IMAGE_SIZEOF_NT_OPTIONAL32_HEADER
IMAGE_NT_OPTIONAL_HDR_MAGIC	= IMAGE_NT_OPTIONAL_HDR32_MAGIC

struc	IMAGE_NT_HEADERS64
	Signature		dd ?
	FileHeader		IMAGE_FILE_HEADER ?
	OptionalHeader		IMAGE_OPTIONAL_HEADER64 ?
ends

struc	IMAGE_NT_HEADERS32
	Signature		dd ?
	FileHeader		IMAGE_FILE_HEADER ?
	OptionalHeader		IMAGE_OPTIONAL_HEADER32 ?
ends

struc	IMAGE_ROM_HEADERS
	FileHeader		IMAGE_FILE_HEADER ?
	OptionalHeader		IMAGE_ROM_OPTIONAL_HEADER ?
ends

IMAGE_NT_HEADERS		= IMAGE_NT_HEADERS32

; Subsystem Values

IMAGE_SUBSYSTEM_UNKNOWN 	= 0   ; Unknown subsystem.
IMAGE_SUBSYSTEM_NATIVE		= 1   ; Image doesn't require a subsystem.
IMAGE_SUBSYSTEM_WINDOWS_GUI	= 2   ; Image runs in the Windows GUI subsystem.
IMAGE_SUBSYSTEM_WINDOWS_CUI	= 3   ; Image runs in the Windows character subsystem.
IMAGE_SUBSYSTEM_OS2_CUI 	= 5   ; image runs in the OS/2 character subsystem.
IMAGE_SUBSYSTEM_POSIX_CUI	= 7   ; image runs in the Posix character subsystem.
IMAGE_SUBSYSTEM_NATIVE_WINDOWS	= 8   ; image is a native Win9x driver.
IMAGE_SUBSYSTEM_WINDOWS_CE_GUI	= 9   ; Image runs in the Windows CE subsystem.

; DllCharacteristics Entries

;      IMAGE_LIBRARY_PROCESS_INIT	    0x0001     // Reserved.
;      IMAGE_LIBRARY_PROCESS_TERM	    0x0002     // Reserved.
;      IMAGE_LIBRARY_THREAD_INIT	    0x0004     // Reserved.
;      IMAGE_LIBRARY_THREAD_TERM	    0x0008     // Reserved.
IMAGE_DLLCHARACTERISTICS_WDM_DRIVER = 02000h	 ; Driver uses WDM model

; Directory Entries

IMAGE_DIRECTORY_ENTRY_EXPORT	= 0   ; Export Directory
IMAGE_DIRECTORY_ENTRY_IMPORT	= 1   ; Import Directory
IMAGE_DIRECTORY_ENTRY_RESOURCE	= 2   ; Resource Directory
IMAGE_DIRECTORY_ENTRY_EXCEPTION = 3   ; Exception Directory
IMAGE_DIRECTORY_ENTRY_SECURITY	= 4   ; Security Directory
IMAGE_DIRECTORY_ENTRY_BASERELOC = 5   ; Base Relocation Table
IMAGE_DIRECTORY_ENTRY_DEBUG	= 6   ; Debug Directory
;      IMAGE_DIRECTORY_ENTRY_COPYRIGHT	     7	 // (X86 usage)
IMAGE_DIRECTORY_ENTRY_ARCHITECTURE = 7	 ; Architecture Specific Data
IMAGE_DIRECTORY_ENTRY_GLOBALPTR = 8   ; RVA of GP
IMAGE_DIRECTORY_ENTRY_TLS	= 9   ; TLS Directory
IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG = 10	 ; Load Configuration Directory
IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT = 11   ; Bound Import Directory in headers
IMAGE_DIRECTORY_ENTRY_IAT	= 12   ; Import Address Table
IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT = 13   ; Delay Load Import Descriptors
IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR = 14   ; COM Runtime descriptor

;
; Section header format.
;

IMAGE_SIZEOF_SHORT_NAME 	= 8


struc	IMAGE_SECTION_HEADER
	_Name			db IMAGE_SIZEOF_SHORT_NAME dup (?)
label	PhysicalAddress 	dword
	VirtualSize		dd ?
	VirtualAddress		dd ?
	SizeOfRawData		dd ?
	PointerToRawData	dd ?
	PointerToRelocations	dd ?
	PointerToLinenumbers	dd ?
	NumberOfRelocations	dw ?
	NumberOfLinenumbers	dw ?
	Characteristics 	dd ?
ends

IMAGE_SIZEOF_SECTION_HEADER	= 40

;
; Section characteristics.
;
;      IMAGE_SCN_TYPE_REG		    0x00000000	// Reserved.
;      IMAGE_SCN_TYPE_DSECT		    0x00000001	// Reserved.
;      IMAGE_SCN_TYPE_NOLOAD		    0x00000002	// Reserved.
;      IMAGE_SCN_TYPE_GROUP		    0x00000004	// Reserved.
IMAGE_SCN_TYPE_NO_PAD		= 000000008h  ; Reserved.
;      IMAGE_SCN_TYPE_COPY		    0x00000010	// Reserved.

IMAGE_SCN_CNT_CODE		= 000000020h  ; Section contains code.
IMAGE_SCN_CNT_INITIALIZED_DATA	= 000000040h  ; Section contains initialized data.
IMAGE_SCN_CNT_UNINITIALIZED_DATA = 000000080h  ; Section contains uninitialized data.

IMAGE_SCN_LNK_OTHER		= 000000100h  ; Reserved.
IMAGE_SCN_LNK_INFO		= 000000200h  ; Section contains comments or some other type of information.
;      IMAGE_SCN_TYPE_OVER		    0x00000400	// Reserved.
IMAGE_SCN_LNK_REMOVE		= 000000800h  ; Section contents will not become part of image.
IMAGE_SCN_LNK_COMDAT		= 000001000h  ; Section contents comdat.
;					    0x00002000	// Reserved.
;      IMAGE_SCN_MEM_PROTECTED - Obsolete   0x00004000
IMAGE_SCN_NO_DEFER_SPEC_EXC	= 000004000h  ; Reset speculative exceptions handling bits in the TLB entries for this section.
IMAGE_SCN_GPREL 		= 000008000h  ; Section content can be accessed relative to GP
IMAGE_SCN_MEM_FARDATA		= 000008000h
;      IMAGE_SCN_MEM_SYSHEAP  - Obsolete    0x00010000
IMAGE_SCN_MEM_PURGEABLE 	= 000020000h
IMAGE_SCN_MEM_16BIT		= 000020000h
IMAGE_SCN_MEM_LOCKED		= 000040000h
IMAGE_SCN_MEM_PRELOAD		= 000080000h

IMAGE_SCN_ALIGN_1BYTES		= 000100000h  ;
IMAGE_SCN_ALIGN_2BYTES		= 000200000h  ;
IMAGE_SCN_ALIGN_4BYTES		= 000300000h  ;
IMAGE_SCN_ALIGN_8BYTES		= 000400000h  ;
IMAGE_SCN_ALIGN_16BYTES 	= 000500000h  ; Default alignment if no others are specified.
IMAGE_SCN_ALIGN_32BYTES 	= 000600000h  ;
IMAGE_SCN_ALIGN_64BYTES 	= 000700000h  ;
IMAGE_SCN_ALIGN_128BYTES	= 000800000h  ;
IMAGE_SCN_ALIGN_256BYTES	= 000900000h  ;
IMAGE_SCN_ALIGN_512BYTES	= 000A00000h  ;
IMAGE_SCN_ALIGN_1024BYTES	= 000B00000h  ;
IMAGE_SCN_ALIGN_2048BYTES	= 000C00000h  ;
IMAGE_SCN_ALIGN_4096BYTES	= 000D00000h  ;
IMAGE_SCN_ALIGN_8192BYTES	= 000E00000h  ;
; Unused				    0x00F00000
IMAGE_SCN_ALIGN_MASK		= 000F00000h

IMAGE_SCN_LNK_NRELOC_OVFL	= 001000000h  ; Section contains extended relocations.
IMAGE_SCN_MEM_DISCARDABLE	= 002000000h  ; Section can be discarded.
IMAGE_SCN_MEM_NOT_CACHED	= 004000000h  ; Section is not cachable.
IMAGE_SCN_MEM_NOT_PAGED 	= 008000000h  ; Section is not pageable.
IMAGE_SCN_MEM_SHARED		= 010000000h  ; Section is shareable.
IMAGE_SCN_MEM_EXECUTE		= 020000000h  ; Section is executable.
IMAGE_SCN_MEM_READ		= 040000000h  ; Section is readable.
IMAGE_SCN_MEM_WRITE		= 080000000h  ; Section is writeable.

;
; TLS Chaacteristic Flags
;
IMAGE_SCN_SCALE_INDEX		= 000000001h  ; Tls index is scaled

;
; Symbol format.
;

struc	IMAGE_SYMBOL
label	ShortName		byte
label	LongName		dword
	Short			dd ?		; if 0, use LongName
	Long			dd ?		; offset into string table
	Value			dd ?
	SectionNumber		dw ?
	Type			dw ?
	StorageClass		db ?
	NumberOfAuxSymbols	db ?
ends

IMAGE_SIZEOF_SYMBOL		= 18

;
; Section values.
;
; Symbols have a section number of the section in which they are
; defined. Otherwise, section numbers have the following meanings:
;

IMAGE_SYM_UNDEFINED		= 0	     ; Symbol is undefined or is common.
IMAGE_SYM_ABSOLUTE		= -1	     ; Symbol is an absolute value.
IMAGE_SYM_DEBUG 		= -2	     ; Symbol is a special debug item.

;
; Type (fundamental) values.
;

IMAGE_SYM_TYPE_NULL		= 00000h  ; no type.
IMAGE_SYM_TYPE_VOID		= 00001h  ;
IMAGE_SYM_TYPE_CHAR		= 00002h  ; type character.
IMAGE_SYM_TYPE_SHORT		= 00003h  ; type short integer.
IMAGE_SYM_TYPE_INT		= 00004h  ;
IMAGE_SYM_TYPE_LONG		= 00005h  ;
IMAGE_SYM_TYPE_FLOAT		= 00006h  ;
IMAGE_SYM_TYPE_DOUBLE		= 00007h  ;
IMAGE_SYM_TYPE_STRUCT		= 00008h  ;
IMAGE_SYM_TYPE_UNION		= 00009h  ;
IMAGE_SYM_TYPE_ENUM		= 0000Ah  ; enumeration.
IMAGE_SYM_TYPE_MOE		= 0000Bh  ; member of enumeration.
IMAGE_SYM_TYPE_BYTE		= 0000Ch  ;
IMAGE_SYM_TYPE_WORD		= 0000Dh  ;
IMAGE_SYM_TYPE_UINT		= 0000Eh  ;
IMAGE_SYM_TYPE_DWORD		= 0000Fh  ;
IMAGE_SYM_TYPE_PCODE		= 08000h  ;
;
; Type (derived) values.
;

IMAGE_SYM_DTYPE_NULL		= 0	  ; no derived type.
IMAGE_SYM_DTYPE_POINTER 	= 1	  ; pointer.
IMAGE_SYM_DTYPE_FUNCTION	= 2	  ; function.
IMAGE_SYM_DTYPE_ARRAY		= 3	  ; array.

;
; Storage classes.
;
IMAGE_SYM_CLASS_END_OF_FUNCTION = -1
IMAGE_SYM_CLASS_NULL		= 00000h
IMAGE_SYM_CLASS_AUTOMATIC	= 00001h
IMAGE_SYM_CLASS_EXTERNAL	= 00002h
IMAGE_SYM_CLASS_STATIC		= 00003h
IMAGE_SYM_CLASS_REGISTER	= 00004h
IMAGE_SYM_CLASS_EXTERNAL_DEF	= 00005h
IMAGE_SYM_CLASS_LABEL		= 00006h
IMAGE_SYM_CLASS_UNDEFINED_LABEL = 00007h
IMAGE_SYM_CLASS_MEMBER_OF_STRUCT = 00008h
IMAGE_SYM_CLASS_ARGUMENT	= 00009h
IMAGE_SYM_CLASS_STRUCT_TAG	= 0000Ah
IMAGE_SYM_CLASS_MEMBER_OF_UNION = 0000Bh
IMAGE_SYM_CLASS_UNION_TAG	= 0000Ch
IMAGE_SYM_CLASS_TYPE_DEFINITION = 0000Dh
IMAGE_SYM_CLASS_UNDEFINED_STATIC = 0000Eh
IMAGE_SYM_CLASS_ENUM_TAG	= 0000Fh
IMAGE_SYM_CLASS_MEMBER_OF_ENUM	= 00010h
IMAGE_SYM_CLASS_REGISTER_PARAM	= 00011h
IMAGE_SYM_CLASS_BIT_FIELD	= 00012h

IMAGE_SYM_CLASS_FAR_EXTERNAL	= 00044h

IMAGE_SYM_CLASS_BLOCK		= 00064h
IMAGE_SYM_CLASS_FUNCTION	= 00065h
IMAGE_SYM_CLASS_END_OF_STRUCT	= 00066h
IMAGE_SYM_CLASS_FILE		= 00067h
; new
IMAGE_SYM_CLASS_SECTION 	= 00068h
IMAGE_SYM_CLASS_WEAK_EXTERNAL	= 00069h

; type packing constants

N_BTMASK			= 0000Fh
N_TMASK 			= 00030h
N_TMASK1			= 000C0h
N_TMASK2			= 000F0h
N_BTSHFT			= 4
N_TSHIFT			= 2

;
; Auxiliary entry format.
;

struc	IAS_SYM
	TagIndex		dd ?		; struct, union, or enum tag index
label	TotalSize		dword
	Linenumber		dw ?		; declaration line number
	Size			dw ?		; size of struct, union, or enum
label	Dimension		word
	PointerToLinenumber	dd ?
	PointerToNextFunction	dd ?
	TvIndex 		dw ?		; tv index
ends

struc	IAS_FILE
	_Name			db IMAGE_SIZEOF_SYMBOL dup (?)
ends

struc	IAS_SECTION
	Length			dd ?		; section length
	NumberOfRelocations	dw ?		; number of relocation entries
	NumberOfLinenumbers	dw ?		; number of line numbers
	CheckSum		dd ?		; checksum for communal
	Number			dw ?		; section number to associate with
	Selection		db ?		; communal selection type
ends

union	IMAGE_AUX_SYMBOL
	Sym			IAS_SYM ?
	File			IAS_FILE ?
	Section 		IAS_SECTION ?
ends

IMAGE_SIZEOF_AUX_SYMBOL 	= 18

;
; Communal selection types.
;

IMAGE_COMDAT_SELECT_NODUPLICATES = 1
IMAGE_COMDAT_SELECT_ANY 	= 2
IMAGE_COMDAT_SELECT_SAME_SIZE	= 3
IMAGE_COMDAT_SELECT_EXACT_MATCH = 4
IMAGE_COMDAT_SELECT_ASSOCIATIVE = 5
IMAGE_COMDAT_SELECT_LARGEST	= 6
IMAGE_COMDAT_SELECT_NEWEST	= 7

IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY = 1
IMAGE_WEAK_EXTERN_SEARCH_LIBRARY = 2
IMAGE_WEAK_EXTERN_SEARCH_ALIAS	= 3

;
; Relocation format.
;

struc	IMAGE_RELOCATION
label	VirtualAddress		dword
	RelocCount		dd ?		; Set to the real count when IMAGE_SCN_LNK_NRELOC_OVFL is set
	SymbolTableIndex	dd ?
	Type			dw ?
ends

IMAGE_SIZEOF_RELOCATION 	= 10

;
; I386 relocation types.
;
IMAGE_REL_I386_ABSOLUTE 	= 00000h  ; Reference is absolute, no relocation is necessary
IMAGE_REL_I386_DIR16		= 00001h  ; Direct 16-bit reference to the symbols virtual address
IMAGE_REL_I386_REL16		= 00002h  ; PC-relative 16-bit reference to the symbols virtual address
IMAGE_REL_I386_DIR32		= 00006h  ; Direct 32-bit reference to the symbols virtual address
IMAGE_REL_I386_DIR32NB		= 00007h  ; Direct 32-bit reference to the symbols virtual address, base not included
IMAGE_REL_I386_SEG12		= 00009h  ; Direct 16-bit reference to the segment-selector bits of a 32-bit virtual address
IMAGE_REL_I386_SECTION		= 0000Ah
IMAGE_REL_I386_SECREL		= 0000Bh
IMAGE_REL_I386_REL32		= 00014h  ; PC-relative 32-bit reference to the symbols virtual address

;
; MIPS relocation types.
;

IMAGE_REL_MIPS_ABSOLUTE 	= 00000h  ; Reference is absolute, no relocation is necessary
IMAGE_REL_MIPS_REFHALF		= 00001h
IMAGE_REL_MIPS_REFWORD		= 00002h
IMAGE_REL_MIPS_JMPADDR		= 00003h
IMAGE_REL_MIPS_REFHI		= 00004h
IMAGE_REL_MIPS_REFLO		= 00005h
IMAGE_REL_MIPS_GPREL		= 00006h
IMAGE_REL_MIPS_LITERAL		= 00007h
IMAGE_REL_MIPS_SECTION		= 0000Ah
IMAGE_REL_MIPS_SECREL		= 0000Bh
IMAGE_REL_MIPS_SECRELLO 	= 0000Ch  ; Low 16-bit section relative referemce (used for >32k TLS)
IMAGE_REL_MIPS_SECRELHI 	= 0000Dh  ; High 16-bit section relative reference (used for >32k TLS)
IMAGE_REL_MIPS_JMPADDR16	= 00010h
IMAGE_REL_MIPS_REFWORDNB	= 00022h
IMAGE_REL_MIPS_PAIR		= 00025h

;
; Alpha Relocation types.
;

IMAGE_REL_ALPHA_ABSOLUTE	= 00000h
IMAGE_REL_ALPHA_REFLONG 	= 00001h
IMAGE_REL_ALPHA_REFQUAD 	= 00002h
IMAGE_REL_ALPHA_GPREL32 	= 00003h
IMAGE_REL_ALPHA_LITERAL 	= 00004h
IMAGE_REL_ALPHA_LITUSE		= 00005h
IMAGE_REL_ALPHA_GPDISP		= 00006h
IMAGE_REL_ALPHA_BRADDR		= 00007h
IMAGE_REL_ALPHA_HINT		= 00008h
IMAGE_REL_ALPHA_INLINE_REFLONG	= 00009h
IMAGE_REL_ALPHA_REFHI		= 0000Ah
IMAGE_REL_ALPHA_REFLO		= 0000Bh
IMAGE_REL_ALPHA_PAIR		= 0000Ch
IMAGE_REL_ALPHA_MATCH		= 0000Dh
IMAGE_REL_ALPHA_SECTION 	= 0000Eh
IMAGE_REL_ALPHA_SECREL		= 0000Fh
IMAGE_REL_ALPHA_REFLONGNB	= 00010h
IMAGE_REL_ALPHA_SECRELLO	= 00011h  ; Low 16-bit section relative reference
IMAGE_REL_ALPHA_SECRELHI	= 00012h  ; High 16-bit section relative reference
IMAGE_REL_ALPHA_REFQ3		= 00013h  ; High 16 bits of 48 bit reference
IMAGE_REL_ALPHA_REFQ2		= 00014h  ; Middle 16 bits of 48 bit reference
IMAGE_REL_ALPHA_REFQ1		= 00015h  ; Low 16 bits of 48 bit reference
IMAGE_REL_ALPHA_GPRELLO 	= 00016h  ; Low 16-bit GP relative reference
IMAGE_REL_ALPHA_GPRELHI 	= 00017h  ; High 16-bit GP relative reference


;
; IBM PowerPC relocation types.
;

IMAGE_REL_PPC_ABSOLUTE		= 00000h  ; NOP
IMAGE_REL_PPC_ADDR64		= 00001h  ; 64-bit address
IMAGE_REL_PPC_ADDR32		= 00002h  ; 32-bit address
IMAGE_REL_PPC_ADDR24		= 00003h  ; 26-bit address, shifted left 2 (branch absolute)
IMAGE_REL_PPC_ADDR16		= 00004h  ; 16-bit address
IMAGE_REL_PPC_ADDR14		= 00005h  ; 16-bit address, shifted left 2 (load doubleword)
IMAGE_REL_PPC_REL24		= 00006h  ; 26-bit PC-relative offset, shifted left 2 (branch relative)
IMAGE_REL_PPC_REL14		= 00007h  ; 16-bit PC-relative offset, shifted left 2 (br cond relative)
IMAGE_REL_PPC_TOCREL16		= 00008h  ; 16-bit offset from TOC base
IMAGE_REL_PPC_TOCREL14		= 00009h  ; 16-bit offset from TOC base, shifted left 2 (load doubleword)

IMAGE_REL_PPC_ADDR32NB		= 0000Ah  ; 32-bit addr w/o image base
IMAGE_REL_PPC_SECREL		= 0000Bh  ; va of containing section (as in an image sectionhdr)
IMAGE_REL_PPC_SECTION		= 0000Ch  ; sectionheader number
IMAGE_REL_PPC_IFGLUE		= 0000Dh  ; substitute TOC restore instruction iff symbol is glue code
IMAGE_REL_PPC_IMGLUE		= 0000Eh  ; symbol is glue code; virtual address is TOC restore instruction
IMAGE_REL_PPC_SECREL16		= 0000Fh  ; va of containing section (limited to 16 bits)
IMAGE_REL_PPC_REFHI		= 00010h
IMAGE_REL_PPC_REFLO		= 00011h
IMAGE_REL_PPC_PAIR		= 00012h
IMAGE_REL_PPC_SECRELLO		= 00013h  ; Low 16-bit section relative reference (used for >32k TLS)
IMAGE_REL_PPC_SECRELHI		= 00014h  ; High 16-bit section relative reference (used for >32k TLS)
IMAGE_REL_PPC_GPREL		= 00015h

IMAGE_REL_PPC_TYPEMASK		= 000FFh  ; mask to isolate above values in IMAGE_RELOCATION.Type

; Flag bits in IMAGE_RELOCATION.TYPE

IMAGE_REL_PPC_NEG		= 00100h  ; subtract reloc value rather than adding it
IMAGE_REL_PPC_BRTAKEN		= 00200h  ; fix branch prediction bit to predict branch taken
IMAGE_REL_PPC_BRNTAKEN		= 00400h  ; fix branch prediction bit to predict branch not taken
IMAGE_REL_PPC_TOCDEFN		= 00800h  ; toc slot defined in file (or, data in toc)

;
; Hitachi SH3 relocation types.
;
IMAGE_REL_SH3_ABSOLUTE		= 00000h  ; No relocation
IMAGE_REL_SH3_DIRECT16		= 00001h  ; 16 bit direct
IMAGE_REL_SH3_DIRECT32		= 00002h  ; 32 bit direct
IMAGE_REL_SH3_DIRECT8		= 00003h  ; 8 bit direct, -128..255
IMAGE_REL_SH3_DIRECT8_WORD	= 00004h  ; 8 bit direct .W (0 ext.)
IMAGE_REL_SH3_DIRECT8_LONG	= 00005h  ; 8 bit direct .L (0 ext.)
IMAGE_REL_SH3_DIRECT4		= 00006h  ; 4 bit direct (0 ext.)
IMAGE_REL_SH3_DIRECT4_WORD	= 00007h  ; 4 bit direct .W (0 ext.)
IMAGE_REL_SH3_DIRECT4_LONG	= 00008h  ; 4 bit direct .L (0 ext.)
IMAGE_REL_SH3_PCREL8_WORD	= 00009h  ; 8 bit PC relative .W
IMAGE_REL_SH3_PCREL8_LONG	= 0000Ah  ; 8 bit PC relative .L
IMAGE_REL_SH3_PCREL12_WORD	= 0000Bh  ; 12 LSB PC relative .W
IMAGE_REL_SH3_STARTOF_SECTION	= 0000Ch  ; Start of EXE section
IMAGE_REL_SH3_SIZEOF_SECTION	= 0000Dh  ; Size of EXE section
IMAGE_REL_SH3_SECTION		= 0000Eh  ; Section table index
IMAGE_REL_SH3_SECREL		= 0000Fh  ; Offset within section
IMAGE_REL_SH3_DIRECT32_NB	= 00010h  ; 32 bit direct not based

IMAGE_REL_ARM_ABSOLUTE		= 00000h  ; No relocation required
IMAGE_REL_ARM_ADDR32		= 00001h  ; 32 bit address
IMAGE_REL_ARM_ADDR32NB		= 00002h  ; 32 bit address w/o image base
IMAGE_REL_ARM_BRANCH24		= 00003h  ; 24 bit offset << 2 & sign ext.
IMAGE_REL_ARM_BRANCH11		= 00004h  ; Thumb: 2 11 bit offsets
IMAGE_REL_ARM_SECTION		= 0000Eh  ; Section table index
IMAGE_REL_ARM_SECREL		= 0000Fh  ; Offset within section

;
; IA64 relocation types.
;

IMAGE_REL_IA64_ABSOLUTE 	= 00000h
IMAGE_REL_IA64_IMM14		= 00001h
IMAGE_REL_IA64_IMM22		= 00002h
IMAGE_REL_IA64_IMM64		= 00003h
IMAGE_REL_IA64_DIR32		= 00004h
IMAGE_REL_IA64_DIR64		= 00005h
IMAGE_REL_IA64_PCREL21B 	= 00006h
IMAGE_REL_IA64_PCREL21M 	= 00007h
IMAGE_REL_IA64_PCREL21F 	= 00008h
IMAGE_REL_IA64_GPREL22		= 00009h
IMAGE_REL_IA64_LTOFF22		= 0000Ah
IMAGE_REL_IA64_SECTION		= 0000Bh
IMAGE_REL_IA64_SECREL22 	= 0000Ch
IMAGE_REL_IA64_SECREL64I	= 0000Dh
IMAGE_REL_IA64_SECREL32 	= 0000Eh
IMAGE_REL_IA64_LTOFF64		= 0000Fh
IMAGE_REL_IA64_DIR32NB		= 00010h
IMAGE_REL_IA64_RESERVED_11	= 00011h
IMAGE_REL_IA64_RESERVED_12	= 00012h
IMAGE_REL_IA64_RESERVED_13	= 00013h
IMAGE_REL_IA64_RESERVED_14	= 00014h
IMAGE_REL_IA64_RESERVED_15	= 00015h
IMAGE_REL_IA64_RESERVED_16	= 00016h
IMAGE_REL_IA64_ADDEND		= 0001Fh

;
; Line number format.
;

struc	IMAGE_LINENUMBER
label	SymbolTableIndex	dword		; Symbol table index of function name if Linenumber is 0.
	VirtualAddress		dd ?		; Virtual address of line number.
	Linenumber		dw ?		; Line number.
ends

IMAGE_SIZEOF_LINENUMBER 	= 6

;
; Based relocation format.
;

struc	IMAGE_BASE_RELOCATION
	VirtualAddress		dd ?
	SizeOfBlock		dd ?		;  WORD    TypeOffset[1];
ends

IMAGE_SIZEOF_BASE_RELOCATION	= 8

;
; Based relocation types.
;

IMAGE_REL_BASED_ABSOLUTE	= 0
IMAGE_REL_BASED_HIGH		= 1
IMAGE_REL_BASED_LOW		= 2
IMAGE_REL_BASED_HIGHLOW 	= 3
IMAGE_REL_BASED_HIGHADJ 	= 4
IMAGE_REL_BASED_MIPS_JMPADDR	= 5
IMAGE_REL_BASED_SECTION 	= 6
IMAGE_REL_BASED_REL32		= 7

IMAGE_REL_BASED_MIPS_JMPADDR16	= 9
IMAGE_REL_BASED_IA64_IMM64	= 9
IMAGE_REL_BASED_DIR64		= 10
IMAGE_REL_BASED_HIGH3ADJ	= 11

;
; Archive format.
;

IMAGE_ARCHIVE_START_SIZE	= 8
IMAGE_ARCHIVE_START		equ <'!<arch>', 13, 10, 0>
IMAGE_ARCHIVE_END		equ <'`', 13, 10, 0>
IMAGE_ARCHIVE_PAD		equ <13, 10, 0>
IMAGE_ARCHIVE_LINKER_MEMBER	equ <'/ 	      ', 0>
IMAGE_ARCHIVE_LONGNAMES_MEMBER	equ <'; 	     ', 0>

struc	IMAGE_ARCHIVE_MEMBER_HEADER
	_Name			db 16 dup (?)	; File member name - `/' terminated.
	Date			db 12 dup (?)	; File member date - decimal.
	UserID			db 6 dup (?)	; File member user id - decimal.
	GroupID 		db 6 dup (?)	; File member group id - decimal.
	Mode			db 8 dup (?)	; File member mode - octal.
	Size			db 10 dup (?)	; File member size - decimal.
	EndHeader		db 2 dup (?)	; String to end header.
ends

IMAGE_SIZEOF_ARCHIVE_MEMBER_HDR = 60

;
; DLL support.
;

;
; Export Format
;

struc	IMAGE_EXPORT_DIRECTORY
	Characteristics 	dd ?
	TimeDateStamp		dd ?
	MajorVersion		dw ?
	MinorVersion		dw ?
	_Name			dd ?
	Base			dd ?
	NumberOfFunctions	dd ?
	NumberOfNames		dd ?
	AddressOfFunctions	dd ?		; RVA from base of image
	AddressOfNames		dd ?		; RVA from base of image
	AddressOfNameOrdinals	dd ?		; RVA from base of image
ends

;
; Import Format
;

struc	IMAGE_IMPORT_BY_NAME
	Hint			dw ?
label	_Name			byte
ends

struc	IMAGE_THUNK_DATA64
label	ForwarderString 	dword
label	Function		dword
label	AddressOfData		dword
	Ordinal 		dq ?
ends

struc	IMAGE_THUNK_DATA32
label	ForwarderString 	dword
label	Function		dword
label	AddressOfData		dword
	Ordinal 		dd ?
ends

IMAGE_ORDINAL_FLAG64		equ 08000000000000000h
IMAGE_ORDINAL_FLAG32		= 080000000h

;
; Thread Local Storage
;

proctype IMAGE_TLS_CALLBACK :dword, :dword, :dword

struc	IMAGE_TLS_DIRECTORY64
	StartAddressOfRawData	dq ?
	EndAddressOfRawData	dq ?
	AddressOfIndex		dd ?
	AddressOfCallBacks	dd ?
	SizeOfZeroFill		dd ?
	Characteristics 	dd ?
ends

struc	IMAGE_TLS_DIRECTORY32
	StartAddressOfRawData	dd ?
	EndAddressOfRawData	dd ?
	AddressOfIndex		dd ?
	AddressOfCallBacks	dd ?
	SizeOfZeroFill		dd ?
	Characteristics 	dd ?
ends

IMAGE_ORDINAL_FLAG		= IMAGE_ORDINAL_FLAG32

struc	IMAGE_IMPORT_DESCRIPTOR
label	Characteristics 	dword		; 0 for terminating null import descriptor
	OriginalFirstThunk	dd ?		; RVA to original unbound IAT (PIMAGE_THUNK_DATA)
	TimeDateStamp		dd ?		; 0 if not bound, ; -1 if bound, and real date\time stamp ;	in IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT (new BIND) ; O.W. date/time stamp of DLL bound to (Old BIND)
	ForwarderChain		dd ?		; -1 if no forwarders
	_Name			dd ?
	FirstThunk		dd ?		; RVA to IAT (if bound this IAT has actual addresses)
ends

;
; New format import descriptors pointed to by DataDirectory[ IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT ]
;

struc	IMAGE_BOUND_IMPORT_DESCRIPTOR
	TimeDateStamp		dd ?
	OffsetModuleName	dw ?
	NumberOfModuleForwarderRefs dw ?	; Array of zero or more IMAGE_BOUND_FORWARDER_REF follows
ends

struc	IMAGE_BOUND_FORWARDER_REF
	TimeDateStamp		dd ?
	OffsetModuleName	dw ?
	Reserved		dw ?
ends

;
; Resource Format.
;

;
; Resource directory consists of two counts, following by a variable length
; array of directory entries.  The first count is the number of entries at
; beginning of the array that have actual names associated with each entry.
; The entries are in ascending order, case insensitive strings.  The second
; count is the number of entries that immediately follow the named entries.
; This second count identifies the number of entries that have 16-bit integer
; Ids as their name.  These entries are also sorted in ascending order.
;
; This structure allows fast lookup by either name or number, but for any
; given resource entry only one form of lookup is supported, not both.
; This is consistant with the syntax of the .RC file and the .RES file.
;

struc	IMAGE_RESOURCE_DIRECTORY
	Characteristics 	dd ?
	TimeDateStamp		dd ?
	MajorVersion		dw ?
	MinorVersion		dw ?
	NumberOfNamedEntries	dw ?
	NumberOfIdEntries	dw ?		;  IMAGE_RESOURCE_DIRECTORY_ENTRY DirectoryEntries[];
ends

IMAGE_RESOURCE_NAME_IS_STRING	= 080000000h
IMAGE_RESOURCE_DATA_IS_DIRECTORY = 080000000h
;
; Each directory contains the 32-bit Name of the entry and an offset,
; relative to the beginning of the resource directory of the data associated
; with this directory entry.  If the name of the entry is an actual text
; string instead of an integer Id, then the high order bit of the name field
; is set to one and the low order 31-bits are an offset, relative to the
; beginning of the resource directory of the string, which is of type
; IMAGE_RESOURCE_DIRECTORY_STRING.  Otherwise the high bit is clear and the
; low-order 16-bits are the integer Id that identify this resource directory
; entry. If the directory entry is yet another resource directory (i.e. a
; subdirectory), then the high order bit of the offset field will be
; set to indicate this.  Otherwise the high bit is clear and the offset
; field points to a resource data entry.
;

struc	IMAGE_RESOURCE_DIRECTORY_ENTRY
label	Id			word
	_Name			dd ?
	OffsetToData		dd ?
ends

;
; For resource directory entries that have actual string names, the Name
; field of the directory entry points to an object of the following type.
; All of these string objects are stored together after the last resource
; directory entry and before the first resource data object.  This minimizes
; the impact of these variable length objects on the alignment of the fixed
; size directory entry objects.
;

struc	IMAGE_RESOURCE_DIRECTORY_STRING
	Length			dw ?
label	NameString		byte
ends

struc	IMAGE_RESOURCE_DIR_STRING_U
	Length			dw ?
label	NameString		byte
ends

;
; Each resource data entry describes a leaf node in the resource directory
; tree.  It contains an offset, relative to the beginning of the resource
; directory of the data for the resource, a size field that gives the number
; of bytes of data at that offset, a CodePage that should be used when
; decoding code point values within the resource data.	Typically for new
; applications the code page would be the unicode code page.
;

struc	IMAGE_RESOURCE_DATA_ENTRY
	OffsetToData		dd ?
	Size			dd ?
	CodePage		dd ?
	Reserved		dd ?
ends

;
; Load Configuration Directory Entry
;

struc	IMAGE_LOAD_CONFIG_DIRECTORY32
	Characteristics 	dd ?
	TimeDateStamp		dd ?
	MajorVersion		dw ?
	MinorVersion		dw ?
	GlobalFlagsClear	dd ?
	GlobalFlagsSet		dd ?
	CriticalSectionDefaultTimeout dd ?
	DeCommitFreeBlockThreshold dd ?
	DeCommitTotalFreeThreshold dd ?
	LockPrefixTable 	dd ?		; VA
	MaximumAllocationSize	dd ?
	VirtualMemoryThreshold	dd ?
	ProcessHeapFlags	dd ?
	ProcessAffinityMask	dd ?
	CSDVersion		dw ?
	Reserved1		dw ?
	EditList		dd ?		; VA
label	Reserved		dword
ends

struc	IMAGE_LOAD_CONFIG_DIRECTORY64
	Characteristics 	dd ?
	TimeDateStamp		dd ?
	MajorVersion		dw ?
	MinorVersion		dw ?
	GlobalFlagsClear	dd ?
	GlobalFlagsSet		dd ?
	CriticalSectionDefaultTimeout dd ?
	DeCommitFreeBlockThreshold dd ?
	DeCommitTotalFreeThreshold dd ?
	LockPrefixTable 	dq ?	 ; VA
	MaximumAllocationSize	dd ?
	VirtualMemoryThreshold	dd ?
	ProcessHeapFlags	dd ?
	ProcessAffinityMask	dd ?
	CSDVersion		dw ?
	Reserved1		dw ?
	EditList		dq ?	 ; VA
label	Reserved		dword
ends

IMAGE_LOAD_CONFIG_DIRECTORY	= IMAGE_LOAD_CONFIG_DIRECTORY32

;
; Function table entry format for IA64 images.	Function table is
; pointed to by the IMAGE_DIRECTORY_ENTRY_EXCEPTION directory entry.
; This definition duplicates the one in ntia64.h for use by portable
; image file mungers.
;

struc	IMAGE_IA64_RUNTIME_FUNCTION_ENTRY
	BeginAddress		dd ?
	EndAddress		dd ?
	UnwindInfoAddress	dd ?
ends

;
; Function table entry format for ALPHA images.  Function table is
; pointed to by the IMAGE_DIRECTORY_ENTRY_EXCEPTION directory entry.
; This definition duplicates ones in ntmips.h and ntalpha.h for use
; by portable image file mungers.
;

struc	IMAGE_ALPHA_RUNTIME_FUNCTION_ENTRY
	BeginAddress		dd ?
	EndAddress		dd ?
	ExceptionHandler	dd ?
	HandlerData		dd ?
	PrologEndAddress	dd ?
ends

struc	IMAGE_ALPHA64_RUNTIME_FUNCTION_ENTRY
	BeginAddress		dq ?
	EndAddress		dq ?
	ExceptionHandler	dq ?
	HandlerData		dq ?
	PrologEndAddress	dq ?
ends

;
; WIN CE Exception table format
;

struc	IMAGE_CE_RUNTIME_FUNCTION_ENTRY
	FuncStart		dd ?
	Flags			dd ?
;	PrologLen		dd  : 8 ?
;	FuncLen 		dd  : 22 ?
;	ThirtyTwoBit		dd  : 1 ?
;	ExceptionFlag		dd  : 1 ?
ends

;
; Debug Format
;

struc	IMAGE_DEBUG_DIRECTORY
	Characteristics 	dd ?
	TimeDateStamp		dd ?
	MajorVersion		dw ?
	MinorVersion		dw ?
	Type			dd ?
	SizeOfData		dd ?
	AddressOfRawData	dd ?
	PointerToRawData	dd ?
ends

IMAGE_DEBUG_TYPE_UNKNOWN	= 0
IMAGE_DEBUG_TYPE_COFF		= 1
IMAGE_DEBUG_TYPE_CODEVIEW	= 2
IMAGE_DEBUG_TYPE_FPO		= 3
IMAGE_DEBUG_TYPE_MISC		= 4
IMAGE_DEBUG_TYPE_EXCEPTION	= 5
IMAGE_DEBUG_TYPE_FIXUP		= 6
IMAGE_DEBUG_TYPE_OMAP_TO_SRC	= 7
IMAGE_DEBUG_TYPE_OMAP_FROM_SRC	= 8
IMAGE_DEBUG_TYPE_BORLAND	= 9
IMAGE_DEBUG_TYPE_RESERVED10	= 10

struc	IMAGE_COFF_SYMBOLS_HEADER
	NumberOfSymbols 	dd ?
	LvaToFirstSymbol	dd ?
	NumberOfLinenumbers	dd ?
	LvaToFirstLinenumber	dd ?
	RvaToFirstByteOfCode	dd ?
	RvaToLastByteOfCode	dd ?
	RvaToFirstByteOfData	dd ?
	RvaToLastByteOfData	dd ?
ends

FRAME_FPO			= 0
FRAME_TRAP			= 1
FRAME_TSS			= 2
FRAME_NONFPO			= 3

struc	FPO_DATA
	ulOffStart		dd ?		; offset 1st byte of function code
	cbProcSize		dd ?		; # bytes in function
	cdwLocals		dd ?		; # bytes in locals/4
	cdwParams		dw ?		; # bytes in params/4
	Flags			dw ?
;	cbProlog		dw : 8 ?	; # bytes in prolog
;	cbRegs			dw : 3 ?	; # regs saved
;	fHasSEH 		dw : 1 ?	; TRUE if SEH in func
;	fUseBP			dw : 1 ?	; TRUE if EBP has been allocated
;	reserved		dw : 1 ?	; reserved for future use
;	cbFrame 		dw : 2 ?	; frame type
ends

SIZEOF_RFPO_DATA		= 16

IMAGE_DEBUG_MISC_EXENAME	= 1

struc	IMAGE_DEBUG_MISC
	DataType		dd ?		; type of misc data, see defines
	Length			dd ?		; total length of record, rounded to four ; byte multiple.
	Unicode 		dd ?		; TRUE if data is unicode string
	Reserved		db 3 dup (?)
label	Data			byte		; Actual data
ends

;
; Function table extracted from MIPS/ALPHA/IA64 images.  Does not contain
; information needed only for runtime support.	Just those fields for
; each entry needed by a debugger.
;

struc	IMAGE_FUNCTION_ENTRY
	StartingAddress 	dd ?
	EndingAddress		dd ?
	EndOfPrologue		dd ?
ends

struc	IMAGE_FUNCTION_ENTRY64
	StartingAddress 	dq ?
	EndingAddress		dq ?
label	EndOfPrologue		qword
	UnwindInfoAddress	dq ?
ends

;
; Debugging information can be stripped from an image file and placed
; in a separate .DBG file, whose file name part is the same as the
; image file name part (e.g. symbols for CMD.EXE could be stripped
; and placed in CMD.DBG).  This is indicated by the IMAGE_FILE_DEBUG_STRIPPED
; flag in the Characteristics field of the file header.  The beginning of
; the .DBG file contains the following structure which captures certain
; information from the image file.  This allows a debug to proceed even if
; the original image file is not accessable.  This header is followed by
; zero of more IMAGE_SECTION_HEADER structures, followed by zero or more
; IMAGE_DEBUG_DIRECTORY structures.  The latter structures and those in
; the image file contain file offsets relative to the beginning of the
; .DBG file.
;
; If symbols have been stripped from an image, the IMAGE_DEBUG_MISC structure
; is left in the image file, but not mapped.  This allows a debugger to
; compute the name of the .DBG file, from the name of the image in the
; IMAGE_DEBUG_MISC structure.
;

struc	IMAGE_SEPARATE_DEBUG_HEADER
	Signature		dw ?
	Flags			dw ?
	Machine 		dw ?
	Characteristics 	dw ?
	TimeDateStamp		dd ?
	CheckSum		dd ?
	ImageBase		dd ?
	SizeOfImage		dd ?
	NumberOfSections	dd ?
	ExportedNamesSize	dd ?
	DebugDirectorySize	dd ?
	SectionAlignment	dd ?
	Reserved		dd 2 dup (?)
ends

IMAGE_SEPARATE_DEBUG_SIGNATURE	= 04944h

IMAGE_SEPARATE_DEBUG_FLAGS_MASK = 08000h
IMAGE_SEPARATE_DEBUG_MISMATCH	= 08000h  ; when DBG was updated, the
						; old checksum didn't match.

;
;  The .arch section is made up of headers, each describing an amask position/value
;  pointing to an array of IMAGE_ARCHITECTURE_ENTRY's.	Each "array" (both the header
;  and entry arrays) are terminiated by a quadword of 0xffffffffL.
;
;  NOTE: There may be quadwords of 0 sprinkled around and must be skipped.
;

struc	IMAGE_ARCHITECTURE_HEADER
	Flags			dd ?
	FirstEntryRVA		dd ?		; RVA into .arch section to array of ARCHITECTURE_ENTRY's
ends

struc	IMAGE_ARCHITECTURE_ENTRY
	FixupInstRVA		dd ?		; RVA of instruction to fixup
	NewInst 		dd ?		; fixup instruction (see alphaops.h)
ends

; The following structure defines the new import object.  Note the values of the first two fields,
; which must be set as stated in order to differentiate old and new import members.
; Following this structure, the linker emits two null-terminated strings used to recreate the
; import at the time of use.  The first string is the import's name, the second is the dll's name.

IMPORT_OBJECT_HDR_SIG2		= 0fffh

struc	IMPORT_OBJECT_HEADER
	Sig1			dw ?		; Must be IMAGE_FILE_MACHINE_UNKNOWN
	Sig2			dw ?		; Must be IMPORT_OBJECT_HDR_SIG2.
	_Version		dw ?
	Machine 		dw ?
	TimeDateStamp		dd ?		; Time/date stamp
	SizeOfData		dd ?		; particularly useful for incremental links
label	Ordinal 		word		; if grf & IMPORT_OBJECT_ORDINAL
	Hint			dw ?
	Flags			dw ?
;	Type			dw  : 2 ?	; IMPORT_TYPE
;	NameType		dw  : 3 ?	; IMPORT_NAME_TYPE
;	Reserved		dw  : 11 ?	; Reserved. Must be zero.
ends

enum	IMPORT_OBJECT_TYPE\
	IMPORT_OBJECT_CODE=0,\
	IMPORT_OBJECT_DATA=1,\
	IMPORT_OBJECT_CONST=2

enum	IMPORT_OBJECT_NAME_TYPE\
	IMPORT_OBJECT_ORDINAL=0,\		 ; Import by ordinal
	IMPORT_OBJECT_NAME=1,\			 ; Import name == public symbol name.
	IMPORT_OBJECT_NAME_NO_PREFIX=2,\	 ; Import name == public symbol name skipping leading ?, @, or optionally _.
	IMPORT_OBJECT_NAME_UNDECORATE=3 	 ; Import name == public symbol name skipping leading ?, @, or optionally _ ; and truncating at first @

;
; End Image Format
;

HEAP_NO_SERIALIZE		= 000000001h
HEAP_GROWABLE			= 000000002h
HEAP_GENERATE_EXCEPTIONS	= 000000004h
HEAP_ZERO_MEMORY		= 000000008h
HEAP_REALLOC_IN_PLACE_ONLY	= 000000010h
HEAP_TAIL_CHECKING_ENABLED	= 000000020h
HEAP_FREE_CHECKING_ENABLED	= 000000040h
HEAP_DISABLE_COALESCE_ON_FREE	= 000000080h
HEAP_CREATE_ALIGN_16		= 000010000h
HEAP_CREATE_ENABLE_TRACING	= 000020000h
HEAP_MAXIMUM_TAG		= 00FFFh
HEAP_PSEUDO_TAG_FLAG		= 08000h
HEAP_TAG_SHIFT			= 18

IS_TEXT_UNICODE_ASCII16 	= 00001h
IS_TEXT_UNICODE_REVERSE_ASCII16 = 00010h

IS_TEXT_UNICODE_STATISTICS	= 00002h
IS_TEXT_UNICODE_REVERSE_STATISTICS = 00020h

IS_TEXT_UNICODE_CONTROLS	= 00004h
IS_TEXT_UNICODE_REVERSE_CONTROLS = 00040h

IS_TEXT_UNICODE_SIGNATURE	= 00008h
IS_TEXT_UNICODE_REVERSE_SIGNATURE = 00080h

IS_TEXT_UNICODE_ILLEGAL_CHARS	= 00100h
IS_TEXT_UNICODE_ODD_LENGTH	= 00200h
IS_TEXT_UNICODE_DBCS_LEADBYTE	= 00400h
IS_TEXT_UNICODE_NULL_BYTES	= 01000h

IS_TEXT_UNICODE_UNICODE_MASK	= 0000Fh
IS_TEXT_UNICODE_REVERSE_MASK	= 000F0h
IS_TEXT_UNICODE_NOT_UNICODE_MASK = 00F00h
IS_TEXT_UNICODE_NOT_ASCII_MASK	= 0F000h

COMPRESSION_FORMAT_NONE 	= (00000h)
COMPRESSION_FORMAT_DEFAULT	= (00001h)
COMPRESSION_FORMAT_LZNT1	= (00002h)
COMPRESSION_ENGINE_STANDARD	= (00000h)
COMPRESSION_ENGINE_MAXIMUM	= (00100h)

struc	MESSAGE_RESOURCE_ENTRY
	Length			dw ?
	Flags			dw ?
label	Text			byte
ends

MESSAGE_RESOURCE_UNICODE	= 00001h

struc	MESSAGE_RESOURCE_BLOCK
	LowId			dd ?
	HighId			dd ?
	OffsetToEntries 	dd ?
ends

struc	MESSAGE_RESOURCE_DATA
	NumberOfBlocks		dd ?
label	Blocks			MESSAGE_RESOURCE_BLOCK
ends

struc	RTL_CRITICAL_SECTION_DEBUG
	Type			dw ?
	CreatorBackTraceIndex	dw ?
	CriticalSection 	dd ?
	ProcessLocksList	LIST_ENTRY ?
	EntryCount		dd ?
	ContentionCount 	dd ?
	Spare			dd 2 dup (?)
ends

RTL_CRITSECT_TYPE		= 0
RTL_RESOURCE_TYPE		= 1

struc	RTL_CRITICAL_SECTION
	DebugInfo		dd ?
;
;  The following three fields control entering and exiting the critical
;  section for the resource
;
	LockCount		dd ?
	RecursionCount		dd ?
	OwningThread		dd ?		; from the thread's ClientId->UniqueThread
	LockSemaphore		dd ?
	SpinCount		dd ?
ends

SEF_DACL_AUTO_INHERIT		= 001h
SEF_SACL_AUTO_INHERIT		= 002h
SEF_DEFAULT_DESCRIPTOR_FOR_OBJECT = 004h
SEF_AVOID_PRIVILEGE_CHECK	= 008h
SEF_AVOID_OWNER_CHECK		= 010h
SEF_DEFAULT_OWNER_FROM_PARENT	= 020h
SEF_DEFAULT_GROUP_FROM_PARENT	= 040h
WT_EXECUTEDEFAULT		= 000000000h
WT_EXECUTEINIOTHREAD		= 000000001h
WT_EXECUTEINUITHREAD		= 000000002h
WT_EXECUTEINWAITTHREAD		= 000000004h
WT_EXECUTEDELETEWAIT		= 000000008h
WT_EXECUTEINLONGTHREAD		= 000000010h

proctype WAITORTIMERCALLBACKFUNC :dword, :dword
proctype WORKERCALLBACKFUNC :dword, :dword

WAITORTIMERCALLBACK		equ <WAITORTIMERCALLBACKFUNC>
WORKERCALLBACK			equ <WORKERCALLBACKFUNC>

DLL_PROCESS_ATTACH		= 1
DLL_THREAD_ATTACH		= 2
DLL_THREAD_DETACH		= 3
DLL_PROCESS_DETACH		= 0

;
; Defines for the READ flags for Eventlogging
;
EVENTLOG_SEQUENTIAL_READ	= 00001h
EVENTLOG_SEEK_READ		= 00002h
EVENTLOG_FORWARDS_READ		= 00004h
EVENTLOG_BACKWARDS_READ 	= 00008h

;
; The types of events that can be logged.
;
EVENTLOG_SUCCESS		= 00000h
EVENTLOG_ERROR_TYPE		= 00001h
EVENTLOG_WARNING_TYPE		= 00002h
EVENTLOG_INFORMATION_TYPE	= 00004h
EVENTLOG_AUDIT_SUCCESS		= 00008h
EVENTLOG_AUDIT_FAILURE		= 00010h

;
; Defines for the WRITE flags used by Auditing for paired events
; These are not implemented in Product 1
;

EVENTLOG_START_PAIRED_EVENT	= 00001h
EVENTLOG_END_PAIRED_EVENT	= 00002h
EVENTLOG_END_ALL_PAIRED_EVENTS	= 00004h
EVENTLOG_PAIRED_EVENT_ACTIVE	= 00008h
EVENTLOG_PAIRED_EVENT_INACTIVE	= 00010h

;
; Structure that defines the header of the Eventlog record. This is the
; fixed-sized portion before all the variable-length strings, binary
; data and pad bytes.
;
; TimeGenerated is the time it was generated at the client.
; TimeWritten is the time it was put into the log at the server end.
;

struc	EVENTLOGRECORD
	Length			dd ?		; Length of full record
	Reserved		dd ?		; Used by the service
	RecordNumber		dd ?		; Absolute record number
	TimeGenerated		dd ?		; Seconds since 1-1-1970
	TimeWritten		dd ?		; Seconds since 1-1-1970
	EventID 		dd ?
	EventType		dw ?
	NumStrings		dw ?
	EventCategory		dw ?
	ReservedFlags		dw ?		; For use with paired events (auditing)
	ClosingRecordNumber	dd ?		; For use with paired events (auditing)
	StringOffset		dd ?		; Offset from beginning of record
	UserSidLength		dd ?
	UserSidOffset		dd ?
	DataLength		dd ?
	DataOffset		dd ?		; Offset from beginning of record
;
; Then follow:
;
; WCHAR SourceName[]
; WCHAR Computername[]
; SID	UserSid
; WCHAR Strings[]
; BYTE	Data[]
; CHAR	Pad[]
; DWORD Length
;
ends

;SS: start of changes to support clustering
;SS: ideally the
MAXLOGICALLOGNAMESIZE		= 256

struc	EVENTSFORLOGFILE
	ulSize			dd ?
	szLogicalLogFile	db MAXLOGICALLOGNAMESIZE dup (?) ;name of the logical file-security/application/system
	ulNumRecords		dd ?
	pEventLogRecords	dd ?
ends

struc	PACKEDEVENTINFO
	ulSize			dd ?		;total size of the structure
	ulNumEventsForLogFile	dd ?		;number of EventsForLogFile structure that follow
	ulOffsets		dd ?		;the offsets from the start of this structure to the EVENTSFORLOGFILE structure
ends

;SS: end of changes to support clustering
DBG_CONTINUE			= (000010002h)
DBG_TERMINATE_THREAD		= (040010003h)
DBG_TERMINATE_PROCESS		= (040010004h)
DBG_CONTROL_C			= (040010005h)
DBG_CONTROL_BREAK		= (040010008h)
DBG_EXCEPTION_NOT_HANDLED	= (080010001h)

;
; Registry Specific Access Rights.
;

KEY_QUERY_VALUE 		= (00001h)
KEY_SET_VALUE			= (00002h)
KEY_CREATE_SUB_KEY		= (00004h)
KEY_ENUMERATE_SUB_KEYS		= (00008h)
KEY_NOTIFY			= (00010h)
KEY_CREATE_LINK 		= (00020h)

KEY_READ			= ((STANDARD_RIGHTS_READ      +\
				   KEY_QUERY_VALUE	      +\
				   KEY_ENUMERATE_SUB_KEYS     +\
				   KEY_NOTIFY)		       \
				   and			       \
				   (not SYNCHRONIZE))

KEY_WRITE			= ((STANDARD_RIGHTS_WRITE     +\
				   KEY_SET_VALUE	      +\
				   KEY_CREATE_SUB_KEY)	       \
				   and			       \
				   (not SYNCHRONIZE))

KEY_EXECUTE			= ((KEY_READ)		       \
				   and			       \
				   (not SYNCHRONIZE))

KEY_ALL_ACCESS			= ((STANDARD_RIGHTS_ALL       +\
				   KEY_QUERY_VALUE	      +\
				   KEY_SET_VALUE	      +\
				   KEY_CREATE_SUB_KEY	      +\
				   KEY_ENUMERATE_SUB_KEYS     +\
				   KEY_NOTIFY		      +\
				   KEY_CREATE_LINK)	       \
				   and			       \
				   (not SYNCHRONIZE))

;
; Open/Create Options
;

REG_OPTION_RESERVED		= (000000000h)	 ; Parameter is reserved
REG_OPTION_NON_VOLATILE 	= (000000000h)	 ; Key is preserved
						 ; when system is rebooted
REG_OPTION_VOLATILE		= (000000001h)	 ; Key is not preserved
						 ; when system is rebooted
REG_OPTION_CREATE_LINK		= (000000002h)	 ; Created key is a
						 ; symbolic link
REG_OPTION_BACKUP_RESTORE	= (000000004h)	 ; open for backup or restore
						 ; special access rules
						 ; privilege required
REG_OPTION_OPEN_LINK		= (000000008h)	 ; Open symbolic link

REG_LEGAL_OPTION		= \
		 (REG_OPTION_RESERVED		 +\
		  REG_OPTION_NON_VOLATILE	 +\
		  REG_OPTION_VOLATILE		 +\
		  REG_OPTION_CREATE_LINK	 +\
		  REG_OPTION_BACKUP_RESTORE	 +\
		  REG_OPTION_OPEN_LINK)

;
; Key creation/open disposition
;

REG_CREATED_NEW_KEY		= (000000001h)	 ; New Registry Key created
REG_OPENED_EXISTING_KEY 	= (000000002h)	 ; Existing Key opened

;
; Key restore flags
;

REG_WHOLE_HIVE_VOLATILE 	= (000000001h)	 ; Restore whole hive volatile
REG_REFRESH_HIVE		= (000000002h)	 ; Unwind changes to last flush
REG_NO_LAZY_FLUSH		= (000000004h)	 ; Never lazy flush this hive

;
; Notify filter values
;
REG_NOTIFY_CHANGE_NAME		= (000000001h) ; Create or delete (child)
REG_NOTIFY_CHANGE_ATTRIBUTES	= (000000002h)
REG_NOTIFY_CHANGE_LAST_SET	= (000000004h) ; time stamp
REG_NOTIFY_CHANGE_SECURITY	= (000000008h)

REG_LEGAL_CHANGE_FILTER 	= \
		 (REG_NOTIFY_CHANGE_NAME	  +\
		  REG_NOTIFY_CHANGE_ATTRIBUTES	  +\
		  REG_NOTIFY_CHANGE_LAST_SET	  +\
		  REG_NOTIFY_CHANGE_SECURITY)

;
; Predefined Value Types.
;

REG_NONE			= ( 0 )   ; No value type
REG_SZ				= ( 1 )   ; Unicode nul terminated string
REG_EXPAND_SZ			= ( 2 )   ; Unicode nul terminated string
					    ; (with environment variable references)
REG_BINARY			= ( 3 )   ; Free form binary
REG_DWORD			= ( 4 )   ; 32-bit number
REG_DWORD_LITTLE_ENDIAN 	= ( 4 )   ; 32-bit number (same as REG_DWORD)
REG_DWORD_BIG_ENDIAN		= ( 5 )   ; 32-bit number
REG_LINK			= ( 6 )   ; Symbolic Link (unicode)
REG_MULTI_SZ			= ( 7 )   ; Multiple Unicode strings
REG_RESOURCE_LIST		= ( 8 )   ; Resource list in the resource map
REG_FULL_RESOURCE_DESCRIPTOR	= ( 9 )  ; Resource list in the hardware description
REG_RESOURCE_REQUIREMENTS_LIST	= ( 10 )

;
; Service Types (Bit Mask)
;
SERVICE_KERNEL_DRIVER		= 000000001h
SERVICE_FILE_SYSTEM_DRIVER	= 000000002h
SERVICE_ADAPTER 		= 000000004h
SERVICE_RECOGNIZER_DRIVER	= 000000008h

SERVICE_DRIVER			= (SERVICE_KERNEL_DRIVER      +\
				   SERVICE_FILE_SYSTEM_DRIVER +\
				   SERVICE_RECOGNIZER_DRIVER)

SERVICE_WIN32_OWN_PROCESS	= 000000010h
SERVICE_WIN32_SHARE_PROCESS	= 000000020h
SERVICE_WIN32			= (SERVICE_WIN32_OWN_PROCESS +\
				   SERVICE_WIN32_SHARE_PROCESS)

SERVICE_INTERACTIVE_PROCESS	= 000000100h

SERVICE_TYPE_ALL		= (SERVICE_WIN32   +\
				   SERVICE_ADAPTER +\
				   SERVICE_DRIVER  +\
				   SERVICE_INTERACTIVE_PROCESS)

;
; Start Type
;

SERVICE_BOOT_START		= 000000000h
SERVICE_SYSTEM_START		= 000000001h
SERVICE_AUTO_START		= 000000002h
SERVICE_DEMAND_START		= 000000003h
SERVICE_DISABLED		= 000000004h

;
; Error control type
;
SERVICE_ERROR_IGNORE		= 000000000h
SERVICE_ERROR_NORMAL		= 000000001h
SERVICE_ERROR_SEVERE		= 000000002h
SERVICE_ERROR_CRITICAL		= 000000003h

;
; Define the registry driver node enumerations
;

enum	SERVICE_NODE_TYPE\
	DriverType=SERVICE_KERNEL_DRIVER,\
	FileSystemType=SERVICE_FILE_SYSTEM_DRIVER,\
	Win32ServiceOwnProcess=SERVICE_WIN32_OWN_PROCESS,\
	Win32ServiceShareProcess=SERVICE_WIN32_SHARE_PROCESS,\
	AdapterType=SERVICE_ADAPTER,\
	RecognizerType=SERVICE_RECOGNIZER_DRIVER

enum	SERVICE_LOAD_TYPE\
	BootLoad=SERVICE_BOOT_START,\
	SystemLoad=SERVICE_SYSTEM_START,\
	AutoLoad=SERVICE_AUTO_START,\
	DemandLoad=SERVICE_DEMAND_START,\
	DisableLoad=SERVICE_DISABLED

enum	SERVICE_ERROR_TYPE\
	IgnoreError=SERVICE_ERROR_IGNORE,\
	NormalError=SERVICE_ERROR_NORMAL,\
	SevereError=SERVICE_ERROR_SEVERE,\
	CriticalError=SERVICE_ERROR_CRITICAL

;
; IOCTL_TAPE_ERASE definitions
;

TAPE_ERASE_SHORT		= 0
TAPE_ERASE_LONG 		= 1

struc	TAPE_ERASE
	Type			dd ?
	Immediate		dd ?
ends

;
; IOCTL_TAPE_PREPARE definitions
;

TAPE_LOAD			= 0
TAPE_UNLOAD			= 1
TAPE_TENSION			= 2
TAPE_LOCK			= 3
TAPE_UNLOCK			= 4
TAPE_FORMAT			= 5


struc	TAPE_PREPARE
	Operation		dd ?
	Immediate		dd ?
ends

;
; IOCTL_TAPE_WRITE_MARKS definitions
;

TAPE_SETMARKS			= 0
TAPE_FILEMARKS			= 1
TAPE_SHORT_FILEMARKS		= 2
TAPE_LONG_FILEMARKS		= 3

struc	TAPE_WRITE_MARKS
	Type			dd ?
	Count			dd ?
	Immediate		dd ?
ends

;
; IOCTL_TAPE_GET_POSITION definitions
;

TAPE_ABSOLUTE_POSITION		= 0
TAPE_LOGICAL_POSITION		= 1
TAPE_PSEUDO_LOGICAL_POSITION	= 2

struc	TAPE_GET_POSITION
	Type			dd ?
	Partition		dd ?
	Offset			dq ?
ends

;
; IOCTL_TAPE_SET_POSITION definitions
;

TAPE_REWIND			= 0
TAPE_ABSOLUTE_BLOCK		= 1
TAPE_LOGICAL_BLOCK		= 2
TAPE_PSEUDO_LOGICAL_BLOCK	= 3
TAPE_SPACE_END_OF_DATA		= 4
TAPE_SPACE_RELATIVE_BLOCKS	= 5
TAPE_SPACE_FILEMARKS		= 6
TAPE_SPACE_SEQUENTIAL_FMKS	= 7
TAPE_SPACE_SETMARKS		= 8
TAPE_SPACE_SEQUENTIAL_SMKS	= 9

struc	TAPE_SET_POSITION
	Method			dd ?
	Partition		dd ?
	Offset			dq ?
	Immediate		dd ?
ends

;
; IOCTL_TAPE_GET_DRIVE_PARAMS definitions
;

;
; Definitions for FeaturesLow parameter
;

TAPE_DRIVE_FIXED		= 000000001h
TAPE_DRIVE_SELECT		= 000000002h
TAPE_DRIVE_INITIATOR		= 000000004h

TAPE_DRIVE_ERASE_SHORT		= 000000010h
TAPE_DRIVE_ERASE_LONG		= 000000020h
TAPE_DRIVE_ERASE_BOP_ONLY	= 000000040h
TAPE_DRIVE_ERASE_IMMEDIATE	= 000000080h

TAPE_DRIVE_TAPE_CAPACITY	= 000000100h
TAPE_DRIVE_TAPE_REMAINING	= 000000200h
TAPE_DRIVE_FIXED_BLOCK		= 000000400h
TAPE_DRIVE_VARIABLE_BLOCK	= 000000800h

TAPE_DRIVE_WRITE_PROTECT	= 000001000h
TAPE_DRIVE_EOT_WZ_SIZE		= 000002000h

TAPE_DRIVE_ECC			= 000010000h
TAPE_DRIVE_COMPRESSION		= 000020000h
TAPE_DRIVE_PADDING		= 000040000h
TAPE_DRIVE_REPORT_SMKS		= 000080000h

TAPE_DRIVE_GET_ABSOLUTE_BLK	= 000100000h
TAPE_DRIVE_GET_LOGICAL_BLK	= 000200000h
TAPE_DRIVE_SET_EOT_WZ_SIZE	= 000400000h

TAPE_DRIVE_EJECT_MEDIA		= 001000000h
TAPE_DRIVE_CLEAN_REQUESTS	= 002000000h
TAPE_DRIVE_SET_CMP_BOP_ONLY	= 004000000h

TAPE_DRIVE_RESERVED_BIT 	= 080000000h  ;don't use this bit!
					      ;can't be a low features bit!
					      ;reserved; high features only

;
; Definitions for FeaturesHigh parameter
;

TAPE_DRIVE_LOAD_UNLOAD		= 080000001h
TAPE_DRIVE_TENSION		= 080000002h
TAPE_DRIVE_LOCK_UNLOCK		= 080000004h
TAPE_DRIVE_REWIND_IMMEDIATE	= 080000008h

TAPE_DRIVE_SET_BLOCK_SIZE	= 080000010h
TAPE_DRIVE_LOAD_UNLD_IMMED	= 080000020h
TAPE_DRIVE_TENSION_IMMED	= 080000040h
TAPE_DRIVE_LOCK_UNLK_IMMED	= 080000080h

TAPE_DRIVE_SET_ECC		= 080000100h
TAPE_DRIVE_SET_COMPRESSION	= 080000200h
TAPE_DRIVE_SET_PADDING		= 080000400h
TAPE_DRIVE_SET_REPORT_SMKS	= 080000800h

TAPE_DRIVE_ABSOLUTE_BLK 	= 080001000h
TAPE_DRIVE_ABS_BLK_IMMED	= 080002000h
TAPE_DRIVE_LOGICAL_BLK		= 080004000h
TAPE_DRIVE_LOG_BLK_IMMED	= 080008000h

TAPE_DRIVE_END_OF_DATA		= 080010000h
TAPE_DRIVE_RELATIVE_BLKS	= 080020000h
TAPE_DRIVE_FILEMARKS		= 080040000h
TAPE_DRIVE_SEQUENTIAL_FMKS	= 080080000h

TAPE_DRIVE_SETMARKS		= 080100000h
TAPE_DRIVE_SEQUENTIAL_SMKS	= 080200000h
TAPE_DRIVE_REVERSE_POSITION	= 080400000h
TAPE_DRIVE_SPACE_IMMEDIATE	= 080800000h

TAPE_DRIVE_WRITE_SETMARKS	= 081000000h
TAPE_DRIVE_WRITE_FILEMARKS	= 082000000h
TAPE_DRIVE_WRITE_SHORT_FMKS	= 084000000h
TAPE_DRIVE_WRITE_LONG_FMKS	= 088000000h

TAPE_DRIVE_WRITE_MARK_IMMED	= 090000000h
TAPE_DRIVE_FORMAT		= 0A0000000h
TAPE_DRIVE_FORMAT_IMMEDIATE	= 0C0000000h
TAPE_DRIVE_HIGH_FEATURES	= 080000000h  ;mask for high features flag


struc	TAPE_GET_DRIVE_PARAMETERS
	ECC			dd ?
	Compression		dd ?
	DataPadding		dd ?
	ReportSetmarks		dd ?
	DefaultBlockSize	dd ?
	MaximumBlockSize	dd ?
	MinimumBlockSize	dd ?
	MaximumPartitionCount	dd ?
	FeaturesLow		dd ?
	FeaturesHigh		dd ?
	EOTWarningZoneSize	dd ?
ends

;
; IOCTL_TAPE_SET_DRIVE_PARAMETERS definitions
;

struc	TAPE_SET_DRIVE_PARAMETERS
	ECC			dd ?
	Compression		dd ?
	DataPadding		dd ?
	ReportSetmarks		dd ?
	EOTWarningZoneSize	dd ?
ends

;
; IOCTL_TAPE_GET_MEDIA_PARAMETERS definitions
;

struc	TAPE_GET_MEDIA_PARAMETERS
	Capacity		dq ?
	Remaining		dq ?
	BlockSize		dd ?
	PartitionCount		dd ?
	WriteProtected		dd ?
ends

;
; IOCTL_TAPE_SET_MEDIA_PARAMETERS definitions
;

struc	TAPE_SET_MEDIA_PARAMETERS
	BlockSize		dd ?
ends

;
; IOCTL_TAPE_CREATE_PARTITION definitions
;

TAPE_FIXED_PARTITIONS		= 0
TAPE_SELECT_PARTITIONS		= 1
TAPE_INITIATOR_PARTITIONS	= 2

struc	TAPE_CREATE_PARTITION
	Method			dd ?
	Count			dd ?
	Size			dd ?
ends
