;++
;
;Copyright (C) 1993-1998 Microsoft Corporation
;
;Module Name:
;
;    winperf.h
;
;Abstract:
;
;    Header file for the Performance Monitor data.
;
;    This file contains the definitions of the data structures returned
;    by the Configuration Registry in response to a request for
;    performance data.	This file is used by both the Configuration
;    Registry and the Performance Monitor to define their interface.
;    The complete interface is described here, except for the name
;    of the node to query in the registry.  It is
;
;		    HKEY_PERFORMANCE_DATA.
;
;    By querying that node with a subkey of "Global" the caller will
;    retrieve the structures described here.
;
;    There is no need to RegOpenKey() the reserved handle HKEY_PERFORMANCE_DATA,
;    but the caller should RegCloseKey() the handle so that network transports
;    and drivers can be removed or installed (which cannot happen while
;    they are open for monitoring.)  Remote requests m
;ust first
;    RegConnectRegistry().

;--*/

;  Data structure definitions.

;  In order for data to be returned through the Configuration Registry
;  in a system-independent fashion, it must be self-describing.

;  In the following, all offsets are in bytes.

;
;  Data is returned through the Configuration Registry in a
;  a data block which begins with a _PERF_DATA_BLOCK structure.
;

PERF_DATA_VERSION		= 1
PERF_DATA_REVISION		= 1


struc	PERF_DATA_BLOCK
	Signature		db 4 dup (?)
	LittleEndian		dd ?
	_Version		dd ?
	Revision		dd ?
	TotalByteLength 	dd ?
	HeaderLength		dd ?
	NumObjectTypes		dd ?
	DefaultObject		dd ?
	SystemTime		SYSTEMTIME ?
	PerfTime		dq ?
	PerfFreq		dq ?
	PerfTime100nSec 	dq ?
	SystemNameLength	dd ?
	SystemNameOffset	dd ?
ends

;
;  The _PERF_DATA_BLOCK structure is followed by NumObjectTypes of
;  data sections, one for each type of object measured.  Each object
;  type section begins with a _PERF_OBJECT_TYPE structure.
;

struc	PERF_OBJECT_TYPE
	TotalByteLength 	dd ?
	DefinitionLength	dd ?
	HeaderLength		dd ?
	ObjectNameTitleIndex	dd ?
	ObjectNameTitle 	dd ?
	ObjectHelpTitleIndex	dd ?
	ObjectHelpTitle 	dd ?
	DetailLevel		dd ?
	NumCounters		dd ?
	DefaultCounter		dd ?
	NumInstances		dd ?
	CodePage		dd ?
	PerfTime		dq ?
	PerfFreq		dq ?
ends

PERF_NO_INSTANCES		= -1  ; no instances (see NumInstances above)
;
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
;  PERF_COUNTER_DEFINITION.CounterType field values
;
;
;	 Counter ID Field Definition:
;
;   3	   2	    2	 2    2        1	1    1
;   1	   8	    4	 2    0        6	2    0	  8		   0
;  +--------+--------+----+----+--------+--------+----+----+----------------+
;  +Display +Calculation  +Time+Counter +	 +Ctr +Size+		    +
;  +Flags   +Modifiers	  +Base+SubType +Reserved+Type+Fld +   Reserved     +
;  +--------+--------+----+----+--------+--------+----+----+----------------+
;
;
;  The counter type is the "or" of the following values as described below
;
;  select one of the following to indicate the counter's data size
;
PERF_SIZE_DWORD 		= 000000000h
PERF_SIZE_LARGE 		= 000000100h
PERF_SIZE_ZERO			= 000000200h  ; for Zero Length fields
PERF_SIZE_VARIABLE_LEN		= 000000300h  ; length is in CounterLength field
					    ;  of Counter Definition struct
;
;  select one of the following values to indicate the counter field usage
;
PERF_TYPE_NUMBER		= 000000000h  ; a number (not a counter)
PERF_TYPE_COUNTER		= 000000400h  ; an increasing numeric value
PERF_TYPE_TEXT			= 000000800h  ; a text field
PERF_TYPE_ZERO			= 000000C00h  ; displays a zero
;
;  If the PERF_TYPE_NUMBER field was selected, then select one of the
;  following to describe the Number
;
PERF_NUMBER_HEX 		= 000000000h  ; display as HEX value
PERF_NUMBER_DECIMAL		= 000010000h  ; display as a decimal integer
PERF_NUMBER_DEC_1000		= 000020000h  ; display as a decimal/1000
;
;  If the PERF_TYPE_COUNTER value was selected then select one of the
;  following to indicate the type of counter
;
PERF_COUNTER_VALUE		= 000000000h  ; display counter value
PERF_COUNTER_RATE		= 000010000h  ; divide ctr / delta time
PERF_COUNTER_FRACTION		= 000020000h  ; divide ctr / base
PERF_COUNTER_BASE		= 000030000h  ; base value used in fractions
PERF_COUNTER_ELAPSED		= 000040000h  ; subtract counter from current time
PERF_COUNTER_QUEUELEN		= 000050000h  ; Use Queuelen processing func.
PERF_COUNTER_HISTOGRAM		= 000060000h  ; Counter begins or ends a histogram
;
;  If the PERF_TYPE_TEXT value was selected, then select one of the
;  following to indicate the type of TEXT data.
;
PERF_TEXT_UNICODE		= 000000000h  ; type of text in text field
PERF_TEXT_ASCII 		= 000010000h  ; ASCII using the CodePage field
;
;  Timer SubTypes
;
PERF_TIMER_TICK 		= 000000000h  ; use system perf. freq for base
PERF_TIMER_100NS		= 000100000h  ; use 100 NS timer time base units
PERF_OBJECT_TIMER		= 000200000h  ; use the object timer freq
;
;  Any types that have calculations performed can use one or more of
;  the following calculation modification flags listed here
;
PERF_DELTA_COUNTER		= 000400000h  ; compute difference first
PERF_DELTA_BASE 		= 000800000h  ; compute base diff as well
PERF_INVERSE_COUNTER		= 001000000h  ; show as 1.00-value (assumes:
PERF_MULTI_COUNTER		= 002000000h  ; sum of multiple instances
;
;  Select one of the following values to indicate the display suffix (if any)
;
PERF_DISPLAY_NO_SUFFIX		= 000000000h  ; no suffix
PERF_DISPLAY_PER_SEC		= 010000000h  ; "/sec"
PERF_DISPLAY_PERCENT		= 020000000h  ; "%"
PERF_DISPLAY_SECONDS		= 030000000h  ; "secs"
PERF_DISPLAY_NOSHOW		= 040000000h  ; value is not displayed
;
;  Predefined counter types
;

PERF_COUNTER_COUNTER = (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
		PERF_TIMER_TICK + PERF_DELTA_COUNTER + PERF_DISPLAY_PER_SEC)

PERF_COUNTER_TIMER = (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
		PERF_TIMER_TICK + PERF_DELTA_COUNTER + PERF_DISPLAY_PERCENT)

PERF_COUNTER_QUEUELEN_TYPE	= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_QUEUELEN +\
	    PERF_TIMER_TICK + PERF_DELTA_COUNTER + PERF_DISPLAY_NO_SUFFIX)

PERF_COUNTER_LARGE_QUEUELEN_TYPE = \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_QUEUELEN +\
	    PERF_TIMER_TICK + PERF_DELTA_COUNTER + PERF_DISPLAY_NO_SUFFIX)

PERF_COUNTER_BULK_COUNT 	= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
	    PERF_TIMER_TICK + PERF_DELTA_COUNTER + PERF_DISPLAY_PER_SEC)

PERF_COUNTER_TEXT		= \
	    (PERF_SIZE_VARIABLE_LEN + PERF_TYPE_TEXT + PERF_TEXT_UNICODE +\
	    PERF_DISPLAY_NO_SUFFIX)

PERF_COUNTER_RAWCOUNT		= \
	    (PERF_SIZE_DWORD + PERF_TYPE_NUMBER + PERF_NUMBER_DECIMAL +\
	    PERF_DISPLAY_NO_SUFFIX)

PERF_COUNTER_LARGE_RAWCOUNT	= \
	    (PERF_SIZE_LARGE + PERF_TYPE_NUMBER + PERF_NUMBER_DECIMAL +\
	    PERF_DISPLAY_NO_SUFFIX)

PERF_COUNTER_RAWCOUNT_HEX	= \
	    (PERF_SIZE_DWORD + PERF_TYPE_NUMBER + PERF_NUMBER_HEX +\
	    PERF_DISPLAY_NO_SUFFIX)

PERF_COUNTER_LARGE_RAWCOUNT_HEX = \
	    (PERF_SIZE_LARGE + PERF_TYPE_NUMBER + PERF_NUMBER_HEX +\
	    PERF_DISPLAY_NO_SUFFIX)


PERF_SAMPLE_FRACTION		= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_FRACTION +\
	    PERF_DELTA_COUNTER + PERF_DELTA_BASE + PERF_DISPLAY_PERCENT)

PERF_SAMPLE_COUNTER		= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
	    PERF_TIMER_TICK + PERF_DELTA_COUNTER + PERF_DISPLAY_NO_SUFFIX)

PERF_COUNTER_NODATA		= \
	    (PERF_SIZE_ZERO + PERF_DISPLAY_NOSHOW)

PERF_COUNTER_TIMER_INV		= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
	    PERF_TIMER_TICK + PERF_DELTA_COUNTER + PERF_INVERSE_COUNTER + \
	    PERF_DISPLAY_PERCENT)

PERF_SAMPLE_BASE		= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_BASE +\
	    PERF_DISPLAY_NOSHOW +\
	    000000001h)  ; for compatibility with pre-beta versions

PERF_AVERAGE_TIMER		= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_FRACTION +\
	    PERF_DISPLAY_SECONDS)

PERF_AVERAGE_BASE		= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_BASE +\
	    PERF_DISPLAY_NOSHOW +\
	    000000002h)  ; for compatibility with pre-beta versions


PERF_AVERAGE_BULK		= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_FRACTION  +\
	    PERF_DISPLAY_NOSHOW)

PERF_100NSEC_TIMER		= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
	    PERF_TIMER_100NS + PERF_DELTA_COUNTER + PERF_DISPLAY_PERCENT)

PERF_100NSEC_TIMER_INV		= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
	    PERF_TIMER_100NS + PERF_DELTA_COUNTER + PERF_INVERSE_COUNTER  +\
	    PERF_DISPLAY_PERCENT)

PERF_COUNTER_MULTI_TIMER	= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
	    PERF_DELTA_COUNTER + PERF_TIMER_TICK + PERF_MULTI_COUNTER +\
	    PERF_DISPLAY_PERCENT)

PERF_COUNTER_MULTI_TIMER_INV	= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_RATE +\
	    PERF_DELTA_COUNTER + PERF_MULTI_COUNTER + PERF_TIMER_TICK +\
	    PERF_INVERSE_COUNTER + PERF_DISPLAY_PERCENT)

PERF_COUNTER_MULTI_BASE 	= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_BASE +\
	    PERF_MULTI_COUNTER + PERF_DISPLAY_NOSHOW)

PERF_100NSEC_MULTI_TIMER	= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_DELTA_COUNTER  +\
	    PERF_COUNTER_RATE + PERF_TIMER_100NS + PERF_MULTI_COUNTER +\
	    PERF_DISPLAY_PERCENT)

PERF_100NSEC_MULTI_TIMER_INV	= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_DELTA_COUNTER  +\
	    PERF_COUNTER_RATE + PERF_TIMER_100NS + PERF_MULTI_COUNTER +\
	    PERF_INVERSE_COUNTER + PERF_DISPLAY_PERCENT)

PERF_RAW_FRACTION		= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_FRACTION +\
	    PERF_DISPLAY_PERCENT)

PERF_RAW_BASE			= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_BASE +\
	    PERF_DISPLAY_NOSHOW +\
	    000000003h)  ; for compatibility with pre-beta versions

PERF_ELAPSED_TIME		= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_ELAPSED +\
	    PERF_OBJECT_TIMER + PERF_DISPLAY_SECONDS)

PERF_COUNTER_HISTOGRAM_TYPE	= 080000000h

PERF_COUNTER_DELTA		= \
	    (PERF_SIZE_DWORD + PERF_TYPE_COUNTER + PERF_COUNTER_VALUE +\
	    PERF_DELTA_COUNTER + PERF_DISPLAY_NO_SUFFIX)

PERF_COUNTER_LARGE_DELTA	= \
	    (PERF_SIZE_LARGE + PERF_TYPE_COUNTER + PERF_COUNTER_VALUE +\
	    PERF_DELTA_COUNTER + PERF_DISPLAY_NO_SUFFIX)

PERF_DETAIL_NOVICE		= 100 ; The uninformed can understand it
PERF_DETAIL_ADVANCED		= 200 ; For the advanced user
PERF_DETAIL_EXPERT		= 300 ; For the expert user
PERF_DETAIL_WIZARD		= 400 ; For the system designer

struc	PERF_COUNTER_DEFINITION
	ByteLength		dd ?
	CounterNameTitleIndex	dd ?
	CounterNameTitle	dd ?
	CounterHelpTitleIndex	dd ?
	CounterHelpTitle	dd ?
	DefaultScale		dd ?
	DetailLevel		dd ?
	CounterType		dd ?
	CounterSize		dd ?
	CounterOffset		dd ?
ends

PERF_NO_UNIQUE_ID		= -1

struc	PERF_INSTANCE_DEFINITION
	ByteLength		dd ?
	ParentObjectTitleIndex	dd ?
	ParentObjectInstance	dd ?
	UniqueID		dd ?
	NameOffset		dd ?
	NameLength		dd ?
ends

struc	PERF_COUNTER_BLOCK
	ByteLength		dd ?
ends

;
; Support for New Extensible API starting with NT 5.0
;
PERF_QUERY_OBJECTS		= (080000000h)
PERF_QUERY_GLOBAL		= (080000001h)
PERF_QUERY_COSTLY		= (080000002h)
