;++ BUILD Version: 0001    // Increment this if a change has global effects
;
;Copyright (c) 1991-1998 Microsoft Corporation
;
;Module Name:
;
;    Winreg.h
;
;Abstract:
;
;    This module contains the function prototypes and constant, type and
;    structure definitions for the Windows 32-Bit Registry API.
;
;--

;
; Requested Key access mask type.
;

;
; Reserved Key Handles.
;

HKEY_CLASSES_ROOT		= 080000000h
HKEY_CURRENT_USER		= 080000001h
HKEY_LOCAL_MACHINE		= 080000002h
HKEY_USERS			= 080000003h
HKEY_PERFORMANCE_DATA		= 080000004h
HKEY_CURRENT_CONFIG		= 080000005h
HKEY_DYN_DATA			= 080000006h

PROVIDER_KEEPS_VALUE_LENGTH	= 01h

struc	PVALUE					; Provider supplied value/context.
	pv_valuename		dd ?		; The value name pointer
	pv_valuelen		dd ?
	pv_value_context	dd ?
	pv_type 		dd ?
ends

struc	REG_PROVIDER
	pi_R0_1val		dd ?
	pi_R0_allvals		dd ?
	pi_R3_1val		dd ?
	pi_R3_allvals		dd ?
	pi_flags		dd ?		; capability flags (none defined yet).
	pi_key_context		dd ?
ends

struc	VALENT
	ve_valuename		dd ?
	ve_valuelen		dd ?
	ve_valueptr		dd ?
	ve_type 		dd ?
ends

;
; Default values for parameters that do not exist in the Win 3.1
; compatible APIs.
;

WIN31_CLASS			= NULL

;
; API Prototypes.
;

procdesc RegCloseKey :dword
procdesc RegOverridePredefKey :dword, :dword
procdesc RegOpenUserClassesRoot :dword, :dword, :dword, :dword
procdesc RegConnectRegistryA :dword, :dword, :dword
procdesc RegCreateKeyA :dword, :dword, :dword
procdesc RegCreateKeyExA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc RegDeleteKeyA :dword, :dword
procdesc RegDeleteValueA :dword, :dword
procdesc RegEnumKeyA :dword, :dword, :dword, :dword
procdesc RegEnumKeyExA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc RegEnumValueA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc RegFlushKey :dword
procdesc RegGetKeySecurity :dword, :dword, :dword, :dword
procdesc RegLoadKeyA :dword, :dword, :dword
procdesc RegNotifyChangeKeyValue :dword, :dword, :dword, :dword, :dword
procdesc RegOpenKeyA :dword, :dword, :dword
procdesc RegOpenKeyExA :dword, :dword, :dword, :dword, :dword
procdesc RegQueryInfoKeyA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc RegQueryValueA :dword, :dword, :dword, :dword
procdesc RegQueryMultipleValuesA :dword, :dword, :dword, :dword, :dword
procdesc RegQueryValueExA :dword, :dword, :dword, :dword, :dword, :dword
procdesc RegReplaceKeyA :dword, :dword, :dword, :dword
procdesc RegRestoreKeyA :dword, :dword, :dword
procdesc RegSaveKeyA :dword, :dword, :dword
procdesc RegSetKeySecurity :dword, :dword, :dword
procdesc RegSetValueA :dword, :dword, :dword, :dword, :dword
procdesc RegSetValueExA :dword, :dword, :dword, :dword, :dword, :dword
procdesc RegUnLoadKeyA :dword, :dword

;
; Remoteable System Shutdown APIs
;

procdesc InitiateSystemShutdownA :dword, :dword, :dword, :dword, :dword
procdesc AbortSystemShutdownA :dword

RegConnectRegistry		equ <RegConnectRegistryA>
RegCreateKey			equ <RegCreateKeyA>
RegCreateKeyEx			equ <RegCreateKeyExA>
RegDeleteKey			equ <RegDeleteKeyA>
RegDeleteValue			equ <RegDeleteValueA>
RegEnumKey			equ <RegEnumKeyA>
RegEnumKeyEx			equ <RegEnumKeyExA>
RegEnumValue			equ <RegEnumValueA>
RegLoadKey			equ <RegLoadKeyA>
RegOpenKey			equ <RegOpenKeyA>
RegOpenKeyEx			equ <RegOpenKeyExA>
RegQueryInfoKey 		equ <RegQueryInfoKeyA>
RegQueryValue			equ <RegQueryValueA>
RegQueryMultipleValues		equ <RegQueryMultipleValuesA>
RegQueryValueEx 		equ <RegQueryValueExA>
RegReplaceKey			equ <RegReplaceKeyA>
RegRestoreKey			equ <RegRestoreKeyA>
RegSaveKey			equ <RegSaveKeyA>
RegSetValue			equ <RegSetValueA>
RegSetValueEx			equ <RegSetValueExA>
RegUnLoadKey			equ <RegUnLoadKeyA>
InitiateSystemShutdown		equ <InitiateSystemShutdownA>
AbortSystemShutdown		equ <AbortSystemShutdownA>
