;++
;
;Copyright (c) 1990-1998  Microsoft Corporation
;
;Module Name:
;
;    WinSpool.h
;
;Abstract:
;
;    Header file for Print APIs
;
;Revision History:
;
;--

struc	PRINTER_INFO_1
	Flags			dd ?
	pDescription		dd ?
	pName			dd ?
	pComment		dd ?
ends

struc	PRINTER_INFO_2
	pServerName		dd ?
	pPrinterName		dd ?
	pShareName		dd ?
	pPortName		dd ?
	pDriverName		dd ?
	pComment		dd ?
	pLocation		dd ?
	pDevMode		dd ?
	pSepFile		dd ?
	pPrintProcessor 	dd ?
	pDatatype		dd ?
	pParameters		dd ?
	pSecurityDescriptor	dd ?
	Attributes		dd ?
	Priority		dd ?
	DefaultPriority 	dd ?
	StartTime		dd ?
	UntilTime		dd ?
	Status			dd ?
	cJobs			dd ?
	AveragePPM		dd ?
ends

struc	PRINTER_INFO_3
	pSecurityDescriptor	dd ?
ends

struc	PRINTER_INFO_4
	pPrinterName		dd ?
	pServerName		dd ?
	Attributes		dd ?
ends

struc	PRINTER_INFO_5
	pPrinterName		dd ?
	pPortName		dd ?
	Attributes		dd ?
	DeviceNotSelectedTimeout dd ?
	TransmissionRetryTimeout dd ?
ends

struc	PRINTER_INFO_6
	dwStatus		dd ?
ends

struc	PRINTER_INFO_7
	pszObjectGUID		dd ?
	dwAction		dd ?
ends

DSPRINT_PUBLISH 		= 000000001h
DSPRINT_UPDATE			= 000000002h
DSPRINT_UNPUBLISH		= 000000004h
DSPRINT_PENDING 		= 080000000h

struc	PRINTER_INFO_8
	pDevMode		dd ?
ends

struc	PRINTER_INFO_9
	pDevMode		dd ?
ends

PRINTER_CONTROL_PAUSE		= 1
PRINTER_CONTROL_RESUME		= 2
PRINTER_CONTROL_PURGE		= 3
PRINTER_CONTROL_SET_STATUS	= 4

PRINTER_STATUS_PAUSED		= 000000001h
PRINTER_STATUS_ERROR		= 000000002h
PRINTER_STATUS_PENDING_DELETION = 000000004h
PRINTER_STATUS_PAPER_JAM	= 000000008h
PRINTER_STATUS_PAPER_OUT	= 000000010h
PRINTER_STATUS_MANUAL_FEED	= 000000020h
PRINTER_STATUS_PAPER_PROBLEM	= 000000040h
PRINTER_STATUS_OFFLINE		= 000000080h
PRINTER_STATUS_IO_ACTIVE	= 000000100h
PRINTER_STATUS_BUSY		= 000000200h
PRINTER_STATUS_PRINTING 	= 000000400h
PRINTER_STATUS_OUTPUT_BIN_FULL	= 000000800h
PRINTER_STATUS_NOT_AVAILABLE	= 000001000h
PRINTER_STATUS_WAITING		= 000002000h
PRINTER_STATUS_PROCESSING	= 000004000h
PRINTER_STATUS_INITIALIZING	= 000008000h
PRINTER_STATUS_WARMING_UP	= 000010000h
PRINTER_STATUS_TONER_LOW	= 000020000h
PRINTER_STATUS_NO_TONER 	= 000040000h
PRINTER_STATUS_PAGE_PUNT	= 000080000h
PRINTER_STATUS_USER_INTERVENTION = 000100000h
PRINTER_STATUS_OUT_OF_MEMORY	= 000200000h
PRINTER_STATUS_DOOR_OPEN	= 000400000h
PRINTER_STATUS_SERVER_UNKNOWN	= 000800000h
PRINTER_STATUS_POWER_SAVE	= 001000000h

PRINTER_ATTRIBUTE_QUEUED	= 000000001h
PRINTER_ATTRIBUTE_DIRECT	= 000000002h
PRINTER_ATTRIBUTE_DEFAULT	= 000000004h
PRINTER_ATTRIBUTE_SHARED	= 000000008h
PRINTER_ATTRIBUTE_NETWORK	= 000000010h
PRINTER_ATTRIBUTE_HIDDEN	= 000000020h
PRINTER_ATTRIBUTE_LOCAL 	= 000000040h

PRINTER_ATTRIBUTE_ENABLE_DEVQ	= 000000080h
PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS = 000000100h
PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST = 000000200h

PRINTER_ATTRIBUTE_WORK_OFFLINE	= 000000400h
PRINTER_ATTRIBUTE_ENABLE_BIDI	= 000000800h
PRINTER_ATTRIBUTE_RAW_ONLY	= 000001000h
PRINTER_ATTRIBUTE_PUBLISHED	= 000002000h

NO_PRIORITY			= 0
MAX_PRIORITY			= 99
MIN_PRIORITY			= 1
DEF_PRIORITY			= 1

struc	JOB_INFO_1
	JobId			dd ?
	pPrinterName		dd ?
	pMachineName		dd ?
	pUserName		dd ?
	pDocument		dd ?
	pDatatype		dd ?
	pStatus 		dd ?
	Status			dd ?
	Priority		dd ?
	Position		dd ?
	TotalPages		dd ?
	PagesPrinted		dd ?
	Submitted		SYSTEMTIME ?
ends

struc	JOB_INFO_2
	JobId			dd ?
	pPrinterName		dd ?
	pMachineName		dd ?
	pUserName		dd ?
	pDocument		dd ?
	pNotifyName		dd ?
	pDatatype		dd ?
	pPrintProcessor 	dd ?
	pParameters		dd ?
	pDriverName		dd ?
	pDevMode		dd ?
	pStatus 		dd ?
	pSecurityDescriptor	dd ?
	Status			dd ?
	Priority		dd ?
	Position		dd ?
	StartTime		dd ?
	UntilTime		dd ?
	TotalPages		dd ?
	Size			dd ?
	Submitted		SYSTEMTIME ?	; Time the job was spooled
	Time			dd ?		; How many seconds the job has been printing
	PagesPrinted		dd ?
ends

struc	JOB_INFO_3
	JobId			dd ?
	NextJobId		dd ?
	Reserved		dd ?
ends

JOB_CONTROL_PAUSE		= 1
JOB_CONTROL_RESUME		= 2
JOB_CONTROL_CANCEL		= 3
JOB_CONTROL_RESTART		= 4
JOB_CONTROL_DELETE		= 5
JOB_CONTROL_SENT_TO_PRINTER	= 6
JOB_CONTROL_LAST_PAGE_EJECTED	= 7

JOB_STATUS_PAUSED		= 000000001h
JOB_STATUS_ERROR		= 000000002h
JOB_STATUS_DELETING		= 000000004h
JOB_STATUS_SPOOLING		= 000000008h
JOB_STATUS_PRINTING		= 000000010h
JOB_STATUS_OFFLINE		= 000000020h
JOB_STATUS_PAPEROUT		= 000000040h
JOB_STATUS_PRINTED		= 000000080h
JOB_STATUS_DELETED		= 000000100h
JOB_STATUS_BLOCKED_DEVQ 	= 000000200h
JOB_STATUS_USER_INTERVENTION	= 000000400h
JOB_STATUS_RESTART		= 000000800h

JOB_POSITION_UNSPECIFIED	= 0

struc	ADDJOB_INFO_1
	Path			dd ?
	JobId			dd ?
ends

struc	DRIVER_INFO_1
	pName			dd ?		; QMS 810
ends

struc	DRIVER_INFO_2
	cVersion		dd ?
	pName			dd ?		; QMS 810
	pEnvironment		dd ?		; Win32 x86
	pDriverPath		dd ?		; c:\drivers\pscript.dll
	pDataFile		dd ?		; c:\drivers\QMS810.PPD
	pConfigFile		dd ?		; c:\drivers\PSCRPTUI.DLL
ends

struc	DRIVER_INFO_3
	cVersion		dd ?
	pName			dd ?		; QMS 810
	pEnvironment		dd ?		; Win32 x86
	pDriverPath		dd ?		; c:\drivers\pscript.dll
	pDataFile		dd ?		; c:\drivers\QMS810.PPD
	pConfigFile		dd ?		; c:\drivers\PSCRPTUI.DLL
	pHelpFile		dd ?		; c:\drivers\PSCRPTUI.HLP
	pDependentFiles 	dd ?		; PSCRIPT.DLL\0QMS810.PPD\0PSCRIPTUI.DLL\0PSCRIPTUI.HLP\0PSTEST.TXT\0\0
	pMonitorName		dd ?		; "PJL monitor"
	pDefaultDataType	dd ?		; "EMF"
ends

struc	DRIVER_INFO_4
	cVersion		dd ?
	pName			dd ?		; QMS 810
	pEnvironment		dd ?		; Win32 x86
	pDriverPath		dd ?		; c:\drivers\pscript.dll
	pDataFile		dd ?		; c:\drivers\QMS810.PPD
	pConfigFile		dd ?		; c:\drivers\PSCRPTUI.DLL
	pHelpFile		dd ?		; c:\drivers\PSCRPTUI.HLP
	pDependentFiles 	dd ?		; PSCRIPT.DLL\0QMS810.PPD\0PSCRIPTUI.DLL\0PSCRIPTUI.HLP\0PSTEST.TXT\0\0
	pMonitorName		dd ?		; "PJL monitor"
	pDefaultDataType	dd ?		; "EMF"
	pszzPreviousNames	dd ?		; "OldName1\0OldName2\0\0
ends

struc	DRIVER_INFO_5
	cVersion		dd ?
	pName			dd ?		; QMS 810
	pEnvironment		dd ?		; Win32 x86
	pDriverPath		dd ?		; c:\drivers\pscript.dll
	pDataFile		dd ?		; c:\drivers\QMS810.PPD
	pConfigFile		dd ?		; c:\drivers\PSCRPTUI.DLL
	dwDriverAttributes	dd ?		; driver attributes (like UMPD/KMPD)
	dwConfigVersion 	dd ?		; version number of the config file since reboot
	dwDriverVersion 	dd ?		; version number of the driver file since reboot
ends

; FLAGS for dwDriverAttributes
DRIVER_KERNELMODE		= 000000001h
DRIVER_USERMODE 		= 000000002h

; FLAGS for DeletePrinterDriverEx.
DPD_DELETE_UNUSED_FILES 	= 000000001h
DPD_DELETE_SPECIFIC_VERSION	= 000000002h
DPD_DELETE_ALL_FILES		= 000000004h

; FLAGS for AddPrinterDriverEx.
APD_STRICT_UPGRADE		= 000000001h
APD_STRICT_DOWNGRADE		= 000000002h
APD_COPY_ALL_FILES		= 000000004h
APD_COPY_NEW_FILES		= 000000008h

struc	DOC_INFO_1
	pDocName		dd ?
	pOutputFile		dd ?
	pDatatype		dd ?
ends

struc	FORM_INFO_1
	Flags			dd ?
	pName			dd ?
	Size			SIZEL ?
	ImageableArea		RECTL ?
ends

struc	DOC_INFO_2
	pDocName		dd ?
	pOutputFile		dd ?
	pDatatype		dd ?
	dwMode			dd ?
	JobId			dd ?
ends

DI_CHANNEL			= 1    ; start direct read/write channel,

DI_READ_SPOOL_JOB		= 3

struc	DOC_INFO_3
	pDocName		dd ?
	pOutputFile		dd ?
	pDatatype		dd ?
	dwFlags 		dd ?
ends

DI_MEMORYMAP_WRITE		= 000000001h

FORM_USER			= 000000000h
FORM_BUILTIN			= 000000001h
FORM_PRINTER			= 000000002h

struc	PRINTPROCESSOR_INFO_1
	pName			dd ?
ends

struc	PRINTPROCESSOR_CAPS_1
	dwLevel 		dd ?
	dwNupOptions		dd ?
	dwPageOrderFlags	dd ?
	dwNumberOfCopies	dd ?
ends

struc	PORT_INFO_1
	pName			dd ?
ends

struc	PORT_INFO_2
	pPortName		dd ?
	pMonitorName		dd ?
	pDescription		dd ?
	fPortType		dd ?
	Reserved		dd ?
ends

PORT_TYPE_WRITE 		= 00001h
PORT_TYPE_READ			= 00002h
PORT_TYPE_REDIRECTED		= 00004h
PORT_TYPE_NET_ATTACHED		= 00008h

struc	PORT_INFO_3
	dwStatus		dd ?
	pszStatus		dd ?
	dwSeverity		dd ?
ends

PORT_STATUS_TYPE_ERROR		= 1
PORT_STATUS_TYPE_WARNING	= 2
PORT_STATUS_TYPE_INFO		= 3

PORT_STATUS_OFFLINE		= 1
PORT_STATUS_PAPER_JAM		= 2
PORT_STATUS_PAPER_OUT		= 3
PORT_STATUS_OUTPUT_BIN_FULL	= 4
PORT_STATUS_PAPER_PROBLEM	= 5
PORT_STATUS_NO_TONER		= 6
PORT_STATUS_DOOR_OPEN		= 7
PORT_STATUS_USER_INTERVENTION	= 8
PORT_STATUS_OUT_OF_MEMORY	= 9

PORT_STATUS_TONER_LOW		= 10

PORT_STATUS_WARMING_UP		= 11
PORT_STATUS_POWER_SAVE		= 12

struc	MONITOR_INFO_1
	pName			dd ?
ends

struc	MONITOR_INFO_2
	pName			dd ?
	pEnvironment		dd ?
	pDLLName		dd ?
ends

struc	DATATYPES_INFO_1
	pName			dd ?
ends

struc	PRINTER_DEFAULTS
	pDatatype		dd ?
	pDevMode		dd ?
	DesiredAccess		dd ?
ends

struc	PRINTER_ENUM_VALUES
	pValueName		dd ?
	cbValueName		dd ?
	dwType			dd ?
	pData			dd ?
	cbData			dd ?
ends

procdesc EnumPrintersA :dword, :dword, :dword, :dword, :dword, :dword, :dword

EnumPrinters			equ <EnumPrintersA>

PRINTER_ENUM_DEFAULT		= 000000001h
PRINTER_ENUM_LOCAL		= 000000002h
PRINTER_ENUM_CONNECTIONS	= 000000004h
PRINTER_ENUM_FAVORITE		= 000000004h
PRINTER_ENUM_NAME		= 000000008h
PRINTER_ENUM_REMOTE		= 000000010h
PRINTER_ENUM_SHARED		= 000000020h
PRINTER_ENUM_NETWORK		= 000000040h

PRINTER_ENUM_EXPAND		= 000004000h
PRINTER_ENUM_CONTAINER		= 000008000h

PRINTER_ENUM_ICONMASK		= 000ff0000h
PRINTER_ENUM_ICON1		= 000010000h
PRINTER_ENUM_ICON2		= 000020000h
PRINTER_ENUM_ICON3		= 000040000h
PRINTER_ENUM_ICON4		= 000080000h
PRINTER_ENUM_ICON5		= 000100000h
PRINTER_ENUM_ICON6		= 000200000h
PRINTER_ENUM_ICON7		= 000400000h
PRINTER_ENUM_ICON8		= 000800000h

struc	SPOOL_FILE_INFO_1
	dwVersion		dd ?
	hSpoolFile		dd ?
	dwAttributes		dd ?
ends

SPOOL_FILE_PERSISTENT		= 000000001h
SPOOL_FILE_TEMPORARY		= 000000002h

procdesc GetSpoolFileHandle :dword
procdesc CommitSpoolData :dword, :dword, :dword
procdesc CloseSpoolFileHandle :dword, :dword
procdesc OpenPrinterA :dword, :dword, :dword
procdesc ResetPrinterA :dword, :dword
procdesc SetJobA :dword, :dword, :dword, :dword, :dword
procdesc GetJobA :dword, :dword, :dword, :dword, :dword, :dword
procdesc EnumJobsA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc AddPrinterA :dword, :dword, :dword
procdesc DeletePrinter :dword
procdesc SetPrinterA :dword, :dword, :dword, :dword
procdesc GetPrinterA :dword, :dword, :dword, :dword, :dword
procdesc AddPrinterDriverA :dword, :dword, :dword
procdesc AddPrinterDriverExA :dword, :dword, :dword, :dword
procdesc EnumPrinterDriversA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetPrinterDriverA :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetPrinterDriverDirectoryA :dword, :dword, :dword, :dword, :dword, :dword
procdesc DeletePrinterDriverA :dword, :dword, :dword
procdesc DeletePrinterDriverExA :dword, :dword, :dword, :dword, :dword
procdesc AddPerMachineConnectionA :dword, :dword, :dword, :dword
procdesc DeletePerMachineConnectionA :dword, :dword
procdesc EnumPerMachineConnectionsA :dword, :dword, :dword, :dword, :dword
procdesc AddPrintProcessorA :dword, :dword, :dword, :dword
procdesc EnumPrintProcessorsA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetPrintProcessorDirectoryA :dword, :dword, :dword, :dword, :dword, :dword
procdesc EnumPrintProcessorDatatypesA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc DeletePrintProcessorA :dword, :dword, :dword
procdesc StartDocPrinterA :dword, :dword, :dword
procdesc StartPagePrinter :dword
procdesc WritePrinter :dword, :dword, :dword, :dword
procdesc EndPagePrinter :dword
procdesc AbortPrinter :dword
procdesc ReadPrinter :dword, :dword, :dword, :dword
procdesc EndDocPrinter :dword
procdesc AddJobA :dword, :dword, :dword, :dword, :dword
procdesc ScheduleJob :dword, :dword
procdesc PrinterProperties :dword, :dword
procdesc DocumentPropertiesA :dword, :dword, :dword, :dword, :dword, :dword
procdesc AdvancedDocumentPropertiesA :dword, :dword, :dword, :dword, :dword
procdesc GetPrinterDataA :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetPrinterDataExA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc EnumPrinterDataA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc EnumPrinterDataExA :dword, :dword, :dword, :dword, :dword, :dword
procdesc EnumPrinterKeyA :dword, :dword, :dword, :dword, :dword
procdesc SetPrinterDataA :dword, :dword, :dword, :dword, :dword
procdesc SetPrinterDataExA :dword, :dword, :dword, :dword, :dword, :dword
procdesc DeletePrinterDataA :dword, :dword
procdesc DeletePrinterDataExA :dword, :dword, :dword
procdesc DeletePrinterKeyA :dword, :dword

OpenPrinter			equ <OpenPrinterA>
ResetPrinter			equ <ResetPrinterA>
SetJob				equ <SetJobA>
GetJob				equ <GetJobA>
EnumJobs			equ <EnumJobsA>
AddPrinter			equ <AddPrinterA>
SetPrinter			equ <SetPrinterA>
GetPrinter			equ <GetPrinterA>
AddPrinterDriver		equ <AddPrinterDriverA>
AddPrinterDriverEx		equ <AddPrinterDriverExA>
EnumPrinterDrivers		equ <EnumPrinterDriversA>
GetPrinterDriver		equ <GetPrinterDriverA>
GetPrinterDriverDirectory	equ <GetPrinterDriverDirectoryA>
DeletePrinterDriver		equ <DeletePrinterDriverA>
DeletePrinterDriverEx		equ <DeletePrinterDriverExA>
AddPerMachineConnection 	equ <AddPerMachineConnectionA>
DeletePerMachineConnection	equ <DeletePerMachineConnectionA>
EnumPerMachineConnections	equ <EnumPerMachineConnectionsA>
AddPrintProcessor		equ <AddPrintProcessorA>
EnumPrintProcessors		equ <EnumPrintProcessorsA>
GetPrintProcessorDirectory	equ <GetPrintProcessorDirectoryA>
EnumPrintProcessorDatatypes	equ <EnumPrintProcessorDatatypesA>
DeletePrintProcessor		equ <DeletePrintProcessorA>
StartDocPrinter 		equ <StartDocPrinterA>
AddJob				equ <AddJobA>
DocumentProperties		equ <DocumentPropertiesA>
AdvancedDocumentProperties	equ <AdvancedDocumentPropertiesA>
GetPrinterData			equ <GetPrinterDataA>
GetPrinterDataEx		equ <GetPrinterDataExA>
EnumPrinterData 		equ <EnumPrinterDataA>
EnumPrinterDataEx		equ <EnumPrinterDataExA>
EnumPrinterKey			equ <EnumPrinterKeyA>
SetPrinterData			equ <SetPrinterDataA>
SetPrinterDataEx		equ <SetPrinterDataExA>
DeletePrinterData		equ <DeletePrinterDataA>
DeletePrinterDataEx		equ <DeletePrinterDataExA>
DeletePrinterKey		equ <DeletePrinterKeyA>

PRINTER_NOTIFY_TYPE		= 000h
JOB_NOTIFY_TYPE 		= 001h

PRINTER_NOTIFY_FIELD_SERVER_NAME = 000h
PRINTER_NOTIFY_FIELD_PRINTER_NAME = 001h
PRINTER_NOTIFY_FIELD_SHARE_NAME = 002h
PRINTER_NOTIFY_FIELD_PORT_NAME	= 003h
PRINTER_NOTIFY_FIELD_DRIVER_NAME = 004h
PRINTER_NOTIFY_FIELD_COMMENT	= 005h
PRINTER_NOTIFY_FIELD_LOCATION	= 006h
PRINTER_NOTIFY_FIELD_DEVMODE	= 007h
PRINTER_NOTIFY_FIELD_SEPFILE	= 008h
PRINTER_NOTIFY_FIELD_PRINT_PROCESSOR = 009h
PRINTER_NOTIFY_FIELD_PARAMETERS = 00Ah
PRINTER_NOTIFY_FIELD_DATATYPE	= 00Bh
PRINTER_NOTIFY_FIELD_SECURITY_DESCRIPTOR = 00Ch
PRINTER_NOTIFY_FIELD_ATTRIBUTES = 00Dh
PRINTER_NOTIFY_FIELD_PRIORITY	= 00Eh
PRINTER_NOTIFY_FIELD_DEFAULT_PRIORITY = 00Fh
PRINTER_NOTIFY_FIELD_START_TIME = 010h
PRINTER_NOTIFY_FIELD_UNTIL_TIME = 011h
PRINTER_NOTIFY_FIELD_STATUS	= 012h
PRINTER_NOTIFY_FIELD_STATUS_STRING = 013h
PRINTER_NOTIFY_FIELD_CJOBS	= 014h
PRINTER_NOTIFY_FIELD_AVERAGE_PPM = 015h
PRINTER_NOTIFY_FIELD_TOTAL_PAGES = 016h
PRINTER_NOTIFY_FIELD_PAGES_PRINTED = 017h
PRINTER_NOTIFY_FIELD_TOTAL_BYTES = 018h
PRINTER_NOTIFY_FIELD_BYTES_PRINTED = 019h
PRINTER_NOTIFY_FIELD_OBJECT_GUID = 01Ah

JOB_NOTIFY_FIELD_PRINTER_NAME	= 000h
JOB_NOTIFY_FIELD_MACHINE_NAME	= 001h
JOB_NOTIFY_FIELD_PORT_NAME	= 002h
JOB_NOTIFY_FIELD_USER_NAME	= 003h
JOB_NOTIFY_FIELD_NOTIFY_NAME	= 004h
JOB_NOTIFY_FIELD_DATATYPE	= 005h
JOB_NOTIFY_FIELD_PRINT_PROCESSOR = 006h
JOB_NOTIFY_FIELD_PARAMETERS	= 007h
JOB_NOTIFY_FIELD_DRIVER_NAME	= 008h
JOB_NOTIFY_FIELD_DEVMODE	= 009h
JOB_NOTIFY_FIELD_STATUS 	= 00Ah
JOB_NOTIFY_FIELD_STATUS_STRING	= 00Bh
JOB_NOTIFY_FIELD_SECURITY_DESCRIPTOR = 00Ch
JOB_NOTIFY_FIELD_DOCUMENT	= 00Dh
JOB_NOTIFY_FIELD_PRIORITY	= 00Eh
JOB_NOTIFY_FIELD_POSITION	= 00Fh
JOB_NOTIFY_FIELD_SUBMITTED	= 010h
JOB_NOTIFY_FIELD_START_TIME	= 011h
JOB_NOTIFY_FIELD_UNTIL_TIME	= 012h
JOB_NOTIFY_FIELD_TIME		= 013h
JOB_NOTIFY_FIELD_TOTAL_PAGES	= 014h
JOB_NOTIFY_FIELD_PAGES_PRINTED	= 015h
JOB_NOTIFY_FIELD_TOTAL_BYTES	= 016h
JOB_NOTIFY_FIELD_BYTES_PRINTED	= 017h

struc	PRINTER_NOTIFY_OPTIONS_TYPE
	Type			dw ?
	Reserved0		dw ?
	Reserved1		dd ?
	Reserved2		dd ?
	Count			dd ?
	pFields 		dd ?
ends

PRINTER_NOTIFY_OPTIONS_REFRESH	= 001h

struc	PRINTER_NOTIFY_OPTIONS
	_Version		dd ?
	Flags			dd ?
	Count			dd ?
	pTypes			dd ?
ends


PRINTER_NOTIFY_INFO_DISCARDED	= 001h

struc	PRINTER_NOTIFY_INFO_DATA
	Type			dw ?
	Field			dw ?
	Reserved		dd ?
	Id			dd ?
label	adwData 		dword
	cbBuf			dd ?
	pBuf			dd ?
ends

struc	PRINTER_NOTIFY_INFO
	_Version		dd ?
	Flags			dd ?
	Count			dd ?
label	aData			PRINTER_NOTIFY_INFO_DATA
ends

procdesc WaitForPrinterChange :dword, :dword
procdesc FindFirstPrinterChangeNotification :dword, :dword, :dword, :dword
procdesc FindNextPrinterChangeNotification :dword, :dword, :dword, :dword
procdesc FreePrinterNotifyInfo :dword
procdesc FindClosePrinterChangeNotification :dword

PRINTER_CHANGE_ADD_PRINTER	= 000000001h
PRINTER_CHANGE_SET_PRINTER	= 000000002h
PRINTER_CHANGE_DELETE_PRINTER	= 000000004h
PRINTER_CHANGE_FAILED_CONNECTION_PRINTER = 000000008h
PRINTER_CHANGE_PRINTER		= 0000000FFh
PRINTER_CHANGE_ADD_JOB		= 000000100h
PRINTER_CHANGE_SET_JOB		= 000000200h
PRINTER_CHANGE_DELETE_JOB	= 000000400h
PRINTER_CHANGE_WRITE_JOB	= 000000800h
PRINTER_CHANGE_JOB		= 00000FF00h
PRINTER_CHANGE_ADD_FORM 	= 000010000h
PRINTER_CHANGE_SET_FORM 	= 000020000h
PRINTER_CHANGE_DELETE_FORM	= 000040000h
PRINTER_CHANGE_FORM		= 000070000h
PRINTER_CHANGE_ADD_PORT 	= 000100000h
PRINTER_CHANGE_CONFIGURE_PORT	= 000200000h
PRINTER_CHANGE_DELETE_PORT	= 000400000h
PRINTER_CHANGE_PORT		= 000700000h
PRINTER_CHANGE_ADD_PRINT_PROCESSOR = 001000000h
PRINTER_CHANGE_DELETE_PRINT_PROCESSOR = 004000000h
PRINTER_CHANGE_PRINT_PROCESSOR	= 007000000h
PRINTER_CHANGE_ADD_PRINTER_DRIVER = 010000000h
PRINTER_CHANGE_SET_PRINTER_DRIVER = 020000000h
PRINTER_CHANGE_DELETE_PRINTER_DRIVER = 040000000h
PRINTER_CHANGE_PRINTER_DRIVER	= 070000000h
PRINTER_CHANGE_TIMEOUT		= 080000000h
PRINTER_CHANGE_ALL		= 07777FFFFh

procdesc PrinterMessageBoxA :dword, :dword, :dword, :dword, :dword, :dword

PrinterMessageBox		equ <PrinterMessageBoxA>

PRINTER_ERROR_INFORMATION	= 080000000h
PRINTER_ERROR_WARNING		= 040000000h
PRINTER_ERROR_SEVERE		= 020000000h

PRINTER_ERROR_OUTOFPAPER	= 000000001h
PRINTER_ERROR_JAM		= 000000002h
PRINTER_ERROR_OUTOFTONER	= 000000004h

procdesc ClosePrinter :dword
procdesc AddFormA :dword, :dword, :dword
procdesc DeleteFormA :dword, :dword
procdesc GetFormA :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetFormA :dword, :dword, :dword, :dword
procdesc EnumFormsA :dword, :dword, :dword, :dword, :dword, :dword
procdesc EnumMonitorsA :dword, :dword, :dword, :dword, :dword, :dword
procdesc AddMonitorA :dword, :dword, :dword
procdesc DeleteMonitorA :dword, :dword, :dword
procdesc EnumPortsA :dword, :dword, :dword, :dword, :dword, :dword
procdesc AddPortA :dword, :dword, :dword
procdesc ConfigurePortA :dword, :dword, :dword
procdesc DeletePortA :dword, :dword, :dword
procdesc XcvDataW :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetPortA :dword, :dword, :dword, :dword
procdesc AddPrinterConnectionA :dword
procdesc DeletePrinterConnectionA :dword
procdesc ConnectToPrinterDlg :dword, :dword

AddForm 			equ <AddFormA>
DeleteForm			equ <DeleteFormA>
GetForm 			equ <GetFormA>
SetForm 			equ <SetFormA>
EnumForms			equ <EnumFormsA>
EnumMonitors			equ <EnumMonitorsA>
AddMonitor			equ <AddMonitorA>
DeleteMonitor			equ <DeleteMonitorA>
EnumPorts			equ <EnumPortsA>
AddPort 			equ <AddPortA>
ConfigurePort			equ <ConfigurePortA>
DeletePort			equ <DeletePortA>
XcvData 			equ <XcvDataW>
SetPort 			equ <SetPortA>
AddPrinterConnection		equ <AddPrinterConnectionA>
DeletePrinterConnection 	equ <DeletePrinterConnectionA>

struc	PROVIDOR_INFO_1
	pName			dd ?
	pEnvironment		dd ?
	pDLLName		dd ?
ends

struc	PROVIDOR_INFO_2
	pOrder			dd ?
ends

procdesc AddPrintProvidorA :dword, :dword, :dword
procdesc DeletePrintProvidorA :dword, :dword, :dword

AddPrintProvidor		equ <AddPrintProvidorA>
DeletePrintProvidor		equ <DeletePrintProvidorA>

;
; SetPrinterData and GetPrinterData Server Handle Key values
;

SPLREG_DEFAULT_SPOOL_DIRECTORY	equ <'DefaultSpoolDirectory', 0>
SPLREG_PORT_THREAD_PRIORITY_DEFAULT equ <'PortThreadPriorityDefault', 0>
SPLREG_PORT_THREAD_PRIORITY	equ <'PortThreadPriority', 0>
SPLREG_SCHEDULER_THREAD_PRIORITY_DEFAULT equ <'SchedulerThreadPriorityDefault', 0>
SPLREG_SCHEDULER_THREAD_PRIORITY equ <'SchedulerThreadPriority', 0>
SPLREG_BEEP_ENABLED		equ <'BeepEnabled', 0>
SPLREG_NET_POPUP		equ <'NetPopup', 0>
SPLREG_RETRY_POPUP		equ <'RetryPopup', 0>
SPLREG_NET_POPUP_TO_COMPUTER	equ <'NetPopupToComputer', 0>
SPLREG_EVENT_LOG		equ <'EventLog', 0>
SPLREG_MAJOR_VERSION		equ <'MajorVersion', 0>
SPLREG_MINOR_VERSION		equ <'MinorVersion', 0>
SPLREG_ARCHITECTURE		equ <'Architecture', 0>
SPLREG_OS_VERSION		equ <'OSVersion', 0>
SPLREG_DS_PRESENT		equ <'DsPresent', 0>
SPLREG_DS_PRESENT_FOR_USER	equ <'DsPresentForUser', 0>
SPLREG_REMOTE_FAX		equ <'RemoteFax', 0>

SERVER_ACCESS_ADMINISTER	= 000000001h
SERVER_ACCESS_ENUMERATE 	= 000000002h

PRINTER_ACCESS_ADMINISTER	= 000000004h
PRINTER_ACCESS_USE		= 000000008h

JOB_ACCESS_ADMINISTER		= 000000010h

;
; Access rights for print servers
;

SERVER_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED	 +\
			      SERVER_ACCESS_ADMINISTER	    +\
			      SERVER_ACCESS_ENUMERATE)

SERVER_READ			= (STANDARD_RIGHTS_READ 	 +\
			      SERVER_ACCESS_ENUMERATE)

SERVER_WRITE			= (STANDARD_RIGHTS_WRITE	 +\
			      SERVER_ACCESS_ADMINISTER	    +\
			      SERVER_ACCESS_ENUMERATE)

SERVER_EXECUTE			= (STANDARD_RIGHTS_EXECUTE	 +\
			      SERVER_ACCESS_ENUMERATE)

;
; Access rights for printers
;

PRINTER_ALL_ACCESS		= (STANDARD_RIGHTS_REQUIRED	+\
			       PRINTER_ACCESS_ADMINISTER    +\
			       PRINTER_ACCESS_USE)

PRINTER_READ			= (STANDARD_RIGHTS_READ 	+\
			       PRINTER_ACCESS_USE)

PRINTER_WRITE			= (STANDARD_RIGHTS_WRITE	+\
			       PRINTER_ACCESS_USE)

PRINTER_EXECUTE 		= (STANDARD_RIGHTS_EXECUTE	+\
			       PRINTER_ACCESS_USE)

;
; Access rights for jobs
;

JOB_ALL_ACCESS			= (STANDARD_RIGHTS_REQUIRED    +\
				JOB_ACCESS_ADMINISTER)

JOB_READ			= (STANDARD_RIGHTS_READ        +\
				JOB_ACCESS_ADMINISTER)

JOB_WRITE			= (STANDARD_RIGHTS_WRITE       +\
				JOB_ACCESS_ADMINISTER)

JOB_EXECUTE			= (STANDARD_RIGHTS_EXECUTE     +\
				JOB_ACCESS_ADMINISTER)


;
; DS Print-Queue property tables
;

; Predefined Registry Keys used by Set/GetPrinterDataEx
SPLDS_SPOOLER_KEY		equ <'DsSpooler', 0>
SPLDS_DRIVER_KEY		equ <'DsDriver', 0>
SPLDS_USER_KEY			equ <'DsUser', 0>

; DS Print-Queue properties

SPLDS_ASSET_NUMBER		equ <'assetNumber', 0>
SPLDS_BYTES_PER_MINUTE		equ <'bytesPerMinute', 0>
SPLDS_DESCRIPTION		equ <'description', 0>
SPLDS_DRIVER_NAME		equ <'driverName', 0>
SPLDS_DRIVER_VERSION		equ <'driverVersion', 0>
SPLDS_LOCATION			equ <'location', 0>
SPLDS_PORT_NAME 		equ <'portName', 0>
SPLDS_PRINT_ATTRIBUTES		equ <'printAttributes', 0>
SPLDS_PRINT_BIN_NAMES		equ <'printBinNames', 0>
SPLDS_PRINT_COLLATE		equ <'printCollate', 0>
SPLDS_PRINT_COLOR		equ <'printColor', 0>
SPLDS_PRINT_DUPLEX_SUPPORTED	equ <'printDuplexSupported', 0>
SPLDS_PRINT_END_TIME		equ <'printEndTime', 0>
SPLDS_PRINTER_CLASS		equ <'printQueue', 0>
SPLDS_PRINTER_NAME		equ <'printerName', 0>
SPLDS_PRINT_KEEP_PRINTED_JOBS	equ <'printKeepPrintedJobs', 0>
SPLDS_PRINT_LANGUAGE		equ <'printLanguage', 0>
SPLDS_PRINT_MAC_ADDRESS 	equ <'printMACAddress', 0>
SPLDS_PRINT_MAX_X_EXTENT	equ <'printMaxXExtent', 0>
SPLDS_PRINT_MAX_Y_EXTENT	equ <'printMaxYExtent', 0>
SPLDS_PRINT_MAX_RESOLUTION_SUPPORTED equ <'printMaxResolutionSupported', 0>
SPLDS_PRINT_MEDIA_READY 	equ <'printMediaReady', 0>
SPLDS_PRINT_MEDIA_SUPPORTED	equ <'printMediaSupported', 0>
SPLDS_PRINT_MEMORY		equ <'printMemory', 0>
SPLDS_PRINT_MIN_X_EXTENT	equ <'printMinXExtent', 0>
SPLDS_PRINT_MIN_Y_EXTENT	equ <'printMinYExtent', 0>
SPLDS_PRINT_NETWORK_ADDRESS	equ <'printNetworkAddress', 0>
SPLDS_PRINT_NOTIFY		equ <'printNotify', 0>
SPLDS_PRINT_NUMBER_UP		equ <'printNumberUp', 0>
SPLDS_PRINT_ORIENTATIONS_SUPPORTED equ <'printOrientationsSupported', 0>
SPLDS_PRINT_OWNER		equ <'printOwner', 0>
SPLDS_PRINT_PAGES_PER_MINUTE	equ <'printPagesPerMinute', 0>
SPLDS_PRINT_RATE		equ <'printRate', 0>
SPLDS_PRINT_RATE_UNIT		equ <'printRateUnit', 0>
SPLDS_PRINT_SEPARATOR_FILE	equ <'printSeparatorFile', 0>
SPLDS_PRINT_SHARE_NAME		equ <'printShareName', 0>
SPLDS_PRINT_SPOOLING		equ <'printSpooling', 0>
SPLDS_PRINT_STAPLING_SUPPORTED	equ <'printStaplingSupported', 0>
SPLDS_PRINT_START_TIME		equ <'printStartTime', 0>
SPLDS_PRINT_STATUS		equ <'printStatus', 0>
SPLDS_PRIORITY			equ <'priority', 0>
SPLDS_SERVER_NAME		equ <'serverName', 0>
SPLDS_SHORT_SERVER_NAME 	equ <'shortServerName', 0>
SPLDS_UNC_NAME			equ <'uNCName', 0>
SPLDS_URL			equ <'url', 0>
SPLDS_VERSION_NUMBER		equ <'versionNumber', 0>

;
;    -- Additional Print-Queue properties --
;
;    These properties are not defined in the default Directory Services Schema,
;    but should be used when extending the Schema so a consistent interface is maintained.
;
;

SPLDS_PRINTER_NAME_ALIASES	equ <'printerNameAliases', 0>	   ; MULTI_SZ
SPLDS_PRINTER_LOCATIONS 	equ <'printerLocations', 0>	   ; MULTI_SZ
SPLDS_PRINTER_MODEL		equ <'printerModel', 0> 	   ; SZ
