;***************************************************************************
;*									     *
;* winuser.h -- USER procedure declarations, constant definitions and macros *
;*									     *
;* Copyright (c) 1985-1998, Microsoft Corp. All rights reserved.	     *
;*									     *
;***************************************************************************

proctype WNDPROC :dword, :dword, :dword, :dword
proctype DLGPROC :dword, :dword, :dword, :dword
proctype TIMERPROC :dword, :dword, :dword, :dword
proctype GRAYSTRINGPROC :dword, :dword, :dword
proctype WNDENUMPROC :dword, :dword
proctype HOOKPROC :dword, :dword, :dword
proctype SENDASYNCPROC :dword, :dword, :dword, :dword
proctype PROPENUMPROC :dword, :dword, :dword
proctype PROPENUMPROCEX :dword, :dword, :dword, :dword
proctype EDITWORDBREAKPROC :dword, :dword, :dword, :dword
proctype DRAWSTATEPROC :dword, :dword, :dword, :dword, :dword
proctype NAMEENUMPROC :dword, :dword

;
; Predefined Resource Types
;
RT_CURSOR			= 1
RT_BITMAP			= 2
RT_ICON 			= 3
RT_MENU 			= 4
RT_DIALOG			= 5
RT_STRING			= 6
RT_FONTDIR			= 7
RT_FONT 			= 8
RT_ACCELERATOR			= 9
RT_RCDATA			= 10
RT_MESSAGETABLE 		= 11

DIFFERENCE			= 11
RT_GROUP_CURSOR 		= RT_CURSOR + DIFFERENCE
RT_GROUP_ICON			= RT_ICON + DIFFERENCE
RT_VERSION			= 16
RT_DLGINCLUDE			= 17
RT_PLUGPLAY			= 19
RT_VXD				= 20
RT_ANICURSOR			= 21
RT_ANIICON			= 22
RT_HTML 			= 23

procdesc wvsprintfA :dword, :dword, :dword
procdesc wsprintfA c :dword, :dword, :dword:?

wvsprintf			equ <wvsprintfA>
wsprintf			equ <wsprintfA>

;
; Scroll Bar Constants
;
SB_HORZ 			= 0
SB_VERT 			= 1
SB_CTL				= 2
SB_BOTH 			= 3

;
; Scroll Bar Commands
;
SB_LINEUP			= 0
SB_LINELEFT			= 0
SB_LINEDOWN			= 1
SB_LINERIGHT			= 1
SB_PAGEUP			= 2
SB_PAGELEFT			= 2
SB_PAGEDOWN			= 3
SB_PAGERIGHT			= 3
SB_THUMBPOSITION		= 4
SB_THUMBTRACK			= 5
SB_TOP				= 6
SB_LEFT 			= 6
SB_BOTTOM			= 7
SB_RIGHT			= 7
SB_ENDSCROLL			= 8

;
; ShowWindow() Commands
;
SW_HIDE 			= 0
SW_SHOWNORMAL			= 1
SW_NORMAL			= 1
SW_SHOWMINIMIZED		= 2
SW_SHOWMAXIMIZED		= 3
SW_MAXIMIZE			= 3
SW_SHOWNOACTIVATE		= 4
SW_SHOW 			= 5
SW_MINIMIZE			= 6
SW_SHOWMINNOACTIVE		= 7
SW_SHOWNA			= 8
SW_RESTORE			= 9
SW_SHOWDEFAULT			= 10
SW_FORCEMINIMIZE		= 11
SW_MAX				= 11

;
; Old ShowWindow() Commands
;
HIDE_WINDOW			= 0
SHOW_OPENWINDOW 		= 1
SHOW_ICONWINDOW 		= 2
SHOW_FULLSCREEN 		= 3
SHOW_OPENNOACTIVATE		= 4

;
; Identifiers for the WM_SHOWWINDOW message
;
SW_PARENTCLOSING		= 1
SW_OTHERZOOM			= 2
SW_PARENTOPENING		= 3
SW_OTHERUNZOOM			= 4

;
; AnimateWindow() Commands
;
AW_HOR_POSITIVE 		= 000000001h
AW_HOR_NEGATIVE 		= 000000002h
AW_VER_POSITIVE 		= 000000004h
AW_VER_NEGATIVE 		= 000000008h
AW_CENTER			= 000000010h
AW_HIDE 			= 000010000h
AW_ACTIVATE			= 000020000h
AW_SLIDE			= 000040000h
AW_BLEND			= 000080000h

;
; WM_KEYUP/DOWN/CHAR HIWORD(lParam) flags
;
KF_EXTENDED			= 00100h
KF_DLGMODE			= 00800h
KF_MENUMODE			= 01000h
KF_ALTDOWN			= 02000h
KF_REPEAT			= 04000h
KF_UP				= 08000h

;
; Virtual Keys, Standard Set
;
VK_LBUTTON			= 001h
VK_RBUTTON			= 002h
VK_CANCEL			= 003h
VK_MBUTTON			= 004h	  ; NOT contiguous with L & RBUTTON

VK_BACK 			= 008h
VK_TAB				= 009h

VK_CLEAR			= 00Ch
VK_RETURN			= 00Dh

VK_SHIFT			= 010h
VK_CONTROL			= 011h
VK_MENU 			= 012h
VK_PAUSE			= 013h
VK_CAPITAL			= 014h

VK_KANA 			= 015h
VK_HANGEUL			= 015h	; old name - should be here for compatibility
VK_HANGUL			= 015h
VK_JUNJA			= 017h
VK_FINAL			= 018h
VK_HANJA			= 019h
VK_KANJI			= 019h

VK_ESCAPE			= 01Bh

VK_CONVERT			= 01Ch
VK_NONCONVERT			= 01Dh
VK_ACCEPT			= 01Eh
VK_MODECHANGE			= 01Fh

VK_SPACE			= 020h
VK_PRIOR			= 021h
VK_NEXT 			= 022h
VK_END				= 023h
VK_HOME 			= 024h
VK_LEFT 			= 025h
VK_UP				= 026h
VK_RIGHT			= 027h
VK_DOWN 			= 028h
VK_SELECT			= 029h
VK_PRINT			= 02Ah
VK_EXECUTE			= 02Bh
VK_SNAPSHOT			= 02Ch
VK_INSERT			= 02Dh
VK_DELETE			= 02Eh
VK_HELP 			= 02Fh

; VK_0 thru VK_9 are the same as ASCII '0' thru '9' (0x30 - 0x39)
; VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A)

VK_LWIN 			= 05Bh
VK_RWIN 			= 05Ch
VK_APPS 			= 05Dh

VK_NUMPAD0			= 060h
VK_NUMPAD1			= 061h
VK_NUMPAD2			= 062h
VK_NUMPAD3			= 063h
VK_NUMPAD4			= 064h
VK_NUMPAD5			= 065h
VK_NUMPAD6			= 066h
VK_NUMPAD7			= 067h
VK_NUMPAD8			= 068h
VK_NUMPAD9			= 069h
VK_MULTIPLY			= 06Ah
VK_ADD				= 06Bh
VK_SEPARATOR			= 06Ch
VK_SUBTRACT			= 06Dh
VK_DECIMAL			= 06Eh
VK_DIVIDE			= 06Fh
VK_F1				= 070h
VK_F2				= 071h
VK_F3				= 072h
VK_F4				= 073h
VK_F5				= 074h
VK_F6				= 075h
VK_F7				= 076h
VK_F8				= 077h
VK_F9				= 078h
VK_F10				= 079h
VK_F11				= 07Ah
VK_F12				= 07Bh
VK_F13				= 07Ch
VK_F14				= 07Dh
VK_F15				= 07Eh
VK_F16				= 07Fh
VK_F17				= 080h
VK_F18				= 081h
VK_F19				= 082h
VK_F20				= 083h
VK_F21				= 084h
VK_F22				= 085h
VK_F23				= 086h
VK_F24				= 087h

VK_NUMLOCK			= 090h
VK_SCROLL			= 091h

;
; VK_L* & VK_R* - left and right Alt, Ctrl and Shift virtual keys.
; Used only as parameters to GetAsyncKeyState() and GetKeyState().
; No other API or message will distinguish left and right keys in this way.
;
VK_LSHIFT			= 0A0h
VK_RSHIFT			= 0A1h
VK_LCONTROL			= 0A2h
VK_RCONTROL			= 0A3h
VK_LMENU			= 0A4h
VK_RMENU			= 0A5h

VK_PROCESSKEY			= 0E5h

VK_ATTN 			= 0F6h
VK_CRSEL			= 0F7h
VK_EXSEL			= 0F8h
VK_EREOF			= 0F9h
VK_PLAY 			= 0FAh
VK_ZOOM 			= 0FBh
VK_NONAME			= 0FCh
VK_PA1				= 0FDh
VK_OEM_CLEAR			= 0FEh


;
; SetWindowsHook() codes
;
WH_MIN				= (-1)
WH_MSGFILTER			= (-1)
WH_JOURNALRECORD		= 0
WH_JOURNALPLAYBACK		= 1
WH_KEYBOARD			= 2
WH_GETMESSAGE			= 3
WH_CALLWNDPROC			= 4
WH_CBT				= 5
WH_SYSMSGFILTER 		= 6
WH_MOUSE			= 7
WH_HARDWARE			= 8
WH_DEBUG			= 9
WH_SHELL			= 10
WH_FOREGROUNDIDLE		= 11
WH_CALLWNDPROCRET		= 12

WH_KEYBOARD_LL			= 13
WH_MOUSE_LL			= 14

WH_MAX				= 14

WH_MINHOOK			= WH_MIN
WH_MAXHOOK			= WH_MAX

;
; Hook Codes
;
HC_ACTION			= 0
HC_GETNEXT			= 1
HC_SKIP 			= 2
HC_NOREMOVE			= 3
HC_NOREM			= HC_NOREMOVE
HC_SYSMODALON			= 4
HC_SYSMODALOFF			= 5

;
; CBT Hook Codes
;
HCBT_MOVESIZE			= 0
HCBT_MINMAX			= 1
HCBT_QS 			= 2
HCBT_CREATEWND			= 3
HCBT_DESTROYWND 		= 4
HCBT_ACTIVATE			= 5
HCBT_CLICKSKIPPED		= 6
HCBT_KEYSKIPPED 		= 7
HCBT_SYSCOMMAND 		= 8
HCBT_SETFOCUS			= 9

;
; HCBT_CREATEWND parameters pointed to by lParam
;

struc	CBT_CREATEWNDA
	lpcs			dd ?
	hwndInsertAfter 	dd ?
ends

;
; HCBT_ACTIVATE structure pointed to by lParam
;

struc	CBTACTIVATESTRUCT
	fMouse			dd ?
	hWndActive		dd ?
ends

;
; WH_MSGFILTER Filter Proc Codes
;
MSGF_DIALOGBOX			= 0
MSGF_MESSAGEBOX 		= 1
MSGF_MENU			= 2
MSGF_SCROLLBAR			= 5
MSGF_NEXTWINDOW 		= 6
MSGF_MAX			= 8			  ; unused
MSGF_USER			= 4096

;
; Shell support
;
HSHELL_WINDOWCREATED		= 1
HSHELL_WINDOWDESTROYED		= 2
HSHELL_ACTIVATESHELLWINDOW	= 3

HSHELL_WINDOWACTIVATED		= 4
HSHELL_GETMINRECT		= 5
HSHELL_REDRAW			= 6
HSHELL_TASKMAN			= 7
HSHELL_LANGUAGE 		= 8
HSHELL_ACCESSIBILITYSTATE	= 11
ACCESS_STICKYKEYS		= 00001h
ACCESS_FILTERKEYS		= 00002h
ACCESS_MOUSEKEYS		= 00003h

;
; Message Structure used in Journaling
;

struc	EVENTMSG
	message 		dd ?
	paramL			dd ?
	paramH			dd ?
	time			dd ?
	hwnd			dd ?
ends

;
; Message structure used by WH_CALLWNDPROC
;

struc	CWPSTRUCT
	lParam			dd ?
	wParam			dd ?
	message 		dd ?
	hwnd			dd ?
ends

;
; Message structure used by WH_CALLWNDPROCRET
;

struc	CWPRETSTRUCT
	lResult 		dd ?
	lParam			dd ?
	wParam			dd ?
	message 		dd ?
	hwnd			dd ?
ends

;
; Low level hook flags
;

LLKHF_EXTENDED			= (KF_EXTENDED shr 8)
LLKHF_INJECTED			= 000000010h
LLKHF_ALTDOWN			= (KF_ALTDOWN shr 8)
LLKHF_UP			= (KF_UP shr 8)

LLMHF_INJECTED			= 000000001h

;
; Structure used by WH_KEYBOARD_LL
;

struc	KBDLLHOOKSTRUCT
	vkCode			dd ?
	scanCode		dd ?
	flags			dd ?
	time			dd ?
	dwExtraInfo		dd ?
ends


;
; Structure used by WH_MOUSE_LL
;

struc	MSLLHOOKSTRUCT
	pt			POINT ?
	mouseData		dd ?
	flags			dd ?
	time			dd ?
	dwExtraInfo		dd ?
ends

;
; Structure used by WH_DEBUG
;

struc	DEBUGHOOKINFO
	idThread		dd ?
	idThreadInstaller	dd ?
	lParam			dd ?
	wParam			dd ?
	code			dd ?
ends

;
; Structure used by WH_MOUSE
;

struc	MOUSEHOOKSTRUCT
	pt			POINT ?
	hwnd			dd ?
	wHitTestCode		dd ?
	dwExtraInfo		dd ?
ends

;
; Structure used by WH_HARDWARE
;

struc	HARDWAREHOOKSTRUCT
	hwnd			dd ?
	message 		dd ?
	wParam			dd ?
	lParam			dd ?
ends

;
; Keyboard Layout API
;
HKL_PREV			= 0
HKL_NEXT			= 1


KLF_ACTIVATE			= 000000001h
KLF_SUBSTITUTE_OK		= 000000002h
KLF_REORDER			= 000000008h
KLF_REPLACELANG 		= 000000010h
KLF_NOTELLSHELL 		= 000000080h
KLF_SETFORPROCESS		= 000000100h

;
; Size of KeyboardLayoutName (number of characters), including nul terminator
;
KL_NAMELENGTH			= 9

procdesc LoadKeyboardLayoutA :dword, :dword
procdesc ActivateKeyboardLayout :dword, :dword
procdesc ToUnicodeEx :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc UnloadKeyboardLayout :dword
procdesc GetKeyboardLayoutNameA :dword
procdesc GetKeyboardLayoutList :dword, :dword
procdesc GetKeyboardLayout :dword

LoadKeyboardLayout		equ <LoadKeyboardLayoutA>
GetKeyboardLayoutName		equ <GetKeyboardLayoutNameA>

struc	MOUSEMOVEPOINT
	x			dd ?
	y			dd ?
	time			dd ?
	dwExtraInfo		dd ?
ends

;
; Values for resolution parameter of GetMouseMovePoints
;
GMMP_USE_DISPLAY_POINTS 	= 1
GMMP_USE_HIGH_RESOLUTION_POINTS = 2

procdesc GetMouseMovePoints :dword, :dword, :dword, :dword, :dword

;
; Desktop-specific access flags
;
DESKTOP_READOBJECTS		= 00001h
DESKTOP_CREATEWINDOW		= 00002h
DESKTOP_CREATEMENU		= 00004h
DESKTOP_HOOKCONTROL		= 00008h
DESKTOP_JOURNALRECORD		= 00010h
DESKTOP_JOURNALPLAYBACK 	= 00020h
DESKTOP_ENUMERATE		= 00040h
DESKTOP_WRITEOBJECTS		= 00080h
DESKTOP_SWITCHDESKTOP		= 00100h

;
; Desktop-specific control flags
;
DF_ALLOWOTHERACCOUNTHOOK	= 00001h

procdesc CreateDesktopA :dword, :dword, :dword, :dword, :dword, :dword
procdesc OpenDesktopA :dword, :dword, :dword, :dword
procdesc OpenInputDesktop :dword, :dword, :dword
procdesc EnumDesktopsA :dword, :dword, :dword
procdesc EnumDesktopWindows :dword, :dword, :dword
procdesc SwitchDesktop :dword
procdesc SetThreadDesktop :dword
procdesc CloseDesktop :dword
procdesc GetThreadDesktop :dword

CreateDesktop			equ <CreateDesktopA>
OpenDesktop			equ <OpenDesktopA>
EnumDesktops			equ <EnumDesktopsA>

;
; Windowstation-specific access flags
;
WINSTA_ENUMDESKTOPS		= 00001h
WINSTA_READATTRIBUTES		= 00002h
WINSTA_ACCESSCLIPBOARD		= 00004h
WINSTA_CREATEDESKTOP		= 00008h
WINSTA_WRITEATTRIBUTES		= 00010h
WINSTA_ACCESSGLOBALATOMS	= 00020h
WINSTA_EXITWINDOWS		= 00040h
WINSTA_ENUMERATE		= 00100h
WINSTA_READSCREEN		= 00200h

;
; Windowstation-specific attribute flags
;
WSF_VISIBLE			= 00001h

procdesc CreateWindowStationA :dword, :dword, :dword, :dword
procdesc OpenWindowStationA :dword, :dword, :dword
procdesc EnumWindowStationsA :dword, :dword
procdesc CloseWindowStation :dword
procdesc SetProcessWindowStation :dword
procdesc GetProcessWindowStation
procdesc SetUserObjectSecurity :dword, :dword, :dword
procdesc GetUserObjectSecurity :dword, :dword, :dword, :dword, :dword

CreateWindowStation		equ <CreateWindowStationA>
OpenWindowStation		equ <OpenWindowStationA>
EnumWindowStations		equ <EnumWindowStationsA>

UOI_FLAGS			= 1
UOI_NAME			= 2
UOI_TYPE			= 3
UOI_USER_SID			= 4

struc	USEROBJECTFLAGS
	fInherit		dd ?
	fReserved		dd ?
	dwFlags 		dd ?
ends

procdesc GetUserObjectInformationA :dword, :dword, :dword, :dword, :dword
procdesc SetUserObjectInformationA :dword, :dword, :dword, :dword

GetUserObjectInformation	equ <GetUserObjectInformationA>
SetUserObjectInformation	equ <SetUserObjectInformationA>

struc	WNDCLASSEX
	cbSize			dd ?		; Win 3.x
	style			dd ?
	lpfnWndProc		dd ?
	cbClsExtra		dd ?
	cbWndExtra		dd ?
	hInstance		dd ?
	hIcon			dd ?
	hCursor 		dd ?
	hbrBackground		dd ?
	lpszMenuName		dd ?
	lpszClassName		dd ?		; Win 4.0
	hIconSm 		dd ?
ends

struc	WNDCLASS
	style			dd ?
	lpfnWndProc		dd ?
	cbClsExtra		dd ?
	cbWndExtra		dd ?
	hInstance		dd ?
	hIcon			dd ?
	hCursor 		dd ?
	hbrBackground		dd ?
	lpszMenuName		dd ?
	lpszClassName		dd ?
ends

;
; Message structure
;

struc	MSG
	hwnd			dd ?
	message 		dd ?
	wParam			dd ?
	lParam			dd ?
	time			dd ?
	pt			POINT ?
ends

;
; Window field offsets for GetWindowLong()
;
GWL_WNDPROC			= (-4)
GWL_HINSTANCE			= (-6)
GWL_HWNDPARENT			= (-8)
GWL_STYLE			= (-16)
GWL_EXSTYLE			= (-20)
GWL_USERDATA			= (-21)
GWL_ID				= (-12)

GWLP_WNDPROC			= (-4)
GWLP_HINSTANCE			= (-6)
GWLP_HWNDPARENT 		= (-8)
GWLP_USERDATA			= (-21)
GWLP_ID 			= (-12)

;
; Class field offsets for GetClassLong()
;
GCL_MENUNAME			= (-8)
GCL_HBRBACKGROUND		= (-10)
GCL_HCURSOR			= (-12)
GCL_HICON			= (-14)
GCL_HMODULE			= (-16)
GCL_CBWNDEXTRA			= (-18)
GCL_CBCLSEXTRA			= (-20)
GCL_WNDPROC			= (-24)
GCL_STYLE			= (-26)
GCW_ATOM			= (-32)

GCL_HICONSM			= (-34)

GCLP_MENUNAME			= (-8)
GCLP_HBRBACKGROUND		= (-10)
GCLP_HCURSOR			= (-12)
GCLP_HICON			= (-14)
GCLP_HMODULE			= (-16)
GCLP_WNDPROC			= (-24)
GCLP_HICONSM			= (-34)

;
; Window Messages
;

WM_NULL 			= 00000h
WM_CREATE			= 00001h
WM_DESTROY			= 00002h
WM_MOVE 			= 00003h
WM_SIZE 			= 00005h

WM_ACTIVATE			= 00006h
;
; WM_ACTIVATE state values
;
WA_INACTIVE			= 0
WA_ACTIVE			= 1
WA_CLICKACTIVE			= 2

WM_SETFOCUS			= 00007h
WM_KILLFOCUS			= 00008h
WM_ENABLE			= 0000Ah
WM_SETREDRAW			= 0000Bh
WM_SETTEXT			= 0000Ch
WM_GETTEXT			= 0000Dh
WM_GETTEXTLENGTH		= 0000Eh
WM_PAINT			= 0000Fh
WM_CLOSE			= 00010h
WM_QUERYENDSESSION		= 00011h
WM_QUERYOPEN			= 00013h
WM_ENDSESSION			= 00016h
WM_QUIT 			= 00012h
WM_ERASEBKGND			= 00014h
WM_SYSCOLORCHANGE		= 00015h
WM_SHOWWINDOW			= 00018h
WM_WININICHANGE 		= 0001Ah
WM_SETTINGCHANGE		= WM_WININICHANGE

WM_DEVMODECHANGE		= 0001Bh
WM_ACTIVATEAPP			= 0001Ch
WM_FONTCHANGE			= 0001Dh
WM_TIMECHANGE			= 0001Eh
WM_CANCELMODE			= 0001Fh
WM_SETCURSOR			= 00020h
WM_MOUSEACTIVATE		= 00021h
WM_CHILDACTIVATE		= 00022h
WM_QUEUESYNC			= 00023h

WM_GETMINMAXINFO		= 00024h
;
; Struct pointed to by WM_GETMINMAXINFO lParam
;

struc	MINMAXINFO
	ptReserved		POINT ?
	ptMaxSize		POINT ?
	ptMaxPosition		POINT ?
	ptMinTrackSize		POINT ?
	ptMaxTrackSize		POINT ?
ends

WM_PAINTICON			= 00026h
WM_ICONERASEBKGND		= 00027h
WM_NEXTDLGCTL			= 00028h
WM_SPOOLERSTATUS		= 0002Ah
WM_DRAWITEM			= 0002Bh
WM_MEASUREITEM			= 0002Ch
WM_DELETEITEM			= 0002Dh
WM_VKEYTOITEM			= 0002Eh
WM_CHARTOITEM			= 0002Fh
WM_SETFONT			= 00030h
WM_GETFONT			= 00031h
WM_SETHOTKEY			= 00032h
WM_GETHOTKEY			= 00033h
WM_QUERYDRAGICON		= 00037h
WM_COMPAREITEM			= 00039h
WM_GETOBJECT			= 0003Dh
WM_COMPACTING			= 00041h
WM_COMMNOTIFY			= 00044h  ; no longer suported
WM_WINDOWPOSCHANGING		= 00046h
WM_WINDOWPOSCHANGED		= 00047h

WM_POWER			= 00048h
;
; wParam for WM_POWER window message and DRV_POWER driver notification
;
PWR_OK				= 1
PWR_FAIL			= (-1)
PWR_SUSPENDREQUEST		= 1
PWR_SUSPENDRESUME		= 2
PWR_CRITICALRESUME		= 3

WM_COPYDATA			= 0004Ah
WM_CANCELJOURNAL		= 0004Bh


;
; lParam of WM_COPYDATA message points to...
;

struc	COPYDATASTRUCT
	dwData			dd ?
	cbData			dd ?
	lpData			dd ?
ends

struc	MDINEXTMENU
	hmenuIn 		dd ?
	hmenuNext		dd ?
	hwndNext		dd ?
ends

WM_NOTIFY			= 0004Eh
WM_INPUTLANGCHANGEREQUEST	= 00050h
WM_INPUTLANGCHANGE		= 00051h
WM_TCARD			= 00052h
WM_HELP 			= 00053h
WM_USERCHANGED			= 00054h
WM_NOTIFYFORMAT 		= 00055h

NFR_ANSI			= 1
NFR_UNICODE			= 2
NF_QUERY			= 3
NF_REQUERY			= 4

WM_CONTEXTMENU			= 0007Bh
WM_STYLECHANGING		= 0007Ch
WM_STYLECHANGED 		= 0007Dh
WM_DISPLAYCHANGE		= 0007Eh
WM_GETICON			= 0007Fh
WM_SETICON			= 00080h

WM_NCCREATE			= 00081h
WM_NCDESTROY			= 00082h
WM_NCCALCSIZE			= 00083h
WM_NCHITTEST			= 00084h
WM_NCPAINT			= 00085h
WM_NCACTIVATE			= 00086h
WM_GETDLGCODE			= 00087h
WM_SYNCPAINT			= 00088h
WM_NCMOUSEMOVE			= 000A0h
WM_NCLBUTTONDOWN		= 000A1h
WM_NCLBUTTONUP			= 000A2h
WM_NCLBUTTONDBLCLK		= 000A3h
WM_NCRBUTTONDOWN		= 000A4h
WM_NCRBUTTONUP			= 000A5h
WM_NCRBUTTONDBLCLK		= 000A6h
WM_NCMBUTTONDOWN		= 000A7h
WM_NCMBUTTONUP			= 000A8h
WM_NCMBUTTONDBLCLK		= 000A9h

WM_KEYFIRST			= 00100h
WM_KEYDOWN			= 00100h
WM_KEYUP			= 00101h
WM_CHAR 			= 00102h
WM_DEADCHAR			= 00103h
WM_SYSKEYDOWN			= 00104h
WM_SYSKEYUP			= 00105h
WM_SYSCHAR			= 00106h
WM_SYSDEADCHAR			= 00107h
WM_KEYLAST			= 00108h

WM_IME_STARTCOMPOSITION 	= 0010Dh
WM_IME_ENDCOMPOSITION		= 0010Eh
WM_IME_COMPOSITION		= 0010Fh
WM_IME_KEYLAST			= 0010Fh

WM_INITDIALOG			= 00110h
WM_COMMAND			= 00111h
WM_SYSCOMMAND			= 00112h
WM_TIMER			= 00113h
WM_HSCROLL			= 00114h
WM_VSCROLL			= 00115h
WM_INITMENU			= 00116h
WM_INITMENUPOPUP		= 00117h
WM_MENUSELECT			= 0011Fh
WM_MENUCHAR			= 00120h
WM_ENTERIDLE			= 00121h
WM_MENURBUTTONUP		= 00122h
WM_MENUDRAG			= 00123h
WM_MENUGETOBJECT		= 00124h
WM_UNINITMENUPOPUP		= 00125h
WM_MENUCOMMAND			= 00126h

WM_KEYBOARDCUES 		= 00127h
;
; LOWORD(wParam) in WM_KEYBOARDCUES
;
KC_SHOW 			= 1
KC_HIDE 			= 2
KC_QUERY			= 3
;
; HIWORD(wParam) in WM_KEYBOARDCUES
;
KCF_FOCUS			= 01h
KCF_ACCEL			= 02h

WM_CTLCOLORMSGBOX		= 00132h
WM_CTLCOLOREDIT 		= 00133h
WM_CTLCOLORLISTBOX		= 00134h
WM_CTLCOLORBTN			= 00135h
WM_CTLCOLORDLG			= 00136h
WM_CTLCOLORSCROLLBAR		= 00137h
WM_CTLCOLORSTATIC		= 00138h

WM_MOUSEFIRST			= 00200h
WM_MOUSEMOVE			= 00200h
WM_LBUTTONDOWN			= 00201h
WM_LBUTTONUP			= 00202h
WM_LBUTTONDBLCLK		= 00203h
WM_RBUTTONDOWN			= 00204h
WM_RBUTTONUP			= 00205h
WM_RBUTTONDBLCLK		= 00206h
WM_MBUTTONDOWN			= 00207h
WM_MBUTTONUP			= 00208h
WM_MBUTTONDBLCLK		= 00209h

WM_MOUSEWHEEL			= 0020Ah
WM_MOUSELAST			= 0020Ah

WHEEL_DELTA			= 120	  ; Value for rolling one detent
WHEEL_PAGESCROLL		= (-1)	  ; Scroll one page

WM_PARENTNOTIFY 		= 00210h
WM_ENTERMENULOOP		= 00211h
WM_EXITMENULOOP 		= 00212h

WM_NEXTMENU			= 00213h
WM_SIZING			= 00214h
WM_CAPTURECHANGED		= 00215h
WM_MOVING			= 00216h

WM_POWERBROADCAST		= 00218h

PBT_APMQUERYSUSPEND		= 00000h
PBT_APMQUERYSTANDBY		= 00001h

PBT_APMQUERYSUSPENDFAILED	= 00002h
PBT_APMQUERYSTANDBYFAILED	= 00003h

PBT_APMSUSPEND			= 00004h
PBT_APMSTANDBY			= 00005h

PBT_APMRESUMECRITICAL		= 00006h
PBT_APMRESUMESUSPEND		= 00007h
PBT_APMRESUMESTANDBY		= 00008h

PBTF_APMRESUMEFROMFAILURE	= 000000001h

PBT_APMBATTERYLOW		= 00009h
PBT_APMPOWERSTATUSCHANGE	= 0000Ah

PBT_APMOEMEVENT 		= 0000Bh
PBT_APMRESUMEAUTOMATIC		= 00012h

WM_DEVICECHANGE 		= 00219h

WM_MDICREATE			= 00220h
WM_MDIDESTROY			= 00221h
WM_MDIACTIVATE			= 00222h
WM_MDIRESTORE			= 00223h
WM_MDINEXT			= 00224h
WM_MDIMAXIMIZE			= 00225h
WM_MDITILE			= 00226h
WM_MDICASCADE			= 00227h
WM_MDIICONARRANGE		= 00228h
WM_MDIGETACTIVE 		= 00229h


WM_MDISETMENU			= 00230h
WM_ENTERSIZEMOVE		= 00231h
WM_EXITSIZEMOVE 		= 00232h
WM_DROPFILES			= 00233h
WM_MDIREFRESHMENU		= 00234h


WM_IME_SETCONTEXT		= 00281h
WM_IME_NOTIFY			= 00282h
WM_IME_CONTROL			= 00283h
WM_IME_COMPOSITIONFULL		= 00284h
WM_IME_SELECT			= 00285h
WM_IME_CHAR			= 00286h
WM_IME_REQUEST			= 00288h
WM_IME_KEYDOWN			= 00290h
WM_IME_KEYUP			= 00291h

WM_MOUSEHOVER			= 002A1h
WM_MOUSELEAVE			= 002A3h
WM_NCMOUSEHOVER 		= 002A0h
WM_NCMOUSELEAVE 		= 002A2h

WM_CUT				= 00300h
WM_COPY 			= 00301h
WM_PASTE			= 00302h
WM_CLEAR			= 00303h
WM_UNDO 			= 00304h
WM_RENDERFORMAT 		= 00305h
WM_RENDERALLFORMATS		= 00306h
WM_DESTROYCLIPBOARD		= 00307h
WM_DRAWCLIPBOARD		= 00308h
WM_PAINTCLIPBOARD		= 00309h
WM_VSCROLLCLIPBOARD		= 0030Ah
WM_SIZECLIPBOARD		= 0030Bh
WM_ASKCBFORMATNAME		= 0030Ch
WM_CHANGECBCHAIN		= 0030Dh
WM_HSCROLLCLIPBOARD		= 0030Eh
WM_QUERYNEWPALETTE		= 0030Fh
WM_PALETTEISCHANGING		= 00310h
WM_PALETTECHANGED		= 00311h
WM_HOTKEY			= 00312h

WM_PRINT			= 00317h
WM_PRINTCLIENT			= 00318h

WM_HANDHELDFIRST		= 00358h
WM_HANDHELDLAST 		= 0035Fh

WM_AFXFIRST			= 00360h
WM_AFXLAST			= 0037Fh

WM_PENWINFIRST			= 00380h
WM_PENWINLAST			= 0038Fh


WM_APP				= 08000h


;
; NOTE: All Message Numbers below 0x0400 are RESERVED.
;
; Private Window Messages Start Here:
;
WM_USER 			= 00400h

;  wParam for WM_SIZING message
WMSZ_LEFT			= 1
WMSZ_RIGHT			= 2
WMSZ_TOP			= 3
WMSZ_TOPLEFT			= 4
WMSZ_TOPRIGHT			= 5
WMSZ_BOTTOM			= 6
WMSZ_BOTTOMLEFT 		= 7
WMSZ_BOTTOMRIGHT		= 8

;
; WM_NCHITTEST and MOUSEHOOKSTRUCT Mouse Position Codes
;
HTERROR 			= (-2)
HTTRANSPARENT			= (-1)
HTNOWHERE			= 0
HTCLIENT			= 1
HTCAPTION			= 2
HTSYSMENU			= 3
HTGROWBOX			= 4
HTSIZE				= HTGROWBOX
HTMENU				= 5
HTHSCROLL			= 6
HTVSCROLL			= 7
HTMINBUTTON			= 8
HTMAXBUTTON			= 9
HTLEFT				= 10
HTRIGHT 			= 11
HTTOP				= 12
HTTOPLEFT			= 13
HTTOPRIGHT			= 14
HTBOTTOM			= 15
HTBOTTOMLEFT			= 16
HTBOTTOMRIGHT			= 17
HTBORDER			= 18
HTREDUCE			= HTMINBUTTON
HTZOOM				= HTMAXBUTTON
HTSIZEFIRST			= HTLEFT
HTSIZELAST			= HTBOTTOMRIGHT
HTOBJECT			= 19
HTCLOSE 			= 20
HTHELP				= 21

;
; SendMessageTimeout values
;
SMTO_NORMAL			= 00000h
SMTO_BLOCK			= 00001h
SMTO_ABORTIFHUNG		= 00002h
SMTO_NOTIMEOUTIFNOTHUNG 	= 00008h

;
; WM_MOUSEACTIVATE Return Codes
;
MA_ACTIVATE			= 1
MA_ACTIVATEANDEAT		= 2
MA_NOACTIVATE			= 3
MA_NOACTIVATEANDEAT		= 4

;
; WM_SETICON / WM_GETICON Type Codes
;
ICON_SMALL			= 0
ICON_BIG			= 1

procdesc RegisterWindowMessageA :dword

RegisterWindowMessage		equ <RegisterWindowMessageA>


;
; WM_SIZE message wParam values
;
SIZE_RESTORED			= 0
SIZE_MINIMIZED			= 1
SIZE_MAXIMIZED			= 2
SIZE_MAXSHOW			= 3
SIZE_MAXHIDE			= 4

;
; Obsolete constant names
;
SIZENORMAL			= SIZE_RESTORED
SIZEICONIC			= SIZE_MINIMIZED
SIZEFULLSCREEN			= SIZE_MAXIMIZED
SIZEZOOMSHOW			= SIZE_MAXSHOW
SIZEZOOMHIDE			= SIZE_MAXHIDE

;
; WM_WINDOWPOSCHANGING/CHANGED struct pointed to by lParam
;

struc	WINDOWPOS
	hwnd			dd ?
	hwndInsertAfter 	dd ?
	x			dd ?
	y			dd ?
	cx			dd ?
	cy			dd ?
	flags			dd ?
ends

;
; WM_NCCALCSIZE parameter structure
;

struc	NCCALCSIZE_PARAMS
	rgrc			RECT 3 dup (?)
	lppos			dd ?
ends

;
; WM_NCCALCSIZE "window valid rect" return values
;
WVR_ALIGNTOP			= 00010h
WVR_ALIGNLEFT			= 00020h
WVR_ALIGNBOTTOM 		= 00040h
WVR_ALIGNRIGHT			= 00080h
WVR_HREDRAW			= 00100h
WVR_VREDRAW			= 00200h
WVR_REDRAW			= (WVR_HREDRAW + WVR_VREDRAW)
WVR_VALIDRECTS			= 00400h

;
; Key State Masks for Mouse Messages
;
MK_LBUTTON			= 00001h
MK_RBUTTON			= 00002h
MK_SHIFT			= 00004h
MK_CONTROL			= 00008h
MK_MBUTTON			= 00010h

TME_HOVER			= 000000001h
TME_LEAVE			= 000000002h
TME_NONCLIENT			= 000000010h
TME_QUERY			= 040000000h
TME_CANCEL			= 080000000h

HOVER_DEFAULT			= 0FFFFFFFFh

struc	TRACKMOUSEEVENT
	cbSize			dd ?
	dwFlags 		dd ?
	hwndTrack		dd ?
	dwHoverTime		dd ?
ends

procdesc TrackMouseEvent :dword

;
; Window Styles
;
WS_OVERLAPPED			= 000000000h
WS_POPUP			= 080000000h
WS_CHILD			= 040000000h
WS_MINIMIZE			= 020000000h
WS_VISIBLE			= 010000000h
WS_DISABLED			= 008000000h
WS_CLIPSIBLINGS 		= 004000000h
WS_CLIPCHILDREN 		= 002000000h
WS_MAXIMIZE			= 001000000h
WS_CAPTION			= 000C00000h	 ; WS_BORDER | WS_DLGFRAME
WS_BORDER			= 000800000h
WS_DLGFRAME			= 000400000h
WS_VSCROLL			= 000200000h
WS_HSCROLL			= 000100000h
WS_SYSMENU			= 000080000h
WS_THICKFRAME			= 000040000h
WS_GROUP			= 000020000h
WS_TABSTOP			= 000010000h

WS_MINIMIZEBOX			= 000020000h
WS_MAXIMIZEBOX			= 000010000h


WS_TILED			= WS_OVERLAPPED
WS_ICONIC			= WS_MINIMIZE
WS_SIZEBOX			= WS_THICKFRAME
WS_TILEDWINDOW			= WS_OVERLAPPEDWINDOW

;
; Common Window Styles
;
WS_OVERLAPPEDWINDOW		= (WS_OVERLAPPED  +\
				   WS_CAPTION	  +\
				   WS_SYSMENU	  +\
				   WS_THICKFRAME  +\
				   WS_MINIMIZEBOX +\
				   WS_MAXIMIZEBOX)

WS_POPUPWINDOW			= (WS_POPUP	  +\
				   WS_BORDER	  +\
				   WS_SYSMENU)

WS_CHILDWINDOW			= (WS_CHILD)

;
; Extended Window Styles
;
WS_EX_DLGMODALFRAME		= 000000001h
WS_EX_NOPARENTNOTIFY		= 000000004h
WS_EX_TOPMOST			= 000000008h
WS_EX_ACCEPTFILES		= 000000010h
WS_EX_TRANSPARENT		= 000000020h
WS_EX_MDICHILD			= 000000040h
WS_EX_TOOLWINDOW		= 000000080h
WS_EX_WINDOWEDGE		= 000000100h
WS_EX_CLIENTEDGE		= 000000200h
WS_EX_CONTEXTHELP		= 000000400h

WS_EX_RIGHT			= 000001000h
WS_EX_LEFT			= 000000000h
WS_EX_RTLREADING		= 000002000h
WS_EX_LTRREADING		= 000000000h
WS_EX_LEFTSCROLLBAR		= 000004000h
WS_EX_RIGHTSCROLLBAR		= 000000000h

WS_EX_CONTROLPARENT		= 000010000h
WS_EX_STATICEDGE		= 000020000h
WS_EX_APPWINDOW 		= 000040000h

WS_EX_OVERLAPPEDWINDOW		= (WS_EX_WINDOWEDGE + WS_EX_CLIENTEDGE)
WS_EX_PALETTEWINDOW		= (WS_EX_WINDOWEDGE + WS_EX_TOOLWINDOW + WS_EX_TOPMOST)

WS_EX_LAYERED			= 000080000h

WS_EX_NOINHERITLAYOUT		= 000100000h ; Disable inheritence of mirroring by children
WS_EX_LAYOUTRTL 		= 000400000h ; Right to left mirroring

WS_EX_NOACTIVATE		= 008000000h


;
; Class styles
;
CS_VREDRAW			= 00001h
CS_HREDRAW			= 00002h
CS_DBLCLKS			= 00008h
CS_OWNDC			= 00020h
CS_CLASSDC			= 00040h
CS_PARENTDC			= 00080h
CS_NOCLOSE			= 00200h
CS_SAVEBITS			= 00800h
CS_BYTEALIGNCLIENT		= 01000h
CS_BYTEALIGNWINDOW		= 02000h
CS_GLOBALCLASS			= 04000h

CS_IME				= 000010000h



; WM_PRINT flags
PRF_CHECKVISIBLE		= 000000001h
PRF_NONCLIENT			= 000000002h
PRF_CLIENT			= 000000004h
PRF_ERASEBKGND			= 000000008h
PRF_CHILDREN			= 000000010h
PRF_OWNED			= 000000020h

; 3D border styles
BDR_RAISEDOUTER 		= 00001h
BDR_SUNKENOUTER 		= 00002h
BDR_RAISEDINNER 		= 00004h
BDR_SUNKENINNER 		= 00008h

BDR_OUTER			= (BDR_RAISEDOUTER + BDR_SUNKENOUTER)
BDR_INNER			= (BDR_RAISEDINNER + BDR_SUNKENINNER)
BDR_RAISED			= (BDR_RAISEDOUTER + BDR_RAISEDINNER)
BDR_SUNKEN			= (BDR_SUNKENOUTER + BDR_SUNKENINNER)


EDGE_RAISED			= (BDR_RAISEDOUTER + BDR_RAISEDINNER)
EDGE_SUNKEN			= (BDR_SUNKENOUTER + BDR_SUNKENINNER)
EDGE_ETCHED			= (BDR_SUNKENOUTER + BDR_RAISEDINNER)
EDGE_BUMP			= (BDR_RAISEDOUTER + BDR_SUNKENINNER)

; Border flags
BF_LEFT 			= 00001h
BF_TOP				= 00002h
BF_RIGHT			= 00004h
BF_BOTTOM			= 00008h

BF_TOPLEFT			= (BF_TOP + BF_LEFT)
BF_TOPRIGHT			= (BF_TOP + BF_RIGHT)
BF_BOTTOMLEFT			= (BF_BOTTOM + BF_LEFT)
BF_BOTTOMRIGHT			= (BF_BOTTOM + BF_RIGHT)
BF_RECT 			= (BF_LEFT + BF_TOP + BF_RIGHT + BF_BOTTOM)

BF_DIAGONAL			= 00010h

; For diagonal lines, the BF_RECT flags specify the end point of the
; vector bounded by the rectangle parameter.
BF_DIAGONAL_ENDTOPRIGHT 	= (BF_DIAGONAL + BF_TOP + BF_RIGHT)
BF_DIAGONAL_ENDTOPLEFT		= (BF_DIAGONAL + BF_TOP + BF_LEFT)
BF_DIAGONAL_ENDBOTTOMLEFT	= (BF_DIAGONAL + BF_BOTTOM + BF_LEFT)
BF_DIAGONAL_ENDBOTTOMRIGHT	= (BF_DIAGONAL + BF_BOTTOM + BF_RIGHT)

BF_MIDDLE			= 00800h  ; Fill in the middle
BF_SOFT 			= 01000h  ; For softer buttons
BF_ADJUST			= 02000h  ; Calculate the space left over
BF_FLAT 			= 04000h  ; For flat rather than 3D borders
BF_MONO 			= 08000h  ; For monochrome borders

procdesc DrawEdge :dword, :dword, :dword, :dword

; flags for DrawFrameControl

DFC_CAPTION			= 1
DFC_MENU			= 2
DFC_SCROLL			= 3
DFC_BUTTON			= 4
DFC_POPUPMENU			= 5

DFCS_CAPTIONCLOSE		= 00000h
DFCS_CAPTIONMIN 		= 00001h
DFCS_CAPTIONMAX 		= 00002h
DFCS_CAPTIONRESTORE		= 00003h
DFCS_CAPTIONHELP		= 00004h

DFCS_MENUARROW			= 00000h
DFCS_MENUCHECK			= 00001h
DFCS_MENUBULLET 		= 00002h
DFCS_MENUARROWRIGHT		= 00004h
DFCS_SCROLLUP			= 00000h
DFCS_SCROLLDOWN 		= 00001h
DFCS_SCROLLLEFT 		= 00002h
DFCS_SCROLLRIGHT		= 00003h
DFCS_SCROLLCOMBOBOX		= 00005h
DFCS_SCROLLSIZEGRIP		= 00008h
DFCS_SCROLLSIZEGRIPRIGHT	= 00010h

DFCS_BUTTONCHECK		= 00000h
DFCS_BUTTONRADIOIMAGE		= 00001h
DFCS_BUTTONRADIOMASK		= 00002h
DFCS_BUTTONRADIO		= 00004h
DFCS_BUTTON3STATE		= 00008h
DFCS_BUTTONPUSH 		= 00010h

DFCS_INACTIVE			= 00100h
DFCS_PUSHED			= 00200h
DFCS_CHECKED			= 00400h

DFCS_TRANSPARENT		= 00800h
DFCS_HOT			= 01000h

DFCS_ADJUSTRECT 		= 02000h
DFCS_FLAT			= 04000h
DFCS_MONO			= 08000h

procdesc DrawFrameControl :dword, :dword, :dword, :dword

; flags for DrawCaption
DC_ACTIVE			= 00001h
DC_SMALLCAP			= 00002h
DC_ICON 			= 00004h
DC_TEXT 			= 00008h
DC_INBUTTON			= 00010h
DC_GRADIENT			= 00020h

procdesc DrawCaption :dword, :dword, :dword, :dword

IDANI_OPEN			= 1

procdesc DrawAnimatedRects :dword, :dword, :dword, :dword

;
; Predefined Clipboard Formats
;
CF_TEXT 			= 1
CF_BITMAP			= 2
CF_METAFILEPICT 		= 3
CF_SYLK 			= 4
CF_DIF				= 5
CF_TIFF 			= 6
CF_OEMTEXT			= 7
CF_DIB				= 8
CF_PALETTE			= 9
CF_PENDATA			= 10
CF_RIFF 			= 11
CF_WAVE 			= 12
CF_UNICODETEXT			= 13
CF_ENHMETAFILE			= 14
CF_HDROP			= 15
CF_LOCALE			= 16
CF_DIBV5			= 17

CF_MAX				= 18

CF_OWNERDISPLAY 		= 00080h
CF_DSPTEXT			= 00081h
CF_DSPBITMAP			= 00082h
CF_DSPMETAFILEPICT		= 00083h
CF_DSPENHMETAFILE		= 0008Eh

;
; "Private" formats don't get GlobalFree()'d
;
CF_PRIVATEFIRST 		= 00200h
CF_PRIVATELAST			= 002FFh

;
; "GDIOBJ" formats do get DeleteObject()'d
;
CF_GDIOBJFIRST			= 00300h
CF_GDIOBJLAST			= 003FFh

;
; Defines for the fVirt field of the Accelerator table structure.
;
FVIRTKEY			= TRUE		; Assumed to be == TRUE
FNOINVERT			= 002h
FSHIFT				= 004h
FCONTROL			= 008h
FALT				= 010h

struc	ACCEL
	fVirt			db ?		; Also called the flags field
	key			dw ?
	cmd			dw ?
ends

struc	PAINTSTRUCT
	hdc			dd ?
	fErase			dd ?
	rcPaint 		RECT ?
	fRestore		dd ?
	fIncUpdate		dd ?
	rgbReserved		db 32 dup (?)
ends

struc	CREATESTRUCT
	lpCreateParams		dd ?
	hInstance		dd ?
	hMenu			dd ?
	hwndParent		dd ?
	cy			dd ?
	cx			dd ?
	y			dd ?
	x			dd ?
	style			dd ?
	lpszName		dd ?
	lpszClass		dd ?
	dwExStyle		dd ?
ends

struc	WINDOWPLACEMENT
	length			dd ?
	flags			dd ?
	showCmd 		dd ?
	ptMinPosition		POINT ?
	ptMaxPosition		POINT ?
	rcNormalPosition	RECT ?
ends

WPF_SETMINPOSITION		= 00001h
WPF_RESTORETOMAXIMIZED		= 00002h
WPF_ASYNCWINDOWPLACEMENT	= 00004h

struc	NMHDR
	hwndFrom		dd ?
	idFrom			dd ?
	code			dd ?		; NM_ code
ends

struc	STYLESTRUCT
	styleOld		dd ?
	styleNew		dd ?
ends

;
; Owner draw control types
;
ODT_MENU			= 1
ODT_LISTBOX			= 2
ODT_COMBOBOX			= 3
ODT_BUTTON			= 4
ODT_STATIC			= 5

;
; Owner draw actions
;
ODA_DRAWENTIRE			= 00001h
ODA_SELECT			= 00002h
ODA_FOCUS			= 00004h

;
; Owner draw state
;
ODS_SELECTED			= 00001h
ODS_GRAYED			= 00002h
ODS_DISABLED			= 00004h
ODS_CHECKED			= 00008h
ODS_FOCUS			= 00010h
ODS_DEFAULT			= 00020h
ODS_HOTLIGHT			= 00040h
ODS_INACTIVE			= 00080h
ODS_NOACCEL			= 00100h
ODS_NOFOCUSRECT 		= 00200h
ODS_COMBOBOXEDIT		= 01000h

;
; MEASUREITEMSTRUCT for ownerdraw
;

struc	MEASUREITEMSTRUCT
	CtlType 		dd ?
	CtlID			dd ?
	itemID			dd ?
	itemWidth		dd ?
	itemHeight		dd ?
	itemData		dd ?
ends

;
; DRAWITEMSTRUCT for ownerdraw
;

struc	DRAWITEMSTRUCT
	CtlType 		dd ?
	CtlID			dd ?
	itemID			dd ?
	itemAction		dd ?
	itemState		dd ?
	hwndItem		dd ?
	hDC			dd ?
	rcItem			RECT ?
	itemData		dd ?
ends

;
; DELETEITEMSTRUCT for ownerdraw
;

struc	DELETEITEMSTRUCT
	CtlType 		dd ?
	CtlID			dd ?
	itemID			dd ?
	hwndItem		dd ?
	itemData		dd ?
ends

;
; COMPAREITEMSTUCT for ownerdraw sorting
;

struc	COMPAREITEMSTRUCT
	CtlType 		dd ?
	CtlID			dd ?
	hwndItem		dd ?
	itemID1 		dd ?
	itemData1		dd ?
	itemID2 		dd ?
	itemData2		dd ?
	dwLocaleId		dd ?
ends

;
; Message Function Templates
;

procdesc GetMessageA :dword, :dword, :dword, :dword
procdesc TranslateMessage :dword
procdesc DispatchMessageA :dword
procdesc SetMessageQueue :dword
procdesc PeekMessageA :dword, :dword, :dword, :dword, :dword

GetMessage			equ <GetMessageA>
DispatchMessage 		equ <DispatchMessageA>
PeekMessage			equ <PeekMessageA>

;
; PeekMessage() Options
;
PM_NOREMOVE			= 00000h
PM_REMOVE			= 00001h
PM_NOYIELD			= 00002h
PM_QS_INPUT			= (QS_INPUT shl 16)
PM_QS_POSTMESSAGE		= ((QS_POSTMESSAGE + QS_HOTKEY + QS_TIMER) shl 16)
PM_QS_PAINT			= (QS_PAINT shl 16)
PM_QS_SENDMESSAGE		= (QS_SENDMESSAGE shl 16)

procdesc RegisterHotKey :dword, :dword, :dword, :dword
procdesc UnregisterHotKey :dword, :dword

MOD_ALT 			= 00001h
MOD_CONTROL			= 00002h
MOD_SHIFT			= 00004h
MOD_WIN 			= 00008h

IDHOT_SNAPWINDOW		= (-1)	  ; SHIFT-PRINTSCRN
IDHOT_SNAPDESKTOP		= (-2)	  ; PRINTSCRN

ENDSESSION_LOGOFF		= 080000000h

EWX_LOGOFF			= 0
EWX_SHUTDOWN			= 000000001h
EWX_REBOOT			= 000000002h
EWX_FORCE			= 000000004h
EWX_POWEROFF			= 000000008h
EWX_FORCEIFHUNG 		= 000000010h

procdesc ExitWindowsEx :dword, :dword
procdesc SwapMouseButton :dword
procdesc GetMessagePos
procdesc GetMessageTime
procdesc GetMessageExtraInfo
procdesc SetMessageExtraInfo :dword
procdesc SendMessageA :dword, :dword, :dword, :dword
procdesc SendMessageTimeoutA :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc SendNotifyMessageA :dword, :dword, :dword, :dword
procdesc SendMessageCallbackA :dword, :dword, :dword, :dword, :dword, :dword
procdesc BroadcastSystemMessageA :dword, :dword, :dword, :dword, :dword

SendMessage			equ <SendMessageA>
SendMessageTimeout		equ <SendMessageTimeoutA>
SendNotifyMessage		equ <SendNotifyMessageA>
SendMessageCallback		equ <SendMessageCallbackA>
BroadcastSystemMessage		equ <BroadcastSystemMessageA>

;Broadcast Special Message Recipient list
BSM_ALLCOMPONENTS		= 000000000h
BSM_VXDS			= 000000001h
BSM_NETDRIVER			= 000000002h
BSM_INSTALLABLEDRIVERS		= 000000004h
BSM_APPLICATIONS		= 000000008h
BSM_ALLDESKTOPS 		= 000000010h

;Broadcast Special Message Flags
BSF_QUERY			= 000000001h
BSF_IGNORECURRENTTASK		= 000000002h
BSF_FLUSHDISK			= 000000004h
BSF_NOHANG			= 000000008h
BSF_POSTMESSAGE 		= 000000010h
BSF_FORCEIFHUNG 		= 000000020h
BSF_NOTIMEOUTIFNOTHUNG		= 000000040h
BSF_ALLOWSFW			= 000000080h

BROADCAST_QUERY_DENY		= 0424D5144h  ; Return this value to deny a query.

; RegisterDeviceNotification

DEVICE_NOTIFY_WINDOW_HANDLE	= 000000000h
DEVICE_NOTIFY_SERVICE_HANDLE	= 000000001h

procdesc RegisterDeviceNotificationA :dword, :dword, :dword
procdesc UnregisterDeviceNotification :dword
procdesc PostMessageA :dword, :dword, :dword, :dword
procdesc PostThreadMessageA :dword, :dword, :dword, :dword

RegisterDeviceNotification	equ <RegisterDeviceNotificationA>
PostMessage			equ <PostMessageA>
PostThreadMessage		equ <PostThreadMessageA>
PostAppMessage			equ <PostThreadMessageA>

;
; Special HWND value for use with PostMessage() and SendMessage()
;
HWND_BROADCAST			= (0fffh)

HWND_MESSAGE			= (-3)

procdesc AttachThreadInput :dword, :dword, :dword
procdesc ReplyMessage :dword
procdesc WaitMessage
procdesc WaitForInputIdle :dword, :dword
procdesc DefWindowProcA :dword, :dword, :dword, :dword
procdesc PostQuitMessage :dword
procdesc CallWindowProcA :dword, :dword, :dword, :dword, :dword
procdesc InSendMessage
procdesc InSendMessageEx :dword

DefWindowProc			equ <DefWindowProcA>
CallWindowProc			equ <CallWindowProcA>

;
; InSendMessageEx return value
;
ISMEX_NOSEND			= 000000000h
ISMEX_SEND			= 000000001h
ISMEX_NOTIFY			= 000000002h
ISMEX_CALLBACK			= 000000004h
ISMEX_REPLIED			= 000000008h

procdesc GetDoubleClickTime
procdesc SetDoubleClickTime :dword
procdesc RegisterClassA :dword
procdesc UnregisterClassA :dword, :dword
procdesc GetClassInfoA :dword, :dword, :dword
procdesc RegisterClassExA :dword
procdesc GetClassInfoExA :dword, :dword, :dword

RegisterClass			equ <RegisterClassA>
UnregisterClass 		equ <UnregisterClassA>
GetClassInfo			equ <GetClassInfoA>
RegisterClassEx 		equ <RegisterClassExA>
GetClassInfoEx			equ <GetClassInfoExA>

CW_USEDEFAULT			= (080000000h)

;
; Special value for CreateWindow, et al.
;
HWND_DESKTOP			= (0)

procdesc CreateWindowExA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc IsWindow :dword
procdesc IsMenu :dword
procdesc IsChild :dword, :dword
procdesc DestroyWindow :dword
procdesc ShowWindow :dword, :dword
procdesc AnimateWindow :dword, :dword, :dword
procdesc UpdateLayeredWindow :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

CreateWindowEx			equ <CreateWindowExA>

ULW_COLORKEY			= 000000001h
ULW_ALPHA			= 000000002h
ULW_OPAQUE			= 000000004h

procdesc ShowWindowAsync :dword, :dword
procdesc FlashWindow :dword, :dword

struc	FLASHWINFO
	cbSize			dd ?
	hwnd			dd ?
	dwFlags 		dd ?
	uCount			dd ?
	dwTimeout		dd ?
ends

procdesc FlashWindowEx :dword

FLASHW_STOP			= 0
FLASHW_CAPTION			= 000000001h
FLASHW_TRAY			= 000000002h
FLASHW_ALL			= (FLASHW_CAPTION + FLASHW_TRAY)
FLASHW_TIMER			= 000000004h
FLASHW_TIMERNOFG		= 00000000Ch

procdesc ShowOwnedPopups :dword, :dword
procdesc OpenIcon :dword
procdesc CloseWindow :dword
procdesc MoveWindow :dword, :dword, :dword, :dword, :dword, :dword
procdesc SetWindowPos :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetWindowPlacement :dword, :dword
procdesc SetWindowPlacement :dword, :dword
procdesc BeginDeferWindowPos :dword
procdesc DeferWindowPos :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc EndDeferWindowPos :dword
procdesc IsWindowVisible :dword
procdesc IsIconic :dword
procdesc AnyPopup
procdesc BringWindowToTop :dword
procdesc IsZoomed :dword

;
; SetWindowPos Flags
;
SWP_NOSIZE			= 00001h
SWP_NOMOVE			= 00002h
SWP_NOZORDER			= 00004h
SWP_NOREDRAW			= 00008h
SWP_NOACTIVATE			= 00010h
SWP_FRAMECHANGED		= 00020h  ; The frame changed: send WM_NCCALCSIZE
SWP_SHOWWINDOW			= 00040h
SWP_HIDEWINDOW			= 00080h
SWP_NOCOPYBITS			= 00100h
SWP_NOOWNERZORDER		= 00200h  ; Don't do owner Z ordering
SWP_NOSENDCHANGING		= 00400h  ; Don't send WM_WINDOWPOSCHANGING

SWP_DRAWFRAME			= SWP_FRAMECHANGED
SWP_NOREPOSITION		= SWP_NOOWNERZORDER

SWP_DEFERERASE			= 02000h
SWP_ASYNCWINDOWPOS		= 04000h

HWND_TOP			= (0)
HWND_BOTTOM			= (1)
HWND_TOPMOST			= (-1)
HWND_NOTOPMOST			= (-2)

;
; WARNING:
; The following structures must NOT be DWORD padded because they are
; followed by strings, etc that do not have to be DWORD aligned.
;

;
; original NT 32 bit dialog template:
;

struc	DLGTEMPLATE
	style			dd ?
	dwExtendedStyle 	dd ?
	cdit			dw ?
	x			dw ?
	y			dw ?
	cx			dw ?
	cy			dw ?
ends

;
; 32 bit Dialog item template.
;

struc	DLGITEMTEMPLATE
	style			dd ?
	dwExtendedStyle 	dd ?
	x			dw ?
	y			dw ?
	cx			dw ?
	cy			dw ?
	id			dw ?
ends

procdesc CreateDialogParamA :dword, :dword, :dword, :dword, :dword
procdesc CreateDialogIndirectParamA :dword, :dword, :dword, :dword, :dword
procdesc DialogBoxParamA :dword, :dword, :dword, :dword, :dword
procdesc DialogBoxIndirectParamA :dword, :dword, :dword, :dword, :dword
procdesc EndDialog :dword, :dword
procdesc GetDlgItem :dword, :dword
procdesc SetDlgItemInt :dword, :dword, :dword, :dword
procdesc GetDlgItemInt :dword, :dword, :dword, :dword
procdesc SetDlgItemTextA :dword, :dword, :dword
procdesc GetDlgItemTextA :dword, :dword, :dword, :dword
procdesc CheckDlgButton :dword, :dword, :dword
procdesc CheckRadioButton :dword, :dword, :dword, :dword
procdesc IsDlgButtonChecked :dword, :dword
procdesc SendDlgItemMessageA :dword, :dword, :dword, :dword, :dword
procdesc GetNextDlgGroupItem :dword, :dword, :dword
procdesc GetNextDlgTabItem :dword, :dword, :dword
procdesc GetDlgCtrlID :dword
procdesc GetDialogBaseUnits
procdesc DefDlgProcA :dword, :dword, :dword, :dword

CreateDialogParam		equ <CreateDialogParamA>
CreateDialogIndirectParam	equ <CreateDialogIndirectParamA>
DialogBoxParam			equ <DialogBoxParamA>
DialogBoxIndirectParam		equ <DialogBoxIndirectParamA>
SetDlgItemText			equ <SetDlgItemTextA>
GetDlgItemText			equ <GetDlgItemTextA>
SendDlgItemMessage		equ <SendDlgItemMessageA>
DefDlgProc			equ <DefDlgProcA>

;
; Window extra byted needed for private dialog classes.
;
DLGWINDOWEXTRA			= 30

procdesc CallMsgFilterA :dword, :dword

CallMsgFilter			equ <CallMsgFilterA>

;
; Clipboard Manager Functions
;

procdesc OpenClipboard :dword
procdesc CloseClipboard
procdesc GetClipboardSequenceNumber
procdesc GetClipboardOwner
procdesc SetClipboardViewer :dword
procdesc GetClipboardViewer
procdesc ChangeClipboardChain :dword, :dword
procdesc SetClipboardData :dword, :dword
procdesc GetClipboardData :dword
procdesc RegisterClipboardFormatA :dword
procdesc CountClipboardFormats
procdesc EnumClipboardFormats :dword
procdesc GetClipboardFormatNameA :dword, :dword, :dword
procdesc EmptyClipboard
procdesc IsClipboardFormatAvailable :dword
procdesc GetPriorityClipboardFormat :dword, :dword
procdesc GetOpenClipboardWindow

RegisterClipboardFormat 	equ <RegisterClipboardFormatA>
GetClipboardFormatName		equ <GetClipboardFormatNameA>

;
; Character Translation Routines
;

procdesc CharToOemA :dword, :dword
procdesc OemToCharA :dword, :dword
procdesc CharToOemBuffA :dword, :dword, :dword
procdesc OemToCharBuffA :dword, :dword, :dword
procdesc CharUpperA :dword
procdesc CharUpperBuffA :dword, :dword
procdesc CharLowerA :dword
procdesc CharLowerBuffA :dword, :dword
procdesc CharNextA :dword
procdesc CharPrevA :dword, :dword
procdesc CharNextExA :dword, :dword, :dword
procdesc CharPrevExA :dword, :dword, :dword, :dword

CharToOem			equ <CharToOemA>
OemToChar			equ <OemToCharA>
CharToOemBuff			equ <CharToOemBuffA>
OemToCharBuff			equ <OemToCharBuffA>
CharUpper			equ <CharUpperA>
CharUpperBuff			equ <CharUpperBuffA>
CharLower			equ <CharLowerA>
CharLowerBuff			equ <CharLowerBuffA>
CharNext			equ <CharNextA>
CharPrev			equ <CharPrevA>
CharNextEx			equ <CharNextExA>
CharPrevEx			equ <CharPrevExA>

;
; Compatibility defines for character translation routines
;
AnsiToOem			equ <CharToOemA>
OemToAnsi			equ <OemToCharA>
AnsiToOemBuff			equ <CharToOemBuffA>
OemToAnsiBuff			equ <OemToCharBuffA>
AnsiUpper			equ <CharUpperA>
AnsiUpperBuff			equ <CharUpperBuffA>
AnsiLower			equ <CharLowerA>
AnsiLowerBuff			equ <CharLowerBuffA>
AnsiNext			equ <CharNextA>
AnsiPrev			equ <CharPrevA>

;
; Language dependent Routines
;

procdesc IsCharAlphaA :dword
procdesc IsCharAlphaNumericA :dword
procdesc IsCharUpperA :dword
procdesc IsCharLowerA :dword
procdesc SetFocus :dword
procdesc GetActiveWindow
procdesc GetFocus
procdesc GetKBCodePage
procdesc GetKeyState :dword
procdesc GetAsyncKeyState :dword
procdesc GetKeyboardState :dword
procdesc SetKeyboardState :dword
procdesc GetKeyNameTextA :dword, :dword, :dword
procdesc GetKeyboardType :dword
procdesc ToAscii :dword, :dword, :dword, :dword, :dword
procdesc ToAsciiEx :dword, :dword, :dword, :dword, :dword, :dword
procdesc ToUnicode :dword, :dword, :dword, :dword, :dword, :dword
procdesc OemKeyScan :dword
procdesc VkKeyScanA :dword
procdesc VkKeyScanExA :dword, :dword

IsCharAlpha			equ <IsCharAlphaA>
IsCharAlphaNumeric		equ <IsCharAlphaNumericA>
IsCharUpper			equ <IsCharUpperA>
IsCharLower			equ <IsCharLowerA>
GetKeyNameText			equ <GetKeyNameTextA>
VkKeyScan			equ <VkKeyScanA>
VkKeyScanEx			equ <VkKeyScanExA>

KEYEVENTF_EXTENDEDKEY		= 00001h
KEYEVENTF_KEYUP 		= 00002h

procdesc keybd_event :dword, :dword, :dword, :dword

MOUSEEVENTF_MOVE		= 00001h ; mouse move
MOUSEEVENTF_LEFTDOWN		= 00002h ; left button down
MOUSEEVENTF_LEFTUP		= 00004h ; left button up
MOUSEEVENTF_RIGHTDOWN		= 00008h ; right button down
MOUSEEVENTF_RIGHTUP		= 00010h ; right button up
MOUSEEVENTF_MIDDLEDOWN		= 00020h ; middle button down
MOUSEEVENTF_MIDDLEUP		= 00040h ; middle button up
MOUSEEVENTF_WHEEL		= 00800h ; wheel button rolled
MOUSEEVENTF_VIRTUALDESK 	= 04000h ; map to entire virtual desktop
MOUSEEVENTF_ABSOLUTE		= 08000h ; absolute move

procdesc mouse_event :dword, :dword, :dword, :dword, :dword

struc	MOUSEINPUT
	dx			dd ?
	dy			dd ?
	mouseData		dd ?
	dwFlags 		dd ?
	time			dd ?
	dwExtraInfo		dd ?
ends

struc	KEYBDINPUT
	wVk			dw ?
	wScan			dw ?
	dwFlags 		dd ?
	time			dd ?
	dwExtraInfo		dd ?
ends

struc	HARDWAREINPUT
	uMsg			dd ?
	wParamL 		dw ?
	wParamH 		dw ?
ends

INPUT_MOUSE			= 0
INPUT_KEYBOARD			= 1
INPUT_HARDWARE			= 2

struc	INPUT
	type			dd ?
label	mi			MOUSEINPUT
label	ki			KEYBDINPUT
	hi			HARDWAREINPUT ?
ends

procdesc SendInput :dword, :dword, :dword

struc	LASTINPUTINFO
	cbSize			dd ?
	dwTime			dd ?
ends

procdesc GetLastInputInfo :dword
procdesc MapVirtualKeyA :dword, :dword
procdesc MapVirtualKeyExA :dword, :dword, :dword
procdesc GetInputState
procdesc GetQueueStatus :dword
procdesc GetCapture
procdesc SetCapture :dword
procdesc ReleaseCapture
procdesc MsgWaitForMultipleObjects :dword, :dword, :dword, :dword, :dword
procdesc MsgWaitForMultipleObjectsEx :dword, :dword, :dword, :dword, :dword

MapVirtualKey			equ <MapVirtualKeyA>
MapVirtualKeyEx 		equ <MapVirtualKeyExA>

MWMO_WAITALL			= 00001h
MWMO_ALERTABLE			= 00002h
MWMO_INPUTAVAILABLE		= 00004h

;
; Queue status flags for GetQueueStatus() and MsgWaitForMultipleObjects()
;
QS_KEY				= 00001h
QS_MOUSEMOVE			= 00002h
QS_MOUSEBUTTON			= 00004h
QS_POSTMESSAGE			= 00008h
QS_TIMER			= 00010h
QS_PAINT			= 00020h
QS_SENDMESSAGE			= 00040h
QS_HOTKEY			= 00080h
QS_ALLPOSTMESSAGE		= 00100h

QS_MOUSE			= (QS_MOUSEMOVE     +\
				   QS_MOUSEBUTTON)

QS_INPUT			= (QS_MOUSE	    +\
				   QS_KEY)

QS_ALLEVENTS			= (QS_INPUT	    +\
				   QS_POSTMESSAGE   +\
				   QS_TIMER	    +\
				   QS_PAINT	    +\
				   QS_HOTKEY)

QS_ALLINPUT			= (QS_INPUT	    +\
				   QS_POSTMESSAGE   +\
				   QS_TIMER	    +\
				   QS_PAINT	    +\
				   QS_HOTKEY	    +\
				   QS_SENDMESSAGE)

;
; Windows Functions
;

procdesc SetTimer :dword, :dword, :dword, :dword
procdesc KillTimer :dword, :dword
procdesc IsWindowUnicode :dword
procdesc EnableWindow :dword, :dword
procdesc IsWindowEnabled :dword
procdesc LoadAcceleratorsA :dword, :dword
procdesc CreateAcceleratorTableA :dword, :dword
procdesc DestroyAcceleratorTable :dword
procdesc CopyAcceleratorTableA :dword, :dword, :dword
procdesc TranslateAcceleratorA :dword, :dword, :dword

LoadAccelerators		equ <LoadAcceleratorsA>
CreateAcceleratorTable		equ <CreateAcceleratorTableA>
CopyAcceleratorTable		equ <CopyAcceleratorTableA>
TranslateAccelerator		equ <TranslateAcceleratorA>

;
; GetSystemMetrics() codes
;

SM_CXSCREEN			= 0
SM_CYSCREEN			= 1
SM_CXVSCROLL			= 2
SM_CYHSCROLL			= 3
SM_CYCAPTION			= 4
SM_CXBORDER			= 5
SM_CYBORDER			= 6
SM_CXDLGFRAME			= 7
SM_CYDLGFRAME			= 8
SM_CYVTHUMB			= 9
SM_CXHTHUMB			= 10
SM_CXICON			= 11
SM_CYICON			= 12
SM_CXCURSOR			= 13
SM_CYCURSOR			= 14
SM_CYMENU			= 15
SM_CXFULLSCREEN 		= 16
SM_CYFULLSCREEN 		= 17
SM_CYKANJIWINDOW		= 18
SM_MOUSEPRESENT 		= 19
SM_CYVSCROLL			= 20
SM_CXHSCROLL			= 21
SM_DEBUG			= 22
SM_SWAPBUTTON			= 23
SM_RESERVED1			= 24
SM_RESERVED2			= 25
SM_RESERVED3			= 26
SM_RESERVED4			= 27
SM_CXMIN			= 28
SM_CYMIN			= 29
SM_CXSIZE			= 30
SM_CYSIZE			= 31
SM_CXFRAME			= 32
SM_CYFRAME			= 33
SM_CXMINTRACK			= 34
SM_CYMINTRACK			= 35
SM_CXDOUBLECLK			= 36
SM_CYDOUBLECLK			= 37
SM_CXICONSPACING		= 38
SM_CYICONSPACING		= 39
SM_MENUDROPALIGNMENT		= 40
SM_PENWINDOWS			= 41
SM_DBCSENABLED			= 42
SM_CMOUSEBUTTONS		= 43

SM_CXFIXEDFRAME 		= SM_CXDLGFRAME  ; ;win40 name change
SM_CYFIXEDFRAME 		= SM_CYDLGFRAME  ; ;win40 name change
SM_CXSIZEFRAME			= SM_CXFRAME	 ; ;win40 name change
SM_CYSIZEFRAME			= SM_CYFRAME	 ; ;win40 name change

SM_SECURE			= 44
SM_CXEDGE			= 45
SM_CYEDGE			= 46
SM_CXMINSPACING 		= 47
SM_CYMINSPACING 		= 48
SM_CXSMICON			= 49
SM_CYSMICON			= 50
SM_CYSMCAPTION			= 51
SM_CXSMSIZE			= 52
SM_CYSMSIZE			= 53
SM_CXMENUSIZE			= 54
SM_CYMENUSIZE			= 55
SM_ARRANGE			= 56
SM_CXMINIMIZED			= 57
SM_CYMINIMIZED			= 58
SM_CXMAXTRACK			= 59
SM_CYMAXTRACK			= 60
SM_CXMAXIMIZED			= 61
SM_CYMAXIMIZED			= 62
SM_NETWORK			= 63
SM_CLEANBOOT			= 67
SM_CXDRAG			= 68
SM_CYDRAG			= 69
SM_SHOWSOUNDS			= 70
SM_CXMENUCHECK			= 71   ; Use instead of GetMenuCheckMarkDimensions()!
SM_CYMENUCHECK			= 72
SM_SLOWMACHINE			= 73
SM_MIDEASTENABLED		= 74

SM_MOUSEWHEELPRESENT		= 75
SM_XVIRTUALSCREEN		= 76
SM_YVIRTUALSCREEN		= 77
SM_CXVIRTUALSCREEN		= 78
SM_CYVIRTUALSCREEN		= 79
SM_CMONITORS			= 80
SM_SAMEDISPLAYFORMAT		= 81

SM_CMETRICS			= 83

SM_REMOTESESSION		= 01000h

procdesc GetSystemMetrics :dword
procdesc LoadMenuA :dword, :dword
procdesc LoadMenuIndirectA :dword
procdesc GetMenu :dword
procdesc SetMenu :dword, :dword
procdesc ChangeMenuA :dword, :dword, :dword, :dword, :dword
procdesc HiliteMenuItem :dword, :dword, :dword, :dword
procdesc GetMenuStringA :dword, :dword, :dword, :dword, :dword
procdesc GetMenuState :dword, :dword, :dword
procdesc DrawMenuBar :dword
procdesc GetSystemMenu :dword, :dword
procdesc CreateMenu
procdesc CreatePopupMenu
procdesc DestroyMenu :dword
procdesc CheckMenuItem :dword, :dword, :dword
procdesc EnableMenuItem :dword, :dword, :dword
procdesc GetSubMenu :dword, :dword
procdesc GetMenuItemID :dword, :dword
procdesc GetMenuItemCount :dword
procdesc InsertMenuA :dword, :dword, :dword, :dword, :dword
procdesc AppendMenuA :dword, :dword, :dword, :dword
procdesc ModifyMenuA :dword, :dword, :dword, :dword, :dword
procdesc RemoveMenu :dword, :dword, :dword
procdesc DeleteMenu :dword, :dword, :dword
procdesc SetMenuItemBitmaps :dword, :dword, :dword, :dword, :dword
procdesc GetMenuCheckMarkDimensions
procdesc TrackPopupMenu :dword, :dword, :dword, :dword, :dword, :dword, :dword

LoadMenu			equ <LoadMenuA>
LoadMenuIndirect		equ <LoadMenuIndirectA>
ChangeMenu			equ <ChangeMenuA>
GetMenuString			equ <GetMenuStringA>
InsertMenu			equ <InsertMenuA>
AppendMenu			equ <AppendMenuA>
ModifyMenu			equ <ModifyMenuA>

; return codes for WM_MENUCHAR
MNC_IGNORE			= 0
MNC_CLOSE			= 1
MNC_EXECUTE			= 2
MNC_SELECT			= 3

struc	TPMPARAMS
	cbSize			dd ?		; Size of structure
	rcExclude		RECT ?		; Screen coordinates of rectangle to exclude when positioning
ends

procdesc TrackPopupMenuEx :dword, :dword, :dword, :dword, :dword, :dword

MNS_NOCHECK			= 080000000h
MNS_MODELESS			= 040000000h
MNS_DRAGDROP			= 020000000h
MNS_AUTODISMISS 		= 010000000h
MNS_NOTIFYBYPOS 		= 008000000h
MNS_CHECKORBMP			= 004000000h

MIM_MAXHEIGHT			= 000000001h
MIM_BACKGROUND			= 000000002h
MIM_HELPID			= 000000004h
MIM_MENUDATA			= 000000008h
MIM_STYLE			= 000000010h
MIM_APPLYTOSUBMENUS		= 080000000h

struc	MENUINFO
	cbSize			dd ?
	fMask			dd ?
	dwStyle 		dd ?
	cyMax			dd ?
	hbrBack 		dd ?
	dwContextHelpID 	dd ?
	dwMenuData		dd ?
ends

procdesc GetMenuInfo :dword, :dword
procdesc SetMenuInfo :dword, :dword
procdesc EndMenu

;
; WM_MENUDRAG return values.
;
MND_CONTINUE			= 0
MND_ENDMENU			= 1

struc	MENUGETOBJECTINFO
	dwFlags 		dd ?
	uPos			dd ?
	hmenu			dd ?
	riid			dd ?
	pvObj			dd ?
ends

;
; MENUGETOBJECTINFO dwFlags values
;
MNGOF_GAP			= 000000003h

;
; WM_MENUGETOBJECT return values
;
MNGO_NOINTERFACE		= 000000000h
MNGO_NOERROR			= 000000001h

MIIM_STATE			= 000000001h
MIIM_ID 			= 000000002h
MIIM_SUBMENU			= 000000004h
MIIM_CHECKMARKS 		= 000000008h
MIIM_TYPE			= 000000010h
MIIM_DATA			= 000000020h

MIIM_STRING			= 000000040h
MIIM_BITMAP			= 000000080h
MIIM_FTYPE			= 000000100h

HBMMENU_CALLBACK		= (-1)
HBMMENU_SYSTEM			= ( 1)
HBMMENU_MBAR_RESTORE		= ( 2)
HBMMENU_MBAR_MINIMIZE		= ( 3)
HBMMENU_MBAR_CLOSE		= ( 5)
HBMMENU_MBAR_CLOSE_D		= ( 6)
HBMMENU_MBAR_MINIMIZE_D 	= ( 7)
HBMMENU_POPUP_CLOSE		= ( 8)
HBMMENU_POPUP_RESTORE		= ( 9)
HBMMENU_POPUP_MAXIMIZE		= (10)
HBMMENU_POPUP_MINIMIZE		= (11)

struc	MENUITEMINFO
	cbSize			dd ?
	fMask			dd ?
	fType			dd ?		; used if MIIM_TYPE (4.0) or MIIM_FTYPE (>4.0)
	fState			dd ?		; used if MIIM_STATE
	wID			dd ?		; used if MIIM_ID
	hSubMenu		dd ?		; used if MIIM_SUBMENU
	hbmpChecked		dd ?		; used if MIIM_CHECKMARKS
	hbmpUnchecked		dd ?		; used if MIIM_CHECKMARKS
	dwItemData		dd ?		; used if MIIM_DATA
	dwTypeData		dd ?		; used if MIIM_TYPE (4.0) or MIIM_STRING (>4.0)
	cch			dd ?		; used if MIIM_TYPE (4.0) or MIIM_STRING (>4.0)
	hbmpItem		dd ?		; used if MIIM_BITMAP
ends

procdesc InsertMenuItemA :dword, :dword, :dword, :dword
procdesc GetMenuItemInfoA :dword, :dword, :dword, :dword
procdesc SetMenuItemInfoA :dword, :dword, :dword, :dword

InsertMenuItem			equ <InsertMenuItemA>
GetMenuItemInfo 		equ <GetMenuItemInfoA>
SetMenuItemInfo 		equ <SetMenuItemInfoA>

GMDI_USEDISABLED		= 00001h
GMDI_GOINTOPOPUPS		= 00002h

procdesc GetMenuDefaultItem :dword, :dword, :dword
procdesc SetMenuDefaultItem :dword, :dword, :dword
procdesc GetMenuItemRect :dword, :dword, :dword, :dword
procdesc MenuItemFromPoint :dword, :dword, :dword

;
; Flags for TrackPopupMenu
;
TPM_LEFTBUTTON			= 00000h
TPM_RIGHTBUTTON 		= 00002h
TPM_LEFTALIGN			= 00000h
TPM_CENTERALIGN 		= 00004h
TPM_RIGHTALIGN			= 00008h
TPM_TOPALIGN			= 00000h
TPM_VCENTERALIGN		= 00010h
TPM_BOTTOMALIGN 		= 00020h

TPM_HORIZONTAL			= 00000h     ; Horz alignment matters more
TPM_VERTICAL			= 00040h     ; Vert alignment matters more
TPM_NONOTIFY			= 00080h     ; Don't send any notification msgs
TPM_RETURNCMD			= 00100h
TPM_RECURSE			= 00001h
TPM_HORPOSANIMATION		= 00400h
TPM_HORNEGANIMATION		= 00800h
TPM_VERPOSANIMATION		= 01000h
TPM_VERNEGANIMATION		= 02000h
TPM_NOANIMATION 		= 04000h

;
; Drag-and-drop support
; Obsolete - use OLE instead
;

struc	DROPSTRUCT
	hwndSource		dd ?
	hwndSink		dd ?
	wFmt			dd ?
	dwData			dd ?
	ptDrop			POINT ?
	dwControlData		dd ?
ends

DOF_EXECUTABLE			= 08001h      ; wFmt flags
DOF_DOCUMENT			= 08002h
DOF_DIRECTORY			= 08003h
DOF_MULTIPLE			= 08004h
DOF_PROGMAN			= 00001h
DOF_SHELLDATA			= 00002h

DO_DROPFILE			= 0454C4946h
DO_PRINTFILE			= 0544E5250h

procdesc DragObject :dword, :dword, :dword, :dword, :dword
procdesc DragDetect :dword, :dword
procdesc DrawIcon :dword, :dword, :dword, :dword

;
; DrawText() Format Flags
;
DT_TOP				= 000000000h
DT_LEFT 			= 000000000h
DT_CENTER			= 000000001h
DT_RIGHT			= 000000002h
DT_VCENTER			= 000000004h
DT_BOTTOM			= 000000008h
DT_WORDBREAK			= 000000010h
DT_SINGLELINE			= 000000020h
DT_EXPANDTABS			= 000000040h
DT_TABSTOP			= 000000080h
DT_NOCLIP			= 000000100h
DT_EXTERNALLEADING		= 000000200h
DT_CALCRECT			= 000000400h
DT_NOPREFIX			= 000000800h
DT_INTERNAL			= 000001000h

DT_EDITCONTROL			= 000002000h
DT_PATH_ELLIPSIS		= 000004000h
DT_END_ELLIPSIS 		= 000008000h
DT_MODIFYSTRING 		= 000010000h
DT_RTLREADING			= 000020000h
DT_WORD_ELLIPSIS		= 000040000h
DT_NOFULLWIDTHCHARBREAK 	= 000080000h
DT_HIDEPREFIX			= 000100000h
DT_PREFIXONLY			= 000200000h

struc	DRAWTEXTPARAMS
	cbSize			dd ?
	iTabLength		dd ?
	iLeftMargin		dd ?
	iRightMargin		dd ?
	uiLengthDrawn		dd ?
ends

procdesc DrawTextA :dword, :dword, :dword, :dword, :dword
procdesc DrawTextExA :dword, :dword, :dword, :dword, :dword, :dword
procdesc GrayStringA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

DrawText			equ <DrawTextA>
DrawTextEx			equ <DrawTextExA>
GrayString			equ <GrayStringA>

; Monolithic state-drawing routine
; Image type
DST_COMPLEX			= 00000h
DST_TEXT			= 00001h
DST_PREFIXTEXT			= 00002h
DST_ICON			= 00003h
DST_BITMAP			= 00004h

; State type
DSS_NORMAL			= 00000h
DSS_UNION			= 00010h  ; Gray string appearance
DSS_DISABLED			= 00020h
DSS_MONO			= 00080h
DSS_HIDEPREFIX			= 00200h
DSS_PREFIXONLY			= 00400h
DSS_RIGHT			= 08000h

procdesc DrawStateA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc TabbedTextOutA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc GetTabbedTextExtentA :dword, :dword, :dword, :dword, :dword
procdesc UpdateWindow :dword
procdesc SetActiveWindow :dword
procdesc GetForegroundWindow
procdesc PaintDesktop :dword
procdesc SetForegroundWindow :dword
procdesc AllowSetForegroundWindow :dword

DrawState			equ <DrawStateA>
TabbedTextOut			equ <TabbedTextOutA>
GetTabbedTextExtent		equ <GetTabbedTextExtentA>

ASFW_ANY			= (-1)

procdesc LockSetForegroundWindow :dword

LSFW_LOCK			= 1
LSFW_UNLOCK			= 2

procdesc WindowFromDC :dword
procdesc GetDC :dword
procdesc GetDCEx :dword, :dword, :dword

;
; GetDCEx() flags
;
DCX_WINDOW			= 000000001h
DCX_CACHE			= 000000002h
DCX_NORESETATTRS		= 000000004h
DCX_CLIPCHILDREN		= 000000008h
DCX_CLIPSIBLINGS		= 000000010h
DCX_PARENTCLIP			= 000000020h

DCX_EXCLUDERGN			= 000000040h
DCX_INTERSECTRGN		= 000000080h

DCX_EXCLUDEUPDATE		= 000000100h
DCX_INTERSECTUPDATE		= 000000200h

DCX_LOCKWINDOWUPDATE		= 000000400h

DCX_VALIDATE			= 000200000h

procdesc GetWindowDC :dword
procdesc ReleaseDC :dword, :dword
procdesc BeginPaint :dword, :dword
procdesc EndPaint :dword, :dword
procdesc GetUpdateRect :dword, :dword, :dword
procdesc GetUpdateRgn :dword, :dword, :dword
procdesc SetWindowRgn :dword, :dword, :dword
procdesc GetWindowRgn :dword, :dword
procdesc ExcludeUpdateRgn :dword, :dword
procdesc InvalidateRect :dword, :dword, :dword
procdesc ValidateRect :dword, :dword
procdesc InvalidateRgn :dword, :dword, :dword
procdesc ValidateRgn :dword, :dword
procdesc RedrawWindow :dword, :dword, :dword, :dword

;
; RedrawWindow() flags
;
RDW_INVALIDATE			= 00001h
RDW_INTERNALPAINT		= 00002h
RDW_ERASE			= 00004h

RDW_VALIDATE			= 00008h
RDW_NOINTERNALPAINT		= 00010h
RDW_NOERASE			= 00020h

RDW_NOCHILDREN			= 00040h
RDW_ALLCHILDREN 		= 00080h

RDW_UPDATENOW			= 00100h
RDW_ERASENOW			= 00200h

RDW_FRAME			= 00400h
RDW_NOFRAME			= 00800h

;
; LockWindowUpdate API
;

procdesc LockWindowUpdate :dword
procdesc ScrollWindow :dword, :dword, :dword, :dword, :dword
procdesc ScrollDC :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc ScrollWindowEx :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword

SW_SCROLLCHILDREN		= 00001h  ; Scroll children within *lprcScroll.
SW_INVALIDATE			= 00002h  ; Invalidate after scrolling
SW_ERASE			= 00004h  ; If SW_INVALIDATE, don't send WM_ERASEBACKGROUND
SW_SMOOTHSCROLL 		= 00010h  ; Use smooth scrolling

procdesc SetScrollPos :dword, :dword, :dword, :dword
procdesc GetScrollPos :dword, :dword
procdesc SetScrollRange :dword, :dword, :dword, :dword, :dword
procdesc GetScrollRange :dword, :dword, :dword, :dword
procdesc ShowScrollBar :dword, :dword, :dword
procdesc EnableScrollBar :dword, :dword, :dword

;
; EnableScrollBar() flags
;
ESB_ENABLE_BOTH 		= 00000h
ESB_DISABLE_BOTH		= 00003h

ESB_DISABLE_LEFT		= 00001h
ESB_DISABLE_RIGHT		= 00002h

ESB_DISABLE_UP			= 00001h
ESB_DISABLE_DOWN		= 00002h

ESB_DISABLE_LTUP		= ESB_DISABLE_LEFT
ESB_DISABLE_RTDN		= ESB_DISABLE_RIGHT

procdesc SetPropA :dword, :dword, :dword
procdesc GetPropA :dword, :dword
procdesc RemovePropA :dword, :dword
procdesc EnumPropsExA :dword, :dword, :dword
procdesc EnumPropsA :dword, :dword
procdesc SetWindowTextA :dword, :dword
procdesc GetWindowTextA :dword, :dword, :dword
procdesc GetWindowTextLengthA :dword
procdesc GetClientRect :dword, :dword
procdesc GetWindowRect :dword, :dword
procdesc AdjustWindowRect :dword, :dword, :dword
procdesc AdjustWindowRectEx :dword, :dword, :dword, :dword

SetProp 			equ <SetPropA>
GetProp 			equ <GetPropA>
RemoveProp			equ <RemovePropA>
EnumPropsEx			equ <EnumPropsExA>
EnumProps			equ <EnumPropsA>
SetWindowText			equ <SetWindowTextA>
GetWindowText			equ <GetWindowTextA>
GetWindowTextLength		equ <GetWindowTextLengthA>

HELPINFO_WINDOW 		= 00001h
HELPINFO_MENUITEM		= 00002h

struc	HELPINFO
	cbSize			dd ?		; Size in bytes of this struct
	iContextType		dd ?		; Either HELPINFO_WINDOW or HELPINFO_MENUITEM
	iCtrlId 		dd ?		; Control Id or a Menu item Id.
	hItemHandle		dd ?		; hWnd of control or hMenu.
	dwContextId		dd ?		; Context Id associated with this item
	MousePos		POINT ? 	; Mouse Position in screen co-ordinates
ends

procdesc SetWindowContextHelpId :dword, :dword
procdesc GetWindowContextHelpId :dword
procdesc SetMenuContextHelpId :dword, :dword
procdesc GetMenuContextHelpId :dword

;
; MessageBox() Flags
;
MB_OK				= 000000000h
MB_OKCANCEL			= 000000001h
MB_ABORTRETRYIGNORE		= 000000002h
MB_YESNOCANCEL			= 000000003h
MB_YESNO			= 000000004h
MB_RETRYCANCEL			= 000000005h


MB_ICONHAND			= 000000010h
MB_ICONQUESTION 		= 000000020h
MB_ICONEXCLAMATION		= 000000030h
MB_ICONASTERISK 		= 000000040h

MB_USERICON			= 000000080h
MB_ICONWARNING			= MB_ICONEXCLAMATION
MB_ICONERROR			= MB_ICONHAND

MB_ICONINFORMATION		= MB_ICONASTERISK
MB_ICONSTOP			= MB_ICONHAND

MB_DEFBUTTON1			= 000000000h
MB_DEFBUTTON2			= 000000100h
MB_DEFBUTTON3			= 000000200h
MB_DEFBUTTON4			= 000000300h

MB_APPLMODAL			= 000000000h
MB_SYSTEMMODAL			= 000001000h
MB_TASKMODAL			= 000002000h
MB_HELP 			= 000004000h ; Help Button

MB_NOFOCUS			= 000008000h
MB_SETFOREGROUND		= 000010000h
MB_DEFAULT_DESKTOP_ONLY 	= 000020000h

MB_TOPMOST			= 000040000h
MB_RIGHT			= 000080000h
MB_RTLREADING			= 000100000h

if _WIN32_WINNT ge 0400h
MB_SERVICE_NOTIFICATION 	= 000200000h
else
MB_SERVICE_NOTIFICATION 	= 000040000h
endif

MB_TYPEMASK			= 00000000Fh
MB_ICONMASK			= 0000000F0h
MB_DEFMASK			= 000000F00h
MB_MODEMASK			= 000003000h
MB_MISCMASK			= 00000C000h

procdesc MessageBoxA :dword, :dword, :dword, :dword
procdesc MessageBoxExA :dword, :dword, :dword, :dword, :dword

MessageBox			equ <MessageBoxA>
MessageBoxEx			equ <MessageBoxExA>

proctype MSGBOXCALLBACK :dword

struc	MSGBOXPARAMS
	cbSize			dd ?
	hwndOwner		dd ?
	hInstance		dd ?
	lpszText		dd ?
	lpszCaption		dd ?
	dwStyle 		dd ?
	lpszIcon		dd ?
	dwContextHelpId 	dd ?
	lpfnMsgBoxCallback	dd ?
	dwLanguageId		dd ?
ends

procdesc MessageBoxIndirectA :dword
procdesc MessageBeep :dword
procdesc ShowCursor :dword
procdesc SetCursorPos :dword, :dword
procdesc SetCursor :dword
procdesc GetCursorPos :dword
procdesc ClipCursor :dword
procdesc GetClipCursor :dword
procdesc GetCursor
procdesc CreateCaret :dword, :dword, :dword, :dword
procdesc GetCaretBlinkTime
procdesc SetCaretBlinkTime :dword
procdesc DestroyCaret
procdesc HideCaret :dword
procdesc ShowCaret :dword
procdesc SetCaretPos :dword, :dword
procdesc GetCaretPos :dword
procdesc ClientToScreen :dword, :dword
procdesc ScreenToClient :dword, :dword
procdesc MapWindowPoints :dword, :dword, :dword, :dword
procdesc WindowFromPoint :dword
procdesc ChildWindowFromPoint :dword, :dword

MessageBoxIndirect		equ <MessageBoxIndirectA>

CWP_ALL 			= 00000h
CWP_SKIPINVISIBLE		= 00001h
CWP_SKIPDISABLED		= 00002h
CWP_SKIPTRANSPARENT		= 00004h

procdesc ChildWindowFromPointEx :dword, :dword, :dword

;
; Color Types
;
CTLCOLOR_MSGBOX 		= 0
CTLCOLOR_EDIT			= 1
CTLCOLOR_LISTBOX		= 2
CTLCOLOR_BTN			= 3
CTLCOLOR_DLG			= 4
CTLCOLOR_SCROLLBAR		= 5
CTLCOLOR_STATIC 		= 6
CTLCOLOR_MAX			= 7

COLOR_SCROLLBAR 		= 0
COLOR_BACKGROUND		= 1
COLOR_ACTIVECAPTION		= 2
COLOR_INACTIVECAPTION		= 3
COLOR_MENU			= 4
COLOR_WINDOW			= 5
COLOR_WINDOWFRAME		= 6
COLOR_MENUTEXT			= 7
COLOR_WINDOWTEXT		= 8
COLOR_CAPTIONTEXT		= 9
COLOR_ACTIVEBORDER		= 10
COLOR_INACTIVEBORDER		= 11
COLOR_APPWORKSPACE		= 12
COLOR_HIGHLIGHT 		= 13
COLOR_HIGHLIGHTTEXT		= 14
COLOR_BTNFACE			= 15
COLOR_BTNSHADOW 		= 16
COLOR_GRAYTEXT			= 17
COLOR_BTNTEXT			= 18
COLOR_INACTIVECAPTIONTEXT	= 19
COLOR_BTNHIGHLIGHT		= 20

COLOR_3DDKSHADOW		= 21
COLOR_3DLIGHT			= 22
COLOR_INFOTEXT			= 23
COLOR_INFOBK			= 24

COLOR_HOTLIGHT			= 26
COLOR_GRADIENTACTIVECAPTION	= 27
COLOR_GRADIENTINACTIVECAPTION	= 28

COLOR_DESKTOP			= COLOR_BACKGROUND
COLOR_3DFACE			= COLOR_BTNFACE
COLOR_3DSHADOW			= COLOR_BTNSHADOW
COLOR_3DHIGHLIGHT		= COLOR_BTNHIGHLIGHT
COLOR_3DHILIGHT 		= COLOR_BTNHIGHLIGHT
COLOR_BTNHILIGHT		= COLOR_BTNHIGHLIGHT

procdesc GetSysColor :dword
procdesc GetSysColorBrush :dword
procdesc SetSysColors :dword, :dword, :dword
procdesc DrawFocusRect :dword, :dword
procdesc FillRect :dword, :dword, :dword
procdesc FrameRect :dword, :dword, :dword
procdesc InvertRect :dword, :dword
procdesc SetRect :dword, :dword, :dword, :dword, :dword
procdesc SetRectEmpty :dword
procdesc CopyRect :dword, :dword
procdesc InflateRect :dword, :dword, :dword
procdesc IntersectRect :dword, :dword, :dword
procdesc UnionRect :dword, :dword, :dword
procdesc SubtractRect :dword, :dword, :dword
procdesc OffsetRect :dword, :dword, :dword
procdesc IsRectEmpty :dword
procdesc EqualRect :dword, :dword
procdesc PtInRect :dword, :dword
procdesc GetWindowWord :dword, :dword
procdesc SetWindowWord :dword, :dword, :dword
procdesc GetWindowLongA :dword, :dword
procdesc SetWindowLongA :dword, :dword, :dword
procdesc GetClassWord :dword, :dword
procdesc SetClassWord :dword, :dword, :dword
procdesc GetClassLongA :dword, :dword
procdesc SetClassLongA :dword, :dword, :dword
procdesc GetProcessDefaultLayout :dword
procdesc SetProcessDefaultLayout :dword
procdesc GetDesktopWindow
procdesc GetParent :dword
procdesc SetParent :dword, :dword
procdesc EnumChildWindows :dword, :dword, :dword
procdesc FindWindowA :dword, :dword
procdesc FindWindowExA :dword, :dword, :dword, :dword
procdesc EnumWindows :dword, :dword
procdesc EnumThreadWindows :dword, :dword, :dword
procdesc GetClassNameA :dword, :dword, :dword
procdesc GetTopWindow :dword
procdesc GetWindowThreadProcessId :dword, :dword
procdesc GetLastActivePopup :dword

GetWindowLong			equ <GetWindowLongA>
SetWindowLong			equ <SetWindowLongA>
GetWindowLongPtr		equ <GetWindowLongPtrA>
SetWindowLongPtr		equ <SetWindowLongPtrA>
GetClassLong			equ <GetClassLongA>
SetClassLong			equ <SetClassLongA>
GetClassLongPtr 		equ <GetClassLongPtrA>
SetClassLongPtr 		equ <SetClassLongPtrA>
FindWindow			equ <FindWindowA>
FindWindowEx			equ <FindWindowExA>
EnumTaskWindows 		equ <EnumThreadWindows>
GetClassName			equ <GetClassNameA>

;
; GetWindow() Constants
;
GW_HWNDFIRST			= 0
GW_HWNDLAST			= 1
GW_HWNDNEXT			= 2
GW_HWNDPREV			= 3
GW_OWNER			= 4
GW_CHILD			= 5
GW_ENABLEDPOPUP 		= 6
GW_MAX				= 6

procdesc GetWindow :dword, :dword
procdesc SetWindowsHookA :dword, :dword
procdesc UnhookWindowsHook :dword, :dword
procdesc SetWindowsHookExA :dword, :dword, :dword, :dword
procdesc UnhookWindowsHookEx :dword
procdesc CallNextHookEx :dword, :dword, :dword, :dword

SetWindowsHook			equ <SetWindowsHookA>
SetWindowsHookEx		equ <SetWindowsHookExA>

; win40  -- A lot of MF_* flags have been renamed as MFT_* and MFS_* flags
;
; Menu flags for Add/Check/EnableMenuItem()
;
MF_INSERT			= 000000000h
MF_CHANGE			= 000000080h
MF_APPEND			= 000000100h
MF_DELETE			= 000000200h
MF_REMOVE			= 000001000h

MF_BYCOMMAND			= 000000000h
MF_BYPOSITION			= 000000400h

MF_SEPARATOR			= 000000800h

MF_ENABLED			= 000000000h
MF_GRAYED			= 000000001h
MF_DISABLED			= 000000002h

MF_UNCHECKED			= 000000000h
MF_CHECKED			= 000000008h
MF_USECHECKBITMAPS		= 000000200h

MF_STRING			= 000000000h
MF_BITMAP			= 000000004h
MF_OWNERDRAW			= 000000100h

MF_POPUP			= 000000010h
MF_MENUBARBREAK 		= 000000020h
MF_MENUBREAK			= 000000040h

MF_UNHILITE			= 000000000h
MF_HILITE			= 000000080h

MF_DEFAULT			= 000001000h
MF_SYSMENU			= 000002000h
MF_HELP 			= 000004000h
MF_RIGHTJUSTIFY 		= 000004000h

MF_MOUSESELECT			= 000008000h
MF_END				= 000000080h  ; Obsolete -- only used by old RES files

MFT_STRING			= MF_STRING
MFT_BITMAP			= MF_BITMAP
MFT_MENUBARBREAK		= MF_MENUBARBREAK
MFT_MENUBREAK			= MF_MENUBREAK
MFT_OWNERDRAW			= MF_OWNERDRAW
MFT_RADIOCHECK			= 000000200h
MFT_SEPARATOR			= MF_SEPARATOR
MFT_RIGHTORDER			= 000002000h
MFT_RIGHTJUSTIFY		= MF_RIGHTJUSTIFY

; Menu flags for Add/Check/EnableMenuItem()
MFS_GRAYED			= 000000003h
MFS_DISABLED			= MFS_GRAYED
MFS_CHECKED			= MF_CHECKED
MFS_HILITE			= MF_HILITE
MFS_ENABLED			= MF_ENABLED
MFS_UNCHECKED			= MF_UNCHECKED
MFS_UNHILITE			= MF_UNHILITE
MFS_DEFAULT			= MF_DEFAULT

procdesc CheckMenuRadioItem :dword, :dword, :dword, :dword, :dword

;
; Menu item resource format
;

struc	MENUITEMTEMPLATEHEADER
	versionNumber		dw ?
	_offset 		dw ?
ends

struc	MENUITEMTEMPLATE			; version 0
	mtOption		dw ?
	mtID			dw ?
label	mtString		byte
ends

MF_END				= 000000080h

;
; System Menu Command Values
;
SC_SIZE 			= 0F000h
SC_MOVE 			= 0F010h
SC_MINIMIZE			= 0F020h
SC_MAXIMIZE			= 0F030h
SC_NEXTWINDOW			= 0F040h
SC_PREVWINDOW			= 0F050h
SC_CLOSE			= 0F060h
SC_VSCROLL			= 0F070h
SC_HSCROLL			= 0F080h
SC_MOUSEMENU			= 0F090h
SC_KEYMENU			= 0F100h
SC_ARRANGE			= 0F110h
SC_RESTORE			= 0F120h
SC_TASKLIST			= 0F130h
SC_SCREENSAVE			= 0F140h
SC_HOTKEY			= 0F150h
SC_DEFAULT			= 0F160h
SC_MONITORPOWER 		= 0F170h
SC_CONTEXTHELP			= 0F180h
SC_SEPARATOR			= 0F00Fh

;
; Obsolete names
;
SC_ICON 			= SC_MINIMIZE
SC_ZOOM 			= SC_MAXIMIZE

;
; Resource Loading Routines
;

procdesc LoadBitmapA :dword, :dword
procdesc LoadCursorA :dword, :dword
procdesc LoadCursorFromFileA :dword
procdesc CreateCursor :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc DestroyCursor :dword

LoadBitmap			equ <LoadBitmapA>
LoadCursor			equ <LoadCursorA>
LoadCursorFromFile		equ <LoadCursorFromFileA>

;
; Standard Cursor IDs
;
IDC_ARROW			= 32512
IDC_IBEAM			= 32513
IDC_WAIT			= 32514
IDC_CROSS			= 32515
IDC_UPARROW			= 32516
IDC_SIZE			= 32640  ; OBSOLETE: use IDC_SIZEALL
IDC_ICON			= 32641  ; OBSOLETE: use IDC_ARROW
IDC_SIZENWSE			= 32642
IDC_SIZENESW			= 32643
IDC_SIZEWE			= 32644
IDC_SIZENS			= 32645
IDC_SIZEALL			= 32646
IDC_NO				= 32648 ;not in win3.1
IDC_HAND			= 32649
IDC_APPSTARTING 		= 32650 ;not in win3.1
IDC_HELP			= 32651

procdesc SetSystemCursor :dword, :dword

struc	ICONINFO
	fIcon			dd ?
	xHotspot		dd ?
	yHotspot		dd ?
	hbmMask 		dd ?
	hbmColor		dd ?
ends

procdesc LoadIconA :dword, :dword
procdesc CreateIcon :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc DestroyIcon :dword
procdesc LookupIconIdFromDirectory :dword, :dword
procdesc LookupIconIdFromDirectoryEx :dword, :dword, :dword, :dword, :dword
procdesc CreateIconFromResource :dword, :dword, :dword, :dword
procdesc CreateIconFromResourceEx :dword, :dword, :dword, :dword, :dword, :dword, :dword

LoadIcon			equ <LoadIconA>

; Icon/Cursor header

struc	CURSORSHAPE
	xHotSpot		dd ?
	yHotSpot		dd ?
	cx			dd ?
	cy			dd ?
	cbWidth 		dd ?
	Planes			db ?
	BitsPixel		db ?
ends

IMAGE_BITMAP			= 0
IMAGE_ICON			= 1
IMAGE_CURSOR			= 2
IMAGE_ENHMETAFILE		= 3

LR_DEFAULTCOLOR 		= 00000h
LR_MONOCHROME			= 00001h
LR_COLOR			= 00002h
LR_COPYRETURNORG		= 00004h
LR_COPYDELETEORG		= 00008h
LR_LOADFROMFILE 		= 00010h
LR_LOADTRANSPARENT		= 00020h
LR_DEFAULTSIZE			= 00040h
LR_VGACOLOR			= 00080h
LR_LOADMAP3DCOLORS		= 01000h
LR_CREATEDIBSECTION		= 02000h
LR_COPYFROMRESOURCE		= 04000h
LR_SHARED			= 08000h

procdesc LoadImageA :dword, :dword, :dword, :dword, :dword, :dword
procdesc CopyImage :dword, :dword, :dword, :dword, :dword

LoadImage			equ <LoadImageA>

DI_MASK 			= 00001h
DI_IMAGE			= 00002h
DI_NORMAL			= 00003h
DI_COMPAT			= 00004h
DI_DEFAULTSIZE			= 00008h

procdesc DrawIconEx :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc CreateIconIndirect :dword
procdesc CopyIcon :dword
procdesc GetIconInfo :dword, :dword

CopyCursor			equ <CopyIcon>

RES_ICON			= 1
RES_CURSOR			= 2

;
; OEM Resource Ordinal Numbers
;
OBM_CLOSE			= 32754
OBM_UPARROW			= 32753
OBM_DNARROW			= 32752
OBM_RGARROW			= 32751
OBM_LFARROW			= 32750
OBM_REDUCE			= 32749
OBM_ZOOM			= 32748
OBM_RESTORE			= 32747
OBM_REDUCED			= 32746
OBM_ZOOMD			= 32745
OBM_RESTORED			= 32744
OBM_UPARROWD			= 32743
OBM_DNARROWD			= 32742
OBM_RGARROWD			= 32741
OBM_LFARROWD			= 32740
OBM_MNARROW			= 32739
OBM_COMBO			= 32738
OBM_UPARROWI			= 32737
OBM_DNARROWI			= 32736
OBM_RGARROWI			= 32735
OBM_LFARROWI			= 32734

OBM_OLD_CLOSE			= 32767
OBM_SIZE			= 32766
OBM_OLD_UPARROW 		= 32765
OBM_OLD_DNARROW 		= 32764
OBM_OLD_RGARROW 		= 32763
OBM_OLD_LFARROW 		= 32762
OBM_BTSIZE			= 32761
OBM_CHECK			= 32760
OBM_CHECKBOXES			= 32759
OBM_BTNCORNERS			= 32758
OBM_OLD_REDUCE			= 32757
OBM_OLD_ZOOM			= 32756
OBM_OLD_RESTORE 		= 32755

OCR_NORMAL			= 32512
OCR_IBEAM			= 32513
OCR_WAIT			= 32514
OCR_CROSS			= 32515
OCR_UP				= 32516
OCR_SIZE			= 32640   ; OBSOLETE: use OCR_SIZEALL
OCR_ICON			= 32641   ; OBSOLETE: use OCR_NORMAL
OCR_SIZENWSE			= 32642
OCR_SIZENESW			= 32643
OCR_SIZEWE			= 32644
OCR_SIZENS			= 32645
OCR_SIZEALL			= 32646
OCR_ICOCUR			= 32647   ; OBSOLETE: use OIC_WINLOGO
OCR_NO				= 32648
OCR_HAND			= 32649
OCR_APPSTARTING 		= 32650

OIC_SAMPLE			= 32512
OIC_HAND			= 32513
OIC_QUES			= 32514
OIC_BANG			= 32515
OIC_NOTE			= 32516
OIC_WINLOGO			= 32517
OIC_WARNING			= OIC_BANG
OIC_ERROR			= OIC_HAND
OIC_INFORMATION 		= OIC_NOTE

ORD_LANGDRIVER			= 1	; The ordinal number for the entry point of
					; language drivers.

;
; Standard Icon IDs
;
IDI_APPLICATION 		= 32512
IDI_HAND			= 32513
IDI_QUESTION			= 32514
IDI_EXCLAMATION 		= 32515
IDI_ASTERISK			= 32516
IDI_WINLOGO			= 32517

IDI_WARNING			= IDI_EXCLAMATION
IDI_ERROR			= IDI_HAND
IDI_INFORMATION 		= IDI_ASTERISK

procdesc LoadStringA :dword, :dword, :dword, :dword

LoadString			equ <LoadStringA>

;
; Dialog Box Command IDs
;
IDOK				= 1
IDCANCEL			= 2
IDABORT 			= 3
IDRETRY 			= 4
IDIGNORE			= 5
IDYES				= 6
IDNO				= 7
IDCLOSE 			= 8
IDHELP				= 9

;
; Control Manager Structures and Definitions
;

;
; Edit Control Styles
;
ES_LEFT 			= 00000h
ES_CENTER			= 00001h
ES_RIGHT			= 00002h
ES_MULTILINE			= 00004h
ES_UPPERCASE			= 00008h
ES_LOWERCASE			= 00010h
ES_PASSWORD			= 00020h
ES_AUTOVSCROLL			= 00040h
ES_AUTOHSCROLL			= 00080h
ES_NOHIDESEL			= 00100h
ES_OEMCONVERT			= 00400h
ES_READONLY			= 00800h
ES_WANTRETURN			= 01000h
ES_NUMBER			= 02000h

;
; Edit Control Notification Codes
;
EN_SETFOCUS			= 00100h
EN_KILLFOCUS			= 00200h
EN_CHANGE			= 00300h
EN_UPDATE			= 00400h
EN_ERRSPACE			= 00500h
EN_MAXTEXT			= 00501h
EN_HSCROLL			= 00601h
EN_VSCROLL			= 00602h

EN_ALIGN_LTR_EC 		= 00700h
EN_ALIGN_RTL_EC 		= 00701h

; Edit control EM_SETMARGIN parameters
EC_LEFTMARGIN			= 00001h
EC_RIGHTMARGIN			= 00002h
EC_USEFONTINFO			= 0fffh

; wParam of EM_GET/SETIMESTATUS
EMSIS_COMPOSITIONSTRING 	= 00001h

; lParam for EMSIS_COMPOSITIONSTRING
EIMES_GETCOMPSTRATONCE		= 00001h
EIMES_CANCELCOMPSTRINFOCUS	= 00002h
EIMES_COMPLETECOMPSTRKILLFOCUS	= 00004h

;
; Edit Control Messages
;
EM_GETSEL			= 000B0h
EM_SETSEL			= 000B1h
EM_GETRECT			= 000B2h
EM_SETRECT			= 000B3h
EM_SETRECTNP			= 000B4h
EM_SCROLL			= 000B5h
EM_LINESCROLL			= 000B6h
EM_SCROLLCARET			= 000B7h
EM_GETMODIFY			= 000B8h
EM_SETMODIFY			= 000B9h
EM_GETLINECOUNT 		= 000BAh
EM_LINEINDEX			= 000BBh
EM_SETHANDLE			= 000BCh
EM_GETHANDLE			= 000BDh
EM_GETTHUMB			= 000BEh
EM_LINELENGTH			= 000C1h
EM_REPLACESEL			= 000C2h
EM_GETLINE			= 000C4h
EM_LIMITTEXT			= 000C5h
EM_CANUNDO			= 000C6h
EM_UNDO 			= 000C7h
EM_FMTLINES			= 000C8h
EM_LINEFROMCHAR 		= 000C9h
EM_SETTABSTOPS			= 000CBh
EM_SETPASSWORDCHAR		= 000CCh
EM_EMPTYUNDOBUFFER		= 000CDh
EM_GETFIRSTVISIBLELINE		= 000CEh
EM_SETREADONLY			= 000CFh
EM_SETWORDBREAKPROC		= 000D0h
EM_GETWORDBREAKPROC		= 000D1h
EM_GETPASSWORDCHAR		= 000D2h
EM_SETMARGINS			= 000D3h
EM_GETMARGINS			= 000D4h
EM_SETLIMITTEXT 		= EM_LIMITTEXT	 ; ;win40 Name change
EM_GETLIMITTEXT 		= 000D5h
EM_POSFROMCHAR			= 000D6h
EM_CHARFROMPOS			= 000D7h

EM_SETIMESTATUS 		= 000D8h
EM_GETIMESTATUS 		= 000D9h

;
; EDITWORDBREAKPROC code values
;
WB_LEFT 			= 0
WB_RIGHT			= 1
WB_ISDELIMITER			= 2

;
; Button Control Styles
;
BS_PUSHBUTTON			= 000000000h
BS_DEFPUSHBUTTON		= 000000001h
BS_CHECKBOX			= 000000002h
BS_AUTOCHECKBOX 		= 000000003h
BS_RADIOBUTTON			= 000000004h
BS_3STATE			= 000000005h
BS_AUTO3STATE			= 000000006h
BS_GROUPBOX			= 000000007h
BS_USERBUTTON			= 000000008h
BS_AUTORADIOBUTTON		= 000000009h
BS_OWNERDRAW			= 00000000Bh
BS_LEFTTEXT			= 000000020h
BS_TEXT 			= 000000000h
BS_ICON 			= 000000040h
BS_BITMAP			= 000000080h
BS_LEFT 			= 000000100h
BS_RIGHT			= 000000200h
BS_CENTER			= 000000300h
BS_TOP				= 000000400h
BS_BOTTOM			= 000000800h
BS_VCENTER			= 000000C00h
BS_PUSHLIKE			= 000001000h
BS_MULTILINE			= 000002000h
BS_NOTIFY			= 000004000h
BS_FLAT 			= 000008000h
BS_RIGHTBUTTON			= BS_LEFTTEXT

;
; User Button Notification Codes
;
BN_CLICKED			= 0
BN_PAINT			= 1
BN_HILITE			= 2
BN_UNHILITE			= 3
BN_DISABLE			= 4
BN_DOUBLECLICKED		= 5
BN_PUSHED			= BN_HILITE
BN_UNPUSHED			= BN_UNHILITE
BN_DBLCLK			= BN_DOUBLECLICKED
BN_SETFOCUS			= 6
BN_KILLFOCUS			= 7

;
; Button Control Messages
;
BM_GETCHECK			= 000F0h
BM_SETCHECK			= 000F1h
BM_GETSTATE			= 000F2h
BM_SETSTATE			= 000F3h
BM_SETSTYLE			= 000F4h
BM_CLICK			= 000F5h
BM_GETIMAGE			= 000F6h
BM_SETIMAGE			= 000F7h

BST_UNCHECKED			= 00000h
BST_CHECKED			= 00001h
BST_INDETERMINATE		= 00002h
BST_PUSHED			= 00004h
BST_FOCUS			= 00008h

;
; Static Control Constants
;
SS_LEFT 			= 000000000h
SS_CENTER			= 000000001h
SS_RIGHT			= 000000002h
SS_ICON 			= 000000003h
SS_BLACKRECT			= 000000004h
SS_GRAYRECT			= 000000005h
SS_WHITERECT			= 000000006h
SS_BLACKFRAME			= 000000007h
SS_GRAYFRAME			= 000000008h
SS_WHITEFRAME			= 000000009h
SS_USERITEM			= 00000000Ah
SS_SIMPLE			= 00000000Bh
SS_LEFTNOWORDWRAP		= 00000000Ch
SS_OWNERDRAW			= 00000000Dh
SS_BITMAP			= 00000000Eh
SS_ENHMETAFILE			= 00000000Fh
SS_ETCHEDHORZ			= 000000010h
SS_ETCHEDVERT			= 000000011h
SS_ETCHEDFRAME			= 000000012h
SS_TYPEMASK			= 00000001Fh
SS_NOPREFIX			= 000000080h ; Don't do "&" character translation
SS_NOTIFY			= 000000100h
SS_CENTERIMAGE			= 000000200h
SS_RIGHTJUST			= 000000400h
SS_REALSIZEIMAGE		= 000000800h
SS_SUNKEN			= 000001000h
SS_ENDELLIPSIS			= 000004000h
SS_PATHELLIPSIS 		= 000008000h
SS_WORDELLIPSIS 		= 00000C000h
SS_ELLIPSISMASK 		= 00000C000h

;
; Static Control Mesages
;
STM_SETICON			= 00170h
STM_GETICON			= 00171h
STM_SETIMAGE			= 00172h
STM_GETIMAGE			= 00173h
STN_CLICKED			= 0
STN_DBLCLK			= 1
STN_ENABLE			= 2
STN_DISABLE			= 3
STM_MSGMAX			= 00174h

;
; Dialog window class
;
WC_DIALOG			= 08002h

;
; Get/SetWindowWord/Long offsets for use with WC_DIALOG windows
;
DWL_MSGRESULT			= 0
DWL_DLGPROC			= 4
DWL_USER			= 8

DWLP_MSGRESULT			= 0
DWLP_DLGPROC			= DWLP_MSGRESULT + 4
DWLP_USER			= DWLP_DLGPROC + 4

procdesc IsDialogMessageA :dword, :dword
procdesc MapDialogRect :dword, :dword
procdesc DlgDirListA :dword, :dword, :dword, :dword, :dword

IsDialogMessage 		equ <IsDialogMessageA>
DlgDirList			equ <DlgDirListA>

;
; DlgDirList, DlgDirListComboBox flags values
;
DDL_READWRITE			= 00000h
DDL_READONLY			= 00001h
DDL_HIDDEN			= 00002h
DDL_SYSTEM			= 00004h
DDL_DIRECTORY			= 00010h
DDL_ARCHIVE			= 00020h

DDL_POSTMSGS			= 02000h
DDL_DRIVES			= 04000h
DDL_EXCLUSIVE			= 08000h

procdesc DlgDirSelectExA :dword, :dword, :dword, :dword
procdesc DlgDirListComboBoxA :dword, :dword, :dword, :dword, :dword
procdesc DlgDirSelectComboBoxExA :dword, :dword, :dword, :dword

DlgDirSelectEx			equ <DlgDirSelectExA>
DlgDirListComboBox		equ <DlgDirListComboBoxA>
DlgDirSelectComboBoxEx		equ <DlgDirSelectComboBoxExA>

;
; Dialog Styles
;
DS_ABSALIGN			= 001h
DS_SYSMODAL			= 002h
DS_LOCALEDIT			= 020h	 ; Edit items get Local storage.
DS_SETFONT			= 040h	 ; User specified font for Dlg controls
DS_MODALFRAME			= 080h	 ; Can be combined with WS_CAPTION
DS_NOIDLEMSG			= 0100h  ; WM_ENTERIDLE message will not be sent
DS_SETFOREGROUND		= 0200h  ; not in win3.1

DS_3DLOOK			= 00004h
DS_FIXEDSYS			= 00008h
DS_NOFAILCREATE 		= 00010h
DS_CONTROL			= 00400h
DS_CENTER			= 00800h
DS_CENTERMOUSE			= 01000h
DS_CONTEXTHELP			= 02000h

DM_GETDEFID			= (WM_USER+0)
DM_SETDEFID			= (WM_USER+1)

DM_REPOSITION			= (WM_USER+2)
;
; Returned in HIWORD() of DM_GETDEFID result if msg is supported
;
DC_HASDEFID			= 0534Bh

;
; Dialog Codes
;
DLGC_WANTARROWS 		= 00001h      ; Control wants arrow keys
DLGC_WANTTAB			= 00002h      ; Control wants tab keys
DLGC_WANTALLKEYS		= 00004h      ; Control wants all keys
DLGC_WANTMESSAGE		= 00004h      ; Pass message to control
DLGC_HASSETSEL			= 00008h      ; Understands EM_SETSEL message
DLGC_DEFPUSHBUTTON		= 00010h      ; Default pushbutton
DLGC_UNDEFPUSHBUTTON		= 00020h     ; Non-default pushbutton
DLGC_RADIOBUTTON		= 00040h      ; Radio button
DLGC_WANTCHARS			= 00080h      ; Want WM_CHAR messages
DLGC_STATIC			= 00100h      ; Static item: don't include
DLGC_BUTTON			= 02000h      ; Button item: can be checked

LB_CTLCODE			= 0

;
; Listbox Return Values
;
LB_OKAY 			= 0
LB_ERR				= (-1)
LB_ERRSPACE			= (-2)

;
;  The idStaticPath parameter to DlgDirList can have the following values
;  ORed if the list box should show other details of the files along with
;  the name of the files;
;
				  ; all other details also will be returned
;
; Listbox Notification Codes
;
LBN_ERRSPACE			= (-2)
LBN_SELCHANGE			= 1
LBN_DBLCLK			= 2
LBN_SELCANCEL			= 3
LBN_SETFOCUS			= 4
LBN_KILLFOCUS			= 5

;
; Listbox messages
;
LB_ADDSTRING			= 00180h
LB_INSERTSTRING 		= 00181h
LB_DELETESTRING 		= 00182h
LB_SELITEMRANGEEX		= 00183h
LB_RESETCONTENT 		= 00184h
LB_SETSEL			= 00185h
LB_SETCURSEL			= 00186h
LB_GETSEL			= 00187h
LB_GETCURSEL			= 00188h
LB_GETTEXT			= 00189h
LB_GETTEXTLEN			= 0018Ah
LB_GETCOUNT			= 0018Bh
LB_SELECTSTRING 		= 0018Ch
LB_DIR				= 0018Dh
LB_GETTOPINDEX			= 0018Eh
LB_FINDSTRING			= 0018Fh
LB_GETSELCOUNT			= 00190h
LB_GETSELITEMS			= 00191h
LB_SETTABSTOPS			= 00192h
LB_GETHORIZONTALEXTENT		= 00193h
LB_SETHORIZONTALEXTENT		= 00194h
LB_SETCOLUMNWIDTH		= 00195h
LB_ADDFILE			= 00196h
LB_SETTOPINDEX			= 00197h
LB_GETITEMRECT			= 00198h
LB_GETITEMDATA			= 00199h
LB_SETITEMDATA			= 0019Ah
LB_SELITEMRANGE 		= 0019Bh
LB_SETANCHORINDEX		= 0019Ch
LB_GETANCHORINDEX		= 0019Dh
LB_SETCARETINDEX		= 0019Eh
LB_GETCARETINDEX		= 0019Fh
LB_SETITEMHEIGHT		= 001A0h
LB_GETITEMHEIGHT		= 001A1h
LB_FINDSTRINGEXACT		= 001A2h
LB_SETLOCALE			= 001A5h
LB_GETLOCALE			= 001A6h
LB_SETCOUNT			= 001A7h
LB_INITSTORAGE			= 001A8h
LB_ITEMFROMPOINT		= 001A9h
LB_MSGMAX			= 001B0h

;
; Listbox Styles
;
LBS_NOTIFY			= 00001h
LBS_SORT			= 00002h
LBS_NOREDRAW			= 00004h
LBS_MULTIPLESEL 		= 00008h
LBS_OWNERDRAWFIXED		= 00010h
LBS_OWNERDRAWVARIABLE		= 00020h
LBS_HASSTRINGS			= 00040h
LBS_USETABSTOPS 		= 00080h
LBS_NOINTEGRALHEIGHT		= 00100h
LBS_MULTICOLUMN 		= 00200h
LBS_WANTKEYBOARDINPUT		= 00400h
LBS_EXTENDEDSEL 		= 00800h
LBS_DISABLENOSCROLL		= 01000h
LBS_NODATA			= 02000h
LBS_NOSEL			= 04000h
LBS_STANDARD			= (LBS_NOTIFY + LBS_SORT + WS_VSCROLL + WS_BORDER)

;
; Combo Box return Values
;
CB_OKAY 			= 0
CB_ERR				= (-1)
CB_ERRSPACE			= (-2)

;
; Combo Box Notification Codes
;
CBN_ERRSPACE			= (-1)
CBN_SELCHANGE			= 1
CBN_DBLCLK			= 2
CBN_SETFOCUS			= 3
CBN_KILLFOCUS			= 4
CBN_EDITCHANGE			= 5
CBN_EDITUPDATE			= 6
CBN_DROPDOWN			= 7
CBN_CLOSEUP			= 8
CBN_SELENDOK			= 9
CBN_SELENDCANCEL		= 10

;
; Combo Box styles
;
CBS_SIMPLE			= 00001h
CBS_DROPDOWN			= 00002h
CBS_DROPDOWNLIST		= 00003h
CBS_OWNERDRAWFIXED		= 00010h
CBS_OWNERDRAWVARIABLE		= 00020h
CBS_AUTOHSCROLL 		= 00040h
CBS_OEMCONVERT			= 00080h
CBS_SORT			= 00100h
CBS_HASSTRINGS			= 00200h
CBS_NOINTEGRALHEIGHT		= 00400h
CBS_DISABLENOSCROLL		= 00800h
CBS_UPPERCASE			= 02000h
CBS_LOWERCASE			= 04000h

;
; Combo Box messages
;
CB_GETEDITSEL			= 00140h
CB_LIMITTEXT			= 00141h
CB_SETEDITSEL			= 00142h
CB_ADDSTRING			= 00143h
CB_DELETESTRING 		= 00144h
CB_DIR				= 00145h
CB_GETCOUNT			= 00146h
CB_GETCURSEL			= 00147h
CB_GETLBTEXT			= 00148h
CB_GETLBTEXTLEN 		= 00149h
CB_INSERTSTRING 		= 0014Ah
CB_RESETCONTENT 		= 0014Bh
CB_FINDSTRING			= 0014Ch
CB_SELECTSTRING 		= 0014Dh
CB_SETCURSEL			= 0014Eh
CB_SHOWDROPDOWN 		= 0014Fh
CB_GETITEMDATA			= 00150h
CB_SETITEMDATA			= 00151h
CB_GETDROPPEDCONTROLRECT	= 00152h
CB_SETITEMHEIGHT		= 00153h
CB_GETITEMHEIGHT		= 00154h
CB_SETEXTENDEDUI		= 00155h
CB_GETEXTENDEDUI		= 00156h
CB_GETDROPPEDSTATE		= 00157h
CB_FINDSTRINGEXACT		= 00158h
CB_SETLOCALE			= 00159h
CB_GETLOCALE			= 0015Ah
CB_GETTOPINDEX			= 0015h
CB_SETTOPINDEX			= 0015h
CB_GETHORIZONTALEXTENT		= 0015h
CB_SETHORIZONTALEXTENT		= 0015h
CB_GETDROPPEDWIDTH		= 0015h
CB_SETDROPPEDWIDTH		= 00160h
CB_INITSTORAGE			= 00161h
CB_MSGMAX			= 00162h

;
; Scroll Bar Styles
;
SBS_HORZ			= 00000h
SBS_VERT			= 00001h
SBS_TOPALIGN			= 00002h
SBS_LEFTALIGN			= 00002h
SBS_BOTTOMALIGN 		= 00004h
SBS_RIGHTALIGN			= 00004h
SBS_SIZEBOXTOPLEFTALIGN 	= 00002h
SBS_SIZEBOXBOTTOMRIGHTALIGN	= 00004h
SBS_SIZEBOX			= 00008h
SBS_SIZEGRIP			= 00010h

;
; Scroll bar messages
;
SBM_SETPOS			= 000E0h ;not in win3.1
SBM_GETPOS			= 000E1h ;not in win3.1
SBM_SETRANGE			= 000E2h ;not in win3.1
SBM_SETRANGEREDRAW		= 000E6h ;not in win3.1
SBM_GETRANGE			= 000E3h ;not in win3.1
SBM_ENABLE_ARROWS		= 000E4h ;not in win3.1
SBM_SETSCROLLINFO		= 000E9h
SBM_GETSCROLLINFO		= 000EAh

SIF_RANGE			= 00001h
SIF_PAGE			= 00002h
SIF_POS 			= 00004h
SIF_DISABLENOSCROLL		= 00008h
SIF_TRACKPOS			= 00010h
SIF_ALL 			= (SIF_RANGE + SIF_PAGE + SIF_POS + SIF_TRACKPOS)

struc	SCROLLINFO
	cbSize			dd ?
	fMask			dd ?
	nMin			dd ?
	nMax			dd ?
	nPage			dd ?
	nPos			dd ?
	nTrackPos		dd ?
ends

procdesc SetScrollInfo :dword, :dword, :dword, :dword
procdesc GetScrollInfo :dword, :dword, :dword

;
; MDI client style bits
;
MDIS_ALLCHILDSTYLES		= 00001h

;
; wParam Flags for WM_MDITILE and WM_MDICASCADE messages.
;
MDITILE_VERTICAL		= 00000h ;not in win3.1
MDITILE_HORIZONTAL		= 00001h ;not in win3.1
MDITILE_SKIPDISABLED		= 00002h ;not in win3.1
MDITILE_ZORDER			= 00004h

struc	MDICREATESTRUCT
	szClass 		dd ?
	szTitle 		dd ?
	hOwner			dd ?
	x			dd ?
	y			dd ?
	cx			dd ?
	cy			dd ?
	style			dd ?
	lParam			dd ?		; app-defined stuff
ends

struc	CLIENTCREATESTRUCT
	hWindowMenu		dd ?
	idFirstChild		dd ?
ends

procdesc DefFrameProcA :dword, :dword, :dword, :dword, :dword
procdesc DefMDIChildProcA :dword, :dword, :dword, :dword
procdesc TranslateMDISysAccel :dword, :dword
procdesc ArrangeIconicWindows :dword
procdesc CreateMDIWindowA :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
procdesc TileWindows :dword, :dword, :dword, :dword, :dword
procdesc CascadeWindows :dword, :dword, :dword, :dword, :dword

DefFrameProc			equ <DefFrameProcA>
DefMDIChildProc 		equ <DefMDIChildProcA>
CreateMDIWindow 		equ <CreateMDIWindowA>

;***** Help support *******************************************************

struc	MULTIKEYHELP
	mkSize			dd ?
	mkKeylist		db ?
label	szKeyphrase		byte
ends

struc	HELPWININFO
	wStructSize		dd ?
	x			dd ?
	y			dd ?
	dx			dd ?
	dy			dd ?
	wMax			dd ?
	rgchMember		db 2 dup (?)
ends

;
; Commands to pass to WinHelp()
;
HELP_CONTEXT			= 00001h  ; Display topic in ulTopic
HELP_QUIT			= 00002h  ; Terminate help
HELP_INDEX			= 00003h  ; Display index
HELP_CONTENTS			= 00003h
HELP_HELPONHELP 		= 00004h  ; Display help on using help
HELP_SETINDEX			= 00005h  ; Set current Index for multi index help
HELP_SETCONTENTS		= 00005h
HELP_CONTEXTPOPUP		= 00008h
HELP_FORCEFILE			= 00009h
HELP_KEY			= 00101h  ; Display topic for keyword in offabData
HELP_COMMAND			= 00102h
HELP_PARTIALKEY 		= 00105h
HELP_MULTIKEY			= 00201h
HELP_SETWINPOS			= 00203h
HELP_CONTEXTMENU		= 0000Ah
HELP_FINDER			= 0000Bh
HELP_WM_HELP			= 0000Ch
HELP_SETPOPUP_POS		= 0000Dh

HELP_TCARD			= 08000h
HELP_TCARD_DATA 		= 00010h
HELP_TCARD_OTHER_CALLER 	= 00011h

; These are in winhelp.h in Win95.
IDH_NO_HELP			= 28440
IDH_MISSING_CONTEXT		= 28441 ; Control doesn't have matching help context
IDH_GENERIC_HELP_BUTTON 	= 28442 ; Property sheet help button
IDH_OK				= 28443
IDH_CANCEL			= 28444
IDH_HELP			= 28445

procdesc WinHelpA :dword, :dword, :dword, :dword

WinHelp 			equ <WinHelpA>

GR_GDIOBJECTS			= 0	  ; Count of GDI objects
GR_USEROBJECTS			= 1	  ; Count of USER objects

;
; Parameter for SystemParametersInfo()
;

SPI_GETBEEP			= 1
SPI_SETBEEP			= 2
SPI_GETMOUSE			= 3
SPI_SETMOUSE			= 4
SPI_GETBORDER			= 5
SPI_SETBORDER			= 6
SPI_GETKEYBOARDSPEED		= 10
SPI_SETKEYBOARDSPEED		= 11
SPI_LANGDRIVER			= 12
SPI_ICONHORIZONTALSPACING	= 13
SPI_GETSCREENSAVETIMEOUT	= 14
SPI_SETSCREENSAVETIMEOUT	= 15
SPI_GETSCREENSAVEACTIVE 	= 16
SPI_SETSCREENSAVEACTIVE 	= 17
SPI_GETGRIDGRANULARITY		= 18
SPI_SETGRIDGRANULARITY		= 19
SPI_SETDESKWALLPAPER		= 20
SPI_SETDESKPATTERN		= 21
SPI_GETKEYBOARDDELAY		= 22
SPI_SETKEYBOARDDELAY		= 23
SPI_ICONVERTICALSPACING 	= 24
SPI_GETICONTITLEWRAP		= 25
SPI_SETICONTITLEWRAP		= 26
SPI_GETMENUDROPALIGNMENT	= 27
SPI_SETMENUDROPALIGNMENT	= 28
SPI_SETDOUBLECLKWIDTH		= 29
SPI_SETDOUBLECLKHEIGHT		= 30
SPI_GETICONTITLELOGFONT 	= 31
SPI_SETDOUBLECLICKTIME		= 32
SPI_SETMOUSEBUTTONSWAP		= 33
SPI_SETICONTITLELOGFONT 	= 34
SPI_GETFASTTASKSWITCH		= 35
SPI_SETFASTTASKSWITCH		= 36
SPI_SETDRAGFULLWINDOWS		= 37
SPI_GETDRAGFULLWINDOWS		= 38
SPI_GETNONCLIENTMETRICS 	= 41
SPI_SETNONCLIENTMETRICS 	= 42
SPI_GETMINIMIZEDMETRICS 	= 43
SPI_SETMINIMIZEDMETRICS 	= 44
SPI_GETICONMETRICS		= 45
SPI_SETICONMETRICS		= 46
SPI_SETWORKAREA 		= 47
SPI_GETWORKAREA 		= 48
SPI_SETPENWINDOWS		= 49

SPI_GETHIGHCONTRAST		= 66
SPI_SETHIGHCONTRAST		= 67
SPI_GETKEYBOARDPREF		= 68
SPI_SETKEYBOARDPREF		= 69
SPI_GETSCREENREADER		= 70
SPI_SETSCREENREADER		= 71
SPI_GETANIMATION		= 72
SPI_SETANIMATION		= 73
SPI_GETFONTSMOOTHING		= 74
SPI_SETFONTSMOOTHING		= 75
SPI_SETDRAGWIDTH		= 76
SPI_SETDRAGHEIGHT		= 77
SPI_SETHANDHELD 		= 78
SPI_GETLOWPOWERTIMEOUT		= 79
SPI_GETPOWEROFFTIMEOUT		= 80
SPI_SETLOWPOWERTIMEOUT		= 81
SPI_SETPOWEROFFTIMEOUT		= 82
SPI_GETLOWPOWERACTIVE		= 83
SPI_GETPOWEROFFACTIVE		= 84
SPI_SETLOWPOWERACTIVE		= 85
SPI_SETPOWEROFFACTIVE		= 86
SPI_SETCURSORS			= 87
SPI_SETICONS			= 88
SPI_GETDEFAULTINPUTLANG 	= 89
SPI_SETDEFAULTINPUTLANG 	= 90
SPI_SETLANGTOGGLE		= 91
SPI_GETWINDOWSEXTENSION 	= 92
SPI_SETMOUSETRAILS		= 93
SPI_GETMOUSETRAILS		= 94
SPI_SETSCREENSAVERRUNNING	= 97
SPI_SCREENSAVERRUNNING		= SPI_SETSCREENSAVERRUNNING
SPI_GETFILTERKEYS		= 50
SPI_SETFILTERKEYS		= 51
SPI_GETTOGGLEKEYS		= 52
SPI_SETTOGGLEKEYS		= 53
SPI_GETMOUSEKEYS		= 54
SPI_SETMOUSEKEYS		= 55
SPI_GETSHOWSOUNDS		= 56
SPI_SETSHOWSOUNDS		= 57
SPI_GETSTICKYKEYS		= 58
SPI_SETSTICKYKEYS		= 59
SPI_GETACCESSTIMEOUT		= 60
SPI_SETACCESSTIMEOUT		= 61
SPI_GETSERIALKEYS		= 62
SPI_SETSERIALKEYS		= 63
SPI_GETSOUNDSENTRY		= 64
SPI_SETSOUNDSENTRY		= 65
SPI_GETSNAPTODEFBUTTON		= 95
SPI_SETSNAPTODEFBUTTON		= 96
SPI_GETMOUSEHOVERWIDTH		= 98
SPI_SETMOUSEHOVERWIDTH		= 99
SPI_GETMOUSEHOVERHEIGHT 	= 100
SPI_SETMOUSEHOVERHEIGHT 	= 101
SPI_GETMOUSEHOVERTIME		= 102
SPI_SETMOUSEHOVERTIME		= 103
SPI_GETWHEELSCROLLLINES 	= 104
SPI_SETWHEELSCROLLLINES 	= 105
SPI_GETMENUSHOWDELAY		= 106
SPI_SETMENUSHOWDELAY		= 107

SPI_GETSHOWIMEUI		= 110
SPI_SETSHOWIMEUI		= 111

SPI_GETMOUSESPEED		= 112
SPI_SETMOUSESPEED		= 113
SPI_GETSCREENSAVERRUNNING	= 114

SPI_GETACTIVEWINDOWTRACKING	= 01000h
SPI_SETACTIVEWINDOWTRACKING	= 01001h
SPI_GETMENUANIMATION		= 01002h
SPI_SETMENUANIMATION		= 01003h
SPI_GETCOMBOBOXANIMATION	= 01004h
SPI_SETCOMBOBOXANIMATION	= 01005h
SPI_GETLISTBOXSMOOTHSCROLLING	= 01006h
SPI_SETLISTBOXSMOOTHSCROLLING	= 01007h
SPI_GETGRADIENTCAPTIONS 	= 01008h
SPI_SETGRADIENTCAPTIONS 	= 01009h
SPI_GETKEYBOARDCUES		= 0100Ah
SPI_SETKEYBOARDCUES		= 0100Bh
SPI_GETMENUUNDERLINES		= SPI_GETKEYBOARDCUES
SPI_SETMENUUNDERLINES		= SPI_SETKEYBOARDCUES
SPI_GETACTIVEWNDTRKZORDER	= 0100Ch
SPI_SETACTIVEWNDTRKZORDER	= 0100Dh
SPI_GETHOTTRACKING		= 0100Eh
SPI_SETHOTTRACKING		= 0100Fh
SPI_GETMENUFADE 		= 01012h
SPI_SETMENUFADE 		= 01013h
SPI_GETSELECTIONFADE		= 01014h
SPI_SETSELECTIONFADE		= 01015h
SPI_GETTOOLTIPANIMATION 	= 01016h
SPI_SETTOOLTIPANIMATION 	= 01017h
SPI_GETTOOLTIPFADE		= 01018h
SPI_SETTOOLTIPFADE		= 01019h
SPI_GETCURSORSHADOW		= 0101Ah
SPI_SETCURSORSHADOW		= 0101Bh

SPI_GETUIEFFECTS		= 0103Eh
SPI_SETUIEFFECTS		= 0103Fh

SPI_GETFOREGROUNDLOCKTIMEOUT	= 02000h
SPI_SETFOREGROUNDLOCKTIMEOUT	= 02001h
SPI_GETACTIVEWNDTRKTIMEOUT	= 02002h
SPI_SETACTIVEWNDTRKTIMEOUT	= 02003h
SPI_GETFOREGROUNDFLASHCOUNT	= 02004h
SPI_SETFOREGROUNDFLASHCOUNT	= 02005h
SPI_GETCARETWIDTH		= 02006h
SPI_SETCARETWIDTH		= 02007h

;
; Flags
;
SPIF_UPDATEINIFILE		= 00001h
SPIF_SENDWININICHANGE		= 00002h
SPIF_SENDCHANGE 		= SPIF_SENDWININICHANGE

METRICS_USEDEFAULT		= -1

struc	NONCLIENTMETRICS
	cbSize			dd ?
	iBorderWidth		dd ?
	iScrollWidth		dd ?
	iScrollHeight		dd ?
	iCaptionWidth		dd ?
	iCaptionHeight		dd ?
	lfCaptionFont		LOGFONT ?
	iSmCaptionWidth 	dd ?
	iSmCaptionHeight	dd ?
	lfSmCaptionFont 	LOGFONT ?
	iMenuWidth		dd ?
	iMenuHeight		dd ?
	lfMenuFont		LOGFONT ?
	lfStatusFont		LOGFONT ?
	lfMessageFont		LOGFONT ?
ends

ARW_BOTTOMLEFT			= 00000h
ARW_BOTTOMRIGHT 		= 00001h
ARW_TOPLEFT			= 00002h
ARW_TOPRIGHT			= 00003h
ARW_STARTMASK			= 00003h
ARW_STARTRIGHT			= 00001h
ARW_STARTTOP			= 00002h

ARW_LEFT			= 00000h
ARW_RIGHT			= 00000h
ARW_UP				= 00004h
ARW_DOWN			= 00004h
ARW_HIDE			= 00008h

struc	MINIMIZEDMETRICS
	cbSize			dd ?
	iWidth			dd ?
	iHorzGap		dd ?
	iVertGap		dd ?
	iArrange		dd ?
ends

struc	ICONMETRICS
	cbSize			dd ?
	iHorzSpacing		dd ?
	iVertSpacing		dd ?
	iTitleWrap		dd ?
	lfFont			LOGFONT ?
ends

struc	ANIMATIONINFO
	cbSize			dd ?
	iMinAnimate		dd ?
ends

struc	SERIALKEYS
	cbSize			dd ?
	dwFlags 		dd ?
	lpszActivePort		dd ?
	lpszPort		dd ?
	iBaudRate		dd ?
	iPortState		dd ?
	iActive 		dd ?
ends

; flags for SERIALKEYS dwFlags field
SERKF_SERIALKEYSON		= 000000001h
SERKF_AVAILABLE 		= 000000002h
SERKF_INDICATOR 		= 000000004h

struc	HIGHCONTRAST
	cbSize			dd ?
	dwFlags 		dd ?
	lpszDefaultScheme	dd ?
ends

; flags for HIGHCONTRAST dwFlags field
HCF_HIGHCONTRASTON		= 000000001h
HCF_AVAILABLE			= 000000002h
HCF_HOTKEYACTIVE		= 000000004h
HCF_CONFIRMHOTKEY		= 000000008h
HCF_HOTKEYSOUND 		= 000000010h
HCF_INDICATOR			= 000000020h
HCF_HOTKEYAVAILABLE		= 000000040h

; Flags for ChangeDisplaySettings
CDS_UPDATEREGISTRY		= 000000001h
CDS_TEST			= 000000002h
CDS_FULLSCREEN			= 000000004h
CDS_GLOBAL			= 000000008h
CDS_SET_PRIMARY 		= 000000010h
CDS_RESET			= 040000000h
CDS_NORESET			= 010000000h

; Return values for ChangeDisplaySettings
DISP_CHANGE_SUCCESSFUL		= 0
DISP_CHANGE_RESTART		= 1
DISP_CHANGE_FAILED		= -1
DISP_CHANGE_BADMODE		= -2
DISP_CHANGE_NOTUPDATED		= -3
DISP_CHANGE_BADFLAGS		= -4
DISP_CHANGE_BADPARAM		= -5

procdesc ChangeDisplaySettingsA :dword, :dword
procdesc ChangeDisplaySettingsExA :dword, :dword, :dword, :dword, :dword

ChangeDisplaySettings		equ <ChangeDisplaySettingsA>
ChangeDisplaySettingsEx 	equ <ChangeDisplaySettingsExA>

ENUM_CURRENT_SETTINGS		= (-1)
ENUM_REGISTRY_SETTINGS		= (-2)

procdesc EnumDisplaySettingsA :dword, :dword, :dword
procdesc EnumDisplayDevicesA :dword, :dword, :dword, :dword
procdesc SystemParametersInfoA :dword, :dword, :dword, :dword

EnumDisplaySettings		equ <EnumDisplaySettingsA>
EnumDisplayDevices		equ <EnumDisplayDevicesA>
SystemParametersInfo		equ <SystemParametersInfoA>

;
; Accessibility support
;

struc	FILTERKEYS
	cbSize			dd ?
	dwFlags 		dd ?
	iWaitMSec		dd ?		; Acceptance Delay
	iDelayMSec		dd ?		; Delay Until Repeat
	iRepeatMSec		dd ?		; Repeat Rate
	iBounceMSec		dd ?		; Debounce Time
ends

;
; FILTERKEYS dwFlags field
;
FKF_FILTERKEYSON		= 000000001h
FKF_AVAILABLE			= 000000002h
FKF_HOTKEYACTIVE		= 000000004h
FKF_CONFIRMHOTKEY		= 000000008h
FKF_HOTKEYSOUND 		= 000000010h
FKF_INDICATOR			= 000000020h
FKF_CLICKON			= 000000040h

struc	STICKYKEYS
	cbSize			dd ?
	dwFlags 		dd ?
ends

;
; STICKYKEYS dwFlags field
;
SKF_STICKYKEYSON		= 000000001h
SKF_AVAILABLE			= 000000002h
SKF_HOTKEYACTIVE		= 000000004h
SKF_CONFIRMHOTKEY		= 000000008h
SKF_HOTKEYSOUND 		= 000000010h
SKF_INDICATOR			= 000000020h
SKF_AUDIBLEFEEDBACK		= 000000040h
SKF_TRISTATE			= 000000080h
SKF_TWOKEYSOFF			= 000000100h
SKF_LALTLATCHED 		= 010000000h
SKF_LCTLLATCHED 		= 004000000h
SKF_LSHIFTLATCHED		= 001000000h
SKF_RALTLATCHED 		= 020000000h
SKF_RCTLLATCHED 		= 008000000h
SKF_RSHIFTLATCHED		= 002000000h
SKF_LWINLATCHED 		= 040000000h
SKF_RWINLATCHED 		= 080000000h
SKF_LALTLOCKED			= 000100000h
SKF_LCTLLOCKED			= 000040000h
SKF_LSHIFTLOCKED		= 000010000h
SKF_RALTLOCKED			= 000200000h
SKF_RCTLLOCKED			= 000080000h
SKF_RSHIFTLOCKED		= 000020000h
SKF_LWINLOCKED			= 000400000h
SKF_RWINLOCKED			= 000800000h

struc	MOUSEKEYS
	cbSize			dd ?
	dwFlags 		dd ?
	iMaxSpeed		dd ?
	iTimeToMaxSpeed 	dd ?
	iCtrlSpeed		dd ?
	dwReserved1		dd ?
	dwReserved2		dd ?
ends

;
; MOUSEKEYS dwFlags field
;
MKF_MOUSEKEYSON 		= 000000001h
MKF_AVAILABLE			= 000000002h
MKF_HOTKEYACTIVE		= 000000004h
MKF_CONFIRMHOTKEY		= 000000008h
MKF_HOTKEYSOUND 		= 000000010h
MKF_INDICATOR			= 000000020h
MKF_MODIFIERS			= 000000040h
MKF_REPLACENUMBERS		= 000000080h
MKF_LEFTBUTTONSEL		= 010000000h
MKF_RIGHTBUTTONSEL		= 020000000h
MKF_LEFTBUTTONDOWN		= 001000000h
MKF_RIGHTBUTTONDOWN		= 002000000h
MKF_MOUSEMODE			= 080000000h

struc	ACCESSTIMEOUT
	cbSize			dd ?
	dwFlags 		dd ?
	iTimeOutMSec		dd ?
ends

;
; ACCESSTIMEOUT dwFlags field
;
ATF_TIMEOUTON			= 000000001h
ATF_ONOFFFEEDBACK		= 000000002h

; values for SOUNDSENTRY iFSGrafEffect field
SSGF_NONE			= 0
SSGF_DISPLAY			= 3

; values for SOUNDSENTRY iFSTextEffect field
SSTF_NONE			= 0
SSTF_CHARS			= 1
SSTF_BORDER			= 2
SSTF_DISPLAY			= 3

; values for SOUNDSENTRY iWindowsEffect field
SSWF_NONE			= 0
SSWF_TITLE			= 1
SSWF_WINDOW			= 2
SSWF_DISPLAY			= 3
SSWF_CUSTOM			= 4

struc	SOUNDSENTRY
	cbSize			dd ?
	dwFlags 		dd ?
	iFSTextEffect		dd ?
	iFSTextEffectMSec	dd ?
	iFSTextEffectColorBits	dd ?
	iFSGrafEffect		dd ?
	iFSGrafEffectMSec	dd ?
	iFSGrafEffectColor	dd ?
	iWindowsEffect		dd ?
	iWindowsEffectMSec	dd ?
	lpszWindowsEffectDLL	dd ?
	iWindowsEffectOrdinal	dd ?
ends

;
; SOUNDSENTRY dwFlags field
;
SSF_SOUNDSENTRYON		= 000000001h
SSF_AVAILABLE			= 000000002h
SSF_INDICATOR			= 000000004h

struc	TOGGLEKEYS
	cbSize			dd ?
	dwFlags 		dd ?
ends

;
; TOGGLEKEYS dwFlags field
;
TKF_TOGGLEKEYSON		= 000000001h
TKF_AVAILABLE			= 000000002h
TKF_HOTKEYACTIVE		= 000000004h
TKF_CONFIRMHOTKEY		= 000000008h
TKF_HOTKEYSOUND 		= 000000010h
TKF_INDICATOR			= 000000020h

;
; Set debug level
;

procdesc SetDebugErrorLevel :dword

;
; SetLastErrorEx() types.
;

SLE_ERROR			= 000000001h
SLE_MINORERROR			= 000000002h
SLE_WARNING			= 000000003h

procdesc SetLastErrorEx :dword, :dword

;
; Multimonitor API.
;

MONITOR_DEFAULTTONULL		= 000000000h
MONITOR_DEFAULTTOPRIMARY	= 000000001h
MONITOR_DEFAULTTONEAREST	= 000000002h

procdesc MonitorFromPoint :dword, :dword
procdesc MonitorFromRect :dword, :dword
procdesc MonitorFromWindow :dword, :dword

MONITORINFOF_PRIMARY		= 000000001h

CCHDEVICENAME			= 32

struc	MONITORINFO
	cbSize			dd ?
	rcMonitor		RECT ?
	rcWork			RECT ?
	dwFlags 		dd ?
ends

struc	MONITORINFOEX
	szDevice		db CCHDEVICENAME dup (?)
ends

proctype MONITORENUMPROC :dword, :dword, :dword, :dword

procdesc GetMonitorInfoA :dword, :dword
procdesc EnumDisplayMonitors :dword, :dword, :dword, :dword

GetMonitorInfo			equ <GetMonitorInfoA>

;
; WinEvents - Active Accessibility hooks
;

proctype WINEVENTPROC :dword, :dword, :dword, :dword, :dword, :dword, :dword

procdesc NotifyWinEvent :dword, :dword, :dword, :dword
procdesc SetWinEventHook :dword, :dword, :dword, :dword, :dword, :dword, :dword

;
; dwFlags for SetWinEventHook
;
WINEVENT_OUTOFCONTEXT		= 00000h  ; Events are ASYNC
WINEVENT_SKIPOWNTHREAD		= 00001h  ; Don't call back for events on installer's thread
WINEVENT_SKIPOWNPROCESS 	= 00002h  ; Don't call back for events on installer's process
WINEVENT_INCONTEXT		= 00004h  ; Events are SYNC, this causes your dll to be injected into every process

procdesc UnhookWinEvent :dword

;
; idObject values for WinEventProc and NotifyWinEvent
;

;
; hwnd + idObject can be used with OLEACC.DLL's OleGetObjectFromWindow()
; to get an interface pointer to the container.  indexChild is the item
; within the container in question.  Setup a VARIANT with vt VT_I4 and
; lVal the indexChild and pass that in to all methods.	Then you
; are raring to go.
;


;
; Common object IDs (cookies, only for sending WM_GETOBJECT to get at the
; thing in question).  Positive IDs are reserved for apps (app specific),
; negative IDs are system things and are global, 0 means "just little old
; me".
;
CHILDID_SELF			= 0
INDEXID_OBJECT			= 0
INDEXID_CONTAINER		= 0

;
; Reserved IDs for system objects
;
OBJID_WINDOW			= 000000000h
OBJID_SYSMENU			= 0FFFFFFFFh
OBJID_TITLEBAR			= 0FFFFFFFEh
OBJID_MENU			= 0FFFFFFFDh
OBJID_CLIENT			= 0FFFFFFFCh
OBJID_VSCROLL			= 0FFFFFFFBh
OBJID_HSCROLL			= 0FFFFFFFAh
OBJID_SIZEGRIP			= 0FFFFFFF9h
OBJID_CARET			= 0FFFFFFF8h
OBJID_CURSOR			= 0FFFFFFF7h
OBJID_ALERT			= 0FFFFFFF6h
OBJID_SOUND			= 0FFFFFFF5h

;
; EVENT DEFINITION
;
EVENT_MIN			= 000000001h
EVENT_MAX			= 07FFFFFFFh


;
;  EVENT_SYSTEM_SOUND
;  Sent when a sound is played.  Currently nothing is generating this, we
;  this event when a system sound (for menus, etc) is played.  Apps
;  generate this, if accessible, when a private sound is played.  For
;  example, if Mail plays a "New Mail" sound.
;
;  System Sounds:
;  (Generated by PlaySoundEvent in USER itself)
;      hwnd	       is NULL
;      idObject        is OBJID_SOUND
;      idChild	       is sound child ID if one
;  App Sounds:
;  (PlaySoundEvent won't generate notification; up to app)
;      hwnd + idObject gets interface pointer to Sound object
;      idChild identifies the sound in question
;  are going to be cleaning up the SOUNDSENTRY feature in the control panel
;  and will use this at that time.  Applications implementing WinEvents
;  are perfectly welcome to use it.  Clients of IAccessible* will simply
;  turn around and get back a non-visual object that describes the sound.
;
EVENT_SYSTEM_SOUND		= 00001h

;
; EVENT_SYSTEM_ALERT
; System Alerts:
; (Generated by MessageBox() calls for example)
;      hwnd	       is hwndMessageBox
;      idObject        is OBJID_ALERT
; App Alerts:
; (Generated whenever)
;      hwnd+idObject gets interface pointer to Alert
;
EVENT_SYSTEM_ALERT		= 00002h

;
; EVENT_SYSTEM_FOREGROUND
; Sent when the foreground (active) window changes, even if it is changing
; to another window in the same thread as the previous one.
;      hwnd	       is hwndNewForeground
;      idObject        is OBJID_WINDOW
;      idChild	  is INDEXID_OBJECT
;
EVENT_SYSTEM_FOREGROUND 	= 00003h

;
; Menu
;      hwnd	       is window (top level window or popup menu window)
;      idObject        is ID of control (OBJID_MENU, OBJID_SYSMENU, OBJID_SELF for popup)
;      idChild	       is CHILDID_SELF
;
; EVENT_SYSTEM_MENUSTART
; EVENT_SYSTEM_MENUEND
; For MENUSTART, hwnd+idObject+idChild refers to the control with the menu bar,
;  or the control bringing up the context menu.
;
; Sent when entering into and leaving from menu mode (system, app bar, and
; track popups).
;
EVENT_SYSTEM_MENUSTART		= 00004h
EVENT_SYSTEM_MENUEND		= 00005h

;
; EVENT_SYSTEM_MENUPOPUPSTART
; EVENT_SYSTEM_MENUPOPUPEND
; Sent when a menu popup comes up and just before it is taken down.  Note
; that for a call to TrackPopupMenu(), a client will see EVENT_SYSTEM_MENUSTART
; followed almost immediately by EVENT_SYSTEM_MENUPOPUPSTART for the popup
; being shown.
;
; For MENUPOPUP, hwnd+idObject+idChild refers to the NEW popup coming up, not the
; parent item which is hierarchical.  You can get the parent menu/popup by
; asking for the accParent object.
;
EVENT_SYSTEM_MENUPOPUPSTART	= 00006h
EVENT_SYSTEM_MENUPOPUPEND	= 00007h


;
; EVENT_SYSTEM_CAPTURESTART
; EVENT_SYSTEM_CAPTUREEND
; Sent when a window takes the capture and releases the capture.
;
EVENT_SYSTEM_CAPTURESTART	= 00008h
EVENT_SYSTEM_CAPTUREEND 	= 00009h

;
; Move Size
; EVENT_SYSTEM_MOVESIZESTART
; EVENT_SYSTEM_MOVESIZEEND
; Sent when a window enters and leaves move-size dragging mode.
;
EVENT_SYSTEM_MOVESIZESTART	= 0000Ah
EVENT_SYSTEM_MOVESIZEEND	= 0000Bh

;
; Context Help
; EVENT_SYSTEM_CONTEXTHELPSTART
; EVENT_SYSTEM_CONTEXTHELPEND
; Sent when a window enters and leaves context sensitive help mode.
;
EVENT_SYSTEM_CONTEXTHELPSTART	= 0000Ch
EVENT_SYSTEM_CONTEXTHELPEND	= 0000Dh

;
; Drag & Drop
; EVENT_SYSTEM_DRAGDROPSTART
; EVENT_SYSTEM_DRAGDROPEND
; Send the START notification just before going into drag&drop loop.  Send
; the END notification just after canceling out.
; Note that it is up to apps and OLE to generate this, since the system
; doesn't know.  Like EVENT_SYSTEM_SOUND, it will be a while before this
; is prevalent.
;
EVENT_SYSTEM_DRAGDROPSTART	= 0000Eh
EVENT_SYSTEM_DRAGDROPEND	= 0000Fh

;
; Dialog
; Send the START notification right after the dialog is completely
;  initialized and visible.  Send the END right before the dialog
;  is hidden and goes away.
; EVENT_SYSTEM_DIALOGSTART
; EVENT_SYSTEM_DIALOGEND
;
EVENT_SYSTEM_DIALOGSTART	= 00010h
EVENT_SYSTEM_DIALOGEND		= 00011h

;
; EVENT_SYSTEM_SCROLLING
; EVENT_SYSTEM_SCROLLINGSTART
; EVENT_SYSTEM_SCROLLINGEND
; Sent when beginning and ending the tracking of a scrollbar in a window,
; and also for scrollbar controls.
;
EVENT_SYSTEM_SCROLLINGSTART	= 00012h
EVENT_SYSTEM_SCROLLINGEND	= 00013h

;
; Alt-Tab Window
; Send the START notification right after the switch window is initialized
; and visible.	Send the END right before it is hidden and goes away.
; EVENT_SYSTEM_SWITCHSTART
; EVENT_SYSTEM_SWITCHEND
;
EVENT_SYSTEM_SWITCHSTART	= 00014h
EVENT_SYSTEM_SWITCHEND		= 00015h

;
; EVENT_SYSTEM_MINIMIZESTART
; EVENT_SYSTEM_MINIMIZEEND
; Sent when a window minimizes and just before it restores.
;
EVENT_SYSTEM_MINIMIZESTART	= 00016h
EVENT_SYSTEM_MINIMIZEEND	= 00017h

;
; Object events
;
; The system AND apps generate these.  The system generates these for
; real windows.  Apps generate these for objects within their window which
; act like a separate control, e.g. an item in a list view.
;
; When the system generate them, dwParam2 is always WMOBJID_SELF.  When
; apps generate them, apps put the has-meaning-to-the-app-only ID value
; in dwParam2.
; For all events, if you want detailed accessibility information, callers
; should
;      * Call AccessibleObjectFromWindow() with the hwnd, idObject parameters
;	   of the event, and IID_IAccessible as the REFIID, to get back an
;	   IAccessible* to talk to
;      * Initialize and fill in a VARIANT as VT_I4 with lVal the idChild
;	   parameter of the event.
;      * If idChild isn't zero, call get_accChild() in the container to see
;	   if the child is an object in its own right.	If so, you will get
;	   back an IDispatch* object for the child.  You should release the
;	   parent, and call QueryInterface() on the child object to get its
;	   IAccessible*.  Then you talk directly to the child.	Otherwise,
;	   if get_accChild() returns you nothing, you should continue to
;	   use the child VARIANT.  You will ask the container for the properties
;	   of the child identified by the VARIANT.  In other words, the
;	   child in this case is accessible but not a full-blown object.
;	   Like a button on a titlebar which is 'small' and has no children.
;

;
; For all EVENT_OBJECT events,
;      hwnd is the dude to Send the WM_GETOBJECT message to (unless NULL,
;	   see above for system things)
;      idObject is the ID of the object that can resolve any queries a
;	   client might have.  It's a way to deal with windowless controls,
;	   controls that are just drawn on the screen in some larger parent
;	   window (like SDM), or standard frame elements of a window.
;      idChild is the piece inside of the object that is affected.  This
;	   allows clients to access things that are too small to have full
;	   blown objects in their own right.  Like the thumb of a scrollbar.
;	   The hwnd/idObject pair gets you to the container, the dude you
;	   probably want to talk to most of the time anyway.  The idChild
;	   can then be passed into the acc properties to get the name/value
;	   of it as needed.
;
; Example #1:
;      System propagating a listbox selection change
;      EVENT_OBJECT_SELECTION
;	   hwnd == listbox hwnd
;	   idObject == OBJID_WINDOW
;	   idChild == new selected item, or CHILDID_SELF if
;	       nothing now selected within container.
;      Word '97 propagating a listbox selection change
;	   hwnd == SDM window
;	   idObject == SDM ID to get at listbox 'control'
;	   idChild == new selected item, or CHILDID_SELF if
;	       nothing
;
; Example #2:
;      System propagating a menu item selection on the menu bar
;      EVENT_OBJECT_SELECTION
;	   hwnd == top level window
;	   idObject == OBJID_MENU
;	   idChild == ID of child menu bar item selected
;
; Example #3:
;      System propagating a dropdown coming off of said menu bar item
;      EVENT_OBJECT_CREATE
;	   hwnd == popup item
;	   idObject == OBJID_WINDOW
;	   idChild == CHILDID_SELF
;
; Example #4:
;
; For EVENT_OBJECT_REORDER, the object referred to by hwnd/idObject is the
; PARENT container in which the zorder is occurring.  This is because if
; one child is zordering, all of them are changing their relative zorder.
;
EVENT_OBJECT_CREATE		= 08000h  ; hwnd + ID + idChild is created item
EVENT_OBJECT_DESTROY		= 08001h  ; hwnd + ID + idChild is destroyed item
EVENT_OBJECT_SHOW		= 08002h  ; hwnd + ID + idChild is shown item
EVENT_OBJECT_HIDE		= 08003h  ; hwnd + ID + idChild is hidden item
EVENT_OBJECT_REORDER		= 08004h  ; hwnd + ID + idChild is parent of zordering children
;
; NOTE:
; Minimize the number of notifications!
;
; When you are hiding a parent object, obviously all child objects are no
; longer visible on screen.  They still have the same "visible" status,
; but are not truly visible.  Hence do not send HIDE notifications for the
; children also.  One implies all.  The same goes for SHOW.
;


EVENT_OBJECT_FOCUS		= 08005h  ; hwnd + ID + idChild is focused item
EVENT_OBJECT_SELECTION		= 08006h  ; hwnd + ID + idChild is selected item (if only one), or idChild is OBJID_WINDOW if complex
EVENT_OBJECT_SELECTIONADD	= 08007h  ; hwnd + ID + idChild is item added
EVENT_OBJECT_SELECTIONREMOVE	= 08008h  ; hwnd + ID + idChild is item removed
EVENT_OBJECT_SELECTIONWITHIN	= 08009h  ; hwnd + ID + idChild is parent of changed selected items

;
; NOTES:
; There is only one "focused" child item in a parent.  This is the place
; keystrokes are going at a given moment.  Hence only send a notification
; about where the NEW focus is going.  A NEW item getting the focus already
; implies that the OLD item is losing it.
;
; SELECTION however can be multiple.  Hence the different SELECTION
; notifications.  Here's when to use each:
;
; (1) Send a SELECTION notification in the simple single selection
;     case (like the focus) when the item with the selection is
;     merely moving to a different item within a container.  hwnd + ID
;     is the container control, idChildItem is the new child with the
;     selection.
;
; (2) Send a SELECTIONADD notification when a new item has simply been added
;     to the selection within a container.  This is appropriate when the
;     number of newly selected items is very small.  hwnd + ID is the
;     container control, idChildItem is the new child added to the selection.
;
; (3) Send a SELECTIONREMOVE notification when a new item has simply been
;     removed from the selection within a container.  This is appropriate
;     when the number of newly selected items is very small, just like
;     SELECTIONADD.  hwnd + ID is the container control, idChildItem is the
;     new child removed from the selection.
;
; (4) Send a SELECTIONWITHIN notification when the selected items within a
;     control have changed substantially.  Rather than propagate a large
;     number of changes to reflect removal for some items, addition of
;     others, just tell somebody who cares that a lot happened.  It will
;     be faster an easier for somebody watching to just turn around and
;     query the container control what the new bunch of selected items
;     are.
;

EVENT_OBJECT_STATECHANGE	= 0800Ah  ; hwnd + ID + idChild is item w/ state change
;
; Examples of when to send an EVENT_OBJECT_STATECHANGE include
;      * It is being enabled/disabled (USER does for windows)
;      * It is being pressed/released (USER does for buttons)
;      * It is being checked/unchecked (USER does for radio/check buttons)
;
EVENT_OBJECT_LOCATIONCHANGE	= 0800Bh  ; hwnd + ID + idChild is moved/sized item

;
; Note:
; A LOCATIONCHANGE is not sent for every child object when the parent
; changes shape/moves.	Send one notification for the topmost object
; that is changing.  For example, if the user resizes a top level window,
; USER will generate a LOCATIONCHANGE for it, but not for the menu bar,
; title bar, scrollbars, etc.  that are also changing shape/moving.
;
; In other words, it only generates LOCATIONCHANGE notifications for
; real windows that are moving/sizing.	It will not generate a LOCATIONCHANGE
; for every non-floating child window when the parent moves (the children are
; logically moving also on screen, but not relative to the parent).
;
; Now, if the app itself resizes child windows as a result of being
; sized, USER will generate LOCATIONCHANGEs for those dudes also because
; it doesn't know better.
;
; Note also that USER will generate LOCATIONCHANGE notifications for two
; non-window sys objects:
;      (1) System caret
;      (2) Cursor
;

EVENT_OBJECT_NAMECHANGE 	= 0800Ch  ; hwnd + ID + idChild is item w/ name change
EVENT_OBJECT_DESCRIPTIONCHANGE	= 0800Dh  ; hwnd + ID + idChild is item w/ desc change
EVENT_OBJECT_VALUECHANGE	= 0800Eh  ; hwnd + ID + idChild is item w/ value change
EVENT_OBJECT_PARENTCHANGE	= 0800Fh  ; hwnd + ID + idChild is item w/ new parent
EVENT_OBJECT_HELPCHANGE 	= 08010h  ; hwnd + ID + idChild is item w/ help change
EVENT_OBJECT_DEFACTIONCHANGE	= 08011h  ; hwnd + ID + idChild is item w/ def action change
EVENT_OBJECT_ACCELERATORCHANGE	= 08012h  ; hwnd + ID + idChild is item w/ keybd accel change

;
; Child IDs
;

;
; System Sounds (idChild of system SOUND notification)
;
SOUND_SYSTEM_STARTUP		= 1
SOUND_SYSTEM_SHUTDOWN		= 2
SOUND_SYSTEM_BEEP		= 3
SOUND_SYSTEM_ERROR		= 4
SOUND_SYSTEM_QUESTION		= 5
SOUND_SYSTEM_WARNING		= 6
SOUND_SYSTEM_INFORMATION	= 7
SOUND_SYSTEM_MAXIMIZE		= 8
SOUND_SYSTEM_MINIMIZE		= 9
SOUND_SYSTEM_RESTOREUP		= 10
SOUND_SYSTEM_RESTOREDOWN	= 11
SOUND_SYSTEM_APPSTART		= 12
SOUND_SYSTEM_FAULT		= 13
SOUND_SYSTEM_APPEND		= 14
SOUND_SYSTEM_MENUCOMMAND	= 15
SOUND_SYSTEM_MENUPOPUP		= 16
CSOUND_SYSTEM			= 16

;
; System Alerts (indexChild of system ALERT notification)
;
ALERT_SYSTEM_INFORMATIONAL	= 1	  ; MB_INFORMATION
ALERT_SYSTEM_WARNING		= 2	  ; MB_WARNING
ALERT_SYSTEM_ERROR		= 3	  ; MB_ERROR
ALERT_SYSTEM_QUERY		= 4	  ; MB_QUESTION
ALERT_SYSTEM_CRITICAL		= 5	  ; HardSysErrBox
CALERT_SYSTEM			= 6

struc	GUITHREADINFO
	cbSize			dd ?
	flags			dd ?
	hwndActive		dd ?
	hwndFocus		dd ?
	hwndCapture		dd ?
	hwndMenuOwner		dd ?
	hwndMoveSize		dd ?
	hwndCaret		dd ?
	rcCaret 		RECT ?
ends

GUI_CARETBLINKING		= 000000001h
GUI_INMOVESIZE			= 000000002h
GUI_INMENUMODE			= 000000004h
GUI_SYSTEMMENUMODE		= 000000008h
GUI_POPUPMENUMODE		= 000000010h

procdesc GetGUIThreadInfo :dword, :dword
procdesc GetWindowModuleFileNameA :dword, :dword, :dword

GetWindowModuleFileName 	equ <GetWindowModuleFileNameA>

STATE_SYSTEM_UNAVAILABLE	= 000000001h  ; Disabled
STATE_SYSTEM_SELECTED		= 000000002h
STATE_SYSTEM_FOCUSED		= 000000004h
STATE_SYSTEM_PRESSED		= 000000008h
STATE_SYSTEM_CHECKED		= 000000010h
STATE_SYSTEM_MIXED		= 000000020h  ; 3-state checkbox or toolbar button
STATE_SYSTEM_INDETERMINATE	= STATE_SYSTEM_MIXED
STATE_SYSTEM_READONLY		= 000000040h
STATE_SYSTEM_HOTTRACKED 	= 000000080h
STATE_SYSTEM_DEFAULT		= 000000100h
STATE_SYSTEM_EXPANDED		= 000000200h
STATE_SYSTEM_COLLAPSED		= 000000400h
STATE_SYSTEM_BUSY		= 000000800h
STATE_SYSTEM_FLOATING		= 000001000h  ; Children "owned" not "contained" by parent
STATE_SYSTEM_MARQUEED		= 000002000h
STATE_SYSTEM_ANIMATED		= 000004000h
STATE_SYSTEM_INVISIBLE		= 000008000h
STATE_SYSTEM_OFFSCREEN		= 000010000h
STATE_SYSTEM_SIZEABLE		= 000020000h
STATE_SYSTEM_MOVEABLE		= 000040000h
STATE_SYSTEM_SELFVOICING	= 000080000h
STATE_SYSTEM_FOCUSABLE		= 000100000h
STATE_SYSTEM_SELECTABLE 	= 000200000h
STATE_SYSTEM_LINKED		= 000400000h
STATE_SYSTEM_TRAVERSED		= 000800000h
STATE_SYSTEM_MULTISELECTABLE	= 001000000h  ; Supports multiple selection
STATE_SYSTEM_EXTSELECTABLE	= 002000000h  ; Supports extended selection
STATE_SYSTEM_ALERT_LOW		= 004000000h  ; This information is of low priority
STATE_SYSTEM_ALERT_MEDIUM	= 008000000h  ; This information is of medium priority
STATE_SYSTEM_ALERT_HIGH 	= 010000000h  ; This information is of high priority
STATE_SYSTEM_REDUNDANT		= 020000000h  ; this child object's data is also represented by it's parent
STATE_SYSTEM_ONLY_REDUNDANT	= 040000000h  ; this object has children, but they are all redundant
STATE_SYSTEM_VALID		= 07FFFFFFFh

CCHILDREN_TITLEBAR		= 5
CCHILDREN_SCROLLBAR		= 5

;
; Information about the global cursor.
;

struc	CURSORINFO
	cbSize			dd ?
	flags			dd ?
	hCursor 		dd ?
	ptScreenPos		POINT ?
ends

CURSOR_SHOWING			= 000000001h

procdesc GetCursorInfo :dword

;
; Window information snapshot
;

struc	WINDOWINFO
	cbSize			dd ?
	rcWindow		RECT ?
	rcClient		RECT ?
	dwStyle 		dd ?
	dwExStyle		dd ?
	dwOtherStuff		dd ?
	cxWindowBorders 	dd ?
	cyWindowBorders 	dd ?
	atomWindowType		dd ?
	wCreatorVersion 	dw ?
ends

WS_ACTIVECAPTION		= 00001h

procdesc GetWindowInfo :dword, :dword

;
; Titlebar information.
;

struc	TITLEBARINFO
	cbSize			dd ?
	rcTitleBar		RECT ?
	rgstate 		dd (CCHILDREN_TITLEBAR+1) dup (?)
ends

procdesc GetTitleBarInfo :dword, :dword

;
; Menubar information
;

struc	MENUBARINFO
	cbSize			dd ?
	rcBar			RECT ?		; rect of bar, popup, item
	hMenu			dd ?		; real menu handle of bar, popup
	hwndMenu		dd ?		; hwnd of item submenu if one
	Flags			dd ?
;	fBarFocused		dd :1 ? 	; bar, popup has the focus
;	fFocused		dd :1 ? 	; item has the focus
ends

procdesc GetMenuBarInfo :dword, :dword, :dword, :dword

;
; Scrollbar information
;

struc	SCROLLBARINFO
	cbSize			dd ?
	rcScrollBar		RECT ?
	dxyLineButton		dd ?
	xyThumbTop		dd ?
	xyThumbBottom		dd ?
	bogus			dd ?
	rgstate 		dd (CCHILDREN_SCROLLBAR+1) dup (?)
ends

procdesc GetScrollBarInfo :dword, :dword, :dword

;
; Combobox information
;

struc	COMBOBOXINFO
	cbSize			dd ?
	rcItem			RECT ?
	rcButton		RECT ?
	stateButton		dd ?
	hwndCombo		dd ?
	hwndItem		dd ?
	hwndList		dd ?
ends

procdesc GetComboBoxInfo :dword, :dword

;
; The "real" ancestor window
;
GA_PARENT			= 1
GA_ROOT 			= 2
GA_ROOTOWNER			= 3

procdesc GetAncestor :dword, :dword
procdesc RealChildWindowFromPoint :dword, :dword
procdesc RealGetWindowClassA :dword, :dword, :dword

RealGetWindowClass		equ <RealGetWindowClassA>

;
; Alt-Tab Switch window information.
;

struc	ALTTABINFO
	cbSize			dd ?
	cItems			dd ?
	cColumns		dd ?
	cRows			dd ?
	iColFocus		dd ?
	iRowFocus		dd ?
	cxItem			dd ?
	cyItem			dd ?
	ptStart 		POINT ?
ends

procdesc GetAltTabInfoA :dword, :dword, :dword, :dword, :dword
procdesc GetListBoxInfo :dword
procdesc LockWorkStation
procdesc UserHandleGrantAccess :dword, :dword, :dword

GetAltTabInfo			equ <GetAltTabInfoA>
