; #########################################################################

      .386
      .model flat, stdcall  ; 32 bit memory model
      option casemap :none  ; case sensitive

      include DispDesc.inc     ; local includes for this file

; #########################################################################

.code

start:
      invoke GetModuleHandle, NULL
      mov hInstance, eax

      invoke LoadLibrary,addr szLibrary
      mov hLib,eax
      .if hLib==NULL
            invoke MessageBox,NULL,addr szCannotLoadDLL,addr szDisplayName,MB_OK or MB_ICONERROR
            jmp @F
      .endif

      ; Now, load each of the 5 routines we will use
      invoke GetProcAddress,hLib,addr szGetDescriptor
      mov GetDescriptor,eax
      .if eax==NULL
            invoke MessageBox,NULL,addr szProcNotFound,addr szGetDescriptor,MB_OK or MB_ICONERROR
            invoke FreeLibrary,hLib
            jmp @F
      .endif

      invoke GetProcAddress,hLib,addr szGetLimitFromDescriptor
      mov GetLimitFromDescriptor,eax
      .if eax==NULL
            invoke MessageBox,NULL,addr szProcNotFound,addr szGetLimitFromDescriptor,MB_OK or MB_ICONERROR
            invoke FreeLibrary,hLib
            jmp @F
      .endif


      invoke GetProcAddress,hLib,addr szGetBaseFromDescriptor
      mov GetBaseFromDescriptor,eax
      .if eax==NULL
            invoke MessageBox,NULL,addr szProcNotFound,addr szGetBaseFromDescriptor,MB_OK or MB_ICONERROR
            invoke FreeLibrary,hLib
            jmp @F
      .endif


      invoke GetProcAddress,hLib,addr szGetAccessFromDescriptor
      mov GetAccessFromDescriptor,eax
      .if eax==NULL
            invoke MessageBox,NULL,addr szProcNotFound,addr szGetAccessFromDescriptor,MB_OK or MB_ICONERROR
            invoke FreeLibrary,hLib
            jmp @F
      .endif


      invoke GetProcAddress,hLib,addr szGetLDT
      mov GetLDT,eax
      .if eax==NULL
            invoke MessageBox,NULL,addr szProcNotFound,addr szGetLDT,MB_OK or MB_ICONERROR
            invoke FreeLibrary,hLib
            jmp @F
      .endif

      invoke GetCommandLine
      mov CommandLine, eax

      invoke WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
      push eax
      invoke FreeLibrary,hLib
      pop eax
@@:
      invoke ExitProcess,eax

      invoke InitCommonControls

; #########################################################################

WinMain proc hInst     :DWORD,
             hPrevInst :DWORD,
             CmdLine   :DWORD,
             CmdShow   :DWORD

      ;====================
      ; Put LOCALs on stack
      ;====================

      LOCAL wc   :WNDCLASSEX
      LOCAL msg  :MSG
      LOCAL Wwd  :DWORD
      LOCAL Wht  :DWORD
      LOCAL Wtx  :DWORD
      LOCAL Wty  :DWORD

      ;==================================================
      ; Fill WNDCLASSEX structure with required variables
      ;==================================================

      szText szClassName,"DISPDESC100"

      mov wc.cbSize,         sizeof WNDCLASSEX
      mov wc.style,          CS_HREDRAW or CS_VREDRAW \
                             or CS_BYTEALIGNWINDOW
      mov wc.lpfnWndProc,    offset WndProc
      mov wc.cbClsExtra,     NULL
      mov wc.cbWndExtra,     DLGWINDOWEXTRA
      m2m wc.hInstance,      hInst
      mov wc.hbrBackground,  COLOR_BTNFACE+1
      mov wc.lpszMenuName,   NULL
      mov wc.lpszClassName,  offset szClassName
      m2m wc.hIcon,          hIcon
        invoke LoadCursor,NULL,IDC_ARROW
      mov wc.hCursor,        eax
      m2m wc.hIconSm,        hIcon

      invoke RegisterClassEx, ADDR wc

      ;================================
      ; Centre window at following size
      ;================================

      invoke CreateDialogParam,hInstance,1000,NULL,NULL,NULL
      mov   hWnd,eax

      invoke ShowWindow,hWnd,SW_SHOWNORMAL
      invoke UpdateWindow,hWnd

        invoke GetDlgItem,hWnd,101
        mov hTab,eax
        invoke CreateDialogParam,hInstance,2000,hTab,addr LDTGDTProc,NULL
        mov hDlg,eax

      invoke GetProcessHeap
      mov hHeap,eax
      invoke HeapAlloc,eax,NULL,32768
      mov lpGDT,eax
      invoke HeapAlloc,hHeap,NULL,32768
      mov lpLDT,eax      

      ; Now, we loop through all available descriptors, global and local, and display
      ; them in the appropriate list boxes.
      invoke GetDlgItem,hWnd,200
      mov hGDT,eax
      invoke GetDlgItem,hWnd,201
      mov hLDT,eax

      push edi
      mov edi,lpGDT
      mov eax,3
      .while eax<65535
          verw ax
          jnz @F
          stosd
          push eax
          invoke wsprintf,addr szBuffer,addr szSelector,eax
          invoke SendMessage,hGDT,LB_ADDSTRING,0,addr szBuffer
          pop eax
          inc GDTCount
        @@:
          add eax,8
      .endw
      
      mov edi,lpLDT
      mov eax,7
      .while eax<65535
          mov bx,cs
          cmp ax,bx
          jz Override
          mov bx,ds
          cmp ax,bx
          jz Override
          
          verw ax
          jnz @F
        Override:
          stosd
          push eax
          invoke wsprintf,addr szBuffer,addr szSelector,eax
          invoke SendMessage,hLDT,LB_ADDSTRING,0,addr szBuffer
          pop eax
          inc LDTCount
        @@:
          add eax,8
      .endw
      pop edi

      ;===================================
      ; Loop until PostQuitMessage is sent
      ;===================================

    StartLoop:
      invoke GetMessage,ADDR msg,NULL,0,0
      cmp eax, 0
      je ExitLoop
      invoke TranslateMessage, ADDR msg
      invoke DispatchMessage,  ADDR msg
      jmp StartLoop
    ExitLoop:

      return msg.wParam

WinMain endp

; #########################################################################

WndProc proc hWin   :DWORD,
             uMsg   :DWORD,
             wParam :DWORD,
             lParam :DWORD

    LOCAL var    :DWORD
    LOCAL caW    :DWORD
    LOCAL caH    :DWORD
    LOCAL Rct    :RECT
    LOCAL hDC    :DWORD
    LOCAL Ps     :PAINTSTRUCT
    LOCAL buffer1[128]:BYTE  ; these are two spare buffers
    LOCAL buffer2[128]:BYTE  ; for text manipulation etc..
    LOCAL Worked :DWORD

    LOCAL Selector  :DWORD

    .if uMsg == WM_COMMAND
        mov eax,wParam
        mov edx,eax
        and eax,0FFFFh
        shr edx,16
        .if edx==BN_CLICKED
            .if eax==IDOK
                invoke SendMessage,hGDT,LB_GETCURSEL,0,0
                .if eax==LB_ERR
                    invoke SendMessage,hLDT,LB_GETCURSEL,0,0
                    .if eax==LB_ERR
                        invoke MessageBox,hWin,addr szNothing,
                                addr szDisplayName,MB_OK or MB_ICONSTOP
                        jmp @F
                    .else
                        mov edx,lpLDT
                    .endif
                .else
                    mov edx,lpGDT
                .endif
                mov eax,[edx+eax*4]
                invoke DisplayDescriptor,eax
        @@:                
            .elseif eax==IDHELP
                invoke MessageBox,NULL,addr szUnavail,addr szDisplayName,MB_OK or MB_ICONSTOP
            .elseif eax==IDCANCEL
                invoke PostMessage,hWin,WM_CLOSE,0,0
            .elseif eax==202
                xor eax,eax
                sldt ax
                mov Selector,eax

                ; Now, go through the entire GDT database looking for the
                ; Selector
                push esi
                mov esi,lpGDT
                mov ecx,0
                .while ecx<GDTCount
                    lodsd
                    .break .if eax==Selector
                    inc ecx
                .endw
                pop esi
                .if eax==Selector
                    ; It was found
                    invoke SendMessage,hGDT,LB_SETCURSEL,ecx,0
                .else
                    invoke SendMessage,hGDT,LB_SETCURSEL,-1,0
                    invoke wsprintf,addr buffer1,addr szLDT,ecx,0
                    invoke MessageBox,hWin,addr buffer1,addr szDisplayName,MB_OK
                .endif
                invoke SendMessage,hLDT,LB_SETCURSEL,-1,0

                invoke DisplayDescriptor,Selector
                
            .elseif eax==203
                ; CS
                xor eax,eax
                mov ax,cs
                mov Selector,eax
                push esi
                mov esi,lpLDT
                mov ecx,0
                .while ecx<LDTCount
                    lodsd
                    .break .if eax==Selector
                    inc ecx
                .endw
                pop esi
                ; CS will always be in the table
                invoke SendMessage,hLDT,LB_SETCURSEL,ecx,0
                invoke SendMessage,hGDT,LB_SETCURSEL,-1,0
                invoke DisplayDescriptor,Selector
                
            .elseif eax==204
                ; DS
                xor eax,eax
                mov ax,ds
                mov Selector,eax
                push esi
                mov esi,lpLDT
                mov ecx,0
                .while ecx<LDTCount
                    lodsd
                    .break .if eax==Selector
                    inc ecx
                .endw
                pop esi
                ; DS will always be in the table
                invoke SendMessage,hLDT,LB_SETCURSEL,ecx,0
                invoke SendMessage,hGDT,LB_SETCURSEL,-1,0
                invoke DisplayDescriptor,Selector

            .elseif eax==205
                sgdt GDTR
                invoke wsprintf,addr buffer1,addr szGDTBase,GDTBase
                invoke MessageBox,hWin,addr buffer1,addr szDisplayName,MB_OK
                
            .endif
        .elseif edx==LBN_SELCHANGE
            mov eax,hGDT
            .if lParam==eax
                invoke SendMessage,hLDT,LB_SETCURSEL,-1,NULL
            .else
                invoke SendMessage,hGDT,LB_SETCURSEL,-1,NULL
            .endif
        .elseif edx==LBN_DBLCLK
            mov eax,lParam
            ; Now, we retrieve and display the selector
            .if eax==hLDT
                mov edx,lpLDT
            .else
                mov edx,lpGDT
            .endif
            push edx
            invoke SendMessage,eax,LB_GETCURSEL,0,0
            pop edx
            mov eax,[edx+eax*4]
            mov Selector,eax
            invoke DisplayDescriptor,Selector
        .endif
@@:        

    ;======== menu commands ========
    .elseif uMsg == WM_CREATE

    .elseif uMsg == WM_SIZE

    .elseif uMsg == WM_PAINT
        invoke BeginPaint,hWin,ADDR Ps
          mov hDC, eax
          invoke Paint_Proc,hWin,hDC
        invoke EndPaint,hWin,ADDR Ps
        return 0

    .elseif uMsg == WM_CLOSE
        szText TheText,"Please Confirm Exit"
        invoke MessageBox,hWin,ADDR TheText,ADDR szDisplayName,MB_YESNO
          .if eax == IDNO
            return 0
          .endif

    .elseif uMsg == WM_DESTROY
        invoke PostQuitMessage,NULL
        return 0 
    .endif

    invoke DefWindowProc,hWin,uMsg,wParam,lParam

    ret

WndProc endp

; ########################################################################

TopXY proc wDim:DWORD, sDim:DWORD

    shr sDim, 1      ; divide screen dimension by 2
    shr wDim, 1      ; divide window dimension by 2
    mov eax, wDim    ; copy window dimension into eax
    sub sDim, eax    ; sub half win dimension from half screen dimension

    return sDim

TopXY endp

; #########################################################################

Paint_Proc proc hWin:DWORD, hDC:DWORD

    LOCAL btn_hi   :DWORD
    LOCAL btn_lo   :DWORD
    LOCAL Rct      :RECT

    invoke GetSysColor,COLOR_BTNHIGHLIGHT
    mov btn_hi, eax

    invoke GetSysColor,COLOR_BTNSHADOW
    mov btn_lo, eax

    return 0

Paint_Proc endp

LDTGDTProc  proc        hWin:DWORD,
                        uMsg:DWORD,
                        wParam:DWORD,
                        lParam:DWORD

    .if uMsg==WM_INITDIALOG
        return TRUE
    .endif
    return FALSE
LDTGDTProc  endp

; ########################################################################

DisplayDescriptor   proc    Selector:DWORD

    LOCAL Temp      :DWORD
    LOCAL Var       :DWORD
    LOCAL Access    :DWORD

    ; Okay, let's begin.  First, we retrieve the descriptor
    push offset Descriptor
    push Selector
    call GetDescriptor

    ; Now, we retrieve the base address
    push offset Descriptor
    call GetBaseFromDescriptor
    mov Temp,eax

    invoke wsprintf,addr szBuffer,addr szEight,Temp
    invoke GetDlgItem,hDlg,104
    mov Temp,eax
    invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szBuffer

    ; Now, we retrieve the full limit
    push offset Descriptor
    call GetLimitFromDescriptor
    mov Temp,eax

    invoke wsprintf,addr szBuffer,addr szEight,Temp
    invoke GetDlgItem,hDlg,103
    mov Temp,eax
    invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szBuffer

    ; Now, we retrieve the visible limit by hand
    xor eax,eax
    mov ah,DLimitHigh
    shl eax,8
    mov ax,DLimitLow
    and eax,0FFFFFh

    invoke wsprintf,addr szBuffer,addr szFive,eax
    invoke GetDlgItem,hDlg,102
    mov Temp,eax
    invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szBuffer

    ; Now, we retrieve the access word
    push offset Descriptor
    call GetAccessFromDescriptor
    mov Access,eax

    invoke wsprintf,addr szBuffer,addr szFour,Access
    invoke GetDlgItem,hDlg,105
    mov Temp,eax
    invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szBuffer

    ; Now, we retrieve and display the IOPL
    mov eax,Access
    and eax,60h
    shr eax,5

    invoke wsprintf,addr szBuffer,addr szOne,eax
    invoke GetDlgItem,hDlg,106
    mov Temp,eax
    invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szBuffer

    ; Now, we modify the Read / Write text according to segment style
    invoke GetDlgItem,hDlg,122
    mov Temp,eax
    test Access,8
    .if zero?
        invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szWrite
        invoke CheckDlgButton,hDlg,124,BST_UNCHECKED
    .else
        invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szRead
        invoke CheckDlgButton,hDlg,124,BST_CHECKED
    .endif

    ; Now, detect flags
    ; Granularity
    test Access,8000h
    .if zero?
        invoke CheckDlgButton,hDlg,113,BST_UNCHECKED
    .else
        invoke CheckDlgButton,hDlg,113,BST_CHECKED
    .endif
    
    ; 32 bit
    test Access,4000h
    .if zero?
        invoke CheckDlgButton,hDlg,115,BST_UNCHECKED
    .else
        invoke CheckDlgButton,hDlg,115,BST_CHECKED
    .endif

    ; 32 bit
    test Access,4000h
    .if zero?
        invoke CheckDlgButton,hDlg,115,BST_UNCHECKED
    .else
        invoke CheckDlgButton,hDlg,115,BST_CHECKED
    .endif

    ; OS defined
    test Access,1000h
    .if zero?
        invoke CheckDlgButton,hDlg,117,BST_UNCHECKED
    .else
        invoke CheckDlgButton,hDlg,117,BST_CHECKED
    .endif

    ; Present
    test Access,80h
    .if zero?
        invoke CheckDlgButton,hDlg,119,BST_UNCHECKED
    .else
        invoke CheckDlgButton,hDlg,119,BST_CHECKED
    .endif

    ; Expandable
    invoke GetDlgItem,hDlg,125
    mov Temp,eax
    test Access,4
    .if zero?
        test Access,8
        .if zero?
            invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szExpandable
            invoke CheckDlgButton,hDlg,123,BST_UNCHECKED
        .else
            invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szConforming
            invoke CheckDlgButton,hDlg,123,BST_UNCHECKED
        .endif
    .else
        test Access,8
        .if zero?
            invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szExpandable
            invoke CheckDlgButton,hDlg,123,BST_CHECKED
        .else
            invoke SendMessage,Temp,WM_SETTEXT,NULL,addr szConforming
            invoke CheckDlgButton,hDlg,123,BST_CHECKED
        .endif
    .endif

    ; Read / Write
    test Access,2
    .if zero?
        invoke CheckDlgButton,hDlg,120,BST_UNCHECKED
    .else
        invoke CheckDlgButton,hDlg,120,BST_CHECKED
    .endif

    ; Accessed
    test Access,1
    .if zero?
        invoke CheckDlgButton,hDlg,205,BST_UNCHECKED
    .else
        invoke CheckDlgButton,hDlg,205,BST_CHECKED
    .endif
    ret
DisplayDescriptor   endp

end start
