.386
.model flat,stdcall
option casemap:none
include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comctl32.inc
include \masm32\include\wsock32.inc
include \masm32\include\comdlg32.inc
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\wsock32.lib
includelib \masm32\lib\comdlg32.lib

WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD
StrLen PROTO :DWORD
InString PROTO :DWORD,:DWORD
InStringi PROTO :DWORD,:DWORD
ConnectSocket PROTO :DWORD
GetHandlesOfChildWindows PROTO :DWORD
TranslateErrorCode PROTO :DWORD,:DWORD
ToggleControls PROTO :DWORD
MakeConnection PROTO :DWORD
ParseURL PROTO :DWORD
String2Dword PROTO :DWORD
ShowErrorMessage PROTO :DWORD
GetErrorString PROTO :DWORD
RequestEOZ PROTO :DWORD
ShowSocketError PROTO :DWORD,:DWORD
GetPercentComplete PROTO 
ReadSocket PROTO :DWORD
ParseHeader PROTO :DWORD,:DWORD
ParseEOZ PROTO :DWORD
GetHeader PROTO :DWORD,:DWORD,:DWORD,:DWORD
SetStatusText PROTO :DWORD,:DWORD
ClearMessages PROTO :DWORD, :DWORD
CheckIfCanResume PROTO
FillTheData PROTO :DWORD,:DWORD,:DWORD
GetMultipartHeader PROTO :DWORD,:DWORD,:DWORD
RequestCD PROTO :DWORD
ParseCD PROTO :DWORD
FillActualData PROTO :DWORD
DownloadFiles PROTO :DWORD
RequestZipFile PROTO :DWORD
CheckForOtherFiles PROTO :DWORD
ParseLocalHeader PROTO :DWORD
RequestActualData PROTO :DWORD
ParseMultipartHeader PROTO
SetUpListView PROTO
WinMain PROTO :DWORD, :DWORD, :DWORD,:DWORD
FindItemInCentralDir PROTO :DWORD
DisplayProgress PROTO

.const
IDD_FORM         equ               101
IDC_URL          equ               1000
IDC_NAMELIST     equ               1002
IDC_OK           equ               1003
IDC_CANCEL       equ               1004
IDC_URLOK        equ               1006
IDC_CANCELURL    equ               1007

WM_SOCKET equ WM_USER+1000
.data?
hInstance dd ?
wsa WSADATA <?>
HTTPPort dd ?
SocketAddress sockaddr_in <?>
sock DWORD ?
sizetoread dd ?
HTTPIndex dd ?
MultipartIndex dd ?
ContentLength dd ?
EndOfZip db 1024 dup(?)
EOZIndex dd ?
CanResume dd ?
CDIndex dd ?
FileHandle dd ?
BytesWritten dd ?
FileName db 256 dup(?)
StartingOffset dd ?
LocalIndex dd ?
lpRelOffset dd ?
DirSize dd ?
CDOffset dd ?
ActualBytesWritten dd ?

hZipDir dd ?
pZipDir dd ?

PrevIndex dd ?
CurrentIndex dd ?
ofn OPENFILENAME <>

;==========================   Child window handles =====================
hwndURLOK dd ?
hwndCancelURL dd ?
hwndURL dd ?
hwndList dd ?
hwndOK dd ?
hwndCancel dd ?
hwndStatus dd ?
lvcol LV_COLUMN <>
ZipFileName db 512 dup(?)

.data
MultipartHeader db 512 dup(?),0
HTTPHeader db 512 dup(?),0
ContentString db 10 dup(?),0
StatusCode db 3 dup(?),0
URLString db 512 dup(?),0
LocalHeader db 30 dup(?),0
HostName db 100 dup(?),0
PortString db 10 dup(?),0
RelativeURL db 400 dup(?),0
AppName db "Iczelion's zip downloader",0
WSAStartupError db "Cannot Initialize Winsock DLL",0
HTTP db "http://",0
Content db "content-length:",0
FileNotFound db "File not found",0
Multipart db "multipart/",0
AcceptRange db "accept-ranges:",0
CannotResume db "This server cannot resume download",0
HTTPError db "HTTP error!",0
DateTemplate db "%lu-%lu-%lu",0
TimeTemplate db "%lu:%.2lu",0
ValueTemplate db "%lu",0
FilterString db "zip archive",0,"*.zip",0
             db "all file",0,"*.*",0,0
StateFlag db 0          ; 0= Connection is not yet begun
                        ; 1= Socket created for reading the end of zip
                        ; 2= Multipart header not yet parsed
EOZTemplate db "GET %s HTTP/1.0",0Dh,0Ah
            db "Host: %s",0Dh,0Ah
            db "Range: bytes=-%lu",0Dh,0Ah
            db "User-Agent: IczelionDownLoad",0Dh,0Ah
            db "Connection: Close",0Dh,0Ah
            db "Accept: text/*,image/*,application/*,*/*",0Dh,0Ah,0dh,0ah,0
CDTemplate  db "GET %s HTTP/1.0",0Dh,0Ah
            db "Host: %s",0Dh,0Ah
            db "Range: bytes=%lu-%lu",0Dh,0Ah
            db "User-Agent: IczelionDownLoad",0Dh,0Ah
            db "Connection: Close",0Dh,0Ah
            db "Accept: text/*,image/*,application/*,*/*",0Dh,0Ah,0dh,0ah,0
Resolving db "Resolving %s",0
Connecting db "Connecting to: %s",0
Connected db "Host %s contacted. Waiting for reply..",0
ReadingHeader db "Reading HTTP header...",0
ConnectionClosed db "The connection is closed",0
InvalidFile db "This is not a valid zip file",0
GettingCD db "Requesting for Central Directory",0
NotSelected db "No file selected",0
Downloading db "Downloading....",0
Finish db "Download Finished!",0
NoContent db "Content Length not found. Contact Iczelion",0
ClassName db "ZipDownloadClass",0
FileNameText db "Filename",0
DateText db "date",0
TimeText db "time",0
UncompressedText db "uncompressed size",0
CompressedText db "compressed size",0
ReadingCD db "Reading Central Directory...%lu percent done",0
ReadingData db "%s --- %lu percent done",0
EOZSize dd 22
EOZSignature dd 06054B50h,0
CDSize dd 2048

.code
start:
        invoke WSAStartup,101h,addr wsa
        .if eax==NULL
                invoke GlobalAlloc,GHND,CDSize
                mov hZipDir,eax
                invoke GlobalLock,eax
                mov pZipDir,eax
                invoke GetModuleHandle,NULL
                mov hInstance,eax
                invoke WinMain, eax,NULL, NULL, SW_SHOWDEFAULT
                invoke WSACleanup
                invoke GlobalUnlock,pZipDir
                invoke GlobalFree,hZipDir
        .else
                invoke MessageBox,NULL,addr WSAStartupError,addr AppName,MB_OK+MB_ICONERROR
        .endif
        invoke ExitProcess,NULL

WinMain PROC hInst:DWORD,hPrev:DWORD,CmdLine:DWORD,CmdShow:DWORD
        LOCAL wc:WNDCLASSEX
        LOCAL msg:MSG
        LOCAL hWnd:DWORD
        mov   wc.cbSize,SIZEOF WNDCLASSEX
        mov   wc.style, CS_HREDRAW or CS_VREDRAW
        mov   wc.lpfnWndProc, OFFSET WndProc
        mov   wc.cbClsExtra,NULL
        mov   wc.cbWndExtra,DLGWINDOWEXTRA
        push  hInstance
        pop   wc.hInstance
        mov   wc.hbrBackground,COLOR_BTNFACE+1
        mov   wc.lpszMenuName,NULL
        mov   wc.lpszClassName,OFFSET ClassName
        invoke LoadIcon,NULL,IDI_APPLICATION
        mov   wc.hIcon,eax
        mov   wc.hIconSm,0
        invoke LoadCursor,NULL,IDC_ARROW
        mov   wc.hCursor,eax
        invoke RegisterClassEx, addr wc
        invoke InitCommonControls
        invoke CreateDialogParam,hInstance,IDD_FORM,NULL,NULL,NULL
        mov   hWnd,eax
        invoke GetHandlesOfChildWindows,hWnd
        invoke SetFocus,hwndURL
        invoke SetUpListView
        .while TRUE
                invoke GetMessage, ADDR msg,NULL,0,0
                .break .if (!eax)
                invoke IsDialogMessage,hWnd,addr msg
                .if eax==FALSE
                        invoke TranslateMessage, ADDR msg
                        invoke DispatchMessage, ADDR msg
                .endif
        .endw
        mov     eax,msg.wParam
        ret        
WinMain ENDP                

WndProc PROC hWnd:DWORD,Msg:DWORD,wParam:DWORD, lParam:DWORD
        .if Msg==WM_DESTROY
                .if StateFlag!=0
                        invoke closesocket,sock
                        .if StateFlag>=7
                                invoke CloseHandle,FileHandle
                        .endif
                .endif
               invoke PostQuitMessage,NULL
        .elseif Msg==WM_CREATE
                invoke CreateStatusWindow,WS_CHILD+WS_VISIBLE,NULL,hWnd,1
                mov hwndStatus,eax
        .elseif Msg==WM_COMMAND
                mov eax,wParam
                .if ax==IDC_CANCELURL
                        shr eax,16
                        .if ax==BN_CLICKED
                                invoke SetDlgItemText,hWnd,IDC_URL,NULL
                                invoke SetFocus,hwndURL
                        .endif
                .elseif ax==IDC_URLOK
                        shr eax,16
                        .if ax==BN_CLICKED
                                invoke GetDlgItemText,hWnd,IDC_URL,addr URLString,512
                                .if eax!=0                                
                                        invoke ConnectSocket,hWnd
                                .else
                                        invoke SetFocus,hwndURL
                                .endif
                        .endif
                .elseif ax==IDC_CANCEL
                        shr eax,16
                        .if ax==BN_CLICKED                                
                                invoke ToggleControls,hWnd
                                invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_DELETEALLITEMS,NULL,NULL
                                invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
                                .if StateFlag>=7
                                        invoke CloseHandle,FileHandle
                                .endif
                                mov StateFlag,0
                        .endif
                .elseif ax==IDC_OK
                        shr eax,16
                        .if ax==BN_CLICKED
                                .if StateFlag==7        ; Waiting for selection
                                        mov ofn.lStructSize,SIZEOF ofn
                                        push hWnd
                                        pop  ofn.hWndOwner
                                        push hInstance
                                        pop  ofn.hInstance
                                        mov  ofn.lpstrFilter, OFFSET FilterString
                                        mov  ofn.lpstrFile, OFFSET FileName
                                        mov  ofn.nMaxFile,sizeof FileName
                                        mov ofn.Flags,OFN_LONGNAMES or\
                                                OFN_EXPLORER or OFN_HIDEREADONLY
                                        invoke GetSaveFileName, ADDR ofn                
                                        .if eax==TRUE
                                                invoke DownloadFiles,hWnd
                                        .else
                                                mov StateFlag,0
                                                invoke ToggleControls,hWnd                                                
                                                invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_DELETEALLITEMS,NULL,NULL
                                                invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
                                        .endif
                                .endif
                        .endif
                .endif
        .elseif Msg==WM_SOCKET
                mov eax,lParam
                .if ax==FD_CONNECT
                        shr eax,16
                        .if ax==0
                                .if StateFlag==1        ; Socket created for reading the end of zip file
                                        invoke RequestEOZ,hWnd
                                .elseif StateFlag==4    ; Request for Central Directory
                                        invoke RequestCD,hWnd
                                .elseif StateFlag==7
                                        invoke RequestZipFile,hWnd
                                .elseif StateFlag==10
                                        invoke RequestActualData,hWnd
                                .endif
                        .else
                                invoke ShowSocketError,hWnd,eax
                        .endif
                .elseif ax==FD_READ
                        shr eax,16
                        .if ax==0
                                invoke ReadSocket,hWnd
                        .else
                                invoke ShowSocketError,hWnd,eax
                        .endif
                .else   ; FD_CLOSE
                        shr eax,16
                        .if ax==0
                                invoke closesocket,sock
                                .if StateFlag==2
                                        invoke ParseEOZ,hWnd
                                .elseif StateFlag==5
                                        invoke ParseCD,hWnd
                                .elseif StateFlag==8
                                        invoke ParseLocalHeader,hWnd
                                .elseif StateFlag==11
                                        invoke CheckForOtherFiles,hWnd
                                .endif
                        .else
                                invoke ShowSocketError,hWnd,eax
                        .endif
                .endif
        .else
                invoke DefWindowProc,hWnd,Msg,wParam,lParam
                ret
        .endif
        xor eax,eax
        ret
WndProc ENDP

String2Dword proc uses ecx edi edx esi String:DWORD
		  LOCAL Result:DWORD
		  mov Result,0
        mov edi,String
        invoke lstrlen,String
        .while eax!=0
                xor edx,edx
                mov dl,byte ptr [edi]
                sub dl,"0"      ; subtrack each digit with "0" to convert it to hex value
                mov esi,eax
                dec esi
                push eax
                mov eax,edx
                push ebx
                mov ebx,10
                .while esi > 0
                        mul ebx
                        dec esi
                .endw
                pop ebx
                add Result,eax
                pop eax
                inc edi
                dec eax
        .endw
        mov eax,Result
        ret
String2Dword endp

GetFileName proc URL:DWORD
        invoke RtlFillMemory,addr FileName,256,0
        invoke lstrlen,URL
        std               ; We will search for "/" in reverse direction
        mov edi,URL
        add edi,eax
        dec edi
        mov ecx,eax
        mov al,"/"
        repne scasb
        cld
        jne No_name
        cmp byte ptr [edi],"/"
        je  No_name
        inc edi
        inc edi
        invoke lstrcpy,addr FileName,edi
No_name:
        ret
GetFileName endp

ParseURL PROC uses esi edi URL:DWORD
        LOCAL MyURL[512]:BYTE
        LOCAL URLLength:DWORD
        invoke GetFileName,URL
        invoke lstrlen,URL
        mov URLLength,eax
        mov ecx,eax             ; Trim the spaces at the start of the url string, if any
        mov edi,URL
        mov al,20h
        repe scasb
        dec edi
        invoke lstrcpy,addr MyURL,edi           ; We don't want to modify the original url string since we have to modify the cases of the url
        invoke lstrcpy,URL,addr MyURL
        invoke lstrlen,URL
        mov URLLength,eax
        invoke RtlFillMemory,addr HostName,501,0   ; fill HostName and RelativeURL with zeroes
        invoke CharLower,addr MyURL             ; change to lower case for ease of comparison
        lea edi,MyURL
        mov esi,offset HTTP             ; check if the url starts with "http://"
        mov ecx,7
        repe cmpsb
        jne No_HTTP
        mov eax,URLLength       ; if it is, substract the length of url string by 7 to
        sub eax,7               ; account for the length of "http://" string
        mov URLLength,eax
        jmp Common_parse
No_HTTP:
        lea edi,MyURL
Common_parse:
        push edi
        invoke lstrcpy,addr MyURL,URL
        pop edi
        xor ecx,ecx
        mov esi,offset HostName
        mov HTTPPort,80         ; Default port =80
        .while ecx < URLLength
                .if byte ptr [edi]=="/"         ; if "/" is found, it denotes the end of the host name string
                        invoke lstrcpy,addr RelativeURL,edi     ; and the start of the relative url string
                        .break
                .elseif byte ptr [edi]==":"     ; if ":" is found, it means an HTTP port is specified in the url
                        inc ecx
                        inc edi
                        invoke RtlFillMemory,addr PortString,10,0
                        mov eax,offset PortString
                        .while (byte ptr [edi]!="/") && (byte ptr [edi]!=0)
                                mov dl,byte ptr [edi]
                                mov byte ptr [eax],dl
                                inc eax
                                inc ecx
                                inc edi
                        .endw
                        invoke String2Dword,addr PortString
                        mov HTTPPort,eax
                .else
                        mov al,byte ptr [edi]
                        mov byte ptr [esi],al
                        inc edi
                        inc esi
                        inc ecx
                .endif
        .endw
        .if ecx==URLLength      ; if there's no relative URL , we must add "/" to it.
                mov byte ptr [RelativeURL],"/"
        .endif
        ret
ParseURL endp

ToggleControls PROC hWnd:DWORD
        invoke IsWindowEnabled,hwndURL
        .if eax==TRUE
                invoke EnableWindow,hwndURL,FALSE
                invoke EnableWindow,hwndURLOK,FALSE
                invoke EnableWindow,hwndCancelURL,FALSE
                invoke EnableWindow,hwndList,TRUE
                invoke EnableWindow,hwndOK,TRUE
                invoke EnableWindow,hwndCancel,TRUE
        .else
                invoke EnableWindow,hwndURL,TRUE
                invoke EnableWindow,hwndURLOK,TRUE
                invoke EnableWindow,hwndCancelURL,TRUE
                invoke EnableWindow,hwndList,FALSE
                invoke EnableWindow,hwndOK,FALSE
                invoke EnableWindow,hwndCancel,FALSE
        .endif
        ret
ToggleControls ENDP

GetHandlesOfChildWindows PROC hWnd:DWORD
        invoke GetDlgItem,hWnd,IDC_URL
        mov hwndURL,eax
        invoke GetDlgItem,hWnd,IDC_URLOK
        mov hwndURLOK,eax
        invoke GetDlgItem,hWnd,IDC_CANCELURL
        mov hwndCancelURL,eax
        invoke GetDlgItem,hWnd,IDC_NAMELIST
        mov hwndList,eax
        invoke GetDlgItem,hWnd,IDC_OK
        mov hwndOK,eax
        invoke GetDlgItem,hWnd,IDC_CANCEL
        mov hwndCancel,eax
        ret
GetHandlesOfChildWindows ENDP

TranslateErrorCode proc ErrCode:DWORD, pErrString:DWORD
        invoke LoadString,hInstance,ErrCode,pErrString,512
        .if eax==0
                invoke LoadString,hInstance,1,pErrString,512
        .endif
        ret
TranslateErrorCode endp

GetErrorString proc pErrString:DWORD
        invoke WSAGetLastError
        push eax
        invoke TranslateErrorCode,eax,pErrString
        pop eax
        ret
GetErrorString endp

ShowErrorMessage PROC hWnd:DWORD
        LOCAL Buffer[512]:BYTE
        invoke GetErrorString,addr Buffer
        invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
        invoke MessageBox,NULL,addr Buffer,addr AppName,MB_OK+MB_ICONERROR
        invoke closesocket,sock
        mov StateFlag,0
        ret
ShowErrorMessage ENDP

SetStatusText PROC Text:DWORD, Text1:DWORD
        LOCAL Buffer[200]:BYTE
		  invoke wsprintf,addr Buffer,Text,Text1
        invoke SetWindowText,hwndStatus,addr Buffer
        ret
SetStatusText ENDP

;========================================================================
;                               MakeConnection
;========================================================================
; Create a socket , parse the URL string and connect to the host
; Return true if all operations are successful, FALSE otherwise
;========================================================================
MakeConnection PROC hWnd:DWORD
        invoke socket,PF_INET,SOCK_STREAM,0
        .if eax!=SOCKET_ERROR
                mov sock,eax
                .if StateFlag==1
                        invoke ParseURL,addr URLString
                        invoke SetStatusText,addr Resolving,addr HostName
                        invoke inet_addr,addr HostName
                        .if eax==INADDR_NONE
                                invoke gethostbyname,addr HostName     ; Use this function to get the host ip address from host name.
                                .if eax==NULL
                                        invoke ShowErrorMessage,hWnd
                                        mov eax,FALSE
                                        ret
                                .endif
                                mov eax,[eax+12]
                                mov eax,[eax]
                                mov eax,[eax]
                                mov SocketAddress.sin_addr,eax
                        .else
                                mov SocketAddress.sin_addr,eax
                        .endif
                        mov SocketAddress.sin_family,AF_INET
                        invoke htons,HTTPPort   ; We must convert host byte order to network byte order
                        mov SocketAddress.sin_port,ax
                .endif
                invoke WSAAsyncSelect,sock,hWnd,WM_SOCKET,\     ; We choose to receive notification about successful connection,
                        FD_CONNECT or FD_READ or FD_CLOSE ; incoming data, and when the socket is closed
                .if eax==NULL
                        invoke SetStatusText,addr Connecting,addr HostName
                        invoke connect,sock,addr SocketAddress,sizeof SocketAddress     ; Make a connection with the remote host
                                                                        ; Since we operate in non-blocking mode, we wait for the window socket to call us when
                                                                        ; the events we are interested in occur.
                        .if eax==SOCKET_ERROR
                                invoke WSAGetLastError
                                .if eax!=WSAEWOULDBLOCK
                                        invoke ShowErrorMessage,hWnd
                                .else
                                        mov eax,TRUE
                                        ret
                                .endif
                        .endif
                .else
                        invoke ShowErrorMessage,hWnd
                .endif
        .else
                invoke ShowErrorMessage,hWnd
        .endif
        mov eax,FALSE                
        ret
MakeConnection ENDP

;=====================================================================
;                               StrLen
;=====================================================================
; This procedure takes an address of a string as its parameter and
; returns the length of the string in eax
;=====================================================================
StrLen PROC uses edi String:DWORD
        mov edi,String
        mov al,0
        mov ecx,0FFFFFFFFh
        repne scasb
        sub ecx,0FFFFFFFFh
        neg ecx
        dec ecx
        mov eax,ecx
        ret
StrLen ENDP
;=====================================================================
;                               StrCpy
;=====================================================================
; This procedure copies a string into a buffer. If the buffer is smaller
; than the string to copy, it returns 0.
;=====================================================================
StrCpy PROC uses edi esi StrBuffer:DWORD,String:DWORD
        invoke StrLen,String
        mov ecx,eax
        mov edi,StrBuffer
        mov esi,String
        rep movsb
        ret
StrCpy ENDP
;=========================================================================
;                               InString
;=========================================================================
; Search for a substring in one string. Case Sensitive
; Return Value: -1 if substring not found, offset of the first byte
; of the substring if successful
;=========================================================================
InString PROC uses ebx edi esi StrMain:DWORD, StrSub:DWORD
        invoke StrLen,StrMain
        mov ecx,eax
        push ecx
        invoke StrLen,StrSub
        pop ecx
        mov ebx,eax
        .if ecx<eax
                mov eax,FALSE
        .elseif ecx==eax
                mov esi,StrMain
                mov edi,StrSub
                repe cmpsb
                je Equal
                mov eax,FALSE
                jmp GetOut
Equal:
                xor eax,eax
GetOut:                
        .else
                sub ecx,eax
                inc ecx
                mov eax,ecx
                xor edx,edx
                push eax                
                .while eax!=0
                        mov edi,StrMain
                        add edi,edx
                        mov esi,StrSub
                        mov ecx,ebx
                        repe cmpsb
                        je Found
                        jmp DontFind
Found:
                        .break        
DontFind:
                        inc edx
                        dec eax
                .endw
                pop ecx
                .if eax!=0
                        sub ecx,eax
                        mov eax,ecx 
                .else
                        mov eax,-1
                .endif
        .endif
        ret
InString ENDP
;=====================================================================
;                               InStringi
;=====================================================================
; Search for a substring in one string. Case insensitive
; Return Value: -1 if substring not found, offset of the first byte
; of the substring if successful
;=========================================================================
InStringi PROC StrMain:DWORD,StrSub:DWORD
        LOCAL hMemory1:DWORD
        LOCAL pMemory1:DWORD
        LOCAL hMemory2:DWORD
        LOCAL pMemory2:DWORD
        invoke StrLen,StrMain
        inc eax
        invoke GlobalAlloc,GHND,eax
        .if eax==NULL
                mov eax,-1
        .else
                mov hMemory1,eax
                invoke GlobalLock,eax
                .if eax==NULL
                        invoke GlobalFree,hMemory1
                        mov eax,-1
                .else
                        mov pMemory1,eax
                        invoke StrLen,StrSub
                        inc eax
                        invoke GlobalAlloc,GHND,eax
                        .if eax==NULL
                                invoke GlobalUnlock,pMemory1
                                invoke GlobalFree,hMemory1
                                mov eax,-1
                        .else
                                mov hMemory2,eax
                                invoke GlobalLock,eax
                                .if eax==NULL
                                        invoke GlobalUnlock,pMemory1
                                        invoke GlobalFree,hMemory1
                                        invoke GlobalFree,hMemory2
                                        mov eax,-1
                                .else
                                        mov pMemory2,eax
                                        invoke StrCpy,pMemory1,StrMain
                                        invoke StrCpy,pMemory2,StrSub
                                        invoke CharLower,pMemory1
                                        invoke CharLower,pMemory2
                                        invoke InString,pMemory1,pMemory2
                                        push eax
                                        invoke GlobalUnlock,pMemory1
                                        invoke GlobalFree,hMemory1
                                        invoke GlobalUnlock,pMemory2
                                        invoke GlobalFree,hMemory2
                                        pop eax
                                .endif
                        .endif
                .endif
        .endif
        ret
InStringi ENDP 

ShowSocketError PROC hWnd:DWORD,ErrCode:DWORD
        LOCAL ErrorString[512]:BYTE
        invoke TranslateErrorCode,ErrCode,addr ErrorString
        invoke MessageBox,hWnd,addr ErrorString,addr AppName,MB_OK+MB_ICONERROR
        invoke closesocket,sock
        mov StateFlag,0
        invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_DELETEALLITEMS,NULL,NULL
        invoke ToggleControls,hWnd        
        ret
ShowSocketError ENDP

RequestEOZ PROC hWnd:DWORD
        LOCAL buffer[512]:BYTE
		  invoke wsprintf,addr buffer, addr EOZTemplate,addr RelativeURL,addr HostName,EOZSize
        invoke SetStatusText,addr Connecting,addr HostName
        invoke lstrlen,addr buffer
        invoke send,sock,addr buffer,eax,0
        .if eax==SOCKET_ERROR
                invoke ShowErrorMessage,hWnd
                invoke ToggleControls,hWnd
                mov StateFlag,0
        .else
                invoke SetStatusText,addr Connected,addr HostName
                mov HTTPIndex,0
                mov MultipartIndex,0
                mov EOZIndex,0
                mov ActualBytesWritten,0
        .endif
        ret
RequestEOZ ENDP

ParseHeader PROC uses esi ecx edi hWnd:DWORD,Header:DWORD
        LOCAL MyHeader[512]:BYTE
        invoke lstrcpy,addr MyHeader,Header
        invoke CharLower,addr MyHeader ; Convert the http header to lower case
        invoke lstrlen,addr MyHeader
        mov ecx,eax
        lea edi,MyHeader
        mov al," "
        repne scasb
        .if byte ptr [edi]==" "
                repe scasb
                dec edi
        .endif
        mov ecx,3
        mov esi,edi
        mov edi,offset StatusCode
        rep movsb
        invoke InStringi,addr MyHeader,addr Content
        .if eax!=-1
                mov edi,offset ContentString
                lea ecx,MyHeader
                add eax,ecx
                add eax,15
                .while byte ptr [eax]!=0 && byte ptr [eax]!=0Dh && byte ptr [eax]!=0Ah
                        .if byte ptr [eax]!=" "
                                mov cl,byte ptr [eax]
                                mov byte ptr [edi],cl
                                inc edi
                        .endif
                        inc eax
                .endw
                mov byte ptr [edi],0
                invoke String2Dword,addr ContentString
                mov ContentLength,eax
        .else
                mov ContentLength,0
        .endif
        mov eax,TRUE
        ret
ParseHeader endp

ClearMessages PROC hWnd:DWORD,Message:DWORD
        LOCAL MyMSG:MSG
        mov eax,TRUE
        .while eax==TRUE        ; Since there may be WM_SOCKET messages left in the message queues,
                                ; we must get rid of them before we create new socket.
                invoke PeekMessage,addr MyMSG,hWnd,Message,Message,PM_REMOVE
        .endw
       ret
ClearMessages ENDP

GetHeader PROC uses edi esi hWnd:DWORD,mPointer:DWORD,lpDest:DWORD,lpDestIndex:DWORD
        LOCAL FirstDataOffset:DWORD
        mov edi,mPointer
        mov ecx,sizetoread
        mov al,0Ah
SearchForItAgain:  
        repne scasb
        jcxz GoToEnd
        jmp FoundIt
GoToEnd:        
        jmp EndOfHeaderNotFound
FoundIt:        
        cmp byte ptr [edi+1],0Ah
        jne  SearchForItAgain
        inc StateFlag           ; Marker that the HTTP header is parsed
        push edi
        dec edi
        dec edi
        sub edi,mPointer
        mov ecx,edi
        mov esi,mPointer
        mov edi,offset HTTPHeader
        add edi,HTTPIndex
        rep movsb
        mov byte ptr [edi],0
        invoke ParseHeader,hWnd,addr HTTPHeader
        pop edi
        invoke CheckIfCanResume
        .if eax==1              ; HTTP error
                invoke closesocket,sock
                invoke ClearMessages,hWnd,WM_SOCKET
                invoke ToggleControls,hWnd
                invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
                mov StateFlag,0
                invoke String2Dword,addr StatusCode
                .if eax==404
                        invoke MessageBox,hWnd,addr FileNotFound,addr AppName,MB_OK+MB_ICONERROR
                .else
                        invoke MessageBox,hWnd,addr HTTPError,addr AppName,MB_OK+MB_ICONERROR
                .endif
                ret
        .elseif eax==2          ; Cannot resume
                invoke closesocket,sock
                invoke ClearMessages,hWnd,WM_SOCKET
                invoke ToggleControls,hWnd
                invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
                mov StateFlag,0
                invoke MessageBox,hWnd,addr CannotResume,addr AppName,MB_OK
                ret
        .endif
        invoke InStringi,addr HTTPHeader,addr Multipart
        .if eax==-1
                inc edi
                inc edi
                push edi
                mov ecx,sizetoread
                sub edi,mPointer
                sub ecx,edi
                pop esi
                .if StateFlag!=11
                        push ecx
                        mov edi,lpDest
                        rep movsb
                        pop ecx
                        mov eax,lpDestIndex
                        add [eax] ,ecx
                .else
                        push ecx
                        invoke WriteFile,FileHandle,esi,ecx,addr BytesWritten,NULL
                        pop ecx
                .endif
                add ActualBytesWritten,ecx
                invoke DisplayProgress
        .else
                mov CanResume,TRUE
                inc edi
                inc edi
                mov FirstDataOffset,edi
                sub edi,mPointer
                mov eax,sizetoread
                sub eax,edi
                mov edi,FirstDataOffset
                mov al,0Ah
SearchMultiAgain:                
                repne scasb
                je  FoundTheLineFeed
                jmp EndOfMultiPartNotFound
FoundTheLineFeed:
                cmp byte ptr [edi+1],0Ah
                jne SearchMultiAgain
                inc edi
                inc edi
                push edi
                mov ecx,edi
                sub ecx,FirstDataOffset
                mov esi,FirstDataOffset
                mov edi,offset MultipartHeader
                add edi,MultipartIndex
                push ecx
                rep movsb
                mov byte ptr [edi],0
                pop ecx
                add MultipartIndex,ecx
                invoke ParseMultipartHeader
                pop  edi
                push edi
                sub edi,mPointer
                mov ecx,sizetoread
                sub ecx,edi                
                pop esi
                .if ecx>ContentLength
                        mov ecx,ContentLength
                .endif
                add ActualBytesWritten,ecx
                .if StateFlag!=11
                        push ecx
                        mov edi,lpDest
                        rep movsb
                        pop ecx                
                        mov eax,lpDestIndex
                        add [eax],ecx
                .else
                        invoke WriteFile,FileHandle,esi,ecx,addr BytesWritten,NULL
                .endif
                invoke DisplayProgress
                ret
EndOfMultiPartNotFound:
                mov esi,FirstDataOffset
                mov edi,offset MultipartHeader
                add edi,MultipartIndex
                mov ecx,sizetoread
                mov edx,FirstDataOffset
                sub edx,mPointer
                sub ecx,edx
                push ecx
                rep movsb
                pop ecx
                add MultipartIndex,ecx
                inc StateFlag           ; End of Multipart header is not found
        .endif
        ret
EndOfHeaderNotFound:
        mov esi,mPointer
        mov edi,offset HTTPHeader
        mov ecx,sizetoread
        rep movsb
        mov eax,sizetoread
        add HTTPIndex,eax
        ret
GetHeader ENDP

FillTheData PROC uses edi esi mPointer:DWORD,lpDest:DWORD,lpDestIndex:DWORD
        mov esi,mPointer
        mov edi,lpDest
        mov eax,lpDestIndex
        add edi,[eax]
        mov ecx,sizetoread
        .if MultipartIndex!=0
                mov edx,ActualBytesWritten
                add edx,ecx
                .if edx>ContentLength
                        mov ecx,ContentLength
                        sub ecx,ActualBytesWritten
                .endif
        .endif
        add ActualBytesWritten,ecx
        push ecx
        rep movsb
        pop ecx
        mov eax,lpDestIndex
        add [eax],ecx
        invoke DisplayProgress
        ret
FillTheData ENDP

ReadSocket PROC hWnd:DWORD
        LOCAL mHandle:DWORD
        LOCAL mPointer:DWORD
        invoke ioctlsocket,sock,FIONREAD,addr sizetoread
        .if eax!=SOCKET_ERROR
                invoke GlobalAlloc,GHND,sizetoread
                mov mHandle,eax
                invoke GlobalLock,eax
                mov mPointer,eax
                invoke recv,sock,mPointer,sizetoread,0
                .if eax!=SOCKET_ERROR
                        mov sizetoread,eax
                        .if StateFlag==1        ; HTTP header not yet parsed
                                invoke GetHeader,hWnd,mPointer,addr EndOfZip,addr EOZIndex
                        .elseif StateFlag==2  ; HTTP header parsed
                                invoke FillTheData,mPointer,addr EndOfZip,addr EOZIndex
                        .elseif StateFlag==3
                                invoke GetMultipartHeader,mPointer,addr EndOfZip,addr EOZIndex
                        .elseif StateFlag==4    ; Getting Central Dir
                                invoke GetHeader,hWnd,mPointer,pZipDir,addr CDIndex
                        .elseif StateFlag==5    ; HTTP header found, read the rest of the data
                                invoke FillTheData,mPointer,pZipDir,addr CDIndex
                        .elseif StateFlag==6
                                invoke GetMultipartHeader,mPointer,pZipDir,addr CDIndex
                        .elseif StateFlag==7    ; Getting local zip header
                                invoke GetHeader,hWnd,mPointer,addr LocalHeader, addr LocalIndex
                        .elseif StateFlag==8
                                invoke FillTheData,mPointer,addr LocalHeader,addr LocalIndex
                        .elseif StateFlag==9
                                invoke GetMultipartHeader,mPointer,addr LocalHeader,addr LocalIndex
                        .elseif StateFlag==10   ; Getting the actual zip data
                                invoke GetHeader,hWnd,mPointer,NULL,NULL
                        .elseif StateFlag==11
                                invoke FillActualData,mPointer
                        .elseif StateFlag==12
                                invoke GetMultipartHeader,mPointer,NULL,NULL
                        .endif
                .else
                        invoke ShowErrorMessage,hWnd
                        invoke ToggleControls,hWnd
                .endif
                invoke GlobalUnlock,mPointer
                invoke GlobalFree,mHandle
        .else
                invoke ShowErrorMessage,hWnd
                invoke ToggleControls,hWnd
        .endif
        ret
ReadSocket ENDP

GetMultipartHeader PROC uses edi esi mPointer:DWORD,lpDest:DWORD,lpDestIndex:DWORD
        mov edi,mPointer
        mov ecx,sizetoread
        mov al,0Ah
BackAndSearch:        
        repne scasb
        je CheckIfLineFeed
        jmp StillNotFound
CheckIfLineFeed:        
        .if byte ptr [edi+1]==0Ah
                inc edi
                inc edi
                dec StateFlag
                push edi
                sub edi,mPointer
                mov ecx,edi
                mov esi,mPointer
                mov edi,offset MultipartHeader
                add edi,MultipartIndex
                push ecx
                rep movsb
                pop ecx
                add MultipartIndex,ecx
                pop edi
                push edi
                sub edi,mPointer
                mov ecx,sizetoread
                sub ecx,edi
                pop esi
                mov edx,ActualBytesWritten
                add edx,ecx
                .if edx>ContentLength
                        mov ecx,ContentLength
                        sub ecx,ActualBytesWritten
                .endif
                add ActualBytesWritten,ecx
                .if StateFlag!=12
                        push ecx
                        mov edi,lpDest
                        rep movsb
                        pop ecx
                        mov eax,lpDestIndex
                        add [eax],ecx
                .else
                        invoke WriteFile,FileHandle,esi,ecx,addr BytesWritten,NULL
                .endif
                invoke DisplayProgress
                ret
        .else
                jmp BackAndSearch
        .endif
StillNotFound:
        mov esi,mPointer
        mov edi,offset MultipartHeader
        add edi,MultipartIndex
        mov ecx,sizetoread
        push ecx
        rep movsb
        pop ecx
        add MultipartIndex,ecx
        ret
GetMultipartHeader ENDP


CheckIfCanResume PROC
       .if byte ptr [StatusCode]=="2"
                .if byte ptr [StatusCode+2]=="6"
                        mov CanResume,TRUE
                        xor eax,eax
                .else
                        invoke InStringi,addr HTTPHeader,addr AcceptRange
                        .if eax==-1
                                mov StateFlag,0
                                mov eax,2       ; Cannot resume
                        .else
                                mov CanResume,TRUE
                                xor eax,eax
                        .endif
                .endif
        .else
                mov CanResume,FALSE
                mov eax,1               ; HTTP error
        .endif
        ret
CheckIfCanResume ENDP


ParseEOZ PROC uses edi esi hWnd:DWORD
        LOCAL buffer[512]:BYTE
        .if EOZSize==22
                mov eax,EOZSignature
                .if DWORD ptr [EndOfZip]==eax
                        mov StateFlag,4         ; 4= Request for Central Directory
                        invoke MakeConnection,hWnd
                .else                        
                        mov EOZSize,1024
                        mov StateFlag,1
                        invoke MakeConnection,hWnd
                .endif
        .else
                mov esi,DWORD ptr [EOZSignature]
                mov edi,offset EndOfZip
                mov ecx,1020
RescanForEOZ:                
                mov al,"P"
                repne scasb
                jne EOZNotFound
                push edi
                dec edi
                cmp DWORD ptr [edi],esi
                pop edi
                jne RescanForEOZ                
EOZFound:
                        mov esi,edi
                        dec esi
                        mov edi,offset EndOfZip
                        mov cx,22
                        rep movsb
                        mov byte ptr [edi],0
                        mov StateFlag,4
                        invoke MakeConnection,hWnd
                        jmp BackToCaller
EOZNotFound:
                        invoke MessageBox,hWnd,addr InvalidFile,addr AppName,MB_OK+MB_ICONERROR
                        invoke ToggleControls,hWnd
                        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_DELETEALLITEMS,NULL,NULL
                        invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
                        mov StateFlag,0
BackToCaller:
                mov EOZSize,22
        .endif
        ret
ParseEOZ ENDP

RequestCD PROC hWnd:DWORD
        LOCAL buffer[512]:BYTE
        
        mov eax,DWORD ptr [EndOfZip+12]
        push eax 
        inc eax
        invoke GlobalReAlloc,hZipDir,eax,GHND
        mov hZipDir,eax
        invoke GlobalLock,eax
        mov pZipDir,eax
        pop eax
        add eax,DWORD ptr [EndOfZip+16]
        dec eax
        push eax
        push DWORD ptr [EndOfZip+16]
        push offset HostName
        push offset RelativeURL
        push offset CDTemplate
        lea eax,buffer
        push eax
        call wsprintfA
        add esp,24
        invoke SetStatusText,addr GettingCD,NULL
        invoke lstrlen,addr buffer
        invoke send,sock,addr buffer,eax,0
        .if eax==SOCKET_ERROR
                invoke ShowErrorMessage,hWnd
                invoke ToggleControls,hWnd
        .else
                invoke SetStatusText,addr Connected,addr HostName
                mov HTTPIndex,0
                mov MultipartIndex,0
                mov EOZIndex,0
                mov CDIndex,0
                mov ActualBytesWritten,0
        .endif
        ret
RequestCD ENDP

ParseCD PROC uses edi esi hWnd:DWORD
        LOCAL lvitem:LV_ITEM
        LOCAL Name1[2048]:BYTE
        LOCAL CurIndex:DWORD
        LOCAL ItemAddr:DWORD
        LOCAL buffer[512]:BYTE
        invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
        mov edx,pZipDir
        mov CurIndex,0
        xor eax,eax
        mov ax,WORD ptr [EndOfZip+8]
        mov lvitem.imask,LVIF_TEXT
        push eax
        mov lvitem.iSubItem,0
        lea ecx,Name1
        mov lvitem.pszText,ecx
        .while eax>0
                xor ecx,ecx
                mov cx,WORD ptr [edx+28]
                lea edi,Name1
                mov esi,edx
                add esi,46
                rep movsb
                mov byte ptr [edi],0
                xor ecx,ecx
                mov cx,WORD ptr [edx+28]
                add cx,WORD ptr [edx+30]
                add cx,WORD ptr [edx+32]
                add ecx,46
                add edx,ecx
                push eax
                push CurIndex
                pop lvitem.iItem
                inc CurIndex
                push edx
                invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_INSERTITEM,NULL,addr lvitem
                pop edx
                pop eax
                dec eax
        .endw
        pop eax
        mov CurIndex,0
        mov lvitem.cchTextMax,2048
        .while eax>0
                push CurIndex
                pop lvitem.iItem
                lea ecx,Name1
                mov lvitem.pszText,ecx
                push eax
                invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_GETITEM,NULL,addr lvitem
                invoke FindItemInCentralDir,addr Name1
                .if eax!=-1
                        mov ItemAddr,eax
                        mov edx,eax
                        mov ax,WORD ptr [edx+14]
                        xor ecx,ecx
                        mov cx,ax
                        shr cx,9
                        add cx,1980
                        push ecx
                        xor ecx,ecx
                        mov cx,ax
                        and cx,1Fh
                        push ecx
                        xor ecx,ecx
                        mov cx,ax
                        shr cx,5
                        and cx,0Fh
                        push ecx
                        push offset DateTemplate
                        lea eax,buffer
                        push eax
                        call wsprintfA
                        add esp,20
                        lea ecx,buffer
                        mov lvitem.pszText,ecx
                        mov lvitem.iSubItem,1
                        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_SETITEM,NULL,addr lvitem
                        mov lvitem.iSubItem,0
                        mov edx,ItemAddr
                        xor eax,eax
                        mov ax,WORD ptr [edx+12]
                        xor ecx,ecx
                        mov cx,ax
                        shr cx,5
                        and cx,3Fh
                        push ecx
                        xor ecx,ecx
                        mov cx,ax
                        shr cx,11
                        push ecx
                        push offset TimeTemplate
                        lea ecx,buffer
                        push ecx
                        call wsprintfA
                        add esp,16
                        lea ecx,buffer
                        mov lvitem.pszText,ecx
                        mov lvitem.iSubItem,2
                        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_SETITEM,NULL,addr lvitem                        
                        mov edx,ItemAddr
                        push DWORD ptr [edx+24]
                        push offset ValueTemplate
                        lea ecx,buffer
                        push ecx
                        call wsprintfA
                        add esp,12
                        lea ecx,buffer
                        mov lvitem.pszText,ecx
                        mov lvitem.iSubItem,3
                        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_SETITEM,NULL,addr lvitem                        
                        mov edx,ItemAddr
                        push DWORD ptr [edx+20]
                        push offset ValueTemplate
                        lea ecx,buffer
                        push ecx
                        call wsprintfA
                        add esp,12
                        lea ecx,buffer
                        mov lvitem.pszText,ecx
                        mov lvitem.iSubItem,4
                        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_SETITEM,NULL,addr lvitem                        
                        mov lvitem.iSubItem,0
                .else
                        invoke MessageBox,NULL,addr AppName,addr AppName,MB_OK
                .endif
                inc CurIndex
                pop eax
                dec eax
        .endw
        mov StateFlag,7         ; 7= Waiting for user to select files
        ret
ParseCD ENDP

FindItemInCentralDir PROC uses esi edi String:DWORD
        LOCAL NoOfItem:DWORD
        LOCAL NameLength:DWORD
        invoke lstrlen,String
        mov NameLength,eax
        xor eax,eax
        mov ax,WORD ptr [EndOfZip+8]
        mov NoOfItem,eax
        xor eax,eax
        mov edx,pZipDir        
        .while eax<NoOfItem
                xor ecx,ecx
                mov cx,WORD ptr [edx+28]
                .if ecx==NameLength
                        mov edi,String
                        mov esi,edx
                        add esi,46
                        repe cmpsb
                        je FoundTheAddress
                .endif
                xor ecx,ecx
                mov cx,WORD ptr [edx+28]
                add cx,WORD ptr [edx+30]
                add cx,WORD ptr [edx+32]
                add edx,46
                add edx,ecx
                inc eax
        .endw
        mov eax,-1
        ret
FoundTheAddress:
        mov eax,edx
        ret
FindItemInCentralDir ENDP

DownloadFiles PROC hWnd:DWORD
        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_GETSELECTEDCOUNT,0,0
        .if eax==0
                invoke MessageBox,hWnd,addr NotSelected,addr AppName,MB_OK+MB_ICONERROR
        .else
                invoke EnableWindow,hwndOK,FALSE
                invoke CreateFile,addr FileName,GENERIC_WRITE,FILE_SHARE_READ,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,NULL
                mov FileHandle,eax                
                invoke EnableWindow,hwndList,FALSE
                mov PrevIndex,-1
                invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_GETNEXTITEM,PrevIndex,LVNI_SELECTED
                mov PrevIndex,eax
                mov CurrentIndex,eax
                invoke MakeConnection,hWnd
        .endif
        ret
DownloadFiles ENDP

WriteCentralDir PROC hWnd:DWORD
        LOCAL lvitem:LV_ITEM
        LOCAL TheName[256]:BYTE
        LOCAL NoEntry:DWORD
        LOCAL mPointer:DWORD
        LOCAL TotalCount:DWORD
        invoke SetFilePointer,FileHandle,0,0,FILE_CURRENT
        mov CDOffset,eax
        mov PrevIndex,-1
        mov DirSize,0
        mov TotalCount,0
CheckAllHeader:        
        xor eax,eax
        mov ax,WORD ptr [EndOfZip+10]
        mov NoEntry,eax
        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_GETNEXTITEM,PrevIndex,LVNI_SELECTED
        mov PrevIndex,eax
        mov CurrentIndex,eax
        cmp eax,-1
        je  NoMore
        mov lvitem.imask,LVIF_TEXT
        mov eax,CurrentIndex
        mov lvitem.iItem,eax
        mov lvitem.iSubItem,0
        lea eax,TheName
        mov lvitem.pszText,eax
        mov lvitem.cchTextMax,256
        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_GETITEM,0,addr lvitem
        mov edi,pZipDir
        mov mPointer,edi
        .while NoEntry>0
                xor ecx,ecx
                mov edx,mPointer
                mov cx,WORD ptr [edx+28]
                mov esi,edx
                add esi,46
                mov edi,lvitem.pszText
                repe cmpsb
                je  GetIt
                xor eax,eax
                mov ax,WORD ptr [edx+28]
                add ax,WORD ptr [edx+30]
                add ax,WORD ptr [edx+32]
                add ax,46
                add mPointer,eax
                dec NoEntry
        .endw
GetIt:
        inc TotalCount
        mov WORD ptr [edx+30],0
        mov WORD ptr [edx+32],0
        mov WORD ptr [edx+34],0
        xor ecx,ecx
        mov cx,WORD ptr [edx+28]
        add ecx,46
        add DirSize,ecx
        invoke WriteFile,FileHandle,edx,ecx,addr BytesWritten,NULL
        jmp CheckAllHeader
NoMore:        
        mov eax,TotalCount
        ret
WriteCentralDir ENDP

WriteEndOfDir PROC TotalCount:DWORD
        mov DWORD ptr [EndOfZip+4],0
        mov WORD ptr [EndOfZip+8],ax
        mov WORD ptr [EndOfZip+10],ax
        mov eax,DirSize
        mov DWORD ptr [EndOfZip+12],eax
        mov eax,CDOffset
        mov DWORD ptr [EndOfZip+16],eax
        mov WORD ptr [EndOfZip+20],0
        invoke WriteFile,FileHandle,addr EndOfZip,22,addr BytesWritten,NULL
        ret
WriteEndOfDir ENDP

CheckForOtherFiles PROC hWnd:DWORD
        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_GETNEXTITEM,PrevIndex,LVNI_SELECTED
        .if eax==-1
                invoke WriteCentralDir,hWnd
                invoke WriteEndOfDir,eax
                invoke CloseHandle,FileHandle
                invoke MessageBox,hWnd,addr Finish,addr AppName,MB_OK
                invoke ToggleControls,hWnd
                invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
                invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_DELETEALLITEMS,NULL,NULL
                mov StateFlag,0
        .else
                mov PrevIndex,eax
                mov CurrentIndex,eax
                mov StateFlag,7
                invoke MakeConnection,hWnd
        .endif
        ret
CheckForOtherFiles ENDP

RequestZipFile PROC uses edi esi hWnd:DWORD        
        LOCAL lvitem:LV_ITEM
        LOCAL TheName[256]:BYTE
        LOCAL NoEntry:DWORD
        LOCAL mPointer:DWORD
        LOCAL buffer[256]:BYTE
        mov lvitem.imask,LVIF_TEXT
        mov eax,CurrentIndex
        mov lvitem.iItem,eax
        mov lvitem.iSubItem,0
        lea eax,TheName
        mov lvitem.pszText,eax
        mov lvitem.cchTextMax,256
        invoke SendDlgItemMessage,hWnd,IDC_NAMELIST,LVM_GETITEM,0,addr lvitem
        mov edi,pZipDir
        mov mPointer,edi
        xor eax,eax
        mov ax,WORD ptr [EndOfZip+10]
        mov NoEntry,eax
        .while NoEntry>0
                xor ecx,ecx
                mov edx,mPointer
                mov cx,WORD ptr [edx+28]
                push edx
                push ecx                
                invoke lstrlen,lvitem.pszText
                pop  ecx
                .if eax>ecx
                        mov ecx,eax
                .endif
                pop edx
                mov esi,edx
                add esi,46
                mov edi,lvitem.pszText
                repe cmpsb
                je  GetIt
                xor eax,eax
                mov ax,WORD ptr [edx+28]
                add ax,WORD ptr [edx+30]
                add ax,WORD ptr [edx+32]
                add ax,46
                add mPointer,eax
                dec NoEntry
        .endw
GetIt:
        mov lpRelOffset,edx
        add lpRelOffset,42
        mov eax,DWORD ptr [edx+42]
        add eax,30
        dec eax
        push eax
        xor ecx,ecx
        mov cx,WORD ptr [edx+28]
        mov edi,offset ZipFileName
        mov esi,edx
        add esi,46
        rep movsb
        mov byte ptr [edi],0
        mov eax,DWORD ptr [edx+42]
        mov StartingOffset,eax
        push eax
        push offset HostName
        push offset RelativeURL
        push offset CDTemplate
        lea eax,buffer
        push eax
        call wsprintfA
        add esp,24
        invoke SetFilePointer,FileHandle,0,0,FILE_CURRENT
        mov ecx,lpRelOffset
        mov DWORD ptr [ecx],eax
;        invoke MessageBox,hWnd,addr buffer,addr AppName,MB_OK
        invoke SetStatusText,addr Downloading,NULL
        invoke lstrlen,addr buffer
        invoke send,sock,addr buffer,eax,0
        .if eax==SOCKET_ERROR
                invoke ShowErrorMessage,hWnd
                invoke ToggleControls,hWnd
                mov StateFlag,0
        .else
                invoke SetStatusText,addr Connected,addr HostName
                mov HTTPIndex,0
                mov MultipartIndex,0
                mov EOZIndex,0
                mov CDIndex,0
                mov LocalIndex,0
                mov ActualBytesWritten,0
        .endif
        ret
RequestZipFile ENDP


ParseLocalHeader PROC hWnd:DWORD
        mov StateFlag,10
        invoke WriteFile,FileHandle,addr LocalHeader,30,addr BytesWritten,NULL
        invoke MakeConnection,hWnd
        ret
ParseLocalHeader ENDP

RequestActualData PROC hWnd:DWORD
        LOCAL buffer[512]:BYTE
        xor eax,eax
        mov ax,WORD ptr [LocalHeader+26]
        add ax,WORD ptr [LocalHeader+28]
        add eax, DWORD ptr [LocalHeader+18]
        mov ecx,StartingOffset
        add ecx,30
        add ecx,eax
        dec ecx
        push ecx
        mov eax,StartingOffset
        add eax,30
        push eax
        push offset HostName
        push offset RelativeURL
        push offset CDTemplate
        lea eax,buffer
        push eax
        call wsprintfA
        add esp,24
        invoke lstrlen,addr buffer
        invoke send,sock,addr buffer,eax,0
        .if eax==SOCKET_ERROR
                invoke ShowErrorMessage,hWnd
                invoke ToggleControls,hWnd
                mov StateFlag,0
        .else
                invoke SetStatusText,addr Connected,addr HostName
                mov HTTPIndex,0
                mov MultipartIndex,0
                mov EOZIndex,0
                mov CDIndex,0
                mov LocalIndex,0
                mov ActualBytesWritten,0
        .endif
        ret
RequestActualData ENDP

GetActualHeader PROC uses edi esi hWnd:DWORD,mPointer:DWORD
        LOCAL FirstDataOffset:DWORD
        mov edi,mPointer
        mov ecx,sizetoread
        mov al,0Ah
SearchForItAgain:  
        repne scasb
        jcxz GoToEnd
        jmp FoundIt
GoToEnd:        
        jmp EndOfHeaderNotFound
FoundIt:        
        cmp byte ptr [edi+1],0Ah
        jne  SearchForItAgain
        mov StateFlag,11         ; HTTP header of the data parsed
        push edi
        dec edi
        dec edi
        sub edi,mPointer
        mov ecx,edi
        mov esi,mPointer
        mov edi,offset HTTPHeader
        add edi,HTTPIndex
        rep movsb
        mov byte ptr [edi],0
        invoke ParseHeader,hWnd,addr HTTPHeader
        pop edi
        invoke InStringi,addr HTTPHeader,addr Multipart
        .if eax==-1
                inc edi
                inc edi
                push edi
                mov ecx,sizetoread
                sub edi,mPointer
                sub ecx,edi
                pop esi
                add ActualBytesWritten,ecx
                invoke WriteFile,FileHandle,esi,ecx,addr BytesWritten,NULL
        .else
                inc edi
                inc edi
                mov FirstDataOffset,edi
                sub edi,mPointer
                mov eax,sizetoread
                sub eax,edi
                mov edi,FirstDataOffset
                mov al,0Ah
SearchMultiAgain:                
                repne scasb
                jcxz EndOfMultiPartNotFound
                cmp byte ptr [edi+1],0Ah
                jne SearchMultiAgain
                inc edi
                inc edi
                push edi
                mov ecx,edi
                sub ecx,FirstDataOffset
                mov esi,FirstDataOffset
                mov edi,offset MultipartHeader
                add edi,MultipartIndex
                push ecx
                rep movsb
                pop ecx
                add MultipartIndex,ecx
                mov byte ptr [edi],0
                invoke ParseMultipartHeader
                pop  edi
                push edi
                sub edi,mPointer
                mov ecx,sizetoread
                sub ecx,edi                
                pop esi
                .if ecx>ContentLength
                        mov ecx,ContentLength
                .endif
                add ActualBytesWritten,ecx
                invoke WriteFile,FileHandle,esi,ecx,addr BytesWritten,NULL
                ret
EndOfMultiPartNotFound:
                mov esi,FirstDataOffset
                mov edi,offset MultipartHeader
                add edi,MultipartIndex
                mov ecx,sizetoread
                mov edx,FirstDataOffset
                sub edx,mPointer
                sub ecx,edx
                push ecx
                rep movsb
                pop ecx
                add MultipartIndex,ecx
                mov StateFlag,12                 ; Multipart header not yet parsed
        .endif
        ret
EndOfHeaderNotFound:
        mov esi,mPointer
        mov edi,offset HTTPHeader
        mov ecx,sizetoread
        rep movsb
        mov eax,sizetoread
        add HTTPIndex,eax
        ret
GetActualHeader ENDP

FillActualData PROC mPointer:DWORD
        .if MultipartIndex!=0
                mov ecx,ActualBytesWritten
                add ecx,sizetoread
                .if ecx>ContentLength
                        mov ecx,ContentLength
                        sub ecx,ActualBytesWritten
                .else
                        mov ecx,sizetoread
                .endif
                add ActualBytesWritten,ecx
        .else
                mov ecx,sizetoread
                add ActualBytesWritten,ecx
        .endif
        invoke WriteFile,FileHandle,mPointer,ecx,addr BytesWritten,NULL
        invoke DisplayProgress
        ret
FillActualData ENDP

ParseMultipartHeader PROC uses edi esi
        invoke InStringi,addr MultipartHeader,addr Content
        .if eax!=-1
                mov edi,offset ContentString                
                add eax,offset MultipartHeader
                add eax,15
                .while byte ptr [eax]!=0 && byte ptr [eax]!=0Dh && byte ptr [eax]!=0Ah
                        .if byte ptr [eax]!=" "
                                mov cl,byte ptr [eax]
                                mov byte ptr [edi],cl
                                inc edi
                        .endif
                        inc eax
                .endw
                mov byte ptr [edi],0
                invoke String2Dword,addr ContentString
                mov ContentLength,eax
        .else
                invoke MessageBox,NULL,addr NoContent,addr AppName,MB_OK
                invoke closesocket,sock
                mov StateFlag,0
        .endif
        ret
ParseMultipartHeader ENDP

ConnectSocket PROC hWnd:DWORD
        invoke ToggleControls,hWnd
        mov StateFlag,1        ; Begin first connection
        invoke MakeConnection,hWnd
        .if eax==FALSE
                mov StateFlag,0
                invoke ToggleControls,hWnd
                invoke SendMessage,hwndStatus,SB_SETTEXT,NULL,NULL
        .endif
        ret
ConnectSocket ENDP

SetUpListView PROC
        mov lvcol.imask,LVCF_TEXT+LVCF_FMT+LVCF_SUBITEM+LVCF_WIDTH
        mov lvcol.fmt,LVCFMT_LEFT
        mov lvcol.lx,120
        mov lvcol.pszText,offset FileNameText
        mov lvcol.iSubItem,0
        invoke SendMessage,hwndList,LVM_INSERTCOLUMN,0,addr lvcol
        mov lvcol.iSubItem,1
        mov lvcol.pszText,offset DateText
        mov lvcol.lx,60
        invoke SendMessage,hwndList,LVM_INSERTCOLUMN,1,addr lvcol
        mov lvcol.iSubItem,2
        mov lvcol.lx,60
        mov lvcol.pszText,offset TimeText
        invoke SendMessage,hwndList,LVM_INSERTCOLUMN,2,addr lvcol
        mov lvcol.iSubItem,3
        mov lvcol.lx,80
        mov lvcol.fmt,LVCFMT_RIGHT
        mov lvcol.pszText,offset UncompressedText
        invoke SendMessage,hwndList,LVM_INSERTCOLUMN,3,addr lvcol
        mov lvcol.iSubItem,4
        mov lvcol.pszText,offset CompressedText
        invoke SendMessage,hwndList,LVM_INSERTCOLUMN,4,addr lvcol
        ret
SetUpListView ENDP
GetPercentComplete PROC
        .if ContentLength!=0
                xor edx,edx
                mov eax,ActualBytesWritten
                mov ecx,100
                mul ecx
                mov ecx,ContentLength
                div ecx        
        .else
                xor eax,eax
        .endif
        ret
GetPercentComplete ENDP
DisplayProgress PROC
        LOCAL buffer[512]:BYTE
        .if StateFlag==5
                invoke GetPercentComplete
                push eax
                push offset ReadingCD
                lea eax,buffer
                push eax
                call wsprintfA
                add esp,12
                invoke SetStatusText,addr buffer,NULL
        .elseif StateFlag>=11
                invoke GetPercentComplete
                push eax
                push offset ZipFileName
                push offset ReadingData
                lea eax,buffer
                push eax
                call wsprintfA
                add esp,16
                invoke SetStatusText,addr buffer,NULL
        .endif
        ret
DisplayProgress ENDP
end start
