;=====================================================================
; Program name: [SaF]-worm
; Programmed by: [SaFc0n] <safcon@gmx.net>
; Finished: 20/03/2001
;=====================================================================

.386
.model flat, stdcall  
option casemap :none 

INCLUDE \MASM32\INCLUDE\windows.inc
INCLUDE \MASM32\INCLUDE\masm32.inc
INCLUDE \MASM32\INCLUDE\gdi32.inc
INCLUDE \MASM32\INCLUDE\user32.inc
INCLUDE \MASM32\INCLUDE\kernel32.inc
INCLUDE \MASM32\INCLUDE\advapi32.inc
INCLUDE \MASM32\INCLUDE\winmm.inc

INCLUDELIB \MASM32\LIB\masm32.LIB
INCLUDELIB \MASM32\LIB\gdi32.LIB
INCLUDELIB \MASM32\LIB\user32.LIB
INCLUDELIB \MASM32\LIB\kernel32.LIB
INCLUDELIB \MASM32\LIB\advapi32.LIB
INCLUDELIB \MASM32\LIB\winmm.LIB

WinMain            PROTO :DWORD,:DWORD,:DWORD,:DWORD
WndProc            PROTO :DWORD,:DWORD,:DWORD,:DWORD
TopXY              PROTO :DWORD,:DWORD
Paint_Proc         PROTO :DWORD,:DWORD
placefood          PROTO
snakecrash         PROTO
foodcrash          PROTO
movesnake          PROTO
wallcrash          PROTO
changedirection    PROTO
newgame            PROTO :DWORD
SetRegKeysz        PROTO :DWORD, :DWORD, :DWORD, :DWORD
GetRegKeysz        PROTO :DWORD, :DWORD, :DWORD, :DWORD
gethighscorepoints PROTO
highscore          PROTO :DWORD,:DWORD,:DWORD,:DWORD
showhighscore      PROTO :DWORD,:DWORD,:DWORD,:DWORD
snakemainproc      PROTO :DWORD,:DWORD,:DWORD,:DWORD 
savepositions      PROTO :DWORD
random             PROTO :DWORD,:DWORD
randomize          PROTO
wsprintfA          PROTO C :DWORD,:VARARG
wsprintf           equ <wsprintfA>

m2m MACRO M1, M2
    push M2
    pop  M1
ENDM

return MACRO arg
    mov eax, arg
    ret
ENDM

RGB macro red,green,blue
        xor eax,eax
        mov ah,blue
        shl eax,8
        mov ah,green
        mov al,red
endm
      
;|> structure for the snakebody, the direction, x, and y 
;|> coordinates are saved here. 
snakebody STRUCT
   sx        dd ?
   sy        dd ?
   direction dd ?
snakebody ENDS
      	
;|> button identifiers
.const 
   BUTTON_1 equ 1
   BUTTON_2 equ 2
   BUTTON_3 equ 3
   BUTTON_4 equ 4
   BUTTON_5 equ 5

.data
        szDisplayName db "[SaF]-worm",0
        szClassName   db "Win_Class",0
        TheText       db "Do you really want to quit?",0
        bodybit       db "bodybit",0
        foodbit       db "foodbit",0
        saflogo       db "-= [SaF]-worm! =-",0
        underln       db "_______________________",0
        verloren      db "Game over!",0
        punktetextstr db "Points:",0
        staticclass   db "STATIC",0
        buttonclass   db "BUTTON",0
        buttontext1   db "Highscore!",0
        difficulty    db "Speed level:",0
        buttontexts1  db "1",0
        buttontexts2  db "2",0
        buttontexts3  db "3",0
        buttontext4   db "Difficult",0
        newgametext   db "Game over! Want to start a new game?",0
        punktestr     db "0",20 dup (0)
        szformat      db "%u",0
        szKeyName     db "Software\Safcon\SafWorm\Highscore\"  ,0
        szStringValue db 30 dup(0)      ;|> buffers for registry
	RegistryText  db 30 dup(0)
	szBigBuffer   db 30 dup(0)
        snakeelements dd 6              ;|> counter for snakeelements
        punkte        dd 0              ;|> points variable
        snakeone      snakebody {5,101,3},{5,85,3},{5,69,3},{5,53,3},{5,37,3},\
        		        {5,21,3},{5,5,3},1000 dup(<?,?,?>)  
        	      ;|> the start coordinates are initialized
  	
        keypressflag  dd 0        ;|> we need a flag for the keys, 'cause after you
                                  ;|> press a key to change the direction, the snake
                                  ;|> first has to be drawn, and only then you can
                                  ;|> change the direction again.
	foodflag      dd 0        ;|> a flag to decide wether we place 
	                          ;|> food on a new position or not
	
	tempregpunkte db 30 dup(0)    ;|> these are temp buffers to write to the 
	regpunkte     dd 5 dup(0)     ;|> registry
	
	punkte1txt    db "Points1",0  ;|> these are the strings that are written to the
	punkte2txt    db "Points2",0  ;|> registry when you run the game the first time
	punkte3txt    db "Points3",0
	punkte4txt    db "Points4",0
	punkte5txt    db "Points5",0
	name1txt      db "Name1",0
	name2txt      db "Name2",0
	name3txt      db "Name3",0
	name4txt      db "Name4",0
	name5txt      db "Name5",0
	prename       db "[SaFc0n]",0
	prepoints1    db "20000",0
	prepoints2    db "15000",0
	prepoints3    db "10000",0
	prepoints4    db "5000",0
	prepoints5    db "2500",0
	
	;|> messagebox strings when you change the speed level
	speed1        db "Speed level set to advanced!",0
	speed2        db "Speed level set to intermediate!",0
	speed3        db "Speed level set to beginner!",0
	sg            dd 2   ;|> variable to check which speed level is currently activated
	                     ;|> on startup it is speed level 2
	
	position      dd 0   ;|> this variable gets the position on the highscore list
	                     ;|> the new user will be written to
	speednr       dd 60  ;|> speed for the timer in ms
	
	fontname      db "Arial",0        ;|> font name for the new font
	instruct1     db "left mouse button: new game",0    ;|> strings that will be displayed
	instruct2     db "right mouse button: close program",0   ;|> on start screen
	
	difflag       dd 0       ;|> is difficult activated? 
	
	
        
.data?
	
        CommandLine   dd ?
        hWnd          dd ?
        hInstance     dd ?
        hIcon         dd ?
        backgroundbrush dd ?
        ;|> variables for the backbuffer
        backbuffer    HDC ?
	backbitmap    HBITMAP ?
	oldbit        dd ?
	screenrect    RECT <?>
	blackbrush    dd ?
	
	myDC          dd ?    ;|> handle to my window's dc
	maxx          dd ?    ;|> used to get the width of a window
	maxy          dd ?    ;|> used to get the height of a window
	hpen          dd ?    ;|> handle for our pen
	oldpen        dd ?    ;|> variable for the old pen when we select a new to the DC         
	rand          dd ?    ;|> random seed
	Wwd           dd ?    ;|> width of the main window
	Wht           dd ?    ;|> height of the main window
	
	foodx         dd ?    ;|> x coordinate for the food
	foody         dd ?    ;|> y coordinate for the food
	
	punktehwnd    dd ?    ;|> window handle for the points
	
	;|> handles for the bitmaps
	bodybmp       HBITMAP ?
	bodybmpdc     HDC ?
	snakefoodbmpdc HDC ?
	snakefoodbmp  HBITMAP ?
	
	;|> variables for the multimedia timer
	timercaps     TIMECAPS <?>
	timerevent1   dd ?
	
	;|> some varibales that are used to write to the registry
	datatype      dd ?
	dwBBufLength  dd ?
	
;####################################################################
	
.code
start:
      INVOKE GetModuleHandle, NULL
      mov hInstance, eax

      INVOKE GetCommandLine
      mov CommandLine, eax

      INVOKE WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
      INVOKE ExitProcess,eax
      
;#####################################################################

WinMain proc hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD
      LOCAL wc   :WNDCLASSEX
      LOCAL msg  :MSG
      LOCAL Wtx  :DWORD
      LOCAL Wty  :DWORD

      INVOKE LoadIcon,hInst,500    ; icon ID
      mov hIcon, eax
      mov wc.cbSize,         sizeof WNDCLASSEX
      mov wc.style,          CS_HREDRAW or CS_VREDRAW \
                             or CS_BYTEALIGNWINDOW
      mov wc.lpfnWndProc,    offset WndProc
      mov wc.cbClsExtra,     NULL
      mov wc.cbWndExtra,     NULL
      m2m wc.hInstance,      hInst
      INVOKE CreateSolidBrush,000000FFh
      
      mov wc.hbrBackground,  eax
      mov wc.lpszMenuName,   NULL
      mov wc.lpszClassName,  offset szClassName
      m2m wc.hIcon,          hIcon
        INVOKE LoadCursor,NULL,IDC_ARROW
      mov wc.hCursor,        eax
      m2m wc.hIconSm,        hIcon
      INVOKE RegisterClassEx, ADDR wc

      mov Wwd, 645
      mov Wht, 490

      INVOKE GetSystemMetrics,SM_CXSCREEN
      mov maxx,eax
      INVOKE TopXY,Wwd,eax
      mov Wtx, eax

      INVOKE GetSystemMetrics,SM_CYSCREEN
      mov maxy,eax
      INVOKE TopXY,Wht,eax
      mov Wty, eax

      INVOKE CreateWindowEx,WS_EX_LEFT,
                            ADDR szClassName,
                            ADDR szDisplayName,
                            WS_POPUP,
                            Wtx,Wty,Wwd,Wht,
                            NULL,NULL,
                            hInst,NULL
      mov   hWnd,eax

      INVOKE LoadMenu,hInst,600  ; menu ID
      INVOKE SetMenu,hWnd,eax

      INVOKE ShowWindow,hWnd,SW_SHOWNORMAL
      INVOKE UpdateWindow,hWnd
      
     StartLoop:
      INVOKE GetMessage,ADDR msg,NULL,0,0
      cmp eax, 0
      je ExitLoop
      INVOKE TranslateMessage, ADDR msg
      INVOKE DispatchMessage,  ADDR msg
      jmp StartLoop
    ExitLoop:

      return msg.wParam

WinMain endp

; #########################################################################

WndProc proc uses ebx edx esi edi hWin   :DWORD,
             uMsg   :DWORD,
             wParam :DWORD,
             lParam :DWORD

    LOCAL var    :DWORD
    LOCAL caW    :DWORD
    LOCAL caH    :DWORD
    LOCAL Rct    :RECT
    LOCAL hDC    :DWORD
    LOCAL Ps     :PAINTSTRUCT
    
    mov eax,uMsg
    
    .IF uMsg == WM_COMMAND
   	mov eax,wParam
        mov edx,wParam
        shr edx,16
        .IF edx==BN_CLICKED
            .IF ax==BUTTON_1     ;|> this button shows the highscore list
            	INVOKE InvalidateRect,hWin,NULL,FALSE
            	INVOKE DialogBoxParam,hInstance,6002,hWnd,offset showhighscore,NULL
            .ELSEIF ax==BUTTON_2 ;|> this button sets speed level to one
            	mov sg,1         ;|> speed level variable
            	mov speednr,20   ;|> speed for the multimedia timer 
            	invoke MessageBox,NULL,addr speed1,addr szDisplayName,MB_OK or MB_ICONINFORMATION
            .ELSEIF ax==BUTTON_3 ;|> the same as above, but we set speed level to 2
            	mov sg,2
            	mov speednr,60
            	invoke MessageBox,NULL,addr speed2,addr szDisplayName,MB_OK or MB_ICONINFORMATION
            .ELSEIF ax==BUTTON_4 ;|> speed level 3
            	mov sg,3
            	mov speednr,100
            	invoke MessageBox,NULL,addr speed3,addr szDisplayName,MB_OK or MB_ICONINFORMATION
            .ELSEIF ax==BUTTON_5 ;|> the user wants a higher difficulty level
            	.IF difflag==0
            		mov difflag,1
            	.ELSE
            		mov difflag,0
            	.ENDIF
            .ENDIF
        .ENDIF
       
    .ELSEIF uMsg == WM_CREATE
    	;|> first create all the windows
    	INVOKE CreateWindowEx,WS_EX_LEFT,addr staticclass,addr punktetextstr,
                WS_CHILD or WS_VISIBLE,5,470,60,20,hWin,0,hInstance,0
    	INVOKE CreateWindowEx,WS_EX_LEFT,addr staticclass,addr punktestr,
                WS_CHILD or WS_VISIBLE,65,470,70,20,hWin,0,hInstance,0
        mov punktehwnd,eax
        INVOKE CreateWindowEx,WS_EX_LEFT,addr staticclass,addr difficulty,
                WS_CHILD or WS_VISIBLE,310,468,90,20,hWin,0,hInstance,0
        INVOKE CreateWindowEx,WS_EX_LEFT,addr buttonclass,addr buttontext1,
                WS_CHILD or WS_VISIBLE,150,467,120,20,hWin,BUTTON_1,hInstance,0
        INVOKE CreateWindowEx,WS_EX_LEFT,addr buttonclass,addr buttontexts1,
                WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON,410,467,50,20,hWin,BUTTON_2,hInstance,0
        INVOKE CreateWindowEx,WS_EX_LEFT,addr buttonclass,addr buttontexts2,
                WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON,460,467,50,20,hWin,BUTTON_3,hInstance,0
        INVOKE SendMessage,eax,BM_SETCHECK,BST_CHECKED,0
        INVOKE CreateWindowEx,WS_EX_LEFT,addr buttonclass,addr buttontexts3,
                WS_CHILD or WS_VISIBLE or BS_AUTORADIOBUTTON,510,467,50,20,hWin,BUTTON_4,hInstance,0
        INVOKE CreateWindowEx,WS_EX_LEFT,addr buttonclass,addr buttontext4,
                WS_CHILD or WS_VISIBLE or BS_AUTOCHECKBOX,560,467,70,20,hWin,BUTTON_5,hInstance,0
        
        ;|> prepare the backbuffer
        INVOKE GetDC,hWin
	mov myDC,eax
	mov screenrect.left,0
	mov screenrect.top,0
	mov eax,635
	mov screenrect.right,eax
	mov eax,465
	sub eax,5
	mov screenrect.bottom,eax
	INVOKE CreateSolidBrush,00000000h
	mov blackbrush,eax
	INVOKE CreateCompatibleDC,myDC
	mov backbuffer,eax			;handle of the invisible Devicecontext
	INVOKE CreateCompatibleBitmap,myDC,screenrect.right,screenrect.bottom
	mov backbitmap,eax			;handle of the invis. Bitmap
	INVOKE SelectObject,backbuffer,backbitmap
	mov oldbit,eax
	INVOKE FillRect, backbuffer, ADDR screenrect, blackbrush	;fill invis screen with black 
	INVOKE CreatePen,PS_SOLID,1,00FFFFFFh	;a white pen
	mov hpen,eax		
    	INVOKE SelectObject,backbuffer,hpen	;pen for the invis. screen
    	;|> load all the bitmaps
    	INVOKE LoadBitmap,hInstance,addr bodybit
    	mov bodybmp,eax
    	INVOKE CreateCompatibleDC,myDC
    	mov bodybmpdc,eax
	INVOKE SelectObject,bodybmpdc,bodybmp
	INVOKE LoadBitmap,hInstance,addr foodbit
    	mov snakefoodbmp,eax
    	INVOKE CreateCompatibleDC,myDC
    	mov snakefoodbmpdc,eax
	INVOKE SelectObject,snakefoodbmpdc,snakefoodbmp
	;|> initialize the random number generator
	INVOKE randomize
	;|> function that must be called for the multimedia timer
        INVOKE timeGetDevCaps,addr timercaps,8	
        

    .ELSEIF uMsg == WM_SIZE
    
    .ELSEIF uMsg==WM_CTLCOLORSTATIC   ;|> color all the static boxes
		mov eax,lParam 
		INVOKE SetTextColor,wParam,White     ;|> text color is white
		INVOKE SetBkColor,wParam,Red         ;|> background color is red
		INVOKE CreateSolidBrush,000000FFh    
		ret                                  ;|> return the handle of the backbrush

    .ELSEIF uMsg == WM_PAINT
        INVOKE BeginPaint,hWin,ADDR Ps
          mov hDC, eax
          INVOKE Paint_Proc,hWin,hDC
        INVOKE EndPaint,hWin,ADDR Ps
        
        return 0

    .ELSEIF uMsg==WM_LBUTTONDOWN           ;|> start a new game
    	INVOKE KillTimer,hWnd,10000        ;|> kill the timer to place the food (difficult is on)
    	INVOKE timeKillEvent,timerevent1   ;|> kill the main snake timer
    	INVOKE newgame,1                   ;|> ask for a new game
    	
    .ELSEIF uMsg==WM_RBUTTONDOWN
    	INVOKE SendMessage,hWin,WM_CLOSE,NULL,NULL    ;|> end the game
    	
    .ELSEIF uMsg == WM_CLOSE        ;|> are you sure that you want to quit?
        INVOKE MessageBox,hWin,ADDR TheText,ADDR szDisplayName,MB_YESNO
          .IF eax == IDNO
            return 0
          .ENDIF
          
    .ELSEIF uMsg==WM_TIMER      ;|> if "difficult" is on then place the food every 3 seconds new
    	INVOKE PlaySound,205,hInstance,SND_RESOURCE or SND_ASYNC
    	INVOKE placefood
    
    .ELSEIF uMsg==WM_KEYDOWN   ;|> change the direction of the snake here
    	.IF keypressflag==0
    	.IF wParam==VK_DOWN	
    		.IF snakeone[0].direction!=1
    			mov snakeone[0].direction,3
    			mov keypressflag,1              ;|> read at the .data section what we
    			                                ;|> need that for
    		.ENDIF
    	.ELSEIF wParam==VK_UP
    		.IF snakeone[0].direction!=3
    			mov snakeone[0].direction,1
    			mov keypressflag,1
    		.ENDIF
    	.ELSEIF wParam==VK_LEFT
    		.IF snakeone[0].direction!=2
    			mov snakeone[0].direction,4
    			mov keypressflag,1
    		.ENDIF
    	.ELSEIF wParam==VK_RIGHT
    		.IF snakeone[0].direction!=4
    			mov snakeone[0].direction,2
    			mov keypressflag,1
    		.ENDIF
    	.ENDIF
    	.ENDIF
    	
    	
   .ELSEIF uMsg == WM_DESTROY       ;|> delete all the objects we created
   	INVOKE DeleteObject,snakefoodbmp
   	INVOKE DeleteDC,snakefoodbmp
    	INVOKE DeleteObject,bodybmp
    	INVOKE DeleteDC,bodybmpdc
        INVOKE SelectObject,backbuffer,oldbit
    	INVOKE SelectObject,backbuffer,oldpen
    	INVOKE DeleteDC,backbuffer
    	INVOKE DeleteObject,backbitmap
    	INVOKE ReleaseDC,hWin,hDC
    	INVOKE DeleteObject,hpen
    	INVOKE DeleteObject,blackbrush
    	INVOKE DeleteObject,oldbit
        INVOKE PostQuitMessage,NULL
        return 0 
    .ENDIF

    INVOKE DefWindowProc,hWin,uMsg,wParam,lParam

    ret

WndProc endp

; ########################################################################

TopXY proc wDim:DWORD, sDim:DWORD

    shr sDim, 1      ; divide screen dimension by 2
    shr wDim, 1      ; divide window dimension by 2
    mov eax, wDim    ; copy window dimension into eax
    sub sDim, eax    ; sub half win dimension from half screen dimension

    return sDim

TopXY endp

; #########################################################################

Paint_Proc proc uses ebx edx esi edi ebp ecx hWin:DWORD, hDC:DWORD
	LOCAL hfont:HFONT
	
	
	;|> this paints the intro screen
	INVOKE FillRect, backbuffer, ADDR screenrect, blackbrush
	INVOKE  CreateFont,25,15,0,0,200,0,0,0,OEM_CHARSET,\
                            OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,\
                            DEFAULT_QUALITY,DEFAULT_PITCH or FF_SCRIPT,\
                            ADDR fontname
	INVOKE SelectObject,backbuffer,eax
        mov    hfont,eax
        RGB    255,255,255
	invoke SetTextColor,backbuffer,eax
	RGB    0,0,0
	invoke SetBkColor,backbuffer,eax
	invoke lstrlen,addr saflogo
	invoke TextOut,backbuffer,180,150,ADDR saflogo,eax
	invoke lstrlen,addr underln
	invoke TextOut,backbuffer,110,180,ADDR underln,eax
	invoke SelectObject,backbuffer, hfont
	INVOKE  CreateFont,15,7,0,0,200,0,0,0,OEM_CHARSET,\
                            OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,\
                            DEFAULT_QUALITY,DEFAULT_PITCH or FF_SCRIPT,\
                            ADDR fontname
	INVOKE SelectObject,backbuffer,eax
        mov    hfont,eax
        RGB    255,255,255
	invoke SetTextColor,backbuffer,eax
	RGB    0,0,0
	invoke SetBkColor,backbuffer,eax
	invoke lstrlen,addr instruct1
	invoke TextOut,backbuffer,190,250,ADDR instruct1,eax
	invoke lstrlen,addr instruct2
	invoke TextOut,backbuffer,190,280,ADDR instruct2,eax
	invoke SelectObject,backbuffer, hfont
	INVOKE BitBlt,myDC, 5, 5, screenrect.right,screenrect.bottom, backbuffer, 0, 0, SRCCOPY
	return 0
Paint_Proc endp

;##########################################################################

placefood proc uses edi esi ebx edx ecx ebp
	;|> this calculates the new position for the food
	;|> it uses random numbers
	
	xor edx,edx
    	mov eax,Wwd
	mov ecx,16
	div ecx
	sub eax,16
	INVOKE random,1,eax
	mov ecx,16	
	mul ecx
	add eax,5
	mov foodx,eax
	xor edx,edx
	mov eax,Wht
	mov ecx,16
	div ecx
	sub eax,16
	INVOKE random,1,eax
	mov ecx,16
	mul ecx
	add eax,5
	mov foody,eax
	mov foodflag,1
	return 0
placefood endp

;###########################################################################

foodcrash proc uses edi esi ebx edx ecx ebp
	;|> did the snake eat some food?
	xor ebx,ebx
        xor ecx,ecx
        mov ebx,foody
    	mov ecx,foodx
    	.IF (snakeone[0].sx==ecx) && (snakeone[0].sy==ebx)  ;|> check that here
    		;|> give some points when the snake ate the food
    		.IF sg==1
    			add punkte,150
    		.ELSEIF sg==2
    			add punkte,75
    		.ELSEIF sg==3
    			add punkte,30
    		.ENDIF
    		.IF difflag==1
    			add punkte,20
    		.ENDIF
    		mov foodflag,0
    		;|> add a new snakeelement at the end of the snake
    		inc snakeelements
    		xor eax,eax
    		xor ecx,ecx
    		xor ebx,ebx
    		mov eax,snakeelements
    		mov ecx,12
    		mul ecx
    		mov ebx,snakeone[eax-12].sx
    		.IF snakeone[eax-12].direction==1
    			mov snakeone[eax].sx,ebx
    		.ELSEIF snakeone[eax-12].direction==2	
    			sub ebx,16
    			mov snakeone[eax].sx,ebx
    		.ELSEIF snakeone[eax-12].direction==3
    			mov snakeone[eax].sx,ebx
    		.ELSEIF snakeone[eax-12].direction==4
    			add ebx,16
    			mov snakeone[eax].sx,ebx
    		.ENDIF
    		xor eax,eax
    		xor ecx,ecx
    		xor ebx,ebx
    		mov eax,snakeelements
    		mov ecx,12
    		mul ecx
    		mov ebx,snakeone[eax-12].sy
    		.IF snakeone[eax-12].direction==1
    			add ebx,16
    			mov snakeone[eax].sy,ebx
    		.ELSEIF snakeone[eax-12].direction==2	
    			mov snakeone[eax].sy,ebx
    		.ELSEIF snakeone[eax-12].direction==3
    			sub ebx,16
    			mov snakeone[eax].sy,ebx
    		.ELSEIF snakeone[eax-12].direction==4
    			mov snakeone[eax].sy,ebx
    		.ENDIF
    		INVOKE PlaySound,202,hInstance,SND_RESOURCE or SND_ASYNC
    		
      	.ENDIF
      	
      	INVOKE wsprintf,addr punktestr,addr szformat,punkte
      	INVOKE SetWindowText,punktehwnd,addr punktestr 
      	return 0
foodcrash endp

;##############################################################################

snakecrash proc uses edi esi ebx edx ecx ebp 
	;|> did the snake crash into itself?
	xor esi,esi
	xor edi,edi
	xor ebx,ebx
	xor edx,edx
    	mov esi,2
    	mov eax,12
    	mov edi,snakeelements
    	inc edi
    	.repeat
		;|> check that in this loop. every element of the snake 
		;|> is compared with the coordinates of the head of the
		;|> snake
		mov ebx,snakeone[eax].sx
		mov edx,snakeone[eax].sy
		.IF (snakeone[0].sx==ebx) && (snakeone[0].sy==edx)
			INVOKE random,1,2
    			.IF eax==1
    				INVOKE PlaySound,200,hInstance,SND_RESOURCE or SND_ASYNC
    			.ELSEIF eax==2
    				INVOKE PlaySound,201,hInstance,SND_RESOURCE or SND_ASYNC
    			.ENDIF
    			
    			INVOKE newgame,0
    		.ENDIF
    		mov eax,esi
        	mov ecx,12
        	mul ecx
        	inc esi
        	xor ebx,ebx
        	xor edx,edx
        .until esi>edi
        return 0
snakecrash endp

;#########################################################################

wallcrash proc uses edi esi ebx edx ecx ebp
	;|> did the snake hit the wall?
	xor ebx,ebx
	xor edx,edx
	;|> compare that here
	.IF (snakeone[0].sx<5) || (snakeone[0].sy<5) || (snakeone[0].sx>625) || (snakeone[0].sy>445)
		INVOKE random,1,2
    		.IF eax==1
    			INVOKE PlaySound,200,hInstance,SND_RESOURCE or SND_ASYNC
    		.ELSEIF eax==2
    			INVOKE PlaySound,201,hInstance,SND_RESOURCE or SND_ASYNC
    		.ENDIF
    		
		INVOKE newgame,0
	.ENDIF
	ret
wallcrash endp

;#########################################################################

movesnake proc uses edi esi ebx edx ecx ebp
	;|> depending on the direction the new snake elements coordinates 
	;|> are calculated here. 
	xor esi,esi
	xor edi,edi
    	mov esi,1
    	mov eax,0
    	mov edi,snakeelements
    	inc edi
    	.repeat
		.IF snakeone[eax].direction==1
    			sub snakeone[eax].sy,16
    		.ELSEIF snakeone[eax].direction==2
    			add snakeone[eax].sx,16
    		.ELSEIF snakeone[eax].direction==3
    			add snakeone[eax].sy,16
    		.ELSEIF snakeone[eax].direction==4
	    		sub snakeone[eax].sx,16
    		.ENDIF
    		INVOKE BitBlt,backbuffer,snakeone[eax].sx,snakeone[eax].sy,16,16,bodybmpdc,0,0,SRCCOPY
    		mov eax,esi
        	mov ecx,12
        	mul ecx
        	inc esi
        .until esi>edi
        return 0
movesnake endp

;#########################################################################

changedirection proc uses esi edi ecx ebx edx ebp
	;|> this procedure gives an element of the snake the direction of the predecessor element
	xor esi,esi
	xor ebx,ebx
    	mov esi,snakeelements
    	mov eax,snakeelements
    	.repeat 
    		mov ecx,12
    		mul ecx
    		mov ebx,snakeone[eax-12].direction
    		mov snakeone[eax].direction,ebx
    		dec esi
    		mov eax,esi
    	.until esi==0
    	return 0
changedirection endp

;#########################################################################

newgame PROC uses ecx edx ebx esi edi ebp whs:DWORD
	;|> this starts a new game
	INVOKE KillTimer,hWnd,10000
	INVOKE timeKillEvent,timerevent1
	cmp whs,1
	je jumpoverh
	INVOKE gethighscorepoints
        xor ebx,ebx
	xor ecx,ecx
	mov ebx,0
	mov ecx,punkte
        ;|> check if we have a new highscore
vergleich:
	cmp ecx,regpunkte[ebx*4]
	jg raus
	inc ebx
	cmp ebx,5
	jl vergleich
raus:
	.IF ebx<5 
		;|> if we have a new highscore, call the dialog box to type in the name
		mov position,ebx
          	INVOKE DialogBoxParam,hInstance,6001,hWnd,offset highscore,NULL
        .ENDIF
jumpoverh:
	
	INVOKE MessageBox,hWnd,ADDR newgametext,ADDR szDisplayName,MB_YESNO
          .IF eax == IDYES
           	;|> set the start positions of the snake and start the game from the beginning
          	mov snakeone[0].sx,5
          	mov snakeone[0].sy,101
          	mov snakeone[0].direction,3
          	mov snakeone[12].sx,5
          	mov snakeone[12].sy,85
          	mov snakeone[12].direction,3
          	mov snakeone[24].sx,5
          	mov snakeone[24].sy,69
          	mov snakeone[24].direction,3
          	mov snakeone[36].sx,5
          	mov snakeone[36].sy,53
          	mov snakeone[36].direction,3
          	mov snakeone[48].sx,5
          	mov snakeone[48].sy,37
          	mov snakeone[48].direction,3
          	mov snakeone[60].sx,5
          	mov snakeone[60].sy,21
          	mov snakeone[60].direction,3
          	mov snakeone[72].sx,5
          	mov snakeone[72].sy,5
          	mov snakeone[72].direction,3
          	mov snakeelements,6
          	mov punkte,0
          	.IF difflag==1
          		INVOKE SetTimer,hWnd,10000,2500,NULL
          	.ENDIF
          	INVOKE timeSetEvent,speednr,addr timercaps,offset snakemainproc,0,1
          	mov timerevent1,eax
          .ELSEIF
          	INVOKE InvalidateRect,hWnd,NULL,FALSE
          .ENDIF
	ret
newgame endp

;#########################################################################

random PROC uses ecx edx ebx esi edi ebp first:DWORD,second:DWORD
	mov ebx,second
	sub ebx,first
	inc ebx
	xor edx,edx
	mov eax,rand
	div ebx
	add rand,eax
	add edx,first
	mov eax,edx
	ret
random ENDP

;#########################################################################

randomize proc uses ecx edx ebx esi edi ebp
	INVOKE GetTickCount
	mov rand,eax
	ret
randomize endp

;#########################################################################

highscore proc uses ecx edx ebx esi edi ebp hdlg:DWORD,uMsg:DWORD,wParam :DWORD,lParam :DWORD
	LOCAL hRegKey:DWORD
	LOCAL Result:DWORD
	
	;|> the procedure of the dialog where you type in your name
	
	.IF uMsg==WM_INITDIALOG
		INVOKE random,1,2
    		.IF eax==1
    			INVOKE PlaySound,203,hInstance,SND_RESOURCE or SND_ASYNC
    		.ELSEIF eax==2
    			INVOKE PlaySound,204,hInstance,SND_RESOURCE or SND_ASYNC
    		.ENDIF
		
		
	.ELSEIF uMsg==WM_CLOSE
		INVOKE EndDialog,hdlg,NULL
	.ELSEIF uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,eax
		shr edx,16
		.IF edx==BN_CLICKED
			.IF ax==20  
				;|> this writes the new highscore to registry
				INVOKE GetDlgItemText,hdlg,10,addr szStringValue,29
				.IF position==4
					INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szKeyName, 0, \
		   			NULL, 0, KEY_READ or KEY_WRITE or KEY_QUERY_VALUE  , 0, ADDR hRegKey, ADDR Result
					INVOKE RegSetValueEx,hRegKey,addr name5txt,0,REG_SZ,addr szStringValue,sizeof szStringValue
					INVOKE RegSetValueEx,hRegKey,addr punkte5txt,0,REG_SZ,addr punktestr,sizeof punktestr
				.ELSEIF position==3
					INVOKE savepositions,1    ;|> the old positions have to be saved. that means, that
					;|> if for example you are the first on the list, then the one you replaced has to be
					;|> on the second positions. that's exactly what the procedure savepositions does
					INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szKeyName, 0, \
		   			NULL, 0, KEY_READ or KEY_WRITE or KEY_QUERY_VALUE  , 0, ADDR hRegKey, ADDR Result
					INVOKE RegSetValueEx,hRegKey,addr name4txt,0,REG_SZ,addr szStringValue,sizeof szStringValue
					INVOKE RegSetValueEx,hRegKey,addr punkte4txt,0,REG_SZ,addr punktestr,sizeof punktestr
				.ELSEIF position==2
					INVOKE savepositions,2
					INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szKeyName, 0, \
		   			NULL, 0, KEY_READ or KEY_WRITE or KEY_QUERY_VALUE  , 0, ADDR hRegKey, ADDR Result
					INVOKE RegSetValueEx,hRegKey,addr name3txt,0,REG_SZ,addr szStringValue,sizeof szStringValue
					INVOKE RegSetValueEx,hRegKey,addr punkte3txt,0,REG_SZ,addr punktestr,sizeof punktestr
				.ELSEIF position==1
					INVOKE savepositions,3
					INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szKeyName, 0, \
		   			NULL, 0, KEY_READ or KEY_WRITE or KEY_QUERY_VALUE  , 0, ADDR hRegKey, ADDR Result
					INVOKE RegSetValueEx,hRegKey,addr name2txt,0,REG_SZ,addr szStringValue,sizeof szStringValue
					INVOKE RegSetValueEx,hRegKey,addr punkte2txt,0,REG_SZ,addr punktestr,sizeof punktestr
				.ELSEIF position==0
					INVOKE savepositions,4
					INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szKeyName, 0, \
		   			NULL, 0, KEY_READ or KEY_WRITE or KEY_QUERY_VALUE  , 0, ADDR hRegKey, ADDR Result
					INVOKE RegSetValueEx,hRegKey,addr name1txt,0,REG_SZ,addr szStringValue,sizeof szStringValue
					INVOKE RegSetValueEx,hRegKey,addr punkte1txt,0,REG_SZ,addr punktestr,sizeof punktestr
				.ENDIF
				INVOKE RegCloseKey,hRegKey
				INVOKE EndDialog,hdlg,NULL
				INVOKE InvalidateRect,hWnd,NULL,FALSE
				;|> show the highscore list
            			INVOKE DialogBoxParam,hInstance,6002,hWnd,offset showhighscore,NULL
			.ENDIF
		.ENDIF
	.ELSE
		mov eax,FALSE
		ret
	.ENDIF
	mov  eax,TRUE
	ret
highscore endp

;#########################################################################

gethighscorepoints proc uses ecx edx ebx esi edi ebp
	LOCAL hRegKey:DWORD
	LOCAL Result:DWORD
	
	;|> in the new game procedure we check if we have a new highscore. but first we
	;|> have to save the highscores in a variable called regpunkte
	
	INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szKeyName, 0, \
		   NULL, 0, KEY_READ or KEY_WRITE or KEY_QUERY_VALUE  , 0, ADDR hRegKey, ADDR Result
	;|> if we run the game the first time, the predefined highscores have to be set
	.IF Result==REG_CREATED_NEW_KEY
		INVOKE RegSetValueEx,hRegKey,addr name1txt,0,REG_SZ,addr prename,sizeof prename
		INVOKE RegSetValueEx,hRegKey,addr name2txt,0,REG_SZ,addr prename,sizeof prename
		INVOKE RegSetValueEx,hRegKey,addr name3txt,0,REG_SZ,addr prename,sizeof prename
		INVOKE RegSetValueEx,hRegKey,addr name4txt,0,REG_SZ,addr prename,sizeof prename
		INVOKE RegSetValueEx,hRegKey,addr name5txt,0,REG_SZ,addr prename,sizeof prename
		INVOKE RegSetValueEx,hRegKey,addr punkte1txt,0,REG_SZ,addr prepoints1,sizeof prepoints1
		INVOKE RegSetValueEx,hRegKey,addr punkte2txt,0,REG_SZ,addr prepoints2,sizeof prepoints2
		INVOKE RegSetValueEx,hRegKey,addr punkte3txt,0,REG_SZ,addr prepoints3,sizeof prepoints3
		INVOKE RegSetValueEx,hRegKey,addr punkte4txt,0,REG_SZ,addr prepoints4,sizeof prepoints4
		INVOKE RegSetValueEx,hRegKey,addr punkte5txt,0,REG_SZ,addr prepoints5,sizeof prepoints5
	.ENDIF	
	mov dwBBufLength,30
	INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength  ;|> clear the buffer
	INVOKE RegQueryValueEx, hRegKey,addr punkte1txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
	;|> read the points
	INVOKE atodw,addr szBigBuffer  ;|> and convert them to a number
	mov regpunkte[0],eax   ;|> and save the number in regpunkte
	INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
    	INVOKE RegQueryValueEx, hRegKey,addr punkte2txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
	INVOKE atodw,addr szBigBuffer
	mov regpunkte[4],eax
	INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
    	INVOKE RegQueryValueEx, hRegKey,addr punkte3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
	INVOKE atodw,addr szBigBuffer
	mov regpunkte[8],eax
	INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
    	INVOKE RegQueryValueEx, hRegKey,addr punkte4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
	INVOKE atodw,addr szBigBuffer
	mov regpunkte[12],eax
	INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
    	INVOKE RegQueryValueEx, hRegKey,addr punkte5txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
    	INVOKE atodw,addr szBigBuffer
	mov regpunkte[16],eax
	INVOKE RegCloseKey,hRegKey
	ret
gethighscorepoints endp

;#########################################################################

showhighscore proc uses ecx edx ebx esi edi ebp hdlg:DWORD,uMsg:DWORD,wParam :DWORD,lParam :DWORD
	LOCAL hRegKey:DWORD
	LOCAL Result:DWORD
	LOCAL dlgrect:RECT
	LOCAL dlgdc:DWORD
	LOCAL hfont:HFONT 
	
	;|> this is the dialog that shows the highscore list
	.IF uMsg==WM_INITDIALOG
		;|> first we read all the entrys and then.......
		INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szKeyName, 0, \
		   NULL, 0, KEY_READ or KEY_WRITE or KEY_QUERY_VALUE  , 0, ADDR hRegKey, ADDR Result
		.IF Result==REG_CREATED_NEW_KEY
			INVOKE gethighscorepoints
		.ENDIF
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name1txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,1,addr szBigBuffer
		;|>  .....we put them to the static boxes in the dialog
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name2txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,2,addr szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,3,addr szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,4,addr szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name5txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,5,addr szBigBuffer
		
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte1txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,6,addr szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte2txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,7,addr szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,8,addr szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,9,addr szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte5txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE SetDlgItemText,hdlg,10,addr szBigBuffer
		
		INVOKE RegCloseKey,hRegKey
	
	.ELSEIF uMsg==WM_CLOSE
		INVOKE EndDialog,hdlg,NULL
	.ELSEIF uMsg==WM_COMMAND
		mov eax,wParam
		mov edx,eax
		shr edx,16
		.IF edx==BN_CLICKED
			.IF ax==20  
				INVOKE EndDialog,hdlg,NULL
			.ENDIF
		.ENDIF
	
	;|> color the staticboxes and the dialog
	.ELSEIF uMsg==WM_CTLCOLORDLG
		mov eax,lParam
		INVOKE SetTextColor,wParam,White
		INVOKE SetBkColor,wParam,Red
		INVOKE CreateSolidBrush,000000FFh
		ret
		
	.ELSEIF uMsg==WM_CTLCOLORSTATIC
		mov eax,lParam
		INVOKE SetTextColor,wParam,White
		INVOKE SetBkColor,wParam,Black
		INVOKE CreateSolidBrush,00000000h
		ret
		
	.ELSEIF uMsg==WM_PAINT
		;|> that paint the red border with the black square in the middle
		INVOKE GetClientRect,hdlg,addr dlgrect
		INVOKE GetWindowDC,hdlg
		push eax
		INVOKE SelectObject,eax,blackbrush
		mov ecx,dlgrect.right
		sub ecx,5
		mov dlgrect.right,ecx
		mov ecx,dlgrect.bottom
		sub ecx,5
		mov dlgrect.bottom,ecx
		pop eax
		INVOKE Rectangle,eax,5,5,dlgrect.right,dlgrect.bottom
		INVOKE  CreateFont,25,15,0,0,200,0,0,0,OEM_CHARSET,\
                            OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,\
                            DEFAULT_QUALITY,DEFAULT_PITCH or FF_SCRIPT,\
                            ADDR fontname
		push eax    
                INVOKE GetWindowDC,hdlg
                mov dlgdc,eax
                pop eax
                INVOKE SelectObject,dlgdc,eax
                mov    hfont,eax
                RGB    255,255,255
		invoke SetTextColor,dlgdc,eax
		RGB    0,0,0
		invoke SetBkColor,dlgdc,eax
		invoke lstrlen,addr buttontext1
		invoke TextOut,dlgdc,155,8,ADDR buttontext1,eax
		invoke SelectObject,dlgdc, hfont
		return 0
	
	.ELSEIF uMsg==WM_LBUTTONDOWN
		;|> the dialog has no caption, so we can't move it normally,
		;|> but that little trick allows the user to move the dialog
		INVOKE ReleaseCapture
		INVOKE SendMessage,hdlg,WM_NCLBUTTONDOWN,HTCAPTION,0

	.ELSE
		mov eax,FALSE
		ret
	.ENDIF
	mov  eax,TRUE
	ret
showhighscore endp

;#########################################################################

snakemainproc proc hwin:DWORD,uMsg:DWORD,idEvent :DWORD,dwTime :DWORD
	;|> this is the procedure of the multimedia timer. here all the
	;|> procedures that are needed to move the snake are called
	.IF foodflag==0 
    		INVOKE placefood
	.ENDIF
	INVOKE movesnake
    	INVOKE foodcrash
    	INVOKE snakecrash
    	INVOKE wallcrash
        
        INVOKE BitBlt,backbuffer,foodx,foody,16,16,snakefoodbmpdc,0,0,SRCCOPY
        INVOKE BitBlt,myDC, 5, 5, screenrect.right,screenrect.bottom, backbuffer, 0, 0, SRCCOPY
	INVOKE FillRect, backbuffer, ADDR screenrect, blackbrush
	mov keypressflag,0
	INVOKE changedirection
	ret 14h     ;|> Test Deparment told me to do that. if i use just ret the program 
		    ;|> program crashed, dunno why. perhaps someone of you could explain
		    ;|> that to me?
snakemainproc endp

;#########################################################################

savepositions proc uses ecx edx ebx esi edi ebp number:DWORD
	LOCAL hRegKey:DWORD
	LOCAL Result:DWORD
	
	;|> this saves the positions of the old entrys in the highscore. somewhere above
	;|> i explained that a bit more. 
	
	INVOKE RegCreateKeyEx, HKEY_LOCAL_MACHINE, ADDR szKeyName, 0, \
		   NULL, 0, KEY_READ or KEY_WRITE or KEY_QUERY_VALUE  , 0, ADDR hRegKey, ADDR Result
	.IF number==4
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name5txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name4txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name2txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name3txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name1txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name2txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte5txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte4txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte2txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte3txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte1txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte2txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
	.ELSEIF number==3
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name5txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name4txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name2txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name3txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte5txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte4txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte2txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte3txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
	.ELSEIF number==2
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name5txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name4txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
	        
	        mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte5txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte3txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte4txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
	.ELSEIF number==1
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr name4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr name5txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
		
		mov dwBBufLength,30
		INVOKE RtlZeroMemory,addr szBigBuffer,dwBBufLength
		INVOKE RegQueryValueEx, hRegKey,addr punkte4txt,0,addr datatype,addr szBigBuffer,addr dwBBufLength
		INVOKE RegSetValueEx,hRegKey,addr punkte5txt,0,REG_SZ,addr szBigBuffer,sizeof szBigBuffer
	.ENDIF
	INVOKE RegCloseKey,hRegKey	
	ret
savepositions endp

; ########################################################################

end start
