/***************************************************
/*  
/* Netscape Parental Control Add-On Dll
/* by: Amante4 of Immortal Descendants
/* March 20, 2000
/* All rights reserved
/*
/***************************************************/


#include <windows.h>

// translate tables for password encryption
unsigned char xlate_tablea[256] = { 0x63,0x11,0xFB,0xA3,0xF2,0x71,0xAA,0xF1,0xD1,0x7A,0x5F,
0x07,0x0C,0xAD,0xAF,0xFE,0x90,0xED,0x94,0x76,0x84,0x69,
0xE2,0x7E,0x68,0xEF,0xD6,0x6D,0xFF,0x0A,0x2B,0x40,0xE6,
0x1B,0x5E,0xF3,0x45,0xBB,0x46,0x65,0xD9,0xC3,0xE1,0x95,
0x93,0xA5,0xA9,0x0E,0x08,0x88,0x3C,0x04,0x2F,0xB5,0x30,
0x43,0x12,0x55,0x18,0x81,0xE8,0x1E,0xFD,0x16,0x82,0x4E,
0xF0,0x4F,0x80,0xF8,0x66,0x10,0xA2,0x5B,0x37,0x74,0xA6,
0xB2,0x51,0xD4,0xEA,0xDA,0x3D,0xE3,0x44,0x33,0x2E,0xCD,
0xDD,0x34,0x1C,0xC6,0x27,0x02,0xB3,0x56,0xE5,0x9A,0x64,
0x73,0x54,0xCB,0xDE,0xBE,0x0F,0x8F,0x85,0xA1,0x0D,0x8B,
0x8E,0xC8,0xC2,0x78,0xF5,0x52,0x9D,0x53,0xBA,0x2D,0xCE,
0x5C,0x48,0xC0,0x20,0x61,0x3E,0xFA,0xC5,0x67,0xD5,0x98,
0xB8,0x58,0xB7,0xB6,0xF9,0xC7,0x19,0x6C,0x72,0x7F,0x31,
0x7B,0x1F,0x4A,0x6F,0x09,0x8D,0x3F,0xD7,0x50,0xEE,0x17,
0x42,0x06,0x1D,0x21,0xC4,0xB0,0x9E,0xBC,0x38,0xE9,0xA0,
0xA7,0x5D,0x1A,0xEB,0xCF,0x6A,0x6B,0x24,0xD2,0x92,0x4D,
0x2A,0x8A,0x26,0xB9,0x01,0x25,0xF6,0x0B,0x03,0x87,0x36,
0x97,0x15,0x9B,0xE7,0x13,0x86,0xD0,0x59,0xB4,0x23,0xAB,
0x14,0x7D,0x00,0xBF,0xFC,0x8C,0x89,0x39,0x7C,0xC1,0xE0,
0x32,0x62,0xB1,0xA8,0xDC,0x96,0xBD,0xD3,0x29,0x83,0x3B,
0x47,0x05,0x4B,0x5A,0xF7,0x35,0xF4,0xEC,0x99,0x75,0x22,
0xDB,0x91,0xA4,0xC9,0xAE,0x9C,0x57,0x4C,0x77,0x49,0xDF,
0xCC,0x41,0x2C,0xAC,0x9F,0x28,0xCA,0x60,0xE4,0x3A,0x70,
0xD8,0x6E,0x79 };

unsigned char xlate_tableb[256] = { 0x1C,0x73,0xC8,0x9D,0x65,0x0D,0x1B,0xA9,0x63,0xDA,0xFD,
0x7D,0x9A,0x2E,0xEC,0xC6,0x70,0x6A,0x32,0x69,0xEA,0xF4,
0xE1,0x86,0xD1,0xF8,0xB6,0xB0,0xE8,0x98,0x4F,0x7E,0x50,
0x01,0x37,0x75,0xDB,0x56,0x44,0xBB,0xF1,0xE0,0xB7,0xC2,
0x51,0x39,0x20,0x7B,0xEF,0x3C,0x77,0x8C,0x59,0xB2,0xFA,
0x21,0xD3,0xD2,0x58,0xCA,0x7F,0x52,0x8B,0x5D,0x0A,0x88,
0x26,0x13,0xDE,0xB3,0xA0,0xDF,0xF7,0x94,0x11,0xFF,0x35,
0x4D,0x33,0x60,0x5E,0x99,0x3D,0x46,0x3B,0x92,0xC0,0x17,
0xD7,0xCF,0xDD,0x72,0xD4,0x67,0xF5,0x6D,0xBA,0x79,0xCC,
0x0C,0x6C,0x08,0xD5,0x24,0x03,0xC7,0x23,0xA4,0x3E,0x7A,
0xFC,0xBC,0x5F,0x22,0x74,0x0B,0x9F,0xA6,0x00,0x8E,0x1E,
0xBE,0x8A,0x1A,0x93,0x82,0x78,0x25,0xA3,0x81,0x6E,0x2B,
0x47,0xA1,0x12,0xF3,0x55,0x91,0xB5,0x15,0x02,0x64,0xC1,
0x6F,0xE2,0x9B,0x87,0x5A,0x06,0xC9,0xE5,0x19,0x4C,0x36,
0x09,0x5C,0x2F,0xD9,0xB4,0x3A,0x2D,0x48,0xC3,0x83,0x04,
0x42,0x40,0xAF,0xE6,0x0F,0x57,0xC5,0xB8,0x41,0x95,0xF6,
0x45,0xEE,0x0E,0xA2,0xE9,0xBF,0x76,0x2C,0x7C,0x90,0x71,
0x4E,0xD6,0x49,0x68,0x61,0x8F,0x1F,0xF0,0xAB,0x66,0xAD,
0x27,0xC4,0x8D,0x6B,0xCE,0xF2,0x97,0x84,0x54,0xF9,0xFB,
0x80,0xD0,0x4B,0xA5,0xE3,0x43,0x07,0xAC,0x10,0x28,0x62,
0x05,0xB1,0x96,0xED,0x16,0xB9,0x3F,0x89,0x1D,0xEB,0x29,
0xAE,0xCB,0xE4,0xFE,0x2A,0x53,0xD8,0x14,0xCD,0x34,0xA8,
0xAA,0xBD,0xA7,0x38,0x9E,0x18,0x9C,0x5B,0x4A,0x30,0x31,
0xDC,0x85,0xE7 };

unsigned char newpass[50]; // global variable

// fuction to Encrypt the password
unsigned char * EncryptPass(unsigned char *pass, int length) {
	int i;


	for (i=0;i<length;++i) {
		// even chars get looked up in 1 translation table
		if ((i % 2) == 0) { // if div by 2
			newpass[i] = xlate_tablea[pass[i]]; // translate char
			newpass[i] += 5;
			newpass[i] ^= 0x5a; // and modify it slightly
		}
		// odd chars get looked up in another
		else {
			newpass[i] = xlate_tableb[pass[i]]; // translate char
			newpass[i] -= 5;
			newpass[i] ^= 0xa5; // and modify it slightly different
		}
	}
	newpass[i] = 0xff; // ending delimiter
	return newpass; // return the encrypted password
}

// function to compare 2 encrypted passwords
int ComparePasswords(unsigned char *enc_pass, unsigned char *reg_pass, unsigned long length) {
	unsigned long i; // just to keep the compiler happy ;)

	for (i=0;i<length;++i) {
		if (enc_pass[i] != reg_pass[i]) {
			return 1; // return 1 for failure anytime they don't match
		}
	}
	return 0; // return 0 for success
}

// this is the window dialog process to handle new passwords	
BOOL CALLBACK NewPassDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	LPTSTR NewPasswordBuf;
	unsigned char *enc_pass;
	int length;
	long ret_value;
	HKEY hKey;

	if (uMsg == WM_INITDIALOG) {
		EnableWindow(GetDlgItem(hwndDlg,1000),0); // shut off 1st box since there is no existing pass
		SetFocus(GetDlgItem(hwndDlg,1001)); // Set focus to 2nd edit box
		return 0;  // return 0 cuz it's WM_INITDIALOG and we set focus
	}
	else if (uMsg == WM_COMMAND) {
		if(wParam == 0x1) { // the OK button
			NewPasswordBuf = (LPTSTR)malloc(50); // buffer of 50 chars
			length = GetDlgItemText(hwndDlg,
				           1001,
						   NewPasswordBuf,
						   50); // get the text typed in

			enc_pass = EncryptPass((unsigned char *)NewPasswordBuf,length); // encrypt the password
			// try to open the registry key
			ret_value = RegCreateKeyEx(HKEY_CURRENT_USER,
			                 "Software\\Netscape\\PC",
							 0,
							 NULL,
							 REG_OPTION_NON_VOLATILE,
							 KEY_SET_VALUE,
							 NULL,
							 &hKey,
							 NULL
							);  // Create it if it doesn't exist. Otherwise just open it.


			ret_value = RegSetValueEx(hKey,
			                 "SSAP",
							 0,
							 REG_SZ,
							 enc_pass,
							 length); // put the encrypted pass in registry
			EndDialog(hwndDlg,0); // end the dialog return 0 for sucess
		}
		else if (wParam == 0x2) { // the Cancel button
			EndDialog(hwndDlg,1); // just end the dialog return 1 for failure
			return 1;
		}

	}
	else {
		return 0; // an unknown msg so fail cuz we didn't process it
	}
}

// this is the window dialog process to handle password entries
BOOL CALLBACK PassDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	LPTSTR PasswordBuf;
	int length,result;
	long ret_value;
	HKEY hKey;
	unsigned long value_length;
	unsigned char *reg_pass;
	unsigned char *enc_pass;

	if (uMsg == WM_INITDIALOG) {
		SetDlgItemText(hwndDlg,123,"Please enter your \nNetscape Parental Control Password:");
		SetFocus(GetDlgItem(hwndDlg,124)); // Set focus to edit box
		return 0;
	}
	else if (uMsg == WM_COMMAND) {
		if(wParam == 0x1) { // the OK button
			PasswordBuf = (LPTSTR)malloc(50); // buffer of 50 chars
			length = GetDlgItemText(hwndDlg,
				           124,
						   PasswordBuf,
						   50); // get the text typed in
			enc_pass = EncryptPass((unsigned char *)PasswordBuf,length); // encrypt the string

			ret_value = RegOpenKeyEx(HKEY_CURRENT_USER,
			                 "Software\\Netscape\\PC",
							 0,
							 KEY_QUERY_VALUE,
							 &hKey
							);

			// first query value to get length
			ret_value = RegQueryValueEx(hKey,
				             "SSAP",
							 NULL,
							 NULL,
							 NULL,
							 &value_length);

			reg_pass = (unsigned char*)malloc(value_length); // allocate a buffer
			
			// now fetch the value
			ret_value = RegQueryValueEx(hKey,
				             "SSAP",
							 NULL,
							 NULL,
							 reg_pass,
							 &value_length);

			// first make sure passwords are same length
			if ((unsigned long)length == value_length) {

				// compare the encrypted versions of the passwords
				result = ComparePasswords(enc_pass,reg_pass,value_length); 
				EndDialog(hwndDlg,result); // end the dialog with the results of the compare
			}
			else { EndDialog(hwndDlg,1); } // otherwise fail

			return 1;
		}
		else if (wParam == 0x2) { // the Cancel button
			EndDialog(hwndDlg,1); // just end the dialog return 1 for failure
			return 1;
		}

	}
	else {
		return 0;
	}
}

// Exported function to ask for password from 
// user when they try to clear/modify history
int ask_for_passwd(void){
	HRSRC passdialog;
	HINSTANCE module_handle;
	HGLOBAL dialog_handle;
	long ret_value;
	HKEY hKey;
	int result;

	// try to open the registry key
	ret_value = RegOpenKeyEx(HKEY_CURRENT_USER,
			                 "Software\\Netscape\\PC",
							 0,
							 KEY_QUERY_VALUE,
							 &hKey
							);

	ret_value = RegQueryValueEx(hKey, // check to see if Password is in registry
			                 "SSAP",
							 NULL,
							 NULL,
							 NULL,
							 NULL);
	if (ret_value != ERROR_SUCCESS) { // password doesn't exist
		// then ask for password the first time
		result = DialogBox(LoadLibrary("nspc.dll"), MAKEINTRESOURCE(101), NULL, NewPassDlgProc);
		return (result);
	}
	else { // password exists


		module_handle=LoadLibrary("resdll.dll"); // use dialog from resdll.dll

		passdialog=FindResource(module_handle,  // find the dialog resource
		                        "#110", // resource 110
		                        (LPSTR)5 // RT_DIALOG  
				               );
		dialog_handle= LoadResource(module_handle, // load it into memory
		                        passdialog);


		// get the password dialog from resdll.dll
		result = DialogBoxIndirect(module_handle,
						 dialog_handle,
						 NULL,
						 PassDlgProc);
		return (result);
	}
}

// this is the window dialog process to handle password changes
BOOL CALLBACK ChangePassDlgProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	LPTSTR NewPasswordBuf,OldPasswordBuf;
	int length,result,new_length;
	long ret_value;
	HKEY hKey;
	unsigned long value_length;
	unsigned char *reg_pass;
	unsigned char *enc_pass;

	if (uMsg == WM_INITDIALOG) {
		SetFocus(GetDlgItem(hwndDlg,1000)); // Set focus to 1st edit box
		return 0;
	}
	else if (uMsg == WM_COMMAND) {
		if(wParam == 0x1) { // the OK button
			OldPasswordBuf = (LPTSTR)malloc(50); // buffer of 50 chars
			NewPasswordBuf = (LPTSTR)malloc(50); // buffer of 50 chars
			length = GetDlgItemText(hwndDlg,
				           1000,
						   OldPasswordBuf,
						   50); // get the text typed in
			new_length = GetDlgItemText(hwndDlg,
				           1001,
						   NewPasswordBuf,
						   50); // get the text typed in
			enc_pass = EncryptPass((unsigned char *)OldPasswordBuf,length); // encrypt the string

			ret_value = RegOpenKeyEx(HKEY_CURRENT_USER,
			                 "Software\\Netscape\\PC",
							 0,
							 KEY_QUERY_VALUE,
							 &hKey
							);

			// first query value to get length
			ret_value = RegQueryValueEx(hKey,
				             "SSAP",
							 NULL,
							 NULL,
							 NULL,
							 &value_length);

			reg_pass = (unsigned char*)malloc(value_length); // allocate a buffer
			
			// now fetch the value
			ret_value = RegQueryValueEx(hKey,
				             "SSAP",
							 NULL,
							 NULL,
							 reg_pass,
							 &value_length);

			// compare the encrypted versions of the passwords
			result = ComparePasswords(enc_pass,reg_pass,value_length); 
			
			if (!result) { // if they compare OK then
				enc_pass = EncryptPass((unsigned char *)NewPasswordBuf,new_length); // encrypt the string
				// try to open the registry key
				ret_value = RegOpenKeyEx(HKEY_CURRENT_USER,
			                 "Software\\Netscape\\PC",
							 0,
							 KEY_ALL_ACCESS,
							 &hKey
							);

				ret_value = RegSetValueEx(hKey,
			                 "SSAP",
							 0,
							 REG_SZ,
							 enc_pass,
							 new_length); // put the encrypted pass in registry
				EndDialog(hwndDlg,0); // End dialog return 0 for success
			}
			else {
				EndDialog(hwndDlg,1); // End dialog return 1 for failure
			}


			return 1;
		}
		else if (wParam == 0x2) { // the Cancel button
			EndDialog(hwndDlg,1); // just end the dialog return 1 for failure
			return 1;
		}

	}
	else {
		return 0;
	}
}

// Exported function to change the password when 
// requested
int change_password(void) {
	int result;

	result = DialogBox(LoadLibrary("nspc.dll"), MAKEINTRESOURCE(101), NULL, ChangePassDlgProc);

	if (result) {
		MessageBox(NULL,"Password not changed. Please check and try again.","Error:",MB_OK);
	}
	else {
		MessageBox(NULL,"Password changed successfully.","Success:",MB_OK);
	}

	return (result);


}

// Exported function to check on the history file at startup
// to make sure it hasn't been tampered with since last shutdown
int check_history_file(char *profile_name){
	char *history_file;
	long ret_value;
	HKEY hKey, hSubKey;
	unsigned long value_length;
	DWORD size;
	DWORD LWTH,LWTL,FSH,FSL;
	WIN32_FILE_ATTRIBUTE_DATA *file_info;

	// allocate some memory for our pointers to hold stuff
	file_info = malloc(sizeof(WIN32_FILE_ATTRIBUTE_DATA));
	history_file=(char*)malloc(MAX_PATH);

	// the code I patched is gonna call a function in xppref32.dll
	// called PREF_GetCurrentProfile which returns something like this:
	// P.?`profilename 
	// I'm also goning to probe the registry to get the Netscape instalation
	// path to know where the profiles are kept
	// So I'll have to remove the crap off the front of the profile and
	// add it to the tail of the install dir to get the location
	// where the history file is at.

	// First find out where Netscape is installed
	ret_value = RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
			                 "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\Netscape.exe", 
							 0, 
							 KEY_QUERY_VALUE, 
							 &hKey
							);
	ret_value = RegQueryValueEx(hKey,
				                "Path",
								NULL,
								NULL,
								history_file,
								&value_length
								);

	// Well since the path in the registry is always going to have \Program
	// tacked on the end we need to get rid of that since we want to know
	// the root install path not the executable path
	history_file[(strlen(history_file) - 7)] = 0; // null terminate string 7 chars back from end

	// now tack on users directory since that's where the profiles are kept
	strcat(history_file,"Users\\");

	profile_name += 4; // get past shit at front of profile string

	// tack on the profile name to get to the right directory
	strcat(history_file,(const char *)profile_name);

	// we're gonna look at the file netscape.hst in that profile's directory
	strcat(history_file,"\\netscape.hst");

	// Get the files attributes
	GetFileAttributesEx(history_file,
						GetFileExInfoStandard,
						file_info);

	// Open up the registry keys to get values stored there
	ret_value = RegOpenKeyEx(HKEY_CURRENT_USER,
			                 "Software\\Netscape\\PC",
							 0,
							 KEY_QUERY_VALUE,
							 &hKey
							);
	ret_value = RegOpenKeyEx(hKey,
			                 profile_name,
							 0,
							 KEY_QUERY_VALUE,
							 &hSubKey
							);
	hKey = hSubKey;

	size = sizeof(DWORD);

	ret_value = RegQueryValueEx(hKey,
				             "LWTL",
							 NULL,
							 NULL,
							 (LPBYTE)&LWTL,
							 &size);
	ret_value = RegQueryValueEx(hKey,
				             "LWTH",
							 NULL,
							 NULL,
							 (LPBYTE)&LWTH,
							 &size);
	ret_value = RegQueryValueEx(hKey,
				             "FSL",
							 NULL,
							 NULL,
							 (LPBYTE)&FSL,
							 &size);
	ret_value = RegQueryValueEx(hKey,
				             "FSH",
							 NULL,
							 NULL,
							 (LPBYTE)&FSH,
							 &size);
	RegCloseKey(hKey);

	// check to see if current file attributes match those in registry
	if (!((FSH == file_info->nFileSizeHigh) && (FSL == file_info->nFileSizeLow) &&
		(LWTH == file_info->ftLastWriteTime.dwHighDateTime) &&
		(LWTL == file_info->ftLastWriteTime.dwLowDateTime))) {
		
		return(ask_for_passwd()); // if sizes don't match then ask for password
	}
	else { return (0); }
	
}

// Exported function to record info about the history file 
// on exit so it can be checked next time Netscape is started
void remember_history_file(char *profile_name){

	char *history_file;
	long ret_value;
	HKEY hKey, hSubKey;
	DWORD temp;
	WIN32_FILE_ATTRIBUTE_DATA *file_info;
	unsigned long value_length;

	// allocate some memory for our pointers to hold stuff
	file_info = malloc(sizeof(WIN32_FILE_ATTRIBUTE_DATA));
	history_file=(char*)malloc(MAX_PATH);

	// the code I patched is gonna call a function in xppref32.dll
	// called PREF_GetCurrentProfile which returns something like this:
	// P.?`profilename 
	// I'm also goning to probe the registry to get the Netscape instalation
	// path to know where the profiles are kept
	// So I'll have to remove the crap off the front of the profile and
	// add it to the tail of the install dir to get the location
	// where the history file is at.

	// First find out where Netscape is installed
	ret_value = RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
			                 "Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\Netscape.exe", 
							 0, 
							 KEY_QUERY_VALUE, 
							 &hKey
							);
	ret_value = RegQueryValueEx(hKey,
				                "Path",
								NULL,
								NULL,
								history_file,
								&value_length
								);

	// Well since the path in the registry is always going to have \Program
	// tacked on the end we need to get rid of that since we want to know
	// the root install path not the executable path
	history_file[(strlen(history_file) - 7)] = 0; // null terminate string 7 chars back from end

	// now tack on users directory since that's where the profiles are kept
	strcat(history_file,"Users\\");

	profile_name += 4; // get past shit at front of profile string

	// tack on the profile name to get to the right directory
	strcat(history_file,(const char *)profile_name);

	// we're gonna look at the file netscape.hst in that profile's directory
	strcat(history_file,"\\netscape.hst");

	// Get the files attributes
	GetFileAttributesEx(history_file,
						GetFileExInfoStandard,
						file_info);
	
	//save file info in registry
	ret_value = RegCreateKeyEx(HKEY_CURRENT_USER,
			                 "Software\\Netscape\\PC",
							 0,
							 NULL,
							 REG_OPTION_NON_VOLATILE,
							 KEY_ALL_ACCESS,
							 NULL,
							 &hSubKey,
							 NULL
							);  // Create it if it doesn't exist. Otherwise just open it.

	hKey = hSubKey;

	ret_value = RegCreateKeyEx(hKey,  //make a key for each profile since history files
			                 profile_name, // are per profile
							 0,
							 NULL,
							 REG_OPTION_NON_VOLATILE,
							 KEY_ALL_ACCESS,
							 NULL,
							 &hSubKey,
							 NULL
							);  // Create it if it doesn't exist. Otherwise just open it.

	hKey = hSubKey;

	temp = (DWORD) file_info->ftLastWriteTime.dwHighDateTime;

	ret_value = RegSetValueEx(hKey, // remember last write time
			                 "LWTH",
							 0,
							 REG_DWORD,
							 (BYTE *)&temp,
							 4);
	temp = (DWORD) file_info->ftLastWriteTime.dwLowDateTime;
	ret_value = RegSetValueEx(hKey, // remember last write time
			                 "LWTL",
							 0,
							 REG_DWORD,
							 (BYTE *)&temp,
							 4);
	temp = (DWORD) file_info->nFileSizeHigh;
	ret_value = RegSetValueEx(hKey, // remember file size
			                 "FSH",
							 0,
							 REG_DWORD,
							 (BYTE *)&temp,
							 4);
	temp = (DWORD) file_info->nFileSizeLow;
	ret_value = RegSetValueEx(hKey, // remember file size
			                 "FSL",
							 0,
							 REG_DWORD,
							 (BYTE *)&temp,
							 4);
	RegCloseKey(hKey);
}
			   