; r4.asm, r4.api.asm
; (c) r!sc june 2000 ...


;icd_crc         dd  ?   ; place to store final CRC
;code_base       dd  ?   ; the address of icd's code section
;crc_offset      dd  ?   ;
;reloc_pointer   dd  ?   ; address of reloc section
;code_ends       dd  ?   ;)
;last_reloc_rva  dd  ?   ; store the last reloc rva (if more than 1 code section, or
                         ;  there are missing 4kb pages (4kb pages containing no reloc info))
;crc_section_rva dd  ?   ; store this sections rva .. 
;section_flags   dd  ?   ; store this sections chacteristics

;cc_temp_buffer  dd 1000h dup (?)

;cc_counter      dd  ?
;cc_something    dd  ?

;raw_key         dd  ?,?,?,?   ; raw key data from safedisc loader
;icd_entrypoint  dd  ?

.code

r4_main:
    call    load_dll

; dplayerx is loaded and decrypted, can now begin work on the key

    call calc_crc_and_or_decrypt_r4b
    call play_my_api_game

    mov eax, [decrypt_key]      ; key1==rawkey1^x^crc+(entrypoint+2d8h)
    mov ebx, [icd_entrypoint]
    add ebx, 2d8h
    sub eax, ebx                ; x=key1-(entrypoint+2d8h)
    xor eax, [raw_key]          ; x^=x^rawkey1 ( calculate value x :)
    mov ecx, 2
    lea esi, decrypt_key+4
    lea edi, raw_key+4
make_128bit_key:
    mov edx, [edi+ecx*4]        ; key2..4=rawkey2..4^x^crc+(entrypoint+2d8h)
    xor edx, eax                ; xor keyx, x
    xor edx, [icd_crc]          ; xor keyx, crc
    add edx, ebx                ; add keyx, (entrypoint+2d8h)
    mov [esi+ecx*4], edx
    dec ecx
    jns make_128bit_key
    ;call    create_keyfile
    ;mov     eax, [icd_crc]
    ;mov     [decrypt_key], eax
    ;db 0ebh, 0feh
    ret

create_keyfile:
;    call    CreateFileA, offset key_file, 40000000h, 0, 0, 2, 80h, 0
;    call    WriteFile, eax, offset decrypt_key, 16, offset bytesrw, 0, eax
;    call    CloseHandle
;    ret

;________________________________________________________________________________________
;
; calculate icd crc, for use with computing the 128bit key
; also calls the decrypt proc for r4b .. 
; cc_simple: nice simple crc on 4kb pages
; cc_with_reloc: extremly complicated crc for icd's with reloc info
;________________________________________________________________________________________
calc_crc_and_or_decrypt_r4b:
    pushad
    mov     [icd_crc], 0            ; reset crc, incase algo has been ran already
    mov     [cc_something], 0       ; reset something :)
    mov     [cc_counter], 0         ; hehe
    mov     edi, [de_section_ptr] ; sections to be decrypted
    jmp     find_crypted_sections
    
find_crypted_sections_main:
    popad
find_crypted_sections:
    mov     esi, [edi]
    add     edi, 4
    or      esi, esi
    jne     crc_got_crypted_section
    popad
    ret

crc_got_crypted_section:
    mov     eax, dword ptr [esi+24h]
    mov     [section_flags], eax
    pushad

    mov     eax, [esi+10h]          ; code section raw size
    mov     edi, [esi+0ch]          ; code RVA ..
    mov     [crc_section_rva], edi
    cmp     eax, [esi+8]            ; cmp with vsize, i need the smaller of the two
    jbe     cc_size_ok
    cmp     dword ptr [esi+8], 0
    je      cc_size_ok
    mov     eax, [esi+8]            ; else, i use the vsize
cc_size_ok:
    mov     esi, [esi+14h]          ; get sections raw offset
    add     esi, [memory_ptr]       ; add base address to it ..
                                    ; so now, esi=raw offset to code, eax=size of code
    mov     [code_base], esi
    lea     esi, reloc_buffer       ; *unpacked* reloc info
    cmp     dword ptr [esi-4], 4    ; if this == 4, reloc info was present in this icd
    jz      cc_with_reloc           ; so, jump to the calc_crc_with_reloc routine

;________________________________________________________________________________________
cc_simple:                          ; cc_simple, calc crc on 1000h byte chunks of code
    mov     ecx, 1000h
    xor     edx, edx
    idiv    ecx                     ; code_size / 1000h, remainder in edx..
    xchg    eax, ecx                ; we use the result, as a counter
    mov     ebx, [code_base]
    test    ecx, ecx
    jz      less_than_1000h
cc_simple_loop:
    call    crc_maths               ; calc crc on 1000h bytes, pointed to by ebx
    add     ebx, eax                ; add 1000h to ebx
    dec     ecx                     ; decrease counter
    jnz     cc_simple_loop          ; loop until finished
less_than_1000h:
    test    edx, edx                ; check if remainder of code_size/1000h is 0
    jz      find_crypted_sections_main      ; if so, weve finished
    mov     eax, edx                ; else, use remainder for last pass
    call    crc_maths
    jmp     find_crypted_sections_main

;________________________________________________________________________________________

cc_reloc_finished:
    pop esi                         ; pop our saved pointer to next reloc info
    mov [cc_something], esi         ; save it, incase we have to crc another section
    jmp find_crypted_sections_main

;________________________________________________________________________________________
;
; big nasty crc_with_reloc routine
; probably not very optimised, but works (after 12 ish hours coding/debugging) 
;________________________________________________________________________________________
cc_with_reloc:
    add     eax, [code_base]        ; eax = code size + code address (my eof pointer)
    mov     [code_ends], eax
    xor     ebp,ebp
    mov     edx, [code_base]        ; sub rva of section off base address.. as reloc info has
    sub     edx, edi                ;  rva added to it anyway ..
    mov     esi, [cc_something]     ; get pointer to reloc info (is only a pointer after this
    test    esi, esi                ;                             routine has executed)
    jnz     used_reloc_before       ; jnz its a good pointer

    mov     esi, [reloc_pointer]    ; else, start with the very first reloc info ..
    mov     edi, [crc_section_rva]  ; and use sections RVA - 1000h as the last reloc pointer..
    jmp     crc_late_entry          ;  (bug fix if reloc info is above 1000h ..)

used_reloc_before:
    mov     edi, [esi]
crc_late_entry:
    sub     edi, 1000h
    mov     [last_reloc_rva], edi
    push    esi

cc_get_4kb_reloc_info:
    pop     esi                     ; pop pointer to reloc info off the stack (pushed later on..)
    mov     edi, [esi]              ; relative virtual address of this array reloc info
    mov     ecx, [esi+04]           ; size, of this array of reloc info
    push    esi                     ; save pointer to reloc info
    add     [esp], ecx              ; add size of current block to pointer
    test    edi, edi
    je      cc_reloc_finished

crc_revover_from_4kb_no_reloc_info:
    add     [last_reloc_rva], 1000h ; dodgy shit
    cmp     [last_reloc_rva], edi   ; to check for missing 4kb page info in reloc
    jne     crc_4kb_no_reloc_info

    add     esi, 8                  ; point esi to reloc data
    sub     ecx, 8                  ; sub ecx, size_of_reloc_header_thing
    xor     ebx, ebx
    push    ebp                     ; boohoo, ebp is used for reloc info falling into next 4kb page
    mov     ebp, esi                ; going to copy reloc info into a buffer, as i mangle it
    lea     esi, cc_temp_buffer     ;  all and dont want to mangle the actual info in the file
copy_and_fix_reloc_info:
    mov     eax,[ebp+ebx]           ; read two words
    and     eax, 0fff0fffh          ; kill the high 4 bits of each word, only need the lower 12 bits
    mov     [esi+ebx], eax          ; save fixed data in reloc_buffer
    add     ebx, 4
    cmp     ebx, ecx
    jb      copy_and_fix_reloc_info ; loop until block is finished
    pop     ebp

    shr     ecx, 1                  ; div size counter, 2 
                                    ; need size of the data in words, for the next piece of code
;________________________________________________________________________________________
;
; this code is executed once per 4kb page, right at the beginning..
; if ebp is non zero, it means that previous reloc info ran into this 4kb page..
;________________________________________________________________________________________
cc_process_reloc_data:
    movzx   eax, word ptr [esi]     ; get reloc word
    test    eax,eax                 ; if its 0, means first dword of this page relocates
    jz      cc_lil_loop             ; so we skip it
    sub     eax, ebp                ; else, fix byte count if last page ran into this one
    mov     ebx, edi                ; move current 4kb page's RVA into ebx
    add     ebx, ebp                ; add the current offset to non-relocating data
    add     ebx, edx                ; add the base address of the code in memory
    call    crc_maths_reloc         ; crc eax bytes, at ebx..
    movzx   eax, word ptr [esi]     ; get last reloc info into eax.. its the starting point for
                                    ;  the main loop


;________________________________________________________________________________________
;
; main crc loop, compares next reloc word, with current word + 4, basically scans for
;  next chunk of non-relocatable data
;________________________________________________________________________________________
cc_lil_loop:
    add     eax, 4                  ; current word+=4
    add     esi, 2                  ; point to next reloc word
    dec     ecx                     ; dec word counter
    jz      crc_last_few_bytes      ; jz crc last few bytes :)
    cmp     word ptr [esi], 0       ; just a dodgy check for a null terminator..
    jz      cc_end_of_4kb_page      ; if we find this, we have to fix esi, b4 crc_last_few_bytes
    cmp     ax, [esi]               ; cmp (current word + 4), next reloc word
    jz      cc_lil_loop             ; jz lil loop
    mov     ebp, eax                ; hey! now ebp points to non-relocatable data we need to crc
    mov     ax, [esi]               ; and ax points to the next relocatable data
    sub     eax, ebp                ; so ax-ebp = offset, or the bytes to crc
    mov     ebx, edi                ; move current 4kb page's RVA into ebx
    add     ebx, ebp                ; add the current offset to non-relocating data
    add     ebx, edx                ; add the base address of the code in memory
    call    crc_maths_reloc
    add     eax, ebp                ; fix eax so it points to the next relocatable data (again!)
    jmp     cc_lil_loop



;________________________________________________________________________________________
;
; cc_end_of_4kb_page, calculates if last reloc word covers a dword going into the next 4kb
;  page, if not, it calculates the bytes to the end of the 4kb page, and crc's them
;________________________________________________________________________________________
cc_end_of_4kb_page:
    add     esi, 2                  ; fix null terminator (or some extra padding?)
crc_last_few_bytes:
    cmp     eax, 1000h              ; if eax > 1000h, need to fix ebp, so we dont crc the
    ja      cc_fix_ebp              ;  first few bytes of next 4kb page
    mov     ebx, 1000h              ; else
    sub     ebx, eax                ; calc remaining bytes to end of current 4kb page
    xchg    ebx, eax                ;
    xor     ebp, ebp                ; reset ebp 2 zero, so we do crc all the info at the beginning of next page
    add     ebx, edi                ; calc addr of memory to crc
    add     ebx, edx
    call    crc_maths_reloc         ; crc the last few bytes
    jmp     cc_get_4kb_reloc_info   ; and begin loop again!
cc_fix_ebp:
    and     eax, 0fffh
    mov     ebp, eax
    jmp     cc_get_4kb_reloc_info


;________________________________________________________________________________________
;
; this is the mega lame error handler, well, handles errors with reloc info missing
; if reloc info is missing for a 4kb page, this will calc the crc for the missing 4kb
;________________________________________________________________________________________
crc_4kb_no_reloc_info:
    pushad
    add     edi, edx
    cmp     edi, [code_ends]    ; checkif its the end of the section
    ja      cc_fuckyou
    mov     ebx, [last_reloc_rva]
    add     ebx, edx            ; add imagebase..
    mov     eax, 1000h          ; crc 4kb
    call    crc_maths           ; do it
    popad
    jmp     crc_revover_from_4kb_no_reloc_info


cc_fuckyou:                     ; or calc the crc for the last bytes of the section :)
    mov     ebx, [last_reloc_rva]
    add     ebx, edx
    mov     eax, [code_ends]
    sub     eax, ebx

; bug fix, as on animation master the last few bytes were c02ch bytes
; next reloc pointer pointed past the end of the code section,
;  but last d000h bytes didnt have reloc info. almost freaky..
    mov     ecx, 1000h
    xor     edx, edx
    idiv    ecx                     ; code_size / 1000h, remainder in edx..
    xchg    eax, ecx                ; we use the result, as a counter
    test    ecx, ecx
    jz      cc_fuck_you_last_few_bytes
cc_fuck_u_simple_loop:
    call    crc_maths               ; calc crc on 1000h bytes, pointed to by ebx
    add     ebx, eax                ; add 1000h to ebx
    dec     ecx                     ; decrease counter
    jnz     cc_fuck_u_simple_loop   ; loop until finished
cc_fuck_you_last_few_bytes:
    test    edx, edx                ; check if remainder of code_size/1000h is 0
    jz      fuck_u_end              ; if so, weve finished
    mov     eax, edx                ; else, use remainder for last pass
    call    crc_maths
fuck_u_end:
    popad
    jmp     cc_reloc_finished


;________________________________________________________________________________________
;
; only called once, to calculate the amount of bytes to crc for the final pass
;________________________________________________________________________________________
cc_reloc_crc_last_bytes:
    sub     ebx, eax
    mov     eax, [code_ends]
    sub     eax, ebx
    mov     dword ptr [esp], offset cc_reloc_finished ; put address of cc_finished onto the stack
    jmp     crc_maths                           ;  so crc_maths exits to the correct place


;________________________________________________________________________________________
;
; for crc with reloc, an extra bit of code to check i dont crc past the end of the code
;________________________________________________________________________________________
crc_maths_reloc:
    add     ebx, eax                ; add bytes to crc to address
    cmp     ebx, [code_ends]        ; check its not above the end of the code
    ja      cc_reloc_crc_last_bytes
    sub     ebx, eax


;________________________________________________________________________________________
;
; eax, amount of bytes to crc
; ebx, base of code to crc
; will either crc 1000h blocks of code, or different size blocks inbetween relocatable code
;________________________________________________________________________________________
crc_maths:
    test    dword ptr [section_flags], 20h      ; is it a code section?
    jz      do_r4b_check                        ; nope, skip crc, and do r4b check..
    
    pushad
    test    eax, eax                ; make sure we dont try to crc 0 bytes 
    jle     exit_crc_maths
    mov     ebp, 0FD379AB1h         ; ebp used as crc_magic_value
    mov     esi, [icd_crc]          ; get old crc into esi
crc_loop:
    movzx   edx, byte ptr [ebx]     ; byte to crc into dl
    inc     ebx                     ; point ebx to next byte to crc
    imul    edx, ebp                ; calc crc for this byte
    add     esi, edx                ; add crc'ed byte to main crc
    imul    ebp, 0A7753394h         ; morph the magic value
    dec     eax                     ; decrease byte counter
    lea     ebp, [ebp+eax+3BC62BB2h] ; morph the magic value some more
    jne     crc_loop                ; loop if counter not zero 

    mov     [icd_crc], esi          ; save new crc
exit_crc_maths:
    popad
    call    do_r4b_check
    ret
;________________________________________________________________________________________

do_r4b_check:
    cmp [dll_size], 138752
    jz  r4b_decrypt_chunk
exit_do_r4b_check:
    ret
r4b_decrypt_chunk:
    ;test    eax, eax                ; make sure we dont try to decrypt 0 bytes 
    ;jle     exit_do_r4b_check
    call r4b_raxs_decrypt_main
    ret
    