'
'   File:   eq.bas
'   Creation Date:  Thu 15-Jul-2004 15:36:22        Jonathan D. Kirwan
'   Last Modified:  Sun 18-Jul-2004 02:30:29        Initial version.
'
'   Copyright (C) 2004 Jonathan Dale Kirwan, All Rights Reserved
'
'
'   DESCRIPTION
'
'   This is a modularized program for demonstrating parsing of mathematical
'   expressions.  This version handles algebraic equations of the form:
'
'       unary := SIN | COS | TAN | SEC | CSC | CTN | ATAN | ASIN | ACOS |
'                   ASEC | ACSC | ACTN | ABS | SGN | INT | SQRT | LOG | EXP
'       moreitems := ^ item moreitems | <null>
'       item := name | number | ( expression ) | unary ( expression )
'       morefactors := * factor morefactors | / factor morefactors | <null>
'       factor := item moreitems
'       moreterms := + term moreterms | - term moreterms | <null>
'       term := factor morefactors
'       expression := sign term moreterms
'       statement := expression | name = expression
'       moreexpr := ; expression moreexpr | <null>
'       list := expression moreexpr
'
'   Where a number is:
'
'       digit := 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9
'       digits := digit digits | <null>
'       mantissa := . digit digits | digit . digits | digit digits
'       scaleid := e | E
'       scale := scaleid sign digit digits | <null>
'       sign := + | - | <null>
'       number := sign mantissa scale
'
'   And where a variable name or function name is:
'
'       alpha := A | B | C | D | E | F | G | H | I | J | K | L | M |
'                N | O | P | Q | R | S | T | U | V | W | X | Y | Z |
'                a | b | c | d | e | f | g | h | i | j | k | l | m |
'                n | o | p | q | r | s | t | u | v | w | x | y | z
'       alphanumeric := alpha | digit
'       alphanumerics := alphanumeric alphanumerics | <null>
'       name := alpha alphanumerics
'
'   It also calculates the resulting value and displays it, as well as
'   handling some standard unary functions. It also supports two special
'   values, PI and E, for use in calculating values and allows statements
'   to define new variable values.  Statements can be repeated, if
'   separated by semi-colons, as well.
'
'   See,
'
'       http://users.easystreet.com/jkirwan/new/parsing.html
'
'   for more detailed information on the design.
'
'
'   MODIFICATIONS
'
'   No modifications.
'
'
'   COPYRIGHT NOTICE
'
'   Jonathan Dale Kirwan grants you a non-transferable, non-exclusive,
'   royalty-free worldwide license to use, copy, modify, prepare deriva-
'   tive works of and distribute this software, subject to your agreement
'   that you acquire no ownership right, title, or interest in this soft-
'   ware and your agreement that this software is research work which is
'   provided 'as is', where Jonathan Dale Kirwan disclaims all warranties
'   with regard to this software, including all implied warranties of
'   merchantability and fitness of purpose.  In no event shall Jonathan
'   Dale Kirwan be liable for any direct, indirect, consequential or
'   special damages or any damages whatsoever resulting from loss of use,
'   data or profits, whether in an action of contract, negligence or
'   other tortious action, arising out of or in connection with the use
'   or performance of this software.

CONST TITLE$ = "EQ"
CONST VERSION% = 10

'$INCLUDE: 'VARIABLE.BI'
'$INCLUDE: 'PARSE.BI'

        CLS

        COLOR 13
        PRINT " "; STRING$(78, "")
        PRINT SPACE$(41 - LEN(TITLE) \ 2); TITLE;
        LOCATE , 71 + (VERSION > 9)
        PRINT "Version"; VERSION
        PRINT " "; STRING$(78, "")
        COLOR 7

        PRINT
        PRINT "This program accepts mathematical expressions in algebraic notation and then"
        PRINT "calculates the values and prints them.  Separate expressions can be entered"
        PRINT "on a single line by using the semi-colon between them.  A number of built-in"
        PRINT "functions are supported (enter ? to get a list.)  The special values PI and E"
        PRINT "are available and you can enter assignment statements to your own variables,"
        PRINT "as well.  This program is intended as a parsing demonstration program."
        PRINT

        InitValues
        SetValue "PI", 4# * ATN(1#)
        SetValue "E", EXP(1#)

    DIM eq AS STRING, eqpos AS INTEGER, status AS INTEGER, stk AS STRING

        INPUT "Enter the statement list: ", eq
        DO WHILE RTRIM$(eq) <> ""
            IF LTRIM$(RTRIM$(eq)) = "?" THEN
                PRINT
                PRINT "  Built-in Variables:"
                PRINT "    PI, E, ANS"
                PRINT
                PRINT "  Built-in Functions:"
                PRINT "    SIN, COS, TAN, SEC, CSC, CTN,"
                PRINT "    ASIN, ACOS, ATAN, ASEC, ACSC, ACTN,"
                PRINT "    SINH, COSH, TANH, SECH, CSCH, COTH,"
                PRINT "    DEG, RAD, EXP, LOG, LN, LOG10, LOG2,"
                PRINT "    SQRT, SQR, ABS, SGN, INT, RND"
                PRINT
                PRINT "  Some Examples:"
                PRINT "    a= SIN(PI/3); b= SIN(PI/4); DEG(ASN(a+b))"
                PRINT "    -(4+13)*8; ANS*2"
                PRINT "    e^2+e^-2"
                PRINT
            ELSE
              LET eqpos = 1
              SList eqpos, eq, stk
            END IF
            INPUT "Enter the statement list: ", eq
        LOOP
        END
