'
'   File:   hash.bas
'   Creation Date:  Sun 18-Jul-2004 01:57:31        Jonathan D. Kirwan
'   Last Modified:  Sun 18-Jul-2004 02:03:42        Initial version.
'
'   Copyright (C) 2004 Jonathan Dale Kirwan, All Rights Reserved
'
'
'   DESCRIPTION
'
'   This module provides a hashing function for strings.
'
'
'   MODIFICATIONS
'
'   No modifications.
'
'
'   COPYRIGHT NOTICE
'
'   Jonathan Dale Kirwan grants you a non-transferable, non-exclusive,
'   royalty-free worldwide license to use, copy, modify, prepare deriva-
'   tive works of and distribute this software, subject to your agreement
'   that you acquire no ownership right, title, or interest in this soft-
'   ware and your agreement that this software is research work which is
'   provided 'as is', where Jonathan Dale Kirwan disclaims all warranties
'   with regard to this software, including all implied warranties of
'   merchantability and fitness of purpose.  In no event shall Jonathan
'   Dale Kirwan be liable for any direct, indirect, consequential or
'   special damages or any damages whatsoever resulting from loss of use,
'   data or profits, whether in an action of contract, negligence or
'   other tortious action, arising out of or in connection with the use
'   or performance of this software.

'$INCLUDE: 'HASH.BI'

        END

DATA 2078917053,  143302914, 1027100827, 1953210302,  755253631, 2002600785
DATA 1405390230,   45248011, 1099951567,  433832350, 2018585307,  438263339
DATA  813528929, 1703199216,  618906479,  573714703,  766270699,  275680090
DATA 1510320440, 1583583926, 1723401032, 1965443329, 1098183682, 1636505764
DATA  980071615, 1011597961,  643279273, 1315461275,  157584038, 1069844923
DATA  471560540,   89017443, 1213147837, 1498661368, 2042227746, 1968401469
DATA 1353778505, 1300134328, 2013649480,  306246424, 1733966678, 1884751139
DATA  744509763,  400011959, 1440466707, 1363416242,  973726663,   59253759
DATA 1639096332,  336563455, 1642837685, 1215013716,  154523136,  593537720
DATA  704035832, 1134594751, 1605135681, 1347315106,  302572379, 1762719719
DATA  269676381,  774132919, 1851737163, 1482824219,  125310639, 1746481261
DATA 1303742040, 1479089144,  899131941, 1169907872, 1785335569,  485614972
DATA  907175364,  382361684,  885626931,  200158423, 1745777927, 1859353594
DATA  259412182, 1237390611,   48433401, 1902249868,  304920680,  202956538
DATA  348303940, 1008956512, 1337551289, 1953439621,  208787970, 1640123668
DATA 1568675693,  478464352,  266772940, 1272929208, 1961288571,  392083579
DATA  871926821, 1117546963, 1871172724, 1771058762,  139971187, 1509024645
DATA  109190086, 1047146551, 1891386329,  994817018, 1247304975, 1489680608
DATA  706686964, 1506717157,  579587572,  755120366, 1261483377,  884508252
DATA  958076904, 1609787317, 1893464764,  148144545, 1415743291, 2102252735
DATA 1788268214,  836935336,  433233439, 2055041154, 2109864544,  247038362
DATA  299641085,  834307717, 1364585325,   23330161,  457882831, 1504556512
DATA 1532354806,  567072918,  404219416, 1276257488, 1561889936, 1651524391
DATA  618454448,  121093252, 1010757900, 1198042020,  876213618,  124757630
DATA 2082550272, 1834290522, 1734544947, 1828531389, 1982435068, 1002804590
DATA 1783300476, 1623219634, 1839739926,   69050267, 1530777140, 1802120822
DATA  316088629, 1830418225,  488944891, 1680673954, 1853748387,  946827723
DATA 1037746818, 1238619545, 1513900641, 1441966234,  367393385,  928306929
DATA  946006977,  985847834, 1049400181, 1956764878,   36406206, 1925613800
DATA 2081522508, 2118956479, 1612420674, 1668583807, 1800004220, 1447372094
DATA  523904750, 1435821048,  923108080,  216161028, 1504871315,  306401572
DATA 2018281851, 1820959944, 2136819798,  359743094, 1354150250, 1843084537
DATA 1306570817,  244413420,  934220434,  672987810, 1686379655, 1301613820
DATA 1601294739,  484902984,  139978006,  503211273,  294184214,  176384212
DATA  281341425,  228223074,  147857043, 1893762099, 1896806882, 1947861263
DATA 1193650546,  273227984, 1236198663, 2116758626,  489389012,  593586330
DATA  275676551,  360187215,  267062626,  265012701,  719930310, 1621212876
DATA 2108097238, 2026501127, 1865626297,  894834024,  552005290, 1404522304
DATA   48964196,    5816381, 1889425288,  188942202,  509027654,   36125855
DATA  365326415,  790369079,  264348929,  513183458,  536647531,   13672163
DATA  313561074, 1730298077,  286900147, 1549759737, 1699573055,  776289160
DATA 2143346068, 1975249606, 1136476375,  262925046,   92778659, 1856406685
DATA 1884137923,   53392249, 1735424165, 1602280572,          0

FUNCTION Hash& (msg AS STRING)

        LET Hash = ReHash(0&, msg)

END FUNCTION

FUNCTION ReHash& (priorhash AS LONG, msg AS STRING)

    STATIC IsLoaded AS INTEGER
    STATIC scatter() AS LONG

    DIM i AS INTEGER

        IF NOT IsLoaded THEN
            RESTORE
            DIM scatter(0 TO 255) AS LONG
            FOR i = 0 TO 255
                READ scatter(i)
            NEXT i
            LET IsLoaded = -1
        END IF

    DIM s AS LONG, current AS LONG

        LET current = priorhash
        FOR i = 1 TO LEN(msg)
            SELECT CASE (current AND &HC0000000)
            CASE &H0&
                LET current = current * 2
            CASE &H40000000
                LET current = (current OR &H80000000) * 2
            CASE &H80000000
                LET current = (current AND &H7FFFFFFF) * 2
            CASE &HC0000000
                LET current = current * 2
            END SELECT
            LET s = scatter(ASC(MID$(msg, i, 1)))
            IF current < 0& THEN
                LET current = current + s
            ELSEIF current > &H7FFFFFFF - s THEN
                LET current = (&H7FFFFFFF - current) + (&H7FFFFFFF - s) + 2
            ELSE
                LET current = current + s
            END IF
        NEXT i

        LET ReHash = current

END FUNCTION
