'
'   File:   eq_02.bas
'   Creation Date:  Thu 15-Jul-2004 15:36:22        Jonathan D. Kirwan
'   Last Modified:  Thu 15-Jul-2004 23:43:05        Initial version.
'
'   Copyright (C) 2004 Jonathan Dale Kirwan, All Rights Reserved
'
'
'   DESCRIPTION
'
'   This is a program demonstrating parsing of mathematical expressions.
'   This version only handles algebraic equations of the form:
'
'       moreterms := + term moreterms | - term moreterms | <null>
'       term := number | ( expression )
'       expression := term moreterms
'
'   Where a number is:
'
'       digit := 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9
'       digits := digit digits | <null>
'       mantissa := . digit digits | digit . digits | digit digits
'       scaleid := e | E
'       scale := scaleid sign digit digits | <null>
'       sign := + | - | <null>
'       number := sign mantissa scale
'
'   See,
'
'       http://users.easystreet.com/jkirwan/new/parsing.html
'
'   for more detailed information on the design.
'
'
'   MODIFICATIONS
'
'   No modifications.
'
'
'   COPYRIGHT NOTICE
'
'   Jonathan Dale Kirwan grants you a non-transferable, non-exclusive,
'   royalty-free worldwide license to use, copy, modify, prepare deriva-
'   tive works of and distribute this software, subject to your agreement
'   that you acquire no ownership right, title, or interest in this soft-
'   ware and your agreement that this software is research work which is
'   provided 'as is', where Jonathan Dale Kirwan disclaims all warranties
'   with regard to this software, including all implied warranties of
'   merchantability and fitness of purpose.  In no event shall Jonathan
'   Dale Kirwan be liable for any direct, indirect, consequential or
'   special damages or any damages whatsoever resulting from loss of use,
'   data or profits, whether in an action of contract, negligence or
'   other tortious action, arising out of or in connection with the use
'   or performance of this software.

DECLARE FUNCTION Term% (eqpos AS INTEGER, eq AS STRING)
DECLARE FUNCTION MoreTerms% (eqpos AS INTEGER, eq AS STRING)
DECLARE FUNCTION Expression% (eqpos AS INTEGER, eq AS STRING)
DECLARE FUNCTION ScaleID% (eqpos AS INTEGER, eq AS STRING)
DECLARE SUB SkipSpaces (eqpos AS INTEGER, eq AS STRING)
DECLARE FUNCTION Match% (charlist AS STRING, eqpos AS INTEGER, eq AS STRING)
DECLARE FUNCTION Digit% (eqpos AS INTEGER, eq AS STRING)
DECLARE SUB Sign (eqpos AS INTEGER, eq AS STRING)
DECLARE SUB Digits (eqpos AS INTEGER, eq AS STRING)
DECLARE SUB Scale (eqpos AS INTEGER, eq AS STRING)
DECLARE FUNCTION Mantissa% (eqpos AS INTEGER, eq AS STRING)
DECLARE FUNCTION Number% (eqpos AS INTEGER, eq AS STRING)

    DIM eq AS STRING, eqpos AS INTEGER, status AS INTEGER

        CLS
        INPUT "Enter the equation: ", eq
        DO WHILE RTRIM$(eq) <> ""
            LET eqpos = 1
            LET status = Expression(eqpos, eq)
            IF LEN(LTRIM$(eq)) + eqpos = LEN(eq) + 1 THEN
                PRINT "  The entire equation fails!"
            ELSEIF status AND eqpos > LEN(eq) THEN
                PRINT "  The entire equation succeeds!"
            ELSE
                PRINT "  "; eq
                PRINT TAB(eqpos + 2); "^-- error from this point."
            END IF
            PRINT
            INPUT "Enter the equation: ", eq
        LOOP
        END

FUNCTION Digit% (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER

        LET status = Match("0123456789", eqpos, eq)

    LET Digit = status

END FUNCTION

SUB Digits (eqpos AS INTEGER, eq AS STRING)

        DO WHILE Digit(eqpos, eq)
        LOOP

END SUB

FUNCTION Expression% (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER

        LET status = Term(eqpos, eq)
        IF status THEN
            LET status = MoreTerms(eqpos, eq)
        END IF

    LET Expression = status

END FUNCTION

FUNCTION Mantissa% (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER

        IF Match(".", eqpos, eq) THEN
            LET status = Digit(eqpos, eq)
            IF status THEN
                Digits eqpos, eq
            END IF
        ELSEIF Digit(eqpos, eq) THEN
            Digits eqpos, eq
            LET status = -1 OR Match(".", eqpos, eq)
            Digits eqpos, eq
        ELSE
            LET status = 0
        END IF

    LET Mantissa = status

END FUNCTION

FUNCTION Match% (charlist AS STRING, eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER

        IF eqpos <= LEN(eq) THEN
            IF INSTR(charlist, MID$(eq, eqpos, 1)) <> 0 THEN
                LET eqpos = eqpos + 1
                LET status = -1
            END IF
        ELSE
            LET status = 0
        END IF

    LET Match = status

END FUNCTION

FUNCTION MoreTerms% (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER

        SkipSpaces eqpos, eq
        IF Match("+-", eqpos, eq) THEN
            LET status = Term(eqpos, eq)
            IF status THEN
                LET status = MoreTerms(eqpos, eq)
            END IF
        ELSE
            LET status = -1
        END IF

    LET MoreTerms = status

END FUNCTION

FUNCTION Number% (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER, dummy AS INTEGER

        Sign eqpos, eq
        LET status = Mantissa(eqpos, eq)
        IF status THEN
            Scale eqpos, eq
        END IF

    LET Number = status

END FUNCTION

SUB Scale (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER, savepos AS INTEGER

        LET savepos = eqpos
        IF ScaleID(eqpos, eq) THEN
            Sign eqpos, eq
            LET status = Digit(eqpos, eq)
            IF status THEN
                Digits eqpos, eq
            ELSE
                LET eqpos = savepos
            END IF
        END IF

END SUB

FUNCTION ScaleID% (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER

        LET status = Match("eE", eqpos, eq)

    LET ScaleID = status

END FUNCTION

SUB Sign (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER

        LET status = Match("+-", eqpos, eq)

END SUB

SUB SkipSpaces (eqpos AS INTEGER, eq AS STRING)

        DO WHILE eqpos <= LEN(eq)
            IF MID$(eq, eqpos, 1) <> " " THEN
                EXIT DO
            END IF
            LET eqpos = eqpos + 1
        LOOP

END SUB

FUNCTION Term% (eqpos AS INTEGER, eq AS STRING)

    DIM status AS INTEGER

        SkipSpaces eqpos, eq
        IF Match("(", eqpos, eq) THEN
            LET status = Expression(eqpos, eq)
            IF status THEN
                SkipSpaces eqpos, eq
                LET status = Match(")", eqpos, eq)
            END IF
        ELSE
            LET status = Number(eqpos, eq)
        END IF

    LET Term = status

END FUNCTION
