/*
    File:   assert.h
    Author: Jonathan Dale Kirwan
 
    Creation Date:  Fri 08-Apr-2005 02:45:35
    Last Modified:  Sun 15-Jan-2006 23:15:37

    Copyright 2005, 2006, Jonathan Dale Kirwan, All Rights Reserved.

    URL:    http://users.easystreet.com/jkirwan/new/c_expr.html
    email:  jkirwan@easystreet.com


    DESCRIPTION

    The assert handling here replaces the standard assert.h usually found in
    the compiler's include file directory.  It relies upon the exception
    handler and raises an exception which can be handled, if desired.  The
    assert is 'assertfailed' and can be used with an EXCEPT( assertfailed )
    clause in a TRY..ENDTRY block.  Therefore, 'assertfailed' is reserved.


    TARGET COMPILER

    Microsoft 16-bit Visual C/C++, IDE version 1.52C (DOS version 8.00c)
 
 
    MODIFICATIONS
 
    Original source.
*/

#ifndef ASSERT_H
#define ASSERT_H

#undef assert

#define E   assertfailed

#ifdef NDEBUG
#define assert(e)       ( (void) 0 )
#else
#define assert(c)       ( (void) ( (c) || (RAISE( E ), 0) ) )
#include "except.h"
extern const except_t E;
#endif

#define errorif(c,e)    ( (void) ( !(c) || (RAISE( (e) ), 0) ) )

#undef E

#endif
