/*
    File:   clipbrd.c
    Author: Jonathan Dale Kirwan

    Creation Date:  Fri 30-Dec-2005 14:34:49
    Last Modified:  Mon 16-Jan-2006 00:51:54

    Copyright 2005, 2006, Jonathan Dale Kirwan, All Rights Reserved.

    URL:    http://users.easystreet.com/jkirwan/new/c_expr.html
    email:  jkirwan@easystreet.com


    DESCRIPTION

    This module provides access to the Windows clipboard.


    TARGET COMPILER

    Microsoft 16-bit Visual C/C++, IDE version 1.52C (DOS version 8.00c)


    COPYRIGHT NOTICE

    You are granted a non-transferable, non-exclusive, royalty-free worldwide
    license to use, copy, modify, prepare derivative works of and distribute
    this software, subject to your agreement that you acquire no ownership
    right, title, or interest in this software and your agreement that this
    software is research work that is provided 'as is.'

    Jonathan Dale Kirwan disclaims all warranties with regard to this source
    code software, including any and all implied warranties of merchantability
    and fitness of purpose.  In no event shall Jonathan Dale Kirwan be liable
    for any direct, indirect, consequential or special damages or any damages
    whatsoever resulting from loss of use, loss of data or profits, whether in
    an action of contract, negligence or other tortious action, arising out of
    or in connection with the use or performance of this software.

 
    MODIFICATIONS

    None
*/

#include "clipbrd.h"

#pragma warning( disable:4704 )


/*  ----------------------------------------------------------------------  */
int clpVerify( void ) {
/*  ----------------------------------------------------------------------
    This routine validates the presence of WinOldAp.  WinOldAp supports
    access to the clipboard from DOS.  It returns 1 if WinOldAp is present,
    otherwise 0.
*/
    auto unsigned char minor, major;
    auto unsigned int result;

        __asm {
            mov ax, 1700h
            int 2Fh
            mov major, al
            mov minor, ah
            mov result, ax
        }

    return result != 0x1700;
}


/*  ----------------------------------------------------------------------  */
int clpOpen( void ) {
/*  ----------------------------------------------------------------------
    This routine opens the clipboard via WinOldAp.  If successful, it
    returns 1.  If not, 0.
*/

    auto unsigned int result;

        __asm {
            mov ax, 1700h
            int 2Fh
            mov result, ax
        }
        if ( result == 0x1700 )
            return 0;

        __asm {
            mov ax, 1701h
            int 2Fh
            mov result, ax
        }

    return result != 0;
}


/*  ----------------------------------------------------------------------  */
int clpClose( void ) {
/*  ----------------------------------------------------------------------
    This routine closes the clipboard via WinOldAp.  If successful, it
    returns 1.  If not, 0.
*/
    auto unsigned int result;

        __asm {
            mov ax, 1700h
            int 2Fh
            mov result, ax
        }
        if ( result == 0x1700 )
            return 0;

        __asm {
            mov ax, 1708h
            int 2Fh
            mov result, ax
        }

    return result != 0;
}


/*  ----------------------------------------------------------------------  */
int clpEmpty( void ) {
/*  ----------------------------------------------------------------------
    This routine empties the clipboard via WinOldAp.  If successful, it
    returns 1.  If not, 0.
*/
    auto unsigned int result;

        __asm {
            mov ax, 1700h
            int 2Fh
            mov result, ax
        }
        if ( result == 0x1700 )
            return 0;

        __asm {
            mov ax, 1702h
            int 2Fh
            mov result, ax
        }

    return result != 0;
}


/*  ----------------------------------------------------------------------  */
int clpCopyText( char *txt, unsigned int len ) {
/*  ----------------------------------------------------------------------
    This routine places the given text onto the Windows clipboard via
    WinOldAp and returns 1, if successful.  If not, it returns 0.
*/
    auto unsigned int result;
    auto char __far * ptxt;

        __asm {
            mov ax, 1700h
            int 2Fh
            mov result, ax
        }
        if ( result == 0x1700 )
            return 0;

        ptxt= (char __far *) txt;
        __asm {
            mov ax, 1703h
            mov dx, 1
            les bx, ptxt
            push si
            xor si, si
            mov cx, len
            int 2Fh
            pop si
            mov result, ax
        }

    return result != 0;
}
