'
'   File:   table.bas
'   Creation Date:  Sun 18-Jul-2004 02:01:34        Jonathan D. Kirwan
'   Last Modified:  Sun 18-Jul-2004 02:31:53        Initial version.
'
'   Copyright (C) 2004 Jonathan Dale Kirwan, All Rights Reserved
'
'
'   DESCRIPTION
'
'   This module provides support for storing and searching for strings.
'
'
'   MODIFICATIONS
'
'   No modifications.
'
'
'   COPYRIGHT NOTICE
'
'   Jonathan Dale Kirwan grants you a non-transferable, non-exclusive,
'   royalty-free worldwide license to use, copy, modify, prepare deriva-
'   tive works of and distribute this software, subject to your agreement
'   that you acquire no ownership right, title, or interest in this soft-
'   ware and your agreement that this software is research work which is
'   provided 'as is', where Jonathan Dale Kirwan disclaims all warranties
'   with regard to this software, including all implied warranties of
'   merchantability and fitness of purpose.  In no event shall Jonathan
'   Dale Kirwan be liable for any direct, indirect, consequential or
'   special damages or any damages whatsoever resulting from loss of use,
'   data or profits, whether in an action of contract, negligence or
'   other tortious action, arising out of or in connection with the use
'   or performance of this software.

'$INCLUDE: 'HASH.BI'
'$INCLUDE: 'TABLE.BI'

        END

FUNCTION AddEntry% (vname AS STRING, hashtable() AS SYMBOLENTRY)

    DIM hashcode AS LONG, idx AS INTEGER, pidx AS INTEGER, hlimit AS INTEGER

        LET hashcode = ReHash(0&, vname)
        LET hlimit = CINT(hashtable(0).hashcode)
        LET idx = hashcode MOD hlimit
        IF idx < 0 THEN
            LET idx = idx + hlimit
        END IF
        LET idx = idx + 1

        IF hashtable(idx).nextptr >= 0 THEN
            DO
                IF hashtable(idx).hashcode = hashcode THEN
                    LET AddEntry = idx
                    EXIT FUNCTION
                END IF
                LET pidx = idx
                LET idx = hashtable(idx).nextptr
            LOOP WHILE idx > 0
            IF hashtable(0).nextptr <= UBOUND(hashtable) THEN
                LET idx = hashtable(0).nextptr
                LET hashtable(0).nextptr = idx + 1
                LET hashtable(pidx).nextptr = idx
            ELSE
                LET AddEntry = 0
                EXIT FUNCTION
            END IF
        END IF

        LET hashtable(idx).hashcode = hashcode
        LET hashtable(idx).nextptr = 0

    LET AddEntry = idx

END FUNCTION

FUNCTION FindEntry% (vname AS STRING, hashtable() AS SYMBOLENTRY)

    DIM hashcode AS LONG, idx AS INTEGER, hlimit AS INTEGER

        LET hashcode = ReHash(0&, vname)
        LET hlimit = CINT(hashtable(0).hashcode)
        LET idx = hashcode MOD hlimit
        IF idx < 0 THEN
            LET idx = idx + hlimit
        END IF
        LET idx = idx + 1

        IF hashtable(idx).nextptr >= 0 THEN
            DO
                IF hashtable(idx).hashcode = hashcode THEN
                    EXIT DO
                END IF
                LET idx = hashtable(idx).nextptr
            LOOP WHILE idx > 0
        ELSE
            LET idx = 0
        END IF

    LET FindEntry = idx

END FUNCTION

SUB InitEntries (vlimit AS INTEGER, hlimit AS INTEGER, hashtable() AS SYMBOLENTRY)

    DIM i AS INTEGER

        IF hlimit <= vlimit THEN
            IF LBOUND(hashtable) <> 0 OR UBOUND(hashtable) <> vlimit THEN
                REDIM hashtable(0 TO vlimit) AS SYMBOLENTRY
            END IF
            LET hashtable(0).hashcode = CLNG(hlimit)    ' Size of the header.
            LET hashtable(0).nextptr = hlimit + 1       ' Next available entry.
            FOR i = 1 TO hlimit
                LET hashtable(i).nextptr = -1
            NEXT i
        END IF

END SUB
