Program LogDecrypt; { Saruman / DFR Research & Engineering }

TYPE
 TLogEntry  =Array[1..121] of Byte;

CONST
 FnOut   ='LOG.TXT';
 HardKey :TLogEntry=(37,122,207,36,121,206,35,120,205,34,119,204,33,118,203,
                     32,117,202,31,116,6,91,176,5,90,175,4,89,174,3, 88,173,
                     2,87,172,1,86,171,0,  85,170,255,84,169,254,83,168,253,
                     82,167,252,81,166,251,80,165,250,79,164,249,78,163,248,
                     77,162,247,76,161,246,75,160,245,74,159,244,73,158,243,
                     72,157,242,71,156,241,70,155,240,69,154,239,68,153,238,
                     67,152,237,66,151,236,65,150,235,64,149,234,63,148,233,
                     62,147,232,61,146,231,60,145,230,59,144,229,58);

VAR
 F,Fut          :File;
 Fn             :String;
 Log            :TLogEntry;
 i              :Word;

 Key            :^TLogEntry;
 SoftKey        :TLogEntry;

BEGIN
 Fn:='WNN3.LOG';

 Write('Decrypting "',Fn,'" ');
 Assign(F,'LOG.KEY');
 {$I-}
 Reset(F,1);
 {$I+}
 if IOResult=0 then
 begin
  BlockRead(F,SoftKey,SizeOf(TLogEntry),i);
  Close(F);
  key:=@SoftKey;
  WriteLn('using external key.');
 end else begin
  key:=@HardKey;
  WriteLn('using internal key.');
 end;

 Assign(F,Fn); Reset(F,1); Seek(F,$18);
 Assign(Fut,FnOut); ReWrite(Fut,1);

 REPEAT
  BlockRead(F,Log,SizeOf(TLogEntry));
  for i:=1 to SizeOf(Log) do Log[i]:=Log[i] XOR Key^[i];
  BlockWrite(Fut,Log,SizeOf(TLogEntry));
 UNTIL EoF(F);

 Close(F);
 Close(Fut);
 WriteLn('Wrote decrypted log to file "',FnOut,'"');
END.
