Program NNDec; { Saruman / DFR Research & Engineering }

Function HexL(const L: LongInt): String; Assembler;
asm
 les  di,@result
 mov  al,8
 stosb
 jmp  @process
@outALhex:
 mov  ah,al
 shr  al,4
 cmp  al,9
 jng  @first
 add  al,7
@first:
 and  ah,$0F
 cmp  ah,9
 jng  @second
 add  ah,7
@second:
 add  ax,$3030
 stosw
 retf
@process:
 mov  ax,word ptr L+2
 mov  bx,ax
 shr  ax,8
 call far [@outALhex]
 mov  ax,bx
 call far [@outALhex]
 mov  ax,word ptr L
 mov  bx,ax
 shr  ax,8
 call far [@outALhex]
 mov  ax,bx
 call far [@outALhex]
end;

Function HexW(const W: Word): String; Assembler;
asm
 les  di,@result
 mov  al,4
 stosb
 jmp  @process
@outALhex:
 mov  ah,al
 shr  al,4
 cmp  al,9
 jng  @first
 add  al,7
@first:
 and  ah,$0F
 cmp  ah,9
 jng  @second
 add  ah,7
@second:
 add  ax,$3030
 stosw
 retf
@process:
 mov  ax,W
 mov  bx,ax
 shr  ax,8
 call far [@outALhex]
 mov  ax,bx
 call far [@outALhex]
end;

Function NNKeyUpdate2(const CurrKey: Integer): Word;
begin
 NNKeyUpdate2:=(((CurrKey mod 177)*171)-((CurrKey div 177)*2))*32767;
end;

VAR
 F1             :File;
 Seed,i,Blocks  :Word;
 BlockID,
 Offset,BLen    :LongInt;

Procedure Decrypt(var F: File;const O,L: Longint;Seed: Word);
var
 Ut             :Char;
 Key            :Byte;

 i,
 CurrSeed       :Word;

 Buf            :Array[0..1023] of Byte;
 BufLen         :Word;
 Left           :LongInt;

begin
 Left:=L;
 CurrSeed:=Seed;

 Seek(F,O);

 While Left>0 do
 begin
  if Left>=SizeOf(Buf) then BufLen:=SizeOf(Buf) else BufLen:=Left;
  BlockRead(F,Buf,BufLen,BufLen);

  { -- begin decrypt block -- }
  for i:=0 to BufLen-1 do
  begin
   Key:=NNKeyUpdate2(CurrSeed) AND $FF;
   ut:=Char(Buf[i] XOR key);
   Write(ut);
   Inc(CurrSeed);
  end;
  { --- end decrypt block --- }

  Dec(Left,BufLen);
 end;
end;

BEGIN
 Assign(F1,ParamStr(1)); Reset(F1,1);

 Seek(F1,$11);  BlockRead(F1,Seed,2);
 Seek(F1,$1D);  BlockRead(F1,Blocks,2);

 WriteLn(ParamStr(1),', with key 0x',HexW(Seed),', contains 0x',HexW(Blocks),' blocks.');

 for i:=0 to Blocks-1 do
 begin
  Seek(F1,$21+(i*4));  BlockRead(F1,BlockID,4);
  Seek(F1,$E9+(i*4));  BlockRead(F1,Offset,4);
  Seek(F1,$1B1+(i*4)); BlockRead(F1,BLen,4);
  WriteLn;
  WriteLn('### Block #',i,' (ID: ',HexL(BlockID),') at 0x',HexL(Offset),', length 0x',HexL(BLen),' ###');
  WriteLn;

  Decrypt(F1,Offset,BLen,Seed);
 end;
 Close(F1);
END.
