;
; Useful Win32 constants - Saruman / DFR Research & Engineering
;

 NULL      =  0
 FALSE     =  0
 TRUE      =  1

 MINCHAR   =  080h
 MAXCHAR   =  07fh
 MINSHORT  =  08000h
 MAXSHORT  =  07fffh
 MINLONG   =  080000000h
 MAXLONG   =  07fffffffh
 MAXBYTE   =  0ffh
 MAXWORD   =  0ffffh
 MAXDWORD  =  0ffffffffh

 LANG_NEUTRAL = 0
 LANG_ENGLISH = 9
 LANG_SWEDISH = 01dh

 SUBLANG_NEUTRAL     = 0 ; language neutral
 SUBLANG_DEFAULT     = 1 ; user default
 SUBLANG_SYS_DEFAULT = 2 ; system default

 SORT_DEFAULT        = 0 ; sorting default

 TIME_ZONE_ID_UNKNOWN  = 0
 TIME_ZONE_ID_STANDARD = 1
 TIME_ZONE_ID_DAYLIGHT = 2

 PROCESSOR_INTEL_386     = 0386d
 PROCESSOR_INTEL_486     = 0486d
 PROCESSOR_INTEL_PENTIUM = 0586d
 PROCESSOR_MIPS_R4000    = 04000d
 PROCESSOR_ALPHA_21064   = 021064d

 PROCESSOR_ARCHITECTURE_INTEL   = 0
 PROCESSOR_ARCHITECTURE_MIPS    = 1
 PROCESSOR_ARCHITECTURE_ALPHA   = 2
 PROCESSOR_ARCHITECTURE_PPC     = 3
 PROCESSOR_ARCHITECTURE_UNKNOWN = 0FFFFh

 DELETE                         = 00010000h
 READ_CONTROL                   = 00020000h
 WRITE_DAC                      = 00040000h
 WRITE_OWNER                    = 00080000h
 SYNCHRONIZE                    = 00100000h
 STANDARD_RIGHTS_REQUIRED       = 000F0000h
 STANDARD_RIGHTS_READ           = 00020000h ; equal to READ_CONTROL
 STANDARD_RIGHTS_WRITE          = 00020000h ; equal to READ_CONTROL
 STANDARD_RIGHTS_EXECUTE        = 00020000h ; equal to READ_CONTROL
 STANDARD_RIGHTS_ALL            = 001F0000h

 SPECIFIC_RIGHTS_ALL            = 0000FFFFh
 ACCESS_SYSTEM_SECURITY         = 01000000h
 MAXIMUM_ALLOWED                = 02000000h

 MAX_PATH = 0104h

 CREATE_NEW        = 1
 CREATE_ALWAYS     = 2
 OPEN_EXISTING     = 3
 OPEN_ALWAYS       = 4
 TRUNCATE_EXISTING = 5

 GENERIC_READ                   = 080000000h
 GENERIC_WRITE                  = 040000000h
 GENERIC_EXECUTE                = 020000000h
 GENERIC_ALL                    = 010000000h

 FILE_READ_DATA                 = 0001h    ; file & pipe
 FILE_LIST_DIRECTORY            = 0001h    ; directory
 FILE_WRITE_DATA                = 0002h    ; file & pipe
 FILE_ADD_FILE                  = 0002h    ; directory
 FILE_APPEND_DATA               = 0004h    ; file
 FILE_ADD_SUBDIRECTORY          = 0004h    ; directory
 FILE_CREATE_PIPE_INSTANCE      = 0004h    ; named pipe
 FILE_READ_EA                   = 0008h    ; file & directory
 FILE_WRITE_EA                  = 0010h    ; file & directory
 FILE_EXECUTE                   = 0020h    ; file
 FILE_TRAVERSE                  = 0020h    ; directory
 FILE_DELETE_CHILD              = 0040h    ; directory
 FILE_READ_ATTRIBUTES           = 0080h    ; all
 FILE_WRITE_ATTRIBUTES          = 0100h    ; all

 FILE_ALL_ACCESS      = STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 01FFh
 FILE_GENERIC_READ    = STANDARD_RIGHTS_READ or FILE_READ_DATA or FILE_READ_ATTRIBUTES or FILE_READ_EA or SYNCHRONIZE
 FILE_GENERIC_WRITE   = STANDARD_RIGHTS_WRITE or FILE_WRITE_DATA or FILE_WRITE_ATTRIBUTES or FILE_WRITE_EA or FILE_APPEND_DATA or SYNCHRONIZE
 FILE_GENERIC_EXECUTE = STANDARD_RIGHTS_EXECUTE or FILE_READ_ATTRIBUTES or FILE_EXECUTE or SYNCHRONIZE

 FILE_SHARE_READ               = 00000001h
 FILE_SHARE_WRITE              = 00000002h
 FILE_SHARE_DELETE             = 00000004h
 FILE_ATTRIBUTE_READONLY       = 00000001h
 FILE_ATTRIBUTE_HIDDEN         = 00000002h
 FILE_ATTRIBUTE_SYSTEM         = 00000004h
 FILE_ATTRIBUTE_DIRECTORY      = 00000010h
 FILE_ATTRIBUTE_ARCHIVE        = 00000020h
 FILE_ATTRIBUTE_NORMAL         = 00000080h
 FILE_ATTRIBUTE_TEMPORARY      = 00000100h
 FILE_ATTRIBUTE_COMPRESSED     = 00000800h
 FILE_ATTRIBUTE_OFFLINE        = 00001000h
 FILE_NOTIFY_CHANGE_FILE_NAME  = 00000001h
 FILE_NOTIFY_CHANGE_DIR_NAME   = 00000002h
 FILE_NOTIFY_CHANGE_ATTRIBUTES = 00000004h
 FILE_NOTIFY_CHANGE_SIZE       = 00000008h
 FILE_NOTIFY_CHANGE_LAST_WRITE = 00000010h
 FILE_NOTIFY_CHANGE_LAST_ACCESS= 00000020h
 FILE_NOTIFY_CHANGE_CREATION   = 00000040h
 FILE_NOTIFY_CHANGE_SECURITY   = 00000100h
 FILE_ACTION_ADDED             = 00000001h
 FILE_ACTION_REMOVED           = 00000002h
 FILE_ACTION_MODIFIED          = 00000003h
 FILE_ACTION_RENAMED_OLD_NAME  = 00000004h
 FILE_ACTION_RENAMED_NEW_NAME  = 00000005h
 MAILSLOT_NO_MESSAGE           = 0FFFFFFFFh
 MAILSLOT_WAIT_FOREVER         = 0FFFFFFFFh
 FILE_CASE_SENSITIVE_SEARCH    = 00000001h
 FILE_CASE_PRESERVED_NAMES     = 00000002h
 FILE_UNICODE_ON_DISK          = 00000004h
 FILE_PERSISTENT_ACLS          = 00000008h
 FILE_FILE_COMPRESSION         = 00000010h
 FILE_VOLUME_IS_COMPRESSED     = 00008000h

 FILE_FLAG_WRITE_THROUGH       = 080000000h
 FILE_FLAG_OVERLAPPED          = 040000000h
 FILE_FLAG_NO_BUFFERING        = 020000000h
 FILE_FLAG_RANDOM_ACCESS       = 010000000h
 FILE_FLAG_SEQUENTIAL_SCAN     = 008000000h
 FILE_FLAG_DELETE_ON_CLOSE     = 004000000h
 FILE_FLAG_BACKUP_SEMANTICS    = 002000000h
 FILE_FLAG_POSIX_SEMANTICS     = 001000000h

 INVALID_HANDLE_VALUE          = 0FFFFFFFFh
 INVALID_FILE_SIZE             = 0FFFFFFFFh

 FILE_BEGIN   = 0
 FILE_CURRENT = 1
 FILE_END     = 2

