.386
.model flat, stdcall
option casemap: none

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comdlg32.inc
include \masm32\include\gdi32.inc
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\user32.lib
includelib \masm32\lib\comdlg32.lib
includelib \masm32\lib\gdi32.lib

wsprintfA proto C :DWORD,:DWORD,:VARARG
wsprintf TEXTEQU <wsprintfA>

WinMain proto:DWORD,:DWORD,:DWORD,:DWORD
SLoad proto
DlgProc proto:DWORD,:DWORD,:DWORD,:DWORD

.data
ClassName                        db "SimpleWindow",0
AppName                          db "PE-Analyzer",0
ListClassName                    db "listbox",0
EditClassName                    db "edit",0
sprint                           db "%X",0
sprintd                          db "%u",0
ofn                              OPENFILENAME <>
findfiledata                     WIN32_FIND_DATA <>
FilterString                     db "EXE",0,"*.exe",0
                                 db "All Files",0,"*.*",0,0
Invalids                         db "INVALID",0
Byted                            db "BYTE",13,10,0
Wordd                            db "WORD",13,10,0
DWordd                           db "DWORD",13,10,0
StartOfPE                        db "Start of PE: ",0
dStartOfPE                       db "This byte is read from the MZ-Header (Offset 0x3C). It shows where the PE-header starts.",0
Error                            db "Error",0
NoPE                             db "The file you selected has no valid PE-Header",0
Unknown                          db "Unknown",0
dMachine                         db "(PE+04)",13,10,"This value indicates the system the binary is intended to run on - The following values are possible:",13,10,"0x14c- Intel 80386 or better",13,10,"0x14d - Intel 80486 or better",13,10,"0x14e - Intel Pentium or better",13,10,"0x160 - MIPS Mark I (R2000, R3000)",13,10,"0x162 - MIPS Mark II (R6000)",13,10,"0x166 - MIPS Mark III (R4000)",13,10,"0x168 - MIPS Mark (R10000)",13,10,"0x184 - DEC Alpha AXP",13,10,"0x1F0 - IBM Power PC",0
Machine                          db "Machine: ",0
Machine014C                      db "80386",0
Machine014D                      db "80486",0
Machine014E                      db "80586",0
Machine0162                      db "MIPS Mark I (R2000, R3000)",0
Machine0163                      db "MIPS Mark II (R6000)",0
Machine0166                      db "MIPS Mark III (R4000)",0
Machine0168                      db "MIPS Mark (R10000)",0
Machine0184                      db "DEC Alpha AXP",0
Machine01F0                      db "IBM Power PC",0
Sections                         db "Sections: ",0
dSections                        db "(PE+06)",13,10,"This number displays the number of sections",0
TimeDateStamp                    db "TimeDateStamp: ",0
dTimeDateStamp                   db "(PE+08)",13,10,"This value shows when the file was created (seconds since 1.1.1970 in UCT)",0
PointerToSymbolTable             db "PointerToSymbolTable: ",0
dPointerToSymbolTable            db "(PE+0C)",13,10,"This value is used for debugging, but seems always to be 0",0
NumberOfSymbols                  db "NumberOfSymbols: ",0
dNumberOfSymbols                 db "(PE+10)",13,10,"Used for debugging",0
SizeOfOptionalHeader             db "SizeOfOptionalHeader: ",0
dSizeOfOptionalHeader            db "(PE+14)",13,10,"simply SIZEOF(IMAGE_OPTIONAL_HEADER) - can be used to validate a PE's structure",0
Characteristics                  db "Characteristics: ",0
dCharacteristics                 db "(PE+16) A 16bit value that consists of a collection of flags, most of them only valid for object files and libraries.",13,10,13,10,"Bit 0 (IMAGE_FILE_RELOCS_STRIPPED) is set if there's no relocation information in the file",13,10,13,10,"Bit 1 (IMAGE_FILE_EXECUTABLE_IMAGE): is set if file is executable",13,10,13,10,"Bit 2 (IMAGE_FILE_LINE_NUMS_STRIPPED): is set if the line number information is stripped (not in executables)",13,10,13,10,0
dCharacteristicsa                db "Bit 3 (IMAGE_FILE_LOCAL_SYMS_STRIPPED): is set if there's no information about local symbols in the file (not used for executables)",13,10,13,10,"Bit 4 (IMAGE_FILE_AGGRESSIVE_WS_TRIM): is set if the OS is supposed to trim the working set of the running process aggresively by paging it out",13,10,13,10,"Bits 7 and 15 (IMAGE_FILE_BYTES_REVERSED_LO): is set if the 'endianness' is not the one the machine expects",13,10,13,10,0
dCharacteristicsb                db "Bit 8 (IMAGE_FILE_32BIT_MACHINE): set if machine is expected to be 32bit (always)",13,10,13,10,"Bit 9 (IMAGE_FILE_DEBUG_STRIPPED): is set if there's no debugging info in the file",13,10,13,10,"Bit 10 (IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP): is set if file cannot be run from removable disks",13,10,13,10,"Bit 11 (IMAGE_FILE_NET_RUN_FROM_SWAP): is set if app may not run from network",13,10,13,10,0
dCharacteristicsc                db "Bit 12 (IMAGE_FILE_SYSTEM): is set if the file is a system file such as a driver",13,10,13,10,"Bit 13 (IMAGE_FILE_DLL): set if file is a DLL",13,10,13,10,"Bit 14 (IMAGE_FILE_UP_SYSTEM_ONLY): is set if file is not designed for multiprocessor systems",0
Magic                            db "Magic: ",0
dMagic                           db "No idea, seems always to be 0x010b",0
MajorLinkerVersion               db "MajorLinkerVersion: ",0
dMajorLinkerVersion              db "Indicates - if correct set - the major version linker that was used to create the file",0
MinorLinkerVersion               db "MinorLinkerVersion: ",0
dMinorLinkerVersion              db "Indicates - if correct set - the minor version linker that was used to create the file",0
SizeOfCode                       db "SizeOfCode: ",0
SizeOfInitializedData            db "SizeOfInitializedData: ",0
SizeOfUninitializedData          db "SizeOfUninitializedData: ",0
AddressOfEntryPoint              db "AddressOfEntryPoint: ", 0
BaseOfCode                       db "BaseOfCode: ",0
BaseOfData                       db "BaseOfData: ",0
ImageBase                        db "ImageBase: ",0
SectionAlignment                 db "SectionAlignment: ",0
FileAlignment                    db "FileAlignment: ",0
MajorOperatingSystemVersion      db "MajorOperatingSystemVersion ",0
MinorOperatingSystemVersion      db "MinorOperatingSystemVersion ",0
MajorImageVersion                db "MajorImageVersion: ",0
MinorImageVersion                db "MinorImageVersion: ",0
MajorSubsystemVersion            db "MajorSubsystemVersion: ",0
MinorSubsystemVersion            db "MinorSubsystemVersion: ",0
Reserved1                        db "Reserved1: ",0
SizeOfImage                      db "SizeOfImage: ",0
SizeOfHeaders                    db "SizeOfHeaders: ",0
CheckSum                         db "CheckSum: ",0
Subsystem                        db "Subsystem: ",0
DLLCharacteristics               db "DLLCharacteristics: ",0
SizeOfStackReserve               db "SizeOfStackReserve: ",0
SizeOfStackCommit                db "SizeOfStackCommit: ",0
SizeOfHeapReserve                db "SizeOfHeapReserve: ",0
SizeOfHeapCommit                 db "SizeOfHeapCommit: ",0
LoaderFlags                      db "LoaderFlags: ",0
NumberOfRvaAndSizes              db "NumberOfRvaAndSizes: ",0
ImageDirectoryEntryExporto       db "ImageDirectoryEntryExport (Offset): ",0
ImageDirectoryEntryExportl       db "ImageDirectoryEntryExport (Length): ",0
ImageDirectoryEntryImporto       db "ImageDirectoryEntryImport (Offset): ",0
ImageDirectoryEntryImportl       db "ImageDirectoryEntryImport (Length): ",0
ImageDirectoryEntryResourceo     db "ImageDirectoryEntryResource (Offset): ",0
ImageDirectoryEntryResourcel     db "ImageDirectoryEntryResource (Length): ",0
ImageDirectoryEntryExceptiono    db "ImageDirectoryEntryException (Offset): ",0
ImageDirectoryEntryExceptionl    db "ImageDirectoryEntryException (Length): ",0
ImageDirectoryEntrySecurityo     db "ImageDirectoryEntrySecurity (Offset): ",0
ImageDirectoryEntrySecurityl     db "ImageDirectoryEntrySecurity (Length): ",0
ImageDirectoryEntryBasereloco    db "ImageDirectoryEntryBasereloc (Offset): ",0
ImageDirectoryEntryBaserelocl    db "ImageDirectoryEntryBasereloc (Length): ",0
ImageDirectoryEntryDebugo        db "ImageDirectoryEntryDebug (Offset): ",0
ImageDirectoryEntryDebugl        db "ImageDirectoryEntryDebug (Length): ",0
ImageDirectoryEntryCopyrighto    db "ImageDirectoryEntryCopyright (Offset): ",0
ImageDirectoryEntryCopyrightl    db "ImageDirectoryEntryCopyright (Length): ",0
ImageDirectoryEntryGlobalPtro    db "ImageDirectoryEntryGlobalPtr (Offset): ",0
ImageDirectoryEntryGlobalPtrl    db "ImageDirectoryEntryGlobalPtr (Length): ",0
ImageDirectoryEntryTlso          db "ImageDirectoryEntryTls (Offset): ",0
ImageDirectoryEntryTlsl          db "ImageDirectoryEntryTls (Length): ",0
ImageDirectoryEntryLoadConfigo   db "ImageDirectoryEntryLoadConfig (Offset): ",0
ImageDirectoryEntryLoadConfigl   db "ImageDirectoryEntryLoadConfig (Length): ",0
ImageDirectoryEntryBoundImporto  db "ImageDirectoryEntryBoundImport (Offset): ",0
ImageDirectoryEntryBoundImportl  db "ImageDirectoryEntryBoundImport (Length): ",0
ImageDirectoryEntryIato          db "ImageDirectoryEntryIat (Offset): ",0
ImageDirectoryEntryIatl          db "ImageDirectoryEntryIat (Length): ",0
SectionsA                        dw 0
SectionsB                        db "--- SECTIONS ---",0
VirtualSize                      db "Virtual Size: ",0
VirtualAddress                   db "Virtual Address: ",0
SizeOfRawData                    db "Size of raw data: ",0
PointerToRawData                 db "Pointer to raw data: ",0
PointerToRelocations             db "Pointer to Relocations: ",0
PointerToLineNumbers             db "Pointer to LineNumbers: ",0
NumberOfRelocations              db "Number of Relocations: ",0
NumberOfLineNumbers              db "Number of LineNumbers: ",0
loopcheck                        db 0
DlgName                          db "ABOUTDLG",0
hwndDlg                          dd 0            ; Handle to the dialog box

.data?
hInstance       HINSTANCE ?
hwndList        HWND ?
hwndEdit        HWND ?
buffer          db 512 dup(?)
buffer2         db 512 dup(?)
buffer3         db 512 dup(?)
hFile           HANDLE ?     ;; Handle of File
hMemory         HANDLE ?     ;; Handle to the allocated memoty block
pMemory         DWORD ?      ;; pointer to the allocated memory block
SizeReadWrite   DWORD ?      ;; number of bytes actually read or write

.const
Menu1           equ 1
ListID1         equ 201
EditID1         equ 202
IDM_OPEN        equ 666
MAXSIZE         equ 260    ;; max size for FileName
MEMSIZE         equ 2097152  ;; max size for text
IDM_ABOUT       equ 667    ;; Handle for "About" Menu
IDC_BUTTON1     equ 101    ;; Button in DialogBox

.code
start:
invoke GetModuleHandle, NULL
invoke WinMain, hInstance, NULL, NULL, SW_SHOWDEFAULT
invoke ExitProcess, 0

WinMain proc hInst:HINSTANCE, hPrevInst:HINSTANCE, CmdLine:LPSTR, CmdShow:DWORD
  LOCAL wc:WNDCLASSEX
  LOCAL msg:MSG
  LOCAL hwnd:HWND

  mov wc.cbSize, SIZEOF WNDCLASSEX
  mov wc.style, CS_HREDRAW or CS_VREDRAW
  mov wc.lpfnWndProc, OFFSET WndProc
  mov wc.cbClsExtra, NULL
  mov wc.cbWndExtra, NULL
  push hInstance
  pop wc.hInstance
  mov wc.hbrBackground, COLOR_WINDOW+1
  mov wc.lpszMenuName, Menu1
  mov wc.lpszClassName, OFFSET ClassName
  invoke LoadIcon, NULL, IDI_APPLICATION
  mov wc.hIcon, eax
  mov wc.hIconSm, eax
  invoke LoadCursor, NULL, IDC_ARROW
  mov wc.hCursor, eax
  invoke RegisterClassEx, addr wc
  invoke CreateWindowEx, NULL,\
         ADDR ClassName,\
         ADDR AppName,\
         WS_BORDER or WS_SYSMENU,\
         200,\
         100,\
         400,\
         450,\
         NULL,\
         NULL,\
         hInst,\
         NULL
  mov hwnd, eax
  invoke ShowWindow, hwnd, CmdShow
  invoke UpdateWindow, hwnd

  .WHILE TRUE
    invoke GetMessage, ADDR msg, NULL, 0, 0
    .BREAK .IF (!eax)
    invoke TranslateMessage, ADDR msg
    invoke DispatchMessage, ADDR msg
  .ENDW
  mov eax, msg.wParam
  ret
WinMain endp

WndProc proc hWnd:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
  LOCAL hdc:HDC
  LOCAL ps:PAINTSTRUCT
  LOCAL rect:RECT
  LOCAL fln:DWORD
  .IF uMsg==WM_DESTROY
    invoke PostQuitMessage,NULL
  .ELSEIF uMsg==WM_CREATE
    invoke CreateWindowEx,WS_EX_CLIENTEDGE, ADDR ListClassName,NULL,\
            WS_CHILD or WS_VISIBLE or WS_BORDER or WS_VSCROLL or WS_HSCROLL or LBS_NOTIFY,\
            20,15,350,250,hWnd,ListID1,hInstance,NULL
    mov hwndList, eax
    invoke CreateWindowEx,WS_EX_CLIENTEDGE, ADDR EditClassName,NULL,\
            WS_CHILD or WS_VISIBLE or WS_BORDER or WS_VSCROLL or ES_READONLY or ES_MULTILINE or ES_WANTRETURN,\
            20,280,350,100,hWnd,EditID1,hInstance,NULL
    mov hwndEdit, eax
  .ELSEIF uMsg==WM_COMMAND ;; if something happens
    mov eax,wParam
    .if lParam==0
      .if ax==IDM_OPEN
        invoke SLoad
        .if eax!=0
          invoke SendDlgItemMessage, hWnd, ListID1, LB_RESETCONTENT,0,0
          invoke SetWindowText, hwndEdit, NULL
          mov esi, pMemory
          mov ebx, dword ptr [esi+3Ch]
;; ----- PE\0\0
          .IF (dword ptr [esi+3Ch] < 1000h) && (dword ptr [esi+ebx] == 00004550h)
            invoke lstrcpy, ADDR buffer3, ADDR StartOfPE
            invoke wsprintf, ADDR buffer2, ADDR sprint, ebx
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- Machine
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR Machine
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- Objects
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR Sections
            mov ax, word ptr [esi+ebx]
            mov SectionsA, ax
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- TimeDateStamp
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR TimeDateStamp
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- PointerToSymbolTable
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR PointerToSymbolTable
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- NumberOfSymbols
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR NumberOfSymbols
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfOptionalHeader
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfOptionalHeader
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- Characteristics
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR Characteristics
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- Magic
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR Magic
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- MajorLinkerVersion
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR MajorLinkerVersion
            invoke wsprintf, ADDR buffer2, ADDR sprintd, byte ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- MinorLinkerVersion
            inc ebx
            invoke lstrcpy, ADDR buffer3, ADDR MinorLinkerVersion
            invoke wsprintf, ADDR buffer2, ADDR sprintd, byte ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfCode
            inc ebx
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfCode
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfInitializedData
            add ebx,4
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfInitializedData
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfUninitializedData
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfUninitializedData
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- AddressOfEntryPoint
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR AddressOfEntryPoint
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- BaseOfCode
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR BaseOfCode
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- BaseOfData
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR BaseOfData
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageBase
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageBase
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SectionAlignment
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR SectionAlignment
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- FileAlignment
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR FileAlignment
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- MajorOperatingSystemVersion
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR MajorOperatingSystemVersion
            invoke wsprintf, ADDR buffer2, ADDR sprintd, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- MinorOperatingSystemVersion
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR MinorOperatingSystemVersion
            invoke wsprintf, ADDR buffer2, ADDR sprintd, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- MajorImageVersion
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR MajorImageVersion
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- MinorImageVersion
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR MinorImageVersion
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- MajorSubsystemVersion
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR MajorSubsystemVersion
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- MinorSubsystemVersion
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR MinorSubsystemVersion
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- Reserved1
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR Reserved1
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfImage
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfImage
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfHeaders
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfHeaders
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfCheckSum
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR CheckSum
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- Subsystem
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR Subsystem
            invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- DLLCharacteristics
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR DLLCharacteristics
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfStackReserve
            add ebx, 2
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfStackReserve
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfStackCommit
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfStackCommit
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfHeapReserve
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfHeapReserve
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- SizeOfHeapCommit
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR SizeOfHeapCommit
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- LoaderFlags
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR LoaderFlags
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- NumberOfRvaAndSizes
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR NumberOfRvaAndSizes
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryExporto
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryExporto
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryExportl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryExportl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryImporto
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryImporto
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryImportl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryImportl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryResourceo
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryResourceo
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryResourcel
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryResourcel
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryExceptiono
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryExceptiono
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryExceptionl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryExceptionl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntrySecurityo
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntrySecurityo
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntrySecurityl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntrySecurityl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryBaseReloco
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryBasereloco
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryBaseRelocl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryBaserelocl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryDebugo
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryDebugo
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryDebugl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryDebugl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryCopyrighto
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryCopyrighto
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryCopyrightl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryCopyrightl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryGlobalPtro
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryGlobalPtro
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryGlobalPtrl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryGlobalPtrl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryTlso
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryTlso
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryTlsl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryTlsl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryLoadConfigo
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryLoadConfigo
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryLoadConfigl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryLoadConfigl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryBoundImporto
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryBoundImporto
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryBoundImportl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryBoundImportl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryIato
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryIato
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ----- ImageDirectoryEntryIatl
            add ebx, 4
            invoke lstrcpy, ADDR buffer3, ADDR ImageDirectoryEntryIatl
            invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
            invoke lstrcat, ADDR buffer3, ADDR buffer2
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- BEGIN OF SECTIONS
            invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR SectionsB
            add ebx, 1Ch
            SectionStart:
            .IF (SectionsA!=0)
               xor eax, eax
;; ---- Get the Name
              InnerLoop:
              .IF (byte ptr [esi+ebx]!=0) && (loopcheck!=8)
                mov cl, byte ptr [esi+ebx]
                mov byte ptr [buffer2+eax], cl
                inc eax
                inc ebx
                inc loopcheck
                jmp InnerLoop
              .ENDIF
              mov loopcheck, 0
              mov byte ptr [buffer2+eax], 0
              push eax
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer2
              pop eax
;; --- Got the Name here / now the Virtual Size
              mov ecx, 8
              sub ecx, eax
              add ebx, ecx
              invoke lstrcpy, ADDR buffer3, ADDR VirtualSize
              invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- Virtual Address              
              add ebx, 4
              invoke lstrcpy, ADDR buffer3, ADDR VirtualAddress
              invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- Size of raw data
              add ebx, 4
              invoke lstrcpy, ADDR buffer3, ADDR SizeOfRawData
              invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- Pointer to raw data
              add ebx, 4
              invoke lstrcpy, ADDR buffer3, ADDR PointerToRawData
              invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- Pointer to Relocations
              add ebx, 4
              invoke lstrcpy, ADDR buffer3, ADDR PointerToRelocations
              invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- Pointer to Linenumbers
              add ebx, 4
              invoke lstrcpy, ADDR buffer3, ADDR PointerToLineNumbers
              invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- Number of Relocations
              add ebx, 4
              invoke lstrcpy, ADDR buffer3, ADDR NumberOfRelocations
              invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- Number of LineNumbers
              add ebx, 2
              invoke lstrcpy, ADDR buffer3, ADDR NumberOfLineNumbers
              invoke wsprintf, ADDR buffer2, ADDR sprint, word ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3
;; ---- Characteristics
              add ebx, 2
              invoke lstrcpy, ADDR buffer3, ADDR Characteristics
              invoke wsprintf, ADDR buffer2, ADDR sprint, dword ptr [esi+ebx]
              invoke lstrcat, ADDR buffer3, ADDR buffer2
              invoke SendDlgItemMessage, hWnd, ListID1, LB_ADDSTRING, 1 ,ADDR buffer3

              add ebx, 4
              dec SectionsA
              jmp SectionStart
            .ENDIF
            invoke CloseHandle,hFile
            invoke GlobalUnlock,pMemory
            invoke GlobalFree,hMemory
          .ELSEIF
            invoke MessageBoxA, hWnd, ADDR NoPE, ADDR Error, MB_OK
          .ENDIF
        .endif
      .elseif ax==IDM_ABOUT
        invoke CreateDialogParam,hInstance,addr DlgName,hWnd,OFFSET DlgProc,NULL
        mov hwndDlg,eax
      .endif
   .ELSEIF ax==ListID1
     shr eax, 16
     .IF ax==LBN_SELCHANGE
       invoke SetWindowText, hwndEdit, NULL
       invoke SendDlgItemMessage, hWnd, ListID1, LB_GETCURSEL,0,0
       .IF eax==0
         invoke lstrcpy, ADDR buffer2, ADDR Byted
         invoke lstrcat, ADDR buffer2, ADDR dStartOfPE
       .ELSEIF eax==1
         invoke lstrcpy, ADDR buffer2, ADDR Wordd
         invoke lstrcat, ADDR buffer2, ADDR dMachine
       .ELSEIF eax==2
         invoke lstrcpy, ADDR buffer2, ADDR Wordd
         invoke lstrcat, ADDR buffer2, ADDR dSections
       .ELSEIF eax==3
         invoke lstrcpy, ADDR buffer2, ADDR DWordd
         invoke lstrcat, ADDR buffer2, ADDR dTimeDateStamp
       .ELSEIF eax==4
         invoke lstrcpy, ADDR buffer2, ADDR DWordd
         invoke lstrcat, ADDR buffer2, ADDR dPointerToSymbolTable
       .ELSEIF eax==5
         invoke lstrcpy, ADDR buffer2, ADDR DWordd
         invoke lstrcat, ADDR buffer2, ADDR dNumberOfSymbols
       .ELSEIF eax==6
         invoke lstrcpy, ADDR buffer2, ADDR Wordd
         invoke lstrcat, ADDR buffer2, ADDR dSizeOfOptionalHeader
       .ELSEIF eax==7
         invoke lstrcpy, ADDR buffer2, ADDR Wordd
         invoke lstrcat, ADDR buffer2, ADDR dCharacteristics
         invoke lstrcat, ADDR buffer2, ADDR dCharacteristicsa
         invoke lstrcat, ADDR buffer2, ADDR dCharacteristicsb
         invoke lstrcat, ADDR buffer2, ADDR dCharacteristicsc
       .ELSEIF eax==8
         invoke lstrcpy, ADDR buffer2, ADDR Wordd
         invoke lstrcat, ADDR buffer2, ADDR dMagic
       .ELSEIF eax==9
         invoke lstrcpy, ADDR buffer2, ADDR Byted
         invoke lstrcat, ADDR buffer2, ADDR dMajorLinkerVersion
       .ELSEIF eax==10
         invoke lstrcpy, ADDR buffer2, ADDR Byted
         invoke lstrcat, ADDR buffer2, ADDR dMinorLinkerVersion
       .ENDIF
         invoke SetWindowText, hwndEdit, ADDR buffer2
     .endif
   .endif
  .ELSE
    invoke DefWindowProc,hWnd,uMsg,wParam,lParam
    ret
  .ENDIF
  xor eax, eax
  ret
WndProc endp

SLoad proc
            mov ofn.lStructSize,SIZEOF ofn 
            push hInstance 
            pop  ofn.hInstance 
            mov  ofn.lpstrFilter, OFFSET FilterString 
            mov  ofn.lpstrFile, OFFSET buffer 
            mov  ofn.nMaxFile,MAXSIZE 
            mov  ofn.Flags, OFN_FILEMUSTEXIST or \ 
                OFN_PATHMUSTEXIST or OFN_LONGNAMES or\ 
                OFN_EXPLORER or OFN_HIDEREADONLY 
            invoke GetOpenFileName, ADDR ofn
  .if eax==TRUE
    invoke CreateFile,ADDR buffer,\
                      GENERIC_READ or GENERIC_WRITE ,\
                      FILE_SHARE_READ or FILE_SHARE_WRITE,\
                      NULL,OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,\
                      NULL
    mov hFile,eax
    invoke GlobalAlloc,GMEM_MOVEABLE or GMEM_ZEROINIT,MEMSIZE
    mov  hMemory,eax
    invoke GlobalLock,hMemory
    mov  pMemory,eax
    invoke ReadFile,hFile,pMemory,MEMSIZE-1,ADDR SizeReadWrite,NULL
  .endif
ret
SLoad endp

DlgProc PROC hWnd:HWND,iMsg:DWORD,wParam:WPARAM, lParam:LPARAM
        .if iMsg==WM_INITDIALOG
        .elseif iMsg==WM_CLOSE
		invoke EndDialog,hWnd,NULL
		mov hwndDlg,0
        .elseif iMsg==WM_COMMAND
          mov eax, wParam 
          .IF ax==IDC_BUTTON1
            shr eax, 16
            .IF ax==BN_CLICKED
              invoke SendMessage,hWnd,WM_CLOSE,NULL,NULL
            .ENDIF
          .ENDIF
        .else
		mov eax,FALSE
		ret
        .endif
        mov  eax,TRUE
        ret
DlgProc endp

end start
