; Direct3D Fullscreen Application
; by Minde, montana@is.lt (c) 1999.08.12

.386
.MODEL  FLAT, STDCALL

;// INCLUDES ///////////////////////////////////////////////
.const
include winerror.inc
include include.inc
include tddraw.inc
include td3dtypes.inc
include td3drmdef.inc
include td3drmobj.inc
include td3drm.inc

;// PROTOTYPES /////////////////////////////////////////////
Setup3D         PROCDESC STDCALL
CreateScene     PROCDESC STDCALL
OnDestroy       PROCDESC STDCALL
UpdateScreen    PROCDESC STDCALL
ScaleMesh       PROCDESC STDCALL :DWORD, :DWORD

.data
;// GLOBALS ////////////////////////////////////////////////
ddraw       DD 0;
primsurf    DD 0;
backsurf    DD 0;
zbufsurf    DD 0;

d3drm       DD 0;
scene       DD 0;
camera      DD 0;
device      DD 0;
viewport    DD 0;
meshbuilder DD 0;

szAppName       DB "FULL3D",0

modewidth   = 640;
modeheight  = 480;
modedepth   = 16;

.data?
hWnd            DD ?
hThisInstance   DD ?
lpCmdLine       DD ?
nCmdShow        SDWORD ?
msg             MSGSTRUCT <?>
wc              WNDCLASS <?>
desc            DDSURFACEDESC <?>
ddscaps         DDSCAPS <?>


.code
Start:  call  GetModuleHandleA, NULL   ; get our module's handle
        mov hThisInstance, eax
        call  GetCommandLineA      ; and the command line
        mov lpCmdLine, eax
        mov nCmdShow, SW_SHOWDEFAULT

        call WinMain, hThisInstance, 0, lpCmdLine, nCmdShow
        call ExitProcess, eax    ; eax == Exit Code

;/////////////////////////////////////////////////////////////////////////////
;/////////////////////////////////////////////////////////////////////////////
WinMain PROC STDCALL, hInst:DWORD, hPrevInst:DWORD, lpszCmdParam:DWORD, CmdShow:SDWORD
        call InitWindow, hThisInstance, nCmdShow
        .IF eax == FALSE
            dec eax
            ret
        .ENDIF
        call Setup3D
        .IF eax == FALSE
            dec eax
            ret
        .ENDIF
        call CreateScene
        .IF eax == FALSE
            dec eax
            ret
         .ENDIF
        .WHILE TRUE
            call PeekMessageA, offset msg, NULL,0,0,PM_NOREMOVE
            .IF eax != 0
                call GetMessageA, offset msg, NULL, 0, 0
                .BREAK .IF eax == 0
                call TranslateMessage, offset msg
                call DispatchMessageA, offset msg   
            .ELSE
                call UpdateScreen
            .ENDIF
        .ENDW
        mov eax, msg.msg_wParam
        ret
WinMain ENDP
;//////////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////////
WndFunc PROC STDCALL, hwnd:DWORD, wmsg:DWORD, wParam:DWORD, lParam:DWORD
    mov eax, [wmsg]
    .if eax == WM_KEYDOWN
            mov eax, wParam
            .if eax == VK_ESCAPE
                call OnDestroy
                call PostQuitMessage, 0
                return0
            .endif
            return1
    .elseif eax == WM_DESTROY
            call OnDestroy
            call PostQuitMessage, 0
            return0
    .else
            call DefWindowProcA, hwnd, wmsg, wParam, lParam
            ret
    .endif
WndFunc ENDP
;//////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////
OnDestroy PROC
    .if (ddraw != 0)
        mcall [ddraw],DDRelease
        mov ddraw, 0
    .endif
    .if (primsurf != 0)
        mcall [primsurf], DDRelease
        mov primsurf, 0
    .endif
    .if (backsurf != 0)
        mcall [backsurf],DDRelease
        mov backsurf, 0
    .endif
    .if (zbufsurf != 0)
        mcall [zbufsurf],DDRelease
        mov zbufsurf, 0
    .endif
    .if (d3drm != 0)
        mcall [d3drm],DDRelease
        mov d3drm, 0
    .endif
    .if (scene != 0)
        mcall [scene], DDRelease
        mov scene, 0
    .endif
    .if (camera != 0)
        mcall [camera], DDRelease
        mov camera, 0
    .endif
    .if (device != 0)
        mcall [device], DDRelease
        mov device, 0
    .endif
    .if (viewport != 0)
        mcall [viewport], DDRelease
        mov viewport, 0
    .endif
    .if (meshbuilder != 0)
        mcall [meshbuilder], DDRelease
        mov meshbuilder, 0
    .endif
    ret
OnDestroy ENDP
;//////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////
InitWindow  PROC
        mov wc.style, CS_DBLCLKS
        mov eax, offset WndFunc
        mov wc.lpfnWndProc, eax ;       //the windows message handling function  
        mov wc.cbClsExtra, 0;         //not used anymore 
        mov wc.cbWndExtra, 0;         //not used anymore 
        mov eax, hThisInstance
        mov wc.hInstance, eax   ;     //you can run the windows programs more than once, which one is this
        call LoadIconA, 0, IDI_APPLICATION
        mov wc.hIcon, eax       ;  //icon used for window
        call LoadCursorA, 0, IDC_ARROW
        mov wc.hCursor, eax     ;      //type of mouse cursor used
        call GetStockObject, BLACK_BRUSH
        mov wc.hbrBackground, eax ;      //background color of window
        mov wc.lpszMenuName, NULL;                  //not used
        mov wc.lpszClassName, offset  szAppName;             //name for this windows class   
        call RegisterClassA,  offset wc
        call CreateWindowExA, \
                    WS_EX_TOPMOST, \
                    offset szAppName, \
                    offset szAppName, \
                    WS_VISIBLE | WS_POPUP, \
                    CW_USEDEFAULT,\         
                    CW_USEDEFAULT, \        
                    modewidth,   \
                    modeheight,  \
                    NULL,         \         
                    NULL,         \         
                    hThisInstance,\        
                    NULL
        mov hWnd, eax
        .if eax == FALSE
            ret
        .endif
        call ShowWindow, hwnd, nCmdShow
        call UpdateWindow, hwnd
        call ShowCursor, FALSE
        ret
InitWindow  ENDP
;//////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////
Setup3D PROC
;    //create d3d retained mode interface
    call Direct3DRMCreate, offset d3drm

;    //create directdraw interface
    call DirectDrawCreate, 0, offset ddraw, 0
    mcall [ddraw], DDSetCooperativeLevel, <hWnd>, <DDSCL_EXCLUSIVE + DDSCL_FULLSCREEN>
    mcall [ddraw], DDSetDisplayMode, <modewidth>, <modeheight>, <modedepth>

;    //create the primary surface(with attached back surface)
    mov desc.ddsurfacedesc_dwSize, size desc
    mov desc.ddsurfacedesc_dwFlags, DDSD_BACKBUFFERCOUNT + DDSD_CAPS
    mov desc.ddsurfacedesc_dwBackBufferCount, 1
    mov desc.ddsurfacedesc_ddssurfCaps.dwCaps,DDSCAPS_PRIMARYSURFACE + DDSCAPS_3DDEVICE + DDSCAPS_FLIP + DDSCAPS_COMPLEX
    mcall [ddraw], DDCreateSurface, <offset desc>, <offset primsurf>, 0

;    //create the attached back surface
    mov ddscaps.dwCaps, DDSCAPS_BACKBUFFER;
    mcall [primsurf], DDSGetAttachedSurface, <offset ddscaps>, <offset backsurf>

;    //create the zbuffer
    call RtlZeroMemory, offset desc, SIZE desc
    mov desc.ddsurfacedesc_dwSize, size desc
    mov desc.ddsurfacedesc_dwFlags, DDSD_WIDTH + DDSD_HEIGHT + DDSD_CAPS + DDSD_ZBUFFERBITDEPTH;
    mov desc.ddsurfacedesc_dwWidth, modewidth
    mov desc.ddsurfacedesc_dwHeight, modeheight
    mov desc.ddsurfacedesc_dwZBufferBitDepth, modedepth
    mov desc.ddsurfacedesc_ddssurfCaps.dwCaps, DDSCAPS_ZBUFFER + DDSCAPS_SYSTEMMEMORY;
    mcall [ddraw], DDCreateSurface, <offset desc>, <offset zbufsurf>,0
    mcall [backsurf], DDSAddAttachedSurface, <zbufsurf>

;    //create d3d device from directdraw surface
    mcall [d3drm], D3DRMCreateDeviceFromSurface, 0,<ddraw>,<backsurf>,<offset device>
    mcall [device], D3DRMDSetQuality, D3DRMRENDER_WIREFRAME;WIREFRAME;GOURAUD
    return1
Setup3D ENDP
;//////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////
CreateScene PROC
;    //create scene frame, the root frame
    mcall [d3drm], D3DRMCreateFrame, 0, <offset scene>
    
;    //load a mesh
.data
bin         db "desk.x",0

.code
    mcall [d3drm], D3DRMCreateMeshBuilder, <offset meshbuilder>
    mcall [meshbuilder], D3DRMMBLoad,<offset bin>, 0,D3DRMLOAD_FROMFILE,0,0
    .if eax != D3DRM_OK
        return0
    .endif
    call ScaleMesh, meshbuilder, 1108082688 ; //just to make sure it's a size we want
    
;    //create a meshframe, attach to scene
.data?
    meshframe DD ?
.code
    mcall [d3drm], D3DRMCreateFrame, <scene>, <offset meshframe>
    mcall [meshframe], D3DRMFAddVisual, <meshbuilder>


;    //note: adding the automatic rotation means in the update() function we have to call the move() 
;    //member function to initiate the auto update.
    mcall [meshframe],D3DRMFSetRotation,<scene>,0,1065353216,1045220557,1028443341
    mcall [meshframe],D3DRMFRelease
    mov meshframe, 0;

;    //create a light
.data?
    slight          DD ?
    slightframe     DD ?
.code
    mcall [d3drm], D3DRMCreateLightRGB,2,1065353216,1065353216,1065353216,<offset slight>
    
;    //create the frame to attach the light to, 
;    //everything needs to attach to a frame then to the scene frame.
    mcall [d3drm], D3DRMCreateFrame,<scene>,<offset slightframe>
    mcall [slightframe], D3DRMFSetPosition,<scene>,0,1084227584,-1029701632
    mcall [slightframe], D3DRMFSetOrientation,<scene>,0,0,1065353216,0,1065353216,0
    mcall [slightframe], D3DRMFAddLight,<slight>
    mcall [slightframe], D3DRMFRelease
    mov slightframe, 0
    mcall [slight], D3DRMFRelease
    mov slight, 0
    
;    //create a frame to act as the camera, attach to scene
    mcall [d3drm], D3DRMCreateFrame,<scene>,<offset camera>
    mcall [camera], D3DRMFSetPosition,<scene>,0,1097859072,-1032847360
    
;    //create the renderer, the viewport
.data?
temp1   DD ?
temp2   DD ?
.code
    mcall [device], <D3DRMDGetHeight>
    mov temp2, eax
    mcall [device], <D3DRMDGetWidth>
    mov temp1, eax
    mcall [d3drm], <D3DRMCreateViewport>,<device>,<camera>,0,0,<temp1>,<temp2>,<offset viewport>
    return1
CreateScene ENDP
;//////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////
UpdateScreen PROC
    mcall [primsurf], DDSIsLost
    .if eax == DDERR_SURFACELOST
        mcall [primsurf], DDSRestore
    .endif    
.data?
    bltfx DDBLTFX <?>
.code
    call RtlZeroMemory, offset bltfx, size bltfx
    mov bltfx.ddbltfx_dwSize, size bltfx
    mov bltfx.ddbltfx_dwFillColor, 0
    mcall [backsurf], DDSBlt,0,0,0,<DDBLT_COLORFILL + DDBLT_WAIT>,<offset bltfx>

;    //if you setrotation or some other auto updating frame function you must
;    //call ->Move() to update it
    mcall [scene], D3DRMFMove,1065353216

    mcall [viewport],D3DRMVClear
    mcall [viewport],D3DRMVRender,<scene>
    mcall [device], D3DRMDUpdate
    
    mcall [primsurf], DDSFlip, 0, <DDFLIP_WAIT>
    ret
UpdateScreen ENDP
;//////////////////////////////////////////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////
ScaleMesh PROC, mesh:DWORD, dim:D3DVALUE
.data?
    box         D3DRMBOX <?>
    sizex       D3DVALUE ?
    sizey       D3DVALUE ?
    sizez       D3DVALUE ?
    scalefactor D3DVALUE ?
    largedim    D3DVALUE ?
    dimm        D3DVALUE ?
.code
    mov eax, dim
    mov dimm, eax
    ; method D3DRMMGetBox
    mcall [mesh], 64, <offset box>

    fld box.d3drmbox_max.d3dvector_x
    fsub box.d3drmbox_min.d3dvector_x
    fstp sizex
    fld box.d3drmbox_max.d3dvector_y
    fsub box.d3drmbox_min.d3dvector_y
    fstp sizey
    fld box.d3drmbox_max.d3dvector_z
    fsub box.d3drmbox_min.d3dvector_z
    fstp sizez

    fld sizex
    fcomp largedim
    fnstsw ax
    sahf
    .if !carry? ; if st >= operand
        mov eax, sizex
        mov largedim, eax
    .endif

    fld sizey
    fcomp largedim
    fnstsw ax
    sahf
    .if !carry? ; if st >= operand
        mov eax, sizey
        mov largedim, eax
    .endif

    fld sizez
    fcomp largedim
    fnstsw ax
    sahf
    .if !carry? ; if st >= operand
        mov eax, sizez
        mov largedim, eax
    .endif

    fld dimm
    fdiv largedim
    fstp scalefactor

    ; method D3DRMMScale
    mcall [mesh], 52,<scalefactor>,<scalefactor>,<scalefactor>

    ret
ScaleMesh ENDP

end Start
;//////////////////////////////////////////////////////////////////////////
;//////////////////////// END OF FILE /////////////////////////////////////
;//////////////////////////////////////////////////////////////////////////
