;###############################################################################
;#                                  MACROS                                     #
;###############################################################################
;===============================================================================
; pushrtol
; pushes the arguments of the macro onto the stack right to left
; uses recursion...
;-------------------------------------------------------------------------------
pushrtol MACRO v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12
        IFNB <v1>
                pushrtol <v2>,<v3>,<v4>,<v5>,<v6>,<v7>,<v8>,<v9>,<v10>,<v11>,<v12>
                push v1
        ENDIF
ENDM
;================================================================================
; mcall
; used to call the DirectDraw methods. Pointer to object first, then offset into
; method table, then parameters.... e.g.
;               mcall [lpDD], DDSETCOOPERATIVELEVEL, [hWnd], DDSCL_NORMAL
;-------------------------------------------------------------------------------
mcall MACRO ObjectPtr, MethodName, v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12
        pushrtol <v1>,<v2>,<v3>,<v4>,<v5>,<v6>,<v7>,<v8>,<v9>,<v10>,<v11>,<v12>
        mov eax, ObjectPtr
        push eax
        mov eax, [eax]
        call DWORD PTR [eax+MethodName]
ENDM
;================================================================================
; return0
; used to return to windows whit false
;-------------------------------------------------------------------------------
return0 MACRO
        xor eax, eax
        ret
ENDM
;================================================================================
; return1
; used to return to windows whit true
;-------------------------------------------------------------------------------
return1 MACRO
        xor eax, eax
        inc eax
        ret
ENDM

;͸
;          S T A N D A R D    E Q U A T E S    A N D    D E F S        
;;
NULL        equ 0h
FALSE       equ 0h
TRUE        equ 1h

BOOL        TYPEDEF SDWORD


;͸
;                           PROTOTYPES ...
;

MessageBoxA         PROCDESC    STDCALL :DWORD, :DWORD, :DWORD, :DWORD
WaitMessage         PROCDESC    STDCALL
RtlZeroMemory       PROCDESC    STDCALL :DWORD, :DWORD
LoadCursorA         PROCDESC    STDCALL :DWORD, :DWORD
LoadIconA           PROCDESC    STDCALL :DWORD, :DWORD
GetStockObject      PROCDESC    STDCALL :SDWORD             ;used to get a brush
RegisterClassA      PROCDESC    STDCALL :DWORD
CreateWindowExA     PROCDESC    STDCALL :DWORD, :DWORD, :DWORD, :DWORD, :SDWORD,:SDWORD, :SDWORD, :SDWORD, :DWORD, :DWORD, :DWORD, :DWORD
GetCommandLineA     PROCDESC    STDCALL
GetModuleHandleA    PROCDESC    STDCALL :DWORD
ExitProcess         PROCDESC    STDCALL :DWORD
ShowWindow          PROCDESC    STDCALL :DWORD, :SDWORD
UpdateWindow        PROCDESC    STDCALL :DWORD
SetFocus            PROCDESC    STDCALL :DWORD
ShowCursor          PROCDESC    STDCALL :DWORD
PeekMessageA        PROCDESC    STDCALL :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
GetMessageA         PROCDESC    STDCALL :DWORD, :DWORD, :DWORD, :DWORD
TranslateMessage    PROCDESC    STDCALL :DWORD
DispatchMessageA    PROCDESC    STDCALL :DWORD
ExitProcess         PROCDESC    STDCALL :DWORD
PostMessageA        PROCDESC    STDCALL :DWORD, :DWORD, :DWORD, :DWORD
DefWindowProcA      PROCDESC    STDCALL :DWORD, :DWORD, :DWORD, :DWORD
BeginPaint          PROCDESC    STDCALL :DWORD,  :DWORD
EndPaint            PROCDESC    STDCALL :DWORD,  :DWORD
PostQuitMessage     PROCDESC    STDCALL :SWORD
ExitProcess         PROCDESC    STDCALL :DWORD


GUID STRUCT
    Data1   dd ?
    Data2   dw ?
    Data3   dw ?
    Data4   db ?
    Data5   db ?
    Data6   db ?
    Data7   db ?
    Data8   db ?
    Data9   db ?
    Data10  db ?
    Data11  db ?
GUID ENDS


UCHAR   EQU <db>
USHORT  EQU <dw>  ; used only if we really need 16 bits
UINT    EQU <dd>  ; 32 bits for WIN32
ULONG   EQU <dd>


RECT    struc
     Left          UINT ?
     Top           UINT ?
     Right         UINT ?
     Bottom        UINT ?
RECT    ends

WNDCLASS struc
  style          UINT  ? ; class style
  lpfnWndProc    ULONG ?
  cbClsExtra     UINT  ?
  cbWndExtra     UINT  ?
  hInstance      UINT  ? ; instance handle
  hIcon          UINT  ? ; class icon handle
  hCursor        UINT  ? ; class cursor handle
  hbrBackground  UINT  ? ; class background brush
  lpszMenuName   ULONG ? ; menu name
  lpszClassName  ULONG ? ; far ptr to class name
WNDCLASS ends

MSGSTRUCT struc
   msg_HWND          UINT    ?
   msg_MESSAGE       UINT    ?
   msg_wParam        UINT    ?
   msg_lParam        ULONG   ?
   msg_TIME          ULONG   ?
   msg_PT            ULONG   ?
MSGSTRUCT ends

PAINTSTRUCT STRUC
    hdc         UINT             ?
    fErase      UINT             ?
    rcPaint     UCHAR            size RECT dup(?)
    fRestore    UINT             ?
    fIncUpdate  UINT             ?
    rgbReserved UCHAR            32 dup(?)
PAINTSTRUCT ENDS





CW_USEDEFAULT   equ 80000000h
WS_EX_TOPMOST   equ 8h
IDC_ARROW       equ 32512
IDI_APPLICATION equ 32512
CS_DBLCLKS      equ 8h
VK_ESCAPE       equ 1Bh
WM_KEYDOWN      equ 0100h
WM_CREATE       equ 0001h
WM_DESTROY      equ 0002h
WM_SIZE         equ 0005h
WM_SETTEXT      equ 000Ch
WM_PAINT        equ 000Fh
WM_CLOSE        equ 0010h
WM_ERASEBKGND       equ 0014h
WM_NOTIFY       equ 004Eh
WM_HELP         equ 0053h
WM_CHAR         equ 0102h
WM_INITDIALOG       equ 0110h
WM_COMMAND      equ 0111h
WM_TIMER        equ 0113h
WM_HSCROLL      equ 0114h
WM_VSCROLL      equ 0115h
WM_MENUSELECT       equ 011Fh
WM_CTLCOLORDLG      equ 0136h
WM_MOUSEMOVE        equ 0200h
WM_LBUTTONDOWN      equ 0201h
WM_LBUTTONUP        equ 0202h
WM_LBUTTONDBLCLK    equ 0203h
WM_RBUTTONDOWN      equ 0204h
WM_RBUTTONUP        equ 0205h
WM_RBUTTONDBLCLK    equ 0206h
WM_CUT          equ 0300h
WM_COPY         equ 0301h
WM_PASTE        equ 0302h
WM_CLEAR        equ 0303h
WM_UNDO         equ 0304h
WM_USER         equ 0400h

WS_POPUP        equ 080000000h
WS_CHILD        equ 040000000h
WS_MINIMIZE     equ 020000000h
WS_VISIBLE      equ 010000000h
WS_MAXIMIZE     equ 001000000h
WS_CAPTION      equ 000C00000h
WS_BORDER       equ 000800000h
WS_DLGFRAME     equ 000400000h
WS_VSCROLL      equ 000200000h
WS_HSCROLL      equ 000100000h
WS_SYSMENU      equ 000080000h
WS_SIZEBOX      equ 000040000h
WS_MINIMIZEBOX      equ 000020000h
WS_MAXIMIZEBOX      equ 000010000h
WS_OVERLAPPEDWINDOW equ 000CF0000h
WS_EX_NOPARENTNOTIFY    equ 000000004h
WS_EX_WINDOWEDGE    equ 000000100h
WS_EX_CLIENTEDGE    equ 000000200h
WS_EX_OVERLAPPEDWINDOW  equ WS_EX_WINDOWEDGE + WS_EX_CLIENTEDGE

CS_VREDRAW      equ 00001h
CS_HREDRAW      equ 00002h
CS_PARENTDC     equ 00080h
CS_BYTEALIGNWINDOW  equ 02000h

PM_NOREMOVE     equ 00h
PM_REMOVE       equ 01h
PM_NOYIELD      equ 02h

SWP_NOSIZE      equ 001h
SWP_NOMOVE      equ 002h
SWP_NOZORDER        equ 004h
SWP_FRAMECHANGED    equ 020h
SWP_DRAWFRAME       equ SWP_FRAMECHANGED
HWND_TOP        equ 000h

WHITE_BRUSH     equ 00h
LTGRAY_BRUSH        equ 01h
GRAY_BRUSH      equ 02h
DKGRAY_BRUSH        equ 03h
BLACK_BRUSH     equ 04h

SW_HIDE         equ 00h
SW_SHOWNORMAL       equ 01h
SW_SHOWMINIMIZED    equ 02h
SW_SHOWMAXIMIZED    equ 03h
SW_SHOW         equ 05h
SW_RESTORE      equ 09h
SW_SHOWDEFAULT      equ 0Ah
MB_OK                   = 0


;Ŀ
;                       END OF THE WINDOWS.INC FILE                
;;
;END OF FILE
