; td3dcaps.inc  (c) Minde  05/08/99 montana@is.lt
; Content:  TASM Direct3D capabilities include file ver. 1.2
; converted from d3dcaps.h, DX ver. 6.1
;
;  Feel free to use or distribute the package, part or whole, for any
; non-commercial use preferably crediting me.
;  Also feel free to contact me at the above address if you experience any
; problems or notice any omissions.


;===============================================================================
;                               STRUCTURES...
;===============================================================================

D3DTRANSFORMCAPS STRUCT
d3dtransformcaps_dwSize                  DD ? ;
d3dtransformcaps_dwCaps                  DD ? ;
D3DTRANSFORMCAPS ENDS

D3DLIGHTINGCAPS STRUCT
d3dlightingcaps_dwSize                  DD ? ;
d3dlightingcaps_dwCaps                  DD ? ; Lighting caps
d3dlightingcaps_dwLightingModel         DD ? ; Lighting model - RGB or mono
d3dlightingcaps_dwNumLights             DD ? ; Number of lights that can be handled
D3DLIGHTINGCAPS ENDS


D3DPRIMCAPS STRUCT
d3dprimcaps_dwSize                  DD ? ;
d3dprimcaps_dwMiscCaps              DD ? ; Capability flags
d3dprimcaps_dwRasterCaps            DD ? ;
d3dprimcaps_dwZCmpCaps              DD ? ;
d3dprimcaps_dwSrcBlendCaps          DD ? ;
d3dprimcaps_dwDestBlendCaps         DD ? ;
d3dprimcaps_dwAlphaCmpCaps          DD ? ;
d3dprimcaps_dwShadeCaps             DD ? ;
d3dprimcaps_dwTextureCaps           DD ? ;
d3dprimcaps_dwTextureFilterCaps     DD ? ;
d3dprimcaps_dwTextureBlendCaps      DD ? ;
d3dprimcaps_dwTextureAddressCaps    DD ? ;
d3dprimcaps_dwStippleWidth          DD ? ; maximum width and height of
d3dprimcaps_dwStippleHeight         DD ? ; of supported stipple (up to 32x32)
D3DPRIMCAPS ENDS


D3DDEVICEDESC STRUCT
d3ddevicedesc_dwSize                  DD ?                ; Size of D3DDEVICEDESC structure
d3ddevicedesc_dwFlags                 DD ?                ; Indicates which fields have valid data
d3ddevicedesc_dcmColorModel           D3DCOLORMODEL ?     ; Color model of device
d3ddevicedesc_dwDevCaps               DD ?                ; Capabilities of device
d3ddevicedesc_dtcTransformCaps        D3DTRANSFORMCAPS ?  ; Capabilities of transform
d3ddevicedesc_bClipping               DD ?                ; Device can do 3D clipping
d3ddevicedesc_dlcLightingCaps         D3DLIGHTINGCAPS ?   ; Capabilities of lighting
d3ddevicedesc_dpcLineCaps             D3DPRIMCAPS     ? ;
d3ddevicedesc_dpcTriCaps              D3DPRIMCAPS     ? ;
d3ddevicedesc_dwDeviceRenderBitDepth  DD ? ; One of DDBB_8, 16, etc..
d3ddevicedesc_dwDeviceZBufferBitDepth DD ? ; One of DDBD_16, 32, etc..
d3ddevicedesc_dwMaxBufferSize         DD ? ; Maximum execute buffer size
d3ddevicedesc_dwMaxVertexCount        DD ? ; Maximum vertex count

; New fields for DX5
d3ddevicedesc_dwMinTextureWidth       DD ? ;
d3ddevicedesc_dwMinTextureHeight      DD ? ;
d3ddevicedesc_dwMaxTextureWidth       DD ? ;
d3ddevicedesc_dwMaxTextureHeight      DD ? ;
d3ddevicedesc_dwMinStippleWidth       DD ? ;
d3ddevicedesc_dwMaxStippleWidth       DD ? ;
d3ddevicedesc_dwMinStippleHeight      DD ? ;
d3ddevicedesc_dwMaxStippleHeight      DD ? ;

; New fields for DX6
d3ddevicedesc_dwMaxTextureRepeat      DD ? ;
d3ddevicedesc_dwMaxTextureAspectRatio DD ? ;
d3ddevicedesc_dwMaxAnisotropy         DD ? ;

d3ddevicedesc_dvGuardBandLeft             D3DVALUE ? ;
d3ddevicedesc_dvGuardBandTop              D3DVALUE ? ;
d3ddevicedesc_dvGuardBandRight            D3DVALUE ? ;
d3ddevicedesc_dvGuardBandBottom           D3DVALUE ? ;
d3ddevicedesc_dvExtentsAdjust             D3DVALUE ? ;
d3ddevicedesc_dwStencilCaps               DD ? ;
d3ddevicedesc_dwFVFCaps                   DD ? ; low 4 bits: 0 implies TLVERTEX only, 1..8 imply FVF aware
d3ddevicedesc_dwTextureOpCaps             DD ? ;
d3ddevicedesc_wMaxTextureBlendStages      DW ? ;
d3ddevicedesc_wMaxSimultaneousTextures    DW ? ;
D3DDEVICEDESC ENDS

D3DDEVICEDESCSIZE = size D3DDEVICEDESC

; FindDevice arguments
D3DFINDDEVICESEARCH STRUCT
d3dfinddevicesearch_dwSize                  DD ? ;
d3dfinddevicesearch_dwFlags                 DD ? ;
d3dfinddevicesearch_bHardware               DD ? ;
d3dfinddevicesearch_dcmColorModel           D3DCOLORMODEL ? ;
d3dfinddevicesearch_guid                    GUID ? ;
d3dfinddevicesearch_dwCaps                  DD ? ;
d3dfinddevicesearch_dpcPrimCaps             D3DPRIMCAPS ? ;
D3DFINDDEVICESEARCH ENDS

D3DFINDDEVICERESULT STRUCT
d3dfinddeviceresult_dwSize                  DD ? ;
d3dfinddeviceresult_guid                    GUID ? ; guid which matched
d3dfinddeviceresult_ddHwDesc                D3DDEVICEDESC ? ; hardware D3DDEVICEDESC
d3dfinddeviceresult_ddSwDesc                D3DDEVICEDESC ? ; software D3DDEVICEDESC
D3DFINDDEVICERESULT ENDS

; Description of execute buffer.
D3DEXECUTEBUFFERDESC STRUCT
d3dexecutebufferdesc_dwSize                  DD ? ; size of this structure
d3dexecutebufferdesc_dwFlags                 DD ? ; flags indicating which fields are valid
d3dexecutebufferdesc_dwCaps                  DD ? ; capabilities of execute buffer
d3dexecutebufferdesc_dwBufferSize            DD ? ; size of execute buffer data
d3dexecutebufferdesc_lpData                  DD ? ; pointer to actual data
D3DEXECUTEBUFFERDESC ENDS


;===============================================================================
;                               FLAGS...
;===============================================================================

D3DTRANSFORMCAPS_CLIP       = 000000001h ; Will clip whilst transforming
D3DLIGHTINGMODEL_RGB        = 000000001h
D3DLIGHTINGMODEL_MONO       = 000000002h
D3DLIGHTCAPS_POINT          = 000000001h ; Point lights supported
D3DLIGHTCAPS_SPOT           = 000000002h ; Spot lights supported
D3DLIGHTCAPS_DIRECTIONAL    = 000000004h ; Directional lights supported
D3DLIGHTCAPS_PARALLELPOINT  = 000000008h ; Parallel point lights supported
D3DLIGHTCAPS_GLSPOT         = 000000010h ; GL syle spot lights supported

D3DPMISCCAPS_MASKPLANES        = 000000001h
D3DPMISCCAPS_MASKZ             = 000000002h
D3DPMISCCAPS_LINEPATTERNREP    = 000000004h
D3DPMISCCAPS_CONFORMANT        = 000000008h
D3DPMISCCAPS_CULLNONE          = 000000010h
D3DPMISCCAPS_CULLCW            = 000000020h
D3DPMISCCAPS_CULLCCW           = 000000040h

D3DPRASTERCAPS_DITHER          = 000000001h
D3DPRASTERCAPS_ROP2            = 000000002h
D3DPRASTERCAPS_XOR             = 000000004h
D3DPRASTERCAPS_PAT             = 000000008h
D3DPRASTERCAPS_ZTEST           = 000000010h
D3DPRASTERCAPS_SUBPIXEL        = 000000020h
D3DPRASTERCAPS_SUBPIXELX       = 000000040h
D3DPRASTERCAPS_FOGVERTEX       = 000000080h
D3DPRASTERCAPS_FOGTABLE        = 000000100h
D3DPRASTERCAPS_STIPPLE         = 000000200h
D3DPRASTERCAPS_ANTIALIASSORTDEPENDENT   = 00000400h;
D3DPRASTERCAPS_ANTIALIASSORTINDEPENDENT = 00000800h;
D3DPRASTERCAPS_ANTIALIASEDGES           = 00001000h;
D3DPRASTERCAPS_MIPMAPLODBIAS            = 00002000h;
D3DPRASTERCAPS_ZBIAS                    = 00004000h;
D3DPRASTERCAPS_ZBUFFERLESSHSR           = 00008000h;
D3DPRASTERCAPS_FOGRANGE                 = 00010000h;
D3DPRASTERCAPS_ANISOTROPY               = 00020000h;
D3DPRASTERCAPS_WBUFFER                      = 00040000h;
D3DPRASTERCAPS_TRANSLUCENTSORTINDEPENDENT   = 00080000h;
D3DPRASTERCAPS_WFOG                         = 00100000h;

D3DPCMPCAPS_NEVER              = 000000001h
D3DPCMPCAPS_LESS               = 000000002h
D3DPCMPCAPS_EQUAL              = 000000004h
D3DPCMPCAPS_LESSEQUAL          = 000000008h
D3DPCMPCAPS_GREATER            = 000000010h
D3DPCMPCAPS_NOTEQUAL           = 000000020h
D3DPCMPCAPS_GREATEREQUAL       = 000000040h
D3DPCMPCAPS_ALWAYS             = 000000080h

D3DPBLENDCAPS_ZERO             = 000000001h
D3DPBLENDCAPS_ONE              = 000000002h
D3DPBLENDCAPS_SRCCOLOR         = 000000004h
D3DPBLENDCAPS_INVSRCCOLOR      = 000000008h
D3DPBLENDCAPS_SRCALPHA         = 000000010h
D3DPBLENDCAPS_INVSRCALPHA      = 000000020h
D3DPBLENDCAPS_DESTALPHA        = 000000040h
D3DPBLENDCAPS_INVDESTALPHA     = 000000080h
D3DPBLENDCAPS_DESTCOLOR        = 000000100h
D3DPBLENDCAPS_INVDESTCOLOR     = 000000200h
D3DPBLENDCAPS_SRCALPHASAT      = 000000400h
D3DPBLENDCAPS_BOTHSRCALPHA     = 000000800h
D3DPBLENDCAPS_BOTHINVSRCALPHA  = 000001000h

D3DPSHADECAPS_COLORFLATMONO            = 000000001h
D3DPSHADECAPS_COLORFLATRGB             = 000000002h
D3DPSHADECAPS_COLORGOURAUDMONO         = 000000004h
D3DPSHADECAPS_COLORGOURAUDRGB          = 000000008h
D3DPSHADECAPS_COLORPHONGMONO           = 000000010h
D3DPSHADECAPS_COLORPHONGRGB            = 000000020h

D3DPSHADECAPS_SPECULARFLATMONO         = 000000040h
D3DPSHADECAPS_SPECULARFLATRGB          = 000000080h
D3DPSHADECAPS_SPECULARGOURAUDMONO      = 000000100h
D3DPSHADECAPS_SPECULARGOURAUDRGB       = 000000200h
D3DPSHADECAPS_SPECULARPHONGMONO        = 000000400h
D3DPSHADECAPS_SPECULARPHONGRGB         = 000000800h

D3DPSHADECAPS_ALPHAFLATBLEND           = 000001000h
D3DPSHADECAPS_ALPHAFLATSTIPPLED        = 000002000h
D3DPSHADECAPS_ALPHAGOURAUDBLEND        = 000004000h
D3DPSHADECAPS_ALPHAGOURAUDSTIPPLED     = 000008000h
D3DPSHADECAPS_ALPHAPHONGBLEND          = 000010000h
D3DPSHADECAPS_ALPHAPHONGSTIPPLED       = 000020000h

D3DPSHADECAPS_FOGFLAT                  = 000040000h
D3DPSHADECAPS_FOGGOURAUD               = 000080000h
D3DPSHADECAPS_FOGPHONG                 = 000100000h

D3DPTEXTURECAPS_PERSPECTIVE    = 000000001h
D3DPTEXTURECAPS_POW2           = 000000002h
D3DPTEXTURECAPS_ALPHA          = 000000004h
D3DPTEXTURECAPS_TRANSPARENCY   = 000000008h
D3DPTEXTURECAPS_BORDER         = 000000010h
D3DPTEXTURECAPS_SQUAREONLY     = 000000020h
D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE = 00000040h;
D3DPTEXTURECAPS_ALPHAPALETTE    = 00000080h;

D3DPTFILTERCAPS_NEAREST          = 000000001h
D3DPTFILTERCAPS_LINEAR           = 000000002h
D3DPTFILTERCAPS_MIPNEAREST       = 000000004h
D3DPTFILTERCAPS_MIPLINEAR        = 000000008h
D3DPTFILTERCAPS_LINEARMIPNEAREST = 000000010h
D3DPTFILTERCAPS_LINEARMIPLINEAR  = 000000020h

D3DPTFILTERCAPS_MINFPOINT       = 00000100h;
D3DPTFILTERCAPS_MINFLINEAR      = 00000200h;
D3DPTFILTERCAPS_MINFANISOTROPIC = 00000400h;

D3DPTFILTERCAPS_MIPFPOINT       = 00010000h;
D3DPTFILTERCAPS_MIPFLINEAR      = 00020000h;

D3DPTFILTERCAPS_MAGFPOINT         = 01000000h;
D3DPTFILTERCAPS_MAGFLINEAR        = 02000000h;
D3DPTFILTERCAPS_MAGFANISOTROPIC   = 04000000h;
D3DPTFILTERCAPS_MAGFAFLATCUBIC    = 08000000h;
D3DPTFILTERCAPS_MAGFGAUSSIANCUBIC = 010000000h;

D3DPTBLENDCAPS_DECAL           = 000000001h
D3DPTBLENDCAPS_MODULATE        = 000000002h
D3DPTBLENDCAPS_DECALALPHA      = 000000004h
D3DPTBLENDCAPS_MODULATEALPHA   = 000000008h
D3DPTBLENDCAPS_DECALMASK       = 000000010h
D3DPTBLENDCAPS_MODULATEMASK    = 000000020h
D3DPTBLENDCAPS_COPY            = 000000040h
D3DPTBLENDCAPS_ADD             = 000000080h;

D3DPTADDRESSCAPS_WRAP          = 000000001h
D3DPTADDRESSCAPS_MIRROR        = 000000002h
D3DPTADDRESSCAPS_CLAMP         = 000000004h
D3DPTADDRESSCAPS_BORDER        = 000000008h;
D3DPTADDRESSCAPS_INDEPENDENTUV = 000000010h;

D3DSTENCILCAPS_KEEP     = 00000001h;
D3DSTENCILCAPS_ZERO     = 00000002h;
D3DSTENCILCAPS_REPLACE  = 00000004h;
D3DSTENCILCAPS_INCRSAT  = 00000008h;
D3DSTENCILCAPS_DECRSAT  = 00000010h;
D3DSTENCILCAPS_INVERT   = 00000020h;
D3DSTENCILCAPS_INCR     = 00000040h;
D3DSTENCILCAPS_DECR     = 00000080h;

D3DTEXOPCAPS_DISABLE                    = 00000001h;
D3DTEXOPCAPS_SELECTARG1                 = 00000002h;
D3DTEXOPCAPS_SELECTARG2                 = 00000004h;
D3DTEXOPCAPS_MODULATE                   = 00000008h;
D3DTEXOPCAPS_MODULATE2X                 = 00000010h;
D3DTEXOPCAPS_MODULATE4X                 = 00000020h;
D3DTEXOPCAPS_ADD                        = 00000040h;
D3DTEXOPCAPS_ADDSIGNED                  = 00000080h;
D3DTEXOPCAPS_ADDSIGNED2X                = 00000100h;
D3DTEXOPCAPS_SUBTRACT                   = 00000200h;
D3DTEXOPCAPS_ADDSMOOTH                  = 00000400h;
D3DTEXOPCAPS_BLENDDIFFUSEALPHA          = 00000800h;
D3DTEXOPCAPS_BLENDTEXTUREALPHA          = 00001000h;
D3DTEXOPCAPS_BLENDFACTORALPHA           = 00002000h;
D3DTEXOPCAPS_BLENDTEXTUREALPHAPM        = 00004000h;
D3DTEXOPCAPS_BLENDCURRENTALPHA          = 00008000h;
D3DTEXOPCAPS_PREMODULATE                = 00010000h;
D3DTEXOPCAPS_MODULATEALPHA_ADDCOLOR     = 00020000h;
D3DTEXOPCAPS_MODULATECOLOR_ADDALPHA     = 00040000h;
D3DTEXOPCAPS_MODULATEINVALPHA_ADDCOLOR  = 00080000h;
D3DTEXOPCAPS_MODULATEINVCOLOR_ADDALPHA  = 00100000h;
D3DTEXOPCAPS_BUMPENVMAP                 = 00200000h;
D3DTEXOPCAPS_BUMPENVMAPLUMINANCE        = 00400000h;
D3DTEXOPCAPS_DOTPRODUCT3                = 00800000h;

D3DFVFCAPS_TEXCOORDCOUNTMASK    = 0000ffffh ; mask for texture coordinate count field
D3DFVFCAPS_DONOTSTRIPELEMENTS   = 00080000h ; Device prefers that vertex elements not be stripped

D3DDD_COLORMODEL            = 000000001h ; dcmColorModel is valid
D3DDD_DEVCAPS               = 000000002h ; dwDevCaps is valid
D3DDD_TRANSFORMCAPS         = 000000004h ; dtcTransformCaps is valid
D3DDD_LIGHTINGCAPS          = 000000008h ; dlcLightingCaps is valid
D3DDD_BCLIPPING             = 000000010h ; bClipping is valid
D3DDD_LINECAPS              = 000000020h ; dpcLineCaps is valid
D3DDD_TRICAPS               = 000000040h ; dpcTriCaps is valid
D3DDD_DEVICERENDERBITDEPTH  = 000000080h ; dwDeviceRenderBitDepth is valid
D3DDD_DEVICEZBUFFERBITDEPTH = 000000100h ; dwDeviceZBufferBitDepth is valid
D3DDD_MAXBUFFERSIZE         = 000000200h ; dwMaxBufferSize is valid
D3DDD_MAXVERTEXCOUNT        = 000000400h ; dwMaxVertexCount is valid

D3DDEVCAPS_FLOATTLVERTEX        = 000000001h ; Device accepts floating point  for post-transform vertex data

D3DDEVCAPS_SORTINCREASINGZ      = 000000002h ; Device needs data sorted for increasing Z
D3DDEVCAPS_SORTDECREASINGZ      = 000000004h ; Device needs data sorted for decreasing Z
D3DDEVCAPS_SORTEXACT            = 000000008h ; Device needs data sorted exactly

D3DDEVCAPS_EXECUTESYSTEMMEMORY  = 000000010h ; Device can use execute buffers from system memory
D3DDEVCAPS_EXECUTEVIDEOMEMORY   = 000000020h ; Device can use execute buffers from video memory
D3DDEVCAPS_TLVERTEXSYSTEMMEMORY = 000000040h ; Device can use TL buffers from system memory
D3DDEVCAPS_TLVERTEXVIDEOMEMORY  = 000000080h ; Device can use TL buffers from video memory 
D3DDEVCAPS_TEXTURESYSTEMMEMORY  = 000000100h ; Device can texture from system memory
D3DDEVCAPS_TEXTUREVIDEOMEMORY   = 000000200h ; Device can texture from device memory
D3DDEVCAPS_DRAWPRIMTLVERTEX     = 000000400h ; Device can draw TLVERTEX primitives
D3DDEVCAPS_CANRENDERAFTERFLIP   = 000000800h ; Device can render without waiting for flip to complete
D3DDEVCAPS_TEXTURENONLOCALVIDMEM = 00001000h ; Device can texture from nonlocal video memory 
D3DDEVCAPS_DRAWPRIMITIVES2      = 000002000h ; Device can support DrawPrimitives2
D3DDEVCAPS_SEPARATETEXTUREMEMORIES = 00004000h;Device is texturing from separate memory pools

D3DFDS_COLORMODEL           = 000000001h ; Match color model
D3DFDS_GUID                 = 000000002h ; Match guid
D3DFDS_HARDWARE             = 000000004h ; Match hardware/software
D3DFDS_TRIANGLES            = 000000008h ; Match in triCaps
D3DFDS_LINES                = 000000010h ; Match in lineCaps
D3DFDS_MISCCAPS             = 000000020h ; Match primCaps.dwMiscCaps
D3DFDS_RASTERCAPS           = 000000040h ; Match primCaps.dwRasterCaps
D3DFDS_ZCMPCAPS             = 000000080h ; Match primCaps.dwZCmpCaps
D3DFDS_ALPHACMPCAPS         = 000000100h ; Match primCaps.dwAlphaCmpCaps
D3DFDS_SRCBLENDCAPS         = 000000200h ; Match primCaps.dwSourceBlendCaps
D3DFDS_DSTBLENDCAPS         = 000000400h ; Match primCaps.dwDestBlendCaps
D3DFDS_SHADECAPS            = 000000800h ; Match primCaps.dwShadeCaps
D3DFDS_TEXTURECAPS          = 000001000h ; Match primCaps.dwTextureCaps
D3DFDS_TEXTUREFILTERCAPS    = 000002000h ; Match primCaps.dwTextureFilterCaps 
D3DFDS_TEXTUREBLENDCAPS     = 000004000h ; Match primCaps.dwTextureBlendCaps
D3DFDS_TEXTUREADDRESSCAPS   = 000008000h ; Match primCaps.dwTextureBlendCaps

D3DDEB_BUFSIZE         = 000000001h ; buffer size valid
D3DDEB_CAPS            = 000000002h ; caps valid
D3DDEB_LPDATA          = 000000004h ; lpData valid

D3DDEBCAPS_SYSTEMMEMORY = 000000001h ; buffer in system memory
D3DDEBCAPS_VIDEOMEMORY  = 000000002h ; buffer in device memory
D3DDEBCAPS_MEM      = D3DDEBCAPS_SYSTEMMEMORY + D3DDEBCAPS_VIDEOMEMORY

;end of file
