; td3dcaps.inc  (c) Minde  06/08/99 montana@is.lt
; Content:  TASM Direct3D types include file ver. 1.2
; converted from d3dtypes.h, DX ver. 6.1
;
;  Feel free to use or distribute the package, part or whole, for any
; non-commercial use preferably crediting me.
;  Also feel free to contact me at the above address if you experience any
; problems or notice any omissions.

; Format of CI colors is
;  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;  |    alpha      |         color index           |   fraction    |
;  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

; Format of RGBA colors is
;  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;  |    alpha      |      red      |     green     |     blue      |
;  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

; Format of RGB colors is
;  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
;  |    ignored    |      red      |     green     |     blue      |
;  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

;Flags for Enumerate functions
D3DENUMRET_CANCEL                       = DDENUMRET_CANCEL
D3DENUMRET_OK                           = DDENUMRET_OK

D3DVALUE        typedef REAL4
D3DFIXED        typedef SDWORD
D3DCOLOR        typedef DWORD
D3DMATERIALHANDLE   typedef DWORD 
D3DTEXTUREHANDLE    typedef DWORD 
D3DMATRIXHANDLE     typedef DWORD 


D3DCOLORVALUE STRUCT
    union
d3dcolorvalue_r       D3DVALUE ? ;
d3dcolorvalue_dvR     D3DVALUE ? ;
    ends
    union
d3dcolorvalue_g       D3DVALUE ? ;
d3dcolorvalue_dvG     D3DVALUE ? ;
    ends
    union
d3dcolorvalue_b       D3DVALUE ? ;
d3dcolorvalue_dvB     D3DVALUE ? ;
    ends
    union
d3dcolorvalue_a       D3DVALUE ? ;
d3dcolorvalue_dvA     D3DVALUE ? ;
 ends
D3DCOLORVALUE ENDS

D3DRECT STRUCT
    union
d3drect_x1      DD ? ;
d3drect_lX1     DD ? ;
    ends
    union
d3drect_y1      DD ? ;
d3drect_lY1     DD ? ;
    ends
    union
d3drect_x2      DD ? ;
d3drect_lX2     DD ? ;
    ends
    union
d3drect_y2      DD ? ;
d3drect_lY2     DD ? ;
 ends
D3DRECT ENDS

D3DVECTOR STRUCT
    union
d3dvector_x       D3DVALUE ? ;
d3dvector_dvX     D3DVALUE ? ;
    ends
    union
d3dvector_y       D3DVALUE ? ;
d3dvector_dvY     D3DVALUE ? ;
    ends
    union
d3dvector_z       D3DVALUE ? ;
d3dvector_dvZ     D3DVALUE ? ;
    ends
D3DVECTOR ENDS


D3DHVERTEX STRUCT
d3dhvertex_dwFlags     DD ? ; Homogeneous clipping flags
    union
d3dhvertex_hx          D3DVALUE ? ;
d3dhvertex_dvHX        D3DVALUE ? ;
    ends
    union
d3dhvertex_hy          D3DVALUE ? ;
d3dhvertex_dvHY        D3DVALUE ? ;
    ends
    union
d3dhvertex_hz          D3DVALUE ? ;
d3dhvertex_dvHZ        D3DVALUE ? ;
    ends
D3DHVERTEX ENDS


D3DTLVERTEX STRUCT
    union
d3dtlvertex_sx          D3DVALUE ? ; Screen coordinates
d3dtlvertex_dvSX        D3DVALUE ? ;
    ends
    union
d3dtlvertex_sy          D3DVALUE ? ;
d3dtlvertex_dvSY        D3DVALUE ? ;
    ends
    union
d3dtlvertex_sz          D3DVALUE ? ;
d3dtlvertex_dvSZ        D3DVALUE ? ;
    ends
    union
d3dtlvertex_rhw         D3DVALUE ? ; Reciprocal of homogeneous w
d3dtlvertex_dvRHW       D3DVALUE ? ;
    ends
    union
d3dtlvertex_color       D3DCOLOR ? ; Vertex color
d3dtlvertex_dcColor     D3DCOLOR ? ;
    ends
    union
d3dtlvertex_specular    D3DCOLOR ? ; Specular component of vertex
d3dtlvertex_dcSpecular  D3DCOLOR ? ;
    ends
    union
d3dtlvertex_tu          D3DVALUE ? ; Texture coordinates
d3dtlvertex_dvTU        D3DVALUE ? ;
    ends
    union
d3dtlvertex_tv          D3DVALUE ? ;
d3dtlvertex_dvTV        D3DVALUE ? ;
    ends
D3DTLVERTEX ENDS


D3DLVERTEX STRUCT
    union
d3dlvertex_x       D3DVALUE ? ; Homogeneous coordinates
d3dlvertex_dvX     D3DVALUE ? ;
    ends
    union
d3dlvertex_y       D3DVALUE ? ;
d3dlvertex_dvY     D3DVALUE ? ;
    ends
    union
d3dlvertex_z       D3DVALUE ? ;
d3dlvertex_dvZ     D3DVALUE ? ;
    ends
d3dlvertex_dwReserved  DD ? ;
    union
d3dlvertex_color       D3DCOLOR ? ; Vertex color
d3dlvertex_dcColor     D3DCOLOR ? ;
    ends
    union
d3dlvertex_specular    D3DCOLOR ? ; Specular component of vertex
d3dlvertex_dcSpecular  D3DCOLOR ? ;
    ends
    union
d3dlvertex_tu          D3DVALUE ? ; Texture coordinates
d3dlvertex_dvTU        D3DVALUE ? ;
    ends
    union
d3dlvertex_tv          D3DVALUE ? ;
d3dlvertex_dvTV        D3DVALUE ? ;
    ends
D3DLVERTEX ENDS


D3DVERTEX STRUCT
    union
d3dvertex_x           D3DVALUE ? ; Homogeneous coordinates
d3dvertex_dvX         D3DVALUE ? ;
    ends
    union
d3dvertex_y           D3DVALUE ? ;
d3dvertex_dvY         D3DVALUE ? ;
    ends
    union
d3dvertex_z           D3DVALUE ? ;
d3dvertex_dvZ         D3DVALUE ? ;
    ends
    union
d3dvertex_nx          D3DVALUE ? ; Normal
d3dvertex_dvNX        D3DVALUE ? ;
    ends
    union
d3dvertex_ny          D3DVALUE ? ;
d3dvertex_dvNY        D3DVALUE ? ;
    ends
    union
d3dvertex_nz          D3DVALUE ? ;
d3dvertex_dvNZ        D3DVALUE ? ;
    ends
    union
d3dvertex_tu          D3DVALUE ? ; Texture coordinates
d3dvertex_dvTU        D3DVALUE ? ;
    ends
    union
d3dvertex_tv          D3DVALUE ? ;
d3dvertex_dvTV        D3DVALUE ? ;
    ends
D3DVERTEX ENDS

D3DMATRIX STRUCT ; THIS IS ONLY STRUCT WHIT NOT MODIFIED MEMBER NAMES
_11 D3DVALUE ? ;
_12 D3DVALUE ? ;
_13 D3DVALUE ? ;
_14 D3DVALUE ? ;
_21 D3DVALUE ? ;
_22 D3DVALUE ? ;
_23 D3DVALUE ? ;
_24 D3DVALUE ? ;
_31 D3DVALUE ? ;
_32 D3DVALUE ? ;
_33 D3DVALUE ? ;
_34 D3DVALUE ? ;
_41 D3DVALUE ? ;
_42 D3DVALUE ? ;
_43 D3DVALUE ? ;
_44 D3DVALUE ? ;
D3DMATRIX ENDS

D3DVIEWPORT STRUCT
d3dviewport_dwSize      DD ? ;
d3dviewport_dwX         DD ? ;
d3dviewport_dwY         DD ? ; Top left
d3dviewport_dwWidth     DD ? ;
d3dviewport_dwHeight    DD ? ; Dimensions
d3dviewport_dvScaleX    D3DVALUE ? ; Scale homogeneous to screen
d3dviewport_dvScaleY    D3DVALUE ? ; Scale homogeneous to screen
d3dviewport_dvMaxX      D3DVALUE ? ; Min/max homogeneous x coord
d3dviewport_dvMaxY      D3DVALUE ? ; Min/max homogeneous y coord
d3dviewport_dvMinZ      D3DVALUE ? ;
d3dviewport_dvMaxZ      D3DVALUE ? ; Min/max homogeneous z coord
D3DVIEWPORT ENDS

D3DVIEWPORT2 STRUCT
d3dviewport2_dwSize          DD ? ;
d3dviewport2_dwX             DD ? ;
d3dviewport2_dwY             DD ? ; Viewport Top left
d3dviewport2_dwWidth         DD ? ;
d3dviewport2_dwHeight        DD ? ; Viewport Dimensions
d3dviewport2_dvClipX         D3DVALUE ? ; Top left of clip volume
d3dviewport2_dvClipY         D3DVALUE ? ;
d3dviewport2_dvClipWidth     D3DVALUE ? ; Clip Volume Dimensions
d3dviewport2_dvClipHeight    D3DVALUE ? ;
d3dviewport2_dvMinZ          D3DVALUE ? ; Min/max of clip Volume
d3dviewport2_dvMaxZ          D3DVALUE ? ;
D3DVIEWPORT2 ENDS

;Values for clip fields.
D3DCLIP_LEFT                           = 000000001h
D3DCLIP_RIGHT                          = 000000002h
D3DCLIP_TOP                            = 000000004h
D3DCLIP_BOTTOM                         = 000000008h
D3DCLIP_FRONT                          = 000000010h
D3DCLIP_BACK                           = 000000020h
D3DCLIP_GEN0                           = 000000040h
D3DCLIP_GEN1                           = 000000080h
D3DCLIP_GEN2                           = 000000100h
D3DCLIP_GEN3                           = 000000200h
D3DCLIP_GEN4                           = 000000400h
D3DCLIP_GEN5                           = 000000800h

;Values for d3d status.
D3DSTATUS_CLIPUNIONLEFT                = D3DCLIP_LEFT
D3DSTATUS_CLIPUNIONRIGHT               = D3DCLIP_RIGHT
D3DSTATUS_CLIPUNIONTOP                 = D3DCLIP_TOP
D3DSTATUS_CLIPUNIONBOTTOM              = D3DCLIP_BOTTOM
D3DSTATUS_CLIPUNIONFRONT               = D3DCLIP_FRONT
D3DSTATUS_CLIPUNIONBACK                = D3DCLIP_BACK
D3DSTATUS_CLIPUNIONGEN0                = D3DCLIP_GEN0
D3DSTATUS_CLIPUNIONGEN1                = D3DCLIP_GEN1
D3DSTATUS_CLIPUNIONGEN2                = D3DCLIP_GEN2
D3DSTATUS_CLIPUNIONGEN3                = D3DCLIP_GEN3
D3DSTATUS_CLIPUNIONGEN4                = D3DCLIP_GEN4
D3DSTATUS_CLIPUNIONGEN5                = D3DCLIP_GEN5
D3DSTATUS_CLIPINTERSECTIONLEFT         = 000001000h
D3DSTATUS_CLIPINTERSECTIONRIGHT        = 000002000h
D3DSTATUS_CLIPINTERSECTIONTOP          = 000004000h
D3DSTATUS_CLIPINTERSECTIONBOTTOM       = 000008000h
D3DSTATUS_CLIPINTERSECTIONFRONT        = 000010000h
D3DSTATUS_CLIPINTERSECTIONBACK         = 000020000h
D3DSTATUS_CLIPINTERSECTIONGEN0         = 000040000h
D3DSTATUS_CLIPINTERSECTIONGEN1         = 000080000h
D3DSTATUS_CLIPINTERSECTIONGEN2         = 000100000h
D3DSTATUS_CLIPINTERSECTIONGEN3         = 000200000h
D3DSTATUS_CLIPINTERSECTIONGEN4         = 000400000h
D3DSTATUS_CLIPINTERSECTIONGEN5         = 000800000h
D3DSTATUS_ZNOTVISIBLE                  = 001000000h
D3DSTATUS_CLIPUNIONALL = D3DSTATUS_CLIPUNIONLEFT + D3DSTATUS_CLIPUNIONRIGHT +\
            D3DSTATUS_CLIPUNIONTOP + D3DSTATUS_CLIPUNIONBOTTOM +\
            D3DSTATUS_CLIPUNIONFRONT + D3DSTATUS_CLIPUNIONBACK +\
            D3DSTATUS_CLIPUNIONGEN0 + D3DSTATUS_CLIPUNIONGEN1 +\
            D3DSTATUS_CLIPUNIONGEN2 + D3DSTATUS_CLIPUNIONGEN3 +\
            D3DSTATUS_CLIPUNIONGEN4 + D3DSTATUS_CLIPUNIONGEN5
D3DSTATUS_CLIPINTERSECTIONALL = D3DSTATUS_CLIPINTERSECTIONLEFT +\
    D3DSTATUS_CLIPINTERSECTIONRIGHT + D3DSTATUS_CLIPINTERSECTIONTOP +\
    D3DSTATUS_CLIPINTERSECTIONBOTTOM + D3DSTATUS_CLIPINTERSECTIONFRONT +\
    D3DSTATUS_CLIPINTERSECTIONBACK + D3DSTATUS_CLIPINTERSECTIONGEN0 +\
    D3DSTATUS_CLIPINTERSECTIONGEN1 + D3DSTATUS_CLIPINTERSECTIONGEN2 +\
    D3DSTATUS_CLIPINTERSECTIONGEN3 + D3DSTATUS_CLIPINTERSECTIONGEN4 +\
    D3DSTATUS_CLIPINTERSECTIONGEN5
D3DSTATUS_DEFAULT = D3DSTATUS_CLIPINTERSECTIONALL + D3DSTATUS_ZNOTVISIBLE



D3DTRANSFORM_CLIPPED      = 000000001h
D3DTRANSFORM_UNCLIPPED    = 000000002h

D3DTRANSFORMDATA STRUCT
d3dtransformdata_dwSize              DD ? ;
d3dtransformdata_lpIn                DD ? ; Input vertices
d3dtransformdata_dwInSize            DD ? ; Stride of input vertices
d3dtransformdata_lpOut               DD ? ; Output vertices
d3dtransformdata_dwOutSize           DD ? ; Stride of output vertices
d3dtransformdata_lpHOut              DD ? ; Output homogeneous vertices
d3dtransformdata_dwClip              DD ? ; Clipping hint
d3dtransformdata_dwClipIntersection  DD ? ;
d3dtransformdata_dwClipUnion         DD ? ; Union of all clip flags
d3dtransformdata_drExtent            D3DRECT ? ; Extent of transformed vertices
D3DTRANSFORMDATA ENDS

D3DLIGHTINGELEMENT STRUCT
d3dlightingelement_dvPosition          D3DVECTOR ? ; Lightable point in model space
d3dlightingelement_dvNormal            D3DVECTOR ? ; Normalised unit vector
D3DLIGHTINGELEMENT ENDS

D3DMATERIAL STRUCT
d3dmaterial_dwSize      DD ? ;
    union
d3dmaterial_diffuse     D3DCOLORVALUE ? ; Diffuse color RGBA
d3dmaterial_dcvDiffuse  D3DCOLORVALUE ? ;
    ends
    union
d3dmaterial_ambient     D3DCOLORVALUE ? ; Ambient color RGB
d3dmaterial_dcvAmbient  D3DCOLORVALUE ? ;
    ends
    union
d3dmaterial_specular    D3DCOLORVALUE ? ; Specular 'shininess'
d3dmaterial_dcvSpecular D3DCOLORVALUE ? ;
    ends
    union
d3dmaterial_emissive    D3DCOLORVALUE ? ; Emissive color RGB
d3dmaterial_dcvEmissive D3DCOLORVALUE ? ;
    ends
    union
d3dmaterial_power       D3DVALUE ? ; Sharpness if specular highlight
d3dmaterial_dvPower     D3DVALUE ? ;
    ends
d3dmaterial_hTexture    D3DTEXTUREHANDLE ? ; Handle to texture map
d3dmaterial_dwRampSize  DD ? ;
D3DMATERIAL ENDS

D3DLIGHTTYPE enum D3DLIGHT_POINT = 1, D3DLIGHT_SPOT = 2, \
D3DLIGHT_DIRECTIONAL = 3, D3DLIGHT_PARALLELPOINT = 4, D3DLIGHT_GLSPOT = 5


D3DLIGHT STRUCT
d3dlight_dwSize          DD ? ;
d3dlight_dltType         D3DLIGHTTYPE    ? ; Type of light source
d3dlight_dcvColor        D3DCOLORVALUE   ? ; Color of light
d3dlight_dvPosition      D3DVECTOR   ? ; Position in world space
d3dlight_dvDirection     D3DVECTOR   ? ; Direction in world space
d3dlight_dvRange         D3DVALUE    ? ; Cutoff range
d3dlight_dvFalloff       D3DVALUE    ? ; Falloff
d3dlight_dvAttenuation0  D3DVALUE    ? ; Constant attenuation
d3dlight_dvAttenuation1  D3DVALUE    ? ; Linear attenuation
d3dlight_dvAttenuation2  D3DVALUE    ? ; Quadratic attenuation
d3dlight_dvTheta         D3DVALUE    ? ; Inner angle of spotlight cone
d3dlight_dvPhi           D3DVALUE    ? ; Outer angle of spotlight cone
D3DLIGHT ENDS


D3DLIGHT_ACTIVE         = 00000001h;
D3DLIGHT_NO_SPECULAR    = 00000002h;

; maximum valid light range
D3DLIGHT_RANGE_MAX      equ <19.8439088915f>

D3DLIGHT2 STRUCT
d3dlight2_dwSize          DD ? ;
d3dlight2_dltType         D3DLIGHTTYPE    ? ; Type of light source
d3dlight2_dcvColor        D3DCOLORVALUE   ? ; Color of light
d3dlight2_dvPosition      D3DVECTOR   ? ; Position in world space
d3dlight2_dvDirection     D3DVECTOR   ? ; Direction in world space
d3dlight2_dvRange         D3DVALUE    ? ; Cutoff range
d3dlight2_dvFalloff       D3DVALUE    ? ; Falloff
d3dlight2_dvAttenuation0  D3DVALUE    ? ; Constant attenuation
d3dlight2_dvAttenuation1  D3DVALUE    ? ; Linear attenuation
d3dlight2_dvAttenuation2  D3DVALUE    ? ; Quadratic attenuation
d3dlight2_dvTheta         D3DVALUE    ? ; Inner angle of spotlight cone
d3dlight2_dvPhi           D3DVALUE    ? ; Outer angle of spotlight cone
d3dlight2_dwFlags         DD ? ;
D3DLIGHT2 ENDS

D3DLIGHTDATA STRUCT
d3dlightdata_dwSize          DD ? ;
d3dlightdata_lpIn            DD ? ; Input positions and normals
d3dlightdata_dwInSize        DD ? ; Stride of input elements
d3dlightdata_lpOut           DD ? ; Output colors
d3dlightdata_dwOutSize       DD ? ; Stride of output colors
D3DLIGHTDATA ENDS

D3DCOLORMODEL enum D3DCOLOR_MONO = 1, D3DCOLOR_RGB = 2

D3DCLEAR_TARGET           = 000000001h ; Clear target surface
D3DCLEAR_ZBUFFER          = 000000002h ; Clear target z buffer
D3DCLEAR_STENCIL          = 000000004h ; Clear stencil planes

D3DOPCODE enum D3DOP_POINT = 1, D3DOP_LINE = 2, D3DOP_TRIANGLE = 3, \
    D3DOP_MATRIXLOAD = 4, D3DOP_MATRIXMULTIPLY = 5, \
    D3DOP_STATETRANSFORM = 6, D3DOP_STATELIGHT = 7, \
    D3DOP_STATERENDER = 8, D3DOP_PROCESSVERTICES = 9, \
    D3DOP_TEXTURELOAD = 10, D3DOP_EXIT = 11, D3DOP_BRANCHFORWARD = 12, \
    D3DOP_SPAN = 13, D3DOP_SETSTATUS = 14

D3DINSTRUCTION STRUCT
d3dinstruction_bOpcode         DB ? ; Instruction opcode
d3dinstruction_bSize           DB ? ; Size of each instruction data unit
d3dinstruction_wCount          DW ? ; Count of instruction data units to follow 
D3DINSTRUCTION ENDS

D3DTEXTURELOAD STRUCT
d3dtextureload_hDestTexture    D3DTEXTUREHANDLE ? ;
d3dtextureload_hSrcTexture     D3DTEXTUREHANDLE ? ;
D3DTEXTURELOAD ENDS

D3DPICKRECORD struct
d3dpickrecord_bOpcode         DB ? ;
d3dpickrecord_bPad            DB ? ;
d3dpickrecord_dwOffset        DW ? ;
d3dpickrecord_dvZ             D3DVALUE ? ;
D3DPICKRECORD ends

D3DSHADEMODE enum D3DSHADE_FLAT = 1, D3DSHADE_GOURAUD = 2, D3DSHADE_PHONG = 3
D3DFILLMODE  enum D3DFILL_POINT = 1, D3DFILL_WIREFRAME = 2, D3DFILL_SOLID = 3

D3DLINEPATTERN STRUCT
d3dlinepattern_wRepeatFactor   DW ? ;
d3dlinepattern_wLinePattern    DW ? ;
D3DLINEPATTERN ENDS


D3DTEXTUREFILTER enum D3DFILTER_NEAREST = 1, D3DFILTER_LINEAR = 2, \
    D3DFILTER_MIPNEAREST = 3, D3DFILTER_MIPLINEAR = 4, \
    D3DFILTER_LINEARMIPNEAREST = 5, D3DFILTER_LINEARMIPLINEAR = 6

D3DBLEND enum D3DBLEND_ZERO = 1, D3DBLEND_ONE = 2, D3DBLEND_SRCCOLOR = 3, \
    D3DBLEND_INVSRCCOLOR = 4, D3DBLEND_SRCALPHA = 5, \
    D3DBLEND_INVSRCALPHA = 6, D3DBLEND_DESTALPHA = 7, \
    D3DBLEND_INVDESTALPHA = 8, D3DBLEND_DESTCOLOR = 9, \
    D3DBLEND_INVDESTCOLOR = 10, D3DBLEND_SRCALPHASAT = 11, \
    D3DBLEND_BOTHSRCALPHA = 12, D3DBLEND_BOTHINVSRCALPHA = 13

D3DTEXTUREBLEND enum D3DTBLEND_DECAL = 1, D3DTBLEND_MODULATE = 2, \
    D3DTBLEND_DECALALPHA = 3, D3DTBLEND_MODULATEALPHA = 4, \
    D3DTBLEND_DECALMASK = 5, D3DTBLEND_MODULATEMASK = 6, \
    D3DTBLEND_COPY = 7

D3DTEXTUREADDRESS enum D3DTADDRESS_WRAP = 1, D3DTADDRESS_MIRROR = 2, \
    D3DTADDRESS_CLAMP = 3

D3DCULL enum D3DCULL_NONE = 1, D3DCULL_CW = 2, D3DCULL_CCW = 3

D3DCMPFUNC enum D3DCMP_NEVER = 1, D3DCMP_LESS = 2, D3DCMP_EQUAL = 3, \
    D3DCMP_LESSEQUAL = 4, D3DCMP_GREATER = 5, D3DCMP_NOTEQUAL = 6, \
    D3DCMP_GREATEREQUAL = 7, D3DCMP_ALWAYS = 8

D3DSTENCILOP enum D3DSTENCILOP_KEEP = 1, D3DSTENCILOP_ZERO           = 2, \
    D3DSTENCILOP_REPLACE = 3, D3DSTENCILOP_INCRSAT = 4, D3DSTENCILOP_DECRSAT = 5, \
    D3DSTENCILOP_INVERT = 6, D3DSTENCILOP_INCR = 7, D3DSTENCILOP_DECR = 8

D3DFOGMODE enum D3DFOG_NONE = 0, D3DFOG_EXP = 1, D3DFOG_EXP2 = 2, \
    D3DFOG_LINEAR = 3

D3DZBUFFERTYPE enum D3DZB_FALSE = 0, D3DZB_TRUE = 1, D3DZB_USEW = 2

D3DANTIALIASMODE enum D3DANTIALIAS_NONE = 0, D3DANTIALIAS_SORTDEPENDENT = 1, \
    D3DANTIALIAS_SORTINDEPENDENT = 2

D3DVERTEXTYPE enum D3DVT_VERTEX = 1, D3DVT_LVERTEX = 2, D3DVT_TLVERTEX = 3

D3DPRIMITIVETYPE enum D3DPT_POINTLIST = 1, D3DPT_LINELIST = 2, \
    D3DPT_LINESTRIP = 3, D3DPT_TRIANGLELIST = 4, D3DPT_TRIANGLESTRIP = 5, \
    D3DPT_TRIANGLEFAN = 6

D3DSTATE_OVERRIDE_BIAS         = 256

D3DTRANSFORMSTATETYPE enum D3DTRANSFORMSTATE_WORLD = 1, \
    D3DTRANSFORMSTATE_VIEW = 2, D3DTRANSFORMSTATE_PROJECTION = 3

D3DLIGHTSTATETYPE enum D3DLIGHTSTATE_MATERIAL = 1, D3DLIGHTSTATE_AMBIENT = 2, \
    D3DLIGHTSTATE_COLORMODEL = 3, D3DLIGHTSTATE_FOGMODE = 4, \
    D3DLIGHTSTATE_FOGSTART = 5, D3DLIGHTSTATE_FOGEND = 6, \
    D3DLIGHTSTATE_FOGDENSITY = 7

;
; D3DRENDERSTATETYPE enum: THIS ENUM CONVERTED TO CONSTANTS :-<
; 
D3DRENDERSTATETYPE typedef DWORD
D3DRENDERSTATE_TEXTUREHANDLE      = 1
D3DRENDERSTATE_ANTIALIAS          = 2
D3DRENDERSTATE_TEXTUREADDRESS     = 3
D3DRENDERSTATE_TEXTUREPERSPECTIVE = 4
D3DRENDERSTATE_WRAPU              = 5
D3DRENDERSTATE_WRAPV              = 6
D3DRENDERSTATE_ZENABLE            = 7
D3DRENDERSTATE_FILLMODE           = 8
D3DRENDERSTATE_SHADEMODE          = 9
D3DRENDERSTATE_LINEPATTERN        = 10
D3DRENDERSTATE_MONOENABLE         = 11
D3DRENDERSTATE_ROP2               = 12
D3DRENDERSTATE_PLANEMASK          = 13
D3DRENDERSTATE_ZWRITEENABLE       = 14
D3DRENDERSTATE_ALPHATESTENABLE    = 15
D3DRENDERSTATE_LASTPIXEL          = 16
D3DRENDERSTATE_TEXTUREMAG         = 17
D3DRENDERSTATE_TEXTUREMIN         = 18
D3DRENDERSTATE_SRCBLEND           = 19
D3DRENDERSTATE_DESTBLEND          = 20
D3DRENDERSTATE_TEXTUREMAPBLEND    = 21
D3DRENDERSTATE_CULLMODE           = 22
D3DRENDERSTATE_ZFUNC              = 23
D3DRENDERSTATE_ALPHAREF           = 24
D3DRENDERSTATE_ALPHAFUNC          = 25
D3DRENDERSTATE_DITHERENABLE       = 26
D3DRENDERSTATE_ALPHABLENDENABLE   = 27
D3DRENDERSTATE_FOGENABLE          = 28
D3DRENDERSTATE_SPECULARENABLE     = 29
D3DRENDERSTATE_ZVISIBLE           = 30
D3DRENDERSTATE_SUBPIXEL           = 31
D3DRENDERSTATE_SUBPIXELX          = 32
D3DRENDERSTATE_STIPPLEDALPHA      = 33
D3DRENDERSTATE_FOGCOLOR           = 34
D3DRENDERSTATE_FOGTABLEMODE       = 35
D3DRENDERSTATE_FOGTABLESTART      = 36
D3DRENDERSTATE_FOGTABLEEND        = 37
D3DRENDERSTATE_FOGTABLEDENSITY    = 38
D3DRENDERSTATE_STIPPLEENABLE      = 39
D3DRENDERSTATE_EDGEANTIALIAS      = 40
D3DRENDERSTATE_COLORKEYENABLE     = 41
D3DRENDERSTATE_BORDERCOLOR        = 43
D3DRENDERSTATE_TEXTUREADDRESSU    = 44
D3DRENDERSTATE_TEXTUREADDRESSV    = 45
D3DRENDERSTATE_MIPMAPLODBIAS      = 46
D3DRENDERSTATE_ZBIAS              = 47
D3DRENDERSTATE_RANGEFOGENABLE     = 48
D3DRENDERSTATE_ANISOTROPY         = 49
D3DRENDERSTATE_FLUSHBATCH         = 50
D3DRENDERSTATE_TRANSLUCENTSORTINDEPENDENT = 51
D3DRENDERSTATE_STENCILENABLE      = 52
D3DRENDERSTATE_STENCILFAIL        = 53
D3DRENDERSTATE_STENCILZFAIL       = 54
D3DRENDERSTATE_STENCILPASS        = 55
D3DRENDERSTATE_STENCILFUNC        = 56
D3DRENDERSTATE_STENCILREF         = 57
D3DRENDERSTATE_STENCILMASK        = 58
D3DRENDERSTATE_STENCILWRITEMASK   = 59
D3DRENDERSTATE_TEXTUREFACTOR      = 60
D3DRENDERSTATE_STIPPLEPATTERN00   = 64
D3DRENDERSTATE_STIPPLEPATTERN01   = 65
D3DRENDERSTATE_STIPPLEPATTERN02   = 66
D3DRENDERSTATE_STIPPLEPATTERN03   = 67
D3DRENDERSTATE_STIPPLEPATTERN04   = 68
D3DRENDERSTATE_STIPPLEPATTERN05   = 69
D3DRENDERSTATE_STIPPLEPATTERN06   = 70
D3DRENDERSTATE_STIPPLEPATTERN07   = 71
D3DRENDERSTATE_STIPPLEPATTERN08   = 72
D3DRENDERSTATE_STIPPLEPATTERN09   = 73
D3DRENDERSTATE_STIPPLEPATTERN10   = 74
D3DRENDERSTATE_STIPPLEPATTERN11   = 75
D3DRENDERSTATE_STIPPLEPATTERN12   = 76
D3DRENDERSTATE_STIPPLEPATTERN13   = 77
D3DRENDERSTATE_STIPPLEPATTERN14   = 78
D3DRENDERSTATE_STIPPLEPATTERN15   = 79
D3DRENDERSTATE_STIPPLEPATTERN16   = 80
D3DRENDERSTATE_STIPPLEPATTERN17   = 81
D3DRENDERSTATE_STIPPLEPATTERN18   = 82
D3DRENDERSTATE_STIPPLEPATTERN19   = 83
D3DRENDERSTATE_STIPPLEPATTERN20   = 84
D3DRENDERSTATE_STIPPLEPATTERN21   = 85
D3DRENDERSTATE_STIPPLEPATTERN22   = 86
D3DRENDERSTATE_STIPPLEPATTERN23   = 87
D3DRENDERSTATE_STIPPLEPATTERN24   = 88
D3DRENDERSTATE_STIPPLEPATTERN25   = 89
D3DRENDERSTATE_STIPPLEPATTERN26   = 90
D3DRENDERSTATE_STIPPLEPATTERN27   = 91
D3DRENDERSTATE_STIPPLEPATTERN28   = 92
D3DRENDERSTATE_STIPPLEPATTERN29   = 93
D3DRENDERSTATE_STIPPLEPATTERN30   = 94
D3DRENDERSTATE_STIPPLEPATTERN31   = 95
D3DRENDERSTATE_WRAP0              = 128
D3DRENDERSTATE_WRAP1              = 129
D3DRENDERSTATE_WRAP2              = 130
D3DRENDERSTATE_WRAP3              = 131
D3DRENDERSTATE_WRAP4              = 132
D3DRENDERSTATE_WRAP5              = 133
D3DRENDERSTATE_WRAP6              = 134
D3DRENDERSTATE_WRAP7              = 135
D3DRENDERSTATE_FORCE_DWORD        = 07fffffffh


; For back-compatibility with legacy compilations
D3DRENDERSTATE_BLENDENABLE = D3DRENDERSTATE_ALPHABLENDENABLE

; Bias to apply to the texture coordinate set to apply a wrap to.
D3DRENDERSTATE_WRAPBIAS = 128

; Flags to construct the WRAP render states
D3DWRAP_U   = 00000001h
D3DWRAP_V   = 00000002h


D3DSTATE STRUCT
    union
d3dstate_dtstTransformStateType  D3DTRANSFORMSTATETYPE ? ;
d3dstate_dlstLightStateType      D3DLIGHTSTATETYPE     ? ;
d3dstate_drstRenderStateType     D3DRENDERSTATETYPE    ? ;
    ends
    union
d3dstate_dwArg           DD ? ;
d3dstate_dvArg           D3DVALUE ? ;
    ends
D3DSTATE ENDS


D3DMATRIXLOAD STRUCT
d3dmatrixload_hDestMatrix     D3DMATRIXHANDLE ? ; Destination matrix
d3dmatrixload_hSrcMatrix      D3DMATRIXHANDLE ? ; Source matrix
D3DMATRIXLOAD ENDS


D3DMATRIXMULTIPLY STRUCT
d3dmatrixmultiply_hDestMatrix     D3DMATRIXHANDLE ? ; Destination matrix
d3dmatrixmultiply_hSrcMatrix1     D3DMATRIXHANDLE ? ; First source matrix
d3dmatrixmultiply_hSrcMatrix2     D3DMATRIXHANDLE ? ; Second source matrix
D3DMATRIXMULTIPLY ENDS


D3DPROCESSVERTICES STRUCT
d3dprocessvertices_dwFlags         DD ? ; Do we transform or light or just copy?
d3dprocessvertices_wStart          DW ? ; Index to first vertex in source
d3dprocessvertices_wDest           DW ? ; Index to first vertex in local buffer
d3dprocessvertices_dwCount         DD ? ; Number of vertices to be processed
d3dprocessvertices_dwReserved      DD ? ; Must be zero
D3DPROCESSVERTICES ENDS

D3DPROCESSVERTICES_TRANSFORMLIGHT      = 000000000h
D3DPROCESSVERTICES_TRANSFORM           = 000000001h
D3DPROCESSVERTICES_COPY                = 000000002h
D3DPROCESSVERTICES_OPMASK              = 000000007h
D3DPROCESSVERTICES_UPDATEEXTENTS       = 000000008h
D3DPROCESSVERTICES_NOCOLOR             = 000000010h



D3DTEXTURESTAGESTATETYPE enum D3DTSS_COLOROP = 1,  \
    D3DTSS_COLORARG1      = 2,      D3DTSS_COLORARG2      = 3,  \
    D3DTSS_ALPHAOP        = 4,      D3DTSS_ALPHAARG1      = 5,  \
    D3DTSS_ALPHAARG2      = 6,      D3DTSS_BUMPENVMAT00   = 7,  \
    D3DTSS_BUMPENVMAT01   = 8,      D3DTSS_BUMPENVMAT10   = 9,  \
    D3DTSS_BUMPENVMAT11   = 10,     D3DTSS_TEXCOORDINDEX  = 11, \
    D3DTSS_ADDRESS        = 12,     D3DTSS_ADDRESSU       = 13, \
    D3DTSS_ADDRESSV       = 14,     D3DTSS_BORDERCOLOR    = 15, \
    D3DTSS_MAGFILTER      = 16,     D3DTSS_MINFILTER      = 17, \
    D3DTSS_MIPFILTER      = 18,     D3DTSS_MIPMAPLODBIAS  = 19, \
    D3DTSS_MAXMIPLEVEL    = 20,     D3DTSS_MAXANISOTROPY  = 21, \
    D3DTSS_BUMPENVLSCALE  = 22,     D3DTSS_BUMPENVLOFFSET = 23, \
    D3DTSS_FORCE_DWORD   = 07fffffffh


D3DTEXTUREOP enum D3DTOP_DISABLE    = 1,  \
    D3DTOP_SELECTARG1 = 2,      D3DTOP_SELECTARG2 = 3,  \
    D3DTOP_MODULATE   = 4,      D3DTOP_MODULATE2X = 5,  \
    D3DTOP_MODULATE4X = 6,      D3DTOP_ADD        = 7,  \
    D3DTOP_ADDSIGNED  = 8,      D3DTOP_ADDSIGNED2X  =  9,  \
    D3DTOP_SUBTRACT     = 10,   D3DTOP_ADDSMOOTH    = 11,  \
    D3DTOP_BLENDDIFFUSEALPHA    = 12,      D3DTOP_BLENDTEXTUREALPHA    = 13,  \
    D3DTOP_BLENDFACTORALPHA     = 14,      D3DTOP_BLENDTEXTUREALPHAPM  = 15,  \
    D3DTOP_BLENDCURRENTALPHA    = 16,      D3DTOP_PREMODULATE          = 17,  \
    D3DTOP_MODULATEALPHA_ADDCOLOR = 18,  D3DTOP_MODULATECOLOR_ADDALPHA = 19,  \
    D3DTOP_MODULATEINVALPHA_ADDCOLOR = 20, D3DTOP_MODULATEINVCOLOR_ADDALPHA = 21,  \
    D3DTOP_BUMPENVMAP           = 22,    D3DTOP_BUMPENVMAPLUMINANCE    = 23,  \
    D3DTOP_DOTPRODUCT3          = 24,    D3DTOP_FORCE_DWORD = 07fffffffh


D3DTA_SELECTMASK        = 0000000fh ; mask for arg selector
D3DTA_DIFFUSE           = 00000000h ; select diffuse color
D3DTA_CURRENT           = 00000001h ; select result of previous stage
D3DTA_TEXTURE           = 00000002h ; select texture color
D3DTA_TFACTOR           = 00000003h ; select RENDERSTATE_TEXTUREFACTOR
D3DTA_COMPLEMENT        = 00000010h ; take 1.0 - x
D3DTA_ALPHAREPLICATE    = 00000020h ; replicate alpha to color components


D3DTEXTUREMAGFILTER enum D3DTFG_POINT = 1, D3DTFG_LINEAR = 2, \
    D3DTFG_FLATCUBIC    = 3, D3DTFG_GAUSSIANCUBIC = 4, \
    D3DTFG_ANISOTROPIC  = 5, D3DTFG_FORCE_DWORD = 07fffffffh

D3DTEXTUREMINFILTER enum D3DTFN_POINT = 1, D3DTFN_LINEAR = 2, \
    D3DTFN_ANISOTROPIC  = 3, D3DTFN_FORCE_DWORD = 07fffffffh

D3DTEXTUREMIPFILTER enum D3DTFP_NONE = 1, D3DTFP_POINT        = 2, \
    D3DTFP_LINEAR = 3, D3DTFP_FORCE_DWORD = 07fffffffh


D3DTRIFLAG_START                       = 000000000h
D3DTRIFLAG_ODD                         = 00000001eh
D3DTRIFLAG_EVEN                        = 00000001fh

D3DTRIFLAG_EDGEENABLE1                 = 000000100h ; v0-v1 edge
D3DTRIFLAG_EDGEENABLE2                 = 000000200h ; v1-v2 edge
D3DTRIFLAG_EDGEENABLE3                 = 000000400h ; v2-v0 edge
D3DTRIFLAG_EDGEENABLETRIANGLE = D3DTRIFLAG_EDGEENABLE1 + D3DTRIFLAG_EDGEENABLE2 + D3DTRIFLAG_EDGEENABLE3
        

D3DTRIANGLE STRUCT
    union
d3dtriangle_v1      DW ? ; Vertex indices
d3dtriangle_wV1     DW ? ;
    ends
    union
d3dtriangle_v2      DW ? ;
d3dtriangle_wV2     DW ? ;
    ends
    union
d3dtriangle_v3      DW ? ;
d3dtriangle_wV3     DW ? ;
    ends
d3dtriangle_wFlags      DW ? ; Edge (and other) flags
D3DTRIANGLE ENDS


D3DLINE STRUCT
    union
d3dline_v1      DW ? ; Vertex indices
d3dline_wV1     DW ? ;
    ends
    union
d3dline_v2      DW ? ;
d3dline_wV2     DW ? ;
    ends
D3DLINE ENDS


D3DSPAN STRUCT
d3dspan_wCount      DW ? ; Number of spans
d3dspan_wFirst      DW ? ; Index to first vertex
D3DSPAN ENDS

D3DPOINT STRUCT
d3dpoint_wCount      DW ? ; number of points
d3dpoint_wFirst      DW ? ; index to first vertex
D3DPOINT ENDS

D3DBRANCH STRUCT
d3dbranch_dwMask      DD ? ; Bitmask against D3D status
d3dbranch_dwValue     DD ? ;
d3dbranch_bNegate     DD ? ; TRUE to negate comparison
d3dbranch_dwOffset    DD ? ; How far to branch forward (0 for exit)
D3DBRANCH ENDS

D3DSTATUS STRUCT
d3dstatus_dwFlags     DD ? ; Do we set extents or status
d3dstatus_dwStatus    DD ? ; D3D status
d3dstatus_drExtent    D3DRECT ? ;
D3DSTATUS ENDS

D3DSETSTATUS_STATUS     = 000000001h
D3DSETSTATUS_EXTENTS    = 000000002h
D3DSETSTATUS_ALL        = D3DSETSTATUS_STATUS + D3DSETSTATUS_EXTENTS

D3DCLIPSTATUS struct
d3dclipstatus_dwFlags         DD ? ; Do we set 2d extents, 3D extents or status
d3dclipstatus_dwStatus        DD ? ; Clip status
d3dclipstatus_minx            DD ?
d3dclipstatus_maxx            DD ? ; X extents
d3dclipstatus_miny            DD ?
d3dclipstatus_maxy            DD ? ; Y extents
d3dclipstatus_minz            DD ?
d3dclipstatus_maxz            DD ? ; Z extents
D3DCLIPSTATUS ends

D3DCLIPSTATUS_STATUS        = 00000001h;
D3DCLIPSTATUS_EXTENTS2      = 00000002h;
D3DCLIPSTATUS_EXTENTS3      = 00000004h;


D3DSTATS STRUCT
d3dstats_dwSize              DD ? ;
d3dstats_dwTrianglesDrawn    DD ? ;
d3dstats_dwLinesDrawn        DD ? ;
d3dstats_dwPointsDrawn       DD ? ;
d3dstats_dwSpansDrawn        DD ? ;
d3dstats_dwVerticesProcessed DD ? ;
D3DSTATS ENDS


D3DEXECUTE_CLIPPED      = 000000001h
D3DEXECUTE_UNCLIPPED    = 000000002h

D3DEXECUTEDATA STRUCT
d3dexecutedata_dwSize              DD ? ;
d3dexecutedata_dwVertexOffset      DD ? ;
d3dexecutedata_dwVertexCount       DD ? ;
d3dexecutedata_dwInstructionOffset DD ? ;
d3dexecutedata_dwInstructionLength DD ? ;
d3dexecutedata_dwHVertexOffset     DD ? ;
d3dexecutedata_dsStatus            D3DSTATUS ? ; Status after execute
D3DEXECUTEDATA ENDS


D3DPAL_FREE     = 000h ; Renderer may use this entry freely
D3DPAL_READONLY = 040h ; Renderer may not set this entry
D3DPAL_RESERVED = 080h ; Renderer may not use this entry


D3DVERTEXBUFFERDESC struct
d3dvertexbufferdesc_dwSize          DD ? ;
d3dvertexbufferdesc_dwCaps          DD ? ;
d3dvertexbufferdesc_dwFVF           DD ? ;
d3dvertexbufferdesc_dwNumVertices   DD ? ;
D3DVERTEXBUFFERDESC ends

D3DVBCAPS_SYSTEMMEMORY      = 000000800h;
D3DVBCAPS_WRITEONLY         = 000010000h;
D3DVBCAPS_OPTIMIZED         = 080000000h;

 D3DVOP_LIGHT      = (1 shl 10);
 D3DVOP_TRANSFORM  = (1 shl 0);
 D3DVOP_CLIP       = (1 shl 2);
 D3DVOP_EXTENTS    = (1 shl 3);


D3DFVF_RESERVED0        = 0001h;
D3DFVF_POSITION_MASK    = 000Eh;
D3DFVF_XYZ              = 0002h;
D3DFVF_XYZRHW           = 0004h;
D3DFVF_NORMAL           = 0010h;
D3DFVF_RESERVED1        = 0020h;
D3DFVF_DIFFUSE          = 0040h;
D3DFVF_SPECULAR         = 0080h;
D3DFVF_TEXCOUNT_MASK    = 0f00h;
D3DFVF_TEXCOUNT_SHIFT   = 0008h;
D3DFVF_TEX0             = 0000h;
D3DFVF_TEX1             = 0100h;
D3DFVF_TEX2             = 0200h;
D3DFVF_TEX3             = 0300h;
D3DFVF_TEX4             = 0400h;
D3DFVF_TEX5             = 0500h;
D3DFVF_TEX6             = 0600h;
D3DFVF_TEX7             = 0700h;
D3DFVF_TEX8             = 0800h;
D3DFVF_RESERVED2        = 0f00h;  // 4 reserved bits
D3DFVF_VERTEX = ( D3DFVF_XYZ or D3DFVF_NORMAL or D3DFVF_TEX1 )
D3DFVF_LVERTEX = ( D3DFVF_XYZ or D3DFVF_RESERVED1 or D3DFVF_DIFFUSE or \
                         D3DFVF_SPECULAR or D3DFVF_TEX1 )
D3DFVF_TLVERTEX = ( D3DFVF_XYZRHW or D3DFVF_DIFFUSE or D3DFVF_SPECULAR or \
                          D3DFVF_TEX1 )


D3DDP_PTRSTRIDE struct
d3ddp_ptrstride_lpvData         DD ?
d3ddp_ptrstride_dwStride        DD ?
D3DDP_PTRSTRIDE ends

D3DDP_MAXTEXCOORD = 8;

D3DDRAWPRIMITIVESTRIDEDDATA struct
d3ddrawprimitivestrideddata_position        D3DDP_PTRSTRIDE ? ;
d3ddrawprimitivestrideddata_normal          D3DDP_PTRSTRIDE ? ;
d3ddrawprimitivestrideddata_diffuse         D3DDP_PTRSTRIDE ? ;
d3ddrawprimitivestrideddata_specular        D3DDP_PTRSTRIDE ? ;
d3ddrawprimitivestrideddata_textureCoords   D3DDP_PTRSTRIDE D3DDP_MAXTEXCOORD DUP (?)
D3DDRAWPRIMITIVESTRIDEDDATA ends


D3DVIS_INSIDE_FRUSTUM      = 0;
D3DVIS_INTERSECT_FRUSTUM   = 1;
D3DVIS_OUTSIDE_FRUSTUM     = 2;
D3DVIS_INSIDE_LEFT         = 0;
D3DVIS_INTERSECT_LEFT      = (1 shl 2);
D3DVIS_OUTSIDE_LEFT        = (2 shl 2);
D3DVIS_INSIDE_RIGHT        = 0;
D3DVIS_INTERSECT_RIGHT     = (1 shl 4);
D3DVIS_OUTSIDE_RIGHT       = (2 shl 4);
D3DVIS_INSIDE_TOP          = 0;
D3DVIS_INTERSECT_TOP       = (1 shl 6);
D3DVIS_OUTSIDE_TOP         = (2 shl 6);
D3DVIS_INSIDE_BOTTOM       = 0;
D3DVIS_INTERSECT_BOTTOM    = (1 shl 8);
D3DVIS_OUTSIDE_BOTTOM      = (2 shl 8);
D3DVIS_INSIDE_NEAR         = 0;
D3DVIS_INTERSECT_NEAR      = (1 shl 10);
D3DVIS_OUTSIDE_NEAR        = (2 shl 10);
D3DVIS_INSIDE_FAR          = 0;
D3DVIS_INTERSECT_FAR       = (1 shl 12);
D3DVIS_OUTSIDE_FAR         = (2 shl 12);
D3DVIS_MASK_FRUSTUM        = (3 shl 0);
D3DVIS_MASK_LEFT           = (3 shl 2);
D3DVIS_MASK_RIGHT          = (3 shl 4);
D3DVIS_MASK_TOP            = (3 shl 6);
D3DVIS_MASK_BOTTOM         = (3 shl 8);
D3DVIS_MASK_NEAR           = (3 shl 10);
D3DVIS_MASK_FAR            = (3 shl 12);


;end of file
