; FMan

;--------------------------------------------------------------------------------------------------

.486p
.model flat, stdcall

include fman.inc

WinMain PROTO
InitApplicationWindow proto
InitializeViewBar proto :DWORD
RegisterServiceProcess proto :DWORD, :DWORD

;------------------------------------------------------------------------------------------------------------
.data?                                          ; uninitialized data
align DWORD  
	hWndApp				dd			?			; main application window
	hWndStatusBar		dd			?			; status bar window
	hWndViewBar			dd			?

	pShellMalloc		LPMALLOC 	?
	g_hInstance			dd			?       
	wMsg				MSG			<?>
	szCurPath			db 			MAX_PATH dup (?)   
	iSeparatorPos		dd			? 
	icc        			INITCOMMONCONTROLSEX	<?>
	rect				RECT		<?>			; rectangle
	
;------------------------------------------------------------------------------------------------------------
.const                                          ; constant data segment
align DWORD   
	szWndTitle			db		"File Manager",0	
	szAppWndClassName	db		"FileManagerClass",0	
	
	szAllFolders		db		"All Folders",0
	szAllFiles			db		"All Files",0
	szEdit				db		"EDIT",0
	
	szStatusText		db		"FileManager .002",0
	szAboutText			db		"ASM File Manager Version 0.002",0Ah,0Ah
						db		"July 23, 1999",0Ah
						db		"lord-lucifer@usa.net",0

						
;------------------------------------------------------------------------------------------------------------
.code
; Entry Point
start:                                          
    invoke  GetModuleHandle, 0h            
    mov     g_hInstance,eax
           
	mov		icc.dwSize, sizeof INITCOMMONCONTROLSEX
	mov		icc.dwICC, ICC_BAR_CLASSES or ICC_COOL_CLASSES or ICC_LISTVIEW_CLASSES or ICC_TREEVIEW_CLASSES 
	invoke	InitCommonControlsEx, addr icc
		
	; initialize the Component Object Model(COM) library
	invoke	CoInitialize, 0
	test	eax,eax				; any HRESULT with the MSB (the sign bit) = 1, is an error
	js		exit				; js = jump if signed

	; Get global IMalloc object
	invoke	SHGetMalloc, addr pShellMalloc
	cmp		eax, E_FAIL
	jz		shutdown
		
		
	; Winmain
    invoke	WinMain    
    
    ; Release IMalloc Object
    mov		eax, pShellMalloc
    mov		eax, [eax]
    invoke	(IMalloc PTR [eax]).Release, pShellMalloc
    
shutdown:    
    ; close the COM library
    invoke	CoUninitialize 
         
exit:
    invoke	ExitProcess, eax
    ; Program Terminates Here


;------------------------------------------------------------------------------------------------------------
WinMain proc

	invoke	InitApplicationWindow
	test	eax,eax
	jz		quit
	
; Message Dispatch Loop        
MessageLoop:                                  	
	invoke	GetMessage,	addr wMsg, NULL, 0h, 0h						           
    test    eax,eax				; if false (WM_QUIT), exit loop		  
    jz      quit
                   
    invoke  TranslateMessage, addr wMsg					
    invoke  DispatchMessage, addr wMsg
    jmp     MessageLoop

; Exit WinMain
quit:
    mov     eax, wMsg.wParam 
    ret
WinMain endp
       
       
;--------------------------------------------------------------------------------------------------
align DWORD
AppWndProc proc hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	mov		eax,uMsg
	cmp		eax,WM_SIZE
	je		wm_size
	cmp		eax,WM_COMMAND
	je		wm_command
	cmp		eax,WM_NOTIFY
	je		wm_notify
	cmp		eax,WM_CREATE
	je		wm_create
	cmp		eax,WM_DESTROY
	je		wm_destroy
	
	invoke 	DefWindowProc, hWnd, uMsg, wParam, lParam
	jmp		return


;--------------------------------------------------------------------------------------------------
; WM_COMMAND
; wParam: HIWORD = notification code   LOWORD = item, control, or accelerator identifier
; lParam: handle of control 
; return: 0
wm_command:
	mov		eax, wParam
	and		eax, 0000FFFFh
	.IF		eax == IDM_QUIT
			invoke	PostQuitMessage, 0
	.ELSEIF	eax == IDM_ABOUT
			invoke	MessageBox, hWnd, addr szAboutText, addr szWndTitle, MB_OK or MB_ICONQUESTION
	.ENDIF	
	jmp		return0
	
	
;--------------------------------------------------------------------------------------------------
; WM_SIZE
; wParam: resizing flag 
; lParam: LOWORD=width  HIWORD=height
; return: 0
wm_size:	
	; resize status bar
	invoke	SendMessage, hWndStatusBar, WM_SIZE, 0, 0
	
	; get client coordinates
	invoke	GetClientRect, hWndStatusBar, addr rect
	mov		ebx, rect.bottom
	mov		edx, lParam
	shr		edx, 16
	sub		edx, ebx
	
	mov		ecx, lParam
	and		ecx, 0000FFFFh
	
	; resize the viewbar
	invoke	MoveWindow, hWndViewBar, 0, 0, ecx, edx, TRUE
	
	jmp		return0
	
;--------------------------------------------------------------------------------------------------
; WM_NOTIFY
; wParam: 
; lParam:
; return: 0
wm_notify:
	mov		eax, wParam
	cmp		eax, ID_TREEVIEW
	jne		@F
	invoke	TreeViewNotify, hWnd, lParam
	jmp		return0
	
@@:
	cmp		eax, ID_LISTVIEW
	jne		@F
	invoke	ListViewNotify, hWnd, lParam
	jmp		return0

@@:
	jmp		return0

;--------------------------------------------------------------------------------------------------
; WM_CREATE
; wParam: ?
; lParam: LPCREATESTRUCT - structure with creation data 
; retrun: 0 to continue creation, -1 to destroy window
wm_create:

	; create the status bar window
	invoke	CreateStatusWindow,
			WS_CHILD or WS_VISIBLE or SBARS_SIZEGRIP,
			addr szStatusText,
			hWnd,
			ID_STATUSVIEW
	test	eax,eax
	jz		@F
	mov		hWndStatusBar, eax	

	; create the viewbar
	invoke	InitializeViewBar, hWnd
	test	eax, eax
	jz		@F
	
	; created ok, so return 0
	jmp		return0
	
	; viewbar initialization falied
	@@:
	dec		eax	;set eax tp -1
	jmp		return	
	
;--------------------------------------------------------------------------------------------------
; WM_DESTROY
; wParam: ?
; lParam: ?
; return: 0	
; Close the window, and terminate the application
wm_destroy:		
	invoke 	PostQuitMessage, NULL		
	jmp		return0
	
		
return0:
	xor		eax,eax
return:
	ret		
AppWndProc	endp



;--------------------------------------------------------------------------------------------------
; creates main window, status bar, and client window
; return: TRUE if ok, FALSE if failed
InitApplicationWindow proc 
	LOCAL   wc:WNDCLASSEX

	; init main application window window class
    mov     wc.cbSize, sizeof WNDCLASSEX    
    mov     wc.style, CS_VREDRAW + CS_HREDRAW + CS_DBLCLKS + CS_BYTEALIGNCLIENT + CS_BYTEALIGNWINDOW     				
    mov     wc.lpfnWndProc,offset AppWndProc
    mov     wc.cbClsExtra,0
    mov     wc.cbWndExtra,0	
	mov     eax,g_hInstance
    mov     wc.hInstance,eax
	invoke	LoadIcon, eax, IDI_ICON1
    mov     wc.hIcon,eax 
    mov     wc.hIconSm,eax
	invoke	LoadCursor, 0, IDC_ARROW
    mov     wc.hCursor,eax
    mov     wc.hbrBackground, 0
    mov     wc.lpszMenuName, MENUEX_1
    mov     wc.lpszClassName,offset szAppWndClassName

    invoke	RegisterClassEx, addr wc                                    
	test	eax,eax
	jz		return		
		
	; create the application window
	invoke	CreateWindowEx, 
			WS_EX_ACCEPTFILES + WS_EX_APPWINDOW, 
			addr szAppWndClassName, 
			addr szWndTitle,
			WS_OVERLAPPEDWINDOW or WS_VISIBLE,
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			CW_USEDEFAULT, 
			0,
			0, 
			g_hInstance, 
			0
	test	eax,eax     
	jz		return
    mov		hWndApp, eax	

	; all ok so return true
	mov		eax, 1
return:
	ret
InitApplicationWindow endp



;--------------------------------------------------------------------------------------------------
; return: TRUE if successful, FALSE if error
InitializeViewBar proc hWnd:DWORD
	LOCAL	vbi:VIEWBARITEM
	
	; initialize the viewbar
	invoke	InitViewBar, hWnd, g_hInstance
	test	eax,eax
	jz		return
	mov		hWndViewBar, eax
	
	; add the tree / list pair
	invoke	InitTreeView, hWnd	
	mov		vbi.hWnd, eax
	invoke	InitListView, hWnd
	mov		vbi.hWndAssoc, eax
	mov		vbi.hIcon, 0
	mov		vbi.dwStyle, 0
	lea		eax, vbi.szTitle
	invoke	wsprintf, eax, offset szAllFolders
	invoke	SendMessage, hWndViewBar, VIEWBAR_INSERT, -1, addr vbi
	test	eax,eax
	jz		return
		
	; initialize the tree / list views
	invoke	SendMessage, hWndTree, TVM_SELECTITEM, TVGN_CARET, hitemMyComputer
	invoke	SendMessage, hWndTree, TVM_EXPAND, TVE_EXPAND, hitemMyComputer
		
		
	; add the edit / edit pair
	invoke	CreateWindowEx, 
			WS_EX_ACCEPTFILES or WS_EX_CLIENTEDGE, 
			addr szEdit, 
			addr szEdit,
			WS_CHILD or ES_MULTILINE,
			0, 	0, 
			2,	2,
			hWnd,
			0, 
			g_hInstance, 
			0
	mov		vbi.hWnd, eax
	
	invoke	CreateWindowEx, 
			WS_EX_ACCEPTFILES or WS_EX_CLIENTEDGE, 
			addr szEdit, 
			addr szEdit,
			WS_CHILD or ES_MULTILINE,
			0, 	0, 
			2,	2,
			hWnd,
			0, 
			g_hInstance, 
			0
	mov		vbi.hWndAssoc, eax
	mov		vbi.hIcon, 0
	mov		vbi.dwStyle, 0
	lea		eax, vbi.szTitle
	invoke	wsprintf, eax, offset szEdit
	invoke	SendMessage, hWndViewBar, VIEWBAR_INSERT, -1, addr vbi
	test	eax,eax
	
	invoke	SendMessage, hWndViewBar, VIEWBAR_SETACTIVE, 0, 0
	test	eax, eax
	jz		return
	
	; all ok so return true
	mov		eax, 1
return:
	ret
InitializeViewBar endp




end start
