; List.asm
; Handles the Files list view
.486p
.model flat, stdcall
                      
include fman.inc

ListViewSort proto :DWORD, :DWORD, :DWORD
ShellExecuteEx proto :DWORD
COL_NAME	equ 0
COL_SIZE	equ 1
COL_TYPE	equ	2
COL_TIME	equ 3
COL_ATTR	equ 4

;------------------------------------------------------------------------------------------------------------
.data?                                          	; uninitialized data
align DWORD 
	hWndList			dd		?					; Window handle for the List View
	hListImageList		dd		?
	
;------------------------------------------------------------------------------------------------------------
.const                                          	; constant data segment
align DWORD   
	szListViewName		db		"SysListView32",0    
	szRootPath			db		"C:\",0
	szAllFiles			db		"*.*",0 
	szOpen				db		"Open",0
	szNull				db		0
	szColName			db		"Name",0
	szColSize			db		"Size",0
	szColType			db		"Type",0
	szSizeFormatByte	db		"%d B",0
	szSizeFormatKB		db		"%d K",0
	szSizeFormatMB		db		"%d M",0

;------------------------------------------------------------------------------------------------------------
.code

InitListView proc hWndParent:DWORD
	LOCAL	rectClient:RECT
   	LOCAL	sfi:SHFILEINFO
	LOCAL	lvcol:LV_COLUMN
		                  
	; get parent window size
	invoke	GetClientRect, hWndParent, addr rectClient      
	mov		eax, rectClient.right
	shr		eax,1  
	inc		eax
		
	; create the window 		
	invoke	CreateWindowEx, 
			WS_EX_CLIENTEDGE,
			addr szListViewName, 
			0,
			WS_CHILD or WS_VISIBLE or LVS_REPORT or LVS_EDITLABELS or LVS_SHAREIMAGELISTS,; or LVS_EX_HEADERDRAGDROP or LVS_EX_FULLROWSELECT,
			eax, 0,
			rectClient.right, rectClient.bottom, 
			hWndParent,
			ID_LISTVIEW, 
			g_hInstance, 
			NULL
	test	eax,eax     
	jz	ret_error
	mov	hWndList, eax 
	
;	invoke	SendMessage, LVM_FIRST + 54, hWndList, 
;			LVS_EX_HEADERDRAGDROP or LVS_EX_FULLROWSELECT,
;			LVS_EX_HEADERDRAGDROP or LVS_EX_FULLROWSELECT
			
	; Initialize the columns
	mov		lvcol.imask, LVCF_FMT or LVCF_SUBITEM or LVCF_TEXT or LVCF_WIDTH
	
	mov		lvcol.fmt, LVCFMT_LEFT
	mov		lvcol.lx, 200
	mov		lvcol.pszText, offset szColName
	mov		lvcol.iSubItem, COL_NAME	
	invoke	SendMessage, hWndList, LVM_INSERTCOLUMN, COL_NAME, addr lvcol
	
	mov		lvcol.fmt, LVCFMT_RIGHT
	mov		lvcol.lx, 80
	mov		lvcol.pszText, offset szColSize
	mov		lvcol.iSubItem, COL_SIZE
	invoke	SendMessage, hWndList, LVM_INSERTCOLUMN, COL_SIZE, addr lvcol
	
	mov		lvcol.fmt, LVCFMT_LEFT
	mov		lvcol.lx, 120
	mov		lvcol.pszText, offset szColType
	mov		lvcol.iSubItem, COL_TYPE
	invoke	SendMessage, hWndList, LVM_INSERTCOLUMN, COL_TYPE, addr lvcol	
		
                            
	; Get the shell image list for the list view
	invoke	SHGetFileInfo, addr szRootPath, 0, addr sfi, sizeof SHFILEINFO, SHGFI_SYSICONINDEX or SHGFI_SMALLICON
	test	eax,eax
	jz		ret_error
	mov		hListImageList, eax	
	invoke	SendMessage, hWndList, LVM_SETIMAGELIST , LVSIL_SMALL, eax
      
ret_ok:                     
	mov	eax,hWndList
	ret
ret_error:
	xor	eax,eax
	ret
InitListView	endp    



   
;--------------------------------------------------------------------------------------------------
UpdateListView proc uses edx hWnd:DWORD, ptvobj:LPTV_OBJDATA, pshfParent:LPSHELLFOLDER
	LOCAL	lvi:LV_ITEM
	LOCAL	peidl:LPENUMIDLIST
	LOCAL	pidl:LPITEMIDLIST
	LOCAL	pidlFull:LPITEMIDLIST
	LOCAL	plvobj:LPLV_OBJDATA
	LOCAL	dwAttr:DWORD
	LOCAL	strret:STRRET
	LOCAL	shfi:SHFILEINFO
	LOCAL	nPos:DWORD
	LOCAL	hFile:DWORD
	LOCAL	szBuf[80]:BYTE
	LOCAL	szPath[256]:BYTE
	LOCAL	dwHighDWORD:DWORD

	; remove all the items
	invoke	SendMessage, hWnd, LVM_DELETEALLITEMS, 0, 0

	; get the id lists from the parent folder
    mov		edx, pshfParent
    mov		edx, [edx]
    invoke	(IShellFolder ptr [edx]).EnumObjects, pshfParent, hWnd, SHCONTF_FOLDERS or SHCONTF_NONFOLDERS, addr peidl
	test	eax,eax
	js		ret_error
	
	; counter
	mov		nPos,0
	
	; display hourglass cursor
	invoke	LoadCursor, NULL, IDC_WAIT
	invoke	SetCursor, eax
	
ObjectLoop:
	mov		edx, peidl
	mov		edx,[edx]
	invoke	(IEnumIDList PTR [edx]).Next, peidl, 1, addr pidl, NULL
	test	eax,eax
	js		ret_error
	cmp		eax,S_FALSE	;no more items
	jz		End_ObjectLoop
	
    mov		eax, pShellMalloc
    mov		eax, [eax]
    invoke	(IMalloc ptr [eax]).Alloc, pShellMalloc, sizeof LV_OBJDATA
	.IF		eax != 0
			mov		plvobj, eax
			
			; Get the name
			mov		edx, pshfParent
			mov		edx,[edx]
			invoke	(IShellFolder PTR [edx]).GetDisplayNameOf, pshfParent, pidl, SHGDN_NORMAL, addr strret
			test	eax,eax
			js		ret_error
			.IF		strret.uType == STRRET_CSTR
					lea		eax, strret.cStr
			.ELSEIF	strret.uType == STRRET_OFFSET
					mov		eax, pidl
					add		eax, strret.uOffset
			.ELSEIF	strret.uType == STRRET_WSTR	
					;int 3
			.ENDIF
			mov		lvi.pszText, eax
			
			; Get the attributes
			mov		edx, pshfParent
			mov		edx, [edx]
			invoke	(IShellFolder ptr [edx]).GetAttributesOf, pshfParent, 1, addr pidl, addr dwAttr
			test	eax,eax
			js		ret_error			
			mov		edx,plvobj
			mov		eax, dwAttr
						
			; Get full pidl						
			mov		eax, ptvobj						
			invoke	IDList_Combine, (TV_OBJDATA ptr [eax]).pidlFull, pidl
			test	eax,eax
			jz		ret_error
			mov		pidlFull, eax
			
			; fill in LVI_ITEM structure
			mov		eax, nPos
			mov		lvi.iItem, eax
			mov		lvi.iSubItem, 0
			mov		lvi.cchTextMax, 255
			invoke	GetIcon, pidlFull, 0
			mov		lvi.iImage, eax		
			mov		lvi.imask, LVIF_TEXT or LVIF_IMAGE or LVIF_PARAM
	
			
			; save LV_OBJDATA struct
			mov		edx, plvobj
			invoke	IDList_CopyItem, pidl
			mov		(LV_OBJDATA PTR [edx]).pidlRel, eax		
			mov		eax, pshfParent				
			mov		(LV_OBJDATA ptr [edx]).pshfParent, eax 
			mov		eax, pidlFull
			mov		(LV_OBJDATA ptr [edx]).pidlFull, eax 	
			mov		eax, dwAttr
			mov		(LV_OBJDATA ptr [edx]).dwAttr, eax
			mov		lvi.lParam, edx
				
			; add refernece to parent folder
			mov		eax, (LV_OBJDATA ptr [edx]).pshfParent
			mov		eax, [eax]
			invoke	(IShellFolder ptr [eax]).AddRef, (LV_OBJDATA ptr [edx]).pshfParent

			; add item to the list
			invoke 	SendMessage, hWndList, LVM_INSERTITEM, 0, addr lvi  ;;; USE LVM_SETITEM
			cmp		eax, -1
			jz		ret_error    
			
			; Get File info
			invoke	SHGetFileInfo,
					pidlFull,
					0,
					addr shfi,
					sizeof SHFILEINFO,
					SHGFI_PIDL or SHGFI_ATTRIBUTES or SHGFI_TYPENAME
			test	eax,eax
			jz		ret_error		
			
			invoke	SHGetPathFromIDList, pidlFull, addr szPath
			invoke	CreateFile,
					addr szPath,
					GENERIC_READ,
					FILE_SHARE_READ	or FILE_SHARE_WRITE,
					0,
					OPEN_EXISTING,
					FILE_ATTRIBUTE_NORMAL,
					0	
			mov		hFile, eax
			
			;; File Size
			invoke	GetFileSize, hFile, addr dwHighDWORD			
			cmp		eax, 0
			jl		@Folder	 ; if size = -1, its a folder
					mov		edx, dwHighDWORD
					mov		ecx, 1000							
					
					cmp		eax, 10000	
					jge		@KBFormat
					; size is < 10K, so print out in bytes
					push	eax
					lea		eax, szSizeFormatByte
					jmp		@GotSizeFormat 						
			@KBFormat:
					mov		edx, dwHighDWORD
					idiv	ecx					
					cmp		eax, 10000		
					jge		@MBFormat
					; size is < 10 MB, show as KB
					push	eax
					lea		eax, szSizeFormatKB
					jmp		@GotSizeFormat 		
			@MBFormat:
					mov		edx, dwHighDWORD
					idiv	ecx
					push	eax
					lea		eax, szSizeFormatMB									
			@GotSizeFormat:
					push	eax					
					lea		eax, szBuf
					push	eax
					call	wsprintf
					add		esp, 12			
		
					mov		lvi.imask, LVIF_TEXT		
					mov		lvi.iSubItem, COL_SIZE
					lea		eax, szBuf
					mov		lvi.pszText, eax
					invoke 	SendMessage, hWndList, LVM_SETITEMTEXT, nPos, addr lvi		
					cmp		eax, -1
					jz		ret_error   
					jmp		@EndSize
			@Folder:
					mov		lvi.imask, LVIF_TEXT		
					mov		lvi.iSubItem, COL_SIZE
					lea		eax, szNull
					mov		lvi.pszText, eax
					invoke 	SendMessage, hWndList, LVM_SETITEMTEXT, nPos, addr lvi		
					cmp		eax, -1
					jz		ret_error   
			@EndSize:			
			
			
			;close the file
			invoke	CloseHandle, hFile
			
			mov		lvi.imask, LVIF_TEXT		
			mov		lvi.iSubItem, COL_TYPE
			lea		eax, shfi.szTypeName
			mov		lvi.pszText, eax
			invoke 	SendMessage, hWndList, LVM_SETITEMTEXT, nPos, addr lvi		
			cmp		eax, -1
			jz		ret_error   			
			
			
			
			
			; increment index
			add		nPos, 1		
	.ENDIF
	jmp		ObjectLoop
	
End_ObjectLoop:	

    invoke	SendMessage, hWndList, LVM_SORTITEMS, 0, addr ListViewSort

	; reset to normal cursor
	invoke	LoadCursor, NULL, IDC_ARROW
	invoke	SetCursor, eax
			
ret_ok:
	mov		eax,1
	ret			
ret_error:			
	xor		eax,eax
	ret
UpdateListView endp
    
;--------------------------------------------------------------------------------------------------
ListViewNotify proc uses ebx hWnd:DWORD, pnmlv:DWORD
	LOCAL	point:POINT
	LOCAL	lvhti:LV_HITTESTINFO
	LOCAL	lvi:LV_ITEM
	LOCAL	tvi:TV_ITEM
	LOCAL	plvobj:LPLV_OBJDATA
	LOCAL	sei:SHELLEXECUTEINFO
	LOCAL	szString[256]:BYTE
	LOCAL	szListFolder[256]:BYTE
		
	mov		eax, pnmlv
	mov		eax, (NM_LISTVIEW ptr [eax]).hdr.code
	cmp		eax, NM_RCLICK
	je		clicked
	cmp		eax, NM_DBLCLK
	je		clicked
	jmp		ret_ok
	
clicked:
	invoke	GetCursorPos, addr point
	invoke	ScreenToClient, hWndList, addr point
	mov		eax, point.x
	mov		lvhti.pt.x, eax
	mov		eax, point.y
	mov		lvhti.pt.y, eax

	invoke	SendMessage, hWndList, LVM_HITTEST, 0, addr lvhti
	; Clicked on an item
	.IF		(lvhti.flags & LVHT_ONITEM)
			invoke	ClientToScreen, hWndList, addr point
			mov		lvi.imask, LVIF_PARAM or LVIF_TEXT
			mov		eax, lvhti.iItem
			mov		lvi.iItem, eax
			lea		eax, szListFolder
			mov		lvi.pszText, eax
			mov		lvi.iSubItem,0
			
			invoke	SendMessage, hWndList, LVM_GETITEM, 0, addr lvi
			test	eax,eax
			jz		ret_error
			
			mov		eax, lvi.lParam
			mov		plvobj, eax
			
			mov		ebx, pnmlv
			mov		ebx, (NM_LISTVIEW ptr [ebx]).hdr.code
			.IF		ebx == NM_RCLICK
					; right clicked
					mov		ebx, plvobj
					invoke	ContextMenu, hWnd, (LV_OBJDATA ptr [ebx]).pshfParent, (LV_OBJDATA ptr [ebx]).pidlRel, addr point
			.ELSE
					; double clicked
					mov		ebx, plvobj
					mov		eax, (LV_OBJDATA ptr [ebx]).dwAttr
					;.IF		(eax & SFGAO_FOLDER)
							; its a folder
							;;;
					;.ELSE
							; its a file
							mov		sei.cbSize, sizeof SHELLEXECUTEINFO
							mov		sei.fMask, SEE_MASK_INVOKEIDLIST
							mov		eax, hWnd
							mov		sei.hwnd, eax
							mov		sei.lpVerb, offset szOpen
							mov		sei.lpFile, offset szNull
							mov		sei.lpParameters, offset szNull
							mov		sei.lpDirectory, offset szNull
							mov		sei.nShow, SW_SHOWNORMAL
							mov		sei.hInstApp, 0
							mov		eax, (LV_OBJDATA ptr [ebx]).pidlFull
							mov		sei.lpIDList, eax
							mov		sei.lpClass, 0
							mov		sei.dwHotKey, 0
							mov		sei.hIcon, 0
							mov		sei.hProcess, 0
							
							invoke	ShellExecuteEx, addr sei
					;.ENDIF
			.ENDIF
	; clicked in client area
	.ELSE
						
	
	.ENDIF
		
ret_ok:
	mov		eax,1
	ret
ret_error:
	xor		eax,eax
	ret	
ListViewNotify endp



;--------------------------------------------------------------------------------------------------
ListViewSort proc uses ebx edx ecx esi edi plvobj1:DWORD, plvobj2:DWORD, lParamSort:DWORD
	LOCAL	strret:STRRET

	.if	((plvobj1 != 0) && (plvobj2 != 0))
	
			mov		ebx, plvobj1
			mov		eax, (LV_OBJDATA ptr [ebx]).dwAttr
		
			mov		ebx, plvobj2
			mov		edx, (LV_OBJDATA ptr [ebx]).dwAttr
			
			.IF		(eax & SFGAO_FOLDER) && !(edx & SFGAO_FOLDER)
					xor		eax,eax
					dec		eax
					ret
			.ELSEIF (edx & SFGAO_FOLDER) && !(eax & SFGAO_FOLDER)
					xor		eax,eax
					inc		eax
					ret
			.ENDIF		
			
			mov		edx, plvobj1
			mov		ecx, (LV_OBJDATA ptr [edx]).pshfParent
			mov		ebx, (LV_OBJDATA ptr [edx]).pidlRel
			mov		edx,[ecx]			
			invoke	(IShellFolder PTR [edx]).GetDisplayNameOf, ecx, ebx, SHGDN_NORMAL, addr strret
			.IF		strret.uType == STRRET_CSTR
					lea		eax, strret.cStr
			.ELSEIF	strret.uType == STRRET_OFFSET
					mov		eax, ebx
					add		eax, strret.uOffset
			.ELSEIF	strret.uType == STRRET_WSTR	
					;int 3
			.ENDIF
			mov		esi, eax
			
			mov		edx, plvobj2
			mov		ecx, (LV_OBJDATA ptr [edx]).pshfParent
			mov		ebx, (LV_OBJDATA ptr [edx]).pidlRel
			mov		edx,[ecx]
			invoke	(IShellFolder PTR [edx]).GetDisplayNameOf, ecx, ebx, SHGDN_NORMAL, addr strret
			.IF		strret.uType == STRRET_CSTR
					lea		eax, strret.cStr
			.ELSEIF	strret.uType == STRRET_OFFSET
					mov		eax, ebx
					add		eax, strret.uOffset
			.ELSEIF	strret.uType == STRRET_WSTR	
					;int 3
			.ENDIF
			mov		edi, eax								
			
			
			invoke	lstrcmpi, esi, edi
	.ENDIF	
	ret
ListViewSort endp

END                   
