# TEMPLATE
#
# make -B                 Build normal  version
# make -B -DDEBUG         Build debug version
#----------------------------------------------------------------------------
.silent

NAME  	= 	FMan

OBJS  	= 	fman.obj tree.obj list.obj util.obj splitter.obj viewbar.obj debug.obj
     
INCLUDE	=	d:\programm\masm32\include    
LIB		=	d:\programm\masm32\lib

#----------------------------------------------------------------------------

!if $d(DEBUG)
MASMDEBUG=/DDEBUG /Zi
LINKDEBUG=/DEBUG /DEBUGTYPE:CV
!else
MASMDEBUG=
LINKDEBUG=
!endif                     

#----------------------------------------------------------------------------
all: $(NAME).res $(NAME).exe                             

$(NAME).exe: $(OBJS) $(NAME).res
		echo Linking $(NAME)...
		echo $(OBJS) > CMD.TMP
        Link /NOLOGO /SUBSYSTEM:WINDOWS /MACHINE:IX86 /LIBPATH:$(LIB) $(LINKDEBUG) $(NAME).res @CMD.TMP
        if errorlevel 0 echo Done!
        echo.
        del CMD.TMP > nul

$(NAME).res: $(NAME).rc    
#	h2ash resource.h
#	move resource.ash resource.inc
    brc32 -r -i$(INCLUDE) $(NAME).rc     

fman.obj: fman.asm fman.inc
    ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) fman.asm
tree.obj: tree.asm tree.inc fman.inc                  
    ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) tree.asm     
list.obj: list.asm list.inc fman.inc
	ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) list.asm
util.obj: util.asm util.inc fman.inc
	ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) util.asm
splitter.obj: splitter.asm splitter.inc fman.inc
	ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) splitter.asm
viewbar.obj: viewbar.asm viewbar.inc fman.inc
        ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) viewbar.asm
debug.obj: debug.asm debug.inc fman.inc
	ml /c /Cp /coff /nologo /I$(INCLUDE) $(MASMDEBUG) debug.asm
